/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_witness.h"

#include "librpc/gen_ndr/ndr_misc.h"
_PUBLIC_ enum ndr_err_code ndr_push_witness_version(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum witness_version r)
{
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_witness_version(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum witness_version *r)
{
	uint32_t v;
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_version(struct ndr_print *ndr, const char *name, enum witness_version r)
{
	const char *val = NULL;

	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case WITNESS_V1: val = "WITNESS_V1"; break;
			case WITNESS_V2: val = "WITNESS_V2"; break;
			case WITNESS_UNSPECIFIED_VERSION: val = "WITNESS_UNSPECIFIED_VERSION"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_witness_interfaceInfo_state(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum witness_interfaceInfo_state r)
{
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint16(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_witness_interfaceInfo_state(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum witness_interfaceInfo_state *r)
{
	uint16_t v;
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint16(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_interfaceInfo_state(struct ndr_print *ndr, const char *name, enum witness_interfaceInfo_state r)
{
	const char *val = NULL;

	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case WITNESS_STATE_UNKNOWN: val = "WITNESS_STATE_UNKNOWN"; break;
			case WITNESS_STATE_AVAILABLE: val = "WITNESS_STATE_AVAILABLE"; break;
			case WITNESS_STATE_UNAVAILABLE: val = "WITNESS_STATE_UNAVAILABLE"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_witness_interfaceInfo_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_witness_interfaceInfo_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_interfaceInfo_flags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WITNESS_INFO_IPv4_VALID", WITNESS_INFO_IPv4_VALID, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WITNESS_INFO_IPv6_VALID", WITNESS_INFO_IPv6_VALID, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WITNESS_INFO_WITNESS_IF", WITNESS_INFO_WITNESS_IF, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_witness_interfaceInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct witness_interfaceInfo *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_charset_to_null(ndr, NDR_SCALARS, r->group_name, 260, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_witness_version(ndr, NDR_SCALARS, r->version));
		NDR_CHECK(ndr_push_witness_interfaceInfo_state(ndr, NDR_SCALARS, r->state));
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->ipv4));
			ndr->flags = _flags_save_ipv4address;
		}
		{
			libndr_flags _flags_save_ipv6address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_push_ipv6address(ndr, NDR_SCALARS, r->ipv6));
			ndr->flags = _flags_save_ipv6address;
		}
		NDR_CHECK(ndr_push_witness_interfaceInfo_flags(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_witness_interfaceInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct witness_interfaceInfo *r)
{
	uint32_t size_group_name_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		size_group_name_0 = 260;
		NDR_CHECK(ndr_pull_charset_to_null(ndr, NDR_SCALARS, &r->group_name, size_group_name_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_witness_version(ndr, NDR_SCALARS, &r->version));
		NDR_CHECK(ndr_pull_witness_interfaceInfo_state(ndr, NDR_SCALARS, &r->state));
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->ipv4));
			ndr->flags = _flags_save_ipv4address;
		}
		{
			libndr_flags _flags_save_ipv6address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			NDR_CHECK(ndr_pull_ipv6address(ndr, NDR_SCALARS, &r->ipv6));
			ndr->flags = _flags_save_ipv6address;
		}
		NDR_CHECK(ndr_pull_witness_interfaceInfo_flags(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_interfaceInfo(struct ndr_print *ndr, const char *name, const struct witness_interfaceInfo *r)
{
	ndr_print_struct(ndr, name, "witness_interfaceInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "group_name", r->group_name);
	ndr_print_witness_version(ndr, "version", r->version);
	ndr_print_witness_interfaceInfo_state(ndr, "state", r->state);
	{
		libndr_flags _flags_save_ipv4address = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_ipv4address(ndr, "ipv4", r->ipv4);
		ndr->flags = _flags_save_ipv4address;
	}
	{
		libndr_flags _flags_save_ipv6address = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
		ndr_print_ipv6address(ndr, "ipv6", r->ipv6);
		ndr->flags = _flags_save_ipv6address;
	}
	ndr_print_witness_interfaceInfo_flags(ndr, "flags", r->flags);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_witness_interfaceList(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct witness_interfaceList *r)
{
	uint32_t cntr_interfaces_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_interfaces));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->interfaces));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->interfaces) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_interfaces));
			for (cntr_interfaces_1 = 0; cntr_interfaces_1 < (r->num_interfaces); cntr_interfaces_1++) {
				NDR_CHECK(ndr_push_witness_interfaceInfo(ndr, NDR_SCALARS, &r->interfaces[cntr_interfaces_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_witness_interfaceList(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct witness_interfaceList *r)
{
	uint32_t _ptr_interfaces;
	uint32_t size_interfaces_1 = 0;
	uint32_t cntr_interfaces_1;
	TALLOC_CTX *_mem_save_interfaces_0 = NULL;
	TALLOC_CTX *_mem_save_interfaces_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_interfaces));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_interfaces));
		if (_ptr_interfaces) {
			NDR_PULL_ALLOC(ndr, r->interfaces);
		} else {
			r->interfaces = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->interfaces) {
			_mem_save_interfaces_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->interfaces, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->interfaces));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->interfaces, &size_interfaces_1));
			NDR_PULL_ALLOC_N(ndr, r->interfaces, size_interfaces_1);
			_mem_save_interfaces_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->interfaces, 0);
			for (cntr_interfaces_1 = 0; cntr_interfaces_1 < (size_interfaces_1); cntr_interfaces_1++) {
				NDR_CHECK(ndr_pull_witness_interfaceInfo(ndr, NDR_SCALARS, &r->interfaces[cntr_interfaces_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_interfaces_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_interfaces_0, 0);
		}
		if (r->interfaces) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->interfaces, r->num_interfaces));
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_witness_interfaceList(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct witness_interfaceList *r)
{
	ndr_print_witness_interfaceList(ndr, name, r);
}

_PUBLIC_ void ndr_print_witness_interfaceList(struct ndr_print *ndr, const char *name, const struct witness_interfaceList *r)
{
	uint32_t cntr_interfaces_1;
	ndr_print_struct(ndr, name, "witness_interfaceList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_interfaces", r->num_interfaces);
	ndr_print_ptr(ndr, "interfaces", r->interfaces);
	ndr->depth++;
	if (r->interfaces) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "interfaces", (uint32_t)(r->num_interfaces));
		ndr->depth++;
		for (cntr_interfaces_1 = 0; cntr_interfaces_1 < (r->num_interfaces); cntr_interfaces_1++) {
			ndr_print_witness_interfaceInfo(ndr, "interfaces", &r->interfaces[cntr_interfaces_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_witness_notifyResponse_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum witness_notifyResponse_type r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_witness_notifyResponse_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum witness_notifyResponse_type *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_notifyResponse_type(struct ndr_print *ndr, const char *name, enum witness_notifyResponse_type r)
{
	const char *val = NULL;

	switch (r) {
		case WITNESS_NOTIFY_RESOURCE_CHANGE: val = "WITNESS_NOTIFY_RESOURCE_CHANGE"; break;
		case WITNESS_NOTIFY_CLIENT_MOVE: val = "WITNESS_NOTIFY_CLIENT_MOVE"; break;
		case WITNESS_NOTIFY_SHARE_MOVE: val = "WITNESS_NOTIFY_SHARE_MOVE"; break;
		case WITNESS_NOTIFY_IP_CHANGE: val = "WITNESS_NOTIFY_IP_CHANGE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_witness_ResourceChange_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum witness_ResourceChange_type r)
{
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_witness_ResourceChange_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum witness_ResourceChange_type *r)
{
	uint32_t v;
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_ResourceChange_type(struct ndr_print *ndr, const char *name, enum witness_ResourceChange_type r)
{
	const char *val = NULL;

	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case WITNESS_RESOURCE_STATE_UNKNOWN: val = "WITNESS_RESOURCE_STATE_UNKNOWN"; break;
			case WITNESS_RESOURCE_STATE_AVAILABLE: val = "WITNESS_RESOURCE_STATE_AVAILABLE"; break;
			case WITNESS_RESOURCE_STATE_UNAVAILABLE: val = "WITNESS_RESOURCE_STATE_UNAVAILABLE"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_witness_ResourceChange(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct witness_ResourceChange *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_witness_ResourceChange(r, ndr->flags)));
			NDR_CHECK(ndr_push_witness_ResourceChange_type(ndr, NDR_SCALARS, r->type));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->name));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_witness_ResourceChange(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct witness_ResourceChange *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
			NDR_CHECK(ndr_pull_witness_ResourceChange_type(ndr, NDR_SCALARS, &r->type));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->name));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_witness_ResourceChange(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct witness_ResourceChange *r)
{
	ndr_print_witness_ResourceChange(ndr, name, r);
}

_PUBLIC_ void ndr_print_witness_ResourceChange(struct ndr_print *ndr, const char *name, const struct witness_ResourceChange *r)
{
	ndr_print_struct(ndr, name, "witness_ResourceChange");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		ndr->depth++;
		ndr_print_uint32(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_witness_ResourceChange(r, ndr->flags):r->length);
		ndr_print_witness_ResourceChange_type(ndr, "type", r->type);
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			ndr_print_string(ndr, "name", r->name);
			ndr->flags = _flags_save_string;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ size_t ndr_size_witness_ResourceChange(const struct witness_ResourceChange *r, libndr_flags flags)
{
	flags |= LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN;
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_witness_ResourceChange);
}

static enum ndr_err_code ndr_push_witness_IPaddrInfo_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_witness_IPaddrInfo_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_IPaddrInfo_flags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WITNESS_IPADDR_V4", WITNESS_IPADDR_V4, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WITNESS_IPADDR_V6", WITNESS_IPADDR_V6, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WITNESS_IPADDR_ONLINE", WITNESS_IPADDR_ONLINE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WITNESS_IPADDR_OFFLINE", WITNESS_IPADDR_OFFLINE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_witness_IPaddrInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct witness_IPaddrInfo *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_witness_IPaddrInfo_flags(ndr, NDR_SCALARS, r->flags));
			{
				libndr_flags _flags_save_ipv4address = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				NDR_CHECK(ndr_push_ipv4address(ndr, NDR_SCALARS, r->ipv4));
				ndr->flags = _flags_save_ipv4address;
			}
			{
				libndr_flags _flags_save_ipv6address = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				NDR_CHECK(ndr_push_ipv6address(ndr, NDR_SCALARS, r->ipv6));
				ndr->flags = _flags_save_ipv6address;
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_witness_IPaddrInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct witness_IPaddrInfo *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_witness_IPaddrInfo_flags(ndr, NDR_SCALARS, &r->flags));
			{
				libndr_flags _flags_save_ipv4address = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				NDR_CHECK(ndr_pull_ipv4address(ndr, NDR_SCALARS, &r->ipv4));
				ndr->flags = _flags_save_ipv4address;
			}
			{
				libndr_flags _flags_save_ipv6address = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
				NDR_CHECK(ndr_pull_ipv6address(ndr, NDR_SCALARS, &r->ipv6));
				ndr->flags = _flags_save_ipv6address;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_IPaddrInfo(struct ndr_print *ndr, const char *name, const struct witness_IPaddrInfo *r)
{
	ndr_print_struct(ndr, name, "witness_IPaddrInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		ndr->depth++;
		ndr_print_witness_IPaddrInfo_flags(ndr, "flags", r->flags);
		{
			libndr_flags _flags_save_ipv4address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			ndr_print_ipv4address(ndr, "ipv4", r->ipv4);
			ndr->flags = _flags_save_ipv4address;
		}
		{
			libndr_flags _flags_save_ipv6address = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_BIGENDIAN);
			ndr_print_ipv6address(ndr, "ipv6", r->ipv6);
			ndr->flags = _flags_save_ipv6address;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_witness_IPaddrInfoList(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct witness_IPaddrInfoList *r)
{
	uint32_t cntr_addr_0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, ndr_size_witness_IPaddrInfoList(r, ndr->flags)));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num));
			for (cntr_addr_0 = 0; cntr_addr_0 < (r->num); cntr_addr_0++) {
				NDR_CHECK(ndr_push_witness_IPaddrInfo(ndr, NDR_SCALARS, &r->addr[cntr_addr_0]));
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_witness_IPaddrInfoList(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct witness_IPaddrInfoList *r)
{
	uint32_t size_addr_0 = 0;
	uint32_t cntr_addr_0;
	TALLOC_CTX *_mem_save_addr_0 = NULL;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->length));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num));
			size_addr_0 = r->num;
			NDR_PULL_ALLOC_N(ndr, r->addr, size_addr_0);
			_mem_save_addr_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->addr, 0);
			for (cntr_addr_0 = 0; cntr_addr_0 < (size_addr_0); cntr_addr_0++) {
				NDR_CHECK(ndr_pull_witness_IPaddrInfo(ndr, NDR_SCALARS, &r->addr[cntr_addr_0]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_addr_0, 0);
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_witness_IPaddrInfoList(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct witness_IPaddrInfoList *r)
{
	ndr_print_witness_IPaddrInfoList(ndr, name, r);
}

_PUBLIC_ void ndr_print_witness_IPaddrInfoList(struct ndr_print *ndr, const char *name, const struct witness_IPaddrInfoList *r)
{
	uint32_t cntr_addr_0;
	ndr_print_struct(ndr, name, "witness_IPaddrInfoList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		ndr->depth++;
		ndr_print_uint32(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_witness_IPaddrInfoList(r, ndr->flags):r->length);
		ndr_print_uint32(ndr, "reserved", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved);
		ndr_print_uint32(ndr, "num", r->num);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "addr", (uint32_t)(r->num));
		ndr->depth++;
		for (cntr_addr_0 = 0; cntr_addr_0 < (r->num); cntr_addr_0++) {
			ndr_print_witness_IPaddrInfo(ndr, "addr", &r->addr[cntr_addr_0]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ size_t ndr_size_witness_IPaddrInfoList(const struct witness_IPaddrInfoList *r, libndr_flags flags)
{
	flags |= LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN;
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_witness_IPaddrInfoList);
}

_PUBLIC_ enum ndr_err_code ndr_push_witness_notifyResponse_message(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union witness_notifyResponse_message *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_push_union_align(ndr, 4));
			switch (level) {
				case WITNESS_NOTIFY_RESOURCE_CHANGE: {
					NDR_CHECK(ndr_push_witness_ResourceChange(ndr, NDR_SCALARS, &r->resource_change));
				break; }

				case WITNESS_NOTIFY_CLIENT_MOVE: {
					NDR_CHECK(ndr_push_witness_IPaddrInfoList(ndr, NDR_SCALARS, &r->client_move));
				break; }

				case WITNESS_NOTIFY_SHARE_MOVE: {
					NDR_CHECK(ndr_push_witness_IPaddrInfoList(ndr, NDR_SCALARS, &r->share_move));
				break; }

				case WITNESS_NOTIFY_IP_CHANGE: {
					NDR_CHECK(ndr_push_witness_IPaddrInfoList(ndr, NDR_SCALARS, &r->ip_change));
				break; }

				default: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->data));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_witness_notifyResponse_message(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union witness_notifyResponse_message *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_pull_union_align(ndr, 4));
			switch (level) {
				case WITNESS_NOTIFY_RESOURCE_CHANGE: {
					NDR_CHECK(ndr_pull_witness_ResourceChange(ndr, NDR_SCALARS, &r->resource_change));
				break; }

				case WITNESS_NOTIFY_CLIENT_MOVE: {
					NDR_CHECK(ndr_pull_witness_IPaddrInfoList(ndr, NDR_SCALARS, &r->client_move));
				break; }

				case WITNESS_NOTIFY_SHARE_MOVE: {
					NDR_CHECK(ndr_pull_witness_IPaddrInfoList(ndr, NDR_SCALARS, &r->share_move));
				break; }

				case WITNESS_NOTIFY_IP_CHANGE: {
					NDR_CHECK(ndr_pull_witness_IPaddrInfoList(ndr, NDR_SCALARS, &r->ip_change));
				break; }

				default: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->data));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_notifyResponse_message(struct ndr_print *ndr, const char *name, const union witness_notifyResponse_message *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN|LIBNDR_FLAG_LITTLE_ENDIAN);
		level = ndr_print_steal_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "witness_notifyResponse_message");
		switch (level) {
			case WITNESS_NOTIFY_RESOURCE_CHANGE:
				ndr_print_witness_ResourceChange(ndr, "resource_change", &r->resource_change);
			break;

			case WITNESS_NOTIFY_CLIENT_MOVE:
				ndr_print_witness_IPaddrInfoList(ndr, "client_move", &r->client_move);
			break;

			case WITNESS_NOTIFY_SHARE_MOVE:
				ndr_print_witness_IPaddrInfoList(ndr, "share_move", &r->share_move);
			break;

			case WITNESS_NOTIFY_IP_CHANGE:
				ndr_print_witness_IPaddrInfoList(ndr, "ip_change", &r->ip_change);
			break;

			default:
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					ndr_print_DATA_BLOB(ndr, "data", r->data);
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break;

		}
		ndr->flags = _flags_save_UNION;
	}
}

static void ndr_print_flags_witness_notifyResponse(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct witness_notifyResponse *r)
{
	ndr_print_witness_notifyResponse(ndr, name, r);
}

_PUBLIC_ void ndr_print_witness_notifyResponse(struct ndr_print *ndr, const char *name, const struct witness_notifyResponse *r)
{
	uint32_t cntr_messages_1;
	ndr_print_struct(ndr, name, "witness_notifyResponse");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_witness_notifyResponse_type(ndr, "type", r->type);
		ndr_print_uint32(ndr, "length", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_witness_notifyResponse(r, ndr->flags) - 20:r->length);
		ndr_print_uint32(ndr, "num", r->num);
		{
			libndr_flags _flags_save_witness_notifyResponse_message = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			ndr_print_ptr(ndr, "messages", r->messages);
			ndr->depth++;
			if (r->messages) {
				ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "messages", (uint32_t)(r->num));
				ndr->depth++;
				for (cntr_messages_1 = 0; cntr_messages_1 < (r->num); cntr_messages_1++) {
					ndr_print_set_switch_value(ndr, &r->messages[cntr_messages_1], r->type);
					ndr_print_witness_notifyResponse_message(ndr, "messages", &r->messages[cntr_messages_1]);
				}
				ndr->depth--;
			}
			ndr->depth--;
			ndr->flags = _flags_save_witness_notifyResponse_message;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ size_t ndr_size_witness_notifyResponse(const struct witness_notifyResponse *r, libndr_flags flags)
{
	flags |= LIBNDR_PRINT_ARRAY_HEX;
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_witness_notifyResponse);
}

_PUBLIC_ enum ndr_err_code ndr_push_witness_RegisterEx_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_witness_RegisterEx_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_RegisterEx_flags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WITNESS_REGISTER_NONE", WITNESS_REGISTER_NONE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "WITNESS_REGISTER_IP_NOTIFICATION", WITNESS_REGISTER_IP_NOTIFICATION, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_witness_GetInterfaceList(struct ndr_push *ndr, ndr_flags_type flags, const struct witness_GetInterfaceList *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.interface_list == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.interface_list));
		if (*r->out.interface_list) {
			NDR_CHECK(ndr_push_witness_interfaceList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.interface_list));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_witness_GetInterfaceList(struct ndr_pull *ndr, ndr_flags_type flags, struct witness_GetInterfaceList *r)
{
	uint32_t _ptr_interface_list;
	TALLOC_CTX *_mem_save_interface_list_0 = NULL;
	TALLOC_CTX *_mem_save_interface_list_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.interface_list);
		NDR_ZERO_STRUCTP(r->out.interface_list);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.interface_list);
		}
		_mem_save_interface_list_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.interface_list, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_interface_list));
		if (_ptr_interface_list) {
			NDR_PULL_ALLOC(ndr, *r->out.interface_list);
		} else {
			*r->out.interface_list = NULL;
		}
		if (*r->out.interface_list) {
			_mem_save_interface_list_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.interface_list, 0);
			NDR_CHECK(ndr_pull_witness_interfaceList(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.interface_list));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_interface_list_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_interface_list_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_GetInterfaceList(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct witness_GetInterfaceList *r)
{
	ndr_print_struct(ndr, name, "witness_GetInterfaceList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "witness_GetInterfaceList");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "witness_GetInterfaceList");
		ndr->depth++;
		ndr_print_ptr(ndr, "interface_list", r->out.interface_list);
		ndr->depth++;
		ndr_print_ptr(ndr, "interface_list", *r->out.interface_list);
		ndr->depth++;
		if (*r->out.interface_list) {
			ndr_print_witness_interfaceList(ndr, "interface_list", *r->out.interface_list);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_witness_Register(struct ndr_push *ndr, ndr_flags_type flags, const struct witness_Register *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_witness_version(ndr, NDR_SCALARS, r->in.version));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.net_name));
		if (r->in.net_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.net_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.net_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.net_name, ndr_charset_length(r->in.net_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ip_address));
		if (r->in.ip_address) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ip_address, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ip_address, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.ip_address, ndr_charset_length(r->in.ip_address, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.client_computer_name));
		if (r->in.client_computer_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.client_computer_name, ndr_charset_length(r->in.client_computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.context_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.context_handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_witness_Register(struct ndr_pull *ndr, ndr_flags_type flags, struct witness_Register *r)
{
	uint32_t _ptr_net_name;
	uint32_t size_net_name_1 = 0;
	uint32_t length_net_name_1 = 0;
	uint32_t _ptr_ip_address;
	uint32_t size_ip_address_1 = 0;
	uint32_t length_ip_address_1 = 0;
	uint32_t _ptr_client_computer_name;
	uint32_t size_client_computer_name_1 = 0;
	uint32_t length_client_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_context_handle_0 = NULL;
	TALLOC_CTX *_mem_save_net_name_0 = NULL;
	TALLOC_CTX *_mem_save_ip_address_0 = NULL;
	TALLOC_CTX *_mem_save_client_computer_name_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_witness_version(ndr, NDR_SCALARS, &r->in.version));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_net_name));
		if (_ptr_net_name) {
			NDR_PULL_ALLOC(ndr, r->in.net_name);
		} else {
			r->in.net_name = NULL;
		}
		if (r->in.net_name) {
			_mem_save_net_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.net_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.net_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.net_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.net_name, &size_net_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.net_name, &length_net_name_1));
			if (length_net_name_1 > size_net_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_net_name_1, length_net_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_net_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.net_name, length_net_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_net_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ip_address));
		if (_ptr_ip_address) {
			NDR_PULL_ALLOC(ndr, r->in.ip_address);
		} else {
			r->in.ip_address = NULL;
		}
		if (r->in.ip_address) {
			_mem_save_ip_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ip_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.ip_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.ip_address));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.ip_address, &size_ip_address_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.ip_address, &length_ip_address_1));
			if (length_ip_address_1 > size_ip_address_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ip_address_1, length_ip_address_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_ip_address_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.ip_address, length_ip_address_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ip_address_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client_computer_name));
		if (_ptr_client_computer_name) {
			NDR_PULL_ALLOC(ndr, r->in.client_computer_name);
		} else {
			r->in.client_computer_name = NULL;
		}
		if (r->in.client_computer_name) {
			_mem_save_client_computer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.client_computer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.client_computer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.client_computer_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.client_computer_name, &size_client_computer_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.client_computer_name, &length_client_computer_name_1));
			if (length_client_computer_name_1 > size_client_computer_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_client_computer_name_1, length_client_computer_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_client_computer_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.client_computer_name, length_client_computer_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_computer_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.context_handle);
		NDR_ZERO_STRUCTP(r->out.context_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.context_handle);
		}
		_mem_save_context_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.context_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.context_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_context_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_Register(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct witness_Register *r)
{
	ndr_print_struct(ndr, name, "witness_Register");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "witness_Register");
		ndr->depth++;
		ndr_print_witness_version(ndr, "version", r->in.version);
		ndr_print_ptr(ndr, "net_name", r->in.net_name);
		ndr->depth++;
		if (r->in.net_name) {
			ndr_print_string(ndr, "net_name", r->in.net_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "ip_address", r->in.ip_address);
		ndr->depth++;
		if (r->in.ip_address) {
			ndr_print_string(ndr, "ip_address", r->in.ip_address);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "client_computer_name", r->in.client_computer_name);
		ndr->depth++;
		if (r->in.client_computer_name) {
			ndr_print_string(ndr, "client_computer_name", r->in.client_computer_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "witness_Register");
		ndr->depth++;
		ndr_print_ptr(ndr, "context_handle", r->out.context_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "context_handle", r->out.context_handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_witness_UnRegister(struct ndr_push *ndr, ndr_flags_type flags, const struct witness_UnRegister *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.context_handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_witness_UnRegister(struct ndr_pull *ndr, ndr_flags_type flags, struct witness_UnRegister *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.context_handle));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_UnRegister(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct witness_UnRegister *r)
{
	ndr_print_struct(ndr, name, "witness_UnRegister");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "witness_UnRegister");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "context_handle", &r->in.context_handle);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "witness_UnRegister");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_witness_AsyncNotify(struct ndr_push *ndr, ndr_flags_type flags, const struct witness_AsyncNotify *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.context_handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.response == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.response));
		if (*r->out.response) {
			NDR_CHECK(ndr_push_witness_notifyResponse(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.response));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_witness_AsyncNotify(struct ndr_pull *ndr, ndr_flags_type flags, struct witness_AsyncNotify *r)
{
	uint32_t _ptr_response;
	TALLOC_CTX *_mem_save_response_0 = NULL;
	TALLOC_CTX *_mem_save_response_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.context_handle));
		NDR_PULL_ALLOC(ndr, r->out.response);
		NDR_ZERO_STRUCTP(r->out.response);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.response);
		}
		_mem_save_response_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.response, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_response));
		if (_ptr_response) {
			NDR_PULL_ALLOC(ndr, *r->out.response);
		} else {
			*r->out.response = NULL;
		}
		if (*r->out.response) {
			_mem_save_response_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.response, 0);
			NDR_CHECK(ndr_pull_witness_notifyResponse(ndr, NDR_SCALARS|NDR_BUFFERS, *r->out.response));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_response_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_response_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_AsyncNotify(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct witness_AsyncNotify *r)
{
	ndr_print_struct(ndr, name, "witness_AsyncNotify");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "witness_AsyncNotify");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "context_handle", &r->in.context_handle);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "witness_AsyncNotify");
		ndr->depth++;
		ndr_print_ptr(ndr, "response", r->out.response);
		ndr->depth++;
		ndr_print_ptr(ndr, "response", *r->out.response);
		ndr->depth++;
		if (*r->out.response) {
			ndr_print_witness_notifyResponse(ndr, "response", *r->out.response);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_witness_RegisterEx(struct ndr_push *ndr, ndr_flags_type flags, const struct witness_RegisterEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_witness_version(ndr, NDR_SCALARS, r->in.version));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.net_name));
		if (r->in.net_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.net_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.net_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.net_name, ndr_charset_length(r->in.net_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.share_name));
		if (r->in.share_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.share_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.share_name, ndr_charset_length(r->in.share_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ip_address));
		if (r->in.ip_address) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ip_address, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ip_address, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.ip_address, ndr_charset_length(r->in.ip_address, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.client_computer_name));
		if (r->in.client_computer_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.client_computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.client_computer_name, ndr_charset_length(r->in.client_computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_witness_RegisterEx_flags(ndr, NDR_SCALARS, r->in.flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.timeout));
	}
	if (flags & NDR_OUT) {
		if (r->out.context_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.context_handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_witness_RegisterEx(struct ndr_pull *ndr, ndr_flags_type flags, struct witness_RegisterEx *r)
{
	uint32_t _ptr_net_name;
	uint32_t size_net_name_1 = 0;
	uint32_t length_net_name_1 = 0;
	uint32_t _ptr_share_name;
	uint32_t size_share_name_1 = 0;
	uint32_t length_share_name_1 = 0;
	uint32_t _ptr_ip_address;
	uint32_t size_ip_address_1 = 0;
	uint32_t length_ip_address_1 = 0;
	uint32_t _ptr_client_computer_name;
	uint32_t size_client_computer_name_1 = 0;
	uint32_t length_client_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_context_handle_0 = NULL;
	TALLOC_CTX *_mem_save_net_name_0 = NULL;
	TALLOC_CTX *_mem_save_share_name_0 = NULL;
	TALLOC_CTX *_mem_save_ip_address_0 = NULL;
	TALLOC_CTX *_mem_save_client_computer_name_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_witness_version(ndr, NDR_SCALARS, &r->in.version));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_net_name));
		if (_ptr_net_name) {
			NDR_PULL_ALLOC(ndr, r->in.net_name);
		} else {
			r->in.net_name = NULL;
		}
		if (r->in.net_name) {
			_mem_save_net_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.net_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.net_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.net_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.net_name, &size_net_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.net_name, &length_net_name_1));
			if (length_net_name_1 > size_net_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_net_name_1, length_net_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_net_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.net_name, length_net_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_net_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_share_name));
		if (_ptr_share_name) {
			NDR_PULL_ALLOC(ndr, r->in.share_name);
		} else {
			r->in.share_name = NULL;
		}
		if (r->in.share_name) {
			_mem_save_share_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.share_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.share_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.share_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.share_name, &size_share_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.share_name, &length_share_name_1));
			if (length_share_name_1 > size_share_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_share_name_1, length_share_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_share_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.share_name, length_share_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_share_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ip_address));
		if (_ptr_ip_address) {
			NDR_PULL_ALLOC(ndr, r->in.ip_address);
		} else {
			r->in.ip_address = NULL;
		}
		if (r->in.ip_address) {
			_mem_save_ip_address_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ip_address, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.ip_address));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.ip_address));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.ip_address, &size_ip_address_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.ip_address, &length_ip_address_1));
			if (length_ip_address_1 > size_ip_address_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ip_address_1, length_ip_address_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_ip_address_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.ip_address, length_ip_address_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ip_address_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_client_computer_name));
		if (_ptr_client_computer_name) {
			NDR_PULL_ALLOC(ndr, r->in.client_computer_name);
		} else {
			r->in.client_computer_name = NULL;
		}
		if (r->in.client_computer_name) {
			_mem_save_client_computer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.client_computer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.client_computer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.client_computer_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.client_computer_name, &size_client_computer_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.client_computer_name, &length_client_computer_name_1));
			if (length_client_computer_name_1 > size_client_computer_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_client_computer_name_1, length_client_computer_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_client_computer_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.client_computer_name, length_client_computer_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_client_computer_name_0, 0);
		}
		NDR_CHECK(ndr_pull_witness_RegisterEx_flags(ndr, NDR_SCALARS, &r->in.flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.timeout));
		NDR_PULL_ALLOC(ndr, r->out.context_handle);
		NDR_ZERO_STRUCTP(r->out.context_handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.context_handle);
		}
		_mem_save_context_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.context_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.context_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_context_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_witness_RegisterEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct witness_RegisterEx *r)
{
	ndr_print_struct(ndr, name, "witness_RegisterEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "witness_RegisterEx");
		ndr->depth++;
		ndr_print_witness_version(ndr, "version", r->in.version);
		ndr_print_ptr(ndr, "net_name", r->in.net_name);
		ndr->depth++;
		if (r->in.net_name) {
			ndr_print_string(ndr, "net_name", r->in.net_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "share_name", r->in.share_name);
		ndr->depth++;
		if (r->in.share_name) {
			ndr_print_string(ndr, "share_name", r->in.share_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "ip_address", r->in.ip_address);
		ndr->depth++;
		if (r->in.ip_address) {
			ndr_print_string(ndr, "ip_address", r->in.ip_address);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "client_computer_name", r->in.client_computer_name);
		ndr->depth++;
		if (r->in.client_computer_name) {
			ndr_print_string(ndr, "client_computer_name", r->in.client_computer_name);
		}
		ndr->depth--;
		ndr_print_witness_RegisterEx_flags(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "timeout", r->in.timeout);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "witness_RegisterEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "context_handle", r->out.context_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "context_handle", r->out.context_handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_witness
static const struct ndr_interface_public_struct witness_public_structs[] = {
	{
		.name = "witness_interfaceList",
		.struct_size = sizeof(struct witness_interfaceList ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_witness_interfaceList,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_witness_interfaceList,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_witness_interfaceList,
	},
	{
		.name = "witness_ResourceChange",
		.struct_size = sizeof(struct witness_ResourceChange ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_witness_ResourceChange,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_witness_ResourceChange,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_witness_ResourceChange,
	},
	{
		.name = "witness_IPaddrInfoList",
		.struct_size = sizeof(struct witness_IPaddrInfoList ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_witness_IPaddrInfoList,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_witness_IPaddrInfoList,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_witness_IPaddrInfoList,
	},
	{
		.name = "witness_notifyResponse",
		.struct_size = sizeof(struct witness_notifyResponse ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_witness_notifyResponse,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_witness_notifyResponse,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_witness_notifyResponse,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call witness_calls[] = {
	{
		"witness_GetInterfaceList",
		sizeof(struct witness_GetInterfaceList),
		(ndr_push_flags_fn_t) ndr_push_witness_GetInterfaceList,
		(ndr_pull_flags_fn_t) ndr_pull_witness_GetInterfaceList,
		(ndr_print_function_t) ndr_print_witness_GetInterfaceList,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"witness_Register",
		sizeof(struct witness_Register),
		(ndr_push_flags_fn_t) ndr_push_witness_Register,
		(ndr_pull_flags_fn_t) ndr_pull_witness_Register,
		(ndr_print_function_t) ndr_print_witness_Register,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"witness_UnRegister",
		sizeof(struct witness_UnRegister),
		(ndr_push_flags_fn_t) ndr_push_witness_UnRegister,
		(ndr_pull_flags_fn_t) ndr_pull_witness_UnRegister,
		(ndr_print_function_t) ndr_print_witness_UnRegister,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"witness_AsyncNotify",
		sizeof(struct witness_AsyncNotify),
		(ndr_push_flags_fn_t) ndr_push_witness_AsyncNotify,
		(ndr_pull_flags_fn_t) ndr_pull_witness_AsyncNotify,
		(ndr_print_function_t) ndr_print_witness_AsyncNotify,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"witness_RegisterEx",
		sizeof(struct witness_RegisterEx),
		(ndr_push_flags_fn_t) ndr_push_witness_RegisterEx,
		(ndr_pull_flags_fn_t) ndr_pull_witness_RegisterEx,
		(ndr_print_function_t) ndr_print_witness_RegisterEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const witness_endpoint_strings[] = {
	"ncacn_ip_tcp:", 
};

static const struct ndr_interface_string_array witness_endpoints = {
	.count	= 1,
	.names	= witness_endpoint_strings
};

static const char * const witness_authservice_strings[] = {
	"cifs", 
};

static const struct ndr_interface_string_array witness_authservices = {
	.count	= 1,
	.names	= witness_authservice_strings
};


const struct ndr_interface_table ndr_table_witness = {
	.name		= "witness",
	.syntax_id	= {
		{0xccd8c074,0xd0e5,0x4a40,{0x92,0xb4},{0xd0,0x74,0xfa,0xa6,0xba,0x28}},
		NDR_WITNESS_VERSION
	},
	.helpstring	= NDR_WITNESS_HELPSTRING,
	.num_calls	= 5,
	.calls		= witness_calls,
	.num_public_structs	= 4,
	.public_structs		= witness_public_structs,
	.endpoints	= &witness_endpoints,
	.authservices	= &witness_authservices
};

#endif /* SKIP_NDR_TABLE_witness */
