#ifndef __LIBRPC_RPC_DCESRV_CORE_PROTO_H__
#define __LIBRPC_RPC_DCESRV_CORE_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../librpc/rpc/dcesrv_core.c  */

void dcesrv_call_disconnect_after(struct dcesrv_call_state *call,
				  const char *reason);
NTSTATUS dcesrv_interface_bind_require_integrity(struct dcesrv_connection_context *context,
						 const struct dcesrv_interface *iface);
NTSTATUS dcesrv_interface_bind_require_privacy(struct dcesrv_connection_context *context,
					       const struct dcesrv_interface *iface);
void _dcesrv_save_ndr_fuzz_seed(DATA_BLOB call_blob,
				struct dcesrv_call_state *call,
				ndr_flags_type flags);
const struct dcesrv_critical_sizes *dcerpc_module_version(void);

/**
 * @brief Start the dcesrv loop, inducing the bind as a blob
 *
 * Like dcesrv_connection_loop_start() but used from connections
 * where the caller has already read the dcerpc bind packet from
 * the socket and is available as a DATA_BLOB.
 *
 * @param[in] dce_conn The connection to start
 * @param[in] pkt The parsed bind packet
 * @param[in] buffer The full binary bind including auth data
 */
void dcesrv_loop_next_packet(
	struct dcesrv_connection *dce_conn,
	struct ncacn_packet *pkt,
	DATA_BLOB buffer);

/* The following definitions come from ../../librpc/rpc/dcesrv_auth.c  */

void dcesrv_default_auth_state_prepare_request(struct dcesrv_call_state *call);
bool dcesrv_auth_bind(struct dcesrv_call_state *call);
NTSTATUS dcesrv_auth_complete(struct dcesrv_call_state *call, NTSTATUS status);
NTSTATUS dcesrv_auth_prepare_bind_ack(struct dcesrv_call_state *call, struct ncacn_packet *pkt);
bool dcesrv_auth_prepare_auth3(struct dcesrv_call_state *call);
bool dcesrv_auth_alter(struct dcesrv_call_state *call);
NTSTATUS dcesrv_auth_prepare_alter_ack(struct dcesrv_call_state *call, struct ncacn_packet *pkt);
bool dcesrv_auth_pkt_pull(struct dcesrv_call_state *call,
			  DATA_BLOB *full_packet,
			  uint8_t required_flags,
			  uint8_t optional_flags,
			  uint8_t payload_offset,
			  DATA_BLOB *payload_and_verifier);
bool dcesrv_auth_pkt_push(struct dcesrv_call_state *call,
			  DATA_BLOB *blob, size_t sig_size,
			  uint8_t payload_offset,
			  const DATA_BLOB *payload,
			  const struct ncacn_packet *pkt);

/* The following definitions come from ../../librpc/rpc/dcesrv_mgmt.c  */

const struct dcesrv_interface *dcesrv_get_mgmt_interface(void);

/* The following definitions come from ../../librpc/rpc/dcesrv_reply.c  */

void dcesrv_init_hdr(struct ncacn_packet *pkt, bool bigendian);
NTSTATUS dcesrv_fault_with_flags(struct dcesrv_call_state *call,
				 uint32_t fault_code,
				 uint8_t extra_flags);
NTSTATUS dcesrv_fault(struct dcesrv_call_state *call, uint32_t fault_code);

/* The following definitions come from ../../librpc/rpc/dcesrv_handles.c  */

struct dcesrv_handle *dcesrv_handle_create(struct dcesrv_call_state *call,
					   uint8_t handle_type);

/**
  find an internal handle given a wire handle. If the wire handle is NULL then
  allocate a new handle
*/
struct dcesrv_handle *dcesrv_handle_lookup(struct dcesrv_call_state *call,
					   const struct policy_handle *p,
					   uint8_t handle_type);
void dcesrv_assoc_group_common_destructor(struct dcesrv_assoc_group *assoc_group);
NTSTATUS _dcesrv_iface_state_store_assoc(struct dcesrv_call_state *call,
				uint64_t magic,
				void *ptr,
				const char *location);
void *_dcesrv_iface_state_find_assoc(struct dcesrv_call_state *call, uint64_t magic);
NTSTATUS _dcesrv_iface_state_store_conn(struct dcesrv_call_state *call,
					uint64_t magic,
					void *ptr,
					const char *location);
void *_dcesrv_iface_state_find_conn(struct dcesrv_call_state *call, uint64_t magic);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __LIBRPC_RPC_DCESRV_CORE_PROTO_H__ */

