
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/source4/librpc/gen_ndr/ndr_irpc.h"
#include "bin/default/source4/librpc/gen_ndr/ndr_irpc_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/nbt.h"
#include "librpc/gen_ndr/netlogon.h"
#include "librpc/gen_ndr/server_id.h"
static PyTypeObject irpc_creds_Type;
static PyTypeObject irpc_header_Type;
static PyTypeObject irpc_name_record_Type;
static PyTypeObject irpc_name_records_Type;
static PyTypeObject nbtd_statistics_Type;
static PyTypeObject nbtd_info_Type;
static PyTypeObject nbtd_proxy_wins_addr_Type;
static PyTypeObject smbsrv_session_info_Type;
static PyTypeObject smbsrv_sessions_Type;
static PyTypeObject smbsrv_tcon_info_Type;
static PyTypeObject smbsrv_tcons_Type;
static PyTypeObject smbsrv_info_Type;
static PyTypeObject irpc_InterfaceType;
static PyTypeObject irpc_uptime_Type;
static PyTypeObject nbtd_information_Type;
static PyTypeObject nbtd_getdcname_Type;
static PyTypeObject nbtd_proxy_wins_challenge_Type;
static PyTypeObject nbtd_proxy_wins_release_demand_Type;
static PyTypeObject kdc_check_generic_kerberos_Type;
static PyTypeObject smbsrv_information_Type;
static PyTypeObject samba_terminate_Type;
static PyTypeObject dreplsrv_refresh_Type;
static PyTypeObject drepl_takeFSMORole_Type;
static PyTypeObject drepl_trigger_repl_secret_Type;
static PyTypeObject dnsupdate_RODC_Type;
static PyTypeObject dnssrv_reload_dns_zones_Type;

static PyTypeObject *security_token_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *server_id_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *nbt_name_Type;
static PyTypeObject *NL_DNS_NAME_INFO_ARRAY_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_irpc_creds_get_token(PyObject *obj, void *closure)
{
	struct irpc_creds *object = pytalloc_get_ptr(obj);
	PyObject *py_token;
	if (object->token == NULL) {
		Py_RETURN_NONE;
	}
	if (object->token == NULL) {
		py_token = Py_None;
		Py_INCREF(py_token);
	} else {
		py_token = pytalloc_reference_ex(security_token_Type, object->token, object->token);
	}
	return py_token;
}

static int py_irpc_creds_set_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_creds *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->token));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->token");
		return -1;
	}
	if (value == Py_None) {
		object->token = NULL;
	} else {
		object->token = NULL;
		PY_CHECK_TYPE(security_token_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->token = (struct security_token *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_irpc_creds_getsetters[] = {
	{
		.name = discard_const_p(char, "token"),
		.get = py_irpc_creds_get_token,
		.set = py_irpc_creds_set_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_token")
	},
	{ .name = NULL }
};

static PyObject *py_irpc_creds_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct irpc_creds, type);
}


static PyTypeObject irpc_creds_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.creds",
	.tp_getset = py_irpc_creds_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_irpc_creds_new,
};


static PyObject *py_irpc_header_get_uuid(PyObject *obj, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(obj);
	PyObject *py_uuid;
	py_uuid = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->uuid);
	return py_uuid;
}

static int py_irpc_header_set_uuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->uuid");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->uuid = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_irpc_header_get_if_version(PyObject *obj, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(obj);
	PyObject *py_if_version;
	py_if_version = PyLong_FromUnsignedLongLong((uint32_t)(object->if_version));
	return py_if_version;
}

static int py_irpc_header_set_if_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->if_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->if_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->if_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_irpc_header_get_callnum(PyObject *obj, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(obj);
	PyObject *py_callnum;
	py_callnum = PyLong_FromUnsignedLongLong((uint32_t)(object->callnum));
	return py_callnum;
}

static int py_irpc_header_set_callnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->callnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->callnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->callnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_irpc_header_get_callid(PyObject *obj, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(obj);
	PyObject *py_callid;
	py_callid = PyLong_FromUnsignedLongLong((uint32_t)(object->callid));
	return py_callid;
}

static int py_irpc_header_set_callid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->callid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->callid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->callid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_irpc_header_get_flags(PyObject *obj, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->flags));
	return py_flags;
}

static int py_irpc_header_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_irpc_header_get_status(PyObject *obj, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromNTSTATUS(object->status);
	return py_status;
}

static int py_irpc_header_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	object->status = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyObject *py_irpc_header_get_creds(PyObject *obj, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(obj);
	PyObject *py_creds;
	py_creds = pytalloc_reference_ex(&irpc_creds_Type, pytalloc_get_mem_ctx(obj), &object->creds);
	return py_creds;
}

static int py_irpc_header_set_creds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->creds");
		return -1;
	}
	PY_CHECK_TYPE(&irpc_creds_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->creds = *(struct irpc_creds *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_irpc_header_get__pad(PyObject *obj, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyBytes_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_irpc_header_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_header *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad");
		return -1;
	}
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_irpc_header_getsetters[] = {
	{
		.name = discard_const_p(char, "uuid"),
		.get = py_irpc_header_get_uuid,
		.set = py_irpc_header_set_uuid,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "if_version"),
		.get = py_irpc_header_get_if_version,
		.set = py_irpc_header_set_if_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "callnum"),
		.get = py_irpc_header_get_callnum,
		.set = py_irpc_header_set_callnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "callid"),
		.get = py_irpc_header_get_callid,
		.set = py_irpc_header_set_callid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_irpc_header_get_flags,
		.set = py_irpc_header_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type irpc_flags")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_irpc_header_get_status,
		.set = py_irpc_header_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTSTATUS")
	},
	{
		.name = discard_const_p(char, "creds"),
		.get = py_irpc_header_get_creds,
		.set = py_irpc_header_set_creds,
		.doc = discard_const_p(char, "PIDL-generated element of base type irpc_creds")
	},
	{
		.name = discard_const_p(char, "_pad"),
		.get = py_irpc_header_get__pad,
		.set = py_irpc_header_set__pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_irpc_header_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct irpc_header, type);
}

static PyObject *py_irpc_header_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct irpc_header *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_irpc_header);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_irpc_header_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct irpc_header *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_irpc_header);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_irpc_header);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_irpc_header_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct irpc_header *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_irpc_header, "irpc_header", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_irpc_header, "irpc_header", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_irpc_header_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_irpc_header_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_header_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_header_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject irpc_header_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.header",
	.tp_getset = py_irpc_header_getsetters,
	.tp_methods = py_irpc_header_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_irpc_header_new,
};


static PyObject *py_irpc_name_record_get_name(PyObject *obj, void *closure)
{
	struct irpc_name_record *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = PyString_FromStringOrNULL(object->name);
	return py_name;
}

static int py_irpc_name_record_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_name_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->name = talloc_str;
	}
	return 0;
}

static PyObject *py_irpc_name_record_get_count(PyObject *obj, void *closure)
{
	struct irpc_name_record *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_irpc_name_record_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_name_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_irpc_name_record_get_ids(PyObject *obj, void *closure)
{
	struct irpc_name_record *object = pytalloc_get_ptr(obj);
	PyObject *py_ids;
	py_ids = PyList_New(object->count);
	if (py_ids == NULL) {
		return NULL;
	}
	{
		int ids_cntr_0;
		for (ids_cntr_0 = 0; ids_cntr_0 < (object->count); ids_cntr_0++) {
			PyObject *py_ids_0;
			py_ids_0 = pytalloc_reference_ex(server_id_Type, object->ids, &(object->ids)[ids_cntr_0]);
			PyList_SetItem(py_ids, ids_cntr_0, py_ids_0);
		}
	}
	return py_ids;
}

static int py_irpc_name_record_set_ids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_name_record *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ids_cntr_0;
		object->ids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ids, PyList_GET_SIZE(value));
		if (!object->ids) { return -1; }
		talloc_set_name_const(object->ids, "ARRAY: object->ids");
		for (ids_cntr_0 = 0; ids_cntr_0 < PyList_GET_SIZE(value); ids_cntr_0++) {
			if (PyList_GET_ITEM(value, ids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->ids)[ids_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(server_id_Type, PyList_GET_ITEM(value, ids_cntr_0), return -1;);
			if (talloc_reference(object->ids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->ids)[ids_cntr_0] = *(struct server_id *)pytalloc_get_ptr(PyList_GET_ITEM(value, ids_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_irpc_name_record_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_irpc_name_record_get_name,
		.set = py_irpc_name_record_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_irpc_name_record_get_count,
		.set = py_irpc_name_record_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ids"),
		.get = py_irpc_name_record_get_ids,
		.set = py_irpc_name_record_set_ids,
		.doc = discard_const_p(char, "PIDL-generated element of base type server_id")
	},
	{ .name = NULL }
};

static PyObject *py_irpc_name_record_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct irpc_name_record, type);
}

static PyObject *py_irpc_name_record_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct irpc_name_record *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_irpc_name_record);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_irpc_name_record_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct irpc_name_record *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_irpc_name_record);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_irpc_name_record);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_irpc_name_record_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct irpc_name_record *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_irpc_name_record, "irpc_name_record", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_irpc_name_record, "irpc_name_record", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_irpc_name_record_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_irpc_name_record_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_name_record_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_name_record_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject irpc_name_record_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.name_record",
	.tp_getset = py_irpc_name_record_getsetters,
	.tp_methods = py_irpc_name_record_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_irpc_name_record_new,
};


static PyObject *py_irpc_name_records_get_names(PyObject *obj, void *closure)
{
	struct irpc_name_records *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	py_names = PyList_New(object->num_records);
	if (py_names == NULL) {
		return NULL;
	}
	{
		int names_cntr_0;
		for (names_cntr_0 = 0; names_cntr_0 < (object->num_records); names_cntr_0++) {
			PyObject *py_names_0;
			if ((object->names)[names_cntr_0] == NULL) {
				py_names_0 = Py_None;
				Py_INCREF(py_names_0);
			} else {
				py_names_0 = pytalloc_reference_ex(&irpc_name_record_Type, (object->names)[names_cntr_0], (object->names)[names_cntr_0]);
			}
			PyList_SetItem(py_names, names_cntr_0, py_names_0);
		}
	}
	return py_names;
}

static int py_irpc_name_records_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_name_records *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->names");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int names_cntr_0;
		object->names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->names, PyList_GET_SIZE(value));
		if (!object->names) { return -1; }
		talloc_set_name_const(object->names, "ARRAY: object->names");
		for (names_cntr_0 = 0; names_cntr_0 < PyList_GET_SIZE(value); names_cntr_0++) {
			if (PyList_GET_ITEM(value, names_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->names)[names_cntr_0]");
				return -1;
			}
			if (PyList_GET_ITEM(value, names_cntr_0) == Py_None) {
				(object->names)[names_cntr_0] = NULL;
			} else {
				(object->names)[names_cntr_0] = NULL;
				PY_CHECK_TYPE(&irpc_name_record_Type, PyList_GET_ITEM(value, names_cntr_0), return -1;);
				if (talloc_reference(object->names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_0))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->names)[names_cntr_0] = (struct irpc_name_record *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_0));
			}
		}
	}
	return 0;
}

static PyObject *py_irpc_name_records_get_num_records(PyObject *obj, void *closure)
{
	struct irpc_name_records *object = pytalloc_get_ptr(obj);
	PyObject *py_num_records;
	py_num_records = PyLong_FromUnsignedLongLong((uint32_t)(object->num_records));
	return py_num_records;
}

static int py_irpc_name_records_set_num_records(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_name_records *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_records");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_records));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_records = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_irpc_name_records_getsetters[] = {
	{
		.name = discard_const_p(char, "names"),
		.get = py_irpc_name_records_get_names,
		.set = py_irpc_name_records_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type irpc_name_record")
	},
	{
		.name = discard_const_p(char, "num_records"),
		.get = py_irpc_name_records_get_num_records,
		.set = py_irpc_name_records_set_num_records,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_irpc_name_records_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct irpc_name_records, type);
}

static PyObject *py_irpc_name_records_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct irpc_name_records *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_irpc_name_records);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_irpc_name_records_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct irpc_name_records *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_irpc_name_records);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_irpc_name_records);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_irpc_name_records_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct irpc_name_records *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_irpc_name_records, "irpc_name_records", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_irpc_name_records, "irpc_name_records", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_irpc_name_records_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_irpc_name_records_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_name_records_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_name_records_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject irpc_name_records_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.name_records",
	.tp_getset = py_irpc_name_records_getsetters,
	.tp_methods = py_irpc_name_records_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_irpc_name_records_new,
};


static PyObject *py_nbtd_statistics_get_total_received(PyObject *obj, void *closure)
{
	struct nbtd_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_total_received;
	py_total_received = PyLong_FromUnsignedLongLong(object->total_received);
	return py_total_received;
}

static int py_nbtd_statistics_set_total_received(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->total_received");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->total_received));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->total_received = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbtd_statistics_get_total_sent(PyObject *obj, void *closure)
{
	struct nbtd_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_total_sent;
	py_total_sent = PyLong_FromUnsignedLongLong(object->total_sent);
	return py_total_sent;
}

static int py_nbtd_statistics_set_total_sent(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->total_sent");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->total_sent));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->total_sent = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbtd_statistics_get_query_count(PyObject *obj, void *closure)
{
	struct nbtd_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_query_count;
	py_query_count = PyLong_FromUnsignedLongLong(object->query_count);
	return py_query_count;
}

static int py_nbtd_statistics_set_query_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->query_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->query_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->query_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbtd_statistics_get_register_count(PyObject *obj, void *closure)
{
	struct nbtd_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_register_count;
	py_register_count = PyLong_FromUnsignedLongLong(object->register_count);
	return py_register_count;
}

static int py_nbtd_statistics_set_register_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->register_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->register_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->register_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbtd_statistics_get_release_count(PyObject *obj, void *closure)
{
	struct nbtd_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_release_count;
	py_release_count = PyLong_FromUnsignedLongLong(object->release_count);
	return py_release_count;
}

static int py_nbtd_statistics_set_release_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->release_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->release_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->release_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_nbtd_statistics_getsetters[] = {
	{
		.name = discard_const_p(char, "total_received"),
		.get = py_nbtd_statistics_get_total_received,
		.set = py_nbtd_statistics_set_total_received,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "total_sent"),
		.get = py_nbtd_statistics_get_total_sent,
		.set = py_nbtd_statistics_set_total_sent,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "query_count"),
		.get = py_nbtd_statistics_get_query_count,
		.set = py_nbtd_statistics_set_query_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "register_count"),
		.get = py_nbtd_statistics_get_register_count,
		.set = py_nbtd_statistics_set_register_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "release_count"),
		.get = py_nbtd_statistics_get_release_count,
		.set = py_nbtd_statistics_set_release_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_nbtd_statistics_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbtd_statistics, type);
}


static PyTypeObject nbtd_statistics_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.nbtd_statistics",
	.tp_getset = py_nbtd_statistics_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbtd_statistics_new,
};

static PyObject *py_import_nbtd_info(TALLOC_CTX *mem_ctx, int level, union nbtd_info *in)
{
	PyObject *ret;

	switch (level) {
		case NBTD_INFO_STATISTICS:
			if (in->stats == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = pytalloc_reference_ex(&nbtd_statistics_Type, in->stats, in->stats);
			}
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union nbtd_info *py_export_nbtd_info(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union nbtd_info *ret = talloc_zero(mem_ctx, union nbtd_info);
	switch (level) {
		case NBTD_INFO_STATISTICS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->stats");
				talloc_free(ret); return NULL;
			}
			if (in == Py_None) {
				ret->stats = NULL;
			} else {
				ret->stats = NULL;
				PY_CHECK_TYPE(&nbtd_statistics_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->stats = (struct nbtd_statistics *)pytalloc_get_ptr(in);
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_nbtd_info_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union nbtd_info *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union nbtd_info *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union nbtd_info!");
		return NULL;
	}

	return py_import_nbtd_info(mem_ctx, level, in);
}

static PyObject *py_nbtd_info_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union nbtd_info *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_nbtd_info(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_nbtd_info_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_info_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_info_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_nbtd_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject nbtd_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.nbtd_info",
	.tp_getset = NULL,
	.tp_methods = py_nbtd_info_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbtd_info_new,
};


static PyObject *py_nbtd_proxy_wins_addr_get_addr(PyObject *obj, void *closure)
{
	struct nbtd_proxy_wins_addr *object = pytalloc_get_ptr(obj);
	PyObject *py_addr;
	py_addr = PyString_FromStringOrNULL(object->addr);
	return py_addr;
}

static int py_nbtd_proxy_wins_addr_set_addr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_proxy_wins_addr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->addr");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->addr = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_nbtd_proxy_wins_addr_getsetters[] = {
	{
		.name = discard_const_p(char, "addr"),
		.get = py_nbtd_proxy_wins_addr_get_addr,
		.set = py_nbtd_proxy_wins_addr_set_addr,
		.doc = discard_const_p(char, "PIDL-generated element of base type ipv4address")
	},
	{ .name = NULL }
};

static PyObject *py_nbtd_proxy_wins_addr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct nbtd_proxy_wins_addr, type);
}


static PyTypeObject nbtd_proxy_wins_addr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.nbtd_proxy_wins_addr",
	.tp_getset = py_nbtd_proxy_wins_addr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbtd_proxy_wins_addr_new,
};


static PyObject *py_smbsrv_session_info_get_vuid(PyObject *obj, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_vuid;
	py_vuid = PyLong_FromUnsignedLongLong(object->vuid);
	return py_vuid;
}

static int py_smbsrv_session_info_set_vuid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->vuid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->vuid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->vuid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbsrv_session_info_get_account_name(PyObject *obj, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = PyString_FromStringOrNULL(object->account_name);
	return py_account_name;
}

static int py_smbsrv_session_info_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->account_name = talloc_str;
	}
	return 0;
}

static PyObject *py_smbsrv_session_info_get_domain_name(PyObject *obj, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = PyString_FromStringOrNULL(object->domain_name);
	return py_domain_name;
}

static int py_smbsrv_session_info_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->domain_name = talloc_str;
	}
	return 0;
}

static PyObject *py_smbsrv_session_info_get_client_ip(PyObject *obj, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_client_ip;
	py_client_ip = PyString_FromStringOrNULL(object->client_ip);
	return py_client_ip;
}

static int py_smbsrv_session_info_set_client_ip(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_ip");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->client_ip = talloc_str;
	}
	return 0;
}

static PyObject *py_smbsrv_session_info_get_connect_time(PyObject *obj, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_connect_time;
	py_connect_time = PyLong_FromUnsignedLongLong(object->connect_time);
	return py_connect_time;
}

static int py_smbsrv_session_info_set_connect_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->connect_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->connect_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->connect_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbsrv_session_info_get_auth_time(PyObject *obj, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_time;
	py_auth_time = PyLong_FromUnsignedLongLong(object->auth_time);
	return py_auth_time;
}

static int py_smbsrv_session_info_set_auth_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbsrv_session_info_get_last_use_time(PyObject *obj, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_last_use_time;
	py_last_use_time = PyLong_FromUnsignedLongLong(object->last_use_time);
	return py_last_use_time;
}

static int py_smbsrv_session_info_set_last_use_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_session_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_use_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_use_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_use_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smbsrv_session_info_getsetters[] = {
	{
		.name = discard_const_p(char, "vuid"),
		.get = py_smbsrv_session_info_get_vuid,
		.set = py_smbsrv_session_info_set_vuid,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_smbsrv_session_info_get_account_name,
		.set = py_smbsrv_session_info_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_smbsrv_session_info_get_domain_name,
		.set = py_smbsrv_session_info_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "client_ip"),
		.get = py_smbsrv_session_info_get_client_ip,
		.set = py_smbsrv_session_info_set_client_ip,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "connect_time"),
		.get = py_smbsrv_session_info_get_connect_time,
		.set = py_smbsrv_session_info_set_connect_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "auth_time"),
		.get = py_smbsrv_session_info_get_auth_time,
		.set = py_smbsrv_session_info_set_auth_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_use_time"),
		.get = py_smbsrv_session_info_get_last_use_time,
		.set = py_smbsrv_session_info_set_last_use_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{ .name = NULL }
};

static PyObject *py_smbsrv_session_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbsrv_session_info, type);
}


static PyTypeObject smbsrv_session_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.smbsrv_session_info",
	.tp_getset = py_smbsrv_session_info_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbsrv_session_info_new,
};


static PyObject *py_smbsrv_sessions_get_num_sessions(PyObject *obj, void *closure)
{
	struct smbsrv_sessions *object = pytalloc_get_ptr(obj);
	PyObject *py_num_sessions;
	py_num_sessions = PyLong_FromUnsignedLongLong((uint32_t)(object->num_sessions));
	return py_num_sessions;
}

static int py_smbsrv_sessions_set_num_sessions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_sessions *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_sessions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_sessions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_sessions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbsrv_sessions_get_sessions(PyObject *obj, void *closure)
{
	struct smbsrv_sessions *object = pytalloc_get_ptr(obj);
	PyObject *py_sessions;
	if (object->sessions == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sessions == NULL) {
		py_sessions = Py_None;
		Py_INCREF(py_sessions);
	} else {
		py_sessions = PyList_New(object->num_sessions);
		if (py_sessions == NULL) {
			return NULL;
		}
		{
			int sessions_cntr_1;
			for (sessions_cntr_1 = 0; sessions_cntr_1 < (object->num_sessions); sessions_cntr_1++) {
				PyObject *py_sessions_1;
				py_sessions_1 = pytalloc_reference_ex(&smbsrv_session_info_Type, object->sessions, &(object->sessions)[sessions_cntr_1]);
				PyList_SetItem(py_sessions, sessions_cntr_1, py_sessions_1);
			}
		}
	}
	return py_sessions;
}

static int py_smbsrv_sessions_set_sessions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_sessions *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->sessions));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sessions");
		return -1;
	}
	if (value == Py_None) {
		object->sessions = NULL;
	} else {
		object->sessions = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int sessions_cntr_1;
			object->sessions = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sessions, PyList_GET_SIZE(value));
			if (!object->sessions) { return -1; }
			talloc_set_name_const(object->sessions, "ARRAY: object->sessions");
			for (sessions_cntr_1 = 0; sessions_cntr_1 < PyList_GET_SIZE(value); sessions_cntr_1++) {
				if (PyList_GET_ITEM(value, sessions_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->sessions)[sessions_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&smbsrv_session_info_Type, PyList_GET_ITEM(value, sessions_cntr_1), return -1;);
				if (talloc_reference(object->sessions, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sessions_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->sessions)[sessions_cntr_1] = *(struct smbsrv_session_info *)pytalloc_get_ptr(PyList_GET_ITEM(value, sessions_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_smbsrv_sessions_getsetters[] = {
	{
		.name = discard_const_p(char, "num_sessions"),
		.get = py_smbsrv_sessions_get_num_sessions,
		.set = py_smbsrv_sessions_set_num_sessions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sessions"),
		.get = py_smbsrv_sessions_get_sessions,
		.set = py_smbsrv_sessions_set_sessions,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbsrv_session_info")
	},
	{ .name = NULL }
};

static PyObject *py_smbsrv_sessions_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbsrv_sessions, type);
}


static PyTypeObject smbsrv_sessions_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.smbsrv_sessions",
	.tp_getset = py_smbsrv_sessions_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbsrv_sessions_new,
};


static PyObject *py_smbsrv_tcon_info_get_tid(PyObject *obj, void *closure)
{
	struct smbsrv_tcon_info *object = pytalloc_get_ptr(obj);
	PyObject *py_tid;
	py_tid = PyLong_FromUnsignedLongLong((uint32_t)(object->tid));
	return py_tid;
}

static int py_smbsrv_tcon_info_set_tid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_tcon_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->tid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->tid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbsrv_tcon_info_get_share_name(PyObject *obj, void *closure)
{
	struct smbsrv_tcon_info *object = pytalloc_get_ptr(obj);
	PyObject *py_share_name;
	py_share_name = PyString_FromStringOrNULL(object->share_name);
	return py_share_name;
}

static int py_smbsrv_tcon_info_set_share_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_tcon_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->share_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->share_name = talloc_str;
	}
	return 0;
}

static PyObject *py_smbsrv_tcon_info_get_client_ip(PyObject *obj, void *closure)
{
	struct smbsrv_tcon_info *object = pytalloc_get_ptr(obj);
	PyObject *py_client_ip;
	py_client_ip = PyString_FromStringOrNULL(object->client_ip);
	return py_client_ip;
}

static int py_smbsrv_tcon_info_set_client_ip(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_tcon_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_ip");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->client_ip = talloc_str;
	}
	return 0;
}

static PyObject *py_smbsrv_tcon_info_get_connect_time(PyObject *obj, void *closure)
{
	struct smbsrv_tcon_info *object = pytalloc_get_ptr(obj);
	PyObject *py_connect_time;
	py_connect_time = PyLong_FromUnsignedLongLong(object->connect_time);
	return py_connect_time;
}

static int py_smbsrv_tcon_info_set_connect_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_tcon_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->connect_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->connect_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->connect_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbsrv_tcon_info_get_last_use_time(PyObject *obj, void *closure)
{
	struct smbsrv_tcon_info *object = pytalloc_get_ptr(obj);
	PyObject *py_last_use_time;
	py_last_use_time = PyLong_FromUnsignedLongLong(object->last_use_time);
	return py_last_use_time;
}

static int py_smbsrv_tcon_info_set_last_use_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_tcon_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_use_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_use_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_use_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_smbsrv_tcon_info_getsetters[] = {
	{
		.name = discard_const_p(char, "tid"),
		.get = py_smbsrv_tcon_info_get_tid,
		.set = py_smbsrv_tcon_info_set_tid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "share_name"),
		.get = py_smbsrv_tcon_info_get_share_name,
		.set = py_smbsrv_tcon_info_set_share_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "client_ip"),
		.get = py_smbsrv_tcon_info_get_client_ip,
		.set = py_smbsrv_tcon_info_set_client_ip,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "connect_time"),
		.get = py_smbsrv_tcon_info_get_connect_time,
		.set = py_smbsrv_tcon_info_set_connect_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_use_time"),
		.get = py_smbsrv_tcon_info_get_last_use_time,
		.set = py_smbsrv_tcon_info_set_last_use_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{ .name = NULL }
};

static PyObject *py_smbsrv_tcon_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbsrv_tcon_info, type);
}


static PyTypeObject smbsrv_tcon_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.smbsrv_tcon_info",
	.tp_getset = py_smbsrv_tcon_info_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbsrv_tcon_info_new,
};


static PyObject *py_smbsrv_tcons_get_num_tcons(PyObject *obj, void *closure)
{
	struct smbsrv_tcons *object = pytalloc_get_ptr(obj);
	PyObject *py_num_tcons;
	py_num_tcons = PyLong_FromUnsignedLongLong((uint32_t)(object->num_tcons));
	return py_num_tcons;
}

static int py_smbsrv_tcons_set_num_tcons(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_tcons *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_tcons");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_tcons));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_tcons = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbsrv_tcons_get_tcons(PyObject *obj, void *closure)
{
	struct smbsrv_tcons *object = pytalloc_get_ptr(obj);
	PyObject *py_tcons;
	if (object->tcons == NULL) {
		Py_RETURN_NONE;
	}
	if (object->tcons == NULL) {
		py_tcons = Py_None;
		Py_INCREF(py_tcons);
	} else {
		py_tcons = PyList_New(object->num_tcons);
		if (py_tcons == NULL) {
			return NULL;
		}
		{
			int tcons_cntr_1;
			for (tcons_cntr_1 = 0; tcons_cntr_1 < (object->num_tcons); tcons_cntr_1++) {
				PyObject *py_tcons_1;
				py_tcons_1 = pytalloc_reference_ex(&smbsrv_tcon_info_Type, object->tcons, &(object->tcons)[tcons_cntr_1]);
				PyList_SetItem(py_tcons, tcons_cntr_1, py_tcons_1);
			}
		}
	}
	return py_tcons;
}

static int py_smbsrv_tcons_set_tcons(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_tcons *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->tcons));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->tcons");
		return -1;
	}
	if (value == Py_None) {
		object->tcons = NULL;
	} else {
		object->tcons = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int tcons_cntr_1;
			object->tcons = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->tcons, PyList_GET_SIZE(value));
			if (!object->tcons) { return -1; }
			talloc_set_name_const(object->tcons, "ARRAY: object->tcons");
			for (tcons_cntr_1 = 0; tcons_cntr_1 < PyList_GET_SIZE(value); tcons_cntr_1++) {
				if (PyList_GET_ITEM(value, tcons_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->tcons)[tcons_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&smbsrv_tcon_info_Type, PyList_GET_ITEM(value, tcons_cntr_1), return -1;);
				if (talloc_reference(object->tcons, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, tcons_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->tcons)[tcons_cntr_1] = *(struct smbsrv_tcon_info *)pytalloc_get_ptr(PyList_GET_ITEM(value, tcons_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_smbsrv_tcons_getsetters[] = {
	{
		.name = discard_const_p(char, "num_tcons"),
		.get = py_smbsrv_tcons_get_num_tcons,
		.set = py_smbsrv_tcons_set_num_tcons,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "tcons"),
		.get = py_smbsrv_tcons_get_tcons,
		.set = py_smbsrv_tcons_set_tcons,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbsrv_tcon_info")
	},
	{ .name = NULL }
};

static PyObject *py_smbsrv_tcons_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct smbsrv_tcons, type);
}


static PyTypeObject smbsrv_tcons_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.smbsrv_tcons",
	.tp_getset = py_smbsrv_tcons_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbsrv_tcons_new,
};

static PyObject *py_import_smbsrv_info(TALLOC_CTX *mem_ctx, int level, union smbsrv_info *in)
{
	PyObject *ret;

	switch (level) {
		case SMBSRV_INFO_SESSIONS:
			ret = pytalloc_reference_ex(&smbsrv_sessions_Type, mem_ctx, &in->sessions);
			return ret;

		case SMBSRV_INFO_TCONS:
			ret = pytalloc_reference_ex(&smbsrv_tcons_Type, mem_ctx, &in->tcons);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union smbsrv_info *py_export_smbsrv_info(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union smbsrv_info *ret = talloc_zero(mem_ctx, union smbsrv_info);
	switch (level) {
		case SMBSRV_INFO_SESSIONS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->sessions");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&smbsrv_sessions_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->sessions = *(struct smbsrv_sessions *)pytalloc_get_ptr(in);
			break;

		case SMBSRV_INFO_TCONS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->tcons");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&smbsrv_tcons_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->tcons = *(struct smbsrv_tcons *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_smbsrv_info_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union smbsrv_info *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union smbsrv_info *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union smbsrv_info!");
		return NULL;
	}

	return py_import_smbsrv_info(mem_ctx, level, in);
}

static PyObject *py_smbsrv_info_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union smbsrv_info *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_smbsrv_info(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_smbsrv_info_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbsrv_info_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbsrv_info_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_smbsrv_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject smbsrv_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.smbsrv_info",
	.tp_getset = NULL,
	.tp_methods = py_smbsrv_info_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbsrv_info_new,
};



static PyObject *py_irpc_uptime_out_get_start_time(PyObject *obj, void *closure)
{
	struct irpc_uptime *object = pytalloc_get_ptr(obj);
	PyObject *py_start_time;
	if (object->out.start_time == NULL) {
		Py_RETURN_NONE;
	}
	py_start_time = PyLong_FromUnsignedLongLong(*object->out.start_time);
	return py_start_time;
}

static int py_irpc_uptime_out_set_start_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct irpc_uptime *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.start_time));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.start_time");
		return -1;
	}
	object->out.start_time = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.start_time);
	if (object->out.start_time == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.start_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.start_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_irpc_uptime_getsetters[] = {
	{
		.name = discard_const_p(char, "out_start_time"),
		.get = py_irpc_uptime_out_get_start_time,
		.set = py_irpc_uptime_out_set_start_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{ .name = NULL }
};

static PyObject *py_irpc_uptime_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct irpc_uptime, type);
	struct irpc_uptime *_self = (struct irpc_uptime *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.start_time = talloc_zero(mem_ctx, NTTIME);
	return self;
}

static PyObject *py_irpc_uptime_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_irpc_uptime_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct irpc_uptime *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_irpc_uptime_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_irpc_uptime_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_irpc_uptime_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_irpc_uptime_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_irpc_uptime_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_irpc_uptime_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct irpc_uptime *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_irpc_uptime_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_irpc_uptime_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_irpc_uptime_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_irpc_uptime_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_irpc_uptime_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_irpc_uptime_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct irpc_uptime *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_irpc_uptime_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_irpc_uptime_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_irpc_uptime_ndr_print(py_obj, args, kwargs, "irpc_uptime_in", NDR_IN);
}

static PyObject *py_irpc_uptime_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_irpc_uptime_ndr_print(py_obj, args, kwargs, "irpc_uptime_out", NDR_OUT);
}

static PyMethodDef py_irpc_uptime_methods[] = {
	{ "opnum", (PyCFunction)py_irpc_uptime_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.uptime.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_uptime_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_uptime_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_uptime_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_uptime_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_uptime_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_irpc_uptime_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject irpc_uptime_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.uptime",
	.tp_getset = py_irpc_uptime_getsetters,
	.tp_methods = py_irpc_uptime_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_irpc_uptime_new,
};

static bool pack_py_irpc_uptime_args_in(PyObject *args, PyObject *kwargs, struct irpc_uptime *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":irpc_uptime", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_irpc_uptime_args_out(struct irpc_uptime *r, bool raise_result_exception)
{
	PyObject *py_start_time = NULL;
	PyObject *result = NULL;

	py_start_time = PyLong_FromUnsignedLongLong(*r->out.start_time);
	result = py_start_time;

	return result;
}


static PyObject *py_nbtd_information_in_get_level(PyObject *obj, void *closure)
{
	struct nbtd_information *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.level));
	return py_level;
}

static int py_nbtd_information_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbtd_information_out_get_info(PyObject *obj, void *closure)
{
	struct nbtd_information *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&nbtd_info_Type, pytalloc_get_mem_ctx(obj), object->in.level, &object->out.info, "union nbtd_info");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_nbtd_information_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.info");
		return -1;
	}
	{
		union nbtd_info *info_switch_0;
		info_switch_0 = (union nbtd_info *)pyrpc_export_union(&nbtd_info_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union nbtd_info");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->out.info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_nbtd_information_getsetters[] = {
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_nbtd_information_in_get_level,
		.set = py_nbtd_information_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbtd_info_level")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_nbtd_information_out_get_info,
		.set = py_nbtd_information_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbtd_info")
	},
	{ .name = NULL }
};

static PyObject *py_nbtd_information_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct nbtd_information, type);
	return self;
}

static PyObject *py_nbtd_information_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_nbtd_information_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_information *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_information_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_nbtd_information_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_nbtd_information_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_nbtd_information_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_nbtd_information_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_nbtd_information_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_information *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_information_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_nbtd_information_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_nbtd_information_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_nbtd_information_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_nbtd_information_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_nbtd_information_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_information *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_information_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_nbtd_information_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_nbtd_information_ndr_print(py_obj, args, kwargs, "nbtd_information_in", NDR_IN);
}

static PyObject *py_nbtd_information_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_nbtd_information_ndr_print(py_obj, args, kwargs, "nbtd_information_out", NDR_OUT);
}

static PyMethodDef py_nbtd_information_methods[] = {
	{ "opnum", (PyCFunction)py_nbtd_information_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.nbtd_information.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_information_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_information_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_information_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_information_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_information_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_information_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbtd_information_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.nbtd_information",
	.tp_getset = py_nbtd_information_getsetters,
	.tp_methods = py_nbtd_information_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbtd_information_new,
};

static bool pack_py_nbtd_information_args_in(PyObject *args, PyObject *kwargs, struct nbtd_information *r)
{
	PyObject *py_level;
	const char *kwnames[] = {
		"level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:nbtd_information", discard_const_p(char *, kwnames), &py_level)) {
		return false;
	}

	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_nbtd_information_args_out(struct nbtd_information *r, bool raise_result_exception)
{
	PyObject *py_info = NULL;
	PyObject *result = NULL;

	py_info = pyrpc_import_union(&nbtd_info_Type, r, r->in.level, &r->out.info, "union nbtd_info");
	if (py_info == NULL) {
		return NULL;
	}
	result = py_info;

	return result;
}


static PyObject *py_nbtd_getdcname_in_get_domainname(PyObject *obj, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(obj);
	PyObject *py_domainname;
	py_domainname = PyString_FromStringOrNULL(object->in.domainname);
	return py_domainname;
}

static int py_nbtd_getdcname_in_set_domainname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domainname");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.domainname = talloc_str;
	}
	return 0;
}

static PyObject *py_nbtd_getdcname_in_get_ip_address(PyObject *obj, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(obj);
	PyObject *py_ip_address;
	py_ip_address = PyString_FromStringOrNULL(object->in.ip_address);
	return py_ip_address;
}

static int py_nbtd_getdcname_in_set_ip_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.ip_address");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.ip_address = talloc_str;
	}
	return 0;
}

static PyObject *py_nbtd_getdcname_in_get_my_computername(PyObject *obj, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(obj);
	PyObject *py_my_computername;
	py_my_computername = PyString_FromStringOrNULL(object->in.my_computername);
	return py_my_computername;
}

static int py_nbtd_getdcname_in_set_my_computername(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.my_computername");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.my_computername = talloc_str;
	}
	return 0;
}

static PyObject *py_nbtd_getdcname_in_get_my_accountname(PyObject *obj, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(obj);
	PyObject *py_my_accountname;
	py_my_accountname = PyString_FromStringOrNULL(object->in.my_accountname);
	return py_my_accountname;
}

static int py_nbtd_getdcname_in_set_my_accountname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.my_accountname");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.my_accountname = talloc_str;
	}
	return 0;
}

static PyObject *py_nbtd_getdcname_in_get_account_control(PyObject *obj, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(obj);
	PyObject *py_account_control;
	py_account_control = PyLong_FromUnsignedLongLong((uint32_t)(object->in.account_control));
	return py_account_control;
}

static int py_nbtd_getdcname_in_set_account_control(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.account_control");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.account_control));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.account_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbtd_getdcname_in_get_domain_sid(PyObject *obj, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_sid;
	if (object->in.domain_sid == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_sid = pytalloc_reference_ex(dom_sid_Type, object->in.domain_sid, object->in.domain_sid);
	return py_domain_sid;
}

static int py_nbtd_getdcname_in_set_domain_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_sid");
		return -1;
	}
	object->in.domain_sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_sid);
	if (object->in.domain_sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_nbtd_getdcname_out_get_dcname(PyObject *obj, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(obj);
	PyObject *py_dcname;
	if (object->out.dcname == NULL) {
		Py_RETURN_NONE;
	}
	if (object->out.dcname == NULL) {
		py_dcname = Py_None;
		Py_INCREF(py_dcname);
	} else {
		py_dcname = PyString_FromStringOrNULL(object->out.dcname);
	}
	return py_dcname;
}

static int py_nbtd_getdcname_out_set_dcname(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_getdcname *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.dcname");
		return -1;
	}
	if (value == Py_None) {
		object->out.dcname = NULL;
	} else {
		object->out.dcname = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->out.dcname = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_nbtd_getdcname_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domainname"),
		.get = py_nbtd_getdcname_in_get_domainname,
		.set = py_nbtd_getdcname_in_set_domainname,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "in_ip_address"),
		.get = py_nbtd_getdcname_in_get_ip_address,
		.set = py_nbtd_getdcname_in_set_ip_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "in_my_computername"),
		.get = py_nbtd_getdcname_in_get_my_computername,
		.set = py_nbtd_getdcname_in_set_my_computername,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "in_my_accountname"),
		.get = py_nbtd_getdcname_in_get_my_accountname,
		.set = py_nbtd_getdcname_in_set_my_accountname,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{
		.name = discard_const_p(char, "in_account_control"),
		.get = py_nbtd_getdcname_in_get_account_control,
		.set = py_nbtd_getdcname_in_set_account_control,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_domain_sid"),
		.get = py_nbtd_getdcname_in_get_domain_sid,
		.set = py_nbtd_getdcname_in_set_domain_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "out_dcname"),
		.get = py_nbtd_getdcname_out_get_dcname,
		.set = py_nbtd_getdcname_out_set_dcname,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_nbtd_getdcname_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct nbtd_getdcname, type);
	struct nbtd_getdcname *_self = (struct nbtd_getdcname *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_sid = talloc_zero(mem_ctx, struct dom_sid);
	return self;
}

static PyObject *py_nbtd_getdcname_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_nbtd_getdcname_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_getdcname *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_getdcname_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_nbtd_getdcname_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_nbtd_getdcname_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_nbtd_getdcname_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_nbtd_getdcname_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_nbtd_getdcname_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_getdcname *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_getdcname_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_nbtd_getdcname_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_nbtd_getdcname_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_nbtd_getdcname_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_nbtd_getdcname_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_nbtd_getdcname_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_getdcname *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_getdcname_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_nbtd_getdcname_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_nbtd_getdcname_ndr_print(py_obj, args, kwargs, "nbtd_getdcname_in", NDR_IN);
}

static PyObject *py_nbtd_getdcname_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_nbtd_getdcname_ndr_print(py_obj, args, kwargs, "nbtd_getdcname_out", NDR_OUT);
}

static PyMethodDef py_nbtd_getdcname_methods[] = {
	{ "opnum", (PyCFunction)py_nbtd_getdcname_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.nbtd_getdcname.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_getdcname_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_getdcname_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_getdcname_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_getdcname_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_getdcname_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_getdcname_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbtd_getdcname_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.nbtd_getdcname",
	.tp_getset = py_nbtd_getdcname_getsetters,
	.tp_methods = py_nbtd_getdcname_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbtd_getdcname_new,
};

static bool pack_py_nbtd_getdcname_args_in(PyObject *args, PyObject *kwargs, struct nbtd_getdcname *r)
{
	PyObject *py_domainname;
	PyObject *py_ip_address;
	PyObject *py_my_computername;
	PyObject *py_my_accountname;
	PyObject *py_account_control;
	PyObject *py_domain_sid;
	const char *kwnames[] = {
		"domainname", "ip_address", "my_computername", "my_accountname", "account_control", "domain_sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:nbtd_getdcname", discard_const_p(char *, kwnames), &py_domainname, &py_ip_address, &py_my_computername, &py_my_accountname, &py_account_control, &py_domain_sid)) {
		return false;
	}

	if (py_domainname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domainname");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_domainname)) {
			unicode = PyUnicode_AsEncodedString(py_domainname, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_domainname)) {
			test_str = PyBytes_AS_STRING(py_domainname);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_domainname)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.domainname = talloc_str;
	}
	if (py_ip_address == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.ip_address");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_ip_address)) {
			unicode = PyUnicode_AsEncodedString(py_ip_address, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_ip_address)) {
			test_str = PyBytes_AS_STRING(py_ip_address);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_ip_address)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.ip_address = talloc_str;
	}
	if (py_my_computername == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.my_computername");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_my_computername)) {
			unicode = PyUnicode_AsEncodedString(py_my_computername, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_my_computername)) {
			test_str = PyBytes_AS_STRING(py_my_computername);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_my_computername)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.my_computername = talloc_str;
	}
	if (py_my_accountname == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.my_accountname");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_my_accountname)) {
			unicode = PyUnicode_AsEncodedString(py_my_accountname, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_my_accountname)) {
			test_str = PyBytes_AS_STRING(py_my_accountname);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_my_accountname)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.my_accountname = talloc_str;
	}
	if (py_account_control == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.account_control");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.account_control));
		if (PyLong_Check(py_account_control)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_account_control);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.account_control = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_domain_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_sid");
		return false;
	}
	r->in.domain_sid = talloc_ptrtype(r, r->in.domain_sid);
	if (r->in.domain_sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_domain_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_sid = (struct dom_sid *)pytalloc_get_ptr(py_domain_sid);
	return true;
}

static PyObject *unpack_py_nbtd_getdcname_args_out(struct nbtd_getdcname *r, bool raise_result_exception)
{
	PyObject *py_dcname = NULL;
	PyObject *result = NULL;

	if (r->out.dcname == NULL) {
		py_dcname = Py_None;
		Py_INCREF(py_dcname);
	} else {
		py_dcname = PyString_FromStringOrNULL(r->out.dcname);
	}
	result = py_dcname;

	return result;
}


static PyObject *py_nbtd_proxy_wins_challenge_in_get_name(PyObject *obj, void *closure)
{
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(nbt_name_Type, pytalloc_get_mem_ctx(obj), &object->in.name);
	return py_name;
}

static int py_nbtd_proxy_wins_challenge_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.name");
		return -1;
	}
	PY_CHECK_TYPE(nbt_name_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.name = *(struct nbt_name *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_nbtd_proxy_wins_challenge_in_get_num_addrs(PyObject *obj, void *closure)
{
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(obj);
	PyObject *py_num_addrs;
	py_num_addrs = PyLong_FromUnsignedLongLong((uint32_t)(object->in.num_addrs));
	return py_num_addrs;
}

static int py_nbtd_proxy_wins_challenge_in_set_num_addrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.num_addrs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.num_addrs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.num_addrs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbtd_proxy_wins_challenge_out_get_num_addrs(PyObject *obj, void *closure)
{
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(obj);
	PyObject *py_num_addrs;
	py_num_addrs = PyLong_FromUnsignedLongLong((uint32_t)(object->out.num_addrs));
	return py_num_addrs;
}

static int py_nbtd_proxy_wins_challenge_out_set_num_addrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.num_addrs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.num_addrs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.num_addrs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbtd_proxy_wins_challenge_in_get_addrs(PyObject *obj, void *closure)
{
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(obj);
	PyObject *py_addrs;
	py_addrs = PyList_New(object->in.num_addrs);
	if (py_addrs == NULL) {
		return NULL;
	}
	{
		int addrs_cntr_0;
		for (addrs_cntr_0 = 0; addrs_cntr_0 < (object->in.num_addrs); addrs_cntr_0++) {
			PyObject *py_addrs_0;
			py_addrs_0 = pytalloc_reference_ex(&nbtd_proxy_wins_addr_Type, object->in.addrs, &(object->in.addrs)[addrs_cntr_0]);
			PyList_SetItem(py_addrs, addrs_cntr_0, py_addrs_0);
		}
	}
	return py_addrs;
}

static int py_nbtd_proxy_wins_challenge_in_set_addrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.addrs");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int addrs_cntr_0;
		object->in.addrs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.addrs, PyList_GET_SIZE(value));
		if (!object->in.addrs) { return -1; }
		talloc_set_name_const(object->in.addrs, "ARRAY: object->in.addrs");
		for (addrs_cntr_0 = 0; addrs_cntr_0 < PyList_GET_SIZE(value); addrs_cntr_0++) {
			if (PyList_GET_ITEM(value, addrs_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.addrs)[addrs_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&nbtd_proxy_wins_addr_Type, PyList_GET_ITEM(value, addrs_cntr_0), return -1;);
			if (talloc_reference(object->in.addrs, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, addrs_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->in.addrs)[addrs_cntr_0] = *(struct nbtd_proxy_wins_addr *)pytalloc_get_ptr(PyList_GET_ITEM(value, addrs_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_nbtd_proxy_wins_challenge_out_get_addrs(PyObject *obj, void *closure)
{
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(obj);
	PyObject *py_addrs;
	py_addrs = PyList_New(object->out.num_addrs);
	if (py_addrs == NULL) {
		return NULL;
	}
	{
		int addrs_cntr_0;
		for (addrs_cntr_0 = 0; addrs_cntr_0 < (object->out.num_addrs); addrs_cntr_0++) {
			PyObject *py_addrs_0;
			py_addrs_0 = pytalloc_reference_ex(&nbtd_proxy_wins_addr_Type, object->out.addrs, &(object->out.addrs)[addrs_cntr_0]);
			PyList_SetItem(py_addrs, addrs_cntr_0, py_addrs_0);
		}
	}
	return py_addrs;
}

static int py_nbtd_proxy_wins_challenge_out_set_addrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.addrs");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int addrs_cntr_0;
		object->out.addrs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.addrs, PyList_GET_SIZE(value));
		if (!object->out.addrs) { return -1; }
		talloc_set_name_const(object->out.addrs, "ARRAY: object->out.addrs");
		for (addrs_cntr_0 = 0; addrs_cntr_0 < PyList_GET_SIZE(value); addrs_cntr_0++) {
			if (PyList_GET_ITEM(value, addrs_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->out.addrs)[addrs_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&nbtd_proxy_wins_addr_Type, PyList_GET_ITEM(value, addrs_cntr_0), return -1;);
			if (talloc_reference(object->out.addrs, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, addrs_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->out.addrs)[addrs_cntr_0] = *(struct nbtd_proxy_wins_addr *)pytalloc_get_ptr(PyList_GET_ITEM(value, addrs_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_nbtd_proxy_wins_challenge_getsetters[] = {
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_nbtd_proxy_wins_challenge_in_get_name,
		.set = py_nbtd_proxy_wins_challenge_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_name")
	},
	{
		.name = discard_const_p(char, "in_num_addrs"),
		.get = py_nbtd_proxy_wins_challenge_in_get_num_addrs,
		.set = py_nbtd_proxy_wins_challenge_in_set_num_addrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_num_addrs"),
		.get = py_nbtd_proxy_wins_challenge_out_get_num_addrs,
		.set = py_nbtd_proxy_wins_challenge_out_set_num_addrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_addrs"),
		.get = py_nbtd_proxy_wins_challenge_in_get_addrs,
		.set = py_nbtd_proxy_wins_challenge_in_set_addrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbtd_proxy_wins_addr")
	},
	{
		.name = discard_const_p(char, "out_addrs"),
		.get = py_nbtd_proxy_wins_challenge_out_get_addrs,
		.set = py_nbtd_proxy_wins_challenge_out_set_addrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbtd_proxy_wins_addr")
	},
	{ .name = NULL }
};

static PyObject *py_nbtd_proxy_wins_challenge_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct nbtd_proxy_wins_challenge, type);
	return self;
}

static PyObject *py_nbtd_proxy_wins_challenge_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_nbtd_proxy_wins_challenge_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_proxy_wins_challenge_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_nbtd_proxy_wins_challenge_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_nbtd_proxy_wins_challenge_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_nbtd_proxy_wins_challenge_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_nbtd_proxy_wins_challenge_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_nbtd_proxy_wins_challenge_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_proxy_wins_challenge_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_nbtd_proxy_wins_challenge_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_nbtd_proxy_wins_challenge_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_nbtd_proxy_wins_challenge_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_nbtd_proxy_wins_challenge_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_nbtd_proxy_wins_challenge_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_proxy_wins_challenge *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_proxy_wins_challenge_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[3];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_nbtd_proxy_wins_challenge_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_nbtd_proxy_wins_challenge_ndr_print(py_obj, args, kwargs, "nbtd_proxy_wins_challenge_in", NDR_IN);
}

static PyObject *py_nbtd_proxy_wins_challenge_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_nbtd_proxy_wins_challenge_ndr_print(py_obj, args, kwargs, "nbtd_proxy_wins_challenge_out", NDR_OUT);
}

static PyMethodDef py_nbtd_proxy_wins_challenge_methods[] = {
	{ "opnum", (PyCFunction)py_nbtd_proxy_wins_challenge_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.nbtd_proxy_wins_challenge.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_challenge_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_challenge_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_challenge_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_challenge_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_challenge_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_challenge_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbtd_proxy_wins_challenge_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.nbtd_proxy_wins_challenge",
	.tp_getset = py_nbtd_proxy_wins_challenge_getsetters,
	.tp_methods = py_nbtd_proxy_wins_challenge_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbtd_proxy_wins_challenge_new,
};

static bool pack_py_nbtd_proxy_wins_challenge_args_in(PyObject *args, PyObject *kwargs, struct nbtd_proxy_wins_challenge *r)
{
	PyObject *py_name;
	PyObject *py_num_addrs;
	PyObject *py_addrs;
	const char *kwnames[] = {
		"name", "num_addrs", "addrs", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:nbtd_proxy_wins_challenge", discard_const_p(char *, kwnames), &py_name, &py_num_addrs, &py_addrs)) {
		return false;
	}

	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.name");
		return false;
	}
	PY_CHECK_TYPE(nbt_name_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = *(struct nbt_name *)pytalloc_get_ptr(py_name);
	if (py_num_addrs == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.num_addrs");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.num_addrs));
		if (PyLong_Check(py_num_addrs)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_num_addrs);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.num_addrs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_addrs == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.addrs");
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_addrs, return false;);
	{
		int addrs_cntr_0;
		r->in.addrs = talloc_array_ptrtype(r, r->in.addrs, PyList_GET_SIZE(py_addrs));
		if (!r->in.addrs) { return false; }
		talloc_set_name_const(r->in.addrs, "ARRAY: r->in.addrs");
		for (addrs_cntr_0 = 0; addrs_cntr_0 < PyList_GET_SIZE(py_addrs); addrs_cntr_0++) {
			if (PyList_GET_ITEM(py_addrs, addrs_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.addrs)[addrs_cntr_0]");
				return false;
			}
			PY_CHECK_TYPE(&nbtd_proxy_wins_addr_Type, PyList_GET_ITEM(py_addrs, addrs_cntr_0), return false;);
			if (talloc_reference(r->in.addrs, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_addrs, addrs_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			(r->in.addrs)[addrs_cntr_0] = *(struct nbtd_proxy_wins_addr *)pytalloc_get_ptr(PyList_GET_ITEM(py_addrs, addrs_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_nbtd_proxy_wins_challenge_args_out(struct nbtd_proxy_wins_challenge *r, bool raise_result_exception)
{
	PyObject *py_num_addrs = NULL;
	PyObject *py_addrs = NULL;
	PyObject *result = NULL;

	result = PyTuple_New(2);
	if (result == NULL) {
		return NULL;
	}

	py_num_addrs = PyLong_FromUnsignedLongLong((uint32_t)(r->out.num_addrs));
	PyTuple_SetItem(result, 0, py_num_addrs);

	py_addrs = PyList_New(r->out.num_addrs);
	if (py_addrs == NULL) {
		return NULL;
	}
	{
		int addrs_cntr_0;
		for (addrs_cntr_0 = 0; addrs_cntr_0 < (r->out.num_addrs); addrs_cntr_0++) {
			PyObject *py_addrs_0;
			py_addrs_0 = pytalloc_reference_ex(&nbtd_proxy_wins_addr_Type, r->out.addrs, &(r->out.addrs)[addrs_cntr_0]);
			PyList_SetItem(py_addrs, addrs_cntr_0, py_addrs_0);
		}
	}
	PyTuple_SetItem(result, 1, py_addrs);

	return result;
}


static PyObject *py_nbtd_proxy_wins_release_demand_in_get_name(PyObject *obj, void *closure)
{
	struct nbtd_proxy_wins_release_demand *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(nbt_name_Type, pytalloc_get_mem_ctx(obj), &object->in.name);
	return py_name;
}

static int py_nbtd_proxy_wins_release_demand_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_proxy_wins_release_demand *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.name");
		return -1;
	}
	PY_CHECK_TYPE(nbt_name_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.name = *(struct nbt_name *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_nbtd_proxy_wins_release_demand_in_get_num_addrs(PyObject *obj, void *closure)
{
	struct nbtd_proxy_wins_release_demand *object = pytalloc_get_ptr(obj);
	PyObject *py_num_addrs;
	py_num_addrs = PyLong_FromUnsignedLongLong((uint32_t)(object->in.num_addrs));
	return py_num_addrs;
}

static int py_nbtd_proxy_wins_release_demand_in_set_num_addrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_proxy_wins_release_demand *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.num_addrs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.num_addrs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.num_addrs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_nbtd_proxy_wins_release_demand_in_get_addrs(PyObject *obj, void *closure)
{
	struct nbtd_proxy_wins_release_demand *object = pytalloc_get_ptr(obj);
	PyObject *py_addrs;
	py_addrs = PyList_New(object->in.num_addrs);
	if (py_addrs == NULL) {
		return NULL;
	}
	{
		int addrs_cntr_0;
		for (addrs_cntr_0 = 0; addrs_cntr_0 < (object->in.num_addrs); addrs_cntr_0++) {
			PyObject *py_addrs_0;
			py_addrs_0 = pytalloc_reference_ex(&nbtd_proxy_wins_addr_Type, object->in.addrs, &(object->in.addrs)[addrs_cntr_0]);
			PyList_SetItem(py_addrs, addrs_cntr_0, py_addrs_0);
		}
	}
	return py_addrs;
}

static int py_nbtd_proxy_wins_release_demand_in_set_addrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct nbtd_proxy_wins_release_demand *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.addrs");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int addrs_cntr_0;
		object->in.addrs = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.addrs, PyList_GET_SIZE(value));
		if (!object->in.addrs) { return -1; }
		talloc_set_name_const(object->in.addrs, "ARRAY: object->in.addrs");
		for (addrs_cntr_0 = 0; addrs_cntr_0 < PyList_GET_SIZE(value); addrs_cntr_0++) {
			if (PyList_GET_ITEM(value, addrs_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.addrs)[addrs_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&nbtd_proxy_wins_addr_Type, PyList_GET_ITEM(value, addrs_cntr_0), return -1;);
			if (talloc_reference(object->in.addrs, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, addrs_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->in.addrs)[addrs_cntr_0] = *(struct nbtd_proxy_wins_addr *)pytalloc_get_ptr(PyList_GET_ITEM(value, addrs_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_nbtd_proxy_wins_release_demand_getsetters[] = {
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_nbtd_proxy_wins_release_demand_in_get_name,
		.set = py_nbtd_proxy_wins_release_demand_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbt_name")
	},
	{
		.name = discard_const_p(char, "in_num_addrs"),
		.get = py_nbtd_proxy_wins_release_demand_in_get_num_addrs,
		.set = py_nbtd_proxy_wins_release_demand_in_set_num_addrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_addrs"),
		.get = py_nbtd_proxy_wins_release_demand_in_get_addrs,
		.set = py_nbtd_proxy_wins_release_demand_in_set_addrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type nbtd_proxy_wins_addr")
	},
	{ .name = NULL }
};

static PyObject *py_nbtd_proxy_wins_release_demand_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct nbtd_proxy_wins_release_demand, type);
	return self;
}

static PyObject *py_nbtd_proxy_wins_release_demand_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_nbtd_proxy_wins_release_demand_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_proxy_wins_release_demand *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_proxy_wins_release_demand_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_nbtd_proxy_wins_release_demand_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_nbtd_proxy_wins_release_demand_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_nbtd_proxy_wins_release_demand_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_nbtd_proxy_wins_release_demand_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_nbtd_proxy_wins_release_demand_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_proxy_wins_release_demand *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_proxy_wins_release_demand_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_nbtd_proxy_wins_release_demand_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_nbtd_proxy_wins_release_demand_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_nbtd_proxy_wins_release_demand_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_nbtd_proxy_wins_release_demand_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_nbtd_proxy_wins_release_demand_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct nbtd_proxy_wins_release_demand *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_nbtd_proxy_wins_release_demand_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[4];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_nbtd_proxy_wins_release_demand_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_nbtd_proxy_wins_release_demand_ndr_print(py_obj, args, kwargs, "nbtd_proxy_wins_release_demand_in", NDR_IN);
}

static PyObject *py_nbtd_proxy_wins_release_demand_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_nbtd_proxy_wins_release_demand_ndr_print(py_obj, args, kwargs, "nbtd_proxy_wins_release_demand_out", NDR_OUT);
}

static PyMethodDef py_nbtd_proxy_wins_release_demand_methods[] = {
	{ "opnum", (PyCFunction)py_nbtd_proxy_wins_release_demand_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.nbtd_proxy_wins_release_demand.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_release_demand_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_release_demand_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_release_demand_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_release_demand_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_release_demand_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_nbtd_proxy_wins_release_demand_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject nbtd_proxy_wins_release_demand_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.nbtd_proxy_wins_release_demand",
	.tp_getset = py_nbtd_proxy_wins_release_demand_getsetters,
	.tp_methods = py_nbtd_proxy_wins_release_demand_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_nbtd_proxy_wins_release_demand_new,
};

static bool pack_py_nbtd_proxy_wins_release_demand_args_in(PyObject *args, PyObject *kwargs, struct nbtd_proxy_wins_release_demand *r)
{
	PyObject *py_name;
	PyObject *py_num_addrs;
	PyObject *py_addrs;
	const char *kwnames[] = {
		"name", "num_addrs", "addrs", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:nbtd_proxy_wins_release_demand", discard_const_p(char *, kwnames), &py_name, &py_num_addrs, &py_addrs)) {
		return false;
	}

	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.name");
		return false;
	}
	PY_CHECK_TYPE(nbt_name_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = *(struct nbt_name *)pytalloc_get_ptr(py_name);
	if (py_num_addrs == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.num_addrs");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.num_addrs));
		if (PyLong_Check(py_num_addrs)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_num_addrs);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.num_addrs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_addrs == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.addrs");
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_addrs, return false;);
	{
		int addrs_cntr_0;
		r->in.addrs = talloc_array_ptrtype(r, r->in.addrs, PyList_GET_SIZE(py_addrs));
		if (!r->in.addrs) { return false; }
		talloc_set_name_const(r->in.addrs, "ARRAY: r->in.addrs");
		for (addrs_cntr_0 = 0; addrs_cntr_0 < PyList_GET_SIZE(py_addrs); addrs_cntr_0++) {
			if (PyList_GET_ITEM(py_addrs, addrs_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.addrs)[addrs_cntr_0]");
				return false;
			}
			PY_CHECK_TYPE(&nbtd_proxy_wins_addr_Type, PyList_GET_ITEM(py_addrs, addrs_cntr_0), return false;);
			if (talloc_reference(r->in.addrs, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_addrs, addrs_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			(r->in.addrs)[addrs_cntr_0] = *(struct nbtd_proxy_wins_addr *)pytalloc_get_ptr(PyList_GET_ITEM(py_addrs, addrs_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_nbtd_proxy_wins_release_demand_args_out(struct nbtd_proxy_wins_release_demand *r, bool raise_result_exception)
{
	PyObject *result = NULL;

	result = Py_None;
	Py_INCREF(result);

	return result;
}


static PyObject *py_kdc_check_generic_kerberos_in_get_generic_request(PyObject *obj, void *closure)
{
	struct kdc_check_generic_kerberos *object = pytalloc_get_ptr(obj);
	PyObject *py_generic_request;
	py_generic_request = PyBytes_FromStringAndSize((char *)(object->in.generic_request).data, (object->in.generic_request).length);
	return py_generic_request;
}

static int py_kdc_check_generic_kerberos_in_set_generic_request(PyObject *py_obj, PyObject *value, void *closure)
{
	struct kdc_check_generic_kerberos *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.generic_request");
		return -1;
	}
	object->in.generic_request = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_kdc_check_generic_kerberos_out_get_generic_reply(PyObject *obj, void *closure)
{
	struct kdc_check_generic_kerberos *object = pytalloc_get_ptr(obj);
	PyObject *py_generic_reply;
	py_generic_reply = PyBytes_FromStringAndSize((char *)(object->out.generic_reply).data, (object->out.generic_reply).length);
	return py_generic_reply;
}

static int py_kdc_check_generic_kerberos_out_set_generic_reply(PyObject *py_obj, PyObject *value, void *closure)
{
	struct kdc_check_generic_kerberos *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.generic_reply");
		return -1;
	}
	object->out.generic_reply = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_kdc_check_generic_kerberos_getsetters[] = {
	{
		.name = discard_const_p(char, "in_generic_request"),
		.get = py_kdc_check_generic_kerberos_in_get_generic_request,
		.set = py_kdc_check_generic_kerberos_in_set_generic_request,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "out_generic_reply"),
		.get = py_kdc_check_generic_kerberos_out_get_generic_reply,
		.set = py_kdc_check_generic_kerberos_out_set_generic_reply,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_kdc_check_generic_kerberos_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct kdc_check_generic_kerberos, type);
	return self;
}

static PyObject *py_kdc_check_generic_kerberos_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(5);
}

static PyObject *py_kdc_check_generic_kerberos_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct kdc_check_generic_kerberos *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_kdc_check_generic_kerberos_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[5];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_kdc_check_generic_kerberos_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_kdc_check_generic_kerberos_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_kdc_check_generic_kerberos_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_kdc_check_generic_kerberos_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_kdc_check_generic_kerberos_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct kdc_check_generic_kerberos *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_kdc_check_generic_kerberos_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[5];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_kdc_check_generic_kerberos_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_kdc_check_generic_kerberos_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_kdc_check_generic_kerberos_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_kdc_check_generic_kerberos_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_kdc_check_generic_kerberos_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct kdc_check_generic_kerberos *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_kdc_check_generic_kerberos_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[5];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_kdc_check_generic_kerberos_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_kdc_check_generic_kerberos_ndr_print(py_obj, args, kwargs, "kdc_check_generic_kerberos_in", NDR_IN);
}

static PyObject *py_kdc_check_generic_kerberos_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_kdc_check_generic_kerberos_ndr_print(py_obj, args, kwargs, "kdc_check_generic_kerberos_out", NDR_OUT);
}

static PyMethodDef py_kdc_check_generic_kerberos_methods[] = {
	{ "opnum", (PyCFunction)py_kdc_check_generic_kerberos_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.kdc_check_generic_kerberos.opnum() -> 5 (0x05) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_kdc_check_generic_kerberos_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_kdc_check_generic_kerberos_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_kdc_check_generic_kerberos_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_kdc_check_generic_kerberos_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_kdc_check_generic_kerberos_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_kdc_check_generic_kerberos_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject kdc_check_generic_kerberos_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.kdc_check_generic_kerberos",
	.tp_getset = py_kdc_check_generic_kerberos_getsetters,
	.tp_methods = py_kdc_check_generic_kerberos_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_kdc_check_generic_kerberos_new,
};

static bool pack_py_kdc_check_generic_kerberos_args_in(PyObject *args, PyObject *kwargs, struct kdc_check_generic_kerberos *r)
{
	PyObject *py_generic_request;
	const char *kwnames[] = {
		"generic_request", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:kdc_check_generic_kerberos", discard_const_p(char *, kwnames), &py_generic_request)) {
		return false;
	}

	if (py_generic_request == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.generic_request");
		return false;
	}
	r->in.generic_request = data_blob_talloc(r, PyBytes_AS_STRING(py_generic_request), PyBytes_GET_SIZE(py_generic_request));
	return true;
}

static PyObject *unpack_py_kdc_check_generic_kerberos_args_out(struct kdc_check_generic_kerberos *r, bool raise_result_exception)
{
	PyObject *py_generic_reply = NULL;
	PyObject *result = NULL;

	py_generic_reply = PyBytes_FromStringAndSize((char *)(r->out.generic_reply).data, (r->out.generic_reply).length);
	result = py_generic_reply;

	return result;
}


static PyObject *py_smbsrv_information_in_get_level(PyObject *obj, void *closure)
{
	struct smbsrv_information *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromUnsignedLongLong((uint32_t)(object->in.level));
	return py_level;
}

static int py_smbsrv_information_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_smbsrv_information_out_get_info(PyObject *obj, void *closure)
{
	struct smbsrv_information *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pyrpc_import_union(&smbsrv_info_Type, pytalloc_get_mem_ctx(obj), object->in.level, &object->out.info, "union smbsrv_info");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_smbsrv_information_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct smbsrv_information *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.info");
		return -1;
	}
	{
		union smbsrv_info *info_switch_0;
		info_switch_0 = (union smbsrv_info *)pyrpc_export_union(&smbsrv_info_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union smbsrv_info");
		if (info_switch_0 == NULL) {
			return -1;
		}
		object->out.info = *info_switch_0;
	}
	return 0;
}

static PyGetSetDef py_smbsrv_information_getsetters[] = {
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_smbsrv_information_in_get_level,
		.set = py_smbsrv_information_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbsrv_info_level")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_smbsrv_information_out_get_info,
		.set = py_smbsrv_information_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type smbsrv_info")
	},
	{ .name = NULL }
};

static PyObject *py_smbsrv_information_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct smbsrv_information, type);
	return self;
}

static PyObject *py_smbsrv_information_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(6);
}

static PyObject *py_smbsrv_information_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct smbsrv_information *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_smbsrv_information_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[6];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_smbsrv_information_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_smbsrv_information_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_smbsrv_information_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_smbsrv_information_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_smbsrv_information_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct smbsrv_information *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_smbsrv_information_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[6];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_smbsrv_information_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_smbsrv_information_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_smbsrv_information_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_smbsrv_information_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_smbsrv_information_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct smbsrv_information *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_smbsrv_information_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[6];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_smbsrv_information_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_smbsrv_information_ndr_print(py_obj, args, kwargs, "smbsrv_information_in", NDR_IN);
}

static PyObject *py_smbsrv_information_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_smbsrv_information_ndr_print(py_obj, args, kwargs, "smbsrv_information_out", NDR_OUT);
}

static PyMethodDef py_smbsrv_information_methods[] = {
	{ "opnum", (PyCFunction)py_smbsrv_information_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.smbsrv_information.opnum() -> 6 (0x06) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbsrv_information_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbsrv_information_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbsrv_information_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbsrv_information_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbsrv_information_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_smbsrv_information_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject smbsrv_information_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.smbsrv_information",
	.tp_getset = py_smbsrv_information_getsetters,
	.tp_methods = py_smbsrv_information_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_smbsrv_information_new,
};

static bool pack_py_smbsrv_information_args_in(PyObject *args, PyObject *kwargs, struct smbsrv_information *r)
{
	PyObject *py_level;
	const char *kwnames[] = {
		"level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:smbsrv_information", discard_const_p(char *, kwnames), &py_level)) {
		return false;
	}

	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_smbsrv_information_args_out(struct smbsrv_information *r, bool raise_result_exception)
{
	PyObject *py_info = NULL;
	PyObject *result = NULL;

	py_info = pyrpc_import_union(&smbsrv_info_Type, r, r->in.level, &r->out.info, "union smbsrv_info");
	if (py_info == NULL) {
		return NULL;
	}
	result = py_info;

	return result;
}


static PyObject *py_samba_terminate_in_get_reason(PyObject *obj, void *closure)
{
	struct samba_terminate *object = pytalloc_get_ptr(obj);
	PyObject *py_reason;
	py_reason = PyString_FromStringOrNULL(object->in.reason);
	return py_reason;
}

static int py_samba_terminate_in_set_reason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samba_terminate *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.reason");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.reason = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_samba_terminate_getsetters[] = {
	{
		.name = discard_const_p(char, "in_reason"),
		.get = py_samba_terminate_in_get_reason,
		.set = py_samba_terminate_in_set_reason,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_samba_terminate_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samba_terminate, type);
	return self;
}

static PyObject *py_samba_terminate_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(7);
}

static PyObject *py_samba_terminate_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samba_terminate *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samba_terminate_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[7];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samba_terminate_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samba_terminate_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samba_terminate_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samba_terminate_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samba_terminate_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samba_terminate *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samba_terminate_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[7];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samba_terminate_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samba_terminate_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samba_terminate_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samba_terminate_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samba_terminate_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samba_terminate *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samba_terminate_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[7];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samba_terminate_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samba_terminate_ndr_print(py_obj, args, kwargs, "samba_terminate_in", NDR_IN);
}

static PyObject *py_samba_terminate_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samba_terminate_ndr_print(py_obj, args, kwargs, "samba_terminate_out", NDR_OUT);
}

static PyMethodDef py_samba_terminate_methods[] = {
	{ "opnum", (PyCFunction)py_samba_terminate_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.samba_terminate.opnum() -> 7 (0x07) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samba_terminate_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samba_terminate_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samba_terminate_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samba_terminate_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samba_terminate_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samba_terminate_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samba_terminate_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.samba_terminate",
	.tp_getset = py_samba_terminate_getsetters,
	.tp_methods = py_samba_terminate_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samba_terminate_new,
};

static bool pack_py_samba_terminate_args_in(PyObject *args, PyObject *kwargs, struct samba_terminate *r)
{
	PyObject *py_reason;
	const char *kwnames[] = {
		"reason", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:samba_terminate", discard_const_p(char *, kwnames), &py_reason)) {
		return false;
	}

	if (py_reason == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.reason");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_reason)) {
			unicode = PyUnicode_AsEncodedString(py_reason, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_reason)) {
			test_str = PyBytes_AS_STRING(py_reason);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_reason)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.reason = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_samba_terminate_args_out(struct samba_terminate *r, bool raise_result_exception)
{
	PyObject *result = NULL;

	result = Py_None;
	Py_INCREF(result);

	return result;
}


static PyObject *py_dreplsrv_refresh_get_result(PyObject *obj, void *closure)
{
	struct dreplsrv_refresh *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_dreplsrv_refresh_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dreplsrv_refresh *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_dreplsrv_refresh_getsetters[] = {
	{
		.name = discard_const_p(char, "result"),
		.get = py_dreplsrv_refresh_get_result,
		.set = py_dreplsrv_refresh_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_dreplsrv_refresh_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct dreplsrv_refresh, type);
	return self;
}

static PyObject *py_dreplsrv_refresh_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(8);
}

static PyObject *py_dreplsrv_refresh_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct dreplsrv_refresh *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_dreplsrv_refresh_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[8];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_dreplsrv_refresh_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_dreplsrv_refresh_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_dreplsrv_refresh_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_dreplsrv_refresh_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_dreplsrv_refresh_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct dreplsrv_refresh *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_dreplsrv_refresh_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[8];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_dreplsrv_refresh_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_dreplsrv_refresh_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_dreplsrv_refresh_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_dreplsrv_refresh_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_dreplsrv_refresh_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct dreplsrv_refresh *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_dreplsrv_refresh_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[8];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_dreplsrv_refresh_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_dreplsrv_refresh_ndr_print(py_obj, args, kwargs, "dreplsrv_refresh_in", NDR_IN);
}

static PyObject *py_dreplsrv_refresh_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_dreplsrv_refresh_ndr_print(py_obj, args, kwargs, "dreplsrv_refresh_out", NDR_OUT);
}

static PyMethodDef py_dreplsrv_refresh_methods[] = {
	{ "opnum", (PyCFunction)py_dreplsrv_refresh_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.dreplsrv_refresh.opnum() -> 8 (0x08) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dreplsrv_refresh_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dreplsrv_refresh_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dreplsrv_refresh_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dreplsrv_refresh_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dreplsrv_refresh_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dreplsrv_refresh_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dreplsrv_refresh_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.dreplsrv_refresh",
	.tp_getset = py_dreplsrv_refresh_getsetters,
	.tp_methods = py_dreplsrv_refresh_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dreplsrv_refresh_new,
};

static bool pack_py_dreplsrv_refresh_args_in(PyObject *args, PyObject *kwargs, struct dreplsrv_refresh *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":dreplsrv_refresh", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_dreplsrv_refresh_args_out(struct dreplsrv_refresh *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_drepl_takeFSMORole_in_get_role(PyObject *obj, void *closure)
{
	struct drepl_takeFSMORole *object = pytalloc_get_ptr(obj);
	PyObject *py_role;
	py_role = PyLong_FromUnsignedLongLong((uint32_t)(object->in.role));
	return py_role;
}

static int py_drepl_takeFSMORole_in_set_role(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drepl_takeFSMORole *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.role");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.role));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.role = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_drepl_takeFSMORole_get_result(PyObject *obj, void *closure)
{
	struct drepl_takeFSMORole *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_drepl_takeFSMORole_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drepl_takeFSMORole *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_drepl_takeFSMORole_getsetters[] = {
	{
		.name = discard_const_p(char, "in_role"),
		.get = py_drepl_takeFSMORole_in_get_role,
		.set = py_drepl_takeFSMORole_in_set_role,
		.doc = discard_const_p(char, "PIDL-generated element of base type drepl_role_master")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_drepl_takeFSMORole_get_result,
		.set = py_drepl_takeFSMORole_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_drepl_takeFSMORole_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct drepl_takeFSMORole, type);
	return self;
}

static PyObject *py_drepl_takeFSMORole_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(9);
}

static PyObject *py_drepl_takeFSMORole_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct drepl_takeFSMORole *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_drepl_takeFSMORole_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[9];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_drepl_takeFSMORole_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_drepl_takeFSMORole_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_drepl_takeFSMORole_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_drepl_takeFSMORole_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_drepl_takeFSMORole_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct drepl_takeFSMORole *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_drepl_takeFSMORole_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[9];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_drepl_takeFSMORole_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_drepl_takeFSMORole_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_drepl_takeFSMORole_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_drepl_takeFSMORole_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_drepl_takeFSMORole_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct drepl_takeFSMORole *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_drepl_takeFSMORole_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[9];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_drepl_takeFSMORole_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_drepl_takeFSMORole_ndr_print(py_obj, args, kwargs, "drepl_takeFSMORole_in", NDR_IN);
}

static PyObject *py_drepl_takeFSMORole_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_drepl_takeFSMORole_ndr_print(py_obj, args, kwargs, "drepl_takeFSMORole_out", NDR_OUT);
}

static PyMethodDef py_drepl_takeFSMORole_methods[] = {
	{ "opnum", (PyCFunction)py_drepl_takeFSMORole_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.drepl_takeFSMORole.opnum() -> 9 (0x09) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_takeFSMORole_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_takeFSMORole_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_takeFSMORole_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_takeFSMORole_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_takeFSMORole_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_takeFSMORole_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drepl_takeFSMORole_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.drepl_takeFSMORole",
	.tp_getset = py_drepl_takeFSMORole_getsetters,
	.tp_methods = py_drepl_takeFSMORole_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drepl_takeFSMORole_new,
};

static bool pack_py_drepl_takeFSMORole_args_in(PyObject *args, PyObject *kwargs, struct drepl_takeFSMORole *r)
{
	PyObject *py_role;
	const char *kwnames[] = {
		"role", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:drepl_takeFSMORole", discard_const_p(char *, kwnames), &py_role)) {
		return false;
	}

	if (py_role == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.role");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.role));
		if (PyLong_Check(py_role)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_role);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.role = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_drepl_takeFSMORole_args_out(struct drepl_takeFSMORole *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_drepl_trigger_repl_secret_in_get_user_dn(PyObject *obj, void *closure)
{
	struct drepl_trigger_repl_secret *object = pytalloc_get_ptr(obj);
	PyObject *py_user_dn;
	py_user_dn = PyString_FromStringOrNULL(object->in.user_dn);
	return py_user_dn;
}

static int py_drepl_trigger_repl_secret_in_set_user_dn(PyObject *py_obj, PyObject *value, void *closure)
{
	struct drepl_trigger_repl_secret *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.user_dn");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.user_dn = talloc_str;
	}
	return 0;
}

static PyGetSetDef py_drepl_trigger_repl_secret_getsetters[] = {
	{
		.name = discard_const_p(char, "in_user_dn"),
		.get = py_drepl_trigger_repl_secret_in_get_user_dn,
		.set = py_drepl_trigger_repl_secret_in_set_user_dn,
		.doc = discard_const_p(char, "PIDL-generated element of base type string")
	},
	{ .name = NULL }
};

static PyObject *py_drepl_trigger_repl_secret_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct drepl_trigger_repl_secret, type);
	return self;
}

static PyObject *py_drepl_trigger_repl_secret_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(10);
}

static PyObject *py_drepl_trigger_repl_secret_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct drepl_trigger_repl_secret *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_drepl_trigger_repl_secret_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[10];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_drepl_trigger_repl_secret_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_drepl_trigger_repl_secret_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_drepl_trigger_repl_secret_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_drepl_trigger_repl_secret_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_drepl_trigger_repl_secret_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct drepl_trigger_repl_secret *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_drepl_trigger_repl_secret_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[10];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_drepl_trigger_repl_secret_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_drepl_trigger_repl_secret_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_drepl_trigger_repl_secret_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_drepl_trigger_repl_secret_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_drepl_trigger_repl_secret_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct drepl_trigger_repl_secret *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_drepl_trigger_repl_secret_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[10];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_drepl_trigger_repl_secret_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_drepl_trigger_repl_secret_ndr_print(py_obj, args, kwargs, "drepl_trigger_repl_secret_in", NDR_IN);
}

static PyObject *py_drepl_trigger_repl_secret_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_drepl_trigger_repl_secret_ndr_print(py_obj, args, kwargs, "drepl_trigger_repl_secret_out", NDR_OUT);
}

static PyMethodDef py_drepl_trigger_repl_secret_methods[] = {
	{ "opnum", (PyCFunction)py_drepl_trigger_repl_secret_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.drepl_trigger_repl_secret.opnum() -> 10 (0x0a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_trigger_repl_secret_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_trigger_repl_secret_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_trigger_repl_secret_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_trigger_repl_secret_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_trigger_repl_secret_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_drepl_trigger_repl_secret_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject drepl_trigger_repl_secret_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.drepl_trigger_repl_secret",
	.tp_getset = py_drepl_trigger_repl_secret_getsetters,
	.tp_methods = py_drepl_trigger_repl_secret_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_drepl_trigger_repl_secret_new,
};

static bool pack_py_drepl_trigger_repl_secret_args_in(PyObject *args, PyObject *kwargs, struct drepl_trigger_repl_secret *r)
{
	PyObject *py_user_dn;
	const char *kwnames[] = {
		"user_dn", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:drepl_trigger_repl_secret", discard_const_p(char *, kwnames), &py_user_dn)) {
		return false;
	}

	if (py_user_dn == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.user_dn");
		return false;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(py_user_dn)) {
			unicode = PyUnicode_AsEncodedString(py_user_dn, "utf-8", "ignore");
			if (unicode == NULL) {
				return false;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(py_user_dn)) {
			test_str = PyBytes_AS_STRING(py_user_dn);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_user_dn)->tp_name);
			return false;
		}
		talloc_str = talloc_strdup(r, test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.user_dn = talloc_str;
	}
	return true;
}

static PyObject *unpack_py_drepl_trigger_repl_secret_args_out(struct drepl_trigger_repl_secret *r, bool raise_result_exception)
{
	PyObject *result = NULL;

	result = Py_None;
	Py_INCREF(result);

	return result;
}


static PyObject *py_dnsupdate_RODC_in_get_dom_sid(PyObject *obj, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(obj);
	PyObject *py_dom_sid;
	if (object->in.dom_sid == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.dom_sid == NULL) {
		py_dom_sid = Py_None;
		Py_INCREF(py_dom_sid);
	} else {
		py_dom_sid = pytalloc_reference_ex(dom_sid_Type, object->in.dom_sid, object->in.dom_sid);
	}
	return py_dom_sid;
}

static int py_dnsupdate_RODC_in_set_dom_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.dom_sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dom_sid");
		return -1;
	}
	if (value == Py_None) {
		object->in.dom_sid = NULL;
	} else {
		object->in.dom_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->in.dom_sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_dnsupdate_RODC_in_get_site_name(PyObject *obj, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(obj);
	PyObject *py_site_name;
	if (object->in.site_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.site_name == NULL) {
		py_site_name = Py_None;
		Py_INCREF(py_site_name);
	} else {
		if (object->in.site_name == NULL) {
			py_site_name = Py_None;
			Py_INCREF(py_site_name);
		} else {
			py_site_name = PyUnicode_Decode(object->in.site_name, strlen(object->in.site_name), "utf-8", "ignore");
		}
	}
	return py_site_name;
}

static int py_dnsupdate_RODC_in_set_site_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.site_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.site_name = NULL;
	} else {
		object->in.site_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->in.site_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_dnsupdate_RODC_in_get_dns_ttl(PyObject *obj, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_ttl;
	py_dns_ttl = PyLong_FromUnsignedLongLong((uint32_t)(object->in.dns_ttl));
	return py_dns_ttl;
}

static int py_dnsupdate_RODC_in_set_dns_ttl(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dns_ttl");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.dns_ttl));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.dns_ttl = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dnsupdate_RODC_in_get_dns_names(PyObject *obj, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_names;
	if (object->in.dns_names == NULL) {
		Py_RETURN_NONE;
	}
	py_dns_names = pytalloc_reference_ex(NL_DNS_NAME_INFO_ARRAY_Type, object->in.dns_names, object->in.dns_names);
	return py_dns_names;
}

static int py_dnsupdate_RODC_in_set_dns_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.dns_names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.dns_names");
		return -1;
	}
	object->in.dns_names = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.dns_names);
	if (object->in.dns_names == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(NL_DNS_NAME_INFO_ARRAY_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.dns_names = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_dnsupdate_RODC_out_get_dns_names(PyObject *obj, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_names;
	if (object->out.dns_names == NULL) {
		Py_RETURN_NONE;
	}
	py_dns_names = pytalloc_reference_ex(NL_DNS_NAME_INFO_ARRAY_Type, object->out.dns_names, object->out.dns_names);
	return py_dns_names;
}

static int py_dnsupdate_RODC_out_set_dns_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.dns_names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.dns_names");
		return -1;
	}
	object->out.dns_names = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.dns_names);
	if (object->out.dns_names == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(NL_DNS_NAME_INFO_ARRAY_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.dns_names = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_dnsupdate_RODC_get_result(PyObject *obj, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_dnsupdate_RODC_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnsupdate_RODC *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_dnsupdate_RODC_getsetters[] = {
	{
		.name = discard_const_p(char, "in_dom_sid"),
		.get = py_dnsupdate_RODC_in_get_dom_sid,
		.set = py_dnsupdate_RODC_in_set_dom_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "in_site_name"),
		.get = py_dnsupdate_RODC_in_get_site_name,
		.set = py_dnsupdate_RODC_in_set_site_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_dns_ttl"),
		.get = py_dnsupdate_RODC_in_get_dns_ttl,
		.set = py_dnsupdate_RODC_in_set_dns_ttl,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_dns_names"),
		.get = py_dnsupdate_RODC_in_get_dns_names,
		.set = py_dnsupdate_RODC_in_set_dns_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_DNS_NAME_INFO_ARRAY")
	},
	{
		.name = discard_const_p(char, "out_dns_names"),
		.get = py_dnsupdate_RODC_out_get_dns_names,
		.set = py_dnsupdate_RODC_out_set_dns_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type NL_DNS_NAME_INFO_ARRAY")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_dnsupdate_RODC_get_result,
		.set = py_dnsupdate_RODC_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_dnsupdate_RODC_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct dnsupdate_RODC, type);
	struct dnsupdate_RODC *_self = (struct dnsupdate_RODC *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.dns_names = talloc_zero(mem_ctx, struct NL_DNS_NAME_INFO_ARRAY);
	_self->out.dns_names = talloc_zero(mem_ctx, struct NL_DNS_NAME_INFO_ARRAY);
	return self;
}

static PyObject *py_dnsupdate_RODC_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(11);
}

static PyObject *py_dnsupdate_RODC_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct dnsupdate_RODC *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_dnsupdate_RODC_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[11];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_dnsupdate_RODC_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_dnsupdate_RODC_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_dnsupdate_RODC_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_dnsupdate_RODC_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_dnsupdate_RODC_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct dnsupdate_RODC *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_dnsupdate_RODC_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[11];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_dnsupdate_RODC_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_dnsupdate_RODC_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_dnsupdate_RODC_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_dnsupdate_RODC_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_dnsupdate_RODC_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct dnsupdate_RODC *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_dnsupdate_RODC_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[11];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_dnsupdate_RODC_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_dnsupdate_RODC_ndr_print(py_obj, args, kwargs, "dnsupdate_RODC_in", NDR_IN);
}

static PyObject *py_dnsupdate_RODC_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_dnsupdate_RODC_ndr_print(py_obj, args, kwargs, "dnsupdate_RODC_out", NDR_OUT);
}

static PyMethodDef py_dnsupdate_RODC_methods[] = {
	{ "opnum", (PyCFunction)py_dnsupdate_RODC_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.dnsupdate_RODC.opnum() -> 11 (0x0b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsupdate_RODC_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsupdate_RODC_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsupdate_RODC_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsupdate_RODC_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsupdate_RODC_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnsupdate_RODC_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnsupdate_RODC_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.dnsupdate_RODC",
	.tp_getset = py_dnsupdate_RODC_getsetters,
	.tp_methods = py_dnsupdate_RODC_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnsupdate_RODC_new,
};

static bool pack_py_dnsupdate_RODC_args_in(PyObject *args, PyObject *kwargs, struct dnsupdate_RODC *r)
{
	PyObject *py_dom_sid;
	PyObject *py_site_name;
	PyObject *py_dns_ttl;
	PyObject *py_dns_names;
	const char *kwnames[] = {
		"dom_sid", "site_name", "dns_ttl", "dns_names", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:dnsupdate_RODC", discard_const_p(char *, kwnames), &py_dom_sid, &py_site_name, &py_dns_ttl, &py_dns_names)) {
		return false;
	}

	if (py_dom_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dom_sid");
		return false;
	}
	if (py_dom_sid == Py_None) {
		r->in.dom_sid = NULL;
	} else {
		r->in.dom_sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, py_dom_sid, return false;);
		if (talloc_reference(r, pytalloc_get_mem_ctx(py_dom_sid)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		r->in.dom_sid = (struct dom_sid *)pytalloc_get_ptr(py_dom_sid);
	}
	if (py_site_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.site_name");
		return false;
	}
	if (py_site_name == Py_None) {
		r->in.site_name = NULL;
	} else {
		r->in.site_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(py_site_name)) {
				unicode = PyUnicode_AsEncodedString(py_site_name, "utf-8", "ignore");
				if (unicode == NULL) {
					return false;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(py_site_name)) {
				test_str = PyBytes_AS_STRING(py_site_name);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_site_name)->tp_name);
				return false;
			}
			talloc_str = talloc_strdup(r, test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.site_name = talloc_str;
		}
	}
	if (py_dns_ttl == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dns_ttl");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.dns_ttl));
		if (PyLong_Check(py_dns_ttl)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_dns_ttl);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.dns_ttl = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_dns_names == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.dns_names");
		return false;
	}
	r->in.dns_names = talloc_ptrtype(r, r->in.dns_names);
	if (r->in.dns_names == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(NL_DNS_NAME_INFO_ARRAY_Type, py_dns_names, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_dns_names)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.dns_names = (struct NL_DNS_NAME_INFO_ARRAY *)pytalloc_get_ptr(py_dns_names);
	return true;
}

static PyObject *unpack_py_dnsupdate_RODC_args_out(struct dnsupdate_RODC *r, bool raise_result_exception)
{
	PyObject *py_dns_names = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_dns_names = pytalloc_reference_ex(NL_DNS_NAME_INFO_ARRAY_Type, r->out.dns_names, r->out.dns_names);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_dns_names);
	}
	if (result_size == 1) {
		result = py_dns_names;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_dnssrv_reload_dns_zones_get_result(PyObject *obj, void *closure)
{
	struct dnssrv_reload_dns_zones *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_dnssrv_reload_dns_zones_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dnssrv_reload_dns_zones *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_dnssrv_reload_dns_zones_getsetters[] = {
	{
		.name = discard_const_p(char, "result"),
		.get = py_dnssrv_reload_dns_zones_get_result,
		.set = py_dnssrv_reload_dns_zones_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_dnssrv_reload_dns_zones_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct dnssrv_reload_dns_zones, type);
	return self;
}

static PyObject *py_dnssrv_reload_dns_zones_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(12);
}

static PyObject *py_dnssrv_reload_dns_zones_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct dnssrv_reload_dns_zones *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_dnssrv_reload_dns_zones_ndr_pack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[12];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_dnssrv_reload_dns_zones_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_dnssrv_reload_dns_zones_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_dnssrv_reload_dns_zones_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_dnssrv_reload_dns_zones_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_dnssrv_reload_dns_zones_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct dnssrv_reload_dns_zones *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_irpc.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_dnssrv_reload_dns_zones_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_irpc.calls[12];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_dnssrv_reload_dns_zones_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_dnssrv_reload_dns_zones_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_dnssrv_reload_dns_zones_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_dnssrv_reload_dns_zones_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_dnssrv_reload_dns_zones_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct dnssrv_reload_dns_zones *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_irpc.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_dnssrv_reload_dns_zones_ndr_print");
		return NULL;
	}
	call = &ndr_table_irpc.calls[12];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_dnssrv_reload_dns_zones_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_dnssrv_reload_dns_zones_ndr_print(py_obj, args, kwargs, "dnssrv_reload_dns_zones_in", NDR_IN);
}

static PyObject *py_dnssrv_reload_dns_zones_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_dnssrv_reload_dns_zones_ndr_print(py_obj, args, kwargs, "dnssrv_reload_dns_zones_out", NDR_OUT);
}

static PyMethodDef py_dnssrv_reload_dns_zones_methods[] = {
	{ "opnum", (PyCFunction)py_dnssrv_reload_dns_zones_ndr_opnum, METH_NOARGS|METH_CLASS,
		"irpc.dnssrv_reload_dns_zones.opnum() -> 12 (0x0c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnssrv_reload_dns_zones_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnssrv_reload_dns_zones_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnssrv_reload_dns_zones_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnssrv_reload_dns_zones_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnssrv_reload_dns_zones_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dnssrv_reload_dns_zones_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dnssrv_reload_dns_zones_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.dnssrv_reload_dns_zones",
	.tp_getset = py_dnssrv_reload_dns_zones_getsetters,
	.tp_methods = py_dnssrv_reload_dns_zones_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dnssrv_reload_dns_zones_new,
};

static bool pack_py_dnssrv_reload_dns_zones_args_in(PyObject *args, PyObject *kwargs, struct dnssrv_reload_dns_zones *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":dnssrv_reload_dns_zones", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_dnssrv_reload_dns_zones_args_out(struct dnssrv_reload_dns_zones *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_irpc_methods[] = {
	{
		.name = "uptime",
		.doc = "S.uptime() -> start_time",
		.call = (py_dcerpc_call_fn)dcerpc_irpc_uptime_r,
		.pack_in_data = (py_data_pack_fn)pack_py_irpc_uptime_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_irpc_uptime_args_out,
		.opnum = 0,
		.table = &ndr_table_irpc,
	},
	{
		.name = "nbtd_information",
		.doc = "S.nbtd_information(level) -> info",
		.call = (py_dcerpc_call_fn)dcerpc_nbtd_information_r,
		.pack_in_data = (py_data_pack_fn)pack_py_nbtd_information_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_nbtd_information_args_out,
		.opnum = 1,
		.table = &ndr_table_irpc,
	},
	{
		.name = "nbtd_getdcname",
		.doc = "S.nbtd_getdcname(domainname, ip_address, my_computername, my_accountname, account_control, domain_sid) -> dcname",
		.call = (py_dcerpc_call_fn)dcerpc_nbtd_getdcname_r,
		.pack_in_data = (py_data_pack_fn)pack_py_nbtd_getdcname_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_nbtd_getdcname_args_out,
		.opnum = 2,
		.table = &ndr_table_irpc,
	},
	{
		.name = "nbtd_proxy_wins_challenge",
		.doc = "S.nbtd_proxy_wins_challenge(name, num_addrs, addrs) -> (num_addrs, addrs)",
		.call = (py_dcerpc_call_fn)dcerpc_nbtd_proxy_wins_challenge_r,
		.pack_in_data = (py_data_pack_fn)pack_py_nbtd_proxy_wins_challenge_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_nbtd_proxy_wins_challenge_args_out,
		.opnum = 3,
		.table = &ndr_table_irpc,
	},
	{
		.name = "nbtd_proxy_wins_release_demand",
		.doc = "S.nbtd_proxy_wins_release_demand(name, num_addrs, addrs) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_nbtd_proxy_wins_release_demand_r,
		.pack_in_data = (py_data_pack_fn)pack_py_nbtd_proxy_wins_release_demand_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_nbtd_proxy_wins_release_demand_args_out,
		.opnum = 4,
		.table = &ndr_table_irpc,
	},
	{
		.name = "kdc_check_generic_kerberos",
		.doc = "S.kdc_check_generic_kerberos(generic_request) -> generic_reply",
		.call = (py_dcerpc_call_fn)dcerpc_kdc_check_generic_kerberos_r,
		.pack_in_data = (py_data_pack_fn)pack_py_kdc_check_generic_kerberos_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_kdc_check_generic_kerberos_args_out,
		.opnum = 5,
		.table = &ndr_table_irpc,
	},
	{
		.name = "smbsrv_information",
		.doc = "S.smbsrv_information(level) -> info",
		.call = (py_dcerpc_call_fn)dcerpc_smbsrv_information_r,
		.pack_in_data = (py_data_pack_fn)pack_py_smbsrv_information_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_smbsrv_information_args_out,
		.opnum = 6,
		.table = &ndr_table_irpc,
	},
	{
		.name = "samba_terminate",
		.doc = "S.samba_terminate(reason) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_samba_terminate_r,
		.pack_in_data = (py_data_pack_fn)pack_py_samba_terminate_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_samba_terminate_args_out,
		.opnum = 7,
		.table = &ndr_table_irpc,
	},
	{
		.name = "dreplsrv_refresh",
		.doc = "S.dreplsrv_refresh() -> None",
		.call = (py_dcerpc_call_fn)dcerpc_dreplsrv_refresh_r,
		.pack_in_data = (py_data_pack_fn)pack_py_dreplsrv_refresh_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_dreplsrv_refresh_args_out,
		.opnum = 8,
		.table = &ndr_table_irpc,
	},
	{
		.name = "drepl_takeFSMORole",
		.doc = "S.drepl_takeFSMORole(role) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_drepl_takeFSMORole_r,
		.pack_in_data = (py_data_pack_fn)pack_py_drepl_takeFSMORole_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_drepl_takeFSMORole_args_out,
		.opnum = 9,
		.table = &ndr_table_irpc,
	},
	{
		.name = "drepl_trigger_repl_secret",
		.doc = "S.drepl_trigger_repl_secret(user_dn) -> None",
		.call = (py_dcerpc_call_fn)dcerpc_drepl_trigger_repl_secret_r,
		.pack_in_data = (py_data_pack_fn)pack_py_drepl_trigger_repl_secret_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_drepl_trigger_repl_secret_args_out,
		.opnum = 10,
		.table = &ndr_table_irpc,
	},
	{
		.name = "dnsupdate_RODC",
		.doc = "S.dnsupdate_RODC(dom_sid, site_name, dns_ttl, dns_names) -> dns_names",
		.call = (py_dcerpc_call_fn)dcerpc_dnsupdate_RODC_r,
		.pack_in_data = (py_data_pack_fn)pack_py_dnsupdate_RODC_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_dnsupdate_RODC_args_out,
		.opnum = 11,
		.table = &ndr_table_irpc,
	},
	{
		.name = "dnssrv_reload_dns_zones",
		.doc = "S.dnssrv_reload_dns_zones() -> None",
		.call = (py_dcerpc_call_fn)dcerpc_dnssrv_reload_dns_zones_r,
		.pack_in_data = (py_data_pack_fn)pack_py_dnssrv_reload_dns_zones_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_dnssrv_reload_dns_zones_args_out,
		.opnum = 12,
		.table = &ndr_table_irpc,
	},
	{
		.name = NULL,
	},
};

static PyObject *interface_irpc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_irpc);
}

static PyTypeObject irpc_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.irpc",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "irpc(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A irpc client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_irpc_new,
};

static PyObject *syntax_irpc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_irpc.syntax_id);
}

static PyTypeObject irpc_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "irpc.irpc_abstract_syntax",
	.tp_doc = "irpc_abstract_syntax()\n",
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_irpc_new,
};

static PyMethodDef irpc_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "irpc",
	.m_doc = "irpc DCE/RPC",
	.m_size = -1,
	.m_methods = irpc_methods,
};
MODULE_INIT_FUNC(irpc)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_samba_dcerpc_nbt = NULL;
	PyObject *dep_samba_dcerpc_netlogon = NULL;
	PyObject *dep_samba_dcerpc_server_id = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_samba_dcerpc_nbt = PyImport_ImportModule("samba.dcerpc.nbt");
	if (dep_samba_dcerpc_nbt == NULL)
		goto out;

	dep_samba_dcerpc_netlogon = PyImport_ImportModule("samba.dcerpc.netlogon");
	if (dep_samba_dcerpc_netlogon == NULL)
		goto out;

	dep_samba_dcerpc_server_id = PyImport_ImportModule("samba.dcerpc.server_id");
	if (dep_samba_dcerpc_server_id == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	security_token_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "token");
	if (security_token_Type == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		goto out;

	server_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_server_id, "server_id");
	if (server_id_Type == NULL)
		goto out;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		goto out;

	nbt_name_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_nbt, "name");
	if (nbt_name_Type == NULL)
		goto out;

	NL_DNS_NAME_INFO_ARRAY_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_netlogon, "NL_DNS_NAME_INFO_ARRAY");
	if (NL_DNS_NAME_INFO_ARRAY_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	irpc_creds_Type.tp_base = BaseObject_Type;
	irpc_creds_Type.tp_basicsize = pytalloc_BaseObject_size();

	irpc_header_Type.tp_base = BaseObject_Type;
	irpc_header_Type.tp_basicsize = pytalloc_BaseObject_size();

	irpc_name_record_Type.tp_base = BaseObject_Type;
	irpc_name_record_Type.tp_basicsize = pytalloc_BaseObject_size();

	irpc_name_records_Type.tp_base = BaseObject_Type;
	irpc_name_records_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbtd_statistics_Type.tp_base = BaseObject_Type;
	nbtd_statistics_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbtd_info_Type.tp_base = BaseObject_Type;
	nbtd_info_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbtd_proxy_wins_addr_Type.tp_base = BaseObject_Type;
	nbtd_proxy_wins_addr_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbsrv_session_info_Type.tp_base = BaseObject_Type;
	smbsrv_session_info_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbsrv_sessions_Type.tp_base = BaseObject_Type;
	smbsrv_sessions_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbsrv_tcon_info_Type.tp_base = BaseObject_Type;
	smbsrv_tcon_info_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbsrv_tcons_Type.tp_base = BaseObject_Type;
	smbsrv_tcons_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbsrv_info_Type.tp_base = BaseObject_Type;
	smbsrv_info_Type.tp_basicsize = pytalloc_BaseObject_size();

	irpc_uptime_Type.tp_base = BaseObject_Type;
	irpc_uptime_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbtd_information_Type.tp_base = BaseObject_Type;
	nbtd_information_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbtd_getdcname_Type.tp_base = BaseObject_Type;
	nbtd_getdcname_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbtd_proxy_wins_challenge_Type.tp_base = BaseObject_Type;
	nbtd_proxy_wins_challenge_Type.tp_basicsize = pytalloc_BaseObject_size();

	nbtd_proxy_wins_release_demand_Type.tp_base = BaseObject_Type;
	nbtd_proxy_wins_release_demand_Type.tp_basicsize = pytalloc_BaseObject_size();

	kdc_check_generic_kerberos_Type.tp_base = BaseObject_Type;
	kdc_check_generic_kerberos_Type.tp_basicsize = pytalloc_BaseObject_size();

	smbsrv_information_Type.tp_base = BaseObject_Type;
	smbsrv_information_Type.tp_basicsize = pytalloc_BaseObject_size();

	samba_terminate_Type.tp_base = BaseObject_Type;
	samba_terminate_Type.tp_basicsize = pytalloc_BaseObject_size();

	dreplsrv_refresh_Type.tp_base = BaseObject_Type;
	dreplsrv_refresh_Type.tp_basicsize = pytalloc_BaseObject_size();

	drepl_takeFSMORole_Type.tp_base = BaseObject_Type;
	drepl_takeFSMORole_Type.tp_basicsize = pytalloc_BaseObject_size();

	drepl_trigger_repl_secret_Type.tp_base = BaseObject_Type;
	drepl_trigger_repl_secret_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnsupdate_RODC_Type.tp_base = BaseObject_Type;
	dnsupdate_RODC_Type.tp_basicsize = pytalloc_BaseObject_size();

	dnssrv_reload_dns_zones_Type.tp_base = BaseObject_Type;
	dnssrv_reload_dns_zones_Type.tp_basicsize = pytalloc_BaseObject_size();

	irpc_InterfaceType.tp_base = ClientConnection_Type;

	irpc_SyntaxType.tp_base = ndr_syntax_id_Type;
	irpc_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&irpc_creds_Type) < 0)
		goto out;
	if (PyType_Ready(&irpc_header_Type) < 0)
		goto out;
	if (PyType_Ready(&irpc_name_record_Type) < 0)
		goto out;
	if (PyType_Ready(&irpc_name_records_Type) < 0)
		goto out;
	if (PyType_Ready(&nbtd_statistics_Type) < 0)
		goto out;
	if (PyType_Ready(&nbtd_info_Type) < 0)
		goto out;
	if (PyType_Ready(&nbtd_proxy_wins_addr_Type) < 0)
		goto out;
	if (PyType_Ready(&smbsrv_session_info_Type) < 0)
		goto out;
	if (PyType_Ready(&smbsrv_sessions_Type) < 0)
		goto out;
	if (PyType_Ready(&smbsrv_tcon_info_Type) < 0)
		goto out;
	if (PyType_Ready(&smbsrv_tcons_Type) < 0)
		goto out;
	if (PyType_Ready(&smbsrv_info_Type) < 0)
		goto out;
	if (PyType_Ready(&irpc_uptime_Type) < 0)
		goto out;
	if (PyType_Ready(&nbtd_information_Type) < 0)
		goto out;
	if (PyType_Ready(&nbtd_getdcname_Type) < 0)
		goto out;
	if (PyType_Ready(&nbtd_proxy_wins_challenge_Type) < 0)
		goto out;
	if (PyType_Ready(&nbtd_proxy_wins_release_demand_Type) < 0)
		goto out;
	if (PyType_Ready(&kdc_check_generic_kerberos_Type) < 0)
		goto out;
	if (PyType_Ready(&smbsrv_information_Type) < 0)
		goto out;
	if (PyType_Ready(&samba_terminate_Type) < 0)
		goto out;
	if (PyType_Ready(&dreplsrv_refresh_Type) < 0)
		goto out;
	if (PyType_Ready(&drepl_takeFSMORole_Type) < 0)
		goto out;
	if (PyType_Ready(&drepl_trigger_repl_secret_Type) < 0)
		goto out;
	if (PyType_Ready(&dnsupdate_RODC_Type) < 0)
		goto out;
	if (PyType_Ready(&dnssrv_reload_dns_zones_Type) < 0)
		goto out;
	if (PyType_Ready(&irpc_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&irpc_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&irpc_InterfaceType, py_ndr_irpc_methods))
		return NULL;

#ifdef PY_CREDS_PATCH
	PY_CREDS_PATCH(&irpc_creds_Type);
#endif
#ifdef PY_HEADER_PATCH
	PY_HEADER_PATCH(&irpc_header_Type);
#endif
#ifdef PY_NAME_RECORD_PATCH
	PY_NAME_RECORD_PATCH(&irpc_name_record_Type);
#endif
#ifdef PY_NAME_RECORDS_PATCH
	PY_NAME_RECORDS_PATCH(&irpc_name_records_Type);
#endif
#ifdef PY_NBTD_STATISTICS_PATCH
	PY_NBTD_STATISTICS_PATCH(&nbtd_statistics_Type);
#endif
#ifdef PY_NBTD_INFO_PATCH
	PY_NBTD_INFO_PATCH(&nbtd_info_Type);
#endif
#ifdef PY_NBTD_PROXY_WINS_ADDR_PATCH
	PY_NBTD_PROXY_WINS_ADDR_PATCH(&nbtd_proxy_wins_addr_Type);
#endif
#ifdef PY_SMBSRV_SESSION_INFO_PATCH
	PY_SMBSRV_SESSION_INFO_PATCH(&smbsrv_session_info_Type);
#endif
#ifdef PY_SMBSRV_SESSIONS_PATCH
	PY_SMBSRV_SESSIONS_PATCH(&smbsrv_sessions_Type);
#endif
#ifdef PY_SMBSRV_TCON_INFO_PATCH
	PY_SMBSRV_TCON_INFO_PATCH(&smbsrv_tcon_info_Type);
#endif
#ifdef PY_SMBSRV_TCONS_PATCH
	PY_SMBSRV_TCONS_PATCH(&smbsrv_tcons_Type);
#endif
#ifdef PY_SMBSRV_INFO_PATCH
	PY_SMBSRV_INFO_PATCH(&smbsrv_info_Type);
#endif
#ifdef PY_UPTIME_PATCH
	PY_UPTIME_PATCH(&irpc_uptime_Type);
#endif
#ifdef PY_NBTD_INFORMATION_PATCH
	PY_NBTD_INFORMATION_PATCH(&nbtd_information_Type);
#endif
#ifdef PY_NBTD_GETDCNAME_PATCH
	PY_NBTD_GETDCNAME_PATCH(&nbtd_getdcname_Type);
#endif
#ifdef PY_NBTD_PROXY_WINS_CHALLENGE_PATCH
	PY_NBTD_PROXY_WINS_CHALLENGE_PATCH(&nbtd_proxy_wins_challenge_Type);
#endif
#ifdef PY_NBTD_PROXY_WINS_RELEASE_DEMAND_PATCH
	PY_NBTD_PROXY_WINS_RELEASE_DEMAND_PATCH(&nbtd_proxy_wins_release_demand_Type);
#endif
#ifdef PY_KDC_CHECK_GENERIC_KERBEROS_PATCH
	PY_KDC_CHECK_GENERIC_KERBEROS_PATCH(&kdc_check_generic_kerberos_Type);
#endif
#ifdef PY_SMBSRV_INFORMATION_PATCH
	PY_SMBSRV_INFORMATION_PATCH(&smbsrv_information_Type);
#endif
#ifdef PY_SAMBA_TERMINATE_PATCH
	PY_SAMBA_TERMINATE_PATCH(&samba_terminate_Type);
#endif
#ifdef PY_DREPLSRV_REFRESH_PATCH
	PY_DREPLSRV_REFRESH_PATCH(&dreplsrv_refresh_Type);
#endif
#ifdef PY_DREPL_TAKEFSMOROLE_PATCH
	PY_DREPL_TAKEFSMOROLE_PATCH(&drepl_takeFSMORole_Type);
#endif
#ifdef PY_DREPL_TRIGGER_REPL_SECRET_PATCH
	PY_DREPL_TRIGGER_REPL_SECRET_PATCH(&drepl_trigger_repl_secret_Type);
#endif
#ifdef PY_DNSUPDATE_RODC_PATCH
	PY_DNSUPDATE_RODC_PATCH(&dnsupdate_RODC_Type);
#endif
#ifdef PY_DNSSRV_RELOAD_DNS_ZONES_PATCH
	PY_DNSSRV_RELOAD_DNS_ZONES_PATCH(&dnssrv_reload_dns_zones_Type);
#endif
#ifdef PY_IRPC_PATCH
	PY_IRPC_PATCH(&irpc_InterfaceType);
#endif
#ifdef PY_IRPC_ABSTRACT_SYNTAX_PATCH
	PY_IRPC_ABSTRACT_SYNTAX_PATCH(&irpc_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&irpc_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "IRPC_FLAG_REPLY", PyLong_FromUnsignedLongLong((uint32_t)(IRPC_FLAG_REPLY)));
	PyModule_AddObject(m, "NBTD_INFO_STATISTICS", PyLong_FromUnsignedLongLong((uint32_t)(NBTD_INFO_STATISTICS)));
	PyModule_AddObject(m, "SMBSRV_INFO_SESSIONS", PyLong_FromUnsignedLongLong((uint32_t)(SMBSRV_INFO_SESSIONS)));
	PyModule_AddObject(m, "SMBSRV_INFO_TCONS", PyLong_FromUnsignedLongLong((uint32_t)(SMBSRV_INFO_TCONS)));
	PyModule_AddObject(m, "DREPL_SCHEMA_MASTER", PyLong_FromUnsignedLongLong((uint32_t)(DREPL_SCHEMA_MASTER)));
	PyModule_AddObject(m, "DREPL_RID_MASTER", PyLong_FromUnsignedLongLong((uint32_t)(DREPL_RID_MASTER)));
	PyModule_AddObject(m, "DREPL_INFRASTRUCTURE_MASTER", PyLong_FromUnsignedLongLong((uint32_t)(DREPL_INFRASTRUCTURE_MASTER)));
	PyModule_AddObject(m, "DREPL_NAMING_MASTER", PyLong_FromUnsignedLongLong((uint32_t)(DREPL_NAMING_MASTER)));
	PyModule_AddObject(m, "DREPL_PDC_MASTER", PyLong_FromUnsignedLongLong((uint32_t)(DREPL_PDC_MASTER)));
	Py_INCREF((PyObject *)(void *)&irpc_creds_Type);
	PyModule_AddObject(m, "creds", (PyObject *)(void *)&irpc_creds_Type);
	Py_INCREF((PyObject *)(void *)&irpc_header_Type);
	PyModule_AddObject(m, "header", (PyObject *)(void *)&irpc_header_Type);
	Py_INCREF((PyObject *)(void *)&irpc_name_record_Type);
	PyModule_AddObject(m, "name_record", (PyObject *)(void *)&irpc_name_record_Type);
	Py_INCREF((PyObject *)(void *)&irpc_name_records_Type);
	PyModule_AddObject(m, "name_records", (PyObject *)(void *)&irpc_name_records_Type);
	Py_INCREF((PyObject *)(void *)&nbtd_statistics_Type);
	PyModule_AddObject(m, "nbtd_statistics", (PyObject *)(void *)&nbtd_statistics_Type);
	Py_INCREF((PyObject *)(void *)&nbtd_info_Type);
	PyModule_AddObject(m, "nbtd_info", (PyObject *)(void *)&nbtd_info_Type);
	Py_INCREF((PyObject *)(void *)&nbtd_proxy_wins_addr_Type);
	PyModule_AddObject(m, "nbtd_proxy_wins_addr", (PyObject *)(void *)&nbtd_proxy_wins_addr_Type);
	Py_INCREF((PyObject *)(void *)&smbsrv_session_info_Type);
	PyModule_AddObject(m, "smbsrv_session_info", (PyObject *)(void *)&smbsrv_session_info_Type);
	Py_INCREF((PyObject *)(void *)&smbsrv_sessions_Type);
	PyModule_AddObject(m, "smbsrv_sessions", (PyObject *)(void *)&smbsrv_sessions_Type);
	Py_INCREF((PyObject *)(void *)&smbsrv_tcon_info_Type);
	PyModule_AddObject(m, "smbsrv_tcon_info", (PyObject *)(void *)&smbsrv_tcon_info_Type);
	Py_INCREF((PyObject *)(void *)&smbsrv_tcons_Type);
	PyModule_AddObject(m, "smbsrv_tcons", (PyObject *)(void *)&smbsrv_tcons_Type);
	Py_INCREF((PyObject *)(void *)&smbsrv_info_Type);
	PyModule_AddObject(m, "smbsrv_info", (PyObject *)(void *)&smbsrv_info_Type);
	Py_INCREF((PyObject *)(void *)&irpc_uptime_Type);
	PyModule_AddObject(m, "uptime", (PyObject *)(void *)&irpc_uptime_Type);
	Py_INCREF((PyObject *)(void *)&nbtd_information_Type);
	PyModule_AddObject(m, "nbtd_information", (PyObject *)(void *)&nbtd_information_Type);
	Py_INCREF((PyObject *)(void *)&nbtd_getdcname_Type);
	PyModule_AddObject(m, "nbtd_getdcname", (PyObject *)(void *)&nbtd_getdcname_Type);
	Py_INCREF((PyObject *)(void *)&nbtd_proxy_wins_challenge_Type);
	PyModule_AddObject(m, "nbtd_proxy_wins_challenge", (PyObject *)(void *)&nbtd_proxy_wins_challenge_Type);
	Py_INCREF((PyObject *)(void *)&nbtd_proxy_wins_release_demand_Type);
	PyModule_AddObject(m, "nbtd_proxy_wins_release_demand", (PyObject *)(void *)&nbtd_proxy_wins_release_demand_Type);
	Py_INCREF((PyObject *)(void *)&kdc_check_generic_kerberos_Type);
	PyModule_AddObject(m, "kdc_check_generic_kerberos", (PyObject *)(void *)&kdc_check_generic_kerberos_Type);
	Py_INCREF((PyObject *)(void *)&smbsrv_information_Type);
	PyModule_AddObject(m, "smbsrv_information", (PyObject *)(void *)&smbsrv_information_Type);
	Py_INCREF((PyObject *)(void *)&samba_terminate_Type);
	PyModule_AddObject(m, "samba_terminate", (PyObject *)(void *)&samba_terminate_Type);
	Py_INCREF((PyObject *)(void *)&dreplsrv_refresh_Type);
	PyModule_AddObject(m, "dreplsrv_refresh", (PyObject *)(void *)&dreplsrv_refresh_Type);
	Py_INCREF((PyObject *)(void *)&drepl_takeFSMORole_Type);
	PyModule_AddObject(m, "drepl_takeFSMORole", (PyObject *)(void *)&drepl_takeFSMORole_Type);
	Py_INCREF((PyObject *)(void *)&drepl_trigger_repl_secret_Type);
	PyModule_AddObject(m, "drepl_trigger_repl_secret", (PyObject *)(void *)&drepl_trigger_repl_secret_Type);
	Py_INCREF((PyObject *)(void *)&dnsupdate_RODC_Type);
	PyModule_AddObject(m, "dnsupdate_RODC", (PyObject *)(void *)&dnsupdate_RODC_Type);
	Py_INCREF((PyObject *)(void *)&dnssrv_reload_dns_zones_Type);
	PyModule_AddObject(m, "dnssrv_reload_dns_zones", (PyObject *)(void *)&dnssrv_reload_dns_zones_Type);
	Py_INCREF((PyObject *)(void *)&irpc_InterfaceType);
	PyModule_AddObject(m, "irpc", (PyObject *)(void *)&irpc_InterfaceType);
	Py_INCREF((PyObject *)(void *)&irpc_SyntaxType);
	PyModule_AddObject(m, "irpc_abstract_syntax", (PyObject *)(void *)&irpc_SyntaxType);
	Py_INCREF((PyObject *)(void *)&irpc_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&irpc_SyntaxType);
#ifdef PY_MOD_IRPC_PATCH
	PY_MOD_IRPC_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_samba_dcerpc_nbt);
	Py_XDECREF(dep_samba_dcerpc_netlogon);
	Py_XDECREF(dep_samba_dcerpc_server_id);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
