#ifndef __SOURCE4_TORTURE_DRS_PROTO_H__
#define __SOURCE4_TORTURE_DRS_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/torture/drs/drs_init.c  */


/**
 * DRSUAPI torture module initialization
 */
NTSTATUS torture_drs_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/drs/drs_util.c  */


/**
 * Decode Attribute OID based on MS documentation
 * See MS-DRSR.pdf - 5.16.4
 *
 * On success returns decoded OID and
 * corresponding prefix_map index (if requested)
 */
bool drs_util_oid_from_attid(struct torture_context *tctx,
			     const struct drsuapi_DsReplicaOIDMapping_Ctr *prefix_map,
			     uint32_t attid,
			     const char **_oid,
			     int *map_idx);

/**
 * Loads dsdb_schema from ldb connection using remote prefixMap.
 * Schema will be loaded only if:
 *  - ldb has no attached schema
 *  - reload_schema is true
 *
 * This function is to be used in tests that use GetNCChanges() function
 */
bool drs_util_dsdb_schema_load_ldb(struct torture_context *tctx,
				   struct ldb_context *ldb,
				   const struct drsuapi_DsReplicaOIDMapping_Ctr *mapping_ctr,
				   bool reload_schema);

/* The following definitions come from ../../source4/torture/drs/unit/prefixmap_tests.c  */


/**
 * Test case initialization for
 * drs.unit.prefixMap
 */
struct torture_tcase * torture_drs_unit_prefixmap(struct torture_suite *suite);

/* The following definitions come from ../../source4/torture/drs/unit/schemainfo_tests.c  */


/**
 * Creates dsdb_schema_info object based on predefined data
 * Function is public as it is intended to be used by other
 * tests (e.g. prefixMap tests)
 */
bool drsut_schemainfo_new(struct torture_context *tctx, struct dsdb_schema_info **_si);

/**
 * Test case initialization for
 * drs.unit.schemaInfo
 */
struct torture_tcase * torture_drs_unit_schemainfo(struct torture_suite *suite);

/* The following definitions come from ../../source4/torture/drs/rpc/dssync.c  */


/**
 * DSSYNC test case implementation
 */
void torture_drs_rpc_dssync_tcase(struct torture_suite *suite);

/* The following definitions come from ../../source4/torture/drs/rpc/msds_intid.c  */


/**
 * DSSYNC test case implementation
 */
void torture_drs_rpc_dsintid_tcase(struct torture_suite *suite);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_TORTURE_DRS_PROTO_H__ */

