/* AppDirs.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AppDirs.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <config.h>
#include <gobject/gvaluecollector.h>

#define APP_DIRS_DEFAULT_DATA_DIR "shotwell"
#define RESOURCES_LIBEXECDIR _LIBEXECDIR
#define RESOURCES_LIB _LIB
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_APP_DIRS (app_dirs_get_type ())
#define APP_DIRS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_DIRS, AppDirs))
#define APP_DIRS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_DIRS, AppDirsClass))
#define IS_APP_DIRS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_DIRS))
#define IS_APP_DIRS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_DIRS))
#define APP_DIRS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_DIRS, AppDirsClass))

typedef struct _AppDirs AppDirs;
typedef struct _AppDirsClass AppDirsClass;
typedef struct _AppDirsPrivate AppDirsPrivate;
typedef enum  {
	APP_DIRS_RUNTIME_NATIVE,
	APP_DIRS_RUNTIME_FLATPAK,
	APP_DIRS_RUNTIME_SNAP,
	APP_DIRS_RUNTIME_UNKNOWN
} AppDirsRuntime;

#define APP_DIRS_TYPE_RUNTIME (app_dirs_runtime_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _ParamSpecAppDirs ParamSpecAppDirs;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AppDirs {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AppDirsPrivate * priv;
};

struct _AppDirsClass {
	GTypeClass parent_class;
	void (*finalize) (AppDirs *self);
};

struct _ParamSpecAppDirs {
	GParamSpec parent_instance;
};

static gpointer app_dirs_parent_class = NULL;
static GFile* app_dirs_exec_dir;
static GFile* app_dirs_exec_dir = NULL;
static GFile* app_dirs_data_dir;
static GFile* app_dirs_data_dir = NULL;
static GFile* app_dirs_tmp_dir;
static GFile* app_dirs_tmp_dir = NULL;
static GFile* app_dirs_libexec_dir;
static GFile* app_dirs_libexec_dir = NULL;
static AppDirsRuntime app_dirs__runtime;
static AppDirsRuntime app_dirs__runtime = APP_DIRS_RUNTIME_UNKNOWN;

VALA_EXTERN gpointer app_dirs_ref (gpointer instance);
VALA_EXTERN void app_dirs_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_app_dirs (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_app_dirs (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_app_dirs (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_app_dirs (const GValue* value);
VALA_EXTERN GType app_dirs_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppDirs, app_dirs_unref)
VALA_EXTERN GType app_dirs_runtime_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void app_dirs_init (const gchar* arg0);
VALA_EXTERN void app_dirs_terminate (void);
VALA_EXTERN GFile* app_dirs_get_home_dir (void);
VALA_EXTERN GFile* app_dirs_get_cache_dir (void);
VALA_EXTERN void app_dirs_try_migrate_data (void);
VALA_EXTERN GFile* app_dirs_get_user_plugins_dir (void);
VALA_EXTERN GFile* app_dirs_get_data_dir (void);
VALA_EXTERN void app_window_panic (const gchar* msg);
VALA_EXTERN void app_dirs_set_data_dir (const gchar* user_data_dir);
VALA_EXTERN gboolean is_string_empty (const gchar* s);
VALA_EXTERN gchar* strip_pretty_path (const gchar* path);
VALA_EXTERN void app_dirs_verify_data_dir (void);
VALA_EXTERN void app_dirs_verify_cache_dir (void);
VALA_EXTERN GFile* app_dirs_get_libexec_dir (void);
VALA_EXTERN GFile* app_dirs_get_install_dir (void);
VALA_EXTERN GFile* app_dirs_get_exec_dir (void);
VALA_EXTERN GFile* get_sys_install_dir (GFile* exec_dir);
VALA_EXTERN GFile* app_dirs_get_import_dir (void);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
VALA_EXTERN gchar* configuration_facade_get_import_dir (ConfigurationFacade* self);
VALA_EXTERN GFile* app_dirs_get_baked_import_dir (GDateTime* tm);
VALA_EXTERN gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self);
VALA_EXTERN gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self);
VALA_EXTERN gboolean app_dirs_is_in_import_dir (GFile* file);
VALA_EXTERN void app_dirs_set_import_dir (const gchar* path);
VALA_EXTERN void configuration_facade_set_import_dir (ConfigurationFacade* self,
                                          const gchar* import_dir);
VALA_EXTERN AppDirsRuntime app_dirs_get_runtime (void);
VALA_EXTERN GFile* app_dirs_get_temp_dir (void);
VALA_EXTERN GFile* app_dirs_get_data_subdir (const gchar* name,
                                 const gchar* subname);
VALA_EXTERN void app_dirs_ensure_writable (GFile* dir);
VALA_EXTERN GFile* app_dirs_get_cache_subdir (const gchar* name,
                                  const gchar* subname);
VALA_EXTERN GFile* app_dirs_get_resources_dir (void);
VALA_EXTERN GFile* app_dirs_get_lib_dir (void);
VALA_EXTERN GFile* app_dirs_get_system_plugins_dir (void);
VALA_EXTERN GFile* app_dirs_get_log_file (void);
VALA_EXTERN GFile* app_dirs_get_thumbnailer_bin (void);
VALA_EXTERN GFile* app_dirs_get_metadata_helper (void);
VALA_EXTERN GFile* app_dirs_get_settings_migrator_bin (void);
VALA_EXTERN GFile* app_dirs_get_haarcascade_file (void);
VALA_EXTERN AppDirs* app_dirs_new (void);
VALA_EXTERN AppDirs* app_dirs_construct (GType object_type);
static void app_dirs_finalize (AppDirs * obj);
static GType app_dirs_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
app_dirs_runtime_get_type_once (void)
{
	static const GEnumValue values[] = {{APP_DIRS_RUNTIME_NATIVE, "APP_DIRS_RUNTIME_NATIVE", "native"}, {APP_DIRS_RUNTIME_FLATPAK, "APP_DIRS_RUNTIME_FLATPAK", "flatpak"}, {APP_DIRS_RUNTIME_SNAP, "APP_DIRS_RUNTIME_SNAP", "snap"}, {APP_DIRS_RUNTIME_UNKNOWN, "APP_DIRS_RUNTIME_UNKNOWN", "unknown"}, {0, NULL, NULL}};
	GType app_dirs_runtime_type_id;
	app_dirs_runtime_type_id = g_enum_register_static ("AppDirsRuntime", values);
	return app_dirs_runtime_type_id;
}

GType
app_dirs_runtime_get_type (void)
{
	static volatile gsize app_dirs_runtime_type_id__once = 0;
	if (g_once_init_enter (&app_dirs_runtime_type_id__once)) {
		GType app_dirs_runtime_type_id;
		app_dirs_runtime_type_id = app_dirs_runtime_get_type_once ();
		g_once_init_leave (&app_dirs_runtime_type_id__once, app_dirs_runtime_type_id);
	}
	return app_dirs_runtime_type_id__once;
}

void
app_dirs_init (const gchar* arg0)
{
	GFile* exec_file = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	g_return_if_fail (arg0 != NULL);
	_tmp0_ = g_find_program_in_path (arg0);
	_tmp1_ = _tmp0_;
	_tmp2_ = realpath (_tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	exec_file = _tmp5_;
	_tmp6_ = g_file_get_parent (exec_file);
	_g_object_unref0 (app_dirs_exec_dir);
	app_dirs_exec_dir = _tmp6_;
	_g_object_unref0 (exec_file);
}

void
app_dirs_terminate (void)
{
}

GFile*
app_dirs_get_home_dir (void)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GFile*
app_dirs_get_cache_dir (void)
{
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* result;
	_tmp1_ = app_dirs_data_dir;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp2_ = g_get_user_cache_dir ();
		_tmp3_ = g_file_new_for_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_child (_tmp4_, APP_DIRS_DEFAULT_DATA_DIR);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
	} else {
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = app_dirs_data_dir;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp7_;
	}
	result = _tmp0_;
	return result;
}

void
app_dirs_try_migrate_data (void)
{
	GFile* user_plugin_dir = NULL;
	GFile* _tmp0_;
	GFile* old_dir = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GFile* _tmp10_;
	GFile* new_dir = NULL;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	gboolean _tmp23_ = FALSE;
	GFile* _tmp24_;
	GFile* cache_dir = NULL;
	GFile* _tmp26_;
	mode_t mask = {0};
	GFile* _tmp27_;
	GFile* _tmp36_;
	GFile* _tmp37_;
	GFile* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GFile* _tmp41_;
	GFile* _tmp42_;
	GFile* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GFile* _tmp46_;
	GFile* _tmp47_;
	GFile* _tmp48_;
	gboolean _tmp49_;
	GFile* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	GFile* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	GFile* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = app_dirs_get_user_plugins_dir ();
	user_plugin_dir = _tmp0_;
	_tmp1_ = app_dirs_get_home_dir ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_child (_tmp2_, ".gnome2");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_child (_tmp4_, "shotwell");
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_get_child (_tmp6_, "plugins");
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	old_dir = _tmp8_;
	_tmp10_ = old_dir;
	if (g_file_query_exists (_tmp10_, NULL)) {
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		_tmp11_ = user_plugin_dir;
		_tmp12_ = g_file_get_parent (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp9_ = !g_file_query_exists (_tmp13_, NULL);
		_g_object_unref0 (_tmp13_);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		{
			GFile* _tmp14_;
			GFile* _tmp15_;
			GFile* _tmp16_;
			_tmp14_ = user_plugin_dir;
			_tmp15_ = g_file_get_parent (_tmp14_);
			_tmp16_ = _tmp15_;
			g_file_make_directory_with_parents (_tmp16_, NULL, &_inner_error0_);
			_g_object_unref0 (_tmp16_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (old_dir);
			_g_object_unref0 (user_plugin_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GFile* _tmp17_;
		GFile* _tmp18_;
		_tmp17_ = old_dir;
		_tmp18_ = user_plugin_dir;
		g_file_move (_tmp17_, _tmp18_, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (old_dir);
		_g_object_unref0 (user_plugin_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp19_ = app_dirs_get_data_dir ();
	new_dir = _tmp19_;
	_tmp20_ = app_dirs_get_home_dir ();
	_tmp21_ = _tmp20_;
	_tmp22_ = g_file_get_child (_tmp21_, ".shotwell");
	_g_object_unref0 (old_dir);
	old_dir = _tmp22_;
	_g_object_unref0 (_tmp21_);
	_tmp24_ = new_dir;
	if (g_file_query_exists (_tmp24_, NULL)) {
		_tmp23_ = TRUE;
	} else {
		GFile* _tmp25_;
		_tmp25_ = old_dir;
		_tmp23_ = !g_file_query_exists (_tmp25_, NULL);
	}
	if (_tmp23_) {
		_g_object_unref0 (new_dir);
		_g_object_unref0 (old_dir);
		_g_object_unref0 (user_plugin_dir);
		return;
	}
	_tmp26_ = app_dirs_get_cache_dir ();
	cache_dir = _tmp26_;
	mask = umask ((mode_t) 0077);
	_tmp27_ = cache_dir;
	if (!g_file_query_exists (_tmp27_, NULL)) {
		{
			GFile* _tmp28_;
			_tmp28_ = cache_dir;
			g_file_make_directory_with_parents (_tmp28_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* err = NULL;
			GFile* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			GError* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp29_ = cache_dir;
			_tmp30_ = g_file_get_path (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = err;
			_tmp33_ = _tmp32_->message;
			_tmp34_ = g_strdup_printf (_ ("Unable to create cache directory %s: %s"), _tmp31_, _tmp33_);
			_tmp35_ = _tmp34_;
			app_window_panic (_tmp35_);
			_g_free0 (_tmp35_);
			_g_free0 (_tmp31_);
			_g_error_free0 (err);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (cache_dir);
			_g_object_unref0 (new_dir);
			_g_object_unref0 (old_dir);
			_g_object_unref0 (user_plugin_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp36_ = old_dir;
	_tmp37_ = g_file_get_child (_tmp36_, "thumbs");
	_tmp38_ = _tmp37_;
	_tmp39_ = g_file_get_path (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = cache_dir;
	_tmp42_ = g_file_get_child (_tmp41_, "thumbs");
	_tmp43_ = _tmp42_;
	_tmp44_ = g_file_get_path (_tmp43_);
	_tmp45_ = _tmp44_;
	g_rename (_tmp40_, _tmp45_);
	_g_free0 (_tmp45_);
	_g_object_unref0 (_tmp43_);
	_g_free0 (_tmp40_);
	_g_object_unref0 (_tmp38_);
	_tmp46_ = new_dir;
	_tmp47_ = g_file_get_parent (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = !g_file_query_exists (_tmp48_, NULL);
	_g_object_unref0 (_tmp48_);
	if (_tmp49_) {
		{
			GFile* _tmp50_;
			GFile* _tmp51_;
			GFile* _tmp52_;
			_tmp50_ = new_dir;
			_tmp51_ = g_file_get_parent (_tmp50_);
			_tmp52_ = _tmp51_;
			g_file_make_directory_with_parents (_tmp52_, NULL, &_inner_error0_);
			_g_object_unref0 (_tmp52_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* err = NULL;
			GFile* _tmp53_;
			GFile* _tmp54_;
			GFile* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			GError* _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp53_ = new_dir;
			_tmp54_ = g_file_get_parent (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_file_get_path (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = err;
			_tmp59_ = _tmp58_->message;
			_tmp60_ = g_strdup_printf (_ ("Unable to create data directory %s: %s"), _tmp57_, _tmp59_);
			_tmp61_ = _tmp60_;
			app_window_panic (_tmp61_);
			_g_free0 (_tmp61_);
			_g_free0 (_tmp57_);
			_g_object_unref0 (_tmp55_);
			_g_error_free0 (err);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (cache_dir);
			_g_object_unref0 (new_dir);
			_g_object_unref0 (old_dir);
			_g_object_unref0 (user_plugin_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp62_ = old_dir;
	_tmp63_ = g_file_get_path (_tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = new_dir;
	_tmp66_ = g_file_get_path (_tmp65_);
	_tmp67_ = _tmp66_;
	g_rename (_tmp64_, _tmp67_);
	_g_free0 (_tmp67_);
	_g_free0 (_tmp64_);
	_tmp68_ = new_dir;
	_tmp69_ = g_file_get_path (_tmp68_);
	_tmp70_ = _tmp69_;
	g_chmod (_tmp70_, 0700);
	_g_free0 (_tmp70_);
	umask (mask);
	_g_object_unref0 (cache_dir);
	_g_object_unref0 (new_dir);
	_g_object_unref0 (old_dir);
	_g_object_unref0 (user_plugin_dir);
}

void
app_dirs_set_data_dir (const gchar* user_data_dir)
{
	GFile* _tmp0_;
	gchar* path = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_if_fail (user_data_dir != NULL);
	_vala_return_if_fail (!is_string_empty (user_data_dir), "!is_string_empty(user_data_dir)");
	_tmp0_ = app_dirs_data_dir;
	_vala_assert (_tmp0_ == NULL, "data_dir == null");
	_tmp1_ = strip_pretty_path (user_data_dir);
	path = _tmp1_;
	_tmp2_ = path;
	if (!g_path_is_absolute (_tmp2_)) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		_tmp3_ = app_dirs_get_home_dir ();
		_tmp4_ = _tmp3_;
		_tmp5_ = path;
		_tmp6_ = g_file_get_child (_tmp4_, _tmp5_);
		_g_object_unref0 (app_dirs_data_dir);
		app_dirs_data_dir = _tmp6_;
		_g_object_unref0 (_tmp4_);
	} else {
		const gchar* _tmp7_;
		GFile* _tmp8_;
		_tmp7_ = path;
		_tmp8_ = g_file_new_for_path (_tmp7_);
		_g_object_unref0 (app_dirs_data_dir);
		app_dirs_data_dir = _tmp8_;
	}
	_tmp9_ = app_dirs_data_dir;
	_tmp10_ = g_file_get_path (_tmp9_);
	_tmp11_ = _tmp10_;
	g_message ("AppDirs.vala:95: Setting private data directory to %s", _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (path);
}

void
app_dirs_verify_data_dir (void)
{
	GFile* data_dir = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = app_dirs_get_data_dir ();
	data_dir = _tmp0_;
	{
		GFile* _tmp1_;
		_tmp1_ = data_dir;
		if (!g_file_query_exists (_tmp1_, NULL)) {
			GFile* _tmp2_;
			_tmp2_ = data_dir;
			g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = data_dir;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_strdup_printf (_ ("Unable to create data directory %s: %s"), _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		app_window_panic (_tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (data_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (data_dir);
}

void
app_dirs_verify_cache_dir (void)
{
	GFile* cache_dir = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = app_dirs_get_cache_dir ();
	cache_dir = _tmp0_;
	{
		GFile* _tmp1_;
		_tmp1_ = cache_dir;
		if (!g_file_query_exists (_tmp1_, NULL)) {
			GFile* _tmp2_;
			_tmp2_ = cache_dir;
			g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = cache_dir;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_strdup_printf (_ ("Unable to create cache directory %s: %s"), _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		app_window_panic (_tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (cache_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (cache_dir);
}

/**
     * @brief Returns the build directory if not installed yet, or a path
     * to where any helper applets we need will live if installed.
     */
GFile*
app_dirs_get_libexec_dir (void)
{
	GFile* _tmp0_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* result;
	_tmp0_ = app_dirs_libexec_dir;
	if (_tmp0_ == NULL) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = app_dirs_get_install_dir ();
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_ == NULL;
		_g_object_unref0 (_tmp2_);
		if (_tmp3_) {
			GFile* _tmp4_;
			_tmp4_ = app_dirs_get_exec_dir ();
			_g_object_unref0 (app_dirs_libexec_dir);
			app_dirs_libexec_dir = _tmp4_;
		} else {
			GFile* _tmp5_;
			_tmp5_ = g_file_new_for_path (RESOURCES_LIBEXECDIR);
			_g_object_unref0 (app_dirs_libexec_dir);
			app_dirs_libexec_dir = _tmp5_;
		}
	}
	_tmp6_ = app_dirs_libexec_dir;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

GFile*
app_dirs_get_install_dir (void)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	_tmp0_ = app_dirs_exec_dir;
	_tmp1_ = get_sys_install_dir (_tmp0_);
	result = _tmp1_;
	return result;
}

GFile*
app_dirs_get_data_dir (void)
{
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* result;
	_tmp1_ = app_dirs_data_dir;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp2_ = g_get_user_data_dir ();
		_tmp3_ = g_file_new_for_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_child (_tmp4_, APP_DIRS_DEFAULT_DATA_DIR);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
	} else {
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = app_dirs_data_dir;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp7_;
	}
	result = _tmp0_;
	return result;
}

GFile*
app_dirs_get_import_dir (void)
{
	gchar* path = NULL;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	GFile* result;
	_tmp0_ = config_facade_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = configuration_facade_get_import_dir (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	path = _tmp3_;
	_tmp4_ = path;
	if (!is_string_empty (_tmp4_)) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp13_;
		GFile* _tmp14_;
		_tmp5_ = path;
		_tmp6_ = strip_pretty_path (_tmp5_);
		_g_free0 (path);
		path = _tmp6_;
		_tmp7_ = path;
		if (!g_path_is_absolute (_tmp7_)) {
			GFile* _tmp8_;
			GFile* _tmp9_;
			const gchar* _tmp10_;
			GFile* _tmp11_;
			GFile* _tmp12_;
			_tmp8_ = app_dirs_get_home_dir ();
			_tmp9_ = _tmp8_;
			_tmp10_ = path;
			_tmp11_ = g_file_get_child (_tmp9_, _tmp10_);
			_tmp12_ = _tmp11_;
			_g_object_unref0 (_tmp9_);
			result = _tmp12_;
			_g_free0 (path);
			return result;
		}
		_tmp13_ = path;
		_tmp14_ = g_file_new_for_path (_tmp13_);
		result = _tmp14_;
		_g_free0 (path);
		return result;
	}
	_tmp15_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_tmp16_ = g_strdup (_tmp15_);
	_g_free0 (path);
	path = _tmp16_;
	_tmp17_ = path;
	if (!is_string_empty (_tmp17_)) {
		const gchar* _tmp18_;
		GFile* _tmp19_;
		_tmp18_ = path;
		_tmp19_ = g_file_new_for_path (_tmp18_);
		result = _tmp19_;
		_g_free0 (path);
		return result;
	}
	_tmp20_ = app_dirs_get_home_dir ();
	_tmp21_ = _tmp20_;
	_tmp22_ = g_file_get_child (_tmp21_, _ ("Pictures"));
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp21_);
	result = _tmp23_;
	_g_free0 (path);
	return result;
}

GFile*
app_dirs_get_baked_import_dir (GDateTime* tm)
{
	gchar* pattern = NULL;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp8_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GDateTime* _tmp16_;
	GDateTime* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GFile* result;
	g_return_val_if_fail (tm != NULL, NULL);
	_tmp0_ = config_facade_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = configuration_facade_get_directory_pattern (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	pattern = _tmp3_;
	_tmp4_ = pattern;
	if (is_string_empty (_tmp4_)) {
		ConfigFacade* _tmp5_;
		ConfigFacade* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = config_facade_get_instance ();
		_tmp6_ = _tmp5_;
		_tmp7_ = configuration_facade_get_directory_pattern_custom (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
		_g_free0 (pattern);
		pattern = _tmp7_;
		_g_object_unref0 (_tmp6_);
	}
	_tmp8_ = pattern;
	if (is_string_empty (_tmp8_)) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("%Y" G_DIR_SEPARATOR_S "%m" G_DIR_SEPARATOR_S "%d");
		_g_free0 (pattern);
		pattern = _tmp9_;
	}
	_tmp10_ = app_dirs_get_import_dir ();
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_get_path (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, G_DIR_SEPARATOR_S, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_date_time_to_local (tm);
	_tmp17_ = _tmp16_;
	_tmp18_ = pattern;
	_tmp19_ = g_date_time_format (_tmp17_, _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp15_, _tmp20_, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_file_new_for_path (_tmp22_);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_date_time_unref0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_object_unref0 (_tmp11_);
	result = _tmp24_;
	_g_free0 (pattern);
	return result;
}

gboolean
app_dirs_is_in_import_dir (GFile* file)
{
	GFile* import_dir = NULL;
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = app_dirs_get_import_dir ();
	import_dir = _tmp0_;
	_tmp2_ = import_dir;
	if (g_file_has_prefix (file, _tmp2_)) {
		_tmp1_ = TRUE;
	} else {
		GFile* _tmp3_;
		_tmp3_ = import_dir;
		_tmp1_ = g_file_equal (file, _tmp3_);
	}
	result = _tmp1_;
	_g_object_unref0 (import_dir);
	return result;
}

void
app_dirs_set_import_dir (const gchar* path)
{
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	g_return_if_fail (path != NULL);
	_tmp0_ = config_facade_get_instance ();
	_tmp1_ = _tmp0_;
	configuration_facade_set_import_dir (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), path);
	_g_object_unref0 (_tmp1_);
}

GFile*
app_dirs_get_exec_dir (void)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	_tmp0_ = app_dirs_exec_dir;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

AppDirsRuntime
app_dirs_get_runtime (void)
{
	AppDirsRuntime result;
	if (app_dirs__runtime == APP_DIRS_RUNTIME_UNKNOWN) {
		gchar* snap = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = g_getenv ("SNAP_NAME");
		_tmp1_ = g_strdup (_tmp0_);
		snap = _tmp1_;
		_tmp2_ = snap;
		if (_tmp2_ != NULL) {
			app_dirs__runtime = APP_DIRS_RUNTIME_SNAP;
		} else {
			GFile* flatpak_canary = NULL;
			GFile* _tmp3_;
			GFile* _tmp4_;
			_tmp3_ = g_file_new_for_path ("/.flatpak-info");
			flatpak_canary = _tmp3_;
			_tmp4_ = flatpak_canary;
			if (g_file_query_exists (_tmp4_, NULL)) {
				app_dirs__runtime = APP_DIRS_RUNTIME_FLATPAK;
			} else {
				app_dirs__runtime = APP_DIRS_RUNTIME_NATIVE;
			}
			_g_object_unref0 (flatpak_canary);
		}
		_g_free0 (snap);
	}
	result = app_dirs__runtime;
	return result;
}

GFile*
app_dirs_get_temp_dir (void)
{
	GFile* _tmp0_;
	GFile* _tmp21_;
	GFile* _tmp22_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	_tmp0_ = app_dirs_tmp_dir;
	if (_tmp0_ == NULL) {
		gchar* basedir = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GFile* _tmp11_;
		_tmp1_ = g_get_tmp_dir ();
		_tmp2_ = g_strdup (_tmp1_);
		basedir = _tmp2_;
		if (app_dirs_get_runtime () == APP_DIRS_RUNTIME_FLATPAK) {
			const gchar* _tmp4_;
			_tmp4_ = basedir;
			_tmp3_ = g_strcmp0 (_tmp4_, "/tmp") == 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = g_get_user_cache_dir ();
			_tmp6_ = g_strconcat (_tmp5_, "/tmp", NULL);
			_g_free0 (basedir);
			basedir = _tmp6_;
		}
		_tmp7_ = basedir;
		_tmp8_ = g_strconcat (_tmp7_, "/shotwell-XXXXXX", NULL);
		_tmp9_ = mkdtemp (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_new_for_path (_tmp10_);
		_g_object_unref0 (app_dirs_tmp_dir);
		app_dirs_tmp_dir = _tmp11_;
		_g_free0 (_tmp10_);
		{
			GFile* _tmp12_;
			_tmp12_ = app_dirs_tmp_dir;
			g_file_make_directory_with_parents (_tmp12_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp13_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = err;
			if (!g_error_matches (_tmp13_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				GFile* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				GError* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp14_ = app_dirs_tmp_dir;
				_tmp15_ = g_file_get_path (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = err;
				_tmp18_ = _tmp17_->message;
				_tmp19_ = g_strdup_printf (_ ("Unable to create temporary directory %s: %s"), _tmp16_, _tmp18_);
				_tmp20_ = _tmp19_;
				app_window_panic (_tmp20_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp16_);
			}
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (basedir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (basedir);
	}
	_tmp21_ = app_dirs_tmp_dir;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	result = _tmp22_;
	return result;
}

GFile*
app_dirs_get_data_subdir (const gchar* name,
                          const gchar* subname)
{
	GFile* subdir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = app_dirs_get_data_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, name);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	subdir = _tmp3_;
	if (subname != NULL) {
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = subdir;
		_tmp5_ = g_file_get_child (_tmp4_, subname);
		_g_object_unref0 (subdir);
		subdir = _tmp5_;
	}
	{
		GFile* _tmp6_;
		_tmp6_ = subdir;
		if (!g_file_query_exists (_tmp6_, NULL)) {
			GFile* _tmp7_;
			_tmp7_ = subdir;
			g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = subdir;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = err;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_strdup_printf (_ ("Unable to create data subdirectory %s: %s"), _tmp10_, _tmp12_);
		_tmp14_ = _tmp13_;
		app_window_panic (_tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp10_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (subdir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = subdir;
	return result;
}

void
app_dirs_ensure_writable (GFile* dir)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	if (g_file_query_exists (dir, NULL)) {
		{
			GFileInfo* info = NULL;
			GFileInfo* _tmp0_;
			guint32 mode = 0U;
			GFileInfo* _tmp1_;
			gboolean _tmp2_ = FALSE;
			_tmp0_ = g_file_query_info (dir, G_FILE_ATTRIBUTE_UNIX_MODE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			info = _tmp0_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp1_ = info;
			mode = g_file_info_get_attribute_uint32 (_tmp1_, G_FILE_ATTRIBUTE_UNIX_MODE) | 0700;
			_tmp2_ = g_file_set_attribute_uint32 (dir, G_FILE_ATTRIBUTE_UNIX_MODE, mode, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				goto __catch0_g_error;
			}
			if (!_tmp2_) {
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp3_ = g_file_get_path (dir);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_strdup_printf (_ ("Could not make directory %s writable"), _tmp4_);
				_tmp6_ = _tmp5_;
				app_window_panic (_tmp6_);
				_g_free0 (_tmp6_);
				_g_free0 (_tmp4_);
			}
			_g_object_unref0 (info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			gchar* _tmp7_;
			gchar* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = g_file_get_path (dir);
			_tmp8_ = _tmp7_;
			_tmp9_ = err;
			_tmp10_ = _tmp9_->message;
			_tmp11_ = g_strdup_printf (_ ("Could not make directory %s writable: %s"), _tmp8_, _tmp10_);
			_tmp12_ = _tmp11_;
			app_window_panic (_tmp12_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp8_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

GFile*
app_dirs_get_cache_subdir (const gchar* name,
                           const gchar* subname)
{
	GFile* subdir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp16_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = app_dirs_get_cache_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, name);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	subdir = _tmp3_;
	_tmp4_ = subdir;
	app_dirs_ensure_writable (_tmp4_);
	if (subname != NULL) {
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp5_ = subdir;
		_tmp6_ = g_file_get_child (_tmp5_, subname);
		_g_object_unref0 (subdir);
		subdir = _tmp6_;
	}
	{
		GFile* _tmp7_;
		_tmp7_ = subdir;
		if (!g_file_query_exists (_tmp7_, NULL)) {
			GFile* _tmp8_;
			_tmp8_ = subdir;
			g_file_make_directory_with_parents (_tmp8_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = subdir;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_strdup_printf (_ ("Unable to create data subdirectory %s: %s"), _tmp11_, _tmp13_);
		_tmp15_ = _tmp14_;
		app_window_panic (_tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp11_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (subdir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp16_ = subdir;
	app_dirs_ensure_writable (_tmp16_);
	result = subdir;
	return result;
}

GFile*
app_dirs_get_resources_dir (void)
{
	GFile* install_dir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFile* result;
	_tmp0_ = app_dirs_get_install_dir ();
	install_dir = _tmp0_;
	_tmp2_ = install_dir;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp3_ = install_dir;
		_tmp4_ = g_file_get_child (_tmp3_, "share");
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_child (_tmp5_, "shotwell");
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	} else {
		GFile* _tmp7_;
		_tmp7_ = app_dirs_get_lib_dir ();
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp7_;
	}
	result = _tmp1_;
	_g_object_unref0 (install_dir);
	return result;
}

GFile*
app_dirs_get_lib_dir (void)
{
	GFile* install_dir = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* result;
	_tmp0_ = app_dirs_get_install_dir ();
	install_dir = _tmp0_;
	_tmp1_ = install_dir;
	if (_tmp1_ == NULL) {
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_;
		GFile* _tmp11_;
		_tmp2_ = app_dirs_get_exec_dir ();
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_str_has_suffix (_tmp5_, "src");
		_g_free0 (_tmp5_);
		_g_object_unref0 (_tmp3_);
		if (_tmp6_) {
			GFile* _tmp7_;
			GFile* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			_tmp7_ = app_dirs_get_exec_dir ();
			_tmp8_ = _tmp7_;
			_tmp9_ = g_file_get_parent (_tmp8_);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp8_);
			result = _tmp10_;
			_g_object_unref0 (install_dir);
			return result;
		}
		_tmp11_ = app_dirs_get_exec_dir ();
		result = _tmp11_;
		_g_object_unref0 (install_dir);
		return result;
	}
	_tmp12_ = install_dir;
	_tmp13_ = g_file_get_child (_tmp12_, RESOURCES_LIB);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_get_child (_tmp14_, "shotwell");
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp14_);
	result = _tmp16_;
	_g_object_unref0 (install_dir);
	return result;
}

GFile*
app_dirs_get_system_plugins_dir (void)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	_tmp0_ = app_dirs_get_lib_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, "plugins");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

GFile*
app_dirs_get_user_plugins_dir (void)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	_tmp0_ = app_dirs_get_data_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, "plugins");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

GFile*
app_dirs_get_log_file (void)
{
	const gchar* _tmp0_;
	GFile* result;
	_tmp0_ = g_getenv ("SHOTWELL_LOG_FILE");
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = g_getenv ("SHOTWELL_LOG_FILE");
		if (g_strcmp0 (_tmp1_, ":console:") == 0) {
			result = NULL;
			return result;
		} else {
			const gchar* _tmp2_;
			GFile* _tmp3_;
			_tmp2_ = g_getenv ("SHOTWELL_LOG_FILE");
			_tmp3_ = g_file_new_for_path (_tmp2_);
			result = _tmp3_;
			return result;
		}
	} else {
		const gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		_tmp4_ = g_get_user_cache_dir ();
		_tmp5_ = g_file_new_for_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_get_child (_tmp6_, "shotwell");
		_tmp8_ = _tmp7_;
		_tmp9_ = g_file_get_child (_tmp8_, "shotwell.log");
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (_tmp6_);
		result = _tmp10_;
		return result;
	}
}

GFile*
app_dirs_get_thumbnailer_bin (void)
{
	static const char filename[] = "shotwell-video-thumbnailer";
	GFile* f = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp12_;
	GFile* result;
	_tmp0_ = app_dirs_get_libexec_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, "thumbnailer");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_child (_tmp3_, filename);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	f = _tmp5_;
	_tmp6_ = f;
	if (!g_file_query_exists (_tmp6_, NULL)) {
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		_tmp7_ = app_dirs_get_libexec_dir ();
		_tmp8_ = _tmp7_;
		_tmp9_ = g_file_get_child (_tmp8_, "shotwell");
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_get_child (_tmp10_, filename);
		_g_object_unref0 (f);
		f = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp8_);
	}
	_tmp12_ = f;
	if (!g_file_query_exists (_tmp12_, NULL)) {
		GFile* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		_tmp13_ = app_dirs_get_libexec_dir ();
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_get_parent (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_file_get_child (_tmp16_, "thumbnailer");
		_tmp18_ = _tmp17_;
		_tmp19_ = g_file_get_child (_tmp18_, filename);
		_g_object_unref0 (f);
		f = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (_tmp14_);
	}
	result = f;
	return result;
}

GFile*
app_dirs_get_metadata_helper (void)
{
	static const char filename[] = "shotwell-video-metadata-handler";
	GFile* f = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* result;
	_tmp0_ = app_dirs_get_libexec_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, "video-support");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_child (_tmp3_, filename);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	f = _tmp5_;
	_tmp6_ = f;
	if (!g_file_query_exists (_tmp6_, NULL)) {
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		_tmp7_ = app_dirs_get_libexec_dir ();
		_tmp8_ = _tmp7_;
		_tmp9_ = g_file_get_child (_tmp8_, "shotwell");
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_get_child (_tmp10_, filename);
		_g_object_unref0 (f);
		f = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp8_);
	}
	result = f;
	return result;
}

GFile*
app_dirs_get_settings_migrator_bin (void)
{
	static const char filename[] = "shotwell-settings-migrator";
	GFile* f = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp12_;
	GFile* result;
	_tmp0_ = app_dirs_get_libexec_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_child (_tmp1_, "settings-migrator");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_child (_tmp3_, filename);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	f = _tmp5_;
	_tmp6_ = f;
	if (!g_file_query_exists (_tmp6_, NULL)) {
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		_tmp7_ = app_dirs_get_libexec_dir ();
		_tmp8_ = _tmp7_;
		_tmp9_ = g_file_get_child (_tmp8_, "shotwell");
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_get_child (_tmp10_, filename);
		_g_object_unref0 (f);
		f = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (_tmp8_);
	}
	_tmp12_ = f;
	if (!g_file_query_exists (_tmp12_, NULL)) {
		GFile* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		_tmp13_ = app_dirs_get_libexec_dir ();
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_get_parent (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_file_get_child (_tmp16_, "settings-migrator");
		_tmp18_ = _tmp17_;
		_tmp19_ = g_file_get_child (_tmp18_, filename);
		_g_object_unref0 (f);
		f = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (_tmp14_);
	}
	result = f;
	return result;
}

GFile*
app_dirs_get_haarcascade_file (void)
{
	static const char filename[] = "facedetect-haarcascade.xml";
	GFile* f = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* result;
	_tmp0_ = app_dirs_get_resources_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_child (_tmp3_, "subprojects");
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_child (_tmp5_, "shotwell-facedetect");
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_get_child (_tmp7_, filename);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	f = _tmp9_;
	_tmp10_ = f;
	if (g_file_query_exists (_tmp10_, NULL)) {
		result = f;
		return result;
	}
	_tmp11_ = app_dirs_get_resources_dir ();
	_tmp12_ = _tmp11_;
	_tmp13_ = g_file_get_child (_tmp12_, "facedetect-haarcascade.xml");
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp12_);
	result = _tmp14_;
	_g_object_unref0 (f);
	return result;
}

AppDirs*
app_dirs_construct (GType object_type)
{
	AppDirs* self = NULL;
	self = (AppDirs*) g_type_create_instance (object_type);
	return self;
}

AppDirs*
app_dirs_new (void)
{
	return app_dirs_construct (TYPE_APP_DIRS);
}

static void
value_app_dirs_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_app_dirs_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		app_dirs_unref (value->data[0].v_pointer);
	}
}

static void
value_app_dirs_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = app_dirs_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_app_dirs_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_app_dirs_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AppDirs * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = app_dirs_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_app_dirs_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	AppDirs ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = app_dirs_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_app_dirs (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecAppDirs* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_APP_DIRS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_app_dirs (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APP_DIRS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_app_dirs (GValue* value,
                    gpointer v_object)
{
	AppDirs * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APP_DIRS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APP_DIRS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		app_dirs_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		app_dirs_unref (old);
	}
}

void
value_take_app_dirs (GValue* value,
                     gpointer v_object)
{
	AppDirs * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_APP_DIRS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_APP_DIRS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		app_dirs_unref (old);
	}
}

static void
app_dirs_class_init (AppDirsClass * klass,
                     gpointer klass_data)
{
	app_dirs_parent_class = g_type_class_peek_parent (klass);
	((AppDirsClass *) klass)->finalize = app_dirs_finalize;
}

static void
app_dirs_instance_init (AppDirs * self,
                        gpointer klass)
{
	self->ref_count = 1;
}

static void
app_dirs_finalize (AppDirs * obj)
{
	AppDirs * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_DIRS, AppDirs);
	g_signal_handlers_destroy (self);
}

static GType
app_dirs_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_app_dirs_init, value_app_dirs_free_value, value_app_dirs_copy_value, value_app_dirs_peek_pointer, "p", value_app_dirs_collect_value, "p", value_app_dirs_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AppDirsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_dirs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppDirs), 0, (GInstanceInitFunc) app_dirs_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType app_dirs_type_id;
	app_dirs_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AppDirs", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return app_dirs_type_id;
}

GType
app_dirs_get_type (void)
{
	static volatile gsize app_dirs_type_id__once = 0;
	if (g_once_init_enter (&app_dirs_type_id__once)) {
		GType app_dirs_type_id;
		app_dirs_type_id = app_dirs_get_type_once ();
		g_once_init_leave (&app_dirs_type_id__once, app_dirs_type_id);
	}
	return app_dirs_type_id__once;
}

gpointer
app_dirs_ref (gpointer instance)
{
	AppDirs * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
app_dirs_unref (gpointer instance)
{
	AppDirs * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		APP_DIRS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

