/* BackgroundProgressBar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackgroundProgressBar.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#define BACKGROUND_PROGRESS_BAR_PULSE_MSEC 250
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BACKGROUND_PROGRESS_BAR (background_progress_bar_get_type ())
#define BACKGROUND_PROGRESS_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_PROGRESS_BAR, BackgroundProgressBar))
#define BACKGROUND_PROGRESS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_PROGRESS_BAR, BackgroundProgressBarClass))
#define IS_BACKGROUND_PROGRESS_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_PROGRESS_BAR))
#define IS_BACKGROUND_PROGRESS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_PROGRESS_BAR))
#define BACKGROUND_PROGRESS_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_PROGRESS_BAR, BackgroundProgressBarClass))

typedef struct _BackgroundProgressBar BackgroundProgressBar;
typedef struct _BackgroundProgressBarClass BackgroundProgressBarClass;
typedef struct _BackgroundProgressBarPrivate BackgroundProgressBarPrivate;
typedef enum  {
	BACKGROUND_PROGRESS_BAR_PRIORITY_NONE = 0,
	BACKGROUND_PROGRESS_BAR_PRIORITY_STARTUP_SCAN = 35,
	BACKGROUND_PROGRESS_BAR_PRIORITY_REALTIME_UPDATE = 40,
	BACKGROUND_PROGRESS_BAR_PRIORITY_REALTIME_IMPORT = 50,
	BACKGROUND_PROGRESS_BAR_PRIORITY_METADATA_WRITER = 30
} BackgroundProgressBarPriority;

#define BACKGROUND_PROGRESS_BAR_TYPE_PRIORITY (background_progress_bar_priority_get_type ())
enum  {
	BACKGROUND_PROGRESS_BAR_0_PROPERTY,
	BACKGROUND_PROGRESS_BAR_SHOULD_BE_VISIBLE_PROPERTY,
	BACKGROUND_PROGRESS_BAR_NUM_PROPERTIES
};
static GParamSpec* background_progress_bar_properties[BACKGROUND_PROGRESS_BAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BackgroundProgressBar {
	GtkProgressBar parent_instance;
	BackgroundProgressBarPrivate * priv;
};

struct _BackgroundProgressBarClass {
	GtkProgressBarClass parent_class;
};

struct _BackgroundProgressBarPrivate {
	gboolean _should_be_visible;
	BackgroundProgressBarPriority current_priority;
	guint pulse_id;
};

static gint BackgroundProgressBar_private_offset;
static gpointer background_progress_bar_parent_class = NULL;

VALA_EXTERN GType background_progress_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundProgressBar, g_object_unref)
VALA_EXTERN GType background_progress_bar_priority_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BackgroundProgressBar* background_progress_bar_new (void);
VALA_EXTERN BackgroundProgressBar* background_progress_bar_construct (GType object_type);
VALA_EXTERN void background_progress_bar_start (BackgroundProgressBar* self,
                                    const gchar* label,
                                    BackgroundProgressBarPriority priority);
VALA_EXTERN void background_progress_bar_stop (BackgroundProgressBar* self,
                                   BackgroundProgressBarPriority priority,
                                   gboolean clear);
static void background_progress_bar_set_should_be_visible (BackgroundProgressBar* self,
                                                    gboolean value);
static gboolean background_progress_bar_on_pulse_timeout (BackgroundProgressBar* self);
static gboolean _background_progress_bar_on_pulse_timeout_gsource_func (gpointer self);
VALA_EXTERN void background_progress_bar_clear (BackgroundProgressBar* self,
                                    BackgroundProgressBarPriority priority);
VALA_EXTERN gboolean background_progress_bar_update (BackgroundProgressBar* self,
                                         const gchar* label,
                                         BackgroundProgressBarPriority priority,
                                         gdouble count,
                                         gdouble total);
VALA_EXTERN gboolean background_progress_bar_get_should_be_visible (BackgroundProgressBar* self);
static void background_progress_bar_finalize (GObject * obj);
static GType background_progress_bar_get_type_once (void);
static void _vala_background_progress_bar_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_background_progress_bar_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
background_progress_bar_get_instance_private (BackgroundProgressBar* self)
{
	return G_STRUCT_MEMBER_P (self, BackgroundProgressBar_private_offset);
}

static GType
background_progress_bar_priority_get_type_once (void)
{
	static const GEnumValue values[] = {{BACKGROUND_PROGRESS_BAR_PRIORITY_NONE, "BACKGROUND_PROGRESS_BAR_PRIORITY_NONE", "none"}, {BACKGROUND_PROGRESS_BAR_PRIORITY_STARTUP_SCAN, "BACKGROUND_PROGRESS_BAR_PRIORITY_STARTUP_SCAN", "startup-scan"}, {BACKGROUND_PROGRESS_BAR_PRIORITY_REALTIME_UPDATE, "BACKGROUND_PROGRESS_BAR_PRIORITY_REALTIME_UPDATE", "realtime-update"}, {BACKGROUND_PROGRESS_BAR_PRIORITY_REALTIME_IMPORT, "BACKGROUND_PROGRESS_BAR_PRIORITY_REALTIME_IMPORT", "realtime-import"}, {BACKGROUND_PROGRESS_BAR_PRIORITY_METADATA_WRITER, "BACKGROUND_PROGRESS_BAR_PRIORITY_METADATA_WRITER", "metadata-writer"}, {0, NULL, NULL}};
	GType background_progress_bar_priority_type_id;
	background_progress_bar_priority_type_id = g_enum_register_static ("BackgroundProgressBarPriority", values);
	return background_progress_bar_priority_type_id;
}

GType
background_progress_bar_priority_get_type (void)
{
	static volatile gsize background_progress_bar_priority_type_id__once = 0;
	if (g_once_init_enter (&background_progress_bar_priority_type_id__once)) {
		GType background_progress_bar_priority_type_id;
		background_progress_bar_priority_type_id = background_progress_bar_priority_get_type_once ();
		g_once_init_leave (&background_progress_bar_priority_type_id__once, background_progress_bar_priority_type_id);
	}
	return background_progress_bar_priority_type_id__once;
}

BackgroundProgressBar*
background_progress_bar_construct (GType object_type)
{
	BackgroundProgressBar * self = NULL;
	self = (BackgroundProgressBar*) g_object_new (object_type, "show-text", TRUE, NULL);
	return self;
}

BackgroundProgressBar*
background_progress_bar_new (void)
{
	return background_progress_bar_construct (TYPE_BACKGROUND_PROGRESS_BAR);
}

static gboolean
_background_progress_bar_on_pulse_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = background_progress_bar_on_pulse_timeout ((BackgroundProgressBar*) self);
	return result;
}

void
background_progress_bar_start (BackgroundProgressBar* self,
                               const gchar* label,
                               BackgroundProgressBarPriority priority)
{
	g_return_if_fail (IS_BACKGROUND_PROGRESS_BAR (self));
	g_return_if_fail (label != NULL);
	if (priority < self->priv->current_priority) {
		return;
	}
	background_progress_bar_stop (self, priority, FALSE);
	self->priv->current_priority = priority;
	gtk_progress_bar_set_text (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_progress_bar_get_type (), GtkProgressBar), label);
	gtk_progress_bar_pulse (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_progress_bar_get_type (), GtkProgressBar));
	background_progress_bar_set_should_be_visible (self, TRUE);
	self->priv->pulse_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BACKGROUND_PROGRESS_BAR_PULSE_MSEC, _background_progress_bar_on_pulse_timeout_gsource_func, g_object_ref (self), g_object_unref);
}

void
background_progress_bar_stop (BackgroundProgressBar* self,
                              BackgroundProgressBarPriority priority,
                              gboolean clear)
{
	g_return_if_fail (IS_BACKGROUND_PROGRESS_BAR (self));
	if (priority < self->priv->current_priority) {
		return;
	}
	if (self->priv->pulse_id != ((guint) 0)) {
		g_source_remove (self->priv->pulse_id);
		self->priv->pulse_id = (guint) 0;
	}
	if (clear) {
		background_progress_bar_clear (self, priority);
	}
}

gboolean
background_progress_bar_update (BackgroundProgressBar* self,
                                const gchar* label,
                                BackgroundProgressBarPriority priority,
                                gdouble count,
                                gdouble total)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gdouble fraction = 0.0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (IS_BACKGROUND_PROGRESS_BAR (self), FALSE);
	g_return_val_if_fail (label != NULL, FALSE);
	if (priority < self->priv->current_priority) {
		result = FALSE;
		return result;
	}
	background_progress_bar_stop (self, priority, FALSE);
	if (count <= 0.0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = total <= 0.0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = count >= total;
	}
	if (_tmp0_) {
		background_progress_bar_clear (self, priority);
		result = FALSE;
		return result;
	}
	self->priv->current_priority = priority;
	fraction = count / total;
	gtk_progress_bar_set_fraction (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_progress_bar_get_type (), GtkProgressBar), fraction);
	_tmp2_ = g_strdup_printf (_ ("%s (%d%%)"), label, (gint) (fraction * 100.0));
	_tmp3_ = _tmp2_;
	gtk_progress_bar_set_text (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_progress_bar_get_type (), GtkProgressBar), _tmp3_);
	_g_free0 (_tmp3_);
	background_progress_bar_set_should_be_visible (self, TRUE);
	result = TRUE;
	return result;
}

void
background_progress_bar_clear (BackgroundProgressBar* self,
                               BackgroundProgressBarPriority priority)
{
	g_return_if_fail (IS_BACKGROUND_PROGRESS_BAR (self));
	if (priority < self->priv->current_priority) {
		return;
	}
	background_progress_bar_stop (self, priority, FALSE);
	self->priv->current_priority = 0;
	gtk_progress_bar_set_fraction (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_progress_bar_get_type (), GtkProgressBar), 0.0);
	gtk_progress_bar_set_text (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_progress_bar_get_type (), GtkProgressBar), "");
	background_progress_bar_set_should_be_visible (self, FALSE);
}

static gboolean
background_progress_bar_on_pulse_timeout (BackgroundProgressBar* self)
{
	gboolean result;
	g_return_val_if_fail (IS_BACKGROUND_PROGRESS_BAR (self), FALSE);
	gtk_progress_bar_pulse (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_progress_bar_get_type (), GtkProgressBar));
	result = TRUE;
	return result;
}

gboolean
background_progress_bar_get_should_be_visible (BackgroundProgressBar* self)
{
	gboolean result;
	g_return_val_if_fail (IS_BACKGROUND_PROGRESS_BAR (self), FALSE);
	result = self->priv->_should_be_visible;
	return result;
}

static void
background_progress_bar_set_should_be_visible (BackgroundProgressBar* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (IS_BACKGROUND_PROGRESS_BAR (self));
	old_value = background_progress_bar_get_should_be_visible (self);
	if (old_value != value) {
		self->priv->_should_be_visible = value;
		g_object_notify_by_pspec ((GObject *) self, background_progress_bar_properties[BACKGROUND_PROGRESS_BAR_SHOULD_BE_VISIBLE_PROPERTY]);
	}
}

static void
background_progress_bar_class_init (BackgroundProgressBarClass * klass,
                                    gpointer klass_data)
{
	background_progress_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BackgroundProgressBar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_background_progress_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_background_progress_bar_set_property;
	G_OBJECT_CLASS (klass)->finalize = background_progress_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_PROGRESS_BAR_SHOULD_BE_VISIBLE_PROPERTY, background_progress_bar_properties[BACKGROUND_PROGRESS_BAR_SHOULD_BE_VISIBLE_PROPERTY] = g_param_spec_boolean ("should-be-visible", "should-be-visible", "should-be-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
background_progress_bar_instance_init (BackgroundProgressBar * self,
                                       gpointer klass)
{
	self->priv = background_progress_bar_get_instance_private (self);
	self->priv->_should_be_visible = FALSE;
	self->priv->current_priority = BACKGROUND_PROGRESS_BAR_PRIORITY_NONE;
	self->priv->pulse_id = (guint) 0;
}

static void
background_progress_bar_finalize (GObject * obj)
{
	BackgroundProgressBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKGROUND_PROGRESS_BAR, BackgroundProgressBar);
	G_OBJECT_CLASS (background_progress_bar_parent_class)->finalize (obj);
}

static GType
background_progress_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackgroundProgressBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_progress_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackgroundProgressBar), 0, (GInstanceInitFunc) background_progress_bar_instance_init, NULL };
	GType background_progress_bar_type_id;
	background_progress_bar_type_id = g_type_register_static (gtk_progress_bar_get_type (), "BackgroundProgressBar", &g_define_type_info, 0);
	BackgroundProgressBar_private_offset = g_type_add_instance_private (background_progress_bar_type_id, sizeof (BackgroundProgressBarPrivate));
	return background_progress_bar_type_id;
}

GType
background_progress_bar_get_type (void)
{
	static volatile gsize background_progress_bar_type_id__once = 0;
	if (g_once_init_enter (&background_progress_bar_type_id__once)) {
		GType background_progress_bar_type_id;
		background_progress_bar_type_id = background_progress_bar_get_type_once ();
		g_once_init_leave (&background_progress_bar_type_id__once, background_progress_bar_type_id);
	}
	return background_progress_bar_type_id__once;
}

static void
_vala_background_progress_bar_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	BackgroundProgressBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BACKGROUND_PROGRESS_BAR, BackgroundProgressBar);
	switch (property_id) {
		case BACKGROUND_PROGRESS_BAR_SHOULD_BE_VISIBLE_PROPERTY:
		g_value_set_boolean (value, background_progress_bar_get_should_be_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_background_progress_bar_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	BackgroundProgressBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BACKGROUND_PROGRESS_BAR, BackgroundProgressBar);
	switch (property_id) {
		case BACKGROUND_PROGRESS_BAR_SHOULD_BE_VISIBLE_PROPERTY:
		background_progress_bar_set_should_be_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

