// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by "deep-copy -type AddressSpecSpec -type AddressStatusSpec -type DNSResolveCacheSpec -type EthernetSpecSpec -type EthernetStatusSpec -type HardwareAddrSpec -type HostDNSConfigSpec -type HostnameSpecSpec -type HostnameStatusSpec -type LinkRefreshSpec -type LinkSpecSpec -type LinkStatusSpec -type NfTablesChainSpec -type NodeAddressSpec -type NodeAddressSortAlgorithmSpec -type NodeAddressFilterSpec -type OperatorSpecSpec -type ProbeSpecSpec -type ProbeStatusSpec -type ResolverSpecSpec -type ResolverStatusSpec -type RouteSpecSpec -type RouteStatusSpec -type StatusSpec -type TimeServerSpecSpec -type TimeServerStatusSpec -header-file ../../../../hack/boilerplate.txt -o deep_copy.generated.go ."; DO NOT EDIT.

package network

import (
	"net/netip"

	"github.com/siderolabs/talos/pkg/machinery/nethelpers"
)

// DeepCopy generates a deep copy of AddressSpecSpec.
func (o AddressSpecSpec) DeepCopy() AddressSpecSpec {
	var cp AddressSpecSpec = o
	return cp
}

// DeepCopy generates a deep copy of AddressStatusSpec.
func (o AddressStatusSpec) DeepCopy() AddressStatusSpec {
	var cp AddressStatusSpec = o
	return cp
}

// DeepCopy generates a deep copy of DNSResolveCacheSpec.
func (o DNSResolveCacheSpec) DeepCopy() DNSResolveCacheSpec {
	var cp DNSResolveCacheSpec = o
	return cp
}

// DeepCopy generates a deep copy of EthernetSpecSpec.
func (o EthernetSpecSpec) DeepCopy() EthernetSpecSpec {
	var cp EthernetSpecSpec = o
	if o.Rings.RX != nil {
		cp.Rings.RX = new(uint32)
		*cp.Rings.RX = *o.Rings.RX
	}
	if o.Rings.TX != nil {
		cp.Rings.TX = new(uint32)
		*cp.Rings.TX = *o.Rings.TX
	}
	if o.Rings.RXMini != nil {
		cp.Rings.RXMini = new(uint32)
		*cp.Rings.RXMini = *o.Rings.RXMini
	}
	if o.Rings.RXJumbo != nil {
		cp.Rings.RXJumbo = new(uint32)
		*cp.Rings.RXJumbo = *o.Rings.RXJumbo
	}
	if o.Rings.RXBufLen != nil {
		cp.Rings.RXBufLen = new(uint32)
		*cp.Rings.RXBufLen = *o.Rings.RXBufLen
	}
	if o.Rings.CQESize != nil {
		cp.Rings.CQESize = new(uint32)
		*cp.Rings.CQESize = *o.Rings.CQESize
	}
	if o.Rings.TXPush != nil {
		cp.Rings.TXPush = new(bool)
		*cp.Rings.TXPush = *o.Rings.TXPush
	}
	if o.Rings.RXPush != nil {
		cp.Rings.RXPush = new(bool)
		*cp.Rings.RXPush = *o.Rings.RXPush
	}
	if o.Rings.TXPushBufLen != nil {
		cp.Rings.TXPushBufLen = new(uint32)
		*cp.Rings.TXPushBufLen = *o.Rings.TXPushBufLen
	}
	if o.Rings.TCPDataSplit != nil {
		cp.Rings.TCPDataSplit = new(bool)
		*cp.Rings.TCPDataSplit = *o.Rings.TCPDataSplit
	}
	if o.Features != nil {
		cp.Features = make(map[string]bool, len(o.Features))
		for k2, v2 := range o.Features {
			cp.Features[k2] = v2
		}
	}
	if o.Channels.RX != nil {
		cp.Channels.RX = new(uint32)
		*cp.Channels.RX = *o.Channels.RX
	}
	if o.Channels.TX != nil {
		cp.Channels.TX = new(uint32)
		*cp.Channels.TX = *o.Channels.TX
	}
	if o.Channels.Other != nil {
		cp.Channels.Other = new(uint32)
		*cp.Channels.Other = *o.Channels.Other
	}
	if o.Channels.Combined != nil {
		cp.Channels.Combined = new(uint32)
		*cp.Channels.Combined = *o.Channels.Combined
	}
	return cp
}

// DeepCopy generates a deep copy of EthernetStatusSpec.
func (o EthernetStatusSpec) DeepCopy() EthernetStatusSpec {
	var cp EthernetStatusSpec = o
	if o.LinkState != nil {
		cp.LinkState = new(bool)
		*cp.LinkState = *o.LinkState
	}
	if o.OurModes != nil {
		cp.OurModes = make([]string, len(o.OurModes))
		copy(cp.OurModes, o.OurModes)
	}
	if o.PeerModes != nil {
		cp.PeerModes = make([]string, len(o.PeerModes))
		copy(cp.PeerModes, o.PeerModes)
	}
	if o.Rings != nil {
		cp.Rings = new(EthernetRingsStatus)
		*cp.Rings = *o.Rings
		if o.Rings.RXMax != nil {
			cp.Rings.RXMax = new(uint32)
			*cp.Rings.RXMax = *o.Rings.RXMax
		}
		if o.Rings.RXMiniMax != nil {
			cp.Rings.RXMiniMax = new(uint32)
			*cp.Rings.RXMiniMax = *o.Rings.RXMiniMax
		}
		if o.Rings.RXJumboMax != nil {
			cp.Rings.RXJumboMax = new(uint32)
			*cp.Rings.RXJumboMax = *o.Rings.RXJumboMax
		}
		if o.Rings.TXMax != nil {
			cp.Rings.TXMax = new(uint32)
			*cp.Rings.TXMax = *o.Rings.TXMax
		}
		if o.Rings.TXPushBufLenMax != nil {
			cp.Rings.TXPushBufLenMax = new(uint32)
			*cp.Rings.TXPushBufLenMax = *o.Rings.TXPushBufLenMax
		}
		if o.Rings.RX != nil {
			cp.Rings.RX = new(uint32)
			*cp.Rings.RX = *o.Rings.RX
		}
		if o.Rings.RXMini != nil {
			cp.Rings.RXMini = new(uint32)
			*cp.Rings.RXMini = *o.Rings.RXMini
		}
		if o.Rings.RXJumbo != nil {
			cp.Rings.RXJumbo = new(uint32)
			*cp.Rings.RXJumbo = *o.Rings.RXJumbo
		}
		if o.Rings.TX != nil {
			cp.Rings.TX = new(uint32)
			*cp.Rings.TX = *o.Rings.TX
		}
		if o.Rings.RXBufLen != nil {
			cp.Rings.RXBufLen = new(uint32)
			*cp.Rings.RXBufLen = *o.Rings.RXBufLen
		}
		if o.Rings.CQESize != nil {
			cp.Rings.CQESize = new(uint32)
			*cp.Rings.CQESize = *o.Rings.CQESize
		}
		if o.Rings.TXPush != nil {
			cp.Rings.TXPush = new(bool)
			*cp.Rings.TXPush = *o.Rings.TXPush
		}
		if o.Rings.RXPush != nil {
			cp.Rings.RXPush = new(bool)
			*cp.Rings.RXPush = *o.Rings.RXPush
		}
		if o.Rings.TXPushBufLen != nil {
			cp.Rings.TXPushBufLen = new(uint32)
			*cp.Rings.TXPushBufLen = *o.Rings.TXPushBufLen
		}
		if o.Rings.TCPDataSplit != nil {
			cp.Rings.TCPDataSplit = new(bool)
			*cp.Rings.TCPDataSplit = *o.Rings.TCPDataSplit
		}
	}
	if o.Features != nil {
		cp.Features = make([]EthernetFeatureStatus, len(o.Features))
		copy(cp.Features, o.Features)
	}
	if o.Channels != nil {
		cp.Channels = new(EthernetChannelsStatus)
		*cp.Channels = *o.Channels
		if o.Channels.RXMax != nil {
			cp.Channels.RXMax = new(uint32)
			*cp.Channels.RXMax = *o.Channels.RXMax
		}
		if o.Channels.TXMax != nil {
			cp.Channels.TXMax = new(uint32)
			*cp.Channels.TXMax = *o.Channels.TXMax
		}
		if o.Channels.OtherMax != nil {
			cp.Channels.OtherMax = new(uint32)
			*cp.Channels.OtherMax = *o.Channels.OtherMax
		}
		if o.Channels.CombinedMax != nil {
			cp.Channels.CombinedMax = new(uint32)
			*cp.Channels.CombinedMax = *o.Channels.CombinedMax
		}
		if o.Channels.RX != nil {
			cp.Channels.RX = new(uint32)
			*cp.Channels.RX = *o.Channels.RX
		}
		if o.Channels.TX != nil {
			cp.Channels.TX = new(uint32)
			*cp.Channels.TX = *o.Channels.TX
		}
		if o.Channels.Other != nil {
			cp.Channels.Other = new(uint32)
			*cp.Channels.Other = *o.Channels.Other
		}
		if o.Channels.Combined != nil {
			cp.Channels.Combined = new(uint32)
			*cp.Channels.Combined = *o.Channels.Combined
		}
	}
	return cp
}

// DeepCopy generates a deep copy of HardwareAddrSpec.
func (o HardwareAddrSpec) DeepCopy() HardwareAddrSpec {
	var cp HardwareAddrSpec = o
	if o.HardwareAddr != nil {
		cp.HardwareAddr = make([]byte, len(o.HardwareAddr))
		copy(cp.HardwareAddr, o.HardwareAddr)
	}
	return cp
}

// DeepCopy generates a deep copy of HostDNSConfigSpec.
func (o HostDNSConfigSpec) DeepCopy() HostDNSConfigSpec {
	var cp HostDNSConfigSpec = o
	if o.ListenAddresses != nil {
		cp.ListenAddresses = make([]netip.AddrPort, len(o.ListenAddresses))
		copy(cp.ListenAddresses, o.ListenAddresses)
	}
	return cp
}

// DeepCopy generates a deep copy of HostnameSpecSpec.
func (o HostnameSpecSpec) DeepCopy() HostnameSpecSpec {
	var cp HostnameSpecSpec = o
	return cp
}

// DeepCopy generates a deep copy of HostnameStatusSpec.
func (o HostnameStatusSpec) DeepCopy() HostnameStatusSpec {
	var cp HostnameStatusSpec = o
	return cp
}

// DeepCopy generates a deep copy of LinkRefreshSpec.
func (o LinkRefreshSpec) DeepCopy() LinkRefreshSpec {
	var cp LinkRefreshSpec = o
	return cp
}

// DeepCopy generates a deep copy of LinkSpecSpec.
func (o LinkSpecSpec) DeepCopy() LinkSpecSpec {
	var cp LinkSpecSpec = o
	if o.Wireguard.Peers != nil {
		cp.Wireguard.Peers = make([]WireguardPeer, len(o.Wireguard.Peers))
		copy(cp.Wireguard.Peers, o.Wireguard.Peers)
		for i3 := range o.Wireguard.Peers {
			if o.Wireguard.Peers[i3].AllowedIPs != nil {
				cp.Wireguard.Peers[i3].AllowedIPs = make([]netip.Prefix, len(o.Wireguard.Peers[i3].AllowedIPs))
				copy(cp.Wireguard.Peers[i3].AllowedIPs, o.Wireguard.Peers[i3].AllowedIPs)
			}
		}
	}
	return cp
}

// DeepCopy generates a deep copy of LinkStatusSpec.
func (o LinkStatusSpec) DeepCopy() LinkStatusSpec {
	var cp LinkStatusSpec = o
	if o.AltNames != nil {
		cp.AltNames = make([]string, len(o.AltNames))
		copy(cp.AltNames, o.AltNames)
	}
	if o.HardwareAddr != nil {
		cp.HardwareAddr = make([]byte, len(o.HardwareAddr))
		copy(cp.HardwareAddr, o.HardwareAddr)
	}
	if o.PermanentAddr != nil {
		cp.PermanentAddr = make([]byte, len(o.PermanentAddr))
		copy(cp.PermanentAddr, o.PermanentAddr)
	}
	if o.BroadcastAddr != nil {
		cp.BroadcastAddr = make([]byte, len(o.BroadcastAddr))
		copy(cp.BroadcastAddr, o.BroadcastAddr)
	}
	if o.Wireguard.Peers != nil {
		cp.Wireguard.Peers = make([]WireguardPeer, len(o.Wireguard.Peers))
		copy(cp.Wireguard.Peers, o.Wireguard.Peers)
		for i3 := range o.Wireguard.Peers {
			if o.Wireguard.Peers[i3].AllowedIPs != nil {
				cp.Wireguard.Peers[i3].AllowedIPs = make([]netip.Prefix, len(o.Wireguard.Peers[i3].AllowedIPs))
				copy(cp.Wireguard.Peers[i3].AllowedIPs, o.Wireguard.Peers[i3].AllowedIPs)
			}
		}
	}
	return cp
}

// DeepCopy generates a deep copy of NfTablesChainSpec.
func (o NfTablesChainSpec) DeepCopy() NfTablesChainSpec {
	var cp NfTablesChainSpec = o
	if o.Rules != nil {
		cp.Rules = make([]NfTablesRule, len(o.Rules))
		copy(cp.Rules, o.Rules)
		for i2 := range o.Rules {
			if o.Rules[i2].MatchIIfName != nil {
				cp.Rules[i2].MatchIIfName = new(NfTablesIfNameMatch)
				*cp.Rules[i2].MatchIIfName = *o.Rules[i2].MatchIIfName
				if o.Rules[i2].MatchIIfName.InterfaceNames != nil {
					cp.Rules[i2].MatchIIfName.InterfaceNames = make([]string, len(o.Rules[i2].MatchIIfName.InterfaceNames))
					copy(cp.Rules[i2].MatchIIfName.InterfaceNames, o.Rules[i2].MatchIIfName.InterfaceNames)
				}
			}
			if o.Rules[i2].MatchOIfName != nil {
				cp.Rules[i2].MatchOIfName = new(NfTablesIfNameMatch)
				*cp.Rules[i2].MatchOIfName = *o.Rules[i2].MatchOIfName
				if o.Rules[i2].MatchOIfName.InterfaceNames != nil {
					cp.Rules[i2].MatchOIfName.InterfaceNames = make([]string, len(o.Rules[i2].MatchOIfName.InterfaceNames))
					copy(cp.Rules[i2].MatchOIfName.InterfaceNames, o.Rules[i2].MatchOIfName.InterfaceNames)
				}
			}
			if o.Rules[i2].MatchMark != nil {
				cp.Rules[i2].MatchMark = new(NfTablesMark)
				*cp.Rules[i2].MatchMark = *o.Rules[i2].MatchMark
			}
			if o.Rules[i2].MatchConntrackState != nil {
				cp.Rules[i2].MatchConntrackState = new(NfTablesConntrackStateMatch)
				*cp.Rules[i2].MatchConntrackState = *o.Rules[i2].MatchConntrackState
				if o.Rules[i2].MatchConntrackState.States != nil {
					cp.Rules[i2].MatchConntrackState.States = make([]nethelpers.ConntrackState, len(o.Rules[i2].MatchConntrackState.States))
					copy(cp.Rules[i2].MatchConntrackState.States, o.Rules[i2].MatchConntrackState.States)
				}
			}
			if o.Rules[i2].MatchSourceAddress != nil {
				cp.Rules[i2].MatchSourceAddress = new(NfTablesAddressMatch)
				*cp.Rules[i2].MatchSourceAddress = *o.Rules[i2].MatchSourceAddress
				if o.Rules[i2].MatchSourceAddress.IncludeSubnets != nil {
					cp.Rules[i2].MatchSourceAddress.IncludeSubnets = make([]netip.Prefix, len(o.Rules[i2].MatchSourceAddress.IncludeSubnets))
					copy(cp.Rules[i2].MatchSourceAddress.IncludeSubnets, o.Rules[i2].MatchSourceAddress.IncludeSubnets)
				}
				if o.Rules[i2].MatchSourceAddress.ExcludeSubnets != nil {
					cp.Rules[i2].MatchSourceAddress.ExcludeSubnets = make([]netip.Prefix, len(o.Rules[i2].MatchSourceAddress.ExcludeSubnets))
					copy(cp.Rules[i2].MatchSourceAddress.ExcludeSubnets, o.Rules[i2].MatchSourceAddress.ExcludeSubnets)
				}
			}
			if o.Rules[i2].MatchDestinationAddress != nil {
				cp.Rules[i2].MatchDestinationAddress = new(NfTablesAddressMatch)
				*cp.Rules[i2].MatchDestinationAddress = *o.Rules[i2].MatchDestinationAddress
				if o.Rules[i2].MatchDestinationAddress.IncludeSubnets != nil {
					cp.Rules[i2].MatchDestinationAddress.IncludeSubnets = make([]netip.Prefix, len(o.Rules[i2].MatchDestinationAddress.IncludeSubnets))
					copy(cp.Rules[i2].MatchDestinationAddress.IncludeSubnets, o.Rules[i2].MatchDestinationAddress.IncludeSubnets)
				}
				if o.Rules[i2].MatchDestinationAddress.ExcludeSubnets != nil {
					cp.Rules[i2].MatchDestinationAddress.ExcludeSubnets = make([]netip.Prefix, len(o.Rules[i2].MatchDestinationAddress.ExcludeSubnets))
					copy(cp.Rules[i2].MatchDestinationAddress.ExcludeSubnets, o.Rules[i2].MatchDestinationAddress.ExcludeSubnets)
				}
			}
			if o.Rules[i2].MatchLayer4 != nil {
				cp.Rules[i2].MatchLayer4 = new(NfTablesLayer4Match)
				*cp.Rules[i2].MatchLayer4 = *o.Rules[i2].MatchLayer4
				if o.Rules[i2].MatchLayer4.MatchSourcePort != nil {
					cp.Rules[i2].MatchLayer4.MatchSourcePort = new(NfTablesPortMatch)
					*cp.Rules[i2].MatchLayer4.MatchSourcePort = *o.Rules[i2].MatchLayer4.MatchSourcePort
					if o.Rules[i2].MatchLayer4.MatchSourcePort.Ranges != nil {
						cp.Rules[i2].MatchLayer4.MatchSourcePort.Ranges = make([]PortRange, len(o.Rules[i2].MatchLayer4.MatchSourcePort.Ranges))
						copy(cp.Rules[i2].MatchLayer4.MatchSourcePort.Ranges, o.Rules[i2].MatchLayer4.MatchSourcePort.Ranges)
					}
				}
				if o.Rules[i2].MatchLayer4.MatchDestinationPort != nil {
					cp.Rules[i2].MatchLayer4.MatchDestinationPort = new(NfTablesPortMatch)
					*cp.Rules[i2].MatchLayer4.MatchDestinationPort = *o.Rules[i2].MatchLayer4.MatchDestinationPort
					if o.Rules[i2].MatchLayer4.MatchDestinationPort.Ranges != nil {
						cp.Rules[i2].MatchLayer4.MatchDestinationPort.Ranges = make([]PortRange, len(o.Rules[i2].MatchLayer4.MatchDestinationPort.Ranges))
						copy(cp.Rules[i2].MatchLayer4.MatchDestinationPort.Ranges, o.Rules[i2].MatchLayer4.MatchDestinationPort.Ranges)
					}
				}
				if o.Rules[i2].MatchLayer4.MatchICMPType != nil {
					cp.Rules[i2].MatchLayer4.MatchICMPType = new(NfTablesICMPTypeMatch)
					*cp.Rules[i2].MatchLayer4.MatchICMPType = *o.Rules[i2].MatchLayer4.MatchICMPType
					if o.Rules[i2].MatchLayer4.MatchICMPType.Types != nil {
						cp.Rules[i2].MatchLayer4.MatchICMPType.Types = make([]nethelpers.ICMPType, len(o.Rules[i2].MatchLayer4.MatchICMPType.Types))
						copy(cp.Rules[i2].MatchLayer4.MatchICMPType.Types, o.Rules[i2].MatchLayer4.MatchICMPType.Types)
					}
				}
			}
			if o.Rules[i2].MatchLimit != nil {
				cp.Rules[i2].MatchLimit = new(NfTablesLimitMatch)
				*cp.Rules[i2].MatchLimit = *o.Rules[i2].MatchLimit
			}
			if o.Rules[i2].ClampMSS != nil {
				cp.Rules[i2].ClampMSS = new(NfTablesClampMSS)
				*cp.Rules[i2].ClampMSS = *o.Rules[i2].ClampMSS
			}
			if o.Rules[i2].SetMark != nil {
				cp.Rules[i2].SetMark = new(NfTablesMark)
				*cp.Rules[i2].SetMark = *o.Rules[i2].SetMark
			}
			if o.Rules[i2].Verdict != nil {
				cp.Rules[i2].Verdict = new(nethelpers.NfTablesVerdict)
				*cp.Rules[i2].Verdict = *o.Rules[i2].Verdict
			}
		}
	}
	return cp
}

// DeepCopy generates a deep copy of NodeAddressSpec.
func (o NodeAddressSpec) DeepCopy() NodeAddressSpec {
	var cp NodeAddressSpec = o
	if o.Addresses != nil {
		cp.Addresses = make([]netip.Prefix, len(o.Addresses))
		copy(cp.Addresses, o.Addresses)
	}
	return cp
}

// DeepCopy generates a deep copy of NodeAddressSortAlgorithmSpec.
func (o NodeAddressSortAlgorithmSpec) DeepCopy() NodeAddressSortAlgorithmSpec {
	var cp NodeAddressSortAlgorithmSpec = o
	return cp
}

// DeepCopy generates a deep copy of NodeAddressFilterSpec.
func (o NodeAddressFilterSpec) DeepCopy() NodeAddressFilterSpec {
	var cp NodeAddressFilterSpec = o
	if o.IncludeSubnets != nil {
		cp.IncludeSubnets = make([]netip.Prefix, len(o.IncludeSubnets))
		copy(cp.IncludeSubnets, o.IncludeSubnets)
	}
	if o.ExcludeSubnets != nil {
		cp.ExcludeSubnets = make([]netip.Prefix, len(o.ExcludeSubnets))
		copy(cp.ExcludeSubnets, o.ExcludeSubnets)
	}
	return cp
}

// DeepCopy generates a deep copy of OperatorSpecSpec.
func (o OperatorSpecSpec) DeepCopy() OperatorSpecSpec {
	var cp OperatorSpecSpec = o
	return cp
}

// DeepCopy generates a deep copy of ProbeSpecSpec.
func (o ProbeSpecSpec) DeepCopy() ProbeSpecSpec {
	var cp ProbeSpecSpec = o
	return cp
}

// DeepCopy generates a deep copy of ProbeStatusSpec.
func (o ProbeStatusSpec) DeepCopy() ProbeStatusSpec {
	var cp ProbeStatusSpec = o
	return cp
}

// DeepCopy generates a deep copy of ResolverSpecSpec.
func (o ResolverSpecSpec) DeepCopy() ResolverSpecSpec {
	var cp ResolverSpecSpec = o
	if o.DNSServers != nil {
		cp.DNSServers = make([]netip.Addr, len(o.DNSServers))
		copy(cp.DNSServers, o.DNSServers)
	}
	if o.SearchDomains != nil {
		cp.SearchDomains = make([]string, len(o.SearchDomains))
		copy(cp.SearchDomains, o.SearchDomains)
	}
	return cp
}

// DeepCopy generates a deep copy of ResolverStatusSpec.
func (o ResolverStatusSpec) DeepCopy() ResolverStatusSpec {
	var cp ResolverStatusSpec = o
	if o.DNSServers != nil {
		cp.DNSServers = make([]netip.Addr, len(o.DNSServers))
		copy(cp.DNSServers, o.DNSServers)
	}
	if o.SearchDomains != nil {
		cp.SearchDomains = make([]string, len(o.SearchDomains))
		copy(cp.SearchDomains, o.SearchDomains)
	}
	return cp
}

// DeepCopy generates a deep copy of RouteSpecSpec.
func (o RouteSpecSpec) DeepCopy() RouteSpecSpec {
	var cp RouteSpecSpec = o
	return cp
}

// DeepCopy generates a deep copy of RouteStatusSpec.
func (o RouteStatusSpec) DeepCopy() RouteStatusSpec {
	var cp RouteStatusSpec = o
	return cp
}

// DeepCopy generates a deep copy of StatusSpec.
func (o StatusSpec) DeepCopy() StatusSpec {
	var cp StatusSpec = o
	return cp
}

// DeepCopy generates a deep copy of TimeServerSpecSpec.
func (o TimeServerSpecSpec) DeepCopy() TimeServerSpecSpec {
	var cp TimeServerSpecSpec = o
	if o.NTPServers != nil {
		cp.NTPServers = make([]string, len(o.NTPServers))
		copy(cp.NTPServers, o.NTPServers)
	}
	return cp
}

// DeepCopy generates a deep copy of TimeServerStatusSpec.
func (o TimeServerStatusSpec) DeepCopy() TimeServerStatusSpec {
	var cp TimeServerStatusSpec = o
	if o.NTPServers != nil {
		cp.NTPServers = make([]string, len(o.NTPServers))
		copy(cp.NTPServers, o.NTPServers)
	}
	return cp
}
