// python wrapper for ttkGeometrySmoother
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkGeometrySmoother.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkGeometrySmoother(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkGeometrySmoother_ClassNew(); }


static PyObject *
PyttkGeometrySmoother_SetNumberOfIterations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfIterations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGeometrySmoother *op = static_cast<ttkGeometrySmoother *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfIterations(temp0);
    }
    else
    {
      op->ttkGeometrySmoother::SetNumberOfIterations(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_GetNumberOfIterations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfIterations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGeometrySmoother *op = static_cast<ttkGeometrySmoother *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfIterations() :
      op->ttkGeometrySmoother::GetNumberOfIterations());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_SetUseMaskScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseMaskScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGeometrySmoother *op = static_cast<ttkGeometrySmoother *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseMaskScalarField(temp0);
    }
    else
    {
      op->ttkGeometrySmoother::SetUseMaskScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_GetUseMaskScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseMaskScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGeometrySmoother *op = static_cast<ttkGeometrySmoother *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseMaskScalarField() :
      op->ttkGeometrySmoother::GetUseMaskScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_SetMaskIdentifier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaskIdentifier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGeometrySmoother *op = static_cast<ttkGeometrySmoother *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaskIdentifier(temp0);
    }
    else
    {
      op->ttkGeometrySmoother::SetMaskIdentifier(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_GetMaskIdentifier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaskIdentifier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGeometrySmoother *op = static_cast<ttkGeometrySmoother *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMaskIdentifier() :
      op->ttkGeometrySmoother::GetMaskIdentifier());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_SetForceInputMaskScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputMaskScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGeometrySmoother *op = static_cast<ttkGeometrySmoother *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputMaskScalarField(temp0);
    }
    else
    {
      op->ttkGeometrySmoother::SetForceInputMaskScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_GetForceInputMaskScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputMaskScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGeometrySmoother *op = static_cast<ttkGeometrySmoother *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputMaskScalarField() :
      op->ttkGeometrySmoother::GetForceInputMaskScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkGeometrySmoother::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGeometrySmoother *op = static_cast<ttkGeometrySmoother *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkGeometrySmoother::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkGeometrySmoother *tempr = ttkGeometrySmoother::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGeometrySmoother *op = static_cast<ttkGeometrySmoother *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkGeometrySmoother *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkGeometrySmoother::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkGeometrySmoother::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGeometrySmoother_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGeometrySmoother *op = static_cast<ttkGeometrySmoother *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkGeometrySmoother::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkGeometrySmoother_Methods[] = {
  {"SetNumberOfIterations", PyttkGeometrySmoother_SetNumberOfIterations, METH_VARARGS,
   "SetNumberOfIterations(self, _arg:int) -> None\nC++: virtual void SetNumberOfIterations(int _arg)\n\n"},
  {"GetNumberOfIterations", PyttkGeometrySmoother_GetNumberOfIterations, METH_VARARGS,
   "GetNumberOfIterations(self) -> int\nC++: virtual int GetNumberOfIterations()\n\n"},
  {"SetUseMaskScalarField", PyttkGeometrySmoother_SetUseMaskScalarField, METH_VARARGS,
   "SetUseMaskScalarField(self, _arg:bool) -> None\nC++: virtual void SetUseMaskScalarField(bool _arg)\n\n"},
  {"GetUseMaskScalarField", PyttkGeometrySmoother_GetUseMaskScalarField, METH_VARARGS,
   "GetUseMaskScalarField(self) -> bool\nC++: virtual bool GetUseMaskScalarField()\n\n"},
  {"SetMaskIdentifier", PyttkGeometrySmoother_SetMaskIdentifier, METH_VARARGS,
   "SetMaskIdentifier(self, _arg:int) -> None\nC++: virtual void SetMaskIdentifier(int _arg)\n\n"},
  {"GetMaskIdentifier", PyttkGeometrySmoother_GetMaskIdentifier, METH_VARARGS,
   "GetMaskIdentifier(self) -> int\nC++: virtual int GetMaskIdentifier()\n\n"},
  {"SetForceInputMaskScalarField", PyttkGeometrySmoother_SetForceInputMaskScalarField, METH_VARARGS,
   "SetForceInputMaskScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputMaskScalarField(bool _arg)\n\n"},
  {"GetForceInputMaskScalarField", PyttkGeometrySmoother_GetForceInputMaskScalarField, METH_VARARGS,
   "GetForceInputMaskScalarField(self) -> bool\nC++: virtual bool GetForceInputMaskScalarField()\n\n"},
  {"IsTypeOf", PyttkGeometrySmoother_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkGeometrySmoother_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkGeometrySmoother_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkGeometrySmoother\nC++: static ttkGeometrySmoother *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkGeometrySmoother_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkGeometrySmoother\nC++: ttkGeometrySmoother *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkGeometrySmoother_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkGeometrySmoother_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkGeometrySmoother_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("use_mask_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkGeometrySmoother_GetUseMaskScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkGeometrySmoother_SetUseMaskScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkGeometrySmoother_SetUseMaskScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseMaskScalarField/SetUseMaskScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mask_identifier"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkGeometrySmoother_GetMaskIdentifier(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkGeometrySmoother_SetMaskIdentifier(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkGeometrySmoother_SetMaskIdentifier(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaskIdentifier/SetMaskIdentifier\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_input_mask_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkGeometrySmoother_GetForceInputMaskScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkGeometrySmoother_SetForceInputMaskScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkGeometrySmoother_SetForceInputMaskScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputMaskScalarField/SetForceInputMaskScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_iterations"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkGeometrySmoother_GetNumberOfIterations(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkGeometrySmoother_SetNumberOfIterations(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkGeometrySmoother_SetNumberOfIterations(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfIterations/SetNumberOfIterations\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkGeometrySmoother_Doc =
  "ttkGeometrySmoother - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Julien Tierny <julien.tierny@lip6.fr>\\date November 2014.\n\n"
  "TTK VTK-filter for geometry smoothing.\n\n"
  "This filter is a dummy example for the development of TTK packages.\n"
  "It smooths an input mesh by average the vertex locations on the link\n"
  "of each vertex.\n\n"
  "\\param Input Input mesh (vtkDataSet)\n"
  "\\param Output Output mesh (vtkDataSet)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa vtkScalarFieldSmoother\n"
  "\\sa ttk::ScalarFieldSmoother\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/1manifoldLearning/\"\n"
  "  >1-Manifold Learning example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/2manifoldLearning/\"\n"
  "  > 2-Manifold Learning example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/dragon/\">Dragon\n"
  "  example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/harmonicSkeleton/\"\n"
  "  > Harmonic Skeleton example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/interactionSites/\"\n"
  "  > Interaction sites example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreePGA/\">Me\n"
  "  rge Tree Principal Geodesic Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/morseMolecule/\">\n"
  "  Morse Molecule example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/morseSmaleSegmentation_at/\"\n"
  "  >Morse-Smale segmentation example\\n\n"
  "- <a href=\"https://topology-tool-kit.github.io/examples/mpiExample/\">\n"
  "  MPI example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDiagramPGA/\"\n"
  "  >Persistence Diagram Principal Geodesic Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_pegasus/\"\n"
  "  >Topological Optimization for Pegasus Genus Repair example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkGeometrySmoother_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkGeometrySmoother.ttkGeometrySmoother", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkGeometrySmoother_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkGeometrySmoother_StaticNew()
{
  return ttkGeometrySmoother::New();
}

PyObject *PyttkGeometrySmoother_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkGeometrySmoother_Type, PyttkGeometrySmoother_Methods,
    "ttkGeometrySmoother",
 &PyttkGeometrySmoother_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkGeometrySmoother_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkGeometrySmoother(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkGeometrySmoother_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkGeometrySmoother", o) != 0)
  {
    Py_DECREF(o);
  }

}

