/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// GRPCRouteSpecApplyConfiguration represents a declarative configuration of the GRPCRouteSpec type for use
// with apply.
type GRPCRouteSpecApplyConfiguration struct {
	CommonRouteSpecApplyConfiguration `json:",inline"`
	Hostnames                         []apisv1.Hostname                 `json:"hostnames,omitempty"`
	Rules                             []GRPCRouteRuleApplyConfiguration `json:"rules,omitempty"`
}

// GRPCRouteSpecApplyConfiguration constructs a declarative configuration of the GRPCRouteSpec type for use with
// apply.
func GRPCRouteSpec() *GRPCRouteSpecApplyConfiguration {
	return &GRPCRouteSpecApplyConfiguration{}
}

// WithParentRefs adds the given value to the ParentRefs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ParentRefs field.
func (b *GRPCRouteSpecApplyConfiguration) WithParentRefs(values ...*ParentReferenceApplyConfiguration) *GRPCRouteSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithParentRefs")
		}
		b.CommonRouteSpecApplyConfiguration.ParentRefs = append(b.CommonRouteSpecApplyConfiguration.ParentRefs, *values[i])
	}
	return b
}

// WithHostnames adds the given value to the Hostnames field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Hostnames field.
func (b *GRPCRouteSpecApplyConfiguration) WithHostnames(values ...apisv1.Hostname) *GRPCRouteSpecApplyConfiguration {
	for i := range values {
		b.Hostnames = append(b.Hostnames, values[i])
	}
	return b
}

// WithRules adds the given value to the Rules field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Rules field.
func (b *GRPCRouteSpecApplyConfiguration) WithRules(values ...*GRPCRouteRuleApplyConfiguration) *GRPCRouteSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRules")
		}
		b.Rules = append(b.Rules, *values[i])
	}
	return b
}
