/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNavigationActivation.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSNavigationHistoryEntry.h"
#include "JSNavigationNavigationType.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNavigationActivationConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationActivation_from);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationActivation_entry);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigationActivation_navigationType);

class JSNavigationActivationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNavigationActivationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNavigationActivationPrototype* ptr = new (NotNull, JSC::allocateCell<JSNavigationActivationPrototype>(vm)) JSNavigationActivationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationActivationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNavigationActivationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationActivationPrototype, JSNavigationActivationPrototype::Base);

using JSNavigationActivationDOMConstructor = JSDOMConstructorNotConstructable<JSNavigationActivation>;

template<> const ClassInfo JSNavigationActivationDOMConstructor::s_info = { "NavigationActivation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationActivationDOMConstructor) };

template<> JSValue JSNavigationActivationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSNavigationActivationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "NavigationActivation"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNavigationActivation::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSNavigationActivationPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationActivationConstructor, 0 } },
    HashTableValue { "from"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationActivation_from, 0 } },
    HashTableValue { "entry"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationActivation_entry, 0 } },
    HashTableValue { "navigationType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationActivation_navigationType, 0 } },
};

const ClassInfo JSNavigationActivationPrototype::s_info = { "NavigationActivation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationActivationPrototype) };

void JSNavigationActivationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNavigationActivation::info(), JSNavigationActivationPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNavigationActivation::s_info = { "NavigationActivation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationActivation) };

JSNavigationActivation::JSNavigationActivation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NavigationActivation>&& impl)
    : JSDOMWrapper<NavigationActivation>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, NavigationActivation>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNavigationActivation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNavigationActivationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSNavigationActivationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNavigationActivation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNavigationActivation>(vm, globalObject);
}

JSValue JSNavigationActivation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNavigationActivationDOMConstructor, DOMConstructorID::NavigationActivation>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSNavigationActivation::destroy(JSC::JSCell* cell)
{
    JSNavigationActivation* thisObject = static_cast<JSNavigationActivation*>(cell);
    thisObject->JSNavigationActivation::~JSNavigationActivation();
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationActivationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNavigationActivationPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNavigationActivation::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsNavigationActivation_fromGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationActivation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<NavigationHistoryEntry>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.from())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationActivation_from, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationActivation>::get<jsNavigationActivation_fromGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationActivation_entryGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationActivation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<NavigationHistoryEntry>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.entry())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationActivation_entry, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationActivation>::get<jsNavigationActivation_entryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigationActivation_navigationTypeGetter(JSGlobalObject& lexicalGlobalObject, JSNavigationActivation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<NavigationNavigationType>>(lexicalGlobalObject, throwScope, impl.navigationType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationActivation_navigationType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigationActivation>::get<jsNavigationActivation_navigationTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSNavigationActivation::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNavigationActivation, UseCustomHeapCellType::No>(vm, "JSNavigationActivation"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNavigationActivation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNavigationActivation = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNavigationActivation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNavigationActivation = std::forward<decltype(space)>(space); }
    );
}

void JSNavigationActivation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNavigationActivation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSNavigationActivationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSNavigationActivationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNavigationActivation = static_cast<JSNavigationActivation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNavigationActivation->protectedWrapped().ptr(), jsNavigationActivation);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7NavigationActivation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20NavigationActivationE[]; }
#endif
template<std::same_as<NavigationActivation> T>
static inline void verifyVTable(NavigationActivation* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7NavigationActivation@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20NavigationActivationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // NavigationActivation has subclasses. If NavigationActivation has subclasses that get passed
        // to toJS() we currently require NavigationActivation you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NavigationActivation>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<NavigationActivation>(impl.ptr());
#endif
    return createWrapper<NavigationActivation>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NavigationActivation& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

NavigationActivation* JSNavigationActivation::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNavigationActivation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
