/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMRectReadOnly.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMRectInit.h"
#include "JSDOMRectReadOnly.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsDOMRectReadOnlyConstructorFunction_fromRect);
static JSC_DECLARE_HOST_FUNCTION(jsDOMRectReadOnlyPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDOMRectReadOnlyConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMRectReadOnly_x);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMRectReadOnly_y);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMRectReadOnly_width);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMRectReadOnly_height);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMRectReadOnly_top);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMRectReadOnly_right);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMRectReadOnly_bottom);
static JSC_DECLARE_CUSTOM_GETTER(jsDOMRectReadOnly_left);

class JSDOMRectReadOnlyPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMRectReadOnlyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMRectReadOnlyPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMRectReadOnlyPrototype>(vm)) JSDOMRectReadOnlyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMRectReadOnlyPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMRectReadOnlyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMRectReadOnlyPrototype, JSDOMRectReadOnlyPrototype::Base);

using JSDOMRectReadOnlyDOMConstructor = JSDOMConstructor<JSDOMRectReadOnly>;

/* Hash table for constructor */

static const std::array<HashTableValue, 1> JSDOMRectReadOnlyConstructorTableValues {
    HashTableValue { "fromRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMRectReadOnlyConstructorFunction_fromRect, 0 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSDOMRectReadOnlyDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSDOMRectReadOnlyDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto xConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto yConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto widthConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (widthConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto heightConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 0 }; });
    if (heightConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = DOMRectReadOnly::create(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), widthConversionResult.releaseReturnValue(), heightConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<DOMRectReadOnly>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<DOMRectReadOnly>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSDOMRectReadOnlyDOMConstructorConstruct, JSDOMRectReadOnlyDOMConstructor::construct);

template<> const ClassInfo JSDOMRectReadOnlyDOMConstructor::s_info = { "DOMRectReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMRectReadOnlyDOMConstructor) };

template<> JSValue JSDOMRectReadOnlyDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMRectReadOnlyDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DOMRectReadOnly"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDOMRectReadOnly::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSDOMRectReadOnly::info(), JSDOMRectReadOnlyConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 10> JSDOMRectReadOnlyPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMRectReadOnlyConstructor, 0 } },
    HashTableValue { "x"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMRectReadOnly_x, 0 } },
    HashTableValue { "y"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMRectReadOnly_y, 0 } },
    HashTableValue { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMRectReadOnly_width, 0 } },
    HashTableValue { "height"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMRectReadOnly_height, 0 } },
    HashTableValue { "top"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMRectReadOnly_top, 0 } },
    HashTableValue { "right"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMRectReadOnly_right, 0 } },
    HashTableValue { "bottom"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMRectReadOnly_bottom, 0 } },
    HashTableValue { "left"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDOMRectReadOnly_left, 0 } },
    HashTableValue { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsDOMRectReadOnlyPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSDOMRectReadOnlyPrototype::s_info = { "DOMRectReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMRectReadOnlyPrototype) };

void JSDOMRectReadOnlyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMRectReadOnly::info(), JSDOMRectReadOnlyPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDOMRectReadOnly::s_info = { "DOMRectReadOnly"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMRectReadOnly) };

JSDOMRectReadOnly::JSDOMRectReadOnly(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMRectReadOnly>&& impl)
    : JSDOMWrapper<DOMRectReadOnly, SignedPtrTraits<DOMRectReadOnly, DOMRectReadOnlyPtrTag>>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DOMRectReadOnly>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDOMRectReadOnly::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDOMRectReadOnlyPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSDOMRectReadOnlyPrototype::create(vm, &globalObject, structure);
}

JSObject* JSDOMRectReadOnly::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMRectReadOnly>(vm, globalObject);
}

JSValue JSDOMRectReadOnly::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMRectReadOnlyDOMConstructor, DOMConstructorID::DOMRectReadOnly>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMRectReadOnly::destroy(JSC::JSCell* cell)
{
    JSDOMRectReadOnly* thisObject = static_cast<JSDOMRectReadOnly*>(cell);
    thisObject->JSDOMRectReadOnly::~JSDOMRectReadOnly();
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMRectReadOnlyConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMRectReadOnlyPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMRectReadOnly::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsDOMRectReadOnly_xGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.x())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMRectReadOnly_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnly_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMRectReadOnly_yGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.y())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMRectReadOnly_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnly_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMRectReadOnly_widthGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMRectReadOnly_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnly_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMRectReadOnly_heightGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMRectReadOnly_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnly_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMRectReadOnly_topGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.top())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMRectReadOnly_top, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnly_topGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMRectReadOnly_rightGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.right())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMRectReadOnly_right, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnly_rightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMRectReadOnly_bottomGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.bottom())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMRectReadOnly_bottom, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnly_bottomGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDOMRectReadOnly_leftGetter(JSGlobalObject& lexicalGlobalObject, JSDOMRectReadOnly& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.left())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDOMRectReadOnly_left, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDOMRectReadOnly>::get<jsDOMRectReadOnly_leftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsDOMRectReadOnlyConstructorFunction_fromRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto otherConversionResult = convert<IDLDictionary<DOMRectInit>>(*lexicalGlobalObject, argument0.value());
    if (otherConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMRectReadOnly>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMRectReadOnly::fromRect(otherConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsDOMRectReadOnlyConstructorFunction_fromRect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMRectReadOnly>::callStatic<jsDOMRectReadOnlyConstructorFunction_fromRectBody>(*lexicalGlobalObject, *callFrame, "fromRect");
}

static inline EncodedJSValue jsDOMRectReadOnlyPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSDOMRectReadOnly* castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto xValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.x());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "x"_s), xValue);
    auto yValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.y());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "y"_s), yValue);
    auto widthValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.width());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "width"_s), widthValue);
    auto heightValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.height());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "height"_s), heightValue);
    auto topValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.top());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "top"_s), topValue);
    auto rightValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.right());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "right"_s), rightValue);
    auto bottomValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.bottom());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "bottom"_s), bottomValue);
    auto leftValue = toJS<IDLUnrestrictedDouble>(*lexicalGlobalObject, throwScope, impl.left());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "left"_s), leftValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsDOMRectReadOnlyPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSDOMRectReadOnly>::call<jsDOMRectReadOnlyPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSDOMRectReadOnly::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDOMRectReadOnly, UseCustomHeapCellType::No>(vm, "JSDOMRectReadOnly"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDOMRectReadOnly.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDOMRectReadOnly = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDOMRectReadOnly.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDOMRectReadOnly = std::forward<decltype(space)>(space); }
    );
}

void JSDOMRectReadOnly::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMRectReadOnly*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMRectReadOnlyOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsDOMRectReadOnly = jsCast<JSDOMRectReadOnly*>(handle.slot()->asCell());
    DOMRectReadOnly* owner = &jsDOMRectReadOnly->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from DOMRectReadOnly"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSDOMRectReadOnlyOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMRectReadOnly = static_cast<JSDOMRectReadOnly*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMRectReadOnly->protectedWrapped().ptr(), jsDOMRectReadOnly);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMRectReadOnly@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15DOMRectReadOnlyE[]; }
#endif
template<std::same_as<DOMRectReadOnly> T>
static inline void verifyVTable(DOMRectReadOnly* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DOMRectReadOnly@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15DOMRectReadOnlyE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DOMRectReadOnly has subclasses. If DOMRectReadOnly has subclasses that get passed
        // to toJS() we currently require DOMRectReadOnly you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMRectReadOnly>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<DOMRectReadOnly>(impl.ptr());
#endif
    return createWrapper<DOMRectReadOnly>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMRectReadOnly& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMRectReadOnly* JSDOMRectReadOnly::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMRectReadOnly*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
