/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLSync.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebGLSyncConstructor);

class JSWebGLSyncPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLSyncPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLSyncPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLSyncPrototype>(vm)) JSWebGLSyncPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLSyncPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLSyncPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLSyncPrototype, JSWebGLSyncPrototype::Base);

using JSWebGLSyncDOMConstructor = JSDOMConstructorNotConstructable<JSWebGLSync>;

template<> const ClassInfo JSWebGLSyncDOMConstructor::s_info = { "WebGLSync"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLSyncDOMConstructor) };

template<> JSValue JSWebGLSyncDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLSyncDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebGLSync"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebGLSync::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 1> JSWebGLSyncPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebGLSyncConstructor, 0 } },
};

const ClassInfo JSWebGLSyncPrototype::s_info = { "WebGLSync"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLSyncPrototype) };

void JSWebGLSyncPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLSync::info(), JSWebGLSyncPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLSync::s_info = { "WebGLSync"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLSync) };

JSWebGLSync::JSWebGLSync(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLSync>&& impl)
    : JSDOMWrapper<WebGLSync>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLSync>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLSync::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLSyncPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLSyncPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLSync::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLSync>(vm, globalObject);
}

JSValue JSWebGLSync::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLSyncDOMConstructor, DOMConstructorID::WebGLSync>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebGLSync::destroy(JSC::JSCell* cell)
{
    JSWebGLSync* thisObject = static_cast<JSWebGLSync*>(cell);
    thisObject->JSWebGLSync::~JSWebGLSync();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebGLSyncConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebGLSyncPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebGLSync::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSWebGLSync::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLSync, UseCustomHeapCellType::No>(vm, "JSWebGLSync"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLSync.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLSync = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLSync.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLSync = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLSync::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLSync*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLSyncOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebGLSyncOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLSync = static_cast<JSWebGLSync*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLSync->protectedWrapped().ptr(), jsWebGLSync);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLSync@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9WebGLSyncE[]; }
#endif
template<std::same_as<WebGLSync> T>
static inline void verifyVTable(WebGLSync* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLSync@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore9WebGLSyncE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLSync has subclasses. If WebGLSync has subclasses that get passed
        // to toJS() we currently require WebGLSync you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLSync>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLSync>(impl.ptr());
#endif
    return createWrapper<WebGLSync>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLSync& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLSync* JSWebGLSync::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLSync*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
