// MasterUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef MasterUI_h
#define MasterUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2014-2025, Will Godfrey & others

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of the ZynAddSubFX original.
#define PANEL_SINGLE_X 1040
#define PANEL_SINGLE_Y 320
#define PANEL_DUAL_X 530
#define PANEL_DUAL_Y 600
#include <FL/Fl_Tooltip.H>
#include <FL/Fl_Box.H>
#include <string>
#include <iostream>
#include <deque>
#include <fstream>
#include "UI/MiscGui.h"
#include "UI/WidgetCheckButton.h"
#include "UI/WidgetSpinner.h"
#include "UI/ScaleTrackedWindow.h"
#include "ADnoteUI.h"
#include "SUBnoteUI.h"
#include "EffUI.h"
#include "VirKeyboardUI.h"
#include "ConfigUI.h"
#include "BankUI.h"
#include "PartUI.h"
#include "MicrotonalUI.h"
#include "PresetsUI.h"
#include "ParametersUI.h"
#include "VectorUI.h"
#include "ConsoleUI.h"
#include "MasterMiscUI.h"
#include "Misc/SynthEngine.h"
#include "Interface/InterChange.h"
#include "Interface/InterfaceAnchor.h"
    using RoutingTag = GuiDataExchange::RoutingTag;
#include "MidiLearnUI.h"
extern int lineitem;
#include <FL/Fl_Group.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Button.H>

class FilerLine : public Fl_Group {
public:
  Fl_Group* make_window();
  Fl_Group *filerlist;
  Fl_Group *fileIcon;
  Fl_Box *outer_box;
  Fl_Box *inner_box;
  Fl_Box *line1;
  Fl_Box *line2;
  Fl_Box *type;
  Fl_Group *dirIcon;
  Fl_Button *name;
  Fl_Button *nametop;
private:
  inline void cb_nametop_i(Fl_Button*, void*);
  static void cb_nametop(Fl_Button*, void*);
public:
  FilerLine(int x, int y, int w, int h, const char *label=0);
  FilerLine(FilerLine const&) =delete;
  FilerLine(FilerLine&&) =delete;
  FilerLine& operator=(FilerLine const&) =delete;
  FilerLine& operator=(FilerLine&&) =delete;
  void init(SynthEngine *synth_, int n_, bool isDir_, string typeName_, string title_);
private:
  int n;
  bool isDir;
  string typeName;
  string title;
  SynthEngine *synth;
public:
  ~FilerLine();
};

class KeyHandle : public Fl_Box {
public:
  KeyHandle(int x,int y, int w, int h, const char *label=0);
  void init(SynthEngine *_synth);
  int handle(int event);
private:
  SynthEngine *synth;
};
#include <FL/Fl_Tabs.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Browser.H>
#include <FL/Fl_Scroll.H>

class MasterUI : public GuiUpdates {
public:
  MasterUI(InterChange& _interChange, InterfaceAnchor connectionData)
	 ;
  ~MasterUI();
  void Init();
  bool Showmaster();
  void refreshInit();
  ScaleTrackedWindow* make_window();
  ScaleTrackedWindow *masterwindow;
private:
  inline void cb_masterwindow_i(ScaleTrackedWindow*, void*);
  static void cb_masterwindow(ScaleTrackedWindow*, void*);
public:
  KeyHandle *keyHandle;
  Fl_Tabs *sysinsgroup;
private:
  inline void cb_sysinsgroup_i(Fl_Tabs*, void*);
  static void cb_sysinsgroup(Fl_Tabs*, void*);
public:
  Fl_Group *SystemEffectsGrp;
  WidgetSpinner *syseffnocounter;
private:
  inline void cb_syseffnocounter_i(WidgetSpinner*, void*);
  static void cb_syseffnocounter(WidgetSpinner*, void*);
public:
  Fl_Choice *sysefftype;
private:
  inline void cb_sysefftype_i(Fl_Choice*, void*);
  static void cb_sysefftype(Fl_Choice*, void*);
public:
  Fl_Check_Button2 *SysEffOn;
private:
  inline void cb_SysEffOn_i(Fl_Check_Button2*, void*);
  static void cb_SysEffOn(Fl_Check_Button2*, void*);
public:
  Fl_Button *sysEffSend;
private:
  inline void cb_sysEffSend_i(Fl_Button*, void*);
  static void cb_sysEffSend(Fl_Button*, void*);
public:
  Fl_Button *sysCopy;
private:
  inline void cb_sysCopy_i(Fl_Button*, void*);
  static void cb_sysCopy(Fl_Button*, void*);
public:
  Fl_Button *sysPaste;
private:
  inline void cb_sysPaste_i(Fl_Button*, void*);
  static void cb_sysPaste(Fl_Button*, void*);
public:
  Fl_Group *InsertionEffectsGrp;
  WidgetSpinner *inseffnocounter;
private:
  inline void cb_inseffnocounter_i(WidgetSpinner*, void*);
  static void cb_inseffnocounter(WidgetSpinner*, void*);
public:
  Fl_Choice *insefftype;
private:
  inline void cb_insefftype_i(Fl_Choice*, void*);
  static void cb_insefftype(Fl_Choice*, void*);
public:
  Fl_Choice *inseffpart;
private:
  inline void cb_inseffpart_i(Fl_Choice*, void*);
  static void cb_inseffpart(Fl_Choice*, void*);
public:
  Fl_Button *insCopy;
private:
  inline void cb_insCopy_i(Fl_Button*, void*);
  static void cb_insCopy(Fl_Button*, void*);
public:
  Fl_Button *insPaste;
private:
  inline void cb_insPaste_i(Fl_Button*, void*);
  static void cb_insPaste(Fl_Button*, void*);
public:
  Fl_Menu_Bar *mastermenu;
private:
  inline void cb_mastermenu_i(Fl_Menu_Bar*, void*);
  static void cb_mastermenu(Fl_Menu_Bar*, void*);
public:
  Fl_Group *MasterControls;
  Fl_Button *mainreset;
private:
  inline void cb_mainreset_i(Fl_Button*, void*);
  static void cb_mainreset(Fl_Button*, void*);
public:
  Fl_Button *mainstop;
private:
  inline void cb_mainstop_i(Fl_Button*, void*);
  static void cb_mainstop(Fl_Button*, void*);
public:
  Fl_Button *mainvirtkeyb;
private:
  inline void cb_mainvirtkeyb_i(Fl_Button*, void*);
  static void cb_mainvirtkeyb(Fl_Button*, void*);
public:
  Fl_Button *mixerpanel;
private:
  inline void cb_mixerpanel_i(Fl_Button*, void*);
  static void cb_mixerpanel(Fl_Button*, void*);
public:
  Fl_Button *mainmidilearn;
private:
  inline void cb_mainmidilearn_i(Fl_Button*, void*);
  static void cb_mainmidilearn(Fl_Button*, void*);
public:
  Fl_Button *vectors;
private:
  inline void cb_vectors_i(Fl_Button*, void*);
  static void cb_vectors(Fl_Button*, void*);
public:
  Fl_Button *undo;
private:
  inline void cb_undo_i(Fl_Button*, void*);
  static void cb_undo(Fl_Button*, void*);
public:
  Fl_Button *redo;
private:
  inline void cb_redo_i(Fl_Button*, void*);
  static void cb_redo(Fl_Button*, void*);
public:
  Fl_Box *topcontrols1;
  WidgetPDial *globalfinedetune;
private:
  inline void cb_globalfinedetune_i(WidgetPDial*, void*);
  static void cb_globalfinedetune(WidgetPDial*, void*);
public:
  WidgetPDial *mastervolumedial;
private:
  inline void cb_mastervolumedial_i(WidgetPDial*, void*);
  static void cb_mastervolumedial(WidgetPDial*, void*);
public:
  WidgetSpinner *masterkeyshift;
private:
  inline void cb_masterkeyshift_i(WidgetSpinner*, void*);
  static void cb_masterkeyshift(WidgetSpinner*, void*);
public:
  WidgetSpinner *bpmfallback;
private:
  inline void cb_bpmfallback_i(WidgetSpinner*, void*);
  static void cb_bpmfallback(WidgetSpinner*, void*);
public:
  Fl_Group *syseffectuigroup;
  EffUI *syseffectui;
  Fl_Group *inseffectuigroup;
  EffUI *inseffectui;
  Fl_Group *partuigroup;
  PartUI *partui;
  Fl_Group *partControls;
  WidgetPDial *partVol;
private:
  inline void cb_partVol_i(WidgetPDial*, void*);
  static void cb_partVol(WidgetPDial*, void*);
public:
  WidgetPDial *partPan;
private:
  inline void cb_partPan_i(WidgetPDial*, void*);
  static void cb_partPan(WidgetPDial*, void*);
public:
  WidgetPDial *partVelOffset;
private:
  inline void cb_partVelOffset_i(WidgetPDial*, void*);
  static void cb_partVelOffset(WidgetPDial*, void*);
public:
  WidgetPDial *partVelSense;
private:
  inline void cb_partVelSense_i(WidgetPDial*, void*);
  static void cb_partVelSense(WidgetPDial*, void*);
public:
  Fl_Group *instrumentGroup;
  Fl_Box *instrumentaddbox;
  Fl_Box *instrumentsubbox;
  Fl_Box *instrumentpadbox;
  Fl_Box *instrumentlabel;
  Fl_Box *instrumentFrame;
  Fl_Button *buttontop;
private:
  inline void cb_buttontop_i(Fl_Button*, void*);
  static void cb_buttontop(Fl_Button*, void*);
public:
  WidgetSpinner *partMidiCh;
private:
  inline void cb_partMidiCh_i(WidgetSpinner*, void*);
  static void cb_partMidiCh(WidgetSpinner*, void*);
public:
  Fl_Button *partEdit;
private:
  inline void cb_partEdit_i(Fl_Button*, void*);
  static void cb_partEdit(Fl_Button*, void*);
public:
  Fl_Button *partControllers;
private:
  inline void cb_partControllers_i(Fl_Button*, void*);
  static void cb_partControllers(Fl_Button*, void*);
public:
  Fl_Button *partMidiCCs;
private:
  inline void cb_partMidiCCs_i(Fl_Button*, void*);
  static void cb_partMidiCCs(Fl_Button*, void*);
public:
  Fl_Box *modepatch;
  Fl_Choice *partKeymode;
private:
  inline void cb_partKeymode_i(Fl_Choice*, void*);
  static void cb_partKeymode(Fl_Choice*, void*);
public:
  Fl_Check_Button2 *partPortamento;
private:
  inline void cb_partPortamento_i(Fl_Check_Button2*, void*);
  static void cb_partPortamento(Fl_Check_Button2*, void*);
public:
  WidgetSpinner *minKeyCount;
private:
  inline void cb_minKeyCount_i(WidgetSpinner*, void*);
  static void cb_minKeyCount(WidgetSpinner*, void*);
public:
  WidgetSpinner *maxKeyCount;
private:
  inline void cb_maxKeyCount_i(WidgetSpinner*, void*);
  static void cb_maxKeyCount(WidgetSpinner*, void*);
public:
  Fl_Button *setMinToLast;
private:
  inline void cb_setMinToLast_i(Fl_Button*, void*);
  static void cb_setMinToLast(Fl_Button*, void*);
public:
  Fl_Button *setNormal;
private:
  inline void cb_setNormal_i(Fl_Button*, void*);
  static void cb_setNormal(Fl_Button*, void*);
public:
  Fl_Button *setMaxToLast;
private:
  inline void cb_setMaxToLast_i(Fl_Button*, void*);
  static void cb_setMaxToLast(Fl_Button*, void*);
public:
  WidgetSpinner *partKeyShift;
private:
  inline void cb_partKeyShift_i(WidgetSpinner*, void*);
  static void cb_partKeyShift(WidgetSpinner*, void*);
public:
  WidgetSpinner *partKeyLimit;
private:
  inline void cb_partKeyLimit_i(WidgetSpinner*, void*);
  static void cb_partKeyLimit(WidgetSpinner*, void*);
public:
  Fl_Group *sysEffBox;
  Fl_Text_Display *sysEffName;
  WidgetPDial *sysEff1;
private:
  inline void cb_sysEff1_i(WidgetPDial*, void*);
  static void cb_sysEff1(WidgetPDial*, void*);
public:
  WidgetPDial *sysEff2;
private:
  inline void cb_sysEff2_i(WidgetPDial*, void*);
  static void cb_sysEff2(WidgetPDial*, void*);
public:
  WidgetPDial *sysEff3;
private:
  inline void cb_sysEff3_i(WidgetPDial*, void*);
  static void cb_sysEff3(WidgetPDial*, void*);
public:
  WidgetPDial *sysEff4;
private:
  inline void cb_sysEff4_i(WidgetPDial*, void*);
  static void cb_sysEff4(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *partOmniEnable;
private:
  inline void cb_partOmniEnable_i(Fl_Check_Button2*, void*);
  static void cb_partOmniEnable(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *partEnable;
private:
  inline void cb_partEnable_i(Fl_Check_Button2*, void*);
  static void cb_partEnable(Fl_Check_Button2*, void*);
public:
  VUMeter *vumeter;
private:
  inline void cb__i(Fl_Button*, void*);
  static void cb_(Fl_Button*, void*);
public:
  Fl_Button *mastermono;
private:
  inline void cb_mastermono_i(Fl_Button*, void*);
  static void cb_mastermono(Fl_Button*, void*);
public:
  WidgetSpinner *maxparts;
private:
  inline void cb_maxparts_i(WidgetSpinner*, void*);
  static void cb_maxparts(WidgetSpinner*, void*);
public:
  WidgetSpinner *npartcounter;
private:
  inline void cb_npartcounter_i(WidgetSpinner*, void*);
  static void cb_npartcounter(WidgetSpinner*, void*);
public:
  Fl_Choice *panning_law;
private:
  inline void cb_panning_law_i(Fl_Choice*, void*);
  static void cb_panning_law(Fl_Choice*, void*);
public:
  Fl_Group *setInstance;
  Fl_Text_Display *InstBlurb;
private:
  inline void cb_1_i(Fl_Button*, void*);
  static void cb_1(Fl_Button*, void*);
public:
  Fl_Button *cancelInst;
private:
  inline void cb_cancelInst_i(Fl_Button*, void*);
  static void cb_cancelInst(Fl_Button*, void*);
public:
  Fl_Button *nextInst;
private:
  inline void cb_nextInst_i(Fl_Button*, void*);
  static void cb_nextInst(Fl_Button*, void*);
public:
  Fl_Input *valueInst;
private:
  inline void cb_valueInst_i(Fl_Input*, void*);
  static void cb_valueInst(Fl_Input*, void*);
public:
  Fl_Box *divider;
// line spaces in boxes below are critical
  ScaleTrackedWindow *aboutwindow;
  Fl_Group *aboutFirst;
  Fl_Box *about1;
  Fl_Box *about2;
  Fl_Box *about3;
  Fl_Box *about4;
  Fl_Button *about5;
private:
  inline void cb_about5_i(Fl_Button*, void*);
  static void cb_about5(Fl_Button*, void*);
public:
  Fl_Group *contributors;
  Fl_Box *cont1;
  Fl_Box *cont2;
  Fl_Box *cont3;
  Fl_Button *aboutClose;
private:
  inline void cb_aboutClose_i(Fl_Button*, void*);
  static void cb_aboutClose(Fl_Button*, void*);
public:
  ScaleTrackedWindow *syseffsendwindow;
private:
  inline void cb_syseffsendwindow_i(ScaleTrackedWindow*, void*);
  static void cb_syseffsendwindow(ScaleTrackedWindow*, void*);
public:
  Fl_Button *syseffClose;
private:
  inline void cb_syseffClose_i(Fl_Button*, void*);
  static void cb_syseffClose(Fl_Button*, void*);
public:
  Fl_Box *syseffname;
  WidgetPDial *syseff01;
private:
  inline void cb_syseff01_i(WidgetPDial*, void*);
  static void cb_syseff01(WidgetPDial*, void*);
public:
  WidgetPDial *syseff02;
private:
  inline void cb_syseff02_i(WidgetPDial*, void*);
  static void cb_syseff02(WidgetPDial*, void*);
public:
  WidgetPDial *syseff03;
private:
  inline void cb_syseff03_i(WidgetPDial*, void*);
  static void cb_syseff03(WidgetPDial*, void*);
public:
  WidgetPDial *syseff12;
private:
  inline void cb_syseff12_i(WidgetPDial*, void*);
  static void cb_syseff12(WidgetPDial*, void*);
public:
  WidgetPDial *syseff13;
private:
  inline void cb_syseff13_i(WidgetPDial*, void*);
  static void cb_syseff13(WidgetPDial*, void*);
public:
  WidgetPDial *syseff23;
private:
  inline void cb_syseff23_i(WidgetPDial*, void*);
  static void cb_syseff23(WidgetPDial*, void*);
public:
  Fl_Box *sys01txt;
  Fl_Box *sys02txt;
  Fl_Box *sys03txt;
  Fl_Box *sys12txt;
  Fl_Box *sys13txt;
  Fl_Box *sys23txt;
  ScaleTrackedWindow *panelwindow;
private:
  inline void cb_panelwindow_i(ScaleTrackedWindow*, void*);
  static void cb_panelwindow(ScaleTrackedWindow*, void*);
public:
  Fl_Group *Panelframe;
  Fl_Button *towide;
private:
  inline void cb_towide_i(Fl_Button*, void*);
  static void cb_towide(Fl_Button*, void*);
public:
  Fl_Button *todeep;
private:
  inline void cb_todeep_i(Fl_Button*, void*);
  static void cb_todeep(Fl_Button*, void*);
public:
  Fl_Choice *Panelgroups;
private:
  inline void cb_Panelgroups_i(Fl_Choice*, void*);
  static void cb_Panelgroups(Fl_Choice*, void*);
public:
  Fl_Choice *Panelsmallgroups;
private:
  inline void cb_Panelsmallgroups_i(Fl_Choice*, void*);
  static void cb_Panelsmallgroups(Fl_Choice*, void*);
public:
  WidgetSpinner *CSspinner;
private:
  inline void cb_CSspinner_i(WidgetSpinner*, void*);
  static void cb_CSspinner(WidgetSpinner*, void*);
public:
  Fl_Button *CSpend;
private:
  inline void cb_CSpend_i(Fl_Button*, void*);
  static void cb_CSpend(Fl_Button*, void*);
public:
  Fl_Choice *channelswitch;
private:
  inline void cb_channelswitch_i(Fl_Choice*, void*);
  static void cb_channelswitch(Fl_Choice*, void*);
public:
  Fl_Button *Panelclose;
private:
  inline void cb_Panelclose_i(Fl_Button*, void*);
  static void cb_Panelclose(Fl_Button*, void*);
public:
  Fl_Double_Window *message;
  Fl_Box *words;
  Fl_Button *yesdoit;
private:
  inline void cb_yesdoit_i(Fl_Button*, void*);
  static void cb_yesdoit(Fl_Button*, void*);
public:
  Fl_Button *cancel;
private:
  inline void cb_cancel_i(Fl_Button*, void*);
  static void cb_cancel(Fl_Button*, void*);
public:
  Fl_Button *closebutton;
private:
  inline void cb_closebutton_i(Fl_Button*, void*);
  static void cb_closebutton(Fl_Button*, void*);
public:
  ScaleTrackedWindow *querywindow;
private:
  inline void cb_querywindow_i(ScaleTrackedWindow*, void *);
  static void cb_querywindow(ScaleTrackedWindow*, void *);
public:
  Fl_Button *yesQ;
private:
  inline void cb_yesQ_i(Fl_Button*, void*);
  static void cb_yesQ(Fl_Button*, void*);
public:
  Fl_Button *noQ;
private:
  inline void cb_noQ_i(Fl_Button*, void*);
  static void cb_noQ(Fl_Button*, void*);
public:
  Fl_Button *cancelQ;
private:
  inline void cb_cancelQ_i(Fl_Button*, void*);
  static void cb_cancelQ(Fl_Button*, void*);
public:
  Fl_Box *typeQ;
  Fl_Box *textQ;
  ScaleTrackedWindow *textwindow;
private:
  inline void cb_textwindow_i(ScaleTrackedWindow*, void*);
  static void cb_textwindow(ScaleTrackedWindow*, void*);
public:
  Fl_Input *textLine;
  ScaleTrackedWindow *filerwindow;
private:
  inline void cb_filerwindow_i(ScaleTrackedWindow*, void*);
  static void cb_filerwindow(ScaleTrackedWindow*, void*);
public:
  Fl_Input *fileroldpath;
private:
  inline void cb_fileroldpath_i(Fl_Input*, void*);
  static void cb_fileroldpath(Fl_Input*, void*);
public:
  Fl_Button *filerback;
private:
  inline void cb_filerback_i(Fl_Button*, void*);
  static void cb_filerback(Fl_Button*, void*);
public:
  Fl_Group *faveGroup;
  Fl_Button *filerfave;
private:
  inline void cb_filerfave_i(Fl_Button*, void*);
  static void cb_filerfave(Fl_Button*, void*);
public:
  Fl_Button *faveadd;
private:
  inline void cb_faveadd_i(Fl_Button*, void*);
  static void cb_faveadd(Fl_Button*, void*);
public:
  Fl_Button *filerclose;
private:
  inline void cb_filerclose_i(Fl_Button*, void*);
  static void cb_filerclose(Fl_Button*, void*);
public:
  Fl_Group *filernamegroup;
  Fl_Input *filernewname;
private:
  inline void cb_filernewname_i(Fl_Input*, void*);
  static void cb_filernewname(Fl_Input*, void*);
public:
  Fl_Button *fileruse;
private:
  inline void cb_fileruse_i(Fl_Button*, void*);
  static void cb_fileruse(Fl_Button*, void*);
public:
  Fl_Check_Button2 *filerOpt8;
private:
  inline void cb_filerOpt8_i(Fl_Check_Button2*, void*);
  static void cb_filerOpt8(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *filerOpt1;
private:
  inline void cb_filerOpt1_i(Fl_Check_Button2*, void*);
  static void cb_filerOpt1(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *filerOpt2;
private:
  inline void cb_filerOpt2_i(Fl_Check_Button2*, void*);
  static void cb_filerOpt2(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *filerOpt16;
private:
  inline void cb_filerOpt16_i(Fl_Check_Button2*, void*);
  static void cb_filerOpt16(Fl_Check_Button2*, void*);
public:
  Fl_Group *filerframe;
  Fl_Group *filershort;
  Fl_Group *favourites;
  Fl_Group *favename;
  Fl_Browser *favebrowse;
private:
  inline void cb_favebrowse_i(Fl_Browser*, void*);
  static void cb_favebrowse(Fl_Browser*, void*);
public:
  Fl_Button *favecancel;
private:
  inline void cb_favecancel_i(Fl_Button*, void*);
  static void cb_favecancel(Fl_Button*, void*);
public:
  Fl_Button *favedefault;
private:
  inline void cb_favedefault_i(Fl_Button*, void*);
  static void cb_favedefault(Fl_Button*, void*);
public:
  Fl_Button *favedelete;
private:
  inline void cb_favedelete_i(Fl_Button*, void*);
  static void cb_favedelete(Fl_Button*, void*);
public:
  Fl_Button *faveset;
private:
  inline void cb_faveset_i(Fl_Button*, void*);
  static void cb_faveset(Fl_Button*, void*);
public:
  Fl_Scroll *filerscroll;
  string setfiler(string title, string name, bool save, int exten);
  void fillfiler(string type_name);
  void filerselect(int item);
  void setfavourites();
  void loadfavourites();
  void savefavourites();
  void clearfavelist();
  void setfavecolour(int num);
  string clearfavecolour(int num);
  void filerRtext();
  void startInstance();
  void send_data(int action, int control, float value, int type, int part = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int miscmsg = UNUSED);
  float fetchData(float value, int control, int part, int kititem = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int offset = UNUSED, int miscmsg = UNUSED, int request = UNUSED);
  bool part_group_returns(CommandBlock *getData);
  bool returns_update(CommandBlock *getData);
  void paste(CommandBlock *getData);
  int query(string one, string two, string three, string text);
  void setmessage(int group, bool fixedPos, string text, string B1 = "Close", string B2 = "", string B3 = "");
  string setinput(string label, string oldLine);
  void updatesendwindow();
  void updatelistitem(int part);
  void changepanelstyle(int type, bool force = false);
  void Showpanel();
  void updatepanel(bool full = false);
  void partSwitch(int next);
  void updateEngines(int engine, string instrumentName);
  void updateModepatch(bool inactive);
  void updatepart();
  void refreshControls(int npart);
  void updatepartprogram(int next);
  void setMasterLabel(string name);
  void do_load_scale(string fname);
  void do_load_instrument(string fname);
  void do_load_master(string filename);
  void do_save_master();
  void refresh_master_ui(int type);
  bool checkmaxparts();
  void strategicRetreat();
  void Log(string msg);
private:
  void showSysEfxUI();
  void showInsEfxUI();
public:
  void showSysEffSends();
  void setinspartlist();
  PresetsUI * getPresetsUi();
  void resetPartsClip();
  void refreshInsEffUI();
  void setState(string filename);
  void setPartActive(int _npart, bool active);
  void setPanelPartVolWidget(int _npart, float _value);
  void setPanelPartPanWidget(int _npart, float _value);
  void setPartMidiWidget(int _npart, unsigned char _value);
  void setPanelPartMidiWidget(int _npart, unsigned char _value);
  void setLogging(bool isConsole);
  void setBpmFallbackValue(float value);
  void updateBankRootDirs();
  void updatepaths(int type);
  SynthEngine * getSynth();
  void loadWindowData();
  void checkBuffer();
  void rescaleMain();
  bool instrumentsWarning(string message);
  bool instrumentSingleWarning(int npart, string message);
  void wincheck();
  void mainRtext();
  void panelRtext();
  void aboutRtext();
  void syseffRtext();
  void queryRtext();
  void msgRtext();
  void textinRtext();
  void theme();
  SynthEngine *synth;
  ConfigUI *configui;
  ParametersUI *paramsui;
  VectorUI *vectorui;
  MidiLearnUI *midilearnui;
  BankUI *bankui;
  MicrotonalUI *microtonalui;
  VirKeyboard *virkeyboard;
  bool themeTrigger;
  int npart;
  /**
   This is only public for vector control
  */
  int partmax;
  Panellistitem *panellistitem[NUM_MIDI_PARTS];
  ConsoleUI *yoshiLog;
private:
  PresetsUI *presetsui;
  string panelwindowlabel;
  int current_ID;
public:
  int panelgroup;
private:
  int CS_CC;
  string filename;
  int msgGroup;
  float mainDW;
  float mainDH;
  float mainScale;
  int panelType;
  float msgDW;
  float msgDH;
  bool msgSeen;
  float syseffDW;
  float syseffDH;
  bool syseffSeen;
  float panelScale;
  bool logenable;
  int aboutDW;
  int aboutDH;
  int queryDW;
  int queryDH;
  int lastqueryW;
  int textinDW;
  int textinDH;
  int lasttextW;
  string filerpath;
  string filerext;
  string filerfound;
  bool dosave;
  int extension;
  bool filerdone;
  int filerDW;
  int filerDH;
  int lastfilerW;
  int lastmainW;
  int lastpanelW;
  int lastmsgW;
  int lastsyseffW;
  float lastsyseffeqW;
  int lastsysDynFiltW;
  int lastinsDynFiltW;
  int lastvirtW;
  int lastaboutW;
  int oldH;
  int fileruseX;
  std::deque<FilerLine> filerlist;
  int lineno;
  string type_name;
};
#endif
