{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoLayoutIter@ can be used to iterate over the visual
-- extents of a @PangoLayout@.
-- 
-- To obtain a @PangoLayoutIter@, use 'GI.Pango.Objects.Layout.layoutGetIter'.
-- 
-- The @PangoLayoutIter@ structure is opaque, and has no user-visible fields.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.LayoutIter
    ( 

-- * Exported types
    LayoutIter(..)                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [atLastLine]("GI.Pango.Structs.LayoutIter#g:method:atLastLine"), [copy]("GI.Pango.Structs.LayoutIter#g:method:copy"), [free]("GI.Pango.Structs.LayoutIter#g:method:free"), [nextChar]("GI.Pango.Structs.LayoutIter#g:method:nextChar"), [nextCluster]("GI.Pango.Structs.LayoutIter#g:method:nextCluster"), [nextLine]("GI.Pango.Structs.LayoutIter#g:method:nextLine"), [nextRun]("GI.Pango.Structs.LayoutIter#g:method:nextRun").
-- 
-- ==== Getters
-- [getBaseline]("GI.Pango.Structs.LayoutIter#g:method:getBaseline"), [getCharExtents]("GI.Pango.Structs.LayoutIter#g:method:getCharExtents"), [getClusterExtents]("GI.Pango.Structs.LayoutIter#g:method:getClusterExtents"), [getIndex]("GI.Pango.Structs.LayoutIter#g:method:getIndex"), [getLayout]("GI.Pango.Structs.LayoutIter#g:method:getLayout"), [getLayoutExtents]("GI.Pango.Structs.LayoutIter#g:method:getLayoutExtents"), [getLine]("GI.Pango.Structs.LayoutIter#g:method:getLine"), [getLineExtents]("GI.Pango.Structs.LayoutIter#g:method:getLineExtents"), [getLineReadonly]("GI.Pango.Structs.LayoutIter#g:method:getLineReadonly"), [getLineYrange]("GI.Pango.Structs.LayoutIter#g:method:getLineYrange"), [getRun]("GI.Pango.Structs.LayoutIter#g:method:getRun"), [getRunBaseline]("GI.Pango.Structs.LayoutIter#g:method:getRunBaseline"), [getRunExtents]("GI.Pango.Structs.LayoutIter#g:method:getRunExtents"), [getRunReadonly]("GI.Pango.Structs.LayoutIter#g:method:getRunReadonly").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveLayoutIterMethod                 ,
#endif

-- ** atLastLine #method:atLastLine#

#if defined(ENABLE_OVERLOADING)
    LayoutIterAtLastLineMethodInfo          ,
#endif
    layoutIterAtLastLine                    ,


-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    LayoutIterCopyMethodInfo                ,
#endif
    layoutIterCopy                          ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    LayoutIterFreeMethodInfo                ,
#endif
    layoutIterFree                          ,


-- ** getBaseline #method:getBaseline#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetBaselineMethodInfo         ,
#endif
    layoutIterGetBaseline                   ,


-- ** getCharExtents #method:getCharExtents#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetCharExtentsMethodInfo      ,
#endif
    layoutIterGetCharExtents                ,


-- ** getClusterExtents #method:getClusterExtents#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetClusterExtentsMethodInfo   ,
#endif
    layoutIterGetClusterExtents             ,


-- ** getIndex #method:getIndex#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetIndexMethodInfo            ,
#endif
    layoutIterGetIndex                      ,


-- ** getLayout #method:getLayout#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetLayoutMethodInfo           ,
#endif
    layoutIterGetLayout                     ,


-- ** getLayoutExtents #method:getLayoutExtents#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetLayoutExtentsMethodInfo    ,
#endif
    layoutIterGetLayoutExtents              ,


-- ** getLine #method:getLine#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetLineMethodInfo             ,
#endif
    layoutIterGetLine                       ,


-- ** getLineExtents #method:getLineExtents#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetLineExtentsMethodInfo      ,
#endif
    layoutIterGetLineExtents                ,


-- ** getLineReadonly #method:getLineReadonly#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetLineReadonlyMethodInfo     ,
#endif
    layoutIterGetLineReadonly               ,


-- ** getLineYrange #method:getLineYrange#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetLineYrangeMethodInfo       ,
#endif
    layoutIterGetLineYrange                 ,


-- ** getRun #method:getRun#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetRunMethodInfo              ,
#endif
    layoutIterGetRun                        ,


-- ** getRunBaseline #method:getRunBaseline#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetRunBaselineMethodInfo      ,
#endif
    layoutIterGetRunBaseline                ,


-- ** getRunExtents #method:getRunExtents#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetRunExtentsMethodInfo       ,
#endif
    layoutIterGetRunExtents                 ,


-- ** getRunReadonly #method:getRunReadonly#

#if defined(ENABLE_OVERLOADING)
    LayoutIterGetRunReadonlyMethodInfo      ,
#endif
    layoutIterGetRunReadonly                ,


-- ** nextChar #method:nextChar#

#if defined(ENABLE_OVERLOADING)
    LayoutIterNextCharMethodInfo            ,
#endif
    layoutIterNextChar                      ,


-- ** nextCluster #method:nextCluster#

#if defined(ENABLE_OVERLOADING)
    LayoutIterNextClusterMethodInfo         ,
#endif
    layoutIterNextCluster                   ,


-- ** nextLine #method:nextLine#

#if defined(ENABLE_OVERLOADING)
    LayoutIterNextLineMethodInfo            ,
#endif
    layoutIterNextLine                      ,


-- ** nextRun #method:nextRun#

#if defined(ENABLE_OVERLOADING)
    LayoutIterNextRunMethodInfo             ,
#endif
    layoutIterNextRun                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.HarfBuzz.Structs.FeatureT as HarfBuzz.FeatureT
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.Context as Pango.Context
import {-# SOURCE #-} qualified GI.Pango.Objects.Coverage as Pango.Coverage
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.FontMap as Pango.FontMap
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Objects.Layout as Pango.Layout
import {-# SOURCE #-} qualified GI.Pango.Structs.Analysis as Pango.Analysis
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrIterator as Pango.AttrIterator
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrList as Pango.AttrList
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphItem as Pango.GlyphItem
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphString as Pango.GlyphString
import {-# SOURCE #-} qualified GI.Pango.Structs.Item as Pango.Item
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.LayoutLine as Pango.LayoutLine
import {-# SOURCE #-} qualified GI.Pango.Structs.LogAttr as Pango.LogAttr
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle
import {-# SOURCE #-} qualified GI.Pango.Structs.TabArray as Pango.TabArray

#else
import {-# SOURCE #-} qualified GI.Pango.Objects.Layout as Pango.Layout
import {-# SOURCE #-} qualified GI.Pango.Structs.GlyphItem as Pango.GlyphItem
import {-# SOURCE #-} qualified GI.Pango.Structs.LayoutLine as Pango.LayoutLine
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#endif

-- | Memory-managed wrapper type.
newtype LayoutIter = LayoutIter (SP.ManagedPtr LayoutIter)
    deriving (Eq)

instance SP.ManagedPtrNewtype LayoutIter where
    toManagedPtr (LayoutIter p) = p

foreign import ccall "pango_layout_iter_get_type" c_pango_layout_iter_get_type :: 
    IO GType

type instance O.ParentTypes LayoutIter = '[]
instance O.HasParentTypes LayoutIter

instance B.Types.TypedObject LayoutIter where
    glibType = c_pango_layout_iter_get_type

instance B.Types.GBoxed LayoutIter

-- | Convert t'LayoutIter' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe LayoutIter) where
    gvalueGType_ = c_pango_layout_iter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr LayoutIter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr LayoutIter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed LayoutIter ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList LayoutIter
type instance O.AttributeList LayoutIter = LayoutIterAttributeList
type LayoutIterAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method LayoutIter::at_last_line
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_at_last_line" pango_layout_iter_at_last_line :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO CInt

-- | Determines whether /@iter@/ is on the last line of the layout.
layoutIterAtLastLine ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@iter@/ is on the last line
layoutIterAtLastLine iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_at_last_line iter'
    let result' = (/= 0) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data LayoutIterAtLastLineMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod LayoutIterAtLastLineMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterAtLastLine

instance O.OverloadedMethodInfo LayoutIterAtLastLineMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterAtLastLine",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterAtLastLine"
        })


#endif

-- method LayoutIter::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "LayoutIter" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_copy" pango_layout_iter_copy :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO (Ptr LayoutIter)

-- | Copies a @PangoLayoutIter@.
-- 
-- /Since: 1.20/
layoutIterCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (LayoutIter)
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m (Maybe LayoutIter)
    -- ^ __Returns:__ the newly allocated @PangoLayoutIter@
layoutIterCopy iter = liftIO $ do
    maybeIter <- case iter of
        Nothing -> return FP.nullPtr
        Just jIter -> do
            jIter' <- unsafeManagedPtrGetPtr jIter
            return jIter'
    result <- pango_layout_iter_copy maybeIter
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed LayoutIter) result'
        return result''
    whenJust iter touchManagedPtr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data LayoutIterCopyMethodInfo
instance (signature ~ (m (Maybe LayoutIter)), MonadIO m) => O.OverloadedMethod LayoutIterCopyMethodInfo LayoutIter signature where
    overloadedMethod i = layoutIterCopy (Just i)

instance O.OverloadedMethodInfo LayoutIterCopyMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterCopy"
        })


#endif

-- method LayoutIter::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`, may be %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_free" pango_layout_iter_free :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO ()

-- | Frees an iterator that\'s no longer in use.
layoutIterFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (LayoutIter)
    -- ^ /@iter@/: a @PangoLayoutIter@, may be 'P.Nothing'
    -> m ()
layoutIterFree iter = liftIO $ do
    maybeIter <- case iter of
        Nothing -> return FP.nullPtr
        Just jIter -> do
            jIter' <- unsafeManagedPtrGetPtr jIter
            return jIter'
    pango_layout_iter_free maybeIter
    whenJust iter touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data LayoutIterFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod LayoutIterFreeMethodInfo LayoutIter signature where
    overloadedMethod i = layoutIterFree (Just i)

instance O.OverloadedMethodInfo LayoutIterFreeMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterFree"
        })


#endif

-- method LayoutIter::get_baseline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_baseline" pango_layout_iter_get_baseline :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO Int32

-- | Gets the Y position of the current line\'s baseline, in layout
-- coordinates.
-- 
-- Layout coordinates have the origin at the top left of the entire layout.
layoutIterGetBaseline ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m Int32
    -- ^ __Returns:__ baseline of current line
layoutIterGetBaseline iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_get_baseline iter'
    touchManagedPtr iter
    return result

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetBaselineMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod LayoutIterGetBaselineMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetBaseline

instance O.OverloadedMethodInfo LayoutIterGetBaselineMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetBaseline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetBaseline"
        })


#endif

-- method LayoutIter::get_char_extents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logical_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to fill with\n  logical extents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_char_extents" pango_layout_iter_get_char_extents :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    Ptr Pango.Rectangle.Rectangle ->        -- logical_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    IO ()

-- | Gets the extents of the current character, in layout coordinates.
-- 
-- Layout coordinates have the origin at the top left of the entire layout.
-- 
-- Only logical extents can sensibly be obtained for characters;
-- ink extents make sense only down to the level of clusters.
layoutIterGetCharExtents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m (Pango.Rectangle.Rectangle)
layoutIterGetCharExtents iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    logicalRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    pango_layout_iter_get_char_extents iter' logicalRect
    logicalRect' <- (wrapPtr Pango.Rectangle.Rectangle) logicalRect
    touchManagedPtr iter
    return logicalRect'

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetCharExtentsMethodInfo
instance (signature ~ (m (Pango.Rectangle.Rectangle)), MonadIO m) => O.OverloadedMethod LayoutIterGetCharExtentsMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetCharExtents

instance O.OverloadedMethodInfo LayoutIterGetCharExtentsMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetCharExtents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetCharExtents"
        })


#endif

-- method LayoutIter::get_cluster_extents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ink_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to fill with ink extents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logical_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to fill with logical extents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_cluster_extents" pango_layout_iter_get_cluster_extents :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    Ptr Pango.Rectangle.Rectangle ->        -- ink_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    Ptr Pango.Rectangle.Rectangle ->        -- logical_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    IO ()

-- | Gets the extents of the current cluster, in layout coordinates.
-- 
-- Layout coordinates have the origin at the top left of the entire layout.
layoutIterGetClusterExtents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))
layoutIterGetClusterExtents iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    inkRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    logicalRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    pango_layout_iter_get_cluster_extents iter' inkRect logicalRect
    inkRect' <- (wrapPtr Pango.Rectangle.Rectangle) inkRect
    logicalRect' <- (wrapPtr Pango.Rectangle.Rectangle) logicalRect
    touchManagedPtr iter
    return (inkRect', logicalRect')

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetClusterExtentsMethodInfo
instance (signature ~ (m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))), MonadIO m) => O.OverloadedMethod LayoutIterGetClusterExtentsMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetClusterExtents

instance O.OverloadedMethodInfo LayoutIterGetClusterExtentsMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetClusterExtents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetClusterExtents"
        })


#endif

-- method LayoutIter::get_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_index" pango_layout_iter_get_index :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO Int32

-- | Gets the current byte index.
-- 
-- Note that iterating forward by char moves in visual order,
-- not logical order, so indexes may not be sequential. Also,
-- the index may be equal to the length of the text in the
-- layout, if on the 'P.Nothing' run (see 'GI.Pango.Structs.LayoutIter.layoutIterGetRun').
layoutIterGetIndex ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m Int32
    -- ^ __Returns:__ current byte index
layoutIterGetIndex iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_get_index iter'
    touchManagedPtr iter
    return result

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetIndexMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod LayoutIterGetIndexMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetIndex

instance O.OverloadedMethodInfo LayoutIterGetIndexMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetIndex"
        })


#endif

-- method LayoutIter::get_layout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Layout" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_layout" pango_layout_iter_get_layout :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO (Ptr Pango.Layout.Layout)

-- | Gets the layout associated with a @PangoLayoutIter@.
-- 
-- /Since: 1.20/
layoutIterGetLayout ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m (Maybe Pango.Layout.Layout)
    -- ^ __Returns:__ the layout associated with /@iter@/
layoutIterGetLayout iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_get_layout iter'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Pango.Layout.Layout) result'
        return result''
    touchManagedPtr iter
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetLayoutMethodInfo
instance (signature ~ (m (Maybe Pango.Layout.Layout)), MonadIO m) => O.OverloadedMethod LayoutIterGetLayoutMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetLayout

instance O.OverloadedMethodInfo LayoutIterGetLayoutMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetLayout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetLayout"
        })


#endif

-- method LayoutIter::get_layout_extents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ink_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to fill with ink extents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logical_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to fill with logical extents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_layout_extents" pango_layout_iter_get_layout_extents :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    Ptr Pango.Rectangle.Rectangle ->        -- ink_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    Ptr Pango.Rectangle.Rectangle ->        -- logical_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    IO ()

-- | Obtains the extents of the @PangoLayout@ being iterated over.
layoutIterGetLayoutExtents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))
layoutIterGetLayoutExtents iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    inkRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    logicalRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    pango_layout_iter_get_layout_extents iter' inkRect logicalRect
    inkRect' <- (wrapPtr Pango.Rectangle.Rectangle) inkRect
    logicalRect' <- (wrapPtr Pango.Rectangle.Rectangle) logicalRect
    touchManagedPtr iter
    return (inkRect', logicalRect')

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetLayoutExtentsMethodInfo
instance (signature ~ (m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))), MonadIO m) => O.OverloadedMethod LayoutIterGetLayoutExtentsMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetLayoutExtents

instance O.OverloadedMethodInfo LayoutIterGetLayoutExtentsMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetLayoutExtents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetLayoutExtents"
        })


#endif

-- method LayoutIter::get_line
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "LayoutLine" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_line" pango_layout_iter_get_line :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO (Ptr Pango.LayoutLine.LayoutLine)

-- | Gets the current line.
-- 
-- Use the faster 'GI.Pango.Structs.LayoutIter.layoutIterGetLineReadonly' if
-- you do not plan to modify the contents of the line (glyphs,
-- glyph widths, etc.).
layoutIterGetLine ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m (Maybe Pango.LayoutLine.LayoutLine)
    -- ^ __Returns:__ the current line
layoutIterGetLine iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_get_line iter'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Pango.LayoutLine.LayoutLine) result'
        return result''
    touchManagedPtr iter
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetLineMethodInfo
instance (signature ~ (m (Maybe Pango.LayoutLine.LayoutLine)), MonadIO m) => O.OverloadedMethod LayoutIterGetLineMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetLine

instance O.OverloadedMethodInfo LayoutIterGetLineMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetLine",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetLine"
        })


#endif

-- method LayoutIter::get_line_extents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ink_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to fill with ink extents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logical_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to fill with logical extents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_line_extents" pango_layout_iter_get_line_extents :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    Ptr Pango.Rectangle.Rectangle ->        -- ink_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    Ptr Pango.Rectangle.Rectangle ->        -- logical_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    IO ()

-- | Obtains the extents of the current line.
-- 
-- Extents are in layout coordinates (origin is the top-left corner
-- of the entire @PangoLayout@). Thus the extents returned by this
-- function will be the same width\/height but not at the same x\/y
-- as the extents returned from 'GI.Pango.Structs.LayoutLine.layoutLineGetExtents'.
layoutIterGetLineExtents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))
layoutIterGetLineExtents iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    inkRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    logicalRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    pango_layout_iter_get_line_extents iter' inkRect logicalRect
    inkRect' <- (wrapPtr Pango.Rectangle.Rectangle) inkRect
    logicalRect' <- (wrapPtr Pango.Rectangle.Rectangle) logicalRect
    touchManagedPtr iter
    return (inkRect', logicalRect')

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetLineExtentsMethodInfo
instance (signature ~ (m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))), MonadIO m) => O.OverloadedMethod LayoutIterGetLineExtentsMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetLineExtents

instance O.OverloadedMethodInfo LayoutIterGetLineExtentsMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetLineExtents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetLineExtents"
        })


#endif

-- method LayoutIter::get_line_readonly
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "LayoutLine" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_line_readonly" pango_layout_iter_get_line_readonly :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO (Ptr Pango.LayoutLine.LayoutLine)

-- | Gets the current line for read-only access.
-- 
-- This is a faster alternative to 'GI.Pango.Structs.LayoutIter.layoutIterGetLine',
-- but the user is not expected to modify the contents of the line
-- (glyphs, glyph widths, etc.).
-- 
-- /Since: 1.16/
layoutIterGetLineReadonly ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m (Maybe Pango.LayoutLine.LayoutLine)
    -- ^ __Returns:__ the current line, that should not be
    --   modified
layoutIterGetLineReadonly iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_get_line_readonly iter'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Pango.LayoutLine.LayoutLine) result'
        return result''
    touchManagedPtr iter
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetLineReadonlyMethodInfo
instance (signature ~ (m (Maybe Pango.LayoutLine.LayoutLine)), MonadIO m) => O.OverloadedMethod LayoutIterGetLineReadonlyMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetLineReadonly

instance O.OverloadedMethodInfo LayoutIterGetLineReadonlyMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetLineReadonly",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetLineReadonly"
        })


#endif

-- method LayoutIter::get_line_yrange
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y0_"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "start of line" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y1_"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "end of line" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_line_yrange" pango_layout_iter_get_line_yrange :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    Ptr Int32 ->                            -- y0_ : TBasicType TInt
    Ptr Int32 ->                            -- y1_ : TBasicType TInt
    IO ()

-- | Divides the vertical space in the @PangoLayout@ being iterated over
-- between the lines in the layout, and returns the space belonging to
-- the current line.
-- 
-- A line\'s range includes the line\'s logical extents. plus half of the
-- spacing above and below the line, if 'GI.Pango.Objects.Layout.layoutSetSpacing'
-- has been called to set layout spacing. The Y positions are in layout
-- coordinates (origin at top left of the entire layout).
-- 
-- Note: Since 1.44, Pango uses line heights for placing lines, and there
-- may be gaps between the ranges returned by this function.
layoutIterGetLineYrange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m ((Int32, Int32))
layoutIterGetLineYrange iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    y0_ <- allocMem :: IO (Ptr Int32)
    y1_ <- allocMem :: IO (Ptr Int32)
    pango_layout_iter_get_line_yrange iter' y0_ y1_
    y0_' <- peek y0_
    y1_' <- peek y1_
    touchManagedPtr iter
    freeMem y0_
    freeMem y1_
    return (y0_', y1_')

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetLineYrangeMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m) => O.OverloadedMethod LayoutIterGetLineYrangeMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetLineYrange

instance O.OverloadedMethodInfo LayoutIterGetLineYrangeMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetLineYrange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetLineYrange"
        })


#endif

-- method LayoutIter::get_run
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "GlyphItem" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_run" pango_layout_iter_get_run :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO (Ptr Pango.GlyphItem.GlyphItem)

-- | Gets the current run.
-- 
-- When iterating by run, at the end of each line, there\'s a position
-- with a 'P.Nothing' run, so this function can return 'P.Nothing'. The 'P.Nothing' run
-- at the end of each line ensures that all lines have at least one run,
-- even lines consisting of only a newline.
-- 
-- Use the faster 'GI.Pango.Structs.LayoutIter.layoutIterGetRunReadonly' if you do not
-- plan to modify the contents of the run (glyphs, glyph widths, etc.).
layoutIterGetRun ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m (Maybe Pango.GlyphItem.GlyphItem)
    -- ^ __Returns:__ the current run
layoutIterGetRun iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_get_run iter'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Pango.GlyphItem.GlyphItem) result'
        return result''
    touchManagedPtr iter
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetRunMethodInfo
instance (signature ~ (m (Maybe Pango.GlyphItem.GlyphItem)), MonadIO m) => O.OverloadedMethod LayoutIterGetRunMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetRun

instance O.OverloadedMethodInfo LayoutIterGetRunMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetRun",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetRun"
        })


#endif

-- method LayoutIter::get_run_baseline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_run_baseline" pango_layout_iter_get_run_baseline :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO Int32

-- | Gets the Y position of the current run\'s baseline, in layout
-- coordinates.
-- 
-- Layout coordinates have the origin at the top left of the entire layout.
-- 
-- The run baseline can be different from the line baseline, for
-- example due to superscript or subscript positioning.
-- 
-- /Since: 1.50/
layoutIterGetRunBaseline ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m Int32
layoutIterGetRunBaseline iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_get_run_baseline iter'
    touchManagedPtr iter
    return result

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetRunBaselineMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod LayoutIterGetRunBaselineMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetRunBaseline

instance O.OverloadedMethodInfo LayoutIterGetRunBaselineMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetRunBaseline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetRunBaseline"
        })


#endif

-- method LayoutIter::get_run_extents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ink_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to fill with ink extents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logical_rect"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to fill with logical extents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_run_extents" pango_layout_iter_get_run_extents :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    Ptr Pango.Rectangle.Rectangle ->        -- ink_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    Ptr Pango.Rectangle.Rectangle ->        -- logical_rect : TInterface (Name {namespace = "Pango", name = "Rectangle"})
    IO ()

-- | Gets the extents of the current run in layout coordinates.
-- 
-- Layout coordinates have the origin at the top left of the entire layout.
layoutIterGetRunExtents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))
layoutIterGetRunExtents iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    inkRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    logicalRect <- SP.callocBytes 16 :: IO (Ptr Pango.Rectangle.Rectangle)
    pango_layout_iter_get_run_extents iter' inkRect logicalRect
    inkRect' <- (wrapPtr Pango.Rectangle.Rectangle) inkRect
    logicalRect' <- (wrapPtr Pango.Rectangle.Rectangle) logicalRect
    touchManagedPtr iter
    return (inkRect', logicalRect')

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetRunExtentsMethodInfo
instance (signature ~ (m ((Pango.Rectangle.Rectangle, Pango.Rectangle.Rectangle))), MonadIO m) => O.OverloadedMethod LayoutIterGetRunExtentsMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetRunExtents

instance O.OverloadedMethodInfo LayoutIterGetRunExtentsMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetRunExtents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetRunExtents"
        })


#endif

-- method LayoutIter::get_run_readonly
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "GlyphItem" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_get_run_readonly" pango_layout_iter_get_run_readonly :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO (Ptr Pango.GlyphItem.GlyphItem)

-- | Gets the current run for read-only access.
-- 
-- When iterating by run, at the end of each line, there\'s a position
-- with a 'P.Nothing' run, so this function can return 'P.Nothing'. The 'P.Nothing' run
-- at the end of each line ensures that all lines have at least one run,
-- even lines consisting of only a newline.
-- 
-- This is a faster alternative to 'GI.Pango.Structs.LayoutIter.layoutIterGetRun',
-- but the user is not expected to modify the contents of the run (glyphs,
-- glyph widths, etc.).
-- 
-- /Since: 1.16/
layoutIterGetRunReadonly ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m (Maybe Pango.GlyphItem.GlyphItem)
    -- ^ __Returns:__ the current run, that
    --   should not be modified
layoutIterGetRunReadonly iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_get_run_readonly iter'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Pango.GlyphItem.GlyphItem) result'
        return result''
    touchManagedPtr iter
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data LayoutIterGetRunReadonlyMethodInfo
instance (signature ~ (m (Maybe Pango.GlyphItem.GlyphItem)), MonadIO m) => O.OverloadedMethod LayoutIterGetRunReadonlyMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterGetRunReadonly

instance O.OverloadedMethodInfo LayoutIterGetRunReadonlyMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterGetRunReadonly",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterGetRunReadonly"
        })


#endif

-- method LayoutIter::next_char
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_next_char" pango_layout_iter_next_char :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO CInt

-- | Moves /@iter@/ forward to the next character in visual order.
-- 
-- If /@iter@/ was already at the end of the layout, returns 'P.False'.
layoutIterNextChar ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m Bool
    -- ^ __Returns:__ whether motion was possible
layoutIterNextChar iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_next_char iter'
    let result' = (/= 0) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data LayoutIterNextCharMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod LayoutIterNextCharMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterNextChar

instance O.OverloadedMethodInfo LayoutIterNextCharMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterNextChar",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterNextChar"
        })


#endif

-- method LayoutIter::next_cluster
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_next_cluster" pango_layout_iter_next_cluster :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO CInt

-- | Moves /@iter@/ forward to the next cluster in visual order.
-- 
-- If /@iter@/ was already at the end of the layout, returns 'P.False'.
layoutIterNextCluster ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m Bool
    -- ^ __Returns:__ whether motion was possible
layoutIterNextCluster iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_next_cluster iter'
    let result' = (/= 0) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data LayoutIterNextClusterMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod LayoutIterNextClusterMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterNextCluster

instance O.OverloadedMethodInfo LayoutIterNextClusterMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterNextCluster",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterNextCluster"
        })


#endif

-- method LayoutIter::next_line
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_next_line" pango_layout_iter_next_line :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO CInt

-- | Moves /@iter@/ forward to the start of the next line.
-- 
-- If /@iter@/ is already on the last line, returns 'P.False'.
layoutIterNextLine ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m Bool
    -- ^ __Returns:__ whether motion was possible
layoutIterNextLine iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_next_line iter'
    let result' = (/= 0) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data LayoutIterNextLineMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod LayoutIterNextLineMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterNextLine

instance O.OverloadedMethodInfo LayoutIterNextLineMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterNextLine",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterNextLine"
        })


#endif

-- method LayoutIter::next_run
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "LayoutIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoLayoutIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_layout_iter_next_run" pango_layout_iter_next_run :: 
    Ptr LayoutIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "LayoutIter"})
    IO CInt

-- | Moves /@iter@/ forward to the next run in visual order.
-- 
-- If /@iter@/ was already at the end of the layout, returns 'P.False'.
layoutIterNextRun ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    LayoutIter
    -- ^ /@iter@/: a @PangoLayoutIter@
    -> m Bool
    -- ^ __Returns:__ whether motion was possible
layoutIterNextRun iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_layout_iter_next_run iter'
    let result' = (/= 0) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data LayoutIterNextRunMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod LayoutIterNextRunMethodInfo LayoutIter signature where
    overloadedMethod = layoutIterNextRun

instance O.OverloadedMethodInfo LayoutIterNextRunMethodInfo LayoutIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.LayoutIter.layoutIterNextRun",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-LayoutIter.html#v:layoutIterNextRun"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveLayoutIterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveLayoutIterMethod "atLastLine" o = LayoutIterAtLastLineMethodInfo
    ResolveLayoutIterMethod "copy" o = LayoutIterCopyMethodInfo
    ResolveLayoutIterMethod "free" o = LayoutIterFreeMethodInfo
    ResolveLayoutIterMethod "nextChar" o = LayoutIterNextCharMethodInfo
    ResolveLayoutIterMethod "nextCluster" o = LayoutIterNextClusterMethodInfo
    ResolveLayoutIterMethod "nextLine" o = LayoutIterNextLineMethodInfo
    ResolveLayoutIterMethod "nextRun" o = LayoutIterNextRunMethodInfo
    ResolveLayoutIterMethod "getBaseline" o = LayoutIterGetBaselineMethodInfo
    ResolveLayoutIterMethod "getCharExtents" o = LayoutIterGetCharExtentsMethodInfo
    ResolveLayoutIterMethod "getClusterExtents" o = LayoutIterGetClusterExtentsMethodInfo
    ResolveLayoutIterMethod "getIndex" o = LayoutIterGetIndexMethodInfo
    ResolveLayoutIterMethod "getLayout" o = LayoutIterGetLayoutMethodInfo
    ResolveLayoutIterMethod "getLayoutExtents" o = LayoutIterGetLayoutExtentsMethodInfo
    ResolveLayoutIterMethod "getLine" o = LayoutIterGetLineMethodInfo
    ResolveLayoutIterMethod "getLineExtents" o = LayoutIterGetLineExtentsMethodInfo
    ResolveLayoutIterMethod "getLineReadonly" o = LayoutIterGetLineReadonlyMethodInfo
    ResolveLayoutIterMethod "getLineYrange" o = LayoutIterGetLineYrangeMethodInfo
    ResolveLayoutIterMethod "getRun" o = LayoutIterGetRunMethodInfo
    ResolveLayoutIterMethod "getRunBaseline" o = LayoutIterGetRunBaselineMethodInfo
    ResolveLayoutIterMethod "getRunExtents" o = LayoutIterGetRunExtentsMethodInfo
    ResolveLayoutIterMethod "getRunReadonly" o = LayoutIterGetRunReadonlyMethodInfo
    ResolveLayoutIterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveLayoutIterMethod t LayoutIter, O.OverloadedMethod info LayoutIter p) => OL.IsLabel t (LayoutIter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveLayoutIterMethod t LayoutIter, O.OverloadedMethod info LayoutIter p, R.HasField t LayoutIter p) => R.HasField t LayoutIter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveLayoutIterMethod t LayoutIter, O.OverloadedMethodInfo info LayoutIter) => OL.IsLabel t (O.MethodProxy info LayoutIter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


