# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Show(AAZCommand):
    """Get the status of a virtual machine from a VM scale set.
    """

    _aaz_info = {
        "version": "2024-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/virtualmachinescalesets/{}/virtualmachines/{}/instanceview", "2024-11-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.instance_id = AAZStrArg(
            options=["--instance-id"],
            help="The instance ID of the virtual machine.",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.vm_scale_set_name = AAZStrArg(
            options=["--vm-scale-set-name"],
            help="The name of the VM scale set.",
            required=True,
            id_part="name",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.VirtualMachineScaleSetVMsGetInstanceView(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class VirtualMachineScaleSetVMsGetInstanceView(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/instanceView",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "instanceId", self.ctx.args.instance_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "vmScaleSetName", self.ctx.args.vm_scale_set_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2024-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.assigned_host = AAZStrType(
                serialized_name="assignedHost",
                flags={"read_only": True},
            )
            _schema_on_200.boot_diagnostics = AAZObjectType(
                serialized_name="bootDiagnostics",
            )
            _schema_on_200.computer_name = AAZStrType(
                serialized_name="computerName",
            )
            _schema_on_200.disks = AAZListType()
            _schema_on_200.extensions = AAZListType()
            _schema_on_200.hyper_v_generation = AAZStrType(
                serialized_name="hyperVGeneration",
            )
            _schema_on_200.maintenance_redeploy_status = AAZObjectType(
                serialized_name="maintenanceRedeployStatus",
            )
            _schema_on_200.os_name = AAZStrType(
                serialized_name="osName",
            )
            _schema_on_200.os_version = AAZStrType(
                serialized_name="osVersion",
            )
            _schema_on_200.placement_group_id = AAZStrType(
                serialized_name="placementGroupId",
            )
            _schema_on_200.platform_fault_domain = AAZIntType(
                serialized_name="platformFaultDomain",
            )
            _schema_on_200.platform_update_domain = AAZIntType(
                serialized_name="platformUpdateDomain",
            )
            _schema_on_200.rdp_thumb_print = AAZStrType(
                serialized_name="rdpThumbPrint",
            )
            _schema_on_200.statuses = AAZListType()
            _schema_on_200.vm_agent = AAZObjectType(
                serialized_name="vmAgent",
            )
            _schema_on_200.vm_health = AAZObjectType(
                serialized_name="vmHealth",
                flags={"read_only": True},
            )

            boot_diagnostics = cls._schema_on_200.boot_diagnostics
            boot_diagnostics.console_screenshot_blob_uri = AAZStrType(
                serialized_name="consoleScreenshotBlobUri",
                flags={"read_only": True},
            )
            boot_diagnostics.serial_console_log_blob_uri = AAZStrType(
                serialized_name="serialConsoleLogBlobUri",
                flags={"read_only": True},
            )
            boot_diagnostics.status = AAZObjectType(
                flags={"read_only": True},
            )
            _ShowHelper._build_schema_instance_view_status_read(boot_diagnostics.status)

            disks = cls._schema_on_200.disks
            disks.Element = AAZObjectType()

            _element = cls._schema_on_200.disks.Element
            _element.encryption_settings = AAZListType(
                serialized_name="encryptionSettings",
            )
            _element.name = AAZStrType()
            _element.statuses = AAZListType()

            encryption_settings = cls._schema_on_200.disks.Element.encryption_settings
            encryption_settings.Element = AAZObjectType()

            _element = cls._schema_on_200.disks.Element.encryption_settings.Element
            _element.disk_encryption_key = AAZObjectType(
                serialized_name="diskEncryptionKey",
            )
            _element.enabled = AAZBoolType()
            _element.key_encryption_key = AAZObjectType(
                serialized_name="keyEncryptionKey",
            )

            disk_encryption_key = cls._schema_on_200.disks.Element.encryption_settings.Element.disk_encryption_key
            disk_encryption_key.secret_url = AAZStrType(
                serialized_name="secretUrl",
                flags={"required": True},
            )
            disk_encryption_key.source_vault = AAZObjectType(
                serialized_name="sourceVault",
                flags={"required": True},
            )
            _ShowHelper._build_schema_sub_resource_read(disk_encryption_key.source_vault)

            key_encryption_key = cls._schema_on_200.disks.Element.encryption_settings.Element.key_encryption_key
            key_encryption_key.key_url = AAZStrType(
                serialized_name="keyUrl",
                flags={"required": True},
            )
            key_encryption_key.source_vault = AAZObjectType(
                serialized_name="sourceVault",
                flags={"required": True},
            )
            _ShowHelper._build_schema_sub_resource_read(key_encryption_key.source_vault)

            statuses = cls._schema_on_200.disks.Element.statuses
            statuses.Element = AAZObjectType()
            _ShowHelper._build_schema_instance_view_status_read(statuses.Element)

            extensions = cls._schema_on_200.extensions
            extensions.Element = AAZObjectType()

            _element = cls._schema_on_200.extensions.Element
            _element.name = AAZStrType()
            _element.statuses = AAZListType()
            _element.substatuses = AAZListType()
            _element.type = AAZStrType()
            _element.type_handler_version = AAZStrType(
                serialized_name="typeHandlerVersion",
            )

            statuses = cls._schema_on_200.extensions.Element.statuses
            statuses.Element = AAZObjectType()
            _ShowHelper._build_schema_instance_view_status_read(statuses.Element)

            substatuses = cls._schema_on_200.extensions.Element.substatuses
            substatuses.Element = AAZObjectType()
            _ShowHelper._build_schema_instance_view_status_read(substatuses.Element)

            maintenance_redeploy_status = cls._schema_on_200.maintenance_redeploy_status
            maintenance_redeploy_status.is_customer_initiated_maintenance_allowed = AAZBoolType(
                serialized_name="isCustomerInitiatedMaintenanceAllowed",
            )
            maintenance_redeploy_status.last_operation_message = AAZStrType(
                serialized_name="lastOperationMessage",
            )
            maintenance_redeploy_status.last_operation_result_code = AAZStrType(
                serialized_name="lastOperationResultCode",
            )
            maintenance_redeploy_status.maintenance_window_end_time = AAZStrType(
                serialized_name="maintenanceWindowEndTime",
            )
            maintenance_redeploy_status.maintenance_window_start_time = AAZStrType(
                serialized_name="maintenanceWindowStartTime",
            )
            maintenance_redeploy_status.pre_maintenance_window_end_time = AAZStrType(
                serialized_name="preMaintenanceWindowEndTime",
            )
            maintenance_redeploy_status.pre_maintenance_window_start_time = AAZStrType(
                serialized_name="preMaintenanceWindowStartTime",
            )

            statuses = cls._schema_on_200.statuses
            statuses.Element = AAZObjectType()
            _ShowHelper._build_schema_instance_view_status_read(statuses.Element)

            vm_agent = cls._schema_on_200.vm_agent
            vm_agent.extension_handlers = AAZListType(
                serialized_name="extensionHandlers",
            )
            vm_agent.statuses = AAZListType()
            vm_agent.vm_agent_version = AAZStrType(
                serialized_name="vmAgentVersion",
            )

            extension_handlers = cls._schema_on_200.vm_agent.extension_handlers
            extension_handlers.Element = AAZObjectType()

            _element = cls._schema_on_200.vm_agent.extension_handlers.Element
            _element.status = AAZObjectType()
            _ShowHelper._build_schema_instance_view_status_read(_element.status)
            _element.type = AAZStrType()
            _element.type_handler_version = AAZStrType(
                serialized_name="typeHandlerVersion",
            )

            statuses = cls._schema_on_200.vm_agent.statuses
            statuses.Element = AAZObjectType()
            _ShowHelper._build_schema_instance_view_status_read(statuses.Element)

            vm_health = cls._schema_on_200.vm_health
            vm_health.status = AAZObjectType(
                flags={"read_only": True},
            )
            _ShowHelper._build_schema_instance_view_status_read(vm_health.status)

            return cls._schema_on_200


class _ShowHelper:
    """Helper class for Show"""

    _schema_instance_view_status_read = None

    @classmethod
    def _build_schema_instance_view_status_read(cls, _schema):
        if cls._schema_instance_view_status_read is not None:
            _schema.code = cls._schema_instance_view_status_read.code
            _schema.display_status = cls._schema_instance_view_status_read.display_status
            _schema.level = cls._schema_instance_view_status_read.level
            _schema.message = cls._schema_instance_view_status_read.message
            _schema.time = cls._schema_instance_view_status_read.time
            return

        cls._schema_instance_view_status_read = _schema_instance_view_status_read = AAZObjectType()

        instance_view_status_read = _schema_instance_view_status_read
        instance_view_status_read.code = AAZStrType()
        instance_view_status_read.display_status = AAZStrType(
            serialized_name="displayStatus",
        )
        instance_view_status_read.level = AAZStrType()
        instance_view_status_read.message = AAZStrType()
        instance_view_status_read.time = AAZStrType()

        _schema.code = cls._schema_instance_view_status_read.code
        _schema.display_status = cls._schema_instance_view_status_read.display_status
        _schema.level = cls._schema_instance_view_status_read.level
        _schema.message = cls._schema_instance_view_status_read.message
        _schema.time = cls._schema_instance_view_status_read.time

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id


__all__ = ["Show"]
