/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core.resthandler;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsAction;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsRequest;
import org.opensearch.alerting.core.resthandler.StatsRequestUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/alerting/core/resthandler/RestScheduledJobStatsHandler;", "Lorg/opensearch/rest/BaseRestHandler;", "path", "", "<init>", "(Ljava/lang/String;)V", "getName", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "alerting-core"})
@SourceDebugExtension(value={"SMAP\nRestScheduledJobStatsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestScheduledJobStatsHandler.kt\norg/opensearch/alerting/core/resthandler/RestScheduledJobStatsHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class RestScheduledJobStatsHandler
extends BaseRestHandler {
    @NotNull
    private final String path;

    public RestScheduledJobStatsHandler(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
    }

    @NotNull
    public String getName() {
        return this.path + "_jobs_stats";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/" + this.path + "/{nodeId}/stats/", RestRequest.Method.GET, "/_opendistro/" + this.path + "/{nodeId}/stats/"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/" + this.path + "/{nodeId}/stats/{metric}", RestRequest.Method.GET, "/_opendistro/" + this.path + "/{nodeId}/stats/{metric}"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/" + this.path + "/stats/", RestRequest.Method.GET, "/_opendistro/" + this.path + "/stats/"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_plugins/" + this.path + "/stats/{metric}", RestRequest.Method.GET, "/_opendistro/" + this.path + "/stats/{metric}")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String alertingVersion = request.param("version");
        if (alertingVersion != null) {
            Object[] objectArray = new String[]{"v1", "v2"};
            if (!CollectionsKt.listOf((Object[])objectArray).contains(alertingVersion)) {
                throw new IllegalArgumentException("Version parameter must be one of v1 or v2");
            }
        }
        String string = alertingVersion;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)"v2");
        } else {
            bl = null;
        }
        Boolean showV2ScheduledJobs = bl;
        ScheduledJobsStatsRequest scheduledJobNodesStatsRequest2 = StatsRequestUtils.INSTANCE.getStatsRequest(request, showV2ScheduledJobs, (Function4<? super RestRequest, ? super Set<String>, ? super Set<String>, ? super String, String>)((Function4)new Function4<RestRequest, Set<String>, Set<String>, String, String>((Object)this){

            public final String invoke(RestRequest p0, Set<String> p1, Set<String> p2, String p3) {
                return RestScheduledJobStatsHandler.access$unrecognized((RestScheduledJobStatsHandler)((Object)this.receiver), p0, p1, p2, p3);
            }
        }));
        return arg_0 -> RestScheduledJobStatsHandler.prepareRequest$lambda$1(client, scheduledJobNodesStatsRequest2, arg_0);
    }

    private static final void prepareRequest$lambda$1(NodeClient $client, ScheduledJobsStatsRequest $scheduledJobNodesStatsRequest, RestChannel channel) {
        $client.execute((ActionType)ScheduledJobsStatsAction.Companion.getINSTANCE(), (ActionRequest)$scheduledJobNodesStatsRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    public static final /* synthetic */ String access$unrecognized(RestScheduledJobStatsHandler $this, RestRequest p0, Set p1, Set p2, String p3) {
        return $this.unrecognized(p0, p1, p2, p3);
    }
}

