/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.RollupIndexResult;
import org.opensearch.indexmanagement.rollup.RollupIndexer;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupStats;
import org.opensearch.indexmanagement.rollup.settings.RollupSettings;
import org.opensearch.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.opensearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.opensearch.search.aggregations.metrics.InternalAvg;
import org.opensearch.search.aggregations.metrics.InternalCardinality;
import org.opensearch.search.aggregations.metrics.InternalMax;
import org.opensearch.search.aggregations.metrics.InternalMin;
import org.opensearch.search.aggregations.metrics.InternalSum;
import org.opensearch.search.aggregations.metrics.InternalValueCount;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupIndexer;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "client", "Lorg/opensearch/transport/client/Client;", "<init>", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/transport/client/Client;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "retryIngestPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "indexRollups", "Lorg/opensearch/indexmanagement/rollup/RollupIndexResult;", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "internalComposite", "Lorg/opensearch/search/aggregations/bucket/composite/InternalComposite;", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lorg/opensearch/search/aggregations/bucket/composite/InternalComposite;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "convertResponseToRequests", "", "Lorg/opensearch/action/DocWriteRequest;", "job", "extractHLLSketch", "", "cardinality", "Lorg/opensearch/search/aggregations/metrics/InternalCardinality;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollupIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupIndexer.kt\norg/opensearch/indexmanagement/rollup/RollupIndexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1869#2:193\n1869#2,2:194\n1869#2,2:196\n1870#2:198\n*S KotlinDebug\n*F\n+ 1 RollupIndexer.kt\norg/opensearch/indexmanagement/rollup/RollupIndexer\n*L\n111#1:193\n117#1:194,2\n118#1:196,2\n111#1:198\n*E\n"})
public final class RollupIndexer {
    @NotNull
    private final Client client;
    private final Logger logger;
    private volatile BackoffPolicy retryIngestPolicy;

    public RollupIndexer(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.logger = LogManager.getLogger(this.getClass());
        TimeValue timeValue = (TimeValue)RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_MILLIS().get(settings);
        Object object = RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_COUNT().get(settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.retryIngestPolicy = BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_MILLIS(), RollupSettings.Companion.getROLLUP_INGEST_BACKOFF_COUNT(), (arg_0, arg_1) -> RollupIndexer._init_$lambda$0(this, arg_0, arg_1));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object indexRollups(@NotNull Rollup rollup, @NotNull InternalComposite internalComposite, @NotNull Continuation<? super RollupIndexResult> $completion) {
        if (!($completion instanceof indexRollups.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ RollupIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.indexRollups(null, null, (Continuation<? super RollupIndexResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                requestsToRetry = new Ref.ObjectRef();
                requestsToRetry.element = this.convertResponseToRequests(rollup, internalComposite);
                stats = new Ref.ObjectRef();
                stats.element = new RollupStats(0L, 0L, ((List)requestsToRetry.element).size(), 0L, 0L);
                nonRetryableFailures = new ArrayList<E>();
                if (!(((Collection)requestsToRetry.element).isEmpty() == false)) ** GOTO lbl44
                v0 = this.retryIngestPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"retryIngestPolicy");
                v1 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"logger");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)rollup);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)internalComposite);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)requestsToRetry);
                $continuation.L$3 = stats;
                $continuation.L$4 = nonRetryableFailures;
                $continuation.label = 1;
                v2 = OpenSearchExtensionsKt.retry(v0, v1, CollectionsKt.listOf((Object)RestStatus.TOO_MANY_REQUESTS), (Function2)new Function2<TimeValue, Continuation<? super Unit>, Object>(requestsToRetry, this, (Ref.ObjectRef<RollupStats>)stats, (List<BulkItemResponse>)nonRetryableFailures, null){
                    Object L$1;
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ Ref.ObjectRef<List<DocWriteRequest<?>>> $requestsToRetry;
                    final /* synthetic */ RollupIndexer this$0;
                    final /* synthetic */ Ref.ObjectRef<RollupStats> $stats;
                    final /* synthetic */ List<BulkItemResponse> $nonRetryableFailures;
                    {
                        this.$requestsToRetry = $requestsToRetry;
                        this.this$0 = $receiver;
                        this.$stats = $stats;
                        this.$nonRetryableFailures = $nonRetryableFailures;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = (TimeValue)this.L$0;
                        var18_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                if (it.getSeconds() >= 900L) {
                                    throw ExceptionsHelper.convertToOpenSearchException((Exception)new IllegalStateException("Cannot retry ingestion with a delay more than half of the rollup lock TTL"));
                                }
                                bulkRequest = new BulkRequest().add((Iterable)this.$requestsToRetry.element);
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                this.L$1 = bulkRequest;
                                this.label = 1;
                                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)RollupIndexer.access$getClient$p(this.this$0), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(org.opensearch.action.bulk.BulkRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((BulkRequest)bulkRequest), (Continuation)this);
                                if (v0 == var18_3) {
                                    return var18_3;
                                }
                                ** GOTO lbl20
                            }
                            case 1: {
                                bulkRequest = (BulkRequest)this.L$1;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl20:
                                // 2 sources

                                bulkResponse = (BulkResponse)v0;
                                this.$stats.element = RollupStats.copy$default((RollupStats)this.$stats.element, 0L, 0L, 0L, ((RollupStats)this.$stats.element).getIndexTimeInMillis() + bulkResponse.getTook().getMillis(), 0L, 23, null);
                                retryableFailures = new ArrayList<E>();
                                v1 = bulkResponse.getItems();
                                if (v1 == null) {
                                    v1 = new BulkItemResponse[]{};
                                }
                                $this$filter$iv /* !! */  = v1;
                                $i$f$filter = false;
                                var8_11 = $this$filter$iv /* !! */ ;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (BulkItemResponse element$iv$iv : $this$filterTo$iv$iv) {
                                    it = element$iv$iv;
                                    $i$a$-filter-RollupIndexer$indexRollups$2$1 = false;
                                    if (!it.isFailed()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$filter$iv /* !! */  = (List)destination$iv$iv;
                                $i$f$filter = this.$nonRetryableFailures;
                                $i$f$forEach = false;
                                for (E element$iv : $this$forEach$iv) {
                                    failedResponse = (BulkItemResponse)element$iv;
                                    $i$a$-forEach-RollupIndexer$indexRollups$2$2 = false;
                                    if (failedResponse.status() == RestStatus.TOO_MANY_REQUESTS) {
                                        Intrinsics.checkNotNull((Object)failedResponse);
                                        v2 = retryableFailures.add(failedResponse);
                                        continue;
                                    }
                                    Intrinsics.checkNotNull((Object)failedResponse);
                                    v2 = $i$f$filter.add(failedResponse);
                                }
                                $this$forEach$iv = retryableFailures;
                                var16_26 = this.$requestsToRetry;
                                $i$f$map = false;
                                $i$f$forEach = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    element$iv$iv = (BulkItemResponse)item$iv$iv;
                                    var17_27 = destination$iv$iv;
                                    $i$a$-map-RollupIndexer$indexRollups$2$3 = false;
                                    v3 = bulkRequest.requests().get(retryableFailure.getItemId());
                                    Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type org.opensearch.action.index.IndexRequest");
                                    var17_27.add((IndexRequest)v3);
                                }
                                var16_26.element = (List)destination$iv$iv;
                                if (((Collection)this.$requestsToRetry.element).isEmpty() == false) {
                                    retryCause = ((BulkItemResponse)CollectionsKt.first((List)retryableFailures)).getFailure().getCause();
                                    throw ExceptionsHelper.convertToOpenSearchException((Exception)retryCause);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(TimeValue p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(BulkRequest $bulkRequest, Client $this$suspendUntil, ActionListener it) {
                        $this$suspendUntil.bulk($bulkRequest, it);
                        return Unit.INSTANCE;
                    }
                }, $continuation);
                ** if (v2 != var9_6) goto lbl33
lbl32:
                // 1 sources

                return var9_6;
lbl33:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                nonRetryableFailures = (List)$continuation.L$4;
                stats = (Ref.ObjectRef)$continuation.L$3;
                requestsToRetry = (Ref.ObjectRef)$continuation.L$2;
                internalComposite = (InternalComposite)$continuation.L$1;
                rollup = (Rollup)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl44:
                    // 3 sources

                    if (((Collection)nonRetryableFailures).isEmpty() == false) {
                        this.logger.error("Failed to index " + nonRetryableFailures.size() + " documents");
                        throw ExceptionsHelper.convertToOpenSearchException((Exception)((BulkItemResponse)CollectionsKt.first((List)nonRetryableFailures)).getFailure().getCause());
                    }
                    return new RollupIndexResult.Success((RollupStats)stats.element);
                }
                catch (RemoteTransportException e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    v3 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type java.lang.Exception");
                    return new RollupIndexResult.Failure(null, (Exception)v3, 1, null);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), e.getCause());
                    return new RollupIndexResult.Failure(null, e, 1, null);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final List<DocWriteRequest<?>> convertResponseToRequests(@NotNull Rollup job, @NotNull InternalComposite internalComposite) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)internalComposite, (String)"internalComposite");
        List requests = new ArrayList();
        List list = internalComposite.getBuckets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBuckets(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it;
            InternalComposite.InternalBucket it2 = (InternalComposite.InternalBucket)element$iv;
            boolean bl = false;
            String docId = job.getId() + "#" + CollectionsKt.joinToString$default((Iterable)it2.getKey().entrySet(), (CharSequence)"#", null, null, (int)0, null, RollupIndexer::convertResponseToRequests$lambda$4$lambda$1, (int)30, null);
            String documentId = IndexUtils.Companion.hashToFixedSize(docId);
            Map<String, Object> mapOfKeyValues = RollupUtilsKt.getInitialDocValues(job, it2.getDocCount());
            Map aggResults = new LinkedHashMap();
            Iterable $this$forEach$iv2 = it2.getKey().entrySet();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (Map.Entry)element$iv2;
                boolean bl2 = false;
                aggResults.put(it.getKey(), it.getValue());
            }
            Aggregations aggregations = it2.getAggregations();
            Intrinsics.checkNotNullExpressionValue((Object)aggregations, (String)"getAggregations(...)");
            $this$forEach$iv2 = (Iterable)aggregations;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (Aggregation)element$iv2;
                boolean bl3 = false;
                Map.Entry entry = it;
                if (entry instanceof InternalSum) {
                    aggResults.put(((InternalSum)it).getName(), ((InternalSum)it).getValue());
                    continue;
                }
                if (entry instanceof InternalMax) {
                    if (Double.isInfinite(((InternalMax)it).getValue())) {
                        aggResults.put(((InternalMax)it).getName(), null);
                        continue;
                    }
                    aggResults.put(((InternalMax)it).getName(), ((InternalMax)it).getValue());
                    continue;
                }
                if (entry instanceof InternalMin) {
                    if (Double.isInfinite(((InternalMin)it).getValue())) {
                        aggResults.put(((InternalMin)it).getName(), null);
                        continue;
                    }
                    aggResults.put(((InternalMin)it).getName(), ((InternalMin)it).getValue());
                    continue;
                }
                if (entry instanceof InternalValueCount) {
                    aggResults.put(((InternalValueCount)it).getName(), ((InternalValueCount)it).getValue());
                    continue;
                }
                if (entry instanceof InternalAvg) {
                    aggResults.put(((InternalAvg)it).getName(), ((InternalAvg)it).getValue());
                    continue;
                }
                if (entry instanceof InternalCardinality) {
                    aggResults.put(((InternalCardinality)it).getName(), this.extractHLLSketch((InternalCardinality)it));
                    continue;
                }
                throw new IllegalStateException(("Found aggregation in composite result that is not supported [" + it.getType() + " - " + it.getName() + "]").toString());
            }
            mapOfKeyValues.putAll(aggResults);
            String targetIndexResolvedName = RollupFieldValueExpressionResolver.INSTANCE.resolve(job, job.getTargetIndex());
            IndexRequest indexRequest = new IndexRequest(targetIndexResolvedName).id(documentId).source(mapOfKeyValues, (MediaType)XContentType.JSON);
            Intrinsics.checkNotNull((Object)indexRequest);
            requests.add(indexRequest);
        }
        return requests;
    }

    private final byte[] extractHLLSketch(InternalCardinality cardinality) {
        byte[] byArray;
        try {
            byte[] byArray2;
            AbstractHyperLogLogPlusPlus sketch = cardinality.getCounts();
            if (sketch == null) {
                this.logger.debug("No HLL sketch data available for cardinality aggregation " + cardinality.getName());
                byArray2 = null;
            } else {
                BytesStreamOutput output = new BytesStreamOutput();
                sketch.writeTo(0L, (StreamOutput)output);
                byArray2 = output.bytes().toBytesRef().bytes;
            }
            byArray = byArray2;
        }
        catch (Exception e) {
            this.logger.error("Failed to extract HLL++ sketch from cardinality aggregation: " + e.getMessage(), (Throwable)e);
            throw new IllegalStateException("Failed to serialize HLL++ sketch for storage", e);
        }
        return byArray;
    }

    private static final void _init_$lambda$0(RollupIndexer this$0, TimeValue millis, Integer count) {
        Intrinsics.checkNotNull((Object)count);
        this$0.retryIngestPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
    }

    private static final CharSequence convertResponseToRequests$lambda$4$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object v = it.getValue();
        return v != null && (v = v.toString()) != null ? (CharSequence)v : (CharSequence)"#ODFE-MAGIC-NULL-MAGIC-ODFE#";
    }

    public static final /* synthetic */ Client access$getClient$p(RollupIndexer $this) {
        return $this.client;
    }
}

