/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Graphics2D;
import org.freeplane.api.Dash;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.RectanglePainter;

class BubblePainter
extends RectanglePainter {
    BubblePainter(MainView mainView, NodeGeometryModel shapeConfiguration) {
        super(mainView, shapeConfiguration);
    }

    @Override
    void paintNodeShape(Graphics2D g) {
        int zoomedBorderWidth = this.mainView.getPaintedBorderWidth();
        int arcWidth = this.getArcWidth();
        g.drawRoundRect(zoomedBorderWidth / 2, zoomedBorderWidth / 2, this.mainView.getWidth() - zoomedBorderWidth, this.mainView.getHeight() - zoomedBorderWidth, arcWidth, arcWidth);
    }

    private int getArcWidth() {
        int minimumArcWidth = this.mainView.getNodeView().getMap().getZoomed(10);
        return minimumArcWidth;
    }

    @Override
    void paintBackground(Graphics2D graphics, Color color) {
        int overlapWidth;
        graphics.setColor(color);
        int borderWidth = this.mainView.getPaintedBorderWidth();
        int arcWidth = this.getArcWidth() + 1 - borderWidth;
        int n = overlapWidth = this.mainView.getDash() == Dash.SOLID ? 1 : 0;
        if (arcWidth > 0) {
            graphics.fillRoundRect(borderWidth, borderWidth, this.mainView.getWidth() - 2 * borderWidth + overlapWidth, this.mainView.getHeight() - 2 * borderWidth + overlapWidth, arcWidth, arcWidth);
        } else {
            graphics.fillRect(borderWidth, borderWidth, this.mainView.getWidth() - 2 * borderWidth + overlapWidth, this.mainView.getHeight() - 2 * borderWidth + overlapWidth);
        }
    }
}

