/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.GTheme;
import generic.theme.ThemeManager;
import generic.theme.ThemeReader;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;

public class ThemePreferences {
    private static final String THEME_PREFFERENCE_KEY = "Theme";

    public GTheme load() {
        String themeId = Preferences.getProperty((String)THEME_PREFFERENCE_KEY, (String)"Default", (boolean)true);
        if (themeId.startsWith("File:")) {
            String filename = themeId.substring("File:".length());
            try {
                return new ThemeReader(new File(filename)).readTheme();
            }
            catch (IOException e) {
                Msg.showError(GTheme.class, null, (String)"Can't Load Previous Theme", (Object)("Error loading theme file: " + filename), (Throwable)e);
            }
        } else if (themeId.startsWith("Class:")) {
            String className = themeId.substring("Class:".length());
            try {
                Class<?> forName = Class.forName(className);
                return (GTheme)forName.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Msg.showError(GTheme.class, null, (String)"Can't Load Previous Theme", (Object)("Can't find or instantiate class: " + className), (Throwable)e);
            }
        }
        return ThemeManager.getDefaultTheme();
    }

    public void save(GTheme theme) {
        Preferences.setProperty((String)THEME_PREFFERENCE_KEY, (String)theme.getThemeLocater());
        Preferences.store();
    }
}

