/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.gradle.api.Named;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AbstractAttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeEntry;
import org.gradle.api.internal.attributes.AttributeValueIsolator;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.UsageCompatibilityHandler;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.internal.provider.DelegatingProviderWithValue;
import org.gradle.api.internal.provider.MappingProvider;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.isolation.Isolatable;
import org.jspecify.annotations.Nullable;

public final class DefaultMutableAttributeContainer
extends AbstractAttributeContainer {
    private final AttributesFactory attributesFactory;
    private final AttributeValueIsolator attributeValueIsolator;
    private final NamedObjectInstantiator namedObjectInstantiator;
    private final MapProperty<Attribute<?>, AttributeEntry<?>> state;
    private boolean realizingLazyState;

    public DefaultMutableAttributeContainer(AttributesFactory attributesFactory, AttributeValueIsolator attributeValueIsolator, NamedObjectInstantiator namedObjectInstantiator, PropertyFactory propertyFactory) {
        this.attributesFactory = attributesFactory;
        this.attributeValueIsolator = attributeValueIsolator;
        this.namedObjectInstantiator = namedObjectInstantiator;
        this.state = (MapProperty)Cast.uncheckedNonnullCast((Object)propertyFactory.mapProperty(Attribute.class, AttributeEntry.class));
    }

    public String toString() {
        return this.asImmutable().toString();
    }

    public Set<Attribute<?>> keySet() {
        Set realizedKeys = this.doRealize(s -> (Set)s.keySet().get());
        DefaultMutableAttributeContainer.assertNoDuplicateNames(realizedKeys);
        return realizedKeys;
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        this.checkInsertionAllowed(key);
        this.assertAttributeValueIsNotNull(value);
        this.assertAttributeTypeIsValid(value.getClass(), key);
        DefaultMutableAttributeContainer.maybeWarnOnLegacyUsageValue(key, value);
        this.state.put(key, new AttributeEntry<T>(key, this.attributeValueIsolator.isolate(value)));
        return this;
    }

    public <T> AttributeContainer attributeProvider(Attribute<T> key, Provider<? extends T> provider) {
        MappingProvider isolated;
        this.checkInsertionAllowed(key);
        this.assertAttributeValueIsNotNull(provider);
        DelegatingProviderWithValue presentProvider = new DelegatingProviderWithValue((ProviderInternal)provider, "Providers passed to attributeProvider(Attribute, Provider) must always be present when queried.");
        Class valueType = presentProvider.getType();
        Class typedAttributeEntry = (Class)Cast.uncheckedCast(AttributeEntry.class);
        if (valueType != null) {
            this.assertAttributeTypeIsValid(valueType, key);
            isolated = new MappingProvider(typedAttributeEntry, (ProviderInternal)presentProvider, value -> {
                DefaultMutableAttributeContainer.maybeWarnOnLegacyUsageValue(key, value);
                Isolatable<Object> isolate = this.attributeValueIsolator.isolate(value);
                return new AttributeEntry<Object>(key, isolate);
            });
        } else {
            isolated = new MappingProvider(typedAttributeEntry, (ProviderInternal)presentProvider, value -> {
                this.assertAttributeTypeIsValid(value.getClass(), key);
                DefaultMutableAttributeContainer.maybeWarnOnLegacyUsageValue(key, value);
                Isolatable<Object> isolate = this.attributeValueIsolator.isolate(value);
                return new AttributeEntry<Object>(key, isolate);
            });
        }
        this.state.put(key, (Provider)isolated);
        return this;
    }

    public AttributeContainer addAllLater(AttributeContainer other) {
        this.state.putAll(((AttributeContainerInternal)other).getEntriesProvider());
        return this;
    }

    private <T> void checkInsertionAllowed(Attribute<T> key) {
        if (this.realizingLazyState) {
            throw new IllegalStateException("Cannot add new attribute '" + key.getName() + "' while realizing all attributes of the container.");
        }
    }

    private static void assertNoDuplicateNames(Set<Attribute<?>> attributes) {
        HashMap attributesByName = new HashMap();
        for (Attribute<?> attribute : attributes) {
            String name = attribute.getName();
            Attribute<?> existing = attributesByName.put(name, attribute);
            if (existing == null) continue;
            throw new IllegalStateException("Cannot have two attributes with the same name but different types. This container has an attribute named '" + name + "' of type '" + existing.getType().getName() + "' and another attribute of type '" + attribute.getType().getName() + "'");
        }
    }

    private <T> T doRealize(Function<MapProperty<Attribute<?>, AttributeEntry<?>>, T> realizeAction) {
        this.realizingLazyState = true;
        try {
            T t = realizeAction.apply(this.state);
            return t;
        }
        finally {
            this.realizingLazyState = false;
        }
    }

    private <T> void assertAttributeTypeIsValid(Class<?> valueType, Attribute<T> attribute) {
        if (!attribute.getType().isAssignableFrom(valueType)) {
            throw new IllegalArgumentException(String.format("Unexpected type for attribute '%s' provided. Expected a value of type %s but found a value of type %s.", attribute.getName(), attribute.getType().getName(), valueType.getName()));
        }
    }

    private void assertAttributeValueIsNotNull(@Nullable Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Setting null as an attribute value is not allowed");
        }
    }

    private static <T> void maybeWarnOnLegacyUsageValue(Attribute<T> key, T value) {
        String name;
        String replacementUsage;
        if (key.equals((Object)Usage.USAGE_ATTRIBUTE)) {
            String name2 = ((Usage)value).getName();
            String replacementUsage2 = UsageCompatibilityHandler.getReplacementUsage(name2);
            if (replacementUsage2 != null) {
                DefaultMutableAttributeContainer.warnOnLegacyUsageValue(name2, replacementUsage2);
            }
        } else if (key.getName().equals(Usage.USAGE_ATTRIBUTE.getName()) && (replacementUsage = UsageCompatibilityHandler.getReplacementUsage(name = value.toString())) != null) {
            DefaultMutableAttributeContainer.warnOnLegacyUsageValue(name, replacementUsage);
        }
    }

    private static void warnOnLegacyUsageValue(String legacyUsageValue, String replacementUsage) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)"Declaring a Usage attribute with a legacy value").withContext("A Usage attribute was declared with value '" + legacyUsageValue + "'.")).withAdvice("Declare a Usage attribute with value '" + replacementUsage + "' and a LibraryElements attribute with value '" + UsageCompatibilityHandler.getLibraryElements(legacyUsageValue) + "' instead.")).willBecomeAnErrorInGradle10().withUpgradeGuideSection(9, "deprecate_legacy_usage_values")).nagUser();
    }

    public <T> @Nullable T getAttribute(Attribute<T> key) {
        if (!this.isValidAttributeRequest(key)) {
            return null;
        }
        return (T)Cast.uncheckedCast((Object)this.state.getting(key).map(entry -> entry.getValue().isolate()).getOrNull());
    }

    @Override
    public Provider<Map<Attribute<?>, AttributeEntry<?>>> getEntriesProvider() {
        return this.state;
    }

    @Override
    public ImmutableAttributes asImmutable() {
        Map realizedState = this.doRealize(Provider::get);
        DefaultMutableAttributeContainer.assertNoDuplicateNames(realizedState.keySet());
        ImmutableAttributes result = ImmutableAttributes.EMPTY;
        for (AttributeEntry entry : realizedState.values()) {
            result = this.concatEntry(result, entry);
        }
        return result;
    }

    private <T> ImmutableAttributes concatEntry(ImmutableAttributes attributes, AttributeEntry<T> entry) {
        Attribute<T> key = entry.getKey();
        if (key.equals((Object)Usage.USAGE_ATTRIBUTE) || key.getName().equals(Usage.USAGE_ATTRIBUTE.getName())) {
            return this.attributesFactory.concatUsageAttribute(attributes, key, entry.getValue());
        }
        return this.attributesFactory.concat(attributes, key, entry.getValue());
    }

    public <T extends Named> T named(Class<T> type, String name) {
        return (T)this.namedObjectInstantiator.named(type, name);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMutableAttributeContainer that = (DefaultMutableAttributeContainer)o;
        return Objects.equals(this.asImmutable(), that.asImmutable());
    }

    @Override
    public int hashCode() {
        return this.asImmutable().hashCode();
    }
}

