/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.ShutdownContext;
import java.io.Closeable;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class StartupContext
implements Closeable {
    public static final String RAW_COMMAND_LINE_ARGS = StartupContext.class.getName() + ".raw-command-line-args";
    private static final Logger LOG = Logger.getLogger(StartupContext.class);
    private final Map<String, Object> values = new HashMap<String, Object>();
    private final Deque<Runnable> shutdownTasks = new ConcurrentLinkedDeque<Runnable>();
    private final Deque<Runnable> lastShutdownTasks = new ConcurrentLinkedDeque<Runnable>();
    private String[] commandLineArgs;
    private String currentBuildStepName;

    public StartupContext() {
        ShutdownContext shutdownContext = new ShutdownContext(){

            @Override
            public void addShutdownTask(Runnable runnable) {
                if (runnable == null) {
                    throw new IllegalArgumentException("Extension passed an invalid shutdown handler");
                }
                StartupContext.this.shutdownTasks.addFirst(runnable);
            }

            @Override
            public void addLastShutdownTask(Runnable runnable) {
                if (runnable == null) {
                    throw new IllegalArgumentException("Extension passed an invalid last shutdown handler");
                }
                StartupContext.this.lastShutdownTasks.addFirst(runnable);
            }
        };
        this.values.put(ShutdownContext.class.getName(), shutdownContext);
        this.values.put(RAW_COMMAND_LINE_ARGS, new Supplier<String[]>(){

            @Override
            public String[] get() {
                if (StartupContext.this.commandLineArgs == null) {
                    throw new RuntimeException("Command line arguments not available during static init");
                }
                return StartupContext.this.commandLineArgs;
            }
        });
    }

    public void putValue(String name, Object value) {
        this.values.put(name, value);
    }

    public Object getValue(String name) {
        return this.values.get(name);
    }

    @Override
    public void close() {
        this.runAllAndClear(this.shutdownTasks);
        this.runAllAndClear(this.lastShutdownTasks);
        this.values.clear();
    }

    private void runAllAndClear(Deque<Runnable> tasks) {
        while (!tasks.isEmpty()) {
            try {
                Runnable runnable = tasks.remove();
                runnable.run();
            }
            catch (Throwable ex) {
                LOG.error((Object)"Running a shutdown task failed", ex);
            }
        }
    }

    public void setCommandLineArguments(String[] commandLineArguments) {
        this.commandLineArgs = commandLineArguments;
    }

    public String getCurrentBuildStepName() {
        return this.currentBuildStepName;
    }

    public void setCurrentBuildStepName(String currentBuildStepName) {
        this.currentBuildStepName = currentBuildStepName;
    }
}

