/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.PropertiesConfigSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public class ConfigArgsConfigSource
extends PropertiesConfigSource {
    public static final String SPI_OPTION_PREFIX = "--spi";
    public static final Set<String> SHORT_OPTIONS_ACCEPTING_VALUE = Set.of("-pf", "-cf");
    private static final String CLI_ARGS = "kc.config.args";
    public static final String NAME = "CliConfigSource";
    private static final Pattern ARG_KEY_VALUE_SPLIT = Pattern.compile("=");
    private static Set<String> duplicatedArgNames;

    protected ConfigArgsConfigSource() {
        super(ConfigArgsConfigSource.parseArguments(), NAME, 600);
    }

    public static void setCliArgs(String ... args) {
        System.setProperty(CLI_ARGS, Stream.of(args).map(arg -> arg.replaceAll(",", ",,")).collect(Collectors.joining(", ")));
    }

    public static List<String> getAllCliArgs() {
        String args = System.getProperty(CLI_ARGS);
        if (args == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean escaped = false;
        StringBuilder arg = new StringBuilder();
        for (int i = 0; i < args.length(); ++i) {
            char c = args.charAt(i);
            if (c == ',') {
                if (escaped) {
                    arg.append(c);
                }
                escaped = !escaped;
                continue;
            }
            if (c == ' ') {
                if (escaped) {
                    result.add(arg.toString());
                    arg.setLength(0);
                    escaped = false;
                    continue;
                }
                arg.append(c);
                continue;
            }
            arg.append(c);
        }
        result.add(arg.toString());
        return result;
    }

    private static Map<String, String> parseArguments() {
        HashMap<String, String> properties = new HashMap<String, String>();
        HashSet allPropertiesNames = new HashSet();
        duplicatedArgNames = new HashSet<String>();
        ConfigArgsConfigSource.parseConfigArgs(ConfigArgsConfigSource.getAllCliArgs(), (key, value) -> {
            if (!allPropertiesNames.add(key)) {
                duplicatedArgNames.add((String)key);
            }
            PropertyMappers.getKcKeyFromCliKey(key).ifPresent(s -> properties.put((String)s, (String)value));
        }, ignored -> {});
        return properties;
    }

    public static Set<String> getDuplicatedArgNames() {
        return Collections.unmodifiableSet(duplicatedArgNames);
    }

    public static void clearDuplicatedArgNames() {
        duplicatedArgNames = Collections.emptySet();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void parseConfigArgs(List<String> args, BiConsumer<String, String> valueArgConsumer, Consumer<String> unaryConsumer) {
        int i = 0;
        while (true) {
            block3: {
                String value;
                String key;
                block7: {
                    String[] keyValue;
                    block4: {
                        String arg;
                        block6: {
                            block5: {
                                block2: {
                                    if (i >= args.size()) {
                                        return;
                                    }
                                    arg = args.get(i);
                                    if (arg.startsWith("-")) break block2;
                                    unaryConsumer.accept(arg);
                                    break block3;
                                }
                                keyValue = ARG_KEY_VALUE_SPLIT.split(arg, 2);
                                key = keyValue[0];
                                if (keyValue.length != 1) break block4;
                                if (args.size() > i + 1) break block5;
                                unaryConsumer.accept(arg);
                                break block3;
                            }
                            PropertyMapper<?> mapper = PropertyMappers.getMapperByCliKey(key);
                            if (mapper == null && !SHORT_OPTIONS_ACCEPTING_VALUE.contains(key) && !arg.startsWith(SPI_OPTION_PREFIX)) break block6;
                            value = args.get(++i);
                            break block7;
                        }
                        unaryConsumer.accept(arg);
                        break block3;
                    }
                    value = keyValue[1];
                }
                valueArgConsumer.accept(key, value);
            }
            ++i;
        }
    }
}

