/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.services.resources;

import io.quarkus.resteasy.reactive.server.EndpointDisabled;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.HostnameV2PropertyMappers;
import org.keycloak.quarkus.runtime.services.resources.ConstantsDebugHostname;
import org.keycloak.services.Urls;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.Theme;
import org.keycloak.theme.freemarker.FreeMarkerProvider;
import org.keycloak.urls.UrlType;
import org.keycloak.utils.SecureContextResolver;

@Provider
@Path(value="/realms")
@EndpointDisabled(name="kc.hostname-debug", stringValue="false", disableIfMissing=true)
public class DebugHostnameSettingsResource {
    public static final String DEFAULT_PATH_SUFFIX = "hostname-debug";
    public static final String PATH_FOR_TEST_CORS_IN_HEADERS = "test";
    @Context
    private KeycloakSession keycloakSession;
    private final Map<String, String> allConfigPropertiesMap = new LinkedHashMap<String, String>();

    public DebugHostnameSettingsResource() {
        String[] relevantOptions;
        for (String key : relevantOptions = ConstantsDebugHostname.RELEVANT_OPTIONS_V2) {
            this.addOption(key);
        }
    }

    @GET
    @Path(value="/{realmName}/hostname-debug")
    @Produces(value={"text/html"})
    public String debug(@PathParam(value="realmName") String realmName) throws IOException, FreeMarkerException {
        RealmModel realmModel = this.keycloakSession.realms().getRealmByName(realmName);
        if (realmModel == null) {
            throw new NotFoundException();
        }
        FreeMarkerProvider freeMarkerProvider = (FreeMarkerProvider)this.keycloakSession.getProvider(FreeMarkerProvider.class);
        ArrayList configWarnings = new ArrayList();
        HostnameV2PropertyMappers.validateConfig(configWarnings::add);
        URI frontendUri = this.keycloakSession.getContext().getUri(UrlType.FRONTEND).getBaseUri();
        URI backendUri = this.keycloakSession.getContext().getUri(UrlType.BACKEND).getBaseUri();
        URI adminUri = this.keycloakSession.getContext().getUri(UrlType.ADMIN).getBaseUri();
        String frontendTestUrl = this.getTest(realmModel, frontendUri, true);
        String backendTestUrl = this.getTest(realmModel, backendUri, false);
        String adminTestUrl = this.getTest(realmModel, adminUri, false);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("configWarnings", configWarnings);
        attributes.put("frontendUrl", frontendUri.toString());
        attributes.put("backendUrl", backendUri.toString());
        attributes.put("adminUrl", adminUri.toString());
        attributes.put("realm", realmModel.getName());
        attributes.put("realmUrl", realmModel.getAttribute("frontendUrl"));
        attributes.put("implVersion", "V2");
        attributes.put("frontendTestUrl", frontendTestUrl);
        attributes.put("backendTestUrl", backendTestUrl);
        attributes.put("adminTestUrl", adminTestUrl);
        attributes.put("serverMode", Environment.isDevMode() ? "dev [start-dev]" : "production [start]");
        attributes.put("config", this.allConfigPropertiesMap);
        attributes.put("headers", this.getHeaders());
        return freeMarkerProvider.processTemplate(attributes, "debug-hostname-settings.ftl", this.keycloakSession.theme().getTheme("base", Theme.Type.LOGIN));
    }

    @GET
    @Path(value="/{realmName}/hostname-debug/test")
    @Produces(value={"text/plain"})
    public Response test(@PathParam(value="realmName") String realmName, @DefaultValue(value="false") @QueryParam(value="frontEnd") boolean frontEnd) {
        Object text = "OK";
        String corsOrigin = this.keycloakSession.getContext().getRequestHeaders().getHeaderString("Origin");
        URI requestUri = this.keycloakSession.getContext().getUri().getRequestUri();
        String requestOrigin = UriUtils.getOrigin((URI)requestUri);
        URI frontendUri = this.keycloakSession.getContext().getUri(UrlType.FRONTEND).getBaseUri();
        if (frontEnd) {
            boolean https;
            boolean originMatches = requestOrigin.equals(UriUtils.getOrigin((URI)frontendUri));
            HttpHeaders requestHeaders = this.keycloakSession.getContext().getRequestHeaders();
            boolean fowarded = requestHeaders.getHeaderString("Forwarded") != null;
            boolean xfowarded = Stream.of(ConstantsDebugHostname.X_FORWARDED_PROXY_HEADERS).map(arg_0 -> ((HttpHeaders)requestHeaders).getHeaderString(arg_0)).anyMatch(Objects::nonNull);
            if (!originMatches) {
                text = "Default origin check failing, request hostname does not match frontend hostname. Please check you proxy settings.";
                if (!this.keycloakSession.getContext().getHttpRequest().isProxyTrusted()) {
                    text = (String)text + " Note the proxy is not trusted.";
                }
                if (!fowarded && !xfowarded) {
                    text = (String)text + " No proxy headers are set on the request.";
                }
            }
            if (!(https = requestUri.getScheme().equals("https")) && !SecureContextResolver.isSecureContext((KeycloakSession)this.keycloakSession)) {
                text = (String)text + " Non-secure context detected - Keycloak will not function properly when accessed over http at a non-localhost host.";
            }
        }
        Response.ResponseBuilder builder = Response.ok((Object)text);
        builder.header("Access-Control-Allow-Origin", (Object)corsOrigin);
        builder.header("Access-Control-Allow-Methods", (Object)"GET");
        return builder.build();
    }

    private void addOption(String key) {
        Configuration.getOptionalKcValue(key).ifPresent(value -> this.allConfigPropertiesMap.put(key, (String)value));
    }

    private Map<String, String> getHeaders() {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        HttpHeaders requestHeaders = this.keycloakSession.getContext().getRequestHeaders();
        for (String h : ConstantsDebugHostname.RELEVANT_HEADERS) {
            this.addProxyHeader(h, headers, requestHeaders);
        }
        return headers;
    }

    private void addProxyHeader(String header, Map<String, String> proxyHeaders, HttpHeaders requestHeaders) {
        String value = requestHeaders.getHeaderString(header);
        if (value != null && !value.isEmpty()) {
            proxyHeaders.put(header, value);
        }
    }

    private String getTest(RealmModel realmModel, URI baseUri, boolean frontEnd) {
        return Urls.realmBase((URI)baseUri).path("/{realmName}/{debugHostnameSettingsPath}/{pathForTestCORSInHeaders}").queryParam("frontEnd", new Object[]{frontEnd}).build(new Object[]{realmModel.getName(), DEFAULT_PATH_SUFFIX, PATH_FOR_TEST_CORS_IN_HEADERS}).toString();
    }
}

