/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.atom;

import java.awt.Color;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSimple;
import net.sourceforge.plantuml.klimt.creole.atom.AbstractAtom;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.debug.StringBounderDebug;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.math.ScientificEquationSafe;

public class AtomMath
extends AbstractAtom
implements Atom {
    private final ScientificEquationSafe math;
    private final HColor foreground;
    private final HColor background;
    private XDimension2D dim;

    public AtomMath(ScientificEquationSafe math, HColor foreground, HColor background) {
        this.math = math;
        this.foreground = foreground;
        this.background = background;
    }

    private XDimension2D calculateDimensionSlow(StringBounder stringBounder) {
        if (stringBounder.matchesProperty("TIKZ")) {
            return stringBounder.calculateDimension(null, this.math.getSource());
        }
        BufferedImage image = this.math.getImage(Color.BLACK, Color.WHITE).withScale(1.0).getImage();
        return new XDimension2D(image.getWidth(), image.getHeight());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        if (stringBounder instanceof StringBounderDebug) {
            return this.calculateDimensionSlow(stringBounder);
        }
        if (this.dim == null) {
            this.dim = this.calculateDimensionSlow(stringBounder);
        }
        return this.dim;
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        ColorMapper colorMapper = ug.getColorMapper();
        boolean isSvg = ug.matchesProperty("SVG");
        Color back = this.background == null ? null : this.getColor(colorMapper, this.background, Color.WHITE);
        Color fore = this.getColor(colorMapper, this.foreground, Color.BLACK);
        if (isSvg) {
            UImageSvg svg = this.math.getSvg(1.0, fore, back);
            ug.draw(svg);
        } else {
            UImage image = new UImage(this.math.getImage(fore, back)).withFormula(this.math.getSource());
            ug.draw(image);
        }
    }

    private Color getColor(ColorMapper colorMapper, HColor color, Color defaultValue) {
        if (color instanceof HColorSimple) {
            return color.toColor(colorMapper);
        }
        return defaultValue;
    }
}

