
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was sonivox-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../../usr" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################
include(CMakeFindDependencyMacro)
set(SONIVOX_WANTS_ZLIB TRUE)

if (UNIX AND NOT APPLE AND NOT EMSCRIPTEN)
    find_library(HAVE_LIBM NAMES "m" NO_CACHE)
endif()

if (SONIVOX_WANTS_ZLIB)
    find_dependency(ZLIB)
endif()

set(sonivox_known_comps static shared)
set(sonivox_comp_static NO)
set(sonivox_comp_shared NO)
foreach (sonivox_comp IN LISTS ${CMAKE_FIND_PACKAGE_NAME}_FIND_COMPONENTS)
    if (sonivox_comp IN_LIST sonivox_known_comps)
        set(sonivox_comp_${sonivox_comp} YES)
    else ()
        set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
            "sonivox does not recognize component `${sonivox_comp}`.")
        set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
        return()
    endif ()
endforeach ()

if (sonivox_comp_static AND sonivox_comp_shared)
    set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
        "sonivox `static` and `shared` components are mutually exclusive.")
    set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
    return()
endif ()

set(sonivox_static_targets "${CMAKE_CURRENT_LIST_DIR}/sonivox-static-targets.cmake")
set(sonivox_shared_targets "${CMAKE_CURRENT_LIST_DIR}/sonivox-shared-targets.cmake")

macro(sonivox_load_targets type)
    if (NOT EXISTS "${sonivox_${type}_targets}")
        set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
            "sonivox `${type}` libraries were requested but not found.")
        set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
        return()
    endif ()
    include("${sonivox_${type}_targets}")
endmacro()

if (sonivox_comp_static)
    sonivox_load_targets(static)
elseif (sonivox_comp_shared)
    sonivox_load_targets(shared)
elseif (DEFINED sonivox_SHARED_LIBS AND sonivox_SHARED_LIBS)
    sonivox_load_targets(shared)
elseif (DEFINED sonivox_SHARED_LIBS AND NOT sonivox_SHARED_LIBS)
    sonivox_load_targets(static)
elseif (BUILD_SHARED_LIBS)
    if (EXISTS "${sonivox_shared_targets}")
        sonivox_load_targets(shared)
    else ()
        sonivox_load_targets(static)
    endif ()
else ()
    if (EXISTS "${sonivox_static_targets}")
        sonivox_load_targets(static)
    else ()
        sonivox_load_targets(shared)
    endif ()
endif ()
