/* Ctt.c generated by valac 0.10.4, the Vala compiler
 * generated from Ctt.vala, do not modify */

/* -*- mode: vala; c-basic-offset: 2; tab-width: 8; -*-
 * AllTrayCtt.vala - CTT support for AllTray
 * Copyright (c) 2009 Michael B. Trausch <mike@trausch.us>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define ALL_TRAY_TYPE_CTT (all_tray_ctt_get_type ())
#define ALL_TRAY_CTT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_TYPE_CTT, AllTrayCtt))
#define ALL_TRAY_CTT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_TYPE_CTT, AllTrayCttClass))
#define ALL_TRAY_IS_CTT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_TYPE_CTT))
#define ALL_TRAY_IS_CTT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_TYPE_CTT))
#define ALL_TRAY_CTT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_TYPE_CTT, AllTrayCttClass))

typedef struct _AllTrayCtt AllTrayCtt;
typedef struct _AllTrayCttClass AllTrayCttClass;
typedef struct _AllTrayCttPrivate AllTrayCttPrivate;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

#define ALL_TRAY_DEBUG_TYPE_SUBSYSTEM (all_tray_debug_subsystem_get_type ())

#define ALL_TRAY_DEBUG_TYPE_LEVEL (all_tray_debug_level_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AllTrayParamSpecCtt AllTrayParamSpecCtt;

typedef enum  {
	ALL_TRAY_ALL_TRAY_CTT_ERROR_SPAWN_HELPER_FAILED,
	ALL_TRAY_ALL_TRAY_CTT_ERROR_CTT_ATTACH_FAILED,
	ALL_TRAY_ALL_TRAY_CTT_ERROR_CTT_DETACH_FAILED,
	ALL_TRAY_ALL_TRAY_CTT_ERROR_STATUS_FAILED,
	ALL_TRAY_ALL_TRAY_CTT_ERROR_FAILED
} AllTrayAllTrayCttError;
#define ALL_TRAY_ALL_TRAY_CTT_ERROR all_tray_all_tray_ctt_error_quark ()
struct _AllTrayCtt {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AllTrayCttPrivate * priv;
};

struct _AllTrayCttClass {
	GTypeClass parent_class;
	void (*finalize) (AllTrayCtt *self);
};

struct _AllTrayCttPrivate {
	GPid _child_pid;
	gint _child_stdin_fd;
	gint _child_stdout_fd;
	FILE* _child_stdin;
	GIOChannel* _child_stdout_channel;
};

typedef enum  {
	ALL_TRAY_DEBUG_SUBSYSTEM_None = 0x00,
	ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine = 0x01,
	ALL_TRAY_DEBUG_SUBSYSTEM_Display = 0x02,
	ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon = 0x04,
	ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager = 0x08,
	ALL_TRAY_DEBUG_SUBSYSTEM_Process = 0x10,
	ALL_TRAY_DEBUG_SUBSYSTEM_Misc = 0x20,
	ALL_TRAY_DEBUG_SUBSYSTEM_Bug = 0x40,
	ALL_TRAY_DEBUG_SUBSYSTEM_Application = 0x80,
	ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper = 0x100,
	ALL_TRAY_DEBUG_SUBSYSTEM_Signal = 0x200,
	ALL_TRAY_DEBUG_SUBSYSTEM_Main = 0x400,
	ALL_TRAY_DEBUG_SUBSYSTEM_Ctt = 0x800,
	ALL_TRAY_DEBUG_SUBSYSTEM_All = ((((((((((ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine | ALL_TRAY_DEBUG_SUBSYSTEM_Display) | ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon) | ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager) | ALL_TRAY_DEBUG_SUBSYSTEM_Process) | ALL_TRAY_DEBUG_SUBSYSTEM_Misc) | ALL_TRAY_DEBUG_SUBSYSTEM_Bug) | ALL_TRAY_DEBUG_SUBSYSTEM_Application) | ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper) | ALL_TRAY_DEBUG_SUBSYSTEM_Signal) | ALL_TRAY_DEBUG_SUBSYSTEM_Main) | ALL_TRAY_DEBUG_SUBSYSTEM_Ctt
} AllTrayDebugSubsystem;

typedef enum  {
	ALL_TRAY_DEBUG_LEVEL_Information,
	ALL_TRAY_DEBUG_LEVEL_Warning,
	ALL_TRAY_DEBUG_LEVEL_Error,
	ALL_TRAY_DEBUG_LEVEL_Fatal
} AllTrayDebugLevel;

struct _AllTrayParamSpecCtt {
	GParamSpec parent_instance;
};


extern gboolean all_tray_program__ctt_enabled;
static gpointer all_tray_ctt_parent_class = NULL;

GQuark all_tray_all_tray_ctt_error_quark (void);
gpointer all_tray_ctt_ref (gpointer instance);
void all_tray_ctt_unref (gpointer instance);
GParamSpec* all_tray_param_spec_ctt (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void all_tray_value_set_ctt (GValue* value, gpointer v_object);
void all_tray_value_take_ctt (GValue* value, gpointer v_object);
gpointer all_tray_value_get_ctt (const GValue* value);
GType all_tray_ctt_get_type (void) G_GNUC_CONST;
#define ALL_TRAY_CTT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ALL_TRAY_TYPE_CTT, AllTrayCttPrivate))
enum  {
	ALL_TRAY_CTT_DUMMY_PROPERTY
};
AllTrayCtt* all_tray_ctt_new (void);
AllTrayCtt* all_tray_ctt_construct (GType object_type);
GType all_tray_debug_subsystem_get_type (void) G_GNUC_CONST;
GType all_tray_debug_level_get_type (void) G_GNUC_CONST;
void all_tray_debug_notification_emit (AllTrayDebugSubsystem subsys, AllTrayDebugLevel lvl, const char* msg);
static gboolean _all_tray_ctt_read_from_helper (AllTrayCtt* self, GIOChannel* ch, GIOCondition cond);
static gboolean __all_tray_ctt_read_from_helper_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void _all_tray_ctt_helper_died (AllTrayCtt* self, GPid p, gint return_status);
static void __all_tray_ctt_helper_died_gchild_watch_func (GPid pid, gint status, gpointer self);
void all_tray_ctt_attach (AllTrayCtt* self, gulong window_id);
void all_tray_ctt_detach (AllTrayCtt* self, gulong window_id);
static void all_tray_ctt_finalize (AllTrayCtt* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark all_tray_all_tray_ctt_error_quark (void) {
	return g_quark_from_static_string ("all_tray_all_tray_ctt_error-quark");
}


static gboolean __all_tray_ctt_read_from_helper_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = _all_tray_ctt_read_from_helper (self, source, condition);
	return result;
}


static void __all_tray_ctt_helper_died_gchild_watch_func (GPid pid, gint status, gpointer self) {
	_all_tray_ctt_helper_died (self, pid, status);
}


AllTrayCtt* all_tray_ctt_construct (GType object_type) {
	AllTrayCtt* self = (AllTrayCtt*) g_type_create_instance (object_type);
	GSpawnFlags child_flags;
	char* _tmp4_;
	GIOChannel* _tmp5_;
	FILE* _tmp6_;
	GError * _inner_error_ = NULL;
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, "in Ctt() constructor");
	child_flags = G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD;
	{
		char** _tmp0_ = NULL;
		char** _tmp1_;
		gint _tmp1__length1;
		all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, "spawning alltray-ctt-helper (using $PATH)");
		g_spawn_async_with_pipes (NULL, (_tmp1_ = (_tmp0_ = g_new0 (char*, 1 + 1), _tmp0_[0] = g_strdup ("alltray-ctt-helper"), _tmp0_), _tmp1__length1 = 1, _tmp1_), NULL, child_flags, NULL, NULL, &self->priv->_child_pid, &self->priv->_child_stdin_fd, &self->priv->_child_stdout_fd, NULL, &_inner_error_);
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch7_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally7;
	__catch7_g_spawn_error:
	{
		GError * se;
		se = _inner_error_;
		_inner_error_ = NULL;
		{
			{
				char** _tmp2_ = NULL;
				char** _tmp3_;
				gint _tmp3__length1;
				all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, "spawning alltray-ctt-helper (not using $PATH)");
				child_flags = G_SPAWN_DO_NOT_REAP_CHILD;
				g_spawn_async_with_pipes (NULL, (_tmp3_ = (_tmp2_ = g_new0 (char*, 1 + 1), _tmp2_[0] = g_strdup ("alltray-ctt-helper"), _tmp2_), _tmp3__length1 = 1, _tmp3_), NULL, child_flags, NULL, NULL, &self->priv->_child_pid, &self->priv->_child_stdin_fd, &self->priv->_child_stdout_fd, NULL, &_inner_error_);
				_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_SPAWN_ERROR) {
						goto __catch8_g_spawn_error;
					}
					_g_error_free0 (se);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			goto __finally8;
			__catch8_g_spawn_error:
			{
				GError * se;
				se = _inner_error_;
				_inner_error_ = NULL;
				{
					all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Error, "Failed to spawn CTT helper process, CTT disabled");
					fprintf (stderr, "CTT unavailable: failed to spawn helper process\n");
					all_tray_program__ctt_enabled = FALSE;
					_g_error_free0 (se);
				}
			}
			__finally8:
			if (_inner_error_ != NULL) {
				_g_error_free0 (se);
				_g_error_free0 (se);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_error_free0 (se);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, _tmp4_ = g_strdup_printf ("CTT subprocess pid = %d", (gint) self->priv->_child_pid));
	_g_free0 (_tmp4_);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, "opening input IOChannel from CTT helper");
	self->priv->_child_stdout_channel = (_tmp5_ = g_io_channel_unix_new (self->priv->_child_stdout_fd), _g_io_channel_unref0 (self->priv->_child_stdout_channel), _tmp5_);
	g_io_add_watch (self->priv->_child_stdout_channel, G_IO_IN | G_IO_HUP, __all_tray_ctt_read_from_helper_gio_func, self);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, "opening write pipe to CTT helper");
	self->priv->_child_stdin = (_tmp6_ = fdopen (self->priv->_child_stdin_fd, "w"), _fclose0 (self->priv->_child_stdin), _tmp6_);
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->_child_pid, __all_tray_ctt_helper_died_gchild_watch_func, all_tray_ctt_ref (self), all_tray_ctt_unref);
	return self;
}


AllTrayCtt* all_tray_ctt_new (void) {
	return all_tray_ctt_construct (ALL_TRAY_TYPE_CTT);
}


static char* string_chomp (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static gboolean _all_tray_ctt_read_from_helper (AllTrayCtt* self, GIOChannel* ch, GIOCondition cond) {
	gboolean result = FALSE;
	char* line;
	gsize line_len = 0UL;
	gsize terminator_pos = 0UL;
	GIOStatus status = 0;
	char* _tmp0_ = NULL;
	GIOStatus _tmp1_;
	char* _tmp2_;
	GIOStatus _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	gint parts_length1;
	gint _parts_size_;
	char** _tmp9_;
	char* _tmp6_;
	char** _tmp7_;
	char** _tmp8_;
	char** parts;
	char* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ch != NULL, FALSE);
	line = NULL;
	if (cond == G_IO_HUP) {
		all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Error, "helper pipe has been hung up on");
		result = FALSE;
		_g_free0 (line);
		return result;
	}
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, "reading from CTT");
	_tmp3_ = (_tmp1_ = g_io_channel_read_line (ch, &_tmp0_, &line_len, &terminator_pos, &_inner_error_), line = (_tmp2_ = _tmp0_, _g_free0 (line), _tmp2_), _tmp1_);
	if (_inner_error_ != NULL) {
		_g_free0 (line);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	status = _tmp3_;
	if (status != G_IO_STATUS_NORMAL) {
		all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Warning, "read from CTT not NORMAL IOStatus, removing");
		result = FALSE;
		_g_free0 (line);
		return result;
	}
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, _tmp5_ = g_strdup_printf ("read '%s' from CTT", _tmp4_ = string_chomp (line)));
	_g_free0 (_tmp5_);
	_g_free0 (_tmp4_);
	parts = (_tmp9_ = (_tmp8_ = _tmp7_ = g_strsplit (_tmp6_ = string_chomp (line), " ", 2), _g_free0 (_tmp6_), _tmp8_), parts_length1 = _vala_array_length (_tmp7_), _parts_size_ = parts_length1, _tmp9_);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, _tmp10_ = g_strdup_printf ("Parts: [%s] [%s]", parts[0], parts[1]));
	_g_free0 (_tmp10_);
	if (_vala_strcmp0 (parts[0], "CTT") == 0) {
		gulong XID;
		XID = strtoul (parts[1], NULL, 0);
		g_signal_emit_by_name (self, "activate", XID);
	}
	result = TRUE;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (line);
	return result;
}


void all_tray_ctt_attach (AllTrayCtt* self, gulong window_id) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, _tmp0_ = g_strdup_printf ("attach called for XID 0x%lx", window_id));
	_g_free0 (_tmp0_);
	fprintf (self->priv->_child_stdin, "ATTACH %lu\n", window_id);
	fflush (self->priv->_child_stdin);
}


void all_tray_ctt_detach (AllTrayCtt* self, gulong window_id) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, _tmp0_ = g_strdup_printf ("detach() called for XID 0x%lx", window_id));
	_g_free0 (_tmp0_);
	fprintf (self->priv->_child_stdin, "DETACH %lu\n", window_id);
	fflush (self->priv->_child_stdin);
}


static void _all_tray_ctt_helper_died (AllTrayCtt* self, GPid p, gint return_status) {
	g_return_if_fail (self != NULL);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Ctt, ALL_TRAY_DEBUG_LEVEL_Information, "helper died");
	fprintf (stderr, "Helper child %d died with status %d\n", (gint) p, return_status);
}


static void all_tray_value_ctt_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void all_tray_value_ctt_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		all_tray_ctt_unref (value->data[0].v_pointer);
	}
}


static void all_tray_value_ctt_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = all_tray_ctt_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer all_tray_value_ctt_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* all_tray_value_ctt_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AllTrayCtt* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = all_tray_ctt_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* all_tray_value_ctt_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AllTrayCtt** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = all_tray_ctt_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* all_tray_param_spec_ctt (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AllTrayParamSpecCtt* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ALL_TRAY_TYPE_CTT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer all_tray_value_get_ctt (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALL_TRAY_TYPE_CTT), NULL);
	return value->data[0].v_pointer;
}


void all_tray_value_set_ctt (GValue* value, gpointer v_object) {
	AllTrayCtt* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALL_TRAY_TYPE_CTT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALL_TRAY_TYPE_CTT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		all_tray_ctt_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		all_tray_ctt_unref (old);
	}
}


void all_tray_value_take_ctt (GValue* value, gpointer v_object) {
	AllTrayCtt* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALL_TRAY_TYPE_CTT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALL_TRAY_TYPE_CTT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		all_tray_ctt_unref (old);
	}
}


static void all_tray_ctt_class_init (AllTrayCttClass * klass) {
	all_tray_ctt_parent_class = g_type_class_peek_parent (klass);
	ALL_TRAY_CTT_CLASS (klass)->finalize = all_tray_ctt_finalize;
	g_type_class_add_private (klass, sizeof (AllTrayCttPrivate));
	g_signal_new ("activate", ALL_TRAY_TYPE_CTT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ULONG, G_TYPE_NONE, 1, G_TYPE_ULONG);
}


static void all_tray_ctt_instance_init (AllTrayCtt * self) {
	self->priv = ALL_TRAY_CTT_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void all_tray_ctt_finalize (AllTrayCtt* obj) {
	AllTrayCtt * self;
	self = ALL_TRAY_CTT (obj);
	_fclose0 (self->priv->_child_stdin);
	_g_io_channel_unref0 (self->priv->_child_stdout_channel);
}


GType all_tray_ctt_get_type (void) {
	static volatile gsize all_tray_ctt_type_id__volatile = 0;
	if (g_once_init_enter (&all_tray_ctt_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { all_tray_value_ctt_init, all_tray_value_ctt_free_value, all_tray_value_ctt_copy_value, all_tray_value_ctt_peek_pointer, "p", all_tray_value_ctt_collect_value, "p", all_tray_value_ctt_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AllTrayCttClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) all_tray_ctt_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AllTrayCtt), 0, (GInstanceInitFunc) all_tray_ctt_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType all_tray_ctt_type_id;
		all_tray_ctt_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AllTrayCtt", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&all_tray_ctt_type_id__volatile, all_tray_ctt_type_id);
	}
	return all_tray_ctt_type_id__volatile;
}


gpointer all_tray_ctt_ref (gpointer instance) {
	AllTrayCtt* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void all_tray_ctt_unref (gpointer instance) {
	AllTrayCtt* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ALL_TRAY_CTT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




