
#include <string.h>

#include "glproc.hpp"
#include "glretrace.hpp"
#include "glstate.hpp"
#include "glsize.hpp"


static GLint
_getActiveProgram(void);

static void
_validateActiveProgram(trace::Call &call);


#include "os_time.hpp"
#include "trace_parser.hpp"
#include "retrace.hpp"
#include "retrace_swizzle.hpp"

static retrace::map<GLuint> _list_map;
static retrace::map<GLuint> _texture_map;
static retrace::map<GLuint> _query_map;
static retrace::map<GLuint> _buffer_map;
static retrace::map<GLuint> _program_map;
static retrace::map<GLuint> _shader_map;
static std::map<GLhandleARB, retrace::map<GLint> > _location_map;
static retrace::map<GLuint> _fence_map;
static retrace::map<GLsync> _sync_map;
static retrace::map<GLuint> _arrayAPPLE_map;
static retrace::map<GLuint64> _textureHandle_map;
static retrace::map<GLuint> _sampler_map;
static retrace::map<GLuint64> _imageHandle_map;
static retrace::map<GLuint> _feedback_map;
static retrace::map<GLuint> _framebuffer_map;
static retrace::map<GLuint> _renderbuffer_map;
static std::map<uintptr_t, retrace::map<GLuint> > _array_map;
static retrace::map<GLuint> _pipeline_map;
static retrace::map<GLhandleARB> _handleARB_map;
static std::map<GLhandleARB, retrace::map<GLuint> > _subroutine_map;
static retrace::map<GLeglImageOES> _eglImageOES_map;
static std::map<GLuint, retrace::map<GLuint> > _uniformBlock_map;
static retrace::map<GLuint> _programARB_map;
static retrace::map<GLuint> _fragmentShaderATI_map;
static retrace::map<GLuint> _region_map;

static void retrace_glCullFace(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCullFace(mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFrontFace(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFrontFace(mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glHint(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum mode;
    mode = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glHint(target, mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLineWidth(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat width;
    width = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLineWidth(width);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPointSize(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat size;
    size = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPointSize(size);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPolygonMode(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum mode;
    mode = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPolygonMode(face, mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glScissor(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    GLsizei width;
    width = (call.arg(2)).toSInt();

    GLsizei height;
    height = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glScissor(x, y, width, height);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexParameterf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat param;
    param = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexParameterf(target, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexParameterfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat * params;
    params = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat86_0 = (call.arg(2)).toArray();
    if (_a_GLfloat86_0) {
        for (size_t _jGLfloat86 = 0; _jGLfloat86 < _a_GLfloat86_0->values.size(); ++_jGLfloat86) {
    params[_jGLfloat86] = (*_a_GLfloat86_0->values[_jGLfloat86]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexParameterfv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexParameteri(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint param;
    param = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexParameteri(target, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexParameteriv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint * params;
    params = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint129_0 = (call.arg(2)).toArray();
    if (_a_GLint129_0) {
        for (size_t _jGLint129 = 0; _jGLint129 < _a_GLint129_0->values.size(); ++_jGLint129) {
    params[_jGLint129] = (*_a_GLint129_0->values[_jGLint129]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexParameteriv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexImage1D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint internalformat;
    internalformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei width;
    width = (call.arg(3)).toSInt();

    GLint border;
    border = (call.arg(4)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(5)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(6)).toSInt());

    GLvoid * pixels;
    pixels = static_cast<GLvoid *>((call.arg(7)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexImage1D(target, level, internalformat, width, border, format, type, pixels);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexImage2D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint internalformat;
    internalformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei width;
    width = (call.arg(3)).toSInt();

    GLsizei height;
    height = (call.arg(4)).toSInt();

    GLint border;
    border = (call.arg(5)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(6)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(7)).toSInt());

    GLvoid * pixels;
    pixels = static_cast<GLvoid *>((call.arg(8)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDrawBuffer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDrawBuffer(mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClear(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbitfield mask;
    mask = static_cast<GLbitfield>((call.arg(0)).toUInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glClear(mask);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glClearColor(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat red;
    red = (call.arg(0)).toFloat();

    GLfloat green;
    green = (call.arg(1)).toFloat();

    GLfloat blue;
    blue = (call.arg(2)).toFloat();

    GLfloat alpha;
    alpha = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearColor(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearStencil(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint s;
    s = (call.arg(0)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearStencil(s);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearDepth(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble depth;
    depth = (call.arg(0)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearDepth(depth);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glStencilMask(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint mask;
    mask = (call.arg(0)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glStencilMask(mask);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColorMask(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLboolean red;
    red = static_cast<GLboolean>((call.arg(0)).toSInt());

    GLboolean green;
    green = static_cast<GLboolean>((call.arg(1)).toSInt());

    GLboolean blue;
    blue = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLboolean alpha;
    alpha = static_cast<GLboolean>((call.arg(3)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColorMask(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDepthMask(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLboolean flag;
    flag = static_cast<GLboolean>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDepthMask(flag);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDisable(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum cap;
    cap = static_cast<GLenum>((call.arg(0)).toSInt());

    if (cap == GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB) return;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDisable(cap);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEnable(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum cap;
    cap = static_cast<GLenum>((call.arg(0)).toSInt());

    if (cap == GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB) return;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEnable(cap);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFinish(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFinish();
    if (currentContext) {
        currentContext->needsFlush = false;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    if (!retrace::doubleBuffer) {
        glretrace::frame_complete(call);
    }
}

static void retrace_glFlush(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFlush();
    if (currentContext) {
        currentContext->needsFlush = false;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    if (!retrace::doubleBuffer) {
        glretrace::frame_complete(call);
    }
}

static void retrace_glBlendFunc(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum sfactor;
    sfactor = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum dfactor;
    dfactor = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendFunc(sfactor, dfactor);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLogicOp(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum opcode;
    opcode = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLogicOp(opcode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glStencilFunc(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum func;
    func = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint ref;
    ref = (call.arg(1)).toSInt();

    GLuint mask;
    mask = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glStencilFunc(func, ref, mask);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glStencilOp(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum fail;
    fail = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum zfail;
    zfail = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum zpass;
    zpass = static_cast<GLenum>((call.arg(2)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glStencilOp(fail, zfail, zpass);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDepthFunc(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum func;
    func = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDepthFunc(func);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPixelStoref(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat param;
    param = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPixelStoref(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPixelStorei(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint param;
    param = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPixelStorei(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glReadBuffer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glReadBuffer(mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glReadPixels(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    GLsizei width;
    width = (call.arg(2)).toSInt();

    GLsizei height;
    height = (call.arg(3)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(4)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(5)).toSInt());

    GLvoid * pixels;
    pixels = static_cast<GLvoid *>((call.arg(6)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
     GLsizei _w = call.arg(2).toSInt();
     GLsizei _h = call.arg(3).toSInt();
     buffer.resize(_w * _h * 64);
    }
    pixels = buffer.data();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glReadPixels(x, y, width, height, format, type, pixels);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetTexImage(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(3)).toSInt());

    GLvoid * pixels;
    pixels = static_cast<GLvoid *>((call.arg(4)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
        return;
    }
    pixels = buffer.data();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetTexImage(target, level, format, type, pixels);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDepthRange(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble zNear;
    zNear = (call.arg(0)).toDouble();

    GLdouble zFar;
    zFar = (call.arg(1)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDepthRange(zNear, zFar);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glViewport(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    GLsizei width;
    width = (call.arg(2)).toSInt();

    GLsizei height;
    height = (call.arg(3)).toSInt();

    glretrace::updateDrawable(x + width, y + height);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glViewport(x, y, width, height);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNewList(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint list;
    list = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "list " << size_t(list) << " <- " << size_t(_list_map[list]) << "\n";
    }
    list = _list_map[list];

    GLenum mode;
    mode = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext) {
        currentContext->insideList = true;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNewList(list, mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEndList(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext) {
        currentContext->insideList = false;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEndList();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCallList(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint list;
    list = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "list " << size_t(list) << " <- " << size_t(_list_map[list]) << "\n";
    }
    list = _list_map[list];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glCallList(list);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glCallLists(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(1)).toSInt());

    GLvoid * lists;
    lists = static_cast<GLvoid *>((call.arg(2)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glCallLists(n, type, lists);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glDeleteLists(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint list;
    list = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "list " << size_t(list) << " <- " << size_t(_list_map[list]) << "\n";
    }
    list = _list_map[list];

    GLsizei range;
    range = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeleteLists(list, range);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGenLists(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei range;
    range = (call.arg(0)).toSInt();

    GLuint _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glGenLists(range);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    GLuint _origResult;
    _origResult = (*call.ret).toUInt();
    for (GLuint _hPGLuint20 = 0; _hPGLuint20 < range; ++_hPGLuint20) {
        _list_map[_origResult + _hPGLuint20] = _result + _hPGLuint20;
        if (retrace::verbosity >= 2) {
            std::cout << "list " << (_origResult + _hPGLuint20) << " -> " << (_result + _hPGLuint20) << "\n";
        }
    }
}

static void retrace_glListBase(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint base;
    base = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "list " << size_t(base) << " <- " << size_t(_list_map[base]) << "\n";
    }
    base = _list_map[base];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glListBase(base);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBegin(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glBegin(mode);
    if (currentContext) {
        currentContext->insideBeginEnd = true;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBitmap(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei width;
    width = (call.arg(0)).toSInt();

    GLsizei height;
    height = (call.arg(1)).toSInt();

    GLfloat xorig;
    xorig = (call.arg(2)).toFloat();

    GLfloat yorig;
    yorig = (call.arg(3)).toFloat();

    GLfloat xmove;
    xmove = (call.arg(4)).toFloat();

    GLfloat ymove;
    ymove = (call.arg(5)).toFloat();

    GLubyte * bitmap;
    bitmap = static_cast<GLubyte *>((call.arg(6)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3b(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbyte red;
    red = (call.arg(0)).toSInt();

    GLbyte green;
    green = (call.arg(1)).toSInt();

    GLbyte blue;
    blue = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3b(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3bv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbyte * v;
    v = _allocator.allocArray<GLbyte>(&call.arg(0));
    const trace::Array *_a_GLbyte1_0 = (call.arg(0)).toArray();
    if (_a_GLbyte1_0) {
        for (size_t _jGLbyte1 = 0; _jGLbyte1 < _a_GLbyte1_0->values.size(); ++_jGLbyte1) {
    v[_jGLbyte1] = (*_a_GLbyte1_0->values[_jGLbyte1]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3bv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble red;
    red = (call.arg(0)).toDouble();

    GLdouble green;
    green = (call.arg(1)).toDouble();

    GLdouble blue;
    blue = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3d(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble25_0 = (call.arg(0)).toArray();
    if (_a_GLdouble25_0) {
        for (size_t _jGLdouble25 = 0; _jGLdouble25 < _a_GLdouble25_0->values.size(); ++_jGLdouble25) {
    v[_jGLdouble25] = (*_a_GLdouble25_0->values[_jGLdouble25]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat red;
    red = (call.arg(0)).toFloat();

    GLfloat green;
    green = (call.arg(1)).toFloat();

    GLfloat blue;
    blue = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3f(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat87_0 = (call.arg(0)).toArray();
    if (_a_GLfloat87_0) {
        for (size_t _jGLfloat87 = 0; _jGLfloat87 < _a_GLfloat87_0->values.size(); ++_jGLfloat87) {
    v[_jGLfloat87] = (*_a_GLfloat87_0->values[_jGLfloat87]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint red;
    red = (call.arg(0)).toSInt();

    GLint green;
    green = (call.arg(1)).toSInt();

    GLint blue;
    blue = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3i(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint130_0 = (call.arg(0)).toArray();
    if (_a_GLint130_0) {
        for (size_t _jGLint130 = 0; _jGLint130 < _a_GLint130_0->values.size(); ++_jGLint130) {
    v[_jGLint130] = (*_a_GLint130_0->values[_jGLint130]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort red;
    red = (call.arg(0)).toSInt();

    GLshort green;
    green = (call.arg(1)).toSInt();

    GLshort blue;
    blue = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3s(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort1_0 = (call.arg(0)).toArray();
    if (_a_GLshort1_0) {
        for (size_t _jGLshort1 = 0; _jGLshort1 < _a_GLshort1_0->values.size(); ++_jGLshort1) {
    v[_jGLshort1] = (*_a_GLshort1_0->values[_jGLshort1]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3ub(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLubyte red;
    red = (call.arg(0)).toUInt();

    GLubyte green;
    green = (call.arg(1)).toUInt();

    GLubyte blue;
    blue = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3ub(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3ubv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLubyte * v;
    v = _allocator.allocArray<GLubyte>(&call.arg(0));
    const trace::Array *_a_GLubyte6_0 = (call.arg(0)).toArray();
    if (_a_GLubyte6_0) {
        for (size_t _jGLubyte6 = 0; _jGLubyte6 < _a_GLubyte6_0->values.size(); ++_jGLubyte6) {
    v[_jGLubyte6] = (*_a_GLubyte6_0->values[_jGLubyte6]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3ubv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3ui(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint red;
    red = (call.arg(0)).toUInt();

    GLuint green;
    green = (call.arg(1)).toUInt();

    GLuint blue;
    blue = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3ui(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint * v;
    v = _allocator.allocArray<GLuint>(&call.arg(0));
    const trace::Array *_a_GLuint79_0 = (call.arg(0)).toArray();
    if (_a_GLuint79_0) {
        for (size_t _jGLuint79 = 0; _jGLuint79 < _a_GLuint79_0->values.size(); ++_jGLuint79) {
    v[_jGLuint79] = (*_a_GLuint79_0->values[_jGLuint79]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3uiv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3us(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLushort red;
    red = (call.arg(0)).toUInt();

    GLushort green;
    green = (call.arg(1)).toUInt();

    GLushort blue;
    blue = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3us(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor3usv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLushort * v;
    v = _allocator.allocArray<GLushort>(&call.arg(0));
    const trace::Array *_a_GLushort3_0 = (call.arg(0)).toArray();
    if (_a_GLushort3_0) {
        for (size_t _jGLushort3 = 0; _jGLushort3 < _a_GLushort3_0->values.size(); ++_jGLushort3) {
    v[_jGLushort3] = (*_a_GLushort3_0->values[_jGLushort3]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor3usv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4b(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbyte red;
    red = (call.arg(0)).toSInt();

    GLbyte green;
    green = (call.arg(1)).toSInt();

    GLbyte blue;
    blue = (call.arg(2)).toSInt();

    GLbyte alpha;
    alpha = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4b(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4bv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbyte * v;
    v = _allocator.allocArray<GLbyte>(&call.arg(0));
    const trace::Array *_a_GLbyte2_0 = (call.arg(0)).toArray();
    if (_a_GLbyte2_0) {
        for (size_t _jGLbyte2 = 0; _jGLbyte2 < _a_GLbyte2_0->values.size(); ++_jGLbyte2) {
    v[_jGLbyte2] = (*_a_GLbyte2_0->values[_jGLbyte2]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4bv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble red;
    red = (call.arg(0)).toDouble();

    GLdouble green;
    green = (call.arg(1)).toDouble();

    GLdouble blue;
    blue = (call.arg(2)).toDouble();

    GLdouble alpha;
    alpha = (call.arg(3)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4d(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble26_0 = (call.arg(0)).toArray();
    if (_a_GLdouble26_0) {
        for (size_t _jGLdouble26 = 0; _jGLdouble26 < _a_GLdouble26_0->values.size(); ++_jGLdouble26) {
    v[_jGLdouble26] = (*_a_GLdouble26_0->values[_jGLdouble26]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat red;
    red = (call.arg(0)).toFloat();

    GLfloat green;
    green = (call.arg(1)).toFloat();

    GLfloat blue;
    blue = (call.arg(2)).toFloat();

    GLfloat alpha;
    alpha = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4f(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat88_0 = (call.arg(0)).toArray();
    if (_a_GLfloat88_0) {
        for (size_t _jGLfloat88 = 0; _jGLfloat88 < _a_GLfloat88_0->values.size(); ++_jGLfloat88) {
    v[_jGLfloat88] = (*_a_GLfloat88_0->values[_jGLfloat88]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint red;
    red = (call.arg(0)).toSInt();

    GLint green;
    green = (call.arg(1)).toSInt();

    GLint blue;
    blue = (call.arg(2)).toSInt();

    GLint alpha;
    alpha = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4i(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint131_0 = (call.arg(0)).toArray();
    if (_a_GLint131_0) {
        for (size_t _jGLint131 = 0; _jGLint131 < _a_GLint131_0->values.size(); ++_jGLint131) {
    v[_jGLint131] = (*_a_GLint131_0->values[_jGLint131]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort red;
    red = (call.arg(0)).toSInt();

    GLshort green;
    green = (call.arg(1)).toSInt();

    GLshort blue;
    blue = (call.arg(2)).toSInt();

    GLshort alpha;
    alpha = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4s(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort2_0 = (call.arg(0)).toArray();
    if (_a_GLshort2_0) {
        for (size_t _jGLshort2 = 0; _jGLshort2 < _a_GLshort2_0->values.size(); ++_jGLshort2) {
    v[_jGLshort2] = (*_a_GLshort2_0->values[_jGLshort2]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4ub(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLubyte red;
    red = (call.arg(0)).toUInt();

    GLubyte green;
    green = (call.arg(1)).toUInt();

    GLubyte blue;
    blue = (call.arg(2)).toUInt();

    GLubyte alpha;
    alpha = (call.arg(3)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4ub(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4ubv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLubyte * v;
    v = _allocator.allocArray<GLubyte>(&call.arg(0));
    const trace::Array *_a_GLubyte7_0 = (call.arg(0)).toArray();
    if (_a_GLubyte7_0) {
        for (size_t _jGLubyte7 = 0; _jGLubyte7 < _a_GLubyte7_0->values.size(); ++_jGLubyte7) {
    v[_jGLubyte7] = (*_a_GLubyte7_0->values[_jGLubyte7]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4ubv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4ui(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint red;
    red = (call.arg(0)).toUInt();

    GLuint green;
    green = (call.arg(1)).toUInt();

    GLuint blue;
    blue = (call.arg(2)).toUInt();

    GLuint alpha;
    alpha = (call.arg(3)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4ui(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint * v;
    v = _allocator.allocArray<GLuint>(&call.arg(0));
    const trace::Array *_a_GLuint80_0 = (call.arg(0)).toArray();
    if (_a_GLuint80_0) {
        for (size_t _jGLuint80 = 0; _jGLuint80 < _a_GLuint80_0->values.size(); ++_jGLuint80) {
    v[_jGLuint80] = (*_a_GLuint80_0->values[_jGLuint80]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4uiv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4us(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLushort red;
    red = (call.arg(0)).toUInt();

    GLushort green;
    green = (call.arg(1)).toUInt();

    GLushort blue;
    blue = (call.arg(2)).toUInt();

    GLushort alpha;
    alpha = (call.arg(3)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4us(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4usv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLushort * v;
    v = _allocator.allocArray<GLushort>(&call.arg(0));
    const trace::Array *_a_GLushort4_0 = (call.arg(0)).toArray();
    if (_a_GLushort4_0) {
        for (size_t _jGLushort4 = 0; _jGLushort4 < _a_GLushort4_0->values.size(); ++_jGLushort4) {
    v[_jGLushort4] = (*_a_GLushort4_0->values[_jGLushort4]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4usv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEdgeFlag(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLboolean flag;
    flag = static_cast<GLboolean>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEdgeFlag(flag);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEdgeFlagv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLboolean * flag;
    flag = _allocator.allocArray<GLboolean>(&call.arg(0));
    if (flag) {
        const trace::Array *_a_PGLboolean_0 = (call.arg(0)).toArray();
    flag[0] = static_cast<GLboolean>((*_a_PGLboolean_0->values[0]).toSInt());
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEdgeFlagv(flag);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEnd(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext) {
        currentContext->insideBeginEnd = false;
    }
    glEnd();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glIndexd(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble c;
    c = (call.arg(0)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexd(c);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glIndexdv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * c;
    c = _allocator.allocArray<GLdouble>(&call.arg(0));
    if (c) {
        const trace::Array *_a_PGLdouble1_0 = (call.arg(0)).toArray();
    c[0] = (*_a_PGLdouble1_0->values[0]).toDouble();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexdv(c);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glIndexf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat c;
    c = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexf(c);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glIndexfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * c;
    c = _allocator.allocArray<GLfloat>(&call.arg(0));
    if (c) {
        const trace::Array *_a_PGLfloat11_0 = (call.arg(0)).toArray();
    c[0] = (*_a_PGLfloat11_0->values[0]).toFloat();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexfv(c);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glIndexi(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint c;
    c = (call.arg(0)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexi(c);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glIndexiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * c;
    c = _allocator.allocArray<GLint>(&call.arg(0));
    if (c) {
        const trace::Array *_a_PGLint29_0 = (call.arg(0)).toArray();
    c[0] = (*_a_PGLint29_0->values[0]).toSInt();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexiv(c);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glIndexs(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort c;
    c = (call.arg(0)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexs(c);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glIndexsv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * c;
    c = _allocator.allocArray<GLshort>(&call.arg(0));
    if (c) {
        const trace::Array *_a_PGLshort_0 = (call.arg(0)).toArray();
    c[0] = (*_a_PGLshort_0->values[0]).toSInt();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexsv(c);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormal3b(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbyte nx;
    nx = (call.arg(0)).toSInt();

    GLbyte ny;
    ny = (call.arg(1)).toSInt();

    GLbyte nz;
    nz = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormal3b(nx, ny, nz);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormal3bv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbyte * v;
    v = _allocator.allocArray<GLbyte>(&call.arg(0));
    const trace::Array *_a_GLbyte3_0 = (call.arg(0)).toArray();
    if (_a_GLbyte3_0) {
        for (size_t _jGLbyte3 = 0; _jGLbyte3 < _a_GLbyte3_0->values.size(); ++_jGLbyte3) {
    v[_jGLbyte3] = (*_a_GLbyte3_0->values[_jGLbyte3]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormal3bv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormal3d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble nx;
    nx = (call.arg(0)).toDouble();

    GLdouble ny;
    ny = (call.arg(1)).toDouble();

    GLdouble nz;
    nz = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormal3d(nx, ny, nz);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormal3dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble27_0 = (call.arg(0)).toArray();
    if (_a_GLdouble27_0) {
        for (size_t _jGLdouble27 = 0; _jGLdouble27 < _a_GLdouble27_0->values.size(); ++_jGLdouble27) {
    v[_jGLdouble27] = (*_a_GLdouble27_0->values[_jGLdouble27]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormal3dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormal3f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat nx;
    nx = (call.arg(0)).toFloat();

    GLfloat ny;
    ny = (call.arg(1)).toFloat();

    GLfloat nz;
    nz = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormal3f(nx, ny, nz);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormal3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat89_0 = (call.arg(0)).toArray();
    if (_a_GLfloat89_0) {
        for (size_t _jGLfloat89 = 0; _jGLfloat89 < _a_GLfloat89_0->values.size(); ++_jGLfloat89) {
    v[_jGLfloat89] = (*_a_GLfloat89_0->values[_jGLfloat89]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormal3fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormal3i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint nx;
    nx = (call.arg(0)).toSInt();

    GLint ny;
    ny = (call.arg(1)).toSInt();

    GLint nz;
    nz = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormal3i(nx, ny, nz);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormal3iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint132_0 = (call.arg(0)).toArray();
    if (_a_GLint132_0) {
        for (size_t _jGLint132 = 0; _jGLint132 < _a_GLint132_0->values.size(); ++_jGLint132) {
    v[_jGLint132] = (*_a_GLint132_0->values[_jGLint132]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormal3iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormal3s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort nx;
    nx = (call.arg(0)).toSInt();

    GLshort ny;
    ny = (call.arg(1)).toSInt();

    GLshort nz;
    nz = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormal3s(nx, ny, nz);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormal3sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort3_0 = (call.arg(0)).toArray();
    if (_a_GLshort3_0) {
        for (size_t _jGLshort3 = 0; _jGLshort3 < _a_GLshort3_0->values.size(); ++_jGLshort3) {
    v[_jGLshort3] = (*_a_GLshort3_0->values[_jGLshort3]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormal3sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos2d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble x;
    x = (call.arg(0)).toDouble();

    GLdouble y;
    y = (call.arg(1)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos2d(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos2dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble28_0 = (call.arg(0)).toArray();
    if (_a_GLdouble28_0) {
        for (size_t _jGLdouble28 = 0; _jGLdouble28 < _a_GLdouble28_0->values.size(); ++_jGLdouble28) {
    v[_jGLdouble28] = (*_a_GLdouble28_0->values[_jGLdouble28]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos2dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos2f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat x;
    x = (call.arg(0)).toFloat();

    GLfloat y;
    y = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos2f(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos2fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat90_0 = (call.arg(0)).toArray();
    if (_a_GLfloat90_0) {
        for (size_t _jGLfloat90 = 0; _jGLfloat90 < _a_GLfloat90_0->values.size(); ++_jGLfloat90) {
    v[_jGLfloat90] = (*_a_GLfloat90_0->values[_jGLfloat90]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos2fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos2i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos2i(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos2iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint133_0 = (call.arg(0)).toArray();
    if (_a_GLint133_0) {
        for (size_t _jGLint133 = 0; _jGLint133 < _a_GLint133_0->values.size(); ++_jGLint133) {
    v[_jGLint133] = (*_a_GLint133_0->values[_jGLint133]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos2iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos2s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort x;
    x = (call.arg(0)).toSInt();

    GLshort y;
    y = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos2s(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos2sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort4_0 = (call.arg(0)).toArray();
    if (_a_GLshort4_0) {
        for (size_t _jGLshort4 = 0; _jGLshort4 < _a_GLshort4_0->values.size(); ++_jGLshort4) {
    v[_jGLshort4] = (*_a_GLshort4_0->values[_jGLshort4]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos2sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos3d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble x;
    x = (call.arg(0)).toDouble();

    GLdouble y;
    y = (call.arg(1)).toDouble();

    GLdouble z;
    z = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos3d(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos3dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble29_0 = (call.arg(0)).toArray();
    if (_a_GLdouble29_0) {
        for (size_t _jGLdouble29 = 0; _jGLdouble29 < _a_GLdouble29_0->values.size(); ++_jGLdouble29) {
    v[_jGLdouble29] = (*_a_GLdouble29_0->values[_jGLdouble29]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos3dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos3f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat x;
    x = (call.arg(0)).toFloat();

    GLfloat y;
    y = (call.arg(1)).toFloat();

    GLfloat z;
    z = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos3f(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat91_0 = (call.arg(0)).toArray();
    if (_a_GLfloat91_0) {
        for (size_t _jGLfloat91 = 0; _jGLfloat91 < _a_GLfloat91_0->values.size(); ++_jGLfloat91) {
    v[_jGLfloat91] = (*_a_GLfloat91_0->values[_jGLfloat91]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos3fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos3i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    GLint z;
    z = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos3i(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos3iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint134_0 = (call.arg(0)).toArray();
    if (_a_GLint134_0) {
        for (size_t _jGLint134 = 0; _jGLint134 < _a_GLint134_0->values.size(); ++_jGLint134) {
    v[_jGLint134] = (*_a_GLint134_0->values[_jGLint134]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos3iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos3s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort x;
    x = (call.arg(0)).toSInt();

    GLshort y;
    y = (call.arg(1)).toSInt();

    GLshort z;
    z = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos3s(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos3sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort5_0 = (call.arg(0)).toArray();
    if (_a_GLshort5_0) {
        for (size_t _jGLshort5 = 0; _jGLshort5 < _a_GLshort5_0->values.size(); ++_jGLshort5) {
    v[_jGLshort5] = (*_a_GLshort5_0->values[_jGLshort5]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos3sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos4d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble x;
    x = (call.arg(0)).toDouble();

    GLdouble y;
    y = (call.arg(1)).toDouble();

    GLdouble z;
    z = (call.arg(2)).toDouble();

    GLdouble w;
    w = (call.arg(3)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos4d(x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos4dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble30_0 = (call.arg(0)).toArray();
    if (_a_GLdouble30_0) {
        for (size_t _jGLdouble30 = 0; _jGLdouble30 < _a_GLdouble30_0->values.size(); ++_jGLdouble30) {
    v[_jGLdouble30] = (*_a_GLdouble30_0->values[_jGLdouble30]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos4dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos4f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat x;
    x = (call.arg(0)).toFloat();

    GLfloat y;
    y = (call.arg(1)).toFloat();

    GLfloat z;
    z = (call.arg(2)).toFloat();

    GLfloat w;
    w = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos4f(x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos4fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat92_0 = (call.arg(0)).toArray();
    if (_a_GLfloat92_0) {
        for (size_t _jGLfloat92 = 0; _jGLfloat92 < _a_GLfloat92_0->values.size(); ++_jGLfloat92) {
    v[_jGLfloat92] = (*_a_GLfloat92_0->values[_jGLfloat92]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos4fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos4i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    GLint z;
    z = (call.arg(2)).toSInt();

    GLint w;
    w = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos4i(x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos4iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint135_0 = (call.arg(0)).toArray();
    if (_a_GLint135_0) {
        for (size_t _jGLint135 = 0; _jGLint135 < _a_GLint135_0->values.size(); ++_jGLint135) {
    v[_jGLint135] = (*_a_GLint135_0->values[_jGLint135]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos4iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos4s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort x;
    x = (call.arg(0)).toSInt();

    GLshort y;
    y = (call.arg(1)).toSInt();

    GLshort z;
    z = (call.arg(2)).toSInt();

    GLshort w;
    w = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos4s(x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRasterPos4sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort6_0 = (call.arg(0)).toArray();
    if (_a_GLshort6_0) {
        for (size_t _jGLshort6 = 0; _jGLshort6 < _a_GLshort6_0->values.size(); ++_jGLshort6) {
    v[_jGLshort6] = (*_a_GLshort6_0->values[_jGLshort6]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRasterPos4sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRectd(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble x1;
    x1 = (call.arg(0)).toDouble();

    GLdouble y1;
    y1 = (call.arg(1)).toDouble();

    GLdouble x2;
    x2 = (call.arg(2)).toDouble();

    GLdouble y2;
    y2 = (call.arg(3)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glRectd(x1, y1, x2, y2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glRectdv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v1;
    v1 = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble31_0 = (call.arg(0)).toArray();
    if (_a_GLdouble31_0) {
        for (size_t _jGLdouble31 = 0; _jGLdouble31 < _a_GLdouble31_0->values.size(); ++_jGLdouble31) {
    v1[_jGLdouble31] = (*_a_GLdouble31_0->values[_jGLdouble31]).toDouble();
        }
    }

    GLdouble * v2;
    v2 = _allocator.allocArray<GLdouble>(&call.arg(1));
    const trace::Array *_a_GLdouble32_0 = (call.arg(1)).toArray();
    if (_a_GLdouble32_0) {
        for (size_t _jGLdouble32 = 0; _jGLdouble32 < _a_GLdouble32_0->values.size(); ++_jGLdouble32) {
    v2[_jGLdouble32] = (*_a_GLdouble32_0->values[_jGLdouble32]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glRectdv(v1, v2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glRectf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat x1;
    x1 = (call.arg(0)).toFloat();

    GLfloat y1;
    y1 = (call.arg(1)).toFloat();

    GLfloat x2;
    x2 = (call.arg(2)).toFloat();

    GLfloat y2;
    y2 = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glRectf(x1, y1, x2, y2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glRectfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v1;
    v1 = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat93_0 = (call.arg(0)).toArray();
    if (_a_GLfloat93_0) {
        for (size_t _jGLfloat93 = 0; _jGLfloat93 < _a_GLfloat93_0->values.size(); ++_jGLfloat93) {
    v1[_jGLfloat93] = (*_a_GLfloat93_0->values[_jGLfloat93]).toFloat();
        }
    }

    GLfloat * v2;
    v2 = _allocator.allocArray<GLfloat>(&call.arg(1));
    const trace::Array *_a_GLfloat94_0 = (call.arg(1)).toArray();
    if (_a_GLfloat94_0) {
        for (size_t _jGLfloat94 = 0; _jGLfloat94 < _a_GLfloat94_0->values.size(); ++_jGLfloat94) {
    v2[_jGLfloat94] = (*_a_GLfloat94_0->values[_jGLfloat94]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glRectfv(v1, v2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glRecti(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x1;
    x1 = (call.arg(0)).toSInt();

    GLint y1;
    y1 = (call.arg(1)).toSInt();

    GLint x2;
    x2 = (call.arg(2)).toSInt();

    GLint y2;
    y2 = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glRecti(x1, y1, x2, y2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glRectiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v1;
    v1 = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint136_0 = (call.arg(0)).toArray();
    if (_a_GLint136_0) {
        for (size_t _jGLint136 = 0; _jGLint136 < _a_GLint136_0->values.size(); ++_jGLint136) {
    v1[_jGLint136] = (*_a_GLint136_0->values[_jGLint136]).toSInt();
        }
    }

    GLint * v2;
    v2 = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint137_0 = (call.arg(1)).toArray();
    if (_a_GLint137_0) {
        for (size_t _jGLint137 = 0; _jGLint137 < _a_GLint137_0->values.size(); ++_jGLint137) {
    v2[_jGLint137] = (*_a_GLint137_0->values[_jGLint137]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glRectiv(v1, v2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glRects(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort x1;
    x1 = (call.arg(0)).toSInt();

    GLshort y1;
    y1 = (call.arg(1)).toSInt();

    GLshort x2;
    x2 = (call.arg(2)).toSInt();

    GLshort y2;
    y2 = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glRects(x1, y1, x2, y2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glRectsv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v1;
    v1 = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort7_0 = (call.arg(0)).toArray();
    if (_a_GLshort7_0) {
        for (size_t _jGLshort7 = 0; _jGLshort7 < _a_GLshort7_0->values.size(); ++_jGLshort7) {
    v1[_jGLshort7] = (*_a_GLshort7_0->values[_jGLshort7]).toSInt();
        }
    }

    GLshort * v2;
    v2 = _allocator.allocArray<GLshort>(&call.arg(1));
    const trace::Array *_a_GLshort8_0 = (call.arg(1)).toArray();
    if (_a_GLshort8_0) {
        for (size_t _jGLshort8 = 0; _jGLshort8 < _a_GLshort8_0->values.size(); ++_jGLshort8) {
    v2[_jGLshort8] = (*_a_GLshort8_0->values[_jGLshort8]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glRectsv(v1, v2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glTexCoord1d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble s;
    s = (call.arg(0)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord1d(s);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord1dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    if (v) {
        const trace::Array *_a_PGLdouble2_0 = (call.arg(0)).toArray();
    v[0] = (*_a_PGLdouble2_0->values[0]).toDouble();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord1dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord1f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat s;
    s = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord1f(s);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord1fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    if (v) {
        const trace::Array *_a_PGLfloat12_0 = (call.arg(0)).toArray();
    v[0] = (*_a_PGLfloat12_0->values[0]).toFloat();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord1fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord1i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint s;
    s = (call.arg(0)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord1i(s);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord1iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    if (v) {
        const trace::Array *_a_PGLint30_0 = (call.arg(0)).toArray();
    v[0] = (*_a_PGLint30_0->values[0]).toSInt();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord1iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord1s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort s;
    s = (call.arg(0)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord1s(s);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord1sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    if (v) {
        const trace::Array *_a_PGLshort1_0 = (call.arg(0)).toArray();
    v[0] = (*_a_PGLshort1_0->values[0]).toSInt();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord1sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord2d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble s;
    s = (call.arg(0)).toDouble();

    GLdouble t;
    t = (call.arg(1)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord2d(s, t);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord2dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble33_0 = (call.arg(0)).toArray();
    if (_a_GLdouble33_0) {
        for (size_t _jGLdouble33 = 0; _jGLdouble33 < _a_GLdouble33_0->values.size(); ++_jGLdouble33) {
    v[_jGLdouble33] = (*_a_GLdouble33_0->values[_jGLdouble33]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord2dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord2f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat s;
    s = (call.arg(0)).toFloat();

    GLfloat t;
    t = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord2f(s, t);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord2fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat95_0 = (call.arg(0)).toArray();
    if (_a_GLfloat95_0) {
        for (size_t _jGLfloat95 = 0; _jGLfloat95 < _a_GLfloat95_0->values.size(); ++_jGLfloat95) {
    v[_jGLfloat95] = (*_a_GLfloat95_0->values[_jGLfloat95]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord2fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord2i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint s;
    s = (call.arg(0)).toSInt();

    GLint t;
    t = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord2i(s, t);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord2iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint138_0 = (call.arg(0)).toArray();
    if (_a_GLint138_0) {
        for (size_t _jGLint138 = 0; _jGLint138 < _a_GLint138_0->values.size(); ++_jGLint138) {
    v[_jGLint138] = (*_a_GLint138_0->values[_jGLint138]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord2iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord2s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort s;
    s = (call.arg(0)).toSInt();

    GLshort t;
    t = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord2s(s, t);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord2sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort9_0 = (call.arg(0)).toArray();
    if (_a_GLshort9_0) {
        for (size_t _jGLshort9 = 0; _jGLshort9 < _a_GLshort9_0->values.size(); ++_jGLshort9) {
    v[_jGLshort9] = (*_a_GLshort9_0->values[_jGLshort9]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord2sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord3d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble s;
    s = (call.arg(0)).toDouble();

    GLdouble t;
    t = (call.arg(1)).toDouble();

    GLdouble r;
    r = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord3d(s, t, r);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord3dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble34_0 = (call.arg(0)).toArray();
    if (_a_GLdouble34_0) {
        for (size_t _jGLdouble34 = 0; _jGLdouble34 < _a_GLdouble34_0->values.size(); ++_jGLdouble34) {
    v[_jGLdouble34] = (*_a_GLdouble34_0->values[_jGLdouble34]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord3dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord3f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat s;
    s = (call.arg(0)).toFloat();

    GLfloat t;
    t = (call.arg(1)).toFloat();

    GLfloat r;
    r = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord3f(s, t, r);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat96_0 = (call.arg(0)).toArray();
    if (_a_GLfloat96_0) {
        for (size_t _jGLfloat96 = 0; _jGLfloat96 < _a_GLfloat96_0->values.size(); ++_jGLfloat96) {
    v[_jGLfloat96] = (*_a_GLfloat96_0->values[_jGLfloat96]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord3fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord3i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint s;
    s = (call.arg(0)).toSInt();

    GLint t;
    t = (call.arg(1)).toSInt();

    GLint r;
    r = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord3i(s, t, r);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord3iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint139_0 = (call.arg(0)).toArray();
    if (_a_GLint139_0) {
        for (size_t _jGLint139 = 0; _jGLint139 < _a_GLint139_0->values.size(); ++_jGLint139) {
    v[_jGLint139] = (*_a_GLint139_0->values[_jGLint139]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord3iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord3s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort s;
    s = (call.arg(0)).toSInt();

    GLshort t;
    t = (call.arg(1)).toSInt();

    GLshort r;
    r = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord3s(s, t, r);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord3sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort10_0 = (call.arg(0)).toArray();
    if (_a_GLshort10_0) {
        for (size_t _jGLshort10 = 0; _jGLshort10 < _a_GLshort10_0->values.size(); ++_jGLshort10) {
    v[_jGLshort10] = (*_a_GLshort10_0->values[_jGLshort10]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord3sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord4d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble s;
    s = (call.arg(0)).toDouble();

    GLdouble t;
    t = (call.arg(1)).toDouble();

    GLdouble r;
    r = (call.arg(2)).toDouble();

    GLdouble q;
    q = (call.arg(3)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord4d(s, t, r, q);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord4dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble35_0 = (call.arg(0)).toArray();
    if (_a_GLdouble35_0) {
        for (size_t _jGLdouble35 = 0; _jGLdouble35 < _a_GLdouble35_0->values.size(); ++_jGLdouble35) {
    v[_jGLdouble35] = (*_a_GLdouble35_0->values[_jGLdouble35]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord4dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord4f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat s;
    s = (call.arg(0)).toFloat();

    GLfloat t;
    t = (call.arg(1)).toFloat();

    GLfloat r;
    r = (call.arg(2)).toFloat();

    GLfloat q;
    q = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord4f(s, t, r, q);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord4fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat97_0 = (call.arg(0)).toArray();
    if (_a_GLfloat97_0) {
        for (size_t _jGLfloat97 = 0; _jGLfloat97 < _a_GLfloat97_0->values.size(); ++_jGLfloat97) {
    v[_jGLfloat97] = (*_a_GLfloat97_0->values[_jGLfloat97]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord4fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord4i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint s;
    s = (call.arg(0)).toSInt();

    GLint t;
    t = (call.arg(1)).toSInt();

    GLint r;
    r = (call.arg(2)).toSInt();

    GLint q;
    q = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord4i(s, t, r, q);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord4iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint140_0 = (call.arg(0)).toArray();
    if (_a_GLint140_0) {
        for (size_t _jGLint140 = 0; _jGLint140 < _a_GLint140_0->values.size(); ++_jGLint140) {
    v[_jGLint140] = (*_a_GLint140_0->values[_jGLint140]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord4iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord4s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort s;
    s = (call.arg(0)).toSInt();

    GLshort t;
    t = (call.arg(1)).toSInt();

    GLshort r;
    r = (call.arg(2)).toSInt();

    GLshort q;
    q = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord4s(s, t, r, q);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoord4sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort11_0 = (call.arg(0)).toArray();
    if (_a_GLshort11_0) {
        for (size_t _jGLshort11 = 0; _jGLshort11 < _a_GLshort11_0->values.size(); ++_jGLshort11) {
    v[_jGLshort11] = (*_a_GLshort11_0->values[_jGLshort11]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoord4sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex2d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble x;
    x = (call.arg(0)).toDouble();

    GLdouble y;
    y = (call.arg(1)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex2d(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex2dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble36_0 = (call.arg(0)).toArray();
    if (_a_GLdouble36_0) {
        for (size_t _jGLdouble36 = 0; _jGLdouble36 < _a_GLdouble36_0->values.size(); ++_jGLdouble36) {
    v[_jGLdouble36] = (*_a_GLdouble36_0->values[_jGLdouble36]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex2dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex2f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat x;
    x = (call.arg(0)).toFloat();

    GLfloat y;
    y = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex2f(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex2fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat98_0 = (call.arg(0)).toArray();
    if (_a_GLfloat98_0) {
        for (size_t _jGLfloat98 = 0; _jGLfloat98 < _a_GLfloat98_0->values.size(); ++_jGLfloat98) {
    v[_jGLfloat98] = (*_a_GLfloat98_0->values[_jGLfloat98]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex2fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex2i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex2i(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex2iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint141_0 = (call.arg(0)).toArray();
    if (_a_GLint141_0) {
        for (size_t _jGLint141 = 0; _jGLint141 < _a_GLint141_0->values.size(); ++_jGLint141) {
    v[_jGLint141] = (*_a_GLint141_0->values[_jGLint141]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex2iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex2s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort x;
    x = (call.arg(0)).toSInt();

    GLshort y;
    y = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex2s(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex2sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort12_0 = (call.arg(0)).toArray();
    if (_a_GLshort12_0) {
        for (size_t _jGLshort12 = 0; _jGLshort12 < _a_GLshort12_0->values.size(); ++_jGLshort12) {
    v[_jGLshort12] = (*_a_GLshort12_0->values[_jGLshort12]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex2sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex3d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble x;
    x = (call.arg(0)).toDouble();

    GLdouble y;
    y = (call.arg(1)).toDouble();

    GLdouble z;
    z = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex3d(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex3dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble37_0 = (call.arg(0)).toArray();
    if (_a_GLdouble37_0) {
        for (size_t _jGLdouble37 = 0; _jGLdouble37 < _a_GLdouble37_0->values.size(); ++_jGLdouble37) {
    v[_jGLdouble37] = (*_a_GLdouble37_0->values[_jGLdouble37]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex3dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex3f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat x;
    x = (call.arg(0)).toFloat();

    GLfloat y;
    y = (call.arg(1)).toFloat();

    GLfloat z;
    z = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex3f(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat99_0 = (call.arg(0)).toArray();
    if (_a_GLfloat99_0) {
        for (size_t _jGLfloat99 = 0; _jGLfloat99 < _a_GLfloat99_0->values.size(); ++_jGLfloat99) {
    v[_jGLfloat99] = (*_a_GLfloat99_0->values[_jGLfloat99]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex3fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex3i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    GLint z;
    z = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex3i(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex3iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint142_0 = (call.arg(0)).toArray();
    if (_a_GLint142_0) {
        for (size_t _jGLint142 = 0; _jGLint142 < _a_GLint142_0->values.size(); ++_jGLint142) {
    v[_jGLint142] = (*_a_GLint142_0->values[_jGLint142]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex3iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex3s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort x;
    x = (call.arg(0)).toSInt();

    GLshort y;
    y = (call.arg(1)).toSInt();

    GLshort z;
    z = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex3s(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex3sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort13_0 = (call.arg(0)).toArray();
    if (_a_GLshort13_0) {
        for (size_t _jGLshort13 = 0; _jGLshort13 < _a_GLshort13_0->values.size(); ++_jGLshort13) {
    v[_jGLshort13] = (*_a_GLshort13_0->values[_jGLshort13]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex3sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex4d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble x;
    x = (call.arg(0)).toDouble();

    GLdouble y;
    y = (call.arg(1)).toDouble();

    GLdouble z;
    z = (call.arg(2)).toDouble();

    GLdouble w;
    w = (call.arg(3)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex4d(x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex4dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble38_0 = (call.arg(0)).toArray();
    if (_a_GLdouble38_0) {
        for (size_t _jGLdouble38 = 0; _jGLdouble38 < _a_GLdouble38_0->values.size(); ++_jGLdouble38) {
    v[_jGLdouble38] = (*_a_GLdouble38_0->values[_jGLdouble38]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex4dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex4f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat x;
    x = (call.arg(0)).toFloat();

    GLfloat y;
    y = (call.arg(1)).toFloat();

    GLfloat z;
    z = (call.arg(2)).toFloat();

    GLfloat w;
    w = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex4f(x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex4fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat100_0 = (call.arg(0)).toArray();
    if (_a_GLfloat100_0) {
        for (size_t _jGLfloat100 = 0; _jGLfloat100 < _a_GLfloat100_0->values.size(); ++_jGLfloat100) {
    v[_jGLfloat100] = (*_a_GLfloat100_0->values[_jGLfloat100]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex4fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex4i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    GLint z;
    z = (call.arg(2)).toSInt();

    GLint w;
    w = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex4i(x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex4iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint143_0 = (call.arg(0)).toArray();
    if (_a_GLint143_0) {
        for (size_t _jGLint143 = 0; _jGLint143 < _a_GLint143_0->values.size(); ++_jGLint143) {
    v[_jGLint143] = (*_a_GLint143_0->values[_jGLint143]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex4iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex4s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort x;
    x = (call.arg(0)).toSInt();

    GLshort y;
    y = (call.arg(1)).toSInt();

    GLshort z;
    z = (call.arg(2)).toSInt();

    GLshort w;
    w = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex4s(x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertex4sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort14_0 = (call.arg(0)).toArray();
    if (_a_GLshort14_0) {
        for (size_t _jGLshort14 = 0; _jGLshort14 < _a_GLshort14_0->values.size(); ++_jGLshort14) {
    v[_jGLshort14] = (*_a_GLshort14_0->values[_jGLshort14]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertex4sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClipPlane(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum plane;
    plane = static_cast<GLenum>((call.arg(0)).toSInt());

    GLdouble * equation;
    equation = _allocator.allocArray<GLdouble>(&call.arg(1));
    const trace::Array *_a_GLdouble39_0 = (call.arg(1)).toArray();
    if (_a_GLdouble39_0) {
        for (size_t _jGLdouble39 = 0; _jGLdouble39 < _a_GLdouble39_0->values.size(); ++_jGLdouble39) {
    equation[_jGLdouble39] = (*_a_GLdouble39_0->values[_jGLdouble39]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClipPlane(plane, equation);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColorMaterial(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum mode;
    mode = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColorMaterial(face, mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFogf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat param;
    param = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFogf(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFogfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat * params;
    params = _allocator.allocArray<GLfloat>(&call.arg(1));
    const trace::Array *_a_GLfloat101_0 = (call.arg(1)).toArray();
    if (_a_GLfloat101_0) {
        for (size_t _jGLfloat101 = 0; _jGLfloat101 < _a_GLfloat101_0->values.size(); ++_jGLfloat101) {
    params[_jGLfloat101] = (*_a_GLfloat101_0->values[_jGLfloat101]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFogfv(pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFogi(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint param;
    param = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFogi(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFogiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint * params;
    params = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint144_0 = (call.arg(1)).toArray();
    if (_a_GLint144_0) {
        for (size_t _jGLint144 = 0; _jGLint144 < _a_GLint144_0->values.size(); ++_jGLint144) {
    params[_jGLint144] = (*_a_GLint144_0->values[_jGLint144]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFogiv(pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLightf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum light;
    light = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat param;
    param = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLightf(light, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLightfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum light;
    light = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat * params;
    params = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat102_0 = (call.arg(2)).toArray();
    if (_a_GLfloat102_0) {
        for (size_t _jGLfloat102 = 0; _jGLfloat102 < _a_GLfloat102_0->values.size(); ++_jGLfloat102) {
    params[_jGLfloat102] = (*_a_GLfloat102_0->values[_jGLfloat102]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLightfv(light, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLighti(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum light;
    light = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint param;
    param = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLighti(light, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLightiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum light;
    light = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint * params;
    params = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint145_0 = (call.arg(2)).toArray();
    if (_a_GLint145_0) {
        for (size_t _jGLint145 = 0; _jGLint145 < _a_GLint145_0->values.size(); ++_jGLint145) {
    params[_jGLint145] = (*_a_GLint145_0->values[_jGLint145]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLightiv(light, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLightModelf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat param;
    param = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLightModelf(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLightModelfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat * params;
    params = _allocator.allocArray<GLfloat>(&call.arg(1));
    const trace::Array *_a_GLfloat103_0 = (call.arg(1)).toArray();
    if (_a_GLfloat103_0) {
        for (size_t _jGLfloat103 = 0; _jGLfloat103 < _a_GLfloat103_0->values.size(); ++_jGLfloat103) {
    params[_jGLfloat103] = (*_a_GLfloat103_0->values[_jGLfloat103]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLightModelfv(pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLightModeli(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint param;
    param = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLightModeli(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLightModeliv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint * params;
    params = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint146_0 = (call.arg(1)).toArray();
    if (_a_GLint146_0) {
        for (size_t _jGLint146 = 0; _jGLint146 < _a_GLint146_0->values.size(); ++_jGLint146) {
    params[_jGLint146] = (*_a_GLint146_0->values[_jGLint146]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLightModeliv(pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLineStipple(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint factor;
    factor = (call.arg(0)).toSInt();

    GLushort pattern;
    pattern = (call.arg(1)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLineStipple(factor, pattern);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMaterialf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat param;
    param = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMaterialf(face, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMaterialfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat * params;
    params = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat104_0 = (call.arg(2)).toArray();
    if (_a_GLfloat104_0) {
        for (size_t _jGLfloat104 = 0; _jGLfloat104 < _a_GLfloat104_0->values.size(); ++_jGLfloat104) {
    params[_jGLfloat104] = (*_a_GLfloat104_0->values[_jGLfloat104]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMaterialfv(face, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMateriali(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint param;
    param = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMateriali(face, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMaterialiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint * params;
    params = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint147_0 = (call.arg(2)).toArray();
    if (_a_GLint147_0) {
        for (size_t _jGLint147 = 0; _jGLint147 < _a_GLint147_0->values.size(); ++_jGLint147) {
    params[_jGLint147] = (*_a_GLint147_0->values[_jGLint147]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMaterialiv(face, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPolygonStipple(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLubyte * mask;
    mask = _allocator.allocArray<GLubyte>(&call.arg(0));
    const trace::Array *_a_GLubyte8_0 = (call.arg(0)).toArray();
    if (_a_GLubyte8_0) {
        for (size_t _jGLubyte8 = 0; _jGLubyte8 < _a_GLubyte8_0->values.size(); ++_jGLubyte8) {
    mask[_jGLubyte8] = (*_a_GLubyte8_0->values[_jGLubyte8]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPolygonStipple(mask);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glShadeModel(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glShadeModel(mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexEnvf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat param;
    param = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexEnvf(target, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexEnvfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat * params;
    params = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat105_0 = (call.arg(2)).toArray();
    if (_a_GLfloat105_0) {
        for (size_t _jGLfloat105 = 0; _jGLfloat105 < _a_GLfloat105_0->values.size(); ++_jGLfloat105) {
    params[_jGLfloat105] = (*_a_GLfloat105_0->values[_jGLfloat105]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexEnvfv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexEnvi(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint param;
    param = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexEnvi(target, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexEnviv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint * params;
    params = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint148_0 = (call.arg(2)).toArray();
    if (_a_GLint148_0) {
        for (size_t _jGLint148 = 0; _jGLint148 < _a_GLint148_0->values.size(); ++_jGLint148) {
    params[_jGLint148] = (*_a_GLint148_0->values[_jGLint148]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexEnviv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexGend(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum coord;
    coord = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLdouble param;
    param = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexGend(coord, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexGendv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum coord;
    coord = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLdouble * params;
    params = _allocator.allocArray<GLdouble>(&call.arg(2));
    const trace::Array *_a_GLdouble40_0 = (call.arg(2)).toArray();
    if (_a_GLdouble40_0) {
        for (size_t _jGLdouble40 = 0; _jGLdouble40 < _a_GLdouble40_0->values.size(); ++_jGLdouble40) {
    params[_jGLdouble40] = (*_a_GLdouble40_0->values[_jGLdouble40]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexGendv(coord, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexGenf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum coord;
    coord = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat param;
    param = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexGenf(coord, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexGenfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum coord;
    coord = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat * params;
    params = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat106_0 = (call.arg(2)).toArray();
    if (_a_GLfloat106_0) {
        for (size_t _jGLfloat106 = 0; _jGLfloat106 < _a_GLfloat106_0->values.size(); ++_jGLfloat106) {
    params[_jGLfloat106] = (*_a_GLfloat106_0->values[_jGLfloat106]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexGenfv(coord, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexGeni(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum coord;
    coord = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint param;
    param = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexGeni(coord, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexGeniv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum coord;
    coord = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint * params;
    params = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint149_0 = (call.arg(2)).toArray();
    if (_a_GLint149_0) {
        for (size_t _jGLint149 = 0; _jGLint149 < _a_GLint149_0->values.size(); ++_jGLint149) {
    params[_jGLint149] = (*_a_GLint149_0->values[_jGLint149]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexGeniv(coord, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFeedbackBuffer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei size;
    size = (call.arg(0)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat * buffer;
    buffer = _allocator.allocArray<GLfloat>(&call.arg(2));
    _allocator.bind(buffer);

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFeedbackBuffer(size, type, buffer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLfloat108 = (call.arg(2)).toArray();
    if (_aGLfloat108) {
        for (size_t _jGLfloat108 = 0; _jGLfloat108 < _aGLfloat108->values.size(); ++_jGLfloat108) {
        }
    }
}

static void retrace_glSelectBuffer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei size;
    size = (call.arg(0)).toSInt();

    GLuint * buffer;
    buffer = _allocator.allocArray<GLuint>(&call.arg(1));
    _allocator.bind(buffer);

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSelectBuffer(size, buffer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint82 = (call.arg(1)).toArray();
    if (_aGLuint82) {
        for (size_t _jGLuint82 = 0; _jGLuint82 < _aGLuint82->values.size(); ++_jGLuint82) {
        }
    }
}

static void retrace_glRenderMode(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glRenderMode(mode);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glInitNames(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glInitNames();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLoadName(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint name;
    name = (call.arg(0)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLoadName(name);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPassThrough(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat token;
    token = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPassThrough(token);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPopName(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPopName();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPushName(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint name;
    name = (call.arg(0)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPushName(name);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearAccum(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat red;
    red = (call.arg(0)).toFloat();

    GLfloat green;
    green = (call.arg(1)).toFloat();

    GLfloat blue;
    blue = (call.arg(2)).toFloat();

    GLfloat alpha;
    alpha = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearAccum(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearIndex(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat c;
    c = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearIndex(c);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glIndexMask(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint mask;
    mask = (call.arg(0)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexMask(mask);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glAccum(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum op;
    op = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat value;
    value = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glAccum(op, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPopAttrib(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPopAttrib();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPushAttrib(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbitfield mask;
    mask = static_cast<GLbitfield>((call.arg(0)).toUInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPushAttrib(mask);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMap1d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLdouble u1;
    u1 = (call.arg(1)).toDouble();

    GLdouble u2;
    u2 = (call.arg(2)).toDouble();

    GLint stride;
    stride = (call.arg(3)).toSInt();

    GLint order;
    order = (call.arg(4)).toSInt();

    GLdouble * points;
    points = _allocator.allocArray<GLdouble>(&call.arg(5));
    const trace::Array *_a_GLdouble41_0 = (call.arg(5)).toArray();
    if (_a_GLdouble41_0) {
        for (size_t _jGLdouble41 = 0; _jGLdouble41 < _a_GLdouble41_0->values.size(); ++_jGLdouble41) {
    points[_jGLdouble41] = (*_a_GLdouble41_0->values[_jGLdouble41]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMap1d(target, u1, u2, stride, order, points);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMap1f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat u1;
    u1 = (call.arg(1)).toFloat();

    GLfloat u2;
    u2 = (call.arg(2)).toFloat();

    GLint stride;
    stride = (call.arg(3)).toSInt();

    GLint order;
    order = (call.arg(4)).toSInt();

    GLfloat * points;
    points = _allocator.allocArray<GLfloat>(&call.arg(5));
    const trace::Array *_a_GLfloat109_0 = (call.arg(5)).toArray();
    if (_a_GLfloat109_0) {
        for (size_t _jGLfloat109 = 0; _jGLfloat109 < _a_GLfloat109_0->values.size(); ++_jGLfloat109) {
    points[_jGLfloat109] = (*_a_GLfloat109_0->values[_jGLfloat109]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMap1f(target, u1, u2, stride, order, points);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMap2d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLdouble u1;
    u1 = (call.arg(1)).toDouble();

    GLdouble u2;
    u2 = (call.arg(2)).toDouble();

    GLint ustride;
    ustride = (call.arg(3)).toSInt();

    GLint uorder;
    uorder = (call.arg(4)).toSInt();

    GLdouble v1;
    v1 = (call.arg(5)).toDouble();

    GLdouble v2;
    v2 = (call.arg(6)).toDouble();

    GLint vstride;
    vstride = (call.arg(7)).toSInt();

    GLint vorder;
    vorder = (call.arg(8)).toSInt();

    GLdouble * points;
    points = _allocator.allocArray<GLdouble>(&call.arg(9));
    const trace::Array *_a_GLdouble42_0 = (call.arg(9)).toArray();
    if (_a_GLdouble42_0) {
        for (size_t _jGLdouble42 = 0; _jGLdouble42 < _a_GLdouble42_0->values.size(); ++_jGLdouble42) {
    points[_jGLdouble42] = (*_a_GLdouble42_0->values[_jGLdouble42]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMap2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMap2f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat u1;
    u1 = (call.arg(1)).toFloat();

    GLfloat u2;
    u2 = (call.arg(2)).toFloat();

    GLint ustride;
    ustride = (call.arg(3)).toSInt();

    GLint uorder;
    uorder = (call.arg(4)).toSInt();

    GLfloat v1;
    v1 = (call.arg(5)).toFloat();

    GLfloat v2;
    v2 = (call.arg(6)).toFloat();

    GLint vstride;
    vstride = (call.arg(7)).toSInt();

    GLint vorder;
    vorder = (call.arg(8)).toSInt();

    GLfloat * points;
    points = _allocator.allocArray<GLfloat>(&call.arg(9));
    const trace::Array *_a_GLfloat110_0 = (call.arg(9)).toArray();
    if (_a_GLfloat110_0) {
        for (size_t _jGLfloat110 = 0; _jGLfloat110 < _a_GLfloat110_0->values.size(); ++_jGLfloat110) {
    points[_jGLfloat110] = (*_a_GLfloat110_0->values[_jGLfloat110]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMap2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMapGrid1d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint un;
    un = (call.arg(0)).toSInt();

    GLdouble u1;
    u1 = (call.arg(1)).toDouble();

    GLdouble u2;
    u2 = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMapGrid1d(un, u1, u2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMapGrid1f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint un;
    un = (call.arg(0)).toSInt();

    GLfloat u1;
    u1 = (call.arg(1)).toFloat();

    GLfloat u2;
    u2 = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMapGrid1f(un, u1, u2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMapGrid2d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint un;
    un = (call.arg(0)).toSInt();

    GLdouble u1;
    u1 = (call.arg(1)).toDouble();

    GLdouble u2;
    u2 = (call.arg(2)).toDouble();

    GLint vn;
    vn = (call.arg(3)).toSInt();

    GLdouble v1;
    v1 = (call.arg(4)).toDouble();

    GLdouble v2;
    v2 = (call.arg(5)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMapGrid2d(un, u1, u2, vn, v1, v2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMapGrid2f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint un;
    un = (call.arg(0)).toSInt();

    GLfloat u1;
    u1 = (call.arg(1)).toFloat();

    GLfloat u2;
    u2 = (call.arg(2)).toFloat();

    GLint vn;
    vn = (call.arg(3)).toSInt();

    GLfloat v1;
    v1 = (call.arg(4)).toFloat();

    GLfloat v2;
    v2 = (call.arg(5)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMapGrid2f(un, u1, u2, vn, v1, v2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEvalCoord1d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble u;
    u = (call.arg(0)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEvalCoord1d(u);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEvalCoord1dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * u;
    u = _allocator.allocArray<GLdouble>(&call.arg(0));
    if (u) {
        const trace::Array *_a_PGLdouble3_0 = (call.arg(0)).toArray();
    u[0] = (*_a_PGLdouble3_0->values[0]).toDouble();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEvalCoord1dv(u);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEvalCoord1f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat u;
    u = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEvalCoord1f(u);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEvalCoord1fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * u;
    u = _allocator.allocArray<GLfloat>(&call.arg(0));
    if (u) {
        const trace::Array *_a_PGLfloat13_0 = (call.arg(0)).toArray();
    u[0] = (*_a_PGLfloat13_0->values[0]).toFloat();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEvalCoord1fv(u);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEvalCoord2d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble u;
    u = (call.arg(0)).toDouble();

    GLdouble v;
    v = (call.arg(1)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEvalCoord2d(u, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEvalCoord2dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * u;
    u = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble43_0 = (call.arg(0)).toArray();
    if (_a_GLdouble43_0) {
        for (size_t _jGLdouble43 = 0; _jGLdouble43 < _a_GLdouble43_0->values.size(); ++_jGLdouble43) {
    u[_jGLdouble43] = (*_a_GLdouble43_0->values[_jGLdouble43]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEvalCoord2dv(u);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEvalCoord2f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat u;
    u = (call.arg(0)).toFloat();

    GLfloat v;
    v = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEvalCoord2f(u, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEvalCoord2fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * u;
    u = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat111_0 = (call.arg(0)).toArray();
    if (_a_GLfloat111_0) {
        for (size_t _jGLfloat111 = 0; _jGLfloat111 < _a_GLfloat111_0->values.size(); ++_jGLfloat111) {
    u[_jGLfloat111] = (*_a_GLfloat111_0->values[_jGLfloat111]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEvalCoord2fv(u);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEvalMesh1(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint i1;
    i1 = (call.arg(1)).toSInt();

    GLint i2;
    i2 = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glEvalMesh1(mode, i1, i2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glEvalPoint1(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint i;
    i = (call.arg(0)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEvalPoint1(i);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEvalMesh2(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint i1;
    i1 = (call.arg(1)).toSInt();

    GLint i2;
    i2 = (call.arg(2)).toSInt();

    GLint j1;
    j1 = (call.arg(3)).toSInt();

    GLint j2;
    j2 = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glEvalMesh2(mode, i1, i2, j1, j2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glEvalPoint2(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint i;
    i = (call.arg(0)).toSInt();

    GLint j;
    j = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEvalPoint2(i, j);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glAlphaFunc(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum func;
    func = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat ref;
    ref = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glAlphaFunc(func, ref);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPixelZoom(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat xfactor;
    xfactor = (call.arg(0)).toFloat();

    GLfloat yfactor;
    yfactor = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPixelZoom(xfactor, yfactor);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPixelTransferf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat param;
    param = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPixelTransferf(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPixelTransferi(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint param;
    param = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPixelTransferi(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPixelMapfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum map;
    map = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei mapsize;
    mapsize = (call.arg(1)).toSInt();

    GLfloat * values;
    values = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat112_0 = (call.arg(2)).toArray();
    if (_a_GLfloat112_0) {
        for (size_t _jGLfloat112 = 0; _jGLfloat112 < _a_GLfloat112_0->values.size(); ++_jGLfloat112) {
    values[_jGLfloat112] = (*_a_GLfloat112_0->values[_jGLfloat112]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPixelMapfv(map, mapsize, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPixelMapuiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum map;
    map = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei mapsize;
    mapsize = (call.arg(1)).toSInt();

    GLuint * values;
    values = _allocator.allocArray<GLuint>(&call.arg(2));
    const trace::Array *_a_GLuint83_0 = (call.arg(2)).toArray();
    if (_a_GLuint83_0) {
        for (size_t _jGLuint83 = 0; _jGLuint83 < _a_GLuint83_0->values.size(); ++_jGLuint83) {
    values[_jGLuint83] = (*_a_GLuint83_0->values[_jGLuint83]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPixelMapuiv(map, mapsize, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPixelMapusv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum map;
    map = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei mapsize;
    mapsize = (call.arg(1)).toSInt();

    GLushort * values;
    values = _allocator.allocArray<GLushort>(&call.arg(2));
    const trace::Array *_a_GLushort5_0 = (call.arg(2)).toArray();
    if (_a_GLushort5_0) {
        for (size_t _jGLushort5 = 0; _jGLushort5 < _a_GLushort5_0->values.size(); ++_jGLushort5) {
    values[_jGLushort5] = (*_a_GLushort5_0->values[_jGLushort5]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPixelMapusv(map, mapsize, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyPixels(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    GLsizei width;
    width = (call.arg(2)).toSInt();

    GLsizei height;
    height = (call.arg(3)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(4)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyPixels(x, y, width, height, type);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDrawPixels(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei width;
    width = (call.arg(0)).toSInt();

    GLsizei height;
    height = (call.arg(1)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(3)).toSInt());

    GLvoid * pixels;
    pixels = static_cast<GLvoid *>((call.arg(4)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDrawPixels(width, height, format, type, pixels);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glGetPixelMapfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum map;
    map = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat * values;
    values = static_cast<GLfloat *>((call.arg(1)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetPixelMapfv(map, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aPGLfloat1 = (call.arg(1)).toArray();
    if (_aPGLfloat1) {
    }
}

static void retrace_glGetPixelMapuiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum map;
    map = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint * values;
    values = static_cast<GLuint *>((call.arg(1)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetPixelMapuiv(map, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aPGLuint21 = (call.arg(1)).toArray();
    if (_aPGLuint21) {
    }
}

static void retrace_glGetPixelMapusv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum map;
    map = static_cast<GLenum>((call.arg(0)).toSInt());

    GLushort * values;
    values = static_cast<GLushort *>((call.arg(1)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetPixelMapusv(map, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aPGLushort = (call.arg(1)).toArray();
    if (_aPGLushort) {
    }
}

static void retrace_glGetPolygonStipple(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLubyte * mask;
    mask = static_cast<GLubyte *>((call.arg(0)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetPolygonStipple(mask);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFrustum(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble left;
    left = (call.arg(0)).toDouble();

    GLdouble right;
    right = (call.arg(1)).toDouble();

    GLdouble bottom;
    bottom = (call.arg(2)).toDouble();

    GLdouble top;
    top = (call.arg(3)).toDouble();

    GLdouble zNear;
    zNear = (call.arg(4)).toDouble();

    GLdouble zFar;
    zFar = (call.arg(5)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFrustum(left, right, bottom, top, zNear, zFar);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLoadIdentity(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLoadIdentity();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLoadMatrixf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * m;
    m = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat113_0 = (call.arg(0)).toArray();
    if (_a_GLfloat113_0) {
        for (size_t _jGLfloat113 = 0; _jGLfloat113 < _a_GLfloat113_0->values.size(); ++_jGLfloat113) {
    m[_jGLfloat113] = (*_a_GLfloat113_0->values[_jGLfloat113]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLoadMatrixf(m);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLoadMatrixd(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * m;
    m = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble44_0 = (call.arg(0)).toArray();
    if (_a_GLdouble44_0) {
        for (size_t _jGLdouble44 = 0; _jGLdouble44 < _a_GLdouble44_0->values.size(); ++_jGLdouble44) {
    m[_jGLdouble44] = (*_a_GLdouble44_0->values[_jGLdouble44]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLoadMatrixd(m);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMatrixMode(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMatrixMode(mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultMatrixf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * m;
    m = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat114_0 = (call.arg(0)).toArray();
    if (_a_GLfloat114_0) {
        for (size_t _jGLfloat114 = 0; _jGLfloat114 < _a_GLfloat114_0->values.size(); ++_jGLfloat114) {
    m[_jGLfloat114] = (*_a_GLfloat114_0->values[_jGLfloat114]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultMatrixf(m);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultMatrixd(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * m;
    m = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble45_0 = (call.arg(0)).toArray();
    if (_a_GLdouble45_0) {
        for (size_t _jGLdouble45 = 0; _jGLdouble45 < _a_GLdouble45_0->values.size(); ++_jGLdouble45) {
    m[_jGLdouble45] = (*_a_GLdouble45_0->values[_jGLdouble45]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultMatrixd(m);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glOrtho(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble left;
    left = (call.arg(0)).toDouble();

    GLdouble right;
    right = (call.arg(1)).toDouble();

    GLdouble bottom;
    bottom = (call.arg(2)).toDouble();

    GLdouble top;
    top = (call.arg(3)).toDouble();

    GLdouble zNear;
    zNear = (call.arg(4)).toDouble();

    GLdouble zFar;
    zFar = (call.arg(5)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glOrtho(left, right, bottom, top, zNear, zFar);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPopMatrix(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPopMatrix();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPushMatrix(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPushMatrix();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRotated(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble angle;
    angle = (call.arg(0)).toDouble();

    GLdouble x;
    x = (call.arg(1)).toDouble();

    GLdouble y;
    y = (call.arg(2)).toDouble();

    GLdouble z;
    z = (call.arg(3)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRotated(angle, x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRotatef(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat angle;
    angle = (call.arg(0)).toFloat();

    GLfloat x;
    x = (call.arg(1)).toFloat();

    GLfloat y;
    y = (call.arg(2)).toFloat();

    GLfloat z;
    z = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRotatef(angle, x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glScaled(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble x;
    x = (call.arg(0)).toDouble();

    GLdouble y;
    y = (call.arg(1)).toDouble();

    GLdouble z;
    z = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glScaled(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glScalef(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat x;
    x = (call.arg(0)).toFloat();

    GLfloat y;
    y = (call.arg(1)).toFloat();

    GLfloat z;
    z = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glScalef(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTranslated(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble x;
    x = (call.arg(0)).toDouble();

    GLdouble y;
    y = (call.arg(1)).toDouble();

    GLdouble z;
    z = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTranslated(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTranslatef(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat x;
    x = (call.arg(0)).toFloat();

    GLfloat y;
    y = (call.arg(1)).toFloat();

    GLfloat z;
    z = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTranslatef(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDrawArrays(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint first;
    first = (call.arg(1)).toSInt();

    GLsizei count;
    count = (call.arg(2)).toSInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDrawArrays(mode, first, count);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glDrawElements(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _element_array_buffer = 0;
        glGetIntegerv(GL_ELEMENT_ARRAY_BUFFER_BINDING, &_element_array_buffer);
        if (!_element_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    const GLvoid * indices;
    indices = static_cast<const GLvoid *>((call.arg(3)).toPointer());

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDrawElements(mode, count, type, indices);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glPolygonOffset(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat factor;
    factor = (call.arg(0)).toFloat();

    GLfloat units;
    units = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPolygonOffset(factor, units);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyTexImage1D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLint x;
    x = (call.arg(3)).toSInt();

    GLint y;
    y = (call.arg(4)).toSInt();

    GLsizei width;
    width = (call.arg(5)).toSInt();

    GLint border;
    border = (call.arg(6)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyTexImage1D(target, level, internalformat, x, y, width, border);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyTexImage2D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLint x;
    x = (call.arg(3)).toSInt();

    GLint y;
    y = (call.arg(4)).toSInt();

    GLsizei width;
    width = (call.arg(5)).toSInt();

    GLsizei height;
    height = (call.arg(6)).toSInt();

    GLint border;
    border = (call.arg(7)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyTexSubImage1D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint xoffset;
    xoffset = (call.arg(2)).toSInt();

    GLint x;
    x = (call.arg(3)).toSInt();

    GLint y;
    y = (call.arg(4)).toSInt();

    GLsizei width;
    width = (call.arg(5)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyTexSubImage1D(target, level, xoffset, x, y, width);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyTexSubImage2D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint xoffset;
    xoffset = (call.arg(2)).toSInt();

    GLint yoffset;
    yoffset = (call.arg(3)).toSInt();

    GLint x;
    x = (call.arg(4)).toSInt();

    GLint y;
    y = (call.arg(5)).toSInt();

    GLsizei width;
    width = (call.arg(6)).toSInt();

    GLsizei height;
    height = (call.arg(7)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexSubImage1D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint xoffset;
    xoffset = (call.arg(2)).toSInt();

    GLsizei width;
    width = (call.arg(3)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(4)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(5)).toSInt());

    GLvoid * pixels;
    pixels = static_cast<GLvoid *>((call.arg(6)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexSubImage1D(target, level, xoffset, width, format, type, pixels);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexSubImage2D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint xoffset;
    xoffset = (call.arg(2)).toSInt();

    GLint yoffset;
    yoffset = (call.arg(3)).toSInt();

    GLsizei width;
    width = (call.arg(4)).toSInt();

    GLsizei height;
    height = (call.arg(5)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(6)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(7)).toSInt());

    GLvoid * pixels;
    pixels = static_cast<GLvoid *>((call.arg(8)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBindTexture(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint texture;
    texture = (call.arg(1)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(texture) << " <- " << size_t(_texture_map[texture]) << "\n";
    }
    texture = _texture_map[texture];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBindTexture(target, texture);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDeleteTextures(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * textures;
    textures = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint84_0 = (call.arg(1)).toArray();
    if (_a_GLuint84_0) {
        for (size_t _jGLuint84 = 0; _jGLuint84 < _a_GLuint84_0->values.size(); ++_jGLuint84) {
    textures[_jGLuint84] = (*_a_GLuint84_0->values[_jGLuint84]).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(textures[_jGLuint84]) << " <- " << size_t(_texture_map[textures[_jGLuint84]]) << "\n";
    }
    textures[_jGLuint84] = _texture_map[textures[_jGLuint84]];
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeleteTextures(n, textures);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGenTextures(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * textures;
    textures = _allocator.allocArray<GLuint>(&call.arg(1));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGenTextures(n, textures);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint86 = (call.arg(1)).toArray();
    if (_aGLuint86) {
        for (size_t _jGLuint86 = 0; _jGLuint86 < _aGLuint86->values.size(); ++_jGLuint86) {
    GLuint _origResult;
    _origResult = (*_aGLuint86->values[_jGLuint86]).toUInt();
    _texture_map[_origResult] = textures[_jGLuint86];
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << _origResult << " -> " << textures[_jGLuint86] << "\n";
    }
        }
    }
}

static void retrace_glArrayElement(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint i;
    i = (call.arg(0)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glArrayElement(i);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColorPointer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint size;
    size = static_cast<GLint>((call.arg(0)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(1)).toSInt());

    GLsizei stride;
    stride = (call.arg(2)).toSInt();

    const GLvoid * pointer;
    pointer = static_cast<const GLvoid *>(retrace::toPointer(call.arg(3), true));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColorPointer(size, type, stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDisableClientState(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum array;
    array = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDisableClientState(array);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEdgeFlagPointer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei stride;
    stride = (call.arg(0)).toSInt();

    const GLvoid * pointer;
    pointer = static_cast<const GLvoid *>(retrace::toPointer(call.arg(1), true));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEdgeFlagPointer(stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEnableClientState(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum array;
    array = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEnableClientState(array);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glIndexPointer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum type;
    type = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei stride;
    stride = (call.arg(1)).toSInt();

    const GLvoid * pointer;
    pointer = static_cast<const GLvoid *>(retrace::toPointer(call.arg(2), true));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexPointer(type, stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glInterleavedArrays(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum format;
    format = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei stride;
    stride = (call.arg(1)).toSInt();

    const GLvoid * pointer;
    pointer = static_cast<const GLvoid *>(retrace::toPointer(call.arg(2), true));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glInterleavedArrays(format, stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormalPointer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum type;
    type = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei stride;
    stride = (call.arg(1)).toSInt();

    const GLvoid * pointer;
    pointer = static_cast<const GLvoid *>(retrace::toPointer(call.arg(2), true));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormalPointer(type, stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexCoordPointer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint size;
    size = (call.arg(0)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(1)).toSInt());

    GLsizei stride;
    stride = (call.arg(2)).toSInt();

    const GLvoid * pointer;
    pointer = static_cast<const GLvoid *>(retrace::toPointer(call.arg(3), true));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexCoordPointer(size, type, stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexPointer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint size;
    size = (call.arg(0)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(1)).toSInt());

    GLsizei stride;
    stride = (call.arg(2)).toSInt();

    const GLvoid * pointer;
    pointer = static_cast<const GLvoid *>(retrace::toPointer(call.arg(3), true));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexPointer(size, type, stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPrioritizeTextures(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * textures;
    textures = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint87_0 = (call.arg(1)).toArray();
    if (_a_GLuint87_0) {
        for (size_t _jGLuint87 = 0; _jGLuint87 < _a_GLuint87_0->values.size(); ++_jGLuint87) {
    textures[_jGLuint87] = (*_a_GLuint87_0->values[_jGLuint87]).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(textures[_jGLuint87]) << " <- " << size_t(_texture_map[textures[_jGLuint87]]) << "\n";
    }
    textures[_jGLuint87] = _texture_map[textures[_jGLuint87]];
        }
    }

    GLclampf * priorities;
    priorities = _allocator.allocArray<GLclampf>(&call.arg(2));
    const trace::Array *_a_GLclampf1_0 = (call.arg(2)).toArray();
    if (_a_GLclampf1_0) {
        for (size_t _jGLclampf1 = 0; _jGLclampf1 < _a_GLclampf1_0->values.size(); ++_jGLclampf1) {
    priorities[_jGLclampf1] = (*_a_GLclampf1_0->values[_jGLclampf1]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPrioritizeTextures(n, textures, priorities);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glIndexub(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLubyte c;
    c = (call.arg(0)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexub(c);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glIndexubv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLubyte * c;
    c = _allocator.allocArray<GLubyte>(&call.arg(0));
    if (c) {
        const trace::Array *_a_PGLubyte1_0 = (call.arg(0)).toArray();
    c[0] = (*_a_PGLubyte1_0->values[0]).toUInt();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glIndexubv(c);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPopClientAttrib(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPopClientAttrib();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPushClientAttrib(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbitfield mask;
    mask = static_cast<GLbitfield>((call.arg(0)).toUInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPushClientAttrib(mask);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendColor(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat red;
    red = (call.arg(0)).toFloat();

    GLfloat green;
    green = (call.arg(1)).toFloat();

    GLfloat blue;
    blue = (call.arg(2)).toFloat();

    GLfloat alpha;
    alpha = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendColor(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendEquation(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendEquation(mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDrawRangeElements(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _element_array_buffer = 0;
        glGetIntegerv(GL_ELEMENT_ARRAY_BUFFER_BINDING, &_element_array_buffer);
        if (!_element_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint start;
    start = (call.arg(1)).toUInt();

    GLuint end;
    end = (call.arg(2)).toUInt();

    GLsizei count;
    count = (call.arg(3)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(4)).toSInt());

    const GLvoid * indices;
    indices = static_cast<const GLvoid *>((call.arg(5)).toPointer());

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDrawRangeElements(mode, start, end, count, type, indices);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glTexImage3D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint internalformat;
    internalformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei width;
    width = (call.arg(3)).toSInt();

    GLsizei height;
    height = (call.arg(4)).toSInt();

    GLsizei depth;
    depth = (call.arg(5)).toSInt();

    GLint border;
    border = (call.arg(6)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(7)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(8)).toSInt());

    GLvoid * pixels;
    pixels = static_cast<GLvoid *>((call.arg(9)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexSubImage3D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint xoffset;
    xoffset = (call.arg(2)).toSInt();

    GLint yoffset;
    yoffset = (call.arg(3)).toSInt();

    GLint zoffset;
    zoffset = (call.arg(4)).toSInt();

    GLsizei width;
    width = (call.arg(5)).toSInt();

    GLsizei height;
    height = (call.arg(6)).toSInt();

    GLsizei depth;
    depth = (call.arg(7)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(8)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(9)).toSInt());

    GLvoid * pixels;
    pixels = static_cast<GLvoid *>((call.arg(10)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyTexSubImage3D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint xoffset;
    xoffset = (call.arg(2)).toSInt();

    GLint yoffset;
    yoffset = (call.arg(3)).toSInt();

    GLint zoffset;
    zoffset = (call.arg(4)).toSInt();

    GLint x;
    x = (call.arg(5)).toSInt();

    GLint y;
    y = (call.arg(6)).toSInt();

    GLsizei width;
    width = (call.arg(7)).toSInt();

    GLsizei height;
    height = (call.arg(8)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColorTable(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLsizei width;
    width = (call.arg(2)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(3)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(4)).toSInt());

    GLvoid * table;
    table = static_cast<GLvoid *>((call.arg(5)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColorTable(target, internalformat, width, format, type, table);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColorTableParameterfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat * params;
    params = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat115_0 = (call.arg(2)).toArray();
    if (_a_GLfloat115_0) {
        for (size_t _jGLfloat115 = 0; _jGLfloat115 < _a_GLfloat115_0->values.size(); ++_jGLfloat115) {
    params[_jGLfloat115] = (*_a_GLfloat115_0->values[_jGLfloat115]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColorTableParameterfv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColorTableParameteriv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint * params;
    params = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint150_0 = (call.arg(2)).toArray();
    if (_a_GLint150_0) {
        for (size_t _jGLint150 = 0; _jGLint150 < _a_GLint150_0->values.size(); ++_jGLint150) {
    params[_jGLint150] = (*_a_GLint150_0->values[_jGLint150]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColorTableParameteriv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyColorTable(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint x;
    x = (call.arg(2)).toSInt();

    GLint y;
    y = (call.arg(3)).toSInt();

    GLsizei width;
    width = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyColorTable(target, internalformat, x, y, width);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColorSubTable(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei start;
    start = (call.arg(1)).toSInt();

    GLsizei count;
    count = (call.arg(2)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(3)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(4)).toSInt());

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(5)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColorSubTable(target, start, count, format, type, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyColorSubTable(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei start;
    start = (call.arg(1)).toSInt();

    GLint x;
    x = (call.arg(2)).toSInt();

    GLint y;
    y = (call.arg(3)).toSInt();

    GLsizei width;
    width = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyColorSubTable(target, start, x, y, width);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glConvolutionFilter1D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLsizei width;
    width = (call.arg(2)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(3)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(4)).toSInt());

    GLvoid * image;
    image = static_cast<GLvoid *>((call.arg(5)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glConvolutionFilter1D(target, internalformat, width, format, type, image);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glConvolutionFilter2D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLsizei width;
    width = (call.arg(2)).toSInt();

    GLsizei height;
    height = (call.arg(3)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(4)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(5)).toSInt());

    GLvoid * image;
    image = static_cast<GLvoid *>((call.arg(6)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glConvolutionFilter2D(target, internalformat, width, height, format, type, image);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glConvolutionParameterf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat params;
    params = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glConvolutionParameterf(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glConvolutionParameterfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfloat * params;
    params = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat116_0 = (call.arg(2)).toArray();
    if (_a_GLfloat116_0) {
        for (size_t _jGLfloat116 = 0; _jGLfloat116 < _a_GLfloat116_0->values.size(); ++_jGLfloat116) {
    params[_jGLfloat116] = (*_a_GLfloat116_0->values[_jGLfloat116]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glConvolutionParameterfv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glConvolutionParameteri(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint params;
    params = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glConvolutionParameteri(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glConvolutionParameteriv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint * params;
    params = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint151_0 = (call.arg(2)).toArray();
    if (_a_GLint151_0) {
        for (size_t _jGLint151 = 0; _jGLint151 < _a_GLint151_0->values.size(); ++_jGLint151) {
    params[_jGLint151] = (*_a_GLint151_0->values[_jGLint151]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glConvolutionParameteriv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyConvolutionFilter1D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint x;
    x = (call.arg(2)).toSInt();

    GLint y;
    y = (call.arg(3)).toSInt();

    GLsizei width;
    width = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyConvolutionFilter1D(target, internalformat, x, y, width);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyConvolutionFilter2D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint x;
    x = (call.arg(2)).toSInt();

    GLint y;
    y = (call.arg(3)).toSInt();

    GLsizei width;
    width = (call.arg(4)).toSInt();

    GLsizei height;
    height = (call.arg(5)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyConvolutionFilter2D(target, internalformat, x, y, width, height);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetConvolutionFilter(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum format;
    format = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    GLvoid * image;
    image = static_cast<GLvoid *>((call.arg(3)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetConvolutionFilter(target, format, type, image);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetSeparableFilter(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum format;
    format = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    GLvoid * row;
    row = static_cast<GLvoid *>((call.arg(3)).toPointer());

    GLvoid * column;
    column = static_cast<GLvoid *>((call.arg(4)).toPointer());

    GLvoid * span;
    span = static_cast<GLvoid *>((call.arg(5)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetSeparableFilter(target, format, type, row, column, span);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSeparableFilter2D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLsizei width;
    width = (call.arg(2)).toSInt();

    GLsizei height;
    height = (call.arg(3)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(4)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(5)).toSInt());

    GLvoid * row;
    row = static_cast<GLvoid *>((call.arg(6)).toPointer());

    GLvoid * column;
    column = static_cast<GLvoid *>((call.arg(7)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSeparableFilter2D(target, internalformat, width, height, format, type, row, column);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetHistogram(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLboolean reset;
    reset = static_cast<GLboolean>((call.arg(1)).toSInt());

    GLenum format;
    format = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(3)).toSInt());

    GLvoid * values;
    values = static_cast<GLvoid *>((call.arg(4)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetHistogram(target, reset, format, type, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetMinmax(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLboolean reset;
    reset = static_cast<GLboolean>((call.arg(1)).toSInt());

    GLenum format;
    format = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(3)).toSInt());

    GLvoid * values;
    values = static_cast<GLvoid *>((call.arg(4)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetMinmax(target, reset, format, type, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glHistogram(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei width;
    width = (call.arg(1)).toSInt();

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLboolean sink;
    sink = static_cast<GLboolean>((call.arg(3)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glHistogram(target, width, internalformat, sink);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMinmax(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLboolean sink;
    sink = static_cast<GLboolean>((call.arg(2)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMinmax(target, internalformat, sink);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glResetHistogram(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glResetHistogram(target);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glResetMinmax(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glResetMinmax(target);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glActiveTexture(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum texture;
    texture = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glActiveTexture(texture);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSampleCoverage(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat value;
    value = (call.arg(0)).toFloat();

    GLboolean invert;
    invert = static_cast<GLboolean>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSampleCoverage(value, invert);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCompressedTexImage3D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei width;
    width = (call.arg(3)).toSInt();

    GLsizei height;
    height = (call.arg(4)).toSInt();

    GLsizei depth;
    depth = (call.arg(5)).toSInt();

    GLint border;
    border = (call.arg(6)).toSInt();

    GLsizei imageSize;
    imageSize = (call.arg(7)).toSInt();

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(8)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCompressedTexImage2D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei width;
    width = (call.arg(3)).toSInt();

    GLsizei height;
    height = (call.arg(4)).toSInt();

    GLint border;
    border = (call.arg(5)).toSInt();

    GLsizei imageSize;
    imageSize = (call.arg(6)).toSInt();

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(7)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCompressedTexImage1D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei width;
    width = (call.arg(3)).toSInt();

    GLint border;
    border = (call.arg(4)).toSInt();

    GLsizei imageSize;
    imageSize = (call.arg(5)).toSInt();

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(6)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCompressedTexImage1D(target, level, internalformat, width, border, imageSize, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCompressedTexSubImage3D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint xoffset;
    xoffset = (call.arg(2)).toSInt();

    GLint yoffset;
    yoffset = (call.arg(3)).toSInt();

    GLint zoffset;
    zoffset = (call.arg(4)).toSInt();

    GLsizei width;
    width = (call.arg(5)).toSInt();

    GLsizei height;
    height = (call.arg(6)).toSInt();

    GLsizei depth;
    depth = (call.arg(7)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(8)).toSInt());

    GLsizei imageSize;
    imageSize = (call.arg(9)).toSInt();

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(10)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCompressedTexSubImage2D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint xoffset;
    xoffset = (call.arg(2)).toSInt();

    GLint yoffset;
    yoffset = (call.arg(3)).toSInt();

    GLsizei width;
    width = (call.arg(4)).toSInt();

    GLsizei height;
    height = (call.arg(5)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(6)).toSInt());

    GLsizei imageSize;
    imageSize = (call.arg(7)).toSInt();

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(8)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCompressedTexSubImage1D(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint xoffset;
    xoffset = (call.arg(2)).toSInt();

    GLsizei width;
    width = (call.arg(3)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(4)).toSInt());

    GLsizei imageSize;
    imageSize = (call.arg(5)).toSInt();

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(6)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCompressedTexSubImage1D(target, level, xoffset, width, format, imageSize, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetCompressedTexImage(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLvoid * img;
    img = static_cast<GLvoid *>((call.arg(2)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetCompressedTexImage(target, level, img);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClientActiveTexture(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum texture;
    texture = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClientActiveTexture(texture);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord1d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLdouble s;
    s = (call.arg(1)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord1d(target, s);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord1dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(1));
    if (v) {
        const trace::Array *_a_PGLdouble4_0 = (call.arg(1)).toArray();
    v[0] = (*_a_PGLdouble4_0->values[0]).toDouble();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord1dv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord1f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat s;
    s = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord1f(target, s);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord1fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(1));
    if (v) {
        const trace::Array *_a_PGLfloat14_0 = (call.arg(1)).toArray();
    v[0] = (*_a_PGLfloat14_0->values[0]).toFloat();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord1fv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord1i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint s;
    s = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord1i(target, s);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord1iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(1));
    if (v) {
        const trace::Array *_a_PGLint31_0 = (call.arg(1)).toArray();
    v[0] = (*_a_PGLint31_0->values[0]).toSInt();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord1iv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord1s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLshort s;
    s = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord1s(target, s);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord1sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(1));
    if (v) {
        const trace::Array *_a_PGLshort2_0 = (call.arg(1)).toArray();
    v[0] = (*_a_PGLshort2_0->values[0]).toSInt();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord1sv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord2d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLdouble s;
    s = (call.arg(1)).toDouble();

    GLdouble t;
    t = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord2d(target, s, t);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord2dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(1));
    const trace::Array *_a_GLdouble46_0 = (call.arg(1)).toArray();
    if (_a_GLdouble46_0) {
        for (size_t _jGLdouble46 = 0; _jGLdouble46 < _a_GLdouble46_0->values.size(); ++_jGLdouble46) {
    v[_jGLdouble46] = (*_a_GLdouble46_0->values[_jGLdouble46]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord2dv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord2f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat s;
    s = (call.arg(1)).toFloat();

    GLfloat t;
    t = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord2f(target, s, t);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord2fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(1));
    const trace::Array *_a_GLfloat117_0 = (call.arg(1)).toArray();
    if (_a_GLfloat117_0) {
        for (size_t _jGLfloat117 = 0; _jGLfloat117 < _a_GLfloat117_0->values.size(); ++_jGLfloat117) {
    v[_jGLfloat117] = (*_a_GLfloat117_0->values[_jGLfloat117]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord2fv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord2i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint s;
    s = (call.arg(1)).toSInt();

    GLint t;
    t = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord2i(target, s, t);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord2iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint152_0 = (call.arg(1)).toArray();
    if (_a_GLint152_0) {
        for (size_t _jGLint152 = 0; _jGLint152 < _a_GLint152_0->values.size(); ++_jGLint152) {
    v[_jGLint152] = (*_a_GLint152_0->values[_jGLint152]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord2iv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord2s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLshort s;
    s = (call.arg(1)).toSInt();

    GLshort t;
    t = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord2s(target, s, t);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord2sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(1));
    const trace::Array *_a_GLshort15_0 = (call.arg(1)).toArray();
    if (_a_GLshort15_0) {
        for (size_t _jGLshort15 = 0; _jGLshort15 < _a_GLshort15_0->values.size(); ++_jGLshort15) {
    v[_jGLshort15] = (*_a_GLshort15_0->values[_jGLshort15]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord2sv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord3d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLdouble s;
    s = (call.arg(1)).toDouble();

    GLdouble t;
    t = (call.arg(2)).toDouble();

    GLdouble r;
    r = (call.arg(3)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord3d(target, s, t, r);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord3dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(1));
    const trace::Array *_a_GLdouble47_0 = (call.arg(1)).toArray();
    if (_a_GLdouble47_0) {
        for (size_t _jGLdouble47 = 0; _jGLdouble47 < _a_GLdouble47_0->values.size(); ++_jGLdouble47) {
    v[_jGLdouble47] = (*_a_GLdouble47_0->values[_jGLdouble47]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord3dv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord3f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat s;
    s = (call.arg(1)).toFloat();

    GLfloat t;
    t = (call.arg(2)).toFloat();

    GLfloat r;
    r = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord3f(target, s, t, r);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(1));
    const trace::Array *_a_GLfloat118_0 = (call.arg(1)).toArray();
    if (_a_GLfloat118_0) {
        for (size_t _jGLfloat118 = 0; _jGLfloat118 < _a_GLfloat118_0->values.size(); ++_jGLfloat118) {
    v[_jGLfloat118] = (*_a_GLfloat118_0->values[_jGLfloat118]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord3fv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord3i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint s;
    s = (call.arg(1)).toSInt();

    GLint t;
    t = (call.arg(2)).toSInt();

    GLint r;
    r = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord3i(target, s, t, r);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord3iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint153_0 = (call.arg(1)).toArray();
    if (_a_GLint153_0) {
        for (size_t _jGLint153 = 0; _jGLint153 < _a_GLint153_0->values.size(); ++_jGLint153) {
    v[_jGLint153] = (*_a_GLint153_0->values[_jGLint153]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord3iv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord3s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLshort s;
    s = (call.arg(1)).toSInt();

    GLshort t;
    t = (call.arg(2)).toSInt();

    GLshort r;
    r = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord3s(target, s, t, r);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord3sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(1));
    const trace::Array *_a_GLshort16_0 = (call.arg(1)).toArray();
    if (_a_GLshort16_0) {
        for (size_t _jGLshort16 = 0; _jGLshort16 < _a_GLshort16_0->values.size(); ++_jGLshort16) {
    v[_jGLshort16] = (*_a_GLshort16_0->values[_jGLshort16]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord3sv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord4d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLdouble s;
    s = (call.arg(1)).toDouble();

    GLdouble t;
    t = (call.arg(2)).toDouble();

    GLdouble r;
    r = (call.arg(3)).toDouble();

    GLdouble q;
    q = (call.arg(4)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord4d(target, s, t, r, q);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord4dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(1));
    const trace::Array *_a_GLdouble48_0 = (call.arg(1)).toArray();
    if (_a_GLdouble48_0) {
        for (size_t _jGLdouble48 = 0; _jGLdouble48 < _a_GLdouble48_0->values.size(); ++_jGLdouble48) {
    v[_jGLdouble48] = (*_a_GLdouble48_0->values[_jGLdouble48]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord4dv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord4f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat s;
    s = (call.arg(1)).toFloat();

    GLfloat t;
    t = (call.arg(2)).toFloat();

    GLfloat r;
    r = (call.arg(3)).toFloat();

    GLfloat q;
    q = (call.arg(4)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord4f(target, s, t, r, q);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord4fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(1));
    const trace::Array *_a_GLfloat119_0 = (call.arg(1)).toArray();
    if (_a_GLfloat119_0) {
        for (size_t _jGLfloat119 = 0; _jGLfloat119 < _a_GLfloat119_0->values.size(); ++_jGLfloat119) {
    v[_jGLfloat119] = (*_a_GLfloat119_0->values[_jGLfloat119]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord4fv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord4i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint s;
    s = (call.arg(1)).toSInt();

    GLint t;
    t = (call.arg(2)).toSInt();

    GLint r;
    r = (call.arg(3)).toSInt();

    GLint q;
    q = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord4i(target, s, t, r, q);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord4iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint154_0 = (call.arg(1)).toArray();
    if (_a_GLint154_0) {
        for (size_t _jGLint154 = 0; _jGLint154 < _a_GLint154_0->values.size(); ++_jGLint154) {
    v[_jGLint154] = (*_a_GLint154_0->values[_jGLint154]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord4iv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord4s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLshort s;
    s = (call.arg(1)).toSInt();

    GLshort t;
    t = (call.arg(2)).toSInt();

    GLshort r;
    r = (call.arg(3)).toSInt();

    GLshort q;
    q = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord4s(target, s, t, r, q);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord4sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(1));
    const trace::Array *_a_GLshort17_0 = (call.arg(1)).toArray();
    if (_a_GLshort17_0) {
        for (size_t _jGLshort17 = 0; _jGLshort17 < _a_GLshort17_0->values.size(); ++_jGLshort17) {
    v[_jGLshort17] = (*_a_GLshort17_0->values[_jGLshort17]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord4sv(target, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLoadTransposeMatrixf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * m;
    m = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat120_0 = (call.arg(0)).toArray();
    if (_a_GLfloat120_0) {
        for (size_t _jGLfloat120 = 0; _jGLfloat120 < _a_GLfloat120_0->values.size(); ++_jGLfloat120) {
    m[_jGLfloat120] = (*_a_GLfloat120_0->values[_jGLfloat120]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLoadTransposeMatrixf(m);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLoadTransposeMatrixd(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * m;
    m = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble49_0 = (call.arg(0)).toArray();
    if (_a_GLdouble49_0) {
        for (size_t _jGLdouble49 = 0; _jGLdouble49 < _a_GLdouble49_0->values.size(); ++_jGLdouble49) {
    m[_jGLdouble49] = (*_a_GLdouble49_0->values[_jGLdouble49]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLoadTransposeMatrixd(m);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultTransposeMatrixf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * m;
    m = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat121_0 = (call.arg(0)).toArray();
    if (_a_GLfloat121_0) {
        for (size_t _jGLfloat121 = 0; _jGLfloat121 < _a_GLfloat121_0->values.size(); ++_jGLfloat121) {
    m[_jGLfloat121] = (*_a_GLfloat121_0->values[_jGLfloat121]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultTransposeMatrixf(m);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultTransposeMatrixd(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * m;
    m = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble50_0 = (call.arg(0)).toArray();
    if (_a_GLdouble50_0) {
        for (size_t _jGLdouble50 = 0; _jGLdouble50 < _a_GLdouble50_0->values.size(); ++_jGLdouble50) {
    m[_jGLdouble50] = (*_a_GLdouble50_0->values[_jGLdouble50]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultTransposeMatrixd(m);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendFuncSeparate(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum sfactorRGB;
    sfactorRGB = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum dfactorRGB;
    dfactorRGB = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum sfactorAlpha;
    sfactorAlpha = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum dfactorAlpha;
    dfactorAlpha = static_cast<GLenum>((call.arg(3)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiDrawArrays(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint * first;
    first = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint155_0 = (call.arg(1)).toArray();
    if (_a_GLint155_0) {
        for (size_t _jGLint155 = 0; _jGLint155 < _a_GLint155_0->values.size(); ++_jGLint155) {
    first[_jGLint155] = (*_a_GLint155_0->values[_jGLint155]).toSInt();
        }
    }

    GLsizei * count;
    count = _allocator.allocArray<GLsizei>(&call.arg(2));
    const trace::Array *_a_GLsizei5_0 = (call.arg(2)).toArray();
    if (_a_GLsizei5_0) {
        for (size_t _jGLsizei5 = 0; _jGLsizei5 < _a_GLsizei5_0->values.size(); ++_jGLsizei5) {
    count[_jGLsizei5] = (*_a_GLsizei5_0->values[_jGLsizei5]).toSInt();
        }
    }

    GLsizei drawcount;
    drawcount = (call.arg(3)).toSInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glMultiDrawArrays(mode, first, count, drawcount);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glMultiDrawElements(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _element_array_buffer = 0;
        glGetIntegerv(GL_ELEMENT_ARRAY_BUFFER_BINDING, &_element_array_buffer);
        if (!_element_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei * count;
    count = _allocator.allocArray<GLsizei>(&call.arg(1));
    const trace::Array *_a_GLsizei6_0 = (call.arg(1)).toArray();
    if (_a_GLsizei6_0) {
        for (size_t _jGLsizei6 = 0; _jGLsizei6 < _a_GLsizei6_0->values.size(); ++_jGLsizei6) {
    count[_jGLsizei6] = (*_a_GLsizei6_0->values[_jGLsizei6]).toSInt();
        }
    }

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    const GLvoid * * indices;
    indices = _allocator.allocArray<const GLvoid *>(&call.arg(3));
    const trace::Array *_a_constGLvoid222_0 = (call.arg(3)).toArray();
    if (_a_constGLvoid222_0) {
        for (size_t _jconstGLvoid222 = 0; _jconstGLvoid222 < _a_constGLvoid222_0->values.size(); ++_jconstGLvoid222) {
    indices[_jconstGLvoid222] = static_cast<const GLvoid *>((*_a_constGLvoid222_0->values[_jconstGLvoid222]).toPointer());
        }
    }

    GLsizei drawcount;
    drawcount = (call.arg(4)).toSInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glMultiDrawElements(mode, count, type, indices, drawcount);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glPointParameterf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat param;
    param = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPointParameterf(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPointParameterfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat * params;
    params = _allocator.allocArray<GLfloat>(&call.arg(1));
    const trace::Array *_a_GLfloat122_0 = (call.arg(1)).toArray();
    if (_a_GLfloat122_0) {
        for (size_t _jGLfloat122 = 0; _jGLfloat122 < _a_GLfloat122_0->values.size(); ++_jGLfloat122) {
    params[_jGLfloat122] = (*_a_GLfloat122_0->values[_jGLfloat122]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPointParameterfv(pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPointParameteri(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint param;
    param = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPointParameteri(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPointParameteriv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint * params;
    params = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint156_0 = (call.arg(1)).toArray();
    if (_a_GLint156_0) {
        for (size_t _jGLint156 = 0; _jGLint156 < _a_GLint156_0->values.size(); ++_jGLint156) {
    params[_jGLint156] = (*_a_GLint156_0->values[_jGLint156]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPointParameteriv(pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFogCoordf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat coord;
    coord = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFogCoordf(coord);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFogCoordfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * coord;
    coord = _allocator.allocArray<GLfloat>(&call.arg(0));
    if (coord) {
        const trace::Array *_a_PGLfloat15_0 = (call.arg(0)).toArray();
    coord[0] = (*_a_PGLfloat15_0->values[0]).toFloat();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFogCoordfv(coord);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFogCoordd(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble coord;
    coord = (call.arg(0)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFogCoordd(coord);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFogCoorddv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * coord;
    coord = _allocator.allocArray<GLdouble>(&call.arg(0));
    if (coord) {
        const trace::Array *_a_PGLdouble5_0 = (call.arg(0)).toArray();
    coord[0] = (*_a_PGLdouble5_0->values[0]).toDouble();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFogCoorddv(coord);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFogCoordPointer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum type;
    type = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei stride;
    stride = (call.arg(1)).toSInt();

    const GLvoid * pointer;
    pointer = static_cast<const GLvoid *>(retrace::toPointer(call.arg(2), true));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFogCoordPointer(type, stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3b(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbyte red;
    red = (call.arg(0)).toSInt();

    GLbyte green;
    green = (call.arg(1)).toSInt();

    GLbyte blue;
    blue = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3b(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3bv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbyte * v;
    v = _allocator.allocArray<GLbyte>(&call.arg(0));
    const trace::Array *_a_GLbyte4_0 = (call.arg(0)).toArray();
    if (_a_GLbyte4_0) {
        for (size_t _jGLbyte4 = 0; _jGLbyte4 < _a_GLbyte4_0->values.size(); ++_jGLbyte4) {
    v[_jGLbyte4] = (*_a_GLbyte4_0->values[_jGLbyte4]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3bv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble red;
    red = (call.arg(0)).toDouble();

    GLdouble green;
    green = (call.arg(1)).toDouble();

    GLdouble blue;
    blue = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3d(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble51_0 = (call.arg(0)).toArray();
    if (_a_GLdouble51_0) {
        for (size_t _jGLdouble51 = 0; _jGLdouble51 < _a_GLdouble51_0->values.size(); ++_jGLdouble51) {
    v[_jGLdouble51] = (*_a_GLdouble51_0->values[_jGLdouble51]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat red;
    red = (call.arg(0)).toFloat();

    GLfloat green;
    green = (call.arg(1)).toFloat();

    GLfloat blue;
    blue = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3f(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat123_0 = (call.arg(0)).toArray();
    if (_a_GLfloat123_0) {
        for (size_t _jGLfloat123 = 0; _jGLfloat123 < _a_GLfloat123_0->values.size(); ++_jGLfloat123) {
    v[_jGLfloat123] = (*_a_GLfloat123_0->values[_jGLfloat123]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint red;
    red = (call.arg(0)).toSInt();

    GLint green;
    green = (call.arg(1)).toSInt();

    GLint blue;
    blue = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3i(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint157_0 = (call.arg(0)).toArray();
    if (_a_GLint157_0) {
        for (size_t _jGLint157 = 0; _jGLint157 < _a_GLint157_0->values.size(); ++_jGLint157) {
    v[_jGLint157] = (*_a_GLint157_0->values[_jGLint157]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort red;
    red = (call.arg(0)).toSInt();

    GLshort green;
    green = (call.arg(1)).toSInt();

    GLshort blue;
    blue = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3s(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort18_0 = (call.arg(0)).toArray();
    if (_a_GLshort18_0) {
        for (size_t _jGLshort18 = 0; _jGLshort18 < _a_GLshort18_0->values.size(); ++_jGLshort18) {
    v[_jGLshort18] = (*_a_GLshort18_0->values[_jGLshort18]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3ub(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLubyte red;
    red = (call.arg(0)).toUInt();

    GLubyte green;
    green = (call.arg(1)).toUInt();

    GLubyte blue;
    blue = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3ub(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3ubv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLubyte * v;
    v = _allocator.allocArray<GLubyte>(&call.arg(0));
    const trace::Array *_a_GLubyte9_0 = (call.arg(0)).toArray();
    if (_a_GLubyte9_0) {
        for (size_t _jGLubyte9 = 0; _jGLubyte9 < _a_GLubyte9_0->values.size(); ++_jGLubyte9) {
    v[_jGLubyte9] = (*_a_GLubyte9_0->values[_jGLubyte9]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3ubv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3ui(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint red;
    red = (call.arg(0)).toUInt();

    GLuint green;
    green = (call.arg(1)).toUInt();

    GLuint blue;
    blue = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3ui(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint * v;
    v = _allocator.allocArray<GLuint>(&call.arg(0));
    const trace::Array *_a_GLuint88_0 = (call.arg(0)).toArray();
    if (_a_GLuint88_0) {
        for (size_t _jGLuint88 = 0; _jGLuint88 < _a_GLuint88_0->values.size(); ++_jGLuint88) {
    v[_jGLuint88] = (*_a_GLuint88_0->values[_jGLuint88]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3uiv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3us(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLushort red;
    red = (call.arg(0)).toUInt();

    GLushort green;
    green = (call.arg(1)).toUInt();

    GLushort blue;
    blue = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3us(red, green, blue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColor3usv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLushort * v;
    v = _allocator.allocArray<GLushort>(&call.arg(0));
    const trace::Array *_a_GLushort6_0 = (call.arg(0)).toArray();
    if (_a_GLushort6_0) {
        for (size_t _jGLushort6 = 0; _jGLushort6 < _a_GLushort6_0->values.size(); ++_jGLushort6) {
    v[_jGLushort6] = (*_a_GLushort6_0->values[_jGLushort6]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColor3usv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSecondaryColorPointer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint size;
    size = static_cast<GLint>((call.arg(0)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(1)).toSInt());

    GLsizei stride;
    stride = (call.arg(2)).toSInt();

    const GLvoid * pointer;
    pointer = static_cast<const GLvoid *>(retrace::toPointer(call.arg(3), true));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSecondaryColorPointer(size, type, stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos2d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble x;
    x = (call.arg(0)).toDouble();

    GLdouble y;
    y = (call.arg(1)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos2d(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos2dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble52_0 = (call.arg(0)).toArray();
    if (_a_GLdouble52_0) {
        for (size_t _jGLdouble52 = 0; _jGLdouble52 < _a_GLdouble52_0->values.size(); ++_jGLdouble52) {
    v[_jGLdouble52] = (*_a_GLdouble52_0->values[_jGLdouble52]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos2dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos2f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat x;
    x = (call.arg(0)).toFloat();

    GLfloat y;
    y = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos2f(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos2fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat124_0 = (call.arg(0)).toArray();
    if (_a_GLfloat124_0) {
        for (size_t _jGLfloat124 = 0; _jGLfloat124 < _a_GLfloat124_0->values.size(); ++_jGLfloat124) {
    v[_jGLfloat124] = (*_a_GLfloat124_0->values[_jGLfloat124]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos2fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos2i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos2i(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos2iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint158_0 = (call.arg(0)).toArray();
    if (_a_GLint158_0) {
        for (size_t _jGLint158 = 0; _jGLint158 < _a_GLint158_0->values.size(); ++_jGLint158) {
    v[_jGLint158] = (*_a_GLint158_0->values[_jGLint158]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos2iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos2s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort x;
    x = (call.arg(0)).toSInt();

    GLshort y;
    y = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos2s(x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos2sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort19_0 = (call.arg(0)).toArray();
    if (_a_GLshort19_0) {
        for (size_t _jGLshort19 = 0; _jGLshort19 < _a_GLshort19_0->values.size(); ++_jGLshort19) {
    v[_jGLshort19] = (*_a_GLshort19_0->values[_jGLshort19]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos2sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos3d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble x;
    x = (call.arg(0)).toDouble();

    GLdouble y;
    y = (call.arg(1)).toDouble();

    GLdouble z;
    z = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos3d(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos3dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(0));
    const trace::Array *_a_GLdouble53_0 = (call.arg(0)).toArray();
    if (_a_GLdouble53_0) {
        for (size_t _jGLdouble53 = 0; _jGLdouble53 < _a_GLdouble53_0->values.size(); ++_jGLdouble53) {
    v[_jGLdouble53] = (*_a_GLdouble53_0->values[_jGLdouble53]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos3dv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos3f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat x;
    x = (call.arg(0)).toFloat();

    GLfloat y;
    y = (call.arg(1)).toFloat();

    GLfloat z;
    z = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos3f(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(0));
    const trace::Array *_a_GLfloat125_0 = (call.arg(0)).toArray();
    if (_a_GLfloat125_0) {
        for (size_t _jGLfloat125 = 0; _jGLfloat125 < _a_GLfloat125_0->values.size(); ++_jGLfloat125) {
    v[_jGLfloat125] = (*_a_GLfloat125_0->values[_jGLfloat125]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos3fv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos3i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint x;
    x = (call.arg(0)).toSInt();

    GLint y;
    y = (call.arg(1)).toSInt();

    GLint z;
    z = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos3i(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos3iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(0));
    const trace::Array *_a_GLint159_0 = (call.arg(0)).toArray();
    if (_a_GLint159_0) {
        for (size_t _jGLint159 = 0; _jGLint159 < _a_GLint159_0->values.size(); ++_jGLint159) {
    v[_jGLint159] = (*_a_GLint159_0->values[_jGLint159]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos3iv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos3s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort x;
    x = (call.arg(0)).toSInt();

    GLshort y;
    y = (call.arg(1)).toSInt();

    GLshort z;
    z = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos3s(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWindowPos3sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(0));
    const trace::Array *_a_GLshort20_0 = (call.arg(0)).toArray();
    if (_a_GLshort20_0) {
        for (size_t _jGLshort20 = 0; _jGLshort20 < _a_GLshort20_0->values.size(); ++_jGLshort20) {
    v[_jGLshort20] = (*_a_GLshort20_0->values[_jGLshort20]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWindowPos3sv(v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGenQueries(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * ids;
    ids = _allocator.allocArray<GLuint>(&call.arg(1));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGenQueries(n, ids);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint90 = (call.arg(1)).toArray();
    if (_aGLuint90) {
        for (size_t _jGLuint90 = 0; _jGLuint90 < _aGLuint90->values.size(); ++_jGLuint90) {
    GLuint _origResult;
    _origResult = (*_aGLuint90->values[_jGLuint90]).toUInt();
    _query_map[_origResult] = ids[_jGLuint90];
    if (retrace::verbosity >= 2) {
        std::cout << "query " << _origResult << " -> " << ids[_jGLuint90] << "\n";
    }
        }
    }
}

static void retrace_glDeleteQueries(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * ids;
    ids = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint91_0 = (call.arg(1)).toArray();
    if (_a_GLuint91_0) {
        for (size_t _jGLuint91 = 0; _jGLuint91 < _a_GLuint91_0->values.size(); ++_jGLuint91) {
    ids[_jGLuint91] = (*_a_GLuint91_0->values[_jGLuint91]).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(ids[_jGLuint91]) << " <- " << size_t(_query_map[ids[_jGLuint91]]) << "\n";
    }
    ids[_jGLuint91] = _query_map[ids[_jGLuint91]];
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeleteQueries(n, ids);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBeginQuery(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint id;
    id = (call.arg(1)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(id) << " <- " << size_t(_query_map[id]) << "\n";
    }
    id = _query_map[id];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBeginQuery(target, id);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEndQuery(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEndQuery(target);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetQueryObjectiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    GLint _query_buffer = 0;
    if (currentContext && currentContext->features().query_buffer_object) {
        glGetIntegerv(GL_QUERY_BUFFER_BINDING, &_query_buffer);
    }
    if (!_query_buffer && retrace::queryHandling == retrace::QUERY_SKIP) {
        return;
    }
wait_for_query_result:
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint id;
    id = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(id) << " <- " << size_t(_query_map[id]) << "\n";
    }
    id = _query_map[id];

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint * params;
    GLint retval;
    if (_query_buffer)
        params = static_cast<GLint *>((call.arg(2)).toPointer());
    else
        params = &retval;

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetQueryObjectiv(id, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLint161 = (call.arg(2)).toArray();
    if (_aGLint161) {
        for (size_t _jGLint161 = 0; _jGLint161 < _aGLint161->values.size(); ++_jGLint161) {
        }
    }
    if (!_query_buffer && retrace::queryHandling != retrace::QUERY_SKIP) {
        auto query_result = call.arg(2).toArray();
        assert(query_result && query_result->values.size() == 1);
        auto expect = static_cast<decltype(retval)>(query_result->values[0]->toUInt());
        if (call.arg(1).toUInt() == GL_QUERY_RESULT_AVAILABLE) {
            if (expect == 1 && retval == 0)
                goto wait_for_query_result;
        } else if (retrace::queryHandling == retrace::QUERY_RUN_AND_CHECK_RESULT &&
                   abs(static_cast<int64_t>(expect) - static_cast<int64_t>(retval)) > retrace::queryTolerance) {
           retrace::warning(call) << "Warning: query returned " << retval << " but trace contained " << expect
                                  << " (tol = " << retrace::queryTolerance << ")\n";
        }
    }
}

static void retrace_glGetQueryObjectuiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    GLint _query_buffer = 0;
    if (currentContext && currentContext->features().query_buffer_object) {
        glGetIntegerv(GL_QUERY_BUFFER_BINDING, &_query_buffer);
    }
    if (!_query_buffer && retrace::queryHandling == retrace::QUERY_SKIP) {
        return;
    }
wait_for_query_result:
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint id;
    id = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(id) << " <- " << size_t(_query_map[id]) << "\n";
    }
    id = _query_map[id];

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLuint * params;
    GLuint retval;
    if (_query_buffer)
        params = static_cast<GLuint *>((call.arg(2)).toPointer());
    else
        params = &retval;

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetQueryObjectuiv(id, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint93 = (call.arg(2)).toArray();
    if (_aGLuint93) {
        for (size_t _jGLuint93 = 0; _jGLuint93 < _aGLuint93->values.size(); ++_jGLuint93) {
        }
    }
    if (!_query_buffer && retrace::queryHandling != retrace::QUERY_SKIP) {
        auto query_result = call.arg(2).toArray();
        assert(query_result && query_result->values.size() == 1);
        auto expect = static_cast<decltype(retval)>(query_result->values[0]->toUInt());
        if (call.arg(1).toUInt() == GL_QUERY_RESULT_AVAILABLE) {
            if (expect == 1 && retval == 0)
                goto wait_for_query_result;
        } else if (retrace::queryHandling == retrace::QUERY_RUN_AND_CHECK_RESULT &&
                   abs(static_cast<int64_t>(expect) - static_cast<int64_t>(retval)) > retrace::queryTolerance) {
           retrace::warning(call) << "Warning: query returned " << retval << " but trace contained " << expect
                                  << " (tol = " << retrace::queryTolerance << ")\n";
        }
    }
}

static void retrace_glBindBuffer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint buffer;
    buffer = (call.arg(1)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << size_t(buffer) << " <- " << size_t(_buffer_map[buffer]) << "\n";
    }
    buffer = _buffer_map[buffer];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBindBuffer(target, buffer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDeleteBuffers(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * buffers;
    buffers = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint94_0 = (call.arg(1)).toArray();
    if (_a_GLuint94_0) {
        for (size_t _jGLuint94 = 0; _jGLuint94 < _a_GLuint94_0->values.size(); ++_jGLuint94) {
    buffers[_jGLuint94] = (*_a_GLuint94_0->values[_jGLuint94]).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << size_t(buffers[_jGLuint94]) << " <- " << size_t(_buffer_map[buffers[_jGLuint94]]) << "\n";
    }
    buffers[_jGLuint94] = _buffer_map[buffers[_jGLuint94]];
        }
    }

    if (currentContext && currentContext->features().ARB_direct_state_access) {
        for (GLsizei i = 0; i < n; ++i) {
            GLuint buffer = buffers[i];
            if (buffer != 0 && glIsBuffer(buffer)) {
                GLvoid *ptr = nullptr;
                glGetNamedBufferPointerv(buffers[i], GL_BUFFER_MAP_POINTER, &ptr);
                if (ptr) {
                    retrace::delRegionByPointer(ptr);
                }
            }
        }
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeleteBuffers(n, buffers);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGenBuffers(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * buffers;
    buffers = _allocator.allocArray<GLuint>(&call.arg(1));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGenBuffers(n, buffers);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint96 = (call.arg(1)).toArray();
    if (_aGLuint96) {
        for (size_t _jGLuint96 = 0; _jGLuint96 < _aGLuint96->values.size(); ++_jGLuint96) {
    GLuint _origResult;
    _origResult = (*_aGLuint96->values[_jGLuint96]).toUInt();
    _buffer_map[_origResult] = buffers[_jGLuint96];
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << _origResult << " -> " << buffers[_jGLuint96] << "\n";
    }
        }
    }
}

static void retrace_glBufferData(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizeiptr size;
    size = (call.arg(1)).toSInt();

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(2)).toPointer());

    GLenum usage;
    usage = static_cast<GLenum>((call.arg(3)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBufferData(target, size, data, usage);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBufferSubData(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLintptr offset;
    offset = (call.arg(1)).toSInt();

    GLsizeiptr size;
    size = (call.arg(2)).toSInt();

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(3)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBufferSubData(target, offset, size, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMapBuffer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum access;
    access = static_cast<GLenum>((call.arg(1)).toSInt());

    GLvoid * _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glMapBuffer(target, access);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
        if (!_result) {
             retrace::warning(call) << "failed to map buffer\n";
        }
    }
    GLint length = 0;
    glGetBufferParameteriv(target, GL_BUFFER_SIZE, &length);
    retrace::addRegion(call, (*call.ret).toUIntPtr(), _result, length);
}

static void retrace_glUnmapBuffer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLboolean _result;
        GLvoid *ptr = NULL;
            glGetBufferPointerv(target, GL_BUFFER_MAP_POINTER, &ptr);
        if (ptr) {
            retrace::delRegionByPointer(ptr);
        } else {
            retrace::warning(call) << "failed to get mapped pointer\n";
        }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glUnmapBuffer(target);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
        if (!_result) {
             retrace::warning(call) << "failed to unmap buffer\n";
        }
    }
}

static void retrace_glBlendEquationSeparate(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum modeRGB;
    modeRGB = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum modeAlpha;
    modeAlpha = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendEquationSeparate(modeRGB, modeAlpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDrawBuffers(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLenum * bufs;
    bufs = _allocator.allocArray<GLenum>(&call.arg(1));
    const trace::Array *_a_GLenum14_0 = (call.arg(1)).toArray();
    if (_a_GLenum14_0) {
        for (size_t _jGLenum14 = 0; _jGLenum14 < _a_GLenum14_0->values.size(); ++_jGLenum14) {
    bufs[_jGLenum14] = static_cast<GLenum>((*_a_GLenum14_0->values[_jGLenum14]).toSInt());
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDrawBuffers(n, bufs);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glStencilOpSeparate(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum sfail;
    sfail = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum dpfail;
    dpfail = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum dppass;
    dppass = static_cast<GLenum>((call.arg(3)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glStencilOpSeparate(face, sfail, dpfail, dppass);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glStencilFuncSeparate(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum func;
    func = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint ref;
    ref = (call.arg(2)).toSInt();

    GLuint mask;
    mask = (call.arg(3)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glStencilFuncSeparate(face, func, ref, mask);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glStencilMaskSeparate(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint mask;
    mask = (call.arg(1)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glStencilMaskSeparate(face, mask);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glAttachShader(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    GLuint shader;
    shader = (call.arg(1)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_handleARB_map[shader]) << "\n";
    }
    shader = _handleARB_map[shader];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_shader_map[shader]) << "\n";
    }
    shader = _shader_map[shader];
}

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glAttachShader(program, shader);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBindAttribLocation(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    GLuint index;
    index = (call.arg(1)).toUInt();

    const GLchar * name;
    name = (const GLchar *)((call.arg(2)).toString());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBindAttribLocation(program, index, name);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCompileShader(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint shader;
    shader = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_handleARB_map[shader]) << "\n";
    }
    shader = _handleARB_map[shader];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_shader_map[shader]) << "\n";
    }
    shader = _shader_map[shader];
}

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCompileShader(shader);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
        GLint compile_status = 0;
        glGetShaderiv(shader, GL_COMPILE_STATUS, &compile_status);
        if (!compile_status) {
             retrace::warning(call) << "compilation failed\n";
        }
        GLint info_log_length = 0;
        glGetShaderiv(shader, GL_INFO_LOG_LENGTH, &info_log_length);
        if (info_log_length > 1) {
             GLchar *infoLog = new GLchar[info_log_length];
             glGetShaderInfoLog(shader, info_log_length, NULL, infoLog);
             retrace::warning(call) << infoLog << "\n";
             delete [] infoLog;
        }
    }
}

static void retrace_glCreateProgram(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glCreateProgram();
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    GLuint _origResult;
    _origResult = (*call.ret).toUInt();
if (glretrace::supportsARBShaderObjects) {
    _handleARB_map[_origResult] = _result;
} else {
    _program_map[_origResult] = _result;
}
    if (retrace::verbosity >= 2) {
        std::cout << "program " << _origResult << " -> " << _result << "\n";
    }
}

static void retrace_glCreateShader(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum type;
    type = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glCreateShader(type);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    GLuint _origResult;
    _origResult = (*call.ret).toUInt();
if (glretrace::supportsARBShaderObjects) {
    _handleARB_map[_origResult] = _result;
} else {
    _shader_map[_origResult] = _result;
}
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << _origResult << " -> " << _result << "\n";
    }
}

static void retrace_glDeleteProgram(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeleteProgram(program);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDeleteShader(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint shader;
    shader = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_handleARB_map[shader]) << "\n";
    }
    shader = _handleARB_map[shader];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_shader_map[shader]) << "\n";
    }
    shader = _shader_map[shader];
}

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeleteShader(shader);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDetachShader(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    GLuint shader;
    shader = (call.arg(1)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_handleARB_map[shader]) << "\n";
    }
    shader = _handleARB_map[shader];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_shader_map[shader]) << "\n";
    }
    shader = _shader_map[shader];
}

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    if (!retrace::dumpingState) {
    glDetachShader(program, shader);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDisableVertexAttribArray(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDisableVertexAttribArray(index);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEnableVertexAttribArray(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEnableVertexAttribArray(index);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetAttribLocation(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    const GLchar * name;
    name = (const GLchar *)((call.arg(1)).toString());

    GLint _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glGetAttribLocation(program, name);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    GLint _origResult = call.ret->toSInt();
    if (_result != _origResult) {
        retrace::warning(call) << "vertex attrib location mismatch " << _origResult << " -> " << _result << "\n";
    }
    }
}

static void retrace_glGetUniformLocation(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    const GLchar * name;
    name = (const GLchar *)((call.arg(1)).toString());

    GLint _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glGetUniformLocation(program, name);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    GLint _origResult;
    _origResult = (*call.ret).toSInt();
    _location_map[program][_origResult] = _result;
    if (retrace::verbosity >= 2) {
        std::cout << "location " << _origResult << " -> " << _result << "\n";
    }
}

static void retrace_glLinkProgram(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLinkProgram(program);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
        GLint link_status = 0;
        glGetProgramiv(program, GL_LINK_STATUS, &link_status);
        if (!link_status) {
             retrace::warning(call) << "link failed\n";
        }
        GLint info_log_length = 0;
        glGetProgramiv(program, GL_INFO_LOG_LENGTH, &info_log_length);
        if (info_log_length > 1) {
             GLchar *infoLog = new GLchar[info_log_length];
             glGetProgramInfoLog(program, info_log_length, NULL, infoLog);
             retrace::warning(call) << infoLog << "\n";
             delete [] infoLog;
        }
    }
}

static void retrace_glShaderSource(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint shader;
    shader = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_handleARB_map[shader]) << "\n";
    }
    shader = _handleARB_map[shader];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_shader_map[shader]) << "\n";
    }
    shader = _shader_map[shader];
}

    GLsizei count;
    count = (call.arg(1)).toSInt();

    const GLchar * * string;
    string = _allocator.allocArray<const GLchar *>(&call.arg(2));
    const trace::Array *_a_constGLchar22_0 = (call.arg(2)).toArray();
    if (_a_constGLchar22_0) {
        for (size_t _jconstGLchar22 = 0; _jconstGLchar22 < _a_constGLchar22_0->values.size(); ++_jconstGLchar22) {
    string[_jconstGLchar22] = (const GLchar *)((*_a_constGLchar22_0->values[_jconstGLchar22]).toString());
        }
    }

    GLint * length;
    length = _allocator.allocArray<GLint>(&call.arg(3));
    const trace::Array *_a_GLint162_0 = (call.arg(3)).toArray();
    if (_a_GLint162_0) {
        for (size_t _jGLint162 = 0; _jGLint162 < _a_GLint162_0->values.size(); ++_jGLint162) {
    length[_jGLint162] = (*_a_GLint162_0->values[_jGLint162]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glShaderSource(shader, count, string, length);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUseProgram(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUseProgram(program);
    if (currentContext) {
        currentContext->currentUserProgram = call.arg(0).toUInt();
        currentContext->currentProgram = _glGetInteger(GL_CURRENT_PROGRAM);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform1f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLfloat v0;
    v0 = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform1f(location, v0);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform2f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLfloat v0;
    v0 = (call.arg(1)).toFloat();

    GLfloat v1;
    v1 = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform2f(location, v0, v1);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform3f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLfloat v0;
    v0 = (call.arg(1)).toFloat();

    GLfloat v1;
    v1 = (call.arg(2)).toFloat();

    GLfloat v2;
    v2 = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform3f(location, v0, v1, v2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform4f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLfloat v0;
    v0 = (call.arg(1)).toFloat();

    GLfloat v1;
    v1 = (call.arg(2)).toFloat();

    GLfloat v2;
    v2 = (call.arg(3)).toFloat();

    GLfloat v3;
    v3 = (call.arg(4)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform4f(location, v0, v1, v2, v3);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform1i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLint v0;
    v0 = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform1i(location, v0);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform2i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLint v0;
    v0 = (call.arg(1)).toSInt();

    GLint v1;
    v1 = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform2i(location, v0, v1);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform3i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLint v0;
    v0 = (call.arg(1)).toSInt();

    GLint v1;
    v1 = (call.arg(2)).toSInt();

    GLint v2;
    v2 = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform3i(location, v0, v1, v2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform4i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLint v0;
    v0 = (call.arg(1)).toSInt();

    GLint v1;
    v1 = (call.arg(2)).toSInt();

    GLint v2;
    v2 = (call.arg(3)).toSInt();

    GLint v3;
    v3 = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform4i(location, v0, v1, v2, v3);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform1fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat126_0 = (call.arg(2)).toArray();
    if (_a_GLfloat126_0) {
        for (size_t _jGLfloat126 = 0; _jGLfloat126 < _a_GLfloat126_0->values.size(); ++_jGLfloat126) {
    value[_jGLfloat126] = (*_a_GLfloat126_0->values[_jGLfloat126]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform1fv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform2fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat127_0 = (call.arg(2)).toArray();
    if (_a_GLfloat127_0) {
        for (size_t _jGLfloat127 = 0; _jGLfloat127 < _a_GLfloat127_0->values.size(); ++_jGLfloat127) {
    value[_jGLfloat127] = (*_a_GLfloat127_0->values[_jGLfloat127]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform2fv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat128_0 = (call.arg(2)).toArray();
    if (_a_GLfloat128_0) {
        for (size_t _jGLfloat128 = 0; _jGLfloat128 < _a_GLfloat128_0->values.size(); ++_jGLfloat128) {
    value[_jGLfloat128] = (*_a_GLfloat128_0->values[_jGLfloat128]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform3fv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform4fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat129_0 = (call.arg(2)).toArray();
    if (_a_GLfloat129_0) {
        for (size_t _jGLfloat129 = 0; _jGLfloat129 < _a_GLfloat129_0->values.size(); ++_jGLfloat129) {
    value[_jGLfloat129] = (*_a_GLfloat129_0->values[_jGLfloat129]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform4fv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform1iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLint * value;
    value = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint163_0 = (call.arg(2)).toArray();
    if (_a_GLint163_0) {
        for (size_t _jGLint163 = 0; _jGLint163 < _a_GLint163_0->values.size(); ++_jGLint163) {
    value[_jGLint163] = (*_a_GLint163_0->values[_jGLint163]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform1iv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform2iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLint * value;
    value = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint164_0 = (call.arg(2)).toArray();
    if (_a_GLint164_0) {
        for (size_t _jGLint164 = 0; _jGLint164 < _a_GLint164_0->values.size(); ++_jGLint164) {
    value[_jGLint164] = (*_a_GLint164_0->values[_jGLint164]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform2iv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform3iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLint * value;
    value = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint165_0 = (call.arg(2)).toArray();
    if (_a_GLint165_0) {
        for (size_t _jGLint165 = 0; _jGLint165 < _a_GLint165_0->values.size(); ++_jGLint165) {
    value[_jGLint165] = (*_a_GLint165_0->values[_jGLint165]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform3iv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform4iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLint * value;
    value = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint166_0 = (call.arg(2)).toArray();
    if (_a_GLint166_0) {
        for (size_t _jGLint166 = 0; _jGLint166 < _a_GLint166_0->values.size(); ++_jGLint166) {
    value[_jGLint166] = (*_a_GLint166_0->values[_jGLint166]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform4iv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniformMatrix2fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLboolean transpose;
    transpose = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(3));
    const trace::Array *_a_GLfloat130_0 = (call.arg(3)).toArray();
    if (_a_GLfloat130_0) {
        for (size_t _jGLfloat130 = 0; _jGLfloat130 < _a_GLfloat130_0->values.size(); ++_jGLfloat130) {
    value[_jGLfloat130] = (*_a_GLfloat130_0->values[_jGLfloat130]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniformMatrix2fv(location, count, transpose, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniformMatrix3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLboolean transpose;
    transpose = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(3));
    const trace::Array *_a_GLfloat131_0 = (call.arg(3)).toArray();
    if (_a_GLfloat131_0) {
        for (size_t _jGLfloat131 = 0; _jGLfloat131 < _a_GLfloat131_0->values.size(); ++_jGLfloat131) {
    value[_jGLfloat131] = (*_a_GLfloat131_0->values[_jGLfloat131]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniformMatrix3fv(location, count, transpose, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniformMatrix4fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLboolean transpose;
    transpose = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(3));
    const trace::Array *_a_GLfloat132_0 = (call.arg(3)).toArray();
    if (_a_GLfloat132_0) {
        for (size_t _jGLfloat132 = 0; _jGLfloat132 < _a_GLfloat132_0->values.size(); ++_jGLfloat132) {
    value[_jGLfloat132] = (*_a_GLfloat132_0->values[_jGLfloat132]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniformMatrix4fv(location, count, transpose, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glValidateProgram(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glValidateProgram(program);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib1d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLdouble x;
    x = (call.arg(1)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib1d(index, x);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib1dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(1));
    if (v) {
        const trace::Array *_a_PGLdouble6_0 = (call.arg(1)).toArray();
    v[0] = (*_a_PGLdouble6_0->values[0]).toDouble();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib1dv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib1f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLfloat x;
    x = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib1f(index, x);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib1fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(1));
    if (v) {
        const trace::Array *_a_PGLfloat16_0 = (call.arg(1)).toArray();
    v[0] = (*_a_PGLfloat16_0->values[0]).toFloat();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib1fv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib1s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLshort x;
    x = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib1s(index, x);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib1sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(1));
    if (v) {
        const trace::Array *_a_PGLshort3_0 = (call.arg(1)).toArray();
    v[0] = (*_a_PGLshort3_0->values[0]).toSInt();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib1sv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib2d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLdouble x;
    x = (call.arg(1)).toDouble();

    GLdouble y;
    y = (call.arg(2)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib2d(index, x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib2dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(1));
    const trace::Array *_a_GLdouble54_0 = (call.arg(1)).toArray();
    if (_a_GLdouble54_0) {
        for (size_t _jGLdouble54 = 0; _jGLdouble54 < _a_GLdouble54_0->values.size(); ++_jGLdouble54) {
    v[_jGLdouble54] = (*_a_GLdouble54_0->values[_jGLdouble54]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib2dv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib2f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLfloat x;
    x = (call.arg(1)).toFloat();

    GLfloat y;
    y = (call.arg(2)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib2f(index, x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib2fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(1));
    const trace::Array *_a_GLfloat133_0 = (call.arg(1)).toArray();
    if (_a_GLfloat133_0) {
        for (size_t _jGLfloat133 = 0; _jGLfloat133 < _a_GLfloat133_0->values.size(); ++_jGLfloat133) {
    v[_jGLfloat133] = (*_a_GLfloat133_0->values[_jGLfloat133]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib2fv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib2s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLshort x;
    x = (call.arg(1)).toSInt();

    GLshort y;
    y = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib2s(index, x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib2sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(1));
    const trace::Array *_a_GLshort21_0 = (call.arg(1)).toArray();
    if (_a_GLshort21_0) {
        for (size_t _jGLshort21 = 0; _jGLshort21 < _a_GLshort21_0->values.size(); ++_jGLshort21) {
    v[_jGLshort21] = (*_a_GLshort21_0->values[_jGLshort21]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib2sv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib3d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLdouble x;
    x = (call.arg(1)).toDouble();

    GLdouble y;
    y = (call.arg(2)).toDouble();

    GLdouble z;
    z = (call.arg(3)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib3d(index, x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib3dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(1));
    const trace::Array *_a_GLdouble55_0 = (call.arg(1)).toArray();
    if (_a_GLdouble55_0) {
        for (size_t _jGLdouble55 = 0; _jGLdouble55 < _a_GLdouble55_0->values.size(); ++_jGLdouble55) {
    v[_jGLdouble55] = (*_a_GLdouble55_0->values[_jGLdouble55]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib3dv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib3f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLfloat x;
    x = (call.arg(1)).toFloat();

    GLfloat y;
    y = (call.arg(2)).toFloat();

    GLfloat z;
    z = (call.arg(3)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib3f(index, x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(1));
    const trace::Array *_a_GLfloat134_0 = (call.arg(1)).toArray();
    if (_a_GLfloat134_0) {
        for (size_t _jGLfloat134 = 0; _jGLfloat134 < _a_GLfloat134_0->values.size(); ++_jGLfloat134) {
    v[_jGLfloat134] = (*_a_GLfloat134_0->values[_jGLfloat134]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib3fv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib3s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLshort x;
    x = (call.arg(1)).toSInt();

    GLshort y;
    y = (call.arg(2)).toSInt();

    GLshort z;
    z = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib3s(index, x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib3sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(1));
    const trace::Array *_a_GLshort22_0 = (call.arg(1)).toArray();
    if (_a_GLshort22_0) {
        for (size_t _jGLshort22 = 0; _jGLshort22 < _a_GLshort22_0->values.size(); ++_jGLshort22) {
    v[_jGLshort22] = (*_a_GLshort22_0->values[_jGLshort22]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib3sv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4Nbv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLbyte * v;
    v = _allocator.allocArray<GLbyte>(&call.arg(1));
    const trace::Array *_a_GLbyte5_0 = (call.arg(1)).toArray();
    if (_a_GLbyte5_0) {
        for (size_t _jGLbyte5 = 0; _jGLbyte5 < _a_GLbyte5_0->values.size(); ++_jGLbyte5) {
    v[_jGLbyte5] = (*_a_GLbyte5_0->values[_jGLbyte5]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4Nbv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4Niv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint167_0 = (call.arg(1)).toArray();
    if (_a_GLint167_0) {
        for (size_t _jGLint167 = 0; _jGLint167 < _a_GLint167_0->values.size(); ++_jGLint167) {
    v[_jGLint167] = (*_a_GLint167_0->values[_jGLint167]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4Niv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4Nsv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(1));
    const trace::Array *_a_GLshort23_0 = (call.arg(1)).toArray();
    if (_a_GLshort23_0) {
        for (size_t _jGLshort23 = 0; _jGLshort23 < _a_GLshort23_0->values.size(); ++_jGLshort23) {
    v[_jGLshort23] = (*_a_GLshort23_0->values[_jGLshort23]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4Nsv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4Nub(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLubyte x;
    x = (call.arg(1)).toUInt();

    GLubyte y;
    y = (call.arg(2)).toUInt();

    GLubyte z;
    z = (call.arg(3)).toUInt();

    GLubyte w;
    w = (call.arg(4)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4Nub(index, x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4Nubv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLubyte * v;
    v = _allocator.allocArray<GLubyte>(&call.arg(1));
    const trace::Array *_a_GLubyte10_0 = (call.arg(1)).toArray();
    if (_a_GLubyte10_0) {
        for (size_t _jGLubyte10 = 0; _jGLubyte10 < _a_GLubyte10_0->values.size(); ++_jGLubyte10) {
    v[_jGLubyte10] = (*_a_GLubyte10_0->values[_jGLubyte10]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4Nubv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4Nuiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint * v;
    v = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint97_0 = (call.arg(1)).toArray();
    if (_a_GLuint97_0) {
        for (size_t _jGLuint97 = 0; _jGLuint97 < _a_GLuint97_0->values.size(); ++_jGLuint97) {
    v[_jGLuint97] = (*_a_GLuint97_0->values[_jGLuint97]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4Nuiv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4Nusv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLushort * v;
    v = _allocator.allocArray<GLushort>(&call.arg(1));
    const trace::Array *_a_GLushort7_0 = (call.arg(1)).toArray();
    if (_a_GLushort7_0) {
        for (size_t _jGLushort7 = 0; _jGLushort7 < _a_GLushort7_0->values.size(); ++_jGLushort7) {
    v[_jGLushort7] = (*_a_GLushort7_0->values[_jGLushort7]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4Nusv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4bv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLbyte * v;
    v = _allocator.allocArray<GLbyte>(&call.arg(1));
    const trace::Array *_a_GLbyte6_0 = (call.arg(1)).toArray();
    if (_a_GLbyte6_0) {
        for (size_t _jGLbyte6 = 0; _jGLbyte6 < _a_GLbyte6_0->values.size(); ++_jGLbyte6) {
    v[_jGLbyte6] = (*_a_GLbyte6_0->values[_jGLbyte6]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4bv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4d(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLdouble x;
    x = (call.arg(1)).toDouble();

    GLdouble y;
    y = (call.arg(2)).toDouble();

    GLdouble z;
    z = (call.arg(3)).toDouble();

    GLdouble w;
    w = (call.arg(4)).toDouble();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4d(index, x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4dv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLdouble * v;
    v = _allocator.allocArray<GLdouble>(&call.arg(1));
    const trace::Array *_a_GLdouble56_0 = (call.arg(1)).toArray();
    if (_a_GLdouble56_0) {
        for (size_t _jGLdouble56 = 0; _jGLdouble56 < _a_GLdouble56_0->values.size(); ++_jGLdouble56) {
    v[_jGLdouble56] = (*_a_GLdouble56_0->values[_jGLdouble56]).toDouble();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4dv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4f(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLfloat x;
    x = (call.arg(1)).toFloat();

    GLfloat y;
    y = (call.arg(2)).toFloat();

    GLfloat z;
    z = (call.arg(3)).toFloat();

    GLfloat w;
    w = (call.arg(4)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4f(index, x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLfloat * v;
    v = _allocator.allocArray<GLfloat>(&call.arg(1));
    const trace::Array *_a_GLfloat135_0 = (call.arg(1)).toArray();
    if (_a_GLfloat135_0) {
        for (size_t _jGLfloat135 = 0; _jGLfloat135 < _a_GLfloat135_0->values.size(); ++_jGLfloat135) {
    v[_jGLfloat135] = (*_a_GLfloat135_0->values[_jGLfloat135]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4fv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint168_0 = (call.arg(1)).toArray();
    if (_a_GLint168_0) {
        for (size_t _jGLint168 = 0; _jGLint168 < _a_GLint168_0->values.size(); ++_jGLint168) {
    v[_jGLint168] = (*_a_GLint168_0->values[_jGLint168]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4iv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4s(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLshort x;
    x = (call.arg(1)).toSInt();

    GLshort y;
    y = (call.arg(2)).toSInt();

    GLshort z;
    z = (call.arg(3)).toSInt();

    GLshort w;
    w = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4s(index, x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(1));
    const trace::Array *_a_GLshort24_0 = (call.arg(1)).toArray();
    if (_a_GLshort24_0) {
        for (size_t _jGLshort24 = 0; _jGLshort24 < _a_GLshort24_0->values.size(); ++_jGLshort24) {
    v[_jGLshort24] = (*_a_GLshort24_0->values[_jGLshort24]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4sv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4ubv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLubyte * v;
    v = _allocator.allocArray<GLubyte>(&call.arg(1));
    const trace::Array *_a_GLubyte11_0 = (call.arg(1)).toArray();
    if (_a_GLubyte11_0) {
        for (size_t _jGLubyte11 = 0; _jGLubyte11 < _a_GLubyte11_0->values.size(); ++_jGLubyte11) {
    v[_jGLubyte11] = (*_a_GLubyte11_0->values[_jGLubyte11]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4ubv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint * v;
    v = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint98_0 = (call.arg(1)).toArray();
    if (_a_GLuint98_0) {
        for (size_t _jGLuint98 = 0; _jGLuint98 < _a_GLuint98_0->values.size(); ++_jGLuint98) {
    v[_jGLuint98] = (*_a_GLuint98_0->values[_jGLuint98]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4uiv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttrib4usv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLushort * v;
    v = _allocator.allocArray<GLushort>(&call.arg(1));
    const trace::Array *_a_GLushort8_0 = (call.arg(1)).toArray();
    if (_a_GLushort8_0) {
        for (size_t _jGLushort8 = 0; _jGLushort8 < _a_GLushort8_0->values.size(); ++_jGLushort8) {
    v[_jGLushort8] = (*_a_GLushort8_0->values[_jGLushort8]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttrib4usv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribPointer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint size;
    size = static_cast<GLint>((call.arg(1)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    GLboolean normalized;
    normalized = static_cast<GLboolean>((call.arg(3)).toSInt());

    GLsizei stride;
    stride = (call.arg(4)).toSInt();

    const GLvoid * pointer;
    pointer = static_cast<const GLvoid *>(retrace::toPointer(call.arg(5), true));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribPointer(index, size, type, normalized, stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniformMatrix2x3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLboolean transpose;
    transpose = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(3));
    const trace::Array *_a_GLfloat136_0 = (call.arg(3)).toArray();
    if (_a_GLfloat136_0) {
        for (size_t _jGLfloat136 = 0; _jGLfloat136 < _a_GLfloat136_0->values.size(); ++_jGLfloat136) {
    value[_jGLfloat136] = (*_a_GLfloat136_0->values[_jGLfloat136]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniformMatrix2x3fv(location, count, transpose, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniformMatrix3x2fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLboolean transpose;
    transpose = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(3));
    const trace::Array *_a_GLfloat137_0 = (call.arg(3)).toArray();
    if (_a_GLfloat137_0) {
        for (size_t _jGLfloat137 = 0; _jGLfloat137 < _a_GLfloat137_0->values.size(); ++_jGLfloat137) {
    value[_jGLfloat137] = (*_a_GLfloat137_0->values[_jGLfloat137]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniformMatrix3x2fv(location, count, transpose, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniformMatrix2x4fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLboolean transpose;
    transpose = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(3));
    const trace::Array *_a_GLfloat138_0 = (call.arg(3)).toArray();
    if (_a_GLfloat138_0) {
        for (size_t _jGLfloat138 = 0; _jGLfloat138 < _a_GLfloat138_0->values.size(); ++_jGLfloat138) {
    value[_jGLfloat138] = (*_a_GLfloat138_0->values[_jGLfloat138]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniformMatrix2x4fv(location, count, transpose, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniformMatrix4x2fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLboolean transpose;
    transpose = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(3));
    const trace::Array *_a_GLfloat139_0 = (call.arg(3)).toArray();
    if (_a_GLfloat139_0) {
        for (size_t _jGLfloat139 = 0; _jGLfloat139 < _a_GLfloat139_0->values.size(); ++_jGLfloat139) {
    value[_jGLfloat139] = (*_a_GLfloat139_0->values[_jGLfloat139]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniformMatrix4x2fv(location, count, transpose, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniformMatrix3x4fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLboolean transpose;
    transpose = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(3));
    const trace::Array *_a_GLfloat140_0 = (call.arg(3)).toArray();
    if (_a_GLfloat140_0) {
        for (size_t _jGLfloat140 = 0; _jGLfloat140 < _a_GLfloat140_0->values.size(); ++_jGLfloat140) {
    value[_jGLfloat140] = (*_a_GLfloat140_0->values[_jGLfloat140]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniformMatrix3x4fv(location, count, transpose, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniformMatrix4x3fv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLboolean transpose;
    transpose = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(3));
    const trace::Array *_a_GLfloat141_0 = (call.arg(3)).toArray();
    if (_a_GLfloat141_0) {
        for (size_t _jGLfloat141 = 0; _jGLfloat141 < _a_GLfloat141_0->values.size(); ++_jGLfloat141) {
    value[_jGLfloat141] = (*_a_GLfloat141_0->values[_jGLfloat141]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniformMatrix4x3fv(location, count, transpose, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColorMaski(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLboolean r;
    r = static_cast<GLboolean>((call.arg(1)).toSInt());

    GLboolean g;
    g = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLboolean b;
    b = static_cast<GLboolean>((call.arg(3)).toSInt());

    GLboolean a;
    a = static_cast<GLboolean>((call.arg(4)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColorMaski(index, r, g, b, a);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEnablei(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint index;
    index = (call.arg(1)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEnablei(target, index);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDisablei(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint index;
    index = (call.arg(1)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDisablei(target, index);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBeginTransformFeedback(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum primitiveMode;
    primitiveMode = static_cast<GLenum>((call.arg(0)).toSInt());

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBeginTransformFeedback(primitiveMode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEndTransformFeedback(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEndTransformFeedback();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBindBufferRange(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint index;
    index = (call.arg(1)).toUInt();

    GLuint buffer;
    buffer = (call.arg(2)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << size_t(buffer) << " <- " << size_t(_buffer_map[buffer]) << "\n";
    }
    buffer = _buffer_map[buffer];

    GLintptr offset;
    offset = (call.arg(3)).toSInt();

    GLsizeiptr size;
    size = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBindBufferRange(target, index, buffer, offset, size);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBindBufferBase(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint index;
    index = (call.arg(1)).toUInt();

    GLuint buffer;
    buffer = (call.arg(2)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << size_t(buffer) << " <- " << size_t(_buffer_map[buffer]) << "\n";
    }
    buffer = _buffer_map[buffer];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBindBufferBase(target, index, buffer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTransformFeedbackVaryings(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    GLsizei count;
    count = (call.arg(1)).toSInt();

    const GLchar * * varyings;
    varyings = _allocator.allocArray<const GLchar *>(&call.arg(2));
    const trace::Array *_a_constGLchar23_0 = (call.arg(2)).toArray();
    if (_a_constGLchar23_0) {
        for (size_t _jconstGLchar23 = 0; _jconstGLchar23 < _a_constGLchar23_0->values.size(); ++_jconstGLchar23) {
    varyings[_jconstGLchar23] = (const GLchar *)((*_a_constGLchar23_0->values[_jconstGLchar23]).toString());
        }
    }

    GLenum bufferMode;
    bufferMode = static_cast<GLenum>((call.arg(3)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTransformFeedbackVaryings(program, count, varyings, bufferMode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClampColor(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum clamp;
    clamp = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClampColor(target, clamp);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBeginConditionalRender(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint id;
    id = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(id) << " <- " << size_t(_query_map[id]) << "\n";
    }
    id = _query_map[id];

    GLenum mode;
    mode = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBeginConditionalRender(id, mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEndConditionalRender(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEndConditionalRender();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribIPointer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint size;
    size = (call.arg(1)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei stride;
    stride = (call.arg(3)).toSInt();

    const GLvoid * pointer;
    pointer = static_cast<const GLvoid *>(retrace::toPointer(call.arg(4), true));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribIPointer(index, size, type, stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI1i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint x;
    x = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI1i(index, x);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI2i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint x;
    x = (call.arg(1)).toSInt();

    GLint y;
    y = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI2i(index, x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI3i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint x;
    x = (call.arg(1)).toSInt();

    GLint y;
    y = (call.arg(2)).toSInt();

    GLint z;
    z = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI3i(index, x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI4i(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint x;
    x = (call.arg(1)).toSInt();

    GLint y;
    y = (call.arg(2)).toSInt();

    GLint z;
    z = (call.arg(3)).toSInt();

    GLint w;
    w = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI4i(index, x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI1ui(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint x;
    x = (call.arg(1)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI1ui(index, x);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI2ui(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint x;
    x = (call.arg(1)).toUInt();

    GLuint y;
    y = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI2ui(index, x, y);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI3ui(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint x;
    x = (call.arg(1)).toUInt();

    GLuint y;
    y = (call.arg(2)).toUInt();

    GLuint z;
    z = (call.arg(3)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI3ui(index, x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI4ui(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint x;
    x = (call.arg(1)).toUInt();

    GLuint y;
    y = (call.arg(2)).toUInt();

    GLuint z;
    z = (call.arg(3)).toUInt();

    GLuint w;
    w = (call.arg(4)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI4ui(index, x, y, z, w);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI1iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(1));
    if (v) {
        const trace::Array *_a_PGLint32_0 = (call.arg(1)).toArray();
    v[0] = (*_a_PGLint32_0->values[0]).toSInt();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI1iv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI2iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint169_0 = (call.arg(1)).toArray();
    if (_a_GLint169_0) {
        for (size_t _jGLint169 = 0; _jGLint169 < _a_GLint169_0->values.size(); ++_jGLint169) {
    v[_jGLint169] = (*_a_GLint169_0->values[_jGLint169]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI2iv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI3iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint170_0 = (call.arg(1)).toArray();
    if (_a_GLint170_0) {
        for (size_t _jGLint170 = 0; _jGLint170 < _a_GLint170_0->values.size(); ++_jGLint170) {
    v[_jGLint170] = (*_a_GLint170_0->values[_jGLint170]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI3iv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI4iv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLint * v;
    v = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint171_0 = (call.arg(1)).toArray();
    if (_a_GLint171_0) {
        for (size_t _jGLint171 = 0; _jGLint171 < _a_GLint171_0->values.size(); ++_jGLint171) {
    v[_jGLint171] = (*_a_GLint171_0->values[_jGLint171]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI4iv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI1uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint * v;
    v = _allocator.allocArray<GLuint>(&call.arg(1));
    if (v) {
        const trace::Array *_a_PGLuint41_0 = (call.arg(1)).toArray();
    v[0] = (*_a_PGLuint41_0->values[0]).toUInt();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI1uiv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI2uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint * v;
    v = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint99_0 = (call.arg(1)).toArray();
    if (_a_GLuint99_0) {
        for (size_t _jGLuint99 = 0; _jGLuint99 < _a_GLuint99_0->values.size(); ++_jGLuint99) {
    v[_jGLuint99] = (*_a_GLuint99_0->values[_jGLuint99]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI2uiv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI3uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint * v;
    v = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint100_0 = (call.arg(1)).toArray();
    if (_a_GLuint100_0) {
        for (size_t _jGLuint100 = 0; _jGLuint100 < _a_GLuint100_0->values.size(); ++_jGLuint100) {
    v[_jGLuint100] = (*_a_GLuint100_0->values[_jGLuint100]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI3uiv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI4uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint * v;
    v = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint101_0 = (call.arg(1)).toArray();
    if (_a_GLuint101_0) {
        for (size_t _jGLuint101 = 0; _jGLuint101 < _a_GLuint101_0->values.size(); ++_jGLuint101) {
    v[_jGLuint101] = (*_a_GLuint101_0->values[_jGLuint101]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI4uiv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI4bv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLbyte * v;
    v = _allocator.allocArray<GLbyte>(&call.arg(1));
    const trace::Array *_a_GLbyte7_0 = (call.arg(1)).toArray();
    if (_a_GLbyte7_0) {
        for (size_t _jGLbyte7 = 0; _jGLbyte7 < _a_GLbyte7_0->values.size(); ++_jGLbyte7) {
    v[_jGLbyte7] = (*_a_GLbyte7_0->values[_jGLbyte7]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI4bv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI4sv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLshort * v;
    v = _allocator.allocArray<GLshort>(&call.arg(1));
    const trace::Array *_a_GLshort25_0 = (call.arg(1)).toArray();
    if (_a_GLshort25_0) {
        for (size_t _jGLshort25 = 0; _jGLshort25 < _a_GLshort25_0->values.size(); ++_jGLshort25) {
    v[_jGLshort25] = (*_a_GLshort25_0->values[_jGLshort25]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI4sv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI4ubv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLubyte * v;
    v = _allocator.allocArray<GLubyte>(&call.arg(1));
    const trace::Array *_a_GLubyte12_0 = (call.arg(1)).toArray();
    if (_a_GLubyte12_0) {
        for (size_t _jGLubyte12 = 0; _jGLubyte12 < _a_GLubyte12_0->values.size(); ++_jGLubyte12) {
    v[_jGLubyte12] = (*_a_GLubyte12_0->values[_jGLubyte12]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI4ubv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribI4usv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLushort * v;
    v = _allocator.allocArray<GLushort>(&call.arg(1));
    const trace::Array *_a_GLushort9_0 = (call.arg(1)).toArray();
    if (_a_GLushort9_0) {
        for (size_t _jGLushort9 = 0; _jGLushort9 < _a_GLushort9_0->values.size(); ++_jGLushort9) {
    v[_jGLushort9] = (*_a_GLushort9_0->values[_jGLushort9]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribI4usv(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBindFragDataLocation(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    GLuint color;
    color = (call.arg(1)).toUInt();

    const GLchar * name;
    name = (const GLchar *)((call.arg(2)).toString());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBindFragDataLocation(program, color, name);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform1ui(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLuint v0;
    v0 = (call.arg(1)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform1ui(location, v0);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform2ui(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLuint v0;
    v0 = (call.arg(1)).toUInt();

    GLuint v1;
    v1 = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform2ui(location, v0, v1);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform3ui(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLuint v0;
    v0 = (call.arg(1)).toUInt();

    GLuint v1;
    v1 = (call.arg(2)).toUInt();

    GLuint v2;
    v2 = (call.arg(3)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform3ui(location, v0, v1, v2);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform4ui(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLuint v0;
    v0 = (call.arg(1)).toUInt();

    GLuint v1;
    v1 = (call.arg(2)).toUInt();

    GLuint v2;
    v2 = (call.arg(3)).toUInt();

    GLuint v3;
    v3 = (call.arg(4)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform4ui(location, v0, v1, v2, v3);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform1uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLuint * value;
    value = _allocator.allocArray<GLuint>(&call.arg(2));
    const trace::Array *_a_GLuint102_0 = (call.arg(2)).toArray();
    if (_a_GLuint102_0) {
        for (size_t _jGLuint102 = 0; _jGLuint102 < _a_GLuint102_0->values.size(); ++_jGLuint102) {
    value[_jGLuint102] = (*_a_GLuint102_0->values[_jGLuint102]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform1uiv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform2uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLuint * value;
    value = _allocator.allocArray<GLuint>(&call.arg(2));
    const trace::Array *_a_GLuint103_0 = (call.arg(2)).toArray();
    if (_a_GLuint103_0) {
        for (size_t _jGLuint103 = 0; _jGLuint103 < _a_GLuint103_0->values.size(); ++_jGLuint103) {
    value[_jGLuint103] = (*_a_GLuint103_0->values[_jGLuint103]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform2uiv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform3uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLuint * value;
    value = _allocator.allocArray<GLuint>(&call.arg(2));
    const trace::Array *_a_GLuint104_0 = (call.arg(2)).toArray();
    if (_a_GLuint104_0) {
        for (size_t _jGLuint104 = 0; _jGLuint104 < _a_GLuint104_0->values.size(); ++_jGLuint104) {
    value[_jGLuint104] = (*_a_GLuint104_0->values[_jGLuint104]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform3uiv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniform4uiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLuint * value;
    value = _allocator.allocArray<GLuint>(&call.arg(2));
    const trace::Array *_a_GLuint105_0 = (call.arg(2)).toArray();
    if (_a_GLuint105_0) {
        for (size_t _jGLuint105 = 0; _jGLuint105 < _a_GLuint105_0->values.size(); ++_jGLuint105) {
    value[_jGLuint105] = (*_a_GLuint105_0->values[_jGLuint105]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniform4uiv(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexParameterIiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint * params;
    params = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint172_0 = (call.arg(2)).toArray();
    if (_a_GLint172_0) {
        for (size_t _jGLint172 = 0; _jGLint172 < _a_GLint172_0->values.size(); ++_jGLint172) {
    params[_jGLint172] = (*_a_GLint172_0->values[_jGLint172]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexParameterIiv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexParameterIuiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLuint * params;
    params = _allocator.allocArray<GLuint>(&call.arg(2));
    const trace::Array *_a_GLuint106_0 = (call.arg(2)).toArray();
    if (_a_GLuint106_0) {
        for (size_t _jGLuint106 = 0; _jGLuint106 < _a_GLuint106_0->values.size(); ++_jGLuint106) {
    params[_jGLuint106] = (*_a_GLuint106_0->values[_jGLuint106]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexParameterIuiv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearBufferiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum buffer;
    buffer = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint drawbuffer;
    drawbuffer = (call.arg(1)).toSInt();

    GLint * value;
    value = _allocator.allocArray<GLint>(&call.arg(2));
    const trace::Array *_a_GLint173_0 = (call.arg(2)).toArray();
    if (_a_GLint173_0) {
        for (size_t _jGLint173 = 0; _jGLint173 < _a_GLint173_0->values.size(); ++_jGLint173) {
    value[_jGLint173] = (*_a_GLint173_0->values[_jGLint173]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearBufferiv(buffer, drawbuffer, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearBufferuiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum buffer;
    buffer = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint drawbuffer;
    drawbuffer = (call.arg(1)).toSInt();

    GLuint * value;
    value = _allocator.allocArray<GLuint>(&call.arg(2));
    const trace::Array *_a_GLuint107_0 = (call.arg(2)).toArray();
    if (_a_GLuint107_0) {
        for (size_t _jGLuint107 = 0; _jGLuint107 < _a_GLuint107_0->values.size(); ++_jGLuint107) {
    value[_jGLuint107] = (*_a_GLuint107_0->values[_jGLuint107]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearBufferuiv(buffer, drawbuffer, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearBufferfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum buffer;
    buffer = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint drawbuffer;
    drawbuffer = (call.arg(1)).toSInt();

    GLfloat * value;
    value = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat142_0 = (call.arg(2)).toArray();
    if (_a_GLfloat142_0) {
        for (size_t _jGLfloat142 = 0; _jGLfloat142 < _a_GLfloat142_0->values.size(); ++_jGLfloat142) {
    value[_jGLfloat142] = (*_a_GLfloat142_0->values[_jGLfloat142]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearBufferfv(buffer, drawbuffer, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearBufferfi(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum buffer;
    buffer = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint drawbuffer;
    drawbuffer = (call.arg(1)).toSInt();

    GLfloat depth;
    depth = (call.arg(2)).toFloat();

    GLint stencil;
    stencil = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearBufferfi(buffer, drawbuffer, depth, stencil);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDrawArraysInstanced(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint first;
    first = (call.arg(1)).toSInt();

    GLsizei count;
    count = (call.arg(2)).toSInt();

    GLsizei instancecount;
    instancecount = (call.arg(3)).toSInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDrawArraysInstanced(mode, first, count, instancecount);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glDrawElementsInstanced(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _element_array_buffer = 0;
        glGetIntegerv(GL_ELEMENT_ARRAY_BUFFER_BINDING, &_element_array_buffer);
        if (!_element_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    const GLvoid * indices;
    indices = static_cast<const GLvoid *>((call.arg(3)).toPointer());

    GLsizei instancecount;
    instancecount = (call.arg(4)).toSInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDrawElementsInstanced(mode, count, type, indices, instancecount);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glTexBuffer(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLuint buffer;
    buffer = (call.arg(2)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << size_t(buffer) << " <- " << size_t(_buffer_map[buffer]) << "\n";
    }
    buffer = _buffer_map[buffer];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexBuffer(target, internalformat, buffer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPrimitiveRestartIndex(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPrimitiveRestartIndex(index);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFramebufferTexture(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum attachment;
    attachment = static_cast<GLenum>((call.arg(1)).toSInt());

    GLuint texture;
    texture = (call.arg(2)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(texture) << " <- " << size_t(_texture_map[texture]) << "\n";
    }
    texture = _texture_map[texture];

    GLint level;
    level = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFramebufferTexture(target, attachment, texture, level);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribDivisor(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint divisor;
    divisor = (call.arg(1)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribDivisor(index, divisor);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMinSampleShading(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat value;
    value = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMinSampleShading(value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendEquationi(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint buf;
    buf = (call.arg(0)).toUInt();

    GLenum mode;
    mode = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendEquationi(buf, mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendEquationSeparatei(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint buf;
    buf = (call.arg(0)).toUInt();

    GLenum modeRGB;
    modeRGB = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum modeAlpha;
    modeAlpha = static_cast<GLenum>((call.arg(2)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendEquationSeparatei(buf, modeRGB, modeAlpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendFunci(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint buf;
    buf = (call.arg(0)).toUInt();

    GLenum src;
    src = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum dst;
    dst = static_cast<GLenum>((call.arg(2)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendFunci(buf, src, dst);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendFuncSeparatei(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint buf;
    buf = (call.arg(0)).toUInt();

    GLenum srcRGB;
    srcRGB = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum dstRGB;
    dstRGB = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum srcAlpha;
    srcAlpha = static_cast<GLenum>((call.arg(3)).toSInt());

    GLenum dstAlpha;
    dstAlpha = static_cast<GLenum>((call.arg(4)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetnCompressedTexImage(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint lod;
    lod = (call.arg(1)).toSInt();

    GLsizei bufSize;
    bufSize = (call.arg(2)).toSInt();

    void * pixels;
    pixels = static_cast<void *>((call.arg(3)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetnCompressedTexImage(target, lod, bufSize, pixels);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetnTexImage(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint level;
    level = (call.arg(1)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(3)).toSInt());

    GLsizei bufSize;
    bufSize = (call.arg(4)).toSInt();

    void * pixels;
    pixels = static_cast<void *>((call.arg(5)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetnTexImage(target, level, format, type, bufSize, pixels);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetnPixelMapfv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum map;
    map = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei bufSize;
    bufSize = (call.arg(1)).toSInt();

    GLfloat * values;
    values = static_cast<GLfloat *>((call.arg(2)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetnPixelMapfv(map, bufSize, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLfloat144 = (call.arg(2)).toArray();
    if (_aGLfloat144) {
        for (size_t _jGLfloat144 = 0; _jGLfloat144 < _aGLfloat144->values.size(); ++_jGLfloat144) {
        }
    }
}

static void retrace_glGetnPixelMapuiv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum map;
    map = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei bufSize;
    bufSize = (call.arg(1)).toSInt();

    GLuint * values;
    values = static_cast<GLuint *>((call.arg(2)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetnPixelMapuiv(map, bufSize, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint109 = (call.arg(2)).toArray();
    if (_aGLuint109) {
        for (size_t _jGLuint109 = 0; _jGLuint109 < _aGLuint109->values.size(); ++_jGLuint109) {
        }
    }
}

static void retrace_glGetnPixelMapusv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum map;
    map = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei bufSize;
    bufSize = (call.arg(1)).toSInt();

    GLushort * values;
    values = static_cast<GLushort *>((call.arg(2)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetnPixelMapusv(map, bufSize, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLushort11 = (call.arg(2)).toArray();
    if (_aGLushort11) {
        for (size_t _jGLushort11 = 0; _jGLushort11 < _aGLushort11->values.size(); ++_jGLushort11) {
        }
    }
}

static void retrace_glGetnPolygonStipple(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei bufSize;
    bufSize = (call.arg(0)).toSInt();

    GLubyte * pattern;
    pattern = static_cast<GLubyte *>((call.arg(1)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetnPolygonStipple(bufSize, pattern);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLubyte14 = (call.arg(1)).toArray();
    if (_aGLubyte14) {
        for (size_t _jGLubyte14 = 0; _jGLubyte14 < _aGLubyte14->values.size(); ++_jGLubyte14) {
        }
    }
}

static void retrace_glGetnConvolutionFilter(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum format;
    format = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei bufSize;
    bufSize = (call.arg(3)).toSInt();

    void * image;
    image = static_cast<void *>((call.arg(4)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetnConvolutionFilter(target, format, type, bufSize, image);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetnSeparableFilter(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum format;
    format = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei rowBufSize;
    rowBufSize = (call.arg(3)).toSInt();

    void * row;
    row = static_cast<void *>((call.arg(4)).toPointer());

    GLsizei columnBufSize;
    columnBufSize = (call.arg(5)).toSInt();

    void * column;
    column = static_cast<void *>((call.arg(6)).toPointer());

    GLvoid * span;
    span = static_cast<GLvoid *>((call.arg(7)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetnSeparableFilter(target, format, type, rowBufSize, row, columnBufSize, column, span);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetnHistogram(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLboolean reset;
    reset = static_cast<GLboolean>((call.arg(1)).toSInt());

    GLenum format;
    format = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(3)).toSInt());

    GLsizei bufSize;
    bufSize = (call.arg(4)).toSInt();

    void * values;
    values = static_cast<void *>((call.arg(5)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetnHistogram(target, reset, format, type, bufSize, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetnMinmax(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLboolean reset;
    reset = static_cast<GLboolean>((call.arg(1)).toSInt());

    GLenum format;
    format = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(3)).toSInt());

    GLsizei bufSize;
    bufSize = (call.arg(4)).toSInt();

    void * values;
    values = static_cast<void *>((call.arg(5)).toPointer());

    GLint _pack_buffer = 0;
    if (currentContext && currentContext->features().pixel_buffer_object) {
        glGetIntegerv(GL_PIXEL_PACK_BUFFER_BINDING, &_pack_buffer);
    }
     std::vector<char> buffer;
    if (!_pack_buffer) {
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetnMinmax(target, reset, format, type, bufSize, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSpecializeShader(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint shader;
    shader = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_handleARB_map[shader]) << "\n";
    }
    shader = _handleARB_map[shader];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "shader " << size_t(shader) << " <- " << size_t(_shader_map[shader]) << "\n";
    }
    shader = _shader_map[shader];
}

    const GLchar * pEntryPoint;
    pEntryPoint = (const GLchar *)((call.arg(1)).toString());

    GLuint numSpecializationConstants;
    numSpecializationConstants = (call.arg(2)).toUInt();

    GLuint * pConstantIndex;
    pConstantIndex = _allocator.allocArray<GLuint>(&call.arg(3));
    const trace::Array *_a_GLuint110_0 = (call.arg(3)).toArray();
    if (_a_GLuint110_0) {
        for (size_t _jGLuint110 = 0; _jGLuint110 < _a_GLuint110_0->values.size(); ++_jGLuint110) {
    pConstantIndex[_jGLuint110] = (*_a_GLuint110_0->values[_jGLuint110]).toUInt();
        }
    }

    GLuint * pConstantValue;
    pConstantValue = _allocator.allocArray<GLuint>(&call.arg(4));
    const trace::Array *_a_GLuint111_0 = (call.arg(4)).toArray();
    if (_a_GLuint111_0) {
        for (size_t _jGLuint111 = 0; _jGLuint111 < _a_GLuint111_0->values.size(); ++_jGLuint111) {
    pConstantValue[_jGLuint111] = (*_a_GLuint111_0->values[_jGLuint111]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSpecializeShader(shader, pEntryPoint, numSpecializationConstants, pConstantIndex, pConstantValue);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiDrawArraysIndirectCount(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    const GLvoid * indirect;
    indirect = static_cast<const GLvoid *>((call.arg(1)).toPointer());

    GLintptr drawcount;
    drawcount = (call.arg(2)).toSInt();

    GLsizei maxdrawcount;
    maxdrawcount = (call.arg(3)).toSInt();

    GLsizei stride;
    stride = (call.arg(4)).toSInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glMultiDrawArraysIndirectCount(mode, indirect, drawcount, maxdrawcount, stride);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glMultiDrawElementsIndirectCount(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(1)).toSInt());

    const GLvoid * indirect;
    indirect = static_cast<const GLvoid *>((call.arg(2)).toPointer());

    GLintptr drawcount;
    drawcount = (call.arg(3)).toSInt();

    GLsizei maxdrawcount;
    maxdrawcount = (call.arg(4)).toSInt();

    GLsizei stride;
    stride = (call.arg(5)).toSInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glMultiDrawElementsIndirectCount(mode, type, indirect, drawcount, maxdrawcount, stride);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glClipPlanef(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum plane;
    plane = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfloat * equation;
    equation = _allocator.allocArray<GLfloat>(&call.arg(1));
    const trace::Array *_a_GLfloat145_0 = (call.arg(1)).toArray();
    if (_a_GLfloat145_0) {
        for (size_t _jGLfloat145 = 0; _jGLfloat145 < _a_GLfloat145_0->values.size(); ++_jGLfloat145) {
    equation[_jGLfloat145] = (*_a_GLfloat145_0->values[_jGLfloat145]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClipPlanef(plane, equation);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFrustumf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat left;
    left = (call.arg(0)).toFloat();

    GLfloat right;
    right = (call.arg(1)).toFloat();

    GLfloat bottom;
    bottom = (call.arg(2)).toFloat();

    GLfloat top;
    top = (call.arg(3)).toFloat();

    GLfloat zNear;
    zNear = (call.arg(4)).toFloat();

    GLfloat zFar;
    zFar = (call.arg(5)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFrustumf(left, right, bottom, top, zNear, zFar);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glOrthof(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat left;
    left = (call.arg(0)).toFloat();

    GLfloat right;
    right = (call.arg(1)).toFloat();

    GLfloat bottom;
    bottom = (call.arg(2)).toFloat();

    GLfloat top;
    top = (call.arg(3)).toFloat();

    GLfloat zNear;
    zNear = (call.arg(4)).toFloat();

    GLfloat zFar;
    zFar = (call.arg(5)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glOrthof(left, right, bottom, top, zNear, zFar);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glAlphaFuncx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum func;
    func = static_cast<GLenum>((call.arg(0)).toSInt());

    GLclampx ref;
    ref = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glAlphaFuncx(func, ref);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearColorx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLclampx red;
    red = (call.arg(0)).toSInt();

    GLclampx green;
    green = (call.arg(1)).toSInt();

    GLclampx blue;
    blue = (call.arg(2)).toSInt();

    GLclampx alpha;
    alpha = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearColorx(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearDepthx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLclampx depth;
    depth = (call.arg(0)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearDepthx(depth);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClipPlanex(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum plane;
    plane = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfixed * equation;
    equation = _allocator.allocArray<GLfixed>(&call.arg(1));
    const trace::Array *_a_GLfixed9_0 = (call.arg(1)).toArray();
    if (_a_GLfixed9_0) {
        for (size_t _jGLfixed9 = 0; _jGLfixed9 < _a_GLfixed9_0->values.size(); ++_jGLfixed9) {
    equation[_jGLfixed9] = (*_a_GLfixed9_0->values[_jGLfixed9]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClipPlanex(plane, equation);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glColor4x(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed red;
    red = (call.arg(0)).toSInt();

    GLfixed green;
    green = (call.arg(1)).toSInt();

    GLfixed blue;
    blue = (call.arg(2)).toSInt();

    GLfixed alpha;
    alpha = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glColor4x(red, green, blue, alpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDepthRangex(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLclampx zNear;
    zNear = (call.arg(0)).toSInt();

    GLclampx zFar;
    zFar = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDepthRangex(zNear, zFar);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFogx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfixed param;
    param = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFogx(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFogxv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfixed * params;
    params = _allocator.allocArray<GLfixed>(&call.arg(1));
    const trace::Array *_a_GLfixed10_0 = (call.arg(1)).toArray();
    if (_a_GLfixed10_0) {
        for (size_t _jGLfixed10 = 0; _jGLfixed10 < _a_GLfixed10_0->values.size(); ++_jGLfixed10) {
    params[_jGLfixed10] = (*_a_GLfixed10_0->values[_jGLfixed10]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFogxv(pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFrustumx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed left;
    left = (call.arg(0)).toSInt();

    GLfixed right;
    right = (call.arg(1)).toSInt();

    GLfixed bottom;
    bottom = (call.arg(2)).toSInt();

    GLfixed top;
    top = (call.arg(3)).toSInt();

    GLfixed zNear;
    zNear = (call.arg(4)).toSInt();

    GLfixed zFar;
    zFar = (call.arg(5)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFrustumx(left, right, bottom, top, zNear, zFar);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLightModelx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfixed param;
    param = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLightModelx(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLightModelxv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfixed * params;
    params = _allocator.allocArray<GLfixed>(&call.arg(1));
    const trace::Array *_a_GLfixed11_0 = (call.arg(1)).toArray();
    if (_a_GLfixed11_0) {
        for (size_t _jGLfixed11 = 0; _jGLfixed11 < _a_GLfixed11_0->values.size(); ++_jGLfixed11) {
    params[_jGLfixed11] = (*_a_GLfixed11_0->values[_jGLfixed11]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLightModelxv(pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLightx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum light;
    light = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfixed param;
    param = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLightx(light, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLightxv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum light;
    light = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfixed * params;
    params = _allocator.allocArray<GLfixed>(&call.arg(2));
    const trace::Array *_a_GLfixed12_0 = (call.arg(2)).toArray();
    if (_a_GLfixed12_0) {
        for (size_t _jGLfixed12 = 0; _jGLfixed12 < _a_GLfixed12_0->values.size(); ++_jGLfixed12) {
    params[_jGLfixed12] = (*_a_GLfixed12_0->values[_jGLfixed12]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLightxv(light, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLineWidthx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed width;
    width = (call.arg(0)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLineWidthx(width);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glLoadMatrixx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed * m;
    m = _allocator.allocArray<GLfixed>(&call.arg(0));
    const trace::Array *_a_GLfixed13_0 = (call.arg(0)).toArray();
    if (_a_GLfixed13_0) {
        for (size_t _jGLfixed13 = 0; _jGLfixed13 < _a_GLfixed13_0->values.size(); ++_jGLfixed13) {
    m[_jGLfixed13] = (*_a_GLfixed13_0->values[_jGLfixed13]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glLoadMatrixx(m);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMaterialx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfixed param;
    param = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMaterialx(face, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMaterialxv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfixed * params;
    params = _allocator.allocArray<GLfixed>(&call.arg(2));
    const trace::Array *_a_GLfixed14_0 = (call.arg(2)).toArray();
    if (_a_GLfixed14_0) {
        for (size_t _jGLfixed14 = 0; _jGLfixed14 < _a_GLfixed14_0->values.size(); ++_jGLfixed14) {
    params[_jGLfixed14] = (*_a_GLfixed14_0->values[_jGLfixed14]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMaterialxv(face, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultMatrixx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed * m;
    m = _allocator.allocArray<GLfixed>(&call.arg(0));
    const trace::Array *_a_GLfixed15_0 = (call.arg(0)).toArray();
    if (_a_GLfixed15_0) {
        for (size_t _jGLfixed15 = 0; _jGLfixed15 < _a_GLfixed15_0->values.size(); ++_jGLfixed15) {
    m[_jGLfixed15] = (*_a_GLfixed15_0->values[_jGLfixed15]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultMatrixx(m);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiTexCoord4x(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfixed s;
    s = (call.arg(1)).toSInt();

    GLfixed t;
    t = (call.arg(2)).toSInt();

    GLfixed r;
    r = (call.arg(3)).toSInt();

    GLfixed q;
    q = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiTexCoord4x(target, s, t, r, q);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNormal3x(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed nx;
    nx = (call.arg(0)).toSInt();

    GLfixed ny;
    ny = (call.arg(1)).toSInt();

    GLfixed nz;
    nz = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNormal3x(nx, ny, nz);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glOrthox(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed left;
    left = (call.arg(0)).toSInt();

    GLfixed right;
    right = (call.arg(1)).toSInt();

    GLfixed bottom;
    bottom = (call.arg(2)).toSInt();

    GLfixed top;
    top = (call.arg(3)).toSInt();

    GLfixed zNear;
    zNear = (call.arg(4)).toSInt();

    GLfixed zFar;
    zFar = (call.arg(5)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glOrthox(left, right, bottom, top, zNear, zFar);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPointParameterx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfixed param;
    param = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPointParameterx(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPointParameterxv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLfixed * params;
    params = _allocator.allocArray<GLfixed>(&call.arg(1));
    const trace::Array *_a_GLfixed16_0 = (call.arg(1)).toArray();
    if (_a_GLfixed16_0) {
        for (size_t _jGLfixed16 = 0; _jGLfixed16 < _a_GLfixed16_0->values.size(); ++_jGLfixed16) {
    params[_jGLfixed16] = (*_a_GLfixed16_0->values[_jGLfixed16]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPointParameterxv(pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPointSizex(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed size;
    size = (call.arg(0)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPointSizex(size);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPolygonOffsetx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed factor;
    factor = (call.arg(0)).toSInt();

    GLfixed units;
    units = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPolygonOffsetx(factor, units);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRotatex(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed angle;
    angle = (call.arg(0)).toSInt();

    GLfixed x;
    x = (call.arg(1)).toSInt();

    GLfixed y;
    y = (call.arg(2)).toSInt();

    GLfixed z;
    z = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRotatex(angle, x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSampleCoveragex(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLclampx value;
    value = (call.arg(0)).toSInt();

    GLboolean invert;
    invert = static_cast<GLboolean>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSampleCoveragex(value, invert);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glScalex(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed x;
    x = (call.arg(0)).toSInt();

    GLfixed y;
    y = (call.arg(1)).toSInt();

    GLfixed z;
    z = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glScalex(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexEnvx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfixed param;
    param = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexEnvx(target, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexEnvxv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfixed * params;
    params = _allocator.allocArray<GLfixed>(&call.arg(2));
    const trace::Array *_a_GLfixed17_0 = (call.arg(2)).toArray();
    if (_a_GLfixed17_0) {
        for (size_t _jGLfixed17 = 0; _jGLfixed17 < _a_GLfixed17_0->values.size(); ++_jGLfixed17) {
    params[_jGLfixed17] = (*_a_GLfixed17_0->values[_jGLfixed17]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexEnvxv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexParameterx(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfixed param;
    param = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexParameterx(target, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexParameterxv(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLfixed * params;
    params = _allocator.allocArray<GLfixed>(&call.arg(2));
    const trace::Array *_a_GLfixed18_0 = (call.arg(2)).toArray();
    if (_a_GLfixed18_0) {
        for (size_t _jGLfixed18 = 0; _jGLfixed18 < _a_GLfixed18_0->values.size(); ++_jGLfixed18) {
    params[_jGLfixed18] = (*_a_GLfixed18_0->values[_jGLfixed18]).toSInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexParameterxv(target, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTranslatex(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfixed x;
    x = (call.arg(0)).toSInt();

    GLfixed y;
    y = (call.arg(1)).toSInt();

    GLfixed z;
    z = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTranslatex(x, y, z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendBarrier(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendBarrier();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPrimitiveBoundingBox(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat minX;
    minX = (call.arg(0)).toFloat();

    GLfloat minY;
    minY = (call.arg(1)).toFloat();

    GLfloat minZ;
    minZ = (call.arg(2)).toFloat();

    GLfloat minW;
    minW = (call.arg(3)).toFloat();

    GLfloat maxX;
    maxX = (call.arg(4)).toFloat();

    GLfloat maxY;
    maxY = (call.arg(5)).toFloat();

    GLfloat maxZ;
    maxZ = (call.arg(6)).toFloat();

    GLfloat maxW;
    maxW = (call.arg(7)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPrimitiveBoundingBox(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTbufferMask3DFX(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint mask;
    mask = (call.arg(0)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTbufferMask3DFX(mask);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDebugMessageEnableAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum category;
    category = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum severity;
    severity = static_cast<GLenum>((call.arg(1)).toSInt());

    GLsizei count;
    count = (call.arg(2)).toSInt();

    GLuint * ids;
    ids = _allocator.allocArray<GLuint>(&call.arg(3));
    const trace::Array *_a_GLuint112_0 = (call.arg(3)).toArray();
    if (_a_GLuint112_0) {
        for (size_t _jGLuint112 = 0; _jGLuint112 < _a_GLuint112_0->values.size(); ++_jGLuint112) {
    ids[_jGLuint112] = (*_a_GLuint112_0->values[_jGLuint112]).toUInt();
        }
    }

    GLboolean enabled;
    enabled = static_cast<GLboolean>((call.arg(4)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDebugMessageEnableAMD(category, severity, count, ids, enabled);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDebugMessageInsertAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum category;
    category = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum severity;
    severity = static_cast<GLenum>((call.arg(1)).toSInt());

    GLuint id;
    id = (call.arg(2)).toUInt();

    GLsizei length;
    length = (call.arg(3)).toSInt();

    const GLchar * buf;
    buf = (const GLchar *)((call.arg(4)).toString());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDebugMessageInsertAMD(category, severity, id, length, buf);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendFuncIndexedAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint buf;
    buf = (call.arg(0)).toUInt();

    GLenum src;
    src = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum dst;
    dst = static_cast<GLenum>((call.arg(2)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendFuncIndexedAMD(buf, src, dst);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendFuncSeparateIndexedAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint buf;
    buf = (call.arg(0)).toUInt();

    GLenum srcRGB;
    srcRGB = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum dstRGB;
    dstRGB = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum srcAlpha;
    srcAlpha = static_cast<GLenum>((call.arg(3)).toSInt());

    GLenum dstAlpha;
    dstAlpha = static_cast<GLenum>((call.arg(4)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendFuncSeparateIndexedAMD(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendEquationIndexedAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint buf;
    buf = (call.arg(0)).toUInt();

    GLenum mode;
    mode = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendEquationIndexedAMD(buf, mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlendEquationSeparateIndexedAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint buf;
    buf = (call.arg(0)).toUInt();

    GLenum modeRGB;
    modeRGB = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum modeAlpha;
    modeAlpha = static_cast<GLenum>((call.arg(2)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBlendEquationSeparateIndexedAMD(buf, modeRGB, modeAlpha);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribParameteriAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint param;
    param = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribParameteriAMD(index, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiDrawArraysIndirectAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    const GLvoid * indirect;
    indirect = static_cast<const GLvoid *>(retrace::toPointer(call.arg(1)));

    GLsizei drawcount;
    drawcount = (call.arg(2)).toSInt();

    GLsizei stride;
    stride = (call.arg(3)).toSInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glMultiDrawArraysIndirectAMD(mode, indirect, drawcount, stride);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glMultiDrawElementsIndirectAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(1)).toSInt());

    const GLvoid * indirect;
    indirect = static_cast<const GLvoid *>(retrace::toPointer(call.arg(2)));

    GLsizei drawcount;
    drawcount = (call.arg(3)).toSInt();

    GLsizei stride;
    stride = (call.arg(4)).toSInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glMultiDrawElementsIndirectAMD(mode, type, indirect, drawcount, stride);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glGenNamesAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum identifier;
    identifier = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint num;
    num = (call.arg(1)).toUInt();

    GLuint * names;
    names = _allocator.allocArray<GLuint>(&call.arg(2));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGenNamesAMD(identifier, num, names);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint114 = (call.arg(2)).toArray();
    if (_aGLuint114) {
        for (size_t _jGLuint114 = 0; _jGLuint114 < _aGLuint114->values.size(); ++_jGLuint114) {
        }
    }
}

static void retrace_glDeleteNamesAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum identifier;
    identifier = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint num;
    num = (call.arg(1)).toUInt();

    GLuint * names;
    names = _allocator.allocArray<GLuint>(&call.arg(2));
    const trace::Array *_a_GLuint115_0 = (call.arg(2)).toArray();
    if (_a_GLuint115_0) {
        for (size_t _jGLuint115 = 0; _jGLuint115 < _a_GLuint115_0->values.size(); ++_jGLuint115) {
    names[_jGLuint115] = (*_a_GLuint115_0->values[_jGLuint115]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeleteNamesAMD(identifier, num, names);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glQueryObjectParameteruiAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint id;
    id = (call.arg(1)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(id) << " <- " << size_t(_query_map[id]) << "\n";
    }
    id = _query_map[id];

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(2)).toSInt());

    GLuint param;
    param = (call.arg(3)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glQueryObjectParameteruiAMD(target, id, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGenPerfMonitorsAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * monitors;
    monitors = _allocator.allocArray<GLuint>(&call.arg(1));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGenPerfMonitorsAMD(n, monitors);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint117 = (call.arg(1)).toArray();
    if (_aGLuint117) {
        for (size_t _jGLuint117 = 0; _jGLuint117 < _aGLuint117->values.size(); ++_jGLuint117) {
        }
    }
}

static void retrace_glDeletePerfMonitorsAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * monitors;
    monitors = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint118_0 = (call.arg(1)).toArray();
    if (_a_GLuint118_0) {
        for (size_t _jGLuint118 = 0; _jGLuint118 < _a_GLuint118_0->values.size(); ++_jGLuint118) {
    monitors[_jGLuint118] = (*_a_GLuint118_0->values[_jGLuint118]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeletePerfMonitorsAMD(n, monitors);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSelectPerfMonitorCountersAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint monitor;
    monitor = (call.arg(0)).toUInt();

    GLboolean enable;
    enable = static_cast<GLboolean>((call.arg(1)).toSInt());

    GLuint group;
    group = (call.arg(2)).toUInt();

    GLint numCounters;
    numCounters = (call.arg(3)).toSInt();

    GLuint * counterList;
    counterList = _allocator.allocArray<GLuint>(&call.arg(4));
    const trace::Array *_a_GLuint119_0 = (call.arg(4)).toArray();
    if (_a_GLuint119_0) {
        for (size_t _jGLuint119 = 0; _jGLuint119 < _a_GLuint119_0->values.size(); ++_jGLuint119) {
    counterList[_jGLuint119] = (*_a_GLuint119_0->values[_jGLuint119]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, counterList);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBeginPerfMonitorAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint monitor;
    monitor = (call.arg(0)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBeginPerfMonitorAMD(monitor);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEndPerfMonitorAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint monitor;
    monitor = (call.arg(0)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEndPerfMonitorAMD(monitor);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSetMultisamplefvAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint index;
    index = (call.arg(1)).toUInt();

    GLfloat * val;
    val = _allocator.allocArray<GLfloat>(&call.arg(2));
    const trace::Array *_a_GLfloat146_0 = (call.arg(2)).toArray();
    if (_a_GLfloat146_0) {
        for (size_t _jGLfloat146 = 0; _jGLfloat146 < _a_GLfloat146_0->values.size(); ++_jGLfloat146) {
    val[_jGLfloat146] = (*_a_GLfloat146_0->values[_jGLfloat146]).toFloat();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSetMultisamplefvAMD(pname, index, val);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTexStorageSparseAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalFormat;
    internalFormat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLsizei width;
    width = (call.arg(2)).toSInt();

    GLsizei height;
    height = (call.arg(3)).toSInt();

    GLsizei depth;
    depth = (call.arg(4)).toSInt();

    GLsizei layers;
    layers = (call.arg(5)).toSInt();

    GLbitfield flags;
    flags = static_cast<GLbitfield>((call.arg(6)).toUInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTexStorageSparseAMD(target, internalFormat, width, height, depth, layers, flags);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTextureStorageSparseAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint texture;
    texture = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(texture) << " <- " << size_t(_texture_map[texture]) << "\n";
    }
    texture = _texture_map[texture];

    GLenum target;
    target = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum internalFormat;
    internalFormat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei width;
    width = (call.arg(3)).toSInt();

    GLsizei height;
    height = (call.arg(4)).toSInt();

    GLsizei depth;
    depth = (call.arg(5)).toSInt();

    GLsizei layers;
    layers = (call.arg(6)).toSInt();

    GLbitfield flags;
    flags = static_cast<GLbitfield>((call.arg(7)).toUInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTextureStorageSparseAMD(texture, target, internalFormat, width, height, depth, layers, flags);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glStencilOpValueAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum face;
    face = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint value;
    value = (call.arg(1)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glStencilOpValueAMD(face, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTessellationFactorAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat factor;
    factor = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTessellationFactorAMD(factor);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTessellationModeAMD(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTessellationModeAMD(mode);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBlitFramebufferANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint srcX0;
    srcX0 = (call.arg(0)).toSInt();

    GLint srcY0;
    srcY0 = (call.arg(1)).toSInt();

    GLint srcX1;
    srcX1 = (call.arg(2)).toSInt();

    GLint srcY1;
    srcY1 = (call.arg(3)).toSInt();

    GLint dstX0;
    dstX0 = (call.arg(4)).toSInt();

    GLint dstY0;
    dstY0 = (call.arg(5)).toSInt();

    GLint dstX1;
    dstX1 = (call.arg(6)).toSInt();

    GLint dstY1;
    dstY1 = (call.arg(7)).toSInt();

    GLbitfield mask;
    mask = static_cast<GLbitfield>((call.arg(8)).toUInt());

    GLenum filter;
    filter = static_cast<GLenum>((call.arg(9)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glBlitFramebufferANGLE(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glRenderbufferStorageMultisampleANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei samples;
    samples = (call.arg(1)).toSInt();
    GLint max_samples = 0;
    glGetIntegerv(GL_MAX_SAMPLES, &max_samples);
    if (samples > max_samples) {
        samples = max_samples;
    }

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei width;
    width = (call.arg(3)).toSInt();

    GLsizei height;
    height = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRenderbufferStorageMultisampleANGLE(target, samples, internalformat, width, height);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDrawArraysInstancedANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint first;
    first = (call.arg(1)).toSInt();

    GLsizei count;
    count = (call.arg(2)).toSInt();

    GLsizei instancecount;
    instancecount = (call.arg(3)).toSInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDrawArraysInstancedANGLE(mode, first, count, instancecount);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glDrawElementsInstancedANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _element_array_buffer = 0;
        glGetIntegerv(GL_ELEMENT_ARRAY_BUFFER_BINDING, &_element_array_buffer);
        if (!_element_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    const GLvoid * indices;
    indices = static_cast<const GLvoid *>((call.arg(3)).toPointer());

    GLsizei instancecount;
    instancecount = (call.arg(4)).toSInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDrawElementsInstancedANGLE(mode, count, type, indices, instancecount);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glVertexAttribDivisorANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint divisor;
    divisor = (call.arg(1)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribDivisorANGLE(index, divisor);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGenQueriesANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * ids;
    ids = _allocator.allocArray<GLuint>(&call.arg(1));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGenQueriesANGLE(n, ids);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint121 = (call.arg(1)).toArray();
    if (_aGLuint121) {
        for (size_t _jGLuint121 = 0; _jGLuint121 < _aGLuint121->values.size(); ++_jGLuint121) {
    GLuint _origResult;
    _origResult = (*_aGLuint121->values[_jGLuint121]).toUInt();
    _query_map[_origResult] = ids[_jGLuint121];
    if (retrace::verbosity >= 2) {
        std::cout << "query " << _origResult << " -> " << ids[_jGLuint121] << "\n";
    }
        }
    }
}

static void retrace_glDeleteQueriesANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * ids;
    ids = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint122_0 = (call.arg(1)).toArray();
    if (_a_GLuint122_0) {
        for (size_t _jGLuint122 = 0; _jGLuint122 < _a_GLuint122_0->values.size(); ++_jGLuint122) {
    ids[_jGLuint122] = (*_a_GLuint122_0->values[_jGLuint122]).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(ids[_jGLuint122]) << " <- " << size_t(_query_map[ids[_jGLuint122]]) << "\n";
    }
    ids[_jGLuint122] = _query_map[ids[_jGLuint122]];
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeleteQueriesANGLE(n, ids);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBeginQueryANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint id;
    id = (call.arg(1)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(id) << " <- " << size_t(_query_map[id]) << "\n";
    }
    id = _query_map[id];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBeginQueryANGLE(target, id);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEndQueryANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEndQueryANGLE(target);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glQueryCounterANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint id;
    id = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(id) << " <- " << size_t(_query_map[id]) << "\n";
    }
    id = _query_map[id];

    GLenum target;
    target = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glQueryCounterANGLE(id, target);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetQueryObjectivANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    GLint _query_buffer = 0;
    if (currentContext && currentContext->features().query_buffer_object) {
        glGetIntegerv(GL_QUERY_BUFFER_BINDING, &_query_buffer);
    }
    if (!_query_buffer && retrace::queryHandling == retrace::QUERY_SKIP) {
        return;
    }
wait_for_query_result:
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint id;
    id = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(id) << " <- " << size_t(_query_map[id]) << "\n";
    }
    id = _query_map[id];

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint * params;
    GLint retval;
    if (_query_buffer)
        params = static_cast<GLint *>((call.arg(2)).toPointer());
    else
        params = &retval;

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetQueryObjectivANGLE(id, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLint175 = (call.arg(2)).toArray();
    if (_aGLint175) {
        for (size_t _jGLint175 = 0; _jGLint175 < _aGLint175->values.size(); ++_jGLint175) {
        }
    }
    if (!_query_buffer && retrace::queryHandling != retrace::QUERY_SKIP) {
        auto query_result = call.arg(2).toArray();
        assert(query_result && query_result->values.size() == 1);
        auto expect = static_cast<decltype(retval)>(query_result->values[0]->toUInt());
        if (call.arg(1).toUInt() == GL_QUERY_RESULT_AVAILABLE) {
            if (expect == 1 && retval == 0)
                goto wait_for_query_result;
        } else if (retrace::queryHandling == retrace::QUERY_RUN_AND_CHECK_RESULT &&
                   abs(static_cast<int64_t>(expect) - static_cast<int64_t>(retval)) > retrace::queryTolerance) {
           retrace::warning(call) << "Warning: query returned " << retval << " but trace contained " << expect
                                  << " (tol = " << retrace::queryTolerance << ")\n";
        }
    }
}

static void retrace_glGetQueryObjectuivANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    GLint _query_buffer = 0;
    if (currentContext && currentContext->features().query_buffer_object) {
        glGetIntegerv(GL_QUERY_BUFFER_BINDING, &_query_buffer);
    }
    if (!_query_buffer && retrace::queryHandling == retrace::QUERY_SKIP) {
        return;
    }
wait_for_query_result:
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint id;
    id = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(id) << " <- " << size_t(_query_map[id]) << "\n";
    }
    id = _query_map[id];

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLuint * params;
    GLuint retval;
    if (_query_buffer)
        params = static_cast<GLuint *>((call.arg(2)).toPointer());
    else
        params = &retval;

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetQueryObjectuivANGLE(id, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint124 = (call.arg(2)).toArray();
    if (_aGLuint124) {
        for (size_t _jGLuint124 = 0; _jGLuint124 < _aGLuint124->values.size(); ++_jGLuint124) {
        }
    }
    if (!_query_buffer && retrace::queryHandling != retrace::QUERY_SKIP) {
        auto query_result = call.arg(2).toArray();
        assert(query_result && query_result->values.size() == 1);
        auto expect = static_cast<decltype(retval)>(query_result->values[0]->toUInt());
        if (call.arg(1).toUInt() == GL_QUERY_RESULT_AVAILABLE) {
            if (expect == 1 && retval == 0)
                goto wait_for_query_result;
        } else if (retrace::queryHandling == retrace::QUERY_RUN_AND_CHECK_RESULT &&
                   abs(static_cast<int64_t>(expect) - static_cast<int64_t>(retval)) > retrace::queryTolerance) {
           retrace::warning(call) << "Warning: query returned " << retval << " but trace contained " << expect
                                  << " (tol = " << retrace::queryTolerance << ")\n";
        }
    }
}

static void retrace_glGetQueryObjecti64vANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    GLint _query_buffer = 0;
    if (currentContext && currentContext->features().query_buffer_object) {
        glGetIntegerv(GL_QUERY_BUFFER_BINDING, &_query_buffer);
    }
    if (!_query_buffer && retrace::queryHandling == retrace::QUERY_SKIP) {
        return;
    }
wait_for_query_result:
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint id;
    id = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(id) << " <- " << size_t(_query_map[id]) << "\n";
    }
    id = _query_map[id];

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint64 * params;
    GLint64 retval;
    if (_query_buffer)
        params = static_cast<GLint64 *>((call.arg(2)).toPointer());
    else
        params = &retval;

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetQueryObjecti64vANGLE(id, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLint6413 = (call.arg(2)).toArray();
    if (_aGLint6413) {
        for (size_t _jGLint6413 = 0; _jGLint6413 < _aGLint6413->values.size(); ++_jGLint6413) {
        }
    }
    if (!_query_buffer && retrace::queryHandling != retrace::QUERY_SKIP) {
        auto query_result = call.arg(2).toArray();
        assert(query_result && query_result->values.size() == 1);
        auto expect = static_cast<decltype(retval)>(query_result->values[0]->toUInt());
        if (call.arg(1).toUInt() == GL_QUERY_RESULT_AVAILABLE) {
            if (expect == 1 && retval == 0)
                goto wait_for_query_result;
        } else if (retrace::queryHandling == retrace::QUERY_RUN_AND_CHECK_RESULT &&
                   abs(static_cast<int64_t>(expect) - static_cast<int64_t>(retval)) > retrace::queryTolerance) {
           retrace::warning(call) << "Warning: query returned " << retval << " but trace contained " << expect
                                  << " (tol = " << retrace::queryTolerance << ")\n";
        }
    }
}

static void retrace_glGetQueryObjectui64vANGLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    GLint _query_buffer = 0;
    if (currentContext && currentContext->features().query_buffer_object) {
        glGetIntegerv(GL_QUERY_BUFFER_BINDING, &_query_buffer);
    }
    if (!_query_buffer && retrace::queryHandling == retrace::QUERY_SKIP) {
        return;
    }
wait_for_query_result:
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint id;
    id = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "query " << size_t(id) << " <- " << size_t(_query_map[id]) << "\n";
    }
    id = _query_map[id];

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLuint64 * params;
    GLuint64 retval;
    if (_query_buffer)
        params = static_cast<GLuint64 *>((call.arg(2)).toPointer());
    else
        params = &retval;

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGetQueryObjectui64vANGLE(id, pname, params);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint648 = (call.arg(2)).toArray();
    if (_aGLuint648) {
        for (size_t _jGLuint648 = 0; _jGLuint648 < _aGLuint648->values.size(); ++_jGLuint648) {
        }
    }
    if (!_query_buffer && retrace::queryHandling != retrace::QUERY_SKIP) {
        auto query_result = call.arg(2).toArray();
        assert(query_result && query_result->values.size() == 1);
        auto expect = static_cast<decltype(retval)>(query_result->values[0]->toUInt());
        if (call.arg(1).toUInt() == GL_QUERY_RESULT_AVAILABLE) {
            if (expect == 1 && retval == 0)
                goto wait_for_query_result;
        } else if (retrace::queryHandling == retrace::QUERY_RUN_AND_CHECK_RESULT &&
                   abs(static_cast<int64_t>(expect) - static_cast<int64_t>(retval)) > retrace::queryTolerance) {
           retrace::warning(call) << "Warning: query returned " << retval << " but trace contained " << expect
                                  << " (tol = " << retrace::queryTolerance << ")\n";
        }
    }
}

static void retrace_glCopyTextureLevelsAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint destinationTexture;
    destinationTexture = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(destinationTexture) << " <- " << size_t(_texture_map[destinationTexture]) << "\n";
    }
    destinationTexture = _texture_map[destinationTexture];

    GLuint sourceTexture;
    sourceTexture = (call.arg(1)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(sourceTexture) << " <- " << size_t(_texture_map[sourceTexture]) << "\n";
    }
    sourceTexture = _texture_map[sourceTexture];

    GLint sourceBaseLevel;
    sourceBaseLevel = (call.arg(2)).toSInt();

    GLsizei sourceLevelCount;
    sourceLevelCount = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyTextureLevelsAPPLE(destinationTexture, sourceTexture, sourceBaseLevel, sourceLevelCount);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glElementPointerAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum type;
    type = static_cast<GLenum>((call.arg(0)).toSInt());

    GLvoid * pointer;
    pointer = static_cast<GLvoid *>((call.arg(1)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glElementPointerAPPLE(type, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDrawElementArrayAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint first;
    first = (call.arg(1)).toSInt();

    GLsizei count;
    count = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDrawElementArrayAPPLE(mode, first, count);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDrawRangeElementArrayAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint start;
    start = (call.arg(1)).toUInt();

    GLuint end;
    end = (call.arg(2)).toUInt();

    GLint first;
    first = (call.arg(3)).toSInt();

    GLsizei count;
    count = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDrawRangeElementArrayAPPLE(mode, start, end, first, count);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiDrawElementArrayAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint * first;
    first = _allocator.allocArray<GLint>(&call.arg(1));
    const trace::Array *_a_GLint176_0 = (call.arg(1)).toArray();
    if (_a_GLint176_0) {
        for (size_t _jGLint176 = 0; _jGLint176 < _a_GLint176_0->values.size(); ++_jGLint176) {
    first[_jGLint176] = (*_a_GLint176_0->values[_jGLint176]).toSInt();
        }
    }

    GLsizei * count;
    count = _allocator.allocArray<GLsizei>(&call.arg(2));
    const trace::Array *_a_GLsizei7_0 = (call.arg(2)).toArray();
    if (_a_GLsizei7_0) {
        for (size_t _jGLsizei7 = 0; _jGLsizei7 < _a_GLsizei7_0->values.size(); ++_jGLsizei7) {
    count[_jGLsizei7] = (*_a_GLsizei7_0->values[_jGLsizei7]).toSInt();
        }
    }

    GLsizei drawcount;
    drawcount = (call.arg(3)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiDrawElementArrayAPPLE(mode, first, count, drawcount);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMultiDrawRangeElementArrayAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint start;
    start = (call.arg(1)).toUInt();

    GLuint end;
    end = (call.arg(2)).toUInt();

    GLint * first;
    first = _allocator.allocArray<GLint>(&call.arg(3));
    const trace::Array *_a_GLint177_0 = (call.arg(3)).toArray();
    if (_a_GLint177_0) {
        for (size_t _jGLint177 = 0; _jGLint177 < _a_GLint177_0->values.size(); ++_jGLint177) {
    first[_jGLint177] = (*_a_GLint177_0->values[_jGLint177]).toSInt();
        }
    }

    GLsizei * count;
    count = _allocator.allocArray<GLsizei>(&call.arg(4));
    const trace::Array *_a_GLsizei8_0 = (call.arg(4)).toArray();
    if (_a_GLsizei8_0) {
        for (size_t _jGLsizei8 = 0; _jGLsizei8 < _a_GLsizei8_0->values.size(); ++_jGLsizei8) {
    count[_jGLsizei8] = (*_a_GLsizei8_0->values[_jGLsizei8]).toSInt();
        }
    }

    GLsizei drawcount;
    drawcount = (call.arg(5)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMultiDrawRangeElementArrayAPPLE(mode, start, end, first, count, drawcount);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGenFencesAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * fences;
    fences = _allocator.allocArray<GLuint>(&call.arg(1));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGenFencesAPPLE(n, fences);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint126 = (call.arg(1)).toArray();
    if (_aGLuint126) {
        for (size_t _jGLuint126 = 0; _jGLuint126 < _aGLuint126->values.size(); ++_jGLuint126) {
    GLuint _origResult;
    _origResult = (*_aGLuint126->values[_jGLuint126]).toUInt();
    _fence_map[_origResult] = fences[_jGLuint126];
    if (retrace::verbosity >= 2) {
        std::cout << "fence " << _origResult << " -> " << fences[_jGLuint126] << "\n";
    }
        }
    }
}

static void retrace_glDeleteFencesAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * fences;
    fences = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint127_0 = (call.arg(1)).toArray();
    if (_a_GLuint127_0) {
        for (size_t _jGLuint127 = 0; _jGLuint127 < _a_GLuint127_0->values.size(); ++_jGLuint127) {
    fences[_jGLuint127] = (*_a_GLuint127_0->values[_jGLuint127]).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "fence " << size_t(fences[_jGLuint127]) << " <- " << size_t(_fence_map[fences[_jGLuint127]]) << "\n";
    }
    fences[_jGLuint127] = _fence_map[fences[_jGLuint127]];
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeleteFencesAPPLE(n, fences);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSetFenceAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint fence;
    fence = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "fence " << size_t(fence) << " <- " << size_t(_fence_map[fence]) << "\n";
    }
    fence = _fence_map[fence];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSetFenceAPPLE(fence);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTestFenceAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint fence;
    fence = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "fence " << size_t(fence) << " <- " << size_t(_fence_map[fence]) << "\n";
    }
    fence = _fence_map[fence];

    GLboolean _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glTestFenceAPPLE(fence);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFinishFenceAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint fence;
    fence = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "fence " << size_t(fence) << " <- " << size_t(_fence_map[fence]) << "\n";
    }
    fence = _fence_map[fence];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFinishFenceAPPLE(fence);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTestObjectAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum object;
    object = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint name;
    name = (call.arg(1)).toUInt();

    GLboolean _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glTestObjectAPPLE(object, name);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFinishObjectAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum object;
    object = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint name;
    name = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFinishObjectAPPLE(object, name);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBufferParameteriAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint param;
    param = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBufferParameteriAPPLE(target, pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFlushMappedBufferRangeAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLintptr offset;
    offset = (call.arg(1)).toSInt();

    GLsizeiptr size;
    size = (call.arg(2)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFlushMappedBufferRangeAPPLE(target, offset, size);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFlushRenderAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFlushRenderAPPLE();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFinishRenderAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFinishRenderAPPLE();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glSwapAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glSwapAPPLE();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glRenderbufferStorageMultisampleAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei samples;
    samples = (call.arg(1)).toSInt();
    GLint max_samples = 0;
    glGetIntegerv(GL_MAX_SAMPLES, &max_samples);
    if (samples > max_samples) {
        samples = max_samples;
    }

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei width;
    width = (call.arg(3)).toSInt();

    GLsizei height;
    height = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glRenderbufferStorageMultisampleAPPLE(target, samples, internalformat, width, height);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glResolveMultisampleFramebufferAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glResolveMultisampleFramebufferAPPLE();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glObjectPurgeableAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum objectType;
    objectType = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint name;
    name = (call.arg(1)).toUInt();

    GLenum option;
    option = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glObjectPurgeableAPPLE(objectType, name, option);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glObjectUnpurgeableAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum objectType;
    objectType = static_cast<GLenum>((call.arg(0)).toSInt());

    GLuint name;
    name = (call.arg(1)).toUInt();

    GLenum option;
    option = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glObjectUnpurgeableAPPLE(objectType, name, option);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPointSizePointerAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum type;
    type = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei stride;
    stride = (call.arg(1)).toSInt();

    const GLvoid * pointer;
    memset(&pointer, 0, sizeof pointer); // FIXME

    if (1) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPointSizePointerAPPLE(type, stride, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexPointSizefAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat size;
    size = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexPointSizefAPPLE(size);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFenceSyncAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum condition;
    condition = static_cast<GLenum>((call.arg(0)).toSInt());

    GLbitfield flags;
    flags = (call.arg(1)).toUInt();

    GLsync _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glFenceSyncAPPLE(condition, flags);
    (void)_result;
    if (currentContext) {
        currentContext->needsFlush = true;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    GLsync _origResult;
    _origResult = static_cast<GLsync>((*call.ret).toPointer());
    _sync_map[_origResult] = _result;
    if (retrace::verbosity >= 2) {
        std::cout << "sync " << _origResult << " -> " << _result << "\n";
    }
}

static void retrace_glDeleteSyncAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsync sync;
    sync = static_cast<GLsync>((call.arg(0)).toPointer());
    if (retrace::verbosity >= 2) {
        std::cout << "sync " << size_t(sync) << " <- " << size_t(_sync_map[sync]) << "\n";
    }
    sync = _sync_map[sync];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeleteSyncAPPLE(sync);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClientWaitSyncAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsync sync;
    sync = static_cast<GLsync>((call.arg(0)).toPointer());
    if (retrace::verbosity >= 2) {
        std::cout << "sync " << size_t(sync) << " <- " << size_t(_sync_map[sync]) << "\n";
    }
    sync = _sync_map[sync];

    GLbitfield flags;
    flags = static_cast<GLbitfield>((call.arg(1)).toUInt());

    GLuint64 timeout;
    timeout = (call.arg(2)).toUInt();

    GLenum _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glClientWaitSyncAPPLE(sync, flags, timeout);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glWaitSyncAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsync sync;
    sync = static_cast<GLsync>((call.arg(0)).toPointer());
    if (retrace::verbosity >= 2) {
        std::cout << "sync " << size_t(sync) << " <- " << size_t(_sync_map[sync]) << "\n";
    }
    sync = _sync_map[sync];

    GLbitfield flags;
    flags = (call.arg(1)).toUInt();

    GLuint64 timeout;
    timeout = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glWaitSyncAPPLE(sync, flags, timeout);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTextureRangeAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei length;
    length = (call.arg(1)).toSInt();

    GLvoid * pointer;
    pointer = static_cast<GLvoid *>((call.arg(2)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTextureRangeAPPLE(target, length, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBindVertexArrayAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint array;
    array = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "arrayAPPLE " << size_t(array) << " <- " << size_t(_arrayAPPLE_map[array]) << "\n";
    }
    array = _arrayAPPLE_map[array];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBindVertexArrayAPPLE(array);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDeleteVertexArraysAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * arrays;
    arrays = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint128_0 = (call.arg(1)).toArray();
    if (_a_GLuint128_0) {
        for (size_t _jGLuint128 = 0; _jGLuint128 < _a_GLuint128_0->values.size(); ++_jGLuint128) {
    arrays[_jGLuint128] = (*_a_GLuint128_0->values[_jGLuint128]).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "arrayAPPLE " << size_t(arrays[_jGLuint128]) << " <- " << size_t(_arrayAPPLE_map[arrays[_jGLuint128]]) << "\n";
    }
    arrays[_jGLuint128] = _arrayAPPLE_map[arrays[_jGLuint128]];
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDeleteVertexArraysAPPLE(n, arrays);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGenVertexArraysAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * arrays;
    arrays = _allocator.allocArray<GLuint>(&call.arg(1));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glGenVertexArraysAPPLE(n, arrays);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint130 = (call.arg(1)).toArray();
    if (_aGLuint130) {
        for (size_t _jGLuint130 = 0; _jGLuint130 < _aGLuint130->values.size(); ++_jGLuint130) {
    GLuint _origResult;
    _origResult = (*_aGLuint130->values[_jGLuint130]).toUInt();
    _arrayAPPLE_map[_origResult] = arrays[_jGLuint130];
    if (retrace::verbosity >= 2) {
        std::cout << "arrayAPPLE " << _origResult << " -> " << arrays[_jGLuint130] << "\n";
    }
        }
    }
}

static void retrace_glVertexArrayRangeAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei length;
    length = (call.arg(0)).toSInt();

    GLvoid * pointer;
    memset(&pointer, 0, sizeof pointer); // FIXME

    if (1) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexArrayRangeAPPLE(length, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glFlushVertexArrayRangeAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei length;
    length = (call.arg(0)).toSInt();

    GLvoid * pointer;
    memset(&pointer, 0, sizeof pointer); // FIXME

    if (1) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glFlushVertexArrayRangeAPPLE(length, pointer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexArrayParameteriAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum pname;
    pname = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint param;
    param = (call.arg(1)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexArrayParameteriAPPLE(pname, param);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glEnableVertexAttribAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glEnableVertexAttribAPPLE(index, pname);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDisableVertexAttribAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLenum pname;
    pname = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDisableVertexAttribAPPLE(index, pname);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMapVertexAttrib1dAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint size;
    size = (call.arg(1)).toUInt();

    GLdouble u1;
    u1 = (call.arg(2)).toDouble();

    GLdouble u2;
    u2 = (call.arg(3)).toDouble();

    GLint stride;
    stride = (call.arg(4)).toSInt();

    GLint order;
    order = (call.arg(5)).toSInt();

    const GLdouble * points;
    memset(&points, 0, sizeof points); // FIXME

    if (1) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMapVertexAttrib1dAPPLE(index, size, u1, u2, stride, order, points);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMapVertexAttrib1fAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint size;
    size = (call.arg(1)).toUInt();

    GLfloat u1;
    u1 = (call.arg(2)).toFloat();

    GLfloat u2;
    u2 = (call.arg(3)).toFloat();

    GLint stride;
    stride = (call.arg(4)).toSInt();

    GLint order;
    order = (call.arg(5)).toSInt();

    const GLfloat * points;
    memset(&points, 0, sizeof points); // FIXME

    if (1) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMapVertexAttrib1fAPPLE(index, size, u1, u2, stride, order, points);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMapVertexAttrib2dAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint size;
    size = (call.arg(1)).toUInt();

    GLdouble u1;
    u1 = (call.arg(2)).toDouble();

    GLdouble u2;
    u2 = (call.arg(3)).toDouble();

    GLint ustride;
    ustride = (call.arg(4)).toSInt();

    GLint uorder;
    uorder = (call.arg(5)).toSInt();

    GLdouble v1;
    v1 = (call.arg(6)).toDouble();

    GLdouble v2;
    v2 = (call.arg(7)).toDouble();

    GLint vstride;
    vstride = (call.arg(8)).toSInt();

    GLint vorder;
    vorder = (call.arg(9)).toSInt();

    const GLdouble * points;
    memset(&points, 0, sizeof points); // FIXME

    if (1) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMapVertexAttrib2dAPPLE(index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMapVertexAttrib2fAPPLE(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint size;
    size = (call.arg(1)).toUInt();

    GLfloat u1;
    u1 = (call.arg(2)).toFloat();

    GLfloat u2;
    u2 = (call.arg(3)).toFloat();

    GLint ustride;
    ustride = (call.arg(4)).toSInt();

    GLint uorder;
    uorder = (call.arg(5)).toSInt();

    GLfloat v1;
    v1 = (call.arg(6)).toFloat();

    GLfloat v2;
    v2 = (call.arg(7)).toFloat();

    GLint vstride;
    vstride = (call.arg(8)).toSInt();

    GLint vorder;
    vorder = (call.arg(9)).toSInt();

    const GLfloat * points;
    memset(&points, 0, sizeof points); // FIXME

    if (1) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMapVertexAttrib2fAPPLE(index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glReleaseShaderCompiler(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glReleaseShaderCompiler();
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glShaderBinary(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei count;
    count = (call.arg(0)).toSInt();

    GLuint * shaders;
    shaders = _allocator.allocArray<GLuint>(&call.arg(1));
    const trace::Array *_a_GLuint131_0 = (call.arg(1)).toArray();
    if (_a_GLuint131_0) {
        for (size_t _jGLuint131 = 0; _jGLuint131 < _a_GLuint131_0->values.size(); ++_jGLuint131) {
    shaders[_jGLuint131] = (*_a_GLuint131_0->values[_jGLuint131]).toUInt();
        }
    }

    GLenum binaryformat;
    binaryformat = static_cast<GLenum>((call.arg(2)).toSInt());

    GLvoid * binary;
    binary = static_cast<GLvoid *>((call.arg(3)).toPointer());

    GLsizei length;
    length = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glShaderBinary(count, shaders, binaryformat, binary, length);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDepthRangef(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat n;
    n = (call.arg(0)).toFloat();

    GLfloat f;
    f = (call.arg(1)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDepthRangef(n, f);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearDepthf(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat d;
    d = (call.arg(0)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearDepthf(d);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMemoryBarrierByRegion(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLbitfield barriers;
    barriers = static_cast<GLbitfield>((call.arg(0)).toUInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMemoryBarrierByRegion(barriers);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glPrimitiveBoundingBoxARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLfloat minX;
    minX = (call.arg(0)).toFloat();

    GLfloat minY;
    minY = (call.arg(1)).toFloat();

    GLfloat minZ;
    minZ = (call.arg(2)).toFloat();

    GLfloat minW;
    minW = (call.arg(3)).toFloat();

    GLfloat maxX;
    maxX = (call.arg(4)).toFloat();

    GLfloat maxY;
    maxY = (call.arg(5)).toFloat();

    GLfloat maxZ;
    maxZ = (call.arg(6)).toFloat();

    GLfloat maxW;
    maxW = (call.arg(7)).toFloat();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glPrimitiveBoundingBoxARB(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDrawArraysInstancedBaseInstance(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _array_buffer = 0;
        glGetIntegerv(GL_ARRAY_BUFFER_BINDING, &_array_buffer);
        if (!_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLint first;
    first = (call.arg(1)).toSInt();

    GLsizei count;
    count = (call.arg(2)).toSInt();

    GLsizei instancecount;
    instancecount = (call.arg(3)).toSInt();

    GLuint baseinstance;
    baseinstance = (call.arg(4)).toUInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDrawArraysInstancedBaseInstance(mode, first, count, instancecount, baseinstance);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glDrawElementsInstancedBaseInstance(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _element_array_buffer = 0;
        glGetIntegerv(GL_ELEMENT_ARRAY_BUFFER_BINDING, &_element_array_buffer);
        if (!_element_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    const GLvoid * indices;
    indices = static_cast<const GLvoid *>((call.arg(3)).toPointer());

    GLsizei instancecount;
    instancecount = (call.arg(4)).toSInt();

    GLuint baseinstance;
    baseinstance = (call.arg(5)).toUInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDrawElementsInstancedBaseInstance(mode, count, type, indices, instancecount, baseinstance);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glDrawElementsInstancedBaseVertexBaseInstance(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    if (retrace::parser->getVersion() < 1) {
        GLint _element_array_buffer = 0;
        glGetIntegerv(GL_ELEMENT_ARRAY_BUFFER_BINDING, &_element_array_buffer);
        if (!_element_array_buffer) {
    if (retrace::verbosity >= 0) {
        retrace::unsupported(call);
    }
    return;
        }
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum mode;
    mode = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLenum type;
    type = static_cast<GLenum>((call.arg(2)).toSInt());

    const GLvoid * indices;
    indices = static_cast<const GLvoid *>((call.arg(3)).toPointer());

    GLsizei instancecount;
    instancecount = (call.arg(4)).toSInt();

    GLint basevertex;
    basevertex = (call.arg(5)).toSInt();

    GLuint baseinstance;
    baseinstance = (call.arg(6)).toUInt();

    if (retrace::debug > 0) {
        _validateActiveProgram(call);
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDrawElementsInstancedBaseVertexBaseInstance(mode, count, type, indices, instancecount, basevertex, baseinstance);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    assert(call.flags & trace::CALL_FLAG_RENDER);
}

static void retrace_glGetTextureHandleARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint texture;
    texture = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(texture) << " <- " << size_t(_texture_map[texture]) << "\n";
    }
    texture = _texture_map[texture];

    GLuint64 _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glGetTextureHandleARB(texture);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    GLuint64 _origResult;
    _origResult = (*call.ret).toUInt();
    _textureHandle_map[_origResult] = _result;
    if (_origResult != _result) {
        std::cout << "Bindless handle doesn't match, GPU failures ahead.\n";
    }
    if (retrace::verbosity >= 2) {
        std::cout << "textureHandle " << _origResult << " -> " << _result << "\n";
    }
}

static void retrace_glGetTextureSamplerHandleARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint texture;
    texture = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(texture) << " <- " << size_t(_texture_map[texture]) << "\n";
    }
    texture = _texture_map[texture];

    GLuint sampler;
    sampler = (call.arg(1)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "sampler " << size_t(sampler) << " <- " << size_t(_sampler_map[sampler]) << "\n";
    }
    sampler = _sampler_map[sampler];

    GLuint64 _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glGetTextureSamplerHandleARB(texture, sampler);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    GLuint64 _origResult;
    _origResult = (*call.ret).toUInt();
    _textureHandle_map[_origResult] = _result;
    if (_origResult != _result) {
        std::cout << "Bindless handle doesn't match, GPU failures ahead.\n";
    }
    if (retrace::verbosity >= 2) {
        std::cout << "textureHandle " << _origResult << " -> " << _result << "\n";
    }
}

static void retrace_glMakeTextureHandleResidentARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint64 handle;
    handle = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "textureHandle " << size_t(handle) << " <- " << size_t(_textureHandle_map[handle]) << "\n";
    }
    handle = _textureHandle_map[handle];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMakeTextureHandleResidentARB(handle);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMakeTextureHandleNonResidentARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint64 handle;
    handle = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "textureHandle " << size_t(handle) << " <- " << size_t(_textureHandle_map[handle]) << "\n";
    }
    handle = _textureHandle_map[handle];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMakeTextureHandleNonResidentARB(handle);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glGetImageHandleARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint texture;
    texture = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(texture) << " <- " << size_t(_texture_map[texture]) << "\n";
    }
    texture = _texture_map[texture];

    GLint level;
    level = (call.arg(1)).toSInt();

    GLboolean layered;
    layered = static_cast<GLboolean>((call.arg(2)).toSInt());

    GLint layer;
    layer = (call.arg(3)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(4)).toSInt());

    GLuint64 _result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    _result = glGetImageHandleARB(texture, level, layered, layer, format);
    (void)_result;
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    GLuint64 _origResult;
    _origResult = (*call.ret).toUInt();
    _imageHandle_map[_origResult] = _result;
    if (_origResult != _result) {
        std::cout << "Bindless handle doesn't match, GPU failures ahead.\n";
    }
    if (retrace::verbosity >= 2) {
        std::cout << "imageHandle " << _origResult << " -> " << _result << "\n";
    }
}

static void retrace_glMakeImageHandleResidentARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint64 handle;
    handle = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "imageHandle " << size_t(handle) << " <- " << size_t(_imageHandle_map[handle]) << "\n";
    }
    handle = _imageHandle_map[handle];

    GLenum access;
    access = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMakeImageHandleResidentARB(handle, access);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glMakeImageHandleNonResidentARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint64 handle;
    handle = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "imageHandle " << size_t(handle) << " <- " << size_t(_imageHandle_map[handle]) << "\n";
    }
    handle = _imageHandle_map[handle];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glMakeImageHandleNonResidentARB(handle);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniformHandleui64ARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLuint64 value;
    value = (call.arg(1)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniformHandleui64ARB(location, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glUniformHandleui64vARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLint location;
    GLint program = _getActiveProgram();
    location = (call.arg(0)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(1)).toSInt();

    GLuint64 * value;
    value = _allocator.allocArray<GLuint64>(&call.arg(2));
    const trace::Array *_a_GLuint649_0 = (call.arg(2)).toArray();
    if (_a_GLuint649_0) {
        for (size_t _jGLuint649 = 0; _jGLuint649 < _a_GLuint649_0->values.size(); ++_jGLuint649) {
    value[_jGLuint649] = (*_a_GLuint649_0->values[_jGLuint649]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glUniformHandleui64vARB(location, count, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glProgramUniformHandleui64ARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    GLint location;
    location = (call.arg(1)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLuint64 value;
    value = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glProgramUniformHandleui64ARB(program, location, value);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glProgramUniformHandleui64vARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    GLint location;
    location = (call.arg(1)).toSInt();
    if (retrace::verbosity >= 2) {
        std::cout << "location " << size_t(location) << " <- " << size_t(_location_map[program].lookupUniformLocation(location)) << "\n";
    }
    location = _location_map[program].lookupUniformLocation(location);

    GLsizei count;
    count = (call.arg(2)).toSInt();

    GLuint64 * values;
    values = _allocator.allocArray<GLuint64>(&call.arg(3));
    const trace::Array *_a_GLuint6410_0 = (call.arg(3)).toArray();
    if (_a_GLuint6410_0) {
        for (size_t _jGLuint6410 = 0; _jGLuint6410 < _a_GLuint6410_0->values.size(); ++_jGLuint6410) {
    values[_jGLuint6410] = (*_a_GLuint6410_0->values[_jGLuint6410]).toUInt();
        }
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glProgramUniformHandleui64vARB(program, location, count, values);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribL1ui64ARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint64 x;
    x = (call.arg(1)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribL1ui64ARB(index, x);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glVertexAttribL1ui64vARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint index;
    index = (call.arg(0)).toUInt();

    GLuint64 * v;
    v = _allocator.allocArray<GLuint64>(&call.arg(1));
    if (v) {
        const trace::Array *_a_PGLuint643_0 = (call.arg(1)).toArray();
    v[0] = (*_a_PGLuint643_0->values[0]).toUInt();
    }

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glVertexAttribL1ui64vARB(index, v);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBindFragDataLocationIndexed(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint program;
    program = (call.arg(0)).toUInt();
if (glretrace::supportsARBShaderObjects) {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_handleARB_map[program]) << "\n";
    }
    program = _handleARB_map[program];
} else {
    if (retrace::verbosity >= 2) {
        std::cout << "program " << size_t(program) << " <- " << size_t(_program_map[program]) << "\n";
    }
    program = _program_map[program];
}

    GLuint colorNumber;
    colorNumber = (call.arg(1)).toUInt();

    GLuint index;
    index = (call.arg(2)).toUInt();

    const GLchar * name;
    name = (const GLchar *)((call.arg(3)).toString());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBindFragDataLocationIndexed(program, colorNumber, index, name);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glBufferStorage(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLsizeiptr size;
    size = (call.arg(1)).toSInt();

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(2)).toPointer());

    GLbitfield flags;
    flags = static_cast<GLbitfield>((call.arg(3)).toUInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glBufferStorage(target, size, data, flags);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearBufferData(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum format;
    format = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(3)).toSInt());

    void * data;
    data = static_cast<void *>((call.arg(4)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearBufferData(target, internalformat, format, type, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearBufferSubData(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum internalformat;
    internalformat = static_cast<GLenum>((call.arg(1)).toSInt());

    GLintptr offset;
    offset = (call.arg(2)).toSInt();

    GLsizeiptr size;
    size = (call.arg(3)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(4)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(5)).toSInt());

    void * data;
    data = static_cast<void *>((call.arg(6)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearBufferSubData(target, internalformat, offset, size, format, type, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearTexImage(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint texture;
    texture = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(texture) << " <- " << size_t(_texture_map[texture]) << "\n";
    }
    texture = _texture_map[texture];

    GLint level;
    level = (call.arg(1)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(2)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(3)).toSInt());

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(4)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearTexImage(texture, level, format, type, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClearTexSubImage(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint texture;
    texture = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(texture) << " <- " << size_t(_texture_map[texture]) << "\n";
    }
    texture = _texture_map[texture];

    GLint level;
    level = (call.arg(1)).toSInt();

    GLint xoffset;
    xoffset = (call.arg(2)).toSInt();

    GLint yoffset;
    yoffset = (call.arg(3)).toSInt();

    GLint zoffset;
    zoffset = (call.arg(4)).toSInt();

    GLsizei width;
    width = (call.arg(5)).toSInt();

    GLsizei height;
    height = (call.arg(6)).toSInt();

    GLsizei depth;
    depth = (call.arg(7)).toSInt();

    GLenum format;
    format = static_cast<GLenum>((call.arg(8)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(9)).toSInt());

    GLvoid * data;
    data = static_cast<GLvoid *>((call.arg(10)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClipControl(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum origin;
    origin = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum depth;
    depth = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClipControl(origin, depth);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glClampColorARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum target;
    target = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum clamp;
    clamp = static_cast<GLenum>((call.arg(1)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glClampColorARB(target, clamp);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDispatchCompute(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint num_groups_x;
    num_groups_x = (call.arg(0)).toUInt();

    GLuint num_groups_y;
    num_groups_y = (call.arg(1)).toUInt();

    GLuint num_groups_z;
    num_groups_z = (call.arg(2)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDispatchCompute(num_groups_x, num_groups_y, num_groups_z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDispatchComputeIndirect(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLintptr indirect;
    indirect = (call.arg(0)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDispatchComputeIndirect(indirect);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDispatchComputeGroupSizeARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint num_groups_x;
    num_groups_x = (call.arg(0)).toUInt();

    GLuint num_groups_y;
    num_groups_y = (call.arg(1)).toUInt();

    GLuint num_groups_z;
    num_groups_z = (call.arg(2)).toUInt();

    GLuint group_size_x;
    group_size_x = (call.arg(3)).toUInt();

    GLuint group_size_y;
    group_size_y = (call.arg(4)).toUInt();

    GLuint group_size_z;
    group_size_z = (call.arg(5)).toUInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, true);
    }
    glDispatchComputeGroupSizeARB(num_groups_x, num_groups_y, num_groups_z, group_size_x, group_size_y, group_size_z);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, true);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyBufferSubData(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum readTarget;
    readTarget = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum writeTarget;
    writeTarget = static_cast<GLenum>((call.arg(1)).toSInt());

    GLintptr readOffset;
    readOffset = (call.arg(2)).toSInt();

    GLintptr writeOffset;
    writeOffset = (call.arg(3)).toSInt();

    GLsizeiptr size;
    size = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyBufferSubData(readTarget, writeTarget, readOffset, writeOffset, size);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyImageSubData(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint srcName;
    srcName = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(srcName) << " <- " << size_t(_texture_map[srcName]) << "\n";
    }
    srcName = _texture_map[srcName];

    GLenum srcTarget;
    srcTarget = static_cast<GLenum>((call.arg(1)).toSInt());

    GLint srcLevel;
    srcLevel = (call.arg(2)).toSInt();

    GLint srcX;
    srcX = (call.arg(3)).toSInt();

    GLint srcY;
    srcY = (call.arg(4)).toSInt();

    GLint srcZ;
    srcZ = (call.arg(5)).toSInt();

    GLuint dstName;
    dstName = (call.arg(6)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "texture " << size_t(dstName) << " <- " << size_t(_texture_map[dstName]) << "\n";
    }
    dstName = _texture_map[dstName];

    GLenum dstTarget;
    dstTarget = static_cast<GLenum>((call.arg(7)).toSInt());

    GLint dstLevel;
    dstLevel = (call.arg(8)).toSInt();

    GLint dstX;
    dstX = (call.arg(9)).toSInt();

    GLint dstY;
    dstY = (call.arg(10)).toSInt();

    GLint dstZ;
    dstZ = (call.arg(11)).toSInt();

    GLsizei srcWidth;
    srcWidth = (call.arg(12)).toSInt();

    GLsizei srcHeight;
    srcHeight = (call.arg(13)).toSInt();

    GLsizei srcDepth;
    srcDepth = (call.arg(14)).toSInt();

    if (srcTarget == GL_RENDERBUFFER || dstTarget == GL_RENDERBUFFER) {
        retrace::warning(call) << " renderbuffer targets unsupported (https://git.io/JOMRC)\n";
    }
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCopyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDebugMessageControlARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum source;
    source = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(1)).toSInt());

    GLenum severity;
    severity = static_cast<GLenum>((call.arg(2)).toSInt());

    GLsizei count;
    count = (call.arg(3)).toSInt();

    GLuint * ids;
    ids = _allocator.allocArray<GLuint>(&call.arg(4));
    const trace::Array *_a_GLuint132_0 = (call.arg(4)).toArray();
    if (_a_GLuint132_0) {
        for (size_t _jGLuint132 = 0; _jGLuint132 < _a_GLuint132_0->values.size(); ++_jGLuint132) {
    ids[_jGLuint132] = (*_a_GLuint132_0->values[_jGLuint132]).toUInt();
        }
    }

    GLboolean enabled;
    enabled = static_cast<GLboolean>((call.arg(5)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDebugMessageControlARB(source, type, severity, count, ids, enabled);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glDebugMessageInsertARB(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLenum source;
    source = static_cast<GLenum>((call.arg(0)).toSInt());

    GLenum type;
    type = static_cast<GLenum>((call.arg(1)).toSInt());

    GLuint id;
    id = (call.arg(2)).toUInt();

    GLenum severity;
    severity = static_cast<GLenum>((call.arg(3)).toSInt());

    GLsizei length;
    length = (call.arg(4)).toSInt();

    const GLchar * buf;
    buf = (const GLchar *)((call.arg(5)).toString());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glDebugMessageInsertARB(source, type, id, severity, length, buf);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCreateTransformFeedbacks(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * ids;
    ids = _allocator.allocArray<GLuint>(&call.arg(1));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCreateTransformFeedbacks(n, ids);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint134 = (call.arg(1)).toArray();
    if (_aGLuint134) {
        for (size_t _jGLuint134 = 0; _jGLuint134 < _aGLuint134->values.size(); ++_jGLuint134) {
    GLuint _origResult;
    _origResult = (*_aGLuint134->values[_jGLuint134]).toUInt();
    _feedback_map[_origResult] = ids[_jGLuint134];
    if (retrace::verbosity >= 2) {
        std::cout << "feedback " << _origResult << " -> " << ids[_jGLuint134] << "\n";
    }
        }
    }
}

static void retrace_glTransformFeedbackBufferBase(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint xfb;
    xfb = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "feedback " << size_t(xfb) << " <- " << size_t(_feedback_map[xfb]) << "\n";
    }
    xfb = _feedback_map[xfb];

    GLuint index;
    index = (call.arg(1)).toUInt();

    GLuint buffer;
    buffer = (call.arg(2)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << size_t(buffer) << " <- " << size_t(_buffer_map[buffer]) << "\n";
    }
    buffer = _buffer_map[buffer];

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTransformFeedbackBufferBase(xfb, index, buffer);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glTransformFeedbackBufferRange(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint xfb;
    xfb = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "feedback " << size_t(xfb) << " <- " << size_t(_feedback_map[xfb]) << "\n";
    }
    xfb = _feedback_map[xfb];

    GLuint index;
    index = (call.arg(1)).toUInt();

    GLuint buffer;
    buffer = (call.arg(2)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << size_t(buffer) << " <- " << size_t(_buffer_map[buffer]) << "\n";
    }
    buffer = _buffer_map[buffer];

    GLintptr offset;
    offset = (call.arg(3)).toSInt();

    GLsizeiptr size;
    size = (call.arg(4)).toSInt();

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glTransformFeedbackBufferRange(xfb, index, buffer, offset, size);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCreateBuffers(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLsizei n;
    n = (call.arg(0)).toSInt();

    GLuint * buffers;
    buffers = _allocator.allocArray<GLuint>(&call.arg(1));

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glCreateBuffers(n, buffers);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
    const trace::Array *_aGLuint136 = (call.arg(1)).toArray();
    if (_aGLuint136) {
        for (size_t _jGLuint136 = 0; _jGLuint136 < _aGLuint136->values.size(); ++_jGLuint136) {
    GLuint _origResult;
    _origResult = (*_aGLuint136->values[_jGLuint136]).toUInt();
    _buffer_map[_origResult] = buffers[_jGLuint136];
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << _origResult << " -> " << buffers[_jGLuint136] << "\n";
    }
        }
    }
}

static void retrace_glNamedBufferStorage(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint buffer;
    buffer = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << size_t(buffer) << " <- " << size_t(_buffer_map[buffer]) << "\n";
    }
    buffer = _buffer_map[buffer];

    GLsizeiptr size;
    size = (call.arg(1)).toSInt();

    void * data;
    data = static_cast<void *>((call.arg(2)).toPointer());

    GLbitfield flags;
    flags = static_cast<GLbitfield>((call.arg(3)).toUInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNamedBufferStorage(buffer, size, data, flags);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNamedBufferData(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint buffer;
    buffer = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << size_t(buffer) << " <- " << size_t(_buffer_map[buffer]) << "\n";
    }
    buffer = _buffer_map[buffer];

    GLsizeiptr size;
    size = (call.arg(1)).toSInt();

    void * data;
    data = static_cast<void *>((call.arg(2)).toPointer());

    GLenum usage;
    usage = static_cast<GLenum>((call.arg(3)).toSInt());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNamedBufferData(buffer, size, data, usage);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glNamedBufferSubData(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentContext();
    if (!currentContext) {
        if (retrace::debug > 0) {
            retrace::warning(call) << "no current context\n";
        }
#ifndef _WIN32
        return;
#endif
    }
    if (retrace::markers) {
        glretrace::insertCallMarker(call, currentContext);
    }
    retrace::ScopedAllocator _allocator;
    (void)_allocator;
    GLuint buffer;
    buffer = (call.arg(0)).toUInt();
    if (retrace::verbosity >= 2) {
        std::cout << "buffer " << size_t(buffer) << " <- " << size_t(_buffer_map[buffer]) << "\n";
    }
    buffer = _buffer_map[buffer];

    GLintptr offset;
    offset = (call.arg(1)).toSInt();

    GLsizeiptr size;
    size = (call.arg(2)).toSInt();

    void * data;
    data = static_cast<void *>((call.arg(3)).toPointer());

    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::beginProfile(call, false);
    }
    glNamedBufferSubData(buffer, offset, size, data);
    if (currentContext && !currentContext->insideList && !currentContext->insideBeginEnd && retrace::profiling) {
        glretrace::endProfile(call, false);
    }
    if (retrace::debug > 0 && currentContext && !currentContext->insideBeginEnd) {
        glretrace::checkGlError(call);
    }
}

static void retrace_glCopyNamedBufferSubData(trace::Call &call) {
    glretrace::Context *currentContext = glretrace::getCurrentCont