/**
 * @file static_strings.h
 * @author Ambroz Bizjak <ambrop7@gmail.com>
 * 
 * @section LICENSE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the
 *    names of its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef BADVPN_STATIC_STRINGS_H
#define BADVPN_STATIC_STRINGS_H

// NOTE: keep synchronized with NCDStringIndex.c
enum {
    NCD_STRING_EMPTY,
    NCD_STRING_ARGS,
    NCD_STRING_ARG0,
    NCD_STRING_ARG1,
    NCD_STRING_ARG2,
    NCD_STRING_ARG3,
    NCD_STRING_ARG4,
    NCD_STRING_ARG5,
    NCD_STRING_ARG6,
    NCD_STRING_ARG7,
    NCD_STRING_ARG8,
    NCD_STRING_ARG9,
    NCD_STRING_ARG10,
    NCD_STRING_ARG11,
    NCD_STRING_ARG12,
    NCD_STRING_ARG13,
    NCD_STRING_ARG14,
    NCD_STRING_ARG15,
    NCD_STRING_ARG16,
    NCD_STRING_ARG17,
    NCD_STRING_ARG18,
    NCD_STRING_ARG19,
    NCD_STRING_TRUE,
    NCD_STRING_FALSE,
    NCD_STRING_NONE,
    NCD_STRING_CALLER,
    NCD_STRING_SUCCEEDED,
    NCD_STRING_IS_ERROR,
    NCD_STRING_NOT_EOF,
    NCD_STRING_LENGTH,
    NCD_STRING_TYPE,
    NCD_STRING_EXIT_STATUS,
    NCD_STRING_SIZE,
    NCD_STRING_EOF,
    NCD_STRING_SCOPE,
};

#endif
