/* KerningRange.c generated by valac 0.56.17, the Vala compiler
 * generated from KerningRange.vala, do not modify */

/*
Copyright (C) 2013 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_KERNING_RANGE_0_PROPERTY,
	BIRD_FONT_KERNING_RANGE_NUM_PROPERTIES
};
static GParamSpec* bird_font_kerning_range_properties[BIRD_FONT_KERNING_RANGE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BirdFontKerningRangePrivate {
	gboolean malformed;
	BirdFontFont* font;
};

static gint BirdFontKerningRange_private_offset;
static gpointer bird_font_kerning_range_parent_class = NULL;

static void __lambda91_ (BirdFontKerningRange* self,
                  BirdFontTool* selected,
                  guint button,
                  gdouble tx,
                  gdouble ty);
static void ___lambda91__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                     BirdFontTool* selected,
                                                     guint button,
                                                     gdouble x,
                                                     gdouble y,
                                                     gpointer self);
static gboolean __lambda327_ (BirdFontKerningRange* self,
                       BirdFontTool* selected,
                       BirdFontTool* button,
                       gdouble tx,
                       gdouble ty);
static gboolean ___lambda327__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                                         BirdFontTool* selected,
                                                         gdouble x,
                                                         gdouble y,
                                                         gpointer self);
static void __lambda328_ (BirdFontKerningRange* self,
                   BirdFontTool* selected,
                   guint button,
                   gdouble tx,
                   gdouble ty);
static void ___lambda328__bird_font_tool_panel_release_action (BirdFontTool* _sender,
                                                        BirdFontTool* selected,
                                                        guint button,
                                                        gdouble x,
                                                        gdouble y,
                                                        gpointer self);
static void bird_font_kerning_range_set_one_range (BirdFontKerningRange* self,
                                            const gchar* r,
                                            GError** error);
static void __lambda325_ (BirdFontKerningRange* self,
                   const gchar* text);
static void ___lambda325__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda326_ (BirdFontKerningRange* self);
static void ___lambda326__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static void bird_font_kerning_range_real_draw_tool (BirdFontTool* base,
                                             cairo_t* cr,
                                             gdouble px,
                                             gdouble py);
static void bird_font_kerning_range_finalize (GObject * obj);
static GType bird_font_kerning_range_get_type_once (void);

static inline gpointer
bird_font_kerning_range_get_instance_private (BirdFontKerningRange* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontKerningRange_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda91_ (BirdFontKerningRange* self,
             BirdFontTool* selected,
             guint button,
             gdouble tx,
             gdouble ty)
{
	BirdFontKerningDisplay* kerning_display = NULL;
	BirdFontKerningDisplay* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (selected != NULL);
	_tmp0_ = bird_font_main_window_get_kerning_display ();
	kerning_display = _tmp0_;
	if (button == ((guint) 3)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = bird_font_key_bindings_modifier == BIRD_FONT_CTRL;
	}
	if (_tmp1_) {
		bird_font_kerning_range_update_kerning_classes (self);
	} else {
		if (self->priv->malformed) {
			BirdFontKerningDisplay* _tmp2_;
			_tmp2_ = kerning_display;
			bird_font_kerning_display_show_parse_error (_tmp2_);
		} else {
			gboolean _tmp3_ = FALSE;
			if (button == ((guint) 1)) {
				BirdFontGlyphRange* _tmp4_;
				_tmp4_ = self->glyph_range;
				_tmp3_ = !bird_font_glyph_range_is_empty (_tmp4_);
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				BirdFontKerningDisplay* _tmp5_;
				BirdFontGlyphRange* _tmp6_;
				_tmp5_ = kerning_display;
				_tmp6_ = self->glyph_range;
				bird_font_kerning_display_add_range (_tmp5_, _tmp6_);
			}
		}
	}
	_g_object_unref0 (kerning_display);
}

static void
___lambda91__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                guint button,
                                                gdouble x,
                                                gdouble y,
                                                gpointer self)
{
	__lambda91_ ((BirdFontKerningRange*) self, selected, button, x, y);
}

static gboolean
__lambda327_ (BirdFontKerningRange* self,
              BirdFontTool* selected,
              BirdFontTool* button,
              gdouble tx,
              gdouble ty)
{
	gboolean result;
	g_return_val_if_fail (selected != NULL, FALSE);
	g_return_val_if_fail (button != NULL, FALSE);
	result = FALSE;
	return result;
}

static gboolean
___lambda327__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gdouble x,
                                                gdouble y,
                                                gpointer self)
{
	gboolean result;
	result = __lambda327_ ((BirdFontKerningRange*) self, _sender, selected, x, y);
	return result;
}

static void
__lambda328_ (BirdFontKerningRange* self,
              BirdFontTool* selected,
              guint button,
              gdouble tx,
              gdouble ty)
{
	g_return_if_fail (selected != NULL);
}

static void
___lambda328__bird_font_tool_panel_release_action (BirdFontTool* _sender,
                                                   BirdFontTool* selected,
                                                   guint button,
                                                   gdouble x,
                                                   gdouble y,
                                                   gpointer self)
{
	__lambda328_ ((BirdFontKerningRange*) self, selected, button, x, y);
}

BirdFontKerningRange*
bird_font_kerning_range_construct (GType object_type,
                                   BirdFontFont* f,
                                   const gchar* name,
                                   const gchar* tip)
{
	BirdFontKerningRange * self = NULL;
	BirdFontFont* _tmp0_;
	BirdFontGlyphRange* _tmp1_;
	g_return_val_if_fail (f != NULL, NULL);
	g_return_val_if_fail (tip != NULL, NULL);
	self = (BirdFontKerningRange*) bird_font_tool_construct (object_type, NULL, tip);
	_tmp0_ = _g_object_ref0 (f);
	_g_object_unref0 (self->priv->font);
	self->priv->font = _tmp0_;
	_tmp1_ = bird_font_glyph_range_new ();
	_bird_font_glyph_range_unref0 (self->glyph_range);
	self->glyph_range = _tmp1_;
	if (name != NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ((const gchar*) name);
		_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->name);
		G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->name = _tmp2_;
	}
	g_signal_connect_object ((BirdFontTool*) self, "panel-press-action", (GCallback) ___lambda91__bird_font_tool_panel_press_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-move-action", (GCallback) ___lambda327__bird_font_tool_panel_move_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-release-action", (GCallback) ___lambda328__bird_font_tool_panel_release_action, self, 0);
	return self;
}

BirdFontKerningRange*
bird_font_kerning_range_new (BirdFontFont* f,
                             const gchar* name,
                             const gchar* tip)
{
	return bird_font_kerning_range_construct (BIRD_FONT_TYPE_KERNING_RANGE, f, name, tip);
}

void
bird_font_kerning_range_update_spacing_class (BirdFontKerningRange* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->ranges;
	bird_font_kerning_range_set_ranges (self, _tmp0_);
}

void
bird_font_kerning_range_set_ranges (BirdFontKerningRange* self,
                                    const gchar* r)
{
	BirdFontGlyphRange* glyph_range = NULL;
	BirdFontGlyphRange* _tmp0_;
	BirdFontSpacingData* spacing = NULL;
	BirdFontFont* _tmp1_;
	BirdFontSpacingData* _tmp2_;
	gchar* new_range = NULL;
	gchar* ch = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_tmp0_ = bird_font_glyph_range_new ();
	glyph_range = _tmp0_;
	_tmp1_ = self->priv->font;
	_tmp2_ = bird_font_font_get_spacing (_tmp1_);
	spacing = _tmp2_;
	{
		BirdFontGlyphRange* _tmp3_;
		BirdFontGlyphRange* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp36_;
		_tmp3_ = glyph_range;
		bird_font_glyph_range_parse_ranges (_tmp3_, r, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch0_g_markup_error;
			}
			_g_free0 (ch);
			_g_free0 (new_range);
			_g_object_unref0 (spacing);
			_bird_font_glyph_range_unref0 (glyph_range);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = glyph_range;
		_tmp5_ = bird_font_glyph_range_get_all_ranges (_tmp4_);
		_g_free0 (new_range);
		new_range = _tmp5_;
		self->priv->malformed = FALSE;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					BirdFontGlyphRange* _tmp8_;
					BirdFontGlyphRange* _tmp9_;
					gchar* _tmp10_;
					BirdFontFont* _tmp34_;
					const gchar* _tmp35_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = glyph_range;
					if (!(((guint32) i) < bird_font_glyph_range_get_length (_tmp8_))) {
						break;
					}
					_tmp9_ = glyph_range;
					_tmp10_ = bird_font_glyph_range_get_char (_tmp9_, (guint32) i);
					_g_free0 (ch);
					ch = _tmp10_;
					{
						GeeArrayList* _c_list = NULL;
						BirdFontSpacingData* _tmp11_;
						const gchar* _tmp12_;
						GeeArrayList* _tmp13_;
						gint _c_size = 0;
						GeeArrayList* _tmp14_;
						gint _tmp15_;
						gint _tmp16_;
						gint _c_index = 0;
						_tmp11_ = spacing;
						_tmp12_ = ch;
						_tmp13_ = bird_font_spacing_data_get_all_connections (_tmp11_, _tmp12_);
						_c_list = _tmp13_;
						_tmp14_ = _c_list;
						_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
						_tmp16_ = _tmp15_;
						_c_size = _tmp16_;
						_c_index = -1;
						while (TRUE) {
							gint _tmp17_;
							gint _tmp18_;
							gchar* c = NULL;
							GeeArrayList* _tmp19_;
							gpointer _tmp20_;
							gboolean _tmp21_ = FALSE;
							gboolean _tmp22_ = FALSE;
							BirdFontGlyphRange* _tmp23_;
							const gchar* _tmp24_;
							_c_index = _c_index + 1;
							_tmp17_ = _c_index;
							_tmp18_ = _c_size;
							if (!(_tmp17_ < _tmp18_)) {
								break;
							}
							_tmp19_ = _c_list;
							_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _c_index);
							c = (gchar*) _tmp20_;
							_tmp23_ = glyph_range;
							_tmp24_ = c;
							if (!bird_font_glyph_range_has_character (_tmp23_, _tmp24_)) {
								const gchar* _tmp25_;
								_tmp25_ = c;
								_tmp22_ = g_strcmp0 (_tmp25_, "") != 0;
							} else {
								_tmp22_ = FALSE;
							}
							if (_tmp22_) {
								const gchar* _tmp26_;
								_tmp26_ = c;
								_tmp21_ = g_strcmp0 (_tmp26_, "?") != 0;
							} else {
								_tmp21_ = FALSE;
							}
							if (_tmp21_) {
								const gchar* _tmp27_;
								const gchar* _tmp28_;
								gchar* _tmp29_;
								gchar* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_;
								gchar* _tmp33_;
								_tmp27_ = new_range;
								_tmp28_ = c;
								_tmp29_ = bird_font_glyph_range_serialize (_tmp28_);
								_tmp30_ = _tmp29_;
								_tmp31_ = g_strconcat (" ", _tmp30_, NULL);
								_tmp32_ = _tmp31_;
								_tmp33_ = g_strconcat (_tmp27_, _tmp32_, NULL);
								_g_free0 (new_range);
								new_range = _tmp33_;
								_g_free0 (_tmp32_);
								_g_free0 (_tmp30_);
							}
							_g_free0 (c);
						}
						_g_object_unref0 (_c_list);
					}
					_tmp34_ = self->priv->font;
					_tmp35_ = ch;
					if (!bird_font_font_has_glyph (_tmp34_, _tmp35_)) {
						self->priv->malformed = TRUE;
					}
				}
			}
		}
		_tmp36_ = new_range;
		bird_font_kerning_range_set_one_range (self, _tmp36_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch0_g_markup_error;
			}
			_g_free0 (ch);
			_g_free0 (new_range);
			_g_object_unref0 (spacing);
			_bird_font_glyph_range_unref0 (glyph_range);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp37_;
		const gchar* _tmp38_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp37_ = e;
		_tmp38_ = _tmp37_->message;
		g_warning ("KerningRange.vala:90: %s", _tmp38_);
		self->priv->malformed = TRUE;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (ch);
		_g_free0 (new_range);
		_g_object_unref0 (spacing);
		_bird_font_glyph_range_unref0 (glyph_range);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (ch);
	_g_free0 (new_range);
	_g_object_unref0 (spacing);
	_bird_font_glyph_range_unref0 (glyph_range);
}

static void
bird_font_kerning_range_set_one_range (BirdFontKerningRange* self,
                                       const gchar* r,
                                       GError** error)
{
	BirdFontGlyphRange* old = NULL;
	BirdFontGlyphRange* _tmp0_;
	BirdFontGlyphRange* _tmp1_;
	const gchar* _tmp2_;
	BirdFontGlyphRange* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontGlyphRange* _tmp6_;
	BirdFontGlyphRange* _tmp7_;
	BirdFontGlyphRange* _tmp8_;
	BirdFontFont* _tmp9_;
	BirdFontSpacingData* _tmp10_;
	BirdFontKerningClasses* _tmp11_;
	BirdFontGlyphRange* _tmp12_;
	BirdFontGlyphRange* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_tmp0_ = bird_font_glyph_range_new ();
	old = _tmp0_;
	_tmp1_ = old;
	_tmp2_ = self->ranges;
	bird_font_glyph_range_parse_ranges (_tmp1_, _tmp2_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_MARKUP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_bird_font_glyph_range_unref0 (old);
			return;
		} else {
			_bird_font_glyph_range_unref0 (old);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp3_ = old;
	bird_font_glyph_range_set_class (_tmp3_, TRUE);
	_tmp4_ = g_strdup (r);
	_g_free0 (self->ranges);
	self->ranges = _tmp4_;
	_tmp5_ = g_strdup (r);
	_g_free0 (((BirdFontTool*) self)->name);
	((BirdFontTool*) self)->name = _tmp5_;
	_tmp6_ = self->glyph_range;
	bird_font_glyph_range_empty (_tmp6_);
	_tmp7_ = self->glyph_range;
	bird_font_glyph_range_parse_ranges (_tmp7_, r, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_MARKUP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_bird_font_glyph_range_unref0 (old);
			return;
		} else {
			_bird_font_glyph_range_unref0 (old);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp8_ = self->glyph_range;
	bird_font_glyph_range_set_class (_tmp8_, TRUE);
	_tmp9_ = self->priv->font;
	_tmp10_ = _tmp9_->spacing;
	_tmp11_ = _tmp10_->kerning_classes;
	_tmp12_ = old;
	_tmp13_ = self->glyph_range;
	bird_font_kerning_classes_update_range (_tmp11_, _tmp12_, _tmp13_);
	_bird_font_glyph_range_unref0 (old);
}

static void
__lambda325_ (BirdFontKerningRange* self,
              const gchar* text)
{
	BirdFontExpander* _tmp0_;
	BirdFontExpander* _tmp1_;
	g_return_if_fail (text != NULL);
	bird_font_kerning_range_set_ranges (self, text);
	_tmp0_ = bird_font_kerning_tools_classes;
	bird_font_expander_clear_cache (_tmp0_);
	_tmp1_ = bird_font_kerning_tools_classes;
	bird_font_expander_redraw (_tmp1_);
}

static void
___lambda325__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda325_ ((BirdFontKerningRange*) self, text);
}

static void
__lambda326_ (BirdFontKerningRange* self)
{
	BirdFontKerningDisplay* _tmp0_;
	BirdFontKerningDisplay* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = bird_font_main_window_get_kerning_display ();
	_tmp1_ = _tmp0_;
	_tmp1_->suppress_input = FALSE;
	_g_object_unref0 (_tmp1_);
	bird_font_tab_content_hide_text_input ();
	_tmp2_ = self->ranges;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		BirdFontGlyphRange* _tmp3_;
		_tmp3_ = self->glyph_range;
		bird_font_glyph_range_empty (_tmp3_);
		bird_font_kerning_tools_remove_empty_classes ();
	}
}

static void
___lambda326__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda326_ ((BirdFontKerningRange*) self);
}

void
bird_font_kerning_range_update_kerning_classes (BirdFontKerningRange* self)
{
	BirdFontKerningDisplay* kerning_display = NULL;
	BirdFontKerningDisplay* _tmp0_;
	BirdFontTextListener* listener = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontTextListener* _tmp6_;
	BirdFontTextListener* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_kerning_display ();
	kerning_display = _tmp0_;
	_tmp1_ = bird_font_t_ ("Kerning class");
	_tmp2_ = _tmp1_;
	_tmp3_ = self->ranges;
	_tmp4_ = bird_font_t_ ("Set");
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_text_listener_new (_tmp2_, _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	listener = _tmp7_;
	g_signal_connect_object (listener, "signal-text-input", (GCallback) ___lambda325__bird_font_text_listener_signal_text_input, self, 0);
	g_signal_connect_object (listener, "signal-submit", (GCallback) ___lambda326__bird_font_text_listener_signal_submit, self, 0);
	kerning_display->suppress_input = TRUE;
	bird_font_tab_content_show_text_input (listener);
	_g_object_unref0 (listener);
	_g_object_unref0 (kerning_display);
}

static void
bird_font_kerning_range_real_draw_tool (BirdFontTool* base,
                                        cairo_t* cr,
                                        gdouble px,
                                        gdouble py)
{
	BirdFontKerningRange * self;
	gdouble xt = 0.0;
	gdouble yt = 0.0;
	BirdFontText* label_text = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	BirdFontText* _tmp0_;
	const gchar* _tmp1_;
	self = (BirdFontKerningRange*) base;
	g_return_if_fail (cr != NULL);
	x = ((BirdFontTool*) self)->x - px;
	y = ((BirdFontTool*) self)->y - py;
	xt = x + 5;
	yt = y + 10;
	cairo_save (cr);
	_tmp0_ = bird_font_text_new ("", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (label_text);
	label_text = _tmp0_;
	_tmp1_ = ((BirdFontTool*) self)->name;
	bird_font_text_set_text (label_text, _tmp1_);
	bird_font_theme_text_color (label_text, "Text Tool Box");
	bird_font_text_set_font_size (label_text, (gdouble) 18);
	((BirdFontWidget*) label_text)->widget_x = x;
	((BirdFontWidget*) label_text)->widget_y = y;
	bird_font_widget_draw ((BirdFontWidget*) label_text, cr);
	cairo_restore (cr);
	_g_object_unref0 (label_text);
}

static void
bird_font_kerning_range_class_init (BirdFontKerningRangeClass * klass,
                                    gpointer klass_data)
{
	bird_font_kerning_range_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontKerningRange_private_offset);
	((BirdFontToolClass *) klass)->draw_tool = (void (*) (BirdFontTool*, cairo_t*, gdouble, gdouble)) bird_font_kerning_range_real_draw_tool;
	G_OBJECT_CLASS (klass)->finalize = bird_font_kerning_range_finalize;
}

static void
bird_font_kerning_range_instance_init (BirdFontKerningRange * self,
                                       gpointer klass)
{
	gchar* _tmp0_;
	self->priv = bird_font_kerning_range_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->ranges = _tmp0_;
	self->priv->malformed = FALSE;
}

static void
bird_font_kerning_range_finalize (GObject * obj)
{
	BirdFontKerningRange * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_KERNING_RANGE, BirdFontKerningRange);
	_g_free0 (self->ranges);
	_bird_font_glyph_range_unref0 (self->glyph_range);
	_g_object_unref0 (self->priv->font);
	G_OBJECT_CLASS (bird_font_kerning_range_parent_class)->finalize (obj);
}

/** Representation of a kerning class. */
static GType
bird_font_kerning_range_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontKerningRangeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_kerning_range_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontKerningRange), 0, (GInstanceInitFunc) bird_font_kerning_range_instance_init, NULL };
	GType bird_font_kerning_range_type_id;
	bird_font_kerning_range_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontKerningRange", &g_define_type_info, 0);
	BirdFontKerningRange_private_offset = g_type_add_instance_private (bird_font_kerning_range_type_id, sizeof (BirdFontKerningRangePrivate));
	return bird_font_kerning_range_type_id;
}

GType
bird_font_kerning_range_get_type (void)
{
	static volatile gsize bird_font_kerning_range_type_id__once = 0;
	if (g_once_init_enter (&bird_font_kerning_range_type_id__once)) {
		GType bird_font_kerning_range_type_id;
		bird_font_kerning_range_type_id = bird_font_kerning_range_get_type_once ();
		g_once_init_leave (&bird_font_kerning_range_type_id__once, bird_font_kerning_range_type_id);
	}
	return bird_font_kerning_range_type_id__once;
}

