/* KerningList.c generated by valac 0.56.17, the Vala compiler
 * generated from KerningList.vala, do not modify */

/*
Copyright (C) 2013 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BIRD_FONT_KERNING_LIST_TYPE_UNDO_ITEM (bird_font_kerning_list_undo_item_get_type ())
#define BIRD_FONT_KERNING_LIST_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_KERNING_LIST_TYPE_UNDO_ITEM, BirdFontKerningListUndoItem))
#define BIRD_FONT_KERNING_LIST_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_KERNING_LIST_TYPE_UNDO_ITEM, BirdFontKerningListUndoItemClass))
#define BIRD_FONT_KERNING_LIST_IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_KERNING_LIST_TYPE_UNDO_ITEM))
#define BIRD_FONT_KERNING_LIST_IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_KERNING_LIST_TYPE_UNDO_ITEM))
#define BIRD_FONT_KERNING_LIST_UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_KERNING_LIST_TYPE_UNDO_ITEM, BirdFontKerningListUndoItemClass))

typedef struct _BirdFontKerningListUndoItem BirdFontKerningListUndoItem;
typedef struct _BirdFontKerningListUndoItemClass BirdFontKerningListUndoItemClass;
enum  {
	BIRD_FONT_KERNING_LIST_0_PROPERTY,
	BIRD_FONT_KERNING_LIST_NUM_PROPERTIES
};
static GParamSpec* bird_font_kerning_list_properties[BIRD_FONT_KERNING_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block23Data Block23Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BirdFontKerningListUndoItemPrivate BirdFontKerningListUndoItemPrivate;
enum  {
	BIRD_FONT_KERNING_LIST_UNDO_ITEM_0_PROPERTY,
	BIRD_FONT_KERNING_LIST_UNDO_ITEM_NUM_PROPERTIES
};
static GParamSpec* bird_font_kerning_list_undo_item_properties[BIRD_FONT_KERNING_LIST_UNDO_ITEM_NUM_PROPERTIES];

struct _BirdFontKerningListPrivate {
	GeeArrayList* undo_items;
};

struct _Block23Data {
	int _ref_count_;
	BirdFontKerningList* self;
	GeeArrayList* rows;
	gint i;
};

struct _BirdFontKerningListUndoItem {
	GObject parent_instance;
	BirdFontKerningListUndoItemPrivate * priv;
	gchar* first;
	gchar* next;
	gdouble kerning;
	gint class_priority;
};

struct _BirdFontKerningListUndoItemClass {
	GObjectClass parent_class;
};

static gint BirdFontKerningList_private_offset;
static gpointer bird_font_kerning_list_parent_class = NULL;
static gpointer bird_font_kerning_list_undo_item_parent_class = NULL;

static GType bird_font_kerning_list_undo_item_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GeeArrayList* bird_font_kerning_list_real_get_rows (BirdFontTable* base);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void __lambda406_ (Block23Data* _data23_,
                   const gchar* left,
                   const gchar* right,
                   gdouble kerning);
static void ___lambda406__bird_font_kerning_classes_kerning_class_iterator (const gchar* left,
                                                                     const gchar* right,
                                                                     gdouble kerning,
                                                                     gpointer self);
static void __lambda407_ (Block23Data* _data23_,
                   const gchar* left,
                   const gchar* right,
                   gdouble kerning);
static void ___lambda407__bird_font_kerning_classes_kerning_class_iterator (const gchar* left,
                                                                     const gchar* right,
                                                                     gdouble kerning,
                                                                     gpointer self);
static gint __lambda408_ (BirdFontKerningList* self,
                   BirdFontRow* a,
                   BirdFontRow* b);
static gint ___lambda408__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static void bird_font_kerning_list_real_selected_row (BirdFontTable* base,
                                               BirdFontRow* row,
                                               gint column,
                                               gboolean delete_button);
static void bird_font_kerning_list_delete_kerning (BirdFontKerningList* self,
                                            const gchar* left,
                                            const gchar* right);
static BirdFontKerningListUndoItem* bird_font_kerning_list_undo_item_new (const gchar* first,
                                                                   const gchar* next,
                                                                   gdouble kerning,
                                                                   gint class_priority);
static BirdFontKerningListUndoItem* bird_font_kerning_list_undo_item_construct (GType object_type,
                                                                         const gchar* first,
                                                                         const gchar* next,
                                                                         gdouble kerning,
                                                                         gint class_priority);
static gchar* bird_font_kerning_list_real_get_label (BirdFontFontDisplay* base);
static gchar* bird_font_kerning_list_real_get_name (BirdFontFontDisplay* base);
static void bird_font_kerning_list_real_undo (BirdFontFontDisplay* base);
static void bird_font_kerning_list_real_update_rows (BirdFontTable* base);
static void bird_font_kerning_list_undo_item_finalize (GObject * obj);
static GType bird_font_kerning_list_undo_item_get_type_once (void);
static void bird_font_kerning_list_finalize (GObject * obj);
static GType bird_font_kerning_list_get_type_once (void);

static inline gpointer
bird_font_kerning_list_get_instance_private (BirdFontKerningList* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontKerningList_private_offset);
}

BirdFontKerningList*
bird_font_kerning_list_construct (GType object_type)
{
	BirdFontKerningList * self = NULL;
	GeeArrayList* _tmp0_;
	self = (BirdFontKerningList*) bird_font_table_construct (object_type);
	_tmp0_ = gee_array_list_new (BIRD_FONT_KERNING_LIST_TYPE_UNDO_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->undo_items);
	self->priv->undo_items = _tmp0_;
	return self;
}

BirdFontKerningList*
bird_font_kerning_list_new (void)
{
	return bird_font_kerning_list_construct (BIRD_FONT_TYPE_KERNING_LIST);
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		BirdFontKerningList* self;
		self = _data23_->self;
		_g_object_unref0 (_data23_->rows);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static void
__lambda406_ (Block23Data* _data23_,
              const gchar* left,
              const gchar* right,
              gdouble kerning)
{
	BirdFontKerningList* self;
	BirdFontRow* r = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BirdFontRow* _tmp2_;
	BirdFontRow* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	self = _data23_->self;
	g_return_if_fail (left != NULL);
	g_return_if_fail (right != NULL);
	_tmp0_ = double_to_string (kerning);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_row_new_columns_3 (left, right, _tmp1_, _data23_->i, TRUE);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	r = _tmp3_;
	_tmp4_ = _data23_->rows;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, r);
	_tmp5_ = _data23_->i;
	_data23_->i = _tmp5_ + 1;
	_g_object_unref0 (r);
}

static void
___lambda406__bird_font_kerning_classes_kerning_class_iterator (const gchar* left,
                                                                const gchar* right,
                                                                gdouble kerning,
                                                                gpointer self)
{
	__lambda406_ (self, left, right, kerning);
}

static void
__lambda407_ (Block23Data* _data23_,
              const gchar* left,
              const gchar* right,
              gdouble kerning)
{
	BirdFontKerningList* self;
	BirdFontRow* r = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BirdFontRow* _tmp2_;
	BirdFontRow* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	self = _data23_->self;
	g_return_if_fail (left != NULL);
	g_return_if_fail (right != NULL);
	_tmp0_ = double_to_string (kerning);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_row_new_columns_3 (left, right, _tmp1_, _data23_->i, TRUE);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	r = _tmp3_;
	_tmp4_ = _data23_->rows;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, r);
	_tmp5_ = _data23_->i;
	_data23_->i = _tmp5_ + 1;
	_g_object_unref0 (r);
}

static void
___lambda407__bird_font_kerning_classes_kerning_class_iterator (const gchar* left,
                                                                const gchar* right,
                                                                gdouble kerning,
                                                                gpointer self)
{
	__lambda407_ (self, left, right, kerning);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
__lambda408_ (BirdFontKerningList* self,
              BirdFontRow* a,
              BirdFontRow* b)
{
	BirdFontRow* sa = NULL;
	BirdFontRow* sb = NULL;
	BirdFontRow* _tmp0_;
	BirdFontRow* _tmp1_;
	GCompareFunc _tmp2_;
	GeeArrayList* _tmp3_;
	gpointer _tmp4_;
	BirdFontText* _tmp5_;
	const gchar* _tmp6_;
	GeeArrayList* _tmp7_;
	gpointer _tmp8_;
	BirdFontText* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_ROW, BirdFontRow));
	_g_object_unref0 (sa);
	sa = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_ROW, BirdFontRow));
	_g_object_unref0 (sb);
	sb = _tmp1_;
	_tmp2_ = ((GCompareFunc) g_strcmp0);
	_tmp3_ = sa->column_text;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
	_tmp5_ = (BirdFontText*) _tmp4_;
	_tmp6_ = _tmp5_->text;
	_tmp7_ = sb->column_text;
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, 0);
	_tmp9_ = (BirdFontText*) _tmp8_;
	_tmp10_ = _tmp9_->text;
	_tmp11_ = _tmp2_ (_tmp6_, _tmp10_);
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp5_);
	result = _tmp11_;
	_g_object_unref0 (sb);
	_g_object_unref0 (sa);
	return result;
}

static gint
___lambda408__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = __lambda408_ ((BirdFontKerningList*) self, (BirdFontRow*) a, (BirdFontRow*) b);
	return result;
}

static GeeArrayList*
bird_font_kerning_list_real_get_rows (BirdFontTable* base)
{
	BirdFontKerningList * self;
	Block23Data* _data23_;
	GeeArrayList* _tmp0_;
	BirdFontKerningClasses* classes = NULL;
	BirdFontFont* _tmp1_;
	BirdFontFont* _tmp2_;
	BirdFontKerningClasses* _tmp3_;
	BirdFontKerningClasses* _tmp4_;
	BirdFontKerningClasses* _tmp5_;
	BirdFontKerningClasses* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	BirdFontRow* _tmp11_;
	BirdFontRow* _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* result;
	self = (BirdFontKerningList*) base;
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_data23_->self = g_object_ref (self);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data23_->rows = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_font_get_kerning_classes (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	classes = _tmp4_;
	_data23_->i = 0;
	_tmp5_ = classes;
	bird_font_kerning_classes_get_classes (_tmp5_, ___lambda406__bird_font_kerning_classes_kerning_class_iterator, _data23_);
	_tmp6_ = classes;
	bird_font_kerning_classes_get_single_position_pairs (_tmp6_, ___lambda407__bird_font_kerning_classes_kerning_class_iterator, _data23_);
	_tmp7_ = _data23_->rows;
	gee_list_sort ((GeeList*) _tmp7_, ___lambda408__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp8_ = _data23_->rows;
	_tmp9_ = bird_font_t_ ("Kerning Pairs");
	_tmp10_ = _tmp9_;
	_tmp11_ = bird_font_row_new_headline (_tmp10_);
	_tmp12_ = _tmp11_;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp8_, 0, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = _data23_->rows;
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == 1) {
		GeeArrayList* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		BirdFontRow* _tmp19_;
		BirdFontRow* _tmp20_;
		_tmp16_ = _data23_->rows;
		_tmp17_ = bird_font_t_ ("No kerning pairs created.");
		_tmp18_ = _tmp17_;
		_tmp19_ = bird_font_row_new_columns_1 (_tmp18_, 0, FALSE);
		_tmp20_ = _tmp19_;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp16_, 1, _tmp20_);
		_g_object_unref0 (_tmp20_);
		_g_free0 (_tmp18_);
	}
	_tmp21_ = _data23_->rows;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	result = _tmp22_;
	_g_object_unref0 (classes);
	block23_data_unref (_data23_);
	_data23_ = NULL;
	return result;
}

static void
bird_font_kerning_list_real_selected_row (BirdFontTable* base,
                                          BirdFontRow* row,
                                          gint column,
                                          gboolean delete_button)
{
	BirdFontKerningList * self;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = (BirdFontKerningList*) base;
	g_return_if_fail (row != NULL);
	_tmp0_ = row->column_text;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ > 2);
	if (delete_button) {
		GeeArrayList* _tmp3_;
		gpointer _tmp4_;
		BirdFontText* _tmp5_;
		const gchar* _tmp6_;
		GeeArrayList* _tmp7_;
		gpointer _tmp8_;
		BirdFontText* _tmp9_;
		const gchar* _tmp10_;
		_tmp3_ = row->column_text;
		_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
		_tmp5_ = (BirdFontText*) _tmp4_;
		_tmp6_ = _tmp5_->text;
		_tmp7_ = row->column_text;
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, 1);
		_tmp9_ = (BirdFontText*) _tmp8_;
		_tmp10_ = _tmp9_->text;
		bird_font_kerning_list_delete_kerning (self, _tmp6_, _tmp10_);
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (_tmp5_);
	}
}

static void
bird_font_kerning_list_delete_kerning (BirdFontKerningList* self,
                                       const gchar* left,
                                       const gchar* right)
{
	gdouble kerning = 0.0;
	BirdFontGlyphRange* glyph_range_first = NULL;
	BirdFontGlyphRange* glyph_range_next = NULL;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontKerningClasses* classes = NULL;
	BirdFontFont* _tmp1_;
	BirdFontKerningClasses* _tmp2_;
	gchar* l = NULL;
	gchar* r = NULL;
	gint class_index = 0;
	gchar* _tmp3_;
	gchar* _tmp4_;
	BirdFontGlyphRange* _tmp5_;
	BirdFontGlyphRange* _tmp6_;
	gboolean _tmp11_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (left != NULL);
	g_return_if_fail (right != NULL);
	kerning = (gdouble) 0;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = font;
	_tmp2_ = bird_font_font_get_kerning_classes (_tmp1_);
	classes = _tmp2_;
	class_index = -1;
	_tmp3_ = bird_font_glyph_range_unserialize (left);
	_g_free0 (l);
	l = _tmp3_;
	_tmp4_ = bird_font_glyph_range_unserialize (right);
	_g_free0 (r);
	r = _tmp4_;
	_tmp5_ = bird_font_glyph_range_new ();
	_bird_font_glyph_range_unref0 (glyph_range_first);
	glyph_range_first = _tmp5_;
	_tmp6_ = bird_font_glyph_range_new ();
	_bird_font_glyph_range_unref0 (glyph_range_next);
	glyph_range_next = _tmp6_;
	{
		BirdFontGlyphRange* _tmp7_;
		BirdFontGlyphRange* _tmp8_;
		_tmp7_ = glyph_range_first;
		bird_font_glyph_range_parse_ranges (_tmp7_, left, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch0_g_markup_error;
			}
			_g_free0 (r);
			_g_free0 (l);
			_g_object_unref0 (classes);
			_g_object_unref0 (font);
			_bird_font_glyph_range_unref0 (glyph_range_next);
			_bird_font_glyph_range_unref0 (glyph_range_first);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp8_ = glyph_range_next;
		bird_font_glyph_range_parse_ranges (_tmp8_, right, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch0_g_markup_error;
			}
			_g_free0 (r);
			_g_free0 (l);
			_g_object_unref0 (classes);
			_g_object_unref0 (font);
			_bird_font_glyph_range_unref0 (glyph_range_next);
			_bird_font_glyph_range_unref0 (glyph_range_first);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("KerningList.vala:89: %s", _tmp10_);
		_g_error_free0 (e);
		_g_free0 (r);
		_g_free0 (l);
		_g_object_unref0 (classes);
		_g_object_unref0 (font);
		_bird_font_glyph_range_unref0 (glyph_range_next);
		_bird_font_glyph_range_unref0 (glyph_range_first);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (r);
		_g_free0 (l);
		_g_object_unref0 (classes);
		_g_object_unref0 (font);
		_bird_font_glyph_range_unref0 (glyph_range_next);
		_bird_font_glyph_range_unref0 (glyph_range_first);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (g_strcmp0 (left, "") != 0) {
		_tmp11_ = g_strcmp0 (right, "") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gboolean _tmp12_ = FALSE;
		BirdFontGlyphRange* _tmp13_;
		GeeArrayList* _tmp24_;
		BirdFontKerningListUndoItem* _tmp25_;
		BirdFontKerningListUndoItem* _tmp26_;
		BirdFontFont* _tmp27_;
		_tmp13_ = glyph_range_first;
		if (bird_font_glyph_range_is_class (_tmp13_)) {
			_tmp12_ = TRUE;
		} else {
			BirdFontGlyphRange* _tmp14_;
			_tmp14_ = glyph_range_next;
			_tmp12_ = bird_font_glyph_range_is_class (_tmp14_);
		}
		if (_tmp12_) {
			BirdFontKerningClasses* _tmp15_;
			BirdFontGlyphRange* _tmp16_;
			BirdFontGlyphRange* _tmp17_;
			BirdFontKerningClasses* _tmp18_;
			BirdFontGlyphRange* _tmp19_;
			BirdFontGlyphRange* _tmp20_;
			BirdFontKerningClasses* _tmp21_;
			_tmp15_ = classes;
			_tmp16_ = glyph_range_first;
			_tmp17_ = glyph_range_next;
			kerning = bird_font_kerning_classes_get_kerning_for_range (_tmp15_, _tmp16_, _tmp17_);
			_tmp18_ = classes;
			_tmp19_ = glyph_range_first;
			_tmp20_ = glyph_range_next;
			class_index = bird_font_kerning_classes_get_kerning_item_index (_tmp18_, _tmp19_, _tmp20_);
			_tmp21_ = classes;
			bird_font_kerning_classes_delete_kerning_for_class (_tmp21_, left, right);
		} else {
			BirdFontKerningClasses* _tmp22_;
			BirdFontKerningClasses* _tmp23_;
			_tmp22_ = classes;
			kerning = bird_font_kerning_classes_get_kerning (_tmp22_, left, right);
			_tmp23_ = classes;
			bird_font_kerning_classes_delete_kerning_for_pair (_tmp23_, left, right);
		}
		_tmp24_ = self->priv->undo_items;
		_tmp25_ = bird_font_kerning_list_undo_item_new (left, right, kerning, class_index);
		_tmp26_ = _tmp25_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp26_);
		_g_object_unref0 (_tmp26_);
		_tmp27_ = font;
		bird_font_font_touch (_tmp27_);
	}
	_g_free0 (r);
	_g_free0 (l);
	_g_object_unref0 (classes);
	_g_object_unref0 (font);
	_bird_font_glyph_range_unref0 (glyph_range_next);
	_bird_font_glyph_range_unref0 (glyph_range_first);
}

static gchar*
bird_font_kerning_list_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontKerningList * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontKerningList*) base;
	_tmp0_ = bird_font_t_ ("Kerning Pairs");
	result = _tmp0_;
	return result;
}

static gchar*
bird_font_kerning_list_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontKerningList * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontKerningList*) base;
	_tmp0_ = g_strdup ("Kerning Pairs");
	result = _tmp0_;
	return result;
}

static void
bird_font_kerning_list_real_undo (BirdFontFontDisplay* base)
{
	BirdFontKerningList * self;
	BirdFontKerningListUndoItem* ui = NULL;
	BirdFontKerningClasses* classes = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	BirdFontKerningClasses* _tmp2_;
	BirdFontKerningClasses* _tmp3_;
	BirdFontGlyphRange* glyph_range_first = NULL;
	BirdFontGlyphRange* glyph_range_next = NULL;
	GError* _inner_error0_ = NULL;
	self = (BirdFontKerningList*) base;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_font_get_kerning_classes (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	classes = _tmp3_;
	{
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gpointer _tmp11_;
		BirdFontGlyphRange* _tmp12_;
		BirdFontGlyphRange* _tmp13_;
		BirdFontGlyphRange* _tmp14_;
		BirdFontKerningListUndoItem* _tmp15_;
		const gchar* _tmp16_;
		BirdFontGlyphRange* _tmp17_;
		BirdFontKerningListUndoItem* _tmp18_;
		const gchar* _tmp19_;
		gboolean _tmp20_ = FALSE;
		BirdFontGlyphRange* _tmp21_;
		GeeArrayList* _tmp34_;
		GeeArrayList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gpointer _tmp38_;
		BirdFontKerningListUndoItem* _tmp39_;
		_tmp4_ = self->priv->undo_items;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == 0) {
			_bird_font_glyph_range_unref0 (glyph_range_next);
			_bird_font_glyph_range_unref0 (glyph_range_first);
			_g_object_unref0 (classes);
			_g_object_unref0 (ui);
			return;
		}
		_tmp7_ = self->priv->undo_items;
		_tmp8_ = self->priv->undo_items;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp10_ - 1);
		_g_object_unref0 (ui);
		ui = (BirdFontKerningListUndoItem*) _tmp11_;
		_tmp12_ = bird_font_glyph_range_new ();
		_bird_font_glyph_range_unref0 (glyph_range_first);
		glyph_range_first = _tmp12_;
		_tmp13_ = bird_font_glyph_range_new ();
		_bird_font_glyph_range_unref0 (glyph_range_next);
		glyph_range_next = _tmp13_;
		_tmp14_ = glyph_range_first;
		_tmp15_ = ui;
		_tmp16_ = _tmp15_->first;
		bird_font_glyph_range_parse_ranges (_tmp14_, _tmp16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch0_g_markup_error;
			}
			_bird_font_glyph_range_unref0 (glyph_range_next);
			_bird_font_glyph_range_unref0 (glyph_range_first);
			_g_object_unref0 (classes);
			_g_object_unref0 (ui);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp17_ = glyph_range_next;
		_tmp18_ = ui;
		_tmp19_ = _tmp18_->next;
		bird_font_glyph_range_parse_ranges (_tmp17_, _tmp19_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch0_g_markup_error;
			}
			_bird_font_glyph_range_unref0 (glyph_range_next);
			_bird_font_glyph_range_unref0 (glyph_range_first);
			_g_object_unref0 (classes);
			_g_object_unref0 (ui);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp21_ = glyph_range_first;
		if (bird_font_glyph_range_is_class (_tmp21_)) {
			_tmp20_ = TRUE;
		} else {
			BirdFontGlyphRange* _tmp22_;
			_tmp22_ = glyph_range_next;
			_tmp20_ = bird_font_glyph_range_is_class (_tmp22_);
		}
		if (_tmp20_) {
			BirdFontKerningClasses* _tmp23_;
			BirdFontGlyphRange* _tmp24_;
			BirdFontGlyphRange* _tmp25_;
			BirdFontKerningListUndoItem* _tmp26_;
			BirdFontKerningListUndoItem* _tmp27_;
			_tmp23_ = classes;
			_tmp24_ = glyph_range_first;
			_tmp25_ = glyph_range_next;
			_tmp26_ = ui;
			_tmp27_ = ui;
			bird_font_kerning_classes_set_kerning (_tmp23_, _tmp24_, _tmp25_, _tmp26_->kerning, _tmp27_->class_priority);
		} else {
			BirdFontKerningClasses* _tmp28_;
			BirdFontKerningListUndoItem* _tmp29_;
			const gchar* _tmp30_;
			BirdFontKerningListUndoItem* _tmp31_;
			const gchar* _tmp32_;
			BirdFontKerningListUndoItem* _tmp33_;
			_tmp28_ = classes;
			_tmp29_ = ui;
			_tmp30_ = _tmp29_->first;
			_tmp31_ = ui;
			_tmp32_ = _tmp31_->next;
			_tmp33_ = ui;
			bird_font_kerning_classes_set_kerning_for_single_glyphs (_tmp28_, _tmp30_, _tmp32_, _tmp33_->kerning);
		}
		_tmp34_ = self->priv->undo_items;
		_tmp35_ = self->priv->undo_items;
		_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp34_, _tmp37_ - 1);
		_tmp39_ = (BirdFontKerningListUndoItem*) _tmp38_;
		_g_object_unref0 (_tmp39_);
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp40_;
		const gchar* _tmp41_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = e;
		_tmp41_ = _tmp40_->message;
		g_warning ("KerningList.vala:144: %s", _tmp41_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_bird_font_glyph_range_unref0 (glyph_range_next);
		_bird_font_glyph_range_unref0 (glyph_range_first);
		_g_object_unref0 (classes);
		_g_object_unref0 (ui);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	bird_font_table_update_rows ((BirdFontTable*) self);
	_bird_font_glyph_range_unref0 (glyph_range_next);
	_bird_font_glyph_range_unref0 (glyph_range_first);
	_g_object_unref0 (classes);
	_g_object_unref0 (ui);
}

static void
bird_font_kerning_list_real_update_rows (BirdFontTable* base)
{
	BirdFontKerningList * self;
	BirdFontWidgetAllocation* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	self = (BirdFontKerningList*) base;
	_tmp0_ = ((BirdFontTable*) self)->allocation;
	_tmp1_ = ((BirdFontTable*) self)->allocation;
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) 0, (gdouble) 0, (gdouble) _tmp0_->width, (gdouble) _tmp1_->height);
}

static BirdFontKerningListUndoItem*
bird_font_kerning_list_undo_item_construct (GType object_type,
                                            const gchar* first,
                                            const gchar* next,
                                            gdouble kerning,
                                            gint class_priority)
{
	BirdFontKerningListUndoItem * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (first != NULL, NULL);
	g_return_val_if_fail (next != NULL, NULL);
	self = (BirdFontKerningListUndoItem*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (first);
	_g_free0 (self->first);
	self->first = _tmp0_;
	_tmp1_ = g_strdup (next);
	_g_free0 (self->next);
	self->next = _tmp1_;
	self->kerning = kerning;
	self->class_priority = class_priority;
	return self;
}

static BirdFontKerningListUndoItem*
bird_font_kerning_list_undo_item_new (const gchar* first,
                                      const gchar* next,
                                      gdouble kerning,
                                      gint class_priority)
{
	return bird_font_kerning_list_undo_item_construct (BIRD_FONT_KERNING_LIST_TYPE_UNDO_ITEM, first, next, kerning, class_priority);
}

static void
bird_font_kerning_list_undo_item_class_init (BirdFontKerningListUndoItemClass * klass,
                                             gpointer klass_data)
{
	bird_font_kerning_list_undo_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_kerning_list_undo_item_finalize;
}

static void
bird_font_kerning_list_undo_item_instance_init (BirdFontKerningListUndoItem * self,
                                                gpointer klass)
{
}

static void
bird_font_kerning_list_undo_item_finalize (GObject * obj)
{
	BirdFontKerningListUndoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_KERNING_LIST_TYPE_UNDO_ITEM, BirdFontKerningListUndoItem);
	_g_free0 (self->first);
	_g_free0 (self->next);
	G_OBJECT_CLASS (bird_font_kerning_list_undo_item_parent_class)->finalize (obj);
}

static GType
bird_font_kerning_list_undo_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontKerningListUndoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_kerning_list_undo_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontKerningListUndoItem), 0, (GInstanceInitFunc) bird_font_kerning_list_undo_item_instance_init, NULL };
	GType bird_font_kerning_list_undo_item_type_id;
	bird_font_kerning_list_undo_item_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontKerningListUndoItem", &g_define_type_info, 0);
	return bird_font_kerning_list_undo_item_type_id;
}

static GType
bird_font_kerning_list_undo_item_get_type (void)
{
	static volatile gsize bird_font_kerning_list_undo_item_type_id__once = 0;
	if (g_once_init_enter (&bird_font_kerning_list_undo_item_type_id__once)) {
		GType bird_font_kerning_list_undo_item_type_id;
		bird_font_kerning_list_undo_item_type_id = bird_font_kerning_list_undo_item_get_type_once ();
		g_once_init_leave (&bird_font_kerning_list_undo_item_type_id__once, bird_font_kerning_list_undo_item_type_id);
	}
	return bird_font_kerning_list_undo_item_type_id__once;
}

static void
bird_font_kerning_list_class_init (BirdFontKerningListClass * klass,
                                   gpointer klass_data)
{
	bird_font_kerning_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontKerningList_private_offset);
	((BirdFontTableClass *) klass)->get_rows = (GeeArrayList* (*) (BirdFontTable*)) bird_font_kerning_list_real_get_rows;
	((BirdFontTableClass *) klass)->selected_row = (void (*) (BirdFontTable*, BirdFontRow*, gint, gboolean)) bird_font_kerning_list_real_selected_row;
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_kerning_list_real_get_label;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_kerning_list_real_get_name;
	((BirdFontFontDisplayClass *) klass)->undo = (void (*) (BirdFontFontDisplay*)) bird_font_kerning_list_real_undo;
	((BirdFontTableClass *) klass)->update_rows = (void (*) (BirdFontTable*)) bird_font_kerning_list_real_update_rows;
	G_OBJECT_CLASS (klass)->finalize = bird_font_kerning_list_finalize;
}

static void
bird_font_kerning_list_instance_init (BirdFontKerningList * self,
                                      gpointer klass)
{
	self->priv = bird_font_kerning_list_get_instance_private (self);
}

static void
bird_font_kerning_list_finalize (GObject * obj)
{
	BirdFontKerningList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_KERNING_LIST, BirdFontKerningList);
	_g_object_unref0 (self->priv->undo_items);
	G_OBJECT_CLASS (bird_font_kerning_list_parent_class)->finalize (obj);
}

static GType
bird_font_kerning_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontKerningListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_kerning_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontKerningList), 0, (GInstanceInitFunc) bird_font_kerning_list_instance_init, NULL };
	GType bird_font_kerning_list_type_id;
	bird_font_kerning_list_type_id = g_type_register_static (BIRD_FONT_TYPE_TABLE, "BirdFontKerningList", &g_define_type_info, 0);
	BirdFontKerningList_private_offset = g_type_add_instance_private (bird_font_kerning_list_type_id, sizeof (BirdFontKerningListPrivate));
	return bird_font_kerning_list_type_id;
}

GType
bird_font_kerning_list_get_type (void)
{
	static volatile gsize bird_font_kerning_list_type_id__once = 0;
	if (g_once_init_enter (&bird_font_kerning_list_type_id__once)) {
		GType bird_font_kerning_list_type_id;
		bird_font_kerning_list_type_id = bird_font_kerning_list_get_type_once ();
		g_once_init_leave (&bird_font_kerning_list_type_id__once, bird_font_kerning_list_type_id);
	}
	return bird_font_kerning_list_type_id__once;
}

