/* ScaledImage.c generated by valac 0.56.17, the Vala compiler
 * generated from ScaledImage.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <cairo-gobject.h>
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_SCALED_BACKGROUND_0_PROPERTY,
	BIRD_FONT_SCALED_BACKGROUND_NUM_PROPERTIES
};
static GParamSpec* bird_font_scaled_background_properties[BIRD_FONT_SCALED_BACKGROUND_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontScaledBackgroundPrivate {
	cairo_surface_t* image;
	cairo_surface_t* original;
	GeeArrayList* parts;
	gint size;
	gint part_width;
	gint part_height;
	gdouble scale;
};

static gint BirdFontScaledBackground_private_offset;
static gpointer bird_font_scaled_background_parent_class = NULL;

static void bird_font_scaled_background_create_parts (BirdFontScaledBackground* self);
static cairo_surface_t* bird_font_scaled_background_get_part_at (BirdFontScaledBackground* self,
                                                          gint x,
                                                          gint y);
static void bird_font_scaled_background_finalize (GObject * obj);
static GType bird_font_scaled_background_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_scaled_background_get_instance_private (BirdFontScaledBackground* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontScaledBackground_private_offset);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

BirdFontScaledBackground*
bird_font_scaled_background_construct (GType object_type,
                                       cairo_surface_t* image,
                                       gdouble scale)
{
	BirdFontScaledBackground * self = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_val_if_fail (image != NULL, NULL);
	self = (BirdFontScaledBackground*) g_object_new (object_type, NULL);
	if (scale <= ((gdouble) 0)) {
		g_warning ("ScaledImage.vala:32: scale <= 0");
		scale = (gdouble) 1;
	}
	_tmp0_ = _cairo_surface_reference0 (image);
	_cairo_surface_destroy0 (self->priv->original);
	self->priv->original = _tmp0_;
	_tmp1_ = _cairo_surface_reference0 (image);
	_cairo_surface_destroy0 (self->priv->image);
	self->priv->image = _tmp1_;
	self->priv->scale = scale;
	_tmp2_ = gee_array_list_new (cairo_gobject_surface_get_type (), (GBoxedCopyFunc) cairo_surface_reference, (GDestroyNotify) cairo_surface_destroy, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->parts);
	self->priv->parts = _tmp2_;
	bird_font_scaled_background_create_parts (self);
	return self;
}

BirdFontScaledBackground*
bird_font_scaled_background_new (cairo_surface_t* image,
                                 gdouble scale)
{
	return bird_font_scaled_background_construct (BIRD_FONT_TYPE_SCALED_BACKGROUND, image, scale);
}

void
bird_font_scaled_background_rotate (BirdFontScaledBackground* self,
                                    gdouble angle)
{
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->original;
	_tmp1_ = bird_font_background_image_rotate_image (_tmp0_, angle);
	_cairo_surface_destroy0 (self->priv->image);
	self->priv->image = _tmp1_;
	bird_font_scaled_background_create_parts (self);
}

static void
bird_font_scaled_background_create_parts (BirdFontScaledBackground* self)
{
	GeeArrayList* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->parts;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->image;
	self->priv->size = cairo_image_surface_get_width (_tmp1_) / 100;
	if (self->priv->size < 10) {
		self->priv->size = 10;
	}
	_tmp2_ = self->priv->image;
	self->priv->part_width = cairo_image_surface_get_width (_tmp2_) / self->priv->size;
	_tmp3_ = self->priv->image;
	self->priv->part_height = cairo_image_surface_get_height (_tmp3_) / self->priv->size;
	if (self->priv->part_width < 1) {
		self->priv->part_width = 1;
	}
	if (self->priv->part_height < 1) {
		self->priv->part_height = 1;
	}
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = y;
					y = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(y < self->priv->size)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							cairo_surface_t* next_part = NULL;
							cairo_surface_t* _tmp8_;
							cairo_t* context = NULL;
							cairo_surface_t* _tmp9_;
							cairo_t* _tmp10_;
							cairo_t* _tmp11_;
							cairo_surface_t* _tmp12_;
							cairo_t* _tmp13_;
							GeeArrayList* _tmp14_;
							cairo_surface_t* _tmp15_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = x;
								x = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							if (!(x < self->priv->size)) {
								break;
							}
							_tmp8_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, self->priv->part_width, self->priv->part_height);
							_cairo_surface_destroy0 (next_part);
							next_part = _tmp8_;
							_tmp9_ = next_part;
							_tmp10_ = cairo_create (_tmp9_);
							context = _tmp10_;
							_tmp11_ = context;
							_tmp12_ = self->priv->image;
							cairo_set_source_surface (_tmp11_, _tmp12_, (gdouble) ((-x) * self->priv->part_width), (gdouble) ((-y) * self->priv->part_width));
							_tmp13_ = context;
							cairo_paint (_tmp13_);
							_tmp14_ = self->priv->parts;
							_tmp15_ = next_part;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
							_cairo_destroy0 (context);
							_cairo_surface_destroy0 (next_part);
						}
					}
				}
			}
		}
	}
}

void
bird_font_scaled_background_set_scale (BirdFontScaledBackground* self,
                                       gdouble s)
{
	g_return_if_fail (self != NULL);
	self->priv->scale = s;
}

gdouble
bird_font_scaled_background_get_scale (BirdFontScaledBackground* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (G_UNLIKELY (self->priv->scale == ((gdouble) 0))) {
		g_warning ("ScaledImage.vala:86: Zero scale.");
		result = (gdouble) 1;
		return result;
	}
	result = self->priv->scale;
	return result;
}

cairo_surface_t*
bird_font_scaled_background_get_image (BirdFontScaledBackground* self)
{
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->image;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static cairo_surface_t*
bird_font_scaled_background_get_part_at (BirdFontScaledBackground* self,
                                         gint x,
                                         gint y)
{
	gint index = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp12_;
	gpointer _tmp13_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	index = (y * self->priv->size) + x;
	if (x >= self->priv->size) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = x < 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	if (y >= self->priv->size) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = y < 0;
	}
	if (_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->parts;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = index;
	if (G_UNLIKELY (!((0 <= _tmp5_) && (_tmp5_ < _tmp4_)))) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = g_strdup_printf ("%i", x);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%i", y);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("No part at index: ", _tmp7_, ", ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		g_warning ("ScaledImage.vala:109: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		result = NULL;
		return result;
	}
	_tmp12_ = self->priv->parts;
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, index);
	result = (cairo_surface_t*) _tmp13_;
	return result;
}

BirdFontScaledBackgroundPart*
bird_font_scaled_background_get_part (BirdFontScaledBackground* self,
                                      gdouble offset_x,
                                      gdouble offset_y,
                                      gint width,
                                      gint height)
{
	gboolean _tmp0_ = FALSE;
	gdouble image_width = 0.0;
	gdouble image_height = 0.0;
	gint start_x = 0;
	gint start_y = 0;
	gint stop_x = 0;
	gint stop_y = 0;
	gint assembled_width = 0;
	gint assembled_height = 0;
	cairo_surface_t* assembled_image = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp2_;
	cairo_t* _tmp3_;
	gint start_offset_x = 0;
	gint start_offset_y = 0;
	cairo_surface_t* _tmp15_;
	BirdFontScaledBackgroundPart* _tmp16_;
	BirdFontScaledBackgroundPart* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (width <= 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = height <= 0;
	}
	if (_tmp0_) {
		g_warning ("ScaledImage.vala:120: width <= 0 || height <= 0");
		self->priv->scale = (gdouble) 1;
	}
	image_width = (gdouble) (self->priv->part_width * self->priv->size);
	image_height = (gdouble) (self->priv->part_height * self->priv->size);
	start_x = (gint) ((offset_x / image_width) * self->priv->size);
	start_y = (gint) ((offset_y / image_height) * self->priv->size);
	stop_x = ((gint) (((offset_x + width) / image_width) * self->priv->size)) + 2;
	stop_y = ((gint) (((offset_y + height) / image_height) * self->priv->size)) + 2;
	if (start_x < 0) {
		start_x = 0;
	}
	if (start_y < 0) {
		start_y = 0;
	}
	if (stop_x > self->priv->size) {
		stop_x = self->priv->size;
	}
	if (stop_y > self->priv->size) {
		stop_y = self->priv->size;
	}
	assembled_width = (gint) ((stop_x - start_x) * self->priv->part_width);
	assembled_height = (gint) ((stop_y - start_y) * self->priv->part_height);
	_tmp1_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, assembled_width, assembled_height);
	assembled_image = _tmp1_;
	_tmp2_ = assembled_image;
	_tmp3_ = cairo_create (_tmp2_);
	context = _tmp3_;
	start_offset_x = start_x * self->priv->part_width;
	start_offset_y = start_y * self->priv->part_height;
	{
		gint y = 0;
		y = start_y;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = y;
					y = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(y < stop_y)) {
					break;
				}
				{
					gint x = 0;
					x = start_x;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							cairo_surface_t* part = NULL;
							cairo_surface_t* _tmp8_;
							cairo_surface_t* _tmp9_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = x;
								x = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							if (!(x < stop_x)) {
								break;
							}
							_tmp8_ = bird_font_scaled_background_get_part_at (self, x, y);
							part = _tmp8_;
							_tmp9_ = part;
							if (_tmp9_ != NULL) {
								cairo_t* _tmp10_;
								cairo_t* _tmp11_;
								cairo_surface_t* _tmp12_;
								cairo_t* _tmp13_;
								cairo_t* _tmp14_;
								_tmp10_ = context;
								cairo_save (_tmp10_);
								_tmp11_ = context;
								_tmp12_ = part;
								cairo_set_source_surface (_tmp11_, (cairo_surface_t*) _tmp12_, (gdouble) ((x - start_x) * self->priv->part_width), (gdouble) ((y - start_y) * self->priv->part_height));
								_tmp13_ = context;
								cairo_paint (_tmp13_);
								_tmp14_ = context;
								cairo_restore (_tmp14_);
							}
							_cairo_surface_destroy0 (part);
						}
					}
				}
			}
		}
	}
	_tmp15_ = assembled_image;
	_tmp16_ = bird_font_scaled_background_part_new (_tmp15_, self->priv->scale, start_offset_x, start_offset_y);
	result = _tmp16_;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (assembled_image);
	return result;
}

static void
bird_font_scaled_background_class_init (BirdFontScaledBackgroundClass * klass,
                                        gpointer klass_data)
{
	bird_font_scaled_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontScaledBackground_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_scaled_background_finalize;
}

static void
bird_font_scaled_background_instance_init (BirdFontScaledBackground * self,
                                           gpointer klass)
{
	self->priv = bird_font_scaled_background_get_instance_private (self);
}

static void
bird_font_scaled_background_finalize (GObject * obj)
{
	BirdFontScaledBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SCALED_BACKGROUND, BirdFontScaledBackground);
	_cairo_surface_destroy0 (self->priv->image);
	_cairo_surface_destroy0 (self->priv->original);
	_g_object_unref0 (self->priv->parts);
	G_OBJECT_CLASS (bird_font_scaled_background_parent_class)->finalize (obj);
}

static GType
bird_font_scaled_background_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontScaledBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_scaled_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontScaledBackground), 0, (GInstanceInitFunc) bird_font_scaled_background_instance_init, NULL };
	GType bird_font_scaled_background_type_id;
	bird_font_scaled_background_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontScaledBackground", &g_define_type_info, 0);
	BirdFontScaledBackground_private_offset = g_type_add_instance_private (bird_font_scaled_background_type_id, sizeof (BirdFontScaledBackgroundPrivate));
	return bird_font_scaled_background_type_id;
}

GType
bird_font_scaled_background_get_type (void)
{
	static volatile gsize bird_font_scaled_background_type_id__once = 0;
	if (g_once_init_enter (&bird_font_scaled_background_type_id__once)) {
		GType bird_font_scaled_background_type_id;
		bird_font_scaled_background_type_id = bird_font_scaled_background_get_type_once ();
		g_once_init_leave (&bird_font_scaled_background_type_id__once, bird_font_scaled_background_type_id);
	}
	return bird_font_scaled_background_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

