/* comicsReader.c generated by valac 0.56.18, the Vala compiler
 * generated from comicsReader.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and is used for parsing comics
* file formats like .cbz, .cbr
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gio/gio.h>
#include <granite.h>
#include <gobject/gvaluecollector.h>

#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE _ ("Problem in extracting contents of book. Ensure there is a valid eBook " \
"file here: ")
#define BOOKWORM_APP_CONSTANTS_bookworm_id "com.github.babluboy.bookworm"
#define BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION "/tmp/" BOOKWORM_APP_CONSTANTS_bookworm_id "/"
#define BOOKWORM_APP_CONSTANTS_COMICS_HTML_TEMPLATE "<html><style>img{max-width: 100%;height: auto;}</style><body><img src=" \
"\"<image-location>\"></body></html>"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_COMICS_READER (bookworm_app_comics_reader_get_type ())
#define BOOKWORM_APP_COMICS_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_COMICS_READER, BookwormAppcomicsReader))
#define BOOKWORM_APP_COMICS_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_COMICS_READER, BookwormAppcomicsReaderClass))
#define BOOKWORM_APP_IS_COMICS_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_COMICS_READER))
#define BOOKWORM_APP_IS_COMICS_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_COMICS_READER))
#define BOOKWORM_APP_COMICS_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_COMICS_READER, BookwormAppcomicsReaderClass))

typedef struct _BookwormAppcomicsReader BookwormAppcomicsReader;
typedef struct _BookwormAppcomicsReaderClass BookwormAppcomicsReaderClass;
typedef struct _BookwormAppcomicsReaderPrivate BookwormAppcomicsReaderPrivate;

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block26Data Block26Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _BookwormAppParamSpeccomicsReader BookwormAppParamSpeccomicsReader;

struct _BookwormAppcomicsReader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppcomicsReaderPrivate * priv;
};

struct _BookwormAppcomicsReaderClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppcomicsReader *self);
};

struct _Block26Data {
	int _ref_count_;
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	GCompareDataFunc compare_func;
	gpointer compare_func_target;
};

struct _BookwormAppParamSpeccomicsReader {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_comics_reader_parent_class = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_bookworm_settings;
VALA_EXTERN gchar* bookworm_app_bookworm_bookworm_config_path;

VALA_EXTERN gpointer bookworm_app_comics_reader_ref (gpointer instance);
VALA_EXTERN void bookworm_app_comics_reader_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_comics_reader (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_comics_reader (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_comics_reader (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_comics_reader (const GValue* value);
VALA_EXTERN GType bookworm_app_comics_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppcomicsReader, bookworm_app_comics_reader_unref)
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN BookwormAppBook* bookworm_app_comics_reader_parseComicsBook (BookwormAppBook* aBook,
                                                             const gchar* comicsFileType);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_book_getIsBookParsed (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_comics_reader_extractComics (const gchar* eBookLocation,
                                                 const gchar* comicsFileType);
VALA_EXTERN void bookworm_app_book_setIsBookParsed (BookwormAppBook* self,
                                        gboolean isParsed);
VALA_EXTERN void bookworm_app_book_setParsingIssue (BookwormAppBook* self,
                                        const gchar* aParsingIssue);
VALA_EXTERN void bookworm_app_book_setBookExtractionLocation (BookwormAppBook* self,
                                                  const gchar* aBookExtractionLocation);
VALA_EXTERN BookwormAppBook* bookworm_app_comics_reader_getContentList (BookwormAppBook* aBook,
                                                            const gchar* extractionLocation);
VALA_EXTERN GeeArrayList* bookworm_app_book_getBookContentList (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getBookTitle (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookTitle (BookwormAppBook* self,
                                     const gchar* aBookTitle);
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN gboolean bookworm_app_settings_get_is_local_storage_enabled (BookwormAppSettings* self);
VALA_EXTERN gchar* bookworm_app_utils_fileOperations (const gchar* operation,
                                          const gchar* path,
                                          const gchar* filename,
                                          const gchar* contents);
VALA_EXTERN gchar* bookworm_app_utils_execute_sync_command (const gchar* cmd);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static gint ___lambda3__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint __lambda37_ (const gchar* a,
                  const gchar* b);
static gint ___lambda37__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN void bookworm_app_book_setBookContentList (BookwormAppBook* self,
                                           const gchar* contentList);
VALA_EXTERN gboolean bookworm_app_book_getIsBookCoverImagePresent (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_utils_setBookCoverImage (BookwormAppBook* aBook,
                                                       const gchar* bookCoverImageLocation);
VALA_EXTERN BookwormAppcomicsReader* bookworm_app_comics_reader_new (void);
VALA_EXTERN BookwormAppcomicsReader* bookworm_app_comics_reader_construct (GType object_type);
static void bookworm_app_comics_reader_finalize (BookwormAppcomicsReader * obj);
static GType bookworm_app_comics_reader_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 30 "../src/comicsReader.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 209 "comicsReader.c"
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1195 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1195 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1197 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1197 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 233 "comicsReader.c"
		gchar* _tmp2_;
#line 1198 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1198 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1198 "glib-2.0.vapi"
		return result;
#line 241 "comicsReader.c"
	} else {
#line 1200 "glib-2.0.vapi"
		result = -1;
#line 1200 "glib-2.0.vapi"
		return result;
#line 247 "comicsReader.c"
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 275 "comicsReader.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 281 "comicsReader.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 287 "comicsReader.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 291 "comicsReader.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 299 "comicsReader.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 303 "comicsReader.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 315 "comicsReader.c"
}

BookwormAppBook*
bookworm_app_comics_reader_parseComicsBook (BookwormAppBook* aBook,
                                            const gchar* comicsFileType)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp24_ = FALSE;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_;
	BookwormAppBook* _tmp46_;
	BookwormAppBook* result;
#line 21 "../src/comicsReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 21 "../src/comicsReader.vala"
	g_return_val_if_fail (comicsFileType != NULL, NULL);
#line 22 "../src/comicsReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 22 "../src/comicsReader.vala"
	_tmp1_ = _tmp0_;
#line 22 "../src/comicsReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:parseComicsBook] book.location=", _tmp1_, NULL);
#line 22 "../src/comicsReader.vala"
	_tmp3_ = _tmp2_;
#line 22 "../src/comicsReader.vala"
	_tmp4_ = g_strconcat (_tmp3_, "comicsFileType=", NULL);
#line 22 "../src/comicsReader.vala"
	_tmp5_ = _tmp4_;
#line 22 "../src/comicsReader.vala"
	_tmp6_ = g_strconcat (_tmp5_, comicsFileType, NULL);
#line 22 "../src/comicsReader.vala"
	_tmp7_ = _tmp6_;
#line 22 "../src/comicsReader.vala"
	g_info ("comicsReader.vala:22: %s", _tmp7_);
#line 22 "../src/comicsReader.vala"
	_g_free0 (_tmp7_);
#line 22 "../src/comicsReader.vala"
	_g_free0 (_tmp5_);
#line 22 "../src/comicsReader.vala"
	_g_free0 (_tmp3_);
#line 22 "../src/comicsReader.vala"
	_g_free0 (_tmp1_);
#line 24 "../src/comicsReader.vala"
	if (!bookworm_app_book_getIsBookParsed (aBook)) {
#line 368 "comicsReader.c"
		gchar* extractionLocation = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		BookwormAppBook* _tmp15_;
		const gchar* _tmp16_;
		BookwormAppBook* _tmp17_;
		GeeArrayList* _tmp18_;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gboolean _tmp22_;
#line 26 "../src/comicsReader.vala"
		_tmp8_ = bookworm_app_book_getBookLocation (aBook);
#line 26 "../src/comicsReader.vala"
		_tmp9_ = _tmp8_;
#line 26 "../src/comicsReader.vala"
		_tmp10_ = bookworm_app_comics_reader_extractComics (_tmp9_, comicsFileType);
#line 26 "../src/comicsReader.vala"
		_tmp11_ = _tmp10_;
#line 26 "../src/comicsReader.vala"
		_g_free0 (_tmp9_);
#line 26 "../src/comicsReader.vala"
		extractionLocation = _tmp11_;
#line 27 "../src/comicsReader.vala"
		_tmp12_ = extractionLocation;
#line 27 "../src/comicsReader.vala"
		if (g_strcmp0 ("false", _tmp12_) == 0) {
#line 399 "comicsReader.c"
			BookwormAppBook* _tmp13_;
#line 28 "../src/comicsReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 29 "../src/comicsReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE);
#line 30 "../src/comicsReader.vala"
			_tmp13_ = _bookworm_app_book_ref0 (aBook);
#line 30 "../src/comicsReader.vala"
			result = _tmp13_;
#line 30 "../src/comicsReader.vala"
			_g_free0 (extractionLocation);
#line 30 "../src/comicsReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 30 "../src/comicsReader.vala"
			return result;
#line 415 "comicsReader.c"
		} else {
			const gchar* _tmp14_;
#line 32 "../src/comicsReader.vala"
			_tmp14_ = extractionLocation;
#line 32 "../src/comicsReader.vala"
			bookworm_app_book_setBookExtractionLocation (aBook, _tmp14_);
#line 422 "comicsReader.c"
		}
#line 35 "../src/comicsReader.vala"
		_tmp15_ = _bookworm_app_book_ref0 (aBook);
#line 35 "../src/comicsReader.vala"
		_tmp16_ = extractionLocation;
#line 35 "../src/comicsReader.vala"
		_tmp17_ = bookworm_app_comics_reader_getContentList (_tmp15_, _tmp16_);
#line 35 "../src/comicsReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 35 "../src/comicsReader.vala"
		aBook = _tmp17_;
#line 36 "../src/comicsReader.vala"
		_tmp18_ = bookworm_app_book_getBookContentList (aBook);
#line 36 "../src/comicsReader.vala"
		_tmp19_ = _tmp18_;
#line 36 "../src/comicsReader.vala"
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
#line 36 "../src/comicsReader.vala"
		_tmp21_ = _tmp20_;
#line 36 "../src/comicsReader.vala"
		_tmp22_ = _tmp21_ < 1;
#line 36 "../src/comicsReader.vala"
		_g_object_unref0 (_tmp19_);
#line 36 "../src/comicsReader.vala"
		if (_tmp22_) {
#line 448 "comicsReader.c"
			BookwormAppBook* _tmp23_;
#line 38 "../src/comicsReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 39 "../src/comicsReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE);
#line 40 "../src/comicsReader.vala"
			_tmp23_ = _bookworm_app_book_ref0 (aBook);
#line 40 "../src/comicsReader.vala"
			result = _tmp23_;
#line 40 "../src/comicsReader.vala"
			_g_free0 (extractionLocation);
#line 40 "../src/comicsReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 40 "../src/comicsReader.vala"
			return result;
#line 464 "comicsReader.c"
		}
#line 24 "../src/comicsReader.vala"
		_g_free0 (extractionLocation);
#line 468 "comicsReader.c"
	}
#line 44 "../src/comicsReader.vala"
	_tmp25_ = bookworm_app_book_getBookTitle (aBook);
#line 44 "../src/comicsReader.vala"
	_tmp26_ = _tmp25_;
#line 44 "../src/comicsReader.vala"
	_tmp27_ = _tmp26_ != NULL;
#line 44 "../src/comicsReader.vala"
	_g_free0 (_tmp26_);
#line 44 "../src/comicsReader.vala"
	if (_tmp27_) {
#line 480 "comicsReader.c"
		gchar* _tmp28_;
		gchar* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
#line 44 "../src/comicsReader.vala"
		_tmp28_ = bookworm_app_book_getBookTitle (aBook);
#line 44 "../src/comicsReader.vala"
		_tmp29_ = _tmp28_;
#line 44 "../src/comicsReader.vala"
		_tmp30_ = strlen (_tmp29_);
#line 44 "../src/comicsReader.vala"
		_tmp31_ = _tmp30_;
#line 44 "../src/comicsReader.vala"
		_tmp24_ = _tmp31_ < 1;
#line 44 "../src/comicsReader.vala"
		_g_free0 (_tmp29_);
#line 497 "comicsReader.c"
	} else {
#line 44 "../src/comicsReader.vala"
		_tmp24_ = FALSE;
#line 501 "comicsReader.c"
	}
#line 44 "../src/comicsReader.vala"
	if (_tmp24_) {
#line 505 "comicsReader.c"
		gchar* bookTitle = NULL;
		gchar* _tmp32_;
		gchar* _tmp33_;
		GFile* _tmp34_;
		GFile* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
#line 45 "../src/comicsReader.vala"
		_tmp32_ = bookworm_app_book_getBookLocation (aBook);
#line 45 "../src/comicsReader.vala"
		_tmp33_ = _tmp32_;
#line 45 "../src/comicsReader.vala"
		_tmp34_ = g_file_new_for_path (_tmp33_);
#line 45 "../src/comicsReader.vala"
		_tmp35_ = _tmp34_;
#line 45 "../src/comicsReader.vala"
		_tmp36_ = g_file_get_basename (_tmp35_);
#line 45 "../src/comicsReader.vala"
		_tmp37_ = _tmp36_;
#line 45 "../src/comicsReader.vala"
		_g_object_unref0 (_tmp35_);
#line 45 "../src/comicsReader.vala"
		_g_free0 (_tmp33_);
#line 45 "../src/comicsReader.vala"
		bookTitle = _tmp37_;
#line 46 "../src/comicsReader.vala"
		_tmp38_ = bookTitle;
#line 46 "../src/comicsReader.vala"
		if (string_last_index_of (_tmp38_, ".", 0) != -1) {
#line 540 "comicsReader.c"
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
#line 47 "../src/comicsReader.vala"
			_tmp39_ = bookTitle;
#line 47 "../src/comicsReader.vala"
			_tmp40_ = bookTitle;
#line 47 "../src/comicsReader.vala"
			_tmp41_ = string_slice (_tmp39_, (glong) 0, (glong) string_last_index_of (_tmp40_, ".", 0));
#line 47 "../src/comicsReader.vala"
			_g_free0 (bookTitle);
#line 47 "../src/comicsReader.vala"
			bookTitle = _tmp41_;
#line 554 "comicsReader.c"
		}
#line 49 "../src/comicsReader.vala"
		_tmp42_ = bookTitle;
#line 49 "../src/comicsReader.vala"
		bookworm_app_book_setBookTitle (aBook, _tmp42_);
#line 50 "../src/comicsReader.vala"
		_tmp43_ = bookTitle;
#line 50 "../src/comicsReader.vala"
		_tmp44_ = g_strconcat ("File name set as Title:", _tmp43_, NULL);
#line 50 "../src/comicsReader.vala"
		_tmp45_ = _tmp44_;
#line 50 "../src/comicsReader.vala"
		g_debug ("comicsReader.vala:50: %s", _tmp45_);
#line 50 "../src/comicsReader.vala"
		_g_free0 (_tmp45_);
#line 44 "../src/comicsReader.vala"
		_g_free0 (bookTitle);
#line 572 "comicsReader.c"
	}
#line 53 "../src/comicsReader.vala"
	bookworm_app_book_setIsBookParsed (aBook, TRUE);
#line 54 "../src/comicsReader.vala"
	g_info ("comicsReader.vala:54: [END] [FUNCTION:parseComicsBook]");
#line 55 "../src/comicsReader.vala"
	_tmp46_ = _bookworm_app_book_ref0 (aBook);
#line 55 "../src/comicsReader.vala"
	result = _tmp46_;
#line 55 "../src/comicsReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 55 "../src/comicsReader.vala"
	return result;
#line 586 "comicsReader.c"
}

gchar*
bookworm_app_comics_reader_extractComics (const gchar* eBookLocation,
                                          const gchar* comicsFileType)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* extractionLocation = NULL;
	gchar* _tmp6_;
	BookwormAppSettings* _tmp7_;
	BookwormAppSettings* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	GQuark _tmp30_ = 0U;
#line 73 "../src/comicsReader.vala"
	static GQuark _tmp29_label0 = 0;
#line 73 "../src/comicsReader.vala"
	static GQuark _tmp29_label1 = 0;
#line 614 "comicsReader.c"
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* result;
#line 58 "../src/comicsReader.vala"
	g_return_val_if_fail (eBookLocation != NULL, NULL);
#line 58 "../src/comicsReader.vala"
	g_return_val_if_fail (comicsFileType != NULL, NULL);
#line 59 "../src/comicsReader.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:extractComics] eBookLocation=", eBookLocation, NULL);
#line 59 "../src/comicsReader.vala"
	_tmp1_ = _tmp0_;
#line 59 "../src/comicsReader.vala"
	_tmp2_ = g_strconcat (_tmp1_, ", comicsFileType=", NULL);
#line 59 "../src/comicsReader.vala"
	_tmp3_ = _tmp2_;
#line 59 "../src/comicsReader.vala"
	_tmp4_ = g_strconcat (_tmp3_, comicsFileType, NULL);
#line 59 "../src/comicsReader.vala"
	_tmp5_ = _tmp4_;
#line 59 "../src/comicsReader.vala"
	g_info ("comicsReader.vala:59: %s", _tmp5_);
#line 59 "../src/comicsReader.vala"
	_g_free0 (_tmp5_);
#line 59 "../src/comicsReader.vala"
	_g_free0 (_tmp3_);
#line 59 "../src/comicsReader.vala"
	_g_free0 (_tmp1_);
#line 60 "../src/comicsReader.vala"
	_tmp6_ = g_strdup ("false");
#line 60 "../src/comicsReader.vala"
	extractionLocation = _tmp6_;
#line 61 "../src/comicsReader.vala"
	_tmp7_ = bookworm_app_bookworm_settings;
#line 61 "../src/comicsReader.vala"
	if (_tmp7_ == NULL) {
#line 650 "comicsReader.c"
		BookwormAppSettings* _tmp8_;
#line 62 "../src/comicsReader.vala"
		_tmp8_ = bookworm_app_settings_get_instance ();
#line 62 "../src/comicsReader.vala"
		_g_object_unref0 (bookworm_app_bookworm_settings);
#line 62 "../src/comicsReader.vala"
		bookworm_app_bookworm_settings = _tmp8_;
#line 658 "comicsReader.c"
	}
#line 65 "../src/comicsReader.vala"
	_tmp9_ = bookworm_app_bookworm_settings;
#line 65 "../src/comicsReader.vala"
	_tmp10_ = bookworm_app_settings_get_is_local_storage_enabled (_tmp9_);
#line 65 "../src/comicsReader.vala"
	_tmp11_ = _tmp10_;
#line 65 "../src/comicsReader.vala"
	if (_tmp11_) {
#line 668 "comicsReader.c"
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
#line 66 "../src/comicsReader.vala"
		_tmp12_ = bookworm_app_bookworm_bookworm_config_path;
#line 66 "../src/comicsReader.vala"
		_tmp13_ = g_strconcat (_tmp12_, "/books/", NULL);
#line 66 "../src/comicsReader.vala"
		_tmp14_ = _tmp13_;
#line 66 "../src/comicsReader.vala"
		_tmp15_ = g_file_new_for_path (eBookLocation);
#line 66 "../src/comicsReader.vala"
		_tmp16_ = _tmp15_;
#line 66 "../src/comicsReader.vala"
		_tmp17_ = g_file_get_basename (_tmp16_);
#line 66 "../src/comicsReader.vala"
		_tmp18_ = _tmp17_;
#line 66 "../src/comicsReader.vala"
		_tmp19_ = g_strconcat (_tmp14_, _tmp18_, NULL);
#line 66 "../src/comicsReader.vala"
		_g_free0 (extractionLocation);
#line 66 "../src/comicsReader.vala"
		extractionLocation = _tmp19_;
#line 66 "../src/comicsReader.vala"
		_g_free0 (_tmp18_);
#line 66 "../src/comicsReader.vala"
		_g_object_unref0 (_tmp16_);
#line 66 "../src/comicsReader.vala"
		_g_free0 (_tmp14_);
#line 703 "comicsReader.c"
	} else {
		GFile* _tmp20_;
		GFile* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
#line 68 "../src/comicsReader.vala"
		_tmp20_ = g_file_new_for_path (eBookLocation);
#line 68 "../src/comicsReader.vala"
		_tmp21_ = _tmp20_;
#line 68 "../src/comicsReader.vala"
		_tmp22_ = g_file_get_basename (_tmp21_);
#line 68 "../src/comicsReader.vala"
		_tmp23_ = _tmp22_;
#line 68 "../src/comicsReader.vala"
		_tmp24_ = g_strconcat (BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION, _tmp23_, NULL);
#line 68 "../src/comicsReader.vala"
		_g_free0 (extractionLocation);
#line 68 "../src/comicsReader.vala"
		extractionLocation = _tmp24_;
#line 68 "../src/comicsReader.vala"
		_g_free0 (_tmp23_);
#line 68 "../src/comicsReader.vala"
		_g_object_unref0 (_tmp21_);
#line 728 "comicsReader.c"
	}
#line 71 "../src/comicsReader.vala"
	_tmp25_ = extractionLocation;
#line 71 "../src/comicsReader.vala"
	_tmp26_ = bookworm_app_utils_fileOperations ("CREATEDIR", _tmp25_, "", "");
#line 71 "../src/comicsReader.vala"
	_tmp27_ = _tmp26_;
#line 71 "../src/comicsReader.vala"
	_g_free0 (_tmp27_);
#line 73 "../src/comicsReader.vala"
	_tmp28_ = comicsFileType;
#line 73 "../src/comicsReader.vala"
	_tmp30_ = (NULL == _tmp28_) ? 0 : g_quark_from_string (_tmp28_);
#line 73 "../src/comicsReader.vala"
	if (_tmp30_ == ((0 != _tmp29_label0) ? _tmp29_label0 : (_tmp29_label0 = g_quark_from_static_string (".CBR")))) {
#line 73 "../src/comicsReader.vala"
		switch (0) {
#line 746 "comicsReader.c"
			default:
			{
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
#line 75 "../src/comicsReader.vala"
				_tmp31_ = extractionLocation;
#line 75 "../src/comicsReader.vala"
				_tmp32_ = g_strconcat ("unar -D -o \"", _tmp31_, NULL);
#line 75 "../src/comicsReader.vala"
				_tmp33_ = _tmp32_;
#line 75 "../src/comicsReader.vala"
				_tmp34_ = g_strconcat (_tmp33_, "/images/", NULL);
#line 75 "../src/comicsReader.vala"
				_tmp35_ = _tmp34_;
#line 75 "../src/comicsReader.vala"
				_tmp36_ = g_strconcat (_tmp35_, "\" \"", NULL);
#line 75 "../src/comicsReader.vala"
				_tmp37_ = _tmp36_;
#line 75 "../src/comicsReader.vala"
				_tmp38_ = g_strconcat (_tmp37_, eBookLocation, NULL);
#line 75 "../src/comicsReader.vala"
				_tmp39_ = _tmp38_;
#line 75 "../src/comicsReader.vala"
				_tmp40_ = g_strconcat (_tmp39_, "\"", NULL);
#line 75 "../src/comicsReader.vala"
				_tmp41_ = _tmp40_;
#line 75 "../src/comicsReader.vala"
				_tmp42_ = bookworm_app_utils_execute_sync_command (_tmp41_);
#line 75 "../src/comicsReader.vala"
				_tmp43_ = _tmp42_;
#line 75 "../src/comicsReader.vala"
				_g_free0 (_tmp43_);
#line 75 "../src/comicsReader.vala"
				_g_free0 (_tmp41_);
#line 75 "../src/comicsReader.vala"
				_g_free0 (_tmp39_);
#line 75 "../src/comicsReader.vala"
				_g_free0 (_tmp37_);
#line 75 "../src/comicsReader.vala"
				_g_free0 (_tmp35_);
#line 75 "../src/comicsReader.vala"
				_g_free0 (_tmp33_);
#line 76 "../src/comicsReader.vala"
				break;
#line 802 "comicsReader.c"
			}
		}
	} else if (_tmp30_ == ((0 != _tmp29_label1) ? _tmp29_label1 : (_tmp29_label1 = g_quark_from_static_string (".CBZ")))) {
#line 73 "../src/comicsReader.vala"
		switch (0) {
#line 808 "comicsReader.c"
			default:
			{
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
#line 78 "../src/comicsReader.vala"
				_tmp44_ = g_strconcat ("unzip -j -o \"", eBookLocation, NULL);
#line 78 "../src/comicsReader.vala"
				_tmp45_ = _tmp44_;
#line 78 "../src/comicsReader.vala"
				_tmp46_ = g_strconcat (_tmp45_, "\" -d \"", NULL);
#line 78 "../src/comicsReader.vala"
				_tmp47_ = _tmp46_;
#line 78 "../src/comicsReader.vala"
				_tmp48_ = extractionLocation;
#line 78 "../src/comicsReader.vala"
				_tmp49_ = g_strconcat (_tmp47_, _tmp48_, NULL);
#line 78 "../src/comicsReader.vala"
				_tmp50_ = _tmp49_;
#line 78 "../src/comicsReader.vala"
				_tmp51_ = g_strconcat (_tmp50_, "/images/", NULL);
#line 78 "../src/comicsReader.vala"
				_tmp52_ = _tmp51_;
#line 78 "../src/comicsReader.vala"
				_tmp53_ = g_strconcat (_tmp52_, "\"", NULL);
#line 78 "../src/comicsReader.vala"
				_tmp54_ = _tmp53_;
#line 78 "../src/comicsReader.vala"
				_tmp55_ = bookworm_app_utils_execute_sync_command (_tmp54_);
#line 78 "../src/comicsReader.vala"
				_tmp56_ = _tmp55_;
#line 78 "../src/comicsReader.vala"
				_g_free0 (_tmp56_);
#line 78 "../src/comicsReader.vala"
				_g_free0 (_tmp54_);
#line 78 "../src/comicsReader.vala"
				_g_free0 (_tmp52_);
#line 78 "../src/comicsReader.vala"
				_g_free0 (_tmp50_);
#line 78 "../src/comicsReader.vala"
				_g_free0 (_tmp47_);
#line 78 "../src/comicsReader.vala"
				_g_free0 (_tmp45_);
#line 79 "../src/comicsReader.vala"
				break;
#line 864 "comicsReader.c"
			}
		}
	} else {
#line 73 "../src/comicsReader.vala"
		switch (0) {
#line 870 "comicsReader.c"
			default:
			{
#line 81 "../src/comicsReader.vala"
				break;
#line 875 "comicsReader.c"
			}
		}
	}
#line 83 "../src/comicsReader.vala"
	_tmp57_ = g_strconcat ("[END] [FUNCTION:extractComics] extractionLocation=", eBookLocation, NULL);
#line 83 "../src/comicsReader.vala"
	_tmp58_ = _tmp57_;
#line 83 "../src/comicsReader.vala"
	g_info ("comicsReader.vala:83: %s", _tmp58_);
#line 83 "../src/comicsReader.vala"
	_g_free0 (_tmp58_);
#line 84 "../src/comicsReader.vala"
	result = extractionLocation;
#line 84 "../src/comicsReader.vala"
	return result;
#line 891 "comicsReader.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 913 "comicsReader.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 917 "comicsReader.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 923 "comicsReader.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 927 "comicsReader.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 931 "comicsReader.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 939 "comicsReader.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 967 "comicsReader.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 976 "comicsReader.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 990 "comicsReader.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 999 "comicsReader.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 1013 "comicsReader.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1022 "comicsReader.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 1031 "comicsReader.c"
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
#line 6821 "glib-2.0.vapi"
	g_atomic_int_inc (&_data26_->_ref_count_);
#line 6821 "glib-2.0.vapi"
	return _data26_;
#line 1041 "comicsReader.c"
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
#line 6821 "glib-2.0.vapi"
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
#line 1051 "comicsReader.c"
		GType t_type;
		GBoxedCopyFunc t_dup_func;
		GDestroyNotify t_destroy_func;
#line 6821 "glib-2.0.vapi"
		t_type = _data26_->t_type;
#line 6821 "glib-2.0.vapi"
		t_dup_func = _data26_->t_dup_func;
#line 6821 "glib-2.0.vapi"
		t_destroy_func = _data26_->t_destroy_func;
#line 6821 "glib-2.0.vapi"
		g_slice_free (Block26Data, _data26_);
#line 1063 "comicsReader.c"
	}
}

static gint
__lambda3_ (Block26Data* _data26_,
            gconstpointer* a,
            gconstpointer* b)
{
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	gint result;
#line 6822 "glib-2.0.vapi"
	t_type = _data26_->t_type;
#line 6822 "glib-2.0.vapi"
	t_dup_func = _data26_->t_dup_func;
#line 6822 "glib-2.0.vapi"
	t_destroy_func = _data26_->t_destroy_func;
#line 6823 "glib-2.0.vapi"
	result = _data26_->compare_func (*a, *b, _data26_->compare_func_target);
#line 6823 "glib-2.0.vapi"
	return result;
#line 1086 "comicsReader.c"
}

static gint
___lambda3__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda3_ (self, a, b);
#line 6822 "glib-2.0.vapi"
	return result;
#line 1098 "comicsReader.c"
}

static void
_vala_g_qsort_with_data (GType t_type,
                         GBoxedCopyFunc t_dup_func,
                         GDestroyNotify t_destroy_func,
                         gpointer* elems,
                         gint elems_length1,
                         gsize size,
                         GCompareDataFunc compare_func,
                         gpointer compare_func_target)
{
	Block26Data* _data26_;
#line 6821 "glib-2.0.vapi"
	_data26_ = g_slice_new0 (Block26Data);
#line 6821 "glib-2.0.vapi"
	_data26_->_ref_count_ = 1;
#line 6821 "glib-2.0.vapi"
	_data26_->t_type = t_type;
#line 6821 "glib-2.0.vapi"
	_data26_->t_dup_func = t_dup_func;
#line 6821 "glib-2.0.vapi"
	_data26_->t_destroy_func = t_destroy_func;
#line 6821 "glib-2.0.vapi"
	_data26_->compare_func = (GCompareDataFunc) compare_func;
#line 6821 "glib-2.0.vapi"
	_data26_->compare_func_target = compare_func_target;
#line 6822 "glib-2.0.vapi"
	g_qsort_with_data (elems, (gint) elems_length1, size, (GCompareDataFunc) ___lambda3__gcompare_data_func, _data26_);
#line 6821 "glib-2.0.vapi"
	block26_data_unref (_data26_);
#line 6821 "glib-2.0.vapi"
	_data26_ = NULL;
#line 1132 "comicsReader.c"
}

static gint
__lambda37_ (const gchar* a,
             const gchar* b)
{
	GCompareFunc _tmp0_;
	gint result;
#line 94 "../src/comicsReader.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 94 "../src/comicsReader.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 94 "../src/comicsReader.vala"
	_tmp0_ = ((GCompareFunc) g_strcmp0);
#line 94 "../src/comicsReader.vala"
	result = _tmp0_ (a, b);
#line 94 "../src/comicsReader.vala"
	return result;
#line 1151 "comicsReader.c"
}

static gint
___lambda37__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda37_ ((const gchar*) a, (const gchar*) b);
#line 94 "../src/comicsReader.vala"
	return result;
#line 1163 "comicsReader.c"
}

BookwormAppBook*
bookworm_app_comics_reader_getContentList (BookwormAppBook* aBook,
                                           const gchar* extractionLocation)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* comicContent = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar** comicContentList = NULL;
	const gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint comicContentList_length1;
	gint _comicContentList_size_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar** _tmp24_;
	gint _tmp24__length1;
	BookwormAppBook* _tmp72_;
	BookwormAppBook* result;
#line 87 "../src/comicsReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 87 "../src/comicsReader.vala"
	g_return_val_if_fail (extractionLocation != NULL, NULL);
#line 88 "../src/comicsReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 88 "../src/comicsReader.vala"
	_tmp1_ = _tmp0_;
#line 88 "../src/comicsReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:getContentList] book.location=", _tmp1_, NULL);
#line 88 "../src/comicsReader.vala"
	_tmp3_ = _tmp2_;
#line 88 "../src/comicsReader.vala"
	_tmp4_ = g_strconcat (_tmp3_, "extractionLocation=", NULL);
#line 88 "../src/comicsReader.vala"
	_tmp5_ = _tmp4_;
#line 88 "../src/comicsReader.vala"
	_tmp6_ = g_strconcat (_tmp5_, extractionLocation, NULL);
#line 88 "../src/comicsReader.vala"
	_tmp7_ = _tmp6_;
#line 88 "../src/comicsReader.vala"
	g_info ("comicsReader.vala:88: %s", _tmp7_);
#line 88 "../src/comicsReader.vala"
	_g_free0 (_tmp7_);
#line 88 "../src/comicsReader.vala"
	_g_free0 (_tmp5_);
#line 88 "../src/comicsReader.vala"
	_g_free0 (_tmp3_);
#line 88 "../src/comicsReader.vala"
	_g_free0 (_tmp1_);
#line 90 "../src/comicsReader.vala"
	_tmp8_ = g_strconcat ("find \"", extractionLocation, NULL);
#line 90 "../src/comicsReader.vala"
	_tmp9_ = _tmp8_;
#line 90 "../src/comicsReader.vala"
	_tmp10_ = g_strconcat (_tmp9_, "/images/", NULL);
#line 90 "../src/comicsReader.vala"
	_tmp11_ = _tmp10_;
#line 90 "../src/comicsReader.vala"
	_tmp12_ = g_strconcat (_tmp11_, "\" -type f", NULL);
#line 90 "../src/comicsReader.vala"
	_tmp13_ = _tmp12_;
#line 90 "../src/comicsReader.vala"
	_tmp14_ = bookworm_app_utils_execute_sync_command (_tmp13_);
#line 90 "../src/comicsReader.vala"
	_tmp15_ = _tmp14_;
#line 90 "../src/comicsReader.vala"
	_g_free0 (_tmp13_);
#line 90 "../src/comicsReader.vala"
	_g_free0 (_tmp11_);
#line 90 "../src/comicsReader.vala"
	_g_free0 (_tmp9_);
#line 90 "../src/comicsReader.vala"
	comicContent = _tmp15_;
#line 91 "../src/comicsReader.vala"
	_tmp16_ = comicContent;
#line 91 "../src/comicsReader.vala"
	_tmp17_ = string_replace (_tmp16_, "\r", "^^^");
#line 91 "../src/comicsReader.vala"
	_tmp18_ = _tmp17_;
#line 91 "../src/comicsReader.vala"
	_tmp19_ = string_replace (_tmp18_, "\n", "^^^");
#line 91 "../src/comicsReader.vala"
	_g_free0 (comicContent);
#line 91 "../src/comicsReader.vala"
	comicContent = _tmp19_;
#line 91 "../src/comicsReader.vala"
	_g_free0 (_tmp18_);
#line 92 "../src/comicsReader.vala"
	_tmp20_ = comicContent;
#line 92 "../src/comicsReader.vala"
	_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, "^^^", 0);
#line 92 "../src/comicsReader.vala"
	comicContentList = _tmp22_;
#line 92 "../src/comicsReader.vala"
	comicContentList_length1 = _vala_array_length (_tmp21_);
#line 92 "../src/comicsReader.vala"
	_comicContentList_size_ = comicContentList_length1;
#line 94 "../src/comicsReader.vala"
	_tmp23_ = comicContentList;
#line 94 "../src/comicsReader.vala"
	_tmp23__length1 = comicContentList_length1;
#line 94 "../src/comicsReader.vala"
	_vala_g_qsort_with_data (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp23_, (gint) _tmp23__length1, (gsize) sizeof (gchar*), (GCompareDataFunc) ___lambda37__gcompare_data_func, NULL);
#line 95 "../src/comicsReader.vala"
	_tmp24_ = comicContentList;
#line 95 "../src/comicsReader.vala"
	_tmp24__length1 = comicContentList_length1;
#line 95 "../src/comicsReader.vala"
	if (_tmp24__length1 > 1) {
#line 1293 "comicsReader.c"
		gint countOfSections = 0;
		GString* htmlFileName = NULL;
		GString* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
#line 96 "../src/comicsReader.vala"
		countOfSections = 1;
#line 97 "../src/comicsReader.vala"
		_tmp25_ = g_string_new ("");
#line 97 "../src/comicsReader.vala"
		htmlFileName = _tmp25_;
#line 98 "../src/comicsReader.vala"
		_tmp26_ = comicContentList;
#line 98 "../src/comicsReader.vala"
		_tmp26__length1 = comicContentList_length1;
#line 1309 "comicsReader.c"
		{
			gchar** contentLocationPath_collection = NULL;
			gint contentLocationPath_collection_length1 = 0;
			gint _contentLocationPath_collection_size_ = 0;
			gint contentLocationPath_it = 0;
#line 98 "../src/comicsReader.vala"
			contentLocationPath_collection = _tmp26_;
#line 98 "../src/comicsReader.vala"
			contentLocationPath_collection_length1 = _tmp26__length1;
#line 98 "../src/comicsReader.vala"
			for (contentLocationPath_it = 0; contentLocationPath_it < contentLocationPath_collection_length1; contentLocationPath_it = contentLocationPath_it + 1) {
#line 1321 "comicsReader.c"
				gchar* _tmp27_;
				gchar* contentLocationPath = NULL;
#line 98 "../src/comicsReader.vala"
				_tmp27_ = g_strdup (contentLocationPath_collection[contentLocationPath_it]);
#line 98 "../src/comicsReader.vala"
				contentLocationPath = _tmp27_;
#line 1328 "comicsReader.c"
				{
					gboolean _tmp28_ = FALSE;
					const gchar* _tmp29_;
#line 100 "../src/comicsReader.vala"
					_tmp29_ = contentLocationPath;
#line 100 "../src/comicsReader.vala"
					if (_tmp29_ != NULL) {
#line 1336 "comicsReader.c"
						const gchar* _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
#line 100 "../src/comicsReader.vala"
						_tmp30_ = contentLocationPath;
#line 100 "../src/comicsReader.vala"
						_tmp31_ = strlen (_tmp30_);
#line 100 "../src/comicsReader.vala"
						_tmp32_ = _tmp31_;
#line 100 "../src/comicsReader.vala"
						_tmp28_ = _tmp32_ > 0;
#line 1348 "comicsReader.c"
					} else {
#line 100 "../src/comicsReader.vala"
						_tmp28_ = FALSE;
#line 1352 "comicsReader.c"
					}
#line 100 "../src/comicsReader.vala"
					if (_tmp28_) {
#line 1356 "comicsReader.c"
						GString* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						GFile* _tmp36_;
						GFile* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						GString* _tmp48_;
						const gchar* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						const gchar* _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						gchar* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						gchar* _tmp60_;
						GString* _tmp61_;
						const gchar* _tmp62_;
						gchar* _tmp63_;
						gchar* _tmp64_;
						gint _tmp71_;
#line 102 "../src/comicsReader.vala"
						_tmp33_ = htmlFileName;
#line 102 "../src/comicsReader.vala"
						_tmp34_ = bookworm_app_book_getBookLocation (aBook);
#line 102 "../src/comicsReader.vala"
						_tmp35_ = _tmp34_;
#line 102 "../src/comicsReader.vala"
						_tmp36_ = g_file_new_for_path (_tmp35_);
#line 102 "../src/comicsReader.vala"
						_tmp37_ = _tmp36_;
#line 102 "../src/comicsReader.vala"
						_tmp38_ = g_file_get_basename (_tmp37_);
#line 102 "../src/comicsReader.vala"
						_tmp39_ = _tmp38_;
#line 102 "../src/comicsReader.vala"
						_tmp40_ = g_strconcat (_tmp39_, "_", NULL);
#line 102 "../src/comicsReader.vala"
						_tmp41_ = _tmp40_;
#line 102 "../src/comicsReader.vala"
						_tmp42_ = g_strdup_printf ("%i", countOfSections);
#line 102 "../src/comicsReader.vala"
						_tmp43_ = _tmp42_;
#line 102 "../src/comicsReader.vala"
						_tmp44_ = g_strconcat (_tmp41_, _tmp43_, NULL);
#line 102 "../src/comicsReader.vala"
						_tmp45_ = _tmp44_;
#line 102 "../src/comicsReader.vala"
						_tmp46_ = g_strconcat (_tmp45_, ".html", NULL);
#line 102 "../src/comicsReader.vala"
						_tmp47_ = _tmp46_;
#line 102 "../src/comicsReader.vala"
						g_string_assign (_tmp33_, _tmp47_);
#line 102 "../src/comicsReader.vala"
						_g_free0 (_tmp47_);
#line 102 "../src/comicsReader.vala"
						_g_free0 (_tmp45_);
#line 102 "../src/comicsReader.vala"
						_g_free0 (_tmp43_);
#line 102 "../src/comicsReader.vala"
						_g_free0 (_tmp41_);
#line 102 "../src/comicsReader.vala"
						_g_free0 (_tmp39_);
#line 102 "../src/comicsReader.vala"
						_g_object_unref0 (_tmp37_);
#line 102 "../src/comicsReader.vala"
						_g_free0 (_tmp35_);
#line 103 "../src/comicsReader.vala"
						_tmp48_ = htmlFileName;
#line 103 "../src/comicsReader.vala"
						_tmp49_ = _tmp48_->str;
#line 103 "../src/comicsReader.vala"
						_tmp50_ = g_strconcat (extractionLocation, "/images/", NULL);
#line 103 "../src/comicsReader.vala"
						_tmp51_ = _tmp50_;
#line 103 "../src/comicsReader.vala"
						_tmp52_ = contentLocationPath;
#line 103 "../src/comicsReader.vala"
						_tmp53_ = g_strconcat (_tmp51_, _tmp52_, NULL);
#line 103 "../src/comicsReader.vala"
						_tmp54_ = _tmp53_;
#line 103 "../src/comicsReader.vala"
						_tmp55_ = string_replace (BOOKWORM_APP_CONSTANTS_COMICS_HTML_TEMPLATE, "<image-location>", _tmp54_);
#line 103 "../src/comicsReader.vala"
						_tmp56_ = _tmp55_;
#line 103 "../src/comicsReader.vala"
						_tmp57_ = bookworm_app_utils_fileOperations ("WRITE", extractionLocation, _tmp49_, _tmp56_);
#line 103 "../src/comicsReader.vala"
						_tmp58_ = _tmp57_;
#line 103 "../src/comicsReader.vala"
						_g_free0 (_tmp58_);
#line 103 "../src/comicsReader.vala"
						_g_free0 (_tmp56_);
#line 103 "../src/comicsReader.vala"
						_g_free0 (_tmp54_);
#line 103 "../src/comicsReader.vala"
						_g_free0 (_tmp51_);
#line 106 "../src/comicsReader.vala"
						_tmp59_ = g_strconcat (extractionLocation, "/", NULL);
#line 106 "../src/comicsReader.vala"
						_tmp60_ = _tmp59_;
#line 106 "../src/comicsReader.vala"
						_tmp61_ = htmlFileName;
#line 106 "../src/comicsReader.vala"
						_tmp62_ = _tmp61_->str;
#line 106 "../src/comicsReader.vala"
						_tmp63_ = g_strconcat (_tmp60_, _tmp62_, NULL);
#line 106 "../src/comicsReader.vala"
						_tmp64_ = _tmp63_;
#line 106 "../src/comicsReader.vala"
						bookworm_app_book_setBookContentList (aBook, _tmp64_);
#line 106 "../src/comicsReader.vala"
						_g_free0 (_tmp64_);
#line 106 "../src/comicsReader.vala"
						_g_free0 (_tmp60_);
#line 108 "../src/comicsReader.vala"
						if (countOfSections == 1) {
#line 109 "../src/comicsReader.vala"
							if (!bookworm_app_book_getIsBookCoverImagePresent (aBook)) {
#line 1488 "comicsReader.c"
								const gchar* _tmp65_;
								gchar* _tmp66_;
								gchar* _tmp67_;
								BookwormAppBook* _tmp68_;
								const gchar* _tmp69_;
								BookwormAppBook* _tmp70_;
#line 110 "../src/comicsReader.vala"
								_tmp65_ = contentLocationPath;
#line 110 "../src/comicsReader.vala"
								_tmp66_ = g_strconcat ("setting cover as:", _tmp65_, NULL);
#line 110 "../src/comicsReader.vala"
								_tmp67_ = _tmp66_;
#line 110 "../src/comicsReader.vala"
								g_debug ("comicsReader.vala:110: %s", _tmp67_);
#line 110 "../src/comicsReader.vala"
								_g_free0 (_tmp67_);
#line 111 "../src/comicsReader.vala"
								_tmp68_ = _bookworm_app_book_ref0 (aBook);
#line 111 "../src/comicsReader.vala"
								_tmp69_ = contentLocationPath;
#line 111 "../src/comicsReader.vala"
								_tmp70_ = bookworm_app_utils_setBookCoverImage (_tmp68_, _tmp69_);
#line 111 "../src/comicsReader.vala"
								_bookworm_app_book_unref0 (aBook);
#line 111 "../src/comicsReader.vala"
								aBook = _tmp70_;
#line 1515 "comicsReader.c"
							}
						}
#line 114 "../src/comicsReader.vala"
						_tmp71_ = countOfSections;
#line 114 "../src/comicsReader.vala"
						countOfSections = _tmp71_ + 1;
#line 1522 "comicsReader.c"
					} else {
#line 116 "../src/comicsReader.vala"
						bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 117 "../src/comicsReader.vala"
						bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE);
#line 1528 "comicsReader.c"
					}
#line 98 "../src/comicsReader.vala"
					_g_free0 (contentLocationPath);
#line 1532 "comicsReader.c"
				}
			}
		}
#line 95 "../src/comicsReader.vala"
		_g_string_free0 (htmlFileName);
#line 1538 "comicsReader.c"
	}
#line 121 "../src/comicsReader.vala"
	g_info ("comicsReader.vala:121: [END] [FUNCTION:getContentList]");
#line 122 "../src/comicsReader.vala"
	_tmp72_ = _bookworm_app_book_ref0 (aBook);
#line 122 "../src/comicsReader.vala"
	result = _tmp72_;
#line 122 "../src/comicsReader.vala"
	comicContentList = (_vala_array_free (comicContentList, comicContentList_length1, (GDestroyNotify) g_free), NULL);
#line 122 "../src/comicsReader.vala"
	_g_free0 (comicContent);
#line 122 "../src/comicsReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 122 "../src/comicsReader.vala"
	return result;
#line 1554 "comicsReader.c"
}

BookwormAppcomicsReader*
bookworm_app_comics_reader_construct (GType object_type)
{
	BookwormAppcomicsReader* self = NULL;
#line 20 "../src/comicsReader.vala"
	self = (BookwormAppcomicsReader*) g_type_create_instance (object_type);
#line 20 "../src/comicsReader.vala"
	return self;
#line 1565 "comicsReader.c"
}

BookwormAppcomicsReader*
bookworm_app_comics_reader_new (void)
{
#line 20 "../src/comicsReader.vala"
	return bookworm_app_comics_reader_construct (BOOKWORM_APP_TYPE_COMICS_READER);
#line 1573 "comicsReader.c"
}

static void
bookworm_app_value_comics_reader_init (GValue* value)
{
#line 20 "../src/comicsReader.vala"
	value->data[0].v_pointer = NULL;
#line 1581 "comicsReader.c"
}

static void
bookworm_app_value_comics_reader_free_value (GValue* value)
{
#line 20 "../src/comicsReader.vala"
	if (value->data[0].v_pointer) {
#line 20 "../src/comicsReader.vala"
		bookworm_app_comics_reader_unref (value->data[0].v_pointer);
#line 1591 "comicsReader.c"
	}
}

static void
bookworm_app_value_comics_reader_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
#line 20 "../src/comicsReader.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "../src/comicsReader.vala"
		dest_value->data[0].v_pointer = bookworm_app_comics_reader_ref (src_value->data[0].v_pointer);
#line 1603 "comicsReader.c"
	} else {
#line 20 "../src/comicsReader.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1607 "comicsReader.c"
	}
}

static gpointer
bookworm_app_value_comics_reader_peek_pointer (const GValue* value)
{
#line 20 "../src/comicsReader.vala"
	return value->data[0].v_pointer;
#line 1616 "comicsReader.c"
}

static gchar*
bookworm_app_value_comics_reader_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
#line 20 "../src/comicsReader.vala"
	if (collect_values[0].v_pointer) {
#line 1627 "comicsReader.c"
		BookwormAppcomicsReader * object;
		object = collect_values[0].v_pointer;
#line 20 "../src/comicsReader.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "../src/comicsReader.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1634 "comicsReader.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "../src/comicsReader.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1638 "comicsReader.c"
		}
#line 20 "../src/comicsReader.vala"
		value->data[0].v_pointer = bookworm_app_comics_reader_ref (object);
#line 1642 "comicsReader.c"
	} else {
#line 20 "../src/comicsReader.vala"
		value->data[0].v_pointer = NULL;
#line 1646 "comicsReader.c"
	}
#line 20 "../src/comicsReader.vala"
	return NULL;
#line 1650 "comicsReader.c"
}

static gchar*
bookworm_app_value_comics_reader_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	BookwormAppcomicsReader ** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "../src/comicsReader.vala"
	if (!object_p) {
#line 20 "../src/comicsReader.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1665 "comicsReader.c"
	}
#line 20 "../src/comicsReader.vala"
	if (!value->data[0].v_pointer) {
#line 20 "../src/comicsReader.vala"
		*object_p = NULL;
#line 1671 "comicsReader.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "../src/comicsReader.vala"
		*object_p = value->data[0].v_pointer;
#line 1675 "comicsReader.c"
	} else {
#line 20 "../src/comicsReader.vala"
		*object_p = bookworm_app_comics_reader_ref (value->data[0].v_pointer);
#line 1679 "comicsReader.c"
	}
#line 20 "../src/comicsReader.vala"
	return NULL;
#line 1683 "comicsReader.c"
}

GParamSpec*
bookworm_app_param_spec_comics_reader (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	BookwormAppParamSpeccomicsReader* spec;
#line 20 "../src/comicsReader.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_COMICS_READER), NULL);
#line 20 "../src/comicsReader.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "../src/comicsReader.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "../src/comicsReader.vala"
	return G_PARAM_SPEC (spec);
#line 1702 "comicsReader.c"
}

gpointer
bookworm_app_value_get_comics_reader (const GValue* value)
{
#line 20 "../src/comicsReader.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_COMICS_READER), NULL);
#line 20 "../src/comicsReader.vala"
	return value->data[0].v_pointer;
#line 1712 "comicsReader.c"
}

void
bookworm_app_value_set_comics_reader (GValue* value,
                                      gpointer v_object)
{
	BookwormAppcomicsReader * old;
#line 20 "../src/comicsReader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_COMICS_READER));
#line 20 "../src/comicsReader.vala"
	old = value->data[0].v_pointer;
#line 20 "../src/comicsReader.vala"
	if (v_object) {
#line 20 "../src/comicsReader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_COMICS_READER));
#line 20 "../src/comicsReader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "../src/comicsReader.vala"
		value->data[0].v_pointer = v_object;
#line 20 "../src/comicsReader.vala"
		bookworm_app_comics_reader_ref (value->data[0].v_pointer);
#line 1734 "comicsReader.c"
	} else {
#line 20 "../src/comicsReader.vala"
		value->data[0].v_pointer = NULL;
#line 1738 "comicsReader.c"
	}
#line 20 "../src/comicsReader.vala"
	if (old) {
#line 20 "../src/comicsReader.vala"
		bookworm_app_comics_reader_unref (old);
#line 1744 "comicsReader.c"
	}
}

void
bookworm_app_value_take_comics_reader (GValue* value,
                                       gpointer v_object)
{
	BookwormAppcomicsReader * old;
#line 20 "../src/comicsReader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_COMICS_READER));
#line 20 "../src/comicsReader.vala"
	old = value->data[0].v_pointer;
#line 20 "../src/comicsReader.vala"
	if (v_object) {
#line 20 "../src/comicsReader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_COMICS_READER));
#line 20 "../src/comicsReader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "../src/comicsReader.vala"
		value->data[0].v_pointer = v_object;
#line 1765 "comicsReader.c"
	} else {
#line 20 "../src/comicsReader.vala"
		value->data[0].v_pointer = NULL;
#line 1769 "comicsReader.c"
	}
#line 20 "../src/comicsReader.vala"
	if (old) {
#line 20 "../src/comicsReader.vala"
		bookworm_app_comics_reader_unref (old);
#line 1775 "comicsReader.c"
	}
}

static void
bookworm_app_comics_reader_class_init (BookwormAppcomicsReaderClass * klass,
                                       gpointer klass_data)
{
#line 20 "../src/comicsReader.vala"
	bookworm_app_comics_reader_parent_class = g_type_class_peek_parent (klass);
#line 20 "../src/comicsReader.vala"
	((BookwormAppcomicsReaderClass *) klass)->finalize = bookworm_app_comics_reader_finalize;
#line 1787 "comicsReader.c"
}

static void
bookworm_app_comics_reader_instance_init (BookwormAppcomicsReader * self,
                                          gpointer klass)
{
#line 20 "../src/comicsReader.vala"
	self->ref_count = 1;
#line 1796 "comicsReader.c"
}

static void
bookworm_app_comics_reader_finalize (BookwormAppcomicsReader * obj)
{
	BookwormAppcomicsReader * self;
#line 20 "../src/comicsReader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_COMICS_READER, BookwormAppcomicsReader);
#line 20 "../src/comicsReader.vala"
	g_signal_handlers_destroy (self);
#line 1807 "comicsReader.c"
}

static GType
bookworm_app_comics_reader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_comics_reader_init, bookworm_app_value_comics_reader_free_value, bookworm_app_value_comics_reader_copy_value, bookworm_app_value_comics_reader_peek_pointer, "p", bookworm_app_value_comics_reader_collect_value, "p", bookworm_app_value_comics_reader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppcomicsReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_comics_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppcomicsReader), 0, (GInstanceInitFunc) bookworm_app_comics_reader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_comics_reader_type_id;
	bookworm_app_comics_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppcomicsReader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_comics_reader_type_id;
}

GType
bookworm_app_comics_reader_get_type (void)
{
	static volatile gsize bookworm_app_comics_reader_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_comics_reader_type_id__once)) {
		GType bookworm_app_comics_reader_type_id;
		bookworm_app_comics_reader_type_id = bookworm_app_comics_reader_get_type_once ();
		g_once_init_leave (&bookworm_app_comics_reader_type_id__once, bookworm_app_comics_reader_type_id);
	}
	return bookworm_app_comics_reader_type_id__once;
}

gpointer
bookworm_app_comics_reader_ref (gpointer instance)
{
	BookwormAppcomicsReader * self;
	self = instance;
#line 20 "../src/comicsReader.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "../src/comicsReader.vala"
	return instance;
#line 1842 "comicsReader.c"
}

void
bookworm_app_comics_reader_unref (gpointer instance)
{
	BookwormAppcomicsReader * self;
	self = instance;
#line 20 "../src/comicsReader.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "../src/comicsReader.vala"
		BOOKWORM_APP_COMICS_READER_GET_CLASS (self)->finalize (self);
#line 20 "../src/comicsReader.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1856 "comicsReader.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

