// This file is generated by kconfig_compiler_kf6 from breezesettingsdata.kcfg.
// All changes you do to this file will be lost.
#ifndef BREEZE_INTERNALSETTINGS_H
#define BREEZE_INTERNALSETTINGS_H

#include <qglobal.h>
#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace Breeze {

class InternalSettings : public KConfigSkeleton
{
  public:
    enum EnumShadowSize { ShadowNone, ShadowSmall, ShadowMedium, ShadowLarge, ShadowVeryLarge };
    enum EnumBorderSize { BorderNone, BorderNoSides, BorderTiny, BorderNormal, BorderLarge, BorderVeryLarge, BorderHuge, BorderVeryHuge, BorderOversized };
    enum EnumTitleAlignment { AlignLeft, AlignCenter, AlignCenterFullWidth, AlignRight };
    enum EnumButtonSize { ButtonTiny, ButtonSmall, ButtonDefault, ButtonLarge, ButtonVeryLarge };
    enum EnumExceptionType { ExceptionWindowClassName, ExceptionWindowTitle };

    InternalSettings( );
    ~InternalSettings() override;

    /**
      Set ShadowStrength
    */
    void setShadowStrength( int v )
    {
      if (v < 25)
      {
        qDebug() << "setShadowStrength: value " << v << " is less than the minimum value of 25";
        v = 25;
      }

      if (v > 255)
      {
        qDebug() << "setShadowStrength: value " << v << " is greater than the maximum value of 255";
        v = 255;
      }

      if (!isShadowStrengthImmutable())
        mShadowStrength = v;
    }

    /**
      Get ShadowStrength
    */
    int shadowStrength() const
    {
      return mShadowStrength;
    }

    /**
      Is ShadowStrength Immutable
    */
    bool isShadowStrengthImmutable() const
    {
      return isImmutable( QStringLiteral( "ShadowStrength" ) );
    }

    /**
      Set ShadowSize
    */
    void setShadowSize( int v )
    {
      if (!isShadowSizeImmutable())
        mShadowSize = v;
    }

    /**
      Get ShadowSize
    */
    int shadowSize() const
    {
      return mShadowSize;
    }

    /**
      Is ShadowSize Immutable
    */
    bool isShadowSizeImmutable() const
    {
      return isImmutable( QStringLiteral( "ShadowSize" ) );
    }

    /**
      Set ShadowColor
    */
    void setShadowColor( const QColor & v )
    {
      if (!isShadowColorImmutable())
        mShadowColor = v;
    }

    /**
      Get ShadowColor
    */
    QColor shadowColor() const
    {
      return mShadowColor;
    }

    /**
      Is ShadowColor Immutable
    */
    bool isShadowColorImmutable() const
    {
      return isImmutable( QStringLiteral( "ShadowColor" ) );
    }

    /**
      Set OutlineCloseButton
    */
    void setOutlineCloseButton( bool v )
    {
      if (!isOutlineCloseButtonImmutable())
        mOutlineCloseButton = v;
    }

    /**
      Get OutlineCloseButton
    */
    bool outlineCloseButton() const
    {
      return mOutlineCloseButton;
    }

    /**
      Is OutlineCloseButton Immutable
    */
    bool isOutlineCloseButtonImmutable() const
    {
      return isImmutable( QStringLiteral( "OutlineCloseButton" ) );
    }

    /**
      Set OutlineEnabled
    */
    void setOutlineEnabled( bool v )
    {
      if (!isOutlineEnabledImmutable())
        mOutlineEnabled = v;
    }

    /**
      Get OutlineEnabled
    */
    bool outlineEnabled() const
    {
      return mOutlineEnabled;
    }

    /**
      Is OutlineEnabled Immutable
    */
    bool isOutlineEnabledImmutable() const
    {
      return isImmutable( QStringLiteral( "OutlineEnabled" ) );
    }

    /**
      Set RoundedCorners
    */
    void setRoundedCorners( bool v )
    {
      if (!isRoundedCornersImmutable())
        mRoundedCorners = v;
    }

    /**
      Get RoundedCorners
    */
    bool roundedCorners() const
    {
      return mRoundedCorners;
    }

    /**
      Is RoundedCorners Immutable
    */
    bool isRoundedCornersImmutable() const
    {
      return isImmutable( QStringLiteral( "RoundedCorners" ) );
    }

    /**
      Set BorderSize
    */
    void setBorderSize( int v )
    {
      if (!isBorderSizeImmutable())
        mBorderSize = v;
    }

    /**
      Get BorderSize
    */
    int borderSize() const
    {
      return mBorderSize;
    }

    /**
      Is BorderSize Immutable
    */
    bool isBorderSizeImmutable() const
    {
      return isImmutable( QStringLiteral( "BorderSize" ) );
    }

    /**
      Set TitleAlignment
    */
    void setTitleAlignment( int v )
    {
      if (!isTitleAlignmentImmutable())
        mTitleAlignment = v;
    }

    /**
      Get TitleAlignment
    */
    int titleAlignment() const
    {
      return mTitleAlignment;
    }

    /**
      Is TitleAlignment Immutable
    */
    bool isTitleAlignmentImmutable() const
    {
      return isImmutable( QStringLiteral( "TitleAlignment" ) );
    }

    /**
      Set ButtonSize
    */
    void setButtonSize( int v )
    {
      if (!isButtonSizeImmutable())
        mButtonSize = v;
    }

    /**
      Get ButtonSize
    */
    int buttonSize() const
    {
      return mButtonSize;
    }

    /**
      Is ButtonSize Immutable
    */
    bool isButtonSizeImmutable() const
    {
      return isImmutable( QStringLiteral( "ButtonSize" ) );
    }

    /**
      Set DrawBorderOnMaximizedWindows
    */
    void setDrawBorderOnMaximizedWindows( bool v )
    {
      if (!isDrawBorderOnMaximizedWindowsImmutable())
        mDrawBorderOnMaximizedWindows = v;
    }

    /**
      Get DrawBorderOnMaximizedWindows
    */
    bool drawBorderOnMaximizedWindows() const
    {
      return mDrawBorderOnMaximizedWindows;
    }

    /**
      Is DrawBorderOnMaximizedWindows Immutable
    */
    bool isDrawBorderOnMaximizedWindowsImmutable() const
    {
      return isImmutable( QStringLiteral( "DrawBorderOnMaximizedWindows" ) );
    }

    /**
      Set DrawBackgroundGradient
    */
    void setDrawBackgroundGradient( bool v )
    {
      if (!isDrawBackgroundGradientImmutable())
        mDrawBackgroundGradient = v;
    }

    /**
      Get DrawBackgroundGradient
    */
    bool drawBackgroundGradient() const
    {
      return mDrawBackgroundGradient;
    }

    /**
      Is DrawBackgroundGradient Immutable
    */
    bool isDrawBackgroundGradientImmutable() const
    {
      return isImmutable( QStringLiteral( "DrawBackgroundGradient" ) );
    }

    /**
      Set HideTitleBar
    */
    void setHideTitleBar( bool v )
    {
      if (!isHideTitleBarImmutable())
        mHideTitleBar = v;
    }

    /**
      Get HideTitleBar
    */
    bool hideTitleBar() const
    {
      return mHideTitleBar;
    }

    /**
      Is HideTitleBar Immutable
    */
    bool isHideTitleBarImmutable() const
    {
      return isImmutable( QStringLiteral( "HideTitleBar" ) );
    }

    /**
      Set ExceptionType
    */
    void setExceptionType( int v )
    {
      if (!isExceptionTypeImmutable())
        mExceptionType = v;
    }

    /**
      Get ExceptionType
    */
    int exceptionType() const
    {
      return mExceptionType;
    }

    /**
      Is ExceptionType Immutable
    */
    bool isExceptionTypeImmutable() const
    {
      return isImmutable( QStringLiteral( "ExceptionType" ) );
    }

    /**
      Set ExceptionPattern
    */
    void setExceptionPattern( const QString & v )
    {
      if (!isExceptionPatternImmutable())
        mExceptionPattern = v;
    }

    /**
      Get ExceptionPattern
    */
    QString exceptionPattern() const
    {
      return mExceptionPattern;
    }

    /**
      Is ExceptionPattern Immutable
    */
    bool isExceptionPatternImmutable() const
    {
      return isImmutable( QStringLiteral( "ExceptionPattern" ) );
    }

    /**
      Set Enabled
    */
    void setEnabled( bool v )
    {
      if (!isEnabledImmutable())
        mEnabled = v;
    }

    /**
      Get Enabled
    */
    bool enabled() const
    {
      return mEnabled;
    }

    /**
      Is Enabled Immutable
    */
    bool isEnabledImmutable() const
    {
      return isImmutable( QStringLiteral( "Enabled" ) );
    }

    /**
      Set Mask
    */
    void setMask( int v )
    {
      if (!isMaskImmutable())
        mMask = v;
    }

    /**
      Get Mask
    */
    int mask() const
    {
      return mMask;
    }

    /**
      Is Mask Immutable
    */
    bool isMaskImmutable() const
    {
      return isImmutable( QStringLiteral( "Mask" ) );
    }

  protected:

    // Common
    int mShadowStrength;
    int mShadowSize;
    QColor mShadowColor;
    bool mOutlineCloseButton;
    bool mOutlineEnabled;
    bool mRoundedCorners;

    // Windeco
    int mBorderSize;
    int mTitleAlignment;
    int mButtonSize;
    bool mDrawBorderOnMaximizedWindows;
    bool mDrawBackgroundGradient;
    bool mHideTitleBar;
    int mExceptionType;
    QString mExceptionPattern;
    bool mEnabled;
    int mMask;
};

}

#endif

