/* AppListBox.c generated by valac 0.56.17, the Vala compiler
 * generated from AppListBox.vala, do not modify */

/*
 * Copyright 2011-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 *              Giulio Collura
 */

#include "slingshot.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_APP_LIST_BOX_0_PROPERTY,
	SLINGSHOT_APP_LIST_BOX_DRAGGING_PROPERTY,
	SLINGSHOT_APP_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* slingshot_app_list_box_properties[SLINGSHOT_APP_LIST_BOX_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SLINGSHOT_APP_LIST_BOX_CLOSE_REQUEST_SIGNAL,
	SLINGSHOT_APP_LIST_BOX_NUM_SIGNALS
};
static guint slingshot_app_list_box_signals[SLINGSHOT_APP_LIST_BOX_NUM_SIGNALS] = {0};

struct _SlingshotAppListBoxPrivate {
	gboolean _dragging;
	gchar* drag_uri;
};

static gint SlingshotAppListBox_private_offset;
static gpointer slingshot_app_list_box_parent_class = NULL;
static GType slingshot_app_list_box_type_id = 0;

static void slingshot_app_list_box_real_move_cursor (GtkListBox* base,
                                              GtkMovementStep step,
                                              gint count);
static void slingshot_app_list_box_set_dragging (SlingshotAppListBox* self,
                                          gboolean value);
static GObject * slingshot_app_list_box_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static gboolean _slingshot_app_list_box___lambda48_ (SlingshotAppListBox* self,
                                              GdkEventMotion* event);
static gboolean __slingshot_app_list_box___lambda48__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                              GdkEventMotion* event,
                                                                              gpointer self);
static void _slingshot_app_list_box___lambda49_ (SlingshotAppListBox* self,
                                          GdkDragContext* ctx);
static void __slingshot_app_list_box___lambda49__gtk_widget_drag_begin (GtkWidget* _sender,
                                                                 GdkDragContext* context,
                                                                 gpointer self);
static void _slingshot_app_list_box___lambda50_ (SlingshotAppListBox* self);
static void __slingshot_app_list_box___lambda50__gtk_widget_drag_end (GtkWidget* _sender,
                                                               GdkDragContext* context,
                                                               gpointer self);
static void _slingshot_app_list_box___lambda51_ (SlingshotAppListBox* self,
                                          GdkDragContext* ctx,
                                          GtkSelectionData* sel,
                                          guint info,
                                          guint time);
static void __slingshot_app_list_box___lambda51__gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                    GdkDragContext* context,
                                                                    GtkSelectionData* selection_data,
                                                                    guint info,
                                                                    guint time_,
                                                                    gpointer self);
static void slingshot_app_list_box_finalize (GObject * obj);
static void _vala_slingshot_app_list_box_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_slingshot_app_list_box_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
slingshot_app_list_box_get_instance_private (SlingshotAppListBox* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotAppListBox_private_offset);
}

static void
slingshot_app_list_box_real_move_cursor (GtkListBox* base,
                                         GtkMovementStep step,
                                         gint count)
{
	SlingshotAppListBox * self;
	GtkListBoxRow* selected = NULL;
	GtkListBoxRow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	guint n_children = 0U;
	GList* _tmp3_;
	GList* _tmp4_;
	guint _tmp5_;
	gint current = 0;
	GtkListBoxRow* _tmp6_;
	gint target = 0;
	GtkListBoxRow* target_row = NULL;
	GtkListBoxRow* _tmp7_;
	GtkListBoxRow* _tmp8_;
	self = (SlingshotAppListBox*) base;
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	selected = _tmp0_;
	if (step != GTK_MOVEMENT_DISPLAY_LINES) {
		_tmp1_ = TRUE;
	} else {
		GtkListBoxRow* _tmp2_;
		_tmp2_ = selected;
		_tmp1_ = _tmp2_ == NULL;
	}
	if (_tmp1_) {
		GTK_LIST_BOX_CLASS (slingshot_app_list_box_parent_class)->move_cursor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), step, count);
		return;
	}
	_tmp3_ = gtk_container_get_children ((GtkContainer*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_list_length (_tmp4_);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_list_free (_tmp4_), NULL));
	n_children = _tmp5_;
	_tmp6_ = selected;
	current = gtk_list_box_row_get_index (_tmp6_);
	target = current + count;
	if (target < 0) {
		target = ((gint) n_children) + count;
	} else {
		if (((guint) target) >= n_children) {
			target = count - 1;
		}
	}
	_tmp7_ = gtk_list_box_get_row_at_index ((GtkListBox*) self, target);
	target_row = _tmp7_;
	_tmp8_ = target_row;
	if (_tmp8_ != NULL) {
		GtkListBoxRow* _tmp9_;
		GtkListBoxRow* _tmp10_;
		_tmp9_ = target_row;
		gtk_list_box_select_row ((GtkListBox*) self, _tmp9_);
		_tmp10_ = target_row;
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	}
}

SlingshotAppListBox*
slingshot_app_list_box_construct (GType object_type)
{
	SlingshotAppListBox * self = NULL;
	self = (SlingshotAppListBox*) g_object_new (object_type, NULL);
	return self;
}

SlingshotAppListBox*
slingshot_app_list_box_new (void)
{
	return slingshot_app_list_box_construct (SLINGSHOT_TYPE_APP_LIST_BOX);
}

gboolean
slingshot_app_list_box_get_dragging (SlingshotAppListBox* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dragging;
	return result;
}

static void
slingshot_app_list_box_set_dragging (SlingshotAppListBox* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_app_list_box_get_dragging (self);
	if (old_value != value) {
		self->priv->_dragging = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_app_list_box_properties[SLINGSHOT_APP_LIST_BOX_DRAGGING_PROPERTY]);
	}
}

static gboolean
_slingshot_app_list_box___lambda48_ (SlingshotAppListBox* self,
                                     GdkEventMotion* event)
{
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_dragging;
	if (!_tmp0_) {
		GtkListBoxRow* _tmp1_;
		_tmp1_ = gtk_list_box_get_row_at_y ((GtkListBox*) self, (gint) event->y);
		gtk_list_box_select_row ((GtkListBox*) self, _tmp1_);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__slingshot_app_list_box___lambda48__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                     GdkEventMotion* event,
                                                                     gpointer self)
{
	gboolean result;
	result = _slingshot_app_list_box___lambda48_ ((SlingshotAppListBox*) self, event);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_slingshot_app_list_box___lambda49_ (SlingshotAppListBox* self,
                                     GdkDragContext* ctx)
{
	GtkListBoxRow* selected_row = NULL;
	GtkListBoxRow* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	g_return_if_fail (ctx != NULL);
	_tmp0_ = gtk_list_box_get_selected_row ((GtkListBox*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	selected_row = _tmp1_;
	_tmp2_ = selected_row;
	if (_tmp2_ != NULL) {
		SlingshotWidgetsSearchItem* drag_item = NULL;
		GtkListBoxRow* _tmp3_;
		SlingshotWidgetsSearchItem* _tmp4_;
		SlingshotWidgetsSearchItem* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		slingshot_app_list_box_set_dragging (self, TRUE);
		_tmp3_ = selected_row;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SLINGSHOT_WIDGETS_TYPE_SEARCH_ITEM, SlingshotWidgetsSearchItem));
		drag_item = _tmp4_;
		_tmp5_ = drag_item;
		_tmp6_ = slingshot_widgets_search_item_get_app_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (self->priv->drag_uri);
		self->priv->drag_uri = _tmp8_;
		_tmp9_ = self->priv->drag_uri;
		if (_tmp9_ != NULL) {
			SlingshotWidgetsSearchItem* _tmp10_;
			GtkImage* _tmp11_;
			GtkImage* _tmp12_;
			GIcon* _tmp13_;
			GIcon* _tmp14_;
			GIcon* _tmp15_;
			_tmp10_ = drag_item;
			_tmp11_ = slingshot_widgets_search_item_get_icon (_tmp10_);
			_tmp12_ = _tmp11_;
			g_object_get (_tmp12_, "gicon", &_tmp13_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_;
			gtk_drag_set_icon_gicon (ctx, _tmp15_, 16, 16);
			_g_object_unref0 (_tmp15_);
		}
		_g_object_unref0 (drag_item);
	}
	_g_object_unref0 (selected_row);
}

static void
__slingshot_app_list_box___lambda49__gtk_widget_drag_begin (GtkWidget* _sender,
                                                            GdkDragContext* context,
                                                            gpointer self)
{
	_slingshot_app_list_box___lambda49_ ((SlingshotAppListBox*) self, context);
}

static void
_slingshot_app_list_box___lambda50_ (SlingshotAppListBox* self)
{
	const gchar* _tmp0_;
	_tmp0_ = self->priv->drag_uri;
	if (_tmp0_ != NULL) {
		g_signal_emit (self, slingshot_app_list_box_signals[SLINGSHOT_APP_LIST_BOX_CLOSE_REQUEST_SIGNAL], 0);
	}
	slingshot_app_list_box_set_dragging (self, FALSE);
	_g_free0 (self->priv->drag_uri);
	self->priv->drag_uri = NULL;
}

static void
__slingshot_app_list_box___lambda50__gtk_widget_drag_end (GtkWidget* _sender,
                                                          GdkDragContext* context,
                                                          gpointer self)
{
	_slingshot_app_list_box___lambda50_ ((SlingshotAppListBox*) self);
}

static void
_slingshot_app_list_box___lambda51_ (SlingshotAppListBox* self,
                                     GdkDragContext* ctx,
                                     GtkSelectionData* sel,
                                     guint info,
                                     guint time)
{
	const gchar* _tmp0_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (sel != NULL);
	_tmp0_ = self->priv->drag_uri;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp1_ = self->priv->drag_uri;
		_tmp2_ = g_strdup (_tmp1_);
		_tmp3_ = g_new0 (gchar*, 1 + 1);
		_tmp3_[0] = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 1;
		gtk_selection_data_set_uris (sel, _tmp4_);
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	}
}

static void
__slingshot_app_list_box___lambda51__gtk_widget_drag_data_get (GtkWidget* _sender,
                                                               GdkDragContext* context,
                                                               GtkSelectionData* selection_data,
                                                               guint info,
                                                               guint time_,
                                                               gpointer self)
{
	_slingshot_app_list_box___lambda51_ ((SlingshotAppListBox*) self, context, selection_data, info, time_);
}

static GObject *
slingshot_app_list_box_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotAppListBox * self;
	static const GtkTargetEntry DND = {"text/uri-list", (guint) 0, (guint) 0};
	GtkTargetEntry* _tmp0_;
	GtkTargetEntry* _tmp1_;
	gint _tmp1__length1;
	parent_class = G_OBJECT_CLASS (slingshot_app_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_APP_LIST_BOX, SlingshotAppListBox);
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_BROWSE);
	_tmp0_ = g_new0 (GtkTargetEntry, 1);
	_tmp0_[0] = DND;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 1;
	gtk_drag_source_set ((GtkWidget*) self, GDK_BUTTON1_MASK, _tmp1_, (gint) 1, GDK_ACTION_COPY);
	_tmp1_ = (g_free (_tmp1_), NULL);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) __slingshot_app_list_box___lambda48__gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-begin", (GCallback) __slingshot_app_list_box___lambda49__gtk_widget_drag_begin, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-end", (GCallback) __slingshot_app_list_box___lambda50__gtk_widget_drag_end, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-get", (GCallback) __slingshot_app_list_box___lambda51__gtk_widget_drag_data_get, self, 0);
	return obj;
}

static void
slingshot_app_list_box_class_init (SlingshotAppListBoxClass * klass,
                                   gpointer klass_data)
{
	slingshot_app_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotAppListBox_private_offset);
	((GtkListBoxClass *) klass)->move_cursor = (void (*) (GtkListBox*, GtkMovementStep, gint)) slingshot_app_list_box_real_move_cursor;
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_app_list_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_app_list_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_app_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_app_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_APP_LIST_BOX_DRAGGING_PROPERTY, slingshot_app_list_box_properties[SLINGSHOT_APP_LIST_BOX_DRAGGING_PROPERTY] = g_param_spec_boolean ("dragging", "dragging", "dragging", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	slingshot_app_list_box_signals[SLINGSHOT_APP_LIST_BOX_CLOSE_REQUEST_SIGNAL] = g_signal_new ("close-request", SLINGSHOT_TYPE_APP_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slingshot_app_list_box_instance_init (SlingshotAppListBox * self,
                                      gpointer klass)
{
	self->priv = slingshot_app_list_box_get_instance_private (self);
	self->priv->_dragging = FALSE;
	self->priv->drag_uri = NULL;
}

static void
slingshot_app_list_box_finalize (GObject * obj)
{
	SlingshotAppListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_APP_LIST_BOX, SlingshotAppListBox);
	_g_free0 (self->priv->drag_uri);
	G_OBJECT_CLASS (slingshot_app_list_box_parent_class)->finalize (obj);
}

GType
slingshot_app_list_box_get_type (void)
{
	return slingshot_app_list_box_type_id;
}

GType
slingshot_app_list_box_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotAppListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_app_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotAppListBox), 0, (GInstanceInitFunc) slingshot_app_list_box_instance_init, NULL };
	slingshot_app_list_box_type_id = g_type_module_register_type (module, gtk_list_box_get_type (), "SlingshotAppListBox", &g_define_type_info, 0);
	SlingshotAppListBox_private_offset = sizeof (SlingshotAppListBoxPrivate);
	return slingshot_app_list_box_type_id;
}

static void
_vala_slingshot_app_list_box_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SlingshotAppListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_APP_LIST_BOX, SlingshotAppListBox);
	switch (property_id) {
		case SLINGSHOT_APP_LIST_BOX_DRAGGING_PROPERTY:
		g_value_set_boolean (value, slingshot_app_list_box_get_dragging (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_app_list_box_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SlingshotAppListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_APP_LIST_BOX, SlingshotAppListBox);
	switch (property_id) {
		case SLINGSHOT_APP_LIST_BOX_DRAGGING_PROPERTY:
		slingshot_app_list_box_set_dragging (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

