/* LightHelper.c generated by valac 0.56.17, the Vala compiler
 * generated from LightHelper.vala, do not modify */

/*
 * BrightnessController
 * This file is part of budgie-extras
 *
 * Author: Serdar ŞEN github.com/serdarsen
 *
 * Copyright © 2018 Ubuntu Budgie Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include "brightnesscontroller.h"
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BRIGHTNESS_CONTROLLER_HELPERS_TYPE_BRIGHTNESS_SETTINGS (brightness_controller_helpers_brightness_settings_get_type ())
#define BRIGHTNESS_CONTROLLER_HELPERS_BRIGHTNESS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BRIGHTNESS_CONTROLLER_HELPERS_TYPE_BRIGHTNESS_SETTINGS, BrightnessControllerHelpersBrightnessSettings))
#define BRIGHTNESS_CONTROLLER_HELPERS_IS_BRIGHTNESS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BRIGHTNESS_CONTROLLER_HELPERS_TYPE_BRIGHTNESS_SETTINGS))
#define BRIGHTNESS_CONTROLLER_HELPERS_BRIGHTNESS_SETTINGS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BRIGHTNESS_CONTROLLER_HELPERS_TYPE_BRIGHTNESS_SETTINGS, BrightnessControllerHelpersBrightnessSettingsIface))

typedef struct _BrightnessControllerHelpersBrightnessSettings BrightnessControllerHelpersBrightnessSettings;
typedef struct _BrightnessControllerHelpersBrightnessSettingsIface BrightnessControllerHelpersBrightnessSettingsIface;

#define BRIGHTNESS_CONTROLLER_HELPERS_TYPE_BRIGHTNESS_SETTINGS_PROXY (brightness_controller_helpers_brightness_settings_proxy_get_type ())
typedef GDBusProxy BrightnessControllerHelpersBrightnessSettingsProxy;
typedef GDBusProxyClass BrightnessControllerHelpersBrightnessSettingsProxyClass;
#define _brightness_controller_helpers_subprocess_helper_unref0(var) ((var == NULL) ? NULL : (var = (brightness_controller_helpers_subprocess_helper_unref (var), NULL)))
#define _brightness_controller_helpers_config_helper_unref0(var) ((var == NULL) ? NULL : (var = (brightness_controller_helpers_config_helper_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _brightness_controller_models_flame_unref0(var) ((var == NULL) ? NULL : (var = (brightness_controller_models_flame_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;
#define _brightness_controller_helpers_light_helper_unref0(var) ((var == NULL) ? NULL : (var = (brightness_controller_helpers_light_helper_unref (var), NULL)))
typedef struct _BrightnessControllerHelpersParamSpecLightHelper BrightnessControllerHelpersParamSpecLightHelper;

struct _BrightnessControllerHelpersBrightnessSettingsIface {
	GTypeInterface parent_iface;
	gint (*get_brightness) (BrightnessControllerHelpersBrightnessSettings* self);
	void (*set_brightness) (BrightnessControllerHelpersBrightnessSettings* self, gint value);
};

struct _BrightnessControllerHelpersLightHelperPrivate {
	gboolean _IsAvailable;
	BrightnessControllerHelpersSubprocessHelper* subprocessHelper;
	BrightnessControllerHelpersConfigHelper* configHelper;
	BrightnessControllerHelpersBrightnessSettings* brightness_settings;
};

struct _Block6Data {
	int _ref_count_;
	BrightnessControllerHelpersLightHelper* self;
	gchar** data;
	gint data_length1;
	gint _data_size_;
};

struct _BrightnessControllerHelpersParamSpecLightHelper {
	GParamSpec parent_instance;
};

static GType brightness_controller_helpers_brightness_settings_type_id = 0;
static gint BrightnessControllerHelpersLightHelper_private_offset;
static gpointer brightness_controller_helpers_light_helper_parent_class = NULL;
static GType brightness_controller_helpers_light_helper_type_id = 0;

GType brightness_controller_helpers_brightness_settings_register_type (GTypeModule * module);
VALA_EXTERN GType brightness_controller_helpers_brightness_settings_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType brightness_controller_helpers_brightness_settings_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void brightness_controller_helpers_brightness_settings_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint brightness_controller_helpers_brightness_settings_register_object (void* object,
                                                                         GDBusConnection* connection,
                                                                         const gchar* path,
                                                                         GError** error);
VALA_EXTERN gint brightness_controller_helpers_brightness_settings_get_brightness (BrightnessControllerHelpersBrightnessSettings* self);
VALA_EXTERN void brightness_controller_helpers_brightness_settings_set_brightness (BrightnessControllerHelpersBrightnessSettings* self,
                                                                       gint value);
static void brightness_controller_helpers_brightness_settings_proxy_g_signal (GDBusProxy* proxy,
                                                                       const gchar* sender_name,
                                                                       const gchar* signal_name,
                                                                       GVariant* parameters);
static gint brightness_controller_helpers_brightness_settings_dbus_proxy_get_brightness (BrightnessControllerHelpersBrightnessSettings* self);
static void brightness_controller_helpers_brightness_settings_dbus_proxy_set_brightness (BrightnessControllerHelpersBrightnessSettings* self,
                                                                                  gint value);
static void brightness_controller_helpers_brightness_settings_proxy_brightness_controller_helpers_brightness_settings_interface_init (BrightnessControllerHelpersBrightnessSettingsIface* iface);
static void brightness_controller_helpers_brightness_settings_dbus_interface_method_call (GDBusConnection* connection,
                                                                                   const gchar* sender,
                                                                                   const gchar* object_path,
                                                                                   const gchar* interface_name,
                                                                                   const gchar* method_name,
                                                                                   GVariant* parameters,
                                                                                   GDBusMethodInvocation* invocation,
                                                                                   gpointer user_data);
static GVariant* brightness_controller_helpers_brightness_settings_dbus_interface_get_property (GDBusConnection* connection,
                                                                                         const gchar* sender,
                                                                                         const gchar* object_path,
                                                                                         const gchar* interface_name,
                                                                                         const gchar* property_name,
                                                                                         GError** error,
                                                                                         gpointer user_data);
static GVariant* _dbus_brightness_controller_helpers_brightness_settings_get_brightness (BrightnessControllerHelpersBrightnessSettings* self);
static gboolean brightness_controller_helpers_brightness_settings_dbus_interface_set_property (GDBusConnection* connection,
                                                                                        const gchar* sender,
                                                                                        const gchar* object_path,
                                                                                        const gchar* interface_name,
                                                                                        const gchar* property_name,
                                                                                        GVariant* value,
                                                                                        GError** error,
                                                                                        gpointer user_data);
static void _dbus_brightness_controller_helpers_brightness_settings_set_brightness (BrightnessControllerHelpersBrightnessSettings* self,
                                                                             GVariant* _value);
static void _brightness_controller_helpers_brightness_settings_unregister_object (gpointer user_data);
static void _brightness_controller_models_flame_unref0_ (gpointer var);
static inline void _g_list_free__brightness_controller_models_flame_unref0_ (GList* self);
static void brightness_controller_helpers_light_helper_Load (BrightnessControllerHelpersLightHelper* self);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gdouble brightness_controller_helpers_light_helper_GetMaxBrightness (BrightnessControllerHelpersLightHelper* self,
                                                                     const gchar* name);
static void __lambda7_ (BrightnessControllerHelpersLightHelper* self,
                 BrightnessControllerModelsLight* light);
static void ___lambda7__gfunc (gconstpointer data,
                        gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda6_ (Block6Data* _data6_,
                 BrightnessControllerModelsLight* light);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda6__gfunc (gconstpointer data,
                        gpointer self);
static void brightness_controller_helpers_light_helper_finalize (BrightnessControllerHelpersLightHelper * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusMethodInfo * const _brightness_controller_helpers_brightness_settings_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _brightness_controller_helpers_brightness_settings_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _brightness_controller_helpers_brightness_settings_dbus_property_info_brightness = {-1, "Brightness", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _brightness_controller_helpers_brightness_settings_dbus_property_info[] = {&_brightness_controller_helpers_brightness_settings_dbus_property_info_brightness, NULL};
static const GDBusInterfaceInfo _brightness_controller_helpers_brightness_settings_dbus_interface_info = {-1, "org.gnome.SettingsDaemon.Power.Screen", (GDBusMethodInfo **) (&_brightness_controller_helpers_brightness_settings_dbus_method_info), (GDBusSignalInfo **) (&_brightness_controller_helpers_brightness_settings_dbus_signal_info), (GDBusPropertyInfo **) (&_brightness_controller_helpers_brightness_settings_dbus_property_info), NULL};
static const GDBusInterfaceVTable _brightness_controller_helpers_brightness_settings_dbus_interface_vtable = {brightness_controller_helpers_brightness_settings_dbus_interface_method_call, brightness_controller_helpers_brightness_settings_dbus_interface_get_property, brightness_controller_helpers_brightness_settings_dbus_interface_set_property};

gint
brightness_controller_helpers_brightness_settings_get_brightness (BrightnessControllerHelpersBrightnessSettings* self)
{
	BrightnessControllerHelpersBrightnessSettingsIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = BRIGHTNESS_CONTROLLER_HELPERS_BRIGHTNESS_SETTINGS_GET_INTERFACE (self);
	if (_iface_->get_brightness) {
		return _iface_->get_brightness (self);
	}
	return -1;
}

void
brightness_controller_helpers_brightness_settings_set_brightness (BrightnessControllerHelpersBrightnessSettings* self,
                                                                  gint value)
{
	BrightnessControllerHelpersBrightnessSettingsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BRIGHTNESS_CONTROLLER_HELPERS_BRIGHTNESS_SETTINGS_GET_INTERFACE (self);
	if (_iface_->set_brightness) {
		_iface_->set_brightness (self, value);
	}
}

static void
brightness_controller_helpers_brightness_settings_default_init (BrightnessControllerHelpersBrightnessSettingsIface * iface,
                                                                gpointer iface_data)
{
}

GType
brightness_controller_helpers_brightness_settings_get_type (void)
{
	return brightness_controller_helpers_brightness_settings_type_id;
}

GType
brightness_controller_helpers_brightness_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BrightnessControllerHelpersBrightnessSettingsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) brightness_controller_helpers_brightness_settings_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	brightness_controller_helpers_brightness_settings_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "BrightnessControllerHelpersBrightnessSettings", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (brightness_controller_helpers_brightness_settings_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (brightness_controller_helpers_brightness_settings_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) brightness_controller_helpers_brightness_settings_proxy_get_type);
	g_type_set_qdata (brightness_controller_helpers_brightness_settings_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SettingsDaemon.Power.Screen");
	g_type_set_qdata (brightness_controller_helpers_brightness_settings_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_brightness_controller_helpers_brightness_settings_dbus_interface_info));
	g_type_set_qdata (brightness_controller_helpers_brightness_settings_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) brightness_controller_helpers_brightness_settings_register_object);
	return brightness_controller_helpers_brightness_settings_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (BrightnessControllerHelpersBrightnessSettingsProxy, brightness_controller_helpers_brightness_settings_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (BRIGHTNESS_CONTROLLER_HELPERS_TYPE_BRIGHTNESS_SETTINGS, brightness_controller_helpers_brightness_settings_proxy_brightness_controller_helpers_brightness_settings_interface_init) )
static void
brightness_controller_helpers_brightness_settings_proxy_class_init (BrightnessControllerHelpersBrightnessSettingsProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = brightness_controller_helpers_brightness_settings_proxy_g_signal;
}

static void
brightness_controller_helpers_brightness_settings_proxy_g_signal (GDBusProxy* proxy,
                                                                  const gchar* sender_name,
                                                                  const gchar* signal_name,
                                                                  GVariant* parameters)
{
}

static void
brightness_controller_helpers_brightness_settings_proxy_class_finalize (BrightnessControllerHelpersBrightnessSettingsProxyClass* klass)
{
}

void
brightness_controller_helpers_brightness_settings_proxy_register_dynamic_type (GTypeModule* module)
{
	brightness_controller_helpers_brightness_settings_proxy_register_type (module);
}

static void
brightness_controller_helpers_brightness_settings_proxy_init (BrightnessControllerHelpersBrightnessSettingsProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_brightness_controller_helpers_brightness_settings_dbus_interface_info));
}

static gint
brightness_controller_helpers_brightness_settings_dbus_proxy_get_brightness (BrightnessControllerHelpersBrightnessSettings* self)
{
	GVariant *_inner_reply;
	gint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Brightness");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Power.Screen"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Brightness"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint _tmp1_ = 0;
			return _tmp1_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
brightness_controller_helpers_brightness_settings_dbus_proxy_set_brightness (BrightnessControllerHelpersBrightnessSettings* self,
                                                                             gint value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Power.Screen"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Brightness"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
brightness_controller_helpers_brightness_settings_proxy_brightness_controller_helpers_brightness_settings_interface_init (BrightnessControllerHelpersBrightnessSettingsIface* iface)
{
	iface->get_brightness = brightness_controller_helpers_brightness_settings_dbus_proxy_get_brightness;
	iface->set_brightness = brightness_controller_helpers_brightness_settings_dbus_proxy_set_brightness;
}

static void
brightness_controller_helpers_brightness_settings_dbus_interface_method_call (GDBusConnection* connection,
                                                                              const gchar* sender,
                                                                              const gchar* object_path,
                                                                              const gchar* interface_name,
                                                                              const gchar* method_name,
                                                                              GVariant* parameters,
                                                                              GDBusMethodInvocation* invocation,
                                                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_brightness_controller_helpers_brightness_settings_get_brightness (BrightnessControllerHelpersBrightnessSettings* self)
{
	gint result;
	GVariant* _reply;
	result = brightness_controller_helpers_brightness_settings_get_brightness (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
brightness_controller_helpers_brightness_settings_dbus_interface_get_property (GDBusConnection* connection,
                                                                               const gchar* sender,
                                                                               const gchar* object_path,
                                                                               const gchar* interface_name,
                                                                               const gchar* property_name,
                                                                               GError** error,
                                                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Brightness") == 0) {
		return _dbus_brightness_controller_helpers_brightness_settings_get_brightness (object);
	}
	return NULL;
}

static void
_dbus_brightness_controller_helpers_brightness_settings_set_brightness (BrightnessControllerHelpersBrightnessSettings* self,
                                                                        GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	brightness_controller_helpers_brightness_settings_set_brightness (self, value);
}

static gboolean
brightness_controller_helpers_brightness_settings_dbus_interface_set_property (GDBusConnection* connection,
                                                                               const gchar* sender,
                                                                               const gchar* object_path,
                                                                               const gchar* interface_name,
                                                                               const gchar* property_name,
                                                                               GVariant* value,
                                                                               GError** error,
                                                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Brightness") == 0) {
		_dbus_brightness_controller_helpers_brightness_settings_set_brightness (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
brightness_controller_helpers_brightness_settings_register_object (gpointer object,
                                                                   GDBusConnection* connection,
                                                                   const gchar* path,
                                                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_brightness_controller_helpers_brightness_settings_dbus_interface_info), &_brightness_controller_helpers_brightness_settings_dbus_interface_vtable, data, _brightness_controller_helpers_brightness_settings_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_brightness_controller_helpers_brightness_settings_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
brightness_controller_helpers_light_helper_get_instance_private (BrightnessControllerHelpersLightHelper* self)
{
	return G_STRUCT_MEMBER_P (self, BrightnessControllerHelpersLightHelper_private_offset);
}

static void
_brightness_controller_models_flame_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (brightness_controller_models_flame_unref (var), NULL));
}

static inline void
_g_list_free__brightness_controller_models_flame_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _brightness_controller_models_flame_unref0_);
}

BrightnessControllerHelpersLightHelper*
brightness_controller_helpers_light_helper_construct (GType object_type)
{
	BrightnessControllerHelpersLightHelper* self = NULL;
	BrightnessControllerHelpersSubprocessHelper* _tmp5_;
	BrightnessControllerHelpersConfigHelper* _tmp6_;
	GError* _inner_error0_ = NULL;
	self = (BrightnessControllerHelpersLightHelper*) g_type_create_instance (object_type);
	{
		BrightnessControllerHelpersBrightnessSettings* _tmp0_ = NULL;
		BrightnessControllerHelpersBrightnessSettings* _tmp1_;
		BrightnessControllerHelpersBrightnessSettings* _tmp2_;
		_tmp1_ = (BrightnessControllerHelpersBrightnessSettings*) g_initable_new (BRIGHTNESS_CONTROLLER_HELPERS_TYPE_BRIGHTNESS_SETTINGS_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.gnome.SettingsDaemon.Power", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SettingsDaemon/Power", "g-interface-name", "org.gnome.SettingsDaemon.Power.Screen", NULL);
		_tmp0_ = (BrightnessControllerHelpersBrightnessSettings*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->brightness_settings);
		self->priv->brightness_settings = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("LightHelper.vala:45: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp5_ = brightness_controller_helpers_subprocess_helper_new ();
	_brightness_controller_helpers_subprocess_helper_unref0 (self->priv->subprocessHelper);
	self->priv->subprocessHelper = _tmp5_;
	_tmp6_ = brightness_controller_helpers_config_helper_new ("budgie-advanced-brightness-controller", "light");
	_brightness_controller_helpers_config_helper_unref0 (self->priv->configHelper);
	self->priv->configHelper = _tmp6_;
	brightness_controller_helpers_light_helper_Load (self);
	return self;
}

BrightnessControllerHelpersLightHelper*
brightness_controller_helpers_light_helper_new (void)
{
	return brightness_controller_helpers_light_helper_construct (BRIGHTNESS_CONTROLLER_HELPERS_TYPE_LIGHT_HELPER);
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
string_to_bool (const gchar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_strcmp0 (self, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gpointer
_brightness_controller_models_flame_ref0 (gpointer self)
{
	return self ? brightness_controller_models_flame_ref (self) : NULL;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
brightness_controller_helpers_light_helper_Load (BrightnessControllerHelpersLightHelper* self)
{
	gchar** retrivedLightNames = NULL;
	gchar** _tmp0_;
	gint retrivedLightNames_length1;
	gint _retrivedLightNames_size_;
	gchar** lightObjects = NULL;
	BrightnessControllerHelpersConfigHelper* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint lightObjects_length1;
	gint _lightObjects_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* lightsString = NULL;
	BrightnessControllerHelpersSubprocessHelper* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar** lightNames = NULL;
	const gchar* _tmp40_;
	gchar** _tmp41_;
	gchar** _tmp42_;
	gint lightNames_length1;
	gint _lightNames_size_;
	gint lightNamesCount = 0;
	gchar** _tmp43_;
	gint _tmp43__length1;
	GList* _tmp80_;
	g_return_if_fail (self != NULL);
	(self->list == NULL) ? NULL : (self->list = (_g_list_free__brightness_controller_models_flame_unref0_ (self->list), NULL));
	self->list = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	retrivedLightNames = _tmp0_;
	retrivedLightNames_length1 = 0;
	_retrivedLightNames_size_ = retrivedLightNames_length1;
	_tmp1_ = self->priv->configHelper;
	_tmp3_ = brightness_controller_helpers_config_helper_Read (_tmp1_, &_tmp2_);
	lightObjects = _tmp3_;
	lightObjects_length1 = _tmp2_;
	_lightObjects_size_ = lightObjects_length1;
	_tmp4_ = lightObjects;
	_tmp4__length1 = lightObjects_length1;
	{
		gchar** obj_collection = NULL;
		gint obj_collection_length1 = 0;
		gint _obj_collection_size_ = 0;
		gint obj_it = 0;
		obj_collection = _tmp4_;
		obj_collection_length1 = _tmp4__length1;
		for (obj_it = 0; obj_it < obj_collection_length1; obj_it = obj_it + 1) {
			gchar* _tmp5_;
			gchar* obj = NULL;
			_tmp5_ = g_strdup (obj_collection[obj_it]);
			obj = _tmp5_;
			{
				gchar** properties = NULL;
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_;
				gint properties_length1;
				gint _properties_size_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				_tmp6_ = obj;
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, " ", 0);
				properties = _tmp8_;
				properties_length1 = _vala_array_length (_tmp7_);
				_properties_size_ = properties_length1;
				_tmp9_ = properties;
				_tmp9__length1 = properties_length1;
				if (_tmp9__length1 > 3) {
					BrightnessControllerModelsLight* light = NULL;
					BrightnessControllerModelsLight* _tmp10_;
					BrightnessControllerModelsLight* _tmp11_;
					gchar** _tmp12_;
					gint _tmp12__length1;
					const gchar* _tmp13_;
					BrightnessControllerModelsLight* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					BrightnessControllerModelsLight* _tmp18_;
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					BrightnessControllerModelsLight* _tmp21_;
					gchar** _tmp22_;
					gint _tmp22__length1;
					const gchar* _tmp23_;
					BrightnessControllerModelsLight* _tmp24_;
					gchar** _tmp25_;
					gint _tmp25__length1;
					const gchar* _tmp26_;
					BrightnessControllerModelsLight* _tmp27_;
					BrightnessControllerModelsLight* _tmp28_;
					_tmp10_ = brightness_controller_models_light_new ();
					light = _tmp10_;
					_tmp11_ = light;
					_tmp12_ = properties;
					_tmp12__length1 = properties_length1;
					_tmp13_ = _tmp12_[0];
					brightness_controller_models_flame_set_Name ((BrightnessControllerModelsFlame*) _tmp11_, _tmp13_);
					_tmp14_ = light;
					_tmp15_ = brightness_controller_models_flame_get_Name ((BrightnessControllerModelsFlame*) _tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strdup (_tmp16_);
					_vala_array_add3 (&retrivedLightNames, &retrivedLightNames_length1, &_retrivedLightNames_size_, _tmp17_);
					_tmp18_ = light;
					_tmp19_ = properties;
					_tmp19__length1 = properties_length1;
					_tmp20_ = _tmp19_[1];
					brightness_controller_models_flame_set_MaxBrightness ((BrightnessControllerModelsFlame*) _tmp18_, g_ascii_strtod (_tmp20_, NULL));
					_tmp21_ = light;
					_tmp22_ = properties;
					_tmp22__length1 = properties_length1;
					_tmp23_ = _tmp22_[2];
					brightness_controller_models_flame_set_Brightness ((BrightnessControllerModelsFlame*) _tmp21_, g_ascii_strtod (_tmp23_, NULL));
					_tmp24_ = light;
					_tmp25_ = properties;
					_tmp25__length1 = properties_length1;
					_tmp26_ = _tmp25_[3];
					brightness_controller_models_flame_set_IsActive ((BrightnessControllerModelsFlame*) _tmp24_, string_to_bool (_tmp26_));
					_tmp27_ = light;
					_tmp28_ = _brightness_controller_models_flame_ref0 (_tmp27_);
					self->list = g_list_append (self->list, _tmp28_);
					_brightness_controller_models_flame_unref0 (light);
				}
				properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (obj);
			}
		}
	}
	_tmp29_ = self->priv->subprocessHelper;
	_tmp30_ = g_strdup ("ls");
	_tmp31_ = g_strdup ("/sys/class/backlight");
	_tmp32_ = g_new0 (gchar*, 2 + 1);
	_tmp32_[0] = _tmp30_;
	_tmp32_[1] = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp33__length1 = 2;
	_tmp34_ = brightness_controller_helpers_subprocess_helper_RunAndGetResult (_tmp29_, _tmp33_, (gint) 2);
	_tmp35_ = _tmp34_;
	_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
	lightsString = _tmp35_;
	_tmp36_ = lightsString;
	_tmp37_ = g_strstrip (_tmp36_);
	_tmp38_ = g_strdup (_tmp37_);
	_g_free0 (lightsString);
	lightsString = _tmp38_;
	_tmp39_ = lightsString;
	if (g_strcmp0 (_tmp39_, "") == 0) {
		_g_free0 (lightsString);
		lightObjects = (_vala_array_free (lightObjects, lightObjects_length1, (GDestroyNotify) g_free), NULL);
		retrivedLightNames = (_vala_array_free (retrivedLightNames, retrivedLightNames_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp40_ = lightsString;
	_tmp42_ = _tmp41_ = g_strsplit (_tmp40_, "\n", 0);
	lightNames = _tmp42_;
	lightNames_length1 = _vala_array_length (_tmp41_);
	_lightNames_size_ = lightNames_length1;
	lightNamesCount = 0;
	_tmp43_ = lightNames;
	_tmp43__length1 = lightNames_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp43_;
		name_collection_length1 = _tmp43__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp44_;
			gchar* name = NULL;
			_tmp44_ = g_strdup (name_collection[name_it]);
			name = _tmp44_;
			{
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
				gboolean _tmp48_ = FALSE;
				const gchar* _tmp49_;
				_tmp45_ = name;
				_tmp46_ = g_strstrip (_tmp45_);
				_tmp47_ = g_strdup (_tmp46_);
				_g_free0 (name);
				name = _tmp47_;
				_tmp49_ = name;
				if (g_strcmp0 (_tmp49_, "") != 0) {
					gchar** _tmp50_;
					gint _tmp50__length1;
					const gchar* _tmp51_;
					_tmp50_ = retrivedLightNames;
					_tmp50__length1 = retrivedLightNames_length1;
					_tmp51_ = name;
					_tmp48_ = !g_strv_contains (_tmp50_, _tmp51_);
				} else {
					_tmp48_ = FALSE;
				}
				if (_tmp48_) {
					BrightnessControllerModelsLight* light = NULL;
					BrightnessControllerModelsLight* _tmp52_;
					BrightnessControllerModelsLight* _tmp53_;
					const gchar* _tmp54_;
					BrightnessControllerModelsLight* _tmp55_;
					const gchar* _tmp56_;
					BrightnessControllerModelsLight* _tmp57_;
					const gchar* _tmp58_;
					BrightnessControllerModelsLight* _tmp61_;
					BrightnessControllerModelsLight* _tmp62_;
					BrightnessControllerModelsLight* _tmp63_;
					const gchar* _tmp64_;
					const gchar* _tmp65_;
					BrightnessControllerModelsLight* _tmp66_;
					gchar* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					BrightnessControllerModelsLight* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					BrightnessControllerModelsLight* _tmp74_;
					gboolean _tmp75_;
					gboolean _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					gint _tmp79_;
					_tmp52_ = brightness_controller_models_light_new ();
					light = _tmp52_;
					_tmp53_ = light;
					_tmp54_ = name;
					brightness_controller_models_flame_set_Name ((BrightnessControllerModelsFlame*) _tmp53_, _tmp54_);
					_tmp55_ = light;
					_tmp56_ = name;
					brightness_controller_models_flame_set_MaxBrightness ((BrightnessControllerModelsFlame*) _tmp55_, brightness_controller_helpers_light_helper_GetMaxBrightness (self, _tmp56_));
					_tmp57_ = light;
					_tmp58_ = name;
					brightness_controller_models_flame_set_Brightness ((BrightnessControllerModelsFlame*) _tmp57_, brightness_controller_helpers_light_helper_GetBrightness (self, _tmp58_));
					if (lightNamesCount == 0) {
						BrightnessControllerModelsLight* _tmp59_;
						_tmp59_ = light;
						brightness_controller_models_flame_set_IsActive ((BrightnessControllerModelsFlame*) _tmp59_, TRUE);
					} else {
						BrightnessControllerModelsLight* _tmp60_;
						_tmp60_ = light;
						brightness_controller_models_flame_set_IsActive ((BrightnessControllerModelsFlame*) _tmp60_, FALSE);
					}
					_tmp61_ = light;
					_tmp62_ = _brightness_controller_models_flame_ref0 (_tmp61_);
					self->list = g_list_append (self->list, _tmp62_);
					_tmp63_ = light;
					_tmp64_ = brightness_controller_models_flame_get_Name ((BrightnessControllerModelsFlame*) _tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = light;
					_tmp67_ = brightness_controller_models_light_get_MaxBrightnessText (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = _tmp68_;
					_tmp70_ = light;
					_tmp71_ = brightness_controller_models_light_get_BrightnessText (_tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = _tmp72_;
					_tmp74_ = light;
					_tmp75_ = brightness_controller_models_flame_get_IsActive ((BrightnessControllerModelsFlame*) _tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = bool_to_string (_tmp76_);
					_tmp78_ = _tmp77_;
					g_print ("Load Lights From Device: %s, %s, %s, %s \n", _tmp65_, _tmp69_, _tmp73_, _tmp78_);
					_g_free0 (_tmp78_);
					_g_free0 (_tmp73_);
					_g_free0 (_tmp69_);
					_tmp79_ = lightNamesCount;
					lightNamesCount = _tmp79_ + 1;
					_brightness_controller_models_flame_unref0 (light);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp80_ = self->list;
	if (g_list_length (_tmp80_) > ((guint) 0)) {
		brightness_controller_helpers_light_helper_set_IsAvailable (self, TRUE);
	} else {
		guint lightListLength = 0U;
		GList* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		g_print ("is not available");
		brightness_controller_helpers_light_helper_set_IsAvailable (self, FALSE);
		_tmp81_ = self->list;
		lightListLength = g_list_length (_tmp81_);
		_tmp82_ = g_strdup_printf ("%u", lightListLength);
		_tmp83_ = _tmp82_;
		_tmp84_ = g_strconcat ("Light is not available Number of Lights: ", _tmp83_, ")\n", NULL);
		_tmp85_ = _tmp84_;
		g_message ("LightHelper.vala:124: %s", _tmp85_);
		_g_free0 (_tmp85_);
		_g_free0 (_tmp83_);
	}
	lightNames = (_vala_array_free (lightNames, lightNames_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (lightsString);
	lightObjects = (_vala_array_free (lightObjects, lightObjects_length1, (GDestroyNotify) g_free), NULL);
	retrivedLightNames = (_vala_array_free (retrivedLightNames, retrivedLightNames_length1, (GDestroyNotify) g_free), NULL);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gdouble
brightness_controller_helpers_light_helper_GetMaxBrightness (BrightnessControllerHelpersLightHelper* self,
                                                             const gchar* name)
{
	BrightnessControllerHelpersSubprocessHelper* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gdouble _tmp8_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (name != NULL, 0.0);
	_tmp0_ = self->priv->subprocessHelper;
	_tmp1_ = g_strdup ("cat");
	_tmp2_ = string_to_string (name);
	_tmp3_ = g_strconcat ("/sys/class/backlight/", _tmp2_, "/max_brightness", NULL);
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = brightness_controller_helpers_subprocess_helper_RunAndGetResult (_tmp0_, _tmp5_, (gint) 2);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_ascii_strtod (_tmp7_, NULL);
	_g_free0 (_tmp7_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp8_;
	return result;
}

gdouble
brightness_controller_helpers_light_helper_GetBrightness (BrightnessControllerHelpersLightHelper* self,
                                                          const gchar* name)
{
	BrightnessControllerHelpersSubprocessHelper* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gdouble _tmp8_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (name != NULL, 0.0);
	_tmp0_ = self->priv->subprocessHelper;
	_tmp1_ = g_strdup ("cat");
	_tmp2_ = string_to_string (name);
	_tmp3_ = g_strconcat ("/sys/class/backlight/", _tmp2_, "/brightness", NULL);
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	_tmp6_ = brightness_controller_helpers_subprocess_helper_RunAndGetResult (_tmp0_, _tmp5_, (gint) 2);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_ascii_strtod (_tmp7_, NULL);
	_g_free0 (_tmp7_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp8_;
	return result;
}

void
brightness_controller_helpers_light_helper_SetBrightness (BrightnessControllerHelpersLightHelper* self,
                                                          gint brightness_percentage)
{
	BrightnessControllerHelpersBrightnessSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->brightness_settings;
	brightness_controller_helpers_brightness_settings_set_brightness (_tmp0_, brightness_percentage);
	brightness_controller_helpers_light_helper_Save (self);
}

static void
__lambda7_ (BrightnessControllerHelpersLightHelper* self,
            BrightnessControllerModelsLight* light)
{
	g_return_if_fail (light != NULL);
	brightness_controller_models_flame_set_IsActive ((BrightnessControllerModelsFlame*) light, FALSE);
}

static void
___lambda7__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda7_ ((BrightnessControllerHelpersLightHelper*) self, (BrightnessControllerModelsLight*) data);
}

void
brightness_controller_helpers_light_helper_SetActive (BrightnessControllerHelpersLightHelper* self,
                                                      BrightnessControllerModelsLight* light)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (light != NULL);
	_tmp0_ = self->list;
	g_list_foreach (_tmp0_, ___lambda7__gfunc, self);
	brightness_controller_models_flame_set_IsActive ((BrightnessControllerModelsFlame*) light, TRUE);
	brightness_controller_helpers_light_helper_Save (self);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BrightnessControllerHelpersLightHelper* self;
		self = _data6_->self;
		_data6_->data = (_vala_array_free (_data6_->data, _data6_->data_length1, (GDestroyNotify) g_free), NULL);
		_brightness_controller_helpers_light_helper_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda6_ (Block6Data* _data6_,
            BrightnessControllerModelsLight* light)
{
	BrightnessControllerHelpersLightHelper* self;
	gchar* name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* maxBrightness = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* brightness = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean isActive = FALSE;
	gboolean _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	self = _data6_->self;
	g_return_if_fail (light != NULL);
	_tmp0_ = brightness_controller_models_flame_get_Name ((BrightnessControllerModelsFlame*) light);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = brightness_controller_models_light_get_MaxBrightnessText (light);
	_tmp4_ = _tmp3_;
	maxBrightness = _tmp4_;
	_tmp5_ = brightness_controller_models_light_get_BrightnessText (light);
	_tmp6_ = _tmp5_;
	brightness = _tmp6_;
	_tmp7_ = brightness_controller_models_flame_get_IsActive ((BrightnessControllerModelsFlame*) light);
	_tmp8_ = _tmp7_;
	isActive = _tmp8_;
	_tmp9_ = string_to_string (name);
	_tmp10_ = string_to_string (maxBrightness);
	_tmp11_ = string_to_string (brightness);
	_tmp12_ = bool_to_string (isActive);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp9_, " ", _tmp10_, " ", _tmp11_, " ", _tmp13_, NULL);
	_vala_array_add4 (&_data6_->data, &_data6_->data_length1, &_data6_->_data_size_, _tmp14_);
	_g_free0 (_tmp13_);
	_g_free0 (brightness);
	_g_free0 (maxBrightness);
	_g_free0 (name);
}

static void
___lambda6__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda6_ (self, (BrightnessControllerModelsLight*) data);
}

void
brightness_controller_helpers_light_helper_Save (BrightnessControllerHelpersLightHelper* self)
{
	Block6Data* _data6_;
	gchar** _tmp0_;
	GList* _tmp1_;
	BrightnessControllerHelpersConfigHelper* _tmp2_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = brightness_controller_helpers_light_helper_ref (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data6_->data = _tmp0_;
	_data6_->data_length1 = 0;
	_data6_->_data_size_ = _data6_->data_length1;
	_tmp1_ = self->list;
	g_list_foreach (_tmp1_, ___lambda6__gfunc, _data6_);
	_tmp2_ = self->priv->configHelper;
	brightness_controller_helpers_config_helper_Write (_tmp2_, _data6_->data, (gint) _data6_->data_length1);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

gboolean
brightness_controller_helpers_light_helper_get_IsAvailable (BrightnessControllerHelpersLightHelper* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_IsAvailable;
	return result;
}

void
brightness_controller_helpers_light_helper_set_IsAvailable (BrightnessControllerHelpersLightHelper* self,
                                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_IsAvailable = value;
}

static void
brightness_controller_helpers_value_light_helper_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
brightness_controller_helpers_value_light_helper_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		brightness_controller_helpers_light_helper_unref (value->data[0].v_pointer);
	}
}

static void
brightness_controller_helpers_value_light_helper_copy_value (const GValue* src_value,
                                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = brightness_controller_helpers_light_helper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
brightness_controller_helpers_value_light_helper_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
brightness_controller_helpers_value_light_helper_collect_value (GValue* value,
                                                                guint n_collect_values,
                                                                GTypeCValue* collect_values,
                                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BrightnessControllerHelpersLightHelper * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = brightness_controller_helpers_light_helper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
brightness_controller_helpers_value_light_helper_lcopy_value (const GValue* value,
                                                              guint n_collect_values,
                                                              GTypeCValue* collect_values,
                                                              guint collect_flags)
{
	BrightnessControllerHelpersLightHelper ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = brightness_controller_helpers_light_helper_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
brightness_controller_helpers_param_spec_light_helper (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags)
{
	BrightnessControllerHelpersParamSpecLightHelper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_LIGHT_HELPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
brightness_controller_helpers_value_get_light_helper (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_LIGHT_HELPER), NULL);
	return value->data[0].v_pointer;
}

void
brightness_controller_helpers_value_set_light_helper (GValue* value,
                                                      gpointer v_object)
{
	BrightnessControllerHelpersLightHelper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_LIGHT_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_LIGHT_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		brightness_controller_helpers_light_helper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		brightness_controller_helpers_light_helper_unref (old);
	}
}

void
brightness_controller_helpers_value_take_light_helper (GValue* value,
                                                       gpointer v_object)
{
	BrightnessControllerHelpersLightHelper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_LIGHT_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_LIGHT_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		brightness_controller_helpers_light_helper_unref (old);
	}
}

static void
brightness_controller_helpers_light_helper_class_init (BrightnessControllerHelpersLightHelperClass * klass,
                                                       gpointer klass_data)
{
	brightness_controller_helpers_light_helper_parent_class = g_type_class_peek_parent (klass);
	((BrightnessControllerHelpersLightHelperClass *) klass)->finalize = brightness_controller_helpers_light_helper_finalize;
	g_type_class_adjust_private_offset (klass, &BrightnessControllerHelpersLightHelper_private_offset);
}

static void
brightness_controller_helpers_light_helper_instance_init (BrightnessControllerHelpersLightHelper * self,
                                                          gpointer klass)
{
	self->priv = brightness_controller_helpers_light_helper_get_instance_private (self);
	self->ref_count = 1;
}

static void
brightness_controller_helpers_light_helper_finalize (BrightnessControllerHelpersLightHelper * obj)
{
	BrightnessControllerHelpersLightHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BRIGHTNESS_CONTROLLER_HELPERS_TYPE_LIGHT_HELPER, BrightnessControllerHelpersLightHelper);
	g_signal_handlers_destroy (self);
	(self->list == NULL) ? NULL : (self->list = (_g_list_free__brightness_controller_models_flame_unref0_ (self->list), NULL));
	_brightness_controller_helpers_subprocess_helper_unref0 (self->priv->subprocessHelper);
	_brightness_controller_helpers_config_helper_unref0 (self->priv->configHelper);
	_g_object_unref0 (self->priv->brightness_settings);
}

/**
 * LightHelper is a helper to work with
 * GNOME/gnome-settings-daemon gsd-backlight-helper
 *
 */
GType
brightness_controller_helpers_light_helper_get_type (void)
{
	return brightness_controller_helpers_light_helper_type_id;
}

GType
brightness_controller_helpers_light_helper_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { brightness_controller_helpers_value_light_helper_init, brightness_controller_helpers_value_light_helper_free_value, brightness_controller_helpers_value_light_helper_copy_value, brightness_controller_helpers_value_light_helper_peek_pointer, "p", brightness_controller_helpers_value_light_helper_collect_value, "p", brightness_controller_helpers_value_light_helper_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BrightnessControllerHelpersLightHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) brightness_controller_helpers_light_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BrightnessControllerHelpersLightHelper), 0, (GInstanceInitFunc) brightness_controller_helpers_light_helper_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	brightness_controller_helpers_light_helper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BrightnessControllerHelpersLightHelper", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BrightnessControllerHelpersLightHelper_private_offset = sizeof (BrightnessControllerHelpersLightHelperPrivate);
	return brightness_controller_helpers_light_helper_type_id;
}

gpointer
brightness_controller_helpers_light_helper_ref (gpointer instance)
{
	BrightnessControllerHelpersLightHelper * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
brightness_controller_helpers_light_helper_unref (gpointer instance)
{
	BrightnessControllerHelpersLightHelper * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BRIGHTNESS_CONTROLLER_HELPERS_LIGHT_HELPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

