/* ModemInterface.c generated by valac 0.56.17, the Vala compiler
 * generated from ModemInterface.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include "networkapplet.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <NetworkManager.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_MODEM_INTERFACE_0_PROPERTY,
	NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY,
	NETWORK_MODEM_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_modem_interface_properties[NETWORK_MODEM_INTERFACE_NUM_PROPERTIES];
typedef enum  {
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UNKNOWN = 0,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_POTS = 1 << 0,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM = 1 << 1,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM_COMPACT = 1 << 2,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GPRS = 1 << 3,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EDGE = 1 << 4,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UMTS = 1 << 5,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSDPA = 1 << 6,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSUPA = 1 << 7,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA = 1 << 8,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA_PLUS = 1 << 9,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_1XRTT = 1 << 10,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDO0 = 1 << 11,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOA = 1 << 12,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOB = 1 << 13,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_LTE = 1 << 14,
	NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_ANY = 0xFFFFFFFFLL
} NetworkModemInterfaceModemAccessTechnology;

#define NETWORK_MODEM_INTERFACE_TYPE_MODEM_ACCESS_TECHNOLOGY (network_modem_interface_modem_access_technology_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NetworkModemInterfacePrepareData NetworkModemInterfacePrepareData;

struct _NetworkModemInterfacePrivate {
	NetworkWidgetsSwitch* modem_item;
	GDBusObjectManagerClient* modem_manager;
	guint32 _signal_quality;
};

struct _Block4Data {
	int _ref_count_;
	NetworkModemInterface* self;
	NMClient* nm_client;
};

struct _NetworkModemInterfacePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NetworkModemInterface* self;
	GDBusObjectManagerClient* _tmp0_;
	GDBusObjectManagerClient* _tmp1_;
	GDBusObjectManagerClient* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GDBusObjectManagerClient* _tmp5_;
	GError* _inner_error0_;
};

static gint NetworkModemInterface_private_offset;
static gpointer network_modem_interface_parent_class = NULL;
static GType network_modem_interface_type_id = 0;

static GType network_modem_interface_modem_access_technology_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda19_ (NetworkModemInterface* self);
static void ___lambda19__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda20_ (Block4Data* _data4_);
static void ____lambda21_ (NetworkModemInterface* self);
static void _____lambda21__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void ___lambda20__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda22_ (NetworkModemInterface* self);
static void ___lambda22__nm_device_state_changed (NMDevice* _sender,
                                           guint new_state,
                                           guint old_state,
                                           guint reason,
                                           gpointer self);
static void network_modem_interface_real_update (NetworkWidgetNMInterface* base);
static NetworkState network_modem_interface_strength_to_state (NetworkModemInterface* self,
                                                        guint32 strength);
static gchar* network_modem_interface_access_technology_to_string (NetworkModemInterface* self,
                                                            NetworkModemInterfaceModemAccessTechnology tech);
static void network_modem_interface_device_properties_changed (NetworkModemInterface* self,
                                                        GVariant* changed);
static void network_modem_interface_set_signal_quality (NetworkModemInterface* self,
                                                 guint32 value);
static void network_modem_interface_prepare_data_free (gpointer _data);
static gboolean network_modem_interface_prepare_co (NetworkModemInterfacePrepareData* _data_);
static void network_modem_interface_prepare_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void __lambda23_ (NetworkModemInterface* self,
                  GDBusObjectProxy* obj_proxy,
                  GDBusProxy* interface_proxy,
                  GVariant* changed,
                  gchar** invalidated);
static void ___lambda23__g_dbus_object_manager_client_interface_proxy_properties_changed (GDBusObjectManagerClient* _sender,
                                                                                   GDBusObjectProxy* object_proxy,
                                                                                   GDBusProxy* interface_proxy,
                                                                                   GVariant* changed_properties,
                                                                                   gchar** invalidated_properties,
                                                                                   gpointer self);
static void network_modem_interface_finalize (GObject * obj);
static void _vala_network_modem_interface_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_network_modem_interface_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
network_modem_interface_get_instance_private (NetworkModemInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkModemInterface_private_offset);
}

static GType
network_modem_interface_modem_access_technology_get_type_once (void)
{
	static const GEnumValue values[] = {{NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UNKNOWN, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UNKNOWN", "unknown"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_POTS, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_POTS", "pots"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM", "gsm"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM_COMPACT, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM_COMPACT", "gsm-compact"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GPRS, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GPRS", "gprs"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EDGE, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EDGE", "edge"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UMTS, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UMTS", "umts"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSDPA, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSDPA", "hsdpa"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSUPA, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSUPA", "hsupa"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA", "hspa"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA_PLUS, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA_PLUS", "hspa-plus"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_1XRTT, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_1XRTT", "1xrtt"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDO0, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDO0", "evdo0"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOA, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOA", "evdoa"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOB, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOB", "evdob"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_LTE, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_LTE", "lte"}, {NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_ANY, "NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_ANY", "any"}, {0, NULL, NULL}};
	GType network_modem_interface_modem_access_technology_type_id;
	network_modem_interface_modem_access_technology_type_id = g_enum_register_static ("NetworkModemInterfaceModemAccessTechnology", values);
	return network_modem_interface_modem_access_technology_type_id;
}

static GType
network_modem_interface_modem_access_technology_get_type (void)
{
	static volatile gsize network_modem_interface_modem_access_technology_type_id__once = 0;
	if (g_once_init_enter (&network_modem_interface_modem_access_technology_type_id__once)) {
		GType network_modem_interface_modem_access_technology_type_id;
		network_modem_interface_modem_access_technology_type_id = network_modem_interface_modem_access_technology_get_type_once ();
		g_once_init_leave (&network_modem_interface_modem_access_technology_type_id__once, network_modem_interface_modem_access_technology_type_id);
	}
	return network_modem_interface_modem_access_technology_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		NetworkModemInterface* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->nm_client);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda19_ (NetworkModemInterface* self)
{
	NetworkWidgetsSwitch* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->modem_item;
	_tmp1_ = network_widget_nm_interface_get_display_title ((NetworkWidgetNMInterface*) self);
	_tmp2_ = _tmp1_;
	network_widgets_switch_set_caption (_tmp0_, _tmp2_);
}

static void
___lambda19__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda19_ ((NetworkModemInterface*) self);
}

static void
____lambda21_ (NetworkModemInterface* self)
{
	g_debug ("ModemInterface.vala:71: Successfully disconnected.");
}

static void
_____lambda21__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda21_ ((NetworkModemInterface*) self);
	g_object_unref (self);
}

static void
__lambda20_ (Block4Data* _data4_)
{
	NetworkModemInterface* self;
	gboolean _tmp0_ = FALSE;
	NetworkWidgetsSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data4_->self;
	_tmp1_ = self->priv->modem_item;
	_tmp2_ = network_widgets_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		NMDevice* _tmp4_;
		NMDeviceState _tmp5_;
		NMDeviceState _tmp6_;
		_tmp4_ = ((NetworkWidgetNMInterface*) self)->device;
		_tmp5_ = nm_device_get_state (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == NM_DEVICE_STATE_DISCONNECTED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NMDevice* _tmp7_;
		_tmp7_ = ((NetworkWidgetNMInterface*) self)->device;
		nm_client_activate_connection_async (_data4_->nm_client, NULL, _tmp7_, NULL, NULL, NULL, NULL);
	} else {
		gboolean _tmp8_ = FALSE;
		NetworkWidgetsSwitch* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->modem_item;
		_tmp10_ = network_widgets_switch_get_active (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			NMDevice* _tmp12_;
			NMDeviceState _tmp13_;
			NMDeviceState _tmp14_;
			_tmp12_ = ((NetworkWidgetNMInterface*) self)->device;
			_tmp13_ = nm_device_get_state (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = _tmp14_ == NM_DEVICE_STATE_ACTIVATED;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			NMDevice* _tmp15_;
			_tmp15_ = ((NetworkWidgetNMInterface*) self)->device;
			nm_device_disconnect_async (_tmp15_, NULL, _____lambda21__gasync_ready_callback, g_object_ref (self));
		}
	}
}

static void
___lambda20__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda20_ (self);
}

static void
__lambda22_ (NetworkModemInterface* self)
{
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
}

static void
___lambda22__nm_device_state_changed (NMDevice* _sender,
                                      guint new_state,
                                      guint old_state,
                                      guint reason,
                                      gpointer self)
{
	__lambda22_ ((NetworkModemInterface*) self);
}

NetworkModemInterface*
network_modem_interface_construct (GType object_type,
                                   NMClient* nm_client,
                                   NMDevice* _device)
{
	NetworkModemInterface * self = NULL;
	Block4Data* _data4_;
	NMClient* _tmp0_;
	NMDevice* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	NetworkWidgetsSwitch* _tmp4_;
	NetworkWidgetsSwitch* _tmp5_;
	GtkStyleContext* _tmp6_;
	NetworkWidgetsSwitch* _tmp7_;
	NetworkWidgetsSwitch* _tmp8_;
	NMDevice* _tmp9_;
	g_return_val_if_fail (nm_client != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (nm_client);
	_g_object_unref0 (_data4_->nm_client);
	_data4_->nm_client = _tmp0_;
	self = (NetworkModemInterface*) network_abstract_modem_interface_construct (object_type);
	_data4_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (_device);
	_g_object_unref0 (((NetworkWidgetNMInterface*) self)->device);
	((NetworkWidgetNMInterface*) self)->device = _tmp1_;
	_tmp2_ = network_widget_nm_interface_get_display_title ((NetworkWidgetNMInterface*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = network_widgets_switch_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->modem_item);
	self->priv->modem_item = _tmp4_;
	g_signal_connect_object ((GObject*) self, "notify::display-title", (GCallback) ___lambda19__g_object_notify, self, 0);
	_tmp5_ = self->priv->modem_item;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, "h4");
	_tmp7_ = self->priv->modem_item;
	g_signal_connect_data ((GObject*) _tmp7_, "notify::active", (GCallback) ___lambda20__g_object_notify, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp8_ = self->priv->modem_item;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp8_);
	_tmp9_ = ((NetworkWidgetNMInterface*) self)->device;
	g_signal_connect_object (_tmp9_, "state-changed", (GCallback) ___lambda22__nm_device_state_changed, self, 0);
	network_modem_interface_prepare (self, NULL, NULL);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return self;
}

NetworkModemInterface*
network_modem_interface_new (NMClient* nm_client,
                             NMDevice* _device)
{
	return network_modem_interface_construct (NETWORK_TYPE_MODEM_INTERFACE, nm_client, _device);
}

static void
network_modem_interface_real_update (NetworkWidgetNMInterface* base)
{
	NetworkModemInterface * self;
	NMDevice* _tmp0_;
	NMDeviceState _tmp1_;
	NMDeviceState _tmp2_;
	self = (NetworkModemInterface*) base;
	_tmp0_ = ((NetworkWidgetNMInterface*) self)->device;
	_tmp1_ = nm_device_get_state (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case NM_DEVICE_STATE_UNKNOWN:
		case NM_DEVICE_STATE_UNMANAGED:
		case NM_DEVICE_STATE_UNAVAILABLE:
		case NM_DEVICE_STATE_FAILED:
		{
			NetworkWidgetsSwitch* _tmp3_;
			NetworkWidgetsSwitch* _tmp4_;
			_tmp3_ = self->priv->modem_item;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
			_tmp4_ = self->priv->modem_item;
			network_widgets_switch_set_active (_tmp4_, FALSE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_FAILED_MOBILE);
			break;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		case NM_DEVICE_STATE_DEACTIVATING:
		{
			NetworkWidgetsSwitch* _tmp5_;
			NetworkWidgetsSwitch* _tmp6_;
			_tmp5_ = self->priv->modem_item;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
			_tmp6_ = self->priv->modem_item;
			network_widgets_switch_set_active (_tmp6_, FALSE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_FAILED_MOBILE);
			break;
		}
		case NM_DEVICE_STATE_PREPARE:
		case NM_DEVICE_STATE_CONFIG:
		case NM_DEVICE_STATE_NEED_AUTH:
		case NM_DEVICE_STATE_IP_CONFIG:
		case NM_DEVICE_STATE_IP_CHECK:
		case NM_DEVICE_STATE_SECONDARIES:
		{
			NetworkWidgetsSwitch* _tmp7_;
			NetworkWidgetsSwitch* _tmp8_;
			_tmp7_ = self->priv->modem_item;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, TRUE);
			_tmp8_ = self->priv->modem_item;
			network_widgets_switch_set_active (_tmp8_, TRUE);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTING_MOBILE);
			break;
		}
		case NM_DEVICE_STATE_ACTIVATED:
		{
			NetworkWidgetsSwitch* _tmp9_;
			NetworkWidgetsSwitch* _tmp10_;
			guint32 _tmp11_;
			guint32 _tmp12_;
			_tmp9_ = self->priv->modem_item;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, TRUE);
			_tmp10_ = self->priv->modem_item;
			network_widgets_switch_set_active (_tmp10_, TRUE);
			_tmp11_ = network_modem_interface_get_signal_quality (self);
			_tmp12_ = _tmp11_;
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, network_modem_interface_strength_to_state (self, _tmp12_));
			break;
		}
		default:
		break;
	}
}

static NetworkState
network_modem_interface_strength_to_state (NetworkModemInterface* self,
                                           guint32 strength)
{
	NetworkState result;
	g_return_val_if_fail (self != NULL, 0);
	if (strength < ((guint32) 30)) {
		result = NETWORK_STATE_CONNECTED_MOBILE_WEAK;
		return result;
	} else {
		if (strength < ((guint32) 55)) {
			result = NETWORK_STATE_CONNECTED_MOBILE_OK;
			return result;
		} else {
			if (strength < ((guint32) 80)) {
				result = NETWORK_STATE_CONNECTED_MOBILE_GOOD;
				return result;
			} else {
				result = NETWORK_STATE_CONNECTED_MOBILE_EXCELLENT;
				return result;
			}
		}
	}
}

static gchar*
network_modem_interface_access_technology_to_string (NetworkModemInterface* self,
                                                     NetworkModemInterfaceModemAccessTechnology tech)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (tech) {
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UNKNOWN:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_POTS:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_ANY:
		{
			result = NULL;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GSM_COMPACT:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_GPRS:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_1XRTT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("G");
			result = _tmp0_;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EDGE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("E");
			result = _tmp1_;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_UMTS:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDO0:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOA:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_EVDOB:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("3G");
			result = _tmp2_;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSDPA:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSUPA:
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("H");
			result = _tmp3_;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_HSPA_PLUS:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("H+");
			result = _tmp4_;
			return result;
		}
		case NETWORK_MODEM_INTERFACE_MODEM_ACCESS_TECHNOLOGY_LTE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("LTE");
			result = _tmp5_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

static void
network_modem_interface_device_properties_changed (NetworkModemInterface* self,
                                                   GVariant* changed)
{
	GVariant* signal_variant = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* access_technologies_variant = NULL;
	const GVariantType* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed != NULL);
	_tmp0_ = G_VARIANT_TYPE_TUPLE;
	_tmp1_ = g_variant_lookup_value (changed, "SignalQuality", _tmp0_);
	signal_variant = _tmp1_;
	_tmp2_ = signal_variant;
	if (_tmp2_ != NULL) {
		gboolean recent = FALSE;
		guint32 quality = 0U;
		GVariant* _tmp3_;
		guint32 _tmp4_ = 0U;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = signal_variant;
		g_variant_get (_tmp3_, "(ub)", &_tmp4_, &_tmp5_, NULL);
		quality = _tmp4_;
		recent = _tmp5_;
		network_modem_interface_set_signal_quality (self, quality);
	}
	_tmp6_ = G_VARIANT_TYPE_UINT32;
	_tmp7_ = g_variant_lookup_value (changed, "AccessTechnologies", _tmp6_);
	access_technologies_variant = _tmp7_;
	_tmp8_ = access_technologies_variant;
	if (_tmp8_ != NULL) {
		guint32 access_type = 0U;
		GVariant* _tmp9_;
		guint32 _tmp10_ = 0U;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp9_ = access_technologies_variant;
		g_variant_get (_tmp9_, "u", &_tmp10_, NULL);
		access_type = _tmp10_;
		_tmp11_ = network_modem_interface_access_technology_to_string (self, (NetworkModemInterfaceModemAccessTechnology) access_type);
		_tmp12_ = _tmp11_;
		network_widget_nm_interface_set_extra_info ((NetworkWidgetNMInterface*) self, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_g_variant_unref0 (access_technologies_variant);
	_g_variant_unref0 (signal_variant);
}

static void
network_modem_interface_prepare_data_free (gpointer _data)
{
	NetworkModemInterfacePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (NetworkModemInterfacePrepareData, _data_);
}

void
network_modem_interface_prepare (NetworkModemInterface* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	NetworkModemInterfacePrepareData* _data_;
	NetworkModemInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (NetworkModemInterfacePrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, network_modem_interface_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	network_modem_interface_prepare_co (_data_);
}

void
network_modem_interface_prepare_finish (NetworkModemInterface* self,
                                        GAsyncResult* _res_)
{
	NetworkModemInterfacePrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
network_modem_interface_prepare_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	NetworkModemInterfacePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	network_modem_interface_prepare_co (_data_);
}

static void
__lambda23_ (NetworkModemInterface* self,
             GDBusObjectProxy* obj_proxy,
             GDBusProxy* interface_proxy,
             GVariant* changed,
             gchar** invalidated)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	NMDevice* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (obj_proxy != NULL);
	g_return_if_fail (interface_proxy != NULL);
	g_return_if_fail (changed != NULL);
	g_object_get (interface_proxy, "g-object-path", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = ((NetworkWidgetNMInterface*) self)->device;
	_tmp4_ = nm_device_get_udi (_tmp3_);
	_tmp5_ = g_strcmp0 (_tmp2_, _tmp4_) == 0;
	_g_free0 (_tmp2_);
	if (_tmp5_) {
		network_modem_interface_device_properties_changed (self, changed);
	}
}

static void
___lambda23__g_dbus_object_manager_client_interface_proxy_properties_changed (GDBusObjectManagerClient* _sender,
                                                                              GDBusObjectProxy* object_proxy,
                                                                              GDBusProxy* interface_proxy,
                                                                              GVariant* changed_properties,
                                                                              gchar** invalidated_properties,
                                                                              gpointer self)
{
	__lambda23_ ((NetworkModemInterface*) self, object_proxy, interface_proxy, changed_properties, invalidated_properties);
}

static gboolean
network_modem_interface_prepare_co (NetworkModemInterfacePrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_dbus_object_manager_client_new_for_bus (G_BUS_TYPE_SYSTEM, G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_NONE, "org.freedesktop.ModemManager1", "/org/freedesktop/ModemManager1", NULL, NULL, NULL, NULL, network_modem_interface_prepare_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_dbus_object_manager_client_new_for_bus_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->modem_manager);
		_data_->self->priv->modem_manager = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("ModemInterface.vala:180: Unable to connect to ModemManager1 to check c" \
"ellular internet signal quality: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->modem_manager;
	g_signal_connect_object (_data_->_tmp5_, "interface-proxy-properties-changed", (GCallback) ___lambda23__g_dbus_object_manager_client_interface_proxy_properties_changed, _data_->self, 0);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

guint32
network_modem_interface_get_signal_quality (NetworkModemInterface* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_signal_quality;
	return result;
}

static void
network_modem_interface_set_signal_quality (NetworkModemInterface* self,
                                            guint32 value)
{
	NMDevice* _tmp0_;
	NMDeviceState _tmp1_;
	NMDeviceState _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->_signal_quality = value;
	_tmp0_ = ((NetworkWidgetNMInterface*) self)->device;
	_tmp1_ = nm_device_get_state (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NM_DEVICE_STATE_ACTIVATED) {
		network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, network_modem_interface_strength_to_state (self, value));
	}
	g_object_notify_by_pspec ((GObject *) self, network_modem_interface_properties[NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY]);
}

static void
network_modem_interface_class_init (NetworkModemInterfaceClass * klass,
                                    gpointer klass_data)
{
	network_modem_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkModemInterface_private_offset);
	((NetworkWidgetNMInterfaceClass *) klass)->update = (void (*) (NetworkWidgetNMInterface*)) network_modem_interface_real_update;
	G_OBJECT_CLASS (klass)->get_property = _vala_network_modem_interface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_modem_interface_set_property;
	G_OBJECT_CLASS (klass)->finalize = network_modem_interface_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY, network_modem_interface_properties[NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY] = g_param_spec_uint ("signal-quality", "signal-quality", "signal-quality", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
network_modem_interface_instance_init (NetworkModemInterface * self,
                                       gpointer klass)
{
	self->priv = network_modem_interface_get_instance_private (self);
}

static void
network_modem_interface_finalize (GObject * obj)
{
	NetworkModemInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_MODEM_INTERFACE, NetworkModemInterface);
	_g_object_unref0 (self->priv->modem_item);
	_g_object_unref0 (self->priv->modem_manager);
	G_OBJECT_CLASS (network_modem_interface_parent_class)->finalize (obj);
}

GType
network_modem_interface_get_type (void)
{
	return network_modem_interface_type_id;
}

GType
network_modem_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkModemInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_modem_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkModemInterface), 0, (GInstanceInitFunc) network_modem_interface_instance_init, NULL };
	network_modem_interface_type_id = g_type_module_register_type (module, NETWORK_TYPE_ABSTRACT_MODEM_INTERFACE, "NetworkModemInterface", &g_define_type_info, 0);
	NetworkModemInterface_private_offset = sizeof (NetworkModemInterfacePrivate);
	return network_modem_interface_type_id;
}

static void
_vala_network_modem_interface_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	NetworkModemInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_MODEM_INTERFACE, NetworkModemInterface);
	switch (property_id) {
		case NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY:
		g_value_set_uint (value, network_modem_interface_get_signal_quality (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_modem_interface_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	NetworkModemInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_MODEM_INTERFACE, NetworkModemInterface);
	switch (property_id) {
		case NETWORK_MODEM_INTERFACE_SIGNAL_QUALITY_PROPERTY:
		network_modem_interface_set_signal_quality (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

