// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/authz.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type UserCanCreateOrganizationRepositoryRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanCreateOrganizationRepositoryRequest) Reset() {
	*x = UserCanCreateOrganizationRepositoryRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanCreateOrganizationRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanCreateOrganizationRepositoryRequest) ProtoMessage() {}

func (x *UserCanCreateOrganizationRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanCreateOrganizationRepositoryRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanCreateOrganizationRepositoryRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanCreateOrganizationRepositoryRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanCreateOrganizationRepositoryRequest_builder) Build() *UserCanCreateOrganizationRepositoryRequest {
	m0 := &UserCanCreateOrganizationRepositoryRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanCreateOrganizationRepositoryResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanCreateOrganizationRepositoryResponse) Reset() {
	*x = UserCanCreateOrganizationRepositoryResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanCreateOrganizationRepositoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanCreateOrganizationRepositoryResponse) ProtoMessage() {}

func (x *UserCanCreateOrganizationRepositoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanCreateOrganizationRepositoryResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanCreateOrganizationRepositoryResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanCreateOrganizationRepositoryResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanCreateOrganizationRepositoryResponse_builder) Build() *UserCanCreateOrganizationRepositoryResponse {
	m0 := &UserCanCreateOrganizationRepositoryResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanSeeRepositorySettingsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *UserCanSeeRepositorySettingsRequest) Reset() {
	*x = UserCanSeeRepositorySettingsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeRepositorySettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeRepositorySettingsRequest) ProtoMessage() {}

func (x *UserCanSeeRepositorySettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanSeeRepositorySettingsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *UserCanSeeRepositorySettingsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type UserCanSeeRepositorySettingsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string
}

func (b0 UserCanSeeRepositorySettingsRequest_builder) Build() *UserCanSeeRepositorySettingsRequest {
	m0 := &UserCanSeeRepositorySettingsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type UserCanSeeRepositorySettingsResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanSeeRepositorySettingsResponse) Reset() {
	*x = UserCanSeeRepositorySettingsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeRepositorySettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeRepositorySettingsResponse) ProtoMessage() {}

func (x *UserCanSeeRepositorySettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanSeeRepositorySettingsResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanSeeRepositorySettingsResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanSeeRepositorySettingsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanSeeRepositorySettingsResponse_builder) Build() *UserCanSeeRepositorySettingsResponse {
	m0 := &UserCanSeeRepositorySettingsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanSeeOrganizationSettingsRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanSeeOrganizationSettingsRequest) Reset() {
	*x = UserCanSeeOrganizationSettingsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeOrganizationSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeOrganizationSettingsRequest) ProtoMessage() {}

func (x *UserCanSeeOrganizationSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanSeeOrganizationSettingsRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanSeeOrganizationSettingsRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanSeeOrganizationSettingsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanSeeOrganizationSettingsRequest_builder) Build() *UserCanSeeOrganizationSettingsRequest {
	m0 := &UserCanSeeOrganizationSettingsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanSeeOrganizationSettingsResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanSeeOrganizationSettingsResponse) Reset() {
	*x = UserCanSeeOrganizationSettingsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeOrganizationSettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeOrganizationSettingsResponse) ProtoMessage() {}

func (x *UserCanSeeOrganizationSettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanSeeOrganizationSettingsResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanSeeOrganizationSettingsResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanSeeOrganizationSettingsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanSeeOrganizationSettingsResponse_builder) Build() *UserCanSeeOrganizationSettingsResponse {
	m0 := &UserCanSeeOrganizationSettingsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanAddOrganizationMemberRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanAddOrganizationMemberRequest) Reset() {
	*x = UserCanAddOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanAddOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanAddOrganizationMemberRequest) ProtoMessage() {}

func (x *UserCanAddOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanAddOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanAddOrganizationMemberRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanAddOrganizationMemberRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanAddOrganizationMemberRequest_builder) Build() *UserCanAddOrganizationMemberRequest {
	m0 := &UserCanAddOrganizationMemberRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanAddOrganizationMemberResponse struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_AuthorizedRoles []OrganizationRole     `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *UserCanAddOrganizationMemberResponse) Reset() {
	*x = UserCanAddOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanAddOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanAddOrganizationMemberResponse) ProtoMessage() {}

func (x *UserCanAddOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanAddOrganizationMemberResponse) GetAuthorizedRoles() []OrganizationRole {
	if x != nil {
		return x.xxx_hidden_AuthorizedRoles
	}
	return nil
}

func (x *UserCanAddOrganizationMemberResponse) SetAuthorizedRoles(v []OrganizationRole) {
	x.xxx_hidden_AuthorizedRoles = v
}

type UserCanAddOrganizationMemberResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of roles that the user is authorized to add, empty list means the user is
	// not authorized to add any members.
	AuthorizedRoles []OrganizationRole
}

func (b0 UserCanAddOrganizationMemberResponse_builder) Build() *UserCanAddOrganizationMemberResponse {
	m0 := &UserCanAddOrganizationMemberResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_AuthorizedRoles = b.AuthorizedRoles
	return m0
}

type UserCanUpdateOrganizationMemberRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanUpdateOrganizationMemberRequest) Reset() {
	*x = UserCanUpdateOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanUpdateOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanUpdateOrganizationMemberRequest) ProtoMessage() {}

func (x *UserCanUpdateOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanUpdateOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanUpdateOrganizationMemberRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanUpdateOrganizationMemberRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanUpdateOrganizationMemberRequest_builder) Build() *UserCanUpdateOrganizationMemberRequest {
	m0 := &UserCanUpdateOrganizationMemberRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanUpdateOrganizationMemberResponse struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_AuthorizedRoles []OrganizationRole     `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *UserCanUpdateOrganizationMemberResponse) Reset() {
	*x = UserCanUpdateOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanUpdateOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanUpdateOrganizationMemberResponse) ProtoMessage() {}

func (x *UserCanUpdateOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanUpdateOrganizationMemberResponse) GetAuthorizedRoles() []OrganizationRole {
	if x != nil {
		return x.xxx_hidden_AuthorizedRoles
	}
	return nil
}

func (x *UserCanUpdateOrganizationMemberResponse) SetAuthorizedRoles(v []OrganizationRole) {
	x.xxx_hidden_AuthorizedRoles = v
}

type UserCanUpdateOrganizationMemberResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of roles that the user is authorized to update (from and to), empty list means the user is
	// not authorized to update any members' role.
	AuthorizedRoles []OrganizationRole
}

func (b0 UserCanUpdateOrganizationMemberResponse_builder) Build() *UserCanUpdateOrganizationMemberResponse {
	m0 := &UserCanUpdateOrganizationMemberResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_AuthorizedRoles = b.AuthorizedRoles
	return m0
}

type UserCanRemoveOrganizationMemberRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanRemoveOrganizationMemberRequest) Reset() {
	*x = UserCanRemoveOrganizationMemberRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanRemoveOrganizationMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanRemoveOrganizationMemberRequest) ProtoMessage() {}

func (x *UserCanRemoveOrganizationMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanRemoveOrganizationMemberRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanRemoveOrganizationMemberRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanRemoveOrganizationMemberRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanRemoveOrganizationMemberRequest_builder) Build() *UserCanRemoveOrganizationMemberRequest {
	m0 := &UserCanRemoveOrganizationMemberRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanRemoveOrganizationMemberResponse struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_AuthorizedRoles []OrganizationRole     `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.OrganizationRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *UserCanRemoveOrganizationMemberResponse) Reset() {
	*x = UserCanRemoveOrganizationMemberResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanRemoveOrganizationMemberResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanRemoveOrganizationMemberResponse) ProtoMessage() {}

func (x *UserCanRemoveOrganizationMemberResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanRemoveOrganizationMemberResponse) GetAuthorizedRoles() []OrganizationRole {
	if x != nil {
		return x.xxx_hidden_AuthorizedRoles
	}
	return nil
}

func (x *UserCanRemoveOrganizationMemberResponse) SetAuthorizedRoles(v []OrganizationRole) {
	x.xxx_hidden_AuthorizedRoles = v
}

type UserCanRemoveOrganizationMemberResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of roles that the user is authorized to remove, empty list means the user is
	// not authorized to remove any members.
	AuthorizedRoles []OrganizationRole
}

func (b0 UserCanRemoveOrganizationMemberResponse_builder) Build() *UserCanRemoveOrganizationMemberResponse {
	m0 := &UserCanRemoveOrganizationMemberResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_AuthorizedRoles = b.AuthorizedRoles
	return m0
}

type UserCanDeleteOrganizationRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *UserCanDeleteOrganizationRequest) Reset() {
	*x = UserCanDeleteOrganizationRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteOrganizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteOrganizationRequest) ProtoMessage() {}

func (x *UserCanDeleteOrganizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanDeleteOrganizationRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *UserCanDeleteOrganizationRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type UserCanDeleteOrganizationRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// whether the user is authorized.
	OrganizationId string
}

func (b0 UserCanDeleteOrganizationRequest_builder) Build() *UserCanDeleteOrganizationRequest {
	m0 := &UserCanDeleteOrganizationRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type UserCanDeleteOrganizationResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanDeleteOrganizationResponse) Reset() {
	*x = UserCanDeleteOrganizationResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteOrganizationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteOrganizationResponse) ProtoMessage() {}

func (x *UserCanDeleteOrganizationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanDeleteOrganizationResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanDeleteOrganizationResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanDeleteOrganizationResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanDeleteOrganizationResponse_builder) Build() *UserCanDeleteOrganizationResponse {
	m0 := &UserCanDeleteOrganizationResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanDeleteRepositoryRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *UserCanDeleteRepositoryRequest) Reset() {
	*x = UserCanDeleteRepositoryRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteRepositoryRequest) ProtoMessage() {}

func (x *UserCanDeleteRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanDeleteRepositoryRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *UserCanDeleteRepositoryRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type UserCanDeleteRepositoryRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string
}

func (b0 UserCanDeleteRepositoryRequest_builder) Build() *UserCanDeleteRepositoryRequest {
	m0 := &UserCanDeleteRepositoryRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type UserCanDeleteRepositoryResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanDeleteRepositoryResponse) Reset() {
	*x = UserCanDeleteRepositoryResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteRepositoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteRepositoryResponse) ProtoMessage() {}

func (x *UserCanDeleteRepositoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanDeleteRepositoryResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanDeleteRepositoryResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanDeleteRepositoryResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanDeleteRepositoryResponse_builder) Build() *UserCanDeleteRepositoryResponse {
	m0 := &UserCanDeleteRepositoryResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanDeleteUserRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserCanDeleteUserRequest) Reset() {
	*x = UserCanDeleteUserRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteUserRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteUserRequest) ProtoMessage() {}

func (x *UserCanDeleteUserRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UserCanDeleteUserRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UserCanDeleteUserRequest_builder) Build() *UserCanDeleteUserRequest {
	m0 := &UserCanDeleteUserRequest{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type UserCanDeleteUserResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanDeleteUserResponse) Reset() {
	*x = UserCanDeleteUserResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanDeleteUserResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanDeleteUserResponse) ProtoMessage() {}

func (x *UserCanDeleteUserResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanDeleteUserResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanDeleteUserResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanDeleteUserResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanDeleteUserResponse_builder) Build() *UserCanDeleteUserResponse {
	m0 := &UserCanDeleteUserResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanSeeServerAdminPanelRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UserCanSeeServerAdminPanelRequest) Reset() {
	*x = UserCanSeeServerAdminPanelRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeServerAdminPanelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeServerAdminPanelRequest) ProtoMessage() {}

func (x *UserCanSeeServerAdminPanelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UserCanSeeServerAdminPanelRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UserCanSeeServerAdminPanelRequest_builder) Build() *UserCanSeeServerAdminPanelRequest {
	m0 := &UserCanSeeServerAdminPanelRequest{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type UserCanSeeServerAdminPanelResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanSeeServerAdminPanelResponse) Reset() {
	*x = UserCanSeeServerAdminPanelResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanSeeServerAdminPanelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanSeeServerAdminPanelResponse) ProtoMessage() {}

func (x *UserCanSeeServerAdminPanelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanSeeServerAdminPanelResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanSeeServerAdminPanelResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanSeeServerAdminPanelResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanSeeServerAdminPanelResponse_builder) Build() *UserCanSeeServerAdminPanelResponse {
	m0 := &UserCanSeeServerAdminPanelResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

type UserCanManageRepositoryContributorsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *UserCanManageRepositoryContributorsRequest) Reset() {
	*x = UserCanManageRepositoryContributorsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanManageRepositoryContributorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanManageRepositoryContributorsRequest) ProtoMessage() {}

func (x *UserCanManageRepositoryContributorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanManageRepositoryContributorsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *UserCanManageRepositoryContributorsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type UserCanManageRepositoryContributorsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string
}

func (b0 UserCanManageRepositoryContributorsRequest_builder) Build() *UserCanManageRepositoryContributorsRequest {
	m0 := &UserCanManageRepositoryContributorsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type UserCanManageRepositoryContributorsResponse struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_AuthorizedRoles []RepositoryRole       `protobuf:"varint,1,rep,packed,name=authorized_roles,json=authorizedRoles,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *UserCanManageRepositoryContributorsResponse) Reset() {
	*x = UserCanManageRepositoryContributorsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanManageRepositoryContributorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanManageRepositoryContributorsResponse) ProtoMessage() {}

func (x *UserCanManageRepositoryContributorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanManageRepositoryContributorsResponse) GetAuthorizedRoles() []RepositoryRole {
	if x != nil {
		return x.xxx_hidden_AuthorizedRoles
	}
	return nil
}

func (x *UserCanManageRepositoryContributorsResponse) SetAuthorizedRoles(v []RepositoryRole) {
	x.xxx_hidden_AuthorizedRoles = v
}

type UserCanManageRepositoryContributorsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of roles that the user is authorized to manage, empty list means the user is
	// not authorized to manage any contributors.
	AuthorizedRoles []RepositoryRole
}

func (b0 UserCanManageRepositoryContributorsResponse_builder) Build() *UserCanManageRepositoryContributorsResponse {
	m0 := &UserCanManageRepositoryContributorsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_AuthorizedRoles = b.AuthorizedRoles
	return m0
}

type UserCanReviewCommitsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *UserCanReviewCommitsRequest) Reset() {
	*x = UserCanReviewCommitsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanReviewCommitsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanReviewCommitsRequest) ProtoMessage() {}

func (x *UserCanReviewCommitsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanReviewCommitsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *UserCanReviewCommitsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type UserCanReviewCommitsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// whether the user is authorized.
	RepositoryId string
}

func (b0 UserCanReviewCommitsRequest_builder) Build() *UserCanReviewCommitsRequest {
	m0 := &UserCanReviewCommitsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type UserCanReviewCommitsResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Authorized bool                   `protobuf:"varint,1,opt,name=authorized,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *UserCanReviewCommitsResponse) Reset() {
	*x = UserCanReviewCommitsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserCanReviewCommitsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCanReviewCommitsResponse) ProtoMessage() {}

func (x *UserCanReviewCommitsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserCanReviewCommitsResponse) GetAuthorized() bool {
	if x != nil {
		return x.xxx_hidden_Authorized
	}
	return false
}

func (x *UserCanReviewCommitsResponse) SetAuthorized(v bool) {
	x.xxx_hidden_Authorized = v
}

type UserCanReviewCommitsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Authorized bool
}

func (b0 UserCanReviewCommitsResponse_builder) Build() *UserCanReviewCommitsResponse {
	m0 := &UserCanReviewCommitsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Authorized = b.Authorized
	return m0
}

var File_buf_alpha_registry_v1alpha1_authz_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_authz_proto_rawDesc = "" +
	"\n" +
	"'buf/alpha/registry/v1alpha1/authz.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a&buf/alpha/registry/v1alpha1/role.proto\"U\n" +
	"*UserCanCreateOrganizationRepositoryRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\"M\n" +
	"+UserCanCreateOrganizationRepositoryResponse\x12\x1e\n" +
	"\n" +
	"authorized\x18\x01 \x01(\bR\n" +
	"authorized\"J\n" +
	"#UserCanSeeRepositorySettingsRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\"F\n" +
	"$UserCanSeeRepositorySettingsResponse\x12\x1e\n" +
	"\n" +
	"authorized\x18\x01 \x01(\bR\n" +
	"authorized\"P\n" +
	"%UserCanSeeOrganizationSettingsRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\"H\n" +
	"&UserCanSeeOrganizationSettingsResponse\x12\x1e\n" +
	"\n" +
	"authorized\x18\x01 \x01(\bR\n" +
	"authorized\"N\n" +
	"#UserCanAddOrganizationMemberRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\"\x80\x01\n" +
	"$UserCanAddOrganizationMemberResponse\x12X\n" +
	"\x10authorized_roles\x18\x01 \x03(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\x0fauthorizedRoles\"Q\n" +
	"&UserCanUpdateOrganizationMemberRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\"\x83\x01\n" +
	"'UserCanUpdateOrganizationMemberResponse\x12X\n" +
	"\x10authorized_roles\x18\x01 \x03(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\x0fauthorizedRoles\"Q\n" +
	"&UserCanRemoveOrganizationMemberRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\"\x83\x01\n" +
	"'UserCanRemoveOrganizationMemberResponse\x12X\n" +
	"\x10authorized_roles\x18\x01 \x03(\x0e2-.buf.alpha.registry.v1alpha1.OrganizationRoleR\x0fauthorizedRoles\"K\n" +
	" UserCanDeleteOrganizationRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\"C\n" +
	"!UserCanDeleteOrganizationResponse\x12\x1e\n" +
	"\n" +
	"authorized\x18\x01 \x01(\bR\n" +
	"authorized\"E\n" +
	"\x1eUserCanDeleteRepositoryRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\"A\n" +
	"\x1fUserCanDeleteRepositoryResponse\x12\x1e\n" +
	"\n" +
	"authorized\x18\x01 \x01(\bR\n" +
	"authorized\"\x1a\n" +
	"\x18UserCanDeleteUserRequest\";\n" +
	"\x19UserCanDeleteUserResponse\x12\x1e\n" +
	"\n" +
	"authorized\x18\x01 \x01(\bR\n" +
	"authorized\"#\n" +
	"!UserCanSeeServerAdminPanelRequest\"D\n" +
	"\"UserCanSeeServerAdminPanelResponse\x12\x1e\n" +
	"\n" +
	"authorized\x18\x01 \x01(\bR\n" +
	"authorized\"Q\n" +
	"*UserCanManageRepositoryContributorsRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\"\x85\x01\n" +
	"+UserCanManageRepositoryContributorsResponse\x12V\n" +
	"\x10authorized_roles\x18\x01 \x03(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\x0fauthorizedRoles\"B\n" +
	"\x1bUserCanReviewCommitsRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\">\n" +
	"\x1cUserCanReviewCommitsResponse\x12\x1e\n" +
	"\n" +
	"authorized\x18\x01 \x01(\bR\n" +
	"authorized2\xfd\x0f\n" +
	"\fAuthzService\x12\xbd\x01\n" +
	"#UserCanCreateOrganizationRepository\x12G.buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryRequest\x1aH.buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryResponse\"\x03\x90\x02\x01\x12\xa8\x01\n" +
	"\x1cUserCanSeeRepositorySettings\x12@.buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsRequest\x1aA.buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsResponse\"\x03\x90\x02\x01\x12\xae\x01\n" +
	"\x1eUserCanSeeOrganizationSettings\x12B.buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsRequest\x1aC.buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsResponse\"\x03\x90\x02\x01\x12\xa8\x01\n" +
	"\x1cUserCanAddOrganizationMember\x12@.buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberRequest\x1aA.buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberResponse\"\x03\x90\x02\x01\x12\xb1\x01\n" +
	"\x1fUserCanUpdateOrganizationMember\x12C.buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberRequest\x1aD.buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberResponse\"\x03\x90\x02\x01\x12\xb1\x01\n" +
	"\x1fUserCanRemoveOrganizationMember\x12C.buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberRequest\x1aD.buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberResponse\"\x03\x90\x02\x01\x12\x9f\x01\n" +
	"\x19UserCanDeleteOrganization\x12=.buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationRequest\x1a>.buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationResponse\"\x03\x90\x02\x01\x12\x99\x01\n" +
	"\x17UserCanDeleteRepository\x12;.buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryRequest\x1a<.buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryResponse\"\x03\x90\x02\x01\x12\x87\x01\n" +
	"\x11UserCanDeleteUser\x125.buf.alpha.registry.v1alpha1.UserCanDeleteUserRequest\x1a6.buf.alpha.registry.v1alpha1.UserCanDeleteUserResponse\"\x03\x90\x02\x01\x12\xa2\x01\n" +
	"\x1aUserCanSeeServerAdminPanel\x12>.buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelRequest\x1a?.buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelResponse\"\x03\x90\x02\x01\x12\xbd\x01\n" +
	"#UserCanManageRepositoryContributors\x12G.buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsRequest\x1aH.buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsResponse\"\x03\x90\x02\x01\x12\x90\x01\n" +
	"\x14UserCanReviewCommits\x128.buf.alpha.registry.v1alpha1.UserCanReviewCommitsRequest\x1a9.buf.alpha.registry.v1alpha1.UserCanReviewCommitsResponse\"\x03\x90\x02\x01B\x97\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\n" +
	"AuthzProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes = make([]protoimpl.MessageInfo, 24)
var file_buf_alpha_registry_v1alpha1_authz_proto_goTypes = []any{
	(*UserCanCreateOrganizationRepositoryRequest)(nil),  // 0: buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryRequest
	(*UserCanCreateOrganizationRepositoryResponse)(nil), // 1: buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryResponse
	(*UserCanSeeRepositorySettingsRequest)(nil),         // 2: buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsRequest
	(*UserCanSeeRepositorySettingsResponse)(nil),        // 3: buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsResponse
	(*UserCanSeeOrganizationSettingsRequest)(nil),       // 4: buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsRequest
	(*UserCanSeeOrganizationSettingsResponse)(nil),      // 5: buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsResponse
	(*UserCanAddOrganizationMemberRequest)(nil),         // 6: buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberRequest
	(*UserCanAddOrganizationMemberResponse)(nil),        // 7: buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberResponse
	(*UserCanUpdateOrganizationMemberRequest)(nil),      // 8: buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberRequest
	(*UserCanUpdateOrganizationMemberResponse)(nil),     // 9: buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberResponse
	(*UserCanRemoveOrganizationMemberRequest)(nil),      // 10: buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberRequest
	(*UserCanRemoveOrganizationMemberResponse)(nil),     // 11: buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberResponse
	(*UserCanDeleteOrganizationRequest)(nil),            // 12: buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationRequest
	(*UserCanDeleteOrganizationResponse)(nil),           // 13: buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationResponse
	(*UserCanDeleteRepositoryRequest)(nil),              // 14: buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryRequest
	(*UserCanDeleteRepositoryResponse)(nil),             // 15: buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryResponse
	(*UserCanDeleteUserRequest)(nil),                    // 16: buf.alpha.registry.v1alpha1.UserCanDeleteUserRequest
	(*UserCanDeleteUserResponse)(nil),                   // 17: buf.alpha.registry.v1alpha1.UserCanDeleteUserResponse
	(*UserCanSeeServerAdminPanelRequest)(nil),           // 18: buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelRequest
	(*UserCanSeeServerAdminPanelResponse)(nil),          // 19: buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelResponse
	(*UserCanManageRepositoryContributorsRequest)(nil),  // 20: buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsRequest
	(*UserCanManageRepositoryContributorsResponse)(nil), // 21: buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsResponse
	(*UserCanReviewCommitsRequest)(nil),                 // 22: buf.alpha.registry.v1alpha1.UserCanReviewCommitsRequest
	(*UserCanReviewCommitsResponse)(nil),                // 23: buf.alpha.registry.v1alpha1.UserCanReviewCommitsResponse
	(OrganizationRole)(0),                               // 24: buf.alpha.registry.v1alpha1.OrganizationRole
	(RepositoryRole)(0),                                 // 25: buf.alpha.registry.v1alpha1.RepositoryRole
}
var file_buf_alpha_registry_v1alpha1_authz_proto_depIdxs = []int32{
	24, // 0: buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	24, // 1: buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	24, // 2: buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.OrganizationRole
	25, // 3: buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsResponse.authorized_roles:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	0,  // 4: buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationRepository:input_type -> buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryRequest
	2,  // 5: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeRepositorySettings:input_type -> buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsRequest
	4,  // 6: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeOrganizationSettings:input_type -> buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsRequest
	6,  // 7: buf.alpha.registry.v1alpha1.AuthzService.UserCanAddOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberRequest
	8,  // 8: buf.alpha.registry.v1alpha1.AuthzService.UserCanUpdateOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberRequest
	10, // 9: buf.alpha.registry.v1alpha1.AuthzService.UserCanRemoveOrganizationMember:input_type -> buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberRequest
	12, // 10: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteOrganization:input_type -> buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationRequest
	14, // 11: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteRepository:input_type -> buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryRequest
	16, // 12: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteUser:input_type -> buf.alpha.registry.v1alpha1.UserCanDeleteUserRequest
	18, // 13: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeServerAdminPanel:input_type -> buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelRequest
	20, // 14: buf.alpha.registry.v1alpha1.AuthzService.UserCanManageRepositoryContributors:input_type -> buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsRequest
	22, // 15: buf.alpha.registry.v1alpha1.AuthzService.UserCanReviewCommits:input_type -> buf.alpha.registry.v1alpha1.UserCanReviewCommitsRequest
	1,  // 16: buf.alpha.registry.v1alpha1.AuthzService.UserCanCreateOrganizationRepository:output_type -> buf.alpha.registry.v1alpha1.UserCanCreateOrganizationRepositoryResponse
	3,  // 17: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeRepositorySettings:output_type -> buf.alpha.registry.v1alpha1.UserCanSeeRepositorySettingsResponse
	5,  // 18: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeOrganizationSettings:output_type -> buf.alpha.registry.v1alpha1.UserCanSeeOrganizationSettingsResponse
	7,  // 19: buf.alpha.registry.v1alpha1.AuthzService.UserCanAddOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.UserCanAddOrganizationMemberResponse
	9,  // 20: buf.alpha.registry.v1alpha1.AuthzService.UserCanUpdateOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.UserCanUpdateOrganizationMemberResponse
	11, // 21: buf.alpha.registry.v1alpha1.AuthzService.UserCanRemoveOrganizationMember:output_type -> buf.alpha.registry.v1alpha1.UserCanRemoveOrganizationMemberResponse
	13, // 22: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteOrganization:output_type -> buf.alpha.registry.v1alpha1.UserCanDeleteOrganizationResponse
	15, // 23: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteRepository:output_type -> buf.alpha.registry.v1alpha1.UserCanDeleteRepositoryResponse
	17, // 24: buf.alpha.registry.v1alpha1.AuthzService.UserCanDeleteUser:output_type -> buf.alpha.registry.v1alpha1.UserCanDeleteUserResponse
	19, // 25: buf.alpha.registry.v1alpha1.AuthzService.UserCanSeeServerAdminPanel:output_type -> buf.alpha.registry.v1alpha1.UserCanSeeServerAdminPanelResponse
	21, // 26: buf.alpha.registry.v1alpha1.AuthzService.UserCanManageRepositoryContributors:output_type -> buf.alpha.registry.v1alpha1.UserCanManageRepositoryContributorsResponse
	23, // 27: buf.alpha.registry.v1alpha1.AuthzService.UserCanReviewCommits:output_type -> buf.alpha.registry.v1alpha1.UserCanReviewCommitsResponse
	16, // [16:28] is the sub-list for method output_type
	4,  // [4:16] is the sub-list for method input_type
	4,  // [4:4] is the sub-list for extension type_name
	4,  // [4:4] is the sub-list for extension extendee
	0,  // [0:4] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_authz_proto_init() }
func file_buf_alpha_registry_v1alpha1_authz_proto_init() {
	if File_buf_alpha_registry_v1alpha1_authz_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_role_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_authz_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_authz_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   24,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_authz_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_authz_proto_depIdxs,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_authz_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_authz_proto = out.File
	file_buf_alpha_registry_v1alpha1_authz_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_authz_proto_depIdxs = nil
}
