/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "chuck.y"


/*----------------------------------------------------------------------------
  ChucK Strongly-timed Audio Programming Language
    Compiler and Virtual Machine

  Copyright (c) 2003 Ge Wang and Perry R. Cook. All rights reserved.
    http://chuck.cs.princeton.edu/
    http://soundlab.cs.princeton.edu/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  U.S.A.
-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// file: chuck.tab.c
// desc: chuck parser
//
// author: Ge Wang (gewang@cs.princeton.edu) - generated by yacc
//         Perry R. Cook (prc@cs.princeton.edu)
//
// initial version created by Ge Wang;
// based on ansi C grammar by Jeff Lee, maintained by Jutta Degener
//
// date: Summer 2002
//-----------------------------------------------------------------------------
#include "chuck_absyn.h"
#include "chuck_errmsg.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

// function
int yylex( void );

void yyerror( char * s )
{
    EM_error( EM_tokPos, "%s", s );
}

a_Program g_program = NULL;


#line 128 "chuck.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "chuck.tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_ID = 3,                         /* ID  */
  YYSYMBOL_STRING_LIT = 4,                 /* STRING_LIT  */
  YYSYMBOL_CHAR_LIT = 5,                   /* CHAR_LIT  */
  YYSYMBOL_INT_VAL = 6,                    /* INT_VAL  */
  YYSYMBOL_FLOAT_VAL = 7,                  /* FLOAT_VAL  */
  YYSYMBOL_POUND = 8,                      /* POUND  */
  YYSYMBOL_COMMA = 9,                      /* COMMA  */
  YYSYMBOL_COLON = 10,                     /* COLON  */
  YYSYMBOL_SEMICOLON = 11,                 /* SEMICOLON  */
  YYSYMBOL_LPAREN = 12,                    /* LPAREN  */
  YYSYMBOL_RPAREN = 13,                    /* RPAREN  */
  YYSYMBOL_LBRACK = 14,                    /* LBRACK  */
  YYSYMBOL_RBRACK = 15,                    /* RBRACK  */
  YYSYMBOL_LBRACE = 16,                    /* LBRACE  */
  YYSYMBOL_RBRACE = 17,                    /* RBRACE  */
  YYSYMBOL_DOT = 18,                       /* DOT  */
  YYSYMBOL_PLUS = 19,                      /* PLUS  */
  YYSYMBOL_MINUS = 20,                     /* MINUS  */
  YYSYMBOL_TIMES = 21,                     /* TIMES  */
  YYSYMBOL_DIVIDE = 22,                    /* DIVIDE  */
  YYSYMBOL_PERCENT = 23,                   /* PERCENT  */
  YYSYMBOL_EQ = 24,                        /* EQ  */
  YYSYMBOL_NEQ = 25,                       /* NEQ  */
  YYSYMBOL_LT = 26,                        /* LT  */
  YYSYMBOL_LE = 27,                        /* LE  */
  YYSYMBOL_GT = 28,                        /* GT  */
  YYSYMBOL_GE = 29,                        /* GE  */
  YYSYMBOL_AND = 30,                       /* AND  */
  YYSYMBOL_OR = 31,                        /* OR  */
  YYSYMBOL_ASSIGN = 32,                    /* ASSIGN  */
  YYSYMBOL_IF = 33,                        /* IF  */
  YYSYMBOL_THEN = 34,                      /* THEN  */
  YYSYMBOL_ELSE = 35,                      /* ELSE  */
  YYSYMBOL_WHILE = 36,                     /* WHILE  */
  YYSYMBOL_FOR = 37,                       /* FOR  */
  YYSYMBOL_DO = 38,                        /* DO  */
  YYSYMBOL_LOOP = 39,                      /* LOOP  */
  YYSYMBOL_BREAK = 40,                     /* BREAK  */
  YYSYMBOL_CONTINUE = 41,                  /* CONTINUE  */
  YYSYMBOL_NULL_TOK = 42,                  /* NULL_TOK  */
  YYSYMBOL_FUNCTION = 43,                  /* FUNCTION  */
  YYSYMBOL_RETURN = 44,                    /* RETURN  */
  YYSYMBOL_QUESTION = 45,                  /* QUESTION  */
  YYSYMBOL_EXCLAMATION = 46,               /* EXCLAMATION  */
  YYSYMBOL_S_OR = 47,                      /* S_OR  */
  YYSYMBOL_S_AND = 48,                     /* S_AND  */
  YYSYMBOL_S_XOR = 49,                     /* S_XOR  */
  YYSYMBOL_PLUSPLUS = 50,                  /* PLUSPLUS  */
  YYSYMBOL_MINUSMINUS = 51,                /* MINUSMINUS  */
  YYSYMBOL_DOLLAR = 52,                    /* DOLLAR  */
  YYSYMBOL_POUNDPAREN = 53,                /* POUNDPAREN  */
  YYSYMBOL_PERCENTPAREN = 54,              /* PERCENTPAREN  */
  YYSYMBOL_ATPAREN = 55,                   /* ATPAREN  */
  YYSYMBOL_SIMULT = 56,                    /* SIMULT  */
  YYSYMBOL_PATTERN = 57,                   /* PATTERN  */
  YYSYMBOL_CODE = 58,                      /* CODE  */
  YYSYMBOL_TRANSPORT = 59,                 /* TRANSPORT  */
  YYSYMBOL_HOST = 60,                      /* HOST  */
  YYSYMBOL_TIME = 61,                      /* TIME  */
  YYSYMBOL_WHENEVER = 62,                  /* WHENEVER  */
  YYSYMBOL_NEXT = 63,                      /* NEXT  */
  YYSYMBOL_UNTIL = 64,                     /* UNTIL  */
  YYSYMBOL_EXTERNAL = 65,                  /* EXTERNAL  */
  YYSYMBOL_GLOBAL = 66,                    /* GLOBAL  */
  YYSYMBOL_EVERY = 67,                     /* EVERY  */
  YYSYMBOL_BEFORE = 68,                    /* BEFORE  */
  YYSYMBOL_AFTER = 69,                     /* AFTER  */
  YYSYMBOL_AT = 70,                        /* AT  */
  YYSYMBOL_AT_SYM = 71,                    /* AT_SYM  */
  YYSYMBOL_ATAT_SYM = 72,                  /* ATAT_SYM  */
  YYSYMBOL_NEW = 73,                       /* NEW  */
  YYSYMBOL_SIZEOF = 74,                    /* SIZEOF  */
  YYSYMBOL_TYPEOF = 75,                    /* TYPEOF  */
  YYSYMBOL_SAME = 76,                      /* SAME  */
  YYSYMBOL_PLUS_CHUCK = 77,                /* PLUS_CHUCK  */
  YYSYMBOL_MINUS_CHUCK = 78,               /* MINUS_CHUCK  */
  YYSYMBOL_TIMES_CHUCK = 79,               /* TIMES_CHUCK  */
  YYSYMBOL_DIVIDE_CHUCK = 80,              /* DIVIDE_CHUCK  */
  YYSYMBOL_S_AND_CHUCK = 81,               /* S_AND_CHUCK  */
  YYSYMBOL_S_OR_CHUCK = 82,                /* S_OR_CHUCK  */
  YYSYMBOL_S_XOR_CHUCK = 83,               /* S_XOR_CHUCK  */
  YYSYMBOL_SHIFT_RIGHT_CHUCK = 84,         /* SHIFT_RIGHT_CHUCK  */
  YYSYMBOL_SHIFT_LEFT_CHUCK = 85,          /* SHIFT_LEFT_CHUCK  */
  YYSYMBOL_PERCENT_CHUCK = 86,             /* PERCENT_CHUCK  */
  YYSYMBOL_SHIFT_RIGHT = 87,               /* SHIFT_RIGHT  */
  YYSYMBOL_SHIFT_LEFT = 88,                /* SHIFT_LEFT  */
  YYSYMBOL_TILDA = 89,                     /* TILDA  */
  YYSYMBOL_CHUCK = 90,                     /* CHUCK  */
  YYSYMBOL_COLONCOLON = 91,                /* COLONCOLON  */
  YYSYMBOL_S_CHUCK = 92,                   /* S_CHUCK  */
  YYSYMBOL_AT_CHUCK = 93,                  /* AT_CHUCK  */
  YYSYMBOL_LEFT_S_CHUCK = 94,              /* LEFT_S_CHUCK  */
  YYSYMBOL_UNCHUCK = 95,                   /* UNCHUCK  */
  YYSYMBOL_UPCHUCK = 96,                   /* UPCHUCK  */
  YYSYMBOL_DOWNCHUCK = 97,                 /* DOWNCHUCK  */
  YYSYMBOL_CLASS = 98,                     /* CLASS  */
  YYSYMBOL_INTERFACE = 99,                 /* INTERFACE  */
  YYSYMBOL_EXTENDS = 100,                  /* EXTENDS  */
  YYSYMBOL_IMPLEMENTS = 101,               /* IMPLEMENTS  */
  YYSYMBOL_PUBLIC = 102,                   /* PUBLIC  */
  YYSYMBOL_PROTECTED = 103,                /* PROTECTED  */
  YYSYMBOL_PRIVATE = 104,                  /* PRIVATE  */
  YYSYMBOL_STATIC = 105,                   /* STATIC  */
  YYSYMBOL_ABSTRACT = 106,                 /* ABSTRACT  */
  YYSYMBOL_CONST = 107,                    /* CONST  */
  YYSYMBOL_SPORK = 108,                    /* SPORK  */
  YYSYMBOL_ARROW_RIGHT = 109,              /* ARROW_RIGHT  */
  YYSYMBOL_ARROW_LEFT = 110,               /* ARROW_LEFT  */
  YYSYMBOL_L_HACK = 111,                   /* L_HACK  */
  YYSYMBOL_R_HACK = 112,                   /* R_HACK  */
  YYSYMBOL_GRUCK_RIGHT = 113,              /* GRUCK_RIGHT  */
  YYSYMBOL_GRUCK_LEFT = 114,               /* GRUCK_LEFT  */
  YYSYMBOL_UNGRUCK_RIGHT = 115,            /* UNGRUCK_RIGHT  */
  YYSYMBOL_UNGRUCK_LEFT = 116,             /* UNGRUCK_LEFT  */
  YYSYMBOL_AT_OP = 117,                    /* AT_OP  */
  YYSYMBOL_AT_CTOR = 118,                  /* AT_CTOR  */
  YYSYMBOL_AT_DTOR = 119,                  /* AT_DTOR  */
  YYSYMBOL_AT_IMPORT = 120,                /* AT_IMPORT  */
  YYSYMBOL_AT_DOC = 121,                   /* AT_DOC  */
  YYSYMBOL_YYACCEPT = 122,                 /* $accept  */
  YYSYMBOL_program = 123,                  /* program  */
  YYSYMBOL_program_section = 124,          /* program_section  */
  YYSYMBOL_class_definition = 125,         /* class_definition  */
  YYSYMBOL_class_ext = 126,                /* class_ext  */
  YYSYMBOL_class_body = 127,               /* class_body  */
  YYSYMBOL_class_body2 = 128,              /* class_body2  */
  YYSYMBOL_class_section = 129,            /* class_section  */
  YYSYMBOL_iface_ext = 130,                /* iface_ext  */
  YYSYMBOL_id_list = 131,                  /* id_list  */
  YYSYMBOL_id_dot = 132,                   /* id_dot  */
  YYSYMBOL_function_definition = 133,      /* function_definition  */
  YYSYMBOL_class_decl = 134,               /* class_decl  */
  YYSYMBOL_function_decl = 135,            /* function_decl  */
  YYSYMBOL_static_decl = 136,              /* static_decl  */
  YYSYMBOL_type_decl_a = 137,              /* type_decl_a  */
  YYSYMBOL_type_decl_b = 138,              /* type_decl_b  */
  YYSYMBOL_type_decl = 139,                /* type_decl  */
  YYSYMBOL_type_decl2 = 140,               /* type_decl2  */
  YYSYMBOL_arg_list = 141,                 /* arg_list  */
  YYSYMBOL_statement_list = 142,           /* statement_list  */
  YYSYMBOL_statement = 143,                /* statement  */
  YYSYMBOL_jump_statement = 144,           /* jump_statement  */
  YYSYMBOL_selection_statement = 145,      /* selection_statement  */
  YYSYMBOL_loop_statement = 146,           /* loop_statement  */
  YYSYMBOL_code_segment = 147,             /* code_segment  */
  YYSYMBOL_import_statement = 148,         /* import_statement  */
  YYSYMBOL_import_list = 149,              /* import_list  */
  YYSYMBOL_import_target = 150,            /* import_target  */
  YYSYMBOL_doc_statement = 151,            /* doc_statement  */
  YYSYMBOL_doc_list = 152,                 /* doc_list  */
  YYSYMBOL_doc_target = 153,               /* doc_target  */
  YYSYMBOL_expression_statement = 154,     /* expression_statement  */
  YYSYMBOL_expression = 155,               /* expression  */
  YYSYMBOL_chuck_expression = 156,         /* chuck_expression  */
  YYSYMBOL_arrow_expression = 157,         /* arrow_expression  */
  YYSYMBOL_array_exp = 158,                /* array_exp  */
  YYSYMBOL_array_empty = 159,              /* array_empty  */
  YYSYMBOL_decl_expression = 160,          /* decl_expression  */
  YYSYMBOL_var_decl_list = 161,            /* var_decl_list  */
  YYSYMBOL_var_decl = 162,                 /* var_decl  */
  YYSYMBOL_complex_exp = 163,              /* complex_exp  */
  YYSYMBOL_polar_exp = 164,                /* polar_exp  */
  YYSYMBOL_vec_exp = 165,                  /* vec_exp  */
  YYSYMBOL_chuck_operator = 166,           /* chuck_operator  */
  YYSYMBOL_arrow_operator = 167,           /* arrow_operator  */
  YYSYMBOL_conditional_expression = 168,   /* conditional_expression  */
  YYSYMBOL_logical_or_expression = 169,    /* logical_or_expression  */
  YYSYMBOL_logical_and_expression = 170,   /* logical_and_expression  */
  YYSYMBOL_inclusive_or_expression = 171,  /* inclusive_or_expression  */
  YYSYMBOL_exclusive_or_expression = 172,  /* exclusive_or_expression  */
  YYSYMBOL_and_expression = 173,           /* and_expression  */
  YYSYMBOL_equality_expression = 174,      /* equality_expression  */
  YYSYMBOL_relational_expression = 175,    /* relational_expression  */
  YYSYMBOL_shift_expression = 176,         /* shift_expression  */
  YYSYMBOL_additive_expression = 177,      /* additive_expression  */
  YYSYMBOL_multiplicative_expression = 178, /* multiplicative_expression  */
  YYSYMBOL_tilda_expression = 179,         /* tilda_expression  */
  YYSYMBOL_cast_expression = 180,          /* cast_expression  */
  YYSYMBOL_unary_expression = 181,         /* unary_expression  */
  YYSYMBOL_unary_operator = 182,           /* unary_operator  */
  YYSYMBOL_overloadable_operator = 183,    /* overloadable_operator  */
  YYSYMBOL_dur_expression = 184,           /* dur_expression  */
  YYSYMBOL_postfix_expression = 185,       /* postfix_expression  */
  YYSYMBOL_primary_expression = 186        /* primary_expression  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  135
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2373

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  122
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  65
/* YYNRULES -- Number of rules.  */
#define YYNRULES  274
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  463

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   376


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   216,   216,   217,   221,   222,   223,   227,   229,   231,
     233,   238,   239,   240,   241,   245,   246,   250,   251,   256,
     257,   258,   262,   266,   267,   271,   272,   276,   278,   280,
     282,   284,   286,   288,   290,   292,   294,   296,   298,   300,
     302,   307,   308,   309,   313,   314,   315,   316,   320,   321,
     322,   326,   327,   331,   332,   341,   342,   347,   348,   352,
     353,   357,   358,   362,   363,   364,   365,   367,   368,   369,
     373,   374,   375,   376,   380,   382,   387,   389,   391,   393,
     395,   397,   399,   401,   406,   407,   411,   412,   413,   414,
     415,   419,   420,   424,   429,   430,   431,   435,   436,   440,
     444,   445,   449,   450,   454,   455,   460,   461,   466,   467,
     468,   470,   475,   476,   480,   481,   482,   483,   484,   485,
     486,   490,   491,   495,   496,   497,   498,   499,   500,   501,
     505,   510,   515,   520,   521,   522,   523,   524,   525,   526,
     527,   528,   529,   530,   531,   532,   533,   534,   538,   539,
     540,   541,   542,   543,   547,   548,   553,   554,   559,   560,
     565,   566,   571,   572,   577,   578,   583,   584,   586,   591,
     592,   594,   596,   598,   603,   604,   606,   611,   612,   614,
     619,   620,   622,   624,   629,   630,   635,   636,   641,   642,
     644,   646,   648,   650,   652,   654,   656,   658,   660,   662,
     669,   670,   671,   672,   673,   674,   675,   681,   682,   683,
     684,   685,   686,   687,   688,   689,   690,   691,   692,   693,
     694,   695,   696,   697,   698,   699,   700,   701,   702,   703,
     704,   705,   706,   707,   708,   709,   710,   711,   712,   713,
     714,   715,   716,   717,   718,   719,   720,   721,   722,   723,
     724,   725,   726,   727,   731,   732,   737,   738,   740,   742,
     744,   746,   748,   754,   755,   756,   757,   758,   759,   760,
     761,   762,   763,   764,   765
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "ID", "STRING_LIT",
  "CHAR_LIT", "INT_VAL", "FLOAT_VAL", "POUND", "COMMA", "COLON",
  "SEMICOLON", "LPAREN", "RPAREN", "LBRACK", "RBRACK", "LBRACE", "RBRACE",
  "DOT", "PLUS", "MINUS", "TIMES", "DIVIDE", "PERCENT", "EQ", "NEQ", "LT",
  "LE", "GT", "GE", "AND", "OR", "ASSIGN", "IF", "THEN", "ELSE", "WHILE",
  "FOR", "DO", "LOOP", "BREAK", "CONTINUE", "NULL_TOK", "FUNCTION",
  "RETURN", "QUESTION", "EXCLAMATION", "S_OR", "S_AND", "S_XOR",
  "PLUSPLUS", "MINUSMINUS", "DOLLAR", "POUNDPAREN", "PERCENTPAREN",
  "ATPAREN", "SIMULT", "PATTERN", "CODE", "TRANSPORT", "HOST", "TIME",
  "WHENEVER", "NEXT", "UNTIL", "EXTERNAL", "GLOBAL", "EVERY", "BEFORE",
  "AFTER", "AT", "AT_SYM", "ATAT_SYM", "NEW", "SIZEOF", "TYPEOF", "SAME",
  "PLUS_CHUCK", "MINUS_CHUCK", "TIMES_CHUCK", "DIVIDE_CHUCK",
  "S_AND_CHUCK", "S_OR_CHUCK", "S_XOR_CHUCK", "SHIFT_RIGHT_CHUCK",
  "SHIFT_LEFT_CHUCK", "PERCENT_CHUCK", "SHIFT_RIGHT", "SHIFT_LEFT",
  "TILDA", "CHUCK", "COLONCOLON", "S_CHUCK", "AT_CHUCK", "LEFT_S_CHUCK",
  "UNCHUCK", "UPCHUCK", "DOWNCHUCK", "CLASS", "INTERFACE", "EXTENDS",
  "IMPLEMENTS", "PUBLIC", "PROTECTED", "PRIVATE", "STATIC", "ABSTRACT",
  "CONST", "SPORK", "ARROW_RIGHT", "ARROW_LEFT", "L_HACK", "R_HACK",
  "GRUCK_RIGHT", "GRUCK_LEFT", "UNGRUCK_RIGHT", "UNGRUCK_LEFT", "AT_OP",
  "AT_CTOR", "AT_DTOR", "AT_IMPORT", "AT_DOC", "$accept", "program",
  "program_section", "class_definition", "class_ext", "class_body",
  "class_body2", "class_section", "iface_ext", "id_list", "id_dot",
  "function_definition", "class_decl", "function_decl", "static_decl",
  "type_decl_a", "type_decl_b", "type_decl", "type_decl2", "arg_list",
  "statement_list", "statement", "jump_statement", "selection_statement",
  "loop_statement", "code_segment", "import_statement", "import_list",
  "import_target", "doc_statement", "doc_list", "doc_target",
  "expression_statement", "expression", "chuck_expression",
  "arrow_expression", "array_exp", "array_empty", "decl_expression",
  "var_decl_list", "var_decl", "complex_exp", "polar_exp", "vec_exp",
  "chuck_operator", "arrow_operator", "conditional_expression",
  "logical_or_expression", "logical_and_expression",
  "inclusive_or_expression", "exclusive_or_expression", "and_expression",
  "equality_expression", "relational_expression", "shift_expression",
  "additive_expression", "multiplicative_expression", "tilda_expression",
  "cast_expression", "unary_expression", "unary_operator",
  "overloadable_operator", "dur_expression", "postfix_expression",
  "primary_expression", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-338)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-52)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     665,    15,  -338,  -338,  -338,  -338,  -338,  1215,  1893,   776,
    -338,  -338,  -338,   148,    42,   145,   151,   998,   156,   149,
     175,  -338,  1289,  -338,  1967,  1967,  1893,  1893,  1893,   171,
      37,    37,    37,  1967,  1967,   198,  -338,  -338,    44,  -338,
      96,    21,   118,  1893,   155,   158,   332,  -338,  -338,  -338,
     168,    47,  -338,  -338,   198,   998,  -338,  -338,  -338,  -338,
    -338,  -338,  -338,  -338,    46,    51,    99,  -338,  -338,  -338,
    -338,  -338,  -338,    -8,   211,   169,   174,   200,   247,   217,
     186,   256,   233,   150,   213,  -338,  1967,   177,    16,  -338,
    -338,  -338,   167,    55,  -338,   887,   265,   262,  1893,  1893,
    1363,    24,  1893,  -338,  -338,  -338,    62,  -338,  -338,  -338,
     172,   183,   184,  1893,   223,   198,   198,    75,  -338,  -338,
      98,  -338,   284,   198,   198,  -338,     8,  -338,    86,   141,
    -338,  -338,   291,   291,  -338,  -338,  -338,   293,   293,  -338,
    -338,   285,   286,    53,  -338,  -338,  1893,  -338,  -338,  -338,
    -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,
    -338,  -338,  -338,  1893,  -338,  -338,  -338,  -338,  -338,  -338,
    1893,  1967,  1893,  1967,  1967,  1967,  1967,  1967,  1967,  1967,
    1967,  1967,  1967,  1967,  1967,  1967,  1967,  1967,  1967,  1967,
    1967,    37,  -338,    39,  1437,   296,  -338,  -338,  -338,  -338,
    1517,   287,  -338,   148,   231,   191,   193,  1363,   248,   288,
     292,   208,  -338,  -338,  -338,  -338,   209,  -338,  -338,  1591,
    -338,  1665,  1745,  -338,   289,   198,  -338,  -338,  -338,  -338,
     294,   297,  -338,   295,   290,   300,   298,   301,    -1,     6,
      82,   112,    13,   299,     7,    51,    99,  -338,   211,   268,
     169,   174,   200,   247,   217,   217,   186,   186,   186,   186,
     256,   256,   233,   233,   150,   150,   150,   213,  -338,    16,
    -338,   216,  -338,   287,  -338,  -338,  -338,   998,   998,  1819,
    1893,  1893,  1893,   998,   998,   287,   219,   287,   221,  -338,
     302,  -338,  -338,   307,  -338,  -338,   291,  -338,   293,   443,
     148,   293,   303,   443,   293,   304,   305,   198,   309,   305,
     310,   113,   313,   289,   306,  2060,  1967,  -338,  -338,   279,
    -338,   998,   222,   224,   227,   229,  -338,  -338,  -338,   287,
    -338,   287,  -338,  -338,  -338,  -338,  -338,   312,  -338,   554,
    -338,   998,   215,   230,   443,   314,  -338,   443,  -338,   315,
     305,  -338,   305,   305,   320,   114,  1101,  -338,  -338,  -338,
    -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,
    -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,
    -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,
    -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,
    -338,  -338,  -338,  -338,   322,  -338,   998,  -338,   998,   998,
     329,   330,  -338,  -338,  -338,  -338,   293,   148,   325,  -338,
     328,    37,  -338,  -338,  -338,   305,    80,   334,   148,   336,
     337,    37,  -338,  -338,  -338,  -338,  -338,  -338,  -338,  -338,
    -338,  -338,  -338,  -338,  -338,   138,  2159,   342,   343,  -338,
    -338,  2257,   305,    37,   305,   344,  -338,   346,  -338,   305,
     305,  -338,  -338
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
      43,   263,   266,   267,   264,   265,   100,     0,     0,     0,
     200,   201,   204,     0,     0,     0,     0,     0,     0,     0,
       0,    44,     0,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   202,   206,    45,    46,
      47,     0,     0,     0,     0,     0,    43,     2,     6,     5,
       0,    50,    55,    56,     0,     4,    61,    66,    65,    64,
      67,    68,    69,    63,     0,   102,   104,   268,   106,   269,
     270,   271,   114,   154,   156,   158,   160,   162,   164,   166,
     169,   174,   177,   180,   184,   186,     0,   188,   254,   256,
      52,   274,     0,     0,    84,     0,    25,     0,     0,     0,
       0,     0,     0,    72,    73,    70,     0,   263,   189,   190,
       0,     0,     0,     0,    51,     0,     0,   194,   193,   192,
     123,   119,   121,     0,     0,   205,     0,    93,     0,     0,
      86,    99,     0,     0,    94,     1,     3,     0,     0,    48,
      49,     0,     0,     0,   115,    62,     0,   101,   135,   136,
     137,   138,   145,   146,   147,   139,   140,   141,   133,   134,
     142,   143,   144,     0,   149,   148,   151,   150,   153,   152,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   191,     0,     0,     0,   261,   262,   257,   273,
       0,   108,    85,     0,    53,     0,     0,     0,     0,     0,
       0,     0,    71,   130,   131,   132,     0,   116,   117,     0,
     195,     0,     0,   124,   125,     0,   120,   118,   272,    87,
       0,    91,    88,     0,     0,    97,     0,    23,     0,     0,
       0,     0,    51,    57,     0,   103,   105,   107,   157,     0,
     159,   161,   163,   165,   167,   168,   170,   172,   171,   173,
     176,   175,   178,   179,   181,   182,   183,   185,   187,   255,
     258,     0,   260,   109,   110,    26,    54,     0,     0,     0,
       0,     0,     0,     0,     0,   196,     0,   126,     0,   112,
       0,   122,    89,     0,    90,    95,     0,    96,     0,    43,
       0,     0,     0,    43,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    58,     0,     0,     0,   259,   111,    74,
      76,     0,     0,     0,     0,     0,    83,    81,   198,   197,
     128,   127,   113,    92,    98,    24,    21,     0,    15,    43,
      20,    19,    13,    11,    43,     0,    22,    43,    32,    59,
       0,    33,     0,     0,     0,     0,     0,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   207,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,     0,   155,     0,    78,     0,     0,
       0,     0,   199,   129,     7,    18,     0,     0,     0,     9,
       0,     0,    31,    34,    30,     0,     0,     0,   215,     0,
       0,     0,    75,    79,    80,    77,    82,    14,    12,     8,
      10,    60,    29,    36,    28,     0,     0,     0,     0,    35,
      27,     0,     0,     0,     0,     0,    38,     0,    37,     0,
       0,    40,    39
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -338,  -338,   316,    26,  -338,  -282,    22,  -338,  -338,  -134,
    -198,    29,  -338,  -338,  -338,  -338,  -338,   -30,  -338,  -233,
      52,   -14,  -338,  -338,  -338,  -270,  -338,  -120,   311,  -338,
    -117,   318,   -86,     5,  -126,   197,   -82,   121,   196,   -47,
      60,  -338,  -338,  -338,  -338,  -338,    58,  -338,   206,   207,
     205,   214,   212,   102,    71,   105,   106,    73,   194,    25,
    -338,  -337,  -338,   188,  -338
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    46,    47,   336,   302,   337,   338,   339,   305,   238,
      97,   340,    50,    51,   143,    52,    53,    54,   244,   308,
     341,    56,    57,    58,    59,    60,    61,   230,   231,    62,
     234,   235,    63,    64,    65,    66,    67,   224,    68,   121,
     122,    69,    70,    71,   163,   170,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,   404,    87,    88,    89
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     115,   116,   117,   101,   239,   275,   198,   144,   310,   233,
     314,   124,    92,    93,   207,   299,   236,   146,   -51,   430,
     245,   345,   303,   171,   114,   311,    48,   106,   194,    49,
       8,   110,   111,   112,   195,   220,   348,   172,   223,   351,
     114,   145,   107,     2,     3,     4,     5,    13,   126,   108,
     109,     7,    55,     8,    98,   146,   242,   147,   118,   119,
     209,    95,   418,    13,   200,   420,   196,   197,   217,   218,
     201,   146,    48,   212,   245,    49,   226,   227,   354,    13,
     422,   145,   423,   424,    90,   114,    90,   219,   210,     8,
     127,   443,    26,    27,    28,   306,     9,   123,    55,   300,
     301,   229,   342,   205,   206,   208,   304,   211,    13,   452,
     221,   192,   222,   243,   455,   114,   114,   114,   216,   274,
     228,   279,   427,   429,   315,   309,   353,   426,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,    13,    13,
      13,   158,   -41,   -41,   159,   127,   160,   161,   162,   449,
      43,    96,   139,   140,     9,   442,   444,    99,   232,   127,
     103,   268,   131,   100,   335,   141,   142,   343,   102,   128,
     346,   129,   132,   333,   133,   450,   146,   249,   291,   334,
     199,   146,   456,   113,   458,   213,   104,   198,   441,   461,
     462,   318,   146,   146,   -42,   -42,   214,   215,   448,   271,
     146,   120,   146,   328,   277,   330,   278,   125,   164,   165,
     307,   307,   166,   167,   168,   169,   174,   146,   146,   438,
     457,   283,   284,   175,   286,   146,   288,    93,   146,   317,
     146,   146,   329,   146,   331,   408,   146,   409,   146,   190,
     410,   173,   411,   179,   180,   181,   182,   412,   176,   413,
     256,   257,   258,   259,   187,   188,   189,   146,   280,   147,
     264,   265,   266,   319,   320,   191,   137,   138,   193,   326,
     327,   177,   178,   183,   184,   185,   186,   146,   316,   254,
     255,   307,   437,   203,   322,   323,   324,   325,   260,   261,
     204,   262,   263,   225,    90,   131,   237,   240,   241,   272,
     281,     8,   276,   290,   282,   295,   293,   407,   292,   296,
     298,   127,   294,   312,   406,   297,   416,   332,   355,   344,
     347,     9,   350,   352,   421,   307,   307,   145,   289,   414,
     417,   419,   135,   425,   431,     1,     2,     3,     4,     5,
     435,   436,   439,     6,     7,   440,     8,   445,     9,   446,
     447,    10,    11,    12,   453,   130,   454,   459,    13,   460,
     246,   415,   136,   134,   313,    14,   247,   349,    15,    16,
      17,    18,    19,    20,   405,    21,    22,   248,    23,   251,
     250,   269,    24,    25,   267,    26,    27,    28,   253,   252,
       0,   307,   432,     0,   433,   434,    29,    30,    31,     0,
       0,   307,     0,     0,     0,    32,    33,    34,    35,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    36,     0,   307,     0,     0,     0,     0,     0,    37,
       0,     0,     0,     0,    38,    39,    40,    41,     0,     0,
      42,     0,     0,    43,     0,     0,     1,     2,     3,     4,
       5,     0,    44,    45,     6,     7,     0,     8,     0,     9,
     -16,     0,    10,    11,    12,     0,     0,     0,     0,    13,
       0,     0,     0,     0,     0,     0,    14,     0,     0,    15,
      16,    17,    18,    19,    20,     0,    21,    22,     0,    23,
       0,     0,     0,    24,    25,     0,    26,    27,    28,     0,
       0,     0,     0,     0,     0,     0,     0,    29,    30,    31,
       0,     0,     0,     0,     0,     0,    32,    33,    34,    35,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,     0,     0,     0,     0,     0,
      37,     0,     0,     0,     0,    38,    39,    40,    41,     0,
       0,    42,     0,     0,    43,     0,     0,     1,     2,     3,
       4,     5,     0,    44,    45,     6,     7,     0,     8,     0,
       9,   -17,     0,    10,    11,    12,     0,     0,     0,     0,
      13,     0,     0,     0,     0,     0,     0,    14,     0,     0,
      15,    16,    17,    18,    19,    20,     0,    21,    22,     0,
      23,     0,     0,     0,    24,    25,     0,    26,    27,    28,
       0,     0,     0,     0,     0,     0,     0,     0,    29,    30,
      31,     0,     0,     0,     0,     0,     0,    32,    33,    34,
      35,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,     0,     0,     0,     0,     0,     0,
       0,    37,     0,     0,     0,     0,    38,    39,    40,    41,
       0,     0,    42,     0,     0,    43,     0,     0,     1,     2,
       3,     4,     5,     0,    44,    45,     6,     7,     0,     8,
       0,     9,     0,     0,    10,    11,    12,     0,     0,     0,
       0,    13,     0,     0,     0,     0,     0,     0,    14,     0,
       0,    15,    16,    17,    18,    19,    20,     0,    21,    22,
       0,    23,     0,     0,     0,    24,    25,     0,    26,    27,
      28,     0,     0,     0,     0,     0,     0,     0,     0,    29,
      30,    31,     0,     0,     0,     0,     0,     0,    32,    33,
      34,    35,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    36,     0,     0,     0,     0,     0,
       0,     0,    37,     0,     0,     0,     0,    38,    39,    40,
      41,     0,     0,    42,     0,     0,    43,     0,     0,     1,
       2,     3,     4,     5,     0,    44,    45,     6,     7,     0,
       8,     0,     9,    94,     0,    10,    11,    12,     0,     0,
       0,     0,    13,     0,     0,     0,     0,     0,     0,    14,
       0,     0,    15,    16,    17,    18,    19,    20,     0,     0,
      22,     0,    23,     0,     0,     0,    24,    25,     0,    26,
      27,    28,     0,     0,     0,     0,     0,     0,     0,     0,
      29,    30,    31,     0,     0,     0,     0,     0,     0,    32,
      33,    34,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    36,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,     0,     0,     0,     0,
       0,    41,     0,     0,    42,     0,     0,    43,     0,     0,
       1,     2,     3,     4,     5,     0,    44,    45,     6,     7,
       0,     8,     0,     9,   202,     0,    10,    11,    12,     0,
       0,     0,     0,    13,     0,     0,     0,     0,     0,     0,
      14,     0,     0,    15,    16,    17,    18,    19,    20,     0,
       0,    22,     0,    23,     0,     0,     0,    24,    25,     0,
      26,    27,    28,     0,     0,     0,     0,     0,     0,     0,
       0,    29,    30,    31,     0,     0,     0,     0,     0,     0,
      32,    33,    34,    35,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    36,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,     0,     0,     0,
       0,     0,    41,     0,     0,    42,     0,     0,    43,     0,
       0,     1,     2,     3,     4,     5,     0,    44,    45,     6,
       7,     0,     8,     0,     9,     0,     0,    10,    11,    12,
       0,     0,     0,     0,    13,     0,     0,     0,     0,     0,
       0,    14,     0,     0,    15,    16,    17,    18,    19,    20,
       0,     0,    22,     0,    23,     0,     0,     0,    24,    25,
       0,    26,    27,    28,     0,     0,     0,     0,     0,     0,
       0,     0,    29,    30,    31,     0,     0,     0,     0,     0,
       0,    32,    33,    34,    35,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    36,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,     0,     0,
       0,     0,     0,    41,   114,     0,    42,     0,     0,    43,
       0,     0,     0,     0,     0,     0,     0,     0,    44,    45,
     357,   358,   359,   360,   361,   362,   363,   428,   365,   366,
     367,   368,   369,   370,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   371,   372,   373,
     374,   375,   376,   377,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   378,     0,     0,     0,     0,   379,   380,
     381,   382,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,   393,     0,   394,     0,   395,   396,   397,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     398,   399,     0,     0,   400,   401,   402,   403,     1,     2,
       3,     4,     5,     0,     0,     0,     0,     7,    91,     8,
       0,     0,     0,     0,    10,    11,    12,     0,     0,     0,
       0,    13,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    23,     0,     0,     0,    24,    25,     0,    26,    27,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      30,    31,     0,     0,     0,     0,     0,     0,    32,    33,
      34,    35,     1,     2,     3,     4,     5,     0,     0,     0,
     105,     7,     0,     8,    36,     0,     0,     0,    10,    11,
      12,     0,    37,     0,     0,    13,     0,     0,     0,     0,
      41,     0,     0,    42,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,     0,    23,     0,     0,     0,    24,
      25,     0,    26,    27,    28,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    30,    31,     0,     0,     0,     0,
       0,     0,    32,    33,    34,    35,     1,     2,     3,     4,
       5,     0,     0,     0,     6,     7,     0,     8,    36,     0,
       0,     0,    10,    11,    12,     0,    37,     0,     0,    13,
       0,     0,     0,     0,    41,     0,     0,    42,     0,     0,
      43,     0,     0,     0,     0,     0,     0,     0,     0,    23,
       0,     0,     0,    24,    25,     0,    26,    27,    28,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,    31,
       0,     0,     0,     0,     0,     0,    32,    33,    34,    35,
       1,     2,     3,     4,     5,     0,     0,     0,     0,     7,
     270,     8,    36,     0,     0,     0,    10,    11,    12,     0,
      37,     0,     0,    13,     0,     0,     0,     0,    41,     0,
       0,    42,     0,     0,    43,     0,     0,     0,     0,     0,
       0,     0,     0,    23,     0,     0,     0,    24,    25,     0,
      26,    27,    28,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,    31,     0,     0,     0,     0,     0,     0,
      32,    33,    34,    35,     0,     0,     0,     0,     0,     0,
       1,     2,     3,     4,     5,     0,    36,     0,     0,     7,
       0,     8,   273,     0,    37,     0,    10,    11,    12,     0,
       0,     0,    41,    13,     0,    42,     0,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    23,     0,     0,     0,    24,    25,     0,
      26,    27,    28,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    30,    31,     0,     0,     0,     0,     0,     0,
      32,    33,    34,    35,     1,     2,     3,     4,     5,     0,
       0,     0,     0,     7,   285,     8,    36,     0,     0,     0,
      10,    11,    12,     0,    37,     0,     0,    13,     0,     0,
       0,     0,    41,     0,     0,    42,     0,     0,    43,     0,
       0,     0,     0,     0,     0,     0,     0,    23,     0,     0,
       0,    24,    25,     0,    26,    27,    28,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    30,    31,     0,     0,
       0,     0,     0,     0,    32,    33,    34,    35,     1,     2,
       3,     4,     5,     0,     0,     0,     0,     7,   287,     8,
      36,     0,     0,     0,    10,    11,    12,     0,    37,     0,
       0,    13,     0,     0,     0,     0,    41,     0,     0,    42,
       0,     0,    43,     0,     0,     0,     0,     0,     0,     0,
       0,    23,     0,     0,     0,    24,    25,     0,    26,    27,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      30,    31,     0,     0,     0,     0,     0,     0,    32,    33,
      34,    35,     0,     0,     0,     0,     0,     0,     1,     2,
       3,     4,     5,     0,    36,     0,     0,     7,     0,     8,
     289,     0,    37,     0,    10,    11,    12,     0,     0,     0,
      41,    13,     0,    42,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    23,     0,     0,     0,    24,    25,     0,    26,    27,
      28,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      30,    31,     0,     0,     0,     0,     0,     0,    32,    33,
      34,    35,     1,     2,     3,     4,     5,     0,     0,     0,
       0,     7,   321,     8,    36,     0,     0,     0,    10,    11,
      12,     0,    37,     0,     0,    13,     0,     0,     0,     0,
      41,     0,     0,    42,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,     0,    23,     0,     0,     0,    24,
      25,     0,    26,    27,    28,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    30,    31,     0,     0,     0,     0,
       0,     0,    32,    33,    34,    35,     1,     2,     3,     4,
       5,     0,     0,     0,     0,     7,     0,     8,    36,     0,
       0,     0,    10,    11,    12,     0,    37,     0,     0,    13,
       0,     0,     0,     0,    41,     0,     0,    42,     0,     0,
      43,     0,     0,     0,     0,     0,     0,     0,     0,    23,
       0,     0,     0,    24,    25,     0,    26,    27,    28,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,    31,
       0,     0,     0,     0,     0,     0,    32,    33,    34,    35,
     107,     2,     3,     4,     5,     0,     0,     0,     0,     7,
       0,     8,    36,     0,     0,     0,    10,    11,    12,     0,
      37,     0,     0,     0,     0,     0,     0,     0,    41,     0,
       0,    42,     0,     0,    43,     0,     0,     0,     0,     0,
       0,     0,     0,    23,     0,     0,     0,    24,    25,     0,
      26,    27,    28,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      32,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    36,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,     0,     0,     0,
       0,     0,   356,     0,     0,    42,     0,     0,    43,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   371,   372,   373,   374,
     375,   376,   377,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   378,     0,     0,     0,     0,   379,   380,   381,
     382,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,   393,     0,   394,     0,   395,   396,   397,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   398,
     399,   451,     0,   400,   401,   402,   403,     0,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   371,   372,   373,   374,   375,
     376,   377,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   378,     0,     0,     0,     0,   379,   380,   381,   382,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
     393,     0,   394,     0,   395,   396,   397,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   398,   399,
       0,     0,   400,   401,   402,   403,   357,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   371,   372,   373,   374,   375,   376,   377,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   378,
       0,     0,     0,     0,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,     0,
     394,     0,   395,   396,   397,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   398,   399,     0,     0,
     400,   401,   402,   403
};

static const yytype_int16 yycheck[] =
{
      30,    31,    32,    17,   138,   203,    88,    54,   241,   129,
       3,    41,     7,     8,   100,    16,   133,     9,     3,   356,
     146,   303,    16,    31,     3,    12,     0,    22,    12,     0,
      14,    26,    27,    28,    18,   117,   306,    45,   120,   309,
       3,    55,     3,     4,     5,     6,     7,    26,    43,    24,
      25,    12,     0,    14,    12,     9,     3,    11,    33,    34,
      36,     9,   344,    26,     9,   347,    50,    51,   115,   116,
      15,     9,    46,    11,   200,    46,   123,   124,   311,    26,
     350,    95,   352,   353,    71,     3,    71,    12,    64,    14,
       4,    11,    53,    54,    55,    13,    16,    76,    46,   100,
     101,    15,   300,    98,    99,   100,   100,   102,    26,   446,
      12,    86,    14,   143,   451,     3,     3,     3,   113,   201,
     112,   207,   355,   356,   117,    13,    13,    13,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    26,    26,
      26,    90,    98,    99,    93,     4,    95,    96,    97,    11,
     111,     3,   105,   106,    16,   425,   426,    12,    17,     4,
      11,   191,     4,    12,   298,   118,   119,   301,    12,    14,
     304,    16,    14,   293,    16,   445,     9,   172,   225,   296,
      13,     9,   452,    12,   454,    13,    11,   269,   421,   459,
     460,   273,     9,     9,    98,    99,    13,    13,   431,   194,
       9,     3,     9,   285,    13,   287,    13,    89,   109,   110,
     240,   241,   113,   114,   115,   116,    47,     9,     9,   417,
     453,    13,    13,    49,   219,     9,   221,   222,     9,    13,
       9,     9,    13,     9,    13,    13,     9,    13,     9,    89,
      13,    30,    13,    26,    27,    28,    29,   329,    48,   331,
     179,   180,   181,   182,    21,    22,    23,     9,    10,    11,
     187,   188,   189,   277,   278,    52,    98,    99,    91,   283,
     284,    24,    25,    87,    88,    19,    20,     9,    10,   177,
     178,   311,   416,    18,   279,   280,   281,   282,   183,   184,
      28,   185,   186,     9,    71,     4,     3,    12,    12,     3,
      12,    14,    71,    14,    12,    15,     9,   321,    14,     9,
       9,     4,    17,    14,    35,    17,   101,    15,    12,    16,
      16,    16,    13,    13,     9,   355,   356,   341,    15,    17,
     100,    17,     0,    13,    12,     3,     4,     5,     6,     7,
      11,    11,    17,    11,    12,    17,    14,    13,    16,    13,
      13,    19,    20,    21,    12,    44,    13,    13,    26,    13,
     163,   339,    46,    45,   243,    33,   170,   307,    36,    37,
      38,    39,    40,    41,   316,    43,    44,   171,    46,   174,
     173,   193,    50,    51,   190,    53,    54,    55,   176,   175,
      -1,   421,   406,    -1,   408,   409,    64,    65,    66,    -1,
      -1,   431,    -1,    -1,    -1,    73,    74,    75,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,   453,    -1,    -1,    -1,    -1,    -1,    97,
      -1,    -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,
     108,    -1,    -1,   111,    -1,    -1,     3,     4,     5,     6,
       7,    -1,   120,   121,    11,    12,    -1,    14,    -1,    16,
      17,    -1,    19,    20,    21,    -1,    -1,    -1,    -1,    26,
      -1,    -1,    -1,    -1,    -1,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    -1,    43,    44,    -1,    46,
      -1,    -1,    -1,    50,    51,    -1,    53,    54,    55,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,    65,    66,
      -1,    -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,   103,   104,   105,    -1,
      -1,   108,    -1,    -1,   111,    -1,    -1,     3,     4,     5,
       6,     7,    -1,   120,   121,    11,    12,    -1,    14,    -1,
      16,    17,    -1,    19,    20,    21,    -1,    -1,    -1,    -1,
      26,    -1,    -1,    -1,    -1,    -1,    -1,    33,    -1,    -1,
      36,    37,    38,    39,    40,    41,    -1,    43,    44,    -1,
      46,    -1,    -1,    -1,    50,    51,    -1,    53,    54,    55,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,    65,
      66,    -1,    -1,    -1,    -1,    -1,    -1,    73,    74,    75,
      76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    97,    -1,    -1,    -1,    -1,   102,   103,   104,   105,
      -1,    -1,   108,    -1,    -1,   111,    -1,    -1,     3,     4,
       5,     6,     7,    -1,   120,   121,    11,    12,    -1,    14,
      -1,    16,    -1,    -1,    19,    20,    21,    -1,    -1,    -1,
      -1,    26,    -1,    -1,    -1,    -1,    -1,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    -1,    43,    44,
      -1,    46,    -1,    -1,    -1,    50,    51,    -1,    53,    54,
      55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    64,
      65,    66,    -1,    -1,    -1,    -1,    -1,    -1,    73,    74,
      75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    97,    -1,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,   108,    -1,    -1,   111,    -1,    -1,     3,
       4,     5,     6,     7,    -1,   120,   121,    11,    12,    -1,
      14,    -1,    16,    17,    -1,    19,    20,    21,    -1,    -1,
      -1,    -1,    26,    -1,    -1,    -1,    -1,    -1,    -1,    33,
      -1,    -1,    36,    37,    38,    39,    40,    41,    -1,    -1,
      44,    -1,    46,    -1,    -1,    -1,    50,    51,    -1,    53,
      54,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      64,    65,    66,    -1,    -1,    -1,    -1,    -1,    -1,    73,
      74,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   105,    -1,    -1,   108,    -1,    -1,   111,    -1,    -1,
       3,     4,     5,     6,     7,    -1,   120,   121,    11,    12,
      -1,    14,    -1,    16,    17,    -1,    19,    20,    21,    -1,
      -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,    -1,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    -1,
      -1,    44,    -1,    46,    -1,    -1,    -1,    50,    51,    -1,
      53,    54,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    64,    65,    66,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   105,    -1,    -1,   108,    -1,    -1,   111,    -1,
      -1,     3,     4,     5,     6,     7,    -1,   120,   121,    11,
      12,    -1,    14,    -1,    16,    -1,    -1,    19,    20,    21,
      -1,    -1,    -1,    -1,    26,    -1,    -1,    -1,    -1,    -1,
      -1,    33,    -1,    -1,    36,    37,    38,    39,    40,    41,
      -1,    -1,    44,    -1,    46,    -1,    -1,    -1,    50,    51,
      -1,    53,    54,    55,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    64,    65,    66,    -1,    -1,    -1,    -1,    -1,
      -1,    73,    74,    75,    76,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   105,     3,    -1,   108,    -1,    -1,   111,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,   121,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    46,    47,    48,
      49,    50,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    -1,    93,    -1,    95,    96,    97,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     109,   110,    -1,    -1,   113,   114,   115,   116,     3,     4,
       5,     6,     7,    -1,    -1,    -1,    -1,    12,    13,    14,
      -1,    -1,    -1,    -1,    19,    20,    21,    -1,    -1,    -1,
      -1,    26,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    -1,    50,    51,    -1,    53,    54,
      55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      65,    66,    -1,    -1,    -1,    -1,    -1,    -1,    73,    74,
      75,    76,     3,     4,     5,     6,     7,    -1,    -1,    -1,
      11,    12,    -1,    14,    89,    -1,    -1,    -1,    19,    20,
      21,    -1,    97,    -1,    -1,    26,    -1,    -1,    -1,    -1,
     105,    -1,    -1,   108,    -1,    -1,   111,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    -1,    50,
      51,    -1,    53,    54,    55,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    65,    66,    -1,    -1,    -1,    -1,
      -1,    -1,    73,    74,    75,    76,     3,     4,     5,     6,
       7,    -1,    -1,    -1,    11,    12,    -1,    14,    89,    -1,
      -1,    -1,    19,    20,    21,    -1,    97,    -1,    -1,    26,
      -1,    -1,    -1,    -1,   105,    -1,    -1,   108,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    -1,    50,    51,    -1,    53,    54,    55,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    65,    66,
      -1,    -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,
       3,     4,     5,     6,     7,    -1,    -1,    -1,    -1,    12,
      13,    14,    89,    -1,    -1,    -1,    19,    20,    21,    -1,
      97,    -1,    -1,    26,    -1,    -1,    -1,    -1,   105,    -1,
      -1,   108,    -1,    -1,   111,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    -1,    50,    51,    -1,
      53,    54,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    65,    66,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,     6,     7,    -1,    89,    -1,    -1,    12,
      -1,    14,    15,    -1,    97,    -1,    19,    20,    21,    -1,
      -1,    -1,   105,    26,    -1,   108,    -1,    -1,   111,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    -1,    50,    51,    -1,
      53,    54,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    65,    66,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    76,     3,     4,     5,     6,     7,    -1,
      -1,    -1,    -1,    12,    13,    14,    89,    -1,    -1,    -1,
      19,    20,    21,    -1,    97,    -1,    -1,    26,    -1,    -1,
      -1,    -1,   105,    -1,    -1,   108,    -1,    -1,   111,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      -1,    50,    51,    -1,    53,    54,    55,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    65,    66,    -1,    -1,
      -1,    -1,    -1,    -1,    73,    74,    75,    76,     3,     4,
       5,     6,     7,    -1,    -1,    -1,    -1,    12,    13,    14,
      89,    -1,    -1,    -1,    19,    20,    21,    -1,    97,    -1,
      -1,    26,    -1,    -1,    -1,    -1,   105,    -1,    -1,   108,
      -1,    -1,   111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    -1,    50,    51,    -1,    53,    54,
      55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      65,    66,    -1,    -1,    -1,    -1,    -1,    -1,    73,    74,
      75,    76,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,     6,     7,    -1,    89,    -1,    -1,    12,    -1,    14,
      15,    -1,    97,    -1,    19,    20,    21,    -1,    -1,    -1,
     105,    26,    -1,   108,    -1,    -1,   111,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    -1,    50,    51,    -1,    53,    54,
      55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      65,    66,    -1,    -1,    -1,    -1,    -1,    -1,    73,    74,
      75,    76,     3,     4,     5,     6,     7,    -1,    -1,    -1,
      -1,    12,    13,    14,    89,    -1,    -1,    -1,    19,    20,
      21,    -1,    97,    -1,    -1,    26,    -1,    -1,    -1,    -1,
     105,    -1,    -1,   108,    -1,    -1,   111,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    -1,    50,
      51,    -1,    53,    54,    55,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    65,    66,    -1,    -1,    -1,    -1,
      -1,    -1,    73,    74,    75,    76,     3,     4,     5,     6,
       7,    -1,    -1,    -1,    -1,    12,    -1,    14,    89,    -1,
      -1,    -1,    19,    20,    21,    -1,    97,    -1,    -1,    26,
      -1,    -1,    -1,    -1,   105,    -1,    -1,   108,    -1,    -1,
     111,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    -1,    50,    51,    -1,    53,    54,    55,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    65,    66,
      -1,    -1,    -1,    -1,    -1,    -1,    73,    74,    75,    76,
       3,     4,     5,     6,     7,    -1,    -1,    -1,    -1,    12,
      -1,    14,    89,    -1,    -1,    -1,    19,    20,    21,    -1,
      97,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   105,    -1,
      -1,   108,    -1,    -1,   111,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    -1,    50,    51,    -1,
      53,    54,    55,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    12,    -1,    -1,   108,    -1,    -1,   111,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    46,    47,    48,    49,
      50,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    -1,    -1,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    -1,    93,    -1,    95,    96,    97,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   109,
     110,    12,    -1,   113,   114,   115,   116,    -1,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    47,    48,    49,    50,
      51,    52,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    -1,    -1,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    -1,    93,    -1,    95,    96,    97,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   109,   110,
      -1,    -1,   113,   114,   115,   116,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    47,    48,    49,    50,    51,    52,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    -1,    -1,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    -1,
      93,    -1,    95,    96,    97,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   109,   110,    -1,    -1,
     113,   114,   115,   116
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     3,     4,     5,     6,     7,    11,    12,    14,    16,
      19,    20,    21,    26,    33,    36,    37,    38,    39,    40,
      41,    43,    44,    46,    50,    51,    53,    54,    55,    64,
      65,    66,    73,    74,    75,    76,    89,    97,   102,   103,
     104,   105,   108,   111,   120,   121,   123,   124,   125,   133,
     134,   135,   137,   138,   139,   142,   143,   144,   145,   146,
     147,   148,   151,   154,   155,   156,   157,   158,   160,   163,
     164,   165,   168,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   180,   181,   182,   184,   185,   186,
      71,    13,   155,   155,    17,   142,     3,   132,    12,    12,
      12,   143,    12,    11,    11,    11,   155,     3,   181,   181,
     155,   155,   155,    12,     3,   139,   139,   139,   181,   181,
       3,   161,   162,    76,   139,    89,   155,     4,    14,    16,
     150,     4,    14,    16,   153,     0,   124,    98,    99,   105,
     106,   118,   119,   136,   161,   143,     9,    11,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    90,    93,
      95,    96,    97,   166,   109,   110,   113,   114,   115,   116,
     167,    31,    45,    30,    47,    49,    48,    24,    25,    26,
      27,    28,    29,    87,    88,    19,    20,    21,    22,    23,
      89,    52,   181,    91,    12,    18,    50,    51,   158,    13,
       9,    15,    17,    18,    28,   155,   155,   154,   155,    36,
      64,   155,    11,    13,    13,    13,   155,   161,   161,    12,
     158,    12,    14,   158,   159,     9,   161,   161,   112,    15,
     149,   150,    17,   149,   152,   153,   152,     3,   131,   131,
      12,    12,     3,   139,   140,   156,   157,   160,   170,   155,
     171,   172,   173,   174,   175,   175,   176,   176,   176,   176,
     177,   177,   178,   178,   179,   179,   179,   180,   139,   185,
      13,   155,     3,    15,   158,   132,    71,    13,    13,   154,
      10,    12,    12,    13,    13,    13,   155,    13,   155,    15,
      14,   161,    14,     9,    17,    15,     9,    17,     9,    16,
     100,   101,   126,    16,   100,   130,    13,   139,   141,    13,
     141,    12,    14,   159,     3,   117,    10,    13,   158,   143,
     143,    13,   155,   155,   155,   155,   143,   143,   158,    13,
     158,    13,    15,   149,   152,   131,   125,   127,   128,   129,
     133,   142,   132,   131,    16,   127,   131,    16,   147,   162,
      13,   147,    13,    13,   141,    12,    12,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    46,    47,    48,    49,    50,    51,    52,    72,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    93,    95,    96,    97,   109,   110,
     113,   114,   115,   116,   183,   168,    35,   143,    13,    13,
      13,    13,   158,   158,    17,   128,   101,   100,   127,    17,
     127,     9,   147,   147,   147,    13,    13,   141,    26,   141,
     183,    12,   143,   143,   143,    11,    11,   131,   132,    17,
      17,   141,   147,    11,   147,    13,    13,    13,   141,    11,
     147,    12,   183,    12,    13,   183,   147,   141,   147,    13,
      13,   147,   147
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,   122,   123,   123,   124,   124,   124,   125,   125,   125,
     125,   126,   126,   126,   126,   127,   127,   128,   128,   129,
     129,   129,   130,   131,   131,   132,   132,   133,   133,   133,
     133,   133,   133,   133,   133,   133,   133,   133,   133,   133,
     133,   134,   134,   134,   135,   135,   135,   135,   136,   136,
     136,   137,   137,   138,   138,   139,   139,   140,   140,   141,
     141,   142,   142,   143,   143,   143,   143,   143,   143,   143,
     144,   144,   144,   144,   145,   145,   146,   146,   146,   146,
     146,   146,   146,   146,   147,   147,   148,   148,   148,   148,
     148,   149,   149,   150,   151,   151,   151,   152,   152,   153,
     154,   154,   155,   155,   156,   156,   157,   157,   158,   158,
     158,   158,   159,   159,   160,   160,   160,   160,   160,   160,
     160,   161,   161,   162,   162,   162,   162,   162,   162,   162,
     163,   164,   165,   166,   166,   166,   166,   166,   166,   166,
     166,   166,   166,   166,   166,   166,   166,   166,   167,   167,
     167,   167,   167,   167,   168,   168,   169,   169,   170,   170,
     171,   171,   172,   172,   173,   173,   174,   174,   174,   175,
     175,   175,   175,   175,   176,   176,   176,   177,   177,   177,
     178,   178,   178,   178,   179,   179,   180,   180,   181,   181,
     181,   181,   181,   181,   181,   181,   181,   181,   181,   181,
     182,   182,   182,   182,   182,   182,   182,   183,   183,   183,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   183,   183,   183,   183,   183,   183,   183,   183,   183,
     183,   183,   183,   183,   184,   184,   185,   185,   185,   185,
     185,   185,   185,   186,   186,   186,   186,   186,   186,   186,
     186,   186,   186,   186,   186
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     6,     7,     6,
       7,     2,     4,     2,     4,     1,     0,     1,     2,     1,
       1,     1,     2,     1,     3,     1,     3,     8,     7,     7,
       6,     6,     5,     5,     6,     8,     7,     9,     9,    11,
      11,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       0,     1,     2,     3,     4,     1,     1,     1,     2,     2,
       4,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     2,     2,     5,     7,     5,     7,     6,     7,
       7,     5,     7,     5,     2,     3,     2,     3,     3,     4,
       4,     1,     3,     1,     2,     4,     4,     1,     3,     1,
       1,     2,     1,     3,     1,     3,     1,     3,     3,     4,
       4,     5,     2,     3,     1,     2,     3,     3,     3,     2,
       3,     1,     3,     1,     2,     2,     3,     4,     4,     5,
       3,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     1,     3,     1,     3,
       1,     3,     1,     3,     1,     3,     1,     3,     3,     1,
       3,     3,     3,     3,     1,     3,     3,     1,     3,     3,
       1,     3,     3,     3,     1,     3,     1,     3,     1,     2,
       2,     2,     2,     2,     2,     3,     4,     5,     5,     6,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     2,     3,     4,
       3,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     3,     2
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]));
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Location data for the lookahead symbol.  */
YYLTYPE yylloc
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* program: program_section  */
#line 216 "chuck.y"
                                            { (yyval.program) = g_program = new_program( (yyvsp[0].program_section), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2156 "chuck.tab.c"
    break;

  case 3: /* program: program program_section  */
#line 217 "chuck.y"
                                            { (yyval.program) = g_program = append_program( (yyvsp[-1].program), (yyvsp[0].program_section), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2162 "chuck.tab.c"
    break;

  case 4: /* program_section: statement_list  */
#line 221 "chuck.y"
                                            { (yyval.program_section) = new_section_stmt( (yyvsp[0].stmt_list), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2168 "chuck.tab.c"
    break;

  case 5: /* program_section: function_definition  */
#line 222 "chuck.y"
                                            { (yyval.program_section) = new_section_func_def( (yyvsp[0].func_def), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2174 "chuck.tab.c"
    break;

  case 6: /* program_section: class_definition  */
#line 223 "chuck.y"
                                            { (yyval.program_section) = new_section_class_def( (yyvsp[0].class_def), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2180 "chuck.tab.c"
    break;

  case 7: /* class_definition: class_decl CLASS id_list LBRACE class_body RBRACE  */
#line 228 "chuck.y"
            { (yyval.class_def) = new_class_def( (yyvsp[-5].ival), (yyvsp[-3].id_list), NULL, (yyvsp[-1].class_body), (yylsp[-5]).first_line, (yylsp[-5]).first_column ); }
#line 2186 "chuck.tab.c"
    break;

  case 8: /* class_definition: class_decl CLASS id_list class_ext LBRACE class_body RBRACE  */
#line 230 "chuck.y"
            { (yyval.class_def) = new_class_def( (yyvsp[-6].ival), (yyvsp[-4].id_list), (yyvsp[-3].class_ext), (yyvsp[-1].class_body), (yylsp[-6]).first_line, (yylsp[-6]).first_column ); }
#line 2192 "chuck.tab.c"
    break;

  case 9: /* class_definition: class_decl INTERFACE id_list LBRACE class_body RBRACE  */
#line 232 "chuck.y"
            { (yyval.class_def) = new_iface_def( (yyvsp[-5].ival), (yyvsp[-3].id_list), NULL, (yyvsp[-1].class_body), (yylsp[-5]).first_line, (yylsp[-5]).first_column ); }
#line 2198 "chuck.tab.c"
    break;

  case 10: /* class_definition: class_decl INTERFACE id_list iface_ext LBRACE class_body RBRACE  */
#line 234 "chuck.y"
            { (yyval.class_def) = new_iface_def( (yyvsp[-6].ival), (yyvsp[-4].id_list), (yyvsp[-3].class_ext), (yyvsp[-1].class_body), (yylsp[-6]).first_line, (yylsp[-6]).first_column ); }
#line 2204 "chuck.tab.c"
    break;

  case 11: /* class_ext: IMPLEMENTS id_list  */
#line 238 "chuck.y"
                                            { (yyval.class_ext) = new_class_ext( NULL, (yyvsp[0].id_list), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2210 "chuck.tab.c"
    break;

  case 12: /* class_ext: IMPLEMENTS id_list EXTENDS id_dot  */
#line 239 "chuck.y"
                                            { (yyval.class_ext) = new_class_ext( (yyvsp[0].id_list), (yyvsp[-2].id_list), (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2216 "chuck.tab.c"
    break;

  case 13: /* class_ext: EXTENDS id_dot  */
#line 240 "chuck.y"
                                            { (yyval.class_ext) = new_class_ext( (yyvsp[0].id_list), NULL, (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2222 "chuck.tab.c"
    break;

  case 14: /* class_ext: EXTENDS id_dot IMPLEMENTS id_list  */
#line 241 "chuck.y"
                                            { (yyval.class_ext) = new_class_ext( (yyvsp[-2].id_list), (yyvsp[0].id_list), (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2228 "chuck.tab.c"
    break;

  case 15: /* class_body: class_body2  */
#line 245 "chuck.y"
                                            { (yyval.class_body) = (yyvsp[0].class_body); }
#line 2234 "chuck.tab.c"
    break;

  case 16: /* class_body: %empty  */
#line 246 "chuck.y"
                                                    { (yyval.class_body) = NULL; }
#line 2240 "chuck.tab.c"
    break;

  case 17: /* class_body2: class_section  */
#line 250 "chuck.y"
                                            { (yyval.class_body) = new_class_body( (yyvsp[0].program_section), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2246 "chuck.tab.c"
    break;

  case 18: /* class_body2: class_section class_body2  */
#line 251 "chuck.y"
                                            { (yyval.class_body) = prepend_class_body( (yyvsp[-1].program_section), (yyvsp[0].class_body), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2252 "chuck.tab.c"
    break;

  case 19: /* class_section: statement_list  */
#line 256 "chuck.y"
                                            { (yyval.program_section) = new_section_stmt( (yyvsp[0].stmt_list), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2258 "chuck.tab.c"
    break;

  case 20: /* class_section: function_definition  */
#line 257 "chuck.y"
                                            { (yyval.program_section) = new_section_func_def( (yyvsp[0].func_def), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2264 "chuck.tab.c"
    break;

  case 21: /* class_section: class_definition  */
#line 258 "chuck.y"
                                            { (yyval.program_section) = new_section_class_def( (yyvsp[0].class_def), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2270 "chuck.tab.c"
    break;

  case 22: /* iface_ext: EXTENDS id_list  */
#line 262 "chuck.y"
                                            { (yyval.class_ext) = new_class_ext( NULL, (yyvsp[0].id_list), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2276 "chuck.tab.c"
    break;

  case 23: /* id_list: ID  */
#line 266 "chuck.y"
                                            { (yyval.id_list) = new_id_list( (yyvsp[0].sval), (yylsp[0]).first_line, (yylsp[0]).first_column  /*, &@1 */ ); }
#line 2282 "chuck.tab.c"
    break;

  case 24: /* id_list: ID COMMA id_list  */
#line 267 "chuck.y"
                                            { (yyval.id_list) = prepend_id_list( (yyvsp[-2].sval), (yyvsp[0].id_list), (yylsp[-2]).first_line, (yylsp[-2]).first_column  /*, &@1 */ ); }
#line 2288 "chuck.tab.c"
    break;

  case 25: /* id_dot: ID  */
#line 271 "chuck.y"
                                            { (yyval.id_list) = new_id_list( (yyvsp[0].sval), (yylsp[0]).first_line, (yylsp[0]).first_column  /*, &@1*/ ); }
#line 2294 "chuck.tab.c"
    break;

  case 26: /* id_dot: ID DOT id_dot  */
#line 272 "chuck.y"
                                            { (yyval.id_list) = prepend_id_list( (yyvsp[-2].sval), (yyvsp[0].id_list), (yylsp[-2]).first_line, (yylsp[-2]).first_column  /*, &@1*/ ); }
#line 2300 "chuck.tab.c"
    break;

  case 27: /* function_definition: function_decl static_decl type_decl2 ID LPAREN arg_list RPAREN code_segment  */
#line 277 "chuck.y"
            { (yyval.func_def) = new_func_def( (yyvsp[-7].ival), (yyvsp[-6].ival), (yyvsp[-5].type_decl), (yyvsp[-4].sval), (yyvsp[-2].arg_list), (yyvsp[0].stmt), TRUE, (yylsp[-7]).first_line, (yylsp[-7]).first_column ); }
#line 2306 "chuck.tab.c"
    break;

  case 28: /* function_definition: function_decl static_decl type_decl2 ID LPAREN RPAREN code_segment  */
#line 279 "chuck.y"
            { (yyval.func_def) = new_func_def( (yyvsp[-6].ival), (yyvsp[-5].ival), (yyvsp[-4].type_decl), (yyvsp[-3].sval), NULL, (yyvsp[0].stmt), TRUE, (yylsp[-6]).first_line, (yylsp[-6]).first_column ); }
#line 2312 "chuck.tab.c"
    break;

  case 29: /* function_definition: function_decl static_decl ID LPAREN arg_list RPAREN code_segment  */
#line 281 "chuck.y"
            { (yyval.func_def) = new_func_def( (yyvsp[-6].ival), (yyvsp[-5].ival), NULL, (yyvsp[-4].sval), (yyvsp[-2].arg_list), (yyvsp[0].stmt), TRUE, (yylsp[-6]).first_line, (yylsp[-6]).first_column ); }
#line 2318 "chuck.tab.c"
    break;

  case 30: /* function_definition: function_decl static_decl ID LPAREN RPAREN code_segment  */
#line 283 "chuck.y"
            { (yyval.func_def) = new_func_def( (yyvsp[-5].ival), (yyvsp[-4].ival), NULL, (yyvsp[-3].sval), NULL, (yyvsp[0].stmt), TRUE, (yylsp[-5]).first_line, (yylsp[-5]).first_column ); }
#line 2324 "chuck.tab.c"
    break;

  case 31: /* function_definition: function_decl AT_CTOR LPAREN arg_list RPAREN code_segment  */
#line 285 "chuck.y"
            { (yyval.func_def) = new_func_def( (yyvsp[-5].ival), ae_key_instance, NULL, "@construct", (yyvsp[-2].arg_list), (yyvsp[0].stmt), TRUE, (yylsp[-5]).first_line, (yylsp[-5]).first_column ); }
#line 2330 "chuck.tab.c"
    break;

  case 32: /* function_definition: function_decl AT_CTOR LPAREN RPAREN code_segment  */
#line 287 "chuck.y"
            { (yyval.func_def) = new_func_def( (yyvsp[-4].ival), ae_key_instance, NULL, "@construct", NULL, (yyvsp[0].stmt), TRUE, (yylsp[-4]).first_line, (yylsp[-4]).first_column ); }
#line 2336 "chuck.tab.c"
    break;

  case 33: /* function_definition: function_decl AT_DTOR LPAREN RPAREN code_segment  */
#line 289 "chuck.y"
            { (yyval.func_def) = new_func_def( (yyvsp[-4].ival), ae_key_instance, NULL, "@destruct", NULL, (yyvsp[0].stmt), TRUE, (yylsp[-4]).first_line, (yylsp[-4]).first_column ); }
#line 2342 "chuck.tab.c"
    break;

  case 34: /* function_definition: function_decl AT_DTOR LPAREN arg_list RPAREN code_segment  */
#line 291 "chuck.y"
            { (yyval.func_def) = new_func_def( (yyvsp[-5].ival), ae_key_instance, NULL, "@destruct", (yyvsp[-2].arg_list), (yyvsp[0].stmt), TRUE, (yylsp[-5]).first_line, (yylsp[-5]).first_column ); }
#line 2348 "chuck.tab.c"
    break;

  case 35: /* function_definition: function_decl static_decl type_decl2 ID LPAREN arg_list RPAREN SEMICOLON  */
#line 293 "chuck.y"
            { (yyval.func_def) = new_func_def( (yyvsp[-7].ival), (yyvsp[-6].ival), (yyvsp[-5].type_decl), (yyvsp[-4].sval), (yyvsp[-2].arg_list), NULL, TRUE, (yylsp[-7]).first_line, (yylsp[-7]).first_column ); }
#line 2354 "chuck.tab.c"
    break;

  case 36: /* function_definition: function_decl static_decl type_decl2 ID LPAREN RPAREN SEMICOLON  */
#line 295 "chuck.y"
            { (yyval.func_def) = new_func_def( (yyvsp[-6].ival), (yyvsp[-5].ival), (yyvsp[-4].type_decl), (yyvsp[-3].sval), NULL, NULL, TRUE, (yylsp[-6]).first_line, (yylsp[-6]).first_column ); }
#line 2360 "chuck.tab.c"
    break;

  case 37: /* function_definition: function_decl static_decl type_decl2 AT_OP overloadable_operator LPAREN arg_list RPAREN code_segment  */
#line 297 "chuck.y"
            { (yyval.func_def) = new_op_overload( (yyvsp[-8].ival), (yyvsp[-7].ival), (yyvsp[-6].type_decl), (yyvsp[-4].ival), (yyvsp[-2].arg_list), (yyvsp[0].stmt), TRUE, FALSE, (yylsp[-8]).first_line, (yylsp[-8]).first_column, (yylsp[-4]).first_column ); }
#line 2366 "chuck.tab.c"
    break;

  case 38: /* function_definition: function_decl static_decl type_decl2 AT_OP LPAREN arg_list RPAREN overloadable_operator code_segment  */
#line 299 "chuck.y"
            { (yyval.func_def) = new_op_overload( (yyvsp[-8].ival), (yyvsp[-7].ival), (yyvsp[-6].type_decl), (yyvsp[-1].ival), (yyvsp[-3].arg_list), (yyvsp[0].stmt), TRUE, TRUE, (yylsp[-8]).first_line, (yylsp[-8]).first_column, (yylsp[-1]).first_column ); }
#line 2372 "chuck.tab.c"
    break;

  case 39: /* function_definition: function_decl static_decl type_decl2 AT_OP LPAREN overloadable_operator RPAREN LPAREN arg_list RPAREN code_segment  */
#line 301 "chuck.y"
            { (yyval.func_def) = new_op_overload( (yyvsp[-10].ival), (yyvsp[-9].ival), (yyvsp[-8].type_decl), (yyvsp[-5].ival), (yyvsp[-2].arg_list), (yyvsp[0].stmt), TRUE, FALSE, (yylsp[-10]).first_line, (yylsp[-10]).first_column, (yylsp[-6]).first_column ); }
#line 2378 "chuck.tab.c"
    break;

  case 40: /* function_definition: function_decl static_decl type_decl2 AT_OP LPAREN arg_list RPAREN LPAREN overloadable_operator RPAREN code_segment  */
#line 303 "chuck.y"
            { (yyval.func_def) = new_op_overload( (yyvsp[-10].ival), (yyvsp[-9].ival), (yyvsp[-8].type_decl), (yyvsp[-2].ival), (yyvsp[-5].arg_list), (yyvsp[0].stmt), TRUE, TRUE, (yylsp[-10]).first_line, (yylsp[-10]).first_column, (yylsp[-3]).first_column ); }
#line 2384 "chuck.tab.c"
    break;

  case 41: /* class_decl: PUBLIC  */
#line 307 "chuck.y"
                                            { (yyval.ival) = ae_key_public; }
#line 2390 "chuck.tab.c"
    break;

  case 42: /* class_decl: PRIVATE  */
#line 308 "chuck.y"
                                            { (yyval.ival) = ae_key_private; }
#line 2396 "chuck.tab.c"
    break;

  case 43: /* class_decl: %empty  */
#line 309 "chuck.y"
                                            { (yyval.ival) = ae_key_private; }
#line 2402 "chuck.tab.c"
    break;

  case 44: /* function_decl: FUNCTION  */
#line 313 "chuck.y"
                                            { (yyval.ival) = ae_key_func; }
#line 2408 "chuck.tab.c"
    break;

  case 45: /* function_decl: PUBLIC  */
#line 314 "chuck.y"
                                            { (yyval.ival) = ae_key_public; }
#line 2414 "chuck.tab.c"
    break;

  case 46: /* function_decl: PROTECTED  */
#line 315 "chuck.y"
                                            { (yyval.ival) = ae_key_protected; }
#line 2420 "chuck.tab.c"
    break;

  case 47: /* function_decl: PRIVATE  */
#line 316 "chuck.y"
                                            { (yyval.ival) = ae_key_private; }
#line 2426 "chuck.tab.c"
    break;

  case 48: /* static_decl: STATIC  */
#line 320 "chuck.y"
                                            { (yyval.ival) = ae_key_static; }
#line 2432 "chuck.tab.c"
    break;

  case 49: /* static_decl: ABSTRACT  */
#line 321 "chuck.y"
                                            { (yyval.ival) = ae_key_abstract; }
#line 2438 "chuck.tab.c"
    break;

  case 50: /* static_decl: %empty  */
#line 322 "chuck.y"
                                            { (yyval.ival) = ae_key_instance; }
#line 2444 "chuck.tab.c"
    break;

  case 51: /* type_decl_a: ID  */
#line 326 "chuck.y"
                                            { (yyval.type_decl) = new_type_decl( new_id_list( (yyvsp[0].sval), (yylsp[0]).first_line, (yylsp[0]).first_column /*, &@1*/ ), 0, (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2450 "chuck.tab.c"
    break;

  case 52: /* type_decl_a: ID AT_SYM  */
#line 327 "chuck.y"
                                            { (yyval.type_decl) = new_type_decl( new_id_list( (yyvsp[-1].sval), (yylsp[-1]).first_line, (yylsp[-1]).first_column /*, &@1*/ ), 1, (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2456 "chuck.tab.c"
    break;

  case 53: /* type_decl_b: LT id_dot GT  */
#line 331 "chuck.y"
                                            { (yyval.type_decl) = new_type_decl( (yyvsp[-1].id_list), 0, (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2462 "chuck.tab.c"
    break;

  case 54: /* type_decl_b: LT id_dot GT AT_SYM  */
#line 332 "chuck.y"
                                            { (yyval.type_decl) = new_type_decl( (yyvsp[-2].id_list), 1, (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2468 "chuck.tab.c"
    break;

  case 55: /* type_decl: type_decl_a  */
#line 341 "chuck.y"
                                            { (yyval.type_decl) = (yyvsp[0].type_decl); }
#line 2474 "chuck.tab.c"
    break;

  case 56: /* type_decl: type_decl_b  */
#line 342 "chuck.y"
                                            { (yyval.type_decl) = (yyvsp[0].type_decl); }
#line 2480 "chuck.tab.c"
    break;

  case 57: /* type_decl2: type_decl  */
#line 347 "chuck.y"
                                            { (yyval.type_decl) = (yyvsp[0].type_decl); }
#line 2486 "chuck.tab.c"
    break;

  case 58: /* type_decl2: type_decl array_empty  */
#line 348 "chuck.y"
                                            { (yyval.type_decl) = add_type_decl_array( (yyvsp[-1].type_decl), (yyvsp[0].array_sub), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2492 "chuck.tab.c"
    break;

  case 59: /* arg_list: type_decl var_decl  */
#line 352 "chuck.y"
                                            { (yyval.arg_list) = new_arg_list( (yyvsp[-1].type_decl), (yyvsp[0].var_decl), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2498 "chuck.tab.c"
    break;

  case 60: /* arg_list: type_decl var_decl COMMA arg_list  */
#line 353 "chuck.y"
                                            { (yyval.arg_list) = prepend_arg_list( (yyvsp[-3].type_decl), (yyvsp[-2].var_decl), (yyvsp[0].arg_list), (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2504 "chuck.tab.c"
    break;

  case 61: /* statement_list: statement  */
#line 357 "chuck.y"
                                            { (yyval.stmt_list) = new_stmt_list( (yyvsp[0].stmt), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2510 "chuck.tab.c"
    break;

  case 62: /* statement_list: statement_list statement  */
#line 358 "chuck.y"
                                            { (yyval.stmt_list) = append_stmt_list( (yyvsp[-1].stmt_list), (yyvsp[0].stmt), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2516 "chuck.tab.c"
    break;

  case 63: /* statement: expression_statement  */
#line 362 "chuck.y"
                                            { (yyval.stmt) = (yyvsp[0].stmt); }
#line 2522 "chuck.tab.c"
    break;

  case 64: /* statement: loop_statement  */
#line 363 "chuck.y"
                                            { (yyval.stmt) = (yyvsp[0].stmt); }
#line 2528 "chuck.tab.c"
    break;

  case 65: /* statement: selection_statement  */
#line 364 "chuck.y"
                                            { (yyval.stmt) = (yyvsp[0].stmt); }
#line 2534 "chuck.tab.c"
    break;

  case 66: /* statement: jump_statement  */
#line 365 "chuck.y"
                                            { (yyval.stmt) = (yyvsp[0].stmt); }
#line 2540 "chuck.tab.c"
    break;

  case 67: /* statement: code_segment  */
#line 367 "chuck.y"
                                            { (yyval.stmt) = (yyvsp[0].stmt); }
#line 2546 "chuck.tab.c"
    break;

  case 68: /* statement: import_statement  */
#line 368 "chuck.y"
                                            { (yyval.stmt) = (yyvsp[0].stmt); }
#line 2552 "chuck.tab.c"
    break;

  case 69: /* statement: doc_statement  */
#line 369 "chuck.y"
                                            { (yyval.stmt) = (yyvsp[0].stmt); }
#line 2558 "chuck.tab.c"
    break;

  case 70: /* jump_statement: RETURN SEMICOLON  */
#line 373 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_return( NULL, (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2564 "chuck.tab.c"
    break;

  case 71: /* jump_statement: RETURN expression SEMICOLON  */
#line 374 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_return( (yyvsp[-1].exp), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2570 "chuck.tab.c"
    break;

  case 72: /* jump_statement: BREAK SEMICOLON  */
#line 375 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_break( (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2576 "chuck.tab.c"
    break;

  case 73: /* jump_statement: CONTINUE SEMICOLON  */
#line 376 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_continue( (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2582 "chuck.tab.c"
    break;

  case 74: /* selection_statement: IF LPAREN expression RPAREN statement  */
#line 381 "chuck.y"
            { (yyval.stmt) = new_stmt_from_if( (yyvsp[-2].exp), (yyvsp[0].stmt), NULL, (yylsp[-4]).first_line, (yylsp[-4]).first_column ); }
#line 2588 "chuck.tab.c"
    break;

  case 75: /* selection_statement: IF LPAREN expression RPAREN statement ELSE statement  */
#line 383 "chuck.y"
            { (yyval.stmt) = new_stmt_from_if( (yyvsp[-4].exp), (yyvsp[-2].stmt), (yyvsp[0].stmt), (yylsp[-6]).first_line, (yylsp[-6]).first_column ); }
#line 2594 "chuck.tab.c"
    break;

  case 76: /* loop_statement: WHILE LPAREN expression RPAREN statement  */
#line 388 "chuck.y"
            { (yyval.stmt) = new_stmt_from_while( (yyvsp[-2].exp), (yyvsp[0].stmt), (yylsp[-4]).first_line, (yylsp[-4]).first_column ); }
#line 2600 "chuck.tab.c"
    break;

  case 77: /* loop_statement: DO statement WHILE LPAREN expression RPAREN SEMICOLON  */
#line 390 "chuck.y"
            { (yyval.stmt) = new_stmt_from_do_while( (yyvsp[-2].exp), (yyvsp[-5].stmt), (yylsp[-6]).first_line, (yylsp[-6]).first_column ); }
#line 2606 "chuck.tab.c"
    break;

  case 78: /* loop_statement: FOR LPAREN expression_statement expression_statement RPAREN statement  */
#line 392 "chuck.y"
            { (yyval.stmt) = new_stmt_from_for( (yyvsp[-3].stmt), (yyvsp[-2].stmt), NULL, (yyvsp[0].stmt), (yylsp[-5]).first_line, (yylsp[-5]).first_column ); }
#line 2612 "chuck.tab.c"
    break;

  case 79: /* loop_statement: FOR LPAREN expression_statement expression_statement expression RPAREN statement  */
#line 394 "chuck.y"
            { (yyval.stmt) = new_stmt_from_for( (yyvsp[-4].stmt), (yyvsp[-3].stmt), (yyvsp[-2].exp), (yyvsp[0].stmt), (yylsp[-6]).first_line, (yylsp[-6]).first_column ); }
#line 2618 "chuck.tab.c"
    break;

  case 80: /* loop_statement: FOR LPAREN expression COLON expression RPAREN statement  */
#line 396 "chuck.y"
            { (yyval.stmt) = new_stmt_from_foreach( (yyvsp[-4].exp), (yyvsp[-2].exp), (yyvsp[0].stmt), (yylsp[-6]).first_line, (yylsp[-6]).first_column ); }
#line 2624 "chuck.tab.c"
    break;

  case 81: /* loop_statement: UNTIL LPAREN expression RPAREN statement  */
#line 398 "chuck.y"
            { (yyval.stmt) = new_stmt_from_until( (yyvsp[-2].exp), (yyvsp[0].stmt), (yylsp[-4]).first_line, (yylsp[-4]).first_column ); }
#line 2630 "chuck.tab.c"
    break;

  case 82: /* loop_statement: DO statement UNTIL LPAREN expression RPAREN SEMICOLON  */
#line 400 "chuck.y"
            { (yyval.stmt) = new_stmt_from_do_until( (yyvsp[-2].exp), (yyvsp[-5].stmt), (yylsp[-6]).first_line, (yylsp[-6]).first_column ); }
#line 2636 "chuck.tab.c"
    break;

  case 83: /* loop_statement: LOOP LPAREN expression RPAREN statement  */
#line 402 "chuck.y"
            { (yyval.stmt) = new_stmt_from_loop( (yyvsp[-2].exp), (yyvsp[0].stmt), (yylsp[-4]).first_line, (yylsp[-4]).first_column ); }
#line 2642 "chuck.tab.c"
    break;

  case 84: /* code_segment: LBRACE RBRACE  */
#line 406 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_code( NULL, (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2648 "chuck.tab.c"
    break;

  case 85: /* code_segment: LBRACE statement_list RBRACE  */
#line 407 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_code( (yyvsp[-1].stmt_list), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2654 "chuck.tab.c"
    break;

  case 86: /* import_statement: AT_IMPORT import_target  */
#line 411 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_import( (yyvsp[0].import), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2660 "chuck.tab.c"
    break;

  case 87: /* import_statement: AT_IMPORT LBRACK RBRACK  */
#line 412 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_import( NULL, (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2666 "chuck.tab.c"
    break;

  case 88: /* import_statement: AT_IMPORT LBRACE RBRACE  */
#line 413 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_import( NULL, (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2672 "chuck.tab.c"
    break;

  case 89: /* import_statement: AT_IMPORT LBRACK import_list LBRACK  */
#line 414 "chuck.y"
                                              { (yyval.stmt) = new_stmt_from_import( (yyvsp[-1].import), (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2678 "chuck.tab.c"
    break;

  case 90: /* import_statement: AT_IMPORT LBRACE import_list RBRACE  */
#line 415 "chuck.y"
                                              { (yyval.stmt) = new_stmt_from_import( (yyvsp[-1].import), (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2684 "chuck.tab.c"
    break;

  case 91: /* import_list: import_target  */
#line 419 "chuck.y"
                                            { (yyval.import) = (yyvsp[0].import); }
#line 2690 "chuck.tab.c"
    break;

  case 92: /* import_list: import_target COMMA import_list  */
#line 420 "chuck.y"
                                            { (yyval.import) = prepend_import( (yyvsp[-2].import), (yyvsp[0].import), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2696 "chuck.tab.c"
    break;

  case 93: /* import_target: STRING_LIT  */
#line 424 "chuck.y"
                                            { (yyval.import) = new_import( (yyvsp[0].sval), NULL, (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2702 "chuck.tab.c"
    break;

  case 94: /* doc_statement: AT_DOC doc_target  */
#line 429 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_doc( (yyvsp[0].doc), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2708 "chuck.tab.c"
    break;

  case 95: /* doc_statement: AT_DOC LBRACK doc_list RBRACK  */
#line 430 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_doc( (yyvsp[-1].doc), (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2714 "chuck.tab.c"
    break;

  case 96: /* doc_statement: AT_DOC LBRACE doc_list RBRACE  */
#line 431 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_doc( (yyvsp[-1].doc), (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2720 "chuck.tab.c"
    break;

  case 97: /* doc_list: doc_target  */
#line 435 "chuck.y"
                                            { (yyval.doc) = (yyvsp[0].doc); }
#line 2726 "chuck.tab.c"
    break;

  case 98: /* doc_list: doc_target COMMA doc_list  */
#line 436 "chuck.y"
                                            { (yyval.doc) = prepend_doc( (yyvsp[-2].doc), (yyvsp[0].doc), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2732 "chuck.tab.c"
    break;

  case 99: /* doc_target: STRING_LIT  */
#line 440 "chuck.y"
                                            { (yyval.doc) = new_doc( (yyvsp[0].sval), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2738 "chuck.tab.c"
    break;

  case 100: /* expression_statement: SEMICOLON  */
#line 444 "chuck.y"
                                            { (yyval.stmt) = NULL; }
#line 2744 "chuck.tab.c"
    break;

  case 101: /* expression_statement: expression SEMICOLON  */
#line 445 "chuck.y"
                                            { (yyval.stmt) = new_stmt_from_expression( (yyvsp[-1].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2750 "chuck.tab.c"
    break;

  case 102: /* expression: chuck_expression  */
#line 449 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 2756 "chuck.tab.c"
    break;

  case 103: /* expression: expression COMMA chuck_expression  */
#line 450 "chuck.y"
                                            { (yyval.exp) = append_expression( (yyvsp[-2].exp), (yyvsp[0].exp), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2762 "chuck.tab.c"
    break;

  case 104: /* chuck_expression: arrow_expression  */
#line 454 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 2768 "chuck.tab.c"
    break;

  case 105: /* chuck_expression: chuck_expression chuck_operator arrow_expression  */
#line 456 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), (yyvsp[-1].ival), (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2774 "chuck.tab.c"
    break;

  case 106: /* arrow_expression: decl_expression  */
#line 460 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 2780 "chuck.tab.c"
    break;

  case 107: /* arrow_expression: arrow_expression arrow_operator decl_expression  */
#line 462 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), (yyvsp[-1].ival), (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2786 "chuck.tab.c"
    break;

  case 108: /* array_exp: LBRACK expression RBRACK  */
#line 466 "chuck.y"
                                            { (yyval.array_sub) = new_array_sub( (yyvsp[-1].exp), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2792 "chuck.tab.c"
    break;

  case 109: /* array_exp: LBRACK expression COMMA RBRACK  */
#line 467 "chuck.y"
                                            { (yyval.array_sub) = new_array_sub( (yyvsp[-2].exp), (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2798 "chuck.tab.c"
    break;

  case 110: /* array_exp: LBRACK expression RBRACK array_exp  */
#line 469 "chuck.y"
            { (yyval.array_sub) = prepend_array_sub( (yyvsp[0].array_sub), (yyvsp[-2].exp), (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2804 "chuck.tab.c"
    break;

  case 111: /* array_exp: LBRACK expression COMMA RBRACK array_exp  */
#line 471 "chuck.y"
            { (yyval.array_sub) = prepend_array_sub( (yyvsp[0].array_sub), (yyvsp[-3].exp), (yylsp[-4]).first_line, (yylsp[-4]).first_column ); }
#line 2810 "chuck.tab.c"
    break;

  case 112: /* array_empty: LBRACK RBRACK  */
#line 475 "chuck.y"
                                            { (yyval.array_sub) = new_array_sub( NULL, (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2816 "chuck.tab.c"
    break;

  case 113: /* array_empty: array_empty LBRACK RBRACK  */
#line 476 "chuck.y"
                                            { (yyval.array_sub) = prepend_array_sub( (yyvsp[-2].array_sub), NULL, (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2822 "chuck.tab.c"
    break;

  case 114: /* decl_expression: conditional_expression  */
#line 480 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 2828 "chuck.tab.c"
    break;

  case 115: /* decl_expression: type_decl var_decl_list  */
#line 481 "chuck.y"
                                            { (yyval.exp) = new_exp_decl( (yyvsp[-1].type_decl), (yyvsp[0].var_decl_list), 0, 0, (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2834 "chuck.tab.c"
    break;

  case 116: /* decl_expression: EXTERNAL type_decl var_decl_list  */
#line 482 "chuck.y"
                                            { (yyval.exp) = new_exp_decl_external( (yyvsp[-1].type_decl), (yyvsp[0].var_decl_list), 0, 0, (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2840 "chuck.tab.c"
    break;

  case 117: /* decl_expression: GLOBAL type_decl var_decl_list  */
#line 483 "chuck.y"
                                            { (yyval.exp) = new_exp_decl_global( (yyvsp[-1].type_decl), (yyvsp[0].var_decl_list), 0, 0, (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2846 "chuck.tab.c"
    break;

  case 118: /* decl_expression: STATIC type_decl var_decl_list  */
#line 484 "chuck.y"
                                            { (yyval.exp) = new_exp_decl( (yyvsp[-1].type_decl), (yyvsp[0].var_decl_list), 1, 0, (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2852 "chuck.tab.c"
    break;

  case 119: /* decl_expression: SAME var_decl_list  */
#line 485 "chuck.y"
                                            { (yyval.exp) = new_exp_decl( NULL, (yyvsp[0].var_decl_list), 0, 0, (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2858 "chuck.tab.c"
    break;

  case 120: /* decl_expression: STATIC SAME var_decl_list  */
#line 486 "chuck.y"
                                            { (yyval.exp) = new_exp_decl( NULL, (yyvsp[0].var_decl_list), 1, 0, (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2864 "chuck.tab.c"
    break;

  case 121: /* var_decl_list: var_decl  */
#line 490 "chuck.y"
                                            { (yyval.var_decl_list) = new_var_decl_list( (yyvsp[0].var_decl), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2870 "chuck.tab.c"
    break;

  case 122: /* var_decl_list: var_decl COMMA var_decl_list  */
#line 491 "chuck.y"
                                            { (yyval.var_decl_list) = prepend_var_decl_list( (yyvsp[-2].var_decl), (yyvsp[0].var_decl_list), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2876 "chuck.tab.c"
    break;

  case 123: /* var_decl: ID  */
#line 495 "chuck.y"
                                            { (yyval.var_decl) = new_var_decl( (yyvsp[0].sval), FALSE, NULL, NULL, (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 2882 "chuck.tab.c"
    break;

  case 124: /* var_decl: ID array_exp  */
#line 496 "chuck.y"
                                            { (yyval.var_decl) = new_var_decl( (yyvsp[-1].sval), FALSE, NULL, (yyvsp[0].array_sub), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2888 "chuck.tab.c"
    break;

  case 125: /* var_decl: ID array_empty  */
#line 497 "chuck.y"
                                            { (yyval.var_decl) = new_var_decl( (yyvsp[-1].sval), FALSE, NULL, (yyvsp[0].array_sub), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 2894 "chuck.tab.c"
    break;

  case 126: /* var_decl: ID LPAREN RPAREN  */
#line 498 "chuck.y"
                                            { (yyval.var_decl) = new_var_decl( (yyvsp[-2].sval), TRUE, NULL, NULL, (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2900 "chuck.tab.c"
    break;

  case 127: /* var_decl: ID LPAREN expression RPAREN  */
#line 499 "chuck.y"
                                            { (yyval.var_decl) = new_var_decl( (yyvsp[-3].sval), TRUE, (yyvsp[-1].exp), NULL, (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2906 "chuck.tab.c"
    break;

  case 128: /* var_decl: ID LPAREN RPAREN array_exp  */
#line 500 "chuck.y"
                                            { (yyval.var_decl) = new_var_decl( (yyvsp[-3].sval), TRUE, NULL, (yyvsp[0].array_sub), (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 2912 "chuck.tab.c"
    break;

  case 129: /* var_decl: ID LPAREN expression RPAREN array_exp  */
#line 501 "chuck.y"
                                                 { (yyval.var_decl) = new_var_decl( (yyvsp[-4].sval), TRUE, (yyvsp[-2].exp), (yyvsp[0].array_sub), (yylsp[-4]).first_line, (yylsp[-4]).first_column ); }
#line 2918 "chuck.tab.c"
    break;

  case 130: /* complex_exp: POUNDPAREN expression RPAREN  */
#line 506 "chuck.y"
            { (yyval.complex_exp) = new_complex( (yyvsp[-1].exp), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2924 "chuck.tab.c"
    break;

  case 131: /* polar_exp: PERCENTPAREN expression RPAREN  */
#line 511 "chuck.y"
            { (yyval.polar_exp) = new_polar( (yyvsp[-1].exp), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2930 "chuck.tab.c"
    break;

  case 132: /* vec_exp: ATPAREN expression RPAREN  */
#line 516 "chuck.y"
            { (yyval.vec_exp) = new_vec( (yyvsp[-1].exp), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 2936 "chuck.tab.c"
    break;

  case 133: /* chuck_operator: CHUCK  */
#line 520 "chuck.y"
                                            { (yyval.ival) = ae_op_chuck; }
#line 2942 "chuck.tab.c"
    break;

  case 134: /* chuck_operator: AT_CHUCK  */
#line 521 "chuck.y"
                                            { (yyval.ival) = ae_op_at_chuck; }
#line 2948 "chuck.tab.c"
    break;

  case 135: /* chuck_operator: PLUS_CHUCK  */
#line 522 "chuck.y"
                                            { (yyval.ival) = ae_op_plus_chuck; }
#line 2954 "chuck.tab.c"
    break;

  case 136: /* chuck_operator: MINUS_CHUCK  */
#line 523 "chuck.y"
                                            { (yyval.ival) = ae_op_minus_chuck; }
#line 2960 "chuck.tab.c"
    break;

  case 137: /* chuck_operator: TIMES_CHUCK  */
#line 524 "chuck.y"
                                            { (yyval.ival) = ae_op_times_chuck; }
#line 2966 "chuck.tab.c"
    break;

  case 138: /* chuck_operator: DIVIDE_CHUCK  */
#line 525 "chuck.y"
                                            { (yyval.ival) = ae_op_divide_chuck; }
#line 2972 "chuck.tab.c"
    break;

  case 139: /* chuck_operator: SHIFT_RIGHT_CHUCK  */
#line 526 "chuck.y"
                                            { (yyval.ival) = ae_op_shift_right_chuck; }
#line 2978 "chuck.tab.c"
    break;

  case 140: /* chuck_operator: SHIFT_LEFT_CHUCK  */
#line 527 "chuck.y"
                                            { (yyval.ival) = ae_op_shift_left_chuck; }
#line 2984 "chuck.tab.c"
    break;

  case 141: /* chuck_operator: PERCENT_CHUCK  */
#line 528 "chuck.y"
                                            { (yyval.ival) = ae_op_percent_chuck; }
#line 2990 "chuck.tab.c"
    break;

  case 142: /* chuck_operator: UNCHUCK  */
#line 529 "chuck.y"
                                            { (yyval.ival) = ae_op_unchuck; }
#line 2996 "chuck.tab.c"
    break;

  case 143: /* chuck_operator: UPCHUCK  */
#line 530 "chuck.y"
                                            { (yyval.ival) = ae_op_upchuck; }
#line 3002 "chuck.tab.c"
    break;

  case 144: /* chuck_operator: DOWNCHUCK  */
#line 531 "chuck.y"
                                            { (yyval.ival) = ae_op_downchuck; }
#line 3008 "chuck.tab.c"
    break;

  case 145: /* chuck_operator: S_AND_CHUCK  */
#line 532 "chuck.y"
                                            { (yyval.ival) = ae_op_s_and_chuck; }
#line 3014 "chuck.tab.c"
    break;

  case 146: /* chuck_operator: S_OR_CHUCK  */
#line 533 "chuck.y"
                                            { (yyval.ival) = ae_op_s_or_chuck; }
#line 3020 "chuck.tab.c"
    break;

  case 147: /* chuck_operator: S_XOR_CHUCK  */
#line 534 "chuck.y"
                                            { (yyval.ival) = ae_op_s_xor_chuck; }
#line 3026 "chuck.tab.c"
    break;

  case 148: /* arrow_operator: ARROW_LEFT  */
#line 538 "chuck.y"
                                            { (yyval.ival) = ae_op_arrow_left; }
#line 3032 "chuck.tab.c"
    break;

  case 149: /* arrow_operator: ARROW_RIGHT  */
#line 539 "chuck.y"
                                            { (yyval.ival) = ae_op_arrow_right; }
#line 3038 "chuck.tab.c"
    break;

  case 150: /* arrow_operator: GRUCK_LEFT  */
#line 540 "chuck.y"
                                            { (yyval.ival) = ae_op_gruck_left; }
#line 3044 "chuck.tab.c"
    break;

  case 151: /* arrow_operator: GRUCK_RIGHT  */
#line 541 "chuck.y"
                                            { (yyval.ival) = ae_op_gruck_right; }
#line 3050 "chuck.tab.c"
    break;

  case 152: /* arrow_operator: UNGRUCK_LEFT  */
#line 542 "chuck.y"
                                            { (yyval.ival) = ae_op_ungruck_left; }
#line 3056 "chuck.tab.c"
    break;

  case 153: /* arrow_operator: UNGRUCK_RIGHT  */
#line 543 "chuck.y"
                                            { (yyval.ival) = ae_op_ungruck_right; }
#line 3062 "chuck.tab.c"
    break;

  case 154: /* conditional_expression: logical_or_expression  */
#line 547 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3068 "chuck.tab.c"
    break;

  case 155: /* conditional_expression: logical_or_expression QUESTION expression COLON conditional_expression  */
#line 549 "chuck.y"
            { (yyval.exp) = new_exp_from_if( (yyvsp[-4].exp), (yyvsp[-2].exp), (yyvsp[0].exp), (yylsp[-4]).first_line, (yylsp[-4]).first_column ); }
#line 3074 "chuck.tab.c"
    break;

  case 156: /* logical_or_expression: logical_and_expression  */
#line 553 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3080 "chuck.tab.c"
    break;

  case 157: /* logical_or_expression: logical_or_expression OR logical_and_expression  */
#line 555 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_or, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3086 "chuck.tab.c"
    break;

  case 158: /* logical_and_expression: inclusive_or_expression  */
#line 559 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3092 "chuck.tab.c"
    break;

  case 159: /* logical_and_expression: logical_and_expression AND inclusive_or_expression  */
#line 561 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_and, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3098 "chuck.tab.c"
    break;

  case 160: /* inclusive_or_expression: exclusive_or_expression  */
#line 565 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3104 "chuck.tab.c"
    break;

  case 161: /* inclusive_or_expression: inclusive_or_expression S_OR exclusive_or_expression  */
#line 567 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_s_or, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3110 "chuck.tab.c"
    break;

  case 162: /* exclusive_or_expression: and_expression  */
#line 571 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3116 "chuck.tab.c"
    break;

  case 163: /* exclusive_or_expression: exclusive_or_expression S_XOR and_expression  */
#line 573 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_s_xor, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3122 "chuck.tab.c"
    break;

  case 164: /* and_expression: equality_expression  */
#line 577 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3128 "chuck.tab.c"
    break;

  case 165: /* and_expression: and_expression S_AND equality_expression  */
#line 579 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_s_and, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3134 "chuck.tab.c"
    break;

  case 166: /* equality_expression: relational_expression  */
#line 583 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3140 "chuck.tab.c"
    break;

  case 167: /* equality_expression: equality_expression EQ relational_expression  */
#line 585 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_eq, (yyvsp[0].exp), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 3146 "chuck.tab.c"
    break;

  case 168: /* equality_expression: equality_expression NEQ relational_expression  */
#line 587 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_neq, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3152 "chuck.tab.c"
    break;

  case 169: /* relational_expression: shift_expression  */
#line 591 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3158 "chuck.tab.c"
    break;

  case 170: /* relational_expression: relational_expression LT shift_expression  */
#line 593 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_lt, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3164 "chuck.tab.c"
    break;

  case 171: /* relational_expression: relational_expression GT shift_expression  */
#line 595 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_gt, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3170 "chuck.tab.c"
    break;

  case 172: /* relational_expression: relational_expression LE shift_expression  */
#line 597 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_le, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3176 "chuck.tab.c"
    break;

  case 173: /* relational_expression: relational_expression GE shift_expression  */
#line 599 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_ge, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3182 "chuck.tab.c"
    break;

  case 174: /* shift_expression: additive_expression  */
#line 603 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3188 "chuck.tab.c"
    break;

  case 175: /* shift_expression: shift_expression SHIFT_LEFT additive_expression  */
#line 605 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_shift_left, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3194 "chuck.tab.c"
    break;

  case 176: /* shift_expression: shift_expression SHIFT_RIGHT additive_expression  */
#line 607 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_shift_right, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3200 "chuck.tab.c"
    break;

  case 177: /* additive_expression: multiplicative_expression  */
#line 611 "chuck.y"
                                             { (yyval.exp) = (yyvsp[0].exp); }
#line 3206 "chuck.tab.c"
    break;

  case 178: /* additive_expression: additive_expression PLUS multiplicative_expression  */
#line 613 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_plus, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3212 "chuck.tab.c"
    break;

  case 179: /* additive_expression: additive_expression MINUS multiplicative_expression  */
#line 615 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_minus, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3218 "chuck.tab.c"
    break;

  case 180: /* multiplicative_expression: tilda_expression  */
#line 619 "chuck.y"
                                             { (yyval.exp) = (yyvsp[0].exp); }
#line 3224 "chuck.tab.c"
    break;

  case 181: /* multiplicative_expression: multiplicative_expression TIMES tilda_expression  */
#line 621 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_times, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3230 "chuck.tab.c"
    break;

  case 182: /* multiplicative_expression: multiplicative_expression DIVIDE tilda_expression  */
#line 623 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_divide, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3236 "chuck.tab.c"
    break;

  case 183: /* multiplicative_expression: multiplicative_expression PERCENT tilda_expression  */
#line 625 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_percent, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3242 "chuck.tab.c"
    break;

  case 184: /* tilda_expression: cast_expression  */
#line 629 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3248 "chuck.tab.c"
    break;

  case 185: /* tilda_expression: tilda_expression TILDA cast_expression  */
#line 631 "chuck.y"
            { (yyval.exp) = new_exp_from_binary( (yyvsp[-2].exp), ae_op_tilda, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3254 "chuck.tab.c"
    break;

  case 186: /* cast_expression: unary_expression  */
#line 635 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3260 "chuck.tab.c"
    break;

  case 187: /* cast_expression: cast_expression DOLLAR type_decl  */
#line 637 "chuck.y"
            { (yyval.exp) = new_exp_from_cast( (yyvsp[0].type_decl), (yyvsp[-2].exp), (yylsp[-2]).first_line, (yylsp[-2]).first_column, (yylsp[-1]).first_column ); }
#line 3266 "chuck.tab.c"
    break;

  case 188: /* unary_expression: dur_expression  */
#line 641 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3272 "chuck.tab.c"
    break;

  case 189: /* unary_expression: PLUSPLUS unary_expression  */
#line 643 "chuck.y"
            { (yyval.exp) = new_exp_from_unary( ae_op_plusplus, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3278 "chuck.tab.c"
    break;

  case 190: /* unary_expression: MINUSMINUS unary_expression  */
#line 645 "chuck.y"
            { (yyval.exp) = new_exp_from_unary( ae_op_minusminus, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3284 "chuck.tab.c"
    break;

  case 191: /* unary_expression: unary_operator unary_expression  */
#line 647 "chuck.y"
            { (yyval.exp) = new_exp_from_unary( (yyvsp[-1].ival), (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3290 "chuck.tab.c"
    break;

  case 192: /* unary_expression: TYPEOF unary_expression  */
#line 649 "chuck.y"
            { (yyval.exp) = new_exp_from_unary( ae_op_typeof, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3296 "chuck.tab.c"
    break;

  case 193: /* unary_expression: SIZEOF unary_expression  */
#line 651 "chuck.y"
            { (yyval.exp) = new_exp_from_unary( ae_op_sizeof, (yyvsp[0].exp), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3302 "chuck.tab.c"
    break;

  case 194: /* unary_expression: NEW type_decl  */
#line 653 "chuck.y"
            { (yyval.exp) = new_exp_from_unary2( ae_op_new, (yyvsp[0].type_decl), FALSE, NULL, NULL, (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3308 "chuck.tab.c"
    break;

  case 195: /* unary_expression: NEW type_decl array_exp  */
#line 655 "chuck.y"
            { (yyval.exp) = new_exp_from_unary2( ae_op_new, (yyvsp[-1].type_decl), FALSE, NULL, (yyvsp[0].array_sub), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 3314 "chuck.tab.c"
    break;

  case 196: /* unary_expression: NEW type_decl LPAREN RPAREN  */
#line 657 "chuck.y"
            { (yyval.exp) = new_exp_from_unary2( ae_op_new, (yyvsp[-2].type_decl), TRUE, NULL, NULL, (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 3320 "chuck.tab.c"
    break;

  case 197: /* unary_expression: NEW type_decl LPAREN expression RPAREN  */
#line 659 "chuck.y"
            { (yyval.exp) = new_exp_from_unary2( ae_op_new, (yyvsp[-3].type_decl), TRUE, (yyvsp[-1].exp), NULL, (yylsp[-4]).first_line, (yylsp[-4]).first_column ); }
#line 3326 "chuck.tab.c"
    break;

  case 198: /* unary_expression: NEW type_decl LPAREN RPAREN array_exp  */
#line 661 "chuck.y"
            { (yyval.exp) = new_exp_from_unary2( ae_op_new, (yyvsp[-3].type_decl), TRUE, NULL, (yyvsp[0].array_sub), (yylsp[-4]).first_line, (yylsp[-4]).first_column ); }
#line 3332 "chuck.tab.c"
    break;

  case 199: /* unary_expression: NEW type_decl LPAREN expression RPAREN array_exp  */
#line 663 "chuck.y"
            { (yyval.exp) = new_exp_from_unary2( ae_op_new, (yyvsp[-4].type_decl), TRUE, (yyvsp[-2].exp), (yyvsp[0].array_sub), (yylsp[-5]).first_line, (yylsp[-5]).first_column ); }
#line 3338 "chuck.tab.c"
    break;

  case 200: /* unary_operator: PLUS  */
#line 669 "chuck.y"
                                            { (yyval.ival) = ae_op_plus; }
#line 3344 "chuck.tab.c"
    break;

  case 201: /* unary_operator: MINUS  */
#line 670 "chuck.y"
                                            { (yyval.ival) = ae_op_minus; }
#line 3350 "chuck.tab.c"
    break;

  case 202: /* unary_operator: TILDA  */
#line 671 "chuck.y"
                                            { (yyval.ival) = ae_op_tilda; }
#line 3356 "chuck.tab.c"
    break;

  case 203: /* unary_operator: EXCLAMATION  */
#line 672 "chuck.y"
                                            { (yyval.ival) = ae_op_exclamation; }
#line 3362 "chuck.tab.c"
    break;

  case 204: /* unary_operator: TIMES  */
#line 673 "chuck.y"
                                            { (yyval.ival) = ae_op_times; }
#line 3368 "chuck.tab.c"
    break;

  case 205: /* unary_operator: SPORK TILDA  */
#line 674 "chuck.y"
                                            { (yyval.ival) = ae_op_spork; }
#line 3374 "chuck.tab.c"
    break;

  case 206: /* unary_operator: DOWNCHUCK  */
#line 675 "chuck.y"
                                            { (yyval.ival) = ae_op_downchuck; }
#line 3380 "chuck.tab.c"
    break;

  case 207: /* overloadable_operator: CHUCK  */
#line 681 "chuck.y"
                                            { (yyval.ival) = ae_op_chuck; }
#line 3386 "chuck.tab.c"
    break;

  case 208: /* overloadable_operator: PLUS  */
#line 682 "chuck.y"
                                            { (yyval.ival) = ae_op_plus; }
#line 3392 "chuck.tab.c"
    break;

  case 209: /* overloadable_operator: MINUS  */
#line 683 "chuck.y"
                                            { (yyval.ival) = ae_op_minus; }
#line 3398 "chuck.tab.c"
    break;

  case 210: /* overloadable_operator: TIMES  */
#line 684 "chuck.y"
                                            { (yyval.ival) = ae_op_times; }
#line 3404 "chuck.tab.c"
    break;

  case 211: /* overloadable_operator: DIVIDE  */
#line 685 "chuck.y"
                                            { (yyval.ival) = ae_op_divide; }
#line 3410 "chuck.tab.c"
    break;

  case 212: /* overloadable_operator: PERCENT  */
#line 686 "chuck.y"
                                            { (yyval.ival) = ae_op_percent; }
#line 3416 "chuck.tab.c"
    break;

  case 213: /* overloadable_operator: EQ  */
#line 687 "chuck.y"
                                            { (yyval.ival) = ae_op_eq; }
#line 3422 "chuck.tab.c"
    break;

  case 214: /* overloadable_operator: NEQ  */
#line 688 "chuck.y"
                                            { (yyval.ival) = ae_op_neq; }
#line 3428 "chuck.tab.c"
    break;

  case 215: /* overloadable_operator: LT  */
#line 689 "chuck.y"
                                            { (yyval.ival) = ae_op_lt; }
#line 3434 "chuck.tab.c"
    break;

  case 216: /* overloadable_operator: LE  */
#line 690 "chuck.y"
                                            { (yyval.ival) = ae_op_le; }
#line 3440 "chuck.tab.c"
    break;

  case 217: /* overloadable_operator: GT  */
#line 691 "chuck.y"
                                            { (yyval.ival) = ae_op_gt; }
#line 3446 "chuck.tab.c"
    break;

  case 218: /* overloadable_operator: GE  */
#line 692 "chuck.y"
                                            { (yyval.ival) = ae_op_ge; }
#line 3452 "chuck.tab.c"
    break;

  case 219: /* overloadable_operator: AND  */
#line 693 "chuck.y"
                                            { (yyval.ival) = ae_op_and; }
#line 3458 "chuck.tab.c"
    break;

  case 220: /* overloadable_operator: OR  */
#line 694 "chuck.y"
                                            { (yyval.ival) = ae_op_or; }
#line 3464 "chuck.tab.c"
    break;

  case 221: /* overloadable_operator: ASSIGN  */
#line 695 "chuck.y"
                                            { (yyval.ival) = ae_op_assign; }
#line 3470 "chuck.tab.c"
    break;

  case 222: /* overloadable_operator: EXCLAMATION  */
#line 696 "chuck.y"
                                            { (yyval.ival) = ae_op_exclamation; }
#line 3476 "chuck.tab.c"
    break;

  case 223: /* overloadable_operator: S_OR  */
#line 697 "chuck.y"
                                            { (yyval.ival) = ae_op_s_or; }
#line 3482 "chuck.tab.c"
    break;

  case 224: /* overloadable_operator: S_AND  */
#line 698 "chuck.y"
                                            { (yyval.ival) = ae_op_s_and; }
#line 3488 "chuck.tab.c"
    break;

  case 225: /* overloadable_operator: S_XOR  */
#line 699 "chuck.y"
                                            { (yyval.ival) = ae_op_s_xor; }
#line 3494 "chuck.tab.c"
    break;

  case 226: /* overloadable_operator: PLUSPLUS  */
#line 700 "chuck.y"
                                            { (yyval.ival) = ae_op_plusplus; }
#line 3500 "chuck.tab.c"
    break;

  case 227: /* overloadable_operator: MINUSMINUS  */
#line 701 "chuck.y"
                                            { (yyval.ival) = ae_op_minusminus; }
#line 3506 "chuck.tab.c"
    break;

  case 228: /* overloadable_operator: DOLLAR  */
#line 702 "chuck.y"
                                            { (yyval.ival) = ae_op_dollar; }
#line 3512 "chuck.tab.c"
    break;

  case 229: /* overloadable_operator: ATAT_SYM  */
#line 703 "chuck.y"
                                            { (yyval.ival) = ae_op_at_at; }
#line 3518 "chuck.tab.c"
    break;

  case 230: /* overloadable_operator: PLUS_CHUCK  */
#line 704 "chuck.y"
                                            { (yyval.ival) = ae_op_plus_chuck; }
#line 3524 "chuck.tab.c"
    break;

  case 231: /* overloadable_operator: MINUS_CHUCK  */
#line 705 "chuck.y"
                                            { (yyval.ival) = ae_op_minus_chuck; }
#line 3530 "chuck.tab.c"
    break;

  case 232: /* overloadable_operator: TIMES_CHUCK  */
#line 706 "chuck.y"
                                            { (yyval.ival) = ae_op_times_chuck; }
#line 3536 "chuck.tab.c"
    break;

  case 233: /* overloadable_operator: DIVIDE_CHUCK  */
#line 707 "chuck.y"
                                            { (yyval.ival) = ae_op_divide_chuck; }
#line 3542 "chuck.tab.c"
    break;

  case 234: /* overloadable_operator: S_AND_CHUCK  */
#line 708 "chuck.y"
                                            { (yyval.ival) = ae_op_s_and_chuck; }
#line 3548 "chuck.tab.c"
    break;

  case 235: /* overloadable_operator: S_OR_CHUCK  */
#line 709 "chuck.y"
                                            { (yyval.ival) = ae_op_s_or_chuck; }
#line 3554 "chuck.tab.c"
    break;

  case 236: /* overloadable_operator: S_XOR_CHUCK  */
#line 710 "chuck.y"
                                            { (yyval.ival) = ae_op_s_xor_chuck; }
#line 3560 "chuck.tab.c"
    break;

  case 237: /* overloadable_operator: SHIFT_RIGHT_CHUCK  */
#line 711 "chuck.y"
                                            { (yyval.ival) = ae_op_shift_right_chuck; }
#line 3566 "chuck.tab.c"
    break;

  case 238: /* overloadable_operator: SHIFT_LEFT_CHUCK  */
#line 712 "chuck.y"
                                            { (yyval.ival) = ae_op_shift_left_chuck; }
#line 3572 "chuck.tab.c"
    break;

  case 239: /* overloadable_operator: PERCENT_CHUCK  */
#line 713 "chuck.y"
                                            { (yyval.ival) = ae_op_percent_chuck; }
#line 3578 "chuck.tab.c"
    break;

  case 240: /* overloadable_operator: SHIFT_RIGHT  */
#line 714 "chuck.y"
                                            { (yyval.ival) = ae_op_shift_right; }
#line 3584 "chuck.tab.c"
    break;

  case 241: /* overloadable_operator: SHIFT_LEFT  */
#line 715 "chuck.y"
                                            { (yyval.ival) = ae_op_shift_left; }
#line 3590 "chuck.tab.c"
    break;

  case 242: /* overloadable_operator: TILDA  */
#line 716 "chuck.y"
                                            { (yyval.ival) = ae_op_tilda; }
#line 3596 "chuck.tab.c"
    break;

  case 243: /* overloadable_operator: COLONCOLON  */
#line 717 "chuck.y"
                                            { (yyval.ival) = ae_op_coloncolon; }
#line 3602 "chuck.tab.c"
    break;

  case 244: /* overloadable_operator: AT_CHUCK  */
#line 718 "chuck.y"
                                            { (yyval.ival) = ae_op_at_chuck; }
#line 3608 "chuck.tab.c"
    break;

  case 245: /* overloadable_operator: UNCHUCK  */
#line 719 "chuck.y"
                                            { (yyval.ival) = ae_op_unchuck; }
#line 3614 "chuck.tab.c"
    break;

  case 246: /* overloadable_operator: UPCHUCK  */
#line 720 "chuck.y"
                                            { (yyval.ival) = ae_op_upchuck; }
#line 3620 "chuck.tab.c"
    break;

  case 247: /* overloadable_operator: DOWNCHUCK  */
#line 721 "chuck.y"
                                            { (yyval.ival) = ae_op_downchuck; }
#line 3626 "chuck.tab.c"
    break;

  case 248: /* overloadable_operator: ARROW_RIGHT  */
#line 722 "chuck.y"
                                            { (yyval.ival) = ae_op_arrow_right; }
#line 3632 "chuck.tab.c"
    break;

  case 249: /* overloadable_operator: ARROW_LEFT  */
#line 723 "chuck.y"
                                            { (yyval.ival) = ae_op_arrow_left; }
#line 3638 "chuck.tab.c"
    break;

  case 250: /* overloadable_operator: GRUCK_RIGHT  */
#line 724 "chuck.y"
                                            { (yyval.ival) = ae_op_gruck_right; }
#line 3644 "chuck.tab.c"
    break;

  case 251: /* overloadable_operator: GRUCK_LEFT  */
#line 725 "chuck.y"
                                            { (yyval.ival) = ae_op_gruck_left; }
#line 3650 "chuck.tab.c"
    break;

  case 252: /* overloadable_operator: UNGRUCK_RIGHT  */
#line 726 "chuck.y"
                                            { (yyval.ival) = ae_op_ungruck_right; }
#line 3656 "chuck.tab.c"
    break;

  case 253: /* overloadable_operator: UNGRUCK_LEFT  */
#line 727 "chuck.y"
                                            { (yyval.ival) = ae_op_ungruck_left; }
#line 3662 "chuck.tab.c"
    break;

  case 255: /* dur_expression: dur_expression COLONCOLON postfix_expression  */
#line 733 "chuck.y"
            { (yyval.exp) = new_exp_from_dur( (yyvsp[-2].exp), (yyvsp[0].exp), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 3668 "chuck.tab.c"
    break;

  case 256: /* postfix_expression: primary_expression  */
#line 737 "chuck.y"
                                            { (yyval.exp) = (yyvsp[0].exp); }
#line 3674 "chuck.tab.c"
    break;

  case 257: /* postfix_expression: postfix_expression array_exp  */
#line 739 "chuck.y"
            { (yyval.exp) = new_exp_from_array( (yyvsp[-1].exp), (yyvsp[0].array_sub), (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3680 "chuck.tab.c"
    break;

  case 258: /* postfix_expression: postfix_expression LPAREN RPAREN  */
#line 741 "chuck.y"
            { (yyval.exp) = new_exp_from_func_call( (yyvsp[-2].exp), NULL, (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 3686 "chuck.tab.c"
    break;

  case 259: /* postfix_expression: postfix_expression LPAREN expression RPAREN  */
#line 743 "chuck.y"
            { (yyval.exp) = new_exp_from_func_call( (yyvsp[-3].exp), (yyvsp[-1].exp), (yylsp[-3]).first_line, (yylsp[-3]).first_column ); }
#line 3692 "chuck.tab.c"
    break;

  case 260: /* postfix_expression: postfix_expression DOT ID  */
#line 745 "chuck.y"
            { (yyval.exp) = new_exp_from_member_dot( (yyvsp[-2].exp), (yyvsp[0].sval), (yylsp[-2]).first_line, (yylsp[-2]).first_column, (yylsp[0]).first_column ); }
#line 3698 "chuck.tab.c"
    break;

  case 261: /* postfix_expression: postfix_expression PLUSPLUS  */
#line 747 "chuck.y"
            { (yyval.exp) = new_exp_from_postfix( (yyvsp[-1].exp), ae_op_plusplus, (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3704 "chuck.tab.c"
    break;

  case 262: /* postfix_expression: postfix_expression MINUSMINUS  */
#line 749 "chuck.y"
            { (yyval.exp) = new_exp_from_postfix( (yyvsp[-1].exp), ae_op_minusminus, (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3710 "chuck.tab.c"
    break;

  case 263: /* primary_expression: ID  */
#line 754 "chuck.y"
                                            { (yyval.exp) = new_exp_from_id( (yyvsp[0].sval), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 3716 "chuck.tab.c"
    break;

  case 264: /* primary_expression: INT_VAL  */
#line 755 "chuck.y"
                                            { (yyval.exp) = new_exp_from_int( (yyvsp[0].ival), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 3722 "chuck.tab.c"
    break;

  case 265: /* primary_expression: FLOAT_VAL  */
#line 756 "chuck.y"
                                            { (yyval.exp) = new_exp_from_float( (yyvsp[0].fval), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 3728 "chuck.tab.c"
    break;

  case 266: /* primary_expression: STRING_LIT  */
#line 757 "chuck.y"
                                            { (yyval.exp) = new_exp_from_str( (yyvsp[0].sval), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 3734 "chuck.tab.c"
    break;

  case 267: /* primary_expression: CHAR_LIT  */
#line 758 "chuck.y"
                                            { (yyval.exp) = new_exp_from_char( (yyvsp[0].sval), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 3740 "chuck.tab.c"
    break;

  case 268: /* primary_expression: array_exp  */
#line 759 "chuck.y"
                                            { (yyval.exp) = new_exp_from_array_lit( (yyvsp[0].array_sub), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 3746 "chuck.tab.c"
    break;

  case 269: /* primary_expression: complex_exp  */
#line 760 "chuck.y"
                                            { (yyval.exp) = new_exp_from_complex( (yyvsp[0].complex_exp), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 3752 "chuck.tab.c"
    break;

  case 270: /* primary_expression: polar_exp  */
#line 761 "chuck.y"
                                            { (yyval.exp) = new_exp_from_polar( (yyvsp[0].polar_exp), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 3758 "chuck.tab.c"
    break;

  case 271: /* primary_expression: vec_exp  */
#line 762 "chuck.y"
                                            { (yyval.exp) = new_exp_from_vec( (yyvsp[0].vec_exp), (yylsp[0]).first_line, (yylsp[0]).first_column ); }
#line 3764 "chuck.tab.c"
    break;

  case 272: /* primary_expression: L_HACK expression R_HACK  */
#line 763 "chuck.y"
                                            { (yyval.exp) = new_exp_from_hack( (yyvsp[-1].exp), (yylsp[-2]).first_line, (yylsp[-2]).first_column ); }
#line 3770 "chuck.tab.c"
    break;

  case 273: /* primary_expression: LPAREN expression RPAREN  */
#line 764 "chuck.y"
                                            { (yyval.exp) = (yyvsp[-1].exp); }
#line 3776 "chuck.tab.c"
    break;

  case 274: /* primary_expression: LPAREN RPAREN  */
#line 765 "chuck.y"
                                                    { (yyval.exp) = new_exp_from_nil( (yylsp[-1]).first_line, (yylsp[-1]).first_column ); }
#line 3782 "chuck.tab.c"
    break;


#line 3786 "chuck.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

