// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package bgp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetBgpRoutesParams creates a new GetBgpRoutesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetBgpRoutesParams() *GetBgpRoutesParams {
	return &GetBgpRoutesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetBgpRoutesParamsWithTimeout creates a new GetBgpRoutesParams object
// with the ability to set a timeout on a request.
func NewGetBgpRoutesParamsWithTimeout(timeout time.Duration) *GetBgpRoutesParams {
	return &GetBgpRoutesParams{
		timeout: timeout,
	}
}

// NewGetBgpRoutesParamsWithContext creates a new GetBgpRoutesParams object
// with the ability to set a context for a request.
func NewGetBgpRoutesParamsWithContext(ctx context.Context) *GetBgpRoutesParams {
	return &GetBgpRoutesParams{
		Context: ctx,
	}
}

// NewGetBgpRoutesParamsWithHTTPClient creates a new GetBgpRoutesParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetBgpRoutesParamsWithHTTPClient(client *http.Client) *GetBgpRoutesParams {
	return &GetBgpRoutesParams{
		HTTPClient: client,
	}
}

/*
GetBgpRoutesParams contains all the parameters to send to the API endpoint

	for the get bgp routes operation.

	Typically these are written to a http.Request.
*/
type GetBgpRoutesParams struct {

	/* Afi.

	   Address Family Indicator (AFI) of a BGP route
	*/
	Afi string

	/* Neighbor.

	     IP address specifying a BGP neighbor.
	Has to be specified only when table type is adj-rib-in or adj-rib-out.

	*/
	Neighbor *string

	/* RouterAsn.

	     Autonomous System Number (ASN) identifying a BGP virtual router instance.
	If not specified, all virtual router instances are selected.

	*/
	RouterAsn *int64

	/* Safi.

	   Subsequent Address Family Indicator (SAFI) of a BGP route
	*/
	Safi string

	/* TableType.

	   BGP Routing Information Base (RIB) table type
	*/
	TableType string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get bgp routes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetBgpRoutesParams) WithDefaults() *GetBgpRoutesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get bgp routes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetBgpRoutesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get bgp routes params
func (o *GetBgpRoutesParams) WithTimeout(timeout time.Duration) *GetBgpRoutesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get bgp routes params
func (o *GetBgpRoutesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get bgp routes params
func (o *GetBgpRoutesParams) WithContext(ctx context.Context) *GetBgpRoutesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get bgp routes params
func (o *GetBgpRoutesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get bgp routes params
func (o *GetBgpRoutesParams) WithHTTPClient(client *http.Client) *GetBgpRoutesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get bgp routes params
func (o *GetBgpRoutesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAfi adds the afi to the get bgp routes params
func (o *GetBgpRoutesParams) WithAfi(afi string) *GetBgpRoutesParams {
	o.SetAfi(afi)
	return o
}

// SetAfi adds the afi to the get bgp routes params
func (o *GetBgpRoutesParams) SetAfi(afi string) {
	o.Afi = afi
}

// WithNeighbor adds the neighbor to the get bgp routes params
func (o *GetBgpRoutesParams) WithNeighbor(neighbor *string) *GetBgpRoutesParams {
	o.SetNeighbor(neighbor)
	return o
}

// SetNeighbor adds the neighbor to the get bgp routes params
func (o *GetBgpRoutesParams) SetNeighbor(neighbor *string) {
	o.Neighbor = neighbor
}

// WithRouterAsn adds the routerAsn to the get bgp routes params
func (o *GetBgpRoutesParams) WithRouterAsn(routerAsn *int64) *GetBgpRoutesParams {
	o.SetRouterAsn(routerAsn)
	return o
}

// SetRouterAsn adds the routerAsn to the get bgp routes params
func (o *GetBgpRoutesParams) SetRouterAsn(routerAsn *int64) {
	o.RouterAsn = routerAsn
}

// WithSafi adds the safi to the get bgp routes params
func (o *GetBgpRoutesParams) WithSafi(safi string) *GetBgpRoutesParams {
	o.SetSafi(safi)
	return o
}

// SetSafi adds the safi to the get bgp routes params
func (o *GetBgpRoutesParams) SetSafi(safi string) {
	o.Safi = safi
}

// WithTableType adds the tableType to the get bgp routes params
func (o *GetBgpRoutesParams) WithTableType(tableType string) *GetBgpRoutesParams {
	o.SetTableType(tableType)
	return o
}

// SetTableType adds the tableType to the get bgp routes params
func (o *GetBgpRoutesParams) SetTableType(tableType string) {
	o.TableType = tableType
}

// WriteToRequest writes these params to a swagger request
func (o *GetBgpRoutesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param afi
	qrAfi := o.Afi
	qAfi := qrAfi
	if qAfi != "" {

		if err := r.SetQueryParam("afi", qAfi); err != nil {
			return err
		}
	}

	if o.Neighbor != nil {

		// query param neighbor
		var qrNeighbor string

		if o.Neighbor != nil {
			qrNeighbor = *o.Neighbor
		}
		qNeighbor := qrNeighbor
		if qNeighbor != "" {

			if err := r.SetQueryParam("neighbor", qNeighbor); err != nil {
				return err
			}
		}
	}

	if o.RouterAsn != nil {

		// query param router_asn
		var qrRouterAsn int64

		if o.RouterAsn != nil {
			qrRouterAsn = *o.RouterAsn
		}
		qRouterAsn := swag.FormatInt64(qrRouterAsn)
		if qRouterAsn != "" {

			if err := r.SetQueryParam("router_asn", qRouterAsn); err != nil {
				return err
			}
		}
	}

	// query param safi
	qrSafi := o.Safi
	qSafi := qrSafi
	if qSafi != "" {

		if err := r.SetQueryParam("safi", qSafi); err != nil {
			return err
		}
	}

	// query param table_type
	qrTableType := o.TableType
	qTableType := qrTableType
	if qTableType != "" {

		if err := r.SetQueryParam("table_type", qTableType); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
