// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

package cmdref

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"
	"github.com/spf13/cobra/doc"
)

func NewCmd(parentCmd *cobra.Command) *cobra.Command {
	return &cobra.Command{
		Use:    "cmdref [output directory]",
		Short:  fmt.Sprintf("Generate command reference for %s to given output directory", parentCmd.Name()),
		Args:   cobra.ExactArgs(1),
		Hidden: true,
		Run: func(cmd *cobra.Command, args []string) {
			genMarkdown(parentCmd, args[0])
		},
	}
}

func genMarkdown(parentCmd *cobra.Command, cmdRefDir string) {
	// Remove the line 'Auto generated by spf13/cobra on ...'
	parentCmd.DisableAutoGenTag = true
	if err := doc.GenMarkdownTreeCustom(parentCmd, cmdRefDir, filePrepend(parentCmd.Name()), linkHandler); err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}

func linkHandler(s string) string {
	return s
}

func filePrepend(parentCmdName string) func(string) string {
	// Prepend a HTML comment that this file is autogenerated. So that
	// users are warned before fixing issues in the Markdown files.  Should
	// never show up on the web.
	return func(string) string {
		return fmt.Sprintf("<!-- This file was autogenerated via %s cmdref, do not edit manually-->\n\n", parentCmdName)
	}
}
