#include <dae.h>
#include <dae/daeDom.h>
#include <1.5/dom/domBox.h>
#include <dae/daeMetaCMPolicy.h>
#include <dae/daeMetaSequence.h>
#include <dae/daeMetaChoice.h>
#include <dae/daeMetaGroup.h>
#include <dae/daeMetaAny.h>
#include <dae/daeMetaElementAttribute.h>


namespace ColladaDOM150 {
daeElementRef
domBox::create(DAE& dae)
{
	domBoxRef ref = new domBox(dae);
	return ref;
}


daeMetaElement *
domBox::registerElement(DAE& dae)
{
	daeMetaElement* meta = dae.getMeta(ID());
	if ( meta != NULL ) return meta;

	meta = new daeMetaElement(dae);
	dae.setMeta(ID(), *meta);
	meta->setName( "box" );
	meta->registerClass(domBox::create);

	daeMetaCMPolicy *cm = NULL;
	daeMetaElementAttribute *mea = NULL;
	cm = new daeMetaSequence( meta, cm, 0, 1, 1 );

	mea = new daeMetaElementAttribute( meta, cm, 0, 1, 1 );
	mea->setName( "half_extents" );
	mea->setOffset( daeOffsetOf(domBox,elemHalf_extents) );
	mea->setElementType( domBox::domHalf_extents::registerElement(dae) );
	cm->appendChild( mea );

	mea = new daeMetaElementArrayAttribute( meta, cm, 1, 0, -1 );
	mea->setName( "extra" );
	mea->setOffset( daeOffsetOf(domBox,elemExtra_array) );
	mea->setElementType( domExtra::registerElement(dae) );
	cm->appendChild( mea );

	cm->setMaxOrdinal( 1 );
	meta->setCMRoot( cm );	

	meta->setElementSize(sizeof(domBox));
	meta->validate();

	return meta;
}

daeElementRef
domBox::domHalf_extents::create(DAE& dae)
{
	domBox::domHalf_extentsRef ref = new domBox::domHalf_extents(dae);
	return ref;
}


daeMetaElement *
domBox::domHalf_extents::registerElement(DAE& dae)
{
	daeMetaElement* meta = dae.getMeta(ID());
	if ( meta != NULL ) return meta;

	meta = new daeMetaElement(dae);
	dae.setMeta(ID(), *meta);
	meta->setName( "half_extents" );
	meta->registerClass(domBox::domHalf_extents::create);

	meta->setIsInnerClass( true );
	//	Add attribute: _value
	{
		daeMetaAttribute *ma = new daeMetaArrayAttribute;
		ma->setName( "_value" );
		ma->setType( dae.getAtomicTypes().get("Float3"));
		ma->setOffset( daeOffsetOf( domBox::domHalf_extents , _value ));
		ma->setContainer( meta );
		meta->appendAttribute(ma);
	}

	meta->setElementSize(sizeof(domBox::domHalf_extents));
	meta->validate();

	return meta;
}

} // ColladaDOM150
