/* ContractSource.c generated by valac 0.56.17, the Vala compiler
 * generated from ContractSource.vala, do not modify */

/*
 * Copyright (C) 2013-2017 elementary Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTRACTOR_TYPE_CONTRACT_SOURCE (contractor_contract_source_get_type ())
#define CONTRACTOR_CONTRACT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT_SOURCE, ContractorContractSource))
#define CONTRACTOR_CONTRACT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT_SOURCE, ContractorContractSourceClass))
#define CONTRACTOR_IS_CONTRACT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT_SOURCE))
#define CONTRACTOR_IS_CONTRACT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT_SOURCE))
#define CONTRACTOR_CONTRACT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT_SOURCE, ContractorContractSourceClass))

typedef struct _ContractorContractSource ContractorContractSource;
typedef struct _ContractorContractSourceClass ContractorContractSourceClass;
typedef struct _ContractorContractSourcePrivate ContractorContractSourcePrivate;

#define CONTRACTOR_TYPE_FILE_SERVICE (contractor_file_service_get_type ())
#define CONTRACTOR_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_FILE_SERVICE, ContractorFileService))
#define CONTRACTOR_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_FILE_SERVICE, ContractorFileServiceClass))
#define CONTRACTOR_IS_FILE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_FILE_SERVICE))
#define CONTRACTOR_IS_FILE_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_FILE_SERVICE))
#define CONTRACTOR_FILE_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_FILE_SERVICE, ContractorFileServiceClass))

typedef struct _ContractorFileService ContractorFileService;
typedef struct _ContractorFileServiceClass ContractorFileServiceClass;

#define CONTRACTOR_TYPE_CONTRACT (contractor_contract_get_type ())
#define CONTRACTOR_CONTRACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT, ContractorContract))
#define CONTRACTOR_CONTRACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT, ContractorContractClass))
#define CONTRACTOR_IS_CONTRACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT))
#define CONTRACTOR_IS_CONTRACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT))
#define CONTRACTOR_CONTRACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT, ContractorContractClass))

typedef struct _ContractorContract ContractorContract;
typedef struct _ContractorContractClass ContractorContractClass;
enum  {
	CONTRACTOR_CONTRACT_SOURCE_0_PROPERTY,
	CONTRACTOR_CONTRACT_SOURCE_NUM_PROPERTIES
};
static GParamSpec* contractor_contract_source_properties[CONTRACTOR_CONTRACT_SOURCE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	CONTRACTOR_CONTRACT_SOURCE_CHANGED_SIGNAL,
	CONTRACTOR_CONTRACT_SOURCE_NUM_SIGNALS
};
static guint contractor_contract_source_signals[CONTRACTOR_CONTRACT_SOURCE_NUM_SIGNALS] = {0};

struct _ContractorContractSource {
	GObject parent_instance;
	ContractorContractSourcePrivate * priv;
};

struct _ContractorContractSourceClass {
	GObjectClass parent_class;
};

struct _ContractorContractSourcePrivate {
	ContractorFileService* file_service;
	GeeList* sorted_contracts;
	GeeHashMap* contracts;
};

static gint ContractorContractSource_private_offset;
static gpointer contractor_contract_source_parent_class = NULL;

VALA_EXTERN GType contractor_contract_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContractSource, g_object_unref)
VALA_EXTERN GType contractor_file_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorFileService, g_object_unref)
VALA_EXTERN GType contractor_contract_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContract, g_object_unref)
VALA_EXTERN ContractorContractSource* contractor_contract_source_new (void);
VALA_EXTERN ContractorContractSource* contractor_contract_source_construct (GType object_type);
VALA_EXTERN ContractorFileService* contractor_file_service_new (void);
VALA_EXTERN ContractorFileService* contractor_file_service_construct (GType object_type);
static void contractor_contract_source_load_contracts (ContractorContractSource* self);
static void _contractor_contract_source_load_contracts_contractor_file_service_contract_files_changed (ContractorFileService* _sender,
                                                                                                gpointer self);
VALA_EXTERN GeeCollection* contractor_contract_source_get_contracts (ContractorContractSource* self);
VALA_EXTERN ContractorContract* contractor_contract_source_lookup_by_id (ContractorContractSource* self,
                                                             const gchar* contract_id,
                                                             GError** error);
static void contractor_contract_source_clear_loaded_contracts (ContractorContractSource* self);
VALA_EXTERN GeeList* contractor_file_service_load_contract_files (ContractorFileService* self);
static void contractor_contract_source_load_contract (ContractorContractSource* self,
                                               GFile* file);
VALA_EXTERN ContractorContract* contractor_contract_new (GFile* file,
                                             GError** error);
VALA_EXTERN ContractorContract* contractor_contract_construct (GType object_type,
                                                   GFile* file,
                                                   GError** error);
static void contractor_contract_source_add_contract (ContractorContractSource* self,
                                              ContractorContract* contract);
VALA_EXTERN const gchar* contractor_contract_get_id (ContractorContract* self);
VALA_EXTERN gint contractor_contract_sorter_compare_func (ContractorContract* a,
                                              ContractorContract* b);
static gint _contractor_contract_sorter_compare_func_gcompare_data_func (gconstpointer a,
                                                                  gconstpointer b,
                                                                  gpointer self);
static void contractor_contract_source_finalize (GObject * obj);
static GType contractor_contract_source_get_type_once (void);

static inline gpointer
contractor_contract_source_get_instance_private (ContractorContractSource* self)
{
	return G_STRUCT_MEMBER_P (self, ContractorContractSource_private_offset);
}

static void
_contractor_contract_source_load_contracts_contractor_file_service_contract_files_changed (ContractorFileService* _sender,
                                                                                           gpointer self)
{
	contractor_contract_source_load_contracts ((ContractorContractSource*) self);
}

ContractorContractSource*
contractor_contract_source_construct (GType object_type)
{
	ContractorContractSource * self = NULL;
	ContractorFileService* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeHashMap* _tmp2_;
	ContractorFileService* _tmp3_;
	self = (ContractorContractSource*) g_object_new (object_type, NULL);
	_tmp0_ = contractor_file_service_new ();
	_g_object_unref0 (self->priv->file_service);
	self->priv->file_service = _tmp0_;
	_tmp1_ = gee_linked_list_new (CONTRACTOR_TYPE_CONTRACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->sorted_contracts);
	self->priv->sorted_contracts = (GeeList*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, CONTRACTOR_TYPE_CONTRACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->contracts);
	self->priv->contracts = _tmp2_;
	contractor_contract_source_load_contracts (self);
	_tmp3_ = self->priv->file_service;
	g_signal_connect_object (_tmp3_, "contract-files-changed", (GCallback) _contractor_contract_source_load_contracts_contractor_file_service_contract_files_changed, self, 0);
	return self;
}

ContractorContractSource*
contractor_contract_source_new (void)
{
	return contractor_contract_source_construct (CONTRACTOR_TYPE_CONTRACT_SOURCE);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeCollection*
contractor_contract_source_get_contracts (ContractorContractSource* self)
{
	GeeList* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sorted_contracts;
	_tmp1_ = _g_object_ref0 ((GeeCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}

ContractorContract*
contractor_contract_source_lookup_by_id (ContractorContractSource* self,
                                         const gchar* contract_id,
                                         GError** error)
{
	ContractorContract* contract = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	ContractorContract* _tmp2_;
	GError* _inner_error0_ = NULL;
	ContractorContract* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contract_id != NULL, NULL);
	_tmp0_ = self->priv->contracts;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, contract_id);
	contract = (ContractorContract*) _tmp1_;
	_tmp2_ = contract;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "Requested invalid contract: %s", contract_id);
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (contract);
		return NULL;
	}
	result = contract;
	return result;
}

static void
contractor_contract_source_load_contracts (ContractorContractSource* self)
{
	GeeList* contract_files_to_load = NULL;
	ContractorFileService* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (self != NULL);
	contractor_contract_source_clear_loaded_contracts (self);
	_tmp0_ = self->priv->file_service;
	_tmp1_ = contractor_file_service_load_contract_files (_tmp0_);
	contract_files_to_load = _tmp1_;
	{
		GeeList* _contract_file_list = NULL;
		GeeList* _tmp2_;
		gint _contract_file_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _contract_file_index = 0;
		_tmp2_ = contract_files_to_load;
		_contract_file_list = _tmp2_;
		_tmp3_ = _contract_file_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_contract_file_size = _tmp5_;
		_contract_file_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			GFile* contract_file = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			GFile* _tmp10_;
			_contract_file_index = _contract_file_index + 1;
			_tmp6_ = _contract_file_index;
			_tmp7_ = _contract_file_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _contract_file_list;
			_tmp9_ = gee_list_get (_tmp8_, _contract_file_index);
			contract_file = (GFile*) _tmp9_;
			_tmp10_ = contract_file;
			contractor_contract_source_load_contract (self, _tmp10_);
			_g_object_unref0 (contract_file);
		}
	}
	g_signal_emit (self, contractor_contract_source_signals[CONTRACTOR_CONTRACT_SOURCE_CHANGED_SIGNAL], 0);
	_g_object_unref0 (contract_files_to_load);
}

static void
contractor_contract_source_load_contract (ContractorContractSource* self,
                                          GFile* file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		ContractorContract* contract = NULL;
		ContractorContract* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = contractor_contract_new (file, &_inner_error0_);
		contract = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		contractor_contract_source_add_contract (self, contract);
		_tmp1_ = g_file_get_path (file);
		_tmp2_ = _tmp1_;
		g_message ("ContractSource.vala:65: Contract file '%s' loaded successfully.", _tmp2_);
		_g_free0 (_tmp2_);
		_g_object_unref0 (contract);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = g_file_get_path (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_warning ("ContractSource.vala:67: Could not load contract at '%s': %s", _tmp4_, _tmp6_);
		_g_free0 (_tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gint
_contractor_contract_sorter_compare_func_gcompare_data_func (gconstpointer a,
                                                             gconstpointer b,
                                                             gpointer self)
{
	gint result;
	result = contractor_contract_sorter_compare_func ((ContractorContract*) a, (ContractorContract*) b);
	return result;
}

static void
contractor_contract_source_add_contract (ContractorContractSource* self,
                                         ContractorContract* contract)
{
	gchar* contract_id = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	GeeHashMap* _tmp6_;
	const gchar* _tmp7_;
	GeeList* _tmp8_;
	GeeList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contract != NULL);
	_tmp0_ = contractor_contract_get_id (contract);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	contract_id = _tmp2_;
	_tmp3_ = self->priv->contracts;
	_tmp4_ = contract_id;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, _tmp4_)) {
		const gchar* _tmp5_;
		_tmp5_ = contract_id;
		g_warning ("ContractSource.vala:75: A contract with ID '%s' exists already. Not ad" \
"ding another one.", _tmp5_);
		_g_free0 (contract_id);
		return;
	}
	_tmp6_ = self->priv->contracts;
	_tmp7_ = contract_id;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp7_, contract);
	_tmp8_ = self->priv->sorted_contracts;
	gee_collection_add ((GeeCollection*) _tmp8_, contract);
	_tmp9_ = self->priv->sorted_contracts;
	gee_list_sort (_tmp9_, _contractor_contract_sorter_compare_func_gcompare_data_func, NULL, NULL);
	_g_free0 (contract_id);
}

static void
contractor_contract_source_clear_loaded_contracts (ContractorContractSource* self)
{
	GeeHashMap* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contracts;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	_tmp1_ = self->priv->sorted_contracts;
	gee_collection_clear ((GeeCollection*) _tmp1_);
}

static void
contractor_contract_source_class_init (ContractorContractSourceClass * klass,
                                       gpointer klass_data)
{
	contractor_contract_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContractorContractSource_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contractor_contract_source_finalize;
	contractor_contract_source_signals[CONTRACTOR_CONTRACT_SOURCE_CHANGED_SIGNAL] = g_signal_new ("changed", CONTRACTOR_TYPE_CONTRACT_SOURCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
contractor_contract_source_instance_init (ContractorContractSource * self,
                                          gpointer klass)
{
	self->priv = contractor_contract_source_get_instance_private (self);
}

static void
contractor_contract_source_finalize (GObject * obj)
{
	ContractorContractSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTRACTOR_TYPE_CONTRACT_SOURCE, ContractorContractSource);
	_g_object_unref0 (self->priv->file_service);
	_g_object_unref0 (self->priv->sorted_contracts);
	_g_object_unref0 (self->priv->contracts);
	G_OBJECT_CLASS (contractor_contract_source_parent_class)->finalize (obj);
}

static GType
contractor_contract_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContractorContractSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contractor_contract_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContractorContractSource), 0, (GInstanceInitFunc) contractor_contract_source_instance_init, NULL };
	GType contractor_contract_source_type_id;
	contractor_contract_source_type_id = g_type_register_static (G_TYPE_OBJECT, "ContractorContractSource", &g_define_type_info, 0);
	ContractorContractSource_private_offset = g_type_add_instance_private (contractor_contract_source_type_id, sizeof (ContractorContractSourcePrivate));
	return contractor_contract_source_type_id;
}

GType
contractor_contract_source_get_type (void)
{
	static volatile gsize contractor_contract_source_type_id__once = 0;
	if (g_once_init_enter (&contractor_contract_source_type_id__once)) {
		GType contractor_contract_source_type_id;
		contractor_contract_source_type_id = contractor_contract_source_get_type_once ();
		g_once_init_leave (&contractor_contract_source_type_id__once, contractor_contract_source_type_id);
	}
	return contractor_contract_source_type_id__once;
}

