/* DBusService.c generated by valac 0.56.17, the Vala compiler
 * generated from DBusService.vala, do not modify */

/*
 * Copyright (C) 2011-2017 elementary Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: ammonkey <am.monkeyd@gmail.com>,
 *          lampe2 <michael@lazarski.me>,
 *          Victor Martinez <victoreduardm@gmail.com>
 *
 * The original Contractor implementation in Python was created by:
 *          Allen Lowe <lallenlowe@gmail.com>
 */
/**
     * Errors specific to the Contractor D-Bus service.
     */

#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTRACTOR_TYPE_CONTRACTOR_ERROR (contractor_contractor_error_get_type ())

#define CONTRACTOR_TYPE_DBUS_SERVICE (contractor_dbus_service_get_type ())
#define CONTRACTOR_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_DBUS_SERVICE, ContractorDBusService))
#define CONTRACTOR_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_DBUS_SERVICE, ContractorDBusServiceClass))
#define CONTRACTOR_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_DBUS_SERVICE))
#define CONTRACTOR_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_DBUS_SERVICE))
#define CONTRACTOR_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_DBUS_SERVICE, ContractorDBusServiceClass))

typedef struct _ContractorDBusService ContractorDBusService;
typedef struct _ContractorDBusServiceClass ContractorDBusServiceClass;
typedef struct _ContractorDBusServicePrivate ContractorDBusServicePrivate;

#define CONTRACTOR_TYPE_CONTRACT_SOURCE (contractor_contract_source_get_type ())
#define CONTRACTOR_CONTRACT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT_SOURCE, ContractorContractSource))
#define CONTRACTOR_CONTRACT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT_SOURCE, ContractorContractSourceClass))
#define CONTRACTOR_IS_CONTRACT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT_SOURCE))
#define CONTRACTOR_IS_CONTRACT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT_SOURCE))
#define CONTRACTOR_CONTRACT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT_SOURCE, ContractorContractSourceClass))

typedef struct _ContractorContractSource ContractorContractSource;
typedef struct _ContractorContractSourceClass ContractorContractSourceClass;
enum  {
	CONTRACTOR_DBUS_SERVICE_0_PROPERTY,
	CONTRACTOR_DBUS_SERVICE_NUM_PROPERTIES
};
static GParamSpec* contractor_dbus_service_properties[CONTRACTOR_DBUS_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTRACTOR_TYPE_GENERIC_CONTRACT (contractor_generic_contract_get_type ())
typedef struct _ContractorGenericContract ContractorGenericContract;

#define CONTRACTOR_TYPE_CONTRACT (contractor_contract_get_type ())
#define CONTRACTOR_CONTRACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT, ContractorContract))
#define CONTRACTOR_CONTRACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT, ContractorContractClass))
#define CONTRACTOR_IS_CONTRACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT))
#define CONTRACTOR_IS_CONTRACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT))
#define CONTRACTOR_CONTRACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT, ContractorContractClass))

typedef struct _ContractorContract ContractorContract;
typedef struct _ContractorContractClass ContractorContractClass;
enum  {
	CONTRACTOR_DBUS_SERVICE_CONTRACTS_CHANGED_SIGNAL,
	CONTRACTOR_DBUS_SERVICE_NUM_SIGNALS
};
static guint contractor_dbus_service_signals[CONTRACTOR_DBUS_SERVICE_NUM_SIGNALS] = {0};
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	CONTRACTOR_CONTRACTOR_ERROR_NO_MIMETYPES_GIVEN
} ContractorContractorError;
#define CONTRACTOR_CONTRACTOR_ERROR contractor_contractor_error_quark ()

struct _ContractorDBusService {
	GObject parent_instance;
	ContractorDBusServicePrivate * priv;
};

struct _ContractorDBusServiceClass {
	GObjectClass parent_class;
};

struct _ContractorDBusServicePrivate {
	ContractorContractSource* contract_source;
};

struct _ContractorGenericContract {
	gchar* id;
	gchar* name;
	gchar* description;
	gchar* icon;
};

static gint ContractorDBusService_private_offset;
static gpointer contractor_dbus_service_parent_class = NULL;

VALA_EXTERN GQuark contractor_contractor_error_quark (void);
VALA_EXTERN GType contractor_contractor_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType contractor_dbus_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorDBusService, g_object_unref)
VALA_EXTERN guint contractor_dbus_service_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN GType contractor_contract_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContractSource, g_object_unref)
VALA_EXTERN ContractorDBusService* contractor_dbus_service_new (void);
VALA_EXTERN ContractorDBusService* contractor_dbus_service_construct (GType object_type);
VALA_EXTERN ContractorContractSource* contractor_contract_source_new (void);
VALA_EXTERN ContractorContractSource* contractor_contract_source_construct (GType object_type);
static void __lambda5_ (ContractorDBusService* self);
static void ___lambda5__contractor_contract_source_changed (ContractorContractSource* _sender,
                                                     gpointer self);
VALA_EXTERN GType contractor_generic_contract_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ContractorGenericContract* contractor_generic_contract_dup (const ContractorGenericContract* self);
VALA_EXTERN void contractor_generic_contract_free (ContractorGenericContract* self);
VALA_EXTERN void contractor_generic_contract_copy (const ContractorGenericContract* self,
                                       ContractorGenericContract* dest);
VALA_EXTERN void contractor_generic_contract_destroy (ContractorGenericContract* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (ContractorGenericContract, contractor_generic_contract_destroy)
VALA_EXTERN ContractorGenericContract* contractor_dbus_service_get_contracts_by_mime (ContractorDBusService* self,
                                                                          const gchar* mime_type,
                                                                          gint* result_length1,
                                                                          GError** error);
VALA_EXTERN ContractorGenericContract* contractor_dbus_service_get_contracts_by_mimelist (ContractorDBusService* self,
                                                                              gchar** mime_types,
                                                                              gint mime_types_length1,
                                                                              gint* result_length1,
                                                                              GError** error);
static void _vala_ContractorGenericContract_array_free (ContractorGenericContract * array,
                                                 gssize array_length);
VALA_EXTERN GType contractor_contract_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContract, g_object_unref)
VALA_EXTERN GeeCollection* contractor_contract_source_get_contracts (ContractorContractSource* self);
VALA_EXTERN GeeCollection* contractor_contract_matcher_get_contracts_for_types (gchar** mime_types,
                                                                    gint mime_types_length1,
                                                                    GeeCollection* contracts_to_filter,
                                                                    GError** error);
static ContractorGenericContract* contractor_dbus_service_convert_to_generic_contracts (GeeCollection* contracts,
                                                                                 gint* result_length1);
VALA_EXTERN ContractorGenericContract* contractor_dbus_service_get_contracts_by_file_size (ContractorDBusService* self,
                                                                               gint64 file_size,
                                                                               gint* result_length1,
                                                                               GError** error);
VALA_EXTERN GeeCollection* contractor_contract_matcher_get_contracts_for_file_size (gint64 file_size,
                                                                        GeeCollection* contracts_to_filter,
                                                                        GError** error);
VALA_EXTERN ContractorGenericContract* contractor_dbus_service_get_contracts_by_mime_and_file_size (ContractorDBusService* self,
                                                                                        const gchar* mime_type,
                                                                                        gint64 file_size,
                                                                                        gint* result_length1,
                                                                                        GError** error);
VALA_EXTERN ContractorGenericContract* contractor_dbus_service_get_contracts_by_mimelist_and_file_size (ContractorDBusService* self,
                                                                                            gchar** mime_types,
                                                                                            gint mime_types_length1,
                                                                                            gint64 file_size,
                                                                                            gint* result_length1,
                                                                                            GError** error);
VALA_EXTERN GeeCollection* contractor_contract_matcher_get_contracts_for_types_and_file_size (gchar** mime_types,
                                                                                  gint mime_types_length1,
                                                                                  gint64 file_size,
                                                                                  GeeCollection* contracts_to_filter,
                                                                                  GError** error);
VALA_EXTERN void contractor_dbus_service_execute_with_uri (ContractorDBusService* self,
                                               const gchar* id,
                                               const gchar* uri,
                                               GError** error);
VALA_EXTERN void contractor_dbus_service_execute_with_uri_list (ContractorDBusService* self,
                                                    const gchar* id,
                                                    gchar** uris,
                                                    gint uris_length1,
                                                    GError** error);
VALA_EXTERN ContractorContract* contractor_contract_source_lookup_by_id (ContractorContractSource* self,
                                                             const gchar* contract_id,
                                                             GError** error);
VALA_EXTERN void contractor_contract_launch_uris (ContractorContract* self,
                                      gchar** uris,
                                      gint uris_length1,
                                      GError** error);
VALA_EXTERN ContractorGenericContract* contractor_dbus_service_list_all_contracts (ContractorDBusService* self,
                                                                       gint* result_length1);
VALA_EXTERN void contractor_contract_get_generic (ContractorContract* self,
                                      ContractorGenericContract* result);
static void _vala_array_add1 (ContractorGenericContract* * array,
                       gint* length,
                       gint* size,
                       const ContractorGenericContract* value);
static void contractor_dbus_service_finalize (GObject * obj);
static GType contractor_dbus_service_get_type_once (void);
static void _dbus_contractor_dbus_service_get_contracts_by_mime (ContractorDBusService* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void _dbus_contractor_dbus_service_get_contracts_by_mimelist (ContractorDBusService* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation);
static void _dbus_contractor_dbus_service_get_contracts_by_file_size (ContractorDBusService* self,
                                                               GVariant* _parameters_,
                                                               GDBusMethodInvocation* invocation);
static void _dbus_contractor_dbus_service_get_contracts_by_mime_and_file_size (ContractorDBusService* self,
                                                                        GVariant* _parameters_,
                                                                        GDBusMethodInvocation* invocation);
static void _dbus_contractor_dbus_service_get_contracts_by_mimelist_and_file_size (ContractorDBusService* self,
                                                                            GVariant* _parameters_,
                                                                            GDBusMethodInvocation* invocation);
static void _dbus_contractor_dbus_service_execute_with_uri (ContractorDBusService* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_contractor_dbus_service_execute_with_uri_list (ContractorDBusService* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void _dbus_contractor_dbus_service_list_all_contracts (ContractorDBusService* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation);
static void contractor_dbus_service_dbus_interface_method_call (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* method_name,
                                                         GVariant* parameters,
                                                         GDBusMethodInvocation* invocation,
                                                         gpointer user_data);
static GVariant* contractor_dbus_service_dbus_interface_get_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GError** error,
                                                               gpointer user_data);
static gboolean contractor_dbus_service_dbus_interface_set_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GVariant* value,
                                                              GError** error,
                                                              gpointer user_data);
static void _dbus_contractor_dbus_service_contracts_changed (GObject* _sender,
                                                      gpointer* _data);
static void _contractor_dbus_service_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusErrorEntry contractor_contractor_error_entries[] = {{CONTRACTOR_CONTRACTOR_ERROR_NO_MIMETYPES_GIVEN, "org.elementary.ContractorError.NoMimetypesGiven"}};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_mime_type = {-1, "mime_type", "s", NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_result = {-1, "result", "a(ssss)", NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_in[] = {&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_mime_type, NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_out[] = {&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_result, NULL};
static const GDBusMethodInfo _contractor_dbus_service_dbus_method_info_get_contracts_by_mime = {-1, "GetContractsByMime", (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_in), (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_out), NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_mime_types = {-1, "mime_types", "as", NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_result = {-1, "result", "a(ssss)", NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_in[] = {&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_mime_types, NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_out[] = {&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_result, NULL};
static const GDBusMethodInfo _contractor_dbus_service_dbus_method_info_get_contracts_by_mimelist = {-1, "GetContractsByMimelist", (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_in), (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_out), NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_file_size_file_size = {-1, "file_size", "x", NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_file_size_result = {-1, "result", "a(ssss)", NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_get_contracts_by_file_size_in[] = {&_contractor_dbus_service_dbus_arg_info_get_contracts_by_file_size_file_size, NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_get_contracts_by_file_size_out[] = {&_contractor_dbus_service_dbus_arg_info_get_contracts_by_file_size_result, NULL};
static const GDBusMethodInfo _contractor_dbus_service_dbus_method_info_get_contracts_by_file_size = {-1, "GetContractsByFileSize", (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_get_contracts_by_file_size_in), (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_get_contracts_by_file_size_out), NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_and_file_size_mime_type = {-1, "mime_type", "s", NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_and_file_size_file_size = {-1, "file_size", "x", NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_and_file_size_result = {-1, "result", "a(ssss)", NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_and_file_size_in[] = {&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_and_file_size_mime_type, &_contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_and_file_size_file_size, NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_and_file_size_out[] = {&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_and_file_size_result, NULL};
static const GDBusMethodInfo _contractor_dbus_service_dbus_method_info_get_contracts_by_mime_and_file_size = {-1, "GetContractsByMimeAndFileSize", (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_and_file_size_in), (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mime_and_file_size_out), NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_and_file_size_mime_types = {-1, "mime_types", "as", NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_and_file_size_file_size = {-1, "file_size", "x", NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_and_file_size_result = {-1, "result", "a(ssss)", NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_and_file_size_in[] = {&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_and_file_size_mime_types, &_contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_and_file_size_file_size, NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_and_file_size_out[] = {&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_and_file_size_result, NULL};
static const GDBusMethodInfo _contractor_dbus_service_dbus_method_info_get_contracts_by_mimelist_and_file_size = {-1, "GetContractsByMimelistAndFileSize", (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_and_file_size_in), (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_get_contracts_by_mimelist_and_file_size_out), NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_execute_with_uri_id = {-1, "id", "s", NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_execute_with_uri_uri = {-1, "uri", "s", NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_execute_with_uri_in[] = {&_contractor_dbus_service_dbus_arg_info_execute_with_uri_id, &_contractor_dbus_service_dbus_arg_info_execute_with_uri_uri, NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_execute_with_uri_out[] = {NULL};
static const GDBusMethodInfo _contractor_dbus_service_dbus_method_info_execute_with_uri = {-1, "ExecuteWithUri", (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_execute_with_uri_in), (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_execute_with_uri_out), NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_execute_with_uri_list_id = {-1, "id", "s", NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_execute_with_uri_list_uris = {-1, "uris", "as", NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_execute_with_uri_list_in[] = {&_contractor_dbus_service_dbus_arg_info_execute_with_uri_list_id, &_contractor_dbus_service_dbus_arg_info_execute_with_uri_list_uris, NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_execute_with_uri_list_out[] = {NULL};
static const GDBusMethodInfo _contractor_dbus_service_dbus_method_info_execute_with_uri_list = {-1, "ExecuteWithUriList", (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_execute_with_uri_list_in), (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_execute_with_uri_list_out), NULL};
static const GDBusArgInfo _contractor_dbus_service_dbus_arg_info_list_all_contracts_result = {-1, "result", "a(ssss)", NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_list_all_contracts_in[] = {NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_list_all_contracts_out[] = {&_contractor_dbus_service_dbus_arg_info_list_all_contracts_result, NULL};
static const GDBusMethodInfo _contractor_dbus_service_dbus_method_info_list_all_contracts = {-1, "ListAllContracts", (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_list_all_contracts_in), (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_list_all_contracts_out), NULL};
static const GDBusMethodInfo * const _contractor_dbus_service_dbus_method_info[] = {&_contractor_dbus_service_dbus_method_info_get_contracts_by_mime, &_contractor_dbus_service_dbus_method_info_get_contracts_by_mimelist, &_contractor_dbus_service_dbus_method_info_get_contracts_by_file_size, &_contractor_dbus_service_dbus_method_info_get_contracts_by_mime_and_file_size, &_contractor_dbus_service_dbus_method_info_get_contracts_by_mimelist_and_file_size, &_contractor_dbus_service_dbus_method_info_execute_with_uri, &_contractor_dbus_service_dbus_method_info_execute_with_uri_list, &_contractor_dbus_service_dbus_method_info_list_all_contracts, NULL};
static const GDBusArgInfo * const _contractor_dbus_service_dbus_arg_info_contracts_changed[] = {NULL};
static const GDBusSignalInfo _contractor_dbus_service_dbus_signal_info_contracts_changed = {-1, "ContractsChanged", (GDBusArgInfo **) (&_contractor_dbus_service_dbus_arg_info_contracts_changed), NULL};
static const GDBusSignalInfo * const _contractor_dbus_service_dbus_signal_info[] = {&_contractor_dbus_service_dbus_signal_info_contracts_changed, NULL};
static const GDBusPropertyInfo * const _contractor_dbus_service_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _contractor_dbus_service_dbus_interface_info = {-1, "org.elementary.Contractor", (GDBusMethodInfo **) (&_contractor_dbus_service_dbus_method_info), (GDBusSignalInfo **) (&_contractor_dbus_service_dbus_signal_info), (GDBusPropertyInfo **) (&_contractor_dbus_service_dbus_property_info), NULL};
static const GDBusInterfaceVTable _contractor_dbus_service_dbus_interface_vtable = {contractor_dbus_service_dbus_interface_method_call, contractor_dbus_service_dbus_interface_get_property, contractor_dbus_service_dbus_interface_set_property};

GQuark
contractor_contractor_error_quark (void)
{
	static volatile gsize contractor_contractor_error_quark_volatile = 0;
	g_dbus_error_register_error_domain ("contractor-contractor-error-quark", &contractor_contractor_error_quark_volatile, contractor_contractor_error_entries, G_N_ELEMENTS (contractor_contractor_error_entries));
	return (GQuark) contractor_contractor_error_quark_volatile;
}

static inline gpointer
contractor_dbus_service_get_instance_private (ContractorDBusService* self)
{
	return G_STRUCT_MEMBER_P (self, ContractorDBusService_private_offset);
}

/**
         * Constructor to create a DBusService object and setup a
         * ContractSource.
         */
static void
__lambda5_ (ContractorDBusService* self)
{
	g_signal_emit (self, contractor_dbus_service_signals[CONTRACTOR_DBUS_SERVICE_CONTRACTS_CHANGED_SIGNAL], 0);
}

static void
___lambda5__contractor_contract_source_changed (ContractorContractSource* _sender,
                                                gpointer self)
{
	__lambda5_ ((ContractorDBusService*) self);
}

ContractorDBusService*
contractor_dbus_service_construct (GType object_type)
{
	ContractorDBusService * self = NULL;
	ContractorContractSource* _tmp0_;
	ContractorContractSource* _tmp1_;
	self = (ContractorDBusService*) g_object_new (object_type, NULL);
	_tmp0_ = contractor_contract_source_new ();
	_g_object_unref0 (self->priv->contract_source);
	self->priv->contract_source = _tmp0_;
	_tmp1_ = self->priv->contract_source;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) ___lambda5__contractor_contract_source_changed, self, 0);
	return self;
}

ContractorDBusService*
contractor_dbus_service_new (void)
{
	return contractor_dbus_service_construct (CONTRACTOR_TYPE_DBUS_SERVICE);
}

/**
         * This method gets an array of GenericContracts filtered by a
         * MIME type.
         *
         * @param mime_type a MIME type string, e.g. text, image
         *
         * @return an array of GenericContracts
         */
static void
_vala_ContractorGenericContract_array_free (ContractorGenericContract * array,
                                            gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			contractor_generic_contract_destroy (&array[i]);
		}
	}
	g_free (array);
}

ContractorGenericContract*
contractor_dbus_service_get_contracts_by_mime (ContractorDBusService* self,
                                               const gchar* mime_type,
                                               gint* result_length1,
                                               GError** error)
{
	gchar** mime_types = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint mime_types_length1;
	gint _mime_types_size_;
	ContractorGenericContract* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ContractorGenericContract* _tmp4_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	ContractorGenericContract* _tmp5_;
	gint _tmp5__length1;
	ContractorGenericContract* _tmp6_;
	gint _tmp6__length1;
	GError* _inner_error0_ = NULL;
	ContractorGenericContract* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	_tmp0_ = g_strdup (mime_type);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	mime_types = _tmp1_;
	mime_types_length1 = 1;
	_mime_types_size_ = mime_types_length1;
	_tmp4_ = contractor_dbus_service_get_contracts_by_mimelist (self, mime_types, (gint) mime_types_length1, &_tmp3_, &_inner_error0_);
	_tmp2_ = _tmp4_;
	_tmp2__length1 = _tmp3_;
	__tmp2__size_ = _tmp2__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	_tmp5_ = _tmp2_;
	_tmp5__length1 = _tmp2__length1;
	_tmp2_ = NULL;
	_tmp2__length1 = 0;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	_tmp2_ = (_vala_ContractorGenericContract_array_free (_tmp2_, _tmp2__length1), NULL);
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
         * This method gets an array of GenericContracts filtered by an array of
         * MIME types.
         *
         * @param mime_types an array of MIME type strings, e.g. text, image
         *
         * @return an array of GenericContracts
         */
ContractorGenericContract*
contractor_dbus_service_get_contracts_by_mimelist (ContractorDBusService* self,
                                                   gchar** mime_types,
                                                   gint mime_types_length1,
                                                   gint* result_length1,
                                                   GError** error)
{
	GeeCollection* all_contracts = NULL;
	ContractorContractSource* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* contracts = NULL;
	GeeCollection* _tmp2_;
	gint _tmp3_ = 0;
	ContractorGenericContract* _tmp4_;
	ContractorGenericContract* _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	ContractorGenericContract* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->contract_source;
	_tmp1_ = contractor_contract_source_get_contracts (_tmp0_);
	all_contracts = _tmp1_;
	_tmp2_ = contractor_contract_matcher_get_contracts_for_types (mime_types, (gint) mime_types_length1, all_contracts, &_inner_error0_);
	contracts = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (all_contracts);
		return NULL;
	}
	_tmp4_ = contractor_dbus_service_convert_to_generic_contracts (contracts, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	_g_object_unref0 (contracts);
	_g_object_unref0 (all_contracts);
	return result;
}

/**
         * This method gets an array of GenericContracts filtered by the file
         * size in bytes.
         *
         * @param file_size the file size in bytes, e.g. from FileInfo.get_size ()
         *
         * @return an array of GenericContracts
         */
ContractorGenericContract*
contractor_dbus_service_get_contracts_by_file_size (ContractorDBusService* self,
                                                    gint64 file_size,
                                                    gint* result_length1,
                                                    GError** error)
{
	GeeCollection* all_contracts = NULL;
	ContractorContractSource* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* contracts = NULL;
	GeeCollection* _tmp2_;
	gint _tmp3_ = 0;
	ContractorGenericContract* _tmp4_;
	ContractorGenericContract* _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	ContractorGenericContract* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->contract_source;
	_tmp1_ = contractor_contract_source_get_contracts (_tmp0_);
	all_contracts = _tmp1_;
	_tmp2_ = contractor_contract_matcher_get_contracts_for_file_size (file_size, all_contracts, &_inner_error0_);
	contracts = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (all_contracts);
		return NULL;
	}
	_tmp4_ = contractor_dbus_service_convert_to_generic_contracts (contracts, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	_g_object_unref0 (contracts);
	_g_object_unref0 (all_contracts);
	return result;
}

/**
         * This method gets an array of GenericContracts filtered by a MIME type
         * and the file size in bytes.
         *
         * @param mime_type a MIME type string, e.g. text, image
         * @param file_size the file size in bytes, e.g. from FileInfo.get_size ()
         *
         * @return an array of GenericContracts
         */
ContractorGenericContract*
contractor_dbus_service_get_contracts_by_mime_and_file_size (ContractorDBusService* self,
                                                             const gchar* mime_type,
                                                             gint64 file_size,
                                                             gint* result_length1,
                                                             GError** error)
{
	gchar** mime_types = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint mime_types_length1;
	gint _mime_types_size_;
	ContractorGenericContract* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ContractorGenericContract* _tmp4_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	ContractorGenericContract* _tmp5_;
	gint _tmp5__length1;
	ContractorGenericContract* _tmp6_;
	gint _tmp6__length1;
	GError* _inner_error0_ = NULL;
	ContractorGenericContract* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	_tmp0_ = g_strdup (mime_type);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	mime_types = _tmp1_;
	mime_types_length1 = 1;
	_mime_types_size_ = mime_types_length1;
	_tmp4_ = contractor_dbus_service_get_contracts_by_mimelist_and_file_size (self, mime_types, (gint) mime_types_length1, file_size, &_tmp3_, &_inner_error0_);
	_tmp2_ = _tmp4_;
	_tmp2__length1 = _tmp3_;
	__tmp2__size_ = _tmp2__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	_tmp5_ = _tmp2_;
	_tmp5__length1 = _tmp2__length1;
	_tmp2_ = NULL;
	_tmp2__length1 = 0;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	_tmp2_ = (_vala_ContractorGenericContract_array_free (_tmp2_, _tmp2__length1), NULL);
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
         * This method gets an array of GenericContracts filtered by an array of
         * MIME types and the file size in bytes.
         *
         * The file size should probably be the sum of all files file size.
         *
         * @param mime_types an array of MIME type strings, e.g. text, image
         * @param file_size the file size in bytes, e.g. from FileInfo.get_size ()
         *
         * @return an array of GenericContracts
         */
ContractorGenericContract*
contractor_dbus_service_get_contracts_by_mimelist_and_file_size (ContractorDBusService* self,
                                                                 gchar** mime_types,
                                                                 gint mime_types_length1,
                                                                 gint64 file_size,
                                                                 gint* result_length1,
                                                                 GError** error)
{
	GeeCollection* all_contracts = NULL;
	ContractorContractSource* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* contracts = NULL;
	GeeCollection* _tmp2_;
	gint _tmp3_ = 0;
	ContractorGenericContract* _tmp4_;
	ContractorGenericContract* _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	ContractorGenericContract* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->contract_source;
	_tmp1_ = contractor_contract_source_get_contracts (_tmp0_);
	all_contracts = _tmp1_;
	_tmp2_ = contractor_contract_matcher_get_contracts_for_types_and_file_size (mime_types, (gint) mime_types_length1, file_size, all_contracts, &_inner_error0_);
	contracts = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (all_contracts);
		return NULL;
	}
	_tmp4_ = contractor_dbus_service_convert_to_generic_contracts (contracts, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	_g_object_unref0 (contracts);
	_g_object_unref0 (all_contracts);
	return result;
}

void
contractor_dbus_service_execute_with_uri (ContractorDBusService* self,
                                          const gchar* id,
                                          const gchar* uri,
                                          GError** error)
{
	gchar** uris = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint uris_length1;
	gint _uris_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup (uri);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	uris = _tmp1_;
	uris_length1 = 1;
	_uris_size_ = uris_length1;
	contractor_dbus_service_execute_with_uri_list (self, id, uris, (gint) uris_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
}

void
contractor_dbus_service_execute_with_uri_list (ContractorDBusService* self,
                                               const gchar* id,
                                               gchar** uris,
                                               gint uris_length1,
                                               GError** error)
{
	ContractorContract* contract = NULL;
	ContractorContractSource* _tmp0_;
	ContractorContract* _tmp1_;
	ContractorContract* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = self->priv->contract_source;
	_tmp1_ = contractor_contract_source_lookup_by_id (_tmp0_, id, &_inner_error0_);
	contract = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = contract;
	contractor_contract_launch_uris (_tmp2_, uris, (gint) uris_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (contract);
		return;
	}
	_g_object_unref0 (contract);
}

/**
         * This method gets an array of GenericContracts containing all
         * contracts that exist.
         *
         * @return an array of GenericContracts containing all contracts
         */
ContractorGenericContract*
contractor_dbus_service_list_all_contracts (ContractorDBusService* self,
                                            gint* result_length1)
{
	GeeCollection* contracts = NULL;
	ContractorContractSource* _tmp0_;
	GeeCollection* _tmp1_;
	gint _tmp2_ = 0;
	ContractorGenericContract* _tmp3_;
	ContractorGenericContract* _tmp4_;
	gint _tmp4__length1;
	ContractorGenericContract* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->contract_source;
	_tmp1_ = contractor_contract_source_get_contracts (_tmp0_);
	contracts = _tmp1_;
	_tmp3_ = contractor_dbus_service_convert_to_generic_contracts (contracts, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (contracts);
	return result;
}

/**
         * Converts a Collection of Contracts into an array of
         * GenericContracts.
         *
         * @return an array of GenericContracts
         */
static void
_vala_array_add1 (ContractorGenericContract* * array,
                  gint* length,
                  gint* size,
                  const ContractorGenericContract* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ContractorGenericContract, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static ContractorGenericContract*
contractor_dbus_service_convert_to_generic_contracts (GeeCollection* contracts,
                                                      gint* result_length1)
{
	ContractorGenericContract* generic_contracts = NULL;
	ContractorGenericContract* _tmp0_;
	gint generic_contracts_length1;
	gint _generic_contracts_size_;
	ContractorGenericContract* _tmp7_;
	gint _tmp7__length1;
	ContractorGenericContract* result;
	g_return_val_if_fail (contracts != NULL, NULL);
	_tmp0_ = g_new0 (ContractorGenericContract, 0);
	generic_contracts = _tmp0_;
	generic_contracts_length1 = 0;
	_generic_contracts_size_ = generic_contracts_length1;
	{
		GeeIterator* _contract_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) contracts);
		_contract_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			ContractorContract* contract = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			ContractorContract* _tmp5_;
			ContractorGenericContract _tmp6_ = {0};
			_tmp2_ = _contract_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _contract_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			contract = (ContractorContract*) _tmp4_;
			_tmp5_ = contract;
			contractor_contract_get_generic (_tmp5_, &_tmp6_);
			_vala_array_add1 (&generic_contracts, &generic_contracts_length1, &_generic_contracts_size_, &_tmp6_);
			_g_object_unref0 (contract);
		}
		_g_object_unref0 (_contract_it);
	}
	_tmp7_ = generic_contracts;
	_tmp7__length1 = generic_contracts_length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static void
contractor_dbus_service_class_init (ContractorDBusServiceClass * klass,
                                    gpointer klass_data)
{
	contractor_dbus_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContractorDBusService_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contractor_dbus_service_finalize;
	/**
	         * Signal which gets sent when Contracts change.
	         */
	contractor_dbus_service_signals[CONTRACTOR_DBUS_SERVICE_CONTRACTS_CHANGED_SIGNAL] = g_signal_new ("contracts-changed", CONTRACTOR_TYPE_DBUS_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
contractor_dbus_service_instance_init (ContractorDBusService * self,
                                       gpointer klass)
{
	self->priv = contractor_dbus_service_get_instance_private (self);
}

static void
contractor_dbus_service_finalize (GObject * obj)
{
	ContractorDBusService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTRACTOR_TYPE_DBUS_SERVICE, ContractorDBusService);
	_g_object_unref0 (self->priv->contract_source);
	G_OBJECT_CLASS (contractor_dbus_service_parent_class)->finalize (obj);
}

/**
     * A D-Bus service handling requests for Contracts defined by .contract
     * files.
     */
static GType
contractor_dbus_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContractorDBusServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contractor_dbus_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContractorDBusService), 0, (GInstanceInitFunc) contractor_dbus_service_instance_init, NULL };
	GType contractor_dbus_service_type_id;
	contractor_dbus_service_type_id = g_type_register_static (G_TYPE_OBJECT, "ContractorDBusService", &g_define_type_info, 0);
	g_type_set_qdata (contractor_dbus_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) contractor_dbus_service_register_object);
	ContractorDBusService_private_offset = g_type_add_instance_private (contractor_dbus_service_type_id, sizeof (ContractorDBusServicePrivate));
	return contractor_dbus_service_type_id;
}

GType
contractor_dbus_service_get_type (void)
{
	static volatile gsize contractor_dbus_service_type_id__once = 0;
	if (g_once_init_enter (&contractor_dbus_service_type_id__once)) {
		GType contractor_dbus_service_type_id;
		contractor_dbus_service_type_id = contractor_dbus_service_get_type_once ();
		g_once_init_leave (&contractor_dbus_service_type_id__once, contractor_dbus_service_type_id);
	}
	return contractor_dbus_service_type_id__once;
}

static void
_dbus_contractor_dbus_service_get_contracts_by_mime (ContractorDBusService* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* mime_type = NULL;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	ContractorGenericContract* result;
	gint result_length1 = 0;
	ContractorGenericContract* _tmp1_;
	GVariantBuilder _tmp2_;
	gint _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	mime_type = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	result = contractor_dbus_service_get_contracts_by_mime (self, mime_type, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp1_ = result;
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("a(ssss)"));
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		GVariantBuilder _tmp4_;
		g_variant_builder_init (&_tmp4_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp4_, g_variant_new_string ((*_tmp1_).id));
		g_variant_builder_add_value (&_tmp4_, g_variant_new_string ((*_tmp1_).name));
		g_variant_builder_add_value (&_tmp4_, g_variant_new_string ((*_tmp1_).description));
		g_variant_builder_add_value (&_tmp4_, g_variant_new_string ((*_tmp1_).icon));
		g_variant_builder_add_value (&_tmp2_, g_variant_builder_end (&_tmp4_));
		_tmp1_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp2_));
	result = (_vala_ContractorGenericContract_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (mime_type);
	;
}

static void
_dbus_contractor_dbus_service_get_contracts_by_mimelist (ContractorDBusService* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** mime_types = NULL;
	gint mime_types_length1 = 0;
	GVariant* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length;
	gint _tmp6__size;
	gint _tmp6__length1;
	GVariantIter _tmp7_;
	GVariant* _tmp8_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	ContractorGenericContract* result;
	gint result_length1 = 0;
	ContractorGenericContract* _tmp9_;
	GVariantBuilder _tmp10_;
	gint _tmp11_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp6_ = g_new (gchar*, 5);
	_tmp6__length = 0;
	_tmp6__size = 4;
	_tmp6__length1 = 0;
	g_variant_iter_init (&_tmp7_, _tmp5_);
	for (; (_tmp8_ = g_variant_iter_next_value (&_tmp7_)) != NULL; _tmp6__length1++) {
		if (_tmp6__size == _tmp6__length) {
			_tmp6__size = 2 * _tmp6__size;
			_tmp6_ = g_renew (gchar*, _tmp6_, _tmp6__size + 1);
		}
		_tmp6_[_tmp6__length++] = g_variant_dup_string (_tmp8_, NULL);
		g_variant_unref (_tmp8_);
	}
	mime_types_length1 = _tmp6__length1;
	_tmp6_[_tmp6__length] = NULL;
	mime_types = _tmp6_;
	g_variant_unref (_tmp5_);
	result = contractor_dbus_service_get_contracts_by_mimelist (self, mime_types, mime_types_length1, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp9_ = result;
	g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("a(ssss)"));
	for (_tmp11_ = 0; _tmp11_ < result_length1; _tmp11_++) {
		GVariantBuilder _tmp12_;
		g_variant_builder_init (&_tmp12_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp12_, g_variant_new_string ((*_tmp9_).id));
		g_variant_builder_add_value (&_tmp12_, g_variant_new_string ((*_tmp9_).name));
		g_variant_builder_add_value (&_tmp12_, g_variant_new_string ((*_tmp9_).description));
		g_variant_builder_add_value (&_tmp12_, g_variant_new_string ((*_tmp9_).icon));
		g_variant_builder_add_value (&_tmp10_, g_variant_builder_end (&_tmp12_));
		_tmp9_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp10_));
	result = (_vala_ContractorGenericContract_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_contractor_dbus_service_get_contracts_by_file_size (ContractorDBusService* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint64 file_size = 0LL;
	GVariant* _tmp13_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	ContractorGenericContract* result;
	gint result_length1 = 0;
	ContractorGenericContract* _tmp14_;
	GVariantBuilder _tmp15_;
	gint _tmp16_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	file_size = g_variant_get_int64 (_tmp13_);
	g_variant_unref (_tmp13_);
	result = contractor_dbus_service_get_contracts_by_file_size (self, file_size, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp14_ = result;
	g_variant_builder_init (&_tmp15_, G_VARIANT_TYPE ("a(ssss)"));
	for (_tmp16_ = 0; _tmp16_ < result_length1; _tmp16_++) {
		GVariantBuilder _tmp17_;
		g_variant_builder_init (&_tmp17_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp17_, g_variant_new_string ((*_tmp14_).id));
		g_variant_builder_add_value (&_tmp17_, g_variant_new_string ((*_tmp14_).name));
		g_variant_builder_add_value (&_tmp17_, g_variant_new_string ((*_tmp14_).description));
		g_variant_builder_add_value (&_tmp17_, g_variant_new_string ((*_tmp14_).icon));
		g_variant_builder_add_value (&_tmp15_, g_variant_builder_end (&_tmp17_));
		_tmp14_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp15_));
	result = (_vala_ContractorGenericContract_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_contractor_dbus_service_get_contracts_by_mime_and_file_size (ContractorDBusService* self,
                                                                   GVariant* _parameters_,
                                                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* mime_type = NULL;
	GVariant* _tmp18_;
	gint64 file_size = 0LL;
	GVariant* _tmp19_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	ContractorGenericContract* result;
	gint result_length1 = 0;
	ContractorGenericContract* _tmp20_;
	GVariantBuilder _tmp21_;
	gint _tmp22_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	mime_type = g_variant_dup_string (_tmp18_, NULL);
	g_variant_unref (_tmp18_);
	_tmp19_ = g_variant_iter_next_value (&_arguments_iter);
	file_size = g_variant_get_int64 (_tmp19_);
	g_variant_unref (_tmp19_);
	result = contractor_dbus_service_get_contracts_by_mime_and_file_size (self, mime_type, file_size, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp20_ = result;
	g_variant_builder_init (&_tmp21_, G_VARIANT_TYPE ("a(ssss)"));
	for (_tmp22_ = 0; _tmp22_ < result_length1; _tmp22_++) {
		GVariantBuilder _tmp23_;
		g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp23_, g_variant_new_string ((*_tmp20_).id));
		g_variant_builder_add_value (&_tmp23_, g_variant_new_string ((*_tmp20_).name));
		g_variant_builder_add_value (&_tmp23_, g_variant_new_string ((*_tmp20_).description));
		g_variant_builder_add_value (&_tmp23_, g_variant_new_string ((*_tmp20_).icon));
		g_variant_builder_add_value (&_tmp21_, g_variant_builder_end (&_tmp23_));
		_tmp20_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp21_));
	result = (_vala_ContractorGenericContract_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (mime_type);
	;
}

static void
_dbus_contractor_dbus_service_get_contracts_by_mimelist_and_file_size (ContractorDBusService* self,
                                                                       GVariant* _parameters_,
                                                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** mime_types = NULL;
	gint mime_types_length1 = 0;
	GVariant* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length;
	gint _tmp25__size;
	gint _tmp25__length1;
	GVariantIter _tmp26_;
	GVariant* _tmp27_;
	gint64 file_size = 0LL;
	GVariant* _tmp28_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	ContractorGenericContract* result;
	gint result_length1 = 0;
	ContractorGenericContract* _tmp29_;
	GVariantBuilder _tmp30_;
	gint _tmp31_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp25_ = g_new (gchar*, 5);
	_tmp25__length = 0;
	_tmp25__size = 4;
	_tmp25__length1 = 0;
	g_variant_iter_init (&_tmp26_, _tmp24_);
	for (; (_tmp27_ = g_variant_iter_next_value (&_tmp26_)) != NULL; _tmp25__length1++) {
		if (_tmp25__size == _tmp25__length) {
			_tmp25__size = 2 * _tmp25__size;
			_tmp25_ = g_renew (gchar*, _tmp25_, _tmp25__size + 1);
		}
		_tmp25_[_tmp25__length++] = g_variant_dup_string (_tmp27_, NULL);
		g_variant_unref (_tmp27_);
	}
	mime_types_length1 = _tmp25__length1;
	_tmp25_[_tmp25__length] = NULL;
	mime_types = _tmp25_;
	g_variant_unref (_tmp24_);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	file_size = g_variant_get_int64 (_tmp28_);
	g_variant_unref (_tmp28_);
	result = contractor_dbus_service_get_contracts_by_mimelist_and_file_size (self, mime_types, mime_types_length1, file_size, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp29_ = result;
	g_variant_builder_init (&_tmp30_, G_VARIANT_TYPE ("a(ssss)"));
	for (_tmp31_ = 0; _tmp31_ < result_length1; _tmp31_++) {
		GVariantBuilder _tmp32_;
		g_variant_builder_init (&_tmp32_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp32_, g_variant_new_string ((*_tmp29_).id));
		g_variant_builder_add_value (&_tmp32_, g_variant_new_string ((*_tmp29_).name));
		g_variant_builder_add_value (&_tmp32_, g_variant_new_string ((*_tmp29_).description));
		g_variant_builder_add_value (&_tmp32_, g_variant_new_string ((*_tmp29_).icon));
		g_variant_builder_add_value (&_tmp30_, g_variant_builder_end (&_tmp32_));
		_tmp29_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp30_));
	result = (_vala_ContractorGenericContract_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_contractor_dbus_service_execute_with_uri (ContractorDBusService* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp33_;
	gchar* uri = NULL;
	GVariant* _tmp34_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp33_, NULL);
	g_variant_unref (_tmp33_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp34_, NULL);
	g_variant_unref (_tmp34_);
	contractor_dbus_service_execute_with_uri (self, id, uri, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (id);
	_g_free0 (uri);
	;
}

static void
_dbus_contractor_dbus_service_execute_with_uri_list (ContractorDBusService* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* id = NULL;
	GVariant* _tmp35_;
	gchar** uris = NULL;
	gint uris_length1 = 0;
	GVariant* _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length;
	gint _tmp37__size;
	gint _tmp37__length1;
	GVariantIter _tmp38_;
	GVariant* _tmp39_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	id = g_variant_dup_string (_tmp35_, NULL);
	g_variant_unref (_tmp35_);
	_tmp36_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp37_ = g_new (gchar*, 5);
	_tmp37__length = 0;
	_tmp37__size = 4;
	_tmp37__length1 = 0;
	g_variant_iter_init (&_tmp38_, _tmp36_);
	for (; (_tmp39_ = g_variant_iter_next_value (&_tmp38_)) != NULL; _tmp37__length1++) {
		if (_tmp37__size == _tmp37__length) {
			_tmp37__size = 2 * _tmp37__size;
			_tmp37_ = g_renew (gchar*, _tmp37_, _tmp37__size + 1);
		}
		_tmp37_[_tmp37__length++] = g_variant_dup_string (_tmp39_, NULL);
		g_variant_unref (_tmp39_);
	}
	uris_length1 = _tmp37__length1;
	_tmp37_[_tmp37__length] = NULL;
	uris = _tmp37_;
	g_variant_unref (_tmp36_);
	contractor_dbus_service_execute_with_uri_list (self, id, uris, uris_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (id);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_contractor_dbus_service_list_all_contracts (ContractorDBusService* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	ContractorGenericContract* result;
	gint result_length1 = 0;
	ContractorGenericContract* _tmp40_;
	GVariantBuilder _tmp41_;
	gint _tmp42_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = contractor_dbus_service_list_all_contracts (self, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp40_ = result;
	g_variant_builder_init (&_tmp41_, G_VARIANT_TYPE ("a(ssss)"));
	for (_tmp42_ = 0; _tmp42_ < result_length1; _tmp42_++) {
		GVariantBuilder _tmp43_;
		g_variant_builder_init (&_tmp43_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp43_, g_variant_new_string ((*_tmp40_).id));
		g_variant_builder_add_value (&_tmp43_, g_variant_new_string ((*_tmp40_).name));
		g_variant_builder_add_value (&_tmp43_, g_variant_new_string ((*_tmp40_).description));
		g_variant_builder_add_value (&_tmp43_, g_variant_new_string ((*_tmp40_).icon));
		g_variant_builder_add_value (&_tmp41_, g_variant_builder_end (&_tmp43_));
		_tmp40_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp41_));
	result = (_vala_ContractorGenericContract_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
contractor_dbus_service_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetContractsByMime") == 0) {
		_dbus_contractor_dbus_service_get_contracts_by_mime (object, parameters, invocation);
	} else if (strcmp (method_name, "GetContractsByMimelist") == 0) {
		_dbus_contractor_dbus_service_get_contracts_by_mimelist (object, parameters, invocation);
	} else if (strcmp (method_name, "GetContractsByFileSize") == 0) {
		_dbus_contractor_dbus_service_get_contracts_by_file_size (object, parameters, invocation);
	} else if (strcmp (method_name, "GetContractsByMimeAndFileSize") == 0) {
		_dbus_contractor_dbus_service_get_contracts_by_mime_and_file_size (object, parameters, invocation);
	} else if (strcmp (method_name, "GetContractsByMimelistAndFileSize") == 0) {
		_dbus_contractor_dbus_service_get_contracts_by_mimelist_and_file_size (object, parameters, invocation);
	} else if (strcmp (method_name, "ExecuteWithUri") == 0) {
		_dbus_contractor_dbus_service_execute_with_uri (object, parameters, invocation);
	} else if (strcmp (method_name, "ExecuteWithUriList") == 0) {
		_dbus_contractor_dbus_service_execute_with_uri_list (object, parameters, invocation);
	} else if (strcmp (method_name, "ListAllContracts") == 0) {
		_dbus_contractor_dbus_service_list_all_contracts (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
contractor_dbus_service_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
contractor_dbus_service_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_contractor_dbus_service_contracts_changed (GObject* _sender,
                                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.elementary.Contractor", "ContractsChanged", _arguments, NULL);
}

guint
contractor_dbus_service_register_object (gpointer object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_contractor_dbus_service_dbus_interface_info), &_contractor_dbus_service_dbus_interface_vtable, data, _contractor_dbus_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "contracts-changed", (GCallback) _dbus_contractor_dbus_service_contracts_changed, data);
	return result;
}

static void
_contractor_dbus_service_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_contractor_dbus_service_contracts_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

