/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__QUANTIFIERS_H
#define CVC4__OPTIONS__QUANTIFIERS_H

#include "options/options.h"




#define CVC4_OPTIONS__QUANTIFIERS__FOR_OPTION_HOLDER \
  aggressiveMiniscopeQuant__option_t::type aggressiveMiniscopeQuant;\
  bool aggressiveMiniscopeQuant__setByUser__; \
  cegisSample__option_t::type cegisSample;\
  bool cegisSample__setByUser__; \
  cegqi__option_t::type cegqi;\
  bool cegqi__setByUser__; \
  cegqiAll__option_t::type cegqiAll;\
  bool cegqiAll__setByUser__; \
  cegqiBv__option_t::type cegqiBv;\
  bool cegqiBv__setByUser__; \
  cegqiBvConcInv__option_t::type cegqiBvConcInv;\
  bool cegqiBvConcInv__setByUser__; \
  cegqiBvIneqMode__option_t::type cegqiBvIneqMode;\
  bool cegqiBvIneqMode__setByUser__; \
  cegqiBvInterleaveValue__option_t::type cegqiBvInterleaveValue;\
  bool cegqiBvInterleaveValue__setByUser__; \
  cegqiBvLinearize__option_t::type cegqiBvLinearize;\
  bool cegqiBvLinearize__setByUser__; \
  cegqiBvRmExtract__option_t::type cegqiBvRmExtract;\
  bool cegqiBvRmExtract__setByUser__; \
  cegqiBvSolveNl__option_t::type cegqiBvSolveNl;\
  bool cegqiBvSolveNl__setByUser__; \
  cegqiFullEffort__option_t::type cegqiFullEffort;\
  bool cegqiFullEffort__setByUser__; \
  cegqiInnermost__option_t::type cegqiInnermost;\
  bool cegqiInnermost__setByUser__; \
  cegqiMidpoint__option_t::type cegqiMidpoint;\
  bool cegqiMidpoint__setByUser__; \
  cegqiMinBounds__option_t::type cegqiMinBounds;\
  bool cegqiMinBounds__setByUser__; \
  cegqiModel__option_t::type cegqiModel;\
  bool cegqiModel__setByUser__; \
  cegqiMultiInst__option_t::type cegqiMultiInst;\
  bool cegqiMultiInst__setByUser__; \
  cegqiNestedQE__option_t::type cegqiNestedQE;\
  bool cegqiNestedQE__setByUser__; \
  cegqiNopt__option_t::type cegqiNopt;\
  bool cegqiNopt__setByUser__; \
  cegqiPreRegInst__option_t::type cegqiPreRegInst;\
  bool cegqiPreRegInst__setByUser__; \
  cegqiRepeatLit__option_t::type cegqiRepeatLit;\
  bool cegqiRepeatLit__setByUser__; \
  cegqiRoundUpLowerLia__option_t::type cegqiRoundUpLowerLia;\
  bool cegqiRoundUpLowerLia__setByUser__; \
  cegqiSat__option_t::type cegqiSat;\
  bool cegqiSat__setByUser__; \
  cegqiUseInfInt__option_t::type cegqiUseInfInt;\
  bool cegqiUseInfInt__setByUser__; \
  cegqiUseInfReal__option_t::type cegqiUseInfReal;\
  bool cegqiUseInfReal__setByUser__; \
  condVarSplitQuantAgg__option_t::type condVarSplitQuantAgg;\
  bool condVarSplitQuantAgg__setByUser__; \
  condVarSplitQuant__option_t::type condVarSplitQuant;\
  bool condVarSplitQuant__setByUser__; \
  conjectureFilterActiveTerms__option_t::type conjectureFilterActiveTerms;\
  bool conjectureFilterActiveTerms__setByUser__; \
  conjectureFilterCanonical__option_t::type conjectureFilterCanonical;\
  bool conjectureFilterCanonical__setByUser__; \
  conjectureFilterModel__option_t::type conjectureFilterModel;\
  bool conjectureFilterModel__setByUser__; \
  conjectureGen__option_t::type conjectureGen;\
  bool conjectureGen__setByUser__; \
  conjectureGenGtEnum__option_t::type conjectureGenGtEnum;\
  bool conjectureGenGtEnum__setByUser__; \
  conjectureGenMaxDepth__option_t::type conjectureGenMaxDepth;\
  bool conjectureGenMaxDepth__setByUser__; \
  conjectureGenPerRound__option_t::type conjectureGenPerRound;\
  bool conjectureGenPerRound__setByUser__; \
  conjectureUeeIntro__option_t::type conjectureUeeIntro;\
  bool conjectureUeeIntro__setByUser__; \
  conjectureNoFilter__option_t::type conjectureNoFilter;\
  bool conjectureNoFilter__setByUser__; \
  dtStcInduction__option_t::type dtStcInduction;\
  bool dtStcInduction__setByUser__; \
  dtVarExpandQuant__option_t::type dtVarExpandQuant;\
  bool dtVarExpandQuant__setByUser__; \
  eMatching__option_t::type eMatching;\
  bool eMatching__setByUser__; \
  elimExtArithQuant__option_t::type elimExtArithQuant;\
  bool elimExtArithQuant__setByUser__; \
  elimTautQuant__option_t::type elimTautQuant;\
  bool elimTautQuant__setByUser__; \
  extRewriteQuant__option_t::type extRewriteQuant;\
  bool extRewriteQuant__setByUser__; \
  finiteModelFind__option_t::type finiteModelFind;\
  bool finiteModelFind__setByUser__; \
  fmfBound__option_t::type fmfBound;\
  bool fmfBound__setByUser__; \
  fmfBoundInt__option_t::type fmfBoundInt;\
  bool fmfBoundInt__setByUser__; \
  fmfBoundLazy__option_t::type fmfBoundLazy;\
  bool fmfBoundLazy__setByUser__; \
  fmfFmcSimple__option_t::type fmfFmcSimple;\
  bool fmfFmcSimple__setByUser__; \
  fmfFreshDistConst__option_t::type fmfFreshDistConst;\
  bool fmfFreshDistConst__setByUser__; \
  fmfFunWellDefined__option_t::type fmfFunWellDefined;\
  bool fmfFunWellDefined__setByUser__; \
  fmfFunWellDefinedRelevant__option_t::type fmfFunWellDefinedRelevant;\
  bool fmfFunWellDefinedRelevant__setByUser__; \
  fmfInstEngine__option_t::type fmfInstEngine;\
  bool fmfInstEngine__setByUser__; \
  fmfTypeCompletionThresh__option_t::type fmfTypeCompletionThresh;\
  bool fmfTypeCompletionThresh__setByUser__; \
  fullSaturateInterleave__option_t::type fullSaturateInterleave;\
  bool fullSaturateInterleave__setByUser__; \
  fullSaturateStratify__option_t::type fullSaturateStratify;\
  bool fullSaturateStratify__setByUser__; \
  fullSaturateQuant__option_t::type fullSaturateQuant;\
  bool fullSaturateQuant__setByUser__; \
  fullSaturateLimit__option_t::type fullSaturateLimit;\
  bool fullSaturateLimit__setByUser__; \
  fullSaturateQuantRd__option_t::type fullSaturateQuantRd;\
  bool fullSaturateQuantRd__setByUser__; \
  globalNegate__option_t::type globalNegate;\
  bool globalNegate__setByUser__; \
  hoElim__option_t::type hoElim;\
  bool hoElim__setByUser__; \
  hoElimStoreAx__option_t::type hoElimStoreAx;\
  bool hoElimStoreAx__setByUser__; \
  hoMatching__option_t::type hoMatching;\
  bool hoMatching__setByUser__; \
  hoMatchingVarArgPriority__option_t::type hoMatchingVarArgPriority;\
  bool hoMatchingVarArgPriority__setByUser__; \
  hoMergeTermDb__option_t::type hoMergeTermDb;\
  bool hoMergeTermDb__setByUser__; \
  incrementTriggers__option_t::type incrementTriggers;\
  bool incrementTriggers__setByUser__; \
  instLevelInputOnly__option_t::type instLevelInputOnly;\
  bool instLevelInputOnly__setByUser__; \
  instMaxLevel__option_t::type instMaxLevel;\
  bool instMaxLevel__setByUser__; \
  instNoEntail__option_t::type instNoEntail;\
  bool instNoEntail__setByUser__; \
  instNoModelTrue__option_t::type instNoModelTrue;\
  bool instNoModelTrue__setByUser__; \
  instWhenPhase__option_t::type instWhenPhase;\
  bool instWhenPhase__setByUser__; \
  instWhenStrictInterleave__option_t::type instWhenStrictInterleave;\
  bool instWhenStrictInterleave__setByUser__; \
  instWhenTcFirst__option_t::type instWhenTcFirst;\
  bool instWhenTcFirst__setByUser__; \
  instWhenMode__option_t::type instWhenMode;\
  bool instWhenMode__setByUser__; \
  intWfInduction__option_t::type intWfInduction;\
  bool intWfInduction__setByUser__; \
  iteDtTesterSplitQuant__option_t::type iteDtTesterSplitQuant;\
  bool iteDtTesterSplitQuant__setByUser__; \
  iteLiftQuant__option_t::type iteLiftQuant;\
  bool iteLiftQuant__setByUser__; \
  literalMatchMode__option_t::type literalMatchMode;\
  bool literalMatchMode__setByUser__; \
  lteRestrictInstClosure__option_t::type lteRestrictInstClosure;\
  bool lteRestrictInstClosure__setByUser__; \
  macrosQuant__option_t::type macrosQuant;\
  bool macrosQuant__setByUser__; \
  macrosQuantMode__option_t::type macrosQuantMode;\
  bool macrosQuantMode__setByUser__; \
  mbqiInterleave__option_t::type mbqiInterleave;\
  bool mbqiInterleave__setByUser__; \
  fmfOneInstPerRound__option_t::type fmfOneInstPerRound;\
  bool fmfOneInstPerRound__setByUser__; \
  mbqiMode__option_t::type mbqiMode;\
  bool mbqiMode__setByUser__; \
  miniscopeQuant__option_t::type miniscopeQuant;\
  bool miniscopeQuant__setByUser__; \
  miniscopeQuantFreeVar__option_t::type miniscopeQuantFreeVar;\
  bool miniscopeQuantFreeVar__setByUser__; \
  multiTriggerCache__option_t::type multiTriggerCache;\
  bool multiTriggerCache__setByUser__; \
  multiTriggerLinear__option_t::type multiTriggerLinear;\
  bool multiTriggerLinear__setByUser__; \
  multiTriggerPriority__option_t::type multiTriggerPriority;\
  bool multiTriggerPriority__setByUser__; \
  multiTriggerWhenSingle__option_t::type multiTriggerWhenSingle;\
  bool multiTriggerWhenSingle__setByUser__; \
  partialTriggers__option_t::type partialTriggers;\
  bool partialTriggers__setByUser__; \
  preSkolemQuant__option_t::type preSkolemQuant;\
  bool preSkolemQuant__setByUser__; \
  preSkolemQuantAgg__option_t::type preSkolemQuantAgg;\
  bool preSkolemQuantAgg__setByUser__; \
  preSkolemQuantNested__option_t::type preSkolemQuantNested;\
  bool preSkolemQuantNested__setByUser__; \
  prenexQuantUser__option_t::type prenexQuantUser;\
  bool prenexQuantUser__setByUser__; \
  prenexQuant__option_t::type prenexQuant;\
  bool prenexQuant__setByUser__; \
  pureThTriggers__option_t::type pureThTriggers;\
  bool pureThTriggers__setByUser__; \
  purifyDtTriggers__option_t::type purifyDtTriggers;\
  bool purifyDtTriggers__setByUser__; \
  purifyTriggers__option_t::type purifyTriggers;\
  bool purifyTriggers__setByUser__; \
  qcfAllConflict__option_t::type qcfAllConflict;\
  bool qcfAllConflict__setByUser__; \
  qcfEagerCheckRd__option_t::type qcfEagerCheckRd;\
  bool qcfEagerCheckRd__setByUser__; \
  qcfEagerTest__option_t::type qcfEagerTest;\
  bool qcfEagerTest__setByUser__; \
  qcfNestedConflict__option_t::type qcfNestedConflict;\
  bool qcfNestedConflict__setByUser__; \
  qcfSkipRd__option_t::type qcfSkipRd;\
  bool qcfSkipRd__setByUser__; \
  qcfTConstraint__option_t::type qcfTConstraint;\
  bool qcfTConstraint__setByUser__; \
  qcfVoExp__option_t::type qcfVoExp;\
  bool qcfVoExp__setByUser__; \
  quantAlphaEquiv__option_t::type quantAlphaEquiv;\
  bool quantAlphaEquiv__setByUser__; \
  quantAntiSkolem__option_t::type quantAntiSkolem;\
  bool quantAntiSkolem__setByUser__; \
  quantConflictFind__option_t::type quantConflictFind;\
  bool quantConflictFind__setByUser__; \
  qcfMode__option_t::type qcfMode;\
  bool qcfMode__setByUser__; \
  qcfWhenMode__option_t::type qcfWhenMode;\
  bool qcfWhenMode__setByUser__; \
  quantDynamicSplit__option_t::type quantDynamicSplit;\
  bool quantDynamicSplit__setByUser__; \
  quantEpr__option_t::type quantEpr;\
  bool quantEpr__setByUser__; \
  quantEprMatching__option_t::type quantEprMatching;\
  bool quantEprMatching__setByUser__; \
  quantFunWellDefined__option_t::type quantFunWellDefined;\
  bool quantFunWellDefined__setByUser__; \
  quantInduction__option_t::type quantInduction;\
  bool quantInduction__setByUser__; \
  quantModelEe__option_t::type quantModelEe;\
  bool quantModelEe__setByUser__; \
  quantRepMode__option_t::type quantRepMode;\
  bool quantRepMode__setByUser__; \
  quantSplit__option_t::type quantSplit;\
  bool quantSplit__setByUser__; \
  registerQuantBodyTerms__option_t::type registerQuantBodyTerms;\
  bool registerQuantBodyTerms__setByUser__; \
  relationalTriggers__option_t::type relationalTriggers;\
  bool relationalTriggers__setByUser__; \
  relevantTriggers__option_t::type relevantTriggers;\
  bool relevantTriggers__setByUser__; \
  strictTriggers__option_t::type strictTriggers;\
  bool strictTriggers__setByUser__; \
  sygus__option_t::type sygus;\
  bool sygus__setByUser__; \
  sygusActiveGenEnumConsts__option_t::type sygusActiveGenEnumConsts;\
  bool sygusActiveGenEnumConsts__setByUser__; \
  sygusActiveGenMode__option_t::type sygusActiveGenMode;\
  bool sygusActiveGenMode__setByUser__; \
  sygusAddConstGrammar__option_t::type sygusAddConstGrammar;\
  bool sygusAddConstGrammar__setByUser__; \
  sygusArgRelevant__option_t::type sygusArgRelevant;\
  bool sygusArgRelevant__setByUser__; \
  sygusInvAutoUnfold__option_t::type sygusInvAutoUnfold;\
  bool sygusInvAutoUnfold__setByUser__; \
  sygusBoolIteReturnConst__option_t::type sygusBoolIteReturnConst;\
  bool sygusBoolIteReturnConst__setByUser__; \
  sygusCoreConnective__option_t::type sygusCoreConnective;\
  bool sygusCoreConnective__setByUser__; \
  sygusConstRepairAbort__option_t::type sygusConstRepairAbort;\
  bool sygusConstRepairAbort__setByUser__; \
  sygusEvalOpt__option_t::type sygusEvalOpt;\
  bool sygusEvalOpt__setByUser__; \
  sygusEvalUnfold__option_t::type sygusEvalUnfold;\
  bool sygusEvalUnfold__setByUser__; \
  sygusEvalUnfoldBool__option_t::type sygusEvalUnfoldBool;\
  bool sygusEvalUnfoldBool__setByUser__; \
  sygusExprMinerCheckTimeout__option_t::type sygusExprMinerCheckTimeout;\
  bool sygusExprMinerCheckTimeout__setByUser__; \
  sygusExprMinerCheckUseExport__option_t::type sygusExprMinerCheckUseExport;\
  bool sygusExprMinerCheckUseExport__setByUser__; \
  sygusExtRew__option_t::type sygusExtRew;\
  bool sygusExtRew__setByUser__; \
  sygusFilterSolRevSubsume__option_t::type sygusFilterSolRevSubsume;\
  bool sygusFilterSolRevSubsume__setByUser__; \
  sygusFilterSolMode__option_t::type sygusFilterSolMode;\
  bool sygusFilterSolMode__setByUser__; \
  sygusGrammarConsMode__option_t::type sygusGrammarConsMode;\
  bool sygusGrammarConsMode__setByUser__; \
  sygusGrammarNorm__option_t::type sygusGrammarNorm;\
  bool sygusGrammarNorm__setByUser__; \
  sygusInference__option_t::type sygusInference;\
  bool sygusInference__setByUser__; \
  sygusInst__option_t::type sygusInst;\
  bool sygusInst__setByUser__; \
  sygusInvTemplWhenSyntax__option_t::type sygusInvTemplWhenSyntax;\
  bool sygusInvTemplWhenSyntax__setByUser__; \
  sygusInvTemplMode__option_t::type sygusInvTemplMode;\
  bool sygusInvTemplMode__setByUser__; \
  sygusMinGrammar__option_t::type sygusMinGrammar;\
  bool sygusMinGrammar__setByUser__; \
  sygusUnifPbe__option_t::type sygusUnifPbe;\
  bool sygusUnifPbe__setByUser__; \
  sygusPbeMultiFair__option_t::type sygusPbeMultiFair;\
  bool sygusPbeMultiFair__setByUser__; \
  sygusPbeMultiFairDiff__option_t::type sygusPbeMultiFairDiff;\
  bool sygusPbeMultiFairDiff__setByUser__; \
  sygusQePreproc__option_t::type sygusQePreproc;\
  bool sygusQePreproc__setByUser__; \
  sygusQueryGen__option_t::type sygusQueryGen;\
  bool sygusQueryGen__setByUser__; \
  sygusQueryGenCheck__option_t::type sygusQueryGenCheck;\
  bool sygusQueryGenCheck__setByUser__; \
  sygusQueryGenDumpFiles__option_t::type sygusQueryGenDumpFiles;\
  bool sygusQueryGenDumpFiles__setByUser__; \
  sygusQueryGenThresh__option_t::type sygusQueryGenThresh;\
  bool sygusQueryGenThresh__setByUser__; \
  sygusRecFun__option_t::type sygusRecFun;\
  bool sygusRecFun__setByUser__; \
  sygusRecFunEvalLimit__option_t::type sygusRecFunEvalLimit;\
  bool sygusRecFunEvalLimit__setByUser__; \
  sygusRepairConst__option_t::type sygusRepairConst;\
  bool sygusRepairConst__setByUser__; \
  sygusRepairConstTimeout__option_t::type sygusRepairConstTimeout;\
  bool sygusRepairConstTimeout__setByUser__; \
  sygusRew__option_t::type sygusRew;\
  bool sygusRew__setByUser__; \
  sygusRewSynth__option_t::type sygusRewSynth;\
  bool sygusRewSynth__setByUser__; \
  sygusRewSynthAccel__option_t::type sygusRewSynthAccel;\
  bool sygusRewSynthAccel__setByUser__; \
  sygusRewSynthCheck__option_t::type sygusRewSynthCheck;\
  bool sygusRewSynthCheck__setByUser__; \
  sygusRewSynthFilterCong__option_t::type sygusRewSynthFilterCong;\
  bool sygusRewSynthFilterCong__setByUser__; \
  sygusRewSynthFilterMatch__option_t::type sygusRewSynthFilterMatch;\
  bool sygusRewSynthFilterMatch__setByUser__; \
  sygusRewSynthFilterNonLinear__option_t::type sygusRewSynthFilterNonLinear;\
  bool sygusRewSynthFilterNonLinear__setByUser__; \
  sygusRewSynthFilterOrder__option_t::type sygusRewSynthFilterOrder;\
  bool sygusRewSynthFilterOrder__setByUser__; \
  sygusRewSynthInput__option_t::type sygusRewSynthInput;\
  bool sygusRewSynthInput__setByUser__; \
  sygusRewSynthInputNVars__option_t::type sygusRewSynthInputNVars;\
  bool sygusRewSynthInputNVars__setByUser__; \
  sygusRewSynthInputUseBool__option_t::type sygusRewSynthInputUseBool;\
  bool sygusRewSynthInputUseBool__setByUser__; \
  sygusRewSynthRec__option_t::type sygusRewSynthRec;\
  bool sygusRewSynthRec__setByUser__; \
  sygusRewVerify__option_t::type sygusRewVerify;\
  bool sygusRewVerify__setByUser__; \
  sygusRewVerifyAbort__option_t::type sygusRewVerifyAbort;\
  bool sygusRewVerifyAbort__setByUser__; \
  sygusSampleFpUniform__option_t::type sygusSampleFpUniform;\
  bool sygusSampleFpUniform__setByUser__; \
  sygusSampleGrammar__option_t::type sygusSampleGrammar;\
  bool sygusSampleGrammar__setByUser__; \
  sygusSamples__option_t::type sygusSamples;\
  bool sygusSamples__setByUser__; \
  cegqiSingleInvAbort__option_t::type cegqiSingleInvAbort;\
  bool cegqiSingleInvAbort__setByUser__; \
  cegqiSingleInvPartial__option_t::type cegqiSingleInvPartial;\
  bool cegqiSingleInvPartial__setByUser__; \
  cegqiSingleInvReconstructLimit__option_t::type cegqiSingleInvReconstructLimit;\
  bool cegqiSingleInvReconstructLimit__setByUser__; \
  cegqiSingleInvReconstruct__option_t::type cegqiSingleInvReconstruct;\
  bool cegqiSingleInvReconstruct__setByUser__; \
  cegqiSingleInvReconstructConst__option_t::type cegqiSingleInvReconstructConst;\
  bool cegqiSingleInvReconstructConst__setByUser__; \
  cegqiSingleInvMode__option_t::type cegqiSingleInvMode;\
  bool cegqiSingleInvMode__setByUser__; \
  sygusStream__option_t::type sygusStream;\
  bool sygusStream__setByUser__; \
  sygusTemplEmbedGrammar__option_t::type sygusTemplEmbedGrammar;\
  bool sygusTemplEmbedGrammar__setByUser__; \
  sygusUnifCondIndNoRepeatSol__option_t::type sygusUnifCondIndNoRepeatSol;\
  bool sygusUnifCondIndNoRepeatSol__setByUser__; \
  sygusUnifPi__option_t::type sygusUnifPi;\
  bool sygusUnifPi__setByUser__; \
  sygusUnifShuffleCond__option_t::type sygusUnifShuffleCond;\
  bool sygusUnifShuffleCond__setByUser__; \
  sygusVerifySubcall__option_t::type sygusVerifySubcall;\
  bool sygusVerifySubcall__setByUser__; \
  termDbMode__option_t::type termDbMode;\
  bool termDbMode__setByUser__; \
  trackInstLemmas__option_t::type trackInstLemmas;\
  bool trackInstLemmas__setByUser__; \
  triggerActiveSelMode__option_t::type triggerActiveSelMode;\
  bool triggerActiveSelMode__setByUser__; \
  triggerSelMode__option_t::type triggerSelMode;\
  bool triggerSelMode__setByUser__; \
  userPatternsQuant__option_t::type userPatternsQuant;\
  bool userPatternsQuant__setByUser__; \
  varElimQuant__option_t::type varElimQuant;\
  bool varElimQuant__setByUser__; \
  varIneqElimQuant__option_t::type varIneqElimQuant;\
  bool varIneqElimQuant__setByUser__;


namespace CVC4 {

namespace options {


enum class CegisSampleMode
{
  NONE,
  USE,
  TRUST
};
std::ostream&
operator<<(std::ostream& os, CegisSampleMode mode) CVC4_PUBLIC;
CegisSampleMode
stringToCegisSampleMode(const std::string& option, const std::string& optarg);
enum class CegqiBvIneqMode
{
  EQ_SLACK,
  EQ_BOUNDARY,
  KEEP
};
std::ostream&
operator<<(std::ostream& os, CegqiBvIneqMode mode) CVC4_PUBLIC;
CegqiBvIneqMode
stringToCegqiBvIneqMode(const std::string& option, const std::string& optarg);
enum class InstWhenMode
{
  PRE_FULL,
  FULL,
  FULL_DELAY,
  FULL_LAST_CALL,
  FULL_DELAY_LAST_CALL,
  LAST_CALL
};
std::ostream&
operator<<(std::ostream& os, InstWhenMode mode) CVC4_PUBLIC;
InstWhenMode
stringToInstWhenMode(const std::string& option, const std::string& optarg);
enum class IteLiftQuantMode
{
  NONE,
  SIMPLE,
  ALL
};
std::ostream&
operator<<(std::ostream& os, IteLiftQuantMode mode) CVC4_PUBLIC;
IteLiftQuantMode
stringToIteLiftQuantMode(const std::string& option, const std::string& optarg);
enum class LiteralMatchMode
{
  NONE,
  USE,
  AGG_PREDICATE,
  AGG
};
std::ostream&
operator<<(std::ostream& os, LiteralMatchMode mode) CVC4_PUBLIC;
LiteralMatchMode
stringToLiteralMatchMode(const std::string& option, const std::string& optarg);
enum class MacrosQuantMode
{
  ALL,
  GROUND,
  GROUND_UF
};
std::ostream&
operator<<(std::ostream& os, MacrosQuantMode mode) CVC4_PUBLIC;
MacrosQuantMode
stringToMacrosQuantMode(const std::string& option, const std::string& optarg);
enum class MbqiMode
{
  NONE,
  FMC,
  TRUST
};
std::ostream&
operator<<(std::ostream& os, MbqiMode mode) CVC4_PUBLIC;
MbqiMode
stringToMbqiMode(const std::string& option, const std::string& optarg);
enum class PrenexQuantMode
{
  NONE,
  SIMPLE,
  NORMAL
};
std::ostream&
operator<<(std::ostream& os, PrenexQuantMode mode) CVC4_PUBLIC;
PrenexQuantMode
stringToPrenexQuantMode(const std::string& option, const std::string& optarg);
enum class QcfMode
{
  CONFLICT_ONLY,
  PROP_EQ,
  PARTIAL
};
std::ostream&
operator<<(std::ostream& os, QcfMode mode) CVC4_PUBLIC;
QcfMode
stringToQcfMode(const std::string& option, const std::string& optarg);
enum class QcfWhenMode
{
  DEFAULT,
  LAST_CALL,
  STD,
  STD_H
};
std::ostream&
operator<<(std::ostream& os, QcfWhenMode mode) CVC4_PUBLIC;
QcfWhenMode
stringToQcfWhenMode(const std::string& option, const std::string& optarg);
enum class QuantDSplitMode
{
  NONE,
  DEFAULT,
  AGG
};
std::ostream&
operator<<(std::ostream& os, QuantDSplitMode mode) CVC4_PUBLIC;
QuantDSplitMode
stringToQuantDSplitMode(const std::string& option, const std::string& optarg);
enum class QuantRepMode
{
  EE,
  FIRST,
  DEPTH
};
std::ostream&
operator<<(std::ostream& os, QuantRepMode mode) CVC4_PUBLIC;
QuantRepMode
stringToQuantRepMode(const std::string& option, const std::string& optarg);
enum class SygusActiveGenMode
{
  NONE,
  ENUM_BASIC,
  ENUM,
  VAR_AGNOSTIC,
  AUTO
};
std::ostream&
operator<<(std::ostream& os, SygusActiveGenMode mode) CVC4_PUBLIC;
SygusActiveGenMode
stringToSygusActiveGenMode(const std::string& option, const std::string& optarg);
enum class SygusFilterSolMode
{
  NONE,
  STRONG,
  WEAK
};
std::ostream&
operator<<(std::ostream& os, SygusFilterSolMode mode) CVC4_PUBLIC;
SygusFilterSolMode
stringToSygusFilterSolMode(const std::string& option, const std::string& optarg);
enum class SygusGrammarConsMode
{
  SIMPLE,
  ANY_CONST,
  ANY_TERM,
  ANY_TERM_CONCISE
};
std::ostream&
operator<<(std::ostream& os, SygusGrammarConsMode mode) CVC4_PUBLIC;
SygusGrammarConsMode
stringToSygusGrammarConsMode(const std::string& option, const std::string& optarg);
enum class SygusInvTemplMode
{
  NONE,
  PRE,
  POST
};
std::ostream&
operator<<(std::ostream& os, SygusInvTemplMode mode) CVC4_PUBLIC;
SygusInvTemplMode
stringToSygusInvTemplMode(const std::string& option, const std::string& optarg);
enum class SygusQueryDumpFilesMode
{
  NONE,
  ALL,
  UNSOLVED
};
std::ostream&
operator<<(std::ostream& os, SygusQueryDumpFilesMode mode) CVC4_PUBLIC;
SygusQueryDumpFilesMode
stringToSygusQueryDumpFilesMode(const std::string& option, const std::string& optarg);
enum class CegqiSingleInvRconsMode
{
  NONE,
  TRY,
  ALL_LIMIT,
  ALL
};
std::ostream&
operator<<(std::ostream& os, CegqiSingleInvRconsMode mode) CVC4_PUBLIC;
CegqiSingleInvRconsMode
stringToCegqiSingleInvRconsMode(const std::string& option, const std::string& optarg);
enum class CegqiSingleInvMode
{
  NONE,
  USE,
  ALL
};
std::ostream&
operator<<(std::ostream& os, CegqiSingleInvMode mode) CVC4_PUBLIC;
CegqiSingleInvMode
stringToCegqiSingleInvMode(const std::string& option, const std::string& optarg);
enum class SygusUnifPiMode
{
  NONE,
  COMPLETE,
  CENUM,
  CENUM_IGAIN
};
std::ostream&
operator<<(std::ostream& os, SygusUnifPiMode mode) CVC4_PUBLIC;
SygusUnifPiMode
stringToSygusUnifPiMode(const std::string& option, const std::string& optarg);
enum class TermDbMode
{
  ALL,
  RELEVANT
};
std::ostream&
operator<<(std::ostream& os, TermDbMode mode) CVC4_PUBLIC;
TermDbMode
stringToTermDbMode(const std::string& option, const std::string& optarg);
enum class TriggerActiveSelMode
{
  ALL,
  MIN,
  MAX
};
std::ostream&
operator<<(std::ostream& os, TriggerActiveSelMode mode) CVC4_PUBLIC;
TriggerActiveSelMode
stringToTriggerActiveSelMode(const std::string& option, const std::string& optarg);
enum class TriggerSelMode
{
  MIN,
  MAX,
  MIN_SINGLE_MAX,
  MIN_SINGLE_ALL,
  ALL
};
std::ostream&
operator<<(std::ostream& os, TriggerSelMode mode) CVC4_PUBLIC;
TriggerSelMode
stringToTriggerSelMode(const std::string& option, const std::string& optarg);
enum class UserPatMode
{
  USE,
  TRUST,
  RESORT,
  IGNORE,
  INTERLEAVE
};
std::ostream&
operator<<(std::ostream& os, UserPatMode mode) CVC4_PUBLIC;
UserPatMode
stringToUserPatMode(const std::string& option, const std::string& optarg);

extern struct CVC4_PUBLIC aggressiveMiniscopeQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} aggressiveMiniscopeQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegisSample__option_t
{
  typedef CegisSampleMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegisSample CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqi__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqi CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiAll__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiAll CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiBv__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiBv CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiBvConcInv__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiBvConcInv CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiBvIneqMode__option_t
{
  typedef CegqiBvIneqMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiBvIneqMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiBvInterleaveValue__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiBvInterleaveValue CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiBvLinearize__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiBvLinearize CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiBvRmExtract__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiBvRmExtract CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiBvSolveNl__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiBvSolveNl CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiFullEffort__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiFullEffort CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiInnermost__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiInnermost CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiMidpoint__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiMidpoint CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiMinBounds__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiMinBounds CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiModel__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiModel CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiMultiInst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiMultiInst CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiNestedQE__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiNestedQE CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiNopt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiNopt CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiPreRegInst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiPreRegInst CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiRepeatLit__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiRepeatLit CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiRoundUpLowerLia__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiRoundUpLowerLia CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSat__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiSat CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiUseInfInt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiUseInfInt CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiUseInfReal__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiUseInfReal CVC4_PUBLIC;
extern struct CVC4_PUBLIC condVarSplitQuantAgg__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} condVarSplitQuantAgg CVC4_PUBLIC;
extern struct CVC4_PUBLIC condVarSplitQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} condVarSplitQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureFilterActiveTerms__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} conjectureFilterActiveTerms CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureFilterCanonical__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} conjectureFilterCanonical CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureFilterModel__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} conjectureFilterModel CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureGen__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} conjectureGen CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureGenGtEnum__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} conjectureGenGtEnum CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureGenMaxDepth__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} conjectureGenMaxDepth CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureGenPerRound__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} conjectureGenPerRound CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureUeeIntro__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} conjectureUeeIntro CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureNoFilter__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} conjectureNoFilter CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtStcInduction__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} dtStcInduction CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtVarExpandQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtVarExpandQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC eMatching__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} eMatching CVC4_PUBLIC;
extern struct CVC4_PUBLIC elimExtArithQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} elimExtArithQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC elimTautQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} elimTautQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC extRewriteQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} extRewriteQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC finiteModelFind__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} finiteModelFind CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfBound__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfBound CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfBoundInt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfBoundInt CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfBoundLazy__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfBoundLazy CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfFmcSimple__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfFmcSimple CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfFreshDistConst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfFreshDistConst CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfFunWellDefined__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfFunWellDefined CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfFunWellDefinedRelevant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfFunWellDefinedRelevant CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfInstEngine__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfInstEngine CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfTypeCompletionThresh__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfTypeCompletionThresh CVC4_PUBLIC;
extern struct CVC4_PUBLIC fullSaturateInterleave__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fullSaturateInterleave CVC4_PUBLIC;
extern struct CVC4_PUBLIC fullSaturateStratify__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fullSaturateStratify CVC4_PUBLIC;
extern struct CVC4_PUBLIC fullSaturateQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fullSaturateQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC fullSaturateLimit__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} fullSaturateLimit CVC4_PUBLIC;
extern struct CVC4_PUBLIC fullSaturateQuantRd__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fullSaturateQuantRd CVC4_PUBLIC;
extern struct CVC4_PUBLIC globalNegate__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} globalNegate CVC4_PUBLIC;
extern struct CVC4_PUBLIC hoElim__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} hoElim CVC4_PUBLIC;
extern struct CVC4_PUBLIC hoElimStoreAx__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} hoElimStoreAx CVC4_PUBLIC;
extern struct CVC4_PUBLIC hoMatching__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} hoMatching CVC4_PUBLIC;
extern struct CVC4_PUBLIC hoMatchingVarArgPriority__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} hoMatchingVarArgPriority CVC4_PUBLIC;
extern struct CVC4_PUBLIC hoMergeTermDb__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} hoMergeTermDb CVC4_PUBLIC;
extern struct CVC4_PUBLIC incrementTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} incrementTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC instLevelInputOnly__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} instLevelInputOnly CVC4_PUBLIC;
extern struct CVC4_PUBLIC instMaxLevel__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instMaxLevel CVC4_PUBLIC;
extern struct CVC4_PUBLIC instNoEntail__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instNoEntail CVC4_PUBLIC;
extern struct CVC4_PUBLIC instNoModelTrue__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instNoModelTrue CVC4_PUBLIC;
extern struct CVC4_PUBLIC instWhenPhase__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instWhenPhase CVC4_PUBLIC;
extern struct CVC4_PUBLIC instWhenStrictInterleave__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instWhenStrictInterleave CVC4_PUBLIC;
extern struct CVC4_PUBLIC instWhenTcFirst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instWhenTcFirst CVC4_PUBLIC;
extern struct CVC4_PUBLIC instWhenMode__option_t
{
  typedef InstWhenMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instWhenMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC intWfInduction__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} intWfInduction CVC4_PUBLIC;
extern struct CVC4_PUBLIC iteDtTesterSplitQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} iteDtTesterSplitQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC iteLiftQuant__option_t
{
  typedef IteLiftQuantMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} iteLiftQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC literalMatchMode__option_t
{
  typedef LiteralMatchMode type;
  type operator()() const;
  bool wasSetByUser() const;
} literalMatchMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC lteRestrictInstClosure__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} lteRestrictInstClosure CVC4_PUBLIC;
extern struct CVC4_PUBLIC macrosQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} macrosQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC macrosQuantMode__option_t
{
  typedef MacrosQuantMode type;
  type operator()() const;
  bool wasSetByUser() const;
} macrosQuantMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC mbqiInterleave__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} mbqiInterleave CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfOneInstPerRound__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfOneInstPerRound CVC4_PUBLIC;
extern struct CVC4_PUBLIC mbqiMode__option_t
{
  typedef MbqiMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} mbqiMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC miniscopeQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} miniscopeQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC miniscopeQuantFreeVar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} miniscopeQuantFreeVar CVC4_PUBLIC;
extern struct CVC4_PUBLIC multiTriggerCache__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} multiTriggerCache CVC4_PUBLIC;
extern struct CVC4_PUBLIC multiTriggerLinear__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} multiTriggerLinear CVC4_PUBLIC;
extern struct CVC4_PUBLIC multiTriggerPriority__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} multiTriggerPriority CVC4_PUBLIC;
extern struct CVC4_PUBLIC multiTriggerWhenSingle__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} multiTriggerWhenSingle CVC4_PUBLIC;
extern struct CVC4_PUBLIC partialTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} partialTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC preSkolemQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} preSkolemQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC preSkolemQuantAgg__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} preSkolemQuantAgg CVC4_PUBLIC;
extern struct CVC4_PUBLIC preSkolemQuantNested__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} preSkolemQuantNested CVC4_PUBLIC;
extern struct CVC4_PUBLIC prenexQuantUser__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} prenexQuantUser CVC4_PUBLIC;
extern struct CVC4_PUBLIC prenexQuant__option_t
{
  typedef PrenexQuantMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} prenexQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC pureThTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} pureThTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC purifyDtTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} purifyDtTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC purifyTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} purifyTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfAllConflict__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} qcfAllConflict CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfEagerCheckRd__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfEagerCheckRd CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfEagerTest__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfEagerTest CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfNestedConflict__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfNestedConflict CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfSkipRd__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfSkipRd CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfTConstraint__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} qcfTConstraint CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfVoExp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfVoExp CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantAlphaEquiv__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} quantAlphaEquiv CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantAntiSkolem__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantAntiSkolem CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantConflictFind__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantConflictFind CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfMode__option_t
{
  typedef QcfMode type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfWhenMode__option_t
{
  typedef QcfWhenMode type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfWhenMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantDynamicSplit__option_t
{
  typedef QuantDSplitMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantDynamicSplit CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantEpr__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantEpr CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantEprMatching__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} quantEprMatching CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantFunWellDefined__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} quantFunWellDefined CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantInduction__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} quantInduction CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantModelEe__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} quantModelEe CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantRepMode__option_t
{
  typedef QuantRepMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantRepMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantSplit__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantSplit CVC4_PUBLIC;
extern struct CVC4_PUBLIC registerQuantBodyTerms__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} registerQuantBodyTerms CVC4_PUBLIC;
extern struct CVC4_PUBLIC relationalTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} relationalTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC relevantTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} relevantTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC strictTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} strictTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygus__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygus CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusActiveGenEnumConsts__option_t
{
  typedef unsigned long type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusActiveGenEnumConsts CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusActiveGenMode__option_t
{
  typedef SygusActiveGenMode type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusActiveGenMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusAddConstGrammar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusAddConstGrammar CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusArgRelevant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusArgRelevant CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusInvAutoUnfold__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusInvAutoUnfold CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusBoolIteReturnConst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusBoolIteReturnConst CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusCoreConnective__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusCoreConnective CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusConstRepairAbort__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusConstRepairAbort CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusEvalOpt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusEvalOpt CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusEvalUnfold__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusEvalUnfold CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusEvalUnfoldBool__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusEvalUnfoldBool CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusExprMinerCheckTimeout__option_t
{
  typedef unsigned long type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusExprMinerCheckTimeout CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusExprMinerCheckUseExport__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusExprMinerCheckUseExport CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusExtRew__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusExtRew CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusFilterSolRevSubsume__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusFilterSolRevSubsume CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusFilterSolMode__option_t
{
  typedef SygusFilterSolMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusFilterSolMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusGrammarConsMode__option_t
{
  typedef SygusGrammarConsMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusGrammarConsMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusGrammarNorm__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusGrammarNorm CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusInference__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusInference CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusInst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusInst CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusInvTemplWhenSyntax__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusInvTemplWhenSyntax CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusInvTemplMode__option_t
{
  typedef SygusInvTemplMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusInvTemplMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusMinGrammar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusMinGrammar CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusUnifPbe__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusUnifPbe CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusPbeMultiFair__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusPbeMultiFair CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusPbeMultiFairDiff__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusPbeMultiFairDiff CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusQePreproc__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusQePreproc CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusQueryGen__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusQueryGen CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusQueryGenCheck__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusQueryGenCheck CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusQueryGenDumpFiles__option_t
{
  typedef SygusQueryDumpFilesMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusQueryGenDumpFiles CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusQueryGenThresh__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusQueryGenThresh CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRecFun__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRecFun CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRecFunEvalLimit__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRecFunEvalLimit CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRepairConst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRepairConst CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRepairConstTimeout__option_t
{
  typedef unsigned long type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRepairConstTimeout CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRew__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusRew CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynth__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynth CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthAccel__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthAccel CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthCheck__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthCheck CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthFilterCong__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthFilterCong CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthFilterMatch__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthFilterMatch CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthFilterNonLinear__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthFilterNonLinear CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthFilterOrder__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthFilterOrder CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthInput__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthInput CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthInputNVars__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthInputNVars CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthInputUseBool__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthInputUseBool CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthRec__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthRec CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewVerify__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewVerify CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewVerifyAbort__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewVerifyAbort CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSampleFpUniform__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusSampleFpUniform CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSampleGrammar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusSampleGrammar CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSamples__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusSamples CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSingleInvAbort__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiSingleInvAbort CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSingleInvPartial__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiSingleInvPartial CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSingleInvReconstructLimit__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiSingleInvReconstructLimit CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSingleInvReconstruct__option_t
{
  typedef CegqiSingleInvRconsMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiSingleInvReconstruct CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSingleInvReconstructConst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiSingleInvReconstructConst CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSingleInvMode__option_t
{
  typedef CegqiSingleInvMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiSingleInvMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusStream__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusStream CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusTemplEmbedGrammar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusTemplEmbedGrammar CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusUnifCondIndNoRepeatSol__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusUnifCondIndNoRepeatSol CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusUnifPi__option_t
{
  typedef SygusUnifPiMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusUnifPi CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusUnifShuffleCond__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusUnifShuffleCond CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusVerifySubcall__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusVerifySubcall CVC4_PUBLIC;
extern struct CVC4_PUBLIC termDbMode__option_t
{
  typedef TermDbMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} termDbMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC trackInstLemmas__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} trackInstLemmas CVC4_PUBLIC;
extern struct CVC4_PUBLIC triggerActiveSelMode__option_t
{
  typedef TriggerActiveSelMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} triggerActiveSelMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC triggerSelMode__option_t
{
  typedef TriggerSelMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} triggerSelMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC userPatternsQuant__option_t
{
  typedef UserPatMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} userPatternsQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC varElimQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} varElimQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC varIneqElimQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} varIneqElimQuant CVC4_PUBLIC;

}  // namespace options

template <> const options::aggressiveMiniscopeQuant__option_t::type& Options::operator[](
    options::aggressiveMiniscopeQuant__option_t) const;
template <> bool Options::wasSetByUser(options::aggressiveMiniscopeQuant__option_t) const;
template <> void Options::assignBool(
    options::aggressiveMiniscopeQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegisSample__option_t,
    const options::cegisSample__option_t::type& x);
template <> const options::cegisSample__option_t::type& Options::operator[](
    options::cegisSample__option_t) const;
template <> bool Options::wasSetByUser(options::cegisSample__option_t) const;
template <> void Options::assign(
    options::cegisSample__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::cegqi__option_t,
    const options::cegqi__option_t::type& x);
template <> const options::cegqi__option_t::type& Options::operator[](
    options::cegqi__option_t) const;
template <> bool Options::wasSetByUser(options::cegqi__option_t) const;
template <> void Options::assignBool(
    options::cegqi__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiAll__option_t,
    const options::cegqiAll__option_t::type& x);
template <> const options::cegqiAll__option_t::type& Options::operator[](
    options::cegqiAll__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiAll__option_t) const;
template <> void Options::assignBool(
    options::cegqiAll__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiBv__option_t,
    const options::cegqiBv__option_t::type& x);
template <> const options::cegqiBv__option_t::type& Options::operator[](
    options::cegqiBv__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiBv__option_t) const;
template <> void Options::assignBool(
    options::cegqiBv__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiBvConcInv__option_t,
    const options::cegqiBvConcInv__option_t::type& x);
template <> const options::cegqiBvConcInv__option_t::type& Options::operator[](
    options::cegqiBvConcInv__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiBvConcInv__option_t) const;
template <> void Options::assignBool(
    options::cegqiBvConcInv__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiBvIneqMode__option_t,
    const options::cegqiBvIneqMode__option_t::type& x);
template <> const options::cegqiBvIneqMode__option_t::type& Options::operator[](
    options::cegqiBvIneqMode__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiBvIneqMode__option_t) const;
template <> void Options::assign(
    options::cegqiBvIneqMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::cegqiBvInterleaveValue__option_t,
    const options::cegqiBvInterleaveValue__option_t::type& x);
template <> const options::cegqiBvInterleaveValue__option_t::type& Options::operator[](
    options::cegqiBvInterleaveValue__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiBvInterleaveValue__option_t) const;
template <> void Options::assignBool(
    options::cegqiBvInterleaveValue__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiBvLinearize__option_t,
    const options::cegqiBvLinearize__option_t::type& x);
template <> const options::cegqiBvLinearize__option_t::type& Options::operator[](
    options::cegqiBvLinearize__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiBvLinearize__option_t) const;
template <> void Options::assignBool(
    options::cegqiBvLinearize__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiBvRmExtract__option_t,
    const options::cegqiBvRmExtract__option_t::type& x);
template <> const options::cegqiBvRmExtract__option_t::type& Options::operator[](
    options::cegqiBvRmExtract__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiBvRmExtract__option_t) const;
template <> void Options::assignBool(
    options::cegqiBvRmExtract__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiBvSolveNl__option_t,
    const options::cegqiBvSolveNl__option_t::type& x);
template <> const options::cegqiBvSolveNl__option_t::type& Options::operator[](
    options::cegqiBvSolveNl__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiBvSolveNl__option_t) const;
template <> void Options::assignBool(
    options::cegqiBvSolveNl__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiFullEffort__option_t,
    const options::cegqiFullEffort__option_t::type& x);
template <> const options::cegqiFullEffort__option_t::type& Options::operator[](
    options::cegqiFullEffort__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiFullEffort__option_t) const;
template <> void Options::assignBool(
    options::cegqiFullEffort__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiInnermost__option_t,
    const options::cegqiInnermost__option_t::type& x);
template <> const options::cegqiInnermost__option_t::type& Options::operator[](
    options::cegqiInnermost__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiInnermost__option_t) const;
template <> void Options::assignBool(
    options::cegqiInnermost__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiMidpoint__option_t,
    const options::cegqiMidpoint__option_t::type& x);
template <> const options::cegqiMidpoint__option_t::type& Options::operator[](
    options::cegqiMidpoint__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiMidpoint__option_t) const;
template <> void Options::assignBool(
    options::cegqiMidpoint__option_t,
    std::string option,
    bool value);
template <> const options::cegqiMinBounds__option_t::type& Options::operator[](
    options::cegqiMinBounds__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiMinBounds__option_t) const;
template <> void Options::assignBool(
    options::cegqiMinBounds__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiModel__option_t,
    const options::cegqiModel__option_t::type& x);
template <> const options::cegqiModel__option_t::type& Options::operator[](
    options::cegqiModel__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiModel__option_t) const;
template <> void Options::assignBool(
    options::cegqiModel__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiMultiInst__option_t,
    const options::cegqiMultiInst__option_t::type& x);
template <> const options::cegqiMultiInst__option_t::type& Options::operator[](
    options::cegqiMultiInst__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiMultiInst__option_t) const;
template <> void Options::assignBool(
    options::cegqiMultiInst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiNestedQE__option_t,
    const options::cegqiNestedQE__option_t::type& x);
template <> const options::cegqiNestedQE__option_t::type& Options::operator[](
    options::cegqiNestedQE__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiNestedQE__option_t) const;
template <> void Options::assignBool(
    options::cegqiNestedQE__option_t,
    std::string option,
    bool value);
template <> const options::cegqiNopt__option_t::type& Options::operator[](
    options::cegqiNopt__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiNopt__option_t) const;
template <> void Options::assignBool(
    options::cegqiNopt__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiPreRegInst__option_t,
    const options::cegqiPreRegInst__option_t::type& x);
template <> const options::cegqiPreRegInst__option_t::type& Options::operator[](
    options::cegqiPreRegInst__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiPreRegInst__option_t) const;
template <> void Options::assignBool(
    options::cegqiPreRegInst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiRepeatLit__option_t,
    const options::cegqiRepeatLit__option_t::type& x);
template <> const options::cegqiRepeatLit__option_t::type& Options::operator[](
    options::cegqiRepeatLit__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiRepeatLit__option_t) const;
template <> void Options::assignBool(
    options::cegqiRepeatLit__option_t,
    std::string option,
    bool value);
template <> const options::cegqiRoundUpLowerLia__option_t::type& Options::operator[](
    options::cegqiRoundUpLowerLia__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiRoundUpLowerLia__option_t) const;
template <> void Options::assignBool(
    options::cegqiRoundUpLowerLia__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiSat__option_t,
    const options::cegqiSat__option_t::type& x);
template <> const options::cegqiSat__option_t::type& Options::operator[](
    options::cegqiSat__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSat__option_t) const;
template <> void Options::assignBool(
    options::cegqiSat__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiUseInfInt__option_t,
    const options::cegqiUseInfInt__option_t::type& x);
template <> const options::cegqiUseInfInt__option_t::type& Options::operator[](
    options::cegqiUseInfInt__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiUseInfInt__option_t) const;
template <> void Options::assignBool(
    options::cegqiUseInfInt__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiUseInfReal__option_t,
    const options::cegqiUseInfReal__option_t::type& x);
template <> const options::cegqiUseInfReal__option_t::type& Options::operator[](
    options::cegqiUseInfReal__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiUseInfReal__option_t) const;
template <> void Options::assignBool(
    options::cegqiUseInfReal__option_t,
    std::string option,
    bool value);
template <> const options::condVarSplitQuantAgg__option_t::type& Options::operator[](
    options::condVarSplitQuantAgg__option_t) const;
template <> bool Options::wasSetByUser(options::condVarSplitQuantAgg__option_t) const;
template <> void Options::assignBool(
    options::condVarSplitQuantAgg__option_t,
    std::string option,
    bool value);
template <> const options::condVarSplitQuant__option_t::type& Options::operator[](
    options::condVarSplitQuant__option_t) const;
template <> bool Options::wasSetByUser(options::condVarSplitQuant__option_t) const;
template <> void Options::assignBool(
    options::condVarSplitQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::conjectureFilterActiveTerms__option_t,
    const options::conjectureFilterActiveTerms__option_t::type& x);
template <> const options::conjectureFilterActiveTerms__option_t::type& Options::operator[](
    options::conjectureFilterActiveTerms__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureFilterActiveTerms__option_t) const;
template <> void Options::assignBool(
    options::conjectureFilterActiveTerms__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::conjectureFilterCanonical__option_t,
    const options::conjectureFilterCanonical__option_t::type& x);
template <> const options::conjectureFilterCanonical__option_t::type& Options::operator[](
    options::conjectureFilterCanonical__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureFilterCanonical__option_t) const;
template <> void Options::assignBool(
    options::conjectureFilterCanonical__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::conjectureFilterModel__option_t,
    const options::conjectureFilterModel__option_t::type& x);
template <> const options::conjectureFilterModel__option_t::type& Options::operator[](
    options::conjectureFilterModel__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureFilterModel__option_t) const;
template <> void Options::assignBool(
    options::conjectureFilterModel__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::conjectureGen__option_t,
    const options::conjectureGen__option_t::type& x);
template <> const options::conjectureGen__option_t::type& Options::operator[](
    options::conjectureGen__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureGen__option_t) const;
template <> void Options::assignBool(
    options::conjectureGen__option_t,
    std::string option,
    bool value);
template <> const options::conjectureGenGtEnum__option_t::type& Options::operator[](
    options::conjectureGenGtEnum__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureGenGtEnum__option_t) const;
template <> void Options::assign(
    options::conjectureGenGtEnum__option_t,
    std::string option,
    std::string value);
template <> const options::conjectureGenMaxDepth__option_t::type& Options::operator[](
    options::conjectureGenMaxDepth__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureGenMaxDepth__option_t) const;
template <> void Options::assign(
    options::conjectureGenMaxDepth__option_t,
    std::string option,
    std::string value);
template <> const options::conjectureGenPerRound__option_t::type& Options::operator[](
    options::conjectureGenPerRound__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureGenPerRound__option_t) const;
template <> void Options::assign(
    options::conjectureGenPerRound__option_t,
    std::string option,
    std::string value);
template <> const options::conjectureUeeIntro__option_t::type& Options::operator[](
    options::conjectureUeeIntro__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureUeeIntro__option_t) const;
template <> void Options::assignBool(
    options::conjectureUeeIntro__option_t,
    std::string option,
    bool value);
template <> const options::conjectureNoFilter__option_t::type& Options::operator[](
    options::conjectureNoFilter__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureNoFilter__option_t) const;
template <> void Options::assignBool(
    options::conjectureNoFilter__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::dtStcInduction__option_t,
    const options::dtStcInduction__option_t::type& x);
template <> const options::dtStcInduction__option_t::type& Options::operator[](
    options::dtStcInduction__option_t) const;
template <> bool Options::wasSetByUser(options::dtStcInduction__option_t) const;
template <> void Options::assignBool(
    options::dtStcInduction__option_t,
    std::string option,
    bool value);
template <> const options::dtVarExpandQuant__option_t::type& Options::operator[](
    options::dtVarExpandQuant__option_t) const;
template <> bool Options::wasSetByUser(options::dtVarExpandQuant__option_t) const;
template <> void Options::assignBool(
    options::dtVarExpandQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::eMatching__option_t,
    const options::eMatching__option_t::type& x);
template <> const options::eMatching__option_t::type& Options::operator[](
    options::eMatching__option_t) const;
template <> bool Options::wasSetByUser(options::eMatching__option_t) const;
template <> void Options::assignBool(
    options::eMatching__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::elimExtArithQuant__option_t,
    const options::elimExtArithQuant__option_t::type& x);
template <> const options::elimExtArithQuant__option_t::type& Options::operator[](
    options::elimExtArithQuant__option_t) const;
template <> bool Options::wasSetByUser(options::elimExtArithQuant__option_t) const;
template <> void Options::assignBool(
    options::elimExtArithQuant__option_t,
    std::string option,
    bool value);
template <> const options::elimTautQuant__option_t::type& Options::operator[](
    options::elimTautQuant__option_t) const;
template <> bool Options::wasSetByUser(options::elimTautQuant__option_t) const;
template <> void Options::assignBool(
    options::elimTautQuant__option_t,
    std::string option,
    bool value);
template <> const options::extRewriteQuant__option_t::type& Options::operator[](
    options::extRewriteQuant__option_t) const;
template <> bool Options::wasSetByUser(options::extRewriteQuant__option_t) const;
template <> void Options::assignBool(
    options::extRewriteQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::finiteModelFind__option_t,
    const options::finiteModelFind__option_t::type& x);
template <> const options::finiteModelFind__option_t::type& Options::operator[](
    options::finiteModelFind__option_t) const;
template <> bool Options::wasSetByUser(options::finiteModelFind__option_t) const;
template <> void Options::assignBool(
    options::finiteModelFind__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfBound__option_t,
    const options::fmfBound__option_t::type& x);
template <> const options::fmfBound__option_t::type& Options::operator[](
    options::fmfBound__option_t) const;
template <> bool Options::wasSetByUser(options::fmfBound__option_t) const;
template <> void Options::assignBool(
    options::fmfBound__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfBoundInt__option_t,
    const options::fmfBoundInt__option_t::type& x);
template <> const options::fmfBoundInt__option_t::type& Options::operator[](
    options::fmfBoundInt__option_t) const;
template <> bool Options::wasSetByUser(options::fmfBoundInt__option_t) const;
template <> void Options::assignBool(
    options::fmfBoundInt__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfBoundLazy__option_t,
    const options::fmfBoundLazy__option_t::type& x);
template <> const options::fmfBoundLazy__option_t::type& Options::operator[](
    options::fmfBoundLazy__option_t) const;
template <> bool Options::wasSetByUser(options::fmfBoundLazy__option_t) const;
template <> void Options::assignBool(
    options::fmfBoundLazy__option_t,
    std::string option,
    bool value);
template <> const options::fmfFmcSimple__option_t::type& Options::operator[](
    options::fmfFmcSimple__option_t) const;
template <> bool Options::wasSetByUser(options::fmfFmcSimple__option_t) const;
template <> void Options::assignBool(
    options::fmfFmcSimple__option_t,
    std::string option,
    bool value);
template <> const options::fmfFreshDistConst__option_t::type& Options::operator[](
    options::fmfFreshDistConst__option_t) const;
template <> bool Options::wasSetByUser(options::fmfFreshDistConst__option_t) const;
template <> void Options::assignBool(
    options::fmfFreshDistConst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfFunWellDefined__option_t,
    const options::fmfFunWellDefined__option_t::type& x);
template <> const options::fmfFunWellDefined__option_t::type& Options::operator[](
    options::fmfFunWellDefined__option_t) const;
template <> bool Options::wasSetByUser(options::fmfFunWellDefined__option_t) const;
template <> void Options::assignBool(
    options::fmfFunWellDefined__option_t,
    std::string option,
    bool value);
template <> const options::fmfFunWellDefinedRelevant__option_t::type& Options::operator[](
    options::fmfFunWellDefinedRelevant__option_t) const;
template <> bool Options::wasSetByUser(options::fmfFunWellDefinedRelevant__option_t) const;
template <> void Options::assignBool(
    options::fmfFunWellDefinedRelevant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfInstEngine__option_t,
    const options::fmfInstEngine__option_t::type& x);
template <> const options::fmfInstEngine__option_t::type& Options::operator[](
    options::fmfInstEngine__option_t) const;
template <> bool Options::wasSetByUser(options::fmfInstEngine__option_t) const;
template <> void Options::assignBool(
    options::fmfInstEngine__option_t,
    std::string option,
    bool value);
template <> const options::fmfTypeCompletionThresh__option_t::type& Options::operator[](
    options::fmfTypeCompletionThresh__option_t) const;
template <> bool Options::wasSetByUser(options::fmfTypeCompletionThresh__option_t) const;
template <> void Options::assign(
    options::fmfTypeCompletionThresh__option_t,
    std::string option,
    std::string value);
template <> const options::fullSaturateInterleave__option_t::type& Options::operator[](
    options::fullSaturateInterleave__option_t) const;
template <> bool Options::wasSetByUser(options::fullSaturateInterleave__option_t) const;
template <> void Options::assignBool(
    options::fullSaturateInterleave__option_t,
    std::string option,
    bool value);
template <> const options::fullSaturateStratify__option_t::type& Options::operator[](
    options::fullSaturateStratify__option_t) const;
template <> bool Options::wasSetByUser(options::fullSaturateStratify__option_t) const;
template <> void Options::assignBool(
    options::fullSaturateStratify__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fullSaturateQuant__option_t,
    const options::fullSaturateQuant__option_t::type& x);
template <> const options::fullSaturateQuant__option_t::type& Options::operator[](
    options::fullSaturateQuant__option_t) const;
template <> bool Options::wasSetByUser(options::fullSaturateQuant__option_t) const;
template <> void Options::assignBool(
    options::fullSaturateQuant__option_t,
    std::string option,
    bool value);
template <> const options::fullSaturateLimit__option_t::type& Options::operator[](
    options::fullSaturateLimit__option_t) const;
template <> bool Options::wasSetByUser(options::fullSaturateLimit__option_t) const;
template <> void Options::assign(
    options::fullSaturateLimit__option_t,
    std::string option,
    std::string value);
template <> const options::fullSaturateQuantRd__option_t::type& Options::operator[](
    options::fullSaturateQuantRd__option_t) const;
template <> bool Options::wasSetByUser(options::fullSaturateQuantRd__option_t) const;
template <> void Options::assignBool(
    options::fullSaturateQuantRd__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::globalNegate__option_t,
    const options::globalNegate__option_t::type& x);
template <> const options::globalNegate__option_t::type& Options::operator[](
    options::globalNegate__option_t) const;
template <> bool Options::wasSetByUser(options::globalNegate__option_t) const;
template <> void Options::assignBool(
    options::globalNegate__option_t,
    std::string option,
    bool value);
template <> const options::hoElim__option_t::type& Options::operator[](
    options::hoElim__option_t) const;
template <> bool Options::wasSetByUser(options::hoElim__option_t) const;
template <> void Options::assignBool(
    options::hoElim__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::hoElimStoreAx__option_t,
    const options::hoElimStoreAx__option_t::type& x);
template <> const options::hoElimStoreAx__option_t::type& Options::operator[](
    options::hoElimStoreAx__option_t) const;
template <> bool Options::wasSetByUser(options::hoElimStoreAx__option_t) const;
template <> void Options::assignBool(
    options::hoElimStoreAx__option_t,
    std::string option,
    bool value);
template <> const options::hoMatching__option_t::type& Options::operator[](
    options::hoMatching__option_t) const;
template <> bool Options::wasSetByUser(options::hoMatching__option_t) const;
template <> void Options::assignBool(
    options::hoMatching__option_t,
    std::string option,
    bool value);
template <> const options::hoMatchingVarArgPriority__option_t::type& Options::operator[](
    options::hoMatchingVarArgPriority__option_t) const;
template <> bool Options::wasSetByUser(options::hoMatchingVarArgPriority__option_t) const;
template <> void Options::assignBool(
    options::hoMatchingVarArgPriority__option_t,
    std::string option,
    bool value);
template <> const options::hoMergeTermDb__option_t::type& Options::operator[](
    options::hoMergeTermDb__option_t) const;
template <> bool Options::wasSetByUser(options::hoMergeTermDb__option_t) const;
template <> void Options::assignBool(
    options::hoMergeTermDb__option_t,
    std::string option,
    bool value);
template <> const options::incrementTriggers__option_t::type& Options::operator[](
    options::incrementTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::incrementTriggers__option_t) const;
template <> void Options::assignBool(
    options::incrementTriggers__option_t,
    std::string option,
    bool value);
template <> const options::instLevelInputOnly__option_t::type& Options::operator[](
    options::instLevelInputOnly__option_t) const;
template <> bool Options::wasSetByUser(options::instLevelInputOnly__option_t) const;
template <> void Options::assignBool(
    options::instLevelInputOnly__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instMaxLevel__option_t,
    const options::instMaxLevel__option_t::type& x);
template <> const options::instMaxLevel__option_t::type& Options::operator[](
    options::instMaxLevel__option_t) const;
template <> bool Options::wasSetByUser(options::instMaxLevel__option_t) const;
template <> void Options::assign(
    options::instMaxLevel__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::instNoEntail__option_t,
    const options::instNoEntail__option_t::type& x);
template <> const options::instNoEntail__option_t::type& Options::operator[](
    options::instNoEntail__option_t) const;
template <> bool Options::wasSetByUser(options::instNoEntail__option_t) const;
template <> void Options::assignBool(
    options::instNoEntail__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instNoModelTrue__option_t,
    const options::instNoModelTrue__option_t::type& x);
template <> const options::instNoModelTrue__option_t::type& Options::operator[](
    options::instNoModelTrue__option_t) const;
template <> bool Options::wasSetByUser(options::instNoModelTrue__option_t) const;
template <> void Options::assignBool(
    options::instNoModelTrue__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instWhenPhase__option_t,
    const options::instWhenPhase__option_t::type& x);
template <> const options::instWhenPhase__option_t::type& Options::operator[](
    options::instWhenPhase__option_t) const;
template <> bool Options::wasSetByUser(options::instWhenPhase__option_t) const;
template <> void Options::assign(
    options::instWhenPhase__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::instWhenStrictInterleave__option_t,
    const options::instWhenStrictInterleave__option_t::type& x);
template <> const options::instWhenStrictInterleave__option_t::type& Options::operator[](
    options::instWhenStrictInterleave__option_t) const;
template <> bool Options::wasSetByUser(options::instWhenStrictInterleave__option_t) const;
template <> void Options::assignBool(
    options::instWhenStrictInterleave__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instWhenTcFirst__option_t,
    const options::instWhenTcFirst__option_t::type& x);
template <> const options::instWhenTcFirst__option_t::type& Options::operator[](
    options::instWhenTcFirst__option_t) const;
template <> bool Options::wasSetByUser(options::instWhenTcFirst__option_t) const;
template <> void Options::assignBool(
    options::instWhenTcFirst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instWhenMode__option_t,
    const options::instWhenMode__option_t::type& x);
template <> const options::instWhenMode__option_t::type& Options::operator[](
    options::instWhenMode__option_t) const;
template <> bool Options::wasSetByUser(options::instWhenMode__option_t) const;
template <> void Options::assign(
    options::instWhenMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::intWfInduction__option_t,
    const options::intWfInduction__option_t::type& x);
template <> const options::intWfInduction__option_t::type& Options::operator[](
    options::intWfInduction__option_t) const;
template <> bool Options::wasSetByUser(options::intWfInduction__option_t) const;
template <> void Options::assignBool(
    options::intWfInduction__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::iteDtTesterSplitQuant__option_t,
    const options::iteDtTesterSplitQuant__option_t::type& x);
template <> const options::iteDtTesterSplitQuant__option_t::type& Options::operator[](
    options::iteDtTesterSplitQuant__option_t) const;
template <> bool Options::wasSetByUser(options::iteDtTesterSplitQuant__option_t) const;
template <> void Options::assignBool(
    options::iteDtTesterSplitQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::iteLiftQuant__option_t,
    const options::iteLiftQuant__option_t::type& x);
template <> const options::iteLiftQuant__option_t::type& Options::operator[](
    options::iteLiftQuant__option_t) const;
template <> bool Options::wasSetByUser(options::iteLiftQuant__option_t) const;
template <> void Options::assign(
    options::iteLiftQuant__option_t,
    std::string option,
    std::string value);
template <> const options::literalMatchMode__option_t::type& Options::operator[](
    options::literalMatchMode__option_t) const;
template <> bool Options::wasSetByUser(options::literalMatchMode__option_t) const;
template <> void Options::assign(
    options::literalMatchMode__option_t,
    std::string option,
    std::string value);
template <> const options::lteRestrictInstClosure__option_t::type& Options::operator[](
    options::lteRestrictInstClosure__option_t) const;
template <> bool Options::wasSetByUser(options::lteRestrictInstClosure__option_t) const;
template <> void Options::assignBool(
    options::lteRestrictInstClosure__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::macrosQuant__option_t,
    const options::macrosQuant__option_t::type& x);
template <> const options::macrosQuant__option_t::type& Options::operator[](
    options::macrosQuant__option_t) const;
template <> bool Options::wasSetByUser(options::macrosQuant__option_t) const;
template <> void Options::assignBool(
    options::macrosQuant__option_t,
    std::string option,
    bool value);
template <> const options::macrosQuantMode__option_t::type& Options::operator[](
    options::macrosQuantMode__option_t) const;
template <> bool Options::wasSetByUser(options::macrosQuantMode__option_t) const;
template <> void Options::assign(
    options::macrosQuantMode__option_t,
    std::string option,
    std::string value);
template <> const options::mbqiInterleave__option_t::type& Options::operator[](
    options::mbqiInterleave__option_t) const;
template <> bool Options::wasSetByUser(options::mbqiInterleave__option_t) const;
template <> void Options::assignBool(
    options::mbqiInterleave__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfOneInstPerRound__option_t,
    const options::fmfOneInstPerRound__option_t::type& x);
template <> const options::fmfOneInstPerRound__option_t::type& Options::operator[](
    options::fmfOneInstPerRound__option_t) const;
template <> bool Options::wasSetByUser(options::fmfOneInstPerRound__option_t) const;
template <> void Options::assignBool(
    options::fmfOneInstPerRound__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::mbqiMode__option_t,
    const options::mbqiMode__option_t::type& x);
template <> const options::mbqiMode__option_t::type& Options::operator[](
    options::mbqiMode__option_t) const;
template <> bool Options::wasSetByUser(options::mbqiMode__option_t) const;
template <> void Options::assign(
    options::mbqiMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::miniscopeQuant__option_t,
    const options::miniscopeQuant__option_t::type& x);
template <> const options::miniscopeQuant__option_t::type& Options::operator[](
    options::miniscopeQuant__option_t) const;
template <> bool Options::wasSetByUser(options::miniscopeQuant__option_t) const;
template <> void Options::assignBool(
    options::miniscopeQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::miniscopeQuantFreeVar__option_t,
    const options::miniscopeQuantFreeVar__option_t::type& x);
template <> const options::miniscopeQuantFreeVar__option_t::type& Options::operator[](
    options::miniscopeQuantFreeVar__option_t) const;
template <> bool Options::wasSetByUser(options::miniscopeQuantFreeVar__option_t) const;
template <> void Options::assignBool(
    options::miniscopeQuantFreeVar__option_t,
    std::string option,
    bool value);
template <> const options::multiTriggerCache__option_t::type& Options::operator[](
    options::multiTriggerCache__option_t) const;
template <> bool Options::wasSetByUser(options::multiTriggerCache__option_t) const;
template <> void Options::assignBool(
    options::multiTriggerCache__option_t,
    std::string option,
    bool value);
template <> const options::multiTriggerLinear__option_t::type& Options::operator[](
    options::multiTriggerLinear__option_t) const;
template <> bool Options::wasSetByUser(options::multiTriggerLinear__option_t) const;
template <> void Options::assignBool(
    options::multiTriggerLinear__option_t,
    std::string option,
    bool value);
template <> const options::multiTriggerPriority__option_t::type& Options::operator[](
    options::multiTriggerPriority__option_t) const;
template <> bool Options::wasSetByUser(options::multiTriggerPriority__option_t) const;
template <> void Options::assignBool(
    options::multiTriggerPriority__option_t,
    std::string option,
    bool value);
template <> const options::multiTriggerWhenSingle__option_t::type& Options::operator[](
    options::multiTriggerWhenSingle__option_t) const;
template <> bool Options::wasSetByUser(options::multiTriggerWhenSingle__option_t) const;
template <> void Options::assignBool(
    options::multiTriggerWhenSingle__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::partialTriggers__option_t,
    const options::partialTriggers__option_t::type& x);
template <> const options::partialTriggers__option_t::type& Options::operator[](
    options::partialTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::partialTriggers__option_t) const;
template <> void Options::assignBool(
    options::partialTriggers__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::preSkolemQuant__option_t,
    const options::preSkolemQuant__option_t::type& x);
template <> const options::preSkolemQuant__option_t::type& Options::operator[](
    options::preSkolemQuant__option_t) const;
template <> bool Options::wasSetByUser(options::preSkolemQuant__option_t) const;
template <> void Options::assignBool(
    options::preSkolemQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::preSkolemQuantAgg__option_t,
    const options::preSkolemQuantAgg__option_t::type& x);
template <> const options::preSkolemQuantAgg__option_t::type& Options::operator[](
    options::preSkolemQuantAgg__option_t) const;
template <> bool Options::wasSetByUser(options::preSkolemQuantAgg__option_t) const;
template <> void Options::assignBool(
    options::preSkolemQuantAgg__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::preSkolemQuantNested__option_t,
    const options::preSkolemQuantNested__option_t::type& x);
template <> const options::preSkolemQuantNested__option_t::type& Options::operator[](
    options::preSkolemQuantNested__option_t) const;
template <> bool Options::wasSetByUser(options::preSkolemQuantNested__option_t) const;
template <> void Options::assignBool(
    options::preSkolemQuantNested__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::prenexQuantUser__option_t,
    const options::prenexQuantUser__option_t::type& x);
template <> const options::prenexQuantUser__option_t::type& Options::operator[](
    options::prenexQuantUser__option_t) const;
template <> bool Options::wasSetByUser(options::prenexQuantUser__option_t) const;
template <> void Options::assignBool(
    options::prenexQuantUser__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::prenexQuant__option_t,
    const options::prenexQuant__option_t::type& x);
template <> const options::prenexQuant__option_t::type& Options::operator[](
    options::prenexQuant__option_t) const;
template <> bool Options::wasSetByUser(options::prenexQuant__option_t) const;
template <> void Options::assign(
    options::prenexQuant__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::pureThTriggers__option_t,
    const options::pureThTriggers__option_t::type& x);
template <> const options::pureThTriggers__option_t::type& Options::operator[](
    options::pureThTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::pureThTriggers__option_t) const;
template <> void Options::assignBool(
    options::pureThTriggers__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::purifyDtTriggers__option_t,
    const options::purifyDtTriggers__option_t::type& x);
template <> const options::purifyDtTriggers__option_t::type& Options::operator[](
    options::purifyDtTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::purifyDtTriggers__option_t) const;
template <> void Options::assignBool(
    options::purifyDtTriggers__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::purifyTriggers__option_t,
    const options::purifyTriggers__option_t::type& x);
template <> const options::purifyTriggers__option_t::type& Options::operator[](
    options::purifyTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::purifyTriggers__option_t) const;
template <> void Options::assignBool(
    options::purifyTriggers__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::qcfAllConflict__option_t,
    const options::qcfAllConflict__option_t::type& x);
template <> const options::qcfAllConflict__option_t::type& Options::operator[](
    options::qcfAllConflict__option_t) const;
template <> bool Options::wasSetByUser(options::qcfAllConflict__option_t) const;
template <> void Options::assignBool(
    options::qcfAllConflict__option_t,
    std::string option,
    bool value);
template <> const options::qcfEagerCheckRd__option_t::type& Options::operator[](
    options::qcfEagerCheckRd__option_t) const;
template <> bool Options::wasSetByUser(options::qcfEagerCheckRd__option_t) const;
template <> void Options::assignBool(
    options::qcfEagerCheckRd__option_t,
    std::string option,
    bool value);
template <> const options::qcfEagerTest__option_t::type& Options::operator[](
    options::qcfEagerTest__option_t) const;
template <> bool Options::wasSetByUser(options::qcfEagerTest__option_t) const;
template <> void Options::assignBool(
    options::qcfEagerTest__option_t,
    std::string option,
    bool value);
template <> const options::qcfNestedConflict__option_t::type& Options::operator[](
    options::qcfNestedConflict__option_t) const;
template <> bool Options::wasSetByUser(options::qcfNestedConflict__option_t) const;
template <> void Options::assignBool(
    options::qcfNestedConflict__option_t,
    std::string option,
    bool value);
template <> const options::qcfSkipRd__option_t::type& Options::operator[](
    options::qcfSkipRd__option_t) const;
template <> bool Options::wasSetByUser(options::qcfSkipRd__option_t) const;
template <> void Options::assignBool(
    options::qcfSkipRd__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::qcfTConstraint__option_t,
    const options::qcfTConstraint__option_t::type& x);
template <> const options::qcfTConstraint__option_t::type& Options::operator[](
    options::qcfTConstraint__option_t) const;
template <> bool Options::wasSetByUser(options::qcfTConstraint__option_t) const;
template <> void Options::assignBool(
    options::qcfTConstraint__option_t,
    std::string option,
    bool value);
template <> const options::qcfVoExp__option_t::type& Options::operator[](
    options::qcfVoExp__option_t) const;
template <> bool Options::wasSetByUser(options::qcfVoExp__option_t) const;
template <> void Options::assignBool(
    options::qcfVoExp__option_t,
    std::string option,
    bool value);
template <> const options::quantAlphaEquiv__option_t::type& Options::operator[](
    options::quantAlphaEquiv__option_t) const;
template <> bool Options::wasSetByUser(options::quantAlphaEquiv__option_t) const;
template <> void Options::assignBool(
    options::quantAlphaEquiv__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::quantAntiSkolem__option_t,
    const options::quantAntiSkolem__option_t::type& x);
template <> const options::quantAntiSkolem__option_t::type& Options::operator[](
    options::quantAntiSkolem__option_t) const;
template <> bool Options::wasSetByUser(options::quantAntiSkolem__option_t) const;
template <> void Options::assignBool(
    options::quantAntiSkolem__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::quantConflictFind__option_t,
    const options::quantConflictFind__option_t::type& x);
template <> const options::quantConflictFind__option_t::type& Options::operator[](
    options::quantConflictFind__option_t) const;
template <> bool Options::wasSetByUser(options::quantConflictFind__option_t) const;
template <> void Options::assignBool(
    options::quantConflictFind__option_t,
    std::string option,
    bool value);
template <> const options::qcfMode__option_t::type& Options::operator[](
    options::qcfMode__option_t) const;
template <> bool Options::wasSetByUser(options::qcfMode__option_t) const;
template <> void Options::assign(
    options::qcfMode__option_t,
    std::string option,
    std::string value);
template <> const options::qcfWhenMode__option_t::type& Options::operator[](
    options::qcfWhenMode__option_t) const;
template <> bool Options::wasSetByUser(options::qcfWhenMode__option_t) const;
template <> void Options::assign(
    options::qcfWhenMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::quantDynamicSplit__option_t,
    const options::quantDynamicSplit__option_t::type& x);
template <> const options::quantDynamicSplit__option_t::type& Options::operator[](
    options::quantDynamicSplit__option_t) const;
template <> bool Options::wasSetByUser(options::quantDynamicSplit__option_t) const;
template <> void Options::assign(
    options::quantDynamicSplit__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::quantEpr__option_t,
    const options::quantEpr__option_t::type& x);
template <> const options::quantEpr__option_t::type& Options::operator[](
    options::quantEpr__option_t) const;
template <> bool Options::wasSetByUser(options::quantEpr__option_t) const;
template <> void Options::assignBool(
    options::quantEpr__option_t,
    std::string option,
    bool value);
template <> const options::quantEprMatching__option_t::type& Options::operator[](
    options::quantEprMatching__option_t) const;
template <> bool Options::wasSetByUser(options::quantEprMatching__option_t) const;
template <> void Options::assignBool(
    options::quantEprMatching__option_t,
    std::string option,
    bool value);
template <> const options::quantFunWellDefined__option_t::type& Options::operator[](
    options::quantFunWellDefined__option_t) const;
template <> bool Options::wasSetByUser(options::quantFunWellDefined__option_t) const;
template <> void Options::assignBool(
    options::quantFunWellDefined__option_t,
    std::string option,
    bool value);
template <> const options::quantInduction__option_t::type& Options::operator[](
    options::quantInduction__option_t) const;
template <> bool Options::wasSetByUser(options::quantInduction__option_t) const;
template <> void Options::assignBool(
    options::quantInduction__option_t,
    std::string option,
    bool value);
template <> const options::quantModelEe__option_t::type& Options::operator[](
    options::quantModelEe__option_t) const;
template <> bool Options::wasSetByUser(options::quantModelEe__option_t) const;
template <> void Options::assignBool(
    options::quantModelEe__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::quantRepMode__option_t,
    const options::quantRepMode__option_t::type& x);
template <> const options::quantRepMode__option_t::type& Options::operator[](
    options::quantRepMode__option_t) const;
template <> bool Options::wasSetByUser(options::quantRepMode__option_t) const;
template <> void Options::assign(
    options::quantRepMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::quantSplit__option_t,
    const options::quantSplit__option_t::type& x);
template <> const options::quantSplit__option_t::type& Options::operator[](
    options::quantSplit__option_t) const;
template <> bool Options::wasSetByUser(options::quantSplit__option_t) const;
template <> void Options::assignBool(
    options::quantSplit__option_t,
    std::string option,
    bool value);
template <> const options::registerQuantBodyTerms__option_t::type& Options::operator[](
    options::registerQuantBodyTerms__option_t) const;
template <> bool Options::wasSetByUser(options::registerQuantBodyTerms__option_t) const;
template <> void Options::assignBool(
    options::registerQuantBodyTerms__option_t,
    std::string option,
    bool value);
template <> const options::relationalTriggers__option_t::type& Options::operator[](
    options::relationalTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::relationalTriggers__option_t) const;
template <> void Options::assignBool(
    options::relationalTriggers__option_t,
    std::string option,
    bool value);
template <> const options::relevantTriggers__option_t::type& Options::operator[](
    options::relevantTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::relevantTriggers__option_t) const;
template <> void Options::assignBool(
    options::relevantTriggers__option_t,
    std::string option,
    bool value);
template <> const options::strictTriggers__option_t::type& Options::operator[](
    options::strictTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::strictTriggers__option_t) const;
template <> void Options::assignBool(
    options::strictTriggers__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygus__option_t,
    const options::sygus__option_t::type& x);
template <> const options::sygus__option_t::type& Options::operator[](
    options::sygus__option_t) const;
template <> bool Options::wasSetByUser(options::sygus__option_t) const;
template <> void Options::assignBool(
    options::sygus__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusActiveGenEnumConsts__option_t,
    const options::sygusActiveGenEnumConsts__option_t::type& x);
template <> const options::sygusActiveGenEnumConsts__option_t::type& Options::operator[](
    options::sygusActiveGenEnumConsts__option_t) const;
template <> bool Options::wasSetByUser(options::sygusActiveGenEnumConsts__option_t) const;
template <> void Options::assign(
    options::sygusActiveGenEnumConsts__option_t,
    std::string option,
    std::string value);
template <> const options::sygusActiveGenMode__option_t::type& Options::operator[](
    options::sygusActiveGenMode__option_t) const;
template <> bool Options::wasSetByUser(options::sygusActiveGenMode__option_t) const;
template <> void Options::assign(
    options::sygusActiveGenMode__option_t,
    std::string option,
    std::string value);
template <> const options::sygusAddConstGrammar__option_t::type& Options::operator[](
    options::sygusAddConstGrammar__option_t) const;
template <> bool Options::wasSetByUser(options::sygusAddConstGrammar__option_t) const;
template <> void Options::assignBool(
    options::sygusAddConstGrammar__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusArgRelevant__option_t,
    const options::sygusArgRelevant__option_t::type& x);
template <> const options::sygusArgRelevant__option_t::type& Options::operator[](
    options::sygusArgRelevant__option_t) const;
template <> bool Options::wasSetByUser(options::sygusArgRelevant__option_t) const;
template <> void Options::assignBool(
    options::sygusArgRelevant__option_t,
    std::string option,
    bool value);
template <> const options::sygusInvAutoUnfold__option_t::type& Options::operator[](
    options::sygusInvAutoUnfold__option_t) const;
template <> bool Options::wasSetByUser(options::sygusInvAutoUnfold__option_t) const;
template <> void Options::assignBool(
    options::sygusInvAutoUnfold__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusBoolIteReturnConst__option_t,
    const options::sygusBoolIteReturnConst__option_t::type& x);
template <> const options::sygusBoolIteReturnConst__option_t::type& Options::operator[](
    options::sygusBoolIteReturnConst__option_t) const;
template <> bool Options::wasSetByUser(options::sygusBoolIteReturnConst__option_t) const;
template <> void Options::assignBool(
    options::sygusBoolIteReturnConst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusCoreConnective__option_t,
    const options::sygusCoreConnective__option_t::type& x);
template <> const options::sygusCoreConnective__option_t::type& Options::operator[](
    options::sygusCoreConnective__option_t) const;
template <> bool Options::wasSetByUser(options::sygusCoreConnective__option_t) const;
template <> void Options::assignBool(
    options::sygusCoreConnective__option_t,
    std::string option,
    bool value);
template <> const options::sygusConstRepairAbort__option_t::type& Options::operator[](
    options::sygusConstRepairAbort__option_t) const;
template <> bool Options::wasSetByUser(options::sygusConstRepairAbort__option_t) const;
template <> void Options::assignBool(
    options::sygusConstRepairAbort__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusEvalOpt__option_t,
    const options::sygusEvalOpt__option_t::type& x);
template <> const options::sygusEvalOpt__option_t::type& Options::operator[](
    options::sygusEvalOpt__option_t) const;
template <> bool Options::wasSetByUser(options::sygusEvalOpt__option_t) const;
template <> void Options::assignBool(
    options::sygusEvalOpt__option_t,
    std::string option,
    bool value);
template <> const options::sygusEvalUnfold__option_t::type& Options::operator[](
    options::sygusEvalUnfold__option_t) const;
template <> bool Options::wasSetByUser(options::sygusEvalUnfold__option_t) const;
template <> void Options::assignBool(
    options::sygusEvalUnfold__option_t,
    std::string option,
    bool value);
template <> const options::sygusEvalUnfoldBool__option_t::type& Options::operator[](
    options::sygusEvalUnfoldBool__option_t) const;
template <> bool Options::wasSetByUser(options::sygusEvalUnfoldBool__option_t) const;
template <> void Options::assignBool(
    options::sygusEvalUnfoldBool__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusExprMinerCheckTimeout__option_t,
    const options::sygusExprMinerCheckTimeout__option_t::type& x);
template <> const options::sygusExprMinerCheckTimeout__option_t::type& Options::operator[](
    options::sygusExprMinerCheckTimeout__option_t) const;
template <> bool Options::wasSetByUser(options::sygusExprMinerCheckTimeout__option_t) const;
template <> void Options::assign(
    options::sygusExprMinerCheckTimeout__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::sygusExprMinerCheckUseExport__option_t,
    const options::sygusExprMinerCheckUseExport__option_t::type& x);
template <> const options::sygusExprMinerCheckUseExport__option_t::type& Options::operator[](
    options::sygusExprMinerCheckUseExport__option_t) const;
template <> bool Options::wasSetByUser(options::sygusExprMinerCheckUseExport__option_t) const;
template <> void Options::assignBool(
    options::sygusExprMinerCheckUseExport__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusExtRew__option_t,
    const options::sygusExtRew__option_t::type& x);
template <> const options::sygusExtRew__option_t::type& Options::operator[](
    options::sygusExtRew__option_t) const;
template <> bool Options::wasSetByUser(options::sygusExtRew__option_t) const;
template <> void Options::assignBool(
    options::sygusExtRew__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusFilterSolRevSubsume__option_t,
    const options::sygusFilterSolRevSubsume__option_t::type& x);
template <> const options::sygusFilterSolRevSubsume__option_t::type& Options::operator[](
    options::sygusFilterSolRevSubsume__option_t) const;
template <> bool Options::wasSetByUser(options::sygusFilterSolRevSubsume__option_t) const;
template <> void Options::assignBool(
    options::sygusFilterSolRevSubsume__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusFilterSolMode__option_t,
    const options::sygusFilterSolMode__option_t::type& x);
template <> const options::sygusFilterSolMode__option_t::type& Options::operator[](
    options::sygusFilterSolMode__option_t) const;
template <> bool Options::wasSetByUser(options::sygusFilterSolMode__option_t) const;
template <> void Options::assign(
    options::sygusFilterSolMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::sygusGrammarConsMode__option_t,
    const options::sygusGrammarConsMode__option_t::type& x);
template <> const options::sygusGrammarConsMode__option_t::type& Options::operator[](
    options::sygusGrammarConsMode__option_t) const;
template <> bool Options::wasSetByUser(options::sygusGrammarConsMode__option_t) const;
template <> void Options::assign(
    options::sygusGrammarConsMode__option_t,
    std::string option,
    std::string value);
template <> const options::sygusGrammarNorm__option_t::type& Options::operator[](
    options::sygusGrammarNorm__option_t) const;
template <> bool Options::wasSetByUser(options::sygusGrammarNorm__option_t) const;
template <> void Options::assignBool(
    options::sygusGrammarNorm__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusInference__option_t,
    const options::sygusInference__option_t::type& x);
template <> const options::sygusInference__option_t::type& Options::operator[](
    options::sygusInference__option_t) const;
template <> bool Options::wasSetByUser(options::sygusInference__option_t) const;
template <> void Options::assignBool(
    options::sygusInference__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusInst__option_t,
    const options::sygusInst__option_t::type& x);
template <> const options::sygusInst__option_t::type& Options::operator[](
    options::sygusInst__option_t) const;
template <> bool Options::wasSetByUser(options::sygusInst__option_t) const;
template <> void Options::assignBool(
    options::sygusInst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusInvTemplWhenSyntax__option_t,
    const options::sygusInvTemplWhenSyntax__option_t::type& x);
template <> const options::sygusInvTemplWhenSyntax__option_t::type& Options::operator[](
    options::sygusInvTemplWhenSyntax__option_t) const;
template <> bool Options::wasSetByUser(options::sygusInvTemplWhenSyntax__option_t) const;
template <> void Options::assignBool(
    options::sygusInvTemplWhenSyntax__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusInvTemplMode__option_t,
    const options::sygusInvTemplMode__option_t::type& x);
template <> const options::sygusInvTemplMode__option_t::type& Options::operator[](
    options::sygusInvTemplMode__option_t) const;
template <> bool Options::wasSetByUser(options::sygusInvTemplMode__option_t) const;
template <> void Options::assign(
    options::sygusInvTemplMode__option_t,
    std::string option,
    std::string value);
template <> const options::sygusMinGrammar__option_t::type& Options::operator[](
    options::sygusMinGrammar__option_t) const;
template <> bool Options::wasSetByUser(options::sygusMinGrammar__option_t) const;
template <> void Options::assignBool(
    options::sygusMinGrammar__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusUnifPbe__option_t,
    const options::sygusUnifPbe__option_t::type& x);
template <> const options::sygusUnifPbe__option_t::type& Options::operator[](
    options::sygusUnifPbe__option_t) const;
template <> bool Options::wasSetByUser(options::sygusUnifPbe__option_t) const;
template <> void Options::assignBool(
    options::sygusUnifPbe__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusPbeMultiFair__option_t,
    const options::sygusPbeMultiFair__option_t::type& x);
template <> const options::sygusPbeMultiFair__option_t::type& Options::operator[](
    options::sygusPbeMultiFair__option_t) const;
template <> bool Options::wasSetByUser(options::sygusPbeMultiFair__option_t) const;
template <> void Options::assignBool(
    options::sygusPbeMultiFair__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusPbeMultiFairDiff__option_t,
    const options::sygusPbeMultiFairDiff__option_t::type& x);
template <> const options::sygusPbeMultiFairDiff__option_t::type& Options::operator[](
    options::sygusPbeMultiFairDiff__option_t) const;
template <> bool Options::wasSetByUser(options::sygusPbeMultiFairDiff__option_t) const;
template <> void Options::assign(
    options::sygusPbeMultiFairDiff__option_t,
    std::string option,
    std::string value);
template <> const options::sygusQePreproc__option_t::type& Options::operator[](
    options::sygusQePreproc__option_t) const;
template <> bool Options::wasSetByUser(options::sygusQePreproc__option_t) const;
template <> void Options::assignBool(
    options::sygusQePreproc__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusQueryGen__option_t,
    const options::sygusQueryGen__option_t::type& x);
template <> const options::sygusQueryGen__option_t::type& Options::operator[](
    options::sygusQueryGen__option_t) const;
template <> bool Options::wasSetByUser(options::sygusQueryGen__option_t) const;
template <> void Options::assignBool(
    options::sygusQueryGen__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusQueryGenCheck__option_t,
    const options::sygusQueryGenCheck__option_t::type& x);
template <> const options::sygusQueryGenCheck__option_t::type& Options::operator[](
    options::sygusQueryGenCheck__option_t) const;
template <> bool Options::wasSetByUser(options::sygusQueryGenCheck__option_t) const;
template <> void Options::assignBool(
    options::sygusQueryGenCheck__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusQueryGenDumpFiles__option_t,
    const options::sygusQueryGenDumpFiles__option_t::type& x);
template <> const options::sygusQueryGenDumpFiles__option_t::type& Options::operator[](
    options::sygusQueryGenDumpFiles__option_t) const;
template <> bool Options::wasSetByUser(options::sygusQueryGenDumpFiles__option_t) const;
template <> void Options::assign(
    options::sygusQueryGenDumpFiles__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::sygusQueryGenThresh__option_t,
    const options::sygusQueryGenThresh__option_t::type& x);
template <> const options::sygusQueryGenThresh__option_t::type& Options::operator[](
    options::sygusQueryGenThresh__option_t) const;
template <> bool Options::wasSetByUser(options::sygusQueryGenThresh__option_t) const;
template <> void Options::assign(
    options::sygusQueryGenThresh__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::sygusRecFun__option_t,
    const options::sygusRecFun__option_t::type& x);
template <> const options::sygusRecFun__option_t::type& Options::operator[](
    options::sygusRecFun__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRecFun__option_t) const;
template <> void Options::assignBool(
    options::sygusRecFun__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRecFunEvalLimit__option_t,
    const options::sygusRecFunEvalLimit__option_t::type& x);
template <> const options::sygusRecFunEvalLimit__option_t::type& Options::operator[](
    options::sygusRecFunEvalLimit__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRecFunEvalLimit__option_t) const;
template <> void Options::assign(
    options::sygusRecFunEvalLimit__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::sygusRepairConst__option_t,
    const options::sygusRepairConst__option_t::type& x);
template <> const options::sygusRepairConst__option_t::type& Options::operator[](
    options::sygusRepairConst__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRepairConst__option_t) const;
template <> void Options::assignBool(
    options::sygusRepairConst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRepairConstTimeout__option_t,
    const options::sygusRepairConstTimeout__option_t::type& x);
template <> const options::sygusRepairConstTimeout__option_t::type& Options::operator[](
    options::sygusRepairConstTimeout__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRepairConstTimeout__option_t) const;
template <> void Options::assign(
    options::sygusRepairConstTimeout__option_t,
    std::string option,
    std::string value);
template <> const options::sygusRew__option_t::type& Options::operator[](
    options::sygusRew__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRew__option_t) const;
template <> void Options::assignBool(
    options::sygusRew__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynth__option_t,
    const options::sygusRewSynth__option_t::type& x);
template <> const options::sygusRewSynth__option_t::type& Options::operator[](
    options::sygusRewSynth__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynth__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynth__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthAccel__option_t,
    const options::sygusRewSynthAccel__option_t::type& x);
template <> const options::sygusRewSynthAccel__option_t::type& Options::operator[](
    options::sygusRewSynthAccel__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthAccel__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthAccel__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthCheck__option_t,
    const options::sygusRewSynthCheck__option_t::type& x);
template <> const options::sygusRewSynthCheck__option_t::type& Options::operator[](
    options::sygusRewSynthCheck__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthCheck__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthCheck__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthFilterCong__option_t,
    const options::sygusRewSynthFilterCong__option_t::type& x);
template <> const options::sygusRewSynthFilterCong__option_t::type& Options::operator[](
    options::sygusRewSynthFilterCong__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterCong__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthFilterCong__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthFilterMatch__option_t,
    const options::sygusRewSynthFilterMatch__option_t::type& x);
template <> const options::sygusRewSynthFilterMatch__option_t::type& Options::operator[](
    options::sygusRewSynthFilterMatch__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterMatch__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthFilterMatch__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthFilterNonLinear__option_t,
    const options::sygusRewSynthFilterNonLinear__option_t::type& x);
template <> const options::sygusRewSynthFilterNonLinear__option_t::type& Options::operator[](
    options::sygusRewSynthFilterNonLinear__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterNonLinear__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthFilterNonLinear__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthFilterOrder__option_t,
    const options::sygusRewSynthFilterOrder__option_t::type& x);
template <> const options::sygusRewSynthFilterOrder__option_t::type& Options::operator[](
    options::sygusRewSynthFilterOrder__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterOrder__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthFilterOrder__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthInput__option_t,
    const options::sygusRewSynthInput__option_t::type& x);
template <> const options::sygusRewSynthInput__option_t::type& Options::operator[](
    options::sygusRewSynthInput__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthInput__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthInput__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthInputNVars__option_t,
    const options::sygusRewSynthInputNVars__option_t::type& x);
template <> const options::sygusRewSynthInputNVars__option_t::type& Options::operator[](
    options::sygusRewSynthInputNVars__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthInputNVars__option_t) const;
template <> void Options::assign(
    options::sygusRewSynthInputNVars__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::sygusRewSynthInputUseBool__option_t,
    const options::sygusRewSynthInputUseBool__option_t::type& x);
template <> const options::sygusRewSynthInputUseBool__option_t::type& Options::operator[](
    options::sygusRewSynthInputUseBool__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthInputUseBool__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthInputUseBool__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthRec__option_t,
    const options::sygusRewSynthRec__option_t::type& x);
template <> const options::sygusRewSynthRec__option_t::type& Options::operator[](
    options::sygusRewSynthRec__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthRec__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthRec__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewVerify__option_t,
    const options::sygusRewVerify__option_t::type& x);
template <> const options::sygusRewVerify__option_t::type& Options::operator[](
    options::sygusRewVerify__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewVerify__option_t) const;
template <> void Options::assignBool(
    options::sygusRewVerify__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewVerifyAbort__option_t,
    const options::sygusRewVerifyAbort__option_t::type& x);
template <> const options::sygusRewVerifyAbort__option_t::type& Options::operator[](
    options::sygusRewVerifyAbort__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewVerifyAbort__option_t) const;
template <> void Options::assignBool(
    options::sygusRewVerifyAbort__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusSampleFpUniform__option_t,
    const options::sygusSampleFpUniform__option_t::type& x);
template <> const options::sygusSampleFpUniform__option_t::type& Options::operator[](
    options::sygusSampleFpUniform__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSampleFpUniform__option_t) const;
template <> void Options::assignBool(
    options::sygusSampleFpUniform__option_t,
    std::string option,
    bool value);
template <> const options::sygusSampleGrammar__option_t::type& Options::operator[](
    options::sygusSampleGrammar__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSampleGrammar__option_t) const;
template <> void Options::assignBool(
    options::sygusSampleGrammar__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusSamples__option_t,
    const options::sygusSamples__option_t::type& x);
template <> const options::sygusSamples__option_t::type& Options::operator[](
    options::sygusSamples__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSamples__option_t) const;
template <> void Options::assign(
    options::sygusSamples__option_t,
    std::string option,
    std::string value);
template <> const options::cegqiSingleInvAbort__option_t::type& Options::operator[](
    options::cegqiSingleInvAbort__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSingleInvAbort__option_t) const;
template <> void Options::assignBool(
    options::cegqiSingleInvAbort__option_t,
    std::string option,
    bool value);
template <> const options::cegqiSingleInvPartial__option_t::type& Options::operator[](
    options::cegqiSingleInvPartial__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSingleInvPartial__option_t) const;
template <> void Options::assignBool(
    options::cegqiSingleInvPartial__option_t,
    std::string option,
    bool value);
template <> const options::cegqiSingleInvReconstructLimit__option_t::type& Options::operator[](
    options::cegqiSingleInvReconstructLimit__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSingleInvReconstructLimit__option_t) const;
template <> void Options::assign(
    options::cegqiSingleInvReconstructLimit__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::cegqiSingleInvReconstruct__option_t,
    const options::cegqiSingleInvReconstruct__option_t::type& x);
template <> const options::cegqiSingleInvReconstruct__option_t::type& Options::operator[](
    options::cegqiSingleInvReconstruct__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSingleInvReconstruct__option_t) const;
template <> void Options::assign(
    options::cegqiSingleInvReconstruct__option_t,
    std::string option,
    std::string value);
template <> const options::cegqiSingleInvReconstructConst__option_t::type& Options::operator[](
    options::cegqiSingleInvReconstructConst__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSingleInvReconstructConst__option_t) const;
template <> void Options::assignBool(
    options::cegqiSingleInvReconstructConst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiSingleInvMode__option_t,
    const options::cegqiSingleInvMode__option_t::type& x);
template <> const options::cegqiSingleInvMode__option_t::type& Options::operator[](
    options::cegqiSingleInvMode__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSingleInvMode__option_t) const;
template <> void Options::assign(
    options::cegqiSingleInvMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::sygusStream__option_t,
    const options::sygusStream__option_t::type& x);
template <> const options::sygusStream__option_t::type& Options::operator[](
    options::sygusStream__option_t) const;
template <> bool Options::wasSetByUser(options::sygusStream__option_t) const;
template <> void Options::assignBool(
    options::sygusStream__option_t,
    std::string option,
    bool value);
template <> const options::sygusTemplEmbedGrammar__option_t::type& Options::operator[](
    options::sygusTemplEmbedGrammar__option_t) const;
template <> bool Options::wasSetByUser(options::sygusTemplEmbedGrammar__option_t) const;
template <> void Options::assignBool(
    options::sygusTemplEmbedGrammar__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusUnifCondIndNoRepeatSol__option_t,
    const options::sygusUnifCondIndNoRepeatSol__option_t::type& x);
template <> const options::sygusUnifCondIndNoRepeatSol__option_t::type& Options::operator[](
    options::sygusUnifCondIndNoRepeatSol__option_t) const;
template <> bool Options::wasSetByUser(options::sygusUnifCondIndNoRepeatSol__option_t) const;
template <> void Options::assignBool(
    options::sygusUnifCondIndNoRepeatSol__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusUnifPi__option_t,
    const options::sygusUnifPi__option_t::type& x);
template <> const options::sygusUnifPi__option_t::type& Options::operator[](
    options::sygusUnifPi__option_t) const;
template <> bool Options::wasSetByUser(options::sygusUnifPi__option_t) const;
template <> void Options::assign(
    options::sygusUnifPi__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::sygusUnifShuffleCond__option_t,
    const options::sygusUnifShuffleCond__option_t::type& x);
template <> const options::sygusUnifShuffleCond__option_t::type& Options::operator[](
    options::sygusUnifShuffleCond__option_t) const;
template <> bool Options::wasSetByUser(options::sygusUnifShuffleCond__option_t) const;
template <> void Options::assignBool(
    options::sygusUnifShuffleCond__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusVerifySubcall__option_t,
    const options::sygusVerifySubcall__option_t::type& x);
template <> const options::sygusVerifySubcall__option_t::type& Options::operator[](
    options::sygusVerifySubcall__option_t) const;
template <> bool Options::wasSetByUser(options::sygusVerifySubcall__option_t) const;
template <> void Options::assignBool(
    options::sygusVerifySubcall__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::termDbMode__option_t,
    const options::termDbMode__option_t::type& x);
template <> const options::termDbMode__option_t::type& Options::operator[](
    options::termDbMode__option_t) const;
template <> bool Options::wasSetByUser(options::termDbMode__option_t) const;
template <> void Options::assign(
    options::termDbMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::trackInstLemmas__option_t,
    const options::trackInstLemmas__option_t::type& x);
template <> const options::trackInstLemmas__option_t::type& Options::operator[](
    options::trackInstLemmas__option_t) const;
template <> bool Options::wasSetByUser(options::trackInstLemmas__option_t) const;
template <> void Options::assignBool(
    options::trackInstLemmas__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::triggerActiveSelMode__option_t,
    const options::triggerActiveSelMode__option_t::type& x);
template <> const options::triggerActiveSelMode__option_t::type& Options::operator[](
    options::triggerActiveSelMode__option_t) const;
template <> bool Options::wasSetByUser(options::triggerActiveSelMode__option_t) const;
template <> void Options::assign(
    options::triggerActiveSelMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::triggerSelMode__option_t,
    const options::triggerSelMode__option_t::type& x);
template <> const options::triggerSelMode__option_t::type& Options::operator[](
    options::triggerSelMode__option_t) const;
template <> bool Options::wasSetByUser(options::triggerSelMode__option_t) const;
template <> void Options::assign(
    options::triggerSelMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::userPatternsQuant__option_t,
    const options::userPatternsQuant__option_t::type& x);
template <> const options::userPatternsQuant__option_t::type& Options::operator[](
    options::userPatternsQuant__option_t) const;
template <> bool Options::wasSetByUser(options::userPatternsQuant__option_t) const;
template <> void Options::assign(
    options::userPatternsQuant__option_t,
    std::string option,
    std::string value);
template <> const options::varElimQuant__option_t::type& Options::operator[](
    options::varElimQuant__option_t) const;
template <> bool Options::wasSetByUser(options::varElimQuant__option_t) const;
template <> void Options::assignBool(
    options::varElimQuant__option_t,
    std::string option,
    bool value);
template <> const options::varIneqElimQuant__option_t::type& Options::operator[](
    options::varIneqElimQuant__option_t) const;
template <> bool Options::wasSetByUser(options::varIneqElimQuant__option_t) const;
template <> void Options::assignBool(
    options::varIneqElimQuant__option_t,
    std::string option,
    bool value);


namespace options {

inline aggressiveMiniscopeQuant__option_t::type aggressiveMiniscopeQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool aggressiveMiniscopeQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegisSample__option_t::type cegisSample__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegisSample__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegisSample__option_t::set(const cegisSample__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqi__option_t::type cegqi__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqi__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqi__option_t::set(const cegqi__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiAll__option_t::type cegqiAll__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiAll__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiAll__option_t::set(const cegqiAll__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiBv__option_t::type cegqiBv__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiBv__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiBv__option_t::set(const cegqiBv__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiBvConcInv__option_t::type cegqiBvConcInv__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiBvConcInv__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiBvConcInv__option_t::set(const cegqiBvConcInv__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiBvIneqMode__option_t::type cegqiBvIneqMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiBvIneqMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiBvIneqMode__option_t::set(const cegqiBvIneqMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiBvInterleaveValue__option_t::type cegqiBvInterleaveValue__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiBvInterleaveValue__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiBvInterleaveValue__option_t::set(const cegqiBvInterleaveValue__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiBvLinearize__option_t::type cegqiBvLinearize__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiBvLinearize__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiBvLinearize__option_t::set(const cegqiBvLinearize__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiBvRmExtract__option_t::type cegqiBvRmExtract__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiBvRmExtract__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiBvRmExtract__option_t::set(const cegqiBvRmExtract__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiBvSolveNl__option_t::type cegqiBvSolveNl__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiBvSolveNl__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiBvSolveNl__option_t::set(const cegqiBvSolveNl__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiFullEffort__option_t::type cegqiFullEffort__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiFullEffort__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiFullEffort__option_t::set(const cegqiFullEffort__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiInnermost__option_t::type cegqiInnermost__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiInnermost__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiInnermost__option_t::set(const cegqiInnermost__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiMidpoint__option_t::type cegqiMidpoint__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiMidpoint__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiMidpoint__option_t::set(const cegqiMidpoint__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiMinBounds__option_t::type cegqiMinBounds__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiMinBounds__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiModel__option_t::type cegqiModel__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiModel__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiModel__option_t::set(const cegqiModel__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiMultiInst__option_t::type cegqiMultiInst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiMultiInst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiMultiInst__option_t::set(const cegqiMultiInst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiNestedQE__option_t::type cegqiNestedQE__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiNestedQE__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiNestedQE__option_t::set(const cegqiNestedQE__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiNopt__option_t::type cegqiNopt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiNopt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiPreRegInst__option_t::type cegqiPreRegInst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiPreRegInst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiPreRegInst__option_t::set(const cegqiPreRegInst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiRepeatLit__option_t::type cegqiRepeatLit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiRepeatLit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiRepeatLit__option_t::set(const cegqiRepeatLit__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiRoundUpLowerLia__option_t::type cegqiRoundUpLowerLia__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiRoundUpLowerLia__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiSat__option_t::type cegqiSat__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSat__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiSat__option_t::set(const cegqiSat__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiUseInfInt__option_t::type cegqiUseInfInt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiUseInfInt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiUseInfInt__option_t::set(const cegqiUseInfInt__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiUseInfReal__option_t::type cegqiUseInfReal__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiUseInfReal__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiUseInfReal__option_t::set(const cegqiUseInfReal__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline condVarSplitQuantAgg__option_t::type condVarSplitQuantAgg__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool condVarSplitQuantAgg__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline condVarSplitQuant__option_t::type condVarSplitQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool condVarSplitQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline conjectureFilterActiveTerms__option_t::type conjectureFilterActiveTerms__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureFilterActiveTerms__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void conjectureFilterActiveTerms__option_t::set(const conjectureFilterActiveTerms__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline conjectureFilterCanonical__option_t::type conjectureFilterCanonical__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureFilterCanonical__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void conjectureFilterCanonical__option_t::set(const conjectureFilterCanonical__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline conjectureFilterModel__option_t::type conjectureFilterModel__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureFilterModel__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void conjectureFilterModel__option_t::set(const conjectureFilterModel__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline conjectureGen__option_t::type conjectureGen__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureGen__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void conjectureGen__option_t::set(const conjectureGen__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline conjectureGenGtEnum__option_t::type conjectureGenGtEnum__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureGenGtEnum__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline conjectureGenMaxDepth__option_t::type conjectureGenMaxDepth__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureGenMaxDepth__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline conjectureGenPerRound__option_t::type conjectureGenPerRound__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureGenPerRound__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline conjectureUeeIntro__option_t::type conjectureUeeIntro__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureUeeIntro__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline conjectureNoFilter__option_t::type conjectureNoFilter__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureNoFilter__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtStcInduction__option_t::type dtStcInduction__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtStcInduction__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void dtStcInduction__option_t::set(const dtStcInduction__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline dtVarExpandQuant__option_t::type dtVarExpandQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtVarExpandQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline eMatching__option_t::type eMatching__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool eMatching__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void eMatching__option_t::set(const eMatching__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline elimExtArithQuant__option_t::type elimExtArithQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool elimExtArithQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void elimExtArithQuant__option_t::set(const elimExtArithQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline elimTautQuant__option_t::type elimTautQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool elimTautQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline extRewriteQuant__option_t::type extRewriteQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool extRewriteQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline finiteModelFind__option_t::type finiteModelFind__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool finiteModelFind__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void finiteModelFind__option_t::set(const finiteModelFind__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfBound__option_t::type fmfBound__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfBound__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfBound__option_t::set(const fmfBound__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfBoundInt__option_t::type fmfBoundInt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfBoundInt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfBoundInt__option_t::set(const fmfBoundInt__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfBoundLazy__option_t::type fmfBoundLazy__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfBoundLazy__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfBoundLazy__option_t::set(const fmfBoundLazy__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfFmcSimple__option_t::type fmfFmcSimple__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfFmcSimple__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fmfFreshDistConst__option_t::type fmfFreshDistConst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfFreshDistConst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fmfFunWellDefined__option_t::type fmfFunWellDefined__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfFunWellDefined__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfFunWellDefined__option_t::set(const fmfFunWellDefined__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfFunWellDefinedRelevant__option_t::type fmfFunWellDefinedRelevant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfFunWellDefinedRelevant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fmfInstEngine__option_t::type fmfInstEngine__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfInstEngine__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfInstEngine__option_t::set(const fmfInstEngine__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfTypeCompletionThresh__option_t::type fmfTypeCompletionThresh__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfTypeCompletionThresh__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fullSaturateInterleave__option_t::type fullSaturateInterleave__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fullSaturateInterleave__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fullSaturateStratify__option_t::type fullSaturateStratify__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fullSaturateStratify__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fullSaturateQuant__option_t::type fullSaturateQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fullSaturateQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fullSaturateQuant__option_t::set(const fullSaturateQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fullSaturateLimit__option_t::type fullSaturateLimit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fullSaturateLimit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fullSaturateQuantRd__option_t::type fullSaturateQuantRd__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fullSaturateQuantRd__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline globalNegate__option_t::type globalNegate__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool globalNegate__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void globalNegate__option_t::set(const globalNegate__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline hoElim__option_t::type hoElim__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool hoElim__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline hoElimStoreAx__option_t::type hoElimStoreAx__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool hoElimStoreAx__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void hoElimStoreAx__option_t::set(const hoElimStoreAx__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline hoMatching__option_t::type hoMatching__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool hoMatching__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline hoMatchingVarArgPriority__option_t::type hoMatchingVarArgPriority__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool hoMatchingVarArgPriority__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline hoMergeTermDb__option_t::type hoMergeTermDb__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool hoMergeTermDb__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline incrementTriggers__option_t::type incrementTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool incrementTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline instLevelInputOnly__option_t::type instLevelInputOnly__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instLevelInputOnly__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline instMaxLevel__option_t::type instMaxLevel__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instMaxLevel__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instMaxLevel__option_t::set(const instMaxLevel__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instNoEntail__option_t::type instNoEntail__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instNoEntail__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instNoEntail__option_t::set(const instNoEntail__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instNoModelTrue__option_t::type instNoModelTrue__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instNoModelTrue__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instNoModelTrue__option_t::set(const instNoModelTrue__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instWhenPhase__option_t::type instWhenPhase__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instWhenPhase__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instWhenPhase__option_t::set(const instWhenPhase__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instWhenStrictInterleave__option_t::type instWhenStrictInterleave__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instWhenStrictInterleave__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instWhenStrictInterleave__option_t::set(const instWhenStrictInterleave__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instWhenTcFirst__option_t::type instWhenTcFirst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instWhenTcFirst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instWhenTcFirst__option_t::set(const instWhenTcFirst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instWhenMode__option_t::type instWhenMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instWhenMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instWhenMode__option_t::set(const instWhenMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline intWfInduction__option_t::type intWfInduction__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool intWfInduction__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void intWfInduction__option_t::set(const intWfInduction__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline iteDtTesterSplitQuant__option_t::type iteDtTesterSplitQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool iteDtTesterSplitQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void iteDtTesterSplitQuant__option_t::set(const iteDtTesterSplitQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline iteLiftQuant__option_t::type iteLiftQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool iteLiftQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void iteLiftQuant__option_t::set(const iteLiftQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline literalMatchMode__option_t::type literalMatchMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool literalMatchMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline lteRestrictInstClosure__option_t::type lteRestrictInstClosure__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool lteRestrictInstClosure__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline macrosQuant__option_t::type macrosQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool macrosQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void macrosQuant__option_t::set(const macrosQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline macrosQuantMode__option_t::type macrosQuantMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool macrosQuantMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline mbqiInterleave__option_t::type mbqiInterleave__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool mbqiInterleave__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fmfOneInstPerRound__option_t::type fmfOneInstPerRound__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfOneInstPerRound__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfOneInstPerRound__option_t::set(const fmfOneInstPerRound__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline mbqiMode__option_t::type mbqiMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool mbqiMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void mbqiMode__option_t::set(const mbqiMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline miniscopeQuant__option_t::type miniscopeQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool miniscopeQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void miniscopeQuant__option_t::set(const miniscopeQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline miniscopeQuantFreeVar__option_t::type miniscopeQuantFreeVar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool miniscopeQuantFreeVar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void miniscopeQuantFreeVar__option_t::set(const miniscopeQuantFreeVar__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline multiTriggerCache__option_t::type multiTriggerCache__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool multiTriggerCache__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline multiTriggerLinear__option_t::type multiTriggerLinear__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool multiTriggerLinear__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline multiTriggerPriority__option_t::type multiTriggerPriority__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool multiTriggerPriority__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline multiTriggerWhenSingle__option_t::type multiTriggerWhenSingle__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool multiTriggerWhenSingle__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline partialTriggers__option_t::type partialTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool partialTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void partialTriggers__option_t::set(const partialTriggers__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline preSkolemQuant__option_t::type preSkolemQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool preSkolemQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void preSkolemQuant__option_t::set(const preSkolemQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline preSkolemQuantAgg__option_t::type preSkolemQuantAgg__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool preSkolemQuantAgg__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void preSkolemQuantAgg__option_t::set(const preSkolemQuantAgg__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline preSkolemQuantNested__option_t::type preSkolemQuantNested__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool preSkolemQuantNested__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void preSkolemQuantNested__option_t::set(const preSkolemQuantNested__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline prenexQuantUser__option_t::type prenexQuantUser__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool prenexQuantUser__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void prenexQuantUser__option_t::set(const prenexQuantUser__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline prenexQuant__option_t::type prenexQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool prenexQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void prenexQuant__option_t::set(const prenexQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline pureThTriggers__option_t::type pureThTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool pureThTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void pureThTriggers__option_t::set(const pureThTriggers__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline purifyDtTriggers__option_t::type purifyDtTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool purifyDtTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void purifyDtTriggers__option_t::set(const purifyDtTriggers__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline purifyTriggers__option_t::type purifyTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool purifyTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void purifyTriggers__option_t::set(const purifyTriggers__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline qcfAllConflict__option_t::type qcfAllConflict__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfAllConflict__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void qcfAllConflict__option_t::set(const qcfAllConflict__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline qcfEagerCheckRd__option_t::type qcfEagerCheckRd__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfEagerCheckRd__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline qcfEagerTest__option_t::type qcfEagerTest__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfEagerTest__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline qcfNestedConflict__option_t::type qcfNestedConflict__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfNestedConflict__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline qcfSkipRd__option_t::type qcfSkipRd__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfSkipRd__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline qcfTConstraint__option_t::type qcfTConstraint__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfTConstraint__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void qcfTConstraint__option_t::set(const qcfTConstraint__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline qcfVoExp__option_t::type qcfVoExp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfVoExp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantAlphaEquiv__option_t::type quantAlphaEquiv__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantAlphaEquiv__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantAntiSkolem__option_t::type quantAntiSkolem__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantAntiSkolem__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantAntiSkolem__option_t::set(const quantAntiSkolem__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline quantConflictFind__option_t::type quantConflictFind__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantConflictFind__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantConflictFind__option_t::set(const quantConflictFind__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline qcfMode__option_t::type qcfMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline qcfWhenMode__option_t::type qcfWhenMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfWhenMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantDynamicSplit__option_t::type quantDynamicSplit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantDynamicSplit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantDynamicSplit__option_t::set(const quantDynamicSplit__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline quantEpr__option_t::type quantEpr__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantEpr__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantEpr__option_t::set(const quantEpr__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline quantEprMatching__option_t::type quantEprMatching__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantEprMatching__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantFunWellDefined__option_t::type quantFunWellDefined__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantFunWellDefined__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantInduction__option_t::type quantInduction__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantInduction__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantModelEe__option_t::type quantModelEe__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantModelEe__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantRepMode__option_t::type quantRepMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantRepMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantRepMode__option_t::set(const quantRepMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline quantSplit__option_t::type quantSplit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantSplit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantSplit__option_t::set(const quantSplit__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline registerQuantBodyTerms__option_t::type registerQuantBodyTerms__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool registerQuantBodyTerms__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline relationalTriggers__option_t::type relationalTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool relationalTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline relevantTriggers__option_t::type relevantTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool relevantTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline strictTriggers__option_t::type strictTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool strictTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygus__option_t::type sygus__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygus__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygus__option_t::set(const sygus__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusActiveGenEnumConsts__option_t::type sygusActiveGenEnumConsts__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusActiveGenEnumConsts__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusActiveGenEnumConsts__option_t::set(const sygusActiveGenEnumConsts__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusActiveGenMode__option_t::type sygusActiveGenMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusActiveGenMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusAddConstGrammar__option_t::type sygusAddConstGrammar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusAddConstGrammar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusArgRelevant__option_t::type sygusArgRelevant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusArgRelevant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusArgRelevant__option_t::set(const sygusArgRelevant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusInvAutoUnfold__option_t::type sygusInvAutoUnfold__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusInvAutoUnfold__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusBoolIteReturnConst__option_t::type sygusBoolIteReturnConst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusBoolIteReturnConst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusBoolIteReturnConst__option_t::set(const sygusBoolIteReturnConst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusCoreConnective__option_t::type sygusCoreConnective__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusCoreConnective__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusCoreConnective__option_t::set(const sygusCoreConnective__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusConstRepairAbort__option_t::type sygusConstRepairAbort__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusConstRepairAbort__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusEvalOpt__option_t::type sygusEvalOpt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusEvalOpt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusEvalOpt__option_t::set(const sygusEvalOpt__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusEvalUnfold__option_t::type sygusEvalUnfold__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusEvalUnfold__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusEvalUnfoldBool__option_t::type sygusEvalUnfoldBool__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusEvalUnfoldBool__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusExprMinerCheckTimeout__option_t::type sygusExprMinerCheckTimeout__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusExprMinerCheckTimeout__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusExprMinerCheckTimeout__option_t::set(const sygusExprMinerCheckTimeout__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusExprMinerCheckUseExport__option_t::type sygusExprMinerCheckUseExport__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusExprMinerCheckUseExport__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusExprMinerCheckUseExport__option_t::set(const sygusExprMinerCheckUseExport__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusExtRew__option_t::type sygusExtRew__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusExtRew__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusExtRew__option_t::set(const sygusExtRew__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusFilterSolRevSubsume__option_t::type sygusFilterSolRevSubsume__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusFilterSolRevSubsume__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusFilterSolRevSubsume__option_t::set(const sygusFilterSolRevSubsume__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusFilterSolMode__option_t::type sygusFilterSolMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusFilterSolMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusFilterSolMode__option_t::set(const sygusFilterSolMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusGrammarConsMode__option_t::type sygusGrammarConsMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusGrammarConsMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusGrammarConsMode__option_t::set(const sygusGrammarConsMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusGrammarNorm__option_t::type sygusGrammarNorm__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusGrammarNorm__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusInference__option_t::type sygusInference__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusInference__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusInference__option_t::set(const sygusInference__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusInst__option_t::type sygusInst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusInst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusInst__option_t::set(const sygusInst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusInvTemplWhenSyntax__option_t::type sygusInvTemplWhenSyntax__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusInvTemplWhenSyntax__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusInvTemplWhenSyntax__option_t::set(const sygusInvTemplWhenSyntax__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusInvTemplMode__option_t::type sygusInvTemplMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusInvTemplMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusInvTemplMode__option_t::set(const sygusInvTemplMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusMinGrammar__option_t::type sygusMinGrammar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusMinGrammar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusUnifPbe__option_t::type sygusUnifPbe__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusUnifPbe__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusUnifPbe__option_t::set(const sygusUnifPbe__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusPbeMultiFair__option_t::type sygusPbeMultiFair__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusPbeMultiFair__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusPbeMultiFair__option_t::set(const sygusPbeMultiFair__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusPbeMultiFairDiff__option_t::type sygusPbeMultiFairDiff__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusPbeMultiFairDiff__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusPbeMultiFairDiff__option_t::set(const sygusPbeMultiFairDiff__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusQePreproc__option_t::type sygusQePreproc__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusQePreproc__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusQueryGen__option_t::type sygusQueryGen__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusQueryGen__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusQueryGen__option_t::set(const sygusQueryGen__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusQueryGenCheck__option_t::type sygusQueryGenCheck__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusQueryGenCheck__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusQueryGenCheck__option_t::set(const sygusQueryGenCheck__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusQueryGenDumpFiles__option_t::type sygusQueryGenDumpFiles__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusQueryGenDumpFiles__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusQueryGenDumpFiles__option_t::set(const sygusQueryGenDumpFiles__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusQueryGenThresh__option_t::type sygusQueryGenThresh__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusQueryGenThresh__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusQueryGenThresh__option_t::set(const sygusQueryGenThresh__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRecFun__option_t::type sygusRecFun__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRecFun__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRecFun__option_t::set(const sygusRecFun__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRecFunEvalLimit__option_t::type sygusRecFunEvalLimit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRecFunEvalLimit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRecFunEvalLimit__option_t::set(const sygusRecFunEvalLimit__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRepairConst__option_t::type sygusRepairConst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRepairConst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRepairConst__option_t::set(const sygusRepairConst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRepairConstTimeout__option_t::type sygusRepairConstTimeout__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRepairConstTimeout__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRepairConstTimeout__option_t::set(const sygusRepairConstTimeout__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRew__option_t::type sygusRew__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRew__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusRewSynth__option_t::type sygusRewSynth__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynth__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynth__option_t::set(const sygusRewSynth__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthAccel__option_t::type sygusRewSynthAccel__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthAccel__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthAccel__option_t::set(const sygusRewSynthAccel__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthCheck__option_t::type sygusRewSynthCheck__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthCheck__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthCheck__option_t::set(const sygusRewSynthCheck__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthFilterCong__option_t::type sygusRewSynthFilterCong__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthFilterCong__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthFilterCong__option_t::set(const sygusRewSynthFilterCong__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthFilterMatch__option_t::type sygusRewSynthFilterMatch__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthFilterMatch__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthFilterMatch__option_t::set(const sygusRewSynthFilterMatch__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthFilterNonLinear__option_t::type sygusRewSynthFilterNonLinear__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthFilterNonLinear__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthFilterNonLinear__option_t::set(const sygusRewSynthFilterNonLinear__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthFilterOrder__option_t::type sygusRewSynthFilterOrder__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthFilterOrder__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthFilterOrder__option_t::set(const sygusRewSynthFilterOrder__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthInput__option_t::type sygusRewSynthInput__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthInput__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthInput__option_t::set(const sygusRewSynthInput__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthInputNVars__option_t::type sygusRewSynthInputNVars__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthInputNVars__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthInputNVars__option_t::set(const sygusRewSynthInputNVars__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthInputUseBool__option_t::type sygusRewSynthInputUseBool__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthInputUseBool__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthInputUseBool__option_t::set(const sygusRewSynthInputUseBool__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthRec__option_t::type sygusRewSynthRec__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthRec__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthRec__option_t::set(const sygusRewSynthRec__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewVerify__option_t::type sygusRewVerify__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewVerify__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewVerify__option_t::set(const sygusRewVerify__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewVerifyAbort__option_t::type sygusRewVerifyAbort__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewVerifyAbort__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewVerifyAbort__option_t::set(const sygusRewVerifyAbort__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusSampleFpUniform__option_t::type sygusSampleFpUniform__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSampleFpUniform__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusSampleFpUniform__option_t::set(const sygusSampleFpUniform__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusSampleGrammar__option_t::type sygusSampleGrammar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSampleGrammar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusSamples__option_t::type sygusSamples__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSamples__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusSamples__option_t::set(const sygusSamples__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiSingleInvAbort__option_t::type cegqiSingleInvAbort__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSingleInvAbort__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiSingleInvPartial__option_t::type cegqiSingleInvPartial__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSingleInvPartial__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiSingleInvReconstructLimit__option_t::type cegqiSingleInvReconstructLimit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSingleInvReconstructLimit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiSingleInvReconstruct__option_t::type cegqiSingleInvReconstruct__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSingleInvReconstruct__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiSingleInvReconstruct__option_t::set(const cegqiSingleInvReconstruct__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiSingleInvReconstructConst__option_t::type cegqiSingleInvReconstructConst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSingleInvReconstructConst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiSingleInvMode__option_t::type cegqiSingleInvMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSingleInvMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiSingleInvMode__option_t::set(const cegqiSingleInvMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusStream__option_t::type sygusStream__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusStream__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusStream__option_t::set(const sygusStream__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusTemplEmbedGrammar__option_t::type sygusTemplEmbedGrammar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusTemplEmbedGrammar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusUnifCondIndNoRepeatSol__option_t::type sygusUnifCondIndNoRepeatSol__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusUnifCondIndNoRepeatSol__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusUnifCondIndNoRepeatSol__option_t::set(const sygusUnifCondIndNoRepeatSol__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusUnifPi__option_t::type sygusUnifPi__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusUnifPi__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusUnifPi__option_t::set(const sygusUnifPi__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusUnifShuffleCond__option_t::type sygusUnifShuffleCond__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusUnifShuffleCond__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusUnifShuffleCond__option_t::set(const sygusUnifShuffleCond__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusVerifySubcall__option_t::type sygusVerifySubcall__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusVerifySubcall__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusVerifySubcall__option_t::set(const sygusVerifySubcall__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline termDbMode__option_t::type termDbMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool termDbMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void termDbMode__option_t::set(const termDbMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline trackInstLemmas__option_t::type trackInstLemmas__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool trackInstLemmas__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void trackInstLemmas__option_t::set(const trackInstLemmas__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline triggerActiveSelMode__option_t::type triggerActiveSelMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool triggerActiveSelMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void triggerActiveSelMode__option_t::set(const triggerActiveSelMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline triggerSelMode__option_t::type triggerSelMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool triggerSelMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void triggerSelMode__option_t::set(const triggerSelMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline userPatternsQuant__option_t::type userPatternsQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool userPatternsQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void userPatternsQuant__option_t::set(const userPatternsQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline varElimQuant__option_t::type varElimQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool varElimQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline varIneqElimQuant__option_t::type varIneqElimQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool varIneqElimQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__QUANTIFIERS_H */
