/** \file
 *  This C source file was generated by $ANTLR version 3.4
 *
 *     -  From the grammar source file : /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g
 *     -                            On : 2023-09-01 16:54:52
 *     -                for the parser : TptpParserParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

/**
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2016 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.
 **/

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "TptpParser.h"


#include <algorithm>
#include <iterator>
#include <vector>

#include "api/cvc4cpp.h"
#include "base/output.h"
#include "expr/expr.h"
#include "expr/kind.h"
#include "expr/type.h"
#include "parser/antlr_input.h"
#include "parser/parser.h"
#include "parser/tptp/tptp.h"
#include "util/integer.h"
#include "util/rational.h"

using namespace CVC4;
using namespace CVC4::parser;

/* These need to be macros so they can refer to the PARSER macro, which will be defined
 * by ANTLR *after* this section. (If they were functions, PARSER would be undefined.) */
#undef PARSER_STATE
#define PARSER_STATE ((Tptp*)PARSER->super)
#undef SOLVER
#define SOLVER PARSER_STATE->getSolver()
#undef MK_TERM
#define MK_TERM SOLVER->mkTerm
#define UNSUPPORTED PARSER_STATE->unimplementedFeature


/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pTptpParser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pTptpParser_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pTptpParser_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pTptpParser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef		MEMOIZE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef		INDEX
#undef      ADAPTOR
#undef		SEEK
#undef	    RULEMEMO
#undef		DBG

#define	    PARSER				ctx->pParser
#define	    RECOGNIZER				PARSER->rec
#define	    PSRSTATE				RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)			RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    MEMOIZE(ri,si)			RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define	    INPUT				PARSER->tstream
#define	    STRSTREAM				INPUT
#define	    ISTREAM				INPUT->istream
#define	    INDEX()				ISTREAM->index(INPUT->istream)
#define	    HASEXCEPTION()			(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION				PSRSTATE->exception
#define	    MATCHT(t, fs)			RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()				RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK				PSRSTATE->following
#ifdef  SKIP_FOLLOW_SETS
#define	    FOLLOWPUSH(x)
#define	    FOLLOWPOP()
#else
#define	    FOLLOWPUSH(x)			FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()				FOLLOWSTACK->pop(FOLLOWSTACK)
#endif
#define	    PRECOVER()				RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()			RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)				INPUT->istream->_LA(ISTREAM, n)
#define	    LT(n)				INPUT->_LT(INPUT, n)
#define	    CONSTRUCTEX()			RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()				ISTREAM->consume(ISTREAM)
#define	    MARK()				ISTREAM->mark(ISTREAM)
#define	    REWIND(m)				ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()			ISTREAM->rewindLast(ISTREAM)
#define	    SEEK(n)				ISTREAM->seek(ISTREAM, n)
#define	    PERRORRECOVERY			PSRSTATE->errorRecovery
#define	    FAILEDFLAG				PSRSTATE->failed
#define	    HASFAILED()				(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING			PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		DBG								RECOGNIZER->debugger


#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   TptpParserTokenNames[92+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "ALPHA_NUMERIC",
        (pANTLR3_UINT8) "AND_TOK",
        (pANTLR3_UINT8) "APP_TOK",
        (pANTLR3_UINT8) "ARROW_TOK",
        (pANTLR3_UINT8) "CHOICE_TOK",
        (pANTLR3_UINT8) "CNF_TOK",
        (pANTLR3_UINT8) "COLON_TOK",
        (pANTLR3_UINT8) "COMMA_TOK",
        (pANTLR3_UINT8) "COMMENT",
        (pANTLR3_UINT8) "DECIMAL",
        (pANTLR3_UINT8) "DEFINED_SYMBOL",
        (pANTLR3_UINT8) "DEF_DESC_TOK",
        (pANTLR3_UINT8) "DISEQUAL_TOK",
        (pANTLR3_UINT8) "DISTINCT_OBJECT",
        (pANTLR3_UINT8) "DOT",
        (pANTLR3_UINT8) "DOT_TOK",
        (pANTLR3_UINT8) "DO_CHAR",
        (pANTLR3_UINT8) "EQUAL_TOK",
        (pANTLR3_UINT8) "EXISTS_TOK",
        (pANTLR3_UINT8) "EXPONENT",
        (pANTLR3_UINT8) "FALSE_TOK",
        (pANTLR3_UINT8) "FOF_TOK",
        (pANTLR3_UINT8) "FORALL_TOK",
        (pANTLR3_UINT8) "IFF_TOK",
        (pANTLR3_UINT8) "IMPLIES_TOK",
        (pANTLR3_UINT8) "INCLUDE_TOK",
        (pANTLR3_UINT8) "LAMBDA_TOK",
        (pANTLR3_UINT8) "LBRACK_TOK",
        (pANTLR3_UINT8) "LOWER_ALPHA",
        (pANTLR3_UINT8) "LOWER_WORD",
        (pANTLR3_UINT8) "LOWER_WORD_SINGLE_QUOTED",
        (pANTLR3_UINT8) "LPAREN_TOK",
        (pANTLR3_UINT8) "MINUS_TOK",
        (pANTLR3_UINT8) "NOT_TOK",
        (pANTLR3_UINT8) "NUMBER",
        (pANTLR3_UINT8) "NUMERIC",
        (pANTLR3_UINT8) "OR_TOK",
        (pANTLR3_UINT8) "PLUS_TOK",
        (pANTLR3_UINT8) "RBRACK_TOK",
        (pANTLR3_UINT8) "REVAND_TOK",
        (pANTLR3_UINT8) "REVIFF_TOK",
        (pANTLR3_UINT8) "REVIMPLIES_TOK",
        (pANTLR3_UINT8) "REVOR_TOK",
        (pANTLR3_UINT8) "RPAREN_TOK",
        (pANTLR3_UINT8) "SIGN",
        (pANTLR3_UINT8) "SINGLE_QUOTED",
        (pANTLR3_UINT8) "SLASH",
        (pANTLR3_UINT8) "SQ_CHAR",
        (pANTLR3_UINT8) "SUBTYPE_TOK",
        (pANTLR3_UINT8) "TFF_TOK",
        (pANTLR3_UINT8) "TH1_UN_A",
        (pANTLR3_UINT8) "TH1_UN_E",
        (pANTLR3_UINT8) "THF_TOK",
        (pANTLR3_UINT8) "TIMES_TOK",
        (pANTLR3_UINT8) "TRUE_TOK",
        (pANTLR3_UINT8) "TYPE_TOK",
        (pANTLR3_UINT8) "UPPER_ALPHA",
        (pANTLR3_UINT8) "UPPER_WORD",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "WITNESS_TOK",
        (pANTLR3_UINT8) "'$ceiling'",
        (pANTLR3_UINT8) "'$difference'",
        (pANTLR3_UINT8) "'$distinct'",
        (pANTLR3_UINT8) "'$floor'",
        (pANTLR3_UINT8) "'$greater'",
        (pANTLR3_UINT8) "'$greatereq'",
        (pANTLR3_UINT8) "'$is_int'",
        (pANTLR3_UINT8) "'$is_rat'",
        (pANTLR3_UINT8) "'$ite_f'",
        (pANTLR3_UINT8) "'$ite_t'",
        (pANTLR3_UINT8) "'$less'",
        (pANTLR3_UINT8) "'$lesseq'",
        (pANTLR3_UINT8) "'$let_ff'",
        (pANTLR3_UINT8) "'$let_ft'",
        (pANTLR3_UINT8) "'$let_tf'",
        (pANTLR3_UINT8) "'$let_tt'",
        (pANTLR3_UINT8) "'$product'",
        (pANTLR3_UINT8) "'$quotient'",
        (pANTLR3_UINT8) "'$quotient_e'",
        (pANTLR3_UINT8) "'$quotient_f'",
        (pANTLR3_UINT8) "'$quotient_t'",
        (pANTLR3_UINT8) "'$remainder_e'",
        (pANTLR3_UINT8) "'$remainder_f'",
        (pANTLR3_UINT8) "'$remainder_t'",
        (pANTLR3_UINT8) "'$round'",
        (pANTLR3_UINT8) "'$sum'",
        (pANTLR3_UINT8) "'$tType'",
        (pANTLR3_UINT8) "'$to_int'",
        (pANTLR3_UINT8) "'$to_rat'",
        (pANTLR3_UINT8) "'$to_real'",
        (pANTLR3_UINT8) "'$truncate'",
        (pANTLR3_UINT8) "'$uminus'"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 CVC4::parser::tptp::myExpr
	parseExpr    (pTptpParser ctx);
static 
 CVC4::Command*
	parseCommand    (pTptpParser ctx);
static 
 void
	formulaRole    (pTptpParser ctx, CVC4::parser::Tptp::FormulaRole& role);
static 
 void
	cnfFormula    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	cnfDisjunction    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	cnfLiteral    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	atomicFormula    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	thfAtomicFormula    (pTptpParser ctx, CVC4::ParseOp& p);
static 
 void
	definedProp    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	definedPred    (pTptpParser ctx, CVC4::ParseOp& p);
static 
 void
	thfDefinedPred    (pTptpParser ctx, CVC4::ParseOp& p);
static 
 void
	definedFun    (pTptpParser ctx, CVC4::ParseOp& p);
static 
 void
	equalOp    (pTptpParser ctx, bool& equal);
static 
 void
	term    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	letTerm    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	simpleTerm    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	thfSimpleTerm    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	functionTerm    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	conditionalTerm    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	plainTerm    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	arguments    (pTptpParser ctx, std::vector<CVC4::api::Term>& args);
static 
 void
	variable    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	fofFormula    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	fofLogicFormula    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	fofUnitaryFormula    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	bindvariable    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	fofBinaryNonAssoc    (pTptpParser ctx, CVC4::parser::tptp::NonAssoc& na);
static 
 void
	folQuantifier    (pTptpParser ctx, CVC4::api::Kind& kind);
static 
 void
	thfQuantifier    (pTptpParser ctx, CVC4::api::Kind& kind);
static 
 void
	thfAtomTyping    (pTptpParser ctx, CVC4::Command*& cmd);
static 
 void
	thfLogicFormula    (pTptpParser ctx, CVC4::ParseOp& p);
static 
 void
	thfTupleForm    (pTptpParser ctx, std::vector<CVC4::api::Term>& args);
static 
 void
	thfUnitaryFormula    (pTptpParser ctx, CVC4::ParseOp& p);
static 
 void
	tffFormula    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	tffTypedAtom    (pTptpParser ctx, CVC4::Command*& cmd);
static 
 void
	tffLogicFormula    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	tffUnitaryFormula    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	tffLetTermDefn    (pTptpParser ctx, CVC4::api::Term& lhs, CVC4::api::Term& rhs);
static 
 void
	tffLetTermBinding    (pTptpParser ctx, std::vector<CVC4::api::Term> & bvlist, CVC4::api::Term& lhs, CVC4::api::Term& rhs);
static 
 void
	tffLetFormulaDefn    (pTptpParser ctx, CVC4::api::Term& lhs, CVC4::api::Term& rhs);
static 
 void
	tffLetFormulaBinding    (pTptpParser ctx, std::vector<CVC4::api::Term> & bvlist, CVC4::api::Term& lhs, CVC4::api::Term& rhs);
static 
 void
	thfBindVariable    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	tffbindvariable    (pTptpParser ctx, CVC4::api::Term& expr);
static 
 void
	tffVariableList    (pTptpParser ctx, std::vector<CVC4::api::Term>& bvlist);
static 
 void
	parseThfType    (pTptpParser ctx, CVC4::api::Sort& type);
static 
 void
	thfType    (pTptpParser ctx, CVC4::api::Sort& type);
static 
 void
	parseType    (pTptpParser ctx, CVC4::api::Sort & type);
static 
 void
	simpleType    (pTptpParser ctx, CVC4::api::Sort& type);
static 
 void
	anything    (pTptpParser ctx);
static 
 void
	unquotedFileName    (pTptpParser ctx, std::string& name);
static 
 void
	nameN    (pTptpParser ctx, std::string& name);
static 
 void
	atomicWord    (pTptpParser ctx, std::string& name);
static void	TptpParserFree(pTptpParser ctx);
static void     TptpParserReset (pTptpParser ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "/build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new TptpParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pTptpParser
TptpParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return TptpParserNewSSD(instream, NULL);
}

/** \brief Create a new TptpParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pTptpParser
TptpParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pTptpParser ctx;	    /* Context structure we will build and return   */

    ctx	= (pTptpParser) ANTLR3_CALLOC(1, sizeof(TptpParser));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in TptpParser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser	    = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our TptpParser interface
     */
    ctx->parseExpr	= parseExpr;
    ctx->parseCommand	= parseCommand;
    ctx->formulaRole	= formulaRole;
    ctx->cnfFormula	= cnfFormula;
    ctx->cnfDisjunction	= cnfDisjunction;
    ctx->cnfLiteral	= cnfLiteral;
    ctx->atomicFormula	= atomicFormula;
    ctx->thfAtomicFormula	= thfAtomicFormula;
    ctx->definedProp	= definedProp;
    ctx->definedPred	= definedPred;
    ctx->thfDefinedPred	= thfDefinedPred;
    ctx->definedFun	= definedFun;
    ctx->equalOp	= equalOp;
    ctx->term	= term;
    ctx->letTerm	= letTerm;
    ctx->simpleTerm	= simpleTerm;
    ctx->thfSimpleTerm	= thfSimpleTerm;
    ctx->functionTerm	= functionTerm;
    ctx->conditionalTerm	= conditionalTerm;
    ctx->plainTerm	= plainTerm;
    ctx->arguments	= arguments;
    ctx->variable	= variable;
    ctx->fofFormula	= fofFormula;
    ctx->fofLogicFormula	= fofLogicFormula;
    ctx->fofUnitaryFormula	= fofUnitaryFormula;
    ctx->bindvariable	= bindvariable;
    ctx->fofBinaryNonAssoc	= fofBinaryNonAssoc;
    ctx->folQuantifier	= folQuantifier;
    ctx->thfQuantifier	= thfQuantifier;
    ctx->thfAtomTyping	= thfAtomTyping;
    ctx->thfLogicFormula	= thfLogicFormula;
    ctx->thfTupleForm	= thfTupleForm;
    ctx->thfUnitaryFormula	= thfUnitaryFormula;
    ctx->tffFormula	= tffFormula;
    ctx->tffTypedAtom	= tffTypedAtom;
    ctx->tffLogicFormula	= tffLogicFormula;
    ctx->tffUnitaryFormula	= tffUnitaryFormula;
    ctx->tffLetTermDefn	= tffLetTermDefn;
    ctx->tffLetTermBinding	= tffLetTermBinding;
    ctx->tffLetFormulaDefn	= tffLetFormulaDefn;
    ctx->tffLetFormulaBinding	= tffLetFormulaBinding;
    ctx->thfBindVariable	= thfBindVariable;
    ctx->tffbindvariable	= tffbindvariable;
    ctx->tffVariableList	= tffVariableList;
    ctx->parseThfType	= parseThfType;
    ctx->thfType	= thfType;
    ctx->parseType	= parseType;
    ctx->simpleType	= simpleType;
    ctx->anything	= anything;
    ctx->unquotedFileName	= unquotedFileName;
    ctx->nameN	= nameN;
    ctx->atomicWord	= atomicWord;
    ctx->free			= TptpParserFree;
    ctx->reset			= TptpParserReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = TptpParserTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
TptpParserReset (pTptpParser ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 TptpParserFree(pTptpParser ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pParser->free(ctx->pParser);


    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return TptpParserTokenNames;
}


/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cnfFormula_in_parseExpr114  */
static	ANTLR3_BITWORD FOLLOW_cnfFormula_in_parseExpr114_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_cnfFormula_in_parseExpr114	= { FOLLOW_cnfFormula_in_parseExpr114_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseExpr121  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseExpr121_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseExpr121	= { FOLLOW_EOF_in_parseExpr121_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CNF_TOK_in_parseCommand145  */
static	ANTLR3_BITWORD FOLLOW_CNF_TOK_in_parseCommand145_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CNF_TOK_in_parseCommand145	= { FOLLOW_CNF_TOK_in_parseCommand145_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand147  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand147_bits[]	= { ANTLR3_UINT64_LIT(0x0922004622000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand147	= { FOLLOW_LPAREN_TOK_in_parseCommand147_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nameN_in_parseCommand149  */
static	ANTLR3_BITWORD FOLLOW_nameN_in_parseCommand149_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_nameN_in_parseCommand149	= { FOLLOW_nameN_in_parseCommand149_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand152  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand152_bits[]	= { ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand152	= { FOLLOW_COMMA_TOK_in_parseCommand152_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formulaRole_in_parseCommand154  */
static	ANTLR3_BITWORD FOLLOW_formulaRole_in_parseCommand154_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_formulaRole_in_parseCommand154	= { FOLLOW_formulaRole_in_parseCommand154_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand157  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand157_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E33020220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand157	= { FOLLOW_COMMA_TOK_in_parseCommand157_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cnfFormula_in_parseCommand167  */
static	ANTLR3_BITWORD FOLLOW_cnfFormula_in_parseCommand167_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_cnfFormula_in_parseCommand167	= { FOLLOW_cnfFormula_in_parseCommand167_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand179  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand179_bits[]	= { ANTLR3_UINT64_LIT(0x2F22FB7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand179	= { FOLLOW_COMMA_TOK_in_parseCommand179_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_anything_in_parseCommand181  */
static	ANTLR3_BITWORD FOLLOW_anything_in_parseCommand181_bits[]	= { ANTLR3_UINT64_LIT(0x2F22FB7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_anything_in_parseCommand181	= { FOLLOW_anything_in_parseCommand181_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand186  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand186_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand186	= { FOLLOW_RPAREN_TOK_in_parseCommand186_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_TOK_in_parseCommand188  */
static	ANTLR3_BITWORD FOLLOW_DOT_TOK_in_parseCommand188_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_TOK_in_parseCommand188	= { FOLLOW_DOT_TOK_in_parseCommand188_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FOF_TOK_in_parseCommand200  */
static	ANTLR3_BITWORD FOLLOW_FOF_TOK_in_parseCommand200_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FOF_TOK_in_parseCommand200	= { FOLLOW_FOF_TOK_in_parseCommand200_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand202  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand202_bits[]	= { ANTLR3_UINT64_LIT(0x0922004622000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand202	= { FOLLOW_LPAREN_TOK_in_parseCommand202_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nameN_in_parseCommand204  */
static	ANTLR3_BITWORD FOLLOW_nameN_in_parseCommand204_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_nameN_in_parseCommand204	= { FOLLOW_nameN_in_parseCommand204_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand207  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand207_bits[]	= { ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand207	= { FOLLOW_COMMA_TOK_in_parseCommand207_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formulaRole_in_parseCommand209  */
static	ANTLR3_BITWORD FOLLOW_formulaRole_in_parseCommand209_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_formulaRole_in_parseCommand209	= { FOLLOW_formulaRole_in_parseCommand209_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand212  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand212_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand212	= { FOLLOW_COMMA_TOK_in_parseCommand212_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofFormula_in_parseCommand224  */
static	ANTLR3_BITWORD FOLLOW_fofFormula_in_parseCommand224_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_fofFormula_in_parseCommand224	= { FOLLOW_fofFormula_in_parseCommand224_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand228  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand228_bits[]	= { ANTLR3_UINT64_LIT(0x2F22FB7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand228	= { FOLLOW_COMMA_TOK_in_parseCommand228_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_anything_in_parseCommand230  */
static	ANTLR3_BITWORD FOLLOW_anything_in_parseCommand230_bits[]	= { ANTLR3_UINT64_LIT(0x2F22FB7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_anything_in_parseCommand230	= { FOLLOW_anything_in_parseCommand230_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand235  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand235_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand235	= { FOLLOW_RPAREN_TOK_in_parseCommand235_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_TOK_in_parseCommand237  */
static	ANTLR3_BITWORD FOLLOW_DOT_TOK_in_parseCommand237_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_TOK_in_parseCommand237	= { FOLLOW_DOT_TOK_in_parseCommand237_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TFF_TOK_in_parseCommand249  */
static	ANTLR3_BITWORD FOLLOW_TFF_TOK_in_parseCommand249_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TFF_TOK_in_parseCommand249	= { FOLLOW_TFF_TOK_in_parseCommand249_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand251  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand251_bits[]	= { ANTLR3_UINT64_LIT(0x0922004622000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand251	= { FOLLOW_LPAREN_TOK_in_parseCommand251_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nameN_in_parseCommand253  */
static	ANTLR3_BITWORD FOLLOW_nameN_in_parseCommand253_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_nameN_in_parseCommand253	= { FOLLOW_nameN_in_parseCommand253_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand256  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand256_bits[]	= { ANTLR3_UINT64_LIT(0x0800000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand256	= { FOLLOW_COMMA_TOK_in_parseCommand256_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_parseCommand264  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_parseCommand264_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_parseCommand264	= { FOLLOW_TYPE_TOK_in_parseCommand264_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand266  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand266_bits[]	= { ANTLR3_UINT64_LIT(0x0922004E22000200) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand266	= { FOLLOW_COMMA_TOK_in_parseCommand266_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffTypedAtom_in_parseCommand268  */
static	ANTLR3_BITWORD FOLLOW_tffTypedAtom_in_parseCommand268_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_tffTypedAtom_in_parseCommand268	= { FOLLOW_tffTypedAtom_in_parseCommand268_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formulaRole_in_parseCommand277  */
static	ANTLR3_BITWORD FOLLOW_formulaRole_in_parseCommand277_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_formulaRole_in_parseCommand277	= { FOLLOW_formulaRole_in_parseCommand277_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand280  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand280_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand280	= { FOLLOW_COMMA_TOK_in_parseCommand280_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffFormula_in_parseCommand296  */
static	ANTLR3_BITWORD FOLLOW_tffFormula_in_parseCommand296_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_tffFormula_in_parseCommand296	= { FOLLOW_tffFormula_in_parseCommand296_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand300  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand300_bits[]	= { ANTLR3_UINT64_LIT(0x2F22FB7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand300	= { FOLLOW_COMMA_TOK_in_parseCommand300_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_anything_in_parseCommand302  */
static	ANTLR3_BITWORD FOLLOW_anything_in_parseCommand302_bits[]	= { ANTLR3_UINT64_LIT(0x2F22FB7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_anything_in_parseCommand302	= { FOLLOW_anything_in_parseCommand302_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand321  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand321_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand321	= { FOLLOW_RPAREN_TOK_in_parseCommand321_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_TOK_in_parseCommand323  */
static	ANTLR3_BITWORD FOLLOW_DOT_TOK_in_parseCommand323_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_TOK_in_parseCommand323	= { FOLLOW_DOT_TOK_in_parseCommand323_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_THF_TOK_in_parseCommand329  */
static	ANTLR3_BITWORD FOLLOW_THF_TOK_in_parseCommand329_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_THF_TOK_in_parseCommand329	= { FOLLOW_THF_TOK_in_parseCommand329_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand331  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand331_bits[]	= { ANTLR3_UINT64_LIT(0x0922004622000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand331	= { FOLLOW_LPAREN_TOK_in_parseCommand331_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nameN_in_parseCommand333  */
static	ANTLR3_BITWORD FOLLOW_nameN_in_parseCommand333_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_nameN_in_parseCommand333	= { FOLLOW_nameN_in_parseCommand333_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand336  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand336_bits[]	= { ANTLR3_UINT64_LIT(0x0800000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand336	= { FOLLOW_COMMA_TOK_in_parseCommand336_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_parseCommand354  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_parseCommand354_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_parseCommand354	= { FOLLOW_TYPE_TOK_in_parseCommand354_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand356  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand356_bits[]	= { ANTLR3_UINT64_LIT(0x0922004E22000200) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand356	= { FOLLOW_COMMA_TOK_in_parseCommand356_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfAtomTyping_in_parseCommand358  */
static	ANTLR3_BITWORD FOLLOW_thfAtomTyping_in_parseCommand358_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_thfAtomTyping_in_parseCommand358	= { FOLLOW_thfAtomTyping_in_parseCommand358_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formulaRole_in_parseCommand367  */
static	ANTLR3_BITWORD FOLLOW_formulaRole_in_parseCommand367_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_formulaRole_in_parseCommand367	= { FOLLOW_formulaRole_in_parseCommand367_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand370  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand370_bits[]	= { ANTLR3_UINT64_LIT(0x2DE2006E67428300), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand370	= { FOLLOW_COMMA_TOK_in_parseCommand370_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfLogicFormula_in_parseCommand386  */
static	ANTLR3_BITWORD FOLLOW_thfLogicFormula_in_parseCommand386_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_thfLogicFormula_in_parseCommand386	= { FOLLOW_thfLogicFormula_in_parseCommand386_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand390  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand390_bits[]	= { ANTLR3_UINT64_LIT(0x2F22FB7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand390	= { FOLLOW_COMMA_TOK_in_parseCommand390_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_anything_in_parseCommand392  */
static	ANTLR3_BITWORD FOLLOW_anything_in_parseCommand392_bits[]	= { ANTLR3_UINT64_LIT(0x2F22FB7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_anything_in_parseCommand392	= { FOLLOW_anything_in_parseCommand392_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand411  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand411_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand411	= { FOLLOW_RPAREN_TOK_in_parseCommand411_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_TOK_in_parseCommand413  */
static	ANTLR3_BITWORD FOLLOW_DOT_TOK_in_parseCommand413_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_TOK_in_parseCommand413	= { FOLLOW_DOT_TOK_in_parseCommand413_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDE_TOK_in_parseCommand419  */
static	ANTLR3_BITWORD FOLLOW_INCLUDE_TOK_in_parseCommand419_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDE_TOK_in_parseCommand419	= { FOLLOW_INCLUDE_TOK_in_parseCommand419_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand421  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand421_bits[]	= { ANTLR3_UINT64_LIT(0x0002000400000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand421	= { FOLLOW_LPAREN_TOK_in_parseCommand421_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_unquotedFileName_in_parseCommand423  */
static	ANTLR3_BITWORD FOLLOW_unquotedFileName_in_parseCommand423_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_unquotedFileName_in_parseCommand423	= { FOLLOW_unquotedFileName_in_parseCommand423_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand432  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand432_bits[]	= { ANTLR3_UINT64_LIT(0x0000000080000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand432	= { FOLLOW_COMMA_TOK_in_parseCommand432_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACK_TOK_in_parseCommand434  */
static	ANTLR3_BITWORD FOLLOW_LBRACK_TOK_in_parseCommand434_bits[]	= { ANTLR3_UINT64_LIT(0x0922004622000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACK_TOK_in_parseCommand434	= { FOLLOW_LBRACK_TOK_in_parseCommand434_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nameN_in_parseCommand436  */
static	ANTLR3_BITWORD FOLLOW_nameN_in_parseCommand436_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_nameN_in_parseCommand436	= { FOLLOW_nameN_in_parseCommand436_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_parseCommand447  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_parseCommand447_bits[]	= { ANTLR3_UINT64_LIT(0x0922004622000200) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_parseCommand447	= { FOLLOW_COMMA_TOK_in_parseCommand447_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nameN_in_parseCommand449  */
static	ANTLR3_BITWORD FOLLOW_nameN_in_parseCommand449_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_nameN_in_parseCommand449	= { FOLLOW_nameN_in_parseCommand449_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACK_TOK_in_parseCommand455  */
static	ANTLR3_BITWORD FOLLOW_RBRACK_TOK_in_parseCommand455_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACK_TOK_in_parseCommand455	= { FOLLOW_RBRACK_TOK_in_parseCommand455_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand464  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand464_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000080000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand464	= { FOLLOW_RPAREN_TOK_in_parseCommand464_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_TOK_in_parseCommand466  */
static	ANTLR3_BITWORD FOLLOW_DOT_TOK_in_parseCommand466_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_TOK_in_parseCommand466	= { FOLLOW_DOT_TOK_in_parseCommand466_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseCommand478  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseCommand478_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseCommand478	= { FOLLOW_EOF_in_parseCommand478_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LOWER_WORD_in_formulaRole500  */
static	ANTLR3_BITWORD FOLLOW_LOWER_WORD_in_formulaRole500_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LOWER_WORD_in_formulaRole500	= { FOLLOW_LOWER_WORD_in_formulaRole500_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_cnfFormula528  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_cnfFormula528_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016633020220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_cnfFormula528	= { FOLLOW_LPAREN_TOK_in_cnfFormula528_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cnfDisjunction_in_cnfFormula530  */
static	ANTLR3_BITWORD FOLLOW_cnfDisjunction_in_cnfFormula530_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_cnfDisjunction_in_cnfFormula530	= { FOLLOW_cnfDisjunction_in_cnfFormula530_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_cnfFormula533  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_cnfFormula533_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_cnfFormula533	= { FOLLOW_RPAREN_TOK_in_cnfFormula533_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cnfDisjunction_in_cnfFormula539  */
static	ANTLR3_BITWORD FOLLOW_cnfDisjunction_in_cnfFormula539_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_cnfDisjunction_in_cnfFormula539	= { FOLLOW_cnfDisjunction_in_cnfFormula539_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cnfLiteral_in_cnfDisjunction557  */
static	ANTLR3_BITWORD FOLLOW_cnfLiteral_in_cnfDisjunction557_bits[]	= { ANTLR3_UINT64_LIT(0x0000010000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_cnfLiteral_in_cnfDisjunction557	= { FOLLOW_cnfLiteral_in_cnfDisjunction557_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_TOK_in_cnfDisjunction568  */
static	ANTLR3_BITWORD FOLLOW_OR_TOK_in_cnfDisjunction568_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016633020220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_TOK_in_cnfDisjunction568	= { FOLLOW_OR_TOK_in_cnfDisjunction568_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_cnfLiteral_in_cnfDisjunction570  */
static	ANTLR3_BITWORD FOLLOW_cnfLiteral_in_cnfDisjunction570_bits[]	= { ANTLR3_UINT64_LIT(0x0000010000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_cnfLiteral_in_cnfDisjunction570	= { FOLLOW_cnfLiteral_in_cnfDisjunction570_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomicFormula_in_cnfLiteral594  */
static	ANTLR3_BITWORD FOLLOW_atomicFormula_in_cnfLiteral594_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomicFormula_in_cnfLiteral594	= { FOLLOW_atomicFormula_in_cnfLiteral594_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_cnfLiteral601  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_cnfLiteral601_bits[]	= { ANTLR3_UINT64_LIT(0x2D22014633020220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_cnfLiteral601	= { FOLLOW_NOT_TOK_in_cnfLiteral601_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomicFormula_in_cnfLiteral603  */
static	ANTLR3_BITWORD FOLLOW_atomicFormula_in_cnfLiteral603_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomicFormula_in_cnfLiteral603	= { FOLLOW_atomicFormula_in_cnfLiteral603_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomicWord_in_atomicFormula625  */
static	ANTLR3_BITWORD FOLLOW_atomicWord_in_atomicFormula625_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800210002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomicWord_in_atomicFormula625	= { FOLLOW_atomicWord_in_atomicFormula625_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_atomicFormula629  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_atomicFormula629_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_atomicFormula629	= { FOLLOW_LPAREN_TOK_in_atomicFormula629_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arguments_in_atomicFormula631  */
static	ANTLR3_BITWORD FOLLOW_arguments_in_atomicFormula631_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_arguments_in_atomicFormula631	= { FOLLOW_arguments_in_atomicFormula631_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_atomicFormula634  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_atomicFormula634_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000210002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_atomicFormula634	= { FOLLOW_RPAREN_TOK_in_atomicFormula634_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_equalOp_in_atomicFormula644  */
static	ANTLR3_BITWORD FOLLOW_equalOp_in_atomicFormula644_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_equalOp_in_atomicFormula644	= { FOLLOW_equalOp_in_atomicFormula644_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_atomicFormula647  */
static	ANTLR3_BITWORD FOLLOW_term_in_atomicFormula647_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_atomicFormula647	= { FOLLOW_term_in_atomicFormula647_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_definedFun_in_atomicFormula676  */
static	ANTLR3_BITWORD FOLLOW_definedFun_in_atomicFormula676_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_definedFun_in_atomicFormula676	= { FOLLOW_definedFun_in_atomicFormula676_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_atomicFormula690  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_atomicFormula690_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_atomicFormula690	= { FOLLOW_LPAREN_TOK_in_atomicFormula690_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arguments_in_atomicFormula692  */
static	ANTLR3_BITWORD FOLLOW_arguments_in_atomicFormula692_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_arguments_in_atomicFormula692	= { FOLLOW_arguments_in_atomicFormula692_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_atomicFormula695  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_atomicFormula695_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000210000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_atomicFormula695	= { FOLLOW_RPAREN_TOK_in_atomicFormula695_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_equalOp_in_atomicFormula702  */
static	ANTLR3_BITWORD FOLLOW_equalOp_in_atomicFormula702_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_equalOp_in_atomicFormula702	= { FOLLOW_equalOp_in_atomicFormula702_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_atomicFormula705  */
static	ANTLR3_BITWORD FOLLOW_term_in_atomicFormula705_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_atomicFormula705	= { FOLLOW_term_in_atomicFormula705_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleTerm_in_atomicFormula726  */
static	ANTLR3_BITWORD FOLLOW_simpleTerm_in_atomicFormula726_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000210002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleTerm_in_atomicFormula726	= { FOLLOW_simpleTerm_in_atomicFormula726_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letTerm_in_atomicFormula731  */
static	ANTLR3_BITWORD FOLLOW_letTerm_in_atomicFormula731_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000210002) };
static  ANTLR3_BITSET_LIST FOLLOW_letTerm_in_atomicFormula731	= { FOLLOW_letTerm_in_atomicFormula731_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_conditionalTerm_in_atomicFormula736  */
static	ANTLR3_BITWORD FOLLOW_conditionalTerm_in_atomicFormula736_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000210002) };
static  ANTLR3_BITSET_LIST FOLLOW_conditionalTerm_in_atomicFormula736	= { FOLLOW_conditionalTerm_in_atomicFormula736_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_equalOp_in_atomicFormula752  */
static	ANTLR3_BITWORD FOLLOW_equalOp_in_atomicFormula752_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_equalOp_in_atomicFormula752	= { FOLLOW_equalOp_in_atomicFormula752_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_atomicFormula755  */
static	ANTLR3_BITWORD FOLLOW_term_in_atomicFormula755_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_atomicFormula755	= { FOLLOW_term_in_atomicFormula755_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_definedPred_in_atomicFormula777  */
static	ANTLR3_BITWORD FOLLOW_definedPred_in_atomicFormula777_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_definedPred_in_atomicFormula777	= { FOLLOW_definedPred_in_atomicFormula777_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_atomicFormula781  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_atomicFormula781_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_atomicFormula781	= { FOLLOW_LPAREN_TOK_in_atomicFormula781_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arguments_in_atomicFormula783  */
static	ANTLR3_BITWORD FOLLOW_arguments_in_atomicFormula783_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_arguments_in_atomicFormula783	= { FOLLOW_arguments_in_atomicFormula783_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_atomicFormula786  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_atomicFormula786_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_atomicFormula786	= { FOLLOW_RPAREN_TOK_in_atomicFormula786_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_definedProp_in_atomicFormula799  */
static	ANTLR3_BITWORD FOLLOW_definedProp_in_atomicFormula799_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_definedProp_in_atomicFormula799	= { FOLLOW_definedProp_in_atomicFormula799_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomicWord_in_thfAtomicFormula819  */
static	ANTLR3_BITWORD FOLLOW_atomicWord_in_thfAtomicFormula819_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomicWord_in_thfAtomicFormula819	= { FOLLOW_atomicWord_in_thfAtomicFormula819_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_thfAtomicFormula823  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_thfAtomicFormula823_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_thfAtomicFormula823	= { FOLLOW_LPAREN_TOK_in_thfAtomicFormula823_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arguments_in_thfAtomicFormula825  */
static	ANTLR3_BITWORD FOLLOW_arguments_in_thfAtomicFormula825_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_arguments_in_thfAtomicFormula825	= { FOLLOW_arguments_in_thfAtomicFormula825_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_thfAtomicFormula828  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_thfAtomicFormula828_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_thfAtomicFormula828	= { FOLLOW_RPAREN_TOK_in_thfAtomicFormula828_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_definedFun_in_thfAtomicFormula842  */
static	ANTLR3_BITWORD FOLLOW_definedFun_in_thfAtomicFormula842_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000002) };
static  ANTLR3_BITSET_LIST FOLLOW_definedFun_in_thfAtomicFormula842	= { FOLLOW_definedFun_in_thfAtomicFormula842_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_thfAtomicFormula857  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_thfAtomicFormula857_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_thfAtomicFormula857	= { FOLLOW_LPAREN_TOK_in_thfAtomicFormula857_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arguments_in_thfAtomicFormula859  */
static	ANTLR3_BITWORD FOLLOW_arguments_in_thfAtomicFormula859_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_arguments_in_thfAtomicFormula859	= { FOLLOW_arguments_in_thfAtomicFormula859_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_thfAtomicFormula862  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_thfAtomicFormula862_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000210000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_thfAtomicFormula862	= { FOLLOW_RPAREN_TOK_in_thfAtomicFormula862_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_equalOp_in_thfAtomicFormula870  */
static	ANTLR3_BITWORD FOLLOW_equalOp_in_thfAtomicFormula870_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_equalOp_in_thfAtomicFormula870	= { FOLLOW_equalOp_in_thfAtomicFormula870_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_thfAtomicFormula873  */
static	ANTLR3_BITWORD FOLLOW_term_in_thfAtomicFormula873_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_thfAtomicFormula873	= { FOLLOW_term_in_thfAtomicFormula873_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfSimpleTerm_in_thfAtomicFormula895  */
static	ANTLR3_BITWORD FOLLOW_thfSimpleTerm_in_thfAtomicFormula895_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_thfSimpleTerm_in_thfAtomicFormula895	= { FOLLOW_thfSimpleTerm_in_thfAtomicFormula895_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letTerm_in_thfAtomicFormula902  */
static	ANTLR3_BITWORD FOLLOW_letTerm_in_thfAtomicFormula902_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_letTerm_in_thfAtomicFormula902	= { FOLLOW_letTerm_in_thfAtomicFormula902_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_conditionalTerm_in_thfAtomicFormula909  */
static	ANTLR3_BITWORD FOLLOW_conditionalTerm_in_thfAtomicFormula909_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_conditionalTerm_in_thfAtomicFormula909	= { FOLLOW_conditionalTerm_in_thfAtomicFormula909_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfDefinedPred_in_thfAtomicFormula916  */
static	ANTLR3_BITWORD FOLLOW_thfDefinedPred_in_thfAtomicFormula916_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000002) };
static  ANTLR3_BITSET_LIST FOLLOW_thfDefinedPred_in_thfAtomicFormula916	= { FOLLOW_thfDefinedPred_in_thfAtomicFormula916_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_thfAtomicFormula920  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_thfAtomicFormula920_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_thfAtomicFormula920	= { FOLLOW_LPAREN_TOK_in_thfAtomicFormula920_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arguments_in_thfAtomicFormula922  */
static	ANTLR3_BITWORD FOLLOW_arguments_in_thfAtomicFormula922_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_arguments_in_thfAtomicFormula922	= { FOLLOW_arguments_in_thfAtomicFormula922_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_thfAtomicFormula925  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_thfAtomicFormula925_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_thfAtomicFormula925	= { FOLLOW_RPAREN_TOK_in_thfAtomicFormula925_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_definedProp_in_thfAtomicFormula939  */
static	ANTLR3_BITWORD FOLLOW_definedProp_in_thfAtomicFormula939_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_definedProp_in_thfAtomicFormula939	= { FOLLOW_definedProp_in_thfAtomicFormula939_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUE_TOK_in_definedProp957  */
static	ANTLR3_BITWORD FOLLOW_TRUE_TOK_in_definedProp957_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUE_TOK_in_definedProp957	= { FOLLOW_TRUE_TOK_in_definedProp957_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSE_TOK_in_definedProp965  */
static	ANTLR3_BITWORD FOLLOW_FALSE_TOK_in_definedProp965_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSE_TOK_in_definedProp965	= { FOLLOW_FALSE_TOK_in_definedProp965_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_74_in_definedPred982  */
static	ANTLR3_BITWORD FOLLOW_74_in_definedPred982_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_74_in_definedPred982	= { FOLLOW_74_in_definedPred982_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_75_in_definedPred994  */
static	ANTLR3_BITWORD FOLLOW_75_in_definedPred994_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_75_in_definedPred994	= { FOLLOW_75_in_definedPred994_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_68_in_definedPred1006  */
static	ANTLR3_BITWORD FOLLOW_68_in_definedPred1006_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_68_in_definedPred1006	= { FOLLOW_68_in_definedPred1006_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_69_in_definedPred1018  */
static	ANTLR3_BITWORD FOLLOW_69_in_definedPred1018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_69_in_definedPred1018	= { FOLLOW_69_in_definedPred1018_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_71_in_definedPred1030  */
static	ANTLR3_BITWORD FOLLOW_71_in_definedPred1030_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_71_in_definedPred1030	= { FOLLOW_71_in_definedPred1030_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_70_in_definedPred1057  */
static	ANTLR3_BITWORD FOLLOW_70_in_definedPred1057_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_70_in_definedPred1057	= { FOLLOW_70_in_definedPred1057_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_66_in_definedPred1069  */
static	ANTLR3_BITWORD FOLLOW_66_in_definedPred1069_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_66_in_definedPred1069	= { FOLLOW_66_in_definedPred1069_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_TOK_in_definedPred1081  */
static	ANTLR3_BITWORD FOLLOW_AND_TOK_in_definedPred1081_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_TOK_in_definedPred1081	= { FOLLOW_AND_TOK_in_definedPred1081_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IMPLIES_TOK_in_definedPred1093  */
static	ANTLR3_BITWORD FOLLOW_IMPLIES_TOK_in_definedPred1093_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IMPLIES_TOK_in_definedPred1093	= { FOLLOW_IMPLIES_TOK_in_definedPred1093_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_TOK_in_definedPred1105  */
static	ANTLR3_BITWORD FOLLOW_OR_TOK_in_definedPred1105_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_TOK_in_definedPred1105	= { FOLLOW_OR_TOK_in_definedPred1105_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_74_in_thfDefinedPred1125  */
static	ANTLR3_BITWORD FOLLOW_74_in_thfDefinedPred1125_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_74_in_thfDefinedPred1125	= { FOLLOW_74_in_thfDefinedPred1125_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_75_in_thfDefinedPred1138  */
static	ANTLR3_BITWORD FOLLOW_75_in_thfDefinedPred1138_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_75_in_thfDefinedPred1138	= { FOLLOW_75_in_thfDefinedPred1138_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_68_in_thfDefinedPred1150  */
static	ANTLR3_BITWORD FOLLOW_68_in_thfDefinedPred1150_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_68_in_thfDefinedPred1150	= { FOLLOW_68_in_thfDefinedPred1150_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_69_in_thfDefinedPred1162  */
static	ANTLR3_BITWORD FOLLOW_69_in_thfDefinedPred1162_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_69_in_thfDefinedPred1162	= { FOLLOW_69_in_thfDefinedPred1162_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_71_in_thfDefinedPred1174  */
static	ANTLR3_BITWORD FOLLOW_71_in_thfDefinedPred1174_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_71_in_thfDefinedPred1174	= { FOLLOW_71_in_thfDefinedPred1174_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_70_in_thfDefinedPred1201  */
static	ANTLR3_BITWORD FOLLOW_70_in_thfDefinedPred1201_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_70_in_thfDefinedPred1201	= { FOLLOW_70_in_thfDefinedPred1201_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_66_in_thfDefinedPred1213  */
static	ANTLR3_BITWORD FOLLOW_66_in_thfDefinedPred1213_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_66_in_thfDefinedPred1213	= { FOLLOW_66_in_thfDefinedPred1213_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_thfDefinedPred1225  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_thfDefinedPred1225_bits[]	= { ANTLR3_UINT64_LIT(0x0000010010000020) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_thfDefinedPred1225	= { FOLLOW_LPAREN_TOK_in_thfDefinedPred1225_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_TOK_in_thfDefinedPred1239  */
static	ANTLR3_BITWORD FOLLOW_AND_TOK_in_thfDefinedPred1239_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_TOK_in_thfDefinedPred1239	= { FOLLOW_AND_TOK_in_thfDefinedPred1239_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_TOK_in_thfDefinedPred1255  */
static	ANTLR3_BITWORD FOLLOW_OR_TOK_in_thfDefinedPred1255_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_TOK_in_thfDefinedPred1255	= { FOLLOW_OR_TOK_in_thfDefinedPred1255_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IMPLIES_TOK_in_thfDefinedPred1271  */
static	ANTLR3_BITWORD FOLLOW_IMPLIES_TOK_in_thfDefinedPred1271_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IMPLIES_TOK_in_thfDefinedPred1271	= { FOLLOW_IMPLIES_TOK_in_thfDefinedPred1271_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_thfDefinedPred1291  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_thfDefinedPred1291_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_thfDefinedPred1291	= { FOLLOW_RPAREN_TOK_in_thfDefinedPred1291_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_95_in_definedFun1310  */
static	ANTLR3_BITWORD FOLLOW_95_in_definedFun1310_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_95_in_definedFun1310	= { FOLLOW_95_in_definedFun1310_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_89_in_definedFun1322  */
static	ANTLR3_BITWORD FOLLOW_89_in_definedFun1322_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_89_in_definedFun1322	= { FOLLOW_89_in_definedFun1322_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_65_in_definedFun1334  */
static	ANTLR3_BITWORD FOLLOW_65_in_definedFun1334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_65_in_definedFun1334	= { FOLLOW_65_in_definedFun1334_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_80_in_definedFun1346  */
static	ANTLR3_BITWORD FOLLOW_80_in_definedFun1346_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_80_in_definedFun1346	= { FOLLOW_80_in_definedFun1346_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_81_in_definedFun1358  */
static	ANTLR3_BITWORD FOLLOW_81_in_definedFun1358_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_81_in_definedFun1358	= { FOLLOW_81_in_definedFun1358_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_82_in_definedFun1372  */
static	ANTLR3_BITWORD FOLLOW_82_in_definedFun1372_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_82_in_definedFun1372	= { FOLLOW_82_in_definedFun1372_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_85_in_definedFun1382  */
static	ANTLR3_BITWORD FOLLOW_85_in_definedFun1382_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_85_in_definedFun1382	= { FOLLOW_85_in_definedFun1382_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_84_in_definedFun1404  */
static	ANTLR3_BITWORD FOLLOW_84_in_definedFun1404_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_84_in_definedFun1404	= { FOLLOW_84_in_definedFun1404_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_87_in_definedFun1414  */
static	ANTLR3_BITWORD FOLLOW_87_in_definedFun1414_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_87_in_definedFun1414	= { FOLLOW_87_in_definedFun1414_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_83_in_definedFun1436  */
static	ANTLR3_BITWORD FOLLOW_83_in_definedFun1436_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_83_in_definedFun1436	= { FOLLOW_83_in_definedFun1436_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_86_in_definedFun1446  */
static	ANTLR3_BITWORD FOLLOW_86_in_definedFun1446_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_86_in_definedFun1446	= { FOLLOW_86_in_definedFun1446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_67_in_definedFun1466  */
static	ANTLR3_BITWORD FOLLOW_67_in_definedFun1466_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_67_in_definedFun1466	= { FOLLOW_67_in_definedFun1466_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_64_in_definedFun1478  */
static	ANTLR3_BITWORD FOLLOW_64_in_definedFun1478_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_64_in_definedFun1478	= { FOLLOW_64_in_definedFun1478_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_94_in_definedFun1490  */
static	ANTLR3_BITWORD FOLLOW_94_in_definedFun1490_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_94_in_definedFun1490	= { FOLLOW_94_in_definedFun1490_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_88_in_definedFun1502  */
static	ANTLR3_BITWORD FOLLOW_88_in_definedFun1502_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_88_in_definedFun1502	= { FOLLOW_88_in_definedFun1502_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_91_in_definedFun1514  */
static	ANTLR3_BITWORD FOLLOW_91_in_definedFun1514_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_91_in_definedFun1514	= { FOLLOW_91_in_definedFun1514_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_92_in_definedFun1526  */
static	ANTLR3_BITWORD FOLLOW_92_in_definedFun1526_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_92_in_definedFun1526	= { FOLLOW_92_in_definedFun1526_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_93_in_definedFun1538  */
static	ANTLR3_BITWORD FOLLOW_93_in_definedFun1538_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_93_in_definedFun1538	= { FOLLOW_93_in_definedFun1538_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_equalOp1561  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_equalOp1561_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_equalOp1561	= { FOLLOW_EQUAL_TOK_in_equalOp1561_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISEQUAL_TOK_in_equalOp1572  */
static	ANTLR3_BITWORD FOLLOW_DISEQUAL_TOK_in_equalOp1572_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DISEQUAL_TOK_in_equalOp1572	= { FOLLOW_DISEQUAL_TOK_in_equalOp1572_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_functionTerm_in_term1588  */
static	ANTLR3_BITWORD FOLLOW_functionTerm_in_term1588_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_functionTerm_in_term1588	= { FOLLOW_functionTerm_in_term1588_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_conditionalTerm_in_term1595  */
static	ANTLR3_BITWORD FOLLOW_conditionalTerm_in_term1595_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_conditionalTerm_in_term1595	= { FOLLOW_conditionalTerm_in_term1595_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleTerm_in_term1602  */
static	ANTLR3_BITWORD FOLLOW_simpleTerm_in_term1602_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleTerm_in_term1602	= { FOLLOW_simpleTerm_in_term1602_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letTerm_in_term1609  */
static	ANTLR3_BITWORD FOLLOW_letTerm_in_term1609_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_letTerm_in_term1609	= { FOLLOW_letTerm_in_term1609_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_77_in_letTerm1629  */
static	ANTLR3_BITWORD FOLLOW_77_in_letTerm1629_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_77_in_letTerm1629	= { FOLLOW_77_in_letTerm1629_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_letTerm1631  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_letTerm1631_bits[]	= { ANTLR3_UINT64_LIT(0x2D22014E37020220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_letTerm1631	= { FOLLOW_LPAREN_TOK_in_letTerm1631_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLetFormulaDefn_in_letTerm1639  */
static	ANTLR3_BITWORD FOLLOW_tffLetFormulaDefn_in_letTerm1639_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLetFormulaDefn_in_letTerm1639	= { FOLLOW_tffLetFormulaDefn_in_letTerm1639_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_letTerm1642  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_letTerm1642_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_letTerm1642	= { FOLLOW_COMMA_TOK_in_letTerm1642_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_letTerm1648  */
static	ANTLR3_BITWORD FOLLOW_term_in_letTerm1648_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_letTerm1648	= { FOLLOW_term_in_letTerm1648_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_letTerm1661  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_letTerm1661_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_letTerm1661	= { FOLLOW_RPAREN_TOK_in_letTerm1661_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_79_in_letTerm1667  */
static	ANTLR3_BITWORD FOLLOW_79_in_letTerm1667_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_79_in_letTerm1667	= { FOLLOW_79_in_letTerm1667_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_letTerm1669  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_letTerm1669_bits[]	= { ANTLR3_UINT64_LIT(0x2922004E26020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_letTerm1669	= { FOLLOW_LPAREN_TOK_in_letTerm1669_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLetTermDefn_in_letTerm1677  */
static	ANTLR3_BITWORD FOLLOW_tffLetTermDefn_in_letTerm1677_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLetTermDefn_in_letTerm1677	= { FOLLOW_tffLetTermDefn_in_letTerm1677_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_letTerm1680  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_letTerm1680_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_letTerm1680	= { FOLLOW_COMMA_TOK_in_letTerm1680_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_letTerm1686  */
static	ANTLR3_BITWORD FOLLOW_term_in_letTerm1686_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_letTerm1686	= { FOLLOW_term_in_letTerm1686_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_letTerm1699  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_letTerm1699_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_letTerm1699	= { FOLLOW_RPAREN_TOK_in_letTerm1699_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_variable_in_simpleTerm1715  */
static	ANTLR3_BITWORD FOLLOW_variable_in_simpleTerm1715_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_variable_in_simpleTerm1715	= { FOLLOW_variable_in_simpleTerm1715_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_simpleTerm1722  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_simpleTerm1722_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_simpleTerm1722	= { FOLLOW_NUMBER_in_simpleTerm1722_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISTINCT_OBJECT_in_simpleTerm1730  */
static	ANTLR3_BITWORD FOLLOW_DISTINCT_OBJECT_in_simpleTerm1730_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DISTINCT_OBJECT_in_simpleTerm1730	= { FOLLOW_DISTINCT_OBJECT_in_simpleTerm1730_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_thfSimpleTerm1748  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_thfSimpleTerm1748_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_thfSimpleTerm1748	= { FOLLOW_NUMBER_in_thfSimpleTerm1748_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISTINCT_OBJECT_in_thfSimpleTerm1756  */
static	ANTLR3_BITWORD FOLLOW_DISTINCT_OBJECT_in_thfSimpleTerm1756_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DISTINCT_OBJECT_in_thfSimpleTerm1756	= { FOLLOW_DISTINCT_OBJECT_in_thfSimpleTerm1756_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_plainTerm_in_functionTerm1781  */
static	ANTLR3_BITWORD FOLLOW_plainTerm_in_functionTerm1781_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_plainTerm_in_functionTerm1781	= { FOLLOW_plainTerm_in_functionTerm1781_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_definedFun_in_functionTerm1788  */
static	ANTLR3_BITWORD FOLLOW_definedFun_in_functionTerm1788_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_definedFun_in_functionTerm1788	= { FOLLOW_definedFun_in_functionTerm1788_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_functionTerm1791  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_functionTerm1791_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_functionTerm1791	= { FOLLOW_LPAREN_TOK_in_functionTerm1791_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arguments_in_functionTerm1793  */
static	ANTLR3_BITWORD FOLLOW_arguments_in_functionTerm1793_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_arguments_in_functionTerm1793	= { FOLLOW_arguments_in_functionTerm1793_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_functionTerm1796  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_functionTerm1796_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_functionTerm1796	= { FOLLOW_RPAREN_TOK_in_functionTerm1796_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_73_in_conditionalTerm1821  */
static	ANTLR3_BITWORD FOLLOW_73_in_conditionalTerm1821_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_73_in_conditionalTerm1821	= { FOLLOW_73_in_conditionalTerm1821_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_conditionalTerm1823  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_conditionalTerm1823_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_conditionalTerm1823	= { FOLLOW_LPAREN_TOK_in_conditionalTerm1823_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLogicFormula_in_conditionalTerm1825  */
static	ANTLR3_BITWORD FOLLOW_tffLogicFormula_in_conditionalTerm1825_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLogicFormula_in_conditionalTerm1825	= { FOLLOW_tffLogicFormula_in_conditionalTerm1825_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_conditionalTerm1828  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_conditionalTerm1828_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_conditionalTerm1828	= { FOLLOW_COMMA_TOK_in_conditionalTerm1828_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_conditionalTerm1830  */
static	ANTLR3_BITWORD FOLLOW_term_in_conditionalTerm1830_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_conditionalTerm1830	= { FOLLOW_term_in_conditionalTerm1830_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_conditionalTerm1833  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_conditionalTerm1833_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_conditionalTerm1833	= { FOLLOW_COMMA_TOK_in_conditionalTerm1833_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_conditionalTerm1835  */
static	ANTLR3_BITWORD FOLLOW_term_in_conditionalTerm1835_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_conditionalTerm1835	= { FOLLOW_term_in_conditionalTerm1835_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_conditionalTerm1838  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_conditionalTerm1838_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_conditionalTerm1838	= { FOLLOW_RPAREN_TOK_in_conditionalTerm1838_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomicWord_in_plainTerm1863  */
static	ANTLR3_BITWORD FOLLOW_atomicWord_in_plainTerm1863_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomicWord_in_plainTerm1863	= { FOLLOW_atomicWord_in_plainTerm1863_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_plainTerm1867  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_plainTerm1867_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_plainTerm1867	= { FOLLOW_LPAREN_TOK_in_plainTerm1867_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arguments_in_plainTerm1869  */
static	ANTLR3_BITWORD FOLLOW_arguments_in_plainTerm1869_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_arguments_in_plainTerm1869	= { FOLLOW_arguments_in_plainTerm1869_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_plainTerm1872  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_plainTerm1872_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_plainTerm1872	= { FOLLOW_RPAREN_TOK_in_plainTerm1872_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_arguments1901  */
static	ANTLR3_BITWORD FOLLOW_term_in_arguments1901_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000802) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_arguments1901	= { FOLLOW_term_in_arguments1901_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_arguments1908  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_arguments1908_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_arguments1908	= { FOLLOW_COMMA_TOK_in_arguments1908_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_arguments1910  */
static	ANTLR3_BITWORD FOLLOW_term_in_arguments1910_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000802) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_arguments1910	= { FOLLOW_term_in_arguments1910_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UPPER_WORD_in_variable1930  */
static	ANTLR3_BITWORD FOLLOW_UPPER_WORD_in_variable1930_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UPPER_WORD_in_variable1930	= { FOLLOW_UPPER_WORD_in_variable1930_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofLogicFormula_in_fofFormula1954  */
static	ANTLR3_BITWORD FOLLOW_fofLogicFormula_in_fofFormula1954_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_fofLogicFormula_in_fofFormula1954	= { FOLLOW_fofLogicFormula_in_fofFormula1954_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofUnitaryFormula_in_fofLogicFormula1972  */
static	ANTLR3_BITWORD FOLLOW_fofUnitaryFormula_in_fofLogicFormula1972_bits[]	= { ANTLR3_UINT64_LIT(0x0000790018000022) };
static  ANTLR3_BITSET_LIST FOLLOW_fofUnitaryFormula_in_fofLogicFormula1972	= { FOLLOW_fofUnitaryFormula_in_fofLogicFormula1972_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofBinaryNonAssoc_in_fofLogicFormula1990  */
static	ANTLR3_BITWORD FOLLOW_fofBinaryNonAssoc_in_fofLogicFormula1990_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_fofBinaryNonAssoc_in_fofLogicFormula1990	= { FOLLOW_fofBinaryNonAssoc_in_fofLogicFormula1990_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofUnitaryFormula_in_fofLogicFormula1993  */
static	ANTLR3_BITWORD FOLLOW_fofUnitaryFormula_in_fofLogicFormula1993_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_fofUnitaryFormula_in_fofLogicFormula1993	= { FOLLOW_fofUnitaryFormula_in_fofLogicFormula1993_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_TOK_in_fofLogicFormula2041  */
static	ANTLR3_BITWORD FOLLOW_AND_TOK_in_fofLogicFormula2041_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_TOK_in_fofLogicFormula2041	= { FOLLOW_AND_TOK_in_fofLogicFormula2041_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofUnitaryFormula_in_fofLogicFormula2043  */
static	ANTLR3_BITWORD FOLLOW_fofUnitaryFormula_in_fofLogicFormula2043_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000022) };
static  ANTLR3_BITSET_LIST FOLLOW_fofUnitaryFormula_in_fofLogicFormula2043	= { FOLLOW_fofUnitaryFormula_in_fofLogicFormula2043_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_TOK_in_fofLogicFormula2096  */
static	ANTLR3_BITWORD FOLLOW_OR_TOK_in_fofLogicFormula2096_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_TOK_in_fofLogicFormula2096	= { FOLLOW_OR_TOK_in_fofLogicFormula2096_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofUnitaryFormula_in_fofLogicFormula2098  */
static	ANTLR3_BITWORD FOLLOW_fofUnitaryFormula_in_fofLogicFormula2098_bits[]	= { ANTLR3_UINT64_LIT(0x0000010000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_fofUnitaryFormula_in_fofLogicFormula2098	= { FOLLOW_fofUnitaryFormula_in_fofLogicFormula2098_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomicFormula_in_fofUnitaryFormula2148  */
static	ANTLR3_BITWORD FOLLOW_atomicFormula_in_fofUnitaryFormula2148_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomicFormula_in_fofUnitaryFormula2148	= { FOLLOW_atomicFormula_in_fofUnitaryFormula2148_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_fofUnitaryFormula2155  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_fofUnitaryFormula2155_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_fofUnitaryFormula2155	= { FOLLOW_LPAREN_TOK_in_fofUnitaryFormula2155_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofLogicFormula_in_fofUnitaryFormula2157  */
static	ANTLR3_BITWORD FOLLOW_fofLogicFormula_in_fofUnitaryFormula2157_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_fofLogicFormula_in_fofUnitaryFormula2157	= { FOLLOW_fofLogicFormula_in_fofUnitaryFormula2157_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_fofUnitaryFormula2160  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_fofUnitaryFormula2160_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_fofUnitaryFormula2160	= { FOLLOW_RPAREN_TOK_in_fofUnitaryFormula2160_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_fofUnitaryFormula2166  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_fofUnitaryFormula2166_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_fofUnitaryFormula2166	= { FOLLOW_NOT_TOK_in_fofUnitaryFormula2166_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofUnitaryFormula_in_fofUnitaryFormula2168  */
static	ANTLR3_BITWORD FOLLOW_fofUnitaryFormula_in_fofUnitaryFormula2168_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_fofUnitaryFormula_in_fofUnitaryFormula2168	= { FOLLOW_fofUnitaryFormula_in_fofUnitaryFormula2168_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_folQuantifier_in_fofUnitaryFormula2182  */
static	ANTLR3_BITWORD FOLLOW_folQuantifier_in_fofUnitaryFormula2182_bits[]	= { ANTLR3_UINT64_LIT(0x0000000080000000) };
static  ANTLR3_BITSET_LIST FOLLOW_folQuantifier_in_fofUnitaryFormula2182	= { FOLLOW_folQuantifier_in_fofUnitaryFormula2182_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACK_TOK_in_fofUnitaryFormula2185  */
static	ANTLR3_BITWORD FOLLOW_LBRACK_TOK_in_fofUnitaryFormula2185_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACK_TOK_in_fofUnitaryFormula2185	= { FOLLOW_LBRACK_TOK_in_fofUnitaryFormula2185_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bindvariable_in_fofUnitaryFormula2195  */
static	ANTLR3_BITWORD FOLLOW_bindvariable_in_fofUnitaryFormula2195_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_bindvariable_in_fofUnitaryFormula2195	= { FOLLOW_bindvariable_in_fofUnitaryFormula2195_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_fofUnitaryFormula2208  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_fofUnitaryFormula2208_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_fofUnitaryFormula2208	= { FOLLOW_COMMA_TOK_in_fofUnitaryFormula2208_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bindvariable_in_fofUnitaryFormula2210  */
static	ANTLR3_BITWORD FOLLOW_bindvariable_in_fofUnitaryFormula2210_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_bindvariable_in_fofUnitaryFormula2210	= { FOLLOW_bindvariable_in_fofUnitaryFormula2210_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACK_TOK_in_fofUnitaryFormula2220  */
static	ANTLR3_BITWORD FOLLOW_RBRACK_TOK_in_fofUnitaryFormula2220_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACK_TOK_in_fofUnitaryFormula2220	= { FOLLOW_RBRACK_TOK_in_fofUnitaryFormula2220_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_TOK_in_fofUnitaryFormula2226  */
static	ANTLR3_BITWORD FOLLOW_COLON_TOK_in_fofUnitaryFormula2226_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_TOK_in_fofUnitaryFormula2226	= { FOLLOW_COLON_TOK_in_fofUnitaryFormula2226_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofUnitaryFormula_in_fofUnitaryFormula2228  */
static	ANTLR3_BITWORD FOLLOW_fofUnitaryFormula_in_fofUnitaryFormula2228_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_fofUnitaryFormula_in_fofUnitaryFormula2228	= { FOLLOW_fofUnitaryFormula_in_fofUnitaryFormula2228_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UPPER_WORD_in_bindvariable2249  */
static	ANTLR3_BITWORD FOLLOW_UPPER_WORD_in_bindvariable2249_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UPPER_WORD_in_bindvariable2249	= { FOLLOW_UPPER_WORD_in_bindvariable2249_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IFF_TOK_in_fofBinaryNonAssoc2269  */
static	ANTLR3_BITWORD FOLLOW_IFF_TOK_in_fofBinaryNonAssoc2269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IFF_TOK_in_fofBinaryNonAssoc2269	= { FOLLOW_IFF_TOK_in_fofBinaryNonAssoc2269_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REVIFF_TOK_in_fofBinaryNonAssoc2282  */
static	ANTLR3_BITWORD FOLLOW_REVIFF_TOK_in_fofBinaryNonAssoc2282_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REVIFF_TOK_in_fofBinaryNonAssoc2282	= { FOLLOW_REVIFF_TOK_in_fofBinaryNonAssoc2282_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REVOR_TOK_in_fofBinaryNonAssoc2292  */
static	ANTLR3_BITWORD FOLLOW_REVOR_TOK_in_fofBinaryNonAssoc2292_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REVOR_TOK_in_fofBinaryNonAssoc2292	= { FOLLOW_REVOR_TOK_in_fofBinaryNonAssoc2292_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REVAND_TOK_in_fofBinaryNonAssoc2303  */
static	ANTLR3_BITWORD FOLLOW_REVAND_TOK_in_fofBinaryNonAssoc2303_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REVAND_TOK_in_fofBinaryNonAssoc2303	= { FOLLOW_REVAND_TOK_in_fofBinaryNonAssoc2303_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IMPLIES_TOK_in_fofBinaryNonAssoc2313  */
static	ANTLR3_BITWORD FOLLOW_IMPLIES_TOK_in_fofBinaryNonAssoc2313_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IMPLIES_TOK_in_fofBinaryNonAssoc2313	= { FOLLOW_IMPLIES_TOK_in_fofBinaryNonAssoc2313_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REVIMPLIES_TOK_in_fofBinaryNonAssoc2324  */
static	ANTLR3_BITWORD FOLLOW_REVIMPLIES_TOK_in_fofBinaryNonAssoc2324_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REVIMPLIES_TOK_in_fofBinaryNonAssoc2324	= { FOLLOW_REVIMPLIES_TOK_in_fofBinaryNonAssoc2324_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_folQuantifier2340  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_folQuantifier2340_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_folQuantifier2340	= { FOLLOW_FORALL_TOK_in_folQuantifier2340_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXISTS_TOK_in_folQuantifier2348  */
static	ANTLR3_BITWORD FOLLOW_EXISTS_TOK_in_folQuantifier2348_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXISTS_TOK_in_folQuantifier2348	= { FOLLOW_EXISTS_TOK_in_folQuantifier2348_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_thfQuantifier2369  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_thfQuantifier2369_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_thfQuantifier2369	= { FOLLOW_FORALL_TOK_in_thfQuantifier2369_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXISTS_TOK_in_thfQuantifier2377  */
static	ANTLR3_BITWORD FOLLOW_EXISTS_TOK_in_thfQuantifier2377_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXISTS_TOK_in_thfQuantifier2377	= { FOLLOW_EXISTS_TOK_in_thfQuantifier2377_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LAMBDA_TOK_in_thfQuantifier2385  */
static	ANTLR3_BITWORD FOLLOW_LAMBDA_TOK_in_thfQuantifier2385_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LAMBDA_TOK_in_thfQuantifier2385	= { FOLLOW_LAMBDA_TOK_in_thfQuantifier2385_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHOICE_TOK_in_thfQuantifier2393  */
static	ANTLR3_BITWORD FOLLOW_CHOICE_TOK_in_thfQuantifier2393_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CHOICE_TOK_in_thfQuantifier2393	= { FOLLOW_CHOICE_TOK_in_thfQuantifier2393_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEF_DESC_TOK_in_thfQuantifier2405  */
static	ANTLR3_BITWORD FOLLOW_DEF_DESC_TOK_in_thfQuantifier2405_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DEF_DESC_TOK_in_thfQuantifier2405	= { FOLLOW_DEF_DESC_TOK_in_thfQuantifier2405_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_thfQuantifier2417  */
static	ANTLR3_BITWORD FOLLOW_set_in_thfQuantifier2417_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_thfQuantifier2417	= { FOLLOW_set_in_thfQuantifier2417_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_thfAtomTyping2449  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_thfAtomTyping2449_bits[]	= { ANTLR3_UINT64_LIT(0x0922004E22000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_thfAtomTyping2449	= { FOLLOW_LPAREN_TOK_in_thfAtomTyping2449_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfAtomTyping_in_thfAtomTyping2451  */
static	ANTLR3_BITWORD FOLLOW_thfAtomTyping_in_thfAtomTyping2451_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_thfAtomTyping_in_thfAtomTyping2451	= { FOLLOW_thfAtomTyping_in_thfAtomTyping2451_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_thfAtomTyping2454  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_thfAtomTyping2454_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_thfAtomTyping2454	= { FOLLOW_RPAREN_TOK_in_thfAtomTyping2454_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nameN_in_thfAtomTyping2460  */
static	ANTLR3_BITWORD FOLLOW_nameN_in_thfAtomTyping2460_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_nameN_in_thfAtomTyping2460	= { FOLLOW_nameN_in_thfAtomTyping2460_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_TOK_in_thfAtomTyping2463  */
static	ANTLR3_BITWORD FOLLOW_COLON_TOK_in_thfAtomTyping2463_bits[]	= { ANTLR3_UINT64_LIT(0x0922000EA2004200), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_TOK_in_thfAtomTyping2463	= { FOLLOW_COLON_TOK_in_thfAtomTyping2463_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_90_in_thfAtomTyping2471  */
static	ANTLR3_BITWORD FOLLOW_90_in_thfAtomTyping2471_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_90_in_thfAtomTyping2471	= { FOLLOW_90_in_thfAtomTyping2471_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parseThfType_in_thfAtomTyping2487  */
static	ANTLR3_BITWORD FOLLOW_parseThfType_in_thfAtomTyping2487_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_parseThfType_in_thfAtomTyping2487	= { FOLLOW_parseThfType_in_thfAtomTyping2487_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfUnitaryFormula_in_thfLogicFormula2527  */
static	ANTLR3_BITWORD FOLLOW_thfUnitaryFormula_in_thfLogicFormula2527_bits[]	= { ANTLR3_UINT64_LIT(0x0000790018210062) };
static  ANTLR3_BITSET_LIST FOLLOW_thfUnitaryFormula_in_thfLogicFormula2527	= { FOLLOW_thfUnitaryFormula_in_thfLogicFormula2527_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_equalOp_in_thfLogicFormula2543  */
static	ANTLR3_BITWORD FOLLOW_equalOp_in_thfLogicFormula2543_bits[]	= { ANTLR3_UINT64_LIT(0x2DE2006E67428300), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_equalOp_in_thfLogicFormula2543	= { FOLLOW_equalOp_in_thfLogicFormula2543_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfUnitaryFormula_in_thfLogicFormula2552  */
static	ANTLR3_BITWORD FOLLOW_thfUnitaryFormula_in_thfLogicFormula2552_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_thfUnitaryFormula_in_thfLogicFormula2552	= { FOLLOW_thfUnitaryFormula_in_thfLogicFormula2552_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofBinaryNonAssoc_in_thfLogicFormula2576  */
static	ANTLR3_BITWORD FOLLOW_fofBinaryNonAssoc_in_thfLogicFormula2576_bits[]	= { ANTLR3_UINT64_LIT(0x2DE2006E67428300), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_fofBinaryNonAssoc_in_thfLogicFormula2576	= { FOLLOW_fofBinaryNonAssoc_in_thfLogicFormula2576_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfUnitaryFormula_in_thfLogicFormula2579  */
static	ANTLR3_BITWORD FOLLOW_thfUnitaryFormula_in_thfLogicFormula2579_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_thfUnitaryFormula_in_thfLogicFormula2579	= { FOLLOW_thfUnitaryFormula_in_thfLogicFormula2579_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_TOK_in_thfLogicFormula2625  */
static	ANTLR3_BITWORD FOLLOW_AND_TOK_in_thfLogicFormula2625_bits[]	= { ANTLR3_UINT64_LIT(0x2DE2006E67428300), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_TOK_in_thfLogicFormula2625	= { FOLLOW_AND_TOK_in_thfLogicFormula2625_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfUnitaryFormula_in_thfLogicFormula2627  */
static	ANTLR3_BITWORD FOLLOW_thfUnitaryFormula_in_thfLogicFormula2627_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000022) };
static  ANTLR3_BITSET_LIST FOLLOW_thfUnitaryFormula_in_thfLogicFormula2627	= { FOLLOW_thfUnitaryFormula_in_thfLogicFormula2627_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_TOK_in_thfLogicFormula2706  */
static	ANTLR3_BITWORD FOLLOW_OR_TOK_in_thfLogicFormula2706_bits[]	= { ANTLR3_UINT64_LIT(0x2DE2006E67428300), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_TOK_in_thfLogicFormula2706	= { FOLLOW_OR_TOK_in_thfLogicFormula2706_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfUnitaryFormula_in_thfLogicFormula2708  */
static	ANTLR3_BITWORD FOLLOW_thfUnitaryFormula_in_thfLogicFormula2708_bits[]	= { ANTLR3_UINT64_LIT(0x0000010000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_thfUnitaryFormula_in_thfLogicFormula2708	= { FOLLOW_thfUnitaryFormula_in_thfLogicFormula2708_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_APP_TOK_in_thfLogicFormula2810  */
static	ANTLR3_BITWORD FOLLOW_APP_TOK_in_thfLogicFormula2810_bits[]	= { ANTLR3_UINT64_LIT(0x2DE2006EE7428300), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_APP_TOK_in_thfLogicFormula2810	= { FOLLOW_APP_TOK_in_thfLogicFormula2810_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfUnitaryFormula_in_thfLogicFormula2831  */
static	ANTLR3_BITWORD FOLLOW_thfUnitaryFormula_in_thfLogicFormula2831_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000042) };
static  ANTLR3_BITSET_LIST FOLLOW_thfUnitaryFormula_in_thfLogicFormula2831	= { FOLLOW_thfUnitaryFormula_in_thfLogicFormula2831_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACK_TOK_in_thfLogicFormula2856  */
static	ANTLR3_BITWORD FOLLOW_LBRACK_TOK_in_thfLogicFormula2856_bits[]	= { ANTLR3_UINT64_LIT(0x2DE2006E67428300), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACK_TOK_in_thfLogicFormula2856	= { FOLLOW_LBRACK_TOK_in_thfLogicFormula2856_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfTupleForm_in_thfLogicFormula2882  */
static	ANTLR3_BITWORD FOLLOW_thfTupleForm_in_thfLogicFormula2882_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_thfTupleForm_in_thfLogicFormula2882	= { FOLLOW_thfTupleForm_in_thfLogicFormula2882_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACK_TOK_in_thfLogicFormula2896  */
static	ANTLR3_BITWORD FOLLOW_RBRACK_TOK_in_thfLogicFormula2896_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000042) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACK_TOK_in_thfLogicFormula2896	= { FOLLOW_RBRACK_TOK_in_thfLogicFormula2896_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfUnitaryFormula_in_thfTupleForm2949  */
static	ANTLR3_BITWORD FOLLOW_thfUnitaryFormula_in_thfTupleForm2949_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_thfUnitaryFormula_in_thfTupleForm2949	= { FOLLOW_thfUnitaryFormula_in_thfTupleForm2949_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_thfTupleForm2962  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_thfTupleForm2962_bits[]	= { ANTLR3_UINT64_LIT(0x2DE2006E67428300), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_thfTupleForm2962	= { FOLLOW_COMMA_TOK_in_thfTupleForm2962_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfUnitaryFormula_in_thfTupleForm2964  */
static	ANTLR3_BITWORD FOLLOW_thfUnitaryFormula_in_thfTupleForm2964_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000802) };
static  ANTLR3_BITSET_LIST FOLLOW_thfUnitaryFormula_in_thfTupleForm2964	= { FOLLOW_thfUnitaryFormula_in_thfTupleForm2964_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_variable_in_thfUnitaryFormula2995  */
static	ANTLR3_BITWORD FOLLOW_variable_in_thfUnitaryFormula2995_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_variable_in_thfUnitaryFormula2995	= { FOLLOW_variable_in_thfUnitaryFormula2995_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfAtomicFormula_in_thfUnitaryFormula3002  */
static	ANTLR3_BITWORD FOLLOW_thfAtomicFormula_in_thfUnitaryFormula3002_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_thfAtomicFormula_in_thfUnitaryFormula3002	= { FOLLOW_thfAtomicFormula_in_thfUnitaryFormula3002_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_thfUnitaryFormula3009  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_thfUnitaryFormula3009_bits[]	= { ANTLR3_UINT64_LIT(0x2DE2006E67428300), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_thfUnitaryFormula3009	= { FOLLOW_LPAREN_TOK_in_thfUnitaryFormula3009_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfLogicFormula_in_thfUnitaryFormula3015  */
static	ANTLR3_BITWORD FOLLOW_thfLogicFormula_in_thfUnitaryFormula3015_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_thfLogicFormula_in_thfUnitaryFormula3015	= { FOLLOW_thfLogicFormula_in_thfUnitaryFormula3015_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_thfUnitaryFormula3022  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_thfUnitaryFormula3022_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_thfUnitaryFormula3022	= { FOLLOW_RPAREN_TOK_in_thfUnitaryFormula3022_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_thfUnitaryFormula3028  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_thfUnitaryFormula3028_bits[]	= { ANTLR3_UINT64_LIT(0x2DE2006E67428302), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_thfUnitaryFormula3028	= { FOLLOW_NOT_TOK_in_thfUnitaryFormula3028_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfUnitaryFormula_in_thfUnitaryFormula3047  */
static	ANTLR3_BITWORD FOLLOW_thfUnitaryFormula_in_thfUnitaryFormula3047_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_thfUnitaryFormula_in_thfUnitaryFormula3047	= { FOLLOW_thfUnitaryFormula_in_thfUnitaryFormula3047_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfQuantifier_in_thfUnitaryFormula3073  */
static	ANTLR3_BITWORD FOLLOW_thfQuantifier_in_thfUnitaryFormula3073_bits[]	= { ANTLR3_UINT64_LIT(0x0000000080000000) };
static  ANTLR3_BITSET_LIST FOLLOW_thfQuantifier_in_thfUnitaryFormula3073	= { FOLLOW_thfQuantifier_in_thfUnitaryFormula3073_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACK_TOK_in_thfUnitaryFormula3080  */
static	ANTLR3_BITWORD FOLLOW_LBRACK_TOK_in_thfUnitaryFormula3080_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACK_TOK_in_thfUnitaryFormula3080	= { FOLLOW_LBRACK_TOK_in_thfUnitaryFormula3080_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfBindVariable_in_thfUnitaryFormula3088  */
static	ANTLR3_BITWORD FOLLOW_thfBindVariable_in_thfUnitaryFormula3088_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_thfBindVariable_in_thfUnitaryFormula3088	= { FOLLOW_thfBindVariable_in_thfUnitaryFormula3088_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_thfUnitaryFormula3103  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_thfUnitaryFormula3103_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_thfUnitaryFormula3103	= { FOLLOW_COMMA_TOK_in_thfUnitaryFormula3103_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfBindVariable_in_thfUnitaryFormula3105  */
static	ANTLR3_BITWORD FOLLOW_thfBindVariable_in_thfUnitaryFormula3105_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_thfBindVariable_in_thfUnitaryFormula3105	= { FOLLOW_thfBindVariable_in_thfUnitaryFormula3105_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACK_TOK_in_thfUnitaryFormula3127  */
static	ANTLR3_BITWORD FOLLOW_RBRACK_TOK_in_thfUnitaryFormula3127_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACK_TOK_in_thfUnitaryFormula3127	= { FOLLOW_RBRACK_TOK_in_thfUnitaryFormula3127_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_TOK_in_thfUnitaryFormula3129  */
static	ANTLR3_BITWORD FOLLOW_COLON_TOK_in_thfUnitaryFormula3129_bits[]	= { ANTLR3_UINT64_LIT(0x2DE2006E67428300), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_TOK_in_thfUnitaryFormula3129	= { FOLLOW_COLON_TOK_in_thfUnitaryFormula3129_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfUnitaryFormula_in_thfUnitaryFormula3135  */
static	ANTLR3_BITWORD FOLLOW_thfUnitaryFormula_in_thfUnitaryFormula3135_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_thfUnitaryFormula_in_thfUnitaryFormula3135	= { FOLLOW_thfUnitaryFormula_in_thfUnitaryFormula3135_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLogicFormula_in_tffFormula3158  */
static	ANTLR3_BITWORD FOLLOW_tffLogicFormula_in_tffFormula3158_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLogicFormula_in_tffFormula3158	= { FOLLOW_tffLogicFormula_in_tffFormula3158_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_tffTypedAtom3175  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_tffTypedAtom3175_bits[]	= { ANTLR3_UINT64_LIT(0x0922004E22000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_tffTypedAtom3175	= { FOLLOW_LPAREN_TOK_in_tffTypedAtom3175_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffTypedAtom_in_tffTypedAtom3177  */
static	ANTLR3_BITWORD FOLLOW_tffTypedAtom_in_tffTypedAtom3177_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_tffTypedAtom_in_tffTypedAtom3177	= { FOLLOW_tffTypedAtom_in_tffTypedAtom3177_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_tffTypedAtom3180  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_tffTypedAtom3180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_tffTypedAtom3180	= { FOLLOW_RPAREN_TOK_in_tffTypedAtom3180_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nameN_in_tffTypedAtom3186  */
static	ANTLR3_BITWORD FOLLOW_nameN_in_tffTypedAtom3186_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_nameN_in_tffTypedAtom3186	= { FOLLOW_nameN_in_tffTypedAtom3186_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_TOK_in_tffTypedAtom3189  */
static	ANTLR3_BITWORD FOLLOW_COLON_TOK_in_tffTypedAtom3189_bits[]	= { ANTLR3_UINT64_LIT(0x0922000E22004200), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_TOK_in_tffTypedAtom3189	= { FOLLOW_COLON_TOK_in_tffTypedAtom3189_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_90_in_tffTypedAtom3197  */
static	ANTLR3_BITWORD FOLLOW_90_in_tffTypedAtom3197_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_90_in_tffTypedAtom3197	= { FOLLOW_90_in_tffTypedAtom3197_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parseType_in_tffTypedAtom3213  */
static	ANTLR3_BITWORD FOLLOW_parseType_in_tffTypedAtom3213_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_parseType_in_tffTypedAtom3213	= { FOLLOW_parseType_in_tffTypedAtom3213_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffUnitaryFormula_in_tffLogicFormula3247  */
static	ANTLR3_BITWORD FOLLOW_tffUnitaryFormula_in_tffLogicFormula3247_bits[]	= { ANTLR3_UINT64_LIT(0x0000790018000022) };
static  ANTLR3_BITSET_LIST FOLLOW_tffUnitaryFormula_in_tffLogicFormula3247	= { FOLLOW_tffUnitaryFormula_in_tffLogicFormula3247_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_fofBinaryNonAssoc_in_tffLogicFormula3265  */
static	ANTLR3_BITWORD FOLLOW_fofBinaryNonAssoc_in_tffLogicFormula3265_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_fofBinaryNonAssoc_in_tffLogicFormula3265	= { FOLLOW_fofBinaryNonAssoc_in_tffLogicFormula3265_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffUnitaryFormula_in_tffLogicFormula3268  */
static	ANTLR3_BITWORD FOLLOW_tffUnitaryFormula_in_tffLogicFormula3268_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tffUnitaryFormula_in_tffLogicFormula3268	= { FOLLOW_tffUnitaryFormula_in_tffLogicFormula3268_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_TOK_in_tffLogicFormula3316  */
static	ANTLR3_BITWORD FOLLOW_AND_TOK_in_tffLogicFormula3316_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_TOK_in_tffLogicFormula3316	= { FOLLOW_AND_TOK_in_tffLogicFormula3316_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffUnitaryFormula_in_tffLogicFormula3318  */
static	ANTLR3_BITWORD FOLLOW_tffUnitaryFormula_in_tffLogicFormula3318_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000022) };
static  ANTLR3_BITSET_LIST FOLLOW_tffUnitaryFormula_in_tffLogicFormula3318	= { FOLLOW_tffUnitaryFormula_in_tffLogicFormula3318_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_TOK_in_tffLogicFormula3371  */
static	ANTLR3_BITWORD FOLLOW_OR_TOK_in_tffLogicFormula3371_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_TOK_in_tffLogicFormula3371	= { FOLLOW_OR_TOK_in_tffLogicFormula3371_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffUnitaryFormula_in_tffLogicFormula3373  */
static	ANTLR3_BITWORD FOLLOW_tffUnitaryFormula_in_tffLogicFormula3373_bits[]	= { ANTLR3_UINT64_LIT(0x0000010000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tffUnitaryFormula_in_tffLogicFormula3373	= { FOLLOW_tffUnitaryFormula_in_tffLogicFormula3373_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomicFormula_in_tffUnitaryFormula3423  */
static	ANTLR3_BITWORD FOLLOW_atomicFormula_in_tffUnitaryFormula3423_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomicFormula_in_tffUnitaryFormula3423	= { FOLLOW_atomicFormula_in_tffUnitaryFormula3423_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3430  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3430_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3430	= { FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3430_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLogicFormula_in_tffUnitaryFormula3432  */
static	ANTLR3_BITWORD FOLLOW_tffLogicFormula_in_tffUnitaryFormula3432_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLogicFormula_in_tffUnitaryFormula3432	= { FOLLOW_tffLogicFormula_in_tffUnitaryFormula3432_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3435  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3435_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3435	= { FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3435_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_tffUnitaryFormula3441  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_tffUnitaryFormula3441_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_tffUnitaryFormula3441	= { FOLLOW_NOT_TOK_in_tffUnitaryFormula3441_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffUnitaryFormula_in_tffUnitaryFormula3443  */
static	ANTLR3_BITWORD FOLLOW_tffUnitaryFormula_in_tffUnitaryFormula3443_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tffUnitaryFormula_in_tffUnitaryFormula3443	= { FOLLOW_tffUnitaryFormula_in_tffUnitaryFormula3443_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_folQuantifier_in_tffUnitaryFormula3457  */
static	ANTLR3_BITWORD FOLLOW_folQuantifier_in_tffUnitaryFormula3457_bits[]	= { ANTLR3_UINT64_LIT(0x0000000080000000) };
static  ANTLR3_BITSET_LIST FOLLOW_folQuantifier_in_tffUnitaryFormula3457	= { FOLLOW_folQuantifier_in_tffUnitaryFormula3457_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACK_TOK_in_tffUnitaryFormula3460  */
static	ANTLR3_BITWORD FOLLOW_LBRACK_TOK_in_tffUnitaryFormula3460_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACK_TOK_in_tffUnitaryFormula3460	= { FOLLOW_LBRACK_TOK_in_tffUnitaryFormula3460_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffbindvariable_in_tffUnitaryFormula3470  */
static	ANTLR3_BITWORD FOLLOW_tffbindvariable_in_tffUnitaryFormula3470_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_tffbindvariable_in_tffUnitaryFormula3470	= { FOLLOW_tffbindvariable_in_tffUnitaryFormula3470_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_tffUnitaryFormula3483  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_tffUnitaryFormula3483_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_tffUnitaryFormula3483	= { FOLLOW_COMMA_TOK_in_tffUnitaryFormula3483_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffbindvariable_in_tffUnitaryFormula3485  */
static	ANTLR3_BITWORD FOLLOW_tffbindvariable_in_tffUnitaryFormula3485_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_tffbindvariable_in_tffUnitaryFormula3485	= { FOLLOW_tffbindvariable_in_tffUnitaryFormula3485_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACK_TOK_in_tffUnitaryFormula3495  */
static	ANTLR3_BITWORD FOLLOW_RBRACK_TOK_in_tffUnitaryFormula3495_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACK_TOK_in_tffUnitaryFormula3495	= { FOLLOW_RBRACK_TOK_in_tffUnitaryFormula3495_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_TOK_in_tffUnitaryFormula3501  */
static	ANTLR3_BITWORD FOLLOW_COLON_TOK_in_tffUnitaryFormula3501_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_TOK_in_tffUnitaryFormula3501	= { FOLLOW_COLON_TOK_in_tffUnitaryFormula3501_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffUnitaryFormula_in_tffUnitaryFormula3503  */
static	ANTLR3_BITWORD FOLLOW_tffUnitaryFormula_in_tffUnitaryFormula3503_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tffUnitaryFormula_in_tffUnitaryFormula3503	= { FOLLOW_tffUnitaryFormula_in_tffUnitaryFormula3503_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_72_in_tffUnitaryFormula3516  */
static	ANTLR3_BITWORD FOLLOW_72_in_tffUnitaryFormula3516_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_72_in_tffUnitaryFormula3516	= { FOLLOW_72_in_tffUnitaryFormula3516_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3518  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3518_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3518	= { FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3518_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLogicFormula_in_tffUnitaryFormula3520  */
static	ANTLR3_BITWORD FOLLOW_tffLogicFormula_in_tffUnitaryFormula3520_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLogicFormula_in_tffUnitaryFormula3520	= { FOLLOW_tffLogicFormula_in_tffUnitaryFormula3520_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_tffUnitaryFormula3523  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_tffUnitaryFormula3523_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_tffUnitaryFormula3523	= { FOLLOW_COMMA_TOK_in_tffUnitaryFormula3523_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLogicFormula_in_tffUnitaryFormula3525  */
static	ANTLR3_BITWORD FOLLOW_tffLogicFormula_in_tffUnitaryFormula3525_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLogicFormula_in_tffUnitaryFormula3525	= { FOLLOW_tffLogicFormula_in_tffUnitaryFormula3525_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_tffUnitaryFormula3528  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_tffUnitaryFormula3528_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_tffUnitaryFormula3528	= { FOLLOW_COMMA_TOK_in_tffUnitaryFormula3528_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLogicFormula_in_tffUnitaryFormula3530  */
static	ANTLR3_BITWORD FOLLOW_tffLogicFormula_in_tffUnitaryFormula3530_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLogicFormula_in_tffUnitaryFormula3530	= { FOLLOW_tffLogicFormula_in_tffUnitaryFormula3530_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3533  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3533_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3533	= { FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3533_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_78_in_tffUnitaryFormula3545  */
static	ANTLR3_BITWORD FOLLOW_78_in_tffUnitaryFormula3545_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_78_in_tffUnitaryFormula3545	= { FOLLOW_78_in_tffUnitaryFormula3545_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3547  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3547_bits[]	= { ANTLR3_UINT64_LIT(0x2922004E26020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3547	= { FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3547_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLetTermDefn_in_tffUnitaryFormula3555  */
static	ANTLR3_BITWORD FOLLOW_tffLetTermDefn_in_tffUnitaryFormula3555_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLetTermDefn_in_tffUnitaryFormula3555	= { FOLLOW_tffLetTermDefn_in_tffUnitaryFormula3555_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_tffUnitaryFormula3558  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_tffUnitaryFormula3558_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_tffUnitaryFormula3558	= { FOLLOW_COMMA_TOK_in_tffUnitaryFormula3558_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffFormula_in_tffUnitaryFormula3564  */
static	ANTLR3_BITWORD FOLLOW_tffFormula_in_tffUnitaryFormula3564_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_tffFormula_in_tffUnitaryFormula3564	= { FOLLOW_tffFormula_in_tffUnitaryFormula3564_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3577  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3577_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3577	= { FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3577_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_76_in_tffUnitaryFormula3583  */
static	ANTLR3_BITWORD FOLLOW_76_in_tffUnitaryFormula3583_bits[]	= { ANTLR3_UINT64_LIT(0x0000000800000000) };
static  ANTLR3_BITSET_LIST FOLLOW_76_in_tffUnitaryFormula3583	= { FOLLOW_76_in_tffUnitaryFormula3583_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3585  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3585_bits[]	= { ANTLR3_UINT64_LIT(0x2D22014E37020220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3585	= { FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3585_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLetFormulaDefn_in_tffUnitaryFormula3593  */
static	ANTLR3_BITWORD FOLLOW_tffLetFormulaDefn_in_tffUnitaryFormula3593_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000800) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLetFormulaDefn_in_tffUnitaryFormula3593	= { FOLLOW_tffLetFormulaDefn_in_tffUnitaryFormula3593_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_tffUnitaryFormula3596  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_tffUnitaryFormula3596_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_tffUnitaryFormula3596	= { FOLLOW_COMMA_TOK_in_tffUnitaryFormula3596_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffFormula_in_tffUnitaryFormula3602  */
static	ANTLR3_BITWORD FOLLOW_tffFormula_in_tffUnitaryFormula3602_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_tffFormula_in_tffUnitaryFormula3602	= { FOLLOW_tffFormula_in_tffUnitaryFormula3602_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3615  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3615_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3615	= { FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3615_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_tffLetTermDefn3635  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_tffLetTermDefn3635_bits[]	= { ANTLR3_UINT64_LIT(0x0000000080000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_tffLetTermDefn3635	= { FOLLOW_FORALL_TOK_in_tffLetTermDefn3635_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACK_TOK_in_tffLetTermDefn3637  */
static	ANTLR3_BITWORD FOLLOW_LBRACK_TOK_in_tffLetTermDefn3637_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACK_TOK_in_tffLetTermDefn3637	= { FOLLOW_LBRACK_TOK_in_tffLetTermDefn3637_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffVariableList_in_tffLetTermDefn3639  */
static	ANTLR3_BITWORD FOLLOW_tffVariableList_in_tffLetTermDefn3639_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_tffVariableList_in_tffLetTermDefn3639	= { FOLLOW_tffVariableList_in_tffLetTermDefn3639_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACK_TOK_in_tffLetTermDefn3642  */
static	ANTLR3_BITWORD FOLLOW_RBRACK_TOK_in_tffLetTermDefn3642_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACK_TOK_in_tffLetTermDefn3642	= { FOLLOW_RBRACK_TOK_in_tffLetTermDefn3642_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_TOK_in_tffLetTermDefn3644  */
static	ANTLR3_BITWORD FOLLOW_COLON_TOK_in_tffLetTermDefn3644_bits[]	= { ANTLR3_UINT64_LIT(0x2922004E26020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_TOK_in_tffLetTermDefn3644	= { FOLLOW_COLON_TOK_in_tffLetTermDefn3644_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLetTermBinding_in_tffLetTermDefn3652  */
static	ANTLR3_BITWORD FOLLOW_tffLetTermBinding_in_tffLetTermDefn3652_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLetTermBinding_in_tffLetTermDefn3652	= { FOLLOW_tffLetTermBinding_in_tffLetTermDefn3652_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_tffLetTermBinding3667  */
static	ANTLR3_BITWORD FOLLOW_term_in_tffLetTermBinding3667_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_tffLetTermBinding3667	= { FOLLOW_term_in_tffLetTermBinding3667_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_tffLetTermBinding3670  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_tffLetTermBinding3670_bits[]	= { ANTLR3_UINT64_LIT(0x2922004622020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_tffLetTermBinding3670	= { FOLLOW_EQUAL_TOK_in_tffLetTermBinding3670_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_tffLetTermBinding3672  */
static	ANTLR3_BITWORD FOLLOW_term_in_tffLetTermBinding3672_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_tffLetTermBinding3672	= { FOLLOW_term_in_tffLetTermBinding3672_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_tffLetTermBinding3683  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_tffLetTermBinding3683_bits[]	= { ANTLR3_UINT64_LIT(0x2922004E22020200), ANTLR3_UINT64_LIT(0x00000000FBFFA20B) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_tffLetTermBinding3683	= { FOLLOW_LPAREN_TOK_in_tffLetTermBinding3683_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLetTermBinding_in_tffLetTermBinding3685  */
static	ANTLR3_BITWORD FOLLOW_tffLetTermBinding_in_tffLetTermBinding3685_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLetTermBinding_in_tffLetTermBinding3685	= { FOLLOW_tffLetTermBinding_in_tffLetTermBinding3685_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_tffLetTermBinding3688  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_tffLetTermBinding3688_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_tffLetTermBinding3688	= { FOLLOW_RPAREN_TOK_in_tffLetTermBinding3688_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_tffLetFormulaDefn3708  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_tffLetFormulaDefn3708_bits[]	= { ANTLR3_UINT64_LIT(0x0000000080000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_tffLetFormulaDefn3708	= { FOLLOW_FORALL_TOK_in_tffLetFormulaDefn3708_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACK_TOK_in_tffLetFormulaDefn3710  */
static	ANTLR3_BITWORD FOLLOW_LBRACK_TOK_in_tffLetFormulaDefn3710_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACK_TOK_in_tffLetFormulaDefn3710	= { FOLLOW_LBRACK_TOK_in_tffLetFormulaDefn3710_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffVariableList_in_tffLetFormulaDefn3712  */
static	ANTLR3_BITWORD FOLLOW_tffVariableList_in_tffLetFormulaDefn3712_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_tffVariableList_in_tffLetFormulaDefn3712	= { FOLLOW_tffVariableList_in_tffLetFormulaDefn3712_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACK_TOK_in_tffLetFormulaDefn3715  */
static	ANTLR3_BITWORD FOLLOW_RBRACK_TOK_in_tffLetFormulaDefn3715_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000400) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACK_TOK_in_tffLetFormulaDefn3715	= { FOLLOW_RBRACK_TOK_in_tffLetFormulaDefn3715_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_TOK_in_tffLetFormulaDefn3717  */
static	ANTLR3_BITWORD FOLLOW_COLON_TOK_in_tffLetFormulaDefn3717_bits[]	= { ANTLR3_UINT64_LIT(0x2D22014E37020220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_TOK_in_tffLetFormulaDefn3717	= { FOLLOW_COLON_TOK_in_tffLetFormulaDefn3717_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLetFormulaBinding_in_tffLetFormulaDefn3725  */
static	ANTLR3_BITWORD FOLLOW_tffLetFormulaBinding_in_tffLetFormulaDefn3725_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLetFormulaBinding_in_tffLetFormulaDefn3725	= { FOLLOW_tffLetFormulaBinding_in_tffLetFormulaDefn3725_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomicFormula_in_tffLetFormulaBinding3741  */
static	ANTLR3_BITWORD FOLLOW_atomicFormula_in_tffLetFormulaBinding3741_bits[]	= { ANTLR3_UINT64_LIT(0x0000000008000000) };
static  ANTLR3_BITSET_LIST FOLLOW_atomicFormula_in_tffLetFormulaBinding3741	= { FOLLOW_atomicFormula_in_tffLetFormulaBinding3741_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IFF_TOK_in_tffLetFormulaBinding3744  */
static	ANTLR3_BITWORD FOLLOW_IFF_TOK_in_tffLetFormulaBinding3744_bits[]	= { ANTLR3_UINT64_LIT(0x2D22016E37420220), ANTLR3_UINT64_LIT(0x00000000FBFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_IFF_TOK_in_tffLetFormulaBinding3744	= { FOLLOW_IFF_TOK_in_tffLetFormulaBinding3744_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffUnitaryFormula_in_tffLetFormulaBinding3746  */
static	ANTLR3_BITWORD FOLLOW_tffUnitaryFormula_in_tffLetFormulaBinding3746_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tffUnitaryFormula_in_tffLetFormulaBinding3746	= { FOLLOW_tffUnitaryFormula_in_tffLetFormulaBinding3746_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_tffLetFormulaBinding3757  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_tffLetFormulaBinding3757_bits[]	= { ANTLR3_UINT64_LIT(0x2D22014E33020220), ANTLR3_UINT64_LIT(0x00000000FBFFAEFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_tffLetFormulaBinding3757	= { FOLLOW_LPAREN_TOK_in_tffLetFormulaBinding3757_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffLetFormulaBinding_in_tffLetFormulaBinding3759  */
static	ANTLR3_BITWORD FOLLOW_tffLetFormulaBinding_in_tffLetFormulaBinding3759_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_tffLetFormulaBinding_in_tffLetFormulaBinding3759	= { FOLLOW_tffLetFormulaBinding_in_tffLetFormulaBinding3759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_tffLetFormulaBinding3762  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_tffLetFormulaBinding3762_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_tffLetFormulaBinding3762	= { FOLLOW_RPAREN_TOK_in_tffLetFormulaBinding3762_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UPPER_WORD_in_thfBindVariable3781  */
static	ANTLR3_BITWORD FOLLOW_UPPER_WORD_in_thfBindVariable3781_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000402) };
static  ANTLR3_BITSET_LIST FOLLOW_UPPER_WORD_in_thfBindVariable3781	= { FOLLOW_UPPER_WORD_in_thfBindVariable3781_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_TOK_in_thfBindVariable3795  */
static	ANTLR3_BITWORD FOLLOW_COLON_TOK_in_thfBindVariable3795_bits[]	= { ANTLR3_UINT64_LIT(0x0922000EA2004200) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_TOK_in_thfBindVariable3795	= { FOLLOW_COLON_TOK_in_thfBindVariable3795_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parseThfType_in_thfBindVariable3797  */
static	ANTLR3_BITWORD FOLLOW_parseThfType_in_thfBindVariable3797_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_parseThfType_in_thfBindVariable3797	= { FOLLOW_parseThfType_in_thfBindVariable3797_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UPPER_WORD_in_tffbindvariable3827  */
static	ANTLR3_BITWORD FOLLOW_UPPER_WORD_in_tffbindvariable3827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000402) };
static  ANTLR3_BITSET_LIST FOLLOW_UPPER_WORD_in_tffbindvariable3827	= { FOLLOW_UPPER_WORD_in_tffbindvariable3827_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_TOK_in_tffbindvariable3835  */
static	ANTLR3_BITWORD FOLLOW_COLON_TOK_in_tffbindvariable3835_bits[]	= { ANTLR3_UINT64_LIT(0x0922000E22004200) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_TOK_in_tffbindvariable3835	= { FOLLOW_COLON_TOK_in_tffbindvariable3835_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parseType_in_tffbindvariable3837  */
static	ANTLR3_BITWORD FOLLOW_parseType_in_tffbindvariable3837_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_parseType_in_tffbindvariable3837	= { FOLLOW_parseType_in_tffbindvariable3837_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffbindvariable_in_tffVariableList3868  */
static	ANTLR3_BITWORD FOLLOW_tffbindvariable_in_tffVariableList3868_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000802) };
static  ANTLR3_BITSET_LIST FOLLOW_tffbindvariable_in_tffVariableList3868	= { FOLLOW_tffbindvariable_in_tffVariableList3868_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_tffVariableList3879  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_tffVariableList3879_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_tffVariableList3879	= { FOLLOW_COMMA_TOK_in_tffVariableList3879_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tffbindvariable_in_tffVariableList3881  */
static	ANTLR3_BITWORD FOLLOW_tffbindvariable_in_tffVariableList3881_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000802) };
static  ANTLR3_BITSET_LIST FOLLOW_tffbindvariable_in_tffVariableList3881	= { FOLLOW_tffbindvariable_in_tffVariableList3881_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfType_in_parseThfType3907  */
static	ANTLR3_BITWORD FOLLOW_thfType_in_parseThfType3907_bits[]	= { ANTLR3_UINT64_LIT(0x0200000000000082) };
static  ANTLR3_BITSET_LIST FOLLOW_thfType_in_parseThfType3907	= { FOLLOW_thfType_in_parseThfType3907_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_parseThfType3923  */
static	ANTLR3_BITWORD FOLLOW_set_in_parseThfType3923_bits[]	= { ANTLR3_UINT64_LIT(0x0922000EA2004200) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_parseThfType3923	= { FOLLOW_set_in_parseThfType3923_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_thfType_in_parseThfType3931  */
static	ANTLR3_BITWORD FOLLOW_thfType_in_parseThfType3931_bits[]	= { ANTLR3_UINT64_LIT(0x0200000000000082) };
static  ANTLR3_BITSET_LIST FOLLOW_thfType_in_parseThfType3931	= { FOLLOW_thfType_in_parseThfType3931_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleType_in_thfType3962  */
static	ANTLR3_BITWORD FOLLOW_simpleType_in_thfType3962_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleType_in_thfType3962	= { FOLLOW_simpleType_in_thfType3962_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_thfType3971  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_thfType3971_bits[]	= { ANTLR3_UINT64_LIT(0x0922000EA2004200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_thfType3971	= { FOLLOW_LPAREN_TOK_in_thfType3971_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parseThfType_in_thfType3973  */
static	ANTLR3_BITWORD FOLLOW_parseThfType_in_thfType3973_bits[]	= { ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_parseThfType_in_thfType3973	= { FOLLOW_parseThfType_in_thfType3973_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_thfType3976  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_thfType3976_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_thfType3976	= { FOLLOW_RPAREN_TOK_in_thfType3976_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACK_TOK_in_thfType3984  */
static	ANTLR3_BITWORD FOLLOW_LBRACK_TOK_in_thfType3984_bits[]	= { ANTLR3_UINT64_LIT(0x0922000EA2004200) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACK_TOK_in_thfType3984	= { FOLLOW_LBRACK_TOK_in_thfType3984_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parseThfType_in_thfType3988  */
static	ANTLR3_BITWORD FOLLOW_parseThfType_in_thfType3988_bits[]	= { ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_parseThfType_in_thfType3988	= { FOLLOW_parseThfType_in_thfType3988_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACK_TOK_in_thfType3991  */
static	ANTLR3_BITWORD FOLLOW_RBRACK_TOK_in_thfType3991_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACK_TOK_in_thfType3991	= { FOLLOW_RBRACK_TOK_in_thfType3991_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleType_in_parseType4010  */
static	ANTLR3_BITWORD FOLLOW_simpleType_in_parseType4010_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleType_in_parseType4010	= { FOLLOW_simpleType_in_parseType4010_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleType_in_parseType4019  */
static	ANTLR3_BITWORD FOLLOW_simpleType_in_parseType4019_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleType_in_parseType4019	= { FOLLOW_simpleType_in_parseType4019_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseType4030  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseType4030_bits[]	= { ANTLR3_UINT64_LIT(0x0922000622004200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseType4030	= { FOLLOW_LPAREN_TOK_in_parseType4030_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleType_in_parseType4032  */
static	ANTLR3_BITWORD FOLLOW_simpleType_in_parseType4032_bits[]	= { ANTLR3_UINT64_LIT(0x0200000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleType_in_parseType4032	= { FOLLOW_simpleType_in_parseType4032_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TIMES_TOK_in_parseType4045  */
static	ANTLR3_BITWORD FOLLOW_TIMES_TOK_in_parseType4045_bits[]	= { ANTLR3_UINT64_LIT(0x0922000622004200) };
static  ANTLR3_BITSET_LIST FOLLOW_TIMES_TOK_in_parseType4045	= { FOLLOW_TIMES_TOK_in_parseType4045_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleType_in_parseType4047  */
static	ANTLR3_BITWORD FOLLOW_simpleType_in_parseType4047_bits[]	= { ANTLR3_UINT64_LIT(0x0200800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleType_in_parseType4047	= { FOLLOW_simpleType_in_parseType4047_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseType4061  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseType4061_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000080) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseType4061	= { FOLLOW_RPAREN_TOK_in_parseType4061_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARROW_TOK_in_parseType4073  */
static	ANTLR3_BITWORD FOLLOW_ARROW_TOK_in_parseType4073_bits[]	= { ANTLR3_UINT64_LIT(0x0922000622004200) };
static  ANTLR3_BITSET_LIST FOLLOW_ARROW_TOK_in_parseType4073	= { FOLLOW_ARROW_TOK_in_parseType4073_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleType_in_parseType4075  */
static	ANTLR3_BITWORD FOLLOW_simpleType_in_parseType4075_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleType_in_parseType4075	= { FOLLOW_simpleType_in_parseType4075_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINED_SYMBOL_in_simpleType4102  */
static	ANTLR3_BITWORD FOLLOW_DEFINED_SYMBOL_in_simpleType4102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINED_SYMBOL_in_simpleType4102	= { FOLLOW_DEFINED_SYMBOL_in_simpleType4102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomicWord_in_simpleType4114  */
static	ANTLR3_BITWORD FOLLOW_atomicWord_in_simpleType4114_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomicWord_in_simpleType4114	= { FOLLOW_atomicWord_in_simpleType4114_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_anything4139  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_anything4139_bits[]	= { ANTLR3_UINT64_LIT(0x2F22FB7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_anything4139	= { FOLLOW_LPAREN_TOK_in_anything4139_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_anything_in_anything4141  */
static	ANTLR3_BITWORD FOLLOW_anything_in_anything4141_bits[]	= { ANTLR3_UINT64_LIT(0x2F22FB7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_anything_in_anything4141	= { FOLLOW_anything_in_anything4141_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_anything4144  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_anything4144_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_anything4144	= { FOLLOW_RPAREN_TOK_in_anything4144_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACK_TOK_in_anything4150  */
static	ANTLR3_BITWORD FOLLOW_LBRACK_TOK_in_anything4150_bits[]	= { ANTLR3_UINT64_LIT(0x2F227F7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACK_TOK_in_anything4150	= { FOLLOW_LBRACK_TOK_in_anything4150_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_anything_in_anything4152  */
static	ANTLR3_BITWORD FOLLOW_anything_in_anything4152_bits[]	= { ANTLR3_UINT64_LIT(0x2F227F7EBF6B4E20) };
static  ANTLR3_BITSET_LIST FOLLOW_anything_in_anything4152	= { FOLLOW_anything_in_anything4152_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACK_TOK_in_anything4155  */
static	ANTLR3_BITWORD FOLLOW_RBRACK_TOK_in_anything4155_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACK_TOK_in_anything4155	= { FOLLOW_RBRACK_TOK_in_anything4155_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_TOK_in_anything4161  */
static	ANTLR3_BITWORD FOLLOW_COMMA_TOK_in_anything4161_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_TOK_in_anything4161	= { FOLLOW_COMMA_TOK_in_anything4161_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_TOK_in_anything4167  */
static	ANTLR3_BITWORD FOLLOW_DOT_TOK_in_anything4167_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_TOK_in_anything4167	= { FOLLOW_DOT_TOK_in_anything4167_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_TOK_in_anything4173  */
static	ANTLR3_BITWORD FOLLOW_COLON_TOK_in_anything4173_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_TOK_in_anything4173	= { FOLLOW_COLON_TOK_in_anything4173_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_TOK_in_anything4179  */
static	ANTLR3_BITWORD FOLLOW_OR_TOK_in_anything4179_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_TOK_in_anything4179	= { FOLLOW_OR_TOK_in_anything4179_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_anything4185  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_anything4185_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_anything4185	= { FOLLOW_NOT_TOK_in_anything4185_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_anything4191  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_anything4191_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_anything4191	= { FOLLOW_FORALL_TOK_in_anything4191_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXISTS_TOK_in_anything4197  */
static	ANTLR3_BITWORD FOLLOW_EXISTS_TOK_in_anything4197_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXISTS_TOK_in_anything4197	= { FOLLOW_EXISTS_TOK_in_anything4197_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_TOK_in_anything4203  */
static	ANTLR3_BITWORD FOLLOW_AND_TOK_in_anything4203_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_TOK_in_anything4203	= { FOLLOW_AND_TOK_in_anything4203_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IFF_TOK_in_anything4209  */
static	ANTLR3_BITWORD FOLLOW_IFF_TOK_in_anything4209_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IFF_TOK_in_anything4209	= { FOLLOW_IFF_TOK_in_anything4209_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IMPLIES_TOK_in_anything4215  */
static	ANTLR3_BITWORD FOLLOW_IMPLIES_TOK_in_anything4215_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IMPLIES_TOK_in_anything4215	= { FOLLOW_IMPLIES_TOK_in_anything4215_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REVIMPLIES_TOK_in_anything4221  */
static	ANTLR3_BITWORD FOLLOW_REVIMPLIES_TOK_in_anything4221_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REVIMPLIES_TOK_in_anything4221	= { FOLLOW_REVIMPLIES_TOK_in_anything4221_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REVIFF_TOK_in_anything4227  */
static	ANTLR3_BITWORD FOLLOW_REVIFF_TOK_in_anything4227_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REVIFF_TOK_in_anything4227	= { FOLLOW_REVIFF_TOK_in_anything4227_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REVOR_TOK_in_anything4233  */
static	ANTLR3_BITWORD FOLLOW_REVOR_TOK_in_anything4233_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REVOR_TOK_in_anything4233	= { FOLLOW_REVOR_TOK_in_anything4233_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REVAND_TOK_in_anything4239  */
static	ANTLR3_BITWORD FOLLOW_REVAND_TOK_in_anything4239_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REVAND_TOK_in_anything4239	= { FOLLOW_REVAND_TOK_in_anything4239_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TIMES_TOK_in_anything4245  */
static	ANTLR3_BITWORD FOLLOW_TIMES_TOK_in_anything4245_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TIMES_TOK_in_anything4245	= { FOLLOW_TIMES_TOK_in_anything4245_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PLUS_TOK_in_anything4251  */
static	ANTLR3_BITWORD FOLLOW_PLUS_TOK_in_anything4251_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_PLUS_TOK_in_anything4251	= { FOLLOW_PLUS_TOK_in_anything4251_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_anything4257  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_anything4257_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_anything4257	= { FOLLOW_MINUS_TOK_in_anything4257_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUE_TOK_in_anything4263  */
static	ANTLR3_BITWORD FOLLOW_TRUE_TOK_in_anything4263_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUE_TOK_in_anything4263	= { FOLLOW_TRUE_TOK_in_anything4263_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSE_TOK_in_anything4269  */
static	ANTLR3_BITWORD FOLLOW_FALSE_TOK_in_anything4269_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSE_TOK_in_anything4269	= { FOLLOW_FALSE_TOK_in_anything4269_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_anything4275  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_anything4275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_anything4275	= { FOLLOW_EQUAL_TOK_in_anything4275_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISEQUAL_TOK_in_anything4281  */
static	ANTLR3_BITWORD FOLLOW_DISEQUAL_TOK_in_anything4281_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DISEQUAL_TOK_in_anything4281	= { FOLLOW_DISEQUAL_TOK_in_anything4281_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CNF_TOK_in_anything4287  */
static	ANTLR3_BITWORD FOLLOW_CNF_TOK_in_anything4287_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CNF_TOK_in_anything4287	= { FOLLOW_CNF_TOK_in_anything4287_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FOF_TOK_in_anything4293  */
static	ANTLR3_BITWORD FOLLOW_FOF_TOK_in_anything4293_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FOF_TOK_in_anything4293	= { FOLLOW_FOF_TOK_in_anything4293_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_THF_TOK_in_anything4299  */
static	ANTLR3_BITWORD FOLLOW_THF_TOK_in_anything4299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_THF_TOK_in_anything4299	= { FOLLOW_THF_TOK_in_anything4299_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TFF_TOK_in_anything4305  */
static	ANTLR3_BITWORD FOLLOW_TFF_TOK_in_anything4305_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TFF_TOK_in_anything4305	= { FOLLOW_TFF_TOK_in_anything4305_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_anything4311  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_anything4311_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_anything4311	= { FOLLOW_TYPE_TOK_in_anything4311_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDE_TOK_in_anything4317  */
static	ANTLR3_BITWORD FOLLOW_INCLUDE_TOK_in_anything4317_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDE_TOK_in_anything4317	= { FOLLOW_INCLUDE_TOK_in_anything4317_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISTINCT_OBJECT_in_anything4323  */
static	ANTLR3_BITWORD FOLLOW_DISTINCT_OBJECT_in_anything4323_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DISTINCT_OBJECT_in_anything4323	= { FOLLOW_DISTINCT_OBJECT_in_anything4323_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UPPER_WORD_in_anything4329  */
static	ANTLR3_BITWORD FOLLOW_UPPER_WORD_in_anything4329_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UPPER_WORD_in_anything4329	= { FOLLOW_UPPER_WORD_in_anything4329_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LOWER_WORD_in_anything4335  */
static	ANTLR3_BITWORD FOLLOW_LOWER_WORD_in_anything4335_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LOWER_WORD_in_anything4335	= { FOLLOW_LOWER_WORD_in_anything4335_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_anything4341  */
static	ANTLR3_BITWORD FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_anything4341_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_anything4341	= { FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_anything4341_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SINGLE_QUOTED_in_anything4347  */
static	ANTLR3_BITWORD FOLLOW_SINGLE_QUOTED_in_anything4347_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SINGLE_QUOTED_in_anything4347	= { FOLLOW_SINGLE_QUOTED_in_anything4347_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_anything4353  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_anything4353_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_anything4353	= { FOLLOW_NUMBER_in_anything4353_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINED_SYMBOL_in_anything4359  */
static	ANTLR3_BITWORD FOLLOW_DEFINED_SYMBOL_in_anything4359_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINED_SYMBOL_in_anything4359	= { FOLLOW_DEFINED_SYMBOL_in_anything4359_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_unquotedFileName5039  */
static	ANTLR3_BITWORD FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_unquotedFileName5039_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_unquotedFileName5039	= { FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_unquotedFileName5039_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SINGLE_QUOTED_in_unquotedFileName5045  */
static	ANTLR3_BITWORD FOLLOW_SINGLE_QUOTED_in_unquotedFileName5045_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SINGLE_QUOTED_in_unquotedFileName5045	= { FOLLOW_SINGLE_QUOTED_in_unquotedFileName5045_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_atomicWord_in_nameN5064  */
static	ANTLR3_BITWORD FOLLOW_atomicWord_in_nameN5064_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_atomicWord_in_nameN5064	= { FOLLOW_atomicWord_in_nameN5064_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NUMBER_in_nameN5070  */
static	ANTLR3_BITWORD FOLLOW_NUMBER_in_nameN5070_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NUMBER_in_nameN5070	= { FOLLOW_NUMBER_in_nameN5070_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FOF_TOK_in_atomicWord5086  */
static	ANTLR3_BITWORD FOLLOW_FOF_TOK_in_atomicWord5086_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FOF_TOK_in_atomicWord5086	= { FOLLOW_FOF_TOK_in_atomicWord5086_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CNF_TOK_in_atomicWord5097  */
static	ANTLR3_BITWORD FOLLOW_CNF_TOK_in_atomicWord5097_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CNF_TOK_in_atomicWord5097	= { FOLLOW_CNF_TOK_in_atomicWord5097_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_THF_TOK_in_atomicWord5108  */
static	ANTLR3_BITWORD FOLLOW_THF_TOK_in_atomicWord5108_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_THF_TOK_in_atomicWord5108	= { FOLLOW_THF_TOK_in_atomicWord5108_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TFF_TOK_in_atomicWord5119  */
static	ANTLR3_BITWORD FOLLOW_TFF_TOK_in_atomicWord5119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TFF_TOK_in_atomicWord5119	= { FOLLOW_TFF_TOK_in_atomicWord5119_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_atomicWord5130  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_atomicWord5130_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_atomicWord5130	= { FOLLOW_TYPE_TOK_in_atomicWord5130_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDE_TOK_in_atomicWord5140  */
static	ANTLR3_BITWORD FOLLOW_INCLUDE_TOK_in_atomicWord5140_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDE_TOK_in_atomicWord5140	= { FOLLOW_INCLUDE_TOK_in_atomicWord5140_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LOWER_WORD_in_atomicWord5147  */
static	ANTLR3_BITWORD FOLLOW_LOWER_WORD_in_atomicWord5147_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LOWER_WORD_in_atomicWord5147	= { FOLLOW_LOWER_WORD_in_atomicWord5147_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_atomicWord5155  */
static	ANTLR3_BITWORD FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_atomicWord5155_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_atomicWord5155	= { FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_atomicWord5155_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SINGLE_QUOTED_in_atomicWord5167  */
static	ANTLR3_BITWORD FOLLOW_SINGLE_QUOTED_in_atomicWord5167_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SINGLE_QUOTED_in_atomicWord5167	= { FOLLOW_SINGLE_QUOTED_in_atomicWord5167_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start parseExpr
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:135:1: parseExpr returns [CVC4::parser::tptp::myExpr expr] : ( cnfFormula[expr] | EOF );
 */
static CVC4::parser::tptp::myExpr
parseExpr(pTptpParser ctx)
{
    CVC4::parser::tptp::myExpr expr;


    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:136:3: ( cnfFormula[expr] | EOF )

            ANTLR3_UINT32 alt1;

            alt1=2;

            switch ( LA(1) )
            {
            case AND_TOK:
            case CNF_TOK:
            case DISTINCT_OBJECT:
            case FALSE_TOK:
            case FOF_TOK:
            case IMPLIES_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case LPAREN_TOK:
            case NOT_TOK:
            case NUMBER:
            case OR_TOK:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TRUE_TOK:
            case TYPE_TOK:
            case UPPER_WORD:
            case 64:
            case 65:
            case 66:
            case 67:
            case 68:
            case 69:
            case 70:
            case 71:
            case 73:
            case 74:
            case 75:
            case 77:
            case 79:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt1=1;
            	}
                break;
            case EOF:
            	{
            		alt1=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleparseExprEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:136:5: cnfFormula[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_cnfFormula_in_parseExpr114);
        	        cnfFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:137:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseExpr121);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseExprEx; /* Prevent compiler warnings */
    ruleparseExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return expr;
}
/* $ANTLR end parseExpr */

/**
 * $ANTLR start parseCommand
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:144:1: parseCommand returns [CVC4::Command* cmd = NULL] : ( CNF_TOK LPAREN_TOK nameN[name] COMMA_TOK formulaRole[fr] COMMA_TOK cnfFormula[expr] ( COMMA_TOK ( anything )* )? RPAREN_TOK DOT_TOK | FOF_TOK LPAREN_TOK nameN[name] COMMA_TOK formulaRole[fr] COMMA_TOK fofFormula[expr] ( COMMA_TOK ( anything )* )? RPAREN_TOK DOT_TOK | TFF_TOK LPAREN_TOK nameN[name] COMMA_TOK ( TYPE_TOK COMMA_TOK tffTypedAtom[cmd] | formulaRole[fr] COMMA_TOK tffFormula[expr] ( COMMA_TOK ( anything )* )? ) RPAREN_TOK DOT_TOK | THF_TOK LPAREN_TOK nameN[name] COMMA_TOK ( TYPE_TOK COMMA_TOK thfAtomTyping[cmd] | formulaRole[fr] COMMA_TOK thfLogicFormula[p] ( COMMA_TOK ( anything )* )? ) RPAREN_TOK DOT_TOK | INCLUDE_TOK LPAREN_TOK unquotedFileName[name] ( COMMA_TOK LBRACK_TOK nameN[inclSymbol] ( COMMA_TOK nameN[inclSymbol] )* RBRACK_TOK )? RPAREN_TOK DOT_TOK | EOF );
 */
static CVC4::Command*
parseCommand(pTptpParser ctx)
{
    CVC4::Command* cmd;



      CVC4::api::Term expr;
      Tptp::FormulaRole fr;
      std::string name, inclSymbol;
      ParseOp p;

    /* Initialize rule variables
     */
    cmd =  NULL;


    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:151:3: ( CNF_TOK LPAREN_TOK nameN[name] COMMA_TOK formulaRole[fr] COMMA_TOK cnfFormula[expr] ( COMMA_TOK ( anything )* )? RPAREN_TOK DOT_TOK | FOF_TOK LPAREN_TOK nameN[name] COMMA_TOK formulaRole[fr] COMMA_TOK fofFormula[expr] ( COMMA_TOK ( anything )* )? RPAREN_TOK DOT_TOK | TFF_TOK LPAREN_TOK nameN[name] COMMA_TOK ( TYPE_TOK COMMA_TOK tffTypedAtom[cmd] | formulaRole[fr] COMMA_TOK tffFormula[expr] ( COMMA_TOK ( anything )* )? ) RPAREN_TOK DOT_TOK | THF_TOK LPAREN_TOK nameN[name] COMMA_TOK ( TYPE_TOK COMMA_TOK thfAtomTyping[cmd] | formulaRole[fr] COMMA_TOK thfLogicFormula[p] ( COMMA_TOK ( anything )* )? ) RPAREN_TOK DOT_TOK | INCLUDE_TOK LPAREN_TOK unquotedFileName[name] ( COMMA_TOK LBRACK_TOK nameN[inclSymbol] ( COMMA_TOK nameN[inclSymbol] )* RBRACK_TOK )? RPAREN_TOK DOT_TOK | EOF )

            ANTLR3_UINT32 alt14;

            alt14=6;

            switch ( LA(1) )
            {
            case CNF_TOK:
            	{
            		alt14=1;
            	}
                break;
            case FOF_TOK:
            	{
            		alt14=2;
            	}
                break;
            case TFF_TOK:
            	{
            		alt14=3;
            	}
                break;
            case THF_TOK:
            	{
            		alt14=4;
            	}
                break;
            case INCLUDE_TOK:
            	{
            		alt14=5;
            	}
                break;
            case EOF:
            	{
            		alt14=6;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 14;
                EXCEPTION->state        = 0;


                goto ruleparseCommandEx;

            }

            switch (alt14)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:151:5: CNF_TOK LPAREN_TOK nameN[name] COMMA_TOK formulaRole[fr] COMMA_TOK cnfFormula[expr] ( COMMA_TOK ( anything )* )? RPAREN_TOK DOT_TOK
        	    {
        	         MATCHT(CNF_TOK, &FOLLOW_CNF_TOK_in_parseCommand145);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand147);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_nameN_in_parseCommand149);
        	        nameN(ctx, name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand152);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_formulaRole_in_parseCommand154);
        	        formulaRole(ctx, fr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand157);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        {
        	             PARSER_STATE->setCnf(true);
        	                PARSER_STATE->setFof(false);
        	                PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_cnfFormula_in_parseCommand167);
        	        cnfFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                std::vector<api::Term> bvl = PARSER_STATE->getFreeVar();
        	                if(!bvl.empty()) {
        	                  expr = MK_TERM(api::FORALL,MK_TERM(api::BOUND_VAR_LIST,bvl),expr);
        	                };
        	              
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:162:5: ( COMMA_TOK ( anything )* )?
        	        {
        	            int alt3=2;
        	            switch ( LA(1) )
        	            {
        	                case COMMA_TOK:
        	                	{
        	                		alt3=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt3)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:162:6: COMMA_TOK ( anything )*
        	        	    {
        	        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand179);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:162:16: ( anything )*

        	        	        for (;;)
        	        	        {
        	        	            int alt2=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case AND_TOK:
        	        	            case CNF_TOK:
        	        	            case COLON_TOK:
        	        	            case COMMA_TOK:
        	        	            case DEFINED_SYMBOL:
        	        	            case DISEQUAL_TOK:
        	        	            case DISTINCT_OBJECT:
        	        	            case DOT_TOK:
        	        	            case EQUAL_TOK:
        	        	            case EXISTS_TOK:
        	        	            case FALSE_TOK:
        	        	            case FOF_TOK:
        	        	            case FORALL_TOK:
        	        	            case IFF_TOK:
        	        	            case IMPLIES_TOK:
        	        	            case INCLUDE_TOK:
        	        	            case LBRACK_TOK:
        	        	            case LOWER_WORD:
        	        	            case LOWER_WORD_SINGLE_QUOTED:
        	        	            case LPAREN_TOK:
        	        	            case MINUS_TOK:
        	        	            case NOT_TOK:
        	        	            case NUMBER:
        	        	            case OR_TOK:
        	        	            case PLUS_TOK:
        	        	            case REVAND_TOK:
        	        	            case REVIFF_TOK:
        	        	            case REVIMPLIES_TOK:
        	        	            case REVOR_TOK:
        	        	            case SINGLE_QUOTED:
        	        	            case TFF_TOK:
        	        	            case THF_TOK:
        	        	            case TIMES_TOK:
        	        	            case TRUE_TOK:
        	        	            case TYPE_TOK:
        	        	            case UPPER_WORD:
        	        	            	{
        	        	            		alt2=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt2)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:162:16: anything
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_anything_in_parseCommand181);
        	        	        	        anything(ctx);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto ruleparseCommandEx;
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop2;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop2: ; /* Jump out to here if this rule does not match */


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand186);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(DOT_TOK, &FOLLOW_DOT_TOK_in_parseCommand188);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        {

        	                  CVC4::api::Term aexpr = PARSER_STATE->getAssertionExpr(fr,expr);
        	                  if( !aexpr.isNull() ){
        	                    // set the expression name (e.g. used with unsat core printing)
        	                    Command* csen = new SetExpressionNameCommand(aexpr.getExpr(), name);
        	                    csen->setMuted(true);
        	                    PARSER_STATE->preemptCommand(csen);
        	                  }
        	                  // make the command to assert the formula
        	                  cmd = PARSER_STATE->makeAssertCommand(fr, aexpr, /* cnf == */ true, true);
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:174:5: FOF_TOK LPAREN_TOK nameN[name] COMMA_TOK formulaRole[fr] COMMA_TOK fofFormula[expr] ( COMMA_TOK ( anything )* )? RPAREN_TOK DOT_TOK
        	    {
        	         MATCHT(FOF_TOK, &FOLLOW_FOF_TOK_in_parseCommand200);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand202);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_nameN_in_parseCommand204);
        	        nameN(ctx, name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand207);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_formulaRole_in_parseCommand209);
        	        formulaRole(ctx, fr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand212);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        {
        	             PARSER_STATE->setCnf(false); PARSER_STATE->setFof(true); 
        	        }


        	        FOLLOWPUSH(FOLLOW_fofFormula_in_parseCommand224);
        	        fofFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:176:22: ( COMMA_TOK ( anything )* )?
        	        {
        	            int alt5=2;
        	            switch ( LA(1) )
        	            {
        	                case COMMA_TOK:
        	                	{
        	                		alt5=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt5)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:176:23: COMMA_TOK ( anything )*
        	        	    {
        	        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand228);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:176:33: ( anything )*

        	        	        for (;;)
        	        	        {
        	        	            int alt4=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case AND_TOK:
        	        	            case CNF_TOK:
        	        	            case COLON_TOK:
        	        	            case COMMA_TOK:
        	        	            case DEFINED_SYMBOL:
        	        	            case DISEQUAL_TOK:
        	        	            case DISTINCT_OBJECT:
        	        	            case DOT_TOK:
        	        	            case EQUAL_TOK:
        	        	            case EXISTS_TOK:
        	        	            case FALSE_TOK:
        	        	            case FOF_TOK:
        	        	            case FORALL_TOK:
        	        	            case IFF_TOK:
        	        	            case IMPLIES_TOK:
        	        	            case INCLUDE_TOK:
        	        	            case LBRACK_TOK:
        	        	            case LOWER_WORD:
        	        	            case LOWER_WORD_SINGLE_QUOTED:
        	        	            case LPAREN_TOK:
        	        	            case MINUS_TOK:
        	        	            case NOT_TOK:
        	        	            case NUMBER:
        	        	            case OR_TOK:
        	        	            case PLUS_TOK:
        	        	            case REVAND_TOK:
        	        	            case REVIFF_TOK:
        	        	            case REVIMPLIES_TOK:
        	        	            case REVOR_TOK:
        	        	            case SINGLE_QUOTED:
        	        	            case TFF_TOK:
        	        	            case THF_TOK:
        	        	            case TIMES_TOK:
        	        	            case TRUE_TOK:
        	        	            case TYPE_TOK:
        	        	            case UPPER_WORD:
        	        	            	{
        	        	            		alt4=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt4)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:176:33: anything
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_anything_in_parseCommand230);
        	        	        	        anything(ctx);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto ruleparseCommandEx;
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop4;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop4: ; /* Jump out to here if this rule does not match */


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand235);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(DOT_TOK, &FOLLOW_DOT_TOK_in_parseCommand237);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        {

        	                  CVC4::api::Term aexpr = PARSER_STATE->getAssertionExpr(fr,expr);
        	                  if( !aexpr.isNull() ){
        	                    // set the expression name (e.g. used with unsat core printing)
        	                    Command* csen = new SetExpressionNameCommand(aexpr.getExpr(), name);
        	                    csen->setMuted(true);
        	                    PARSER_STATE->preemptCommand(csen);
        	                  }
        	                  // make the command to assert the formula
        	                  cmd = PARSER_STATE->makeAssertCommand(fr, aexpr, /* cnf == */ false, true);
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:188:5: TFF_TOK LPAREN_TOK nameN[name] COMMA_TOK ( TYPE_TOK COMMA_TOK tffTypedAtom[cmd] | formulaRole[fr] COMMA_TOK tffFormula[expr] ( COMMA_TOK ( anything )* )? ) RPAREN_TOK DOT_TOK
        	    {
        	         MATCHT(TFF_TOK, &FOLLOW_TFF_TOK_in_parseCommand249);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand251);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_nameN_in_parseCommand253);
        	        nameN(ctx, name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand256);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:189:5: ( TYPE_TOK COMMA_TOK tffTypedAtom[cmd] | formulaRole[fr] COMMA_TOK tffFormula[expr] ( COMMA_TOK ( anything )* )? )
        	        {
        	            int alt8=2;
        	            switch ( LA(1) )
        	            {
        	            case TYPE_TOK:
        	            	{
        	            		alt8=1;
        	            	}
        	                break;
        	            case LOWER_WORD:
        	            	{
        	            		alt8=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 8;
        	                EXCEPTION->state        = 0;


        	                goto ruleparseCommandEx;

        	            }

        	            switch (alt8)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:189:7: TYPE_TOK COMMA_TOK tffTypedAtom[cmd]
        	        	    {
        	        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_parseCommand264);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand266);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_tffTypedAtom_in_parseCommand268);
        	        	        tffTypedAtom(ctx, cmd);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:190:7: formulaRole[fr] COMMA_TOK tffFormula[expr] ( COMMA_TOK ( anything )* )?
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_formulaRole_in_parseCommand277);
        	        	        formulaRole(ctx, fr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand280);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->setCnf(false); PARSER_STATE->setFof(false); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_tffFormula_in_parseCommand296);
        	        	        tffFormula(ctx, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:192:24: ( COMMA_TOK ( anything )* )?
        	        	        {
        	        	            int alt7=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	                case COMMA_TOK:
        	        	                	{
        	        	                		alt7=1;
        	        	                	}
        	        	                    break;
        	        	            }

        	        	            switch (alt7)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:192:25: COMMA_TOK ( anything )*
        	        	        	    {
        	        	        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand300);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto ruleparseCommandEx;
        	        	        	        }


        	        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:192:35: ( anything )*

        	        	        	        for (;;)
        	        	        	        {
        	        	        	            int alt6=2;
        	        	        	            switch ( LA(1) )
        	        	        	            {
        	        	        	            case AND_TOK:
        	        	        	            case CNF_TOK:
        	        	        	            case COLON_TOK:
        	        	        	            case COMMA_TOK:
        	        	        	            case DEFINED_SYMBOL:
        	        	        	            case DISEQUAL_TOK:
        	        	        	            case DISTINCT_OBJECT:
        	        	        	            case DOT_TOK:
        	        	        	            case EQUAL_TOK:
        	        	        	            case EXISTS_TOK:
        	        	        	            case FALSE_TOK:
        	        	        	            case FOF_TOK:
        	        	        	            case FORALL_TOK:
        	        	        	            case IFF_TOK:
        	        	        	            case IMPLIES_TOK:
        	        	        	            case INCLUDE_TOK:
        	        	        	            case LBRACK_TOK:
        	        	        	            case LOWER_WORD:
        	        	        	            case LOWER_WORD_SINGLE_QUOTED:
        	        	        	            case LPAREN_TOK:
        	        	        	            case MINUS_TOK:
        	        	        	            case NOT_TOK:
        	        	        	            case NUMBER:
        	        	        	            case OR_TOK:
        	        	        	            case PLUS_TOK:
        	        	        	            case REVAND_TOK:
        	        	        	            case REVIFF_TOK:
        	        	        	            case REVIMPLIES_TOK:
        	        	        	            case REVOR_TOK:
        	        	        	            case SINGLE_QUOTED:
        	        	        	            case TFF_TOK:
        	        	        	            case THF_TOK:
        	        	        	            case TIMES_TOK:
        	        	        	            case TRUE_TOK:
        	        	        	            case TYPE_TOK:
        	        	        	            case UPPER_WORD:
        	        	        	            	{
        	        	        	            		alt6=1;
        	        	        	            	}
        	        	        	                break;

        	        	        	            }

        	        	        	            switch (alt6)
        	        	        	            {
        	        	        	        	case 1:
        	        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:192:35: anything
        	        	        	        	    {
        	        	        	        	        FOLLOWPUSH(FOLLOW_anything_in_parseCommand302);
        	        	        	        	        anything(ctx);

        	        	        	        	        FOLLOWPOP();
        	        	        	        	        if  (HASEXCEPTION())
        	        	        	        	        {
        	        	        	        	            goto ruleparseCommandEx;
        	        	        	        	        }


        	        	        	        	    }
        	        	        	        	    break;

        	        	        	        	default:
        	        	        	        	    goto loop6;	/* break out of the loop */
        	        	        	        	    break;
        	        	        	            }
        	        	        	        }
        	        	        	        loop6: ; /* Jump out to here if this rule does not match */


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        {

        	        	                    CVC4::api::Term aexpr = PARSER_STATE->getAssertionExpr(fr,expr);
        	        	                    if( !aexpr.isNull() ){
        	        	                      // set the expression name (e.g. used with unsat core printing)
        	        	                      Command* csen = new SetExpressionNameCommand(aexpr.getExpr(), name);
        	        	                      csen->setMuted(true);
        	        	                      PARSER_STATE->preemptCommand(csen);
        	        	                    }
        	        	                    // make the command to assert the formula
        	        	                    cmd = PARSER_STATE->makeAssertCommand(fr, aexpr, /* cnf == */ false, true);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand321);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(DOT_TOK, &FOLLOW_DOT_TOK_in_parseCommand323);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:205:5: THF_TOK LPAREN_TOK nameN[name] COMMA_TOK ( TYPE_TOK COMMA_TOK thfAtomTyping[cmd] | formulaRole[fr] COMMA_TOK thfLogicFormula[p] ( COMMA_TOK ( anything )* )? ) RPAREN_TOK DOT_TOK
        	    {
        	         MATCHT(THF_TOK, &FOLLOW_THF_TOK_in_parseCommand329);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand331);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_nameN_in_parseCommand333);
        	        nameN(ctx, name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand336);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:208:5: ( TYPE_TOK COMMA_TOK thfAtomTyping[cmd] | formulaRole[fr] COMMA_TOK thfLogicFormula[p] ( COMMA_TOK ( anything )* )? )
        	        {
        	            int alt11=2;
        	            switch ( LA(1) )
        	            {
        	            case TYPE_TOK:
        	            	{
        	            		alt11=1;
        	            	}
        	                break;
        	            case LOWER_WORD:
        	            	{
        	            		alt11=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 11;
        	                EXCEPTION->state        = 0;


        	                goto ruleparseCommandEx;

        	            }

        	            switch (alt11)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:208:7: TYPE_TOK COMMA_TOK thfAtomTyping[cmd]
        	        	    {
        	        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_parseCommand354);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand356);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_thfAtomTyping_in_parseCommand358);
        	        	        thfAtomTyping(ctx, cmd);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:209:7: formulaRole[fr] COMMA_TOK thfLogicFormula[p] ( COMMA_TOK ( anything )* )?
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_formulaRole_in_parseCommand367);
        	        	        formulaRole(ctx, fr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand370);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	        {
        	        	             PARSER_STATE->setCnf(false); PARSER_STATE->setFof(false); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_thfLogicFormula_in_parseCommand386);
        	        	        thfLogicFormula(ctx, p);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:211:26: ( COMMA_TOK ( anything )* )?
        	        	        {
        	        	            int alt10=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	                case COMMA_TOK:
        	        	                	{
        	        	                		alt10=1;
        	        	                	}
        	        	                    break;
        	        	            }

        	        	            switch (alt10)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:211:27: COMMA_TOK ( anything )*
        	        	        	    {
        	        	        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand390);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto ruleparseCommandEx;
        	        	        	        }


        	        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:211:37: ( anything )*

        	        	        	        for (;;)
        	        	        	        {
        	        	        	            int alt9=2;
        	        	        	            switch ( LA(1) )
        	        	        	            {
        	        	        	            case AND_TOK:
        	        	        	            case CNF_TOK:
        	        	        	            case COLON_TOK:
        	        	        	            case COMMA_TOK:
        	        	        	            case DEFINED_SYMBOL:
        	        	        	            case DISEQUAL_TOK:
        	        	        	            case DISTINCT_OBJECT:
        	        	        	            case DOT_TOK:
        	        	        	            case EQUAL_TOK:
        	        	        	            case EXISTS_TOK:
        	        	        	            case FALSE_TOK:
        	        	        	            case FOF_TOK:
        	        	        	            case FORALL_TOK:
        	        	        	            case IFF_TOK:
        	        	        	            case IMPLIES_TOK:
        	        	        	            case INCLUDE_TOK:
        	        	        	            case LBRACK_TOK:
        	        	        	            case LOWER_WORD:
        	        	        	            case LOWER_WORD_SINGLE_QUOTED:
        	        	        	            case LPAREN_TOK:
        	        	        	            case MINUS_TOK:
        	        	        	            case NOT_TOK:
        	        	        	            case NUMBER:
        	        	        	            case OR_TOK:
        	        	        	            case PLUS_TOK:
        	        	        	            case REVAND_TOK:
        	        	        	            case REVIFF_TOK:
        	        	        	            case REVIMPLIES_TOK:
        	        	        	            case REVOR_TOK:
        	        	        	            case SINGLE_QUOTED:
        	        	        	            case TFF_TOK:
        	        	        	            case THF_TOK:
        	        	        	            case TIMES_TOK:
        	        	        	            case TRUE_TOK:
        	        	        	            case TYPE_TOK:
        	        	        	            case UPPER_WORD:
        	        	        	            	{
        	        	        	            		alt9=1;
        	        	        	            	}
        	        	        	                break;

        	        	        	            }

        	        	        	            switch (alt9)
        	        	        	            {
        	        	        	        	case 1:
        	        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:211:37: anything
        	        	        	        	    {
        	        	        	        	        FOLLOWPUSH(FOLLOW_anything_in_parseCommand392);
        	        	        	        	        anything(ctx);

        	        	        	        	        FOLLOWPOP();
        	        	        	        	        if  (HASEXCEPTION())
        	        	        	        	        {
        	        	        	        	            goto ruleparseCommandEx;
        	        	        	        	        }


        	        	        	        	    }
        	        	        	        	    break;

        	        	        	        	default:
        	        	        	        	    goto loop9;	/* break out of the loop */
        	        	        	        	    break;
        	        	        	            }
        	        	        	        }
        	        	        	        loop9: ; /* Jump out to here if this rule does not match */


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        {

        	        	                    if (p.d_expr.isNull())
        	        	                    {
        	        	                      PARSER_STATE->parseError("Top level expression must be a formula");
        	        	                    }
        	        	                    expr = p.d_expr;
        	        	                    CVC4::api::Term aexpr = PARSER_STATE->getAssertionExpr(fr, expr);
        	        	                    if (!aexpr.isNull())
        	        	                    {
        	        	                      // set the expression name (e.g. used with unsat core printing)
        	        	                      Command* csen = new SetExpressionNameCommand(aexpr.getExpr(), name);
        	        	                      csen->setMuted(true);
        	        	                      PARSER_STATE->preemptCommand(csen);
        	        	                    }
        	        	                    // make the command to assert the formula
        	        	                    cmd = PARSER_STATE->makeAssertCommand(
        	        	                        fr, aexpr, /* cnf == */ false, true);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand411);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(DOT_TOK, &FOLLOW_DOT_TOK_in_parseCommand413);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:231:5: INCLUDE_TOK LPAREN_TOK unquotedFileName[name] ( COMMA_TOK LBRACK_TOK nameN[inclSymbol] ( COMMA_TOK nameN[inclSymbol] )* RBRACK_TOK )? RPAREN_TOK DOT_TOK
        	    {
        	         MATCHT(INCLUDE_TOK, &FOLLOW_INCLUDE_TOK_in_parseCommand419);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand421);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_unquotedFileName_in_parseCommand423);
        	        unquotedFileName(ctx, name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:232:5: ( COMMA_TOK LBRACK_TOK nameN[inclSymbol] ( COMMA_TOK nameN[inclSymbol] )* RBRACK_TOK )?
        	        {
        	            int alt13=2;
        	            switch ( LA(1) )
        	            {
        	                case COMMA_TOK:
        	                	{
        	                		alt13=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt13)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:232:7: COMMA_TOK LBRACK_TOK nameN[inclSymbol] ( COMMA_TOK nameN[inclSymbol] )* RBRACK_TOK
        	        	    {
        	        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand432);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	         MATCHT(LBRACK_TOK, &FOLLOW_LBRACK_TOK_in_parseCommand434);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_nameN_in_parseCommand436);
        	        	        nameN(ctx, inclSymbol);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:233:7: ( COMMA_TOK nameN[inclSymbol] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt12=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA_TOK:
        	        	            	{
        	        	            		alt12=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt12)
        	        	            {
        	        	        	case 1:
        	        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:233:9: COMMA_TOK nameN[inclSymbol]
        	        	        	    {
        	        	        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_parseCommand447);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto ruleparseCommandEx;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_nameN_in_parseCommand449);
        	        	        	        nameN(ctx, inclSymbol);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto ruleparseCommandEx;
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop12;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop12: ; /* Jump out to here if this rule does not match */


        	        	         MATCHT(RBRACK_TOK, &FOLLOW_RBRACK_TOK_in_parseCommand455);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseCommandEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand464);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	         MATCHT(DOT_TOK, &FOLLOW_DOT_TOK_in_parseCommand466);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        {
        	             /* TODO - implement symbol filtering for file inclusion.
        	                   * the following removes duplicates and "all", just need to pass it
        	                   * through to includeFile() and implement it there.
        	                  std::sort(inclArgs.begin(), inclArgs.end());
        	                  std::vector<std::string>::iterator it =
        	                    std::unique(inclArgs.begin(), inclArgs.end());
        	                  inclArgs.resize(std::distance(inclArgs.begin(), it));
        	                  it = std::lower_bound(inclArgs.begin(), inclArgs.end(), std::string("all"));
        	                  if(it != inclArgs.end() && *it == "all") {
        	                    inclArgs.erase(it);
        	                  }
        	                  */
        	                  PARSER_STATE->includeFile(name /* , inclArgs */ );
        	                  // The command of the included file will be produced at the next parseCommand() call
        	                  cmd = new EmptyCommand("include::" + name);
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:251:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseCommand478);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }


        	        {

        	                  CommandSequence* seq = new CommandSequence();
        	                  // assert that all distinct constants are distinct
        	                  CVC4::api::Term aexpr = PARSER_STATE->getAssertionDistinctConstants();
        	                  if( !aexpr.isNull() )
        	                  {
        	                    seq->addCommand(new AssertCommand(aexpr.getExpr(), false));
        	                  }

        	                  std::string filename = PARSER_STATE->getInput()->getInputStreamName();
        	                  size_t i = filename.find_last_of('/');
        	                  if(i != std::string::npos) {
        	                    filename = filename.substr(i + 1);
        	                  }
        	                  if(filename.substr(filename.length() - 2) == ".p") {
        	                    filename = filename.substr(0, filename.length() - 2);
        	                  }
        	                  seq->addCommand(new SetInfoCommand("filename", SExpr(filename)));
        	                  if(PARSER_STATE->hasConjecture()) {
        	                    seq->addCommand(new QueryCommand(SOLVER->mkFalse().getExpr()));
        	                  } else {
        	                    seq->addCommand(new CheckSatCommand());
        	                  }
        	                  PARSER_STATE->preemptCommand(seq);
        	                  cmd = NULL;
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseCommandEx; /* Prevent compiler warnings */
    ruleparseCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return cmd;
}
/* $ANTLR end parseCommand */

/**
 * $ANTLR start formulaRole
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:281:1: formulaRole[CVC4::parser::Tptp::FormulaRole& role] : LOWER_WORD ;
 */
static void
formulaRole(pTptpParser ctx, CVC4::parser::Tptp::FormulaRole& role)
{
    pANTLR3_COMMON_TOKEN    LOWER_WORD1;

    /* Initialize rule variables
     */

    LOWER_WORD1       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:282:3: ( LOWER_WORD )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:282:5: LOWER_WORD
        {
            LOWER_WORD1 = (pANTLR3_COMMON_TOKEN) MATCHT(LOWER_WORD, &FOLLOW_LOWER_WORD_in_formulaRole500);
            if  (HASEXCEPTION())
            {
                goto ruleformulaRoleEx;
            }


            {

                      std::string r = AntlrInput::tokenText(LOWER_WORD1);
                      if      (r == "axiom")              role = Tptp::FR_AXIOM;
                      else if (r == "hypothesis")         role = Tptp::FR_HYPOTHESIS;
                      else if (r == "definition")         role = Tptp::FR_DEFINITION;
                      else if (r == "assumption")         role = Tptp::FR_ASSUMPTION;
                      else if (r == "lemma")              role = Tptp::FR_LEMMA;
                      else if (r == "theorem")            role = Tptp::FR_THEOREM;
                      else if (r == "negated_conjecture") role = Tptp::FR_NEGATED_CONJECTURE;
                      else if (r == "conjecture")         role = Tptp::FR_CONJECTURE;
                      else if (r == "unknown")            role = Tptp::FR_UNKNOWN;
                      else if (r == "plain")              role = Tptp::FR_PLAIN;
                      else if (r == "fi_domain")          role = Tptp::FR_FI_DOMAIN;
                      else if (r == "fi_functor")         role = Tptp::FR_FI_FUNCTORS;
                      else if (r == "fi_predicate")       role = Tptp::FR_FI_PREDICATES;
                      else if (r == "type")               role = Tptp::FR_TYPE;
                      else PARSER_STATE->parseError("Invalid formula role: " + r);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleformulaRoleEx; /* Prevent compiler warnings */
    ruleformulaRoleEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end formulaRole */

/**
 * $ANTLR start cnfFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:309:1: cnfFormula[CVC4::api::Term& expr] : ( LPAREN_TOK cnfDisjunction[expr] RPAREN_TOK | cnfDisjunction[expr] );
 */
static void
cnfFormula(pTptpParser ctx, CVC4::api::Term& expr)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:310:3: ( LPAREN_TOK cnfDisjunction[expr] RPAREN_TOK | cnfDisjunction[expr] )

            ANTLR3_UINT32 alt15;

            alt15=2;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		alt15=1;
            	}
                break;
            case AND_TOK:
            case CNF_TOK:
            case DISTINCT_OBJECT:
            case FALSE_TOK:
            case FOF_TOK:
            case IMPLIES_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case NOT_TOK:
            case NUMBER:
            case OR_TOK:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TRUE_TOK:
            case TYPE_TOK:
            case UPPER_WORD:
            case 64:
            case 65:
            case 66:
            case 67:
            case 68:
            case 69:
            case 70:
            case 71:
            case 73:
            case 74:
            case 75:
            case 77:
            case 79:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt15=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 15;
                EXCEPTION->state        = 0;


                goto rulecnfFormulaEx;

            }

            switch (alt15)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:310:5: LPAREN_TOK cnfDisjunction[expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_cnfFormula528);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecnfFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_cnfDisjunction_in_cnfFormula530);
        	        cnfDisjunction(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecnfFormulaEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_cnfFormula533);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecnfFormulaEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:311:5: cnfDisjunction[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_cnfDisjunction_in_cnfFormula539);
        	        cnfDisjunction(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecnfFormulaEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulecnfFormulaEx; /* Prevent compiler warnings */
    rulecnfFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end cnfFormula */

/**
 * $ANTLR start cnfDisjunction
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:314:1: cnfDisjunction[CVC4::api::Term& expr] : cnfLiteral[expr] ( OR_TOK cnfLiteral[expr] )* ;
 */
static void
cnfDisjunction(pTptpParser ctx, CVC4::api::Term& expr)
{

      std::vector<api::Term> args;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:318:3: ( cnfLiteral[expr] ( OR_TOK cnfLiteral[expr] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:318:5: cnfLiteral[expr] ( OR_TOK cnfLiteral[expr] )*
        {
            FOLLOWPUSH(FOLLOW_cnfLiteral_in_cnfDisjunction557);
            cnfLiteral(ctx, expr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulecnfDisjunctionEx;
            }


            {
                 args.push_back(expr); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:319:5: ( OR_TOK cnfLiteral[expr] )*

            for (;;)
            {
                int alt16=2;
                switch ( LA(1) )
                {
                case OR_TOK:
                	{
                		alt16=1;
                	}
                    break;

                }

                switch (alt16)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:319:7: OR_TOK cnfLiteral[expr]
            	    {
            	         MATCHT(OR_TOK, &FOLLOW_OR_TOK_in_cnfDisjunction568);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecnfDisjunctionEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_cnfLiteral_in_cnfDisjunction570);
            	        cnfLiteral(ctx, expr);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecnfDisjunctionEx;
            	        }


            	        {
            	             args.push_back(expr); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop16;	/* break out of the loop */
            	    break;
                }
            }
            loop16: ; /* Jump out to here if this rule does not match */


            {
                 if(args.size() > 1) {
                        expr = MK_TERM(api::OR, args);
                      } // else its already in the expr
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulecnfDisjunctionEx; /* Prevent compiler warnings */
    rulecnfDisjunctionEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end cnfDisjunction */

/**
 * $ANTLR start cnfLiteral
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:326:1: cnfLiteral[CVC4::api::Term& expr] : ( atomicFormula[expr] | NOT_TOK atomicFormula[expr] );
 */
static void
cnfLiteral(pTptpParser ctx, CVC4::api::Term& expr)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:327:3: ( atomicFormula[expr] | NOT_TOK atomicFormula[expr] )

            ANTLR3_UINT32 alt17;

            alt17=2;

            switch ( LA(1) )
            {
            case AND_TOK:
            case CNF_TOK:
            case DISTINCT_OBJECT:
            case FALSE_TOK:
            case FOF_TOK:
            case IMPLIES_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case NUMBER:
            case OR_TOK:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TRUE_TOK:
            case TYPE_TOK:
            case UPPER_WORD:
            case 64:
            case 65:
            case 66:
            case 67:
            case 68:
            case 69:
            case 70:
            case 71:
            case 73:
            case 74:
            case 75:
            case 77:
            case 79:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt17=1;
            	}
                break;
            case NOT_TOK:
            	{
            		alt17=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 17;
                EXCEPTION->state        = 0;


                goto rulecnfLiteralEx;

            }

            switch (alt17)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:327:5: atomicFormula[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_atomicFormula_in_cnfLiteral594);
        	        atomicFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecnfLiteralEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:328:5: NOT_TOK atomicFormula[expr]
        	    {
        	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_cnfLiteral601);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecnfLiteralEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_atomicFormula_in_cnfLiteral603);
        	        atomicFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecnfLiteralEx;
        	        }


        	        {
        	             expr = MK_TERM(api::NOT, expr); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulecnfLiteralEx; /* Prevent compiler warnings */
    rulecnfLiteralEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end cnfLiteral */

/**
 * $ANTLR start atomicFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:331:1: atomicFormula[CVC4::api::Term& expr] : ( atomicWord[p.d_name] ( LPAREN_TOK arguments[args] RPAREN_TOK )? ( equalOp[equal] term[expr2] |) | definedFun[p] ( LPAREN_TOK arguments[args] RPAREN_TOK equalOp[equal] term[expr2] ) | ( simpleTerm[expr] | letTerm[expr] | conditionalTerm[expr] ) ( equalOp[equal] term[expr2] )? | definedPred[p] ( LPAREN_TOK arguments[args] RPAREN_TOK ) | definedProp[expr] );
 */
static void
atomicFormula(pTptpParser ctx, CVC4::api::Term& expr)
{

      CVC4::api::Term expr2;
      std::string name;
      std::vector<CVC4::api::Term> args;
      bool equal;
      ParseOp p;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:339:3: ( atomicWord[p.d_name] ( LPAREN_TOK arguments[args] RPAREN_TOK )? ( equalOp[equal] term[expr2] |) | definedFun[p] ( LPAREN_TOK arguments[args] RPAREN_TOK equalOp[equal] term[expr2] ) | ( simpleTerm[expr] | letTerm[expr] | conditionalTerm[expr] ) ( equalOp[equal] term[expr2] )? | definedPred[p] ( LPAREN_TOK arguments[args] RPAREN_TOK ) | definedProp[expr] )

            ANTLR3_UINT32 alt22;

            alt22=5;

            switch ( LA(1) )
            {
            case CNF_TOK:
            case FOF_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TYPE_TOK:
            	{
            		alt22=1;
            	}
                break;
            case 64:
            case 65:
            case 67:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt22=2;
            	}
                break;
            case DISTINCT_OBJECT:
            case NUMBER:
            case UPPER_WORD:
            case 73:
            case 77:
            case 79:
            	{
            		alt22=3;
            	}
                break;
            case AND_TOK:
            case IMPLIES_TOK:
            case OR_TOK:
            case 66:
            case 68:
            case 69:
            case 70:
            case 71:
            case 74:
            case 75:
            	{
            		alt22=4;
            	}
                break;
            case FALSE_TOK:
            case TRUE_TOK:
            	{
            		alt22=5;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 22;
                EXCEPTION->state        = 0;


                goto ruleatomicFormulaEx;

            }

            switch (alt22)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:339:5: atomicWord[p.d_name] ( LPAREN_TOK arguments[args] RPAREN_TOK )? ( equalOp[equal] term[expr2] |)
        	    {
        	        FOLLOWPUSH(FOLLOW_atomicWord_in_atomicFormula625);
        	        atomicWord(ctx, p.d_name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicFormulaEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:339:26: ( LPAREN_TOK arguments[args] RPAREN_TOK )?
        	        {
        	            int alt18=2;
        	            switch ( LA(1) )
        	            {
        	                case LPAREN_TOK:
        	                	{
        	                		alt18=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt18)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:339:27: LPAREN_TOK arguments[args] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_atomicFormula629);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleatomicFormulaEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_arguments_in_atomicFormula631);
        	        	        arguments(ctx, args);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleatomicFormulaEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_atomicFormula634);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleatomicFormulaEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:340:5: ( equalOp[equal] term[expr2] |)
        	        {
        	            int alt19=2;
        	            switch ( LA(1) )
        	            {
        	            case DISEQUAL_TOK:
        	            case EQUAL_TOK:
        	            	{
        	            		alt19=1;
        	            	}
        	                break;
        	            case EOF:
        	            case AND_TOK:
        	            case COMMA_TOK:
        	            case IFF_TOK:
        	            case IMPLIES_TOK:
        	            case OR_TOK:
        	            case REVAND_TOK:
        	            case REVIFF_TOK:
        	            case REVIMPLIES_TOK:
        	            case REVOR_TOK:
        	            case RPAREN_TOK:
        	            	{
        	            		alt19=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 19;
        	                EXCEPTION->state        = 0;


        	                goto ruleatomicFormulaEx;

        	            }

        	            switch (alt19)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:340:7: equalOp[equal] term[expr2]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_equalOp_in_atomicFormula644);
        	        	        equalOp(ctx, equal);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleatomicFormulaEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_atomicFormula647);
        	        	        term(ctx, expr2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleatomicFormulaEx;
        	        	        }


        	        	        {
        	        	             // equality/disequality between terms
        	        	                    expr = args.empty() ? PARSER_STATE->parseOpToExpr(p)
        	        	                                        : PARSER_STATE->applyParseOp(p, args);
        	        	                    args.clear();
        	        	                    args.push_back(expr);
        	        	                    args.push_back(expr2);
        	        	                    ParseOp p1(api::EQUAL);
        	        	                    expr = PARSER_STATE->applyParseOp(p1, args);
        	        	                    if (!equal)
        	        	                    {
        	        	                      expr = MK_TERM(api::NOT, expr);
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:354:7: 
        	        	    {
        	        	        {
        	        	             // predicate
        	        	                    p.d_type = SOLVER->getBooleanSort();
        	        	                    expr = args.empty() ? PARSER_STATE->parseOpToExpr(p)
        	        	                                        : PARSER_STATE->applyParseOp(p, args);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:360:5: definedFun[p] ( LPAREN_TOK arguments[args] RPAREN_TOK equalOp[equal] term[expr2] )
        	    {
        	        FOLLOWPUSH(FOLLOW_definedFun_in_atomicFormula676);
        	        definedFun(ctx, p);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicFormulaEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:361:5: ( LPAREN_TOK arguments[args] RPAREN_TOK equalOp[equal] term[expr2] )
        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:362:6: LPAREN_TOK arguments[args] RPAREN_TOK equalOp[equal] term[expr2]
        	        {
        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_atomicFormula690);
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleatomicFormulaEx;
        	            }


        	            FOLLOWPUSH(FOLLOW_arguments_in_atomicFormula692);
        	            arguments(ctx, args);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleatomicFormulaEx;
        	            }


        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_atomicFormula695);
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleatomicFormulaEx;
        	            }


        	            FOLLOWPUSH(FOLLOW_equalOp_in_atomicFormula702);
        	            equalOp(ctx, equal);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleatomicFormulaEx;
        	            }


        	            FOLLOWPUSH(FOLLOW_term_in_atomicFormula705);
        	            term(ctx, expr2);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleatomicFormulaEx;
        	            }


        	            {

        	                       expr = PARSER_STATE->applyParseOp(p, args);
        	                       args.clear();
        	                       args.push_back(expr);
        	                       args.push_back(expr2);
        	                       ParseOp p1(api::EQUAL);
        	                       expr = PARSER_STATE->applyParseOp(p1, args);
        	                       if (!equal)
        	                       {
        	                         expr = MK_TERM(api::NOT, expr);
        	                       }
        	                     
        	            }


        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:377:5: ( simpleTerm[expr] | letTerm[expr] | conditionalTerm[expr] ) ( equalOp[equal] term[expr2] )?
        	    {
        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:377:5: ( simpleTerm[expr] | letTerm[expr] | conditionalTerm[expr] )
        	        {
        	            int alt20=3;
        	            switch ( LA(1) )
        	            {
        	            case DISTINCT_OBJECT:
        	            case NUMBER:
        	            case UPPER_WORD:
        	            	{
        	            		alt20=1;
        	            	}
        	                break;
        	            case 77:
        	            case 79:
        	            	{
        	            		alt20=2;
        	            	}
        	                break;
        	            case 73:
        	            	{
        	            		alt20=3;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 20;
        	                EXCEPTION->state        = 0;


        	                goto ruleatomicFormulaEx;

        	            }

        	            switch (alt20)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:377:6: simpleTerm[expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleTerm_in_atomicFormula726);
        	        	        simpleTerm(ctx, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleatomicFormulaEx;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:377:25: letTerm[expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_letTerm_in_atomicFormula731);
        	        	        letTerm(ctx, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleatomicFormulaEx;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:377:41: conditionalTerm[expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_conditionalTerm_in_atomicFormula736);
        	        	        conditionalTerm(ctx, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleatomicFormulaEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:378:5: ( equalOp[equal] term[expr2] )?
        	        {
        	            int alt21=2;
        	            switch ( LA(1) )
        	            {
        	                case DISEQUAL_TOK:
        	                case EQUAL_TOK:
        	                	{
        	                		alt21=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt21)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:379:7: equalOp[equal] term[expr2]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_equalOp_in_atomicFormula752);
        	        	        equalOp(ctx, equal);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleatomicFormulaEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_atomicFormula755);
        	        	        term(ctx, expr2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleatomicFormulaEx;
        	        	        }


        	        	        {
        	        	             // equality/disequality between terms
        	        	                    args.push_back(expr);
        	        	                    args.push_back(expr2);
        	        	                    p.d_kind = api::EQUAL;
        	        	                    expr = PARSER_STATE->applyParseOp(p, args);
        	        	                    if (!equal)
        	        	                    {
        	        	                      expr = MK_TERM(api::NOT, expr);
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:391:5: definedPred[p] ( LPAREN_TOK arguments[args] RPAREN_TOK )
        	    {
        	        FOLLOWPUSH(FOLLOW_definedPred_in_atomicFormula777);
        	        definedPred(ctx, p);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicFormulaEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:391:20: ( LPAREN_TOK arguments[args] RPAREN_TOK )
        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:391:21: LPAREN_TOK arguments[args] RPAREN_TOK
        	        {
        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_atomicFormula781);
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleatomicFormulaEx;
        	            }


        	            FOLLOWPUSH(FOLLOW_arguments_in_atomicFormula783);
        	            arguments(ctx, args);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleatomicFormulaEx;
        	            }


        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_atomicFormula786);
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruleatomicFormulaEx;
        	            }


        	        }


        	        {

        	                  p.d_type = SOLVER->getBooleanSort();
        	                  expr = PARSER_STATE->applyParseOp(p, args);
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:396:5: definedProp[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_definedProp_in_atomicFormula799);
        	        definedProp(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicFormulaEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleatomicFormulaEx; /* Prevent compiler warnings */
    ruleatomicFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end atomicFormula */

/**
 * $ANTLR start thfAtomicFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:399:1: thfAtomicFormula[CVC4::ParseOp& p] : ( atomicWord[p.d_name] ( LPAREN_TOK arguments[args] RPAREN_TOK )? | definedFun[p] ( LPAREN_TOK arguments[args] RPAREN_TOK equalOp[equal] term[expr2] )? | thfSimpleTerm[p.d_expr] | letTerm[p.d_expr] | conditionalTerm[p.d_expr] | thfDefinedPred[p] ( LPAREN_TOK arguments[args] RPAREN_TOK )? | definedProp[p.d_expr] );
 */
static void
thfAtomicFormula(pTptpParser ctx, CVC4::ParseOp& p)
{

      CVC4::api::Term expr2;
      std::string name;
      std::vector<CVC4::api::Term> args;
      bool equal;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:406:3: ( atomicWord[p.d_name] ( LPAREN_TOK arguments[args] RPAREN_TOK )? | definedFun[p] ( LPAREN_TOK arguments[args] RPAREN_TOK equalOp[equal] term[expr2] )? | thfSimpleTerm[p.d_expr] | letTerm[p.d_expr] | conditionalTerm[p.d_expr] | thfDefinedPred[p] ( LPAREN_TOK arguments[args] RPAREN_TOK )? | definedProp[p.d_expr] )

            ANTLR3_UINT32 alt26;

            alt26=7;

            switch ( LA(1) )
            {
            case CNF_TOK:
            case FOF_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TYPE_TOK:
            	{
            		alt26=1;
            	}
                break;
            case 64:
            case 65:
            case 67:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt26=2;
            	}
                break;
            case DISTINCT_OBJECT:
            case NUMBER:
            	{
            		alt26=3;
            	}
                break;
            case 77:
            case 79:
            	{
            		alt26=4;
            	}
                break;
            case 73:
            	{
            		alt26=5;
            	}
                break;
            case LPAREN_TOK:
            case 66:
            case 68:
            case 69:
            case 70:
            case 71:
            case 74:
            case 75:
            	{
            		alt26=6;
            	}
                break;
            case FALSE_TOK:
            case TRUE_TOK:
            	{
            		alt26=7;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 26;
                EXCEPTION->state        = 0;


                goto rulethfAtomicFormulaEx;

            }

            switch (alt26)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:406:5: atomicWord[p.d_name] ( LPAREN_TOK arguments[args] RPAREN_TOK )?
        	    {
        	        FOLLOWPUSH(FOLLOW_atomicWord_in_thfAtomicFormula819);
        	        atomicWord(ctx, p.d_name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomicFormulaEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:406:26: ( LPAREN_TOK arguments[args] RPAREN_TOK )?
        	        {
        	            int alt23=2;
        	            switch ( LA(1) )
        	            {
        	                case LPAREN_TOK:
        	                	{
        	                		alt23=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt23)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:406:27: LPAREN_TOK arguments[args] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_thfAtomicFormula823);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomicFormulaEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_arguments_in_thfAtomicFormula825);
        	        	        arguments(ctx, args);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomicFormulaEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_thfAtomicFormula828);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomicFormulaEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  p.d_expr = args.empty() ? PARSER_STATE->parseOpToExpr(p)
        	                                          : PARSER_STATE->applyParseOp(p, args);
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:411:5: definedFun[p] ( LPAREN_TOK arguments[args] RPAREN_TOK equalOp[equal] term[expr2] )?
        	    {
        	        FOLLOWPUSH(FOLLOW_definedFun_in_thfAtomicFormula842);
        	        definedFun(ctx, p);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomicFormulaEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:412:5: ( LPAREN_TOK arguments[args] RPAREN_TOK equalOp[equal] term[expr2] )?
        	        {
        	            int alt24=2;
        	            switch ( LA(1) )
        	            {
        	                case LPAREN_TOK:
        	                	{
        	                		alt24=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt24)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:413:7: LPAREN_TOK arguments[args] RPAREN_TOK equalOp[equal] term[expr2]
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_thfAtomicFormula857);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomicFormulaEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_arguments_in_thfAtomicFormula859);
        	        	        arguments(ctx, args);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomicFormulaEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_thfAtomicFormula862);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomicFormulaEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_equalOp_in_thfAtomicFormula870);
        	        	        equalOp(ctx, equal);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomicFormulaEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_thfAtomicFormula873);
        	        	        term(ctx, expr2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomicFormulaEx;
        	        	        }


        	        	        {

        	        	                    p.d_expr = PARSER_STATE->applyParseOp(p, args);
        	        	                    args.clear();
        	        	                    args.push_back(p.d_expr);
        	        	                    args.push_back(expr2);
        	        	                    ParseOp p1(api::EQUAL);
        	        	                    p.d_expr = PARSER_STATE->applyParseOp(p1, args);
        	        	                    if (!equal)
        	        	                    {
        	        	                      p.d_expr = MK_TERM(api::NOT, p.d_expr);
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:428:5: thfSimpleTerm[p.d_expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_thfSimpleTerm_in_thfAtomicFormula895);
        	        thfSimpleTerm(ctx, p.d_expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomicFormulaEx;
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:429:5: letTerm[p.d_expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_letTerm_in_thfAtomicFormula902);
        	        letTerm(ctx, p.d_expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomicFormulaEx;
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:430:5: conditionalTerm[p.d_expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_conditionalTerm_in_thfAtomicFormula909);
        	        conditionalTerm(ctx, p.d_expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomicFormulaEx;
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:431:5: thfDefinedPred[p] ( LPAREN_TOK arguments[args] RPAREN_TOK )?
        	    {
        	        FOLLOWPUSH(FOLLOW_thfDefinedPred_in_thfAtomicFormula916);
        	        thfDefinedPred(ctx, p);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomicFormulaEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:431:23: ( LPAREN_TOK arguments[args] RPAREN_TOK )?
        	        {
        	            int alt25=2;
        	            switch ( LA(1) )
        	            {
        	                case LPAREN_TOK:
        	                	{
        	                		alt25=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt25)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:431:24: LPAREN_TOK arguments[args] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_thfAtomicFormula920);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomicFormulaEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_arguments_in_thfAtomicFormula922);
        	        	        arguments(ctx, args);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomicFormulaEx;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_thfAtomicFormula925);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomicFormulaEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  p.d_type = SOLVER->getBooleanSort();
        	                  if (!args.empty())
        	                  {
        	                    p.d_expr = PARSER_STATE->applyParseOp(p, args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:439:5: definedProp[p.d_expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_definedProp_in_thfAtomicFormula939);
        	        definedProp(ctx, p.d_expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomicFormulaEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulethfAtomicFormulaEx; /* Prevent compiler warnings */
    rulethfAtomicFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end thfAtomicFormula */

/**
 * $ANTLR start definedProp
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:445:1: definedProp[CVC4::api::Term& expr] : ( TRUE_TOK | FALSE_TOK );
 */
static void
definedProp(pTptpParser ctx, CVC4::api::Term& expr)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:446:3: ( TRUE_TOK | FALSE_TOK )

            ANTLR3_UINT32 alt27;

            alt27=2;

            switch ( LA(1) )
            {
            case TRUE_TOK:
            	{
            		alt27=1;
            	}
                break;
            case FALSE_TOK:
            	{
            		alt27=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 27;
                EXCEPTION->state        = 0;


                goto ruledefinedPropEx;

            }

            switch (alt27)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:446:5: TRUE_TOK
        	    {
        	         MATCHT(TRUE_TOK, &FOLLOW_TRUE_TOK_in_definedProp957);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPropEx;
        	        }


        	        {
        	             expr = SOLVER->mkTrue(); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:447:5: FALSE_TOK
        	    {
        	         MATCHT(FALSE_TOK, &FOLLOW_FALSE_TOK_in_definedProp965);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPropEx;
        	        }


        	        {
        	             expr = SOLVER->mkFalse(); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledefinedPropEx; /* Prevent compiler warnings */
    ruledefinedPropEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end definedProp */

/**
 * $ANTLR start definedPred
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:450:1: definedPred[CVC4::ParseOp& p] : ( '$less' | '$lesseq' | '$greater' | '$greatereq' | '$is_rat' | '$is_int' | '$distinct' | AND_TOK | IMPLIES_TOK | OR_TOK );
 */
static void
definedPred(pTptpParser ctx, CVC4::ParseOp& p)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:451:3: ( '$less' | '$lesseq' | '$greater' | '$greatereq' | '$is_rat' | '$is_int' | '$distinct' | AND_TOK | IMPLIES_TOK | OR_TOK )

            ANTLR3_UINT32 alt28;

            alt28=10;

            switch ( LA(1) )
            {
            case 74:
            	{
            		alt28=1;
            	}
                break;
            case 75:
            	{
            		alt28=2;
            	}
                break;
            case 68:
            	{
            		alt28=3;
            	}
                break;
            case 69:
            	{
            		alt28=4;
            	}
                break;
            case 71:
            	{
            		alt28=5;
            	}
                break;
            case 70:
            	{
            		alt28=6;
            	}
                break;
            case 66:
            	{
            		alt28=7;
            	}
                break;
            case AND_TOK:
            	{
            		alt28=8;
            	}
                break;
            case IMPLIES_TOK:
            	{
            		alt28=9;
            	}
                break;
            case OR_TOK:
            	{
            		alt28=10;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 28;
                EXCEPTION->state        = 0;


                goto ruledefinedPredEx;

            }

            switch (alt28)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:451:5: '$less'
        	    {
        	         MATCHT(74, &FOLLOW_74_in_definedPred982);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::LT;
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:455:5: '$lesseq'
        	    {
        	         MATCHT(75, &FOLLOW_75_in_definedPred994);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::LEQ;
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:459:5: '$greater'
        	    {
        	         MATCHT(68, &FOLLOW_68_in_definedPred1006);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::GT;
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:463:5: '$greatereq'
        	    {
        	         MATCHT(69, &FOLLOW_69_in_definedPred1018);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::GEQ;
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:467:5: '$is_rat'
        	    {
        	         MATCHT(71, &FOLLOW_71_in_definedPred1030);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPredEx;
        	        }


        	        {

        	                  api::Term n = SOLVER->mkVar(SOLVER->getRealSort(), "N");
        	                  api::Term q = SOLVER->mkVar(SOLVER->getIntegerSort(), "Q");
        	                  api::Term qr = MK_TERM(api::TO_REAL, q);
        	                  api::Term r = SOLVER->mkVar(SOLVER->getIntegerSort(), "R");
        	                  api::Term rr = MK_TERM(api::TO_REAL, r);
        	                  api::Term body =
        	                      MK_TERM(api::AND,
        	                              MK_TERM(api::NOT,
        	                                      MK_TERM(api::EQUAL, r, SOLVER->mkReal(0))),
        	                              MK_TERM(api::EQUAL, qr, MK_TERM(api::MULT, n, rr)));
        	                  api::Term bvl = MK_TERM(api::BOUND_VAR_LIST, q, r);
        	                  body = MK_TERM(api::EXISTS, bvl, body);
        	                  api::Term lbvl = MK_TERM(api::BOUND_VAR_LIST, n);
        	                  p.d_kind = api::LAMBDA;
        	                  p.d_expr = MK_TERM(api::LAMBDA, lbvl, body);
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:488:5: '$is_int'
        	    {
        	         MATCHT(70, &FOLLOW_70_in_definedPred1057);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::IS_INTEGER;
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:492:5: '$distinct'
        	    {
        	         MATCHT(66, &FOLLOW_66_in_definedPred1069);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::DISTINCT;
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:496:5: AND_TOK
        	    {
        	         MATCHT(AND_TOK, &FOLLOW_AND_TOK_in_definedPred1081);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::AND;
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:500:5: IMPLIES_TOK
        	    {
        	         MATCHT(IMPLIES_TOK, &FOLLOW_IMPLIES_TOK_in_definedPred1093);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::IMPLIES;
        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:504:5: OR_TOK
        	    {
        	         MATCHT(OR_TOK, &FOLLOW_OR_TOK_in_definedPred1105);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::OR;
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledefinedPredEx; /* Prevent compiler warnings */
    ruledefinedPredEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end definedPred */

/**
 * $ANTLR start thfDefinedPred
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:510:1: thfDefinedPred[CVC4::ParseOp& p] : ( '$less' | '$lesseq' | '$greater' | '$greatereq' | '$is_rat' | '$is_int' | '$distinct' | LPAREN_TOK ( AND_TOK | OR_TOK | IMPLIES_TOK ) RPAREN_TOK );
 */
static void
thfDefinedPred(pTptpParser ctx, CVC4::ParseOp& p)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:511:3: ( '$less' | '$lesseq' | '$greater' | '$greatereq' | '$is_rat' | '$is_int' | '$distinct' | LPAREN_TOK ( AND_TOK | OR_TOK | IMPLIES_TOK ) RPAREN_TOK )

            ANTLR3_UINT32 alt30;

            alt30=8;

            switch ( LA(1) )
            {
            case 74:
            	{
            		alt30=1;
            	}
                break;
            case 75:
            	{
            		alt30=2;
            	}
                break;
            case 68:
            	{
            		alt30=3;
            	}
                break;
            case 69:
            	{
            		alt30=4;
            	}
                break;
            case 71:
            	{
            		alt30=5;
            	}
                break;
            case 70:
            	{
            		alt30=6;
            	}
                break;
            case 66:
            	{
            		alt30=7;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt30=8;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 30;
                EXCEPTION->state        = 0;


                goto rulethfDefinedPredEx;

            }

            switch (alt30)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:511:5: '$less'
        	    {
        	         MATCHT(74, &FOLLOW_74_in_thfDefinedPred1125);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfDefinedPredEx;
        	        }


        	        {

        	                   p.d_kind = api::LT;
        	                 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:515:5: '$lesseq'
        	    {
        	         MATCHT(75, &FOLLOW_75_in_thfDefinedPred1138);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfDefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::LEQ;
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:519:5: '$greater'
        	    {
        	         MATCHT(68, &FOLLOW_68_in_thfDefinedPred1150);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfDefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::GT;
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:523:5: '$greatereq'
        	    {
        	         MATCHT(69, &FOLLOW_69_in_thfDefinedPred1162);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfDefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::GEQ;
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:527:5: '$is_rat'
        	    {
        	         MATCHT(71, &FOLLOW_71_in_thfDefinedPred1174);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfDefinedPredEx;
        	        }


        	        {

        	                  api::Term n = SOLVER->mkVar(SOLVER->getRealSort(), "N");
        	                  api::Term q = SOLVER->mkVar(SOLVER->getIntegerSort(), "Q");
        	                  api::Term qr = MK_TERM(api::TO_REAL, q);
        	                  api::Term r = SOLVER->mkVar(SOLVER->getIntegerSort(), "R");
        	                  api::Term rr = MK_TERM(api::TO_REAL, r);
        	                  api::Term body = MK_TERM(
        	                      api::AND,
        	                      MK_TERM(api::NOT,
        	                              MK_TERM(api::EQUAL, r, SOLVER->mkReal(0))),
        	                      MK_TERM(api::EQUAL, qr, MK_TERM(api::MULT, n, rr)));
        	                  api::Term bvl = MK_TERM(api::BOUND_VAR_LIST, q, r);
        	                  body = MK_TERM(api::EXISTS, bvl, body);
        	                  api::Term lbvl = MK_TERM(api::BOUND_VAR_LIST, n);
        	                  p.d_kind = api::LAMBDA;
        	                  p.d_expr = MK_TERM(api::LAMBDA, lbvl, body);
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:548:5: '$is_int'
        	    {
        	         MATCHT(70, &FOLLOW_70_in_thfDefinedPred1201);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfDefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::IS_INTEGER;
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:552:5: '$distinct'
        	    {
        	         MATCHT(66, &FOLLOW_66_in_thfDefinedPred1213);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfDefinedPredEx;
        	        }


        	        {

        	                  p.d_kind = api::DISTINCT;
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:556:5: LPAREN_TOK ( AND_TOK | OR_TOK | IMPLIES_TOK ) RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_thfDefinedPred1225);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfDefinedPredEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:557:5: ( AND_TOK | OR_TOK | IMPLIES_TOK )
        	        {
        	            int alt29=3;
        	            switch ( LA(1) )
        	            {
        	            case AND_TOK:
        	            	{
        	            		alt29=1;
        	            	}
        	                break;
        	            case OR_TOK:
        	            	{
        	            		alt29=2;
        	            	}
        	                break;
        	            case IMPLIES_TOK:
        	            	{
        	            		alt29=3;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 29;
        	                EXCEPTION->state        = 0;


        	                goto rulethfDefinedPredEx;

        	            }

        	            switch (alt29)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:558:7: AND_TOK
        	        	    {
        	        	         MATCHT(AND_TOK, &FOLLOW_AND_TOK_in_thfDefinedPred1239);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfDefinedPredEx;
        	        	        }


        	        	        {

        	        	                    p.d_kind = api::AND;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:562:7: OR_TOK
        	        	    {
        	        	         MATCHT(OR_TOK, &FOLLOW_OR_TOK_in_thfDefinedPred1255);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfDefinedPredEx;
        	        	        }


        	        	        {

        	        	                    p.d_kind = api::OR;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:566:7: IMPLIES_TOK
        	        	    {
        	        	         MATCHT(IMPLIES_TOK, &FOLLOW_IMPLIES_TOK_in_thfDefinedPred1271);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfDefinedPredEx;
        	        	        }


        	        	        {

        	        	                    p.d_kind = api::IMPLIES;
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_thfDefinedPred1291);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfDefinedPredEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulethfDefinedPredEx; /* Prevent compiler warnings */
    rulethfDefinedPredEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end thfDefinedPred */

/**
 * $ANTLR start definedFun
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:574:1: definedFun[CVC4::ParseOp& p] : ( '$uminus' | '$sum' | '$difference' | '$product' | '$quotient' | ( '$quotient_e' | '$remainder_e' ) | ( '$quotient_t' | '$remainder_t' ) | ( '$quotient_f' | '$remainder_f' ) | '$floor' | '$ceiling' | '$truncate' | '$round' | '$to_int' | '$to_rat' | '$to_real' );
 */
static void
definedFun(pTptpParser ctx, CVC4::ParseOp& p)
{

      bool remainder = false;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:578:3: ( '$uminus' | '$sum' | '$difference' | '$product' | '$quotient' | ( '$quotient_e' | '$remainder_e' ) | ( '$quotient_t' | '$remainder_t' ) | ( '$quotient_f' | '$remainder_f' ) | '$floor' | '$ceiling' | '$truncate' | '$round' | '$to_int' | '$to_rat' | '$to_real' )

            ANTLR3_UINT32 alt34;

            alt34=15;

            switch ( LA(1) )
            {
            case 95:
            	{
            		alt34=1;
            	}
                break;
            case 89:
            	{
            		alt34=2;
            	}
                break;
            case 65:
            	{
            		alt34=3;
            	}
                break;
            case 80:
            	{
            		alt34=4;
            	}
                break;
            case 81:
            	{
            		alt34=5;
            	}
                break;
            case 82:
            case 85:
            	{
            		alt34=6;
            	}
                break;
            case 84:
            case 87:
            	{
            		alt34=7;
            	}
                break;
            case 83:
            case 86:
            	{
            		alt34=8;
            	}
                break;
            case 67:
            	{
            		alt34=9;
            	}
                break;
            case 64:
            	{
            		alt34=10;
            	}
                break;
            case 94:
            	{
            		alt34=11;
            	}
                break;
            case 88:
            	{
            		alt34=12;
            	}
                break;
            case 91:
            	{
            		alt34=13;
            	}
                break;
            case 92:
            	{
            		alt34=14;
            	}
                break;
            case 93:
            	{
            		alt34=15;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 34;
                EXCEPTION->state        = 0;


                goto ruledefinedFunEx;

            }

            switch (alt34)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:578:5: '$uminus'
        	    {
        	         MATCHT(95, &FOLLOW_95_in_definedFun1310);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  p.d_kind = api::UMINUS;
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:582:5: '$sum'
        	    {
        	         MATCHT(89, &FOLLOW_89_in_definedFun1322);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  p.d_kind = api::PLUS;
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:586:5: '$difference'
        	    {
        	         MATCHT(65, &FOLLOW_65_in_definedFun1334);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  p.d_kind = api::MINUS;
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:590:5: '$product'
        	    {
        	         MATCHT(80, &FOLLOW_80_in_definedFun1346);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  p.d_kind = api::MULT;
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:594:5: '$quotient'
        	    {
        	         MATCHT(81, &FOLLOW_81_in_definedFun1358);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  p.d_kind = api::DIVISION;
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:598:5: ( '$quotient_e' | '$remainder_e' )
        	    {
        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:598:5: ( '$quotient_e' | '$remainder_e' )
        	        {
        	            int alt31=2;
        	            switch ( LA(1) )
        	            {
        	            case 82:
        	            	{
        	            		alt31=1;
        	            	}
        	                break;
        	            case 85:
        	            	{
        	            		alt31=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 31;
        	                EXCEPTION->state        = 0;


        	                goto ruledefinedFunEx;

        	            }

        	            switch (alt31)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:598:7: '$quotient_e'
        	        	    {
        	        	         MATCHT(82, &FOLLOW_82_in_definedFun1372);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruledefinedFunEx;
        	        	        }


        	        	        {
        	        	             remainder = false; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:599:7: '$remainder_e'
        	        	    {
        	        	         MATCHT(85, &FOLLOW_85_in_definedFun1382);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruledefinedFunEx;
        	        	        }


        	        	        {
        	        	             remainder = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  api::Term n = SOLVER->mkVar(SOLVER->getRealSort(), "N");
        	                  api::Term d = SOLVER->mkVar(SOLVER->getRealSort(), "D");
        	                  api::Term formals = MK_TERM(api::BOUND_VAR_LIST, n, d);
        	                  api::Term expr = MK_TERM(api::DIVISION, n, d);
        	                  expr = MK_TERM(api::ITE,
        	                                 MK_TERM(api::GEQ, d, SOLVER->mkReal(0)),
        	                                 MK_TERM(api::TO_INTEGER, expr),
        	                                 MK_TERM(api::UMINUS,
        	                                         MK_TERM(api::TO_INTEGER,
        	                                                 MK_TERM(api::UMINUS, expr))));
        	                  if (remainder)
        	                  {
        	                    expr = MK_TERM(
        	                        api::TO_INTEGER,
        	                        MK_TERM(api::MINUS, n, MK_TERM(api::MULT, expr, d)));
        	                  }
        	                  p.d_kind = api::LAMBDA;
        	                  p.d_expr = MK_TERM(api::LAMBDA, formals, expr);
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:621:5: ( '$quotient_t' | '$remainder_t' )
        	    {
        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:621:5: ( '$quotient_t' | '$remainder_t' )
        	        {
        	            int alt32=2;
        	            switch ( LA(1) )
        	            {
        	            case 84:
        	            	{
        	            		alt32=1;
        	            	}
        	                break;
        	            case 87:
        	            	{
        	            		alt32=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 32;
        	                EXCEPTION->state        = 0;


        	                goto ruledefinedFunEx;

        	            }

        	            switch (alt32)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:621:7: '$quotient_t'
        	        	    {
        	        	         MATCHT(84, &FOLLOW_84_in_definedFun1404);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruledefinedFunEx;
        	        	        }


        	        	        {
        	        	             remainder = false; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:622:7: '$remainder_t'
        	        	    {
        	        	         MATCHT(87, &FOLLOW_87_in_definedFun1414);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruledefinedFunEx;
        	        	        }


        	        	        {
        	        	             remainder = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  api::Term n = SOLVER->mkVar(SOLVER->getRealSort(), "N");
        	                  api::Term d = SOLVER->mkVar(SOLVER->getRealSort(), "D");
        	                  api::Term formals = MK_TERM(api::BOUND_VAR_LIST, n, d);
        	                  api::Term expr = MK_TERM(api::DIVISION, n, d);
        	                  expr = MK_TERM(api::ITE,
        	                                 MK_TERM(api::GEQ, expr, SOLVER->mkReal(0)),
        	                                 MK_TERM(api::TO_INTEGER, expr),
        	                                 MK_TERM(api::UMINUS,
        	                                         MK_TERM(api::TO_INTEGER,
        	                                                 MK_TERM(api::UMINUS, expr))));
        	                  if (remainder)
        	                  {
        	                    expr = MK_TERM(
        	                        api::TO_INTEGER,
        	                        MK_TERM(api::MINUS, n, MK_TERM(api::MULT, expr, d)));
        	                  }
        	                  p.d_kind = api::LAMBDA;
        	                  p.d_expr = MK_TERM(api::LAMBDA, formals, expr);
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:644:5: ( '$quotient_f' | '$remainder_f' )
        	    {
        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:644:5: ( '$quotient_f' | '$remainder_f' )
        	        {
        	            int alt33=2;
        	            switch ( LA(1) )
        	            {
        	            case 83:
        	            	{
        	            		alt33=1;
        	            	}
        	                break;
        	            case 86:
        	            	{
        	            		alt33=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 33;
        	                EXCEPTION->state        = 0;


        	                goto ruledefinedFunEx;

        	            }

        	            switch (alt33)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:644:7: '$quotient_f'
        	        	    {
        	        	         MATCHT(83, &FOLLOW_83_in_definedFun1436);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruledefinedFunEx;
        	        	        }


        	        	        {
        	        	             remainder = false; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:645:7: '$remainder_f'
        	        	    {
        	        	         MATCHT(86, &FOLLOW_86_in_definedFun1446);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruledefinedFunEx;
        	        	        }


        	        	        {
        	        	             remainder = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        {

        	                  api::Term n = SOLVER->mkVar(SOLVER->getRealSort(), "N");
        	                  api::Term d = SOLVER->mkVar(SOLVER->getRealSort(), "D");
        	                  api::Term formals = MK_TERM(api::BOUND_VAR_LIST, n, d);
        	                  api::Term expr = MK_TERM(api::DIVISION, n, d);
        	                  expr = MK_TERM(api::TO_INTEGER, expr);
        	                  if (remainder)
        	                  {
        	                    expr = MK_TERM(api::TO_INTEGER,
        	                                   MK_TERM(api::MINUS, n, MK_TERM(api::MULT, expr, d)));
        	                  }
        	                  p.d_kind = api::LAMBDA;
        	                  p.d_expr = MK_TERM(api::LAMBDA, formals, expr);
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:661:5: '$floor'
        	    {
        	         MATCHT(67, &FOLLOW_67_in_definedFun1466);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  p.d_kind = api::TO_INTEGER;
        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:665:5: '$ceiling'
        	    {
        	         MATCHT(64, &FOLLOW_64_in_definedFun1478);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  api::Term n = SOLVER->mkVar(SOLVER->getRealSort(), "N");
        	                  api::Term formals = MK_TERM(api::BOUND_VAR_LIST, n);
        	                  api::Term expr = MK_TERM(api::UMINUS,
        	                                      MK_TERM(api::TO_INTEGER, MK_TERM(api::UMINUS, n)));
        	                  p.d_kind = api::LAMBDA;
        	                  p.d_expr = MK_TERM(api::LAMBDA, formals, expr);
        	                
        	        }


        	    }
        	    break;
        	case 11:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:674:5: '$truncate'
        	    {
        	         MATCHT(94, &FOLLOW_94_in_definedFun1490);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  api::Term n = SOLVER->mkVar(SOLVER->getRealSort(), "N");
        	                  api::Term formals = MK_TERM(api::BOUND_VAR_LIST, n);
        	                  api::Term expr =
        	                      MK_TERM(api::ITE,
        	                              MK_TERM(api::GEQ, n, SOLVER->mkReal(0)),
        	                              MK_TERM(api::TO_INTEGER, n),
        	                              MK_TERM(api::UMINUS,
        	                                      MK_TERM(api::TO_INTEGER, MK_TERM(api::UMINUS, n))));
        	                  p.d_kind = api::LAMBDA;
        	                  p.d_expr = MK_TERM(api::LAMBDA, formals, expr);
        	                
        	        }


        	    }
        	    break;
        	case 12:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:687:5: '$round'
        	    {
        	         MATCHT(88, &FOLLOW_88_in_definedFun1502);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  api::Term n = SOLVER->mkVar(SOLVER->getRealSort(), "N");
        	                  api::Term formals = MK_TERM(api::BOUND_VAR_LIST, n);
        	                  api::Term decPart = MK_TERM(api::MINUS, n, MK_TERM(api::TO_INTEGER, n));
        	                  api::Term expr = MK_TERM(
        	                      api::ITE,
        	                      MK_TERM(api::LT, decPart, SOLVER->mkReal(1, 2)),
        	                      // if decPart < 0.5, round down
        	                      MK_TERM(api::TO_INTEGER, n),
        	                      MK_TERM(api::ITE,
        	                              MK_TERM(api::GT, decPart, SOLVER->mkReal(1, 2)),
        	                              // if decPart > 0.5, round up
        	                              MK_TERM(api::TO_INTEGER,
        	                                      MK_TERM(api::PLUS, n, SOLVER->mkReal(1))),
        	                              // if decPart == 0.5, round to nearest even integer:
        	                              // result is: to_int(n/2 + .5) * 2
        	                              MK_TERM(api::MULT,
        	                                      MK_TERM(api::TO_INTEGER,
        	                                              MK_TERM(api::PLUS,
        	                                                      MK_TERM(api::DIVISION,
        	                                                              n,
        	                                                              SOLVER->mkReal(2)),
        	                                                      SOLVER->mkReal(1, 2))),
        	                                      SOLVER->mkReal(2))));
        	                  p.d_kind = api::LAMBDA;
        	                  p.d_expr = MK_TERM(api::LAMBDA, formals, expr);
        	                  
        	        }


        	    }
        	    break;
        	case 13:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:715:5: '$to_int'
        	    {
        	         MATCHT(91, &FOLLOW_91_in_definedFun1514);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  p.d_kind = api::TO_INTEGER;
        	                
        	        }


        	    }
        	    break;
        	case 14:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:719:5: '$to_rat'
        	    {
        	         MATCHT(92, &FOLLOW_92_in_definedFun1526);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  p.d_kind = api::TO_REAL;
        	                
        	        }


        	    }
        	    break;
        	case 15:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:723:5: '$to_real'
        	    {
        	         MATCHT(93, &FOLLOW_93_in_definedFun1538);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledefinedFunEx;
        	        }


        	        {

        	                  p.d_kind = api::TO_REAL;
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledefinedFunEx; /* Prevent compiler warnings */
    ruledefinedFunEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end definedFun */

/**
 * $ANTLR start equalOp
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:732:1: equalOp[bool& equal] : ( EQUAL_TOK | DISEQUAL_TOK );
 */
static void
equalOp(pTptpParser ctx, bool& equal)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:733:3: ( EQUAL_TOK | DISEQUAL_TOK )

            ANTLR3_UINT32 alt35;

            alt35=2;

            switch ( LA(1) )
            {
            case EQUAL_TOK:
            	{
            		alt35=1;
            	}
                break;
            case DISEQUAL_TOK:
            	{
            		alt35=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 35;
                EXCEPTION->state        = 0;


                goto ruleequalOpEx;

            }

            switch (alt35)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:733:5: EQUAL_TOK
        	    {
        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_equalOp1561);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleequalOpEx;
        	        }


        	        {
        	             equal = true; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:734:5: DISEQUAL_TOK
        	    {
        	         MATCHT(DISEQUAL_TOK, &FOLLOW_DISEQUAL_TOK_in_equalOp1572);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleequalOpEx;
        	        }


        	        {
        	             equal = false; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleequalOpEx; /* Prevent compiler warnings */
    ruleequalOpEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end equalOp */

/**
 * $ANTLR start term
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:737:1: term[CVC4::api::Term& expr] : ( functionTerm[expr] | conditionalTerm[expr] | simpleTerm[expr] | letTerm[expr] );
 */
static void
term(pTptpParser ctx, CVC4::api::Term& expr)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:738:3: ( functionTerm[expr] | conditionalTerm[expr] | simpleTerm[expr] | letTerm[expr] )

            ANTLR3_UINT32 alt36;

            alt36=4;

            switch ( LA(1) )
            {
            case CNF_TOK:
            case FOF_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TYPE_TOK:
            case 64:
            case 65:
            case 67:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt36=1;
            	}
                break;
            case 73:
            	{
            		alt36=2;
            	}
                break;
            case DISTINCT_OBJECT:
            case NUMBER:
            case UPPER_WORD:
            	{
            		alt36=3;
            	}
                break;
            case 77:
            case 79:
            	{
            		alt36=4;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 36;
                EXCEPTION->state        = 0;


                goto ruletermEx;

            }

            switch (alt36)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:738:5: functionTerm[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_functionTerm_in_term1588);
        	        functionTerm(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:739:5: conditionalTerm[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_conditionalTerm_in_term1595);
        	        conditionalTerm(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:740:5: simpleTerm[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleTerm_in_term1602);
        	        simpleTerm(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:741:5: letTerm[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_letTerm_in_term1609);
        	        letTerm(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletermEx; /* Prevent compiler warnings */
    ruletermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end term */

/**
 * $ANTLR start letTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:744:1: letTerm[CVC4::api::Term& expr] : ( '$let_ft' LPAREN_TOK tffLetFormulaDefn[lhs, rhs] COMMA_TOK term[expr] RPAREN_TOK | '$let_tt' LPAREN_TOK tffLetTermDefn[lhs, rhs] COMMA_TOK term[expr] RPAREN_TOK );
 */
static void
letTerm(pTptpParser ctx, CVC4::api::Term& expr)
{

      CVC4::api::Term lhs, rhs;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:748:3: ( '$let_ft' LPAREN_TOK tffLetFormulaDefn[lhs, rhs] COMMA_TOK term[expr] RPAREN_TOK | '$let_tt' LPAREN_TOK tffLetTermDefn[lhs, rhs] COMMA_TOK term[expr] RPAREN_TOK )

            ANTLR3_UINT32 alt37;

            alt37=2;

            switch ( LA(1) )
            {
            case 77:
            	{
            		alt37=1;
            	}
                break;
            case 79:
            	{
            		alt37=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 37;
                EXCEPTION->state        = 0;


                goto ruleletTermEx;

            }

            switch (alt37)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:748:5: '$let_ft' LPAREN_TOK tffLetFormulaDefn[lhs, rhs] COMMA_TOK term[expr] RPAREN_TOK
        	    {
        	         MATCHT(77, &FOLLOW_77_in_letTerm1629);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_letTerm1631);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_tffLetFormulaDefn_in_letTerm1639);
        	        tffLetFormulaDefn(ctx, lhs, rhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_letTerm1642);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_letTerm1648);
        	        term(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  expr = expr.substitute(lhs, rhs);
        	                
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_letTerm1661);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:755:5: '$let_tt' LPAREN_TOK tffLetTermDefn[lhs, rhs] COMMA_TOK term[expr] RPAREN_TOK
        	    {
        	         MATCHT(79, &FOLLOW_79_in_letTerm1667);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_letTerm1669);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_tffLetTermDefn_in_letTerm1677);
        	        tffLetTermDefn(ctx, lhs, rhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_letTerm1680);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_letTerm1686);
        	        term(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  expr = expr.substitute(lhs, rhs);
        	                
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_letTerm1699);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleletTermEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleletTermEx; /* Prevent compiler warnings */
    ruleletTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end letTerm */

/**
 * $ANTLR start simpleTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:765:1: simpleTerm[CVC4::api::Term& expr] : ( variable[expr] | NUMBER | DISTINCT_OBJECT );
 */
static void
simpleTerm(pTptpParser ctx, CVC4::api::Term& expr)
{
    pANTLR3_COMMON_TOKEN    DISTINCT_OBJECT2;

    /* Initialize rule variables
     */

    DISTINCT_OBJECT2       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:766:3: ( variable[expr] | NUMBER | DISTINCT_OBJECT )

            ANTLR3_UINT32 alt38;

            alt38=3;

            switch ( LA(1) )
            {
            case UPPER_WORD:
            	{
            		alt38=1;
            	}
                break;
            case NUMBER:
            	{
            		alt38=2;
            	}
                break;
            case DISTINCT_OBJECT:
            	{
            		alt38=3;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 38;
                EXCEPTION->state        = 0;


                goto rulesimpleTermEx;

            }

            switch (alt38)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:766:5: variable[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_variable_in_simpleTerm1715);
        	        variable(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:767:5: NUMBER
        	    {
        	         MATCHT(NUMBER, &FOLLOW_NUMBER_in_simpleTerm1722);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }


        	        {
        	             expr = PARSER_STATE->d_tmp_expr; 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:768:5: DISTINCT_OBJECT
        	    {
        	        DISTINCT_OBJECT2 = (pANTLR3_COMMON_TOKEN) MATCHT(DISTINCT_OBJECT, &FOLLOW_DISTINCT_OBJECT_in_simpleTerm1730);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }


        	        {
        	             expr = PARSER_STATE->convertStrToUnsorted(AntlrInput::tokenText(DISTINCT_OBJECT2)); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleTermEx; /* Prevent compiler warnings */
    rulesimpleTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleTerm */

/**
 * $ANTLR start thfSimpleTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:772:1: thfSimpleTerm[CVC4::api::Term& expr] : ( NUMBER | DISTINCT_OBJECT );
 */
static void
thfSimpleTerm(pTptpParser ctx, CVC4::api::Term& expr)
{
    pANTLR3_COMMON_TOKEN    DISTINCT_OBJECT3;

    /* Initialize rule variables
     */

    DISTINCT_OBJECT3       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:773:3: ( NUMBER | DISTINCT_OBJECT )

            ANTLR3_UINT32 alt39;

            alt39=2;

            switch ( LA(1) )
            {
            case NUMBER:
            	{
            		alt39=1;
            	}
                break;
            case DISTINCT_OBJECT:
            	{
            		alt39=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 39;
                EXCEPTION->state        = 0;


                goto rulethfSimpleTermEx;

            }

            switch (alt39)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:773:5: NUMBER
        	    {
        	         MATCHT(NUMBER, &FOLLOW_NUMBER_in_thfSimpleTerm1748);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfSimpleTermEx;
        	        }


        	        {
        	             expr = PARSER_STATE->d_tmp_expr; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:774:5: DISTINCT_OBJECT
        	    {
        	        DISTINCT_OBJECT3 = (pANTLR3_COMMON_TOKEN) MATCHT(DISTINCT_OBJECT, &FOLLOW_DISTINCT_OBJECT_in_thfSimpleTerm1756);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfSimpleTermEx;
        	        }


        	        {

        	                  expr = PARSER_STATE->convertStrToUnsorted(
        	                      AntlrInput::tokenText(DISTINCT_OBJECT3));
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulethfSimpleTermEx; /* Prevent compiler warnings */
    rulethfSimpleTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end thfSimpleTerm */

/**
 * $ANTLR start functionTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:781:1: functionTerm[CVC4::api::Term& expr] : ( plainTerm[expr] | definedFun[p] LPAREN_TOK arguments[args] RPAREN_TOK );
 */
static void
functionTerm(pTptpParser ctx, CVC4::api::Term& expr)
{

      std::vector<CVC4::api::Term> args;
      ParseOp p;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:786:3: ( plainTerm[expr] | definedFun[p] LPAREN_TOK arguments[args] RPAREN_TOK )

            ANTLR3_UINT32 alt40;

            alt40=2;

            switch ( LA(1) )
            {
            case CNF_TOK:
            case FOF_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TYPE_TOK:
            	{
            		alt40=1;
            	}
                break;
            case 64:
            case 65:
            case 67:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt40=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 40;
                EXCEPTION->state        = 0;


                goto rulefunctionTermEx;

            }

            switch (alt40)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:786:5: plainTerm[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_plainTerm_in_functionTerm1781);
        	        plainTerm(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefunctionTermEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:787:5: definedFun[p] LPAREN_TOK arguments[args] RPAREN_TOK
        	    {
        	        FOLLOWPUSH(FOLLOW_definedFun_in_functionTerm1788);
        	        definedFun(ctx, p);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefunctionTermEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_functionTerm1791);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefunctionTermEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_arguments_in_functionTerm1793);
        	        arguments(ctx, args);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefunctionTermEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_functionTerm1796);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefunctionTermEx;
        	        }


        	        {

        	                  expr = PARSER_STATE->applyParseOp(p, args);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulefunctionTermEx; /* Prevent compiler warnings */
    rulefunctionTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end functionTerm */

/**
 * $ANTLR start conditionalTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:793:1: conditionalTerm[CVC4::api::Term& expr] : '$ite_t' LPAREN_TOK tffLogicFormula[expr] COMMA_TOK term[expr2] COMMA_TOK term[expr3] RPAREN_TOK ;
 */
static void
conditionalTerm(pTptpParser ctx, CVC4::api::Term& expr)
{

      CVC4::api::Term expr2, expr3;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:797:3: ( '$ite_t' LPAREN_TOK tffLogicFormula[expr] COMMA_TOK term[expr2] COMMA_TOK term[expr3] RPAREN_TOK )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:797:5: '$ite_t' LPAREN_TOK tffLogicFormula[expr] COMMA_TOK term[expr2] COMMA_TOK term[expr3] RPAREN_TOK
        {
             MATCHT(73, &FOLLOW_73_in_conditionalTerm1821);
            if  (HASEXCEPTION())
            {
                goto ruleconditionalTermEx;
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_conditionalTerm1823);
            if  (HASEXCEPTION())
            {
                goto ruleconditionalTermEx;
            }


            FOLLOWPUSH(FOLLOW_tffLogicFormula_in_conditionalTerm1825);
            tffLogicFormula(ctx, expr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleconditionalTermEx;
            }


             MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_conditionalTerm1828);
            if  (HASEXCEPTION())
            {
                goto ruleconditionalTermEx;
            }


            FOLLOWPUSH(FOLLOW_term_in_conditionalTerm1830);
            term(ctx, expr2);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleconditionalTermEx;
            }


             MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_conditionalTerm1833);
            if  (HASEXCEPTION())
            {
                goto ruleconditionalTermEx;
            }


            FOLLOWPUSH(FOLLOW_term_in_conditionalTerm1835);
            term(ctx, expr3);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleconditionalTermEx;
            }


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_conditionalTerm1838);
            if  (HASEXCEPTION())
            {
                goto ruleconditionalTermEx;
            }


            {
                 expr = MK_TERM(api::ITE, expr, expr2, expr3); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleconditionalTermEx; /* Prevent compiler warnings */
    ruleconditionalTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end conditionalTerm */

/**
 * $ANTLR start plainTerm
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:801:1: plainTerm[CVC4::api::Term& expr] : atomicWord[p.d_name] ( LPAREN_TOK arguments[args] RPAREN_TOK )? ;
 */
static void
plainTerm(pTptpParser ctx, CVC4::api::Term& expr)
{

      std::string name;
      std::vector<api::Term> args;
      ParseOp p;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:807:3: ( atomicWord[p.d_name] ( LPAREN_TOK arguments[args] RPAREN_TOK )? )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:807:5: atomicWord[p.d_name] ( LPAREN_TOK arguments[args] RPAREN_TOK )?
        {
            FOLLOWPUSH(FOLLOW_atomicWord_in_plainTerm1863);
            atomicWord(ctx, p.d_name);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleplainTermEx;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:807:26: ( LPAREN_TOK arguments[args] RPAREN_TOK )?
            {
                int alt41=2;
                switch ( LA(1) )
                {
                    case LPAREN_TOK:
                    	{
                    		alt41=1;
                    	}
                        break;
                }

                switch (alt41)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:807:27: LPAREN_TOK arguments[args] RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_plainTerm1867);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleplainTermEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_arguments_in_plainTerm1869);
            	        arguments(ctx, args);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleplainTermEx;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_plainTerm1872);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleplainTermEx;
            	        }


            	    }
            	    break;

                }
            }

            {

                      expr = args.empty() ? PARSER_STATE->parseOpToExpr(p)
                                          : PARSER_STATE->applyParseOp(p, args);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleplainTermEx; /* Prevent compiler warnings */
    ruleplainTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end plainTerm */

/**
 * $ANTLR start arguments
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:814:1: arguments[std::vector<CVC4::api::Term>& args] : term[expr] ( COMMA_TOK term[expr] )* ;
 */
static void
arguments(pTptpParser ctx, std::vector<CVC4::api::Term>& args)
{

      CVC4::api::Term expr;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:818:3: ( term[expr] ( COMMA_TOK term[expr] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:819:3: term[expr] ( COMMA_TOK term[expr] )*
        {
            FOLLOWPUSH(FOLLOW_term_in_arguments1901);
            term(ctx, expr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleargumentsEx;
            }


            {
                 args.push_back(expr); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:819:40: ( COMMA_TOK term[expr] )*

            for (;;)
            {
                int alt42=2;
                switch ( LA(1) )
                {
                case COMMA_TOK:
                	{
                		alt42=1;
                	}
                    break;

                }

                switch (alt42)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:819:42: COMMA_TOK term[expr]
            	    {
            	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_arguments1908);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleargumentsEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_arguments1910);
            	        term(ctx, expr);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleargumentsEx;
            	        }


            	        {
            	             args.push_back(expr); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop42;	/* break out of the loop */
            	    break;
                }
            }
            loop42: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleargumentsEx; /* Prevent compiler warnings */
    ruleargumentsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end arguments */

/**
 * $ANTLR start variable
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:822:1: variable[CVC4::api::Term& expr] : UPPER_WORD ;
 */
static void
variable(pTptpParser ctx, CVC4::api::Term& expr)
{
    pANTLR3_COMMON_TOKEN    UPPER_WORD4;

    /* Initialize rule variables
     */

    UPPER_WORD4       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:823:3: ( UPPER_WORD )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:823:5: UPPER_WORD
        {
            UPPER_WORD4 = (pANTLR3_COMMON_TOKEN) MATCHT(UPPER_WORD, &FOLLOW_UPPER_WORD_in_variable1930);
            if  (HASEXCEPTION())
            {
                goto rulevariableEx;
            }


            {

                      std::string name = AntlrInput::tokenText(UPPER_WORD4);
                      if(!PARSER_STATE->cnf() || PARSER_STATE->isDeclared(name)) {
                        expr = PARSER_STATE->getVariable(name);
                      } else {
                        expr = PARSER_STATE->bindBoundVar(name, PARSER_STATE->d_unsorted);
                        if(PARSER_STATE->cnf()) PARSER_STATE->addFreeVar(expr);
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulevariableEx; /* Prevent compiler warnings */
    rulevariableEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end variable */

/**
 * $ANTLR start fofFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:837:1: fofFormula[CVC4::api::Term& expr] : fofLogicFormula[expr] ;
 */
static void
fofFormula(pTptpParser ctx, CVC4::api::Term& expr)
{
    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:837:35: ( fofLogicFormula[expr] )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:837:37: fofLogicFormula[expr]
        {
            FOLLOWPUSH(FOLLOW_fofLogicFormula_in_fofFormula1954);
            fofLogicFormula(ctx, expr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulefofFormulaEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulefofFormulaEx; /* Prevent compiler warnings */
    rulefofFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end fofFormula */

/**
 * $ANTLR start fofLogicFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:839:1: fofLogicFormula[CVC4::api::Term& expr] : fofUnitaryFormula[expr] ( ( fofBinaryNonAssoc[na] fofUnitaryFormula[expr2] ) | ( ( AND_TOK fofUnitaryFormula[expr] )+ ) | ( ( OR_TOK fofUnitaryFormula[expr] )+ ) )? ;
 */
static void
fofLogicFormula(pTptpParser ctx, CVC4::api::Term& expr)
{

      tptp::NonAssoc na;
      std::vector< CVC4::api::Term > args;
      CVC4::api::Term expr2;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:845:3: ( fofUnitaryFormula[expr] ( ( fofBinaryNonAssoc[na] fofUnitaryFormula[expr2] ) | ( ( AND_TOK fofUnitaryFormula[expr] )+ ) | ( ( OR_TOK fofUnitaryFormula[expr] )+ ) )? )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:845:5: fofUnitaryFormula[expr] ( ( fofBinaryNonAssoc[na] fofUnitaryFormula[expr2] ) | ( ( AND_TOK fofUnitaryFormula[expr] )+ ) | ( ( OR_TOK fofUnitaryFormula[expr] )+ ) )?
        {
            FOLLOWPUSH(FOLLOW_fofUnitaryFormula_in_fofLogicFormula1972);
            fofUnitaryFormula(ctx, expr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulefofLogicFormulaEx;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:846:5: ( ( fofBinaryNonAssoc[na] fofUnitaryFormula[expr2] ) | ( ( AND_TOK fofUnitaryFormula[expr] )+ ) | ( ( OR_TOK fofUnitaryFormula[expr] )+ ) )?
            {
                int alt45=4;
                switch ( LA(1) )
                {
                    case IFF_TOK:
                    case IMPLIES_TOK:
                    case REVAND_TOK:
                    case REVIFF_TOK:
                    case REVIMPLIES_TOK:
                    case REVOR_TOK:
                    	{
                    		alt45=1;
                    	}
                        break;
                    case AND_TOK:
                    	{
                    		alt45=2;
                    	}
                        break;
                    case OR_TOK:
                    	{
                    		alt45=3;
                    	}
                        break;
                }

                switch (alt45)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:847:7: ( fofBinaryNonAssoc[na] fofUnitaryFormula[expr2] )
            	    {
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:847:7: ( fofBinaryNonAssoc[na] fofUnitaryFormula[expr2] )
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:847:9: fofBinaryNonAssoc[na] fofUnitaryFormula[expr2]
            	        {
            	            FOLLOWPUSH(FOLLOW_fofBinaryNonAssoc_in_fofLogicFormula1990);
            	            fofBinaryNonAssoc(ctx, na);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulefofLogicFormulaEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_fofUnitaryFormula_in_fofLogicFormula1993);
            	            fofUnitaryFormula(ctx, expr2);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulefofLogicFormulaEx;
            	            }


            	            {
            	                 switch(na) {
            	                           case tptp::NA_IFF:
            	                             expr = MK_TERM(api::EQUAL,expr,expr2);
            	                             break;
            	                           case tptp::NA_REVIFF:
            	                             expr = MK_TERM(api::XOR,expr,expr2);
            	                             break;
            	                           case tptp::NA_IMPLIES:
            	                             expr = MK_TERM(api::IMPLIES,expr,expr2);
            	                             break;
            	                           case tptp::NA_REVIMPLIES:
            	                             expr = MK_TERM(api::IMPLIES,expr2,expr);
            	                             break;
            	                           case tptp::NA_REVOR:
            	                             expr = MK_TERM(api::NOT,MK_TERM(api::OR,expr,expr2));
            	                             break;
            	                           case tptp::NA_REVAND:
            	                             expr = MK_TERM(api::NOT,MK_TERM(api::AND,expr,expr2));
            	                             break;
            	                          }
            	                        
            	            }


            	        }


            	    }
            	    break;
            	case 2:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:871:7: ( ( AND_TOK fofUnitaryFormula[expr] )+ )
            	    {
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:871:7: ( ( AND_TOK fofUnitaryFormula[expr] )+ )
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:871:9: ( AND_TOK fofUnitaryFormula[expr] )+
            	        {
            	            {
            	                 args.push_back(expr); 
            	            }


            	            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:872:9: ( AND_TOK fofUnitaryFormula[expr] )+
            	            {
            	                int cnt43=0;

            	                for (;;)
            	                {
            	                    int alt43=2;
            	            	switch ( LA(1) )
            	            	{
            	            	case AND_TOK:
            	            		{
            	            			alt43=1;
            	            		}
            	            	    break;

            	            	}

            	            	switch (alt43)
            	            	{
            	            	    case 1:
            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:872:11: AND_TOK fofUnitaryFormula[expr]
            	            	        {
            	            	             MATCHT(AND_TOK, &FOLLOW_AND_TOK_in_fofLogicFormula2041);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulefofLogicFormulaEx;
            	            	            }


            	            	            FOLLOWPUSH(FOLLOW_fofUnitaryFormula_in_fofLogicFormula2043);
            	            	            fofUnitaryFormula(ctx, expr);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulefofLogicFormulaEx;
            	            	            }


            	            	            {
            	            	                 args.push_back(expr); 
            	            	            }


            	            	        }
            	            	        break;

            	            	    default:

            	            		if ( cnt43 >= 1 )
            	            		{
            	            		    goto loop43;
            	            		}
            	            		/* mismatchedSetEx()
            	            		 */
            	            		CONSTRUCTEX();
            	            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            		goto rulefofLogicFormulaEx;
            	            	}
            	            	cnt43++;
            	                }
            	                loop43: ;	/* Jump to here if this rule does not match */
            	            }

            	            {
            	                 expr = MK_TERM(api::AND, args); 
            	            }


            	        }


            	    }
            	    break;
            	case 3:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:876:7: ( ( OR_TOK fofUnitaryFormula[expr] )+ )
            	    {
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:876:7: ( ( OR_TOK fofUnitaryFormula[expr] )+ )
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:876:9: ( OR_TOK fofUnitaryFormula[expr] )+
            	        {
            	            {
            	                 args.push_back(expr); 
            	            }


            	            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:877:9: ( OR_TOK fofUnitaryFormula[expr] )+
            	            {
            	                int cnt44=0;

            	                for (;;)
            	                {
            	                    int alt44=2;
            	            	switch ( LA(1) )
            	            	{
            	            	case OR_TOK:
            	            		{
            	            			alt44=1;
            	            		}
            	            	    break;

            	            	}

            	            	switch (alt44)
            	            	{
            	            	    case 1:
            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:877:11: OR_TOK fofUnitaryFormula[expr]
            	            	        {
            	            	             MATCHT(OR_TOK, &FOLLOW_OR_TOK_in_fofLogicFormula2096);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulefofLogicFormulaEx;
            	            	            }


            	            	            FOLLOWPUSH(FOLLOW_fofUnitaryFormula_in_fofLogicFormula2098);
            	            	            fofUnitaryFormula(ctx, expr);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulefofLogicFormulaEx;
            	            	            }


            	            	            {
            	            	                 args.push_back(expr); 
            	            	            }


            	            	        }
            	            	        break;

            	            	    default:

            	            		if ( cnt44 >= 1 )
            	            		{
            	            		    goto loop44;
            	            		}
            	            		/* mismatchedSetEx()
            	            		 */
            	            		CONSTRUCTEX();
            	            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            		goto rulefofLogicFormulaEx;
            	            	}
            	            	cnt44++;
            	                }
            	                loop44: ;	/* Jump to here if this rule does not match */
            	            }

            	            {
            	                 expr = MK_TERM(api::OR, args); 
            	            }


            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulefofLogicFormulaEx; /* Prevent compiler warnings */
    rulefofLogicFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end fofLogicFormula */

/**
 * $ANTLR start fofUnitaryFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:883:1: fofUnitaryFormula[CVC4::api::Term& expr] : ( atomicFormula[expr] | LPAREN_TOK fofLogicFormula[expr] RPAREN_TOK | NOT_TOK fofUnitaryFormula[expr] | folQuantifier[kind] LBRACK_TOK ( bindvariable[expr] ( COMMA_TOK bindvariable[expr] )* ) RBRACK_TOK COLON_TOK fofUnitaryFormula[expr] );
 */
static void
fofUnitaryFormula(pTptpParser ctx, CVC4::api::Term& expr)
{

      api::Kind kind;
      std::vector< CVC4::api::Term > bv;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:888:3: ( atomicFormula[expr] | LPAREN_TOK fofLogicFormula[expr] RPAREN_TOK | NOT_TOK fofUnitaryFormula[expr] | folQuantifier[kind] LBRACK_TOK ( bindvariable[expr] ( COMMA_TOK bindvariable[expr] )* ) RBRACK_TOK COLON_TOK fofUnitaryFormula[expr] )

            ANTLR3_UINT32 alt47;

            alt47=4;

            switch ( LA(1) )
            {
            case AND_TOK:
            case CNF_TOK:
            case DISTINCT_OBJECT:
            case FALSE_TOK:
            case FOF_TOK:
            case IMPLIES_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case NUMBER:
            case OR_TOK:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TRUE_TOK:
            case TYPE_TOK:
            case UPPER_WORD:
            case 64:
            case 65:
            case 66:
            case 67:
            case 68:
            case 69:
            case 70:
            case 71:
            case 73:
            case 74:
            case 75:
            case 77:
            case 79:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt47=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt47=2;
            	}
                break;
            case NOT_TOK:
            	{
            		alt47=3;
            	}
                break;
            case EXISTS_TOK:
            case FORALL_TOK:
            	{
            		alt47=4;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 47;
                EXCEPTION->state        = 0;


                goto rulefofUnitaryFormulaEx;

            }

            switch (alt47)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:888:5: atomicFormula[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_atomicFormula_in_fofUnitaryFormula2148);
        	        atomicFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofUnitaryFormulaEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:889:5: LPAREN_TOK fofLogicFormula[expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_fofUnitaryFormula2155);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_fofLogicFormula_in_fofUnitaryFormula2157);
        	        fofLogicFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofUnitaryFormulaEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_fofUnitaryFormula2160);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofUnitaryFormulaEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:890:5: NOT_TOK fofUnitaryFormula[expr]
        	    {
        	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_fofUnitaryFormula2166);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_fofUnitaryFormula_in_fofUnitaryFormula2168);
        	        fofUnitaryFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofUnitaryFormulaEx;
        	        }


        	        {
        	             expr = MK_TERM(api::NOT,expr); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:892:5: folQuantifier[kind] LBRACK_TOK ( bindvariable[expr] ( COMMA_TOK bindvariable[expr] )* ) RBRACK_TOK COLON_TOK fofUnitaryFormula[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_folQuantifier_in_fofUnitaryFormula2182);
        	        folQuantifier(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofUnitaryFormulaEx;
        	        }


        	         MATCHT(LBRACK_TOK, &FOLLOW_LBRACK_TOK_in_fofUnitaryFormula2185);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofUnitaryFormulaEx;
        	        }


        	        {
        	            PARSER_STATE->pushScope();
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:893:5: ( bindvariable[expr] ( COMMA_TOK bindvariable[expr] )* )
        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:893:7: bindvariable[expr] ( COMMA_TOK bindvariable[expr] )*
        	        {
        	            FOLLOWPUSH(FOLLOW_bindvariable_in_fofUnitaryFormula2195);
        	            bindvariable(ctx, expr);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto rulefofUnitaryFormulaEx;
        	            }


        	            {
        	                 bv.push_back(expr); 
        	            }


        	            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:894:7: ( COMMA_TOK bindvariable[expr] )*

        	            for (;;)
        	            {
        	                int alt46=2;
        	                switch ( LA(1) )
        	                {
        	                case COMMA_TOK:
        	                	{
        	                		alt46=1;
        	                	}
        	                    break;

        	                }

        	                switch (alt46)
        	                {
        	            	case 1:
        	            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:894:9: COMMA_TOK bindvariable[expr]
        	            	    {
        	            	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_fofUnitaryFormula2208);
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto rulefofUnitaryFormulaEx;
        	            	        }


        	            	        FOLLOWPUSH(FOLLOW_bindvariable_in_fofUnitaryFormula2210);
        	            	        bindvariable(ctx, expr);

        	            	        FOLLOWPOP();
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto rulefofUnitaryFormulaEx;
        	            	        }


        	            	        {
        	            	             bv.push_back(expr); 
        	            	        }


        	            	    }
        	            	    break;

        	            	default:
        	            	    goto loop46;	/* break out of the loop */
        	            	    break;
        	                }
        	            }
        	            loop46: ; /* Jump out to here if this rule does not match */


        	        }


        	         MATCHT(RBRACK_TOK, &FOLLOW_RBRACK_TOK_in_fofUnitaryFormula2220);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofUnitaryFormulaEx;
        	        }


        	         MATCHT(COLON_TOK, &FOLLOW_COLON_TOK_in_fofUnitaryFormula2226);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_fofUnitaryFormula_in_fofUnitaryFormula2228);
        	        fofUnitaryFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofUnitaryFormulaEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  expr = MK_TERM(kind, MK_TERM(api::BOUND_VAR_LIST, bv), expr);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulefofUnitaryFormulaEx; /* Prevent compiler warnings */
    rulefofUnitaryFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end fofUnitaryFormula */

/**
 * $ANTLR start bindvariable
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:901:1: bindvariable[CVC4::api::Term& expr] : UPPER_WORD ;
 */
static void
bindvariable(pTptpParser ctx, CVC4::api::Term& expr)
{
    pANTLR3_COMMON_TOKEN    UPPER_WORD5;

    /* Initialize rule variables
     */

    UPPER_WORD5       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:902:3: ( UPPER_WORD )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:902:5: UPPER_WORD
        {
            UPPER_WORD5 = (pANTLR3_COMMON_TOKEN) MATCHT(UPPER_WORD, &FOLLOW_UPPER_WORD_in_bindvariable2249);
            if  (HASEXCEPTION())
            {
                goto rulebindvariableEx;
            }


            {
                 std::string name = AntlrInput::tokenText(UPPER_WORD5);
                      expr = PARSER_STATE->bindBoundVar(name, PARSER_STATE->d_unsorted);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebindvariableEx; /* Prevent compiler warnings */
    rulebindvariableEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bindvariable */

/**
 * $ANTLR start fofBinaryNonAssoc
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:908:1: fofBinaryNonAssoc[CVC4::parser::tptp::NonAssoc& na] : ( IFF_TOK | REVIFF_TOK | REVOR_TOK | REVAND_TOK | IMPLIES_TOK | REVIMPLIES_TOK );
 */
static void
fofBinaryNonAssoc(pTptpParser ctx, CVC4::parser::tptp::NonAssoc& na)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:909:3: ( IFF_TOK | REVIFF_TOK | REVOR_TOK | REVAND_TOK | IMPLIES_TOK | REVIMPLIES_TOK )

            ANTLR3_UINT32 alt48;

            alt48=6;

            switch ( LA(1) )
            {
            case IFF_TOK:
            	{
            		alt48=1;
            	}
                break;
            case REVIFF_TOK:
            	{
            		alt48=2;
            	}
                break;
            case REVOR_TOK:
            	{
            		alt48=3;
            	}
                break;
            case REVAND_TOK:
            	{
            		alt48=4;
            	}
                break;
            case IMPLIES_TOK:
            	{
            		alt48=5;
            	}
                break;
            case REVIMPLIES_TOK:
            	{
            		alt48=6;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 48;
                EXCEPTION->state        = 0;


                goto rulefofBinaryNonAssocEx;

            }

            switch (alt48)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:909:5: IFF_TOK
        	    {
        	         MATCHT(IFF_TOK, &FOLLOW_IFF_TOK_in_fofBinaryNonAssoc2269);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofBinaryNonAssocEx;
        	        }


        	        {
        	             na = tptp::NA_IFF; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:910:5: REVIFF_TOK
        	    {
        	         MATCHT(REVIFF_TOK, &FOLLOW_REVIFF_TOK_in_fofBinaryNonAssoc2282);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofBinaryNonAssocEx;
        	        }


        	        {
        	             na = tptp::NA_REVIFF; 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:911:5: REVOR_TOK
        	    {
        	         MATCHT(REVOR_TOK, &FOLLOW_REVOR_TOK_in_fofBinaryNonAssoc2292);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofBinaryNonAssocEx;
        	        }


        	        {
        	             na = tptp::NA_REVOR; 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:912:5: REVAND_TOK
        	    {
        	         MATCHT(REVAND_TOK, &FOLLOW_REVAND_TOK_in_fofBinaryNonAssoc2303);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofBinaryNonAssocEx;
        	        }


        	        {
        	             na = tptp::NA_REVAND; 
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:913:5: IMPLIES_TOK
        	    {
        	         MATCHT(IMPLIES_TOK, &FOLLOW_IMPLIES_TOK_in_fofBinaryNonAssoc2313);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofBinaryNonAssocEx;
        	        }


        	        {
        	             na = tptp::NA_IMPLIES; 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:914:5: REVIMPLIES_TOK
        	    {
        	         MATCHT(REVIMPLIES_TOK, &FOLLOW_REVIMPLIES_TOK_in_fofBinaryNonAssoc2324);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefofBinaryNonAssocEx;
        	        }


        	        {
        	             na = tptp::NA_REVIMPLIES; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulefofBinaryNonAssocEx; /* Prevent compiler warnings */
    rulefofBinaryNonAssocEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end fofBinaryNonAssoc */

/**
 * $ANTLR start folQuantifier
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:917:1: folQuantifier[CVC4::api::Kind& kind] : ( FORALL_TOK | EXISTS_TOK );
 */
static void
folQuantifier(pTptpParser ctx, CVC4::api::Kind& kind)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:918:3: ( FORALL_TOK | EXISTS_TOK )

            ANTLR3_UINT32 alt49;

            alt49=2;

            switch ( LA(1) )
            {
            case FORALL_TOK:
            	{
            		alt49=1;
            	}
                break;
            case EXISTS_TOK:
            	{
            		alt49=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 49;
                EXCEPTION->state        = 0;


                goto rulefolQuantifierEx;

            }

            switch (alt49)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:918:5: FORALL_TOK
        	    {
        	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_folQuantifier2340);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefolQuantifierEx;
        	        }


        	        {
        	             kind = api::FORALL; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:919:5: EXISTS_TOK
        	    {
        	         MATCHT(EXISTS_TOK, &FOLLOW_EXISTS_TOK_in_folQuantifier2348);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulefolQuantifierEx;
        	        }


        	        {
        	             kind = api::EXISTS; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulefolQuantifierEx; /* Prevent compiler warnings */
    rulefolQuantifierEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end folQuantifier */

/**
 * $ANTLR start thfQuantifier
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:925:1: thfQuantifier[CVC4::api::Kind& kind] : ( FORALL_TOK | EXISTS_TOK | LAMBDA_TOK | CHOICE_TOK | DEF_DESC_TOK | ( TH1_UN_A | TH1_UN_E ) );
 */
static void
thfQuantifier(pTptpParser ctx, CVC4::api::Kind& kind)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:926:3: ( FORALL_TOK | EXISTS_TOK | LAMBDA_TOK | CHOICE_TOK | DEF_DESC_TOK | ( TH1_UN_A | TH1_UN_E ) )

            ANTLR3_UINT32 alt50;

            alt50=6;

            switch ( LA(1) )
            {
            case FORALL_TOK:
            	{
            		alt50=1;
            	}
                break;
            case EXISTS_TOK:
            	{
            		alt50=2;
            	}
                break;
            case LAMBDA_TOK:
            	{
            		alt50=3;
            	}
                break;
            case CHOICE_TOK:
            	{
            		alt50=4;
            	}
                break;
            case DEF_DESC_TOK:
            	{
            		alt50=5;
            	}
                break;
            case TH1_UN_A:
            case TH1_UN_E:
            	{
            		alt50=6;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 50;
                EXCEPTION->state        = 0;


                goto rulethfQuantifierEx;

            }

            switch (alt50)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:926:5: FORALL_TOK
        	    {
        	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_thfQuantifier2369);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfQuantifierEx;
        	        }


        	        {
        	             kind = api::FORALL; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:927:5: EXISTS_TOK
        	    {
        	         MATCHT(EXISTS_TOK, &FOLLOW_EXISTS_TOK_in_thfQuantifier2377);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfQuantifierEx;
        	        }


        	        {
        	             kind = api::EXISTS; 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:928:5: LAMBDA_TOK
        	    {
        	         MATCHT(LAMBDA_TOK, &FOLLOW_LAMBDA_TOK_in_thfQuantifier2385);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfQuantifierEx;
        	        }


        	        {
        	             kind = api::LAMBDA; 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:929:5: CHOICE_TOK
        	    {
        	         MATCHT(CHOICE_TOK, &FOLLOW_CHOICE_TOK_in_thfQuantifier2393);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfQuantifierEx;
        	        }


        	        {

        	                    UNSUPPORTED("Choice operator");
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:933:5: DEF_DESC_TOK
        	    {
        	         MATCHT(DEF_DESC_TOK, &FOLLOW_DEF_DESC_TOK_in_thfQuantifier2405);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfQuantifierEx;
        	        }


        	        {

        	                  UNSUPPORTED("Description quantifier");
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:937:5: ( TH1_UN_A | TH1_UN_E )
        	    {
        	        if ( ((LA(1) >= TH1_UN_A) && (LA(1) <= TH1_UN_E)) )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        }
        	        else
        	        {
        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulethfQuantifierEx;
        	        }


        	        {

        	                  UNSUPPORTED("TH1 operator");
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulethfQuantifierEx; /* Prevent compiler warnings */
    rulethfQuantifierEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end thfQuantifier */

/**
 * $ANTLR start thfAtomTyping
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:943:1: thfAtomTyping[CVC4::Command*& cmd] : ( LPAREN_TOK thfAtomTyping[cmd] RPAREN_TOK | nameN[name] COLON_TOK ( '$tType' | parseThfType[type] ) );
 */
static void
thfAtomTyping(pTptpParser ctx, CVC4::Command*& cmd)
{

      CVC4::api::Term expr;
      CVC4::api::Sort type;
      std::string name;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:950:3: ( LPAREN_TOK thfAtomTyping[cmd] RPAREN_TOK | nameN[name] COLON_TOK ( '$tType' | parseThfType[type] ) )

            ANTLR3_UINT32 alt52;

            alt52=2;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		alt52=1;
            	}
                break;
            case CNF_TOK:
            case FOF_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case NUMBER:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TYPE_TOK:
            	{
            		alt52=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 52;
                EXCEPTION->state        = 0;


                goto rulethfAtomTypingEx;

            }

            switch (alt52)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:950:5: LPAREN_TOK thfAtomTyping[cmd] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_thfAtomTyping2449);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomTypingEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_thfAtomTyping_in_thfAtomTyping2451);
        	        thfAtomTyping(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomTypingEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_thfAtomTyping2454);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomTypingEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:951:5: nameN[name] COLON_TOK ( '$tType' | parseThfType[type] )
        	    {
        	        FOLLOWPUSH(FOLLOW_nameN_in_thfAtomTyping2460);
        	        nameN(ctx, name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomTypingEx;
        	        }


        	         MATCHT(COLON_TOK, &FOLLOW_COLON_TOK_in_thfAtomTyping2463);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfAtomTypingEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:952:5: ( '$tType' | parseThfType[type] )
        	        {
        	            int alt51=2;
        	            switch ( LA(1) )
        	            {
        	            case 90:
        	            	{
        	            		alt51=1;
        	            	}
        	                break;
        	            case CNF_TOK:
        	            case DEFINED_SYMBOL:
        	            case FOF_TOK:
        	            case INCLUDE_TOK:
        	            case LBRACK_TOK:
        	            case LOWER_WORD:
        	            case LOWER_WORD_SINGLE_QUOTED:
        	            case LPAREN_TOK:
        	            case SINGLE_QUOTED:
        	            case TFF_TOK:
        	            case THF_TOK:
        	            case TYPE_TOK:
        	            	{
        	            		alt51=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 51;
        	                EXCEPTION->state        = 0;


        	                goto rulethfAtomTypingEx;

        	            }

        	            switch (alt51)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:952:7: '$tType'
        	        	    {
        	        	         MATCHT(90, &FOLLOW_90_in_thfAtomTyping2471);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomTypingEx;
        	        	        }


        	        	        {

        	        	                    if (PARSER_STATE->isDeclared(name, SYM_SORT))
        	        	                    {
        	        	                      // duplicate declaration is fine, they're compatible
        	        	                      cmd = new EmptyCommand("compatible redeclaration of sort " + name);
        	        	                    }
        	        	                    else if (PARSER_STATE->isDeclared(name, SYM_VARIABLE))
        	        	                    {
        	        	                      // error: cannot be both sort and constant
        	        	                      PARSER_STATE->parseError(
        	        	                          "Symbol `" + name
        	        	                          + "' previously declared as a constant; cannot also be a sort");
        	        	                    }
        	        	                    else
        	        	                    {
        	        	                      // as yet, it's undeclared
        	        	                      api::Sort atype = PARSER_STATE->mkSort(name);
        	        	                      cmd = new DeclareTypeCommand(name, 0, atype.getType());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:973:7: parseThfType[type]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_parseThfType_in_thfAtomTyping2487);
        	        	        parseThfType(ctx, type);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfAtomTypingEx;
        	        	        }


        	        	        {

        	        	                    if (PARSER_STATE->isDeclared(name, SYM_SORT))
        	        	                    {
        	        	                      // error: cannot be both sort and constant
        	        	                      PARSER_STATE->parseError("Symbol `" + name
        	        	                                               + "' previously declared as a sort");
        	        	                      cmd = new EmptyCommand("compatible redeclaration of sort " + name);
        	        	                    }
        	        	                    else if (PARSER_STATE->isDeclared(name, SYM_VARIABLE))
        	        	                    {
        	        	                      if (type == PARSER_STATE->getVariable(name).getSort())
        	        	                      {
        	        	                        // duplicate declaration is fine, they're compatible
        	        	                        cmd = new EmptyCommand("compatible redeclaration of constant "
        	        	                                               + name);
        	        	                      }
        	        	                      else
        	        	                      {
        	        	                        // error: sorts incompatible
        	        	                        PARSER_STATE->parseError(
        	        	                            "Symbol `" + name
        	        	                            + "' declared previously with a different sort");
        	        	                      }
        	        	                    }
        	        	                    else
        	        	                    {
        	        	                      // as of yet, it's undeclared
        	        	                      CVC4::api::Term freshExpr;
        	        	                      if (type.isFunction())
        	        	                      {
        	        	                        freshExpr = PARSER_STATE->bindVar(name, type);
        	        	                      }
        	        	                      else
        	        	                      {
        	        	                        freshExpr = PARSER_STATE->bindVar(name, type);
        	        	                      }
        	        	                      cmd = new DeclareFunctionCommand(
        	        	                          name, freshExpr.getExpr(), type.getType());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulethfAtomTypingEx; /* Prevent compiler warnings */
    rulethfAtomTypingEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end thfAtomTyping */

/**
 * $ANTLR start thfLogicFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1017:1: thfLogicFormula[CVC4::ParseOp& p] : thfUnitaryFormula[p] ( equalOp[equal] thfUnitaryFormula[p1] | fofBinaryNonAssoc[na] thfUnitaryFormula[p1] | ( ( AND_TOK thfUnitaryFormula[p] )+ ) | ( ( OR_TOK thfUnitaryFormula[p] )+ ) | ( APP_TOK ( thfUnitaryFormula[p] | LBRACK_TOK thfTupleForm[args] RBRACK_TOK ) )+ )? ;
 */
static void
thfLogicFormula(pTptpParser ctx, CVC4::ParseOp& p)
{

      tptp::NonAssoc na;
      std::vector<CVC4::api::Term> args;
      std::vector<ParseOp> p_args;
      CVC4::api::Term expr2;
      bool equal;
      ParseOp p1;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1028:3: ( thfUnitaryFormula[p] ( equalOp[equal] thfUnitaryFormula[p1] | fofBinaryNonAssoc[na] thfUnitaryFormula[p1] | ( ( AND_TOK thfUnitaryFormula[p] )+ ) | ( ( OR_TOK thfUnitaryFormula[p] )+ ) | ( APP_TOK ( thfUnitaryFormula[p] | LBRACK_TOK thfTupleForm[args] RBRACK_TOK ) )+ )? )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1028:5: thfUnitaryFormula[p] ( equalOp[equal] thfUnitaryFormula[p1] | fofBinaryNonAssoc[na] thfUnitaryFormula[p1] | ( ( AND_TOK thfUnitaryFormula[p] )+ ) | ( ( OR_TOK thfUnitaryFormula[p] )+ ) | ( APP_TOK ( thfUnitaryFormula[p] | LBRACK_TOK thfTupleForm[args] RBRACK_TOK ) )+ )?
        {
            FOLLOWPUSH(FOLLOW_thfUnitaryFormula_in_thfLogicFormula2527);
            thfUnitaryFormula(ctx, p);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulethfLogicFormulaEx;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1029:5: ( equalOp[equal] thfUnitaryFormula[p1] | fofBinaryNonAssoc[na] thfUnitaryFormula[p1] | ( ( AND_TOK thfUnitaryFormula[p] )+ ) | ( ( OR_TOK thfUnitaryFormula[p] )+ ) | ( APP_TOK ( thfUnitaryFormula[p] | LBRACK_TOK thfTupleForm[args] RBRACK_TOK ) )+ )?
            {
                int alt57=6;
                switch ( LA(1) )
                {
                    case DISEQUAL_TOK:
                    case EQUAL_TOK:
                    	{
                    		alt57=1;
                    	}
                        break;
                    case IFF_TOK:
                    case IMPLIES_TOK:
                    case REVAND_TOK:
                    case REVIFF_TOK:
                    case REVIMPLIES_TOK:
                    case REVOR_TOK:
                    	{
                    		alt57=2;
                    	}
                        break;
                    case AND_TOK:
                    	{
                    		alt57=3;
                    	}
                        break;
                    case OR_TOK:
                    	{
                    		alt57=4;
                    	}
                        break;
                    case APP_TOK:
                    	{
                    		alt57=5;
                    	}
                        break;
                }

                switch (alt57)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1030:7: equalOp[equal] thfUnitaryFormula[p1]
            	    {
            	        FOLLOWPUSH(FOLLOW_equalOp_in_thfLogicFormula2543);
            	        equalOp(ctx, equal);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulethfLogicFormulaEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_thfUnitaryFormula_in_thfLogicFormula2552);
            	        thfUnitaryFormula(ctx, p1);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulethfLogicFormulaEx;
            	        }


            	        {

            	                    if (p.d_expr.isNull() && !p1.d_expr.isNull())
            	                    {
            	                      // make p.d_expr with a lambda of the same type as p1.d_expr
            	                      p.d_expr =
            	                          PARSER_STATE->mkLambdaWrapper(p.d_kind, p1.d_expr.getSort());
            	                    }
            	                    else if (p1.d_expr.isNull() && !p.d_expr.isNull())
            	                    {
            	                      // make p1.d_expr with a lambda of the same type as p.d_expr
            	                      p1.d_expr =
            	                          PARSER_STATE->mkLambdaWrapper(p1.d_kind, p.d_expr.getSort());
            	                    }
            	                    else if (p.d_expr.isNull() && p1.d_expr.isNull())
            	                    {
            	                      // Without a reference type it's not possible in general to know what
            	                      // the lambda wrapping should be, so we fail in these cases
            	                      UNSUPPORTED("Equality between theory functions");
            	                    }
            	                    args.push_back(p.d_expr);
            	                    args.push_back(p1.d_expr);
            	                    p.d_expr = MK_TERM(api::EQUAL, args);
            	                    if (!equal)
            	                    {
            	                      p.d_expr = MK_TERM(api::NOT, p.d_expr);
            	                    }
            	                  
            	        }


            	    }
            	    break;
            	case 2:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1060:7: fofBinaryNonAssoc[na] thfUnitaryFormula[p1]
            	    {
            	        FOLLOWPUSH(FOLLOW_fofBinaryNonAssoc_in_thfLogicFormula2576);
            	        fofBinaryNonAssoc(ctx, na);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulethfLogicFormulaEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_thfUnitaryFormula_in_thfLogicFormula2579);
            	        thfUnitaryFormula(ctx, p1);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulethfLogicFormulaEx;
            	        }


            	        {

            	                    if (p.d_expr.isNull() || p1.d_expr.isNull())
            	                    {
            	                      PARSER_STATE->parseError(
            	                          "Non-associative operator must be applied to formulas");
            	                    }
            	                    switch (na)
            	                    {
            	                      case tptp::NA_IFF:
            	                        p.d_expr = MK_TERM(api::EQUAL, p.d_expr, p1.d_expr);
            	                        break;
            	                      case tptp::NA_REVIFF:
            	                        p.d_expr = MK_TERM(api::XOR, p.d_expr, p1.d_expr);
            	                        break;
            	                      case tptp::NA_IMPLIES:
            	                        p.d_expr = MK_TERM(api::IMPLIES, p.d_expr, p1.d_expr);
            	                        break;
            	                      case tptp::NA_REVIMPLIES:
            	                        p.d_expr = MK_TERM(api::IMPLIES, p1.d_expr, p.d_expr);
            	                        break;
            	                      case tptp::NA_REVOR:
            	                        p.d_expr =
            	                            MK_TERM(api::NOT, MK_TERM(api::OR, p.d_expr, p1.d_expr));
            	                        break;
            	                      case tptp::NA_REVAND:
            	                        p.d_expr =
            	                            MK_TERM(api::NOT, MK_TERM(api::AND, p.d_expr, p1.d_expr));
            	                        break;
            	                    }
            	                  
            	        }


            	    }
            	    break;
            	case 3:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1092:7: ( ( AND_TOK thfUnitaryFormula[p] )+ )
            	    {
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1092:7: ( ( AND_TOK thfUnitaryFormula[p] )+ )
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1093:9: ( AND_TOK thfUnitaryFormula[p] )+
            	        {
            	            {

            	                          if (p.d_expr.isNull())
            	                          {
            	                            PARSER_STATE->parseError("AND must be applied to a formula");
            	                          }
            	                          args.push_back(p.d_expr);
            	                          p = ParseOp();
            	                        
            	            }


            	            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1101:9: ( AND_TOK thfUnitaryFormula[p] )+
            	            {
            	                int cnt53=0;

            	                for (;;)
            	                {
            	                    int alt53=2;
            	            	switch ( LA(1) )
            	            	{
            	            	case AND_TOK:
            	            		{
            	            			alt53=1;
            	            		}
            	            	    break;

            	            	}

            	            	switch (alt53)
            	            	{
            	            	    case 1:
            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1101:11: AND_TOK thfUnitaryFormula[p]
            	            	        {
            	            	             MATCHT(AND_TOK, &FOLLOW_AND_TOK_in_thfLogicFormula2625);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulethfLogicFormulaEx;
            	            	            }


            	            	            FOLLOWPUSH(FOLLOW_thfUnitaryFormula_in_thfLogicFormula2627);
            	            	            thfUnitaryFormula(ctx, p);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulethfLogicFormulaEx;
            	            	            }


            	            	            {

            	            	                            if (p.d_expr.isNull())
            	            	                            {
            	            	                              PARSER_STATE->parseError("AND must be applied to a formula");
            	            	                            }
            	            	                            args.push_back(p.d_expr);
            	            	                            p = ParseOp();
            	            	                          
            	            	            }


            	            	        }
            	            	        break;

            	            	    default:

            	            		if ( cnt53 >= 1 )
            	            		{
            	            		    goto loop53;
            	            		}
            	            		/* mismatchedSetEx()
            	            		 */
            	            		CONSTRUCTEX();
            	            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            		goto rulethfLogicFormulaEx;
            	            	}
            	            	cnt53++;
            	                }
            	                loop53: ;	/* Jump to here if this rule does not match */
            	            }

            	            {

            	                          p.d_expr = MK_TERM(api::AND, args);
            	                        
            	            }


            	        }


            	    }
            	    break;
            	case 4:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1116:7: ( ( OR_TOK thfUnitaryFormula[p] )+ )
            	    {
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1116:7: ( ( OR_TOK thfUnitaryFormula[p] )+ )
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1117:9: ( OR_TOK thfUnitaryFormula[p] )+
            	        {
            	            {

            	                          if (p.d_expr.isNull())
            	                          {
            	                            PARSER_STATE->parseError("OR must be applied to a formula");
            	                          }
            	                          args.push_back(p.d_expr);
            	                          p = ParseOp();
            	                        
            	            }


            	            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1125:9: ( OR_TOK thfUnitaryFormula[p] )+
            	            {
            	                int cnt54=0;

            	                for (;;)
            	                {
            	                    int alt54=2;
            	            	switch ( LA(1) )
            	            	{
            	            	case OR_TOK:
            	            		{
            	            			alt54=1;
            	            		}
            	            	    break;

            	            	}

            	            	switch (alt54)
            	            	{
            	            	    case 1:
            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1125:11: OR_TOK thfUnitaryFormula[p]
            	            	        {
            	            	             MATCHT(OR_TOK, &FOLLOW_OR_TOK_in_thfLogicFormula2706);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulethfLogicFormulaEx;
            	            	            }


            	            	            FOLLOWPUSH(FOLLOW_thfUnitaryFormula_in_thfLogicFormula2708);
            	            	            thfUnitaryFormula(ctx, p);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto rulethfLogicFormulaEx;
            	            	            }


            	            	            {

            	            	                            if (p.d_expr.isNull())
            	            	                            {
            	            	                              PARSER_STATE->parseError("OR must be applied to a formula");
            	            	                            }
            	            	                            args.push_back(p.d_expr);
            	            	                            p = ParseOp();
            	            	                          
            	            	            }


            	            	        }
            	            	        break;

            	            	    default:

            	            		if ( cnt54 >= 1 )
            	            		{
            	            		    goto loop54;
            	            		}
            	            		/* mismatchedSetEx()
            	            		 */
            	            		CONSTRUCTEX();
            	            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            		goto rulethfLogicFormulaEx;
            	            	}
            	            	cnt54++;
            	                }
            	                loop54: ;	/* Jump to here if this rule does not match */
            	            }

            	            {

            	                          p.d_expr = MK_TERM(api::OR, args);
            	                        
            	            }


            	        }


            	    }
            	    break;
            	case 5:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1145:7: ( APP_TOK ( thfUnitaryFormula[p] | LBRACK_TOK thfTupleForm[args] RBRACK_TOK ) )+
            	    {
            	        {

            	                    p_args.push_back(p);
            	                    p = ParseOp();
            	                  
            	        }


            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1149:7: ( APP_TOK ( thfUnitaryFormula[p] | LBRACK_TOK thfTupleForm[args] RBRACK_TOK ) )+
            	        {
            	            int cnt56=0;

            	            for (;;)
            	            {
            	                int alt56=2;
            	        	switch ( LA(1) )
            	        	{
            	        	case APP_TOK:
            	        		{
            	        			alt56=1;
            	        		}
            	        	    break;

            	        	}

            	        	switch (alt56)
            	        	{
            	        	    case 1:
            	        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1149:9: APP_TOK ( thfUnitaryFormula[p] | LBRACK_TOK thfTupleForm[args] RBRACK_TOK )
            	        	        {
            	        	             MATCHT(APP_TOK, &FOLLOW_APP_TOK_in_thfLogicFormula2810);
            	        	            if  (HASEXCEPTION())
            	        	            {
            	        	                goto rulethfLogicFormulaEx;
            	        	            }


            	        	            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1150:9: ( thfUnitaryFormula[p] | LBRACK_TOK thfTupleForm[args] RBRACK_TOK )
            	        	            {
            	        	                int alt55=2;
            	        	                switch ( LA(1) )
            	        	                {
            	        	                case CHOICE_TOK:
            	        	                case CNF_TOK:
            	        	                case DEF_DESC_TOK:
            	        	                case DISTINCT_OBJECT:
            	        	                case EXISTS_TOK:
            	        	                case FALSE_TOK:
            	        	                case FOF_TOK:
            	        	                case FORALL_TOK:
            	        	                case INCLUDE_TOK:
            	        	                case LAMBDA_TOK:
            	        	                case LOWER_WORD:
            	        	                case LOWER_WORD_SINGLE_QUOTED:
            	        	                case LPAREN_TOK:
            	        	                case NOT_TOK:
            	        	                case NUMBER:
            	        	                case SINGLE_QUOTED:
            	        	                case TFF_TOK:
            	        	                case TH1_UN_A:
            	        	                case TH1_UN_E:
            	        	                case THF_TOK:
            	        	                case TRUE_TOK:
            	        	                case TYPE_TOK:
            	        	                case UPPER_WORD:
            	        	                case 64:
            	        	                case 65:
            	        	                case 66:
            	        	                case 67:
            	        	                case 68:
            	        	                case 69:
            	        	                case 70:
            	        	                case 71:
            	        	                case 73:
            	        	                case 74:
            	        	                case 75:
            	        	                case 77:
            	        	                case 79:
            	        	                case 80:
            	        	                case 81:
            	        	                case 82:
            	        	                case 83:
            	        	                case 84:
            	        	                case 85:
            	        	                case 86:
            	        	                case 87:
            	        	                case 88:
            	        	                case 89:
            	        	                case 91:
            	        	                case 92:
            	        	                case 93:
            	        	                case 94:
            	        	                case 95:
            	        	                	{
            	        	                		alt55=1;
            	        	                	}
            	        	                    break;
            	        	                case LBRACK_TOK:
            	        	                	{
            	        	                		alt55=2;
            	        	                	}
            	        	                    break;

            	        	                default:
            	        	                    CONSTRUCTEX();
            	        	                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                    EXCEPTION->message      = (void *)"";
            	        	                    EXCEPTION->decisionNum  = 55;
            	        	                    EXCEPTION->state        = 0;


            	        	                    goto rulethfLogicFormulaEx;

            	        	                }

            	        	                switch (alt55)
            	        	                {
            	        	            	case 1:
            	        	            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1151:10: thfUnitaryFormula[p]
            	        	            	    {
            	        	            	        FOLLOWPUSH(FOLLOW_thfUnitaryFormula_in_thfLogicFormula2831);
            	        	            	        thfUnitaryFormula(ctx, p);

            	        	            	        FOLLOWPOP();
            	        	            	        if  (HASEXCEPTION())
            	        	            	        {
            	        	            	            goto rulethfLogicFormulaEx;
            	        	            	        }


            	        	            	        {

            	        	            	                       p_args.push_back(p);
            	        	            	                       p = ParseOp();
            	        	            	                     
            	        	            	        }


            	        	            	    }
            	        	            	    break;
            	        	            	case 2:
            	        	            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1156:12: LBRACK_TOK thfTupleForm[args] RBRACK_TOK
            	        	            	    {
            	        	            	         MATCHT(LBRACK_TOK, &FOLLOW_LBRACK_TOK_in_thfLogicFormula2856);
            	        	            	        if  (HASEXCEPTION())
            	        	            	        {
            	        	            	            goto rulethfLogicFormulaEx;
            	        	            	        }


            	        	            	        {
            	        	            	             UNSUPPORTED("Tuple terms"); 
            	        	            	        }


            	        	            	        FOLLOWPUSH(FOLLOW_thfTupleForm_in_thfLogicFormula2882);
            	        	            	        thfTupleForm(ctx, args);

            	        	            	        FOLLOWPOP();
            	        	            	        if  (HASEXCEPTION())
            	        	            	        {
            	        	            	            goto rulethfLogicFormulaEx;
            	        	            	        }


            	        	            	         MATCHT(RBRACK_TOK, &FOLLOW_RBRACK_TOK_in_thfLogicFormula2896);
            	        	            	        if  (HASEXCEPTION())
            	        	            	        {
            	        	            	            goto rulethfLogicFormulaEx;
            	        	            	        }


            	        	            	    }
            	        	            	    break;

            	        	                }
            	        	            }

            	        	        }
            	        	        break;

            	        	    default:

            	        		if ( cnt56 >= 1 )
            	        		{
            	        		    goto loop56;
            	        		}
            	        		/* mismatchedSetEx()
            	        		 */
            	        		CONSTRUCTEX();
            	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	        		goto rulethfLogicFormulaEx;
            	        	}
            	        	cnt56++;
            	            }
            	            loop56: ;	/* Jump to here if this rule does not match */
            	        }

            	        {

            	                    if (p_args[0].d_expr.isNull())
            	                    {
            	                      for (unsigned i = 1, size = p_args.size(); i < size; ++i)
            	                      {
            	                        if (p_args[i].d_expr.isNull())
            	                        {
            	                          PARSER_STATE->parseError(
            	                              "Application chains with defined symbol heads and at least "
            	                              "one defined symbol as argument are unsupported.");
            	                        }
            	                        args.push_back(p_args[i].d_expr);
            	                      }
            	                      p.d_expr = PARSER_STATE->applyParseOp(p_args[0], args);
            	                    }
            	                    else
            	                    {
            	                      p.d_expr = p_args[0].d_expr;
            	                      // check if any argument is a defined function, e.g. "~", and create a
            	                      // lambda wrapper then, e.g. (\lambda x. ~ x)
            	                      for (unsigned i = 1, size = p_args.size(); i < size; ++i)
            	                      {
            	                        if (!p_args[i].d_expr.isNull())
            	                        {
            	                          args.push_back(p_args[i].d_expr);
            	                          continue;
            	                        }
            	                        // create a lambda wrapper, e.g. (\lambda x. ~ x).
            	                        //
            	                        // The type is determined by the first element of the application
            	                        // chain, which must be a function of type t1...tn -> t, so the
            	                        // lambda must have type ti
            	                        args.push_back(PARSER_STATE->mkLambdaWrapper(
            	                            p_args[i].d_kind,
            	                            p.d_expr.getSort()
            	                                .getFunctionDomainSorts()[i - 1]));
            	                      }
            	                      for (unsigned i = 0, size = args.size(); i < size; ++i)
            	                      {
            	                        p.d_expr = MK_TERM(api::HO_APPLY, p.d_expr, args[i]);
            	                      }
            	                    }
            	                  
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulethfLogicFormulaEx; /* Prevent compiler warnings */
    rulethfLogicFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end thfLogicFormula */

/**
 * $ANTLR start thfTupleForm
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1208:1: thfTupleForm[std::vector<CVC4::api::Term>& args] : thfUnitaryFormula[p] ( COMMA_TOK thfUnitaryFormula[p] )+ ;
 */
static void
thfTupleForm(pTptpParser ctx, std::vector<CVC4::api::Term>& args)
{

      ParseOp p;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1212:3: ( thfUnitaryFormula[p] ( COMMA_TOK thfUnitaryFormula[p] )+ )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1212:5: thfUnitaryFormula[p] ( COMMA_TOK thfUnitaryFormula[p] )+
        {
            FOLLOWPUSH(FOLLOW_thfUnitaryFormula_in_thfTupleForm2949);
            thfUnitaryFormula(ctx, p);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulethfTupleFormEx;
            }


            {

                     if (p.d_expr.isNull())
                     {
                       PARSER_STATE->parseError("TUPLE element must be a formula");
                     }
                     args.push_back(p.d_expr);
                   
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1220:4: ( COMMA_TOK thfUnitaryFormula[p] )+
            {
                int cnt58=0;

                for (;;)
                {
                    int alt58=2;
            	switch ( LA(1) )
            	{
            	case COMMA_TOK:
            		{
            			alt58=1;
            		}
            	    break;

            	}

            	switch (alt58)
            	{
            	    case 1:
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1220:6: COMMA_TOK thfUnitaryFormula[p]
            	        {
            	             MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_thfTupleForm2962);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulethfTupleFormEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_thfUnitaryFormula_in_thfTupleForm2964);
            	            thfUnitaryFormula(ctx, p);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulethfTupleFormEx;
            	            }


            	            {

            	                       if (p.d_expr.isNull())
            	                       {
            	                         PARSER_STATE->parseError("TUPLE element must be a formula");
            	                       }
            	                       args.push_back(p.d_expr);
            	                     
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt58 >= 1 )
            		{
            		    goto loop58;
            		}
            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulethfTupleFormEx;
            	}
            	cnt58++;
                }
                loop58: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulethfTupleFormEx; /* Prevent compiler warnings */
    rulethfTupleFormEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end thfTupleForm */

/**
 * $ANTLR start thfUnitaryFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1231:1: thfUnitaryFormula[CVC4::ParseOp& p] : ( variable[p.d_expr] | thfAtomicFormula[p] | LPAREN_TOK thfLogicFormula[p] RPAREN_TOK | NOT_TOK ( thfUnitaryFormula[p1] )? | thfQuantifier[p.d_kind] LBRACK_TOK thfBindVariable[expr] ( COMMA_TOK thfBindVariable[expr] )* RBRACK_TOK COLON_TOK thfUnitaryFormula[p1] );
 */
static void
thfUnitaryFormula(pTptpParser ctx, CVC4::ParseOp& p)
{

      api::Kind kind;
      std::vector< CVC4::api::Term > bv;
      CVC4::api::Term expr;
      bool equal;
      ParseOp p1;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1239:3: ( variable[p.d_expr] | thfAtomicFormula[p] | LPAREN_TOK thfLogicFormula[p] RPAREN_TOK | NOT_TOK ( thfUnitaryFormula[p1] )? | thfQuantifier[p.d_kind] LBRACK_TOK thfBindVariable[expr] ( COMMA_TOK thfBindVariable[expr] )* RBRACK_TOK COLON_TOK thfUnitaryFormula[p1] )

            ANTLR3_UINT32 alt61;

            alt61=5;

            switch ( LA(1) )
            {
            case UPPER_WORD:
            	{
            		alt61=1;
            	}
                break;
            case CNF_TOK:
            case DISTINCT_OBJECT:
            case FALSE_TOK:
            case FOF_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case NUMBER:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TRUE_TOK:
            case TYPE_TOK:
            case 64:
            case 65:
            case 66:
            case 67:
            case 68:
            case 69:
            case 70:
            case 71:
            case 73:
            case 74:
            case 75:
            case 77:
            case 79:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt61=2;
            	}
                break;
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case AND_TOK:
            		case IMPLIES_TOK:
            		case OR_TOK:
            			{
            				alt61=2;
            			}
            		    break;
            		case CHOICE_TOK:
            		case CNF_TOK:
            		case DEF_DESC_TOK:
            		case DISTINCT_OBJECT:
            		case EXISTS_TOK:
            		case FALSE_TOK:
            		case FOF_TOK:
            		case FORALL_TOK:
            		case INCLUDE_TOK:
            		case LAMBDA_TOK:
            		case LOWER_WORD:
            		case LOWER_WORD_SINGLE_QUOTED:
            		case LPAREN_TOK:
            		case NOT_TOK:
            		case NUMBER:
            		case SINGLE_QUOTED:
            		case TFF_TOK:
            		case TH1_UN_A:
            		case TH1_UN_E:
            		case THF_TOK:
            		case TRUE_TOK:
            		case TYPE_TOK:
            		case UPPER_WORD:
            		case 64:
            		case 65:
            		case 66:
            		case 67:
            		case 68:
            		case 69:
            		case 70:
            		case 71:
            		case 73:
            		case 74:
            		case 75:
            		case 77:
            		case 79:
            		case 80:
            		case 81:
            		case 82:
            		case 83:
            		case 84:
            		case 85:
            		case 86:
            		case 87:
            		case 88:
            		case 89:
            		case 91:
            		case 92:
            		case 93:
            		case 94:
            		case 95:
            			{
            				alt61=3;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 61;
            		    EXCEPTION->state        = 41;


            		    goto rulethfUnitaryFormulaEx;

            		}

            	}
                break;
            case NOT_TOK:
            	{
            		alt61=4;
            	}
                break;
            case CHOICE_TOK:
            case DEF_DESC_TOK:
            case EXISTS_TOK:
            case FORALL_TOK:
            case LAMBDA_TOK:
            case TH1_UN_A:
            case TH1_UN_E:
            	{
            		alt61=5;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 61;
                EXCEPTION->state        = 0;


                goto rulethfUnitaryFormulaEx;

            }

            switch (alt61)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1239:5: variable[p.d_expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_variable_in_thfUnitaryFormula2995);
        	        variable(ctx, p.d_expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1240:5: thfAtomicFormula[p]
        	    {
        	        FOLLOWPUSH(FOLLOW_thfAtomicFormula_in_thfUnitaryFormula3002);
        	        thfAtomicFormula(ctx, p);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1241:5: LPAREN_TOK thfLogicFormula[p] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_thfUnitaryFormula3009);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_thfLogicFormula_in_thfUnitaryFormula3015);
        	        thfLogicFormula(ctx, p);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_thfUnitaryFormula3022);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1244:5: NOT_TOK ( thfUnitaryFormula[p1] )?
        	    {
        	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_thfUnitaryFormula3028);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	        {

        	                  p.d_kind = api::NOT;
        	                
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1248:5: ( thfUnitaryFormula[p1] )?
        	        {
        	            int alt59=2;
        	            switch ( LA(1) )
        	            {
        	                case CHOICE_TOK:
        	                case CNF_TOK:
        	                case DEF_DESC_TOK:
        	                case DISTINCT_OBJECT:
        	                case EXISTS_TOK:
        	                case FALSE_TOK:
        	                case FOF_TOK:
        	                case FORALL_TOK:
        	                case INCLUDE_TOK:
        	                case LAMBDA_TOK:
        	                case LOWER_WORD:
        	                case LOWER_WORD_SINGLE_QUOTED:
        	                case LPAREN_TOK:
        	                case NOT_TOK:
        	                case NUMBER:
        	                case SINGLE_QUOTED:
        	                case TFF_TOK:
        	                case TH1_UN_A:
        	                case TH1_UN_E:
        	                case THF_TOK:
        	                case TRUE_TOK:
        	                case TYPE_TOK:
        	                case UPPER_WORD:
        	                case 64:
        	                case 65:
        	                case 66:
        	                case 67:
        	                case 68:
        	                case 69:
        	                case 70:
        	                case 71:
        	                case 73:
        	                case 74:
        	                case 75:
        	                case 77:
        	                case 79:
        	                case 80:
        	                case 81:
        	                case 82:
        	                case 83:
        	                case 84:
        	                case 85:
        	                case 86:
        	                case 87:
        	                case 88:
        	                case 89:
        	                case 91:
        	                case 92:
        	                case 93:
        	                case 94:
        	                case 95:
        	                	{
        	                		alt59=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt59)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1249:6: thfUnitaryFormula[p1]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_thfUnitaryFormula_in_thfUnitaryFormula3047);
        	        	        thfUnitaryFormula(ctx, p1);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfUnitaryFormulaEx;
        	        	        }


        	        	        {

        	        	                   if (p1.d_expr.isNull())
        	        	                   {
        	        	                     PARSER_STATE->parseError("NOT must be applied to a formula");
        	        	                   }
        	        	                   std::vector<api::Term> args{p1.d_expr};
        	        	                   p.d_expr = PARSER_STATE->applyParseOp(p, args);
        	        	                 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1260:5: thfQuantifier[p.d_kind] LBRACK_TOK thfBindVariable[expr] ( COMMA_TOK thfBindVariable[expr] )* RBRACK_TOK COLON_TOK thfUnitaryFormula[p1]
        	    {
        	        FOLLOWPUSH(FOLLOW_thfQuantifier_in_thfUnitaryFormula3073);
        	        thfQuantifier(ctx, p.d_kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	         MATCHT(LBRACK_TOK, &FOLLOW_LBRACK_TOK_in_thfUnitaryFormula3080);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	        {
        	            PARSER_STATE->pushScope();
        	        }


        	        FOLLOWPUSH(FOLLOW_thfBindVariable_in_thfUnitaryFormula3088);
        	        thfBindVariable(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	        {

        	                  bv.push_back(expr);
        	                
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1266:5: ( COMMA_TOK thfBindVariable[expr] )*

        	        for (;;)
        	        {
        	            int alt60=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA_TOK:
        	            	{
        	            		alt60=1;
        	            	}
        	                break;

        	            }

        	            switch (alt60)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1266:7: COMMA_TOK thfBindVariable[expr]
        	        	    {
        	        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_thfUnitaryFormula3103);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfUnitaryFormulaEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_thfBindVariable_in_thfUnitaryFormula3105);
        	        	        thfBindVariable(ctx, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulethfUnitaryFormulaEx;
        	        	        }


        	        	        {

        	        	                    bv.push_back(expr);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop60;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop60: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RBRACK_TOK, &FOLLOW_RBRACK_TOK_in_thfUnitaryFormula3127);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	         MATCHT(COLON_TOK, &FOLLOW_COLON_TOK_in_thfUnitaryFormula3129);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_thfUnitaryFormula_in_thfUnitaryFormula3135);
        	        thfUnitaryFormula(ctx, p1);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfUnitaryFormulaEx;
        	        }


        	        {

        	                  if (p1.d_expr.isNull())
        	                  {
        	                    PARSER_STATE->parseError("In scope of binder there must be a formula.");
        	                  }
        	                  expr = p1.d_expr;
        	                  PARSER_STATE->popScope();
        	                  // handle lambda case, in which case return type must be flattened and the
        	                  // auxiliary variables introduced in the proccess must be added no the
        	                  // variable list
        	                  //
        	                  // see documentation of mkFlatFunctionType for how it's done
        	                  //
        	                  // flatten body via flattening its type
        	                  std::vector<api::Sort> sorts;
        	                  std::vector<api::Term> flattenVars;
        	                  PARSER_STATE->mkFlatFunctionType(sorts, expr.getSort(), flattenVars);
        	                  if (!flattenVars.empty())
        	                  {
        	                    // apply body of lambda to flatten vars
        	                    expr = PARSER_STATE->mkHoApply(expr, flattenVars);
        	                    // add variables to BOUND_VAR_LIST
        	                    bv.insert(bv.end(), flattenVars.begin(), flattenVars.end());
        	                  }
        	                  p.d_expr = MK_TERM(p.d_kind, MK_TERM(api::BOUND_VAR_LIST, bv), expr);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulethfUnitaryFormulaEx; /* Prevent compiler warnings */
    rulethfUnitaryFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end thfUnitaryFormula */

/**
 * $ANTLR start tffFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1303:1: tffFormula[CVC4::api::Term& expr] : tffLogicFormula[expr] ;
 */
static void
tffFormula(pTptpParser ctx, CVC4::api::Term& expr)
{
    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1303:35: ( tffLogicFormula[expr] )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1303:37: tffLogicFormula[expr]
        {
            FOLLOWPUSH(FOLLOW_tffLogicFormula_in_tffFormula3158);
            tffLogicFormula(ctx, expr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletffFormulaEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletffFormulaEx; /* Prevent compiler warnings */
    ruletffFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tffFormula */

/**
 * $ANTLR start tffTypedAtom
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1305:1: tffTypedAtom[CVC4::Command*& cmd] : ( LPAREN_TOK tffTypedAtom[cmd] RPAREN_TOK | nameN[name] COLON_TOK ( '$tType' | parseType[type] ) );
 */
static void
tffTypedAtom(pTptpParser ctx, CVC4::Command*& cmd)
{

      CVC4::api::Term expr;
      CVC4::api::Sort type;
      std::string name;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1311:3: ( LPAREN_TOK tffTypedAtom[cmd] RPAREN_TOK | nameN[name] COLON_TOK ( '$tType' | parseType[type] ) )

            ANTLR3_UINT32 alt63;

            alt63=2;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		alt63=1;
            	}
                break;
            case CNF_TOK:
            case FOF_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case NUMBER:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TYPE_TOK:
            	{
            		alt63=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 63;
                EXCEPTION->state        = 0;


                goto ruletffTypedAtomEx;

            }

            switch (alt63)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1311:5: LPAREN_TOK tffTypedAtom[cmd] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_tffTypedAtom3175);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffTypedAtomEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffTypedAtom_in_tffTypedAtom3177);
        	        tffTypedAtom(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffTypedAtomEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_tffTypedAtom3180);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffTypedAtomEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1312:5: nameN[name] COLON_TOK ( '$tType' | parseType[type] )
        	    {
        	        FOLLOWPUSH(FOLLOW_nameN_in_tffTypedAtom3186);
        	        nameN(ctx, name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffTypedAtomEx;
        	        }


        	         MATCHT(COLON_TOK, &FOLLOW_COLON_TOK_in_tffTypedAtom3189);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffTypedAtomEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1313:5: ( '$tType' | parseType[type] )
        	        {
        	            int alt62=2;
        	            switch ( LA(1) )
        	            {
        	            case 90:
        	            	{
        	            		alt62=1;
        	            	}
        	                break;
        	            case CNF_TOK:
        	            case DEFINED_SYMBOL:
        	            case FOF_TOK:
        	            case INCLUDE_TOK:
        	            case LOWER_WORD:
        	            case LOWER_WORD_SINGLE_QUOTED:
        	            case LPAREN_TOK:
        	            case SINGLE_QUOTED:
        	            case TFF_TOK:
        	            case THF_TOK:
        	            case TYPE_TOK:
        	            	{
        	            		alt62=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 62;
        	                EXCEPTION->state        = 0;


        	                goto ruletffTypedAtomEx;

        	            }

        	            switch (alt62)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1313:7: '$tType'
        	        	    {
        	        	         MATCHT(90, &FOLLOW_90_in_tffTypedAtom3197);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletffTypedAtomEx;
        	        	        }


        	        	        {
        	        	             if(PARSER_STATE->isDeclared(name, SYM_SORT)) {
        	        	                      // duplicate declaration is fine, they're compatible
        	        	                      cmd = new EmptyCommand("compatible redeclaration of sort " + name);
        	        	                    } else if(PARSER_STATE->isDeclared(name, SYM_VARIABLE)) {
        	        	                      // error: cannot be both sort and constant
        	        	                      PARSER_STATE->parseError("Symbol `" + name + "' previously declared as a constant; cannot also be a sort");
        	        	                    } else {
        	        	                      // as yet, it's undeclared
        	        	                      api::Sort atype = PARSER_STATE->mkSort(name);
        	        	                      cmd = new DeclareTypeCommand(name, 0, atype.getType());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1326:7: parseType[type]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_parseType_in_tffTypedAtom3213);
        	        	        parseType(ctx, type);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletffTypedAtomEx;
        	        	        }


        	        	        {
        	        	             if(PARSER_STATE->isDeclared(name, SYM_SORT)) {
        	        	                      // error: cannot be both sort and constant
        	        	                      PARSER_STATE->parseError("Symbol `" + name + "' previously declared as a sort");
        	        	                      cmd = new EmptyCommand("compatible redeclaration of sort " + name);
        	        	                    } else if(PARSER_STATE->isDeclared(name, SYM_VARIABLE)) {
        	        	                      if(type == PARSER_STATE->getVariable(name).getSort()) {
        	        	                        // duplicate declaration is fine, they're compatible
        	        	                        cmd = new EmptyCommand("compatible redeclaration of constant " + name);
        	        	                      } else {
        	        	                        // error: sorts incompatible
        	        	                        PARSER_STATE->parseError("Symbol `" + name + "' declared previously with a different sort");
        	        	                      }
        	        	                    } else {
        	        	                      // as yet, it's undeclared
        	        	                      CVC4::api::Term aexpr = PARSER_STATE->bindVar(name, type);
        	        	                      cmd =
        	        	                          new DeclareFunctionCommand(name, aexpr.getExpr(), type.getType());
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletffTypedAtomEx; /* Prevent compiler warnings */
    ruletffTypedAtomEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tffTypedAtom */

/**
 * $ANTLR start tffLogicFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1349:1: tffLogicFormula[CVC4::api::Term& expr] : tffUnitaryFormula[expr] ( ( fofBinaryNonAssoc[na] tffUnitaryFormula[expr2] ) | ( ( AND_TOK tffUnitaryFormula[expr] )+ ) | ( ( OR_TOK tffUnitaryFormula[expr] )+ ) )? ;
 */
static void
tffLogicFormula(pTptpParser ctx, CVC4::api::Term& expr)
{

      tptp::NonAssoc na;
      std::vector< CVC4::api::Term > args;
      CVC4::api::Term expr2;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1355:3: ( tffUnitaryFormula[expr] ( ( fofBinaryNonAssoc[na] tffUnitaryFormula[expr2] ) | ( ( AND_TOK tffUnitaryFormula[expr] )+ ) | ( ( OR_TOK tffUnitaryFormula[expr] )+ ) )? )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1355:5: tffUnitaryFormula[expr] ( ( fofBinaryNonAssoc[na] tffUnitaryFormula[expr2] ) | ( ( AND_TOK tffUnitaryFormula[expr] )+ ) | ( ( OR_TOK tffUnitaryFormula[expr] )+ ) )?
        {
            FOLLOWPUSH(FOLLOW_tffUnitaryFormula_in_tffLogicFormula3247);
            tffUnitaryFormula(ctx, expr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletffLogicFormulaEx;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1356:5: ( ( fofBinaryNonAssoc[na] tffUnitaryFormula[expr2] ) | ( ( AND_TOK tffUnitaryFormula[expr] )+ ) | ( ( OR_TOK tffUnitaryFormula[expr] )+ ) )?
            {
                int alt66=4;
                switch ( LA(1) )
                {
                    case IFF_TOK:
                    case IMPLIES_TOK:
                    case REVAND_TOK:
                    case REVIFF_TOK:
                    case REVIMPLIES_TOK:
                    case REVOR_TOK:
                    	{
                    		alt66=1;
                    	}
                        break;
                    case AND_TOK:
                    	{
                    		alt66=2;
                    	}
                        break;
                    case OR_TOK:
                    	{
                    		alt66=3;
                    	}
                        break;
                }

                switch (alt66)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1357:7: ( fofBinaryNonAssoc[na] tffUnitaryFormula[expr2] )
            	    {
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1357:7: ( fofBinaryNonAssoc[na] tffUnitaryFormula[expr2] )
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1357:9: fofBinaryNonAssoc[na] tffUnitaryFormula[expr2]
            	        {
            	            FOLLOWPUSH(FOLLOW_fofBinaryNonAssoc_in_tffLogicFormula3265);
            	            fofBinaryNonAssoc(ctx, na);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruletffLogicFormulaEx;
            	            }


            	            FOLLOWPUSH(FOLLOW_tffUnitaryFormula_in_tffLogicFormula3268);
            	            tffUnitaryFormula(ctx, expr2);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruletffLogicFormulaEx;
            	            }


            	            {
            	                 switch(na) {
            	                           case tptp::NA_IFF:
            	                             expr = MK_TERM(api::EQUAL,expr,expr2);
            	                             break;
            	                           case tptp::NA_REVIFF:
            	                             expr = MK_TERM(api::XOR,expr,expr2);
            	                             break;
            	                           case tptp::NA_IMPLIES:
            	                             expr = MK_TERM(api::IMPLIES,expr,expr2);
            	                             break;
            	                           case tptp::NA_REVIMPLIES:
            	                             expr = MK_TERM(api::IMPLIES,expr2,expr);
            	                             break;
            	                           case tptp::NA_REVOR:
            	                             expr = MK_TERM(api::NOT,MK_TERM(api::OR,expr,expr2));
            	                             break;
            	                           case tptp::NA_REVAND:
            	                             expr = MK_TERM(api::NOT,MK_TERM(api::AND,expr,expr2));
            	                             break;
            	                          }
            	                        
            	            }


            	        }


            	    }
            	    break;
            	case 2:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1381:7: ( ( AND_TOK tffUnitaryFormula[expr] )+ )
            	    {
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1381:7: ( ( AND_TOK tffUnitaryFormula[expr] )+ )
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1381:9: ( AND_TOK tffUnitaryFormula[expr] )+
            	        {
            	            {
            	                 args.push_back(expr); 
            	            }


            	            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1382:9: ( AND_TOK tffUnitaryFormula[expr] )+
            	            {
            	                int cnt64=0;

            	                for (;;)
            	                {
            	                    int alt64=2;
            	            	switch ( LA(1) )
            	            	{
            	            	case AND_TOK:
            	            		{
            	            			alt64=1;
            	            		}
            	            	    break;

            	            	}

            	            	switch (alt64)
            	            	{
            	            	    case 1:
            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1382:11: AND_TOK tffUnitaryFormula[expr]
            	            	        {
            	            	             MATCHT(AND_TOK, &FOLLOW_AND_TOK_in_tffLogicFormula3316);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto ruletffLogicFormulaEx;
            	            	            }


            	            	            FOLLOWPUSH(FOLLOW_tffUnitaryFormula_in_tffLogicFormula3318);
            	            	            tffUnitaryFormula(ctx, expr);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto ruletffLogicFormulaEx;
            	            	            }


            	            	            {
            	            	                 args.push_back(expr); 
            	            	            }


            	            	        }
            	            	        break;

            	            	    default:

            	            		if ( cnt64 >= 1 )
            	            		{
            	            		    goto loop64;
            	            		}
            	            		/* mismatchedSetEx()
            	            		 */
            	            		CONSTRUCTEX();
            	            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            		goto ruletffLogicFormulaEx;
            	            	}
            	            	cnt64++;
            	                }
            	                loop64: ;	/* Jump to here if this rule does not match */
            	            }

            	            {
            	                 expr = MK_TERM(api::AND,args); 
            	            }


            	        }


            	    }
            	    break;
            	case 3:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1386:7: ( ( OR_TOK tffUnitaryFormula[expr] )+ )
            	    {
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1386:7: ( ( OR_TOK tffUnitaryFormula[expr] )+ )
            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1386:9: ( OR_TOK tffUnitaryFormula[expr] )+
            	        {
            	            {
            	                 args.push_back(expr); 
            	            }


            	            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1387:9: ( OR_TOK tffUnitaryFormula[expr] )+
            	            {
            	                int cnt65=0;

            	                for (;;)
            	                {
            	                    int alt65=2;
            	            	switch ( LA(1) )
            	            	{
            	            	case OR_TOK:
            	            		{
            	            			alt65=1;
            	            		}
            	            	    break;

            	            	}

            	            	switch (alt65)
            	            	{
            	            	    case 1:
            	            	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1387:11: OR_TOK tffUnitaryFormula[expr]
            	            	        {
            	            	             MATCHT(OR_TOK, &FOLLOW_OR_TOK_in_tffLogicFormula3371);
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto ruletffLogicFormulaEx;
            	            	            }


            	            	            FOLLOWPUSH(FOLLOW_tffUnitaryFormula_in_tffLogicFormula3373);
            	            	            tffUnitaryFormula(ctx, expr);

            	            	            FOLLOWPOP();
            	            	            if  (HASEXCEPTION())
            	            	            {
            	            	                goto ruletffLogicFormulaEx;
            	            	            }


            	            	            {
            	            	                 args.push_back(expr); 
            	            	            }


            	            	        }
            	            	        break;

            	            	    default:

            	            		if ( cnt65 >= 1 )
            	            		{
            	            		    goto loop65;
            	            		}
            	            		/* mismatchedSetEx()
            	            		 */
            	            		CONSTRUCTEX();
            	            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            	            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            	            		goto ruletffLogicFormulaEx;
            	            	}
            	            	cnt65++;
            	                }
            	                loop65: ;	/* Jump to here if this rule does not match */
            	            }

            	            {
            	                 expr = MK_TERM(api::OR,args); 
            	            }


            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletffLogicFormulaEx; /* Prevent compiler warnings */
    ruletffLogicFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tffLogicFormula */

/**
 * $ANTLR start tffUnitaryFormula
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1393:1: tffUnitaryFormula[CVC4::api::Term& expr] : ( atomicFormula[expr] | LPAREN_TOK tffLogicFormula[expr] RPAREN_TOK | NOT_TOK tffUnitaryFormula[expr] | folQuantifier[kind] LBRACK_TOK ( tffbindvariable[expr] ( COMMA_TOK tffbindvariable[expr] )* ) RBRACK_TOK COLON_TOK tffUnitaryFormula[expr] | '$ite_f' LPAREN_TOK tffLogicFormula[expr] COMMA_TOK tffLogicFormula[lhs] COMMA_TOK tffLogicFormula[rhs] RPAREN_TOK | '$let_tf' LPAREN_TOK tffLetTermDefn[lhs, rhs] COMMA_TOK tffFormula[expr] RPAREN_TOK | '$let_ff' LPAREN_TOK tffLetFormulaDefn[lhs, rhs] COMMA_TOK tffFormula[expr] RPAREN_TOK );
 */
static void
tffUnitaryFormula(pTptpParser ctx, CVC4::api::Term& expr)
{

      api::Kind kind;
      std::vector< CVC4::api::Term > bv;
      CVC4::api::Term lhs, rhs;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1399:3: ( atomicFormula[expr] | LPAREN_TOK tffLogicFormula[expr] RPAREN_TOK | NOT_TOK tffUnitaryFormula[expr] | folQuantifier[kind] LBRACK_TOK ( tffbindvariable[expr] ( COMMA_TOK tffbindvariable[expr] )* ) RBRACK_TOK COLON_TOK tffUnitaryFormula[expr] | '$ite_f' LPAREN_TOK tffLogicFormula[expr] COMMA_TOK tffLogicFormula[lhs] COMMA_TOK tffLogicFormula[rhs] RPAREN_TOK | '$let_tf' LPAREN_TOK tffLetTermDefn[lhs, rhs] COMMA_TOK tffFormula[expr] RPAREN_TOK | '$let_ff' LPAREN_TOK tffLetFormulaDefn[lhs, rhs] COMMA_TOK tffFormula[expr] RPAREN_TOK )

            ANTLR3_UINT32 alt68;

            alt68=7;

            switch ( LA(1) )
            {
            case AND_TOK:
            case CNF_TOK:
            case DISTINCT_OBJECT:
            case FALSE_TOK:
            case FOF_TOK:
            case IMPLIES_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case NUMBER:
            case OR_TOK:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TRUE_TOK:
            case TYPE_TOK:
            case UPPER_WORD:
            case 64:
            case 65:
            case 66:
            case 67:
            case 68:
            case 69:
            case 70:
            case 71:
            case 73:
            case 74:
            case 75:
            case 77:
            case 79:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt68=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt68=2;
            	}
                break;
            case NOT_TOK:
            	{
            		alt68=3;
            	}
                break;
            case EXISTS_TOK:
            case FORALL_TOK:
            	{
            		alt68=4;
            	}
                break;
            case 72:
            	{
            		alt68=5;
            	}
                break;
            case 78:
            	{
            		alt68=6;
            	}
                break;
            case 76:
            	{
            		alt68=7;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 68;
                EXCEPTION->state        = 0;


                goto ruletffUnitaryFormulaEx;

            }

            switch (alt68)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1399:5: atomicFormula[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_atomicFormula_in_tffUnitaryFormula3423);
        	        atomicFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1400:5: LPAREN_TOK tffLogicFormula[expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3430);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffLogicFormula_in_tffUnitaryFormula3432);
        	        tffLogicFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3435);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1401:5: NOT_TOK tffUnitaryFormula[expr]
        	    {
        	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_tffUnitaryFormula3441);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffUnitaryFormula_in_tffUnitaryFormula3443);
        	        tffUnitaryFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        {
        	             expr = MK_TERM(api::NOT,expr); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1403:5: folQuantifier[kind] LBRACK_TOK ( tffbindvariable[expr] ( COMMA_TOK tffbindvariable[expr] )* ) RBRACK_TOK COLON_TOK tffUnitaryFormula[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_folQuantifier_in_tffUnitaryFormula3457);
        	        folQuantifier(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	         MATCHT(LBRACK_TOK, &FOLLOW_LBRACK_TOK_in_tffUnitaryFormula3460);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        {
        	            PARSER_STATE->pushScope();
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1404:5: ( tffbindvariable[expr] ( COMMA_TOK tffbindvariable[expr] )* )
        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1404:7: tffbindvariable[expr] ( COMMA_TOK tffbindvariable[expr] )*
        	        {
        	            FOLLOWPUSH(FOLLOW_tffbindvariable_in_tffUnitaryFormula3470);
        	            tffbindvariable(ctx, expr);

        	            FOLLOWPOP();
        	            if  (HASEXCEPTION())
        	            {
        	                goto ruletffUnitaryFormulaEx;
        	            }


        	            {
        	                 bv.push_back(expr); 
        	            }


        	            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1405:7: ( COMMA_TOK tffbindvariable[expr] )*

        	            for (;;)
        	            {
        	                int alt67=2;
        	                switch ( LA(1) )
        	                {
        	                case COMMA_TOK:
        	                	{
        	                		alt67=1;
        	                	}
        	                    break;

        	                }

        	                switch (alt67)
        	                {
        	            	case 1:
        	            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1405:9: COMMA_TOK tffbindvariable[expr]
        	            	    {
        	            	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_tffUnitaryFormula3483);
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto ruletffUnitaryFormulaEx;
        	            	        }


        	            	        FOLLOWPUSH(FOLLOW_tffbindvariable_in_tffUnitaryFormula3485);
        	            	        tffbindvariable(ctx, expr);

        	            	        FOLLOWPOP();
        	            	        if  (HASEXCEPTION())
        	            	        {
        	            	            goto ruletffUnitaryFormulaEx;
        	            	        }


        	            	        {
        	            	             bv.push_back(expr); 
        	            	        }


        	            	    }
        	            	    break;

        	            	default:
        	            	    goto loop67;	/* break out of the loop */
        	            	    break;
        	                }
        	            }
        	            loop67: ; /* Jump out to here if this rule does not match */


        	        }


        	         MATCHT(RBRACK_TOK, &FOLLOW_RBRACK_TOK_in_tffUnitaryFormula3495);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	         MATCHT(COLON_TOK, &FOLLOW_COLON_TOK_in_tffUnitaryFormula3501);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffUnitaryFormula_in_tffUnitaryFormula3503);
        	        tffUnitaryFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  expr = MK_TERM(kind, MK_TERM(api::BOUND_VAR_LIST, bv), expr);
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1410:5: '$ite_f' LPAREN_TOK tffLogicFormula[expr] COMMA_TOK tffLogicFormula[lhs] COMMA_TOK tffLogicFormula[rhs] RPAREN_TOK
        	    {
        	         MATCHT(72, &FOLLOW_72_in_tffUnitaryFormula3516);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3518);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffLogicFormula_in_tffUnitaryFormula3520);
        	        tffLogicFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_tffUnitaryFormula3523);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffLogicFormula_in_tffUnitaryFormula3525);
        	        tffLogicFormula(ctx, lhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_tffUnitaryFormula3528);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffLogicFormula_in_tffUnitaryFormula3530);
        	        tffLogicFormula(ctx, rhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3533);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        {
        	             expr = MK_TERM(api::ITE, expr, lhs, rhs); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1412:5: '$let_tf' LPAREN_TOK tffLetTermDefn[lhs, rhs] COMMA_TOK tffFormula[expr] RPAREN_TOK
        	    {
        	         MATCHT(78, &FOLLOW_78_in_tffUnitaryFormula3545);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3547);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_tffLetTermDefn_in_tffUnitaryFormula3555);
        	        tffLetTermDefn(ctx, lhs, rhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_tffUnitaryFormula3558);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffFormula_in_tffUnitaryFormula3564);
        	        tffFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  expr = expr.substitute(lhs, rhs);
        	                
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3577);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1419:5: '$let_ff' LPAREN_TOK tffLetFormulaDefn[lhs, rhs] COMMA_TOK tffFormula[expr] RPAREN_TOK
        	    {
        	         MATCHT(76, &FOLLOW_76_in_tffUnitaryFormula3583);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_tffUnitaryFormula3585);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_tffLetFormulaDefn_in_tffUnitaryFormula3593);
        	        tffLetFormulaDefn(ctx, lhs, rhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_tffUnitaryFormula3596);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffFormula_in_tffUnitaryFormula3602);
        	        tffFormula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	        {
        	             PARSER_STATE->popScope();
        	                  expr = expr.substitute(lhs, rhs);
        	                
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_tffUnitaryFormula3615);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffUnitaryFormulaEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletffUnitaryFormulaEx; /* Prevent compiler warnings */
    ruletffUnitaryFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tffUnitaryFormula */

/**
 * $ANTLR start tffLetTermDefn
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1428:1: tffLetTermDefn[CVC4::api::Term& lhs, CVC4::api::Term& rhs] : ( FORALL_TOK LBRACK_TOK tffVariableList[bvlist] RBRACK_TOK COLON_TOK )* tffLetTermBinding[bvlist, lhs, rhs] ;
 */
static void
tffLetTermDefn(pTptpParser ctx, CVC4::api::Term& lhs, CVC4::api::Term& rhs)
{

      std::vector<CVC4::api::Term> bvlist;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1432:3: ( ( FORALL_TOK LBRACK_TOK tffVariableList[bvlist] RBRACK_TOK COLON_TOK )* tffLetTermBinding[bvlist, lhs, rhs] )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1432:5: ( FORALL_TOK LBRACK_TOK tffVariableList[bvlist] RBRACK_TOK COLON_TOK )* tffLetTermBinding[bvlist, lhs, rhs]
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1432:5: ( FORALL_TOK LBRACK_TOK tffVariableList[bvlist] RBRACK_TOK COLON_TOK )*

            for (;;)
            {
                int alt69=2;
                switch ( LA(1) )
                {
                case FORALL_TOK:
                	{
                		alt69=1;
                	}
                    break;

                }

                switch (alt69)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1432:6: FORALL_TOK LBRACK_TOK tffVariableList[bvlist] RBRACK_TOK COLON_TOK
            	    {
            	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_tffLetTermDefn3635);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffLetTermDefnEx;
            	        }


            	         MATCHT(LBRACK_TOK, &FOLLOW_LBRACK_TOK_in_tffLetTermDefn3637);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffLetTermDefnEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_tffVariableList_in_tffLetTermDefn3639);
            	        tffVariableList(ctx, bvlist);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffLetTermDefnEx;
            	        }


            	         MATCHT(RBRACK_TOK, &FOLLOW_RBRACK_TOK_in_tffLetTermDefn3642);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffLetTermDefnEx;
            	        }


            	         MATCHT(COLON_TOK, &FOLLOW_COLON_TOK_in_tffLetTermDefn3644);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffLetTermDefnEx;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop69;	/* break out of the loop */
            	    break;
                }
            }
            loop69: ; /* Jump out to here if this rule does not match */


            FOLLOWPUSH(FOLLOW_tffLetTermBinding_in_tffLetTermDefn3652);
            tffLetTermBinding(ctx, bvlist, lhs, rhs);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletffLetTermDefnEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletffLetTermDefnEx; /* Prevent compiler warnings */
    ruletffLetTermDefnEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tffLetTermDefn */

/**
 * $ANTLR start tffLetTermBinding
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1436:1: tffLetTermBinding[std::vector<CVC4::api::Term> & bvlist,\n CVC4::api::Term& lhs,\n CVC4::api::Term& rhs] : ( term[lhs] EQUAL_TOK term[rhs] | LPAREN_TOK tffLetTermBinding[bvlist, lhs, rhs] RPAREN_TOK );
 */
static void
tffLetTermBinding(pTptpParser ctx, std::vector<CVC4::api::Term> & bvlist, CVC4::api::Term& lhs, CVC4::api::Term& rhs)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1439:3: ( term[lhs] EQUAL_TOK term[rhs] | LPAREN_TOK tffLetTermBinding[bvlist, lhs, rhs] RPAREN_TOK )

            ANTLR3_UINT32 alt70;

            alt70=2;

            switch ( LA(1) )
            {
            case CNF_TOK:
            case DISTINCT_OBJECT:
            case FOF_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case NUMBER:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TYPE_TOK:
            case UPPER_WORD:
            case 64:
            case 65:
            case 67:
            case 73:
            case 77:
            case 79:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt70=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt70=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 70;
                EXCEPTION->state        = 0;


                goto ruletffLetTermBindingEx;

            }

            switch (alt70)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1439:5: term[lhs] EQUAL_TOK term[rhs]
        	    {
        	        FOLLOWPUSH(FOLLOW_term_in_tffLetTermBinding3667);
        	        term(ctx, lhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetTermBindingEx;
        	        }


        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_tffLetTermBinding3670);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetTermBindingEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_tffLetTermBinding3672);
        	        term(ctx, rhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetTermBindingEx;
        	        }


        	        {

        	                PARSER_STATE->checkLetBinding(bvlist, lhs, rhs, false);
        	                std::vector<api::Term> lchildren(++lhs.begin(), lhs.end());
        	                rhs = MK_TERM(api::LAMBDA, MK_TERM(api::BOUND_VAR_LIST, lchildren), rhs);
        	                lhs = api::Term(SOLVER, lhs.getExpr().getOperator());
        	              
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1446:5: LPAREN_TOK tffLetTermBinding[bvlist, lhs, rhs] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_tffLetTermBinding3683);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetTermBindingEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffLetTermBinding_in_tffLetTermBinding3685);
        	        tffLetTermBinding(ctx, bvlist, lhs, rhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetTermBindingEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_tffLetTermBinding3688);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetTermBindingEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletffLetTermBindingEx; /* Prevent compiler warnings */
    ruletffLetTermBindingEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tffLetTermBinding */

/**
 * $ANTLR start tffLetFormulaDefn
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1449:1: tffLetFormulaDefn[CVC4::api::Term& lhs, CVC4::api::Term& rhs] : ( FORALL_TOK LBRACK_TOK tffVariableList[bvlist] RBRACK_TOK COLON_TOK )* tffLetFormulaBinding[bvlist, lhs, rhs] ;
 */
static void
tffLetFormulaDefn(pTptpParser ctx, CVC4::api::Term& lhs, CVC4::api::Term& rhs)
{

      std::vector<CVC4::api::Term> bvlist;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1453:3: ( ( FORALL_TOK LBRACK_TOK tffVariableList[bvlist] RBRACK_TOK COLON_TOK )* tffLetFormulaBinding[bvlist, lhs, rhs] )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1453:5: ( FORALL_TOK LBRACK_TOK tffVariableList[bvlist] RBRACK_TOK COLON_TOK )* tffLetFormulaBinding[bvlist, lhs, rhs]
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1453:5: ( FORALL_TOK LBRACK_TOK tffVariableList[bvlist] RBRACK_TOK COLON_TOK )*

            for (;;)
            {
                int alt71=2;
                switch ( LA(1) )
                {
                case FORALL_TOK:
                	{
                		alt71=1;
                	}
                    break;

                }

                switch (alt71)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1453:6: FORALL_TOK LBRACK_TOK tffVariableList[bvlist] RBRACK_TOK COLON_TOK
            	    {
            	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_tffLetFormulaDefn3708);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffLetFormulaDefnEx;
            	        }


            	         MATCHT(LBRACK_TOK, &FOLLOW_LBRACK_TOK_in_tffLetFormulaDefn3710);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffLetFormulaDefnEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_tffVariableList_in_tffLetFormulaDefn3712);
            	        tffVariableList(ctx, bvlist);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffLetFormulaDefnEx;
            	        }


            	         MATCHT(RBRACK_TOK, &FOLLOW_RBRACK_TOK_in_tffLetFormulaDefn3715);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffLetFormulaDefnEx;
            	        }


            	         MATCHT(COLON_TOK, &FOLLOW_COLON_TOK_in_tffLetFormulaDefn3717);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffLetFormulaDefnEx;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop71;	/* break out of the loop */
            	    break;
                }
            }
            loop71: ; /* Jump out to here if this rule does not match */


            FOLLOWPUSH(FOLLOW_tffLetFormulaBinding_in_tffLetFormulaDefn3725);
            tffLetFormulaBinding(ctx, bvlist, lhs, rhs);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletffLetFormulaDefnEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletffLetFormulaDefnEx; /* Prevent compiler warnings */
    ruletffLetFormulaDefnEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tffLetFormulaDefn */

/**
 * $ANTLR start tffLetFormulaBinding
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1457:1: tffLetFormulaBinding[std::vector<CVC4::api::Term> & bvlist,\n CVC4::api::Term& lhs,\n CVC4::api::Term& rhs] : ( atomicFormula[lhs] IFF_TOK tffUnitaryFormula[rhs] | LPAREN_TOK tffLetFormulaBinding[bvlist, lhs, rhs] RPAREN_TOK );
 */
static void
tffLetFormulaBinding(pTptpParser ctx, std::vector<CVC4::api::Term> & bvlist, CVC4::api::Term& lhs, CVC4::api::Term& rhs)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1461:3: ( atomicFormula[lhs] IFF_TOK tffUnitaryFormula[rhs] | LPAREN_TOK tffLetFormulaBinding[bvlist, lhs, rhs] RPAREN_TOK )

            ANTLR3_UINT32 alt72;

            alt72=2;

            switch ( LA(1) )
            {
            case AND_TOK:
            case CNF_TOK:
            case DISTINCT_OBJECT:
            case FALSE_TOK:
            case FOF_TOK:
            case IMPLIES_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case NUMBER:
            case OR_TOK:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TRUE_TOK:
            case TYPE_TOK:
            case UPPER_WORD:
            case 64:
            case 65:
            case 66:
            case 67:
            case 68:
            case 69:
            case 70:
            case 71:
            case 73:
            case 74:
            case 75:
            case 77:
            case 79:
            case 80:
            case 81:
            case 82:
            case 83:
            case 84:
            case 85:
            case 86:
            case 87:
            case 88:
            case 89:
            case 91:
            case 92:
            case 93:
            case 94:
            case 95:
            	{
            		alt72=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt72=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 72;
                EXCEPTION->state        = 0;


                goto ruletffLetFormulaBindingEx;

            }

            switch (alt72)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1461:5: atomicFormula[lhs] IFF_TOK tffUnitaryFormula[rhs]
        	    {
        	        FOLLOWPUSH(FOLLOW_atomicFormula_in_tffLetFormulaBinding3741);
        	        atomicFormula(ctx, lhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetFormulaBindingEx;
        	        }


        	         MATCHT(IFF_TOK, &FOLLOW_IFF_TOK_in_tffLetFormulaBinding3744);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetFormulaBindingEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffUnitaryFormula_in_tffLetFormulaBinding3746);
        	        tffUnitaryFormula(ctx, rhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetFormulaBindingEx;
        	        }


        	        {

        	                PARSER_STATE->checkLetBinding(bvlist, lhs, rhs, true);
        	                std::vector<api::Term> lchildren(++lhs.begin(), lhs.end());
        	                rhs = MK_TERM(api::LAMBDA, MK_TERM(api::BOUND_VAR_LIST, lchildren), rhs);
        	                lhs = api::Term(SOLVER, lhs.getExpr().getOperator());
        	              
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1468:5: LPAREN_TOK tffLetFormulaBinding[bvlist, lhs, rhs] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_tffLetFormulaBinding3757);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetFormulaBindingEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_tffLetFormulaBinding_in_tffLetFormulaBinding3759);
        	        tffLetFormulaBinding(ctx, bvlist, lhs, rhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetFormulaBindingEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_tffLetFormulaBinding3762);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletffLetFormulaBindingEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletffLetFormulaBindingEx; /* Prevent compiler warnings */
    ruletffLetFormulaBindingEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tffLetFormulaBinding */

/**
 * $ANTLR start thfBindVariable
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1471:1: thfBindVariable[CVC4::api::Term& expr] : UPPER_WORD ( COLON_TOK parseThfType[type] )? ;
 */
static void
thfBindVariable(pTptpParser ctx, CVC4::api::Term& expr)
{

      std::string name;
      CVC4::api::Sort type = PARSER_STATE->d_unsorted;

    pANTLR3_COMMON_TOKEN    UPPER_WORD6;

    /* Initialize rule variables
     */

    UPPER_WORD6       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1476:3: ( UPPER_WORD ( COLON_TOK parseThfType[type] )? )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1476:5: UPPER_WORD ( COLON_TOK parseThfType[type] )?
        {
            UPPER_WORD6 = (pANTLR3_COMMON_TOKEN) MATCHT(UPPER_WORD, &FOLLOW_UPPER_WORD_in_thfBindVariable3781);
            if  (HASEXCEPTION())
            {
                goto rulethfBindVariableEx;
            }


            {
                 name = AntlrInput::tokenText(UPPER_WORD6); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1478:5: ( COLON_TOK parseThfType[type] )?
            {
                int alt73=2;
                switch ( LA(1) )
                {
                    case COLON_TOK:
                    	{
                    		alt73=1;
                    	}
                        break;
                }

                switch (alt73)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1478:7: COLON_TOK parseThfType[type]
            	    {
            	         MATCHT(COLON_TOK, &FOLLOW_COLON_TOK_in_thfBindVariable3795);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulethfBindVariableEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_parseThfType_in_thfBindVariable3797);
            	        parseThfType(ctx, type);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulethfBindVariableEx;
            	        }


            	    }
            	    break;

                }
            }

            {

                      expr = PARSER_STATE->bindBoundVar(name, type);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulethfBindVariableEx; /* Prevent compiler warnings */
    rulethfBindVariableEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end thfBindVariable */

/**
 * $ANTLR start tffbindvariable
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1485:1: tffbindvariable[CVC4::api::Term& expr] : UPPER_WORD ( COLON_TOK parseType[type] )? ;
 */
static void
tffbindvariable(pTptpParser ctx, CVC4::api::Term& expr)
{

      CVC4::api::Sort type = PARSER_STATE->d_unsorted;

    pANTLR3_COMMON_TOKEN    UPPER_WORD7;

    /* Initialize rule variables
     */

    UPPER_WORD7       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1489:3: ( UPPER_WORD ( COLON_TOK parseType[type] )? )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1489:5: UPPER_WORD ( COLON_TOK parseType[type] )?
        {
            UPPER_WORD7 = (pANTLR3_COMMON_TOKEN) MATCHT(UPPER_WORD, &FOLLOW_UPPER_WORD_in_tffbindvariable3827);
            if  (HASEXCEPTION())
            {
                goto ruletffbindvariableEx;
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1490:5: ( COLON_TOK parseType[type] )?
            {
                int alt74=2;
                switch ( LA(1) )
                {
                    case COLON_TOK:
                    	{
                    		alt74=1;
                    	}
                        break;
                }

                switch (alt74)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1490:7: COLON_TOK parseType[type]
            	    {
            	         MATCHT(COLON_TOK, &FOLLOW_COLON_TOK_in_tffbindvariable3835);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffbindvariableEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_parseType_in_tffbindvariable3837);
            	        parseType(ctx, type);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffbindvariableEx;
            	        }


            	    }
            	    break;

                }
            }

            {
                 std::string name = AntlrInput::tokenText(UPPER_WORD7);
                      expr = PARSER_STATE->bindBoundVar(name, type);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletffbindvariableEx; /* Prevent compiler warnings */
    ruletffbindvariableEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tffbindvariable */

/**
 * $ANTLR start tffVariableList
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1498:1: tffVariableList[std::vector<CVC4::api::Term>& bvlist] : tffbindvariable[e] ( COMMA_TOK tffbindvariable[e] )* ;
 */
static void
tffVariableList(pTptpParser ctx, std::vector<CVC4::api::Term>& bvlist)
{

      CVC4::api::Term e;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1502:3: ( tffbindvariable[e] ( COMMA_TOK tffbindvariable[e] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1502:5: tffbindvariable[e] ( COMMA_TOK tffbindvariable[e] )*
        {
            FOLLOWPUSH(FOLLOW_tffbindvariable_in_tffVariableList3868);
            tffbindvariable(ctx, e);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletffVariableListEx;
            }


            {
                 bvlist.push_back(e); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1503:5: ( COMMA_TOK tffbindvariable[e] )*

            for (;;)
            {
                int alt75=2;
                switch ( LA(1) )
                {
                case COMMA_TOK:
                	{
                		alt75=1;
                	}
                    break;

                }

                switch (alt75)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1503:7: COMMA_TOK tffbindvariable[e]
            	    {
            	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_tffVariableList3879);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffVariableListEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_tffbindvariable_in_tffVariableList3881);
            	        tffbindvariable(ctx, e);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletffVariableListEx;
            	        }


            	        {
            	             bvlist.push_back(e); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop75;	/* break out of the loop */
            	    break;
                }
            }
            loop75: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletffVariableListEx; /* Prevent compiler warnings */
    ruletffVariableListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tffVariableList */

/**
 * $ANTLR start parseThfType
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1506:1: parseThfType[CVC4::api::Sort& type] : thfType[type] ( ( ARROW_TOK | TIMES_TOK ) thfType[type] )* ;
 */
static void
parseThfType(pTptpParser ctx, CVC4::api::Sort& type)
{

      std::vector<CVC4::api::Sort> sorts;

    /* Initialize rule variables
     */

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1511:3: ( thfType[type] ( ( ARROW_TOK | TIMES_TOK ) thfType[type] )* )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1511:5: thfType[type] ( ( ARROW_TOK | TIMES_TOK ) thfType[type] )*
        {
            FOLLOWPUSH(FOLLOW_thfType_in_parseThfType3907);
            thfType(ctx, type);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleparseThfTypeEx;
            }


            {
                 sorts.push_back(type); 
            }


            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1512:5: ( ( ARROW_TOK | TIMES_TOK ) thfType[type] )*

            for (;;)
            {
                int alt76=2;
                switch ( LA(1) )
                {
                case ARROW_TOK:
                case TIMES_TOK:
                	{
                		alt76=1;
                	}
                    break;

                }

                switch (alt76)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1513:6: ( ARROW_TOK | TIMES_TOK ) thfType[type]
            	    {
            	        if ( LA(1) == ARROW_TOK || LA(1) == TIMES_TOK )
            	        {
            	            CONSUME();
            	            PERRORRECOVERY=ANTLR3_FALSE;
            	        }
            	        else
            	        {
            	            CONSTRUCTEX();
            	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
            	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
            	            EXCEPTION->expectingSet = NULL;

            	            goto ruleparseThfTypeEx;
            	        }


            	        FOLLOWPUSH(FOLLOW_thfType_in_parseThfType3931);
            	        thfType(ctx, type);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparseThfTypeEx;
            	        }


            	        {
            	             sorts.push_back(type); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop76;	/* break out of the loop */
            	    break;
                }
            }
            loop76: ; /* Jump out to here if this rule does not match */


            {

                      if (sorts.size() < 1)
                      {
                        type = sorts[0];
                      }
                      else
                      {
                        api::Sort range = sorts.back();
                        sorts.pop_back();
                        type = PARSER_STATE->mkFlatFunctionType(sorts, range);
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleparseThfTypeEx; /* Prevent compiler warnings */
    ruleparseThfTypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end parseThfType */

/**
 * $ANTLR start thfType
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1529:1: thfType[CVC4::api::Sort& type] : ( simpleType[type] | LPAREN_TOK parseThfType[type] RPAREN_TOK | LBRACK_TOK parseThfType[type] RBRACK_TOK );
 */
static void
thfType(pTptpParser ctx, CVC4::api::Sort& type)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1531:3: ( simpleType[type] | LPAREN_TOK parseThfType[type] RPAREN_TOK | LBRACK_TOK parseThfType[type] RBRACK_TOK )

            ANTLR3_UINT32 alt77;

            alt77=3;

            switch ( LA(1) )
            {
            case CNF_TOK:
            case DEFINED_SYMBOL:
            case FOF_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TYPE_TOK:
            	{
            		alt77=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt77=2;
            	}
                break;
            case LBRACK_TOK:
            	{
            		alt77=3;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 77;
                EXCEPTION->state        = 0;


                goto rulethfTypeEx;

            }

            switch (alt77)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1531:5: simpleType[type]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleType_in_thfType3962);
        	        simpleType(ctx, type);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfTypeEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1532:7: LPAREN_TOK parseThfType[type] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_thfType3971);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfTypeEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_parseThfType_in_thfType3973);
        	        parseThfType(ctx, type);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfTypeEx;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_thfType3976);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfTypeEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1533:7: LBRACK_TOK parseThfType[type] RBRACK_TOK
        	    {
        	         MATCHT(LBRACK_TOK, &FOLLOW_LBRACK_TOK_in_thfType3984);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfTypeEx;
        	        }


        	        {
        	             UNSUPPORTED("Tuple types"); 
        	        }


        	        FOLLOWPUSH(FOLLOW_parseThfType_in_thfType3988);
        	        parseThfType(ctx, type);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfTypeEx;
        	        }


        	         MATCHT(RBRACK_TOK, &FOLLOW_RBRACK_TOK_in_thfType3991);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulethfTypeEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulethfTypeEx; /* Prevent compiler warnings */
    rulethfTypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end thfType */

/**
 * $ANTLR start parseType
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1536:1: parseType[CVC4::api::Sort & type] : ( simpleType[type] | ( simpleType[type] | LPAREN_TOK simpleType[type] ( TIMES_TOK simpleType[type] )+ RPAREN_TOK ) ARROW_TOK simpleType[type] );
 */
static void
parseType(pTptpParser ctx, CVC4::api::Sort & type)
{

      std::vector<CVC4::api::Sort> v;

    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1541:3: ( simpleType[type] | ( simpleType[type] | LPAREN_TOK simpleType[type] ( TIMES_TOK simpleType[type] )+ RPAREN_TOK ) ARROW_TOK simpleType[type] )

            ANTLR3_UINT32 alt80;

            alt80=2;

            switch ( LA(1) )
            {
            case DEFINED_SYMBOL:
            	{
            		switch ( LA(2) )
            		{
            		case COMMA_TOK:
            		case RBRACK_TOK:
            		case RPAREN_TOK:
            			{
            				alt80=1;
            			}
            		    break;
            		case ARROW_TOK:
            			{
            				alt80=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 80;
            		    EXCEPTION->state        = 1;


            		    goto ruleparseTypeEx;

            		}

            	}
                break;
            case FOF_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case COMMA_TOK:
            		case RBRACK_TOK:
            		case RPAREN_TOK:
            			{
            				alt80=1;
            			}
            		    break;
            		case ARROW_TOK:
            			{
            				alt80=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 80;
            		    EXCEPTION->state        = 2;


            		    goto ruleparseTypeEx;

            		}

            	}
                break;
            case CNF_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case COMMA_TOK:
            		case RBRACK_TOK:
            		case RPAREN_TOK:
            			{
            				alt80=1;
            			}
            		    break;
            		case ARROW_TOK:
            			{
            				alt80=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 80;
            		    EXCEPTION->state        = 3;


            		    goto ruleparseTypeEx;

            		}

            	}
                break;
            case THF_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case COMMA_TOK:
            		case RBRACK_TOK:
            		case RPAREN_TOK:
            			{
            				alt80=1;
            			}
            		    break;
            		case ARROW_TOK:
            			{
            				alt80=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 80;
            		    EXCEPTION->state        = 4;


            		    goto ruleparseTypeEx;

            		}

            	}
                break;
            case TFF_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case COMMA_TOK:
            		case RBRACK_TOK:
            		case RPAREN_TOK:
            			{
            				alt80=1;
            			}
            		    break;
            		case ARROW_TOK:
            			{
            				alt80=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 80;
            		    EXCEPTION->state        = 5;


            		    goto ruleparseTypeEx;

            		}

            	}
                break;
            case TYPE_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case COMMA_TOK:
            		case RBRACK_TOK:
            		case RPAREN_TOK:
            			{
            				alt80=1;
            			}
            		    break;
            		case ARROW_TOK:
            			{
            				alt80=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 80;
            		    EXCEPTION->state        = 6;


            		    goto ruleparseTypeEx;

            		}

            	}
                break;
            case INCLUDE_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case COMMA_TOK:
            		case RBRACK_TOK:
            		case RPAREN_TOK:
            			{
            				alt80=1;
            			}
            		    break;
            		case ARROW_TOK:
            			{
            				alt80=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 80;
            		    EXCEPTION->state        = 7;


            		    goto ruleparseTypeEx;

            		}

            	}
                break;
            case LOWER_WORD:
            	{
            		switch ( LA(2) )
            		{
            		case COMMA_TOK:
            		case RBRACK_TOK:
            		case RPAREN_TOK:
            			{
            				alt80=1;
            			}
            		    break;
            		case ARROW_TOK:
            			{
            				alt80=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 80;
            		    EXCEPTION->state        = 8;


            		    goto ruleparseTypeEx;

            		}

            	}
                break;
            case LOWER_WORD_SINGLE_QUOTED:
            	{
            		switch ( LA(2) )
            		{
            		case COMMA_TOK:
            		case RBRACK_TOK:
            		case RPAREN_TOK:
            			{
            				alt80=1;
            			}
            		    break;
            		case ARROW_TOK:
            			{
            				alt80=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 80;
            		    EXCEPTION->state        = 9;


            		    goto ruleparseTypeEx;

            		}

            	}
                break;
            case SINGLE_QUOTED:
            	{
            		switch ( LA(2) )
            		{
            		case COMMA_TOK:
            		case RBRACK_TOK:
            		case RPAREN_TOK:
            			{
            				alt80=1;
            			}
            		    break;
            		case ARROW_TOK:
            			{
            				alt80=2;
            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 80;
            		    EXCEPTION->state        = 10;


            		    goto ruleparseTypeEx;

            		}

            	}
                break;
            case LPAREN_TOK:
            	{
            		alt80=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 80;
                EXCEPTION->state        = 0;


                goto ruleparseTypeEx;

            }

            switch (alt80)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1541:5: simpleType[type]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleType_in_parseType4010);
        	        simpleType(ctx, type);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseTypeEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1542:5: ( simpleType[type] | LPAREN_TOK simpleType[type] ( TIMES_TOK simpleType[type] )+ RPAREN_TOK ) ARROW_TOK simpleType[type]
        	    {
        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1542:5: ( simpleType[type] | LPAREN_TOK simpleType[type] ( TIMES_TOK simpleType[type] )+ RPAREN_TOK )
        	        {
        	            int alt79=2;
        	            switch ( LA(1) )
        	            {
        	            case CNF_TOK:
        	            case DEFINED_SYMBOL:
        	            case FOF_TOK:
        	            case INCLUDE_TOK:
        	            case LOWER_WORD:
        	            case LOWER_WORD_SINGLE_QUOTED:
        	            case SINGLE_QUOTED:
        	            case TFF_TOK:
        	            case THF_TOK:
        	            case TYPE_TOK:
        	            	{
        	            		alt79=1;
        	            	}
        	                break;
        	            case LPAREN_TOK:
        	            	{
        	            		alt79=2;
        	            	}
        	                break;

        	            default:
        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 79;
        	                EXCEPTION->state        = 0;


        	                goto ruleparseTypeEx;

        	            }

        	            switch (alt79)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1542:7: simpleType[type]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleType_in_parseType4019);
        	        	        simpleType(ctx, type);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseTypeEx;
        	        	        }


        	        	        {
        	        	             v.push_back(type); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1543:7: LPAREN_TOK simpleType[type] ( TIMES_TOK simpleType[type] )+ RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseType4030);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseTypeEx;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_simpleType_in_parseType4032);
        	        	        simpleType(ctx, type);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseTypeEx;
        	        	        }


        	        	        {
        	        	             v.push_back(type); 
        	        	        }


        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1544:7: ( TIMES_TOK simpleType[type] )+
        	        	        {
        	        	            int cnt78=0;

        	        	            for (;;)
        	        	            {
        	        	                int alt78=2;
        	        	        	switch ( LA(1) )
        	        	        	{
        	        	        	case TIMES_TOK:
        	        	        		{
        	        	        			alt78=1;
        	        	        		}
        	        	        	    break;

        	        	        	}

        	        	        	switch (alt78)
        	        	        	{
        	        	        	    case 1:
        	        	        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1544:9: TIMES_TOK simpleType[type]
        	        	        	        {
        	        	        	             MATCHT(TIMES_TOK, &FOLLOW_TIMES_TOK_in_parseType4045);
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruleparseTypeEx;
        	        	        	            }


        	        	        	            FOLLOWPUSH(FOLLOW_simpleType_in_parseType4047);
        	        	        	            simpleType(ctx, type);

        	        	        	            FOLLOWPOP();
        	        	        	            if  (HASEXCEPTION())
        	        	        	            {
        	        	        	                goto ruleparseTypeEx;
        	        	        	            }


        	        	        	            {
        	        	        	                 v.push_back(type); 
        	        	        	            }


        	        	        	        }
        	        	        	        break;

        	        	        	    default:

        	        	        		if ( cnt78 >= 1 )
        	        	        		{
        	        	        		    goto loop78;
        	        	        		}
        	        	        		/* mismatchedSetEx()
        	        	        		 */
        	        	        		CONSTRUCTEX();
        	        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        	        		goto ruleparseTypeEx;
        	        	        	}
        	        	        	cnt78++;
        	        	            }
        	        	            loop78: ;	/* Jump to here if this rule does not match */
        	        	        }

        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseType4061);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleparseTypeEx;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(ARROW_TOK, &FOLLOW_ARROW_TOK_in_parseType4073);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseTypeEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_simpleType_in_parseType4075);
        	        simpleType(ctx, type);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseTypeEx;
        	        }


        	        {
        	             type = SOLVER->mkFunctionSort(v,type);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseTypeEx; /* Prevent compiler warnings */
    ruleparseTypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end parseType */

/**
 * $ANTLR start simpleType
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1553:1: simpleType[CVC4::api::Sort& type] : ( DEFINED_SYMBOL | atomicWord[name] );
 */
static void
simpleType(pTptpParser ctx, CVC4::api::Sort& type)
{

      std::string name;

    pANTLR3_COMMON_TOKEN    DEFINED_SYMBOL8;

    /* Initialize rule variables
     */

    DEFINED_SYMBOL8       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1557:3: ( DEFINED_SYMBOL | atomicWord[name] )

            ANTLR3_UINT32 alt81;

            alt81=2;

            switch ( LA(1) )
            {
            case DEFINED_SYMBOL:
            	{
            		alt81=1;
            	}
                break;
            case CNF_TOK:
            case FOF_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TYPE_TOK:
            	{
            		alt81=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 81;
                EXCEPTION->state        = 0;


                goto rulesimpleTypeEx;

            }

            switch (alt81)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1557:5: DEFINED_SYMBOL
        	    {
        	        DEFINED_SYMBOL8 = (pANTLR3_COMMON_TOKEN) MATCHT(DEFINED_SYMBOL, &FOLLOW_DEFINED_SYMBOL_in_simpleType4102);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTypeEx;
        	        }


        	        {
        	             std::string s = AntlrInput::tokenText(DEFINED_SYMBOL8);
        	                  if(s == "$i") type = PARSER_STATE->d_unsorted;
        	                  else if(s == "$o") type = SOLVER->getBooleanSort();
        	                  else if(s == "$int") type = SOLVER->getIntegerSort();
        	                  else if(s == "$rat") type = SOLVER->getRealSort();
        	                  else if(s == "$real") type = SOLVER->getRealSort();
        	                  else if(s == "$tType") PARSER_STATE->parseError("Type of types `$tType' cannot be used here");
        	                  else PARSER_STATE->parseError("unknown defined type `" + s + "'");
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1567:5: atomicWord[name]
        	    {
        	        FOLLOWPUSH(FOLLOW_atomicWord_in_simpleType4114);
        	        atomicWord(ctx, name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTypeEx;
        	        }


        	        {
        	             type = PARSER_STATE->getSort(name); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleTypeEx; /* Prevent compiler warnings */
    rulesimpleTypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleType */

/**
 * $ANTLR start anything
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1574:1: anything : ( LPAREN_TOK ( anything )* RPAREN_TOK | LBRACK_TOK ( anything )* RBRACK_TOK | COMMA_TOK | DOT_TOK | COLON_TOK | OR_TOK | NOT_TOK | FORALL_TOK | EXISTS_TOK | AND_TOK | IFF_TOK | IMPLIES_TOK | REVIMPLIES_TOK | REVIFF_TOK | REVOR_TOK | REVAND_TOK | TIMES_TOK | PLUS_TOK | MINUS_TOK | TRUE_TOK | FALSE_TOK | EQUAL_TOK | DISEQUAL_TOK | CNF_TOK | FOF_TOK | THF_TOK | TFF_TOK | TYPE_TOK | INCLUDE_TOK | DISTINCT_OBJECT | UPPER_WORD | LOWER_WORD | LOWER_WORD_SINGLE_QUOTED | SINGLE_QUOTED | NUMBER | DEFINED_SYMBOL );
 */
static void
anything(pTptpParser ctx)
{
    /* Initialize rule variables
     */

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1575:3: ( LPAREN_TOK ( anything )* RPAREN_TOK | LBRACK_TOK ( anything )* RBRACK_TOK | COMMA_TOK | DOT_TOK | COLON_TOK | OR_TOK | NOT_TOK | FORALL_TOK | EXISTS_TOK | AND_TOK | IFF_TOK | IMPLIES_TOK | REVIMPLIES_TOK | REVIFF_TOK | REVOR_TOK | REVAND_TOK | TIMES_TOK | PLUS_TOK | MINUS_TOK | TRUE_TOK | FALSE_TOK | EQUAL_TOK | DISEQUAL_TOK | CNF_TOK | FOF_TOK | THF_TOK | TFF_TOK | TYPE_TOK | INCLUDE_TOK | DISTINCT_OBJECT | UPPER_WORD | LOWER_WORD | LOWER_WORD_SINGLE_QUOTED | SINGLE_QUOTED | NUMBER | DEFINED_SYMBOL )

            ANTLR3_UINT32 alt84;

            alt84=36;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		alt84=1;
            	}
                break;
            case LBRACK_TOK:
            	{
            		alt84=2;
            	}
                break;
            case COMMA_TOK:
            	{
            		alt84=3;
            	}
                break;
            case DOT_TOK:
            	{
            		alt84=4;
            	}
                break;
            case COLON_TOK:
            	{
            		alt84=5;
            	}
                break;
            case OR_TOK:
            	{
            		alt84=6;
            	}
                break;
            case NOT_TOK:
            	{
            		alt84=7;
            	}
                break;
            case FORALL_TOK:
            	{
            		alt84=8;
            	}
                break;
            case EXISTS_TOK:
            	{
            		alt84=9;
            	}
                break;
            case AND_TOK:
            	{
            		alt84=10;
            	}
                break;
            case IFF_TOK:
            	{
            		alt84=11;
            	}
                break;
            case IMPLIES_TOK:
            	{
            		alt84=12;
            	}
                break;
            case REVIMPLIES_TOK:
            	{
            		alt84=13;
            	}
                break;
            case REVIFF_TOK:
            	{
            		alt84=14;
            	}
                break;
            case REVOR_TOK:
            	{
            		alt84=15;
            	}
                break;
            case REVAND_TOK:
            	{
            		alt84=16;
            	}
                break;
            case TIMES_TOK:
            	{
            		alt84=17;
            	}
                break;
            case PLUS_TOK:
            	{
            		alt84=18;
            	}
                break;
            case MINUS_TOK:
            	{
            		alt84=19;
            	}
                break;
            case TRUE_TOK:
            	{
            		alt84=20;
            	}
                break;
            case FALSE_TOK:
            	{
            		alt84=21;
            	}
                break;
            case EQUAL_TOK:
            	{
            		alt84=22;
            	}
                break;
            case DISEQUAL_TOK:
            	{
            		alt84=23;
            	}
                break;
            case CNF_TOK:
            	{
            		alt84=24;
            	}
                break;
            case FOF_TOK:
            	{
            		alt84=25;
            	}
                break;
            case THF_TOK:
            	{
            		alt84=26;
            	}
                break;
            case TFF_TOK:
            	{
            		alt84=27;
            	}
                break;
            case TYPE_TOK:
            	{
            		alt84=28;
            	}
                break;
            case INCLUDE_TOK:
            	{
            		alt84=29;
            	}
                break;
            case DISTINCT_OBJECT:
            	{
            		alt84=30;
            	}
                break;
            case UPPER_WORD:
            	{
            		alt84=31;
            	}
                break;
            case LOWER_WORD:
            	{
            		alt84=32;
            	}
                break;
            case LOWER_WORD_SINGLE_QUOTED:
            	{
            		alt84=33;
            	}
                break;
            case SINGLE_QUOTED:
            	{
            		alt84=34;
            	}
                break;
            case NUMBER:
            	{
            		alt84=35;
            	}
                break;
            case DEFINED_SYMBOL:
            	{
            		alt84=36;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 84;
                EXCEPTION->state        = 0;


                goto ruleanythingEx;

            }

            switch (alt84)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1575:5: LPAREN_TOK ( anything )* RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_anything4139);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1575:16: ( anything )*

        	        for (;;)
        	        {
        	            int alt82=2;
        	            switch ( LA(1) )
        	            {
        	            case AND_TOK:
        	            case CNF_TOK:
        	            case COLON_TOK:
        	            case COMMA_TOK:
        	            case DEFINED_SYMBOL:
        	            case DISEQUAL_TOK:
        	            case DISTINCT_OBJECT:
        	            case DOT_TOK:
        	            case EQUAL_TOK:
        	            case EXISTS_TOK:
        	            case FALSE_TOK:
        	            case FOF_TOK:
        	            case FORALL_TOK:
        	            case IFF_TOK:
        	            case IMPLIES_TOK:
        	            case INCLUDE_TOK:
        	            case LBRACK_TOK:
        	            case LOWER_WORD:
        	            case LOWER_WORD_SINGLE_QUOTED:
        	            case LPAREN_TOK:
        	            case MINUS_TOK:
        	            case NOT_TOK:
        	            case NUMBER:
        	            case OR_TOK:
        	            case PLUS_TOK:
        	            case REVAND_TOK:
        	            case REVIFF_TOK:
        	            case REVIMPLIES_TOK:
        	            case REVOR_TOK:
        	            case SINGLE_QUOTED:
        	            case TFF_TOK:
        	            case THF_TOK:
        	            case TIMES_TOK:
        	            case TRUE_TOK:
        	            case TYPE_TOK:
        	            case UPPER_WORD:
        	            	{
        	            		alt82=1;
        	            	}
        	                break;

        	            }

        	            switch (alt82)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1575:16: anything
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_anything_in_anything4141);
        	        	        anything(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleanythingEx;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop82;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop82: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_anything4144);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1576:5: LBRACK_TOK ( anything )* RBRACK_TOK
        	    {
        	         MATCHT(LBRACK_TOK, &FOLLOW_LBRACK_TOK_in_anything4150);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1576:16: ( anything )*

        	        for (;;)
        	        {
        	            int alt83=2;
        	            switch ( LA(1) )
        	            {
        	            case AND_TOK:
        	            case CNF_TOK:
        	            case COLON_TOK:
        	            case COMMA_TOK:
        	            case DEFINED_SYMBOL:
        	            case DISEQUAL_TOK:
        	            case DISTINCT_OBJECT:
        	            case DOT_TOK:
        	            case EQUAL_TOK:
        	            case EXISTS_TOK:
        	            case FALSE_TOK:
        	            case FOF_TOK:
        	            case FORALL_TOK:
        	            case IFF_TOK:
        	            case IMPLIES_TOK:
        	            case INCLUDE_TOK:
        	            case LBRACK_TOK:
        	            case LOWER_WORD:
        	            case LOWER_WORD_SINGLE_QUOTED:
        	            case LPAREN_TOK:
        	            case MINUS_TOK:
        	            case NOT_TOK:
        	            case NUMBER:
        	            case OR_TOK:
        	            case PLUS_TOK:
        	            case REVAND_TOK:
        	            case REVIFF_TOK:
        	            case REVIMPLIES_TOK:
        	            case REVOR_TOK:
        	            case SINGLE_QUOTED:
        	            case TFF_TOK:
        	            case THF_TOK:
        	            case TIMES_TOK:
        	            case TRUE_TOK:
        	            case TYPE_TOK:
        	            case UPPER_WORD:
        	            	{
        	            		alt83=1;
        	            	}
        	                break;

        	            }

        	            switch (alt83)
        	            {
        	        	case 1:
        	        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1576:16: anything
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_anything_in_anything4152);
        	        	        anything(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleanythingEx;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop83;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop83: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RBRACK_TOK, &FOLLOW_RBRACK_TOK_in_anything4155);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1577:5: COMMA_TOK
        	    {
        	         MATCHT(COMMA_TOK, &FOLLOW_COMMA_TOK_in_anything4161);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1578:5: DOT_TOK
        	    {
        	         MATCHT(DOT_TOK, &FOLLOW_DOT_TOK_in_anything4167);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1579:5: COLON_TOK
        	    {
        	         MATCHT(COLON_TOK, &FOLLOW_COLON_TOK_in_anything4173);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1580:5: OR_TOK
        	    {
        	         MATCHT(OR_TOK, &FOLLOW_OR_TOK_in_anything4179);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1581:5: NOT_TOK
        	    {
        	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_anything4185);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 8:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1582:5: FORALL_TOK
        	    {
        	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_anything4191);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 9:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1583:5: EXISTS_TOK
        	    {
        	         MATCHT(EXISTS_TOK, &FOLLOW_EXISTS_TOK_in_anything4197);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 10:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1584:5: AND_TOK
        	    {
        	         MATCHT(AND_TOK, &FOLLOW_AND_TOK_in_anything4203);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 11:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1585:5: IFF_TOK
        	    {
        	         MATCHT(IFF_TOK, &FOLLOW_IFF_TOK_in_anything4209);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 12:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1586:5: IMPLIES_TOK
        	    {
        	         MATCHT(IMPLIES_TOK, &FOLLOW_IMPLIES_TOK_in_anything4215);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 13:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1587:5: REVIMPLIES_TOK
        	    {
        	         MATCHT(REVIMPLIES_TOK, &FOLLOW_REVIMPLIES_TOK_in_anything4221);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 14:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1588:5: REVIFF_TOK
        	    {
        	         MATCHT(REVIFF_TOK, &FOLLOW_REVIFF_TOK_in_anything4227);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 15:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1589:5: REVOR_TOK
        	    {
        	         MATCHT(REVOR_TOK, &FOLLOW_REVOR_TOK_in_anything4233);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 16:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1590:5: REVAND_TOK
        	    {
        	         MATCHT(REVAND_TOK, &FOLLOW_REVAND_TOK_in_anything4239);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 17:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1591:5: TIMES_TOK
        	    {
        	         MATCHT(TIMES_TOK, &FOLLOW_TIMES_TOK_in_anything4245);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 18:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1592:5: PLUS_TOK
        	    {
        	         MATCHT(PLUS_TOK, &FOLLOW_PLUS_TOK_in_anything4251);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 19:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1593:5: MINUS_TOK
        	    {
        	         MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_anything4257);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 20:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1594:5: TRUE_TOK
        	    {
        	         MATCHT(TRUE_TOK, &FOLLOW_TRUE_TOK_in_anything4263);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 21:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1595:5: FALSE_TOK
        	    {
        	         MATCHT(FALSE_TOK, &FOLLOW_FALSE_TOK_in_anything4269);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 22:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1596:5: EQUAL_TOK
        	    {
        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_anything4275);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 23:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1597:5: DISEQUAL_TOK
        	    {
        	         MATCHT(DISEQUAL_TOK, &FOLLOW_DISEQUAL_TOK_in_anything4281);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 24:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1598:5: CNF_TOK
        	    {
        	         MATCHT(CNF_TOK, &FOLLOW_CNF_TOK_in_anything4287);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 25:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1599:5: FOF_TOK
        	    {
        	         MATCHT(FOF_TOK, &FOLLOW_FOF_TOK_in_anything4293);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 26:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1600:5: THF_TOK
        	    {
        	         MATCHT(THF_TOK, &FOLLOW_THF_TOK_in_anything4299);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 27:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1601:5: TFF_TOK
        	    {
        	         MATCHT(TFF_TOK, &FOLLOW_TFF_TOK_in_anything4305);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 28:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1602:5: TYPE_TOK
        	    {
        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_anything4311);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 29:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1603:5: INCLUDE_TOK
        	    {
        	         MATCHT(INCLUDE_TOK, &FOLLOW_INCLUDE_TOK_in_anything4317);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 30:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1604:5: DISTINCT_OBJECT
        	    {
        	         MATCHT(DISTINCT_OBJECT, &FOLLOW_DISTINCT_OBJECT_in_anything4323);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 31:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1605:5: UPPER_WORD
        	    {
        	         MATCHT(UPPER_WORD, &FOLLOW_UPPER_WORD_in_anything4329);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 32:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1606:5: LOWER_WORD
        	    {
        	         MATCHT(LOWER_WORD, &FOLLOW_LOWER_WORD_in_anything4335);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 33:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1607:5: LOWER_WORD_SINGLE_QUOTED
        	    {
        	         MATCHT(LOWER_WORD_SINGLE_QUOTED, &FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_anything4341);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 34:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1608:5: SINGLE_QUOTED
        	    {
        	         MATCHT(SINGLE_QUOTED, &FOLLOW_SINGLE_QUOTED_in_anything4347);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 35:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1609:5: NUMBER
        	    {
        	         MATCHT(NUMBER, &FOLLOW_NUMBER_in_anything4353);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;
        	case 36:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1610:5: DEFINED_SYMBOL
        	    {
        	         MATCHT(DEFINED_SYMBOL, &FOLLOW_DEFINED_SYMBOL_in_anything4359);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleanythingEx;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleanythingEx; /* Prevent compiler warnings */
    ruleanythingEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end anything */

/**
 * $ANTLR start unquotedFileName
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1701:1: unquotedFileName[std::string& name] : (s= LOWER_WORD_SINGLE_QUOTED |s= SINGLE_QUOTED ) ;
 */
static void
unquotedFileName(pTptpParser ctx, std::string& name)
{
    pANTLR3_COMMON_TOKEN    s;

    /* Initialize rule variables
     */

    s       = NULL;

    {
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1702:2: ( (s= LOWER_WORD_SINGLE_QUOTED |s= SINGLE_QUOTED ) )
        // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1702:4: (s= LOWER_WORD_SINGLE_QUOTED |s= SINGLE_QUOTED )
        {
            // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1702:4: (s= LOWER_WORD_SINGLE_QUOTED |s= SINGLE_QUOTED )
            {
                int alt85=2;
                switch ( LA(1) )
                {
                case LOWER_WORD_SINGLE_QUOTED:
                	{
                		alt85=1;
                	}
                    break;
                case SINGLE_QUOTED:
                	{
                		alt85=2;
                	}
                    break;

                default:
                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 85;
                    EXCEPTION->state        = 0;


                    goto ruleunquotedFileNameEx;

                }

                switch (alt85)
                {
            	case 1:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1702:5: s= LOWER_WORD_SINGLE_QUOTED
            	    {
            	        s = (pANTLR3_COMMON_TOKEN) MATCHT(LOWER_WORD_SINGLE_QUOTED, &FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_unquotedFileName5039);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleunquotedFileNameEx;
            	        }


            	    }
            	    break;
            	case 2:
            	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1702:34: s= SINGLE_QUOTED
            	    {
            	        s = (pANTLR3_COMMON_TOKEN) MATCHT(SINGLE_QUOTED, &FOLLOW_SINGLE_QUOTED_in_unquotedFileName5045);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleunquotedFileNameEx;
            	        }


            	    }
            	    break;

                }
            }

            {
                 name = AntlrInput::tokenText(s);
                      name = name.substr(1, name.size() - 2 );
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleunquotedFileNameEx; /* Prevent compiler warnings */
    ruleunquotedFileNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end unquotedFileName */

/**
 * $ANTLR start nameN
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1708:1: nameN[std::string& name] : ( atomicWord[name] | NUMBER );
 */
static void
nameN(pTptpParser ctx, std::string& name)
{
    pANTLR3_COMMON_TOKEN    NUMBER9;

    /* Initialize rule variables
     */

    NUMBER9       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1709:2: ( atomicWord[name] | NUMBER )

            ANTLR3_UINT32 alt86;

            alt86=2;

            switch ( LA(1) )
            {
            case CNF_TOK:
            case FOF_TOK:
            case INCLUDE_TOK:
            case LOWER_WORD:
            case LOWER_WORD_SINGLE_QUOTED:
            case SINGLE_QUOTED:
            case TFF_TOK:
            case THF_TOK:
            case TYPE_TOK:
            	{
            		alt86=1;
            	}
                break;
            case NUMBER:
            	{
            		alt86=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 86;
                EXCEPTION->state        = 0;


                goto rulenameNEx;

            }

            switch (alt86)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1709:4: atomicWord[name]
        	    {
        	        FOLLOWPUSH(FOLLOW_atomicWord_in_nameN5064);
        	        atomicWord(ctx, name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulenameNEx;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1710:4: NUMBER
        	    {
        	        NUMBER9 = (pANTLR3_COMMON_TOKEN) MATCHT(NUMBER, &FOLLOW_NUMBER_in_nameN5070);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulenameNEx;
        	        }


        	        {
        	             name = AntlrInput::tokenText(NUMBER9); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulenameNEx; /* Prevent compiler warnings */
    rulenameNEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end nameN */

/**
 * $ANTLR start atomicWord
 * /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1714:1: atomicWord[std::string& name] : ( FOF_TOK | CNF_TOK | THF_TOK | TFF_TOK | TYPE_TOK | INCLUDE_TOK | LOWER_WORD | LOWER_WORD_SINGLE_QUOTED | SINGLE_QUOTED );
 */
static void
atomicWord(pTptpParser ctx, std::string& name)
{
    pANTLR3_COMMON_TOKEN    LOWER_WORD10;
    pANTLR3_COMMON_TOKEN    LOWER_WORD_SINGLE_QUOTED11;
    pANTLR3_COMMON_TOKEN    SINGLE_QUOTED12;

    /* Initialize rule variables
     */

    LOWER_WORD10       = NULL;
    LOWER_WORD_SINGLE_QUOTED11       = NULL;
    SINGLE_QUOTED12       = NULL;

    {
        {
            //  /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1715:2: ( FOF_TOK | CNF_TOK | THF_TOK | TFF_TOK | TYPE_TOK | INCLUDE_TOK | LOWER_WORD | LOWER_WORD_SINGLE_QUOTED | SINGLE_QUOTED )

            ANTLR3_UINT32 alt87;

            alt87=9;

            switch ( LA(1) )
            {
            case FOF_TOK:
            	{
            		alt87=1;
            	}
                break;
            case CNF_TOK:
            	{
            		alt87=2;
            	}
                break;
            case THF_TOK:
            	{
            		alt87=3;
            	}
                break;
            case TFF_TOK:
            	{
            		alt87=4;
            	}
                break;
            case TYPE_TOK:
            	{
            		alt87=5;
            	}
                break;
            case INCLUDE_TOK:
            	{
            		alt87=6;
            	}
                break;
            case LOWER_WORD:
            	{
            		alt87=7;
            	}
                break;
            case LOWER_WORD_SINGLE_QUOTED:
            	{
            		alt87=8;
            	}
                break;
            case SINGLE_QUOTED:
            	{
            		alt87=9;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 87;
                EXCEPTION->state        = 0;


                goto ruleatomicWordEx;

            }

            switch (alt87)
            {
        	case 1:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1715:4: FOF_TOK
        	    {
        	         MATCHT(FOF_TOK, &FOLLOW_FOF_TOK_in_atomicWord5086);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicWordEx;
        	        }


        	        {
        	             name = "fof"; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1716:4: CNF_TOK
        	    {
        	         MATCHT(CNF_TOK, &FOLLOW_CNF_TOK_in_atomicWord5097);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicWordEx;
        	        }


        	        {
        	             name = "cnf"; 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1717:4: THF_TOK
        	    {
        	         MATCHT(THF_TOK, &FOLLOW_THF_TOK_in_atomicWord5108);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicWordEx;
        	        }


        	        {
        	             name = "thf"; 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1718:4: TFF_TOK
        	    {
        	         MATCHT(TFF_TOK, &FOLLOW_TFF_TOK_in_atomicWord5119);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicWordEx;
        	        }


        	        {
        	             name = "tff"; 
        	        }


        	    }
        	    break;
        	case 5:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1719:4: TYPE_TOK
        	    {
        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_atomicWord5130);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicWordEx;
        	        }


        	        {
        	             name = "type"; 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1720:4: INCLUDE_TOK
        	    {
        	         MATCHT(INCLUDE_TOK, &FOLLOW_INCLUDE_TOK_in_atomicWord5140);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicWordEx;
        	        }


        	        {
        	             name = "include"; 
        	        }


        	    }
        	    break;
        	case 7:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1721:4: LOWER_WORD
        	    {
        	        LOWER_WORD10 = (pANTLR3_COMMON_TOKEN) MATCHT(LOWER_WORD, &FOLLOW_LOWER_WORD_in_atomicWord5147);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicWordEx;
        	        }


        	        {
        	             name = AntlrInput::tokenText(LOWER_WORD10); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1722:4: LOWER_WORD_SINGLE_QUOTED
        	    {
        	        LOWER_WORD_SINGLE_QUOTED11 = (pANTLR3_COMMON_TOKEN) MATCHT(LOWER_WORD_SINGLE_QUOTED, &FOLLOW_LOWER_WORD_SINGLE_QUOTED_in_atomicWord5155);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicWordEx;
        	        }


        	        {
        	             /* strip off the quotes */
        	                  name = AntlrInput::tokenTextSubstr(LOWER_WORD_SINGLE_QUOTED11, 1 ,
        	                                                     (LOWER_WORD_SINGLE_QUOTED11->stop - LOWER_WORD_SINGLE_QUOTED11->start) - 1);
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // /build/cvc4/src/cvc5-1.8/src/parser/tptp/Tptp.g:1727:4: SINGLE_QUOTED
        	    {
        	        SINGLE_QUOTED12 = (pANTLR3_COMMON_TOKEN) MATCHT(SINGLE_QUOTED, &FOLLOW_SINGLE_QUOTED_in_atomicWord5167);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleatomicWordEx;
        	        }


        	        {
        	            name = AntlrInput::tokenText(SINGLE_QUOTED12); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleatomicWordEx; /* Prevent compiler warnings */
    ruleatomicWordEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end atomicWord */
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
/* End of syntactic predicates
 * ==============================================
 */






/* End of code
 * =============================================================================
 */
