/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> void Options::set(
    options::maxApproxDepth__option_t,
    const options::maxApproxDepth__option_t::type& x)
{
  d_holder->maxApproxDepth = x;
}
template <> const options::maxApproxDepth__option_t::type& Options::operator[](
    options::maxApproxDepth__option_t) const
{
  return d_holder->maxApproxDepth;
}
template <> bool Options::wasSetByUser(options::maxApproxDepth__option_t) const
{
  return d_holder->maxApproxDepth__setByUser__;
}
template <> const options::brabTest__option_t::type& Options::operator[](
    options::brabTest__option_t) const
{
  return d_holder->brabTest;
}
template <> bool Options::wasSetByUser(options::brabTest__option_t) const
{
  return d_holder->brabTest__setByUser__;
}
template <> const options::arithNoPartialFun__option_t::type& Options::operator[](
    options::arithNoPartialFun__option_t) const
{
  return d_holder->arithNoPartialFun;
}
template <> bool Options::wasSetByUser(options::arithNoPartialFun__option_t) const
{
  return d_holder->arithNoPartialFun__setByUser__;
}
template <> void Options::set(
    options::arithPropAsLemmaLength__option_t,
    const options::arithPropAsLemmaLength__option_t::type& x)
{
  d_holder->arithPropAsLemmaLength = x;
}
template <> const options::arithPropAsLemmaLength__option_t::type& Options::operator[](
    options::arithPropAsLemmaLength__option_t) const
{
  return d_holder->arithPropAsLemmaLength;
}
template <> bool Options::wasSetByUser(options::arithPropAsLemmaLength__option_t) const
{
  return d_holder->arithPropAsLemmaLength__setByUser__;
}
template <> const options::arithPropagationMode__option_t::type& Options::operator[](
    options::arithPropagationMode__option_t) const
{
  return d_holder->arithPropagationMode;
}
template <> bool Options::wasSetByUser(options::arithPropagationMode__option_t) const
{
  return d_holder->arithPropagationMode__setByUser__;
}
template <> void Options::set(
    options::arithRewriteEq__option_t,
    const options::arithRewriteEq__option_t::type& x)
{
  d_holder->arithRewriteEq = x;
}
template <> const options::arithRewriteEq__option_t::type& Options::operator[](
    options::arithRewriteEq__option_t) const
{
  return d_holder->arithRewriteEq;
}
template <> bool Options::wasSetByUser(options::arithRewriteEq__option_t) const
{
  return d_holder->arithRewriteEq__setByUser__;
}
template <> void Options::set(
    options::collectPivots__option_t,
    const options::collectPivots__option_t::type& x)
{
  d_holder->collectPivots = x;
}
template <> const options::collectPivots__option_t::type& Options::operator[](
    options::collectPivots__option_t) const
{
  return d_holder->collectPivots;
}
template <> bool Options::wasSetByUser(options::collectPivots__option_t) const
{
  return d_holder->collectPivots__setByUser__;
}
template <> void Options::set(
    options::doCutAllBounded__option_t,
    const options::doCutAllBounded__option_t::type& x)
{
  d_holder->doCutAllBounded = x;
}
template <> const options::doCutAllBounded__option_t::type& Options::operator[](
    options::doCutAllBounded__option_t) const
{
  return d_holder->doCutAllBounded;
}
template <> bool Options::wasSetByUser(options::doCutAllBounded__option_t) const
{
  return d_holder->doCutAllBounded__setByUser__;
}
template <> void Options::set(
    options::exportDioDecompositions__option_t,
    const options::exportDioDecompositions__option_t::type& x)
{
  d_holder->exportDioDecompositions = x;
}
template <> const options::exportDioDecompositions__option_t::type& Options::operator[](
    options::exportDioDecompositions__option_t) const
{
  return d_holder->exportDioDecompositions;
}
template <> bool Options::wasSetByUser(options::exportDioDecompositions__option_t) const
{
  return d_holder->exportDioDecompositions__setByUser__;
}
template <> const options::dioRepeat__option_t::type& Options::operator[](
    options::dioRepeat__option_t) const
{
  return d_holder->dioRepeat;
}
template <> bool Options::wasSetByUser(options::dioRepeat__option_t) const
{
  return d_holder->dioRepeat__setByUser__;
}
template <> const options::arithDioSolver__option_t::type& Options::operator[](
    options::arithDioSolver__option_t) const
{
  return d_holder->arithDioSolver;
}
template <> bool Options::wasSetByUser(options::arithDioSolver__option_t) const
{
  return d_holder->arithDioSolver__setByUser__;
}
template <> const options::dioSolverTurns__option_t::type& Options::operator[](
    options::dioSolverTurns__option_t) const
{
  return d_holder->dioSolverTurns;
}
template <> bool Options::wasSetByUser(options::dioSolverTurns__option_t) const
{
  return d_holder->dioSolverTurns__setByUser__;
}
template <> const options::arithErrorSelectionRule__option_t::type& Options::operator[](
    options::arithErrorSelectionRule__option_t) const
{
  return d_holder->arithErrorSelectionRule;
}
template <> bool Options::wasSetByUser(options::arithErrorSelectionRule__option_t) const
{
  return d_holder->arithErrorSelectionRule__setByUser__;
}
template <> void Options::set(
    options::havePenalties__option_t,
    const options::havePenalties__option_t::type& x)
{
  d_holder->havePenalties = x;
}
template <> const options::havePenalties__option_t::type& Options::operator[](
    options::havePenalties__option_t) const
{
  return d_holder->havePenalties;
}
template <> bool Options::wasSetByUser(options::havePenalties__option_t) const
{
  return d_holder->havePenalties__setByUser__;
}
template <> void Options::set(
    options::arithHeuristicPivots__option_t,
    const options::arithHeuristicPivots__option_t::type& x)
{
  d_holder->arithHeuristicPivots = x;
}
template <> const options::arithHeuristicPivots__option_t::type& Options::operator[](
    options::arithHeuristicPivots__option_t) const
{
  return d_holder->arithHeuristicPivots;
}
template <> bool Options::wasSetByUser(options::arithHeuristicPivots__option_t) const
{
  return d_holder->arithHeuristicPivots__setByUser__;
}
template <> const options::replayFailureLemma__option_t::type& Options::operator[](
    options::replayFailureLemma__option_t) const
{
  return d_holder->replayFailureLemma;
}
template <> bool Options::wasSetByUser(options::replayFailureLemma__option_t) const
{
  return d_holder->replayFailureLemma__setByUser__;
}
template <> const options::maxCutsInContext__option_t::type& Options::operator[](
    options::maxCutsInContext__option_t) const
{
  return d_holder->maxCutsInContext;
}
template <> bool Options::wasSetByUser(options::maxCutsInContext__option_t) const
{
  return d_holder->maxCutsInContext__setByUser__;
}
template <> void Options::set(
    options::arithMLTrick__option_t,
    const options::arithMLTrick__option_t::type& x)
{
  d_holder->arithMLTrick = x;
}
template <> const options::arithMLTrick__option_t::type& Options::operator[](
    options::arithMLTrick__option_t) const
{
  return d_holder->arithMLTrick;
}
template <> bool Options::wasSetByUser(options::arithMLTrick__option_t) const
{
  return d_holder->arithMLTrick__setByUser__;
}
template <> const options::arithMLTrickSubstitutions__option_t::type& Options::operator[](
    options::arithMLTrickSubstitutions__option_t) const
{
  return d_holder->arithMLTrickSubstitutions;
}
template <> bool Options::wasSetByUser(options::arithMLTrickSubstitutions__option_t) const
{
  return d_holder->arithMLTrickSubstitutions__setByUser__;
}
template <> void Options::set(
    options::newProp__option_t,
    const options::newProp__option_t::type& x)
{
  d_holder->newProp = x;
}
template <> const options::newProp__option_t::type& Options::operator[](
    options::newProp__option_t) const
{
  return d_holder->newProp;
}
template <> bool Options::wasSetByUser(options::newProp__option_t) const
{
  return d_holder->newProp__setByUser__;
}
template <> const options::nlExt__option_t::type& Options::operator[](
    options::nlExt__option_t) const
{
  return d_holder->nlExt;
}
template <> bool Options::wasSetByUser(options::nlExt__option_t) const
{
  return d_holder->nlExt__setByUser__;
}
template <> const options::nlExtEntailConflicts__option_t::type& Options::operator[](
    options::nlExtEntailConflicts__option_t) const
{
  return d_holder->nlExtEntailConflicts;
}
template <> bool Options::wasSetByUser(options::nlExtEntailConflicts__option_t) const
{
  return d_holder->nlExtEntailConflicts__setByUser__;
}
template <> const options::nlExtFactor__option_t::type& Options::operator[](
    options::nlExtFactor__option_t) const
{
  return d_holder->nlExtFactor;
}
template <> bool Options::wasSetByUser(options::nlExtFactor__option_t) const
{
  return d_holder->nlExtFactor__setByUser__;
}
template <> const options::nlExtIncPrecision__option_t::type& Options::operator[](
    options::nlExtIncPrecision__option_t) const
{
  return d_holder->nlExtIncPrecision;
}
template <> bool Options::wasSetByUser(options::nlExtIncPrecision__option_t) const
{
  return d_holder->nlExtIncPrecision__setByUser__;
}
template <> const options::nlExtPurify__option_t::type& Options::operator[](
    options::nlExtPurify__option_t) const
{
  return d_holder->nlExtPurify;
}
template <> bool Options::wasSetByUser(options::nlExtPurify__option_t) const
{
  return d_holder->nlExtPurify__setByUser__;
}
template <> const options::nlExtResBound__option_t::type& Options::operator[](
    options::nlExtResBound__option_t) const
{
  return d_holder->nlExtResBound;
}
template <> bool Options::wasSetByUser(options::nlExtResBound__option_t) const
{
  return d_holder->nlExtResBound__setByUser__;
}
template <> const options::nlExtRewrites__option_t::type& Options::operator[](
    options::nlExtRewrites__option_t) const
{
  return d_holder->nlExtRewrites;
}
template <> bool Options::wasSetByUser(options::nlExtRewrites__option_t) const
{
  return d_holder->nlExtRewrites__setByUser__;
}
template <> const options::nlExtSplitZero__option_t::type& Options::operator[](
    options::nlExtSplitZero__option_t) const
{
  return d_holder->nlExtSplitZero;
}
template <> bool Options::wasSetByUser(options::nlExtSplitZero__option_t) const
{
  return d_holder->nlExtSplitZero__setByUser__;
}
template <> void Options::set(
    options::nlExtTfTaylorDegree__option_t,
    const options::nlExtTfTaylorDegree__option_t::type& x)
{
  d_holder->nlExtTfTaylorDegree = x;
}
template <> const options::nlExtTfTaylorDegree__option_t::type& Options::operator[](
    options::nlExtTfTaylorDegree__option_t) const
{
  return d_holder->nlExtTfTaylorDegree;
}
template <> bool Options::wasSetByUser(options::nlExtTfTaylorDegree__option_t) const
{
  return d_holder->nlExtTfTaylorDegree__setByUser__;
}
template <> const options::nlExtTfTangentPlanes__option_t::type& Options::operator[](
    options::nlExtTfTangentPlanes__option_t) const
{
  return d_holder->nlExtTfTangentPlanes;
}
template <> bool Options::wasSetByUser(options::nlExtTfTangentPlanes__option_t) const
{
  return d_holder->nlExtTfTangentPlanes__setByUser__;
}
template <> const options::nlExtTangentPlanes__option_t::type& Options::operator[](
    options::nlExtTangentPlanes__option_t) const
{
  return d_holder->nlExtTangentPlanes;
}
template <> bool Options::wasSetByUser(options::nlExtTangentPlanes__option_t) const
{
  return d_holder->nlExtTangentPlanes__setByUser__;
}
template <> void Options::set(
    options::nlExtTangentPlanesInterleave__option_t,
    const options::nlExtTangentPlanesInterleave__option_t::type& x)
{
  d_holder->nlExtTangentPlanesInterleave = x;
}
template <> const options::nlExtTangentPlanesInterleave__option_t::type& Options::operator[](
    options::nlExtTangentPlanesInterleave__option_t) const
{
  return d_holder->nlExtTangentPlanesInterleave;
}
template <> bool Options::wasSetByUser(options::nlExtTangentPlanesInterleave__option_t) const
{
  return d_holder->nlExtTangentPlanesInterleave__setByUser__;
}
template <> const options::pbRewrites__option_t::type& Options::operator[](
    options::pbRewrites__option_t) const
{
  return d_holder->pbRewrites;
}
template <> bool Options::wasSetByUser(options::pbRewrites__option_t) const
{
  return d_holder->pbRewrites__setByUser__;
}
template <> void Options::set(
    options::arithPivotThreshold__option_t,
    const options::arithPivotThreshold__option_t::type& x)
{
  d_holder->arithPivotThreshold = x;
}
template <> const options::arithPivotThreshold__option_t::type& Options::operator[](
    options::arithPivotThreshold__option_t) const
{
  return d_holder->arithPivotThreshold;
}
template <> bool Options::wasSetByUser(options::arithPivotThreshold__option_t) const
{
  return d_holder->arithPivotThreshold__setByUser__;
}
template <> const options::ppAssertMaxSubSize__option_t::type& Options::operator[](
    options::ppAssertMaxSubSize__option_t) const
{
  return d_holder->ppAssertMaxSubSize;
}
template <> bool Options::wasSetByUser(options::ppAssertMaxSubSize__option_t) const
{
  return d_holder->ppAssertMaxSubSize__setByUser__;
}
template <> const options::arithPropagateMaxLength__option_t::type& Options::operator[](
    options::arithPropagateMaxLength__option_t) const
{
  return d_holder->arithPropagateMaxLength;
}
template <> bool Options::wasSetByUser(options::arithPropagateMaxLength__option_t) const
{
  return d_holder->arithPropagateMaxLength__setByUser__;
}
template <> const options::replayEarlyCloseDepths__option_t::type& Options::operator[](
    options::replayEarlyCloseDepths__option_t) const
{
  return d_holder->replayEarlyCloseDepths;
}
template <> bool Options::wasSetByUser(options::replayEarlyCloseDepths__option_t) const
{
  return d_holder->replayEarlyCloseDepths__setByUser__;
}
template <> const options::replayFailurePenalty__option_t::type& Options::operator[](
    options::replayFailurePenalty__option_t) const
{
  return d_holder->replayFailurePenalty;
}
template <> bool Options::wasSetByUser(options::replayFailurePenalty__option_t) const
{
  return d_holder->replayFailurePenalty__setByUser__;
}
template <> const options::lemmaRejectCutSize__option_t::type& Options::operator[](
    options::lemmaRejectCutSize__option_t) const
{
  return d_holder->lemmaRejectCutSize;
}
template <> bool Options::wasSetByUser(options::lemmaRejectCutSize__option_t) const
{
  return d_holder->lemmaRejectCutSize__setByUser__;
}
template <> const options::replayNumericFailurePenalty__option_t::type& Options::operator[](
    options::replayNumericFailurePenalty__option_t) const
{
  return d_holder->replayNumericFailurePenalty;
}
template <> bool Options::wasSetByUser(options::replayNumericFailurePenalty__option_t) const
{
  return d_holder->replayNumericFailurePenalty__setByUser__;
}
template <> const options::replayRejectCutSize__option_t::type& Options::operator[](
    options::replayRejectCutSize__option_t) const
{
  return d_holder->replayRejectCutSize;
}
template <> bool Options::wasSetByUser(options::replayRejectCutSize__option_t) const
{
  return d_holder->replayRejectCutSize__setByUser__;
}
template <> const options::soiApproxMajorFailurePen__option_t::type& Options::operator[](
    options::soiApproxMajorFailurePen__option_t) const
{
  return d_holder->soiApproxMajorFailurePen;
}
template <> bool Options::wasSetByUser(options::soiApproxMajorFailurePen__option_t) const
{
  return d_holder->soiApproxMajorFailurePen__setByUser__;
}
template <> const options::soiApproxMajorFailure__option_t::type& Options::operator[](
    options::soiApproxMajorFailure__option_t) const
{
  return d_holder->soiApproxMajorFailure;
}
template <> bool Options::wasSetByUser(options::soiApproxMajorFailure__option_t) const
{
  return d_holder->soiApproxMajorFailure__setByUser__;
}
template <> const options::soiApproxMinorFailurePen__option_t::type& Options::operator[](
    options::soiApproxMinorFailurePen__option_t) const
{
  return d_holder->soiApproxMinorFailurePen;
}
template <> bool Options::wasSetByUser(options::soiApproxMinorFailurePen__option_t) const
{
  return d_holder->soiApproxMinorFailurePen__setByUser__;
}
template <> const options::soiApproxMinorFailure__option_t::type& Options::operator[](
    options::soiApproxMinorFailure__option_t) const
{
  return d_holder->soiApproxMinorFailure;
}
template <> bool Options::wasSetByUser(options::soiApproxMinorFailure__option_t) const
{
  return d_holder->soiApproxMinorFailure__setByUser__;
}
template <> void Options::set(
    options::restrictedPivots__option_t,
    const options::restrictedPivots__option_t::type& x)
{
  d_holder->restrictedPivots = x;
}
template <> const options::restrictedPivots__option_t::type& Options::operator[](
    options::restrictedPivots__option_t) const
{
  return d_holder->restrictedPivots;
}
template <> bool Options::wasSetByUser(options::restrictedPivots__option_t) const
{
  return d_holder->restrictedPivots__setByUser__;
}
template <> const options::revertArithModels__option_t::type& Options::operator[](
    options::revertArithModels__option_t) const
{
  return d_holder->revertArithModels;
}
template <> bool Options::wasSetByUser(options::revertArithModels__option_t) const
{
  return d_holder->revertArithModels__setByUser__;
}
template <> const options::rrTurns__option_t::type& Options::operator[](
    options::rrTurns__option_t) const
{
  return d_holder->rrTurns;
}
template <> bool Options::wasSetByUser(options::rrTurns__option_t) const
{
  return d_holder->rrTurns__setByUser__;
}
template <> const options::trySolveIntStandardEffort__option_t::type& Options::operator[](
    options::trySolveIntStandardEffort__option_t) const
{
  return d_holder->trySolveIntStandardEffort;
}
template <> bool Options::wasSetByUser(options::trySolveIntStandardEffort__option_t) const
{
  return d_holder->trySolveIntStandardEffort__setByUser__;
}
template <> const options::arithSimplexCheckPeriod__option_t::type& Options::operator[](
    options::arithSimplexCheckPeriod__option_t) const
{
  return d_holder->arithSimplexCheckPeriod;
}
template <> bool Options::wasSetByUser(options::arithSimplexCheckPeriod__option_t) const
{
  return d_holder->arithSimplexCheckPeriod__setByUser__;
}
template <> void Options::set(
    options::soiQuickExplain__option_t,
    const options::soiQuickExplain__option_t::type& x)
{
  d_holder->soiQuickExplain = x;
}
template <> const options::soiQuickExplain__option_t::type& Options::operator[](
    options::soiQuickExplain__option_t) const
{
  return d_holder->soiQuickExplain;
}
template <> bool Options::wasSetByUser(options::soiQuickExplain__option_t) const
{
  return d_holder->soiQuickExplain__setByUser__;
}
template <> void Options::set(
    options::arithStandardCheckVarOrderPivots__option_t,
    const options::arithStandardCheckVarOrderPivots__option_t::type& x)
{
  d_holder->arithStandardCheckVarOrderPivots = x;
}
template <> const options::arithStandardCheckVarOrderPivots__option_t::type& Options::operator[](
    options::arithStandardCheckVarOrderPivots__option_t) const
{
  return d_holder->arithStandardCheckVarOrderPivots;
}
template <> bool Options::wasSetByUser(options::arithStandardCheckVarOrderPivots__option_t) const
{
  return d_holder->arithStandardCheckVarOrderPivots__setByUser__;
}
template <> const options::arithUnateLemmaMode__option_t::type& Options::operator[](
    options::arithUnateLemmaMode__option_t) const
{
  return d_holder->arithUnateLemmaMode;
}
template <> bool Options::wasSetByUser(options::arithUnateLemmaMode__option_t) const
{
  return d_holder->arithUnateLemmaMode__setByUser__;
}
template <> void Options::set(
    options::useApprox__option_t,
    const options::useApprox__option_t::type& x)
{
  d_holder->useApprox = x;
}
template <> const options::useApprox__option_t::type& Options::operator[](
    options::useApprox__option_t) const
{
  return d_holder->useApprox;
}
template <> bool Options::wasSetByUser(options::useApprox__option_t) const
{
  return d_holder->useApprox__setByUser__;
}
template <> void Options::set(
    options::useFC__option_t,
    const options::useFC__option_t::type& x)
{
  d_holder->useFC = x;
}
template <> const options::useFC__option_t::type& Options::operator[](
    options::useFC__option_t) const
{
  return d_holder->useFC;
}
template <> bool Options::wasSetByUser(options::useFC__option_t) const
{
  return d_holder->useFC__setByUser__;
}
template <> void Options::set(
    options::useSOI__option_t,
    const options::useSOI__option_t::type& x)
{
  d_holder->useSOI = x;
}
template <> const options::useSOI__option_t::type& Options::operator[](
    options::useSOI__option_t) const
{
  return d_holder->useSOI;
}
template <> bool Options::wasSetByUser(options::useSOI__option_t) const
{
  return d_holder->useSOI__setByUser__;
}


namespace options {

struct maxApproxDepth__option_t maxApproxDepth;
struct brabTest__option_t brabTest;
struct arithNoPartialFun__option_t arithNoPartialFun;
struct arithPropAsLemmaLength__option_t arithPropAsLemmaLength;
struct arithPropagationMode__option_t arithPropagationMode;
struct arithRewriteEq__option_t arithRewriteEq;
struct collectPivots__option_t collectPivots;
struct doCutAllBounded__option_t doCutAllBounded;
struct exportDioDecompositions__option_t exportDioDecompositions;
struct dioRepeat__option_t dioRepeat;
struct arithDioSolver__option_t arithDioSolver;
struct dioSolverTurns__option_t dioSolverTurns;
struct arithErrorSelectionRule__option_t arithErrorSelectionRule;
struct havePenalties__option_t havePenalties;
struct arithHeuristicPivots__option_t arithHeuristicPivots;
struct replayFailureLemma__option_t replayFailureLemma;
struct maxCutsInContext__option_t maxCutsInContext;
struct arithMLTrick__option_t arithMLTrick;
struct arithMLTrickSubstitutions__option_t arithMLTrickSubstitutions;
struct newProp__option_t newProp;
struct nlExt__option_t nlExt;
struct nlExtEntailConflicts__option_t nlExtEntailConflicts;
struct nlExtFactor__option_t nlExtFactor;
struct nlExtIncPrecision__option_t nlExtIncPrecision;
struct nlExtPurify__option_t nlExtPurify;
struct nlExtResBound__option_t nlExtResBound;
struct nlExtRewrites__option_t nlExtRewrites;
struct nlExtSplitZero__option_t nlExtSplitZero;
struct nlExtTfTaylorDegree__option_t nlExtTfTaylorDegree;
struct nlExtTfTangentPlanes__option_t nlExtTfTangentPlanes;
struct nlExtTangentPlanes__option_t nlExtTangentPlanes;
struct nlExtTangentPlanesInterleave__option_t nlExtTangentPlanesInterleave;
struct pbRewrites__option_t pbRewrites;
struct arithPivotThreshold__option_t arithPivotThreshold;
struct ppAssertMaxSubSize__option_t ppAssertMaxSubSize;
struct arithPropagateMaxLength__option_t arithPropagateMaxLength;
struct replayEarlyCloseDepths__option_t replayEarlyCloseDepths;
struct replayFailurePenalty__option_t replayFailurePenalty;
struct lemmaRejectCutSize__option_t lemmaRejectCutSize;
struct replayNumericFailurePenalty__option_t replayNumericFailurePenalty;
struct replayRejectCutSize__option_t replayRejectCutSize;
struct soiApproxMajorFailurePen__option_t soiApproxMajorFailurePen;
struct soiApproxMajorFailure__option_t soiApproxMajorFailure;
struct soiApproxMinorFailurePen__option_t soiApproxMinorFailurePen;
struct soiApproxMinorFailure__option_t soiApproxMinorFailure;
struct restrictedPivots__option_t restrictedPivots;
struct revertArithModels__option_t revertArithModels;
struct rrTurns__option_t rrTurns;
struct trySolveIntStandardEffort__option_t trySolveIntStandardEffort;
struct arithSimplexCheckPeriod__option_t arithSimplexCheckPeriod;
struct soiQuickExplain__option_t soiQuickExplain;
struct arithStandardCheckVarOrderPivots__option_t arithStandardCheckVarOrderPivots;
struct arithUnateLemmaMode__option_t arithUnateLemmaMode;
struct useApprox__option_t useApprox;
struct useFC__option_t useFC;
struct useSOI__option_t useSOI;


std::ostream&
operator<<(std::ostream& os, ArithPropagationMode mode)
{
  os << "ArithPropagationMode::";
  switch(mode) {
    case ArithPropagationMode::NO_PROP:
      os << "NO_PROP";
      break;
    case ArithPropagationMode::UNATE_PROP:
      os << "UNATE_PROP";
      break;
    case ArithPropagationMode::BOUND_INFERENCE_PROP:
      os << "BOUND_INFERENCE_PROP";
      break;
    case ArithPropagationMode::BOTH_PROP:
      os << "BOTH_PROP";
      break;
    default:
        Unreachable();
  }
  return os;
}

ArithPropagationMode
stringToArithPropagationMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return ArithPropagationMode::NO_PROP;
  }
  else if (optarg == "unate")
  {
    return ArithPropagationMode::UNATE_PROP;
  }
  else if (optarg == "bi")
  {
    return ArithPropagationMode::BOUND_INFERENCE_PROP;
  }
  else if (optarg == "both")
  {
    return ArithPropagationMode::BOTH_PROP;
  }
  else if (optarg == "help")
  {
    puts("This decides on kind of propagation arithmetic attempts to do during the\n"
         "search.\n"
         "Available modes for --arith-prop are:\n"
         "+ none\n"
         "+ unate\n"
         "  Use constraints to do unate propagation.\n"
         "+ bi\n"
         "  (Bounds Inference) infers bounds on basic variables using the upper and lower\n"
         "  bounds of the non-basic variables in the tableau.\n"
         "+ both (default)\n"
         "  Use bounds inference and unate.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --arith-prop: `") +
                          optarg + "'.  Try --arith-prop=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, ErrorSelectionRule mode)
{
  os << "ErrorSelectionRule::";
  switch(mode) {
    case ErrorSelectionRule::MINIMUM_AMOUNT:
      os << "MINIMUM_AMOUNT";
      break;
    case ErrorSelectionRule::VAR_ORDER:
      os << "VAR_ORDER";
      break;
    case ErrorSelectionRule::MAXIMUM_AMOUNT:
      os << "MAXIMUM_AMOUNT";
      break;
    case ErrorSelectionRule::SUM_METRIC:
      os << "SUM_METRIC";
      break;
    default:
        Unreachable();
  }
  return os;
}

ErrorSelectionRule
stringToErrorSelectionRule(const std::string& option, const std::string& optarg)
{
  if (optarg == "min")
  {
    return ErrorSelectionRule::MINIMUM_AMOUNT;
  }
  else if (optarg == "varord")
  {
    return ErrorSelectionRule::VAR_ORDER;
  }
  else if (optarg == "max")
  {
    return ErrorSelectionRule::MAXIMUM_AMOUNT;
  }
  else if (optarg == "sum")
  {
    return ErrorSelectionRule::SUM_METRIC;
  }
  else if (optarg == "help")
  {
    puts("This decides on the rule used by simplex during heuristic rounds for deciding\n"
         "the next basic variable to select.\n"
         "Available modes for --error-selection-rule are:\n"
         "+ min (default)\n"
         "  The minimum abs() value of the variable's violation of its bound.\n"
         "+ varord\n"
         "  The variable order.\n"
         "+ max\n"
         "  The maximum violation the bound.\n"
         "+ sum\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --error-selection-rule: `") +
                          optarg + "'.  Try --error-selection-rule=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, ArithUnateLemmaMode mode)
{
  os << "ArithUnateLemmaMode::";
  switch(mode) {
    case ArithUnateLemmaMode::ALL:
      os << "ALL";
      break;
    case ArithUnateLemmaMode::EQUALITY:
      os << "EQUALITY";
      break;
    case ArithUnateLemmaMode::INEQUALITY:
      os << "INEQUALITY";
      break;
    case ArithUnateLemmaMode::NO:
      os << "NO";
      break;
    default:
        Unreachable();
  }
  return os;
}

ArithUnateLemmaMode
stringToArithUnateLemmaMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "all")
  {
    return ArithUnateLemmaMode::ALL;
  }
  else if (optarg == "eqs")
  {
    return ArithUnateLemmaMode::EQUALITY;
  }
  else if (optarg == "ineqs")
  {
    return ArithUnateLemmaMode::INEQUALITY;
  }
  else if (optarg == "none")
  {
    return ArithUnateLemmaMode::NO;
  }
  else if (optarg == "help")
  {
    puts("Unate lemmas are generated before SAT search begins using the relationship of\n"
         "constant terms and polynomials.\n"
         "Available modes for --unate-lemmas are:\n"
         "+ all (default)\n"
         "  A combination of inequalities and equalities.\n"
         "+ eqs\n"
         "  Outputs lemmas of the general forms (= p c) implies (<= p d) for c < d, or (=\n"
         "  p c) implies (not (= p d)) for c != d.\n"
         "+ ineqs\n"
         "  Outputs lemmas of the general form (<= p c) implies (<= p d) for c < d.\n"
         "+ none\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --unate-lemmas: `") +
                          optarg + "'.  Try --unate-lemmas=help.");
  }
}


}  // namespace options
}  // namespace CVC4
