/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__EXPR_H
#define CVC4__OPTIONS__EXPR_H

#include "options/options.h"




#define CVC4_OPTIONS__EXPR__FOR_OPTION_HOLDER \
  defaultDagThresh__option_t::type defaultDagThresh;\
  bool defaultDagThresh__setByUser__; \
  defaultExprDepth__option_t::type defaultExprDepth;\
  bool defaultExprDepth__setByUser__; \
  printExprTypes__option_t::type printExprTypes;\
  bool printExprTypes__setByUser__; \
  typeChecking__option_t::type typeChecking;\
  bool typeChecking__setByUser__;


namespace CVC4 {

namespace options {



extern struct CVC4_PUBLIC defaultDagThresh__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} defaultDagThresh CVC4_PUBLIC;
extern struct CVC4_PUBLIC defaultExprDepth__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} defaultExprDepth CVC4_PUBLIC;
extern struct CVC4_PUBLIC printExprTypes__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} printExprTypes CVC4_PUBLIC;
extern struct CVC4_PUBLIC typeChecking__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} typeChecking CVC4_PUBLIC;

}  // namespace options

template <> const options::defaultDagThresh__option_t::type& Options::operator[](
    options::defaultDagThresh__option_t) const;
template <> bool Options::wasSetByUser(options::defaultDagThresh__option_t) const;
template <> void Options::assign(
    options::defaultDagThresh__option_t,
    std::string option,
    std::string value);
template <> const options::defaultExprDepth__option_t::type& Options::operator[](
    options::defaultExprDepth__option_t) const;
template <> bool Options::wasSetByUser(options::defaultExprDepth__option_t) const;
template <> void Options::assign(
    options::defaultExprDepth__option_t,
    std::string option,
    std::string value);
template <> const options::printExprTypes__option_t::type& Options::operator[](
    options::printExprTypes__option_t) const;
template <> bool Options::wasSetByUser(options::printExprTypes__option_t) const;
template <> void Options::assignBool(
    options::printExprTypes__option_t,
    std::string option,
    bool value);
template <> const options::typeChecking__option_t::type& Options::operator[](
    options::typeChecking__option_t) const;
template <> bool Options::wasSetByUser(options::typeChecking__option_t) const;
template <> void Options::assignBool(
    options::typeChecking__option_t,
    std::string option,
    bool value);


namespace options {

inline defaultDagThresh__option_t::type defaultDagThresh__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool defaultDagThresh__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline defaultExprDepth__option_t::type defaultExprDepth__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool defaultExprDepth__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline printExprTypes__option_t::type printExprTypes__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool printExprTypes__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline typeChecking__option_t::type typeChecking__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool typeChecking__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__EXPR_H */
