/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> const options::aggressiveMiniscopeQuant__option_t::type& Options::operator[](
    options::aggressiveMiniscopeQuant__option_t) const
{
  return d_holder->aggressiveMiniscopeQuant;
}
template <> bool Options::wasSetByUser(options::aggressiveMiniscopeQuant__option_t) const
{
  return d_holder->aggressiveMiniscopeQuant__setByUser__;
}
template <> void Options::set(
    options::cegisSample__option_t,
    const options::cegisSample__option_t::type& x)
{
  d_holder->cegisSample = x;
}
template <> const options::cegisSample__option_t::type& Options::operator[](
    options::cegisSample__option_t) const
{
  return d_holder->cegisSample;
}
template <> bool Options::wasSetByUser(options::cegisSample__option_t) const
{
  return d_holder->cegisSample__setByUser__;
}
template <> void Options::set(
    options::cegqi__option_t,
    const options::cegqi__option_t::type& x)
{
  d_holder->cegqi = x;
}
template <> const options::cegqi__option_t::type& Options::operator[](
    options::cegqi__option_t) const
{
  return d_holder->cegqi;
}
template <> bool Options::wasSetByUser(options::cegqi__option_t) const
{
  return d_holder->cegqi__setByUser__;
}
template <> void Options::set(
    options::cegqiAll__option_t,
    const options::cegqiAll__option_t::type& x)
{
  d_holder->cegqiAll = x;
}
template <> const options::cegqiAll__option_t::type& Options::operator[](
    options::cegqiAll__option_t) const
{
  return d_holder->cegqiAll;
}
template <> bool Options::wasSetByUser(options::cegqiAll__option_t) const
{
  return d_holder->cegqiAll__setByUser__;
}
template <> void Options::set(
    options::cegqiBv__option_t,
    const options::cegqiBv__option_t::type& x)
{
  d_holder->cegqiBv = x;
}
template <> const options::cegqiBv__option_t::type& Options::operator[](
    options::cegqiBv__option_t) const
{
  return d_holder->cegqiBv;
}
template <> bool Options::wasSetByUser(options::cegqiBv__option_t) const
{
  return d_holder->cegqiBv__setByUser__;
}
template <> void Options::set(
    options::cegqiBvConcInv__option_t,
    const options::cegqiBvConcInv__option_t::type& x)
{
  d_holder->cegqiBvConcInv = x;
}
template <> const options::cegqiBvConcInv__option_t::type& Options::operator[](
    options::cegqiBvConcInv__option_t) const
{
  return d_holder->cegqiBvConcInv;
}
template <> bool Options::wasSetByUser(options::cegqiBvConcInv__option_t) const
{
  return d_holder->cegqiBvConcInv__setByUser__;
}
template <> void Options::set(
    options::cegqiBvIneqMode__option_t,
    const options::cegqiBvIneqMode__option_t::type& x)
{
  d_holder->cegqiBvIneqMode = x;
}
template <> const options::cegqiBvIneqMode__option_t::type& Options::operator[](
    options::cegqiBvIneqMode__option_t) const
{
  return d_holder->cegqiBvIneqMode;
}
template <> bool Options::wasSetByUser(options::cegqiBvIneqMode__option_t) const
{
  return d_holder->cegqiBvIneqMode__setByUser__;
}
template <> void Options::set(
    options::cegqiBvInterleaveValue__option_t,
    const options::cegqiBvInterleaveValue__option_t::type& x)
{
  d_holder->cegqiBvInterleaveValue = x;
}
template <> const options::cegqiBvInterleaveValue__option_t::type& Options::operator[](
    options::cegqiBvInterleaveValue__option_t) const
{
  return d_holder->cegqiBvInterleaveValue;
}
template <> bool Options::wasSetByUser(options::cegqiBvInterleaveValue__option_t) const
{
  return d_holder->cegqiBvInterleaveValue__setByUser__;
}
template <> void Options::set(
    options::cegqiBvLinearize__option_t,
    const options::cegqiBvLinearize__option_t::type& x)
{
  d_holder->cegqiBvLinearize = x;
}
template <> const options::cegqiBvLinearize__option_t::type& Options::operator[](
    options::cegqiBvLinearize__option_t) const
{
  return d_holder->cegqiBvLinearize;
}
template <> bool Options::wasSetByUser(options::cegqiBvLinearize__option_t) const
{
  return d_holder->cegqiBvLinearize__setByUser__;
}
template <> void Options::set(
    options::cegqiBvRmExtract__option_t,
    const options::cegqiBvRmExtract__option_t::type& x)
{
  d_holder->cegqiBvRmExtract = x;
}
template <> const options::cegqiBvRmExtract__option_t::type& Options::operator[](
    options::cegqiBvRmExtract__option_t) const
{
  return d_holder->cegqiBvRmExtract;
}
template <> bool Options::wasSetByUser(options::cegqiBvRmExtract__option_t) const
{
  return d_holder->cegqiBvRmExtract__setByUser__;
}
template <> void Options::set(
    options::cegqiBvSolveNl__option_t,
    const options::cegqiBvSolveNl__option_t::type& x)
{
  d_holder->cegqiBvSolveNl = x;
}
template <> const options::cegqiBvSolveNl__option_t::type& Options::operator[](
    options::cegqiBvSolveNl__option_t) const
{
  return d_holder->cegqiBvSolveNl;
}
template <> bool Options::wasSetByUser(options::cegqiBvSolveNl__option_t) const
{
  return d_holder->cegqiBvSolveNl__setByUser__;
}
template <> void Options::set(
    options::cegqiFullEffort__option_t,
    const options::cegqiFullEffort__option_t::type& x)
{
  d_holder->cegqiFullEffort = x;
}
template <> const options::cegqiFullEffort__option_t::type& Options::operator[](
    options::cegqiFullEffort__option_t) const
{
  return d_holder->cegqiFullEffort;
}
template <> bool Options::wasSetByUser(options::cegqiFullEffort__option_t) const
{
  return d_holder->cegqiFullEffort__setByUser__;
}
template <> void Options::set(
    options::cegqiInnermost__option_t,
    const options::cegqiInnermost__option_t::type& x)
{
  d_holder->cegqiInnermost = x;
}
template <> const options::cegqiInnermost__option_t::type& Options::operator[](
    options::cegqiInnermost__option_t) const
{
  return d_holder->cegqiInnermost;
}
template <> bool Options::wasSetByUser(options::cegqiInnermost__option_t) const
{
  return d_holder->cegqiInnermost__setByUser__;
}
template <> void Options::set(
    options::cegqiMidpoint__option_t,
    const options::cegqiMidpoint__option_t::type& x)
{
  d_holder->cegqiMidpoint = x;
}
template <> const options::cegqiMidpoint__option_t::type& Options::operator[](
    options::cegqiMidpoint__option_t) const
{
  return d_holder->cegqiMidpoint;
}
template <> bool Options::wasSetByUser(options::cegqiMidpoint__option_t) const
{
  return d_holder->cegqiMidpoint__setByUser__;
}
template <> const options::cegqiMinBounds__option_t::type& Options::operator[](
    options::cegqiMinBounds__option_t) const
{
  return d_holder->cegqiMinBounds;
}
template <> bool Options::wasSetByUser(options::cegqiMinBounds__option_t) const
{
  return d_holder->cegqiMinBounds__setByUser__;
}
template <> void Options::set(
    options::cegqiModel__option_t,
    const options::cegqiModel__option_t::type& x)
{
  d_holder->cegqiModel = x;
}
template <> const options::cegqiModel__option_t::type& Options::operator[](
    options::cegqiModel__option_t) const
{
  return d_holder->cegqiModel;
}
template <> bool Options::wasSetByUser(options::cegqiModel__option_t) const
{
  return d_holder->cegqiModel__setByUser__;
}
template <> void Options::set(
    options::cegqiMultiInst__option_t,
    const options::cegqiMultiInst__option_t::type& x)
{
  d_holder->cegqiMultiInst = x;
}
template <> const options::cegqiMultiInst__option_t::type& Options::operator[](
    options::cegqiMultiInst__option_t) const
{
  return d_holder->cegqiMultiInst;
}
template <> bool Options::wasSetByUser(options::cegqiMultiInst__option_t) const
{
  return d_holder->cegqiMultiInst__setByUser__;
}
template <> void Options::set(
    options::cegqiNestedQE__option_t,
    const options::cegqiNestedQE__option_t::type& x)
{
  d_holder->cegqiNestedQE = x;
}
template <> const options::cegqiNestedQE__option_t::type& Options::operator[](
    options::cegqiNestedQE__option_t) const
{
  return d_holder->cegqiNestedQE;
}
template <> bool Options::wasSetByUser(options::cegqiNestedQE__option_t) const
{
  return d_holder->cegqiNestedQE__setByUser__;
}
template <> const options::cegqiNopt__option_t::type& Options::operator[](
    options::cegqiNopt__option_t) const
{
  return d_holder->cegqiNopt;
}
template <> bool Options::wasSetByUser(options::cegqiNopt__option_t) const
{
  return d_holder->cegqiNopt__setByUser__;
}
template <> void Options::set(
    options::cegqiPreRegInst__option_t,
    const options::cegqiPreRegInst__option_t::type& x)
{
  d_holder->cegqiPreRegInst = x;
}
template <> const options::cegqiPreRegInst__option_t::type& Options::operator[](
    options::cegqiPreRegInst__option_t) const
{
  return d_holder->cegqiPreRegInst;
}
template <> bool Options::wasSetByUser(options::cegqiPreRegInst__option_t) const
{
  return d_holder->cegqiPreRegInst__setByUser__;
}
template <> void Options::set(
    options::cegqiRepeatLit__option_t,
    const options::cegqiRepeatLit__option_t::type& x)
{
  d_holder->cegqiRepeatLit = x;
}
template <> const options::cegqiRepeatLit__option_t::type& Options::operator[](
    options::cegqiRepeatLit__option_t) const
{
  return d_holder->cegqiRepeatLit;
}
template <> bool Options::wasSetByUser(options::cegqiRepeatLit__option_t) const
{
  return d_holder->cegqiRepeatLit__setByUser__;
}
template <> const options::cegqiRoundUpLowerLia__option_t::type& Options::operator[](
    options::cegqiRoundUpLowerLia__option_t) const
{
  return d_holder->cegqiRoundUpLowerLia;
}
template <> bool Options::wasSetByUser(options::cegqiRoundUpLowerLia__option_t) const
{
  return d_holder->cegqiRoundUpLowerLia__setByUser__;
}
template <> void Options::set(
    options::cegqiSat__option_t,
    const options::cegqiSat__option_t::type& x)
{
  d_holder->cegqiSat = x;
}
template <> const options::cegqiSat__option_t::type& Options::operator[](
    options::cegqiSat__option_t) const
{
  return d_holder->cegqiSat;
}
template <> bool Options::wasSetByUser(options::cegqiSat__option_t) const
{
  return d_holder->cegqiSat__setByUser__;
}
template <> void Options::set(
    options::cegqiUseInfInt__option_t,
    const options::cegqiUseInfInt__option_t::type& x)
{
  d_holder->cegqiUseInfInt = x;
}
template <> const options::cegqiUseInfInt__option_t::type& Options::operator[](
    options::cegqiUseInfInt__option_t) const
{
  return d_holder->cegqiUseInfInt;
}
template <> bool Options::wasSetByUser(options::cegqiUseInfInt__option_t) const
{
  return d_holder->cegqiUseInfInt__setByUser__;
}
template <> void Options::set(
    options::cegqiUseInfReal__option_t,
    const options::cegqiUseInfReal__option_t::type& x)
{
  d_holder->cegqiUseInfReal = x;
}
template <> const options::cegqiUseInfReal__option_t::type& Options::operator[](
    options::cegqiUseInfReal__option_t) const
{
  return d_holder->cegqiUseInfReal;
}
template <> bool Options::wasSetByUser(options::cegqiUseInfReal__option_t) const
{
  return d_holder->cegqiUseInfReal__setByUser__;
}
template <> const options::condVarSplitQuantAgg__option_t::type& Options::operator[](
    options::condVarSplitQuantAgg__option_t) const
{
  return d_holder->condVarSplitQuantAgg;
}
template <> bool Options::wasSetByUser(options::condVarSplitQuantAgg__option_t) const
{
  return d_holder->condVarSplitQuantAgg__setByUser__;
}
template <> const options::condVarSplitQuant__option_t::type& Options::operator[](
    options::condVarSplitQuant__option_t) const
{
  return d_holder->condVarSplitQuant;
}
template <> bool Options::wasSetByUser(options::condVarSplitQuant__option_t) const
{
  return d_holder->condVarSplitQuant__setByUser__;
}
template <> void Options::set(
    options::conjectureFilterActiveTerms__option_t,
    const options::conjectureFilterActiveTerms__option_t::type& x)
{
  d_holder->conjectureFilterActiveTerms = x;
}
template <> const options::conjectureFilterActiveTerms__option_t::type& Options::operator[](
    options::conjectureFilterActiveTerms__option_t) const
{
  return d_holder->conjectureFilterActiveTerms;
}
template <> bool Options::wasSetByUser(options::conjectureFilterActiveTerms__option_t) const
{
  return d_holder->conjectureFilterActiveTerms__setByUser__;
}
template <> void Options::set(
    options::conjectureFilterCanonical__option_t,
    const options::conjectureFilterCanonical__option_t::type& x)
{
  d_holder->conjectureFilterCanonical = x;
}
template <> const options::conjectureFilterCanonical__option_t::type& Options::operator[](
    options::conjectureFilterCanonical__option_t) const
{
  return d_holder->conjectureFilterCanonical;
}
template <> bool Options::wasSetByUser(options::conjectureFilterCanonical__option_t) const
{
  return d_holder->conjectureFilterCanonical__setByUser__;
}
template <> void Options::set(
    options::conjectureFilterModel__option_t,
    const options::conjectureFilterModel__option_t::type& x)
{
  d_holder->conjectureFilterModel = x;
}
template <> const options::conjectureFilterModel__option_t::type& Options::operator[](
    options::conjectureFilterModel__option_t) const
{
  return d_holder->conjectureFilterModel;
}
template <> bool Options::wasSetByUser(options::conjectureFilterModel__option_t) const
{
  return d_holder->conjectureFilterModel__setByUser__;
}
template <> void Options::set(
    options::conjectureGen__option_t,
    const options::conjectureGen__option_t::type& x)
{
  d_holder->conjectureGen = x;
}
template <> const options::conjectureGen__option_t::type& Options::operator[](
    options::conjectureGen__option_t) const
{
  return d_holder->conjectureGen;
}
template <> bool Options::wasSetByUser(options::conjectureGen__option_t) const
{
  return d_holder->conjectureGen__setByUser__;
}
template <> const options::conjectureGenGtEnum__option_t::type& Options::operator[](
    options::conjectureGenGtEnum__option_t) const
{
  return d_holder->conjectureGenGtEnum;
}
template <> bool Options::wasSetByUser(options::conjectureGenGtEnum__option_t) const
{
  return d_holder->conjectureGenGtEnum__setByUser__;
}
template <> const options::conjectureGenMaxDepth__option_t::type& Options::operator[](
    options::conjectureGenMaxDepth__option_t) const
{
  return d_holder->conjectureGenMaxDepth;
}
template <> bool Options::wasSetByUser(options::conjectureGenMaxDepth__option_t) const
{
  return d_holder->conjectureGenMaxDepth__setByUser__;
}
template <> const options::conjectureGenPerRound__option_t::type& Options::operator[](
    options::conjectureGenPerRound__option_t) const
{
  return d_holder->conjectureGenPerRound;
}
template <> bool Options::wasSetByUser(options::conjectureGenPerRound__option_t) const
{
  return d_holder->conjectureGenPerRound__setByUser__;
}
template <> const options::conjectureUeeIntro__option_t::type& Options::operator[](
    options::conjectureUeeIntro__option_t) const
{
  return d_holder->conjectureUeeIntro;
}
template <> bool Options::wasSetByUser(options::conjectureUeeIntro__option_t) const
{
  return d_holder->conjectureUeeIntro__setByUser__;
}
template <> const options::conjectureNoFilter__option_t::type& Options::operator[](
    options::conjectureNoFilter__option_t) const
{
  return d_holder->conjectureNoFilter;
}
template <> bool Options::wasSetByUser(options::conjectureNoFilter__option_t) const
{
  return d_holder->conjectureNoFilter__setByUser__;
}
template <> void Options::set(
    options::dtStcInduction__option_t,
    const options::dtStcInduction__option_t::type& x)
{
  d_holder->dtStcInduction = x;
}
template <> const options::dtStcInduction__option_t::type& Options::operator[](
    options::dtStcInduction__option_t) const
{
  return d_holder->dtStcInduction;
}
template <> bool Options::wasSetByUser(options::dtStcInduction__option_t) const
{
  return d_holder->dtStcInduction__setByUser__;
}
template <> const options::dtVarExpandQuant__option_t::type& Options::operator[](
    options::dtVarExpandQuant__option_t) const
{
  return d_holder->dtVarExpandQuant;
}
template <> bool Options::wasSetByUser(options::dtVarExpandQuant__option_t) const
{
  return d_holder->dtVarExpandQuant__setByUser__;
}
template <> void Options::set(
    options::eMatching__option_t,
    const options::eMatching__option_t::type& x)
{
  d_holder->eMatching = x;
}
template <> const options::eMatching__option_t::type& Options::operator[](
    options::eMatching__option_t) const
{
  return d_holder->eMatching;
}
template <> bool Options::wasSetByUser(options::eMatching__option_t) const
{
  return d_holder->eMatching__setByUser__;
}
template <> void Options::set(
    options::elimExtArithQuant__option_t,
    const options::elimExtArithQuant__option_t::type& x)
{
  d_holder->elimExtArithQuant = x;
}
template <> const options::elimExtArithQuant__option_t::type& Options::operator[](
    options::elimExtArithQuant__option_t) const
{
  return d_holder->elimExtArithQuant;
}
template <> bool Options::wasSetByUser(options::elimExtArithQuant__option_t) const
{
  return d_holder->elimExtArithQuant__setByUser__;
}
template <> const options::elimTautQuant__option_t::type& Options::operator[](
    options::elimTautQuant__option_t) const
{
  return d_holder->elimTautQuant;
}
template <> bool Options::wasSetByUser(options::elimTautQuant__option_t) const
{
  return d_holder->elimTautQuant__setByUser__;
}
template <> const options::extRewriteQuant__option_t::type& Options::operator[](
    options::extRewriteQuant__option_t) const
{
  return d_holder->extRewriteQuant;
}
template <> bool Options::wasSetByUser(options::extRewriteQuant__option_t) const
{
  return d_holder->extRewriteQuant__setByUser__;
}
template <> void Options::set(
    options::finiteModelFind__option_t,
    const options::finiteModelFind__option_t::type& x)
{
  d_holder->finiteModelFind = x;
}
template <> const options::finiteModelFind__option_t::type& Options::operator[](
    options::finiteModelFind__option_t) const
{
  return d_holder->finiteModelFind;
}
template <> bool Options::wasSetByUser(options::finiteModelFind__option_t) const
{
  return d_holder->finiteModelFind__setByUser__;
}
template <> void Options::set(
    options::fmfBound__option_t,
    const options::fmfBound__option_t::type& x)
{
  d_holder->fmfBound = x;
}
template <> const options::fmfBound__option_t::type& Options::operator[](
    options::fmfBound__option_t) const
{
  return d_holder->fmfBound;
}
template <> bool Options::wasSetByUser(options::fmfBound__option_t) const
{
  return d_holder->fmfBound__setByUser__;
}
template <> void Options::set(
    options::fmfBoundInt__option_t,
    const options::fmfBoundInt__option_t::type& x)
{
  d_holder->fmfBoundInt = x;
}
template <> const options::fmfBoundInt__option_t::type& Options::operator[](
    options::fmfBoundInt__option_t) const
{
  return d_holder->fmfBoundInt;
}
template <> bool Options::wasSetByUser(options::fmfBoundInt__option_t) const
{
  return d_holder->fmfBoundInt__setByUser__;
}
template <> void Options::set(
    options::fmfBoundLazy__option_t,
    const options::fmfBoundLazy__option_t::type& x)
{
  d_holder->fmfBoundLazy = x;
}
template <> const options::fmfBoundLazy__option_t::type& Options::operator[](
    options::fmfBoundLazy__option_t) const
{
  return d_holder->fmfBoundLazy;
}
template <> bool Options::wasSetByUser(options::fmfBoundLazy__option_t) const
{
  return d_holder->fmfBoundLazy__setByUser__;
}
template <> const options::fmfFmcSimple__option_t::type& Options::operator[](
    options::fmfFmcSimple__option_t) const
{
  return d_holder->fmfFmcSimple;
}
template <> bool Options::wasSetByUser(options::fmfFmcSimple__option_t) const
{
  return d_holder->fmfFmcSimple__setByUser__;
}
template <> const options::fmfFreshDistConst__option_t::type& Options::operator[](
    options::fmfFreshDistConst__option_t) const
{
  return d_holder->fmfFreshDistConst;
}
template <> bool Options::wasSetByUser(options::fmfFreshDistConst__option_t) const
{
  return d_holder->fmfFreshDistConst__setByUser__;
}
template <> void Options::set(
    options::fmfFunWellDefined__option_t,
    const options::fmfFunWellDefined__option_t::type& x)
{
  d_holder->fmfFunWellDefined = x;
}
template <> const options::fmfFunWellDefined__option_t::type& Options::operator[](
    options::fmfFunWellDefined__option_t) const
{
  return d_holder->fmfFunWellDefined;
}
template <> bool Options::wasSetByUser(options::fmfFunWellDefined__option_t) const
{
  return d_holder->fmfFunWellDefined__setByUser__;
}
template <> const options::fmfFunWellDefinedRelevant__option_t::type& Options::operator[](
    options::fmfFunWellDefinedRelevant__option_t) const
{
  return d_holder->fmfFunWellDefinedRelevant;
}
template <> bool Options::wasSetByUser(options::fmfFunWellDefinedRelevant__option_t) const
{
  return d_holder->fmfFunWellDefinedRelevant__setByUser__;
}
template <> void Options::set(
    options::fmfInstEngine__option_t,
    const options::fmfInstEngine__option_t::type& x)
{
  d_holder->fmfInstEngine = x;
}
template <> const options::fmfInstEngine__option_t::type& Options::operator[](
    options::fmfInstEngine__option_t) const
{
  return d_holder->fmfInstEngine;
}
template <> bool Options::wasSetByUser(options::fmfInstEngine__option_t) const
{
  return d_holder->fmfInstEngine__setByUser__;
}
template <> const options::fmfTypeCompletionThresh__option_t::type& Options::operator[](
    options::fmfTypeCompletionThresh__option_t) const
{
  return d_holder->fmfTypeCompletionThresh;
}
template <> bool Options::wasSetByUser(options::fmfTypeCompletionThresh__option_t) const
{
  return d_holder->fmfTypeCompletionThresh__setByUser__;
}
template <> const options::fullSaturateInterleave__option_t::type& Options::operator[](
    options::fullSaturateInterleave__option_t) const
{
  return d_holder->fullSaturateInterleave;
}
template <> bool Options::wasSetByUser(options::fullSaturateInterleave__option_t) const
{
  return d_holder->fullSaturateInterleave__setByUser__;
}
template <> const options::fullSaturateStratify__option_t::type& Options::operator[](
    options::fullSaturateStratify__option_t) const
{
  return d_holder->fullSaturateStratify;
}
template <> bool Options::wasSetByUser(options::fullSaturateStratify__option_t) const
{
  return d_holder->fullSaturateStratify__setByUser__;
}
template <> void Options::set(
    options::fullSaturateQuant__option_t,
    const options::fullSaturateQuant__option_t::type& x)
{
  d_holder->fullSaturateQuant = x;
}
template <> const options::fullSaturateQuant__option_t::type& Options::operator[](
    options::fullSaturateQuant__option_t) const
{
  return d_holder->fullSaturateQuant;
}
template <> bool Options::wasSetByUser(options::fullSaturateQuant__option_t) const
{
  return d_holder->fullSaturateQuant__setByUser__;
}
template <> const options::fullSaturateLimit__option_t::type& Options::operator[](
    options::fullSaturateLimit__option_t) const
{
  return d_holder->fullSaturateLimit;
}
template <> bool Options::wasSetByUser(options::fullSaturateLimit__option_t) const
{
  return d_holder->fullSaturateLimit__setByUser__;
}
template <> const options::fullSaturateQuantRd__option_t::type& Options::operator[](
    options::fullSaturateQuantRd__option_t) const
{
  return d_holder->fullSaturateQuantRd;
}
template <> bool Options::wasSetByUser(options::fullSaturateQuantRd__option_t) const
{
  return d_holder->fullSaturateQuantRd__setByUser__;
}
template <> void Options::set(
    options::globalNegate__option_t,
    const options::globalNegate__option_t::type& x)
{
  d_holder->globalNegate = x;
}
template <> const options::globalNegate__option_t::type& Options::operator[](
    options::globalNegate__option_t) const
{
  return d_holder->globalNegate;
}
template <> bool Options::wasSetByUser(options::globalNegate__option_t) const
{
  return d_holder->globalNegate__setByUser__;
}
template <> const options::hoElim__option_t::type& Options::operator[](
    options::hoElim__option_t) const
{
  return d_holder->hoElim;
}
template <> bool Options::wasSetByUser(options::hoElim__option_t) const
{
  return d_holder->hoElim__setByUser__;
}
template <> void Options::set(
    options::hoElimStoreAx__option_t,
    const options::hoElimStoreAx__option_t::type& x)
{
  d_holder->hoElimStoreAx = x;
}
template <> const options::hoElimStoreAx__option_t::type& Options::operator[](
    options::hoElimStoreAx__option_t) const
{
  return d_holder->hoElimStoreAx;
}
template <> bool Options::wasSetByUser(options::hoElimStoreAx__option_t) const
{
  return d_holder->hoElimStoreAx__setByUser__;
}
template <> const options::hoMatching__option_t::type& Options::operator[](
    options::hoMatching__option_t) const
{
  return d_holder->hoMatching;
}
template <> bool Options::wasSetByUser(options::hoMatching__option_t) const
{
  return d_holder->hoMatching__setByUser__;
}
template <> const options::hoMatchingVarArgPriority__option_t::type& Options::operator[](
    options::hoMatchingVarArgPriority__option_t) const
{
  return d_holder->hoMatchingVarArgPriority;
}
template <> bool Options::wasSetByUser(options::hoMatchingVarArgPriority__option_t) const
{
  return d_holder->hoMatchingVarArgPriority__setByUser__;
}
template <> const options::hoMergeTermDb__option_t::type& Options::operator[](
    options::hoMergeTermDb__option_t) const
{
  return d_holder->hoMergeTermDb;
}
template <> bool Options::wasSetByUser(options::hoMergeTermDb__option_t) const
{
  return d_holder->hoMergeTermDb__setByUser__;
}
template <> const options::incrementTriggers__option_t::type& Options::operator[](
    options::incrementTriggers__option_t) const
{
  return d_holder->incrementTriggers;
}
template <> bool Options::wasSetByUser(options::incrementTriggers__option_t) const
{
  return d_holder->incrementTriggers__setByUser__;
}
template <> const options::instLevelInputOnly__option_t::type& Options::operator[](
    options::instLevelInputOnly__option_t) const
{
  return d_holder->instLevelInputOnly;
}
template <> bool Options::wasSetByUser(options::instLevelInputOnly__option_t) const
{
  return d_holder->instLevelInputOnly__setByUser__;
}
template <> void Options::set(
    options::instMaxLevel__option_t,
    const options::instMaxLevel__option_t::type& x)
{
  d_holder->instMaxLevel = x;
}
template <> const options::instMaxLevel__option_t::type& Options::operator[](
    options::instMaxLevel__option_t) const
{
  return d_holder->instMaxLevel;
}
template <> bool Options::wasSetByUser(options::instMaxLevel__option_t) const
{
  return d_holder->instMaxLevel__setByUser__;
}
template <> void Options::set(
    options::instNoEntail__option_t,
    const options::instNoEntail__option_t::type& x)
{
  d_holder->instNoEntail = x;
}
template <> const options::instNoEntail__option_t::type& Options::operator[](
    options::instNoEntail__option_t) const
{
  return d_holder->instNoEntail;
}
template <> bool Options::wasSetByUser(options::instNoEntail__option_t) const
{
  return d_holder->instNoEntail__setByUser__;
}
template <> void Options::set(
    options::instNoModelTrue__option_t,
    const options::instNoModelTrue__option_t::type& x)
{
  d_holder->instNoModelTrue = x;
}
template <> const options::instNoModelTrue__option_t::type& Options::operator[](
    options::instNoModelTrue__option_t) const
{
  return d_holder->instNoModelTrue;
}
template <> bool Options::wasSetByUser(options::instNoModelTrue__option_t) const
{
  return d_holder->instNoModelTrue__setByUser__;
}
template <> void Options::set(
    options::instWhenPhase__option_t,
    const options::instWhenPhase__option_t::type& x)
{
  d_holder->instWhenPhase = x;
}
template <> const options::instWhenPhase__option_t::type& Options::operator[](
    options::instWhenPhase__option_t) const
{
  return d_holder->instWhenPhase;
}
template <> bool Options::wasSetByUser(options::instWhenPhase__option_t) const
{
  return d_holder->instWhenPhase__setByUser__;
}
template <> void Options::set(
    options::instWhenStrictInterleave__option_t,
    const options::instWhenStrictInterleave__option_t::type& x)
{
  d_holder->instWhenStrictInterleave = x;
}
template <> const options::instWhenStrictInterleave__option_t::type& Options::operator[](
    options::instWhenStrictInterleave__option_t) const
{
  return d_holder->instWhenStrictInterleave;
}
template <> bool Options::wasSetByUser(options::instWhenStrictInterleave__option_t) const
{
  return d_holder->instWhenStrictInterleave__setByUser__;
}
template <> void Options::set(
    options::instWhenTcFirst__option_t,
    const options::instWhenTcFirst__option_t::type& x)
{
  d_holder->instWhenTcFirst = x;
}
template <> const options::instWhenTcFirst__option_t::type& Options::operator[](
    options::instWhenTcFirst__option_t) const
{
  return d_holder->instWhenTcFirst;
}
template <> bool Options::wasSetByUser(options::instWhenTcFirst__option_t) const
{
  return d_holder->instWhenTcFirst__setByUser__;
}
template <> void Options::set(
    options::instWhenMode__option_t,
    const options::instWhenMode__option_t::type& x)
{
  d_holder->instWhenMode = x;
}
template <> const options::instWhenMode__option_t::type& Options::operator[](
    options::instWhenMode__option_t) const
{
  return d_holder->instWhenMode;
}
template <> bool Options::wasSetByUser(options::instWhenMode__option_t) const
{
  return d_holder->instWhenMode__setByUser__;
}
template <> void Options::set(
    options::intWfInduction__option_t,
    const options::intWfInduction__option_t::type& x)
{
  d_holder->intWfInduction = x;
}
template <> const options::intWfInduction__option_t::type& Options::operator[](
    options::intWfInduction__option_t) const
{
  return d_holder->intWfInduction;
}
template <> bool Options::wasSetByUser(options::intWfInduction__option_t) const
{
  return d_holder->intWfInduction__setByUser__;
}
template <> void Options::set(
    options::iteDtTesterSplitQuant__option_t,
    const options::iteDtTesterSplitQuant__option_t::type& x)
{
  d_holder->iteDtTesterSplitQuant = x;
}
template <> const options::iteDtTesterSplitQuant__option_t::type& Options::operator[](
    options::iteDtTesterSplitQuant__option_t) const
{
  return d_holder->iteDtTesterSplitQuant;
}
template <> bool Options::wasSetByUser(options::iteDtTesterSplitQuant__option_t) const
{
  return d_holder->iteDtTesterSplitQuant__setByUser__;
}
template <> void Options::set(
    options::iteLiftQuant__option_t,
    const options::iteLiftQuant__option_t::type& x)
{
  d_holder->iteLiftQuant = x;
}
template <> const options::iteLiftQuant__option_t::type& Options::operator[](
    options::iteLiftQuant__option_t) const
{
  return d_holder->iteLiftQuant;
}
template <> bool Options::wasSetByUser(options::iteLiftQuant__option_t) const
{
  return d_holder->iteLiftQuant__setByUser__;
}
template <> const options::literalMatchMode__option_t::type& Options::operator[](
    options::literalMatchMode__option_t) const
{
  return d_holder->literalMatchMode;
}
template <> bool Options::wasSetByUser(options::literalMatchMode__option_t) const
{
  return d_holder->literalMatchMode__setByUser__;
}
template <> const options::lteRestrictInstClosure__option_t::type& Options::operator[](
    options::lteRestrictInstClosure__option_t) const
{
  return d_holder->lteRestrictInstClosure;
}
template <> bool Options::wasSetByUser(options::lteRestrictInstClosure__option_t) const
{
  return d_holder->lteRestrictInstClosure__setByUser__;
}
template <> void Options::set(
    options::macrosQuant__option_t,
    const options::macrosQuant__option_t::type& x)
{
  d_holder->macrosQuant = x;
}
template <> const options::macrosQuant__option_t::type& Options::operator[](
    options::macrosQuant__option_t) const
{
  return d_holder->macrosQuant;
}
template <> bool Options::wasSetByUser(options::macrosQuant__option_t) const
{
  return d_holder->macrosQuant__setByUser__;
}
template <> const options::macrosQuantMode__option_t::type& Options::operator[](
    options::macrosQuantMode__option_t) const
{
  return d_holder->macrosQuantMode;
}
template <> bool Options::wasSetByUser(options::macrosQuantMode__option_t) const
{
  return d_holder->macrosQuantMode__setByUser__;
}
template <> const options::mbqiInterleave__option_t::type& Options::operator[](
    options::mbqiInterleave__option_t) const
{
  return d_holder->mbqiInterleave;
}
template <> bool Options::wasSetByUser(options::mbqiInterleave__option_t) const
{
  return d_holder->mbqiInterleave__setByUser__;
}
template <> void Options::set(
    options::fmfOneInstPerRound__option_t,
    const options::fmfOneInstPerRound__option_t::type& x)
{
  d_holder->fmfOneInstPerRound = x;
}
template <> const options::fmfOneInstPerRound__option_t::type& Options::operator[](
    options::fmfOneInstPerRound__option_t) const
{
  return d_holder->fmfOneInstPerRound;
}
template <> bool Options::wasSetByUser(options::fmfOneInstPerRound__option_t) const
{
  return d_holder->fmfOneInstPerRound__setByUser__;
}
template <> void Options::set(
    options::mbqiMode__option_t,
    const options::mbqiMode__option_t::type& x)
{
  d_holder->mbqiMode = x;
}
template <> const options::mbqiMode__option_t::type& Options::operator[](
    options::mbqiMode__option_t) const
{
  return d_holder->mbqiMode;
}
template <> bool Options::wasSetByUser(options::mbqiMode__option_t) const
{
  return d_holder->mbqiMode__setByUser__;
}
template <> void Options::set(
    options::miniscopeQuant__option_t,
    const options::miniscopeQuant__option_t::type& x)
{
  d_holder->miniscopeQuant = x;
}
template <> const options::miniscopeQuant__option_t::type& Options::operator[](
    options::miniscopeQuant__option_t) const
{
  return d_holder->miniscopeQuant;
}
template <> bool Options::wasSetByUser(options::miniscopeQuant__option_t) const
{
  return d_holder->miniscopeQuant__setByUser__;
}
template <> void Options::set(
    options::miniscopeQuantFreeVar__option_t,
    const options::miniscopeQuantFreeVar__option_t::type& x)
{
  d_holder->miniscopeQuantFreeVar = x;
}
template <> const options::miniscopeQuantFreeVar__option_t::type& Options::operator[](
    options::miniscopeQuantFreeVar__option_t) const
{
  return d_holder->miniscopeQuantFreeVar;
}
template <> bool Options::wasSetByUser(options::miniscopeQuantFreeVar__option_t) const
{
  return d_holder->miniscopeQuantFreeVar__setByUser__;
}
template <> const options::multiTriggerCache__option_t::type& Options::operator[](
    options::multiTriggerCache__option_t) const
{
  return d_holder->multiTriggerCache;
}
template <> bool Options::wasSetByUser(options::multiTriggerCache__option_t) const
{
  return d_holder->multiTriggerCache__setByUser__;
}
template <> const options::multiTriggerLinear__option_t::type& Options::operator[](
    options::multiTriggerLinear__option_t) const
{
  return d_holder->multiTriggerLinear;
}
template <> bool Options::wasSetByUser(options::multiTriggerLinear__option_t) const
{
  return d_holder->multiTriggerLinear__setByUser__;
}
template <> const options::multiTriggerPriority__option_t::type& Options::operator[](
    options::multiTriggerPriority__option_t) const
{
  return d_holder->multiTriggerPriority;
}
template <> bool Options::wasSetByUser(options::multiTriggerPriority__option_t) const
{
  return d_holder->multiTriggerPriority__setByUser__;
}
template <> const options::multiTriggerWhenSingle__option_t::type& Options::operator[](
    options::multiTriggerWhenSingle__option_t) const
{
  return d_holder->multiTriggerWhenSingle;
}
template <> bool Options::wasSetByUser(options::multiTriggerWhenSingle__option_t) const
{
  return d_holder->multiTriggerWhenSingle__setByUser__;
}
template <> void Options::set(
    options::partialTriggers__option_t,
    const options::partialTriggers__option_t::type& x)
{
  d_holder->partialTriggers = x;
}
template <> const options::partialTriggers__option_t::type& Options::operator[](
    options::partialTriggers__option_t) const
{
  return d_holder->partialTriggers;
}
template <> bool Options::wasSetByUser(options::partialTriggers__option_t) const
{
  return d_holder->partialTriggers__setByUser__;
}
template <> void Options::set(
    options::preSkolemQuant__option_t,
    const options::preSkolemQuant__option_t::type& x)
{
  d_holder->preSkolemQuant = x;
}
template <> const options::preSkolemQuant__option_t::type& Options::operator[](
    options::preSkolemQuant__option_t) const
{
  return d_holder->preSkolemQuant;
}
template <> bool Options::wasSetByUser(options::preSkolemQuant__option_t) const
{
  return d_holder->preSkolemQuant__setByUser__;
}
template <> void Options::set(
    options::preSkolemQuantAgg__option_t,
    const options::preSkolemQuantAgg__option_t::type& x)
{
  d_holder->preSkolemQuantAgg = x;
}
template <> const options::preSkolemQuantAgg__option_t::type& Options::operator[](
    options::preSkolemQuantAgg__option_t) const
{
  return d_holder->preSkolemQuantAgg;
}
template <> bool Options::wasSetByUser(options::preSkolemQuantAgg__option_t) const
{
  return d_holder->preSkolemQuantAgg__setByUser__;
}
template <> void Options::set(
    options::preSkolemQuantNested__option_t,
    const options::preSkolemQuantNested__option_t::type& x)
{
  d_holder->preSkolemQuantNested = x;
}
template <> const options::preSkolemQuantNested__option_t::type& Options::operator[](
    options::preSkolemQuantNested__option_t) const
{
  return d_holder->preSkolemQuantNested;
}
template <> bool Options::wasSetByUser(options::preSkolemQuantNested__option_t) const
{
  return d_holder->preSkolemQuantNested__setByUser__;
}
template <> void Options::set(
    options::prenexQuantUser__option_t,
    const options::prenexQuantUser__option_t::type& x)
{
  d_holder->prenexQuantUser = x;
}
template <> const options::prenexQuantUser__option_t::type& Options::operator[](
    options::prenexQuantUser__option_t) const
{
  return d_holder->prenexQuantUser;
}
template <> bool Options::wasSetByUser(options::prenexQuantUser__option_t) const
{
  return d_holder->prenexQuantUser__setByUser__;
}
template <> void Options::set(
    options::prenexQuant__option_t,
    const options::prenexQuant__option_t::type& x)
{
  d_holder->prenexQuant = x;
}
template <> const options::prenexQuant__option_t::type& Options::operator[](
    options::prenexQuant__option_t) const
{
  return d_holder->prenexQuant;
}
template <> bool Options::wasSetByUser(options::prenexQuant__option_t) const
{
  return d_holder->prenexQuant__setByUser__;
}
template <> void Options::set(
    options::pureThTriggers__option_t,
    const options::pureThTriggers__option_t::type& x)
{
  d_holder->pureThTriggers = x;
}
template <> const options::pureThTriggers__option_t::type& Options::operator[](
    options::pureThTriggers__option_t) const
{
  return d_holder->pureThTriggers;
}
template <> bool Options::wasSetByUser(options::pureThTriggers__option_t) const
{
  return d_holder->pureThTriggers__setByUser__;
}
template <> void Options::set(
    options::purifyDtTriggers__option_t,
    const options::purifyDtTriggers__option_t::type& x)
{
  d_holder->purifyDtTriggers = x;
}
template <> const options::purifyDtTriggers__option_t::type& Options::operator[](
    options::purifyDtTriggers__option_t) const
{
  return d_holder->purifyDtTriggers;
}
template <> bool Options::wasSetByUser(options::purifyDtTriggers__option_t) const
{
  return d_holder->purifyDtTriggers__setByUser__;
}
template <> void Options::set(
    options::purifyTriggers__option_t,
    const options::purifyTriggers__option_t::type& x)
{
  d_holder->purifyTriggers = x;
}
template <> const options::purifyTriggers__option_t::type& Options::operator[](
    options::purifyTriggers__option_t) const
{
  return d_holder->purifyTriggers;
}
template <> bool Options::wasSetByUser(options::purifyTriggers__option_t) const
{
  return d_holder->purifyTriggers__setByUser__;
}
template <> void Options::set(
    options::qcfAllConflict__option_t,
    const options::qcfAllConflict__option_t::type& x)
{
  d_holder->qcfAllConflict = x;
}
template <> const options::qcfAllConflict__option_t::type& Options::operator[](
    options::qcfAllConflict__option_t) const
{
  return d_holder->qcfAllConflict;
}
template <> bool Options::wasSetByUser(options::qcfAllConflict__option_t) const
{
  return d_holder->qcfAllConflict__setByUser__;
}
template <> const options::qcfEagerCheckRd__option_t::type& Options::operator[](
    options::qcfEagerCheckRd__option_t) const
{
  return d_holder->qcfEagerCheckRd;
}
template <> bool Options::wasSetByUser(options::qcfEagerCheckRd__option_t) const
{
  return d_holder->qcfEagerCheckRd__setByUser__;
}
template <> const options::qcfEagerTest__option_t::type& Options::operator[](
    options::qcfEagerTest__option_t) const
{
  return d_holder->qcfEagerTest;
}
template <> bool Options::wasSetByUser(options::qcfEagerTest__option_t) const
{
  return d_holder->qcfEagerTest__setByUser__;
}
template <> const options::qcfNestedConflict__option_t::type& Options::operator[](
    options::qcfNestedConflict__option_t) const
{
  return d_holder->qcfNestedConflict;
}
template <> bool Options::wasSetByUser(options::qcfNestedConflict__option_t) const
{
  return d_holder->qcfNestedConflict__setByUser__;
}
template <> const options::qcfSkipRd__option_t::type& Options::operator[](
    options::qcfSkipRd__option_t) const
{
  return d_holder->qcfSkipRd;
}
template <> bool Options::wasSetByUser(options::qcfSkipRd__option_t) const
{
  return d_holder->qcfSkipRd__setByUser__;
}
template <> void Options::set(
    options::qcfTConstraint__option_t,
    const options::qcfTConstraint__option_t::type& x)
{
  d_holder->qcfTConstraint = x;
}
template <> const options::qcfTConstraint__option_t::type& Options::operator[](
    options::qcfTConstraint__option_t) const
{
  return d_holder->qcfTConstraint;
}
template <> bool Options::wasSetByUser(options::qcfTConstraint__option_t) const
{
  return d_holder->qcfTConstraint__setByUser__;
}
template <> const options::qcfVoExp__option_t::type& Options::operator[](
    options::qcfVoExp__option_t) const
{
  return d_holder->qcfVoExp;
}
template <> bool Options::wasSetByUser(options::qcfVoExp__option_t) const
{
  return d_holder->qcfVoExp__setByUser__;
}
template <> const options::quantAlphaEquiv__option_t::type& Options::operator[](
    options::quantAlphaEquiv__option_t) const
{
  return d_holder->quantAlphaEquiv;
}
template <> bool Options::wasSetByUser(options::quantAlphaEquiv__option_t) const
{
  return d_holder->quantAlphaEquiv__setByUser__;
}
template <> void Options::set(
    options::quantAntiSkolem__option_t,
    const options::quantAntiSkolem__option_t::type& x)
{
  d_holder->quantAntiSkolem = x;
}
template <> const options::quantAntiSkolem__option_t::type& Options::operator[](
    options::quantAntiSkolem__option_t) const
{
  return d_holder->quantAntiSkolem;
}
template <> bool Options::wasSetByUser(options::quantAntiSkolem__option_t) const
{
  return d_holder->quantAntiSkolem__setByUser__;
}
template <> void Options::set(
    options::quantConflictFind__option_t,
    const options::quantConflictFind__option_t::type& x)
{
  d_holder->quantConflictFind = x;
}
template <> const options::quantConflictFind__option_t::type& Options::operator[](
    options::quantConflictFind__option_t) const
{
  return d_holder->quantConflictFind;
}
template <> bool Options::wasSetByUser(options::quantConflictFind__option_t) const
{
  return d_holder->quantConflictFind__setByUser__;
}
template <> const options::qcfMode__option_t::type& Options::operator[](
    options::qcfMode__option_t) const
{
  return d_holder->qcfMode;
}
template <> bool Options::wasSetByUser(options::qcfMode__option_t) const
{
  return d_holder->qcfMode__setByUser__;
}
template <> const options::qcfWhenMode__option_t::type& Options::operator[](
    options::qcfWhenMode__option_t) const
{
  return d_holder->qcfWhenMode;
}
template <> bool Options::wasSetByUser(options::qcfWhenMode__option_t) const
{
  return d_holder->qcfWhenMode__setByUser__;
}
template <> void Options::set(
    options::quantDynamicSplit__option_t,
    const options::quantDynamicSplit__option_t::type& x)
{
  d_holder->quantDynamicSplit = x;
}
template <> const options::quantDynamicSplit__option_t::type& Options::operator[](
    options::quantDynamicSplit__option_t) const
{
  return d_holder->quantDynamicSplit;
}
template <> bool Options::wasSetByUser(options::quantDynamicSplit__option_t) const
{
  return d_holder->quantDynamicSplit__setByUser__;
}
template <> void Options::set(
    options::quantEpr__option_t,
    const options::quantEpr__option_t::type& x)
{
  d_holder->quantEpr = x;
}
template <> const options::quantEpr__option_t::type& Options::operator[](
    options::quantEpr__option_t) const
{
  return d_holder->quantEpr;
}
template <> bool Options::wasSetByUser(options::quantEpr__option_t) const
{
  return d_holder->quantEpr__setByUser__;
}
template <> const options::quantEprMatching__option_t::type& Options::operator[](
    options::quantEprMatching__option_t) const
{
  return d_holder->quantEprMatching;
}
template <> bool Options::wasSetByUser(options::quantEprMatching__option_t) const
{
  return d_holder->quantEprMatching__setByUser__;
}
template <> const options::quantFunWellDefined__option_t::type& Options::operator[](
    options::quantFunWellDefined__option_t) const
{
  return d_holder->quantFunWellDefined;
}
template <> bool Options::wasSetByUser(options::quantFunWellDefined__option_t) const
{
  return d_holder->quantFunWellDefined__setByUser__;
}
template <> const options::quantInduction__option_t::type& Options::operator[](
    options::quantInduction__option_t) const
{
  return d_holder->quantInduction;
}
template <> bool Options::wasSetByUser(options::quantInduction__option_t) const
{
  return d_holder->quantInduction__setByUser__;
}
template <> const options::quantModelEe__option_t::type& Options::operator[](
    options::quantModelEe__option_t) const
{
  return d_holder->quantModelEe;
}
template <> bool Options::wasSetByUser(options::quantModelEe__option_t) const
{
  return d_holder->quantModelEe__setByUser__;
}
template <> void Options::set(
    options::quantRepMode__option_t,
    const options::quantRepMode__option_t::type& x)
{
  d_holder->quantRepMode = x;
}
template <> const options::quantRepMode__option_t::type& Options::operator[](
    options::quantRepMode__option_t) const
{
  return d_holder->quantRepMode;
}
template <> bool Options::wasSetByUser(options::quantRepMode__option_t) const
{
  return d_holder->quantRepMode__setByUser__;
}
template <> void Options::set(
    options::quantSplit__option_t,
    const options::quantSplit__option_t::type& x)
{
  d_holder->quantSplit = x;
}
template <> const options::quantSplit__option_t::type& Options::operator[](
    options::quantSplit__option_t) const
{
  return d_holder->quantSplit;
}
template <> bool Options::wasSetByUser(options::quantSplit__option_t) const
{
  return d_holder->quantSplit__setByUser__;
}
template <> const options::registerQuantBodyTerms__option_t::type& Options::operator[](
    options::registerQuantBodyTerms__option_t) const
{
  return d_holder->registerQuantBodyTerms;
}
template <> bool Options::wasSetByUser(options::registerQuantBodyTerms__option_t) const
{
  return d_holder->registerQuantBodyTerms__setByUser__;
}
template <> const options::relationalTriggers__option_t::type& Options::operator[](
    options::relationalTriggers__option_t) const
{
  return d_holder->relationalTriggers;
}
template <> bool Options::wasSetByUser(options::relationalTriggers__option_t) const
{
  return d_holder->relationalTriggers__setByUser__;
}
template <> const options::relevantTriggers__option_t::type& Options::operator[](
    options::relevantTriggers__option_t) const
{
  return d_holder->relevantTriggers;
}
template <> bool Options::wasSetByUser(options::relevantTriggers__option_t) const
{
  return d_holder->relevantTriggers__setByUser__;
}
template <> const options::strictTriggers__option_t::type& Options::operator[](
    options::strictTriggers__option_t) const
{
  return d_holder->strictTriggers;
}
template <> bool Options::wasSetByUser(options::strictTriggers__option_t) const
{
  return d_holder->strictTriggers__setByUser__;
}
template <> void Options::set(
    options::sygus__option_t,
    const options::sygus__option_t::type& x)
{
  d_holder->sygus = x;
}
template <> const options::sygus__option_t::type& Options::operator[](
    options::sygus__option_t) const
{
  return d_holder->sygus;
}
template <> bool Options::wasSetByUser(options::sygus__option_t) const
{
  return d_holder->sygus__setByUser__;
}
template <> void Options::set(
    options::sygusActiveGenEnumConsts__option_t,
    const options::sygusActiveGenEnumConsts__option_t::type& x)
{
  d_holder->sygusActiveGenEnumConsts = x;
}
template <> const options::sygusActiveGenEnumConsts__option_t::type& Options::operator[](
    options::sygusActiveGenEnumConsts__option_t) const
{
  return d_holder->sygusActiveGenEnumConsts;
}
template <> bool Options::wasSetByUser(options::sygusActiveGenEnumConsts__option_t) const
{
  return d_holder->sygusActiveGenEnumConsts__setByUser__;
}
template <> const options::sygusActiveGenMode__option_t::type& Options::operator[](
    options::sygusActiveGenMode__option_t) const
{
  return d_holder->sygusActiveGenMode;
}
template <> bool Options::wasSetByUser(options::sygusActiveGenMode__option_t) const
{
  return d_holder->sygusActiveGenMode__setByUser__;
}
template <> const options::sygusAddConstGrammar__option_t::type& Options::operator[](
    options::sygusAddConstGrammar__option_t) const
{
  return d_holder->sygusAddConstGrammar;
}
template <> bool Options::wasSetByUser(options::sygusAddConstGrammar__option_t) const
{
  return d_holder->sygusAddConstGrammar__setByUser__;
}
template <> void Options::set(
    options::sygusArgRelevant__option_t,
    const options::sygusArgRelevant__option_t::type& x)
{
  d_holder->sygusArgRelevant = x;
}
template <> const options::sygusArgRelevant__option_t::type& Options::operator[](
    options::sygusArgRelevant__option_t) const
{
  return d_holder->sygusArgRelevant;
}
template <> bool Options::wasSetByUser(options::sygusArgRelevant__option_t) const
{
  return d_holder->sygusArgRelevant__setByUser__;
}
template <> const options::sygusInvAutoUnfold__option_t::type& Options::operator[](
    options::sygusInvAutoUnfold__option_t) const
{
  return d_holder->sygusInvAutoUnfold;
}
template <> bool Options::wasSetByUser(options::sygusInvAutoUnfold__option_t) const
{
  return d_holder->sygusInvAutoUnfold__setByUser__;
}
template <> void Options::set(
    options::sygusBoolIteReturnConst__option_t,
    const options::sygusBoolIteReturnConst__option_t::type& x)
{
  d_holder->sygusBoolIteReturnConst = x;
}
template <> const options::sygusBoolIteReturnConst__option_t::type& Options::operator[](
    options::sygusBoolIteReturnConst__option_t) const
{
  return d_holder->sygusBoolIteReturnConst;
}
template <> bool Options::wasSetByUser(options::sygusBoolIteReturnConst__option_t) const
{
  return d_holder->sygusBoolIteReturnConst__setByUser__;
}
template <> void Options::set(
    options::sygusCoreConnective__option_t,
    const options::sygusCoreConnective__option_t::type& x)
{
  d_holder->sygusCoreConnective = x;
}
template <> const options::sygusCoreConnective__option_t::type& Options::operator[](
    options::sygusCoreConnective__option_t) const
{
  return d_holder->sygusCoreConnective;
}
template <> bool Options::wasSetByUser(options::sygusCoreConnective__option_t) const
{
  return d_holder->sygusCoreConnective__setByUser__;
}
template <> const options::sygusConstRepairAbort__option_t::type& Options::operator[](
    options::sygusConstRepairAbort__option_t) const
{
  return d_holder->sygusConstRepairAbort;
}
template <> bool Options::wasSetByUser(options::sygusConstRepairAbort__option_t) const
{
  return d_holder->sygusConstRepairAbort__setByUser__;
}
template <> void Options::set(
    options::sygusEvalOpt__option_t,
    const options::sygusEvalOpt__option_t::type& x)
{
  d_holder->sygusEvalOpt = x;
}
template <> const options::sygusEvalOpt__option_t::type& Options::operator[](
    options::sygusEvalOpt__option_t) const
{
  return d_holder->sygusEvalOpt;
}
template <> bool Options::wasSetByUser(options::sygusEvalOpt__option_t) const
{
  return d_holder->sygusEvalOpt__setByUser__;
}
template <> const options::sygusEvalUnfold__option_t::type& Options::operator[](
    options::sygusEvalUnfold__option_t) const
{
  return d_holder->sygusEvalUnfold;
}
template <> bool Options::wasSetByUser(options::sygusEvalUnfold__option_t) const
{
  return d_holder->sygusEvalUnfold__setByUser__;
}
template <> const options::sygusEvalUnfoldBool__option_t::type& Options::operator[](
    options::sygusEvalUnfoldBool__option_t) const
{
  return d_holder->sygusEvalUnfoldBool;
}
template <> bool Options::wasSetByUser(options::sygusEvalUnfoldBool__option_t) const
{
  return d_holder->sygusEvalUnfoldBool__setByUser__;
}
template <> void Options::set(
    options::sygusExprMinerCheckTimeout__option_t,
    const options::sygusExprMinerCheckTimeout__option_t::type& x)
{
  d_holder->sygusExprMinerCheckTimeout = x;
}
template <> const options::sygusExprMinerCheckTimeout__option_t::type& Options::operator[](
    options::sygusExprMinerCheckTimeout__option_t) const
{
  return d_holder->sygusExprMinerCheckTimeout;
}
template <> bool Options::wasSetByUser(options::sygusExprMinerCheckTimeout__option_t) const
{
  return d_holder->sygusExprMinerCheckTimeout__setByUser__;
}
template <> void Options::set(
    options::sygusExprMinerCheckUseExport__option_t,
    const options::sygusExprMinerCheckUseExport__option_t::type& x)
{
  d_holder->sygusExprMinerCheckUseExport = x;
}
template <> const options::sygusExprMinerCheckUseExport__option_t::type& Options::operator[](
    options::sygusExprMinerCheckUseExport__option_t) const
{
  return d_holder->sygusExprMinerCheckUseExport;
}
template <> bool Options::wasSetByUser(options::sygusExprMinerCheckUseExport__option_t) const
{
  return d_holder->sygusExprMinerCheckUseExport__setByUser__;
}
template <> void Options::set(
    options::sygusExtRew__option_t,
    const options::sygusExtRew__option_t::type& x)
{
  d_holder->sygusExtRew = x;
}
template <> const options::sygusExtRew__option_t::type& Options::operator[](
    options::sygusExtRew__option_t) const
{
  return d_holder->sygusExtRew;
}
template <> bool Options::wasSetByUser(options::sygusExtRew__option_t) const
{
  return d_holder->sygusExtRew__setByUser__;
}
template <> void Options::set(
    options::sygusFilterSolRevSubsume__option_t,
    const options::sygusFilterSolRevSubsume__option_t::type& x)
{
  d_holder->sygusFilterSolRevSubsume = x;
}
template <> const options::sygusFilterSolRevSubsume__option_t::type& Options::operator[](
    options::sygusFilterSolRevSubsume__option_t) const
{
  return d_holder->sygusFilterSolRevSubsume;
}
template <> bool Options::wasSetByUser(options::sygusFilterSolRevSubsume__option_t) const
{
  return d_holder->sygusFilterSolRevSubsume__setByUser__;
}
template <> void Options::set(
    options::sygusFilterSolMode__option_t,
    const options::sygusFilterSolMode__option_t::type& x)
{
  d_holder->sygusFilterSolMode = x;
}
template <> const options::sygusFilterSolMode__option_t::type& Options::operator[](
    options::sygusFilterSolMode__option_t) const
{
  return d_holder->sygusFilterSolMode;
}
template <> bool Options::wasSetByUser(options::sygusFilterSolMode__option_t) const
{
  return d_holder->sygusFilterSolMode__setByUser__;
}
template <> void Options::set(
    options::sygusGrammarConsMode__option_t,
    const options::sygusGrammarConsMode__option_t::type& x)
{
  d_holder->sygusGrammarConsMode = x;
}
template <> const options::sygusGrammarConsMode__option_t::type& Options::operator[](
    options::sygusGrammarConsMode__option_t) const
{
  return d_holder->sygusGrammarConsMode;
}
template <> bool Options::wasSetByUser(options::sygusGrammarConsMode__option_t) const
{
  return d_holder->sygusGrammarConsMode__setByUser__;
}
template <> const options::sygusGrammarNorm__option_t::type& Options::operator[](
    options::sygusGrammarNorm__option_t) const
{
  return d_holder->sygusGrammarNorm;
}
template <> bool Options::wasSetByUser(options::sygusGrammarNorm__option_t) const
{
  return d_holder->sygusGrammarNorm__setByUser__;
}
template <> void Options::set(
    options::sygusInference__option_t,
    const options::sygusInference__option_t::type& x)
{
  d_holder->sygusInference = x;
}
template <> const options::sygusInference__option_t::type& Options::operator[](
    options::sygusInference__option_t) const
{
  return d_holder->sygusInference;
}
template <> bool Options::wasSetByUser(options::sygusInference__option_t) const
{
  return d_holder->sygusInference__setByUser__;
}
template <> void Options::set(
    options::sygusInst__option_t,
    const options::sygusInst__option_t::type& x)
{
  d_holder->sygusInst = x;
}
template <> const options::sygusInst__option_t::type& Options::operator[](
    options::sygusInst__option_t) const
{
  return d_holder->sygusInst;
}
template <> bool Options::wasSetByUser(options::sygusInst__option_t) const
{
  return d_holder->sygusInst__setByUser__;
}
template <> void Options::set(
    options::sygusInvTemplWhenSyntax__option_t,
    const options::sygusInvTemplWhenSyntax__option_t::type& x)
{
  d_holder->sygusInvTemplWhenSyntax = x;
}
template <> const options::sygusInvTemplWhenSyntax__option_t::type& Options::operator[](
    options::sygusInvTemplWhenSyntax__option_t) const
{
  return d_holder->sygusInvTemplWhenSyntax;
}
template <> bool Options::wasSetByUser(options::sygusInvTemplWhenSyntax__option_t) const
{
  return d_holder->sygusInvTemplWhenSyntax__setByUser__;
}
template <> void Options::set(
    options::sygusInvTemplMode__option_t,
    const options::sygusInvTemplMode__option_t::type& x)
{
  d_holder->sygusInvTemplMode = x;
}
template <> const options::sygusInvTemplMode__option_t::type& Options::operator[](
    options::sygusInvTemplMode__option_t) const
{
  return d_holder->sygusInvTemplMode;
}
template <> bool Options::wasSetByUser(options::sygusInvTemplMode__option_t) const
{
  return d_holder->sygusInvTemplMode__setByUser__;
}
template <> const options::sygusMinGrammar__option_t::type& Options::operator[](
    options::sygusMinGrammar__option_t) const
{
  return d_holder->sygusMinGrammar;
}
template <> bool Options::wasSetByUser(options::sygusMinGrammar__option_t) const
{
  return d_holder->sygusMinGrammar__setByUser__;
}
template <> void Options::set(
    options::sygusUnifPbe__option_t,
    const options::sygusUnifPbe__option_t::type& x)
{
  d_holder->sygusUnifPbe = x;
}
template <> const options::sygusUnifPbe__option_t::type& Options::operator[](
    options::sygusUnifPbe__option_t) const
{
  return d_holder->sygusUnifPbe;
}
template <> bool Options::wasSetByUser(options::sygusUnifPbe__option_t) const
{
  return d_holder->sygusUnifPbe__setByUser__;
}
template <> void Options::set(
    options::sygusPbeMultiFair__option_t,
    const options::sygusPbeMultiFair__option_t::type& x)
{
  d_holder->sygusPbeMultiFair = x;
}
template <> const options::sygusPbeMultiFair__option_t::type& Options::operator[](
    options::sygusPbeMultiFair__option_t) const
{
  return d_holder->sygusPbeMultiFair;
}
template <> bool Options::wasSetByUser(options::sygusPbeMultiFair__option_t) const
{
  return d_holder->sygusPbeMultiFair__setByUser__;
}
template <> void Options::set(
    options::sygusPbeMultiFairDiff__option_t,
    const options::sygusPbeMultiFairDiff__option_t::type& x)
{
  d_holder->sygusPbeMultiFairDiff = x;
}
template <> const options::sygusPbeMultiFairDiff__option_t::type& Options::operator[](
    options::sygusPbeMultiFairDiff__option_t) const
{
  return d_holder->sygusPbeMultiFairDiff;
}
template <> bool Options::wasSetByUser(options::sygusPbeMultiFairDiff__option_t) const
{
  return d_holder->sygusPbeMultiFairDiff__setByUser__;
}
template <> const options::sygusQePreproc__option_t::type& Options::operator[](
    options::sygusQePreproc__option_t) const
{
  return d_holder->sygusQePreproc;
}
template <> bool Options::wasSetByUser(options::sygusQePreproc__option_t) const
{
  return d_holder->sygusQePreproc__setByUser__;
}
template <> void Options::set(
    options::sygusQueryGen__option_t,
    const options::sygusQueryGen__option_t::type& x)
{
  d_holder->sygusQueryGen = x;
}
template <> const options::sygusQueryGen__option_t::type& Options::operator[](
    options::sygusQueryGen__option_t) const
{
  return d_holder->sygusQueryGen;
}
template <> bool Options::wasSetByUser(options::sygusQueryGen__option_t) const
{
  return d_holder->sygusQueryGen__setByUser__;
}
template <> void Options::set(
    options::sygusQueryGenCheck__option_t,
    const options::sygusQueryGenCheck__option_t::type& x)
{
  d_holder->sygusQueryGenCheck = x;
}
template <> const options::sygusQueryGenCheck__option_t::type& Options::operator[](
    options::sygusQueryGenCheck__option_t) const
{
  return d_holder->sygusQueryGenCheck;
}
template <> bool Options::wasSetByUser(options::sygusQueryGenCheck__option_t) const
{
  return d_holder->sygusQueryGenCheck__setByUser__;
}
template <> void Options::set(
    options::sygusQueryGenDumpFiles__option_t,
    const options::sygusQueryGenDumpFiles__option_t::type& x)
{
  d_holder->sygusQueryGenDumpFiles = x;
}
template <> const options::sygusQueryGenDumpFiles__option_t::type& Options::operator[](
    options::sygusQueryGenDumpFiles__option_t) const
{
  return d_holder->sygusQueryGenDumpFiles;
}
template <> bool Options::wasSetByUser(options::sygusQueryGenDumpFiles__option_t) const
{
  return d_holder->sygusQueryGenDumpFiles__setByUser__;
}
template <> void Options::set(
    options::sygusQueryGenThresh__option_t,
    const options::sygusQueryGenThresh__option_t::type& x)
{
  d_holder->sygusQueryGenThresh = x;
}
template <> const options::sygusQueryGenThresh__option_t::type& Options::operator[](
    options::sygusQueryGenThresh__option_t) const
{
  return d_holder->sygusQueryGenThresh;
}
template <> bool Options::wasSetByUser(options::sygusQueryGenThresh__option_t) const
{
  return d_holder->sygusQueryGenThresh__setByUser__;
}
template <> void Options::set(
    options::sygusRecFun__option_t,
    const options::sygusRecFun__option_t::type& x)
{
  d_holder->sygusRecFun = x;
}
template <> const options::sygusRecFun__option_t::type& Options::operator[](
    options::sygusRecFun__option_t) const
{
  return d_holder->sygusRecFun;
}
template <> bool Options::wasSetByUser(options::sygusRecFun__option_t) const
{
  return d_holder->sygusRecFun__setByUser__;
}
template <> void Options::set(
    options::sygusRecFunEvalLimit__option_t,
    const options::sygusRecFunEvalLimit__option_t::type& x)
{
  d_holder->sygusRecFunEvalLimit = x;
}
template <> const options::sygusRecFunEvalLimit__option_t::type& Options::operator[](
    options::sygusRecFunEvalLimit__option_t) const
{
  return d_holder->sygusRecFunEvalLimit;
}
template <> bool Options::wasSetByUser(options::sygusRecFunEvalLimit__option_t) const
{
  return d_holder->sygusRecFunEvalLimit__setByUser__;
}
template <> void Options::set(
    options::sygusRepairConst__option_t,
    const options::sygusRepairConst__option_t::type& x)
{
  d_holder->sygusRepairConst = x;
}
template <> const options::sygusRepairConst__option_t::type& Options::operator[](
    options::sygusRepairConst__option_t) const
{
  return d_holder->sygusRepairConst;
}
template <> bool Options::wasSetByUser(options::sygusRepairConst__option_t) const
{
  return d_holder->sygusRepairConst__setByUser__;
}
template <> void Options::set(
    options::sygusRepairConstTimeout__option_t,
    const options::sygusRepairConstTimeout__option_t::type& x)
{
  d_holder->sygusRepairConstTimeout = x;
}
template <> const options::sygusRepairConstTimeout__option_t::type& Options::operator[](
    options::sygusRepairConstTimeout__option_t) const
{
  return d_holder->sygusRepairConstTimeout;
}
template <> bool Options::wasSetByUser(options::sygusRepairConstTimeout__option_t) const
{
  return d_holder->sygusRepairConstTimeout__setByUser__;
}
template <> const options::sygusRew__option_t::type& Options::operator[](
    options::sygusRew__option_t) const
{
  return d_holder->sygusRew;
}
template <> bool Options::wasSetByUser(options::sygusRew__option_t) const
{
  return d_holder->sygusRew__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynth__option_t,
    const options::sygusRewSynth__option_t::type& x)
{
  d_holder->sygusRewSynth = x;
}
template <> const options::sygusRewSynth__option_t::type& Options::operator[](
    options::sygusRewSynth__option_t) const
{
  return d_holder->sygusRewSynth;
}
template <> bool Options::wasSetByUser(options::sygusRewSynth__option_t) const
{
  return d_holder->sygusRewSynth__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthAccel__option_t,
    const options::sygusRewSynthAccel__option_t::type& x)
{
  d_holder->sygusRewSynthAccel = x;
}
template <> const options::sygusRewSynthAccel__option_t::type& Options::operator[](
    options::sygusRewSynthAccel__option_t) const
{
  return d_holder->sygusRewSynthAccel;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthAccel__option_t) const
{
  return d_holder->sygusRewSynthAccel__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthCheck__option_t,
    const options::sygusRewSynthCheck__option_t::type& x)
{
  d_holder->sygusRewSynthCheck = x;
}
template <> const options::sygusRewSynthCheck__option_t::type& Options::operator[](
    options::sygusRewSynthCheck__option_t) const
{
  return d_holder->sygusRewSynthCheck;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthCheck__option_t) const
{
  return d_holder->sygusRewSynthCheck__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthFilterCong__option_t,
    const options::sygusRewSynthFilterCong__option_t::type& x)
{
  d_holder->sygusRewSynthFilterCong = x;
}
template <> const options::sygusRewSynthFilterCong__option_t::type& Options::operator[](
    options::sygusRewSynthFilterCong__option_t) const
{
  return d_holder->sygusRewSynthFilterCong;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterCong__option_t) const
{
  return d_holder->sygusRewSynthFilterCong__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthFilterMatch__option_t,
    const options::sygusRewSynthFilterMatch__option_t::type& x)
{
  d_holder->sygusRewSynthFilterMatch = x;
}
template <> const options::sygusRewSynthFilterMatch__option_t::type& Options::operator[](
    options::sygusRewSynthFilterMatch__option_t) const
{
  return d_holder->sygusRewSynthFilterMatch;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterMatch__option_t) const
{
  return d_holder->sygusRewSynthFilterMatch__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthFilterNonLinear__option_t,
    const options::sygusRewSynthFilterNonLinear__option_t::type& x)
{
  d_holder->sygusRewSynthFilterNonLinear = x;
}
template <> const options::sygusRewSynthFilterNonLinear__option_t::type& Options::operator[](
    options::sygusRewSynthFilterNonLinear__option_t) const
{
  return d_holder->sygusRewSynthFilterNonLinear;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterNonLinear__option_t) const
{
  return d_holder->sygusRewSynthFilterNonLinear__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthFilterOrder__option_t,
    const options::sygusRewSynthFilterOrder__option_t::type& x)
{
  d_holder->sygusRewSynthFilterOrder = x;
}
template <> const options::sygusRewSynthFilterOrder__option_t::type& Options::operator[](
    options::sygusRewSynthFilterOrder__option_t) const
{
  return d_holder->sygusRewSynthFilterOrder;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterOrder__option_t) const
{
  return d_holder->sygusRewSynthFilterOrder__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthInput__option_t,
    const options::sygusRewSynthInput__option_t::type& x)
{
  d_holder->sygusRewSynthInput = x;
}
template <> const options::sygusRewSynthInput__option_t::type& Options::operator[](
    options::sygusRewSynthInput__option_t) const
{
  return d_holder->sygusRewSynthInput;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthInput__option_t) const
{
  return d_holder->sygusRewSynthInput__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthInputNVars__option_t,
    const options::sygusRewSynthInputNVars__option_t::type& x)
{
  d_holder->sygusRewSynthInputNVars = x;
}
template <> const options::sygusRewSynthInputNVars__option_t::type& Options::operator[](
    options::sygusRewSynthInputNVars__option_t) const
{
  return d_holder->sygusRewSynthInputNVars;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthInputNVars__option_t) const
{
  return d_holder->sygusRewSynthInputNVars__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthInputUseBool__option_t,
    const options::sygusRewSynthInputUseBool__option_t::type& x)
{
  d_holder->sygusRewSynthInputUseBool = x;
}
template <> const options::sygusRewSynthInputUseBool__option_t::type& Options::operator[](
    options::sygusRewSynthInputUseBool__option_t) const
{
  return d_holder->sygusRewSynthInputUseBool;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthInputUseBool__option_t) const
{
  return d_holder->sygusRewSynthInputUseBool__setByUser__;
}
template <> void Options::set(
    options::sygusRewSynthRec__option_t,
    const options::sygusRewSynthRec__option_t::type& x)
{
  d_holder->sygusRewSynthRec = x;
}
template <> const options::sygusRewSynthRec__option_t::type& Options::operator[](
    options::sygusRewSynthRec__option_t) const
{
  return d_holder->sygusRewSynthRec;
}
template <> bool Options::wasSetByUser(options::sygusRewSynthRec__option_t) const
{
  return d_holder->sygusRewSynthRec__setByUser__;
}
template <> void Options::set(
    options::sygusRewVerify__option_t,
    const options::sygusRewVerify__option_t::type& x)
{
  d_holder->sygusRewVerify = x;
}
template <> const options::sygusRewVerify__option_t::type& Options::operator[](
    options::sygusRewVerify__option_t) const
{
  return d_holder->sygusRewVerify;
}
template <> bool Options::wasSetByUser(options::sygusRewVerify__option_t) const
{
  return d_holder->sygusRewVerify__setByUser__;
}
template <> void Options::set(
    options::sygusRewVerifyAbort__option_t,
    const options::sygusRewVerifyAbort__option_t::type& x)
{
  d_holder->sygusRewVerifyAbort = x;
}
template <> const options::sygusRewVerifyAbort__option_t::type& Options::operator[](
    options::sygusRewVerifyAbort__option_t) const
{
  return d_holder->sygusRewVerifyAbort;
}
template <> bool Options::wasSetByUser(options::sygusRewVerifyAbort__option_t) const
{
  return d_holder->sygusRewVerifyAbort__setByUser__;
}
template <> void Options::set(
    options::sygusSampleFpUniform__option_t,
    const options::sygusSampleFpUniform__option_t::type& x)
{
  d_holder->sygusSampleFpUniform = x;
}
template <> const options::sygusSampleFpUniform__option_t::type& Options::operator[](
    options::sygusSampleFpUniform__option_t) const
{
  return d_holder->sygusSampleFpUniform;
}
template <> bool Options::wasSetByUser(options::sygusSampleFpUniform__option_t) const
{
  return d_holder->sygusSampleFpUniform__setByUser__;
}
template <> const options::sygusSampleGrammar__option_t::type& Options::operator[](
    options::sygusSampleGrammar__option_t) const
{
  return d_holder->sygusSampleGrammar;
}
template <> bool Options::wasSetByUser(options::sygusSampleGrammar__option_t) const
{
  return d_holder->sygusSampleGrammar__setByUser__;
}
template <> void Options::set(
    options::sygusSamples__option_t,
    const options::sygusSamples__option_t::type& x)
{
  d_holder->sygusSamples = x;
}
template <> const options::sygusSamples__option_t::type& Options::operator[](
    options::sygusSamples__option_t) const
{
  return d_holder->sygusSamples;
}
template <> bool Options::wasSetByUser(options::sygusSamples__option_t) const
{
  return d_holder->sygusSamples__setByUser__;
}
template <> const options::cegqiSingleInvAbort__option_t::type& Options::operator[](
    options::cegqiSingleInvAbort__option_t) const
{
  return d_holder->cegqiSingleInvAbort;
}
template <> bool Options::wasSetByUser(options::cegqiSingleInvAbort__option_t) const
{
  return d_holder->cegqiSingleInvAbort__setByUser__;
}
template <> const options::cegqiSingleInvPartial__option_t::type& Options::operator[](
    options::cegqiSingleInvPartial__option_t) const
{
  return d_holder->cegqiSingleInvPartial;
}
template <> bool Options::wasSetByUser(options::cegqiSingleInvPartial__option_t) const
{
  return d_holder->cegqiSingleInvPartial__setByUser__;
}
template <> const options::cegqiSingleInvReconstructLimit__option_t::type& Options::operator[](
    options::cegqiSingleInvReconstructLimit__option_t) const
{
  return d_holder->cegqiSingleInvReconstructLimit;
}
template <> bool Options::wasSetByUser(options::cegqiSingleInvReconstructLimit__option_t) const
{
  return d_holder->cegqiSingleInvReconstructLimit__setByUser__;
}
template <> void Options::set(
    options::cegqiSingleInvReconstruct__option_t,
    const options::cegqiSingleInvReconstruct__option_t::type& x)
{
  d_holder->cegqiSingleInvReconstruct = x;
}
template <> const options::cegqiSingleInvReconstruct__option_t::type& Options::operator[](
    options::cegqiSingleInvReconstruct__option_t) const
{
  return d_holder->cegqiSingleInvReconstruct;
}
template <> bool Options::wasSetByUser(options::cegqiSingleInvReconstruct__option_t) const
{
  return d_holder->cegqiSingleInvReconstruct__setByUser__;
}
template <> const options::cegqiSingleInvReconstructConst__option_t::type& Options::operator[](
    options::cegqiSingleInvReconstructConst__option_t) const
{
  return d_holder->cegqiSingleInvReconstructConst;
}
template <> bool Options::wasSetByUser(options::cegqiSingleInvReconstructConst__option_t) const
{
  return d_holder->cegqiSingleInvReconstructConst__setByUser__;
}
template <> void Options::set(
    options::cegqiSingleInvMode__option_t,
    const options::cegqiSingleInvMode__option_t::type& x)
{
  d_holder->cegqiSingleInvMode = x;
}
template <> const options::cegqiSingleInvMode__option_t::type& Options::operator[](
    options::cegqiSingleInvMode__option_t) const
{
  return d_holder->cegqiSingleInvMode;
}
template <> bool Options::wasSetByUser(options::cegqiSingleInvMode__option_t) const
{
  return d_holder->cegqiSingleInvMode__setByUser__;
}
template <> void Options::set(
    options::sygusStream__option_t,
    const options::sygusStream__option_t::type& x)
{
  d_holder->sygusStream = x;
}
template <> const options::sygusStream__option_t::type& Options::operator[](
    options::sygusStream__option_t) const
{
  return d_holder->sygusStream;
}
template <> bool Options::wasSetByUser(options::sygusStream__option_t) const
{
  return d_holder->sygusStream__setByUser__;
}
template <> const options::sygusTemplEmbedGrammar__option_t::type& Options::operator[](
    options::sygusTemplEmbedGrammar__option_t) const
{
  return d_holder->sygusTemplEmbedGrammar;
}
template <> bool Options::wasSetByUser(options::sygusTemplEmbedGrammar__option_t) const
{
  return d_holder->sygusTemplEmbedGrammar__setByUser__;
}
template <> void Options::set(
    options::sygusUnifCondIndNoRepeatSol__option_t,
    const options::sygusUnifCondIndNoRepeatSol__option_t::type& x)
{
  d_holder->sygusUnifCondIndNoRepeatSol = x;
}
template <> const options::sygusUnifCondIndNoRepeatSol__option_t::type& Options::operator[](
    options::sygusUnifCondIndNoRepeatSol__option_t) const
{
  return d_holder->sygusUnifCondIndNoRepeatSol;
}
template <> bool Options::wasSetByUser(options::sygusUnifCondIndNoRepeatSol__option_t) const
{
  return d_holder->sygusUnifCondIndNoRepeatSol__setByUser__;
}
template <> void Options::set(
    options::sygusUnifPi__option_t,
    const options::sygusUnifPi__option_t::type& x)
{
  d_holder->sygusUnifPi = x;
}
template <> const options::sygusUnifPi__option_t::type& Options::operator[](
    options::sygusUnifPi__option_t) const
{
  return d_holder->sygusUnifPi;
}
template <> bool Options::wasSetByUser(options::sygusUnifPi__option_t) const
{
  return d_holder->sygusUnifPi__setByUser__;
}
template <> void Options::set(
    options::sygusUnifShuffleCond__option_t,
    const options::sygusUnifShuffleCond__option_t::type& x)
{
  d_holder->sygusUnifShuffleCond = x;
}
template <> const options::sygusUnifShuffleCond__option_t::type& Options::operator[](
    options::sygusUnifShuffleCond__option_t) const
{
  return d_holder->sygusUnifShuffleCond;
}
template <> bool Options::wasSetByUser(options::sygusUnifShuffleCond__option_t) const
{
  return d_holder->sygusUnifShuffleCond__setByUser__;
}
template <> void Options::set(
    options::sygusVerifySubcall__option_t,
    const options::sygusVerifySubcall__option_t::type& x)
{
  d_holder->sygusVerifySubcall = x;
}
template <> const options::sygusVerifySubcall__option_t::type& Options::operator[](
    options::sygusVerifySubcall__option_t) const
{
  return d_holder->sygusVerifySubcall;
}
template <> bool Options::wasSetByUser(options::sygusVerifySubcall__option_t) const
{
  return d_holder->sygusVerifySubcall__setByUser__;
}
template <> void Options::set(
    options::termDbMode__option_t,
    const options::termDbMode__option_t::type& x)
{
  d_holder->termDbMode = x;
}
template <> const options::termDbMode__option_t::type& Options::operator[](
    options::termDbMode__option_t) const
{
  return d_holder->termDbMode;
}
template <> bool Options::wasSetByUser(options::termDbMode__option_t) const
{
  return d_holder->termDbMode__setByUser__;
}
template <> void Options::set(
    options::trackInstLemmas__option_t,
    const options::trackInstLemmas__option_t::type& x)
{
  d_holder->trackInstLemmas = x;
}
template <> const options::trackInstLemmas__option_t::type& Options::operator[](
    options::trackInstLemmas__option_t) const
{
  return d_holder->trackInstLemmas;
}
template <> bool Options::wasSetByUser(options::trackInstLemmas__option_t) const
{
  return d_holder->trackInstLemmas__setByUser__;
}
template <> void Options::set(
    options::triggerActiveSelMode__option_t,
    const options::triggerActiveSelMode__option_t::type& x)
{
  d_holder->triggerActiveSelMode = x;
}
template <> const options::triggerActiveSelMode__option_t::type& Options::operator[](
    options::triggerActiveSelMode__option_t) const
{
  return d_holder->triggerActiveSelMode;
}
template <> bool Options::wasSetByUser(options::triggerActiveSelMode__option_t) const
{
  return d_holder->triggerActiveSelMode__setByUser__;
}
template <> void Options::set(
    options::triggerSelMode__option_t,
    const options::triggerSelMode__option_t::type& x)
{
  d_holder->triggerSelMode = x;
}
template <> const options::triggerSelMode__option_t::type& Options::operator[](
    options::triggerSelMode__option_t) const
{
  return d_holder->triggerSelMode;
}
template <> bool Options::wasSetByUser(options::triggerSelMode__option_t) const
{
  return d_holder->triggerSelMode__setByUser__;
}
template <> void Options::set(
    options::userPatternsQuant__option_t,
    const options::userPatternsQuant__option_t::type& x)
{
  d_holder->userPatternsQuant = x;
}
template <> const options::userPatternsQuant__option_t::type& Options::operator[](
    options::userPatternsQuant__option_t) const
{
  return d_holder->userPatternsQuant;
}
template <> bool Options::wasSetByUser(options::userPatternsQuant__option_t) const
{
  return d_holder->userPatternsQuant__setByUser__;
}
template <> const options::varElimQuant__option_t::type& Options::operator[](
    options::varElimQuant__option_t) const
{
  return d_holder->varElimQuant;
}
template <> bool Options::wasSetByUser(options::varElimQuant__option_t) const
{
  return d_holder->varElimQuant__setByUser__;
}
template <> const options::varIneqElimQuant__option_t::type& Options::operator[](
    options::varIneqElimQuant__option_t) const
{
  return d_holder->varIneqElimQuant;
}
template <> bool Options::wasSetByUser(options::varIneqElimQuant__option_t) const
{
  return d_holder->varIneqElimQuant__setByUser__;
}


namespace options {

struct aggressiveMiniscopeQuant__option_t aggressiveMiniscopeQuant;
struct cegisSample__option_t cegisSample;
struct cegqi__option_t cegqi;
struct cegqiAll__option_t cegqiAll;
struct cegqiBv__option_t cegqiBv;
struct cegqiBvConcInv__option_t cegqiBvConcInv;
struct cegqiBvIneqMode__option_t cegqiBvIneqMode;
struct cegqiBvInterleaveValue__option_t cegqiBvInterleaveValue;
struct cegqiBvLinearize__option_t cegqiBvLinearize;
struct cegqiBvRmExtract__option_t cegqiBvRmExtract;
struct cegqiBvSolveNl__option_t cegqiBvSolveNl;
struct cegqiFullEffort__option_t cegqiFullEffort;
struct cegqiInnermost__option_t cegqiInnermost;
struct cegqiMidpoint__option_t cegqiMidpoint;
struct cegqiMinBounds__option_t cegqiMinBounds;
struct cegqiModel__option_t cegqiModel;
struct cegqiMultiInst__option_t cegqiMultiInst;
struct cegqiNestedQE__option_t cegqiNestedQE;
struct cegqiNopt__option_t cegqiNopt;
struct cegqiPreRegInst__option_t cegqiPreRegInst;
struct cegqiRepeatLit__option_t cegqiRepeatLit;
struct cegqiRoundUpLowerLia__option_t cegqiRoundUpLowerLia;
struct cegqiSat__option_t cegqiSat;
struct cegqiUseInfInt__option_t cegqiUseInfInt;
struct cegqiUseInfReal__option_t cegqiUseInfReal;
struct condVarSplitQuantAgg__option_t condVarSplitQuantAgg;
struct condVarSplitQuant__option_t condVarSplitQuant;
struct conjectureFilterActiveTerms__option_t conjectureFilterActiveTerms;
struct conjectureFilterCanonical__option_t conjectureFilterCanonical;
struct conjectureFilterModel__option_t conjectureFilterModel;
struct conjectureGen__option_t conjectureGen;
struct conjectureGenGtEnum__option_t conjectureGenGtEnum;
struct conjectureGenMaxDepth__option_t conjectureGenMaxDepth;
struct conjectureGenPerRound__option_t conjectureGenPerRound;
struct conjectureUeeIntro__option_t conjectureUeeIntro;
struct conjectureNoFilter__option_t conjectureNoFilter;
struct dtStcInduction__option_t dtStcInduction;
struct dtVarExpandQuant__option_t dtVarExpandQuant;
struct eMatching__option_t eMatching;
struct elimExtArithQuant__option_t elimExtArithQuant;
struct elimTautQuant__option_t elimTautQuant;
struct extRewriteQuant__option_t extRewriteQuant;
struct finiteModelFind__option_t finiteModelFind;
struct fmfBound__option_t fmfBound;
struct fmfBoundInt__option_t fmfBoundInt;
struct fmfBoundLazy__option_t fmfBoundLazy;
struct fmfFmcSimple__option_t fmfFmcSimple;
struct fmfFreshDistConst__option_t fmfFreshDistConst;
struct fmfFunWellDefined__option_t fmfFunWellDefined;
struct fmfFunWellDefinedRelevant__option_t fmfFunWellDefinedRelevant;
struct fmfInstEngine__option_t fmfInstEngine;
struct fmfTypeCompletionThresh__option_t fmfTypeCompletionThresh;
struct fullSaturateInterleave__option_t fullSaturateInterleave;
struct fullSaturateStratify__option_t fullSaturateStratify;
struct fullSaturateQuant__option_t fullSaturateQuant;
struct fullSaturateLimit__option_t fullSaturateLimit;
struct fullSaturateQuantRd__option_t fullSaturateQuantRd;
struct globalNegate__option_t globalNegate;
struct hoElim__option_t hoElim;
struct hoElimStoreAx__option_t hoElimStoreAx;
struct hoMatching__option_t hoMatching;
struct hoMatchingVarArgPriority__option_t hoMatchingVarArgPriority;
struct hoMergeTermDb__option_t hoMergeTermDb;
struct incrementTriggers__option_t incrementTriggers;
struct instLevelInputOnly__option_t instLevelInputOnly;
struct instMaxLevel__option_t instMaxLevel;
struct instNoEntail__option_t instNoEntail;
struct instNoModelTrue__option_t instNoModelTrue;
struct instWhenPhase__option_t instWhenPhase;
struct instWhenStrictInterleave__option_t instWhenStrictInterleave;
struct instWhenTcFirst__option_t instWhenTcFirst;
struct instWhenMode__option_t instWhenMode;
struct intWfInduction__option_t intWfInduction;
struct iteDtTesterSplitQuant__option_t iteDtTesterSplitQuant;
struct iteLiftQuant__option_t iteLiftQuant;
struct literalMatchMode__option_t literalMatchMode;
struct lteRestrictInstClosure__option_t lteRestrictInstClosure;
struct macrosQuant__option_t macrosQuant;
struct macrosQuantMode__option_t macrosQuantMode;
struct mbqiInterleave__option_t mbqiInterleave;
struct fmfOneInstPerRound__option_t fmfOneInstPerRound;
struct mbqiMode__option_t mbqiMode;
struct miniscopeQuant__option_t miniscopeQuant;
struct miniscopeQuantFreeVar__option_t miniscopeQuantFreeVar;
struct multiTriggerCache__option_t multiTriggerCache;
struct multiTriggerLinear__option_t multiTriggerLinear;
struct multiTriggerPriority__option_t multiTriggerPriority;
struct multiTriggerWhenSingle__option_t multiTriggerWhenSingle;
struct partialTriggers__option_t partialTriggers;
struct preSkolemQuant__option_t preSkolemQuant;
struct preSkolemQuantAgg__option_t preSkolemQuantAgg;
struct preSkolemQuantNested__option_t preSkolemQuantNested;
struct prenexQuantUser__option_t prenexQuantUser;
struct prenexQuant__option_t prenexQuant;
struct pureThTriggers__option_t pureThTriggers;
struct purifyDtTriggers__option_t purifyDtTriggers;
struct purifyTriggers__option_t purifyTriggers;
struct qcfAllConflict__option_t qcfAllConflict;
struct qcfEagerCheckRd__option_t qcfEagerCheckRd;
struct qcfEagerTest__option_t qcfEagerTest;
struct qcfNestedConflict__option_t qcfNestedConflict;
struct qcfSkipRd__option_t qcfSkipRd;
struct qcfTConstraint__option_t qcfTConstraint;
struct qcfVoExp__option_t qcfVoExp;
struct quantAlphaEquiv__option_t quantAlphaEquiv;
struct quantAntiSkolem__option_t quantAntiSkolem;
struct quantConflictFind__option_t quantConflictFind;
struct qcfMode__option_t qcfMode;
struct qcfWhenMode__option_t qcfWhenMode;
struct quantDynamicSplit__option_t quantDynamicSplit;
struct quantEpr__option_t quantEpr;
struct quantEprMatching__option_t quantEprMatching;
struct quantFunWellDefined__option_t quantFunWellDefined;
struct quantInduction__option_t quantInduction;
struct quantModelEe__option_t quantModelEe;
struct quantRepMode__option_t quantRepMode;
struct quantSplit__option_t quantSplit;
struct registerQuantBodyTerms__option_t registerQuantBodyTerms;
struct relationalTriggers__option_t relationalTriggers;
struct relevantTriggers__option_t relevantTriggers;
struct strictTriggers__option_t strictTriggers;
struct sygus__option_t sygus;
struct sygusActiveGenEnumConsts__option_t sygusActiveGenEnumConsts;
struct sygusActiveGenMode__option_t sygusActiveGenMode;
struct sygusAddConstGrammar__option_t sygusAddConstGrammar;
struct sygusArgRelevant__option_t sygusArgRelevant;
struct sygusInvAutoUnfold__option_t sygusInvAutoUnfold;
struct sygusBoolIteReturnConst__option_t sygusBoolIteReturnConst;
struct sygusCoreConnective__option_t sygusCoreConnective;
struct sygusConstRepairAbort__option_t sygusConstRepairAbort;
struct sygusEvalOpt__option_t sygusEvalOpt;
struct sygusEvalUnfold__option_t sygusEvalUnfold;
struct sygusEvalUnfoldBool__option_t sygusEvalUnfoldBool;
struct sygusExprMinerCheckTimeout__option_t sygusExprMinerCheckTimeout;
struct sygusExprMinerCheckUseExport__option_t sygusExprMinerCheckUseExport;
struct sygusExtRew__option_t sygusExtRew;
struct sygusFilterSolRevSubsume__option_t sygusFilterSolRevSubsume;
struct sygusFilterSolMode__option_t sygusFilterSolMode;
struct sygusGrammarConsMode__option_t sygusGrammarConsMode;
struct sygusGrammarNorm__option_t sygusGrammarNorm;
struct sygusInference__option_t sygusInference;
struct sygusInst__option_t sygusInst;
struct sygusInvTemplWhenSyntax__option_t sygusInvTemplWhenSyntax;
struct sygusInvTemplMode__option_t sygusInvTemplMode;
struct sygusMinGrammar__option_t sygusMinGrammar;
struct sygusUnifPbe__option_t sygusUnifPbe;
struct sygusPbeMultiFair__option_t sygusPbeMultiFair;
struct sygusPbeMultiFairDiff__option_t sygusPbeMultiFairDiff;
struct sygusQePreproc__option_t sygusQePreproc;
struct sygusQueryGen__option_t sygusQueryGen;
struct sygusQueryGenCheck__option_t sygusQueryGenCheck;
struct sygusQueryGenDumpFiles__option_t sygusQueryGenDumpFiles;
struct sygusQueryGenThresh__option_t sygusQueryGenThresh;
struct sygusRecFun__option_t sygusRecFun;
struct sygusRecFunEvalLimit__option_t sygusRecFunEvalLimit;
struct sygusRepairConst__option_t sygusRepairConst;
struct sygusRepairConstTimeout__option_t sygusRepairConstTimeout;
struct sygusRew__option_t sygusRew;
struct sygusRewSynth__option_t sygusRewSynth;
struct sygusRewSynthAccel__option_t sygusRewSynthAccel;
struct sygusRewSynthCheck__option_t sygusRewSynthCheck;
struct sygusRewSynthFilterCong__option_t sygusRewSynthFilterCong;
struct sygusRewSynthFilterMatch__option_t sygusRewSynthFilterMatch;
struct sygusRewSynthFilterNonLinear__option_t sygusRewSynthFilterNonLinear;
struct sygusRewSynthFilterOrder__option_t sygusRewSynthFilterOrder;
struct sygusRewSynthInput__option_t sygusRewSynthInput;
struct sygusRewSynthInputNVars__option_t sygusRewSynthInputNVars;
struct sygusRewSynthInputUseBool__option_t sygusRewSynthInputUseBool;
struct sygusRewSynthRec__option_t sygusRewSynthRec;
struct sygusRewVerify__option_t sygusRewVerify;
struct sygusRewVerifyAbort__option_t sygusRewVerifyAbort;
struct sygusSampleFpUniform__option_t sygusSampleFpUniform;
struct sygusSampleGrammar__option_t sygusSampleGrammar;
struct sygusSamples__option_t sygusSamples;
struct cegqiSingleInvAbort__option_t cegqiSingleInvAbort;
struct cegqiSingleInvPartial__option_t cegqiSingleInvPartial;
struct cegqiSingleInvReconstructLimit__option_t cegqiSingleInvReconstructLimit;
struct cegqiSingleInvReconstruct__option_t cegqiSingleInvReconstruct;
struct cegqiSingleInvReconstructConst__option_t cegqiSingleInvReconstructConst;
struct cegqiSingleInvMode__option_t cegqiSingleInvMode;
struct sygusStream__option_t sygusStream;
struct sygusTemplEmbedGrammar__option_t sygusTemplEmbedGrammar;
struct sygusUnifCondIndNoRepeatSol__option_t sygusUnifCondIndNoRepeatSol;
struct sygusUnifPi__option_t sygusUnifPi;
struct sygusUnifShuffleCond__option_t sygusUnifShuffleCond;
struct sygusVerifySubcall__option_t sygusVerifySubcall;
struct termDbMode__option_t termDbMode;
struct trackInstLemmas__option_t trackInstLemmas;
struct triggerActiveSelMode__option_t triggerActiveSelMode;
struct triggerSelMode__option_t triggerSelMode;
struct userPatternsQuant__option_t userPatternsQuant;
struct varElimQuant__option_t varElimQuant;
struct varIneqElimQuant__option_t varIneqElimQuant;


std::ostream&
operator<<(std::ostream& os, CegisSampleMode mode)
{
  os << "CegisSampleMode::";
  switch(mode) {
    case CegisSampleMode::NONE:
      os << "NONE";
      break;
    case CegisSampleMode::USE:
      os << "USE";
      break;
    case CegisSampleMode::TRUST:
      os << "TRUST";
      break;
    default:
        Unreachable();
  }
  return os;
}

CegisSampleMode
stringToCegisSampleMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return CegisSampleMode::NONE;
  }
  else if (optarg == "use")
  {
    return CegisSampleMode::USE;
  }
  else if (optarg == "trust")
  {
    return CegisSampleMode::TRUST;
  }
  else if (optarg == "help")
  {
    puts("Modes for sampling with counterexample-guided inductive synthesis (CEGIS).\n"
         "Available modes for --cegis-sample are:\n"
         "+ none (default)\n"
         "  Do not use sampling with CEGIS.\n"
         "+ use\n"
         "  Use sampling to accelerate CEGIS. This will rule out solutions for a\n"
         "  conjecture when they are not satisfied by a sample point.\n"
         "+ trust\n"
         "  Trust that when a solution for a conjecture is always true under sampling,\n"
         "  then it is indeed a solution. Note this option may print out spurious\n"
         "  solutions for synthesis conjectures.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --cegis-sample: `") +
                          optarg + "'.  Try --cegis-sample=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, CegqiBvIneqMode mode)
{
  os << "CegqiBvIneqMode::";
  switch(mode) {
    case CegqiBvIneqMode::EQ_SLACK:
      os << "EQ_SLACK";
      break;
    case CegqiBvIneqMode::EQ_BOUNDARY:
      os << "EQ_BOUNDARY";
      break;
    case CegqiBvIneqMode::KEEP:
      os << "KEEP";
      break;
    default:
        Unreachable();
  }
  return os;
}

CegqiBvIneqMode
stringToCegqiBvIneqMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "eq-slack")
  {
    return CegqiBvIneqMode::EQ_SLACK;
  }
  else if (optarg == "eq-boundary")
  {
    return CegqiBvIneqMode::EQ_BOUNDARY;
  }
  else if (optarg == "keep")
  {
    return CegqiBvIneqMode::KEEP;
  }
  else if (optarg == "help")
  {
    puts("Modes for handling bit-vector inequalities in counterexample-guided\n"
         "instantiation.\n"
         "Available modes for --cegqi-bv-ineq are:\n"
         "+ eq-slack\n"
         "  Solve for the inequality using the slack value in the model, e.g., t > s\n"
         "  becomes t = s + ( t-s )^M.\n"
         "+ eq-boundary (default)\n"
         "  Solve for the boundary point of the inequality, e.g., t > s becomes t = s+1.\n"
         "+ keep\n"
         "  Solve for the inequality directly using side conditions for invertibility.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --cegqi-bv-ineq: `") +
                          optarg + "'.  Try --cegqi-bv-ineq=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, InstWhenMode mode)
{
  os << "InstWhenMode::";
  switch(mode) {
    case InstWhenMode::PRE_FULL:
      os << "PRE_FULL";
      break;
    case InstWhenMode::FULL:
      os << "FULL";
      break;
    case InstWhenMode::FULL_DELAY:
      os << "FULL_DELAY";
      break;
    case InstWhenMode::FULL_LAST_CALL:
      os << "FULL_LAST_CALL";
      break;
    case InstWhenMode::FULL_DELAY_LAST_CALL:
      os << "FULL_DELAY_LAST_CALL";
      break;
    case InstWhenMode::LAST_CALL:
      os << "LAST_CALL";
      break;
    default:
        Unreachable();
  }
  return os;
}

InstWhenMode
stringToInstWhenMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "pre-full")
  {
    return InstWhenMode::PRE_FULL;
  }
  else if (optarg == "full")
  {
    return InstWhenMode::FULL;
  }
  else if (optarg == "full-delay")
  {
    return InstWhenMode::FULL_DELAY;
  }
  else if (optarg == "full-last-call")
  {
    return InstWhenMode::FULL_LAST_CALL;
  }
  else if (optarg == "full-delay-last-call")
  {
    return InstWhenMode::FULL_DELAY_LAST_CALL;
  }
  else if (optarg == "last-call")
  {
    return InstWhenMode::LAST_CALL;
  }
  else if (optarg == "help")
  {
    puts("Instantiation modes.\n"
         "Available modes for --inst-when are:\n"
         "+ pre-full\n"
         "  Run instantiation round before full effort (possibly at standard effort).\n"
         "+ full\n"
         "  Run instantiation round at full effort, before theory combination.\n"
         "+ full-delay\n"
         "  Run instantiation round at full effort, before theory combination, after all\n"
         "  other theories have finished.\n"
         "+ full-last-call (default)\n"
         "  Alternate running instantiation rounds at full effort and last call.  In other\n"
         "  words, interleave instantiation and theory combination.\n"
         "+ full-delay-last-call\n"
         "  Alternate running instantiation rounds at full effort after all other theories\n"
         "  have finished, and last call.\n"
         "+ last-call\n"
         "  Run instantiation at last call effort, after theory combination and and\n"
         "  theories report sat.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --inst-when: `") +
                          optarg + "'.  Try --inst-when=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, IteLiftQuantMode mode)
{
  os << "IteLiftQuantMode::";
  switch(mode) {
    case IteLiftQuantMode::NONE:
      os << "NONE";
      break;
    case IteLiftQuantMode::SIMPLE:
      os << "SIMPLE";
      break;
    case IteLiftQuantMode::ALL:
      os << "ALL";
      break;
    default:
        Unreachable();
  }
  return os;
}

IteLiftQuantMode
stringToIteLiftQuantMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return IteLiftQuantMode::NONE;
  }
  else if (optarg == "simple")
  {
    return IteLiftQuantMode::SIMPLE;
  }
  else if (optarg == "all")
  {
    return IteLiftQuantMode::ALL;
  }
  else if (optarg == "help")
  {
    puts("ITE lifting modes for quantified formulas.\n"
         "Available modes for --ite-lift-quant are:\n"
         "+ none\n"
         "  Do not lift if-then-else in quantified formulas.\n"
         "+ simple (default)\n"
         "  Lift if-then-else in quantified formulas if results in smaller term size.\n"
         "+ all\n"
         "  Lift if-then-else in quantified formulas.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --ite-lift-quant: `") +
                          optarg + "'.  Try --ite-lift-quant=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, LiteralMatchMode mode)
{
  os << "LiteralMatchMode::";
  switch(mode) {
    case LiteralMatchMode::NONE:
      os << "NONE";
      break;
    case LiteralMatchMode::USE:
      os << "USE";
      break;
    case LiteralMatchMode::AGG_PREDICATE:
      os << "AGG_PREDICATE";
      break;
    case LiteralMatchMode::AGG:
      os << "AGG";
      break;
    default:
        Unreachable();
  }
  return os;
}

LiteralMatchMode
stringToLiteralMatchMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return LiteralMatchMode::NONE;
  }
  else if (optarg == "use")
  {
    return LiteralMatchMode::USE;
  }
  else if (optarg == "agg-predicate")
  {
    return LiteralMatchMode::AGG_PREDICATE;
  }
  else if (optarg == "agg")
  {
    return LiteralMatchMode::AGG;
  }
  else if (optarg == "help")
  {
    puts("Literal match modes.\n"
         "Available modes for --literal-matching are:\n"
         "+ none\n"
         "  Do not use literal matching.\n"
         "+ use (default)\n"
         "  Consider phase requirements of triggers conservatively. For example, the\n"
         "  trigger P( x ) in forall( x ). ( P( x ) V ~Q( x ) ) will not be matched with\n"
         "  terms in the equivalence class of true, and likewise Q( x ) will not be\n"
         "  matched terms in the equivalence class of false. Extends to equality.\n"
         "+ agg-predicate\n"
         "  Consider phase requirements aggressively for predicates. In the above example,\n"
         "  only match P( x ) with terms that are in the equivalence class of false.\n"
         "+ agg\n"
         "  Consider the phase requirements aggressively for all triggers.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --literal-matching: `") +
                          optarg + "'.  Try --literal-matching=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, MacrosQuantMode mode)
{
  os << "MacrosQuantMode::";
  switch(mode) {
    case MacrosQuantMode::ALL:
      os << "ALL";
      break;
    case MacrosQuantMode::GROUND:
      os << "GROUND";
      break;
    case MacrosQuantMode::GROUND_UF:
      os << "GROUND_UF";
      break;
    default:
        Unreachable();
  }
  return os;
}

MacrosQuantMode
stringToMacrosQuantMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "all")
  {
    return MacrosQuantMode::ALL;
  }
  else if (optarg == "ground")
  {
    return MacrosQuantMode::GROUND;
  }
  else if (optarg == "ground-uf")
  {
    return MacrosQuantMode::GROUND_UF;
  }
  else if (optarg == "help")
  {
    puts("Modes for quantifiers macro expansion.\n"
         "Available modes for --macros-quant-mode are:\n"
         "+ all\n"
         "  Infer definitions for functions, including those containing quantified\n"
         "  formulas.\n"
         "+ ground\n"
         "  Only infer ground definitions for functions.\n"
         "+ ground-uf (default)\n"
         "  Only infer ground definitions for functions that result in triggers for all\n"
         "  free variables.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --macros-quant-mode: `") +
                          optarg + "'.  Try --macros-quant-mode=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, MbqiMode mode)
{
  os << "MbqiMode::";
  switch(mode) {
    case MbqiMode::NONE:
      os << "NONE";
      break;
    case MbqiMode::FMC:
      os << "FMC";
      break;
    case MbqiMode::TRUST:
      os << "TRUST";
      break;
    default:
        Unreachable();
  }
  return os;
}

MbqiMode
stringToMbqiMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return MbqiMode::NONE;
  }
  else if (optarg == "fmc")
  {
    return MbqiMode::FMC;
  }
  else if (optarg == "trust")
  {
    return MbqiMode::TRUST;
  }
  else if (optarg == "help")
  {
    puts("Model-based quantifier instantiation modes.\n"
         "Available modes for --mbqi are:\n"
         "+ none\n"
         "  Disable model-based quantifier instantiation.\n"
         "+ fmc (default)\n"
         "  Use algorithm from Section 5.4.2 of thesis Finite Model Finding in\n"
         "  Satisfiability Modulo Theories.\n"
         "+ trust\n"
         "  Do not instantiate quantified formulas (incomplete technique).\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --mbqi: `") +
                          optarg + "'.  Try --mbqi=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, PrenexQuantMode mode)
{
  os << "PrenexQuantMode::";
  switch(mode) {
    case PrenexQuantMode::NONE:
      os << "NONE";
      break;
    case PrenexQuantMode::SIMPLE:
      os << "SIMPLE";
      break;
    case PrenexQuantMode::NORMAL:
      os << "NORMAL";
      break;
    default:
        Unreachable();
  }
  return os;
}

PrenexQuantMode
stringToPrenexQuantMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return PrenexQuantMode::NONE;
  }
  else if (optarg == "simple")
  {
    return PrenexQuantMode::SIMPLE;
  }
  else if (optarg == "norm")
  {
    return PrenexQuantMode::NORMAL;
  }
  else if (optarg == "help")
  {
    puts("Prenex quantifiers modes.\n"
         "Available modes for --prenex-quant are:\n"
         "+ none\n"
         "  Do no prenex nested quantifiers.\n"
         "+ simple (default)\n"
         "  Do simple prenexing of same sign quantifiers.\n"
         "+ norm\n"
         "  Prenex to prenex normal form.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --prenex-quant: `") +
                          optarg + "'.  Try --prenex-quant=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, QcfMode mode)
{
  os << "QcfMode::";
  switch(mode) {
    case QcfMode::CONFLICT_ONLY:
      os << "CONFLICT_ONLY";
      break;
    case QcfMode::PROP_EQ:
      os << "PROP_EQ";
      break;
    case QcfMode::PARTIAL:
      os << "PARTIAL";
      break;
    default:
        Unreachable();
  }
  return os;
}

QcfMode
stringToQcfMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "conflict")
  {
    return QcfMode::CONFLICT_ONLY;
  }
  else if (optarg == "prop-eq")
  {
    return QcfMode::PROP_EQ;
  }
  else if (optarg == "partial")
  {
    return QcfMode::PARTIAL;
  }
  else if (optarg == "help")
  {
    puts("Quantifier conflict find modes.\n"
         "Available modes for --quant-cf-mode are:\n"
         "+ conflict\n"
         "  Apply QCF algorithm to find conflicts only.\n"
         "+ prop-eq (default)\n"
         "  Apply QCF algorithm to propagate equalities as well as conflicts.\n"
         "+ partial\n"
         "  Use QCF for conflicts, propagations and heuristic instantiations.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --quant-cf-mode: `") +
                          optarg + "'.  Try --quant-cf-mode=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, QcfWhenMode mode)
{
  os << "QcfWhenMode::";
  switch(mode) {
    case QcfWhenMode::DEFAULT:
      os << "DEFAULT";
      break;
    case QcfWhenMode::LAST_CALL:
      os << "LAST_CALL";
      break;
    case QcfWhenMode::STD:
      os << "STD";
      break;
    case QcfWhenMode::STD_H:
      os << "STD_H";
      break;
    default:
        Unreachable();
  }
  return os;
}

QcfWhenMode
stringToQcfWhenMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "default")
  {
    return QcfWhenMode::DEFAULT;
  }
  else if (optarg == "last-call")
  {
    return QcfWhenMode::LAST_CALL;
  }
  else if (optarg == "std")
  {
    return QcfWhenMode::STD;
  }
  else if (optarg == "std-h")
  {
    return QcfWhenMode::STD_H;
  }
  else if (optarg == "help")
  {
    puts("Quantifier conflict find modes.\n"
         "Available modes for --quant-cf-when are:\n"
         "+ default\n"
         "  Default, apply conflict finding at full effort.\n"
         "+ last-call\n"
         "  Apply conflict finding at last call, after theory combination and and all\n"
         "  theories report sat.\n"
         "+ std\n"
         "  Apply conflict finding at standard effort.\n"
         "+ std-h\n"
         "  Apply conflict finding at standard effort when heuristic says to.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --quant-cf-when: `") +
                          optarg + "'.  Try --quant-cf-when=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, QuantDSplitMode mode)
{
  os << "QuantDSplitMode::";
  switch(mode) {
    case QuantDSplitMode::NONE:
      os << "NONE";
      break;
    case QuantDSplitMode::DEFAULT:
      os << "DEFAULT";
      break;
    case QuantDSplitMode::AGG:
      os << "AGG";
      break;
    default:
        Unreachable();
  }
  return os;
}

QuantDSplitMode
stringToQuantDSplitMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return QuantDSplitMode::NONE;
  }
  else if (optarg == "default")
  {
    return QuantDSplitMode::DEFAULT;
  }
  else if (optarg == "agg")
  {
    return QuantDSplitMode::AGG;
  }
  else if (optarg == "help")
  {
    puts("Modes for quantifiers splitting.\n"
         "Available modes for --quant-dsplit-mode are:\n"
         "+ none\n"
         "  Never split quantified formulas.\n"
         "+ default\n"
         "  Split quantified formulas over some finite datatypes when finite model finding\n"
         "  is enabled.\n"
         "+ agg\n"
         "  Aggressively split quantified formulas.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --quant-dsplit-mode: `") +
                          optarg + "'.  Try --quant-dsplit-mode=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, QuantRepMode mode)
{
  os << "QuantRepMode::";
  switch(mode) {
    case QuantRepMode::EE:
      os << "EE";
      break;
    case QuantRepMode::FIRST:
      os << "FIRST";
      break;
    case QuantRepMode::DEPTH:
      os << "DEPTH";
      break;
    default:
        Unreachable();
  }
  return os;
}

QuantRepMode
stringToQuantRepMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "ee")
  {
    return QuantRepMode::EE;
  }
  else if (optarg == "first")
  {
    return QuantRepMode::FIRST;
  }
  else if (optarg == "depth")
  {
    return QuantRepMode::DEPTH;
  }
  else if (optarg == "help")
  {
    puts("Modes for quantifiers representative selection.\n"
         "Available modes for --quant-rep-mode are:\n"
         "+ ee\n"
         "  Let equality engine choose representatives.\n"
         "+ first (default)\n"
         "  Choose terms that appear first.\n"
         "+ depth\n"
         "  Choose terms that are of minimal depth.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --quant-rep-mode: `") +
                          optarg + "'.  Try --quant-rep-mode=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, SygusActiveGenMode mode)
{
  os << "SygusActiveGenMode::";
  switch(mode) {
    case SygusActiveGenMode::NONE:
      os << "NONE";
      break;
    case SygusActiveGenMode::ENUM_BASIC:
      os << "ENUM_BASIC";
      break;
    case SygusActiveGenMode::ENUM:
      os << "ENUM";
      break;
    case SygusActiveGenMode::VAR_AGNOSTIC:
      os << "VAR_AGNOSTIC";
      break;
    case SygusActiveGenMode::AUTO:
      os << "AUTO";
      break;
    default:
        Unreachable();
  }
  return os;
}

SygusActiveGenMode
stringToSygusActiveGenMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return SygusActiveGenMode::NONE;
  }
  else if (optarg == "basic")
  {
    return SygusActiveGenMode::ENUM_BASIC;
  }
  else if (optarg == "enum")
  {
    return SygusActiveGenMode::ENUM;
  }
  else if (optarg == "var-agnostic")
  {
    return SygusActiveGenMode::VAR_AGNOSTIC;
  }
  else if (optarg == "auto")
  {
    return SygusActiveGenMode::AUTO;
  }
  else if (optarg == "help")
  {
    puts("Modes for actively-generated sygus enumerators.\n"
         "Available modes for --sygus-active-gen are:\n"
         "+ none\n"
         "  Do not use actively-generated sygus enumerators.\n"
         "+ basic\n"
         "  Use basic type enumerator for actively-generated sygus enumerators.\n"
         "+ enum\n"
         "  Use optimized enumerator for actively-generated sygus enumerators.\n"
         "+ var-agnostic\n"
         "  Use sygus solver to enumerate terms that are agnostic to variables.\n"
         "+ auto (default)\n"
         "  Internally decide the best policy for each enumerator.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --sygus-active-gen: `") +
                          optarg + "'.  Try --sygus-active-gen=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, SygusFilterSolMode mode)
{
  os << "SygusFilterSolMode::";
  switch(mode) {
    case SygusFilterSolMode::NONE:
      os << "NONE";
      break;
    case SygusFilterSolMode::STRONG:
      os << "STRONG";
      break;
    case SygusFilterSolMode::WEAK:
      os << "WEAK";
      break;
    default:
        Unreachable();
  }
  return os;
}

SygusFilterSolMode
stringToSygusFilterSolMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return SygusFilterSolMode::NONE;
  }
  else if (optarg == "strong")
  {
    return SygusFilterSolMode::STRONG;
  }
  else if (optarg == "weak")
  {
    return SygusFilterSolMode::WEAK;
  }
  else if (optarg == "help")
  {
    puts("Modes for filtering sygus solutions.\n"
         "Available modes for --sygus-filter-sol are:\n"
         "+ none (default)\n"
         "  Do not filter sygus solutions.\n"
         "+ strong\n"
         "  Filter solutions that are logically stronger than others.\n"
         "+ weak\n"
         "  Filter solutions that are logically weaker than others.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --sygus-filter-sol: `") +
                          optarg + "'.  Try --sygus-filter-sol=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, SygusGrammarConsMode mode)
{
  os << "SygusGrammarConsMode::";
  switch(mode) {
    case SygusGrammarConsMode::SIMPLE:
      os << "SIMPLE";
      break;
    case SygusGrammarConsMode::ANY_CONST:
      os << "ANY_CONST";
      break;
    case SygusGrammarConsMode::ANY_TERM:
      os << "ANY_TERM";
      break;
    case SygusGrammarConsMode::ANY_TERM_CONCISE:
      os << "ANY_TERM_CONCISE";
      break;
    default:
        Unreachable();
  }
  return os;
}

SygusGrammarConsMode
stringToSygusGrammarConsMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "simple")
  {
    return SygusGrammarConsMode::SIMPLE;
  }
  else if (optarg == "any-const")
  {
    return SygusGrammarConsMode::ANY_CONST;
  }
  else if (optarg == "any-term")
  {
    return SygusGrammarConsMode::ANY_TERM;
  }
  else if (optarg == "any-term-concise")
  {
    return SygusGrammarConsMode::ANY_TERM_CONCISE;
  }
  else if (optarg == "help")
  {
    puts("Modes for default SyGuS grammars.\n"
         "Available modes for --sygus-grammar-cons are:\n"
         "+ simple (default)\n"
         "  Use simple grammar construction (no symbolic terms or constants).\n"
         "+ any-const\n"
         "  Use symoblic constant constructors.\n"
         "+ any-term\n"
         "  When applicable, use constructors corresponding to any symbolic term. This\n"
         "  option enables a sum-of-monomials grammar for arithmetic. For all other types,\n"
         "  it enables symbolic constant constructors.\n"
         "+ any-term-concise\n"
         "  When applicable, use constructors corresponding to any symbolic term, favoring\n"
         "  conciseness over generality. This option is equivalent to any-term but enables\n"
         "  a polynomial grammar for arithmetic when not in a combined theory.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --sygus-grammar-cons: `") +
                          optarg + "'.  Try --sygus-grammar-cons=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, SygusInvTemplMode mode)
{
  os << "SygusInvTemplMode::";
  switch(mode) {
    case SygusInvTemplMode::NONE:
      os << "NONE";
      break;
    case SygusInvTemplMode::PRE:
      os << "PRE";
      break;
    case SygusInvTemplMode::POST:
      os << "POST";
      break;
    default:
        Unreachable();
  }
  return os;
}

SygusInvTemplMode
stringToSygusInvTemplMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return SygusInvTemplMode::NONE;
  }
  else if (optarg == "pre")
  {
    return SygusInvTemplMode::PRE;
  }
  else if (optarg == "post")
  {
    return SygusInvTemplMode::POST;
  }
  else if (optarg == "help")
  {
    puts("Template modes for sygus invariant synthesis.\n"
         "Available modes for --sygus-inv-templ are:\n"
         "+ none\n"
         "  Synthesize invariant directly.\n"
         "+ pre\n"
         "  Synthesize invariant based on weakening of precondition.\n"
         "+ post (default)\n"
         "  Synthesize invariant based on strengthening of postcondition.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --sygus-inv-templ: `") +
                          optarg + "'.  Try --sygus-inv-templ=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, SygusQueryDumpFilesMode mode)
{
  os << "SygusQueryDumpFilesMode::";
  switch(mode) {
    case SygusQueryDumpFilesMode::NONE:
      os << "NONE";
      break;
    case SygusQueryDumpFilesMode::ALL:
      os << "ALL";
      break;
    case SygusQueryDumpFilesMode::UNSOLVED:
      os << "UNSOLVED";
      break;
    default:
        Unreachable();
  }
  return os;
}

SygusQueryDumpFilesMode
stringToSygusQueryDumpFilesMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return SygusQueryDumpFilesMode::NONE;
  }
  else if (optarg == "all")
  {
    return SygusQueryDumpFilesMode::ALL;
  }
  else if (optarg == "unsolved")
  {
    return SygusQueryDumpFilesMode::UNSOLVED;
  }
  else if (optarg == "help")
  {
    puts("Query file options.\n"
         "Available modes for --sygus-query-gen-dump-files are:\n"
         "+ none (default)\n"
         "  Do not dump query files when using --sygus-query-gen.\n"
         "+ all\n"
         "  Dump all query files.\n"
         "+ unsolved\n"
         "  Dump query files that the subsolver did not solve.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --sygus-query-gen-dump-files: `") +
                          optarg + "'.  Try --sygus-query-gen-dump-files=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, CegqiSingleInvRconsMode mode)
{
  os << "CegqiSingleInvRconsMode::";
  switch(mode) {
    case CegqiSingleInvRconsMode::NONE:
      os << "NONE";
      break;
    case CegqiSingleInvRconsMode::TRY:
      os << "TRY";
      break;
    case CegqiSingleInvRconsMode::ALL_LIMIT:
      os << "ALL_LIMIT";
      break;
    case CegqiSingleInvRconsMode::ALL:
      os << "ALL";
      break;
    default:
        Unreachable();
  }
  return os;
}

CegqiSingleInvRconsMode
stringToCegqiSingleInvRconsMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return CegqiSingleInvRconsMode::NONE;
  }
  else if (optarg == "try")
  {
    return CegqiSingleInvRconsMode::TRY;
  }
  else if (optarg == "all-limit")
  {
    return CegqiSingleInvRconsMode::ALL_LIMIT;
  }
  else if (optarg == "all")
  {
    return CegqiSingleInvRconsMode::ALL;
  }
  else if (optarg == "help")
  {
    puts("Modes for reconstruction solutions while using single invocation techniques.\n"
         "Available modes for --sygus-si-rcons are:\n"
         "+ none\n"
         "  Do not try to reconstruct solutions in the original (user-provided) grammar\n"
         "  when using single invocation techniques. In this mode, solutions produced by\n"
         "  CVC4 may violate grammar restrictions.\n"
         "+ try\n"
         "  Try to reconstruct solutions in the original grammar when using single\n"
         "  invocation techniques in an incomplete (fail-fast) manner.\n"
         "+ all-limit (default)\n"
         "  Try to reconstruct solutions in the original grammar, but termintate if a\n"
         "  maximum number of rounds for reconstruction is exceeded.\n"
         "+ all\n"
         "  Try to reconstruct solutions in the original grammar. In this mode, we do not\n"
         "  terminate until a solution is successfully reconstructed.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --sygus-si-rcons: `") +
                          optarg + "'.  Try --sygus-si-rcons=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, CegqiSingleInvMode mode)
{
  os << "CegqiSingleInvMode::";
  switch(mode) {
    case CegqiSingleInvMode::NONE:
      os << "NONE";
      break;
    case CegqiSingleInvMode::USE:
      os << "USE";
      break;
    case CegqiSingleInvMode::ALL:
      os << "ALL";
      break;
    default:
        Unreachable();
  }
  return os;
}

CegqiSingleInvMode
stringToCegqiSingleInvMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return CegqiSingleInvMode::NONE;
  }
  else if (optarg == "use")
  {
    return CegqiSingleInvMode::USE;
  }
  else if (optarg == "all")
  {
    return CegqiSingleInvMode::ALL;
  }
  else if (optarg == "help")
  {
    puts("Modes for single invocation techniques.\n"
         "Available modes for --sygus-si are:\n"
         "+ none (default)\n"
         "  Do not use single invocation techniques.\n"
         "+ use\n"
         "  Use single invocation techniques only if grammar is not restrictive.\n"
         "+ all\n"
         "  Always use single invocation techniques.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --sygus-si: `") +
                          optarg + "'.  Try --sygus-si=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, SygusUnifPiMode mode)
{
  os << "SygusUnifPiMode::";
  switch(mode) {
    case SygusUnifPiMode::NONE:
      os << "NONE";
      break;
    case SygusUnifPiMode::COMPLETE:
      os << "COMPLETE";
      break;
    case SygusUnifPiMode::CENUM:
      os << "CENUM";
      break;
    case SygusUnifPiMode::CENUM_IGAIN:
      os << "CENUM_IGAIN";
      break;
    default:
        Unreachable();
  }
  return os;
}

SygusUnifPiMode
stringToSygusUnifPiMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return SygusUnifPiMode::NONE;
  }
  else if (optarg == "complete")
  {
    return SygusUnifPiMode::COMPLETE;
  }
  else if (optarg == "cond-enum")
  {
    return SygusUnifPiMode::CENUM;
  }
  else if (optarg == "cond-enum-igain")
  {
    return SygusUnifPiMode::CENUM_IGAIN;
  }
  else if (optarg == "help")
  {
    puts("Modes for piecewise-independent unification.\n"
         "Available modes for --sygus-unif-pi are:\n"
         "+ none (default)\n"
         "  Do not use piecewise-independent unification.\n"
         "+ complete\n"
         "  Use complete approach for piecewise-independent unification (see Section 3 of\n"
         "  Barbosa et al FMCAD 2019)\n"
         "+ cond-enum\n"
         "  Use unconstrained condition enumeration for piecewise-independent unification\n"
         "  (see Section 4 of Barbosa et al FMCAD 2019).\n"
         "+ cond-enum-igain\n"
         "  Same as cond-enum, but additionally uses an information gain heuristic when\n"
         "  doing decision tree learning.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --sygus-unif-pi: `") +
                          optarg + "'.  Try --sygus-unif-pi=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, TermDbMode mode)
{
  os << "TermDbMode::";
  switch(mode) {
    case TermDbMode::ALL:
      os << "ALL";
      break;
    case TermDbMode::RELEVANT:
      os << "RELEVANT";
      break;
    default:
        Unreachable();
  }
  return os;
}

TermDbMode
stringToTermDbMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "all")
  {
    return TermDbMode::ALL;
  }
  else if (optarg == "relevant")
  {
    return TermDbMode::RELEVANT;
  }
  else if (optarg == "help")
  {
    puts("Modes for terms included in the quantifiers term database.\n"
         "Available modes for --term-db-mode are:\n"
         "+ all (default)\n"
         "  Quantifiers module considers all ground terms.\n"
         "+ relevant\n"
         "  Quantifiers module considers only ground terms connected to current\n"
         "  assertions.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --term-db-mode: `") +
                          optarg + "'.  Try --term-db-mode=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, TriggerActiveSelMode mode)
{
  os << "TriggerActiveSelMode::";
  switch(mode) {
    case TriggerActiveSelMode::ALL:
      os << "ALL";
      break;
    case TriggerActiveSelMode::MIN:
      os << "MIN";
      break;
    case TriggerActiveSelMode::MAX:
      os << "MAX";
      break;
    default:
        Unreachable();
  }
  return os;
}

TriggerActiveSelMode
stringToTriggerActiveSelMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "all")
  {
    return TriggerActiveSelMode::ALL;
  }
  else if (optarg == "min")
  {
    return TriggerActiveSelMode::MIN;
  }
  else if (optarg == "max")
  {
    return TriggerActiveSelMode::MAX;
  }
  else if (optarg == "help")
  {
    puts("Trigger active selection modes.\n"
         "Available modes for --trigger-active-sel are:\n"
         "+ all (default)\n"
         "  Make all triggers active.\n"
         "+ min\n"
         "  Activate triggers with minimal ground terms.\n"
         "+ max\n"
         "  Activate triggers with maximal ground terms.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --trigger-active-sel: `") +
                          optarg + "'.  Try --trigger-active-sel=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, TriggerSelMode mode)
{
  os << "TriggerSelMode::";
  switch(mode) {
    case TriggerSelMode::MIN:
      os << "MIN";
      break;
    case TriggerSelMode::MAX:
      os << "MAX";
      break;
    case TriggerSelMode::MIN_SINGLE_MAX:
      os << "MIN_SINGLE_MAX";
      break;
    case TriggerSelMode::MIN_SINGLE_ALL:
      os << "MIN_SINGLE_ALL";
      break;
    case TriggerSelMode::ALL:
      os << "ALL";
      break;
    default:
        Unreachable();
  }
  return os;
}

TriggerSelMode
stringToTriggerSelMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "min")
  {
    return TriggerSelMode::MIN;
  }
  else if (optarg == "max")
  {
    return TriggerSelMode::MAX;
  }
  else if (optarg == "min-s-max")
  {
    return TriggerSelMode::MIN_SINGLE_MAX;
  }
  else if (optarg == "min-s-all")
  {
    return TriggerSelMode::MIN_SINGLE_ALL;
  }
  else if (optarg == "all")
  {
    return TriggerSelMode::ALL;
  }
  else if (optarg == "help")
  {
    puts("Trigger selection modes.\n"
         "Available modes for --trigger-sel are:\n"
         "+ min (default)\n"
         "  Consider only minimal subterms that meet criteria for triggers.\n"
         "+ max\n"
         "  Consider only maximal subterms that meet criteria for triggers.\n"
         "+ min-s-max\n"
         "  Consider only minimal subterms that meet criteria for single triggers, maximal\n"
         "  otherwise.\n"
         "+ min-s-all\n"
         "  Consider only minimal subterms that meet criteria for single triggers, all\n"
         "  otherwise.\n"
         "+ all\n"
         "  Consider all subterms that meet criteria for triggers.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --trigger-sel: `") +
                          optarg + "'.  Try --trigger-sel=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, UserPatMode mode)
{
  os << "UserPatMode::";
  switch(mode) {
    case UserPatMode::USE:
      os << "USE";
      break;
    case UserPatMode::TRUST:
      os << "TRUST";
      break;
    case UserPatMode::RESORT:
      os << "RESORT";
      break;
    case UserPatMode::IGNORE:
      os << "IGNORE";
      break;
    case UserPatMode::INTERLEAVE:
      os << "INTERLEAVE";
      break;
    default:
        Unreachable();
  }
  return os;
}

UserPatMode
stringToUserPatMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "use")
  {
    return UserPatMode::USE;
  }
  else if (optarg == "trust")
  {
    return UserPatMode::TRUST;
  }
  else if (optarg == "resort")
  {
    return UserPatMode::RESORT;
  }
  else if (optarg == "ignore")
  {
    return UserPatMode::IGNORE;
  }
  else if (optarg == "interleave")
  {
    return UserPatMode::INTERLEAVE;
  }
  else if (optarg == "help")
  {
    puts("These modes determine how user provided patterns (triggers) are used during\n"
         "E-matching. The modes vary on when instantiation based on user-provided\n"
         "triggers is combined with instantiation based on automatically selected\n"
         "triggers.\n"
         "Available modes for --user-pat are:\n"
         "+ use\n"
         "  Use both user-provided and auto-generated patterns when patterns are provided\n"
         "  for a quantified formula.\n"
         "+ trust (default)\n"
         "  When provided, use only user-provided patterns for a quantified formula.\n"
         "+ resort\n"
         "  Use user-provided patterns only after auto-generated patterns saturate.\n"
         "+ ignore\n"
         "  Ignore user-provided patterns.\n"
         "+ interleave\n"
         "  Alternate between use/resort.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --user-pat: `") +
                          optarg + "'.  Try --user-pat=help.");
  }
}


}  // namespace options
}  // namespace CVC4
