/* image_button.c generated by valac 0.56.17, the Vala compiler
 * generated from image_button.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_CLICK_EVENT_BOX (widgets_click_event_box_get_type ())
#define WIDGETS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBox))
#define WIDGETS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))
#define WIDGETS_IS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_IS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_CLICK_EVENT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))

typedef struct _WidgetsClickEventBox WidgetsClickEventBox;
typedef struct _WidgetsClickEventBoxClass WidgetsClickEventBoxClass;
typedef struct _WidgetsClickEventBoxPrivate WidgetsClickEventBoxPrivate;

#define WIDGETS_TYPE_IMAGE_BUTTON (widgets_image_button_get_type ())
#define WIDGETS_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButton))
#define WIDGETS_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButtonClass))
#define WIDGETS_IS_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_IMAGE_BUTTON))
#define WIDGETS_IS_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_IMAGE_BUTTON))
#define WIDGETS_IMAGE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButtonClass))

typedef struct _WidgetsImageButton WidgetsImageButton;
typedef struct _WidgetsImageButtonClass WidgetsImageButtonClass;
typedef struct _WidgetsImageButtonPrivate WidgetsImageButtonPrivate;
enum  {
	WIDGETS_IMAGE_BUTTON_0_PROPERTY,
	WIDGETS_IMAGE_BUTTON_NUM_PROPERTIES
};
static GParamSpec* widgets_image_button_properties[WIDGETS_IMAGE_BUTTON_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define WIDGETS_TYPE_DIALOG (widgets_dialog_get_type ())
#define WIDGETS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialog))
#define WIDGETS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))
#define WIDGETS_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_DIALOG))
#define WIDGETS_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_DIALOG))
#define WIDGETS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))

typedef struct _WidgetsDialog WidgetsDialog;
typedef struct _WidgetsDialogClass WidgetsDialogClass;
typedef struct _WidgetsDialogPrivate WidgetsDialogPrivate;

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _WidgetsClickEventBox {
	GtkEventBox parent_instance;
	WidgetsClickEventBoxPrivate * priv;
	gboolean is_press;
};

struct _WidgetsClickEventBoxClass {
	GtkEventBoxClass parent_class;
};

struct _WidgetsImageButton {
	WidgetsClickEventBox parent_instance;
	WidgetsImageButtonPrivate * priv;
	gboolean is_hover;
	cairo_surface_t* hover_dark_surface;
	cairo_surface_t* hover_light_surface;
	cairo_surface_t* normal_dark_surface;
	cairo_surface_t* normal_light_surface;
	cairo_surface_t* press_dark_surface;
	cairo_surface_t* press_light_surface;
	GdkRGBA text_hover_color;
	GdkRGBA text_normal_color;
	GdkRGBA text_press_color;
	gboolean is_theme_button;
	gint button_text_size;
	gchar* button_text;
};

struct _WidgetsImageButtonClass {
	WidgetsClickEventBoxClass parent_class;
};

struct _WidgetsDialog {
	GtkWindow parent_instance;
	WidgetsDialogPrivate * priv;
	GdkScreen* screen_monitor;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsConfigWindow* transient_window;
	gint option_widget_margin_end;
	gint option_widget_margin_top;
	gint window_frame_margin_bottom;
	gint window_frame_margin_end;
	gint window_frame_margin_start;
	gint window_frame_margin_top;
	gint window_frame_radius;
	gint window_init_height;
	gint window_init_width;
};

struct _WidgetsDialogClass {
	GtkWindowClass parent_class;
	void (*draw_window_above) (WidgetsDialog* self, cairo_t* cr);
};

static gpointer widgets_image_button_parent_class = NULL;

VALA_EXTERN GType widgets_click_event_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsClickEventBox, g_object_unref)
VALA_EXTERN GType widgets_image_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsImageButton, g_object_unref)
VALA_EXTERN WidgetsImageButton* widgets_image_button_new (const gchar* image_path,
                                              gboolean theme_button,
                                              const gchar* text,
                                              gint text_size);
VALA_EXTERN WidgetsImageButton* widgets_image_button_construct (GType object_type,
                                                    const gchar* image_path,
                                                    gboolean theme_button,
                                                    const gchar* text,
                                                    gint text_size);
VALA_EXTERN WidgetsClickEventBox* widgets_click_event_box_new (void);
VALA_EXTERN WidgetsClickEventBox* widgets_click_event_box_construct (GType object_type);
VALA_EXTERN cairo_surface_t* utils_create_image_surface (const gchar* surface_path);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
static gboolean widgets_image_button_on_draw (WidgetsImageButton* self,
                                       GtkWidget* widget,
                                       cairo_t* cr);
static gboolean _widgets_image_button_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                        cairo_t* cr,
                                                        gpointer self);
static gboolean __lambda21_ (WidgetsImageButton* self,
                      GtkWidget* w,
                      GdkEventCrossing* e);
static gboolean ___lambda21__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda22_ (WidgetsImageButton* self,
                      GtkWidget* w,
                      GdkEventCrossing* e);
static gboolean ___lambda22__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda23_ (WidgetsImageButton* self,
                      GtkWidget* w,
                      GdkEventButton* e);
static gboolean ___lambda23__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean __lambda24_ (WidgetsImageButton* self,
                      GtkWidget* w,
                      GdkEventButton* e);
static gboolean ___lambda24__gtk_widget_button_release_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
VALA_EXTERN GType widgets_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsDialog, g_object_unref)
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
VALA_EXTERN void draw_draw_surface (cairo_t* cr,
                        cairo_surface_t* surface,
                        gint x,
                        gint y,
                        gint width,
                        gint height);
VALA_EXTERN void utils_set_context_color (cairo_t* cr,
                              GdkRGBA* color);
VALA_EXTERN void draw_draw_text (cairo_t* cr,
                     const gchar* text,
                     gint x,
                     gint y,
                     gint width,
                     gint height,
                     gint size,
                     PangoAlignment horizontal_alignment,
                     const gchar* vertical_align,
                     gint* wrap_width);
static void widgets_image_button_finalize (GObject * obj);
static GType widgets_image_button_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
_widgets_image_button_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                               cairo_t* cr,
                                               gpointer self)
{
	gboolean result;
	result = widgets_image_button_on_draw ((WidgetsImageButton*) self, _sender, cr);
	return result;
}

static gboolean
__lambda21_ (WidgetsImageButton* self,
             GtkWidget* w,
             GdkEventCrossing* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	self->is_hover = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda21__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda21_ ((WidgetsImageButton*) self, _sender, event);
	return result;
}

static gboolean
__lambda22_ (WidgetsImageButton* self,
             GtkWidget* w,
             GdkEventCrossing* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	self->is_hover = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda22__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda22_ ((WidgetsImageButton*) self, _sender, event);
	return result;
}

static gboolean
__lambda23_ (WidgetsImageButton* self,
             GtkWidget* w,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda23__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda23_ ((WidgetsImageButton*) self, _sender, event);
	return result;
}

static gboolean
__lambda24_ (WidgetsImageButton* self,
             GtkWidget* w,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	self->is_hover = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda24__gtk_widget_button_release_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda24_ ((WidgetsImageButton*) self, _sender, event);
	return result;
}

WidgetsImageButton*
widgets_image_button_construct (GType object_type,
                                const gchar* image_path,
                                gboolean theme_button,
                                const gchar* text,
                                gint text_size)
{
	WidgetsImageButton * self = NULL;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	cairo_surface_t* _tmp32_;
	cairo_surface_t* _tmp33_;
	g_return_val_if_fail (image_path != NULL, NULL);
	self = (WidgetsImageButton*) widgets_click_event_box_construct (object_type);
	self->is_theme_button = theme_button;
	if (self->is_theme_button) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		cairo_surface_t* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		cairo_surface_t* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		cairo_surface_t* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		cairo_surface_t* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		cairo_surface_t* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		cairo_surface_t* _tmp17_;
		_tmp0_ = g_strconcat (image_path, "_dark_normal.svg", NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = utils_create_image_surface (_tmp1_);
		_cairo_surface_destroy0 (self->normal_dark_surface);
		self->normal_dark_surface = _tmp2_;
		_g_free0 (_tmp1_);
		_tmp3_ = g_strconcat (image_path, "_dark_hover.svg", NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = utils_create_image_surface (_tmp4_);
		_cairo_surface_destroy0 (self->hover_dark_surface);
		self->hover_dark_surface = _tmp5_;
		_g_free0 (_tmp4_);
		_tmp6_ = g_strconcat (image_path, "_dark_press.svg", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = utils_create_image_surface (_tmp7_);
		_cairo_surface_destroy0 (self->press_dark_surface);
		self->press_dark_surface = _tmp8_;
		_g_free0 (_tmp7_);
		_tmp9_ = g_strconcat (image_path, "_light_normal.svg", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = utils_create_image_surface (_tmp10_);
		_cairo_surface_destroy0 (self->normal_light_surface);
		self->normal_light_surface = _tmp11_;
		_g_free0 (_tmp10_);
		_tmp12_ = g_strconcat (image_path, "_light_hover.svg", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = utils_create_image_surface (_tmp13_);
		_cairo_surface_destroy0 (self->hover_light_surface);
		self->hover_light_surface = _tmp14_;
		_g_free0 (_tmp13_);
		_tmp15_ = g_strconcat (image_path, "_light_press.svg", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = utils_create_image_surface (_tmp16_);
		_cairo_surface_destroy0 (self->press_light_surface);
		self->press_light_surface = _tmp17_;
		_g_free0 (_tmp16_);
	} else {
		gchar* _tmp18_;
		gchar* _tmp19_;
		cairo_surface_t* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		cairo_surface_t* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		cairo_surface_t* _tmp26_;
		_tmp18_ = g_strconcat (image_path, "_normal.svg", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = utils_create_image_surface (_tmp19_);
		_cairo_surface_destroy0 (self->normal_dark_surface);
		self->normal_dark_surface = _tmp20_;
		_g_free0 (_tmp19_);
		_tmp21_ = g_strconcat (image_path, "_hover.svg", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = utils_create_image_surface (_tmp22_);
		_cairo_surface_destroy0 (self->hover_dark_surface);
		self->hover_dark_surface = _tmp23_;
		_g_free0 (_tmp22_);
		_tmp24_ = g_strconcat (image_path, "_press.svg", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = utils_create_image_surface (_tmp25_);
		_cairo_surface_destroy0 (self->press_dark_surface);
		self->press_dark_surface = _tmp26_;
		_g_free0 (_tmp25_);
	}
	_tmp27_ = g_strdup (text);
	_g_free0 (self->button_text);
	self->button_text = _tmp27_;
	self->button_text_size = text_size;
	_tmp28_ = self->button_text;
	if (_tmp28_ != NULL) {
		GdkRGBA _tmp29_ = {0};
		GdkRGBA _tmp30_ = {0};
		GdkRGBA _tmp31_ = {0};
		utils_hex_to_rgba ("#0699FF", 1.0, &_tmp29_);
		self->text_normal_color = _tmp29_;
		utils_hex_to_rgba ("#FFFFFF", 1.0, &_tmp30_);
		self->text_hover_color = _tmp30_;
		utils_hex_to_rgba ("#FFFFFF", 1.0, &_tmp31_);
		self->text_press_color = _tmp31_;
	}
	_tmp32_ = self->normal_dark_surface;
	_tmp33_ = self->normal_dark_surface;
	gtk_widget_set_size_request ((GtkWidget*) self, cairo_image_surface_get_width (_tmp32_) / gtk_widget_get_scale_factor ((GtkWidget*) self), cairo_image_surface_get_height (_tmp33_) / gtk_widget_get_scale_factor ((GtkWidget*) self));
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_image_button_on_draw_gtk_widget_draw, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) ___lambda21__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) ___lambda22__gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda23__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) ___lambda24__gtk_widget_button_release_event, self, 0);
	return self;
}

WidgetsImageButton*
widgets_image_button_new (const gchar* image_path,
                          gboolean theme_button,
                          const gchar* text,
                          gint text_size)
{
	return widgets_image_button_construct (WIDGETS_TYPE_IMAGE_BUTTON, image_path, theme_button, text, text_size);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
widgets_image_button_on_draw (WidgetsImageButton* self,
                              GtkWidget* widget,
                              cairo_t* cr)
{
	gboolean is_light_theme = FALSE;
	GtkWidget* top_level = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	gint ratio = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	is_light_theme = FALSE;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	top_level = _tmp1_;
	_tmp2_ = top_level;
	if (g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) _tmp2_), WIDGETS_TYPE_DIALOG)) {
		GtkWidget* _tmp3_;
		WidgetsConfigWindow* _tmp4_;
		_tmp3_ = top_level;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, WIDGETS_TYPE_DIALOG, WidgetsDialog)->transient_window;
		is_light_theme = widgets_config_window_is_light_theme (_tmp4_);
	} else {
		GtkWidget* _tmp5_;
		_tmp5_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		is_light_theme = widgets_config_window_is_light_theme (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	}
	ratio = gtk_widget_get_scale_factor ((GtkWidget*) self);
	if (self->is_hover) {
		if (((WidgetsClickEventBox*) self)->is_press) {
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp9_;
			if (self->is_theme_button) {
				_tmp6_ = is_light_theme;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				cairo_surface_t* _tmp7_;
				_tmp7_ = self->press_light_surface;
				draw_draw_surface (cr, _tmp7_, 0, 0, 0, 0);
			} else {
				cairo_surface_t* _tmp8_;
				_tmp8_ = self->press_dark_surface;
				draw_draw_surface (cr, _tmp8_, 0, 0, 0, 0);
			}
			_tmp9_ = self->button_text;
			if (_tmp9_ != NULL) {
				GdkRGBA _tmp10_;
				const gchar* _tmp11_;
				cairo_surface_t* _tmp12_;
				cairo_surface_t* _tmp13_;
				_tmp10_ = self->text_press_color;
				utils_set_context_color (cr, &_tmp10_);
				_tmp11_ = self->button_text;
				_tmp12_ = self->normal_dark_surface;
				_tmp13_ = self->normal_dark_surface;
				draw_draw_text (cr, _tmp11_, 0, 0, cairo_image_surface_get_width (_tmp12_) / ratio, cairo_image_surface_get_height (_tmp13_) / ratio, self->button_text_size, PANGO_ALIGN_CENTER, "middle", NULL);
			}
		} else {
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp17_;
			if (self->is_theme_button) {
				_tmp14_ = is_light_theme;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				cairo_surface_t* _tmp15_;
				_tmp15_ = self->hover_light_surface;
				draw_draw_surface (cr, _tmp15_, 0, 0, 0, 0);
			} else {
				cairo_surface_t* _tmp16_;
				_tmp16_ = self->hover_dark_surface;
				draw_draw_surface (cr, _tmp16_, 0, 0, 0, 0);
			}
			_tmp17_ = self->button_text;
			if (_tmp17_ != NULL) {
				GdkRGBA _tmp18_;
				const gchar* _tmp19_;
				cairo_surface_t* _tmp20_;
				cairo_surface_t* _tmp21_;
				_tmp18_ = self->text_hover_color;
				utils_set_context_color (cr, &_tmp18_);
				_tmp19_ = self->button_text;
				_tmp20_ = self->normal_dark_surface;
				_tmp21_ = self->normal_dark_surface;
				draw_draw_text (cr, _tmp19_, 0, 0, cairo_image_surface_get_width (_tmp20_) / ratio, cairo_image_surface_get_height (_tmp21_) / ratio, self->button_text_size, PANGO_ALIGN_CENTER, "middle", NULL);
			}
		}
	} else {
		gboolean _tmp22_ = FALSE;
		const gchar* _tmp25_;
		if (self->is_theme_button) {
			_tmp22_ = is_light_theme;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			cairo_surface_t* _tmp23_;
			_tmp23_ = self->normal_light_surface;
			draw_draw_surface (cr, _tmp23_, 0, 0, 0, 0);
		} else {
			cairo_surface_t* _tmp24_;
			_tmp24_ = self->normal_dark_surface;
			draw_draw_surface (cr, _tmp24_, 0, 0, 0, 0);
		}
		_tmp25_ = self->button_text;
		if (_tmp25_ != NULL) {
			GdkRGBA _tmp26_;
			const gchar* _tmp27_;
			cairo_surface_t* _tmp28_;
			cairo_surface_t* _tmp29_;
			_tmp26_ = self->text_normal_color;
			utils_set_context_color (cr, &_tmp26_);
			_tmp27_ = self->button_text;
			_tmp28_ = self->normal_dark_surface;
			_tmp29_ = self->normal_dark_surface;
			draw_draw_text (cr, _tmp27_, 0, 0, cairo_image_surface_get_width (_tmp28_) / ratio, cairo_image_surface_get_height (_tmp29_) / ratio, self->button_text_size, PANGO_ALIGN_CENTER, "middle", NULL);
		}
	}
	result = TRUE;
	_g_object_unref0 (top_level);
	return result;
}

static void
widgets_image_button_class_init (WidgetsImageButtonClass * klass,
                                 gpointer klass_data)
{
	widgets_image_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_image_button_finalize;
}

static void
widgets_image_button_instance_init (WidgetsImageButton * self,
                                    gpointer klass)
{
	self->is_hover = FALSE;
	self->button_text_size = 14;
}

static void
widgets_image_button_finalize (GObject * obj)
{
	WidgetsImageButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButton);
	_cairo_surface_destroy0 (self->hover_dark_surface);
	_cairo_surface_destroy0 (self->hover_light_surface);
	_cairo_surface_destroy0 (self->normal_dark_surface);
	_cairo_surface_destroy0 (self->normal_light_surface);
	_cairo_surface_destroy0 (self->press_dark_surface);
	_cairo_surface_destroy0 (self->press_light_surface);
	_g_free0 (self->button_text);
	G_OBJECT_CLASS (widgets_image_button_parent_class)->finalize (obj);
}

static GType
widgets_image_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsImageButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_image_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsImageButton), 0, (GInstanceInitFunc) widgets_image_button_instance_init, NULL };
	GType widgets_image_button_type_id;
	widgets_image_button_type_id = g_type_register_static (WIDGETS_TYPE_CLICK_EVENT_BOX, "WidgetsImageButton", &g_define_type_info, 0);
	return widgets_image_button_type_id;
}

GType
widgets_image_button_get_type (void)
{
	static volatile gsize widgets_image_button_type_id__once = 0;
	if (g_once_init_enter (&widgets_image_button_type_id__once)) {
		GType widgets_image_button_type_id;
		widgets_image_button_type_id = widgets_image_button_get_type_once ();
		g_once_init_leave (&widgets_image_button_type_id__once, widgets_image_button_type_id);
	}
	return widgets_image_button_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

